/*******************************************************
 * HELPER FUNCTIONS TO PROCESS THE LOGIC OF THE MODULE *
 *******************************************************/

class betterRoofsHelpers {
    /******************************************
     * MASK THE FOG WITH THE SPRITE OF A TILE *
     ******************************************/

    showTileThroughFog(tile) {
        const oldSprite = _betterRoofs.fogRoofContainer.children.find((c) => c.name == tile.id);
        let tileImg = tile.mesh;
        if (!tileImg || oldSprite || !tileImg.texture.baseTexture) return;
        let sprite = SpriteMesh.from(tileImg.texture, undefined, WhiteAsFuckShader);
        sprite.alpha = 1;
        sprite.width = tile.document.width;
        sprite.height = tile.document.height;
        sprite.position.set(tile.center.x, tile.center.y);
        sprite.angle = tileImg.angle;
        sprite.name = tile.id;
        sprite.anchor.set(0.5, 0.5);
        sprite.scale.x = (tile.mesh.width / tile.mesh.texture.width) * tile.document.texture.scaleX;
        sprite.scale.y = (tile.mesh.height / tile.mesh.texture.height) * tile.document.texture.scaleY;
        _betterRoofs.fogRoofContainer.spriteIndex[tile.id] = sprite;
        _betterRoofs.fogRoofContainer.addChild(sprite);
    }

    /**********************************************************
     * REMOVE THE MASK SPRITE GENERATED BY SHOWTILETHROUGHFOG *
     **********************************************************/
    hideTileThroughFog(tile) {
        let sprite = _betterRoofs.fogRoofContainer.children.find((c) => c.name == tile.id);
        if (sprite) _betterRoofs.fogRoofContainer.removeChild(sprite);
    }

    /**************************************************************
     * DECIDE IF A TILE SHOULD BE SHOWN OR HIDDEN THROUGH THE FOG *
     **************************************************************/

    computeShowHideTile(tile, overrideHide, controlledToken, brMode) {
        const pointSource = canvas.scene.environment.globalLight.enabled ? controlledToken.vision?.los?.points : controlledToken.vision?.fov?.points;

        if (controlledToken && !tile.occluded && tile.visible && (controlledToken.losHeight ?? controlledToken.document.elevation) < tile.document.elevation && this.checkIfInPoly(pointSource, tile, controlledToken, 5)) {
            this.showTileThroughFog(tile);
        } else {
            this.hideTileThroughFog(tile);
        }
    }

    makeCircle(fov) {
        const center = { x: fov.x, y: fov.y };
        const radius = fov.radius;
        let points = [];
        let angle = 0;
        for (let i = 0; i < 360; i += 4) {
            let x = center.x + radius * Math.cos(angle);
            let y = center.y + radius * Math.sin(angle);
            points.push(x, y);
            angle += 0.1;
        }
        return points;
    }

    //given a center and an array of points, if a point is farther than the radius bring it closer to the center
    bringLosCloser(fov, los) {
        if (!fov || !los) return [];
        const center = { x: fov.x, y: fov.y };
        const points = los.points;
        const radius = fov.radius;
        let newPoints = [];
        for (let i = 0; i < points.length; i += 2) {
            let x = points[i];
            let y = points[i + 1];
            let distance = Math.sqrt(Math.pow(x - center.x, 2) + Math.pow(y - center.y, 2));
            if (distance > radius) {
                let newX = center.x + ((x - center.x) * radius) / distance;
                let newY = center.y + ((y - center.y) * radius) / distance;
                newPoints.push(newX, newY);
            } else {
                newPoints.push(x, y);
            }
        }
        return newPoints;
    }

    /*************************************************************************************
     * CHECK IF ANY POINT IN AN ARRAY OF POINTS IS CONTAINED INSIDE THE BUILDING POLYGON *
     *************************************************************************************/

    checkIfInPoly(points, tile, token, diff) {
        if (!points?.length) return false;
        points.push(points[0], points[1]);
        for (let i = 0; i < points.length; i += 2) {
            if (points[i + 3]) {
                //&& (Math.pow(points[i]-points[i+2],2)+Math.pow(points[i+1]-points[i+3],2)) > 70000
                let midPoint = {
                    x: (points[i + 2] + points[i]) / 2,
                    y: (points[i + 3] + points[i + 1]) / 2,
                };
                let mpt = this.bringPointCloser({ x: midPoint.x, y: midPoint.y }, token.center, diff);
                if (tile.mesh?.containsCanvasPoint({x: mpt.x, y: mpt.y})) {
                    return true;
                }
            }
            let pt = this.bringPointCloser({ x: points[i], y: points[i + 1] }, token.center, diff);
            if (tile.mesh?.containsCanvasPoint({x: pt.x, y: pt.y})) {
                return true;
            }
        }
        return false;
    }

    /**********************************
     * GET NECESSARY DATA FROM A TILE *
     **********************************/

    getTileFlags(tile) {
        let overrideHide = false;
        let brMode = tile.document.getFlag("betterroofs", "brMode");
        return { brMode, overrideHide };
    }

    /***************************************************************************************
     * GIVEN A POINT AND A CENTER GET THE POINT CLOSER TO THE CENTER BY THE SPECIFIED DIFF *
     ***************************************************************************************/

    bringPointCloser(point, center, diff) {
        let slope = this.getSlope(point, center);
        let newL = this.getDist(point, center) + diff;
        let x = -newL * Math.cos(slope) + center.x;
        let y = -newL * Math.sin(slope) + center.y;
        return { x: x, y: y };
    }

    /***********************************************
     * GET THE SLOPE IN RADIANS BETWEEN TWO POINTS *
     ***********************************************/

    getSlope(pt1, pt2) {
        return Math.atan2(pt2.y - pt1.y, pt2.x - pt1.x);
    }

    /*************************************************
     * GET THE DISTANCE IN PIXELS BETWEEN TWO POINTS *
     *************************************************/

    getDist(pt1, pt2) {
        return Math.sqrt(Math.pow(pt1.x - pt2.x, 2) + Math.pow(pt1.y - pt2.y, 2));
    }

    /*******************************************
     * CREATE WALLS ON THE EDGES OF THE CANVAS *
     *******************************************/

    async buildEdgeWalls() {
        let padX = canvas.scene.dimensions.paddingX + 5;
        let padY = canvas.scene.dimensions.paddingY + 5;
        let width = canvas.scene.dimensions.width - 2 * padX - 5;
        let height = canvas.scene.dimensions.height - 2 * padY - 5;
        let wallsCoords = [
            [padX, padY, padX + width, padY],
            [padX + width, padY, padX + width, padY + height],
            [padX + width, padY + height, padX, padY + height],
            [padX, padY + height, padX, padY],
        ];
        let wallDataArray = [];
        for (let c of wallsCoords) {
            wallDataArray.push({
                c: c,
                move: 1,
                sense: 1,
                sound: 1,
                dir: 0,
                door: 0,
                ds: 0,
            });
        }
        await canvas.scene.createEmbeddedDocuments("Wall", wallDataArray);
    }
}

//funny name haha

class WhiteAsFuckShader extends BaseSamplerShader {
    static classPluginName = null;

    static fragmentShader = `
    precision ${PIXI.settings.PRECISION_FRAGMENT} float;
    uniform sampler2D sampler;
    uniform vec4 tintAlpha;
    varying vec2 vUvs;
  
    void main() {
      gl_FragColor = vec4(1.0) * (texture2D(sampler, vUvs).a * tintAlpha);
    }`;
}
