import{DiceSystem as t,DiceSFX as i}from"./api.js";class ShaderUtils{static applyDiceSoNiceShader(t){if(void 0!==this.emissive&&game.dice3d.DiceFactory.realisticLighting&&ShaderUtils.selectiveBloomShaderFragment(t),this.userData.iridescent&&ShaderUtils.iridescentShaderFragment(t),"MeshPhysicalMaterial"==t.shaderName&&t.iridescence&&ShaderUtils.iridescenceShaderFragment(t),Hooks.callAll("diceSoNiceShaderOnBeforeCompile",t,this),this.userData.system&&game.dice3d.DiceFactory.systems.has(this.userData.system)){game.dice3d.DiceFactory.systems.get(this.userData.system).beforeShaderCompile(t,this)}}static selectiveBloomShaderFragment(t){t.uniforms.globalBloom=game.dice3d.uniforms.globalBloom,t.fragmentShader=`\n\t\t\tuniform float globalBloom;\n\t\t\t${t.fragmentShader}\n\t\t`.replace("#include <dithering_fragment>","#include <dithering_fragment>\n\t\t\tif (globalBloom > 0.5) {\n\t\t\t\t#ifdef USE_EMISSIVEMAP\n\t\t\t\t\tgl_FragColor.rgb = emissiveColor.rgb * emissive * totalEmissiveRadiance;\n\t\t\t\t#else\n\t\t\t\t\tgl_FragColor.rgb = vec3(0.0);\n\t\t\t\t#endif\n\t\t\t}\n\t\t")}static iridescenceShaderFragment(t){t.fragmentShader=t.fragmentShader.replace("#include <lights_physical_fragment>","#include <lights_physical_fragment>\n\t\t\t\t#ifdef USE_IRIDESCENCE\n\t\t\t\t\tmaterial.iridescence = iridescence;\n\t\t\t\t\t#ifdef USE_IRIDESCENCEMAP\n\t\t\t\t\t\tmaterial.iridescence *= texture2D( iridescenceMap, vUv ).b;\n\t\t\t\t\t#endif\n\t\t\t\t#endif")}static iridescentShaderFragment(t){t.uniforms.iridescenceLookUp=game.dice3d.uniforms.iridescenceLookUp,t.uniforms.iridescenceNoise=game.dice3d.uniforms.iridescenceNoise,t.uniforms.boost=game.dice3d.uniforms.boost,t.vertexShader=`\n\t\t\tvarying vec3 viWorldPosition;\n\t\t\tvarying vec3 viWorldNormal;\n\t\t\t${t.vertexShader}\n\t\t`.replace("#include <fog_vertex>","#include <fog_vertex>\n\t\t\tviWorldPosition = worldPosition.xyz;\n\t\t\tviWorldNormal = mat3(modelMatrix) * normalize(normal);\n\t\t\t"),t.fragmentShader=`\n\t\t\tvarying vec3 viWorldPosition;\n\t\t\tvarying vec3 viWorldNormal;\n\t\t\t\n\t\t\tuniform sampler2D iridescenceLookUp;\n\t\t\tuniform sampler2D iridescenceNoise;\n\t\t\tuniform float boost;\n\t\t\t${t.fragmentShader}\n\t\t`.replace("#include <transmission_fragment>","vec3 viewWorldDir = normalize(viWorldPosition - cameraPosition);\n\t\t\tvec3 iNormal = normalize(viWorldNormal); \n\t\t\tfloat NdotV = max(-dot(viewWorldDir, iNormal), 0.0);\n\t\t\tfloat fresnelFactor = pow(1.0 - NdotV, 5.0);\n\t\t\tfloat noise = texture2D(iridescenceNoise, vUv/2.0).r;\n\t\t\tvec3 airy = texture2D(iridescenceLookUp, vec2(NdotV * .99, noise)).xyz;\n\t\t\t\n\t\t\tif(metalnessFactor >= 1.0) {\n\t\t\t\ttotalSpecular = totalSpecular  * airy * boost;\n\t\t\t}\n\n\t\t\t#include <transmission_fragment>")}}class AssetsLoader{static cache={};constructor(){}async load(t=[]){Array.isArray(t)||(t=[t]);const i=await Promise.all(t.map((t=>this.loadAsset(t)))),r={};return i.forEach((t=>{const i=Object.keys(t)[0];r[i]=t[i]})),r}async loadAsset(t){if(AssetsLoader.cache[t])return await AssetsLoader.cache[t];const i=(async()=>{if(t.endsWith(".json")){const i=await fetch(t);if(!i.ok)throw new Error(`Failed to load JSON asset: ${t}`);const r=await i.json(),a=await this.loadSpriteSheet(t,r);return{[t]:a}}{const i=await this.loadImage(t),r={source:i,frame:{x:0,y:0,w:i.width,h:i.height}};return{[t]:r}}})();AssetsLoader.cache[t]=i;const r=await i;return AssetsLoader.cache[t]=r,r}async loadSpriteSheet(t,i){const r=t.substring(0,t.lastIndexOf("/")+1),a=r+i.meta.image,o=await this.loadImage(a),l={};for(const[t,r]of Object.entries(i.frames))l[t]={source:o,frame:r.frame};return i.meta.related_multi_packs&&await Promise.all(i.meta.related_multi_packs.map((t=>this.loadAdditionalPack(r+t,l)))),l}async loadAdditionalPack(t,i){const r=await fetch(t);if(!r.ok)throw new Error(`Failed to load additional spritesheet: ${t}`);const a=await r.json(),o=await this.loadImage(t.substring(0,t.lastIndexOf("/")+1)+a.meta.image);for(const[t,r]of Object.entries(a.frames))i[t]={source:o,frame:r.frame}}async loadImage(t){return AssetsLoader.cache[t]?AssetsLoader.cache[t]:new Promise(((i,r)=>{const a=new Image;a.crossOrigin="Anonymous",a.onload=()=>{AssetsLoader.cache[t]=a,i(a)},a.onerror=()=>{r(new Error(`Failed to load image: ${t}`))},a.src=t}))}}class DicePreset{constructor(t,i=""){i=i||t,this.type=t,this.term="Die",this.shape=i||t,this.scale=1,this.labels=[],this.valueMap=null,this.values=[],this.bumps=[],this.emissiveMaps=[],this.emissive=0,this.emissiveIntensity=1,this.mass=300,this.inertia=13,this.geometry=null,this.model=null,this.system="standard",this._diceSystem=null,this.modelLoaded=!1,this.modelLoading=!1,this.modelFile=null,this.internalAdd=!1,this.atlas=null,this.appearance={labelColor:"#FFFFFF",diceColor:"#000000",outlineColor:"#000000",edgeColor:"#000000",texture:"none",material:"auto",font:"auto",colorset:"custom"}}set diceSystem(t){this._diceSystem=t}get diceSystem(){return this._diceSystem}get systemSettings(){return this.diceSystem.getSettingsByDiceType(this.type)}setValues(t=1,i=20,r=1){this.values=this.range(t,i,r),t<1&&this.setValueMap(t,i,r)}setValueMap(t,i,r){let a={},o=1;for(let l=t;l<=i;l+=r)a[l]=o,o++;this.valueMap=a}registerFaces(t){for(let i of["labels","bumps","emissiveMaps"])if(t[i]&&Object.keys(t[i]).length>0){let r=[];if(r.push(""),["d2","d10"].includes(this.shape)||r.push(""),"d4"==this.shape){const a=Object.values(t[i]);let o=a[0],l=a[1],c=a[2],h=a[3];r=[[[],[0,0,0],[l,h,c],[o,c,h],[l,o,h],[o,l,c]],[[],[0,0,0],[l,c,h],[c,o,h],[l,h,o],[c,l,o]],[[],[0,0,0],[h,c,l],[c,h,o],[h,l,o],[c,o,l]],[[],[0,0,0],[h,l,c],[o,h,c],[h,o,l],[o,c,l]]]}else Array.prototype.push.apply(r,Object.values(t[i]));switch(i){case"labels":this.labels=r;break;case"bumps":this.bumps=r;break;case"emissiveMaps":this.emissiveMaps=r}}}setLabels(t){this.labels=t,this.unloadModel()}setBumpMaps(t){this.bumps=t,this.unloadModel()}setEmissiveMaps(t){this.emissiveMaps=t,this.unloadModel()}setAtlas(t){this.atlas=t,this.unloadModel()}unloadModel(){this.modelLoaded=!1,this.modelLoading=!1}loadTextures(){return this.modelLoaded||!1!==this.modelLoading||(this.modelLoading=new Promise((async(t,i)=>{try{const i=new AssetsLoader;let r={};if(this.atlas){let t=await i.load(this.atlas);t=t[this.atlas],r.labels=await this.loadTextureType(this.labels,t,i),this.bumps&&(r.bumps=await this.loadTextureType(this.bumps,t,i)),this.emissiveMaps&&(r.emissiveMaps=await this.loadTextureType(this.emissiveMaps,t,i))}else r.labels=await this.loadTextureType(this.labels,{},i),this.bumps&&(r.bumps=await this.loadTextureType(this.bumps,{},i)),this.emissiveMaps&&(r.emissiveMaps=await this.loadTextureType(this.emissiveMaps,{},i));this.registerFaces(r),this.modelLoaded=!0,t()}catch(t){i(t)}}))),this.modelLoading}async loadTextureType(t,i,r){const a=[],o=/\.(png|jpg|jpeg|gif|webp)$/i;for(let l=0;l<t.length;l++){const c=t[l];if(c&&c.match(o))if(i[c])a[l]=i[c];else{const t=await r.load([c]);a[l]=t[c]}else a[l]=c}return a}range(t,i,r=1){for(var a=[t],o=t;o<i;)a.push(o+=r||1);return a}setModel(t){this.modelFile=t,this.modelLoaded=!1}loadModel(t=null){return this.modelLoaded||!1!==this.modelLoading||(this.modelLoading=new Promise(((i,r)=>{t.load(this.modelFile,(t=>{t.scene.traverse((function(t){if(t.isMesh){t.castShadow=!0,t.material.onBeforeCompile=ShaderUtils.applyDiceSoNiceShader;const i=game.dice3d.box.anisotropy;null!==t.material.map&&(t.material.map.anisotropy=i),null!==t.material.normalMap&&(t.material.normalMap.anisotropy=i),null!==t.material.emissiveMap&&(t.material.emissiveMap.anisotropy=i),null!==t.material.roughnessMap&&(t.material.roughnessMap.anisotropy=i),null!==t.material.metalnessMap&&(t.material.metalnessMap.anisotropy=i),t.layers.enableAll(),Hooks.callAll("diceSoNiceOnMaterialReady",t.material,null)}})),this.model=t,this.modelLoaded=!0,Hooks.callAll("diceSoNiceModelLoaded",this),i(t)}))}))),this.modelLoading}}const r=[],a=[];let o;o=new DicePreset("d2"),o.setLabels(["1","2"]),o.setValues(1,2),o.inertia=8,o.mass=400,o.scale=.9,r.push(o),o=new DicePreset("dc","d2"),o.term="Coin",o.setAtlas("modules/dice-so-nice/textures/standard.json"),o.setLabels(["tail.webp","heads.webp"]),o.setBumpMaps(["tail_bump.webp","heads_bump.webp"]),o.setValues(0,1),o.inertia=8,o.scale=.9,o.colorset="coin_default",r.push(o),o=new DicePreset("d4"),o.setLabels(["1","2","3","4"]),o.setValues(1,4),o.inertia=5,o.scale=1.2,r.push(o),o=new DicePreset("d6"),o.setLabels(["1","2","3","4","5","6"]),o.setValues(1,6),o.scale=.9,r.push(o),o=new DicePreset("d3","d6"),o.setLabels(["1","2","3"]),o.setValues(1,3),o.scale=.9,r.push(o),o=new DicePreset("df","d6"),o.term="FateDie",o.setLabels(["−"," ","+"]),o.setValues(-1,1),o.scale=.9,r.push(o),o=new DicePreset("d8"),o.setLabels(["1","2","3","4","5","6","7","8"]),o.setValues(1,8),r.push(o),o=new DicePreset("d10"),o.setLabels(["1","2","3","4","5","6","7","8","9","0"]),o.setValues(1,10),o.mass=450,o.inertia=9,o.scale=.9,r.push(o),o=new DicePreset("d5","d10"),o.setLabels(["1","2","3","4","5"]),o.setValues(1,5),o.mass=450,o.inertia=9,o.scale=.9,r.push(o),o=new DicePreset("d100","d10"),o.setLabels(["10","20","30","40","50","60","70","80","90","00"]),o.setValues(10,100,10),o.mass=450,o.inertia=9,o.scale=.9,r.push(o),o=new DicePreset("d12"),o.setLabels(["1","2","3","4","5","6","7","8","9","10","11","12"]),o.setValues(1,12),o.mass=450,o.inertia=8,o.scale=.9,r.push(o),o=new DicePreset("d14"),o.setLabels(["1","2","3","4","5","6","7","8","9","10","11","12","13","14"]),o.setValues(1,14),o.mass=450,o.inertia=8,o.scale=1,r.push(o),o=new DicePreset("d7","d14"),o.setLabels(["1","2","3","4","5","6","7"]),o.setValues(1,7),o.mass=450,o.inertia=8,o.scale=1,r.push(o),o=new DicePreset("d16"),o.setLabels(["1","2","3","4","5","6","7","8","9","10","11","12","13","14","15","16"]),o.setValues(1,16),o.mass=450,o.inertia=8,o.scale=1,r.push(o),o=new DicePreset("d20"),o.setLabels(["1","2","3","4","5","6","7","8","9","10","11","12","13","14","15","16","17","18","19","20"]),o.setValues(1,20),o.mass=500,o.scale=1,o.inertia=6,r.push(o),o=new DicePreset("d24"),o.setLabels(["1","2","3","4","5","6","7","8","9","10","11","12","13","14","15","16","17","18","19","20","21","22","23","24"]),o.setValues(1,24),o.mass=500,o.scale=1,o.inertia=10,r.push(o),o=new DicePreset("d30"),o.setLabels(["1","2","3","4","5","6","7","8","9","10","11","12","13","14","15","16","17","18","19","20","21","22","23","24","25","26","27","28","29","30"]),o.setValues(1,30),o.mass=500,o.scale=1,o.inertia=10,r.push(o),a.push({type:"d6",atlas:"modules/dice-so-nice/textures/dot.json",labels:["d6-1.webp","d6-2.webp","d6-3.webp","d6-4.webp","d6-5.webp","d6-6.webp"],bumpMaps:["d6-1-b.webp","d6-2-b.webp","d6-3-b.webp","d6-4-b.webp","d6-5-b.webp","d6-6-b.webp"],system:"dot"}),a.push({type:"d6",atlas:"modules/dice-so-nice/textures/dot.json",labels:["d6-1-black.webp","d6-2-black.webp","d6-3-black.webp","d6-4-black.webp","d6-5-black.webp","d6-6-black.webp"],bumpMaps:["d6-1-b.webp","d6-2-b.webp","d6-3-b.webp","d6-4-b.webp","d6-5-b.webp","d6-6-b.webp"],system:"dot_b"}),a.push({type:"d2",labels:["1","F"],font:"FoundryVTT",system:"foundry_vtt",fontScale:1.2}),a.push({type:"d4",labels:["1","2","3","E"],font:"FoundryVTT",system:"foundry_vtt",fontScale:.8}),a.push({type:"d6",labels:["1","2","3","4","5","E"],font:"FoundryVTT",system:"foundry_vtt"}),a.push({type:"df",labels:["−"," ","+"],font:"FoundryVTT",system:"foundry_vtt"}),a.push({type:"d3",labels:["1","2","E"],font:"FoundryVTT",system:"foundry_vtt"}),a.push({type:"d8",labels:["1","2","3","4","5","6","7","F"],font:"FoundryVTT",system:"foundry_vtt"}),a.push({type:"d10",labels:["1","2","3","4","5","6","7","8","9","E"],font:"FoundryVTT",system:"foundry_vtt",fontScale:.9}),a.push({type:"d5",labels:["1","2","3","4","E"],font:"FoundryVTT",system:"foundry_vtt",fontScale:.9}),a.push({type:"d100",labels:["10","20","30","40","50","60","70","80","90","E"],font:"FoundryVTT",system:"foundry_vtt"}),a.push({type:"d12",labels:["1","2","3","4","5","6","7","8","9","10","11","E"],font:"FoundryVTT",system:"foundry_vtt"}),a.push({type:"d14",labels:["1","2","3","4","5","6","7","8","9","10","11","12","13","E"],font:"FoundryVTT",system:"foundry_vtt"}),a.push({type:"d7",labels:["1","2","3","4","5","6","E"],font:"FoundryVTT",system:"foundry_vtt"}),a.push({type:"d16",labels:["1","2","3","4","5","6","7","8","9","10","11","12","13","14","15","E"],font:"FoundryVTT",system:"foundry_vtt"}),a.push({type:"d20",labels:["1","2","3","4","5","6","7","8","9","10","11","12","13","14","15","16","17","18","19","F"],font:"FoundryVTT",system:"foundry_vtt"}),a.push({type:"d24",labels:["1","2","3","4","5","6","7","8","9","10","11","12","13","14","15","16","17","18","19","20","21","22","23","F"],font:"FoundryVTT",system:"foundry_vtt"}),a.push({type:"d30",labels:["1","2","3","4","5","6","7","8","9","10","11","12","13","14","15","16","17","18","19","20","21","22","23","24","25","26","27","28","29","E"],font:"FoundryVTT",system:"foundry_vtt"}),a.push({type:"df",atlas:"modules/dice-so-nice/textures/spectrum-0.json",labels:["df-m.webp","df-0.webp","df-p.webp"],emissiveMaps:["df-m.webp","df-0.webp","df-p.webp"],emissive:16777215,emissiveIntensity:2,colorset:"spectrum_default",system:"spectrum"}),a.push({type:"d2",atlas:"modules/dice-so-nice/textures/spectrum-0.json",labels:["d2-1.webp","d2-2.webp"],emissiveMaps:["d2-1.webp","d2-2.webp"],emissiveIntensity:2,emissive:16777215,colorset:"spectrum_default",system:"spectrum"}),a.push({type:"dc",atlas:"modules/dice-so-nice/textures/spectrum-0.json",labels:["dc-h.webp","dc-t.webp"],emissiveMaps:["dc-h.webp","dc-t.webp"],emissiveIntensity:2,emissive:16777215,colorset:"spectrum_default",system:"spectrum"}),a.push({type:"d4",atlas:"modules/dice-so-nice/textures/spectrum-0.json",labels:["d4-1.webp","d4-2.webp","d4-3.webp","d4-4.webp"],emissiveMaps:["d4-1.webp","d4-2.webp","d4-3.webp","d4-4.webp"],emissive:16777215,colorset:"spectrum_default",system:"spectrum"}),a.push({type:"d6",atlas:"modules/dice-so-nice/textures/spectrum-0.json",labels:["d6-1.webp","d6-2.webp","d6-3.webp","d6-4.webp","d6-5.webp","d6-6.webp"],emissiveMaps:["d6-1.webp","d6-2.webp","d6-3.webp","d6-4.webp","d6-5.webp","d6-6.webp"],emissive:16777215,colorset:"spectrum_default",system:"spectrum"}),a.push({type:"d8",atlas:"modules/dice-so-nice/textures/spectrum-0.json",labels:["d8-1.webp","d8-2.webp","d8-3.webp","d8-4.webp","d8-5.webp","d8-6.webp","d8-7.webp","d8-8.webp"],emissiveMaps:["d8-1.webp","d8-2.webp","d8-3.webp","d8-4.webp","d8-5.webp","d8-6.webp","d8-7.webp","d8-8.webp"],emissiveIntensity:2,emissive:16777215,colorset:"spectrum_default",system:"spectrum"}),a.push({type:"d10",atlas:"modules/dice-so-nice/textures/spectrum-0.json",labels:["d10-1.webp","d10-2.webp","d10-3.webp","d10-4.webp","d10-5.webp","d10-6.webp","d10-7.webp","d10-8.webp","d10-9.webp","d10-0.webp"],emissiveMaps:["d10-1.webp","d10-2.webp","d10-3.webp","d10-4.webp","d10-5.webp","d10-6.webp","d10-7.webp","d10-8.webp","d10-9.webp","d10-0.webp"],emissiveIntensity:2,emissive:16777215,colorset:"spectrum_default",system:"spectrum"}),a.push({type:"d12",atlas:"modules/dice-so-nice/textures/spectrum-0.json",labels:["d12-1.webp","d12-2.webp","d12-3.webp","d12-4.webp","d12-5.webp","d12-6.webp","d12-7.webp","d12-8.webp","d12-9.webp","d12-10.webp","d12-11.webp","d12-12.webp"],emissiveMaps:["d12-1.webp","d12-2.webp","d12-3.webp","d12-4.webp","d12-5.webp","d12-6.webp","d12-7.webp","d12-8.webp","d12-9.webp","d12-10.webp","d12-11.webp","d12-12.webp"],emissiveIntensity:2,emissive:16777215,colorset:"spectrum_default",system:"spectrum"}),a.push({type:"d100",atlas:"modules/dice-so-nice/textures/spectrum-0.json",labels:["d100-10.webp","d100-20.webp","d100-30.webp","d100-40.webp","d100-50.webp","d100-60.webp","d100-70.webp","d100-80.webp","d100-90.webp","d100-00.webp"],emissiveMaps:["d100-10.webp","d100-20.webp","d100-30.webp","d100-40.webp","d100-50.webp","d100-60.webp","d100-70.webp","d100-80.webp","d100-90.webp","d100-00.webp"],emissiveIntensity:2,emissive:16777215,colorset:"spectrum_default",system:"spectrum"}),a.push({type:"d20",atlas:"modules/dice-so-nice/textures/spectrum-0.json",labels:["d20-1.webp","d20-2.webp","d20-3.webp","d20-4.webp","d20-5.webp","d20-6.webp","d20-7.webp","d20-8.webp","d20-9.webp","d20-10.webp","d20-11.webp","d20-12.webp","d20-13.webp","d20-14.webp","d20-15.webp","d20-16.webp","d20-17.webp","d20-18.webp","d20-19.webp","d20-20.webp"],emissiveMaps:["d20-1.webp","d20-2.webp","d20-3.webp","d20-4.webp","d20-5.webp","d20-6.webp","d20-7.webp","d20-8.webp","d20-9.webp","d20-10.webp","d20-11.webp","d20-12.webp","d20-13.webp","d20-14.webp","d20-15.webp","d20-16.webp","d20-17.webp","d20-18.webp","d20-19.webp","d20-20.webp"],emissiveIntensity:2,emissive:16777215,colorset:"spectrum_default",system:"spectrum"});const l={none:{name:"DICESONICE.TextureNone",composite:"source-over",source:"",bump:""},cloudy:{name:"DICESONICE.TextureCloudsTransparent",composite:"destination-in",atlas:"modules/dice-so-nice/textures/standard.json",source:"cloudy.webp",bump:"cloudy.alt.webp"},cloudy_2:{name:"DICESONICE.TextureClouds",composite:"multiply",atlas:"modules/dice-so-nice/textures/standard.json",source:"cloudy.alt.webp",bump:"cloudy.alt.webp"},fire:{name:"DICESONICE.TextureFire",composite:"multiply",atlas:"modules/dice-so-nice/textures/standard.json",source:"fire.webp",bump:"fire.webp"},marble:{name:"DICESONICE.TextureMarble",composite:"multiply",atlas:"modules/dice-so-nice/textures/standard.json",source:"marble.webp",bump:"",material:"glass"},water:{name:"DICESONICE.TextureWaterTransparent",composite:"destination-in",atlas:"modules/dice-so-nice/textures/standard.json",source:"water.webp",bump:"water.webp",material:"glass"},water_2:{name:"DICESONICE.TextureWater",composite:"multiply",atlas:"modules/dice-so-nice/textures/standard.json",source:"water.webp",bump:"water.webp",material:"glass"},ice:{name:"DICESONICE.TextureIceTransparent",composite:"destination-in",atlas:"modules/dice-so-nice/textures/standard.json",source:"ice.webp",bump:"ice.webp",material:"glass"},ice_2:{name:"DICESONICE.TextureIce",composite:"multiply",atlas:"modules/dice-so-nice/textures/standard.json",source:"ice.webp",bump:"ice.webp",material:"glass"},paper:{name:"DICESONICE.TexturePaper",composite:"multiply",atlas:"modules/dice-so-nice/textures/standard.json",source:"paper.webp",bump:"paper_bump.webp",material:"wood"},speckles:{name:"DICESONICE.TextureSpeckles",composite:"multiply",atlas:"modules/dice-so-nice/textures/standard.json",source:"speckles.webp",bump:"speckles.webp"},glitter:{name:"DICESONICE.TextureGlitter",composite:"multiply",atlas:"modules/dice-so-nice/textures/standard.json",source:"glitter.webp",bump:"glitter_bump.webp"},glitter_2:{name:"DICESONICE.TextureGlitterTransparent",composite:"destination-in",atlas:"modules/dice-so-nice/textures/standard.json",source:"glitter-alpha.webp",bump:""},stars:{name:"DICESONICE.TextureStars",composite:"multiply",atlas:"modules/dice-so-nice/textures/standard.json",source:"stars.webp",bump:"stars.webp"},stainedglass:{name:"DICESONICE.TextureStainedGlass",composite:"multiply",atlas:"modules/dice-so-nice/textures/standard.json",source:"stainedglass.webp",bump:"stainedglass_bump.webp",material:"iridescent"},skulls:{name:"DICESONICE.TextureSkulls",composite:"multiply",atlas:"modules/dice-so-nice/textures/standard.json",source:"skulls.webp",bump:"skulls.webp"},leopard:{name:"DICESONICE.TextureLeopard",composite:"multiply",atlas:"modules/dice-so-nice/textures/standard.json",source:"leopard.webp",bump:"leopard.webp",material:"wood"},tiger:{name:"DICESONICE.TextureTiger",composite:"multiply",atlas:"modules/dice-so-nice/textures/standard.json",source:"tiger.webp",bump:"tiger.webp",material:"wood"},cheetah:{name:"DICESONICE.TextureCheetah",composite:"multiply",atlas:"modules/dice-so-nice/textures/standard.json",source:"cheetah.webp",bump:"cheetah.webp",material:"wood"},dragon:{name:"Dragon",composite:"multiply",atlas:"modules/dice-so-nice/textures/standard.json",source:"dragon.webp",bump:"dragon_bump.webp"},lizard:{name:"Lizard",composite:"multiply",atlas:"modules/dice-so-nice/textures/standard.json",source:"lizard.webp",bump:"lizard_bump.webp"},bird:{name:"Bird",composite:"multiply",atlas:"modules/dice-so-nice/textures/standard.json",source:"feather.webp",bump:"feather_bump.webp"},astral:{name:"DICESONICE.TextureAstralSea",composite:"multiply",atlas:"modules/dice-so-nice/textures/standard.json",source:"astral.webp",bump:"stars.webp"},wood:{name:"DICESONICE.TextureWood",composite:"multiply",atlas:"modules/dice-so-nice/textures/standard.json",source:"wood.webp",bump:"wood.webp",material:"wood"},metal:{name:"DICESONICE.TextureMetal",composite:"multiply",atlas:"modules/dice-so-nice/textures/standard.json",source:"metal.webp",bump:"",material:"metal"},stone:{name:"DICESONICE.TextureStone",composite:"soft-light",atlas:"modules/dice-so-nice/textures/standard.json",source:"stone.webp",bump:"stone.webp",material:"stone"},radial:{name:"DICESONICE.TextureRadial",composite:"source-over",atlas:"modules/dice-so-nice/textures/standard.json",source:"radial.webp",bump:""},bronze01:{name:"DICESONICE.TextureBronze1",composite:"difference",atlas:"modules/dice-so-nice/textures/standard.json",source:"bronze01.webp",material:"metal",bump:""},bronze02:{name:"DICESONICE.TextureBronze2",composite:"difference",atlas:"modules/dice-so-nice/textures/standard.json",source:"bronze02.webp",material:"metal",bump:""},bronze03:{name:"DICESONICE.TextureBronze3",composite:"difference",atlas:"modules/dice-so-nice/textures/standard.json",source:"bronze03.webp",material:"metal",bump:""},bronze03a:{name:"DICESONICE.TextureBronze3a",composite:"difference",atlas:"modules/dice-so-nice/textures/standard.json",source:"bronze03a.webp",material:"metal",bump:""},bronze03b:{name:"DICESONICE.TextureBronze3b",composite:"difference",atlas:"modules/dice-so-nice/textures/standard.json",source:"bronze03b.webp",material:"metal",bump:""},bronze04:{name:"DICESONICE.TextureBronze4",composite:"difference",atlas:"modules/dice-so-nice/textures/standard.json",source:"bronze04.webp",material:"metal",bump:""}},c={coin_default:{name:"coin_default",description:"DICESONICE.ColorCoinDefault",category:"DICESONICE.AcquiredTaste",foreground:"#f6c928",background:"#f6c928",outline:"none",edge:"#f6c928",texture:"metal",visibility:"hidden"},spectrum_default:{name:"spectrum_default",description:"DICESONICE.ColorSpectrumDefault",category:"DICESONICE.AcquiredTaste",foreground:"#ffffff",background:"#000000",outline:"#ffffff",edge:"#000000",texture:"none",visibility:"hidden",material:"pristine"},radiant:{name:"radiant",description:"DICESONICE.ColorRadiant",category:"DICESONICE.DamageTypes",foreground:"#F9B333",background:"#FFFFFF",outline:"gray",texture:"paper"},fire:{name:"fire",description:"DICESONICE.ColorFire",category:"DICESONICE.DamageTypes",foreground:"#f8d84f",background:["#f8d84f","#f9b02d","#f43c04","#910200","#4c1009"],outline:"black",texture:"fire"},ice:{name:"ice",description:"DICESONICE.ColorIce",category:"DICESONICE.DamageTypes",foreground:"#60E9FF",background:["#214fa3","#3c6ac1","#253f70","#0b56e2","#09317a"],outline:"black",texture:"ice"},cold:{name:"cold",description:"DICESONICE.ColorCold",category:"DICESONICE.DamageTypes",foreground:"#60E9FF",background:["#214fa3","#3c6ac1","#253f70","#0b56e2","#09317a"],outline:"black",texture:"ice_2"},poison:{name:"poison",description:"DICESONICE.ColorPoison",category:"DICESONICE.DamageTypes",foreground:"#D6A8FF",background:["#313866","#504099","#66409e","#934fc3","#c949fc"],outline:"black",texture:"cloudy"},acid:{name:"acid",description:"DICESONICE.ColorAcid",category:"DICESONICE.DamageTypes",foreground:"#A9FF70",background:["#a6ff00","#83b625","#5ace04","#69f006","#b0f006","#93bc25"],outline:"black",texture:"marble",material:"plastic"},thunder:{name:"thunder",description:"DICESONICE.ColorThunder",category:"DICESONICE.DamageTypes",foreground:"#FFC500",background:"#7D7D7D",outline:"black",texture:"cloudy"},lightning:{name:"lightning",description:"DICESONICE.ColorLightning",category:"DICESONICE.DamageTypes",foreground:"#FFC500",background:["#f17105","#f3ca40","#eddea4","#df9a57","#dea54b"],outline:"#7D7D7D",texture:"ice"},air:{name:"air",description:"DICESONICE.ColorAir",category:"DICESONICE.DamageTypes",foreground:"#ffffff",background:["#d0e5ea","#c3dee5","#a4ccd6","#8dafb7","#80a4ad"],outline:"black",texture:"cloudy"},water:{name:"water",description:"DICESONICE.ColorWater",category:"DICESONICE.DamageTypes",foreground:"#60E9FF",background:["#87b8c4","#77a6b2","#6b98a3","#5b8691","#4b757f"],outline:"black",texture:"water"},earth:{name:"earth",description:"DICESONICE.ColorEarth",category:"DICESONICE.DamageTypes",foreground:"#6C9943",background:["#346804","#184200","#527f22","#3a1d04","#56341a","#331c17","#5a352a","#302210"],outline:"black",texture:"speckles"},force:{name:"force",description:"DICESONICE.ColorForce",category:"DICESONICE.DamageTypes",foreground:"white",background:["#FF97FF","#FF68FF","#C651C6"],outline:"#570000",texture:"stars"},psychic:{name:"psychic",description:"DICESONICE.ColorPsychic",category:"DICESONICE.DamageTypes",foreground:"#D6A8FF",background:["#313866","#504099","#66409E","#934FC3","#C949FC","#313866"],outline:"black",texture:"speckles"},necrotic:{name:"necrotic",description:"DICESONICE.ColorNecrotic",category:"DICESONICE.DamageTypes",foreground:"#ffffff",background:"#6F0000",outline:"black",texture:"skulls"},breebaby:{name:"breebaby",description:"DICESONICE.ColorPastelSunset",category:"DICESONICE.ThemesSoNice",foreground:["#5E175E","#564A5E","#45455E","#3D5A5E","#1E595E","#5E3F3D","#5E1E29","#283C5E","#25295E"],background:["#FE89CF","#DFD4F2","#C2C2E8","#CCE7FA","#A1D9FC","#F3C3C2","#EB8993","#8EA1D2","#7477AD"],outline:"white",texture:"marble",material:"plastic"},pinkdreams:{name:"pinkdreams",description:"DICESONICE.ColorPinkDreams",category:"DICESONICE.ThemesSoNice",foreground:"white",background:["#ff007c","#df73ff","#f400a1","#df00ff","#ff33cc"],outline:"#570000",texture:"skulls"},inspired:{name:"inspired",description:"DICESONICE.ColorInspired",category:"DICESONICE.ThemesSoNice",foreground:"#FFD800",background:"#C4C4B6",outline:"#000000",texture:"stone"},bloodmoon:{name:"bloodmoon",description:"DICESONICE.ColorBloodMoon",category:"DICESONICE.ThemesSoNice",foreground:"#CDB800",background:"#6F0000",outline:"black",texture:"marble",material:"plastic"},starynight:{name:"starynight",description:"DICESONICE.ColorStaryNight",category:"DICESONICE.ThemesSoNice",foreground:"#4F708F",background:["#091636","#233660","#4F708F","#8597AD","#E2E2E2"],outline:"white",texture:"speckles"},glitterparty:{name:"glitterparty",description:"DICESONICE.ColorGlitterParty",category:"DICESONICE.ThemesSoNice",foreground:"white",background:["#FFB5F5","#7FC9FF","#A17FFF"],outline:"none",texture:"glitter"},astralsea:{name:"astralsea",description:"DICESONICE.ColorAstralSea",category:"DICESONICE.ThemesSoNice",foreground:"#565656",background:"white",outline:"none",texture:"astral"},foundry:{name:"foundry",description:"DICESONICE.ColorFoundry",category:"DICESONICE.ThemesSoNice",foreground:"#000000",background:"#ffffff",outline:"none",edge:"#000000",texture:"radial"},dragons:{name:"dragons",description:"DICESONICE.ColorDragons",category:"DICESONICE.AcquiredTaste",foreground:"#FFFFFF",background:["#B80000","#4D5A5A","#5BB8FF","#7E934E","#FFFFFF","#F6ED7C","#7797A3","#A78437","#862C1A","#FFDF8A"],outline:"black",texture:["dragon","lizard"],description:"Here be Dragons"},birdup:{name:"birdup",description:"DICESONICE.ColorBirdUp",category:"DICESONICE.AcquiredTaste",foreground:"#FFFFFF",background:["#F11602","#FFC000","#6EC832","#0094BC","#05608D","#FEABB3","#F75680","#F3F0DF","#C7A57F"],outline:"black",texture:"bird",description:"Bird Up!"},tigerking:{name:"tigerking",description:"DICESONICE.ColorTigerKing",category:"DICESONICE.AcquiredTaste",foreground:"#ffffff",background:"#FFCC40",outline:"black",texture:["leopard","tiger","cheetah"]},toxic:{name:"toxic",description:"DICESONICE.ColorToxic",category:"DICESONICE.AcquiredTaste",foreground:"#A9FF70",background:["#a6ff00","#83b625","#5ace04","#69f006","#b0f006","#93bc25"],outline:"black",texture:"fire"},rainbow:{name:"rainbow",description:"DICESONICE.ColorRainblow",category:"DICESONICE.Colors",foreground:["#FF5959","#FFA74F","#FFFF56","#59FF59","#2374FF","#00FFFF","#FF59FF"],background:["#900000","#CE3900","#BCBC00","#00B500","#00008E","#008282","#A500A5"],outline:"black",texture:"none"},random:{name:"random",description:"DICESONICE.ColorRaNdOm",category:"DICESONICE.Colors",foreground:[],outline:[],background:[],texture:[]},black:{name:"black",description:"DICESONICE.ColorBlack",category:"DICESONICE.Colors",foreground:"#ffffff",background:"#000000",outline:"black",texture:"none"},white:{name:"white",description:"DICESONICE.ColorWhite",category:"DICESONICE.Colors",foreground:"#000000",background:"#FFFFFF",outline:"#FFFFFF",texture:"none"},grey:{name:"grey",description:"DICESONICE.ColorGrey",category:"DICESONICE.Colors",foreground:"#FFFFFF",background:"#888888",outline:"#000000",texture:"none"},red:{name:"red",description:"DICESONICE.ColorRed",category:"DICESONICE.Colors",foreground:"#FFFFFF",background:"#FF0000",outline:"none",texture:"none"},blue:{name:"blue",description:"DICESONICE.ColorBlue",category:"DICESONICE.Colors",foreground:"#FFFFFF",background:"#0000FF",outline:"none",texture:"none"},green:{name:"green",description:"DICESONICE.ColorGreen",category:"DICESONICE.Colors",foreground:"#FFFFFF",background:"#00FF00",outline:"none",texture:"none"},yellow:{name:"yellow",description:"DICESONICE.ColorYellow",category:"DICESONICE.Colors",foreground:"#000000",background:"#FFFF00",outline:"none",texture:"none"},pink:{name:"pink",description:"DICESONICE.ColorPink",category:"DICESONICE.Colors",foreground:"#FFFFFF",background:"#FF00FF",outline:"none",texture:"none"},cyan:{name:"cyan",description:"DICESONICE.ColorCyan",category:"DICESONICE.Colors",foreground:"#000000",background:"#00FFFF",outline:"none",texture:"none"},prism:{name:"prism",description:"DICESONICE.ColorPrism",category:"DICESONICE.AcquiredTaste",foreground:"#FFFFFF",background:"#FFFFFF",outline:"black",texture:"stainedglass"},bronze:{name:"bronze",description:"DICESONICE.ColorBronze",category:"DICESONICE.ThemesSoNice",foreground:["#FF9159","#FFB066","#FFBF59","#FFD059"],background:["#705206","#7A4E06","#643100","#7A2D06"],outline:["#3D2D03","#472D04","#301700","#471A04"],edge:["#FF5D0D","#FF7B00","#FFA20D","#FFBA0D"],texture:["bronze01","bronze02","bronze03","bronze03b","bronze03b","bronze04"]},custom:{name:"custom",description:"DICESONICE.ColorCustom",category:"DICESONICE.Colors",foreground:"",background:"",outline:"",edge:"",texture:"none"}},h={d2:1,d4:1,d6:1.3,d8:1.1,d10:1,d12:1.1,d14:.5,d16:.5,d20:1,d24:1,d30:.75,d3:1.3,d5:1,d7:.5,df:2,d100:.75};class DiceColors{static diceTextures={};static diceBumps={};static loadTextures(t,i){const r=[],a=Object.entries(t);for(const[t,i]of a)i.atlas?r.push(i.atlas):(i.source&&""!==i.source&&r.push(i.source),i.bump&&""!==i.bump&&r.push(i.bump));(new AssetsLoader).load(r).then((t=>{for(const[i,r]of a)r.atlas?(r.source&&""!==r.source&&(DiceColors.diceTextures[i]=t[r.atlas][r.source]),r.bump&&""!==r.bump&&(DiceColors.diceBumps[i]=t[r.atlas][r.bump])):(r.source&&""!==r.source&&(DiceColors.diceTextures[i]=t[r.source]),r.bump&&""!==r.bump&&(DiceColors.diceBumps[i]=t[r.bump]));i(t)}))}static getTexture(t){if(Array.isArray(t)){let i=[];for(let r=0,a=t.length;r<a;r++)("string"==typeof t[r]||Array.isArray(t[r]))&&i.push(this.getTexture(t[r]));return i}if(!t||""==t)return{name:"",texture:"",material:"plastic"};if("none"==t)return{name:"none",texture:"",material:"plastic"};if("random"==t){let t=Object.keys(DiceColors.diceTextures);return this.getTexture(t[Math.floor(Math.random()*t.length)])}return DiceColors.diceTextures?null!=DiceColors.diceTextures[t]?(l[t].material||(l[t].material="plastic"),DiceColors.diceBumps[t]||(DiceColors.diceBumps[t]=""),{name:t,bump:DiceColors.diceBumps[t],material:l[t].material,texture:DiceColors.diceTextures[t],composite:l[t].composite}):{name:"",texture:""}:t}static randomColor(){let t=[];t[0]=Math.floor(254*Math.random()),t[1]=Math.floor(254*Math.random()),t[2]=Math.floor(254*Math.random());let i=(299*parseInt(t[0])+587*parseInt(t[1])+114*parseInt(t[2]))/1e3>126?"rgb(30,30,30)":"rgb(230,230,230)";return{background:"rgb("+t[0]+","+t[1]+","+t[2]+")",foreground:i}}static initColorSets(t=null){let i;if(t){let r={};r[t.name]=t,i=Object.entries(r)}else i=Object.entries(c);for(const[t,r]of i)c[t].id=t,"custom"!=r.texture&&(c[t].texture=this.getTexture(r.texture)),"object"==typeof c[t].texture&&(c[t].texture.id=r.id),c[t].material||(c[t].material=""),c[t].font||(c[t].font="Arial"),c[t].fontScale?c[t].fontScale=foundry.utils.mergeObject(h,c[t].fontScale,{inplace:!1,performDeletions:!0}):c[t].fontScale=h,c[t].visibility||(c[t].visibility="visible");if(!t)for(let t=0;t<10;t++){let t=this.randomColor(),i=this.getTexture("random");""!=i.name?(c.random.foreground.push(t.foreground),c.random.background.push(t.background),c.random.outline.push(t.background),c.random.texture.push(i)):(c.random.foreground.push(t.foreground),c.random.background.push(t.background),c.random.outline.push("black"),c.random.texture.push(""))}}static getColorSet(t){return{...c[t]||c.custom}}static setColorCustom(t="#FFFFFF",i="#000000",r="#FFFFFF",a="#FFFFFF"){c.custom.foreground=t,c.custom.background=i,c.custom.outline=r,c.custom.edge=a}}const d={d2:{metadata:{version:4.5,type:"BufferGeometry",generator:"BufferGeometry.toJSON"},uuid:"29D8FA3F-1F04-4F5A-985B-16353BAB0B2C",type:"BufferGeometry",data:{attributes:{position:{itemSize:3,type:"Float32Array",array:[88.93379974365234,.0001336209534201771,-4.532903671264648,88.93379974365234,.0001336209534201771,-4.532903671264648,88.93379974365234,.0001336209534201771,-4.532903671264648,90.8361587524414,-6830116763012484e-20,-2.6535863876342773,90.8361587524414,-6830116763012484e-20,-2.6535863876342773,84.580078125,-27.482694625854492,4.547501087188721,84.580078125,-27.482694625854492,4.547501087188721,86.38970947265625,-28.07042121887207,2.668496608734131,27.482057571411133,-84.58028411865234,-4.547504901885986,27.482057571411133,-84.58028411865234,-4.547504901885986,28.06978416442871,-86.38990783691406,-2.6685009002685547,27.481149673461914,-84.58119201660156,4.536083698272705,27.481149673461914,-84.58119201660156,4.536083698272705,28.069250106811523,-86.39043426513672,2.6568350791931152,-.0007737207342870533,-88.93378448486328,4.532901287078857,-.0007737207342870533,-88.93378448486328,4.532901287078857,-.0007737207342870533,-88.93378448486328,4.532901287078857,-.0005998046253807843,-90.83614349365234,2.6535849571228027,-.0005998046253807843,-90.83614349365234,2.6535849571228027,-27.482694625854492,-84.58097839355469,4.5305891036987305,-27.482694625854492,-84.58097839355469,4.5305891036987305,-28.07042121887207,-86.39022827148438,2.6512229442596436,-84.58029174804688,-27.481143951416016,-4.552997589111328,-84.58029174804688,-27.481143951416016,-4.552997589111328,-86.3899154663086,-28.06924819946289,-2.6741106510162354,-88.93379974365234,-.0001336209534201771,4.532903671264648,-88.93379974365234,-.0001336209534201771,4.532903671264648,-88.93379974365234,-.0001336209534201771,4.532903671264648,-90.8361587524414,6830116763012484e-20,2.6535863876342773,-90.8361587524414,6830116763012484e-20,2.6535863876342773,-71.94794464111328,52.27442169189453,-4.543759822845459,-71.94794464111328,52.27442169189453,-4.543759822845459,-73.4873275756836,53.39253234863281,-2.664675235748291,-71.9488525390625,52.27351379394531,4.539828777313232,-71.9488525390625,52.27351379394531,4.539828777313232,-73.48785400390625,53.391998291015625,2.6606605052948,-52.27299499511719,71.94922637939453,-4.539824962615967,-52.27299499511719,71.94922637939453,-4.539824962615967,-53.39146423339844,73.48823547363281,-2.660656213760376,-27.482057571411133,84.58028411865234,4.547504901885986,-27.482057571411133,84.58028411865234,4.547504901885986,-28.06978416442871,86.38990783691406,2.6685009002685547,.0007736866245977581,88.93378448486328,-4.532901287078857,.0007736866245977581,88.93378448486328,-4.532901287078857,.0007736866245977581,88.93378448486328,-4.532901287078857,.0005998046253807843,90.83614349365234,-2.6535849571228027,.0005998046253807843,90.83614349365234,-2.6535849571228027,-.00013426830992102623,88.93287658691406,4.550687789916992,-.00013426830992102623,88.93287658691406,4.550687789916992,-.00013426830992102623,88.93287658691406,4.550687789916992,6751317414455116e-20,90.83562469482422,2.6717519760131836,6751317414455116e-20,90.83562469482422,2.6717519760131836,27.482694625854492,84.58097839355469,-4.5305891036987305,27.482694625854492,84.58097839355469,-4.5305891036987305,28.07042121887207,86.39022827148438,-2.6512229442596436,84.5811996459961,27.482053756713867,-4.530590534210205,84.5811996459961,27.482053756713867,-4.530590534210205,86.39044189453125,28.069782257080078,-2.651224374771118,84.58098602294922,-27.48178482055664,-4.5360870361328125,84.58098602294922,-27.48178482055664,-4.5360870361328125,86.3902359008789,-28.069887161254883,-2.6568384170532227,73.48785400390625,-53.391998291015625,-2.6606605052948,71.9488525390625,-52.27351379394531,-4.539828777313232,71.9488525390625,-52.27351379394531,-4.539828777313232,52.273902893066406,-71.94831848144531,-4.543763637542725,52.273902893066406,-71.94831848144531,-4.543763637542725,53.39199447631836,-73.48770904541016,-2.6646788120269775,.00013430237595457584,-88.93287658691406,-4.550687789916992,.00013430237595457584,-88.93287658691406,-4.550687789916992,.00013430237595457584,-88.93287658691406,-4.550687789916992,-6751317414455116e-20,-90.83562469482422,-2.6717519760131836,-6751317414455116e-20,-90.83562469482422,-2.6717519760131836,-28.069887161254883,-86.38970184326172,-2.6741127967834473,-27.48178482055664,-84.58007049560547,-4.552999496459961,-27.48178482055664,-84.58007049560547,-4.552999496459961,-52.27351760864258,-71.94794464111328,-4.5542144775390625,-52.27351760864258,-71.94794464111328,-4.5542144775390625,-53.39200210571289,-73.4873275756836,-2.67535400390625,-71.94832611083984,-52.27299118041992,-4.554214000701904,-71.94832611083984,-52.27299118041992,-4.554214000701904,-73.48771667480469,-53.391456604003906,-2.675353527069092,-88.93289947509766,.0007747426279820502,-4.550684928894043,-88.93289947509766,.0007747426279820502,-4.550684928894043,-88.93289947509766,.0007747426279820502,-4.550684928894043,-90.83563995361328,.000600832630880177,-2.671748399734497,-90.83563995361328,.000600832630880177,-2.671748399734497,-84.580078125,27.482694625854492,-4.547501087188721,-84.580078125,27.482694625854492,-4.547501087188721,-86.38970947265625,28.07042121887207,-2.668496608734131,-27.481149673461914,84.58119201660156,-4.536083698272705,-27.481149673461914,84.58119201660156,-4.536083698272705,-28.069250106811523,86.39043426513672,-2.6568350791931152,52.2744255065918,71.94884490966797,-4.529373645782471,52.2744255065918,71.94884490966797,-4.529373645782471,53.39253616333008,73.48784637451172,-2.649981737136841,71.94922637939453,52.273895263671875,-4.529374599456787,71.94922637939453,52.273895263671875,-4.529374599456787,73.48823547363281,53.391990661621094,-2.649982452392578,88.93289947509766,-.0007747426279820502,4.550684928894043,88.93289947509766,-.0007747426279820502,4.550684928894043,88.93289947509766,-.0007747426279820502,4.550684928894043,90.83563995361328,-.000600832630880177,2.671748399734497,90.83563995361328,-.000600832630880177,2.671748399734497,71.94794464111328,-52.27442169189453,4.543759346008301,71.94794464111328,-52.27442169189453,4.543759346008301,73.4873275756836,-53.39253234863281,2.664675235748291,52.27299499511719,-71.94922637939453,4.539824962615967,52.27299499511719,-71.94922637939453,4.539824962615967,53.39146423339844,-73.48823547363281,2.660656213760376,-52.2744255065918,-71.94884490966797,4.529373645782471,-52.2744255065918,-71.94884490966797,4.529373645782471,-53.39253616333008,-73.48784637451172,2.649981737136841,-73.48823547363281,-53.391990661621094,2.649982452392578,-71.94922637939453,-52.273895263671875,4.529374599456787,-71.94922637939453,-52.273895263671875,4.529374599456787,-84.5811996459961,-27.482053756713867,4.530590534210205,-84.5811996459961,-27.482053756713867,4.530590534210205,-86.39044189453125,-28.069782257080078,2.651224374771118,-84.58098602294922,27.48178482055664,4.5360870361328125,-84.58098602294922,27.48178482055664,4.5360870361328125,-86.3902359008789,28.069887161254883,2.6568384170532227,-52.273902893066406,71.94831848144531,4.543763637542725,-52.273902893066406,71.94831848144531,4.543763637542725,-53.39199447631836,73.48770904541016,2.6646788120269775,27.48178482055664,84.58007049560547,4.552999496459961,27.48178482055664,84.58007049560547,4.552999496459961,28.069887161254883,86.38970184326172,2.6741127967834473,52.27351760864258,71.94794464111328,4.5542144775390625,52.27351760864258,71.94794464111328,4.5542144775390625,53.39200210571289,73.4873275756836,2.67535400390625,73.48771667480469,53.391456604003906,2.675353527069092,71.94832611083984,52.27299118041992,4.554214000701904,71.94832611083984,52.27299118041992,4.554214000701904,84.58029174804688,27.481143951416016,4.552997589111328,84.58029174804688,27.481143951416016,4.552997589111328,86.3899154663086,28.06924819946289,2.6741106510162354],normalized:!1},normal:{itemSize:3,type:"Float32Array",array:[.004305333364754915,.00014043168630450964,-.9999908208847046,.004305333364754915,.00014043168630450964,-.9999908208847046,.004305333364754915,.00014043168630450964,-.9999908208847046,.967370867729187,23871660232543945e-21,-.2533644437789917,.967370867729187,23871660232543945e-21,-.2533644437789917,.003924518823623657,-.0014061331748962402,.9999912977218628,.003924518823623657,-.0014061331748962402,.9999912977218628,.919967532157898,-.2989548146724701,.25354647636413574,.0014187097549438477,-.003943443298339844,-.9999911785125732,.0014187097549438477,-.003943443298339844,-.9999911785125732,.2989460825920105,-.9199705719947815,-.2535456418991089,.001207306981086731,-.004139244556427002,.999990701675415,.001207306981086731,-.004139244556427002,.999990701675415,.29889336228370667,-.9200217723846436,.25342196226119995,-.00010144524276256561,-.004305422306060791,.9999908208847046,-.00010144524276256561,-.004305422306060791,.9999908208847046,-.00010144524276256561,-.004305422306060791,.9999908208847046,-2811197191476822e-20,-.9673709869384766,.25336405634880066,-2811197191476822e-20,-.9673709869384766,.25336405634880066,-.0013865083456039429,-.0041558146476745605,.9999904036521912,-.0013865083456039429,-.0041558146476745605,.9999904036521912,-.29895341396331787,-.9200186133384705,.25336307287216187,-.003935068845748901,-.0012163519859313965,-.9999915361404419,-.003935068845748901,-.0012163519859313965,-.9999915361404419,-.9199703335762024,-.2988958954811096,-.25360578298568726,-.00432974100112915,-.00013017654418945312,.9999905824661255,-.00432974100112915,-.00013017654418945312,.9999905824661255,-.00432974100112915,-.00013017654418945312,.9999905824661255,-.967370867729187,-22581778466701508e-21,.2533644139766693,-.967370867729187,-22581778466701508e-21,.2533644139766693,-.003362357383593917,.002567464951425791,-.9999910593032837,-.003362357383593917,.002567464951425791,-.9999910593032837,-.7825664281845093,.5686163306236267,-.253506064414978,-.0035184919834136963,.0023897886276245117,.9999909996986389,-.0035184919834136963,.0023897886276245117,.9999909996986389,-.7826218605041504,.5685698390007019,.25343894958496094,-.002216615015640855,.0036201775074005127,-.9999910593032837,-.002216615015640855,.0036201775074005127,-.9999910593032837,-.5685653686523438,.782625675201416,-.25343722105026245,-.0013963840901851654,.0039055049419403076,.9999913573265076,-.0013963840901851654,.0039055049419403076,.9999913573265076,-.2989453971385956,.9199708104133606,.2535455524921417,.00011461973190307617,.004342749714851379,-.9999904632568359,.00011461973190307617,.004342749714851379,-.9999904632568359,.00011461973190307617,.004342749714851379,-.9999904632568359,28920238037244417e-21,.9673709273338318,-.25336408615112305,28920238037244417e-21,.9673709273338318,-.25336408615112305,-9849853813648224e-20,.0041036903858184814,.9999915957450867,-9849853813648224e-20,.0041036903858184814,.9999915957450867,-9849853813648224e-20,.0041036903858184814,.9999915957450867,-1982133835554123e-20,.967315137386322,.2535773515701294,-1982133835554123e-20,.967315137386322,.2535773515701294,.001379296649247408,.004155764821916819,-.9999904632568359,.001379296649247408,.004155764821916819,-.9999904632568359,.2989526391029358,.9200189113616943,-.25336307287216187,.004105646628886461,.0014420022489503026,-.9999905824661255,.004105646628886461,.0014420022489503026,-.9999905824661255,.9200265407562256,.29895055294036865,-.25333744287490845,.0041483743116259575,-.001177109545096755,-.999990701675415,.0041483743116259575,-.001177109545096755,-.999990701675415,.92001873254776,-.29890236258506775,-.2534225881099701,.7826225161552429,-.5685691237449646,-.2534385919570923,.0034059027675539255,-.002543120877817273,-.9999909400939941,.0034059027675539255,-.002543120877817273,-.9999909400939941,.0025934576988220215,-.0033233165740966797,-.9999910593032837,.0025934576988220215,-.0033233165740966797,-.9999910593032837,.5686105489730835,-.7825710773468018,-.2535049617290497,.00014024082338437438,-.004108965862542391,-.9999915361404419,.00014024082338437438,-.004108965862542391,-.9999915361404419,.00014024082338437438,-.004108965862542391,-.9999915361404419,21778512746095657e-21,-.9673150777816772,-.253577321767807,21778512746095657e-21,-.9673150777816772,-.253577321767807,-.29890191555023193,-.9199681878089905,-.2536064684391022,-.001328025944530964,-.003906830679625273,-.9999914765357971,-.001328025944530964,-.003906830679625273,-.9999914765357971,-.0024206042289733887,-.0033184662461280823,-.9999915361404419,-.0024206042289733887,-.0033184662461280823,-.9999915361404419,-.56856769323349,-.7825732231140137,-.25359416007995605,-.0033223330974578857,-.002392679452896118,-.9999916553497314,-.0033223330974578857,-.002392679452896118,-.9999916553497314,-.7825719118118286,-.5685604810714722,-.25361454486846924,-.004138410557061434,5978979606879875e-20,-.9999914169311523,-.004138410557061434,5978979606879875e-20,-.9999914169311523,-.004138410557061434,5978979606879875e-20,-.9999914169311523,-.9673154950141907,2910134026024025e-20,-.25357601046562195,-.9673154950141907,2910134026024025e-20,-.25357601046562195,-.003914192318916321,.0014359354972839355,-.9999912977218628,-.003914192318916321,.0014359354972839355,-.9999912977218628,-.9199680089950562,.29895293712615967,-.2535468339920044,-.001218944787979126,.004143953323364258,-.9999906420707703,-.001218944787979126,.004143953323364258,-.9999906420707703,-.2988971769809723,.920020580291748,-.25342193245887756,.002553605241701007,.003544599749147892,-.9999905228614807,.002553605241701007,.003544599749147892,-.9999905228614807,.5686197876930237,.7826223373413086,-.25332552194595337,.0034990310668945312,.0025759339332580566,-.9999905824661255,.0034990310668945312,.0025759339332580566,-.9999905824661255,.7826220393180847,.5686109662055969,-.25334614515304565,.004121424164623022,9648066043155268e-20,.9999914169311523,.004121424164623022,9648066043155268e-20,.9999914169311523,.004121424164623022,9648066043155268e-20,.9999914169311523,.9673154950141907,-2708425745368004e-20,.2535760700702667,.9673154950141907,-2708425745368004e-20,.2535760700702667,.0033468306064605713,-.002586185932159424,.9999910593032837,.0033468306064605713,-.002586185932159424,.9999910593032837,.7825667858123779,-.5686154365539551,.25350672006607056,.002382144331932068,-.003524601459503174,.9999909996986389,.002382144331932068,-.003524601459503174,.9999909996986389,.5685621500015259,-.7826279401779175,.2534373998641968,-.0025890469551086426,-.003517657518386841,.9999905228614807,-.0025890469551086426,-.003517657518386841,.9999905228614807,-.5686206817626953,-.7826217412948608,.253325492143631,-.7826230525970459,-.5686094760894775,.25334617495536804,-.003505319356918335,-.002576306462287903,.9999906420707703,-.003505319356918335,-.002576306462287903,.9999906420707703,-.0041239261627197266,-.001402430236339569,.9999905228614807,-.0041239261627197266,-.001402430236339569,.9999905228614807,-.9200277328491211,-.29894667863845825,.2533373534679413,-.0041457414627075195,.0012131333351135254,.999990701675415,-.0041457414627075195,.0012131333351135254,.999990701675415,-.9200185537338257,.29890307784080505,.2534220814704895,-.0025840699672698975,.003327280282974243,.9999911785125732,-.0025840699672698975,.003327280282974243,.9999911785125732,-.5686099529266357,.7825716137886047,.2535049021244049,.0012101978063583374,.003936886787414551,.9999915361404419,.0012101978063583374,.003936886787414551,.9999915361404419,.2989037334918976,.9199675917625427,.2536064088344574,.0023893117904663086,.003317922353744507,.9999916553497314,.0023893117904663086,.003317922353744507,.9999916553497314,.5685685873031616,.7825725674629211,.2535940706729889,.782572329044342,.5685595870018005,.25361499190330505,.0033287405967712402,.002385169267654419,.9999915361404419,.0033287405967712402,.002385169267654419,.9999915361404419,.003944873809814453,.0012125223875045776,.9999915957450867,.003944873809814453,.0012125223875045776,.9999915957450867,.9199705719947815,.298895001411438,.25360581278800964],normalized:!1},uv:{itemSize:2,type:"Float32Array",array:[.23704378306865692,.023000359535217285,.2962978482246399,.4792518615722656,.5050051212310791,.2502303123474121,.22790862619876862,.021942079067230225,.2874794006347656,.4803285002708435,.017633967101573944,.6739451289176941,.20161525905132294,.1155695915222168,.21026334166526794,.11554199457168579,.23612302541732788,.3868170976638794,.6741329431533813,.48301517963409424,.22747491300106049,.3868447542190552,.17478206753730774,.5167970061302185,.2012992650270462,.3867114782333374,.2101074755191803,.38673484325408936,.17778971791267395,.4792518615722656,.20069445669651031,.47938668727874756,.2504180371761322,.5048181414604187,.16897115111351013,.4803285002708435,.20982962846755981,.4804449677467346,.17686891555786133,.38681697845458984,.3260548710823059,.5167969465255737,.16822080314159393,.3868447542190552,.1423611342906952,.11557012796401978,.9825537800788879,.32586705684661865,.1510092318058014,.11554241180419922,.17778971791267395,.02300053834915161,.3555530905723572,.4792248010635376,.4951818287372589,.7495819330215454,.16865456104278564,.021942198276519775,.34673523902893066,.480310320854187,.3197054862976074,.29629039764404297,.9477878212928772,.1063617467880249,.32840070128440857,.2962949275970459,.35455501079559326,.2964339256286621,.4484367072582245,.8934502601623535,.34586313366889954,.29642730951309204,.31974896788597107,.20592015981674194,.8936383128166199,.0522121787071228,.32843995094299316,.20592659711837769,.32605481147766113,.9823660254478455,.3545942008495331,.11562323570251465,.34578996896743774,.1155862808227539,.2962978482246399,.023000359535217285,.3192167282104492,.023042798042297363,.7497690320014954,.0054662227630615234,.287162721157074,.021942138671875,.32804927229881287,.022000432014465332,.2504180371761322,.9943457245826721,.25994858145713806,.02313518524169922,.3555530905723572,.023087799549102783,.2687670588493347,.022058546543121338,.3464353084564209,.021996140480041504,.295693039894104,.11567586660385132,.6741330623626709,.017446041107177734,.2868848443031311,.11565232276916504,.2953770160675049,.3868170976638794,.5169848203659058,.17459428310394287,.28672900795936584,.3868447542190552,.2364388257265091,.11567533016204834,.5169847011566162,.32586705684661865,.22763070464134216,.11565178632736206,.2276650071144104,.20608502626419067,.23635976016521454,.20609813928604126,.5517510175704956,.39409929513931274,.23622643947601318,.2964661121368408,.6059006452560425,.44824880361557007,.22753484547138214,.2964508533477783,.1414402574300766,.47938668727874756,.23704378306865692,.4792518615722656,.7497687339782715,.49499499797821045,.15057551860809326,.4804449677467346,.2282252460718155,.4803285002708435,.15085339546203613,.38673484325408936,.14204517006874084,.38671135902404785,.8254057765007019,.48301517963409424,.14212429523468018,.29628849029541016,.893638014793396,.4482489228248596,.15081912279129028,.2963016629219055,.1422577202320099,.20592069625854492,.9477876424789429,.39409929513931274,.15094926953315735,.20593607425689697,.14144045114517212,.02313530445098877,.31920260190963745,.4793957471847534,.9945327043533325,.2502301335334778,.15025892853736877,.02205866575241089,.3283390998840332,.4804449677467346,.31971582770347595,.38671642541885376,.9825538992881775,.17459410429000854,.32852432131767273,.38673120737075806,.31976577639579773,.11558306217193604,.8254058957099915,.017445921897888184,.3284158408641815,.11556941270828247,.29561394453048706,.2060987949371338,.6059007048606873,.05221235752105713,.28691911697387695,.2060856819152832,.29548054933547974,.2964667081832886,.5517511963844299,.1063617467880249,.2867889404296875,.29645150899887085,.005654247011989355,.749582052230835,.20069456100463867,.02313518524169922,.25994864106178284,.47938668727874756,.20951306819915771,.022058427333831787,.26908373832702637,.4804449677467346,.05240018665790558,.605712890625,.20151172578334808,.2059200406074524,.21020328998565674,.2059352993965149,.10654976963996887,.5515632033348083,.2013782411813736,.2962881922721863,.2100730687379837,.29630136489868164,.17697232961654663,.29646652936935425,.39428722858428955,.5515631437301636,.16828079521656036,.2964513301849365,.1684110462665558,.20608550310134888,.17710581421852112,.206098735332489,.44843676686286926,.6057127714157104,.1771848499774933,.11567568778991699,.4832030236721039,.6739450693130493,.168376624584198,.11565232276916504,.3545408844947815,.38678765296936035,.4832029938697815,.8252179622650146,.3458925485610962,.3868238925933838,.35459887981414795,.20606255531311035,.3942871689796448,.9475997686386108,.34590303897857666,.2060578465461731,.17478202283382416,.9823660254478455,.2608692944049835,.11557012796401978,.2695173919200897,.11554241180419922,.10654974728822708,.9475998282432556,.26076579093933105,.20592081546783447,.2694574296474457,.20593613386154175,.2693272829055786,.29630184173583984,.05240019038319588,.8934502601623535,.2606324851512909,.2962886691093445,.0176339503377676,.8252179622650146,.26055341958999634,.3867114782333374,.2693616449832916,.38673484325408936],normalized:!1},color:{itemSize:4,type:"Uint16Array",array:[65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535],normalized:!0}},index:{type:"Uint16Array",array:[35,38,32,129,54,126,123,91,38,130,57,97,18,10,13,21,77,72,120,32,88,17,72,70,27,20,103,105,60,7,130,94,129,126,45,50,28,24,117,13,66,108,117,80,112,29,88,85,111,80,77,41,46,91,108,61,105,135,4,57,76,87,44,38,30,32,54,42,45,72,67,70,77,78,75,94,95,92,104,108,105,113,117,112,125,129,126,134,130,132,113,111,109,15,13,12,14,21,17,49,41,40,61,58,60,61,64,62,77,73,72,88,82,85,135,100,102,132,129,128,60,0,3,66,8,64,10,68,8,80,22,78,24,81,22,32,86,88,38,89,36,91,43,89,94,52,54,57,95,97,57,1,55,6,105,7,19,111,21,26,120,29,12,108,107,48,126,50,25,117,115,118,35,120,40,123,121,99,7,101,121,35,33,7,3,101,35,123,38,129,94,54,123,41,91,130,135,57,18,71,10,21,111,77,120,35,32,17,21,72,103,5,131,5,98,131,98,133,131,131,127,124,124,47,131,47,39,131,39,122,27,122,34,27,34,119,27,27,116,114,114,110,20,20,16,103,16,11,103,11,106,103,27,114,20,103,131,39,39,27,103,105,61,60,130,97,94,126,54,45,28,84,24,13,10,66,117,24,80,29,120,88,111,112,80,41,51,46,108,66,61,135,102,4,56,2,65,2,59,65,59,63,65,65,9,69,69,74,76,76,79,87,79,23,87,23,83,87,87,31,37,37,90,44,44,53,93,93,96,44,96,56,44,65,69,76,87,37,44,56,65,44,65,76,44,38,36,30,54,52,42,72,73,67,77,80,78,94,97,95,104,107,108,113,115,117,125,128,129,134,135,130,113,112,111,15,18,13,14,19,21,49,51,41,61,62,58,61,66,64,77,75,73,88,86,82,135,134,100,132,130,129,60,58,0,66,10,8,10,71,68,80,24,22,24,84,81,32,30,86,38,91,89,91,46,43,94,92,52,57,55,95,57,4,1,6,104,105,19,109,111,26,118,120,12,13,108,48,125,126,25,28,117,118,33,35,40,41,123,99,6,7,121,123,35,7,60,3]},boundingSphere:{center:[0,0,0],radius:128.54241934554352}},rotationCombinations:{"1,2":[180,0,0]}},d4:{metadata:{version:4.5,type:"BufferGeometry",generator:"BufferGeometry.toJSON"},uuid:"C5380F7D-1CC8-4744-8B30-2399F5490F2A",type:"BufferGeometry",data:{attributes:{position:{itemSize:3,type:"Float32Array",array:[-67.64075469970703,-67.64099884033203,65.7880630493164,-67.64075469970703,-67.64099884033203,65.7880630493164,-67.64075469970703,-67.64099884033203,65.7880630493164,67.64124298095703,65.7878189086914,67.6407470703125,67.64124298095703,65.7878189086914,67.6407470703125,67.64124298095703,65.7878189086914,67.6407470703125,65.7880630493164,67.64099884033203,67.64075469970703,65.7880630493164,67.64099884033203,67.64075469970703,-67.6412353515625,67.64099884033203,-65.78756713867188,-67.6412353515625,67.64099884033203,-65.78756713867188,-67.6407470703125,-65.7878189086914,67.64124298095703,-67.6407470703125,-65.7878189086914,67.64124298095703,67.6412353515625,67.64099884033203,65.78756713867188,67.6412353515625,67.64099884033203,65.78756713867188,67.6412353515625,67.64099884033203,65.78756713867188,67.64075469970703,-67.64099884033203,-65.7880630493164,67.64075469970703,-67.64099884033203,-65.7880630493164,67.6407470703125,-65.7878189086914,-67.64124298095703,67.6407470703125,-65.7878189086914,-67.64124298095703,65.78756713867188,-67.64099884033203,-67.6412353515625,65.78756713867188,-67.64099884033203,-67.6412353515625,-65.78756713867188,-67.64099884033203,67.6412353515625,-65.78756713867188,-67.64099884033203,67.6412353515625,-65.78756713867188,-67.64099884033203,67.6412353515625,-65.7880630493164,67.64099884033203,-67.64075469970703,-65.7880630493164,67.64099884033203,-67.64075469970703,-65.7880630493164,67.64099884033203,-67.64075469970703,-67.64124298095703,65.7878189086914,-67.6407470703125,-67.64124298095703,65.7878189086914,-67.6407470703125,-67.64124298095703,65.7878189086914,-67.6407470703125],normalized:!1},normal:{itemSize:3,type:"Float32Array",array:[-.5875354409217834,-.5875733494758606,-.5563808679580688,-.5875354409217834,-.5875733494758606,-.5563808679580688,-.5875354409217834,-.5875733494758606,-.5563808679580688,.58754962682724,-.5564354062080383,.5875076055526733,.58754962682724,-.5564354062080383,.5875076055526733,.58754962682724,-.5564354062080383,.5875076055526733,-.5564345121383667,.5875091552734375,.5875489711761475,-.5564345121383667,.5875091552734375,.5875489711761475,-.5875074863433838,.5875474810600281,.5564377903938293,-.5875074863433838,.5875474810600281,.5564377903938293,-.5875458717346191,.5564350485801697,.5875116586685181,-.5875458717346191,.5564350485801697,.5875116586685181,.5875073075294495,.5875475406646729,-.5564377903938293,.5875073075294495,.5875475406646729,-.5564377903938293,.5875073075294495,.5875475406646729,-.5564377903938293,.5875356793403625,-.5875731706619263,.5563808679580688,.5875356793403625,-.5875731706619263,.5563808679580688,.5875458717346191,.5564350485801697,-.5875116586685181,.5875458717346191,.5564350485801697,-.5875116586685181,-.5564398169517517,-.5875092148780823,-.5875437259674072,-.5564398169517517,-.5875092148780823,-.5875437259674072,.5564400553703308,-.5875090956687927,.5875436663627625,.5564400553703308,-.5875090956687927,.5875436663627625,.5564400553703308,-.5875090956687927,.5875436663627625,.5564344525337219,.587509036064148,-.587549090385437,.5564344525337219,.587509036064148,-.587549090385437,.5564344525337219,.587509036064148,-.587549090385437,-.5875496864318848,-.5564355850219727,-.5875071883201599,-.5875496864318848,-.5564355850219727,-.5875071883201599,-.5875496864318848,-.5564355850219727,-.5875071883201599],normalized:!1},uv:{itemSize:2,type:"Float32Array",array:[.20333926379680634,.01598501205444336,.20718662440776825,.23812401294708252,.5022410154342651,.21281301975250244,.20517542958259583,.22700607776641846,.21218715608119965,.009441137313842773,.6251919865608215,.25002896785736084,.12502600252628326,.24997997283935547,.2080860435962677,.01124197244644165,.0021929999347776175,.4627319574356079,.015251883305609226,.12210333347320557,.2076776623725891,.23367196321487427,.24785800278186798,.4627319574356079,.20334681868553162,.22807049751281738,.20728397369384766,.00649791955947876,.49776899814605713,.46269500255584717,.14456242322921753,.12202131748199463,.7480239868164062,.46278202533721924,.14273378252983093,.12308567762374878,.3749360144138336,.24994301795959473,.14272625744342804,.12096989154815674,.625074028968811,6097555160522461e-20,.20517542958259583,.0170363187789917,.21218715608119965,.23534929752349854,.5023589730262756,.46278202533721924,.011641831137239933,.11945211887359619,.021507836878299713,.12308526039123535,.2521030008792877,.46269500255584717,.011544500477612019,.12516993284225464,.021500281989574432,.12096947431564331,.7479060292243958,.21281301975250244],normalized:!1},color:{itemSize:4,type:"Uint16Array",array:[65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535],normalized:!0}},index:{type:"Uint16Array",array:[6,8,11,26,14,18,29,20,2,5,23,16,17,3,15,25,19,28,10,27,1,0,15,21,9,13,24,9,24,27,7,4,13,10,1,22,17,15,19,7,22,4,17,12,3,25,17,19,10,9,27,0,19,15,9,7,13,7,10,22]},boundingSphere:{center:[0,0,0],radius:117.1579285756433}},rotationCombinations:{"1,2":[90,0,90],"1,3":[120,90,150],"1,4":[-180,0,-180],"2,3":[90,0,90],"2,4":[-90,0,-90],"3,4":[-90,0,90]}},d6:{metadata:{version:4.5,type:"BufferGeometry",generator:"BufferGeometry.toJSON"},uuid:"E18C9F5C-7D15-4FF3-AC5E-A4A56A405499",type:"BufferGeometry",data:{attributes:{position:{itemSize:3,type:"Float32Array",array:[52.081398010253906,-49.99797058105469,49.997779846191406,52.081398010253906,-49.99797058105469,49.997779846191406,52.081398010253906,-49.99797058105469,49.997779846191406,52.081398010253906,-49.99797058105469,49.997779846191406,52.081031799316406,49.99797058105469,-49.99816131591797,52.081031799316406,49.99797058105469,-49.99816131591797,52.081031799316406,49.99797058105469,-49.99816131591797,52.081031799316406,49.99797058105469,-49.99816131591797,52.081398010253906,49.99797058105469,49.997779846191406,52.081398010253906,49.99797058105469,49.997779846191406,52.081398010253906,49.99797058105469,49.997779846191406,52.081398010253906,49.99797058105469,49.997779846191406,-52.081031799316406,49.99797058105469,49.99816131591797,-52.081031799316406,49.99797058105469,49.99816131591797,-52.081031799316406,49.99797058105469,49.99816131591797,-52.081031799316406,49.99797058105469,49.99816131591797,49.99778747558594,52.081214904785156,-49.99814987182617,49.99778747558594,52.081214904785156,-49.99814987182617,49.99778747558594,52.081214904785156,-49.99814987182617,49.99778747558594,52.081214904785156,-49.99814987182617,-49.99814987182617,-52.081214904785156,-49.99778747558594,-49.99814987182617,-52.081214904785156,-49.99778747558594,-49.99814987182617,-52.081214904785156,-49.99778747558594,-49.99814987182617,-52.081214904785156,-49.99778747558594,-49.99816131591797,-49.99797058105469,-52.081031799316406,-49.99816131591797,-49.99797058105469,-52.081031799316406,-49.99816131591797,-49.99797058105469,-52.081031799316406,-49.99816131591797,-49.99797058105469,-52.081031799316406,49.99778747558594,-52.081214904785156,-49.99814987182617,49.99778747558594,-52.081214904785156,-49.99814987182617,49.99778747558594,-52.081214904785156,-49.99814987182617,49.99778747558594,-52.081214904785156,-49.99814987182617,-49.99778747558594,-52.081214904785156,49.99814987182617,-49.99778747558594,-52.081214904785156,49.99814987182617,-49.99778747558594,-52.081214904785156,49.99814987182617,-49.99778747558594,-52.081214904785156,49.99814987182617,52.081031799316406,-49.99797058105469,-49.99816131591797,52.081031799316406,-49.99797058105469,-49.99816131591797,52.081031799316406,-49.99797058105469,-49.99816131591797,52.081031799316406,-49.99797058105469,-49.99816131591797,49.997779846191406,-49.99797058105469,-52.081398010253906,49.997779846191406,-49.99797058105469,-52.081398010253906,49.997779846191406,-49.99797058105469,-52.081398010253906,49.997779846191406,-49.99797058105469,-52.081398010253906,-52.081398010253906,-49.99797058105469,-49.997779846191406,-52.081398010253906,-49.99797058105469,-49.997779846191406,-52.081398010253906,-49.99797058105469,-49.997779846191406,-52.081398010253906,-49.99797058105469,-49.997779846191406,-49.99814987182617,52.081214904785156,-49.99778747558594,-49.99814987182617,52.081214904785156,-49.99778747558594,-49.99814987182617,52.081214904785156,-49.99778747558594,-49.99814987182617,52.081214904785156,-49.99778747558594,49.99814987182617,52.081214904785156,49.99778747558594,49.99814987182617,52.081214904785156,49.99778747558594,49.99814987182617,52.081214904785156,49.99778747558594,49.99814987182617,52.081214904785156,49.99778747558594,-49.997779846191406,-49.99797058105469,52.081398010253906,-49.997779846191406,-49.99797058105469,52.081398010253906,-49.997779846191406,-49.99797058105469,52.081398010253906,-49.997779846191406,-49.99797058105469,52.081398010253906,-49.99778747558594,52.081214904785156,49.99814987182617,-49.99778747558594,52.081214904785156,49.99814987182617,-49.99778747558594,52.081214904785156,49.99814987182617,-49.99778747558594,52.081214904785156,49.99814987182617,49.99816131591797,49.99797058105469,52.081031799316406,49.99816131591797,49.99797058105469,52.081031799316406,49.99816131591797,49.99797058105469,52.081031799316406,49.99816131591797,49.99797058105469,52.081031799316406,49.99814987182617,-52.081214904785156,49.99778747558594,49.99814987182617,-52.081214904785156,49.99778747558594,49.99814987182617,-52.081214904785156,49.99778747558594,49.99814987182617,-52.081214904785156,49.99778747558594,49.99816131591797,-49.99797058105469,52.081031799316406,49.99816131591797,-49.99797058105469,52.081031799316406,49.99816131591797,-49.99797058105469,52.081031799316406,49.99816131591797,-49.99797058105469,52.081031799316406,-52.081031799316406,-49.99797058105469,49.99816131591797,-52.081031799316406,-49.99797058105469,49.99816131591797,-52.081031799316406,-49.99797058105469,49.99816131591797,-52.081031799316406,-49.99797058105469,49.99816131591797,49.997779846191406,49.99797058105469,-52.081398010253906,49.997779846191406,49.99797058105469,-52.081398010253906,49.997779846191406,49.99797058105469,-52.081398010253906,49.997779846191406,49.99797058105469,-52.081398010253906,-49.99816131591797,49.99797058105469,-52.081031799316406,-49.99816131591797,49.99797058105469,-52.081031799316406,-49.99816131591797,49.99797058105469,-52.081031799316406,-49.99816131591797,49.99797058105469,-52.081031799316406,-52.081398010253906,49.99797058105469,-49.997779846191406,-52.081398010253906,49.99797058105469,-49.997779846191406,-52.081398010253906,49.99797058105469,-49.997779846191406,-52.081398010253906,49.99797058105469,-49.997779846191406,-49.997779846191406,49.99797058105469,52.081398010253906,-49.997779846191406,49.99797058105469,52.081398010253906,-49.997779846191406,49.99797058105469,52.081398010253906,-49.997779846191406,49.99797058105469,52.081398010253906],normalized:!1},normal:{itemSize:3,type:"Float32Array",array:[.9995923042297363,-.020230919122695923,.020147494971752167,.9995923042297363,-.020230919122695923,.020147494971752167,.9995923042297363,-.020230919122695923,.020147494971752167,.9995923042297363,-.020230919122695923,.020147494971752167,.9995908737182617,.02024438977241516,-.020207354798913002,.9995908737182617,.02024438977241516,-.020207354798913002,.9995908737182617,.02024438977241516,-.020207354798913002,.9995908737182617,.02024438977241516,-.020207354798913002,.9995913505554199,.020214110612869263,.020209431648254395,.9995913505554199,.020214110612869263,.020209431648254395,.9995913505554199,.020214110612869263,.020209431648254395,.9995913505554199,.020214110612869263,.020209431648254395,-.9995912313461304,.020234376192092896,.020197225734591484,-.9995912313461304,.020234376192092896,.020197225734591484,-.9995912313461304,.020234376192092896,.020197225734591484,-.9995912313461304,.020234376192092896,.020197225734591484,.02019399404525757,.9995913505554199,-.02023378014564514,.02019399404525757,.9995913505554199,-.02023378014564514,.02019399404525757,.9995913505554199,-.02023378014564514,.02019399404525757,.9995913505554199,-.02023378014564514,-.02023431658744812,-.9995909333229065,-.020213313400745392,-.02023431658744812,-.9995909333229065,-.020213313400745392,-.02023431658744812,-.9995909333229065,-.020213313400745392,-.02023431658744812,-.9995909333229065,-.020213313400745392,-.02021673321723938,-.02017366886138916,-.9995919466018677,-.02021673321723938,-.02017366886138916,-.9995919466018677,-.02021673321723938,-.02017366886138916,-.9995919466018677,-.02021673321723938,-.02017366886138916,-.9995919466018677,.020203232765197754,-.9995912909507751,-.020224466919898987,.020203232765197754,-.9995912909507751,-.020224466919898987,.020203232765197754,-.9995912909507751,-.020224466919898987,.020203232765197754,-.9995912909507751,-.020224466919898987,-.020203210413455963,-.9995913505554199,.02022451162338257,-.020203210413455963,-.9995913505554199,.02022451162338257,-.020203210413455963,-.9995913505554199,.02022451162338257,-.020203210413455963,-.9995913505554199,.02022451162338257,.9995921850204468,-.020173730328679085,-.020216643810272217,.9995921850204468,-.020173730328679085,-.020216643810272217,.9995921850204468,-.020173730328679085,-.020216643810272217,.9995921850204468,-.020173730328679085,-.020216643810272217,.020147576928138733,-.020230591297149658,-.9995923042297363,.020147576928138733,-.020230591297149658,-.9995923042297363,.020147576928138733,-.020230591297149658,-.9995923042297363,.020147576928138733,-.020230591297149658,-.9995923042297363,-.9995916485786438,-.020208656787872314,-.020204007625579834,-.9995916485786438,-.020208656787872314,-.020204007625579834,-.9995916485786438,-.020208656787872314,-.020204007625579834,-.9995916485786438,-.020208656787872314,-.020204007625579834,-.02024361491203308,.9995908737182617,-.02020406536757946,-.02024361491203308,.9995908737182617,-.02020406536757946,-.02024361491203308,.9995908737182617,-.02020406536757946,-.02024361491203308,.9995908737182617,-.02020406536757946,.02026575803756714,.9995908141136169,.020181983709335327,.02026575803756714,.9995908141136169,.020181983709335327,.02026575803756714,.9995908141136169,.020181983709335327,.02026575803756714,.9995908141136169,.020181983709335327,-.020204126834869385,-.020208358764648438,.9995917081832886,-.020204126834869385,-.020208358764648438,.9995917081832886,-.020204126834869385,-.020208358764648438,.9995917081832886,-.020204126834869385,-.020208358764648438,.9995917081832886,-.02021375298500061,.9995914101600647,.020213931798934937,-.02021375298500061,.9995914101600647,.020213931798934937,-.02021375298500061,.9995914101600647,.020213931798934937,-.02021375298500061,.9995914101600647,.020213931798934937,.020197970792651176,.020234346389770508,.9995912313461304,.020197970792651176,.020234346389770508,.9995912313461304,.020197970792651176,.020234346389770508,.9995912313461304,.020197970792651176,.020234346389770508,.9995912313461304,.02023431658744812,-.9995909333229065,.020213313400745392,.02023431658744812,-.9995909333229065,.020213313400745392,.02023431658744812,-.9995909333229065,.020213313400745392,.02023431658744812,-.9995909333229065,.020213313400745392,.020256830379366875,-.020169764757156372,.9995912909507751,.020256830379366875,-.020169764757156372,.9995912909507751,.020256830379366875,-.020169764757156372,.9995912909507751,.020256830379366875,-.020169764757156372,.9995912909507751,-.9995914101600647,-.02016991376876831,.020256860181689262,-.9995914101600647,-.02016991376876831,.020256860181689262,-.9995914101600647,-.02016991376876831,.020256860181689262,-.9995914101600647,-.02016991376876831,.020256860181689262,.02021026611328125,.020213961601257324,-.9995913505554199,.02021026611328125,.020213961601257324,-.9995913505554199,.02021026611328125,.020213961601257324,-.9995913505554199,.02021026611328125,.020213961601257324,-.9995913505554199,-.02020804025232792,.020244628190994263,-.9995906949043274,-.02020804025232792,.020244628190994263,-.9995906949043274,-.02020804025232792,.020244628190994263,-.9995906949043274,-.02020804025232792,.020244628190994263,-.9995906949043274,-.9995908737182617,.020204482600092888,-.020239561796188354,-.9995908737182617,.020204482600092888,-.020239561796188354,-.9995908737182617,.020204482600092888,-.020239561796188354,-.9995908737182617,.020204482600092888,-.020239561796188354,-.020240217447280884,.020204216241836548,.9995909929275513,-.020240217447280884,.020204216241836548,.9995909929275513,-.020240217447280884,.020204216241836548,.9995909929275513,-.020240217447280884,.020204216241836548,.9995909929275513],normalized:!1},uv:{itemSize:2,type:"Float32Array",array:[.002862999914214015,.7471370100975037,.07257817685604095,.00783926248550415,.20479217171669006,.24324274063110352,.23563209176063538,.18311190605163574,.16701677441596985,.007843196392059326,.21674437820911407,.007843255996704102,.23563209176063538,.23977500200271606,.24713699519634247,.5028629899024963,.002862999914214015,.5028629899024963,.16701683402061462,.24324274063110352,.20479217171669006,.007843196392059326,.2416384220123291,.12991642951965332,.12230584025382996,.24324274063110352,.14119352400302887,.007843255996704102,.24163848161697388,.2243550419807434,.2481130063533783,.4981130361557007,.11035363376140594,.007843255996704102,.16008129715919495,.007843196392059326,.2416384220123291,.23630714416503906,.4975059926509857,.7470999956130981,.008979067206382751,.00783926248550415,.02786727249622345,.24324274063110352,.2416384220123291,.20546722412109375,.7475240230560303,.002879023551940918,.034802429378032684,.24324274063110352,.08453041315078735,.24324274063110352,.23563209176063538,.20199954509735107,.4974119961261749,.49670398235321045,.027866892516613007,.00783926248550415,.06564302742481232,.24324274063110352,.2416384220123291,.1607564091682434,.5032510161399841,.002879023551940918,.008979566395282745,.24324274063110352,.046754732728004456,.00783926248550415,.2416384220123291,.11102879047393799,.7475240230560303,.24715197086334229,.07257817685604095,.24324274063110352,.21674437820911407,.24324274063110352,.2416384220123291,.1676918864250183,.24713699519634247,.7471370100975037,.03480251133441925,.00783926248550415,.22367990016937256,.24324274063110352,.23563209176063538,.16422414779663086,.2531389892101288,.49670398235321045,.0038399999029934406,.25383996963500977,.015914686024188995,.00783926248550415,.09146587550640106,.24324274063110352,.2416384220123291,.19853174686431885,.11035363376140594,.24324274063110352,.12924134731292725,.007843255996704102,.2416384220123291,.1488041877746582,.4975059926509857,.5028259754180908,.16008129715919495,.24324274063110352,.17896901071071625,.007843196392059326,.2416384220123291,.12298095226287842,.2532320022583008,.7470999956130981,.0536903440952301,.00783926248550415,.14812909066677094,.24324274063110352,.2416384220123291,.10409331321716309,.5033630132675171,.252979040145874,.12924134731292725,.24324274063110352,.17896901071071625,.24324274063110352,.23563209176063538,.22088712453842163,.2532320022583008,.5028259754180908,.18590447306632996,.007843196392059326,.19785669445991516,.007843196392059326,.23563209176063538,.12644875049591064,.7476369738578796,.4972519874572754,.046755194664001465,.24324274063110352,.06564256548881531,.00783926248550415,.2416384220123291,.17964410781860352,.5032510161399841,.24715197086334229,.0536903440952301,.24324274063110352,.19785669445991516,.24324274063110352,.2416384220123291,.18657952547073364,.5033630132675171,.4972519874572754,.0038399999029934406,.4981130361557007,.015914715826511383,.24324274063110352,.14119356870651245,.24324274063110352,.23563209176063538,.10756111145019531,.10341811925172806,.007843255996704102,.22367990016937256,.007843255996704102,.2416384220123291,.24324274063110352,.2531389892101288,.2524310350418091,.08453038334846497,.007843196392059326,.10341812670230865,.24324274063110352,.2416384220123291,.14186859130859375,.4974119961261749,.2524310350418091,.09146586060523987,.007843196392059326,.12230582535266876,.007843255996704102,.23563209176063538,.14533644914627075,.2481130063533783,.25383996963500977,.14812903106212616,.007843255996704102,.18590447306632996,.24324274063110352,.24163848161697388,.21741944551467896,.7476369738578796,.252979040145874],normalized:!1},color:{itemSize:4,type:"Uint16Array",array:[65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535],normalized:!0}},index:{type:"Uint16Array",array:[83,27,87,8,39,7,44,15,91,59,67,95,63,19,51,13,57,92,1,29,36,56,68,72,40,21,24,80,48,16,45,32,77,41,5,37,89,60,49,84,46,88,2,65,73,93,53,61,9,17,52,70,3,74,30,42,38,22,47,26,34,58,79,11,54,66,82,18,6,86,90,50,14,94,62,31,35,23,83,43,27,8,0,39,44,76,15,59,75,67,63,55,19,13,78,57,1,69,29,56,33,68,40,28,21,80,85,48,45,20,32,41,81,5,89,12,60,84,25,46,2,10,65,93,64,53,9,4,17,31,71,35]},boundingSphere:{center:[0,0,0],radius:90.20752176710862}},rotationCombinations:{"1,2":[0,0,90],"1,3":[-90,0,0],"1,4":[90,0,0],"1,5":[0,0,-90],"1,6":[180,0,0],"2,3":[0,90,0],"2,4":[0,-90,0],"2,5":[0,0,180],"2,6":[0,0,90],"3,4":[-180,0,-180],"3,5":[0,90,0],"3,6":[-90,0,0],"4,5":[180,-90,180],"4,6":[90,0,0],"5,6":[0,0,-90]}},d8:{metadata:{version:4.5,type:"BufferGeometry",generator:"BufferGeometry.toJSON"},uuid:"F0A476BC-C144-4BC6-A327-5E00064C485A",type:"BufferGeometry",data:{attributes:{position:{itemSize:3,type:"Float32Array",array:[-1.1684173345565796,1.168058156967163,-97.7831802368164,-1.1684173345565796,1.168058156967163,-97.7831802368164,-1.1684173345565796,1.168058156967163,-97.7831802368164,-1.1684173345565796,1.168058156967163,-97.7831802368164,-97.7831802368164,1.168058156967163,1.1684173345565796,-97.7831802368164,1.168058156967163,1.1684173345565796,-97.7831802368164,1.168058156967163,1.1684173345565796,-97.7831802368164,1.168058156967163,1.1684173345565796,-1.167698860168457,-1.168058156967163,97.7831802368164,-1.167698860168457,-1.168058156967163,97.7831802368164,-1.167698860168457,-1.168058156967163,97.7831802368164,-1.167698860168457,-1.168058156967163,97.7831802368164,-97.7831802368164,-1.168058156967163,1.1684173345565796,-97.7831802368164,-1.168058156967163,1.1684173345565796,-97.7831802368164,-1.168058156967163,1.1684173345565796,-97.7831802368164,-1.168058156967163,1.1684173345565796,-1.1680537462234497,97.7831802368164,1.168062448501587,-1.1680537462234497,97.7831802368164,1.168062448501587,-1.1680537462234497,97.7831802368164,1.168062448501587,-1.1680537462234497,97.7831802368164,1.168062448501587,-97.7831802368164,1.168058156967163,-1.167698860168457,-97.7831802368164,1.168058156967163,-1.167698860168457,-97.7831802368164,1.168058156967163,-1.167698860168457,-97.7831802368164,1.168058156967163,-1.167698860168457,-1.168062448501587,97.7831802368164,-1.1680537462234497,-1.168062448501587,97.7831802368164,-1.1680537462234497,-1.168062448501587,97.7831802368164,-1.1680537462234497,-1.168062448501587,97.7831802368164,-1.1680537462234497,97.7831802368164,-1.168058156967163,-1.1684173345565796,97.7831802368164,-1.168058156967163,-1.1684173345565796,97.7831802368164,-1.168058156967163,-1.1684173345565796,97.7831802368164,-1.168058156967163,-1.1684173345565796,1.167698860168457,-1.168058156967163,-97.7831802368164,1.167698860168457,-1.168058156967163,-97.7831802368164,1.167698860168457,-1.168058156967163,-97.7831802368164,1.167698860168457,-1.168058156967163,-97.7831802368164,1.167698860168457,1.168058156967163,-97.7831802368164,1.167698860168457,1.168058156967163,-97.7831802368164,1.167698860168457,1.168058156967163,-97.7831802368164,1.167698860168457,1.168058156967163,-97.7831802368164,1.1680537462234497,97.7831802368164,-1.168062448501587,1.1680537462234497,97.7831802368164,-1.168062448501587,1.1680537462234497,97.7831802368164,-1.168062448501587,1.1680537462234497,97.7831802368164,-1.168062448501587,97.7831802368164,1.168058156967163,1.167698860168457,97.7831802368164,1.168058156967163,1.167698860168457,97.7831802368164,1.168058156967163,1.167698860168457,97.7831802368164,1.168058156967163,1.167698860168457,-1.168062448501587,-97.7831802368164,-1.1680537462234497,-1.168062448501587,-97.7831802368164,-1.1680537462234497,-1.168062448501587,-97.7831802368164,-1.1680537462234497,-1.168062448501587,-97.7831802368164,-1.1680537462234497,-97.7831802368164,-1.168058156967163,-1.167698860168457,-97.7831802368164,-1.168058156967163,-1.167698860168457,-97.7831802368164,-1.168058156967163,-1.167698860168457,-97.7831802368164,-1.168058156967163,-1.167698860168457,97.7831802368164,-1.168058156967163,1.167698860168457,97.7831802368164,-1.168058156967163,1.167698860168457,97.7831802368164,-1.168058156967163,1.167698860168457,97.7831802368164,-1.168058156967163,1.167698860168457,-1.167698860168457,1.168058156967163,97.7831802368164,-1.167698860168457,1.168058156967163,97.7831802368164,-1.167698860168457,1.168058156967163,97.7831802368164,-1.167698860168457,1.168058156967163,97.7831802368164,1.168062448501587,-97.7831802368164,1.1680537462234497,1.168062448501587,-97.7831802368164,1.1680537462234497,1.168062448501587,-97.7831802368164,1.1680537462234497,1.168062448501587,-97.7831802368164,1.1680537462234497,1.1684173345565796,-1.168058156967163,97.7831802368164,1.1684173345565796,-1.168058156967163,97.7831802368164,1.1684173345565796,-1.168058156967163,97.7831802368164,1.1684173345565796,-1.168058156967163,97.7831802368164,-1.1684173345565796,-1.168058156967163,-97.7831802368164,-1.1684173345565796,-1.168058156967163,-97.7831802368164,-1.1684173345565796,-1.168058156967163,-97.7831802368164,-1.1684173345565796,-1.168058156967163,-97.7831802368164,1.1684173345565796,1.168058156967163,97.7831802368164,1.1684173345565796,1.168058156967163,97.7831802368164,1.1684173345565796,1.168058156967163,97.7831802368164,1.1684173345565796,1.168058156967163,97.7831802368164,97.7831802368164,1.168058156967163,-1.1684173345565796,97.7831802368164,1.168058156967163,-1.1684173345565796,97.7831802368164,1.168058156967163,-1.1684173345565796,97.7831802368164,1.168058156967163,-1.1684173345565796,1.168062448501587,97.7831802368164,1.1680537462234497,1.168062448501587,97.7831802368164,1.1680537462234497,1.168062448501587,97.7831802368164,1.1680537462234497,1.168062448501587,97.7831802368164,1.1680537462234497,-1.1680537462234497,-97.7831802368164,1.168062448501587,-1.1680537462234497,-97.7831802368164,1.168062448501587,-1.1680537462234497,-97.7831802368164,1.168062448501587,-1.1680537462234497,-97.7831802368164,1.168062448501587,1.1680537462234497,-97.7831802368164,-1.168062448501587,1.1680537462234497,-97.7831802368164,-1.168062448501587,1.1680537462234497,-97.7831802368164,-1.168062448501587,1.1680537462234497,-97.7831802368164,-1.168062448501587],normalized:!1},normal:{itemSize:3,type:"Float32Array",array:[-.5682533383369446,.5682891607284546,-.5950928330421448,-.5682533383369446,.5682891607284546,-.5950928330421448,-.5682533383369446,.5682891607284546,-.5950928330421448,-.5682533383369446,.5682891607284546,-.5950928330421448,-.5951133966445923,.568278431892395,.5682425498962402,-.5951133966445923,.568278431892395,.5682425498962402,-.5951133966445923,.568278431892395,.5682425498962402,-.5951133966445923,.568278431892395,.5682425498962402,-.5682530999183655,-.5682904720306396,.5950918197631836,-.5682530999183655,-.5682904720306396,.5950918197631836,-.5682530999183655,-.5682904720306396,.5950918197631836,-.5682530999183655,-.5682904720306396,.5950918197631836,-.5950893759727478,-.5682545304298401,.5682916045188904,-.5950893759727478,-.5682545304298401,.5682916045188904,-.5950893759727478,-.5682545304298401,.5682916045188904,-.5950893759727478,-.5682545304298401,.5682916045188904,-.5682390332221985,.5951166152954102,.5682786107063293,-.5682390332221985,.5951166152954102,.5682786107063293,-.5682390332221985,.5951166152954102,.5682786107063293,-.5682390332221985,.5951166152954102,.5682786107063293,-.5951080918312073,.5682451725006104,-.5682812929153442,-.5951080918312073,.5682451725006104,-.5682812929153442,-.5951080918312073,.5682451725006104,-.5682812929153442,-.5951080918312073,.5682451725006104,-.5682812929153442,-.5682910680770874,.5950912833213806,-.5682533383369446,-.5682910680770874,.5950912833213806,-.5682533383369446,-.5682910680770874,.5950912833213806,-.5682533383369446,-.5682910680770874,.5950912833213806,-.5682533383369446,.595115065574646,-.5682411789894104,-.5682781934738159,.595115065574646,-.5682411789894104,-.5682781934738159,.595115065574646,-.5682411789894104,-.5682781934738159,.595115065574646,-.5682411789894104,-.5682781934738159,.5682530999183655,-.5682904720306396,-.5950918197631836,.5682530999183655,-.5682904720306396,-.5950918197631836,.5682530999183655,-.5682904720306396,-.5950918197631836,.5682530999183655,-.5682904720306396,-.5950918197631836,.5682830810546875,.5682469010353088,-.5951048731803894,.5682830810546875,.5682469010353088,-.5951048731803894,.5682830810546875,.5682469010353088,-.5951048731803894,.5682830810546875,.5682469010353088,-.5951048731803894,.5682392716407776,.5951164960861206,-.5682784914970398,.5682392716407776,.5951164960861206,-.5682784914970398,.5682392716407776,.5951164960861206,-.5682784914970398,.5682392716407776,.5951164960861206,-.5682784914970398,.5951049327850342,.5682469010353088,.5682830214500427,.5951049327850342,.5682469010353088,.5682830214500427,.5951049327850342,.5682469010353088,.5682830214500427,.5951049327850342,.5682469010353088,.5682830214500427,-.5682423114776611,-.5951160788536072,-.5682759881019592,-.5682423114776611,-.5951160788536072,-.5682759881019592,-.5682423114776611,-.5951160788536072,-.5682759881019592,-.5682423114776611,-.5951160788536072,-.5682759881019592,-.595117449760437,-.5682770609855652,-.568239688873291,-.595117449760437,-.5682770609855652,-.568239688873291,-.595117449760437,-.5682770609855652,-.568239688873291,-.595117449760437,-.5682770609855652,-.568239688873291,.5950918197631836,-.5682904720306396,.5682530999183655,.5950918197631836,-.5682904720306396,.5682530999183655,.5950918197631836,-.5682904720306396,.5682530999183655,.5950918197631836,-.5682904720306396,.5682530999183655,-.5682830810546875,.5682469010353088,.5951048731803894,-.5682830810546875,.5682469010353088,.5951048731803894,-.5682830810546875,.5682469010353088,.5951048731803894,-.5682830810546875,.5682469010353088,.5951048731803894,.5682426691055298,-.5951159000396729,.5682759284973145,.5682426691055298,-.5951159000396729,.5682759284973145,.5682426691055298,-.5951159000396729,.5682759284973145,.5682426691055298,-.5951159000396729,.5682759284973145,.5682781934738159,-.5682411193847656,.595115065574646,.5682781934738159,-.5682411193847656,.595115065574646,.5682781934738159,-.5682411193847656,.595115065574646,.5682781934738159,-.5682411193847656,.595115065574646,-.5682781934738159,-.5682411193847656,-.595115065574646,-.5682781934738159,-.5682411193847656,-.595115065574646,-.5682781934738159,-.5682411193847656,-.595115065574646,-.5682781934738159,-.5682411193847656,-.595115065574646,.5682533383369446,.5682891607284546,.5950928330421448,.5682533383369446,.5682891607284546,.5950928330421448,.5682533383369446,.5682891607284546,.5950928330421448,.5682533383369446,.5682891607284546,.5950928330421448,.5950928330421448,.5682891607284546,-.5682533383369446,.5950928330421448,.5682891607284546,-.5682533383369446,.5950928330421448,.5682891607284546,-.5682533383369446,.5950928330421448,.5682891607284546,-.5682533383369446,.5682913064956665,.595090925693512,.5682531595230103,.5682913064956665,.595090925693512,.5682531595230103,.5682913064956665,.595090925693512,.5682531595230103,.5682913064956665,.595090925693512,.5682531595230103,-.5682886838912964,-.5950911641120911,.5682557225227356,-.5682886838912964,-.5950911641120911,.5682557225227356,-.5682886838912964,-.5950911641120911,.5682557225227356,-.5682886838912964,-.5950911641120911,.5682557225227356,.5682889819145203,-.5950908660888672,-.5682554841041565,.5682889819145203,-.5950908660888672,-.5682554841041565,.5682889819145203,-.5950908660888672,-.5682554841041565,.5682889819145203,-.5950908660888672,-.5682554841041565],normalized:!1},uv:{itemSize:2,type:"Float32Array",array:[.07201391458511353,.011956751346588135,.1601339429616928,.228448748588562,.2343699038028717,.15436840057373047,.9927999973297119,.452796995639801,.14628882706165314,.22844743728637695,.213005930185318,.228448748588562,.23062995076179504,.19327861070632935,.3759610056877136,.5007950067520142,.036765892058610916,.011956632137298584,.2167847901582718,.011955499649047852,.2343699038028717,.13678330183029175,.9929670095443726,.2016180157661438,.1286647915840149,.011955201625823975,.2167847901582718,.22844743728637695,.23062995076179504,.1895385980606079,.8765519857406616,-1895427703857422e-20,.14628879725933075,.011955201625823975,.19916081428527832,.22844743728637695,.23062995076179504,.20712369680404663,.49237701296806335,.7024319767951965,.14250995218753815,.228448748588562,.1601339429616928,.011956632137298584,.2343699038028717,.19327861070632935,.876384973526001,.25116002559661865,.07201394438743591,.228448748588562,.14250992238521576,.011956632137298584,.2343699038028717,.20712369680404663,.7599689960479736,.452796995639801,.022920722141861916,.011955201625823975,.18153679370880127,.22844743728637695,.23062995076179504,.22470879554748535,.6253160238265991,.0010759830474853516,.08963792026042938,.011956632137298584,.18153676390647888,.011955499649047852,.23062995076179504,.15810835361480713,.7397840023040771,.19933903217315674,.00919399969279766,.7025139927864075,.07579275965690613,.011955320835113525,.17775794863700867,.011956751346588135,.23062995076179504,.15436840057373047,.07579278945922852,.22844737768173218,.10726193338632584,.228448748588562,.2343699038028717,.21086370944976807,.2420250028371811,.7025139927864075,.05816878750920296,.22844743728637695,.11104078590869904,.011955320835113525,.2343699038028717,.228448748588562,.6256870031356812,.2503969669342041,.09341679513454437,.22844743728637695,.1248859316110611,.228448748588562,.2343699038028717,.17195343971252441,.49275800585746765,.4534569978713989,.12488594651222229,.011956632137298584,.1639128178358078,.011955201625823975,.2343699038028717,.1895385980606079,.37544700503349304,.25026899576187134,.019141869619488716,.011956572532653809,.05438993498682976,.228448748588562,.12524299323558807,.2504919767379761,.2343699038028717,.22470879554748535,.19916081428527832,.011955499649047852,.2130059003829956,.011956751346588135,.2343699038028717,.1405232548713684,.2595460116863251,.7024319767951965,.019141899421811104,.228448748588562,.0405447743833065,.22844743728637695,.23062995076179504,.17569351196289062,.2416590005159378,.4521290063858032,.008828000165522099,.4521290063858032,.040544744580984116,.011955201625823975,.05438990518450737,.011956632137298584,.23062992095947266,.13678330183029175,.09341679513454437,.011955201625823975,.1639127880334854,.22844743728637695,.2343699038028717,.15810835361480713,.2581369876861572,.4534569978713989,.05816878750920296,.01195526123046875,.19538196921348572,.011956751346588135,.23062992095947266,.14052319526672363,.7421020269393921,.45203500986099243,.10726191848516464,.011956751346588135,.12560999393463135,.5008770227432251,.17775794863700867,.228448748588562,.23062995076179504,.228448748588562,.11104080080986023,.22844737768173218,.19538193941116333,.228448748588562,.23062995076179504,.21086370944976807,.5092710256576538,.45203500986099243,.036765921860933304,.228448748588562,.1286647915840149,.22844737768173218,.2343699038028717,.17569351196289062,.7601360082626343,.2016180157661438,.022920751944184303,.22844743728637695,.08963793516159058,.228448748588562,.23062995076179504,.17195343971252441,.5108489990234375,.19933903217315674],normalized:!1},color:{itemSize:4,type:"Uint16Array",array:[65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535],normalized:!0}},index:{type:"Uint16Array",array:[3,23,27,36,43,81,35,31,95,75,51,55,79,47,87,63,19,7,11,15,91,68,67,58,60,85,17,30,46,59,92,56,64,6,54,14,37,24,40,45,41,84,32,48,72,16,20,4,42,18,86,50,66,90,52,89,12,61,13,9,74,39,34,71,62,10,38,29,33,21,73,53,8,65,69,44,70,57,60,77,85,30,83,46,92,28,56,6,22,54,37,0,24,45,80,41,32,93,48,16,25,20,42,26,18,50,94,66,52,49,89,61,5,13,74,2,39,71,78,62,38,82,29,21,1,73,8,88,65,44,76,70]},boundingSphere:{center:[0,0,0],radius:169.36543629583093}},rotationCombinations:{"1,2":[180,0,180],"1,3":[90,0,0],"1,4":[0,0,90],"1,5":[-180,0,0],"1,6":[0,0,180],"1,7":[-90,0,0],"1,8":[90,0,180],"2,3":[90,0,180],"2,4":[-90,0,0],"2,5":[0,0,180],"2,6":[-180,0,0],"2,7":[-90,0,-180],"2,8":[90,0,0],"3,4":[-180,0,180],"3,5":[90,0,0],"3,6":[-90,0,-180],"3,7":[-180,0,0],"3,8":[0,0,180],"4,5":[90,0,180],"4,6":[-90,0,0],"4,7":[0,0,-180],"4,8":[180,0,0],"5,6":[-180,0,-180],"5,7":[90,0,0],"5,8":[-90,0,180],"6,7":[90,0,-180],"6,8":[-90,0,0],"7,8":[-180,0,-180]}},d10:{metadata:{version:4.5,type:"BufferGeometry",generator:"BufferGeometry.toJSON"},uuid:"1B9B60ED-6BEC-48CC-8EB9-EEFFC2DD3ED8",type:"BufferGeometry",data:{attributes:{position:{itemSize:3,type:"Float32Array",array:[-2.5946993827819824,1.8790435791015625,86.0141830444336,-2.5946993827819824,1.8790435791015625,86.0141830444336,-2.5946993827819824,1.8790435791015625,86.0141830444336,-2.5946993827819824,1.8790435791015625,86.0141830444336,71.31939697265625,-49.49197769165039,10.200661659240723,71.31939697265625,-49.49197769165039,10.200661659240723,71.31939697265625,-49.49197769165039,10.200661659240723,71.31939697265625,-49.49197769165039,10.200661659240723,87.39810180664062,-.005702871363610029,-7.479601860046387,87.39810180664062,-.005702871363610029,-7.479601860046387,87.39810180664062,-.005702871363610029,-7.479601860046387,87.39810180664062,-.005702871363610029,-7.479601860046387,3.2070045471191406,-.005997277796268463,86.01419830322266,3.2070045471191406,-.005997277796268463,86.01419830322266,3.2070045471191406,-.005997277796268463,86.01419830322266,3.2070045471191406,-.005997277796268463,86.01419830322266,-28.610445022583008,-81.96196746826172,10.200666427612305,-28.610445022583008,-81.96196746826172,10.200666427612305,-28.610445022583008,-81.96196746826172,10.200666427612305,-28.610445022583008,-81.96196746826172,10.200666427612305,69.1033706665039,-52.5421257019043,10.200669288635254,69.1033706665039,-52.5421257019043,10.200669288635254,69.1033706665039,-52.5421257019043,10.200669288635254,69.1033706665039,-52.5421257019043,10.200669288635254,.9909778237342834,-3.0561423301696777,86.01419830322266,.9909778237342834,-3.0561423301696777,86.01419830322266,.9909778237342834,-3.0561423301696777,86.01419830322266,.9909778237342834,-3.0561423301696777,86.01419830322266,70.70691680908203,-51.37708282470703,7.479945659637451,70.70691680908203,-51.37708282470703,7.479945659637451,70.70691680908203,-51.37708282470703,7.479945659637451,70.70691680908203,-51.37708282470703,7.479945659637451,-25.02603530883789,83.11405944824219,10.200100898742676,-25.02603530883789,83.11405944824219,10.200100898742676,-25.02603530883789,83.11405944824219,10.200100898742676,-25.02603530883789,83.11405944824219,10.200100898742676,-69.10337829589844,52.52949142456055,-10.200671195983887,-69.10337829589844,52.52949142456055,-10.200671195983887,-69.10337829589844,52.52949142456055,-10.200671195983887,-69.10337829589844,52.52949142456055,-10.200671195983887,-86.7856216430664,1.8781644105911255,10.200315475463867,-86.7856216430664,1.8781644105911255,10.200315475463867,-86.7856216430664,1.8781644105911255,10.200315475463867,-86.7856216430664,1.8781644105911255,10.200315475463867,-28.611663818359375,81.948974609375,10.200101852416992,-28.611663818359375,81.948974609375,10.200101852416992,-28.611663818359375,81.948974609375,10.200101852416992,-28.611663818359375,81.948974609375,10.200101852416992,-27.008115768432617,83.1140365600586,7.479378700256348,-27.008115768432617,83.1140365600586,7.479378700256348,-27.008115768432617,83.1140365600586,7.479378700256348,-27.008115768432617,83.1140365600586,7.479378700256348,-70.70691680908203,51.364444732666016,-7.479947566986084,-70.70691680908203,51.364444732666016,-7.479947566986084,-70.70691680908203,51.364444732666016,-7.479947566986084,-70.70691680908203,51.364444732666016,-7.479947566986084,71.31866455078125,49.48046112060547,10.200318336486816,71.31866455078125,49.48046112060547,10.200318336486816,71.31866455078125,49.48046112060547,10.200318336486816,71.31866455078125,49.48046112060547,10.200318336486816,86.78557586669922,1.8793641328811646,-10.20033073425293,86.78557586669922,1.8793641328811646,-10.20033073425293,86.78557586669922,1.8793641328811646,-10.20033073425293,86.78557586669922,1.8793641328811646,-10.20033073425293,69.10259246826172,52.53056716918945,10.20030689239502,69.10259246826172,52.53056716918945,10.20030689239502,69.10259246826172,52.53056716918945,10.20030689239502,69.10259246826172,52.53056716918945,10.20030689239502,70.7061538696289,51.36553192138672,7.479590892791748,70.7061538696289,51.36553192138672,7.479590892791748,70.7061538696289,51.36553192138672,7.479590892791748,70.7061538696289,51.36553192138672,7.479590892791748,2.5946712493896484,1.8784899711608887,-86.01419830322266,2.5946712493896484,1.8784899711608887,-86.01419830322266,2.5946712493896484,1.8784899711608887,-86.01419830322266,2.5946712493896484,1.8784899711608887,-86.01419830322266,28.610443115234375,81.9493408203125,-10.200669288635254,28.610443115234375,81.9493408203125,-10.200669288635254,28.610443115234375,81.9493408203125,-10.200669288635254,28.610443115234375,81.9493408203125,-10.200669288635254,86.78562927246094,-1.8908008337020874,-10.2003173828125,86.78562927246094,-1.8908008337020874,-10.2003173828125,86.78562927246094,-1.8908008337020874,-10.2003173828125,86.78562927246094,-1.8908008337020874,-10.2003173828125,.9909327626228333,3.0441155433654785,86.0141830444336,.9909327626228333,3.0441155433654785,86.0141830444336,.9909327626228333,3.0441155433654785,86.0141830444336,.9909327626228333,3.0441155433654785,86.0141830444336,-27.00689125061035,-83.12700653076172,7.479950428009033,-27.00689125061035,-83.12700653076172,7.479950428009033,-27.00689125061035,-83.12700653076172,7.479950428009033,-27.00689125061035,-83.12700653076172,7.479950428009033,-69.10259246826172,-52.54320526123047,-10.200308799743652,-69.10259246826172,-52.54320526123047,-10.200308799743652,-69.10259246826172,-52.54320526123047,-10.200308799743652,-69.10259246826172,-52.54320526123047,-10.200308799743652,2.594700574874878,-1.8916770219802856,-86.0141830444336,2.594700574874878,-1.8916770219802856,-86.0141830444336,2.594700574874878,-1.8916770219802856,-86.0141830444336,2.594700574874878,-1.8916770219802856,-86.0141830444336,25.026033401489258,-83.1266860961914,-10.200102806091309,25.026033401489258,-83.1266860961914,-10.200102806091309,25.026033401489258,-83.1266860961914,-10.200102806091309,25.026033401489258,-83.1266860961914,-10.200102806091309,-86.78559112548828,-1.892000436782837,10.200329780578613,-86.78559112548828,-1.892000436782837,10.200329780578613,-86.78559112548828,-1.892000436782837,10.200329780578613,-86.78559112548828,-1.892000436782837,10.200329780578613,-70.7061538696289,-51.37816619873047,-7.479592323303223,-70.7061538696289,-51.37816619873047,-7.479592323303223,-70.7061538696289,-51.37816619873047,-7.479592323303223,-70.7061538696289,-51.37816619873047,-7.479592323303223,-25.024797439575195,-83.12699127197266,10.200674057006836,-25.024797439575195,-83.12699127197266,10.200674057006836,-25.024797439575195,-83.12699127197266,10.200674057006836,-25.024797439575195,-83.12699127197266,10.200674057006836,-2.5946712493896484,-1.8911232948303223,86.01419830322266,-2.5946712493896484,-1.8911232948303223,86.01419830322266,-2.5946712493896484,-1.8911232948303223,86.01419830322266,-2.5946712493896484,-1.8911232948303223,86.01419830322266,-71.31940460205078,49.47935104370117,-10.200664520263672,-71.31940460205078,49.47935104370117,-10.200664520263672,-71.31940460205078,49.47935104370117,-10.200664520263672,-71.31940460205078,49.47935104370117,-10.200664520263672,28.611663818359375,-81.96160888671875,-10.200103759765625,28.611663818359375,-81.96160888671875,-10.200103759765625,28.611663818359375,-81.96160888671875,-10.200103759765625,28.611663818359375,-81.96160888671875,-10.200103759765625,27.00688934326172,83.1143798828125,-7.479951858520508,27.00688934326172,83.1143798828125,-7.479951858520508,27.00688934326172,83.1143798828125,-7.479951858520508,27.00688934326172,83.1143798828125,-7.479951858520508,25.024797439575195,83.11434936523438,-10.200675010681152,25.024797439575195,83.11434936523438,-10.200675010681152,25.024797439575195,83.11434936523438,-10.200675010681152,25.024797439575195,83.11434936523438,-10.200675010681152,27.008115768432617,-83.12667083740234,-7.4793806076049805,27.008115768432617,-83.12667083740234,-7.4793806076049805,27.008115768432617,-83.12667083740234,-7.4793806076049805,27.008115768432617,-83.12667083740234,-7.4793806076049805,-87.39810180664062,-.006933570373803377,7.479599952697754,-87.39810180664062,-.006933570373803377,7.479599952697754,-87.39810180664062,-.006933570373803377,7.479599952697754,-87.39810180664062,-.006933570373803377,7.479599952697754,-71.31866455078125,-49.493099212646484,-10.20032024383545,-71.31866455078125,-49.493099212646484,-10.20032024383545,-71.31866455078125,-49.493099212646484,-10.20032024383545,-71.31866455078125,-49.493099212646484,-10.20032024383545,-.9909327626228333,-3.056749105453491,-86.0141830444336,-.9909327626228333,-3.056749105453491,-86.0141830444336,-.9909327626228333,-3.056749105453491,-86.0141830444336,-.9909327626228333,-3.056749105453491,-86.0141830444336,-3.2070045471191406,-.006636159960180521,-86.01419830322266,-3.2070045471191406,-.006636159960180521,-86.01419830322266,-3.2070045471191406,-.006636159960180521,-86.01419830322266,-3.2070045471191406,-.006636159960180521,-86.01419830322266,-.9909778237342834,3.0435099601745605,-86.01419830322266,-.9909778237342834,3.0435099601745605,-86.01419830322266,-.9909778237342834,3.0435099601745605,-86.01419830322266,-.9909778237342834,3.0435099601745605,-86.01419830322266],normalized:!1},normal:{itemSize:3,type:"Float32Array",array:[-.5870956778526306,.42651230096817017,.6880449652671814,-.5870956778526306,.42651230096817017,.6880449652671814,-.5870956778526306,.42651230096817017,.6880449652671814,-.5870956778526306,.42651230096817017,.6880449652671814,.745985746383667,-.033444374799728394,.6651214957237244,.745985746383667,-.033444374799728394,.6651214957237244,.745985746383667,-.033444374799728394,.6651214957237244,.745985746383667,-.033444374799728394,.6651214957237244,.7662718892097473,3863871097564697e-20,.6425164937973022,.7662718892097473,3863871097564697e-20,.6425164937973022,.7662718892097473,3863871097564697e-20,.6425164937973022,.7662718892097473,3863871097564697e-20,.6425164937973022,.7256649732589722,32261013984680176e-21,.6880481839179993,.7256649732589722,32261013984680176e-21,.6880481839179993,.7256649732589722,32261013984680176e-21,.6880481839179993,.7256649732589722,32261013984680176e-21,.6880481839179993,-.5838431119918823,-.4655483365058899,.6651255488395691,-.5838431119918823,-.4655483365058899,.6651255488395691,-.5838431119918823,-.4655483365058899,.6651255488395691,-.5838431119918823,-.4655483365058899,.6651255488395691,.2623160779476166,-.6991221904754639,.6651454567909241,.2623160779476166,-.6991221904754639,.6651454567909241,.2623160779476166,-.6991221904754639,.6651454567909241,.2623160779476166,-.6991221904754639,.6651454567909241,.22423836588859558,-.6901593208312988,.6880385875701904,.22423836588859558,-.6901593208312988,.6880385875701904,.22423836588859558,-.6901593208312988,.6880385875701904,.22423836588859558,-.6901593208312988,.6880385875701904,.6199150085449219,-.4504251182079315,-.6425127983093262,.6199150085449219,-.4504251182079315,-.6425127983093262,.6199150085449219,-.4504251182079315,-.6425127983093262,.6199150085449219,-.4504251182079315,-.6425127983093262,.19871656596660614,.7197921276092529,.6651397347450256,.19871656596660614,.7197921276092529,.6651397347450256,.19871656596660614,.7197921276092529,.6651397347450256,.19871656596660614,.7197921276092529,.6651397347450256,-.26231205463409424,.6991309523582458,-.665137767791748,-.26231205463409424,.6991309523582458,-.665137767791748,-.26231205463409424,.6991309523582458,-.665137767791748,-.26231205463409424,.6991309523582458,-.665137767791748,-.6231518387794495,.41137412190437317,.6651715636253357,-.6231518387794495,.41137412190437317,.6651715636253357,-.6231518387794495,.41137412190437317,.6651715636253357,-.6231518387794495,.41137412190437317,.6651715636253357,-.583817720413208,.46555060148239136,.6651462912559509,-.583817720413208,.46555060148239136,.6651462912559509,-.583817720413208,.46555060148239136,.6651462912559509,-.583817720413208,.46555060148239136,.6651462912559509,-.23676739633083344,.7287734746932983,-.6425187587738037,-.23676739633083344,.7287734746932983,-.6425187587738037,-.23676739633083344,.7287734746932983,-.6425187587738037,-.23676739633083344,.7287734746932983,-.6425187587738037,-.6199446320533752,.45038023591041565,.6425155997276306,-.6199446320533752,.45038023591041565,.6425155997276306,-.6199446320533752,.45038023591041565,.6425155997276306,-.6199446320533752,.45038023591041565,.6425155997276306,.7459679841995239,.03343930095434189,.6651415824890137,.7459679841995239,.03343930095434189,.6651415824890137,.7459679841995239,.03343930095434189,.6651415824890137,.7459679841995239,.03343930095434189,.6651415824890137,.623174250125885,.4114120602607727,-.6651270389556885,.623174250125885,.4114120602607727,-.6651270389556885,.623174250125885,.4114120602607727,-.6651270389556885,.623174250125885,.4114120602607727,-.6651270389556885,.26233187317848206,.6991434097290039,.6651169061660767,.26233187317848206,.6991434097290039,.6651169061660767,.26233187317848206,.6991434097290039,.6651169061660767,.26233187317848206,.6991434097290039,.6651169061660767,.6199406385421753,.45038270950317383,-.6425178050994873,.6199406385421753,.45038270950317383,-.6425178050994873,.6199406385421753,.45038270950317383,-.6425178050994873,.6199406385421753,.45038270950317383,-.6425178050994873,.587073564529419,.4265226125717163,-.6880576610565186,.587073564529419,.4265226125717163,-.6880576610565186,.587073564529419,.4265226125717163,-.6880576610565186,.587073564529419,.4265226125717163,-.6880576610565186,.5838503241539001,.4655469059944153,-.6651202440261841,.5838503241539001,.4655469059944153,-.6651202440261841,.5838503241539001,.4655469059944153,-.6651202440261841,.5838503241539001,.4655469059944153,-.6651202440261841,.6231569647789001,-.4114269018173218,-.665134072303772,.6231569647789001,-.4114269018173218,-.665134072303772,.6231569647789001,-.4114269018173218,-.665134072303772,.6231569647789001,-.4114269018173218,-.665134072303772,.22424747049808502,.6901424527168274,.6880526542663574,.22424747049808502,.6901424527168274,.6880526542663574,.22424747049808502,.6901424527168274,.6880526542663574,.22424747049808502,.6901424527168274,.6880526542663574,-.2368125319480896,-.7287622094154358,-.6425150632858276,-.2368125319480896,-.7287622094154358,-.6425150632858276,-.2368125319480896,-.7287622094154358,-.6425150632858276,-.2368125319480896,-.7287622094154358,-.6425150632858276,-.2623360753059387,-.6991369128227234,-.6651220917701721,-.2623360753059387,-.6991369128227234,-.6651220917701721,-.2623360753059387,-.6991369128227234,-.6651220917701721,-.2623360753059387,-.6991369128227234,-.6651220917701721,.5870862603187561,-.42650753259658813,-.6880559921264648,.5870862603187561,-.42650753259658813,-.6880559921264648,.5870862603187561,-.42650753259658813,-.6880559921264648,.5870862603187561,-.42650753259658813,-.6880559921264648,-.19872358441352844,-.7197949886322021,-.6651346683502197,-.19872358441352844,-.7197949886322021,-.6651346683502197,-.19872358441352844,-.7197949886322021,-.6651346683502197,-.19872358441352844,-.7197949886322021,-.6651346683502197,-.623177170753479,-.4114185571670532,.6651203036308289,-.623177170753479,-.4114185571670532,.6651203036308289,-.623177170753479,-.4114185571670532,.6651203036308289,-.623177170753479,-.4114185571670532,.6651203036308289,-.6199068427085876,-.45042937994003296,.6425175666809082,-.6199068427085876,-.45042937994003296,.6425175666809082,-.6199068427085876,-.45042937994003296,.6425175666809082,-.6199068427085876,-.45042937994003296,.6425175666809082,.19873395562171936,-.7197892069816589,.6651378273963928,.19873395562171936,-.7197892069816589,.6651378273963928,.19873395562171936,-.7197892069816589,.6651378273963928,.19873395562171936,-.7197892069816589,.6651378273963928,-.5870490074157715,-.42655661702156067,.6880573630332947,-.5870490074157715,-.42655661702156067,.6880573630332947,-.5870490074157715,-.42655661702156067,.6880573630332947,-.5870490074157715,-.42655661702156067,.6880573630332947,-.7459824085235596,.033452022820711136,-.665124773979187,-.7459824085235596,.033452022820711136,-.665124773979187,-.7459824085235596,.033452022820711136,-.665124773979187,-.7459824085235596,.033452022820711136,-.665124773979187,.5838494300842285,-.4655435383319855,-.665123462677002,.5838494300842285,-.4655435383319855,-.665123462677002,.5838494300842285,-.4655435383319855,-.665123462677002,.5838494300842285,-.4655435383319855,-.665123462677002,.2367572784423828,.7287806272506714,.6425143480300903,.2367572784423828,.7287806272506714,.6425143480300903,.2367572784423828,.7287806272506714,.6425143480300903,.2367572784423828,.7287806272506714,.6425143480300903,-.1987278163433075,.7197844982147217,-.6651448011398315,-.1987278163433075,.7197844982147217,-.6651448011398315,-.1987278163433075,.7197844982147217,-.6651448011398315,-.1987278163433075,.7197844982147217,-.6651448011398315,.23682300746440887,-.7287558913230896,.6425182819366455,.23682300746440887,-.7287558913230896,.6425182819366455,.23682300746440887,-.7287558913230896,.6425182819366455,.23682300746440887,-.7287558913230896,.6425182819366455,-.7662706971168518,20429491996765137e-21,-.6425180435180664,-.7662706971168518,20429491996765137e-21,-.6425180435180664,-.7662706971168518,20429491996765137e-21,-.6425180435180664,-.7662706971168518,20429491996765137e-21,-.6425180435180664,-.7459728717803955,-.03343328833580017,-.6651365756988525,-.7459728717803955,-.03343328833580017,-.6651365756988525,-.7459728717803955,-.03343328833580017,-.6651365756988525,-.7459728717803955,-.03343328833580017,-.6651365756988525,-.22426503896713257,-.6901455521583557,-.6880438327789307,-.22426503896713257,-.6901455521583557,-.6880438327789307,-.22426503896713257,-.6901455521583557,-.6880438327789307,-.22426503896713257,-.6901455521583557,-.6880438327789307,-.7256579995155334,-3316998481750488e-20,-.6880554556846619,-.7256579995155334,-3316998481750488e-20,-.6880554556846619,-.7256579995155334,-3316998481750488e-20,-.6880554556846619,-.7256579995155334,-3316998481750488e-20,-.6880554556846619,-.22427412867546082,.6901446580886841,-.6880418658256531,-.22427412867546082,.6901446580886841,-.6880418658256531,-.22427412867546082,.6901446580886841,-.6880418658256531,-.22427412867546082,.6901446580886841,-.6880418658256531],normalized:!1},uv:{itemSize:2,type:"Float32Array",array:[.1126541942358017,.23340463638305664,.15771642327308655,.010170280933380127,.1696747988462448,.09594517946243286,.37625399231910706,.5020440220832825,.09763339906930923,.23340469598770142,.17146287858486176,.012006521224975586,.24126237630844116,.007275700569152832,.7849239706993103,.19342201948165894,.18520936369895935,.026231110095977783,.19948936998844147,.1231493353843689,.24126237630844116,.11555743217468262,.8759239912033081,.2386530041694641,.05257079377770424,.23340463638305664,.09763336926698685,.010167598724365234,.1696747988462448,.08392536640167236,.8759239912033081,.0006530284881591797,.015100483782589436,.23340469598770142,.17080335319042206,.06890475749969482,.21341374516487122,.23143154382705688,.4681450128555298,.19335603713989258,.09020465612411499,.23340463638305664,.16530834138393402,.016166627407073975,.22733810544013977,.11358428001403809,.9650390148162842,.44349002838134766,.022529248148202896,.010164380073547363,.09020490944385529,.010167598724365234,.176739901304245,.08622092008590698,.8740389943122864,.2507209777832031,.17146287858486176,.018639087677001953,.22100581228733063,.11555743217468262,.23493003845214844,.005302548408508301,.6253309845924377,.739175021648407,.15028777718544006,.23340463638305664,.18520939350128174,.018639087677001953,.2412623167037964,.23143154382705688,.46857601404190063,.4435969591140747,.06016269698739052,.010176539421081543,.179232656955719,.2314314842224121,.18520936369895935,.05468016862869263,.5344629883766174,.1933860182762146,.11265438795089722,.010173439979553223,.16530834138393402,.12512201070785522,.18389028310775757,.06890475749969482,.46725401282310486,.6948130130767822,.15771642327308655,.23340457677841187,.1790548413991928,.01447904109954834,.1855650693178177,.12512195110321045,.28525400161743164,.6948130130767822,.17923292517662048,.12314879894256592,.18520939350128174,.012006521224975586,.2349299192428589,.23340469598770142,.6254630088806152,.23861700296401978,.1653086096048355,.23340469598770142,.18520936369895935,.06131279468536377,.1855650693178177,.23340469598770142,.37625399231910706,.7400439977645874,.05257079377770424,.01016455888748169,.17146287858486176,.032863736152648926,.19948936998844147,.23143154382705688,.9669240117073059,.19342201948165894,.14269573986530304,.010170340538024902,.18520936369895935,.032863736152648926,.19315698742866516,.12512242794036865,.21655499935150146,.6933860182762146,.04514260217547417,.01016455888748169,.16530832648277283,.02870357036590576,.21341368556022644,.007275700569152832,.2865760028362274,.4435969591140747,.12555499374866486,.7386170029640198,.17146287858486176,.026231110095977783,.1931571662425995,.23340469598770142,.2070813775062561,.005302548408508301,.12555499374866486,.5006170272827148,.12767508625984192,.010170459747314453,.14269573986530304,.23340463638305664,.16530832648277283,.109546959400177,.03455499932169914,.6933860182762146,.12767508625984192,.23340463638305664,.17146290838718414,.040455639362335205,.2070814073085785,.11358422040939331,.1352669894695282,.010170340538024902,.17905481159687042,.028703629970550537,.23493003845214844,.11358428001403809,.5343310236930847,.693943977355957,.04514192417263985,.23340457677841187,.1502876579761505,.010170280933380127,.16530834138393402,.089935302734375,.37757599353790283,.2508280277252197,.12430000305175781,.48809099197387695,.16530832648277283,.07261902093887329,.19948936998844147,.11555695533752441,.20708149671554565,.23340469598770142,.0301218219101429,.23340463638305664,.17146289348602295,.06131279468536377,.2070813775062561,.1251225471496582,.2153010070323944,.4428600072860718,.08261273801326752,.23340463638305664,.13526709377765656,.23340463638305664,.16967478394508362,.11555695533752441,.6253309845924377,.5011749863624573,.03330099955201149,.4428600072860718,.07518399506807327,.010167300701141357,.17905481159687042,.042928099632263184,.19948936998844147,.007275700569152832,.10522530972957611,.010173439979553223,.18389026820659637,.07633346319198608,.22100578248500824,.23143154382705688,.28614500164985657,.19335603713989258,.17146289348602295,.05468016862869263,.21341368556022644,.12314939498901367,.2210056483745575,.1231493353843689,.377144992351532,.23858702182769775,.02252865955233574,.23340469598770142,.17080335319042206,.07633340358734131,.19315703213214874,.11358380317687988,.7830389738082886,.44349002838134766,.015100372023880482,.010164380073547363,.10522563755512238,.23340463638305664,.1767398715019226,.09364962577819824,.377144992351532,.0005869865417480469,.0675920695066452,.010176539421081543,.17164073884487152,.23143154382705688,.17905481159687042,.05884033441543579,.7172229886054993,.4428600072860718,.08261273801326752,.010167300701141357,.18520936369895935,.04708826541900635,.2210056483745575,.007276654243469238,.7163310050964355,.693943977355957,.17146290838718414,.04708826541900635,.21341368556022644,.11555737257003784,.2412623167037964,.12314939498901367,.37757599353790283,.48882800340652466,.12024644762277603,.23340463638305664,.16530834138393402,.044615745544433594,.23493006825447083,.1251225471496582,.716463029384613,.1933860182762146,.18520936369895935,.040455639362335205,.19315698742866516,.005302488803863525,.22733810544013977,.005303502082824707,.8740389943122864,.48872101306915283,.17164073884487152,.1231488585472107,.17839525640010834,.07261908054351807,.2273380160331726,.23340463638305664,.6262230277061462,.48809099197387695,.037550006061792374,.23340463638305664,.16530834138393402,.057152748107910156,.2273380160331726,.12512242794036865,.5352230072021484,.4428600072860718,.030121158808469772,.010164439678192139,.07518427819013596,.23340463638305664,.12430000305175781,.25009095668792725,.176739901304245,.11326134204864502,.037550006061792374,.010164439678192139,.0675920695066452,.23340457677841187,.176739901304245,.10583275556564331,.6262230277061462,.25009095668792725,.06016361340880394,.23340463638305664,.12024631351232529,.010170459747314453,.16967478394508362,.10353708267211914,.6254630088806152,.0006170272827148438],normalized:!1},color:{itemSize:4,type:"Uint16Array",array:[65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535],normalized:!0}},index:{type:"Uint16Array",array:[23,115,139,123,147,143,19,107,111,35,67,131,59,7,11,95,100,88,63,76,68,135,39,51,127,83,31,4,25,20,82,6,30,97,60,80,62,58,9,22,126,29,94,18,109,37,46,48,0,104,117,44,85,32,66,79,129,124,149,96,114,103,137,156,120,36,146,106,142,24,16,112,34,134,50,152,92,144,77,157,132,41,121,140,102,125,136,5,21,28,61,8,81,69,65,57,78,133,128,45,33,49,53,38,122,42,141,105,93,108,145,89,113,17,98,151,154,43,47,55,12,64,84,86,118,26,23,27,115,123,155,147,19,119,107,35,87,67,59,15,7,95,150,100,63,72,76,135,159,39,127,99,83,4,13,25,82,10,6,97,74,60,62,70,58,22,138,126,94,91,18,37,54,46,0,40,104,44,1,85,66,71,79,124,101,149,114,90,103,156,153,120,146,110,106,24,116,16,34,130,134,152,148,92,77,73,157,41,52,121,158,75,154,75,98,154,43,3,47,12,56,64,26,14,86,86,2,118]},boundingSphere:{center:[0,-.006313323974609375,0],radius:148.14155442794186}},rotationCombinations:{"1,2":[180,0,36],"1,3":[0,0,-144],"1,4":[-180,0,-108],"1,5":[0,0,144],"1,6":[180,0,-36],"1,7":[0,0,-72],"1,8":[180,0,108],"1,9":[0,0,72],"1,10":[-180,0,180],"2,3":[180,0,-108],"2,4":[0,0,-144],"2,5":[-180,0,-180],"2,6":[0,0,-72],"2,7":[180,0,-36],"2,8":[0,0,72],"2,9":[-180,0,108],"2,10":[0,0,144],"3,4":[-180,0,108],"3,5":[0,0,-72],"3,6":[-180,0,180],"3,7":[0,0,72],"3,8":[180,0,-36],"3,9":[0,0,-144],"3,10":[180,0,36],"4,5":[180,0,36],"4,6":[0,0,72],"4,7":[-180,0,-180],"4,8":[0,0,-144],"4,9":[180,0,-36],"4,10":[0,0,-72],"5,6":[180,0,108],"5,7":[0,0,144],"5,8":[-180,0,-108],"5,9":[0,0,-72],"5,10":[180,0,-36],"6,7":[180,0,-108],"6,8":[0,0,144],"6,9":[-180,0,36],"6,10":[0,0,-144],"7,8":[180,0,36],"7,9":[0,0,144],"7,10":[-180,0,108],"8,9":[-180,0,180],"8,10":[0,0,72],"9,10":[180,0,-108]}},d12:{metadata:{version:4.5,type:"BufferGeometry",generator:"BufferGeometry.toJSON"},uuid:"04389FAB-5CCD-4FEC-B604-C19AD1000B1C",type:"BufferGeometry",data:{attributes:{position:{itemSize:3,type:"Float32Array",array:[-31.141719818115234,83.4803466796875,-1.2052193880081177,-31.141719818115234,83.4803466796875,-1.2052193880081177,-31.141719818115234,83.4803466796875,-1.2052193880081177,-31.141719818115234,83.4803466796875,-1.2052193880081177,83.48023223876953,-1.2053337097167969,-31.14202308654785,83.48023223876953,-1.2053337097167969,-31.14202308654785,83.48023223876953,-1.2053337097167969,-31.14202308654785,83.48023223876953,-1.2053337097167969,-31.14202308654785,83.48045349121094,-1.2053337097167969,31.141408920288086,83.48045349121094,-1.2053337097167969,31.141408920288086,83.48045349121094,-1.2053337097167969,31.141408920288086,83.48045349121094,-1.2053337097167969,31.141408920288086,-82.73528289794922,0,33.09229278564453,-82.73528289794922,0,33.09229278564453,-82.73528289794922,0,33.09229278564453,-82.73528289794922,0,33.09229278564453,51.59387969970703,50.38835906982422,52.338436126708984,51.59387969970703,50.38835906982422,52.338436126708984,51.59387969970703,50.38835906982422,52.338436126708984,51.59387969970703,50.38835906982422,52.338436126708984,50.3885498046875,52.338626861572266,51.593505859375,50.3885498046875,52.338626861572266,51.593505859375,50.3885498046875,52.338626861572266,51.593505859375,50.3885498046875,52.338626861572266,51.593505859375,-31.141712188720703,83.4803466796875,1.2054481506347656,-31.141712188720703,83.4803466796875,1.2054481506347656,-31.141712188720703,83.4803466796875,1.2054481506347656,-31.141712188720703,83.4803466796875,1.2054481506347656,83.48023223876953,1.2053337097167969,-31.14202308654785,83.48023223876953,1.2053337097167969,-31.14202308654785,83.48023223876953,1.2053337097167969,-31.14202308654785,83.48023223876953,1.2053337097167969,-31.14202308654785,-83.48045349121094,-1.2053337097167969,-31.141408920288086,-83.48045349121094,-1.2053337097167969,-31.141408920288086,-83.48045349121094,-1.2053337097167969,-31.141408920288086,-83.48045349121094,-1.2053337097167969,-31.141408920288086,-51.59387969970703,-50.38835906982422,-52.338436126708984,-51.59387969970703,-50.38835906982422,-52.338436126708984,-51.59387969970703,-50.38835906982422,-52.338436126708984,-51.59387969970703,-50.38835906982422,-52.338436126708984,-1.205640435218811,31.14171600341797,-83.48033142089844,-1.205640435218811,31.14171600341797,-83.48033142089844,-1.205640435218811,31.14171600341797,-83.48033142089844,-1.205640435218811,31.14171600341797,-83.48033142089844,-1.205640435218811,-31.14171600341797,-83.48033142089844,-1.205640435218811,-31.14171600341797,-83.48033142089844,-1.205640435218811,-31.14171600341797,-83.48033142089844,-1.205640435218811,-31.14171600341797,-83.48033142089844,1.2050271034240723,31.14171600341797,-83.48035430908203,1.2050271034240723,31.14171600341797,-83.48035430908203,1.2050271034240723,31.14171600341797,-83.48035430908203,1.2050271034240723,31.14171600341797,-83.48035430908203,-83.48045349121094,1.2053337097167969,-31.141408920288086,-83.48045349121094,1.2053337097167969,-31.141408920288086,-83.48045349121094,1.2053337097167969,-31.141408920288086,-83.48045349121094,1.2053337097167969,-31.141408920288086,-83.48023223876953,1.2053337097167969,31.14202308654785,-83.48023223876953,1.2053337097167969,31.14202308654785,-83.48023223876953,1.2053337097167969,31.14202308654785,-83.48023223876953,1.2053337097167969,31.14202308654785,-50.38816833496094,-52.338626861572266,51.593875885009766,-50.38816833496094,-52.338626861572266,51.593875885009766,-50.38816833496094,-52.338626861572266,51.593875885009766,-50.38816833496094,-52.338626861572266,51.593875885009766,31.141712188720703,83.4803466796875,-1.2054481506347656,31.141712188720703,83.4803466796875,-1.2054481506347656,31.141712188720703,83.4803466796875,-1.2054481506347656,31.141712188720703,83.4803466796875,-1.2054481506347656,-50.3885498046875,52.338626861572266,-51.593505859375,-50.3885498046875,52.338626861572266,-51.593505859375,-50.3885498046875,52.338626861572266,-51.593505859375,-50.3885498046875,52.338626861572266,-51.593505859375,50.38816833496094,52.338626861572266,-51.593875885009766,50.38816833496094,52.338626861572266,-51.593875885009766,50.38816833496094,52.338626861572266,-51.593875885009766,50.38816833496094,52.338626861572266,-51.593875885009766,-.000303904089378193,33.09198760986328,-82.73540496826172,-.000303904089378193,33.09198760986328,-82.73540496826172,-.000303904089378193,33.09198760986328,-82.73540496826172,-.000303904089378193,33.09198760986328,-82.73540496826172,82.73552703857422,0,33.0916862487793,82.73552703857422,0,33.0916862487793,82.73552703857422,0,33.0916862487793,82.73552703857422,0,33.0916862487793,52.338809967041016,-51.59368896484375,50.38816833496094,52.338809967041016,-51.59368896484375,50.38816833496094,52.338809967041016,-51.59368896484375,50.38816833496094,52.338809967041016,-51.59368896484375,50.38816833496094,83.48045349121094,1.2053337097167969,31.141408920288086,83.48045349121094,1.2053337097167969,31.141408920288086,83.48045349121094,1.2053337097167969,31.141408920288086,83.48045349121094,1.2053337097167969,31.141408920288086,52.33843994140625,-51.59368896484375,-50.3885498046875,52.33843994140625,-51.59368896484375,-50.3885498046875,52.33843994140625,-51.59368896484375,-50.3885498046875,52.33843994140625,-51.59368896484375,-50.3885498046875,51.593502044677734,-50.38835906982422,-52.33881759643555,51.593502044677734,-50.38835906982422,-52.33881759643555,51.593502044677734,-50.38835906982422,-52.33881759643555,51.593502044677734,-50.38835906982422,-52.33881759643555,82.73528289794922,0,-33.09229278564453,82.73528289794922,0,-33.09229278564453,82.73528289794922,0,-33.09229278564453,82.73528289794922,0,-33.09229278564453,33.09198760986328,-82.73540496826172,-.00012155366130173206,33.09198760986328,-82.73540496826172,-.00012155366130173206,33.09198760986328,-82.73540496826172,-.00012155366130173206,33.09198760986328,-82.73540496826172,-.00012155366130173206,-1.2050271034240723,-31.14171600341797,83.48035430908203,-1.2050271034240723,-31.14171600341797,83.48035430908203,-1.2050271034240723,-31.14171600341797,83.48035430908203,-1.2050271034240723,-31.14171600341797,83.48035430908203,-1.2050271034240723,31.14171600341797,83.48035430908203,-1.2050271034240723,31.14171600341797,83.48035430908203,-1.2050271034240723,31.14171600341797,83.48035430908203,-1.2050271034240723,31.14171600341797,83.48035430908203,-52.33843994140625,-51.59368896484375,50.3885498046875,-52.33843994140625,-51.59368896484375,50.3885498046875,-52.33843994140625,-51.59368896484375,50.3885498046875,-52.33843994140625,-51.59368896484375,50.3885498046875,-51.593502044677734,-50.38835906982422,52.33881759643555,-51.593502044677734,-50.38835906982422,52.33881759643555,-51.593502044677734,-50.38835906982422,52.33881759643555,-51.593502044677734,-50.38835906982422,52.33881759643555,-51.593502044677734,50.38835906982422,52.33881759643555,-51.593502044677734,50.38835906982422,52.33881759643555,-51.593502044677734,50.38835906982422,52.33881759643555,-51.593502044677734,50.38835906982422,52.33881759643555,-52.33843994140625,51.59368896484375,50.3885498046875,-52.33843994140625,51.59368896484375,50.3885498046875,-52.33843994140625,51.59368896484375,50.3885498046875,-52.33843994140625,51.59368896484375,50.3885498046875,.000303904089378193,33.09198760986328,82.73540496826172,.000303904089378193,33.09198760986328,82.73540496826172,.000303904089378193,33.09198760986328,82.73540496826172,.000303904089378193,33.09198760986328,82.73540496826172,52.338809967041016,51.59368896484375,50.38816833496094,52.338809967041016,51.59368896484375,50.38816833496094,52.338809967041016,51.59368896484375,50.38816833496094,52.338809967041016,51.59368896484375,50.38816833496094,1.205640435218811,-31.14171600341797,83.48033142089844,1.205640435218811,-31.14171600341797,83.48033142089844,1.205640435218811,-31.14171600341797,83.48033142089844,1.205640435218811,-31.14171600341797,83.48033142089844,-33.09198760986328,82.73540496826172,.00012155366130173206,-33.09198760986328,82.73540496826172,.00012155366130173206,-33.09198760986328,82.73540496826172,.00012155366130173206,-33.09198760986328,82.73540496826172,.00012155366130173206,-50.38816833496094,52.338626861572266,51.593875885009766,-50.38816833496094,52.338626861572266,51.593875885009766,-50.38816833496094,52.338626861572266,51.593875885009766,-50.38816833496094,52.338626861572266,51.593875885009766,51.593502044677734,50.38835906982422,-52.33881759643555,51.593502044677734,50.38835906982422,-52.33881759643555,51.593502044677734,50.38835906982422,-52.33881759643555,51.593502044677734,50.38835906982422,-52.33881759643555,-52.338809967041016,-51.59368896484375,-50.38816833496094,-52.338809967041016,-51.59368896484375,-50.38816833496094,-52.338809967041016,-51.59368896484375,-50.38816833496094,-52.338809967041016,-51.59368896484375,-50.38816833496094,-33.09198760986328,-82.73540496826172,.00012155366130173206,-33.09198760986328,-82.73540496826172,.00012155366130173206,-33.09198760986328,-82.73540496826172,.00012155366130173206,-33.09198760986328,-82.73540496826172,.00012155366130173206,-83.48023223876953,-1.2053337097167969,31.14202308654785,-83.48023223876953,-1.2053337097167969,31.14202308654785,-83.48023223876953,-1.2053337097167969,31.14202308654785,-83.48023223876953,-1.2053337097167969,31.14202308654785,-50.3885498046875,-52.338626861572266,-51.593505859375,-50.3885498046875,-52.338626861572266,-51.593505859375,-50.3885498046875,-52.338626861572266,-51.593505859375,-50.3885498046875,-52.338626861572266,-51.593505859375,-.000303904089378193,-33.09198760986328,-82.73540496826172,-.000303904089378193,-33.09198760986328,-82.73540496826172,-.000303904089378193,-33.09198760986328,-82.73540496826172,-.000303904089378193,-33.09198760986328,-82.73540496826172,50.38816833496094,-52.338626861572266,-51.593875885009766,50.38816833496094,-52.338626861572266,-51.593875885009766,50.38816833496094,-52.338626861572266,-51.593875885009766,50.38816833496094,-52.338626861572266,-51.593875885009766,31.141719818115234,-83.4803466796875,1.2052193880081177,31.141719818115234,-83.4803466796875,1.2052193880081177,31.141719818115234,-83.4803466796875,1.2052193880081177,31.141719818115234,-83.4803466796875,1.2052193880081177,-31.141719818115234,-83.4803466796875,-1.2052193880081177,-31.141719818115234,-83.4803466796875,-1.2052193880081177,-31.141719818115234,-83.4803466796875,-1.2052193880081177,-31.141719818115234,-83.4803466796875,-1.2052193880081177,1.2050271034240723,-31.14171600341797,-83.48035430908203,1.2050271034240723,-31.14171600341797,-83.48035430908203,1.2050271034240723,-31.14171600341797,-83.48035430908203,1.2050271034240723,-31.14171600341797,-83.48035430908203,-52.338809967041016,51.59368896484375,-50.38816833496094,-52.338809967041016,51.59368896484375,-50.38816833496094,-52.338809967041016,51.59368896484375,-50.38816833496094,-52.338809967041016,51.59368896484375,-50.38816833496094,-31.141712188720703,-83.4803466796875,1.2054481506347656,-31.141712188720703,-83.4803466796875,1.2054481506347656,-31.141712188720703,-83.4803466796875,1.2054481506347656,-31.141712188720703,-83.4803466796875,1.2054481506347656,31.141719818115234,83.4803466796875,1.2052193880081177,31.141719818115234,83.4803466796875,1.2052193880081177,31.141719818115234,83.4803466796875,1.2052193880081177,31.141719818115234,83.4803466796875,1.2052193880081177,33.09198760986328,82.73540496826172,-.00012155366130173206,33.09198760986328,82.73540496826172,-.00012155366130173206,33.09198760986328,82.73540496826172,-.00012155366130173206,33.09198760986328,82.73540496826172,-.00012155366130173206,31.141712188720703,-83.4803466796875,-1.2054481506347656,31.141712188720703,-83.4803466796875,-1.2054481506347656,31.141712188720703,-83.4803466796875,-1.2054481506347656,31.141712188720703,-83.4803466796875,-1.2054481506347656,1.205640435218811,31.14171600341797,83.48033142089844,1.205640435218811,31.14171600341797,83.48033142089844,1.205640435218811,31.14171600341797,83.48033142089844,1.205640435218811,31.14171600341797,83.48033142089844,.000303904089378193,-33.09198760986328,82.73540496826172,.000303904089378193,-33.09198760986328,82.73540496826172,.000303904089378193,-33.09198760986328,82.73540496826172,.000303904089378193,-33.09198760986328,82.73540496826172,-82.73552703857422,0,-33.0916862487793,-82.73552703857422,0,-33.0916862487793,-82.73552703857422,0,-33.0916862487793,-82.73552703857422,0,-33.0916862487793,-51.59387969970703,50.38835906982422,-52.338436126708984,-51.59387969970703,50.38835906982422,-52.338436126708984,-51.59387969970703,50.38835906982422,-52.338436126708984,-51.59387969970703,50.38835906982422,-52.338436126708984,52.33843994140625,51.59368896484375,-50.3885498046875,52.33843994140625,51.59368896484375,-50.3885498046875,52.33843994140625,51.59368896484375,-50.3885498046875,52.33843994140625,51.59368896484375,-50.3885498046875,51.59387969970703,-50.38835906982422,52.338436126708984,51.59387969970703,-50.38835906982422,52.338436126708984,51.59387969970703,-50.38835906982422,52.338436126708984,51.59387969970703,-50.38835906982422,52.338436126708984,50.3885498046875,-52.338626861572266,51.593505859375,50.3885498046875,-52.338626861572266,51.593505859375,50.3885498046875,-52.338626861572266,51.593505859375,50.3885498046875,-52.338626861572266,51.593505859375],normalized:!1},normal:{itemSize:3,type:"Float32Array",array:[-.010959841310977936,.8584385514259338,-.5127993226051331,-.010959841310977936,.8584385514259338,-.5127993226051331,-.010959841310977936,.8584385514259338,-.5127993226051331,-.010959841310977936,.8584385514259338,-.5127993226051331,.8584375977516174,-.5128011703491211,-.010949048213660717,.8584375977516174,-.5128011703491211,-.010949048213660717,.8584375977516174,-.5128011703491211,-.010949048213660717,.8584375977516174,-.5128011703491211,-.010949048213660717,.8584346175193787,-.5128057599067688,.010964557528495789,.8584346175193787,-.5128057599067688,.010964557528495789,.8584346175193787,-.5128057599067688,.010964557528495789,.8584346175193787,-.5128057599067688,.010964557528495789,-.5414749979972839,-2707540988922119e-20,.8407168388366699,-.5414749979972839,-2707540988922119e-20,.8407168388366699,-.5414749979972839,-2707540988922119e-20,.8407168388366699,-.5414749979972839,-2707540988922119e-20,.8407168388366699,.5305333137512207,.017743051052093506,.8474783301353455,.5305333137512207,.017743051052093506,.8474783301353455,.5305333137512207,.017743051052093506,.8474783301353455,.5305333137512207,.017743051052093506,.8474783301353455,.01774728298187256,.8474791646003723,.5305318236351013,.01774728298187256,.8474791646003723,.5305318236351013,.01774728298187256,.8474791646003723,.5305318236351013,.01774728298187256,.8474791646003723,.5305318236351013,-.010942935943603516,.8584372997283936,.5128018856048584,-.010942935943603516,.8584372997283936,.5128018856048584,-.010942935943603516,.8584372997283936,.5128018856048584,-.010942935943603516,.8584372997283936,.5128018856048584,.8584451079368591,.5127884149551392,-.01095967274159193,.8584451079368591,.5127884149551392,-.01095967274159193,.8584451079368591,.5127884149551392,-.01095967274159193,.8584451079368591,.5127884149551392,-.01095967274159193,-.8584290742874146,-.512814462184906,-.010995045304298401,-.8584290742874146,-.512814462184906,-.010995045304298401,-.8584290742874146,-.512814462184906,-.010995045304298401,-.8584290742874146,-.512814462184906,-.010995045304298401,-.5305572152137756,-.017733842134475708,-.8474634885787964,-.5305572152137756,-.017733842134475708,-.8474634885787964,-.5305572152137756,-.017733842134475708,-.8474634885787964,-.5305572152137756,-.017733842134475708,-.8474634885787964,-.5128048658370972,.010960124433040619,-.8584352135658264,-.5128048658370972,.010960124433040619,-.8584352135658264,-.5128048658370972,.010960124433040619,-.8584352135658264,-.5128048658370972,.010960124433040619,-.8584352135658264,-.5128147006034851,-.010991238057613373,-.858428955078125,-.5128147006034851,-.010991238057613373,-.858428955078125,-.5128147006034851,-.010991238057613373,-.858428955078125,-.5128147006034851,-.010991238057613373,-.858428955078125,.5127923488616943,.010975174605846405,-.8584426045417786,.5127923488616943,.010975174605846405,-.8584426045417786,.5127923488616943,.010975174605846405,-.8584426045417786,.5127923488616943,.010975174605846405,-.8584426045417786,-.8584410548210144,.512795627117157,-.010933354496955872,-.8584410548210144,.512795627117157,-.010933354496955872,-.8584410548210144,.512795627117157,-.010933354496955872,-.8584410548210144,.512795627117157,-.010933354496955872,-.8584320545196533,.5128099322319031,.01097819209098816,-.8584320545196533,.5128099322319031,.01097819209098816,-.8584320545196533,.5128099322319031,.01097819209098816,-.8584320545196533,.5128099322319031,.01097819209098816,-.01773303747177124,-.8474655151367188,.5305542349815369,-.01773303747177124,-.8474655151367188,.5305542349815369,-.01773303747177124,-.8474655151367188,.5305542349815369,-.01773303747177124,-.8474655151367188,.5305542349815369,.010984241962432861,.8584214448928833,-.5128273963928223,.010984241962432861,.8584214448928833,-.5128273963928223,.010984241962432861,.8584214448928833,-.5128273963928223,.010984241962432861,.8584214448928833,-.5128273963928223,-.017747551202774048,.847478985786438,-.5305322408676147,-.017747551202774048,.847478985786438,-.5305322408676147,-.017747551202774048,.847478985786438,-.5305322408676147,-.017747551202774048,.847478985786438,-.5305322408676147,.017701515927910805,.8474764823913574,-.5305377244949341,.017701515927910805,.8474764823913574,-.5305377244949341,.017701515927910805,.8474764823913574,-.5305377244949341,.017701515927910805,.8474764823913574,-.5305377244949341,-2969801425933838e-20,.840691328048706,-.54151451587677,-2969801425933838e-20,.840691328048706,-.54151451587677,-2969801425933838e-20,.840691328048706,-.54151451587677,-2969801425933838e-20,.840691328048706,-.54151451587677,.5415211915969849,26792287826538086e-21,.840687096118927,.5415211915969849,26792287826538086e-21,.840687096118927,.5415211915969849,26792287826538086e-21,.840687096118927,.5415211915969849,26792287826538086e-21,.840687096118927,.8474524617195129,-.5305749177932739,.01773586869239807,.8474524617195129,-.5305749177932739,.01773586869239807,.8474524617195129,-.5305749177932739,.01773586869239807,.8474524617195129,-.5305749177932739,.01773586869239807,.8584384322166443,.5127996206283569,.010955426841974258,.8584384322166443,.5127996206283569,.010955426841974258,.8584384322166443,.5127996206283569,.010955426841974258,.8584384322166443,.5127996206283569,.010955426841974258,.8474904298782349,-.530514657497406,-.01772182434797287,.8474904298782349,-.530514657497406,-.01772182434797287,.8474904298782349,-.530514657497406,-.01772182434797287,.8474904298782349,-.530514657497406,-.01772182434797287,.5305161476135254,-.017740633338689804,-.8474891185760498,.5305161476135254,-.017740633338689804,-.8474891185760498,.5305161476135254,-.017740633338689804,-.8474891185760498,.5305161476135254,-.017740633338689804,-.8474891185760498,.5414748787879944,-5863606929779053e-21,-.8407169580459595,.5414748787879944,-5863606929779053e-21,-.8407169580459595,.5414748787879944,-5863606929779053e-21,-.8407169580459595,.5414748787879944,-5863606929779053e-21,-.8407169580459595,.8406915068626404,-.5415142774581909,-934302806854248e-20,.8406915068626404,-.5415142774581909,-934302806854248e-20,.8406915068626404,-.5415142774581909,-934302806854248e-20,.8406915068626404,-.5415142774581909,-934302806854248e-20,-.5128104090690613,-.01098555326461792,.8584316372871399,-.5128104090690613,-.01098555326461792,.8584316372871399,-.5128104090690613,-.01098555326461792,.8584316372871399,-.5128104090690613,-.01098555326461792,.8584316372871399,-.5128028988838196,.010992184281349182,.858436107635498,-.5128028988838196,.010992184281349182,.858436107635498,-.5128028988838196,.010992184281349182,.858436107635498,-.5128028988838196,.010992184281349182,.858436107635498,-.8474770188331604,-.5305349826812744,.017758265137672424,-.8474770188331604,-.5305349826812744,.017758265137672424,-.8474770188331604,-.5305349826812744,.017758265137672424,-.8474770188331604,-.5305349826812744,.017758265137672424,-.5305088758468628,-.017743252217769623,.8474936485290527,-.5305088758468628,-.017743252217769623,.8474936485290527,-.5305088758468628,-.017743252217769623,.8474936485290527,-.5305088758468628,-.017743252217769623,.8474936485290527,-.5305161476135254,.017740704119205475,.8474891781806946,-.5305161476135254,.017740704119205475,.8474891781806946,-.5305161476135254,.017740704119205475,.8474891781806946,-.5305161476135254,.017740704119205475,.8474891781806946,-.8474623560905457,.5305585861206055,.01774775981903076,-.8474623560905457,.5305585861206055,.01774775981903076,-.8474623560905457,.5305585861206055,.01774775981903076,-.8474623560905457,.5305585861206055,.01774775981903076,29221177101135254e-21,.8406913876533508,.5415146350860596,29221177101135254e-21,.8406913876533508,.5415146350860596,29221177101135254e-21,.8406913876533508,.5415146350860596,29221177101135254e-21,.8406913876533508,.5415146350860596,.8474631309509277,.5305578112602234,.017742618918418884,.8474631309509277,.5305578112602234,.017742618918418884,.8474631309509277,.5305578112602234,.017742618918418884,.8474631309509277,.5305578112602234,.017742618918418884,.5128002166748047,-.010964479297399521,.8584378957748413,.5128002166748047,-.010964479297399521,.8584378957748413,.5128002166748047,-.010964479297399521,.8584378957748413,.5128002166748047,-.010964479297399521,.8584378957748413,-.8407147526741028,.5414782166481018,9499490261077881e-21,-.8407147526741028,.5414782166481018,9499490261077881e-21,-.8407147526741028,.5414782166481018,9499490261077881e-21,-.8407147526741028,.5414782166481018,9499490261077881e-21,-.017701396718621254,.847476601600647,.530537486076355,-.017701396718621254,.847476601600647,.530537486076355,-.017701396718621254,.847476601600647,.530537486076355,-.017701396718621254,.847476601600647,.530537486076355,.5305255055427551,.01773667335510254,-.8474833369255066,.5305255055427551,.01773667335510254,-.8474833369255066,.5305255055427551,.01773667335510254,-.8474833369255066,.5305255055427551,.01773667335510254,-.8474833369255066,-.8474682569503784,-.5305496454238892,-.017742810770869255,-.8474682569503784,-.5305496454238892,-.017742810770869255,-.8474682569503784,-.5305496454238892,-.017742810770869255,-.8474682569503784,-.5305496454238892,-.017742810770869255,-.8406901359558105,-.5415164232254028,3986060619354248e-20,-.8406901359558105,-.5415164232254028,3986060619354248e-20,-.8406901359558105,-.5415164232254028,3986060619354248e-20,-.8406901359558105,-.5415164232254028,3986060619354248e-20,-.858434796333313,-.5128055810928345,.010956216603517532,-.858434796333313,-.5128055810928345,.010956216603517532,-.858434796333313,-.5128055810928345,.010956216603517532,-.858434796333313,-.5128055810928345,.010956216603517532,-.017747780308127403,-.8474676012992859,-.530550479888916,-.017747780308127403,-.8474676012992859,-.530550479888916,-.017747780308127403,-.8474676012992859,-.530550479888916,-.017747780308127403,-.8474676012992859,-.530550479888916,33095479011535645e-21,-.8406911492347717,-.5415149331092834,33095479011535645e-21,-.8406911492347717,-.5415149331092834,33095479011535645e-21,-.8406911492347717,-.5415149331092834,33095479011535645e-21,-.8406911492347717,-.5415149331092834,.017742261290550232,-.8474804759025574,-.5305300354957581,.017742261290550232,-.8474804759025574,-.5305300354957581,.017742261290550232,-.8474804759025574,-.5305300354957581,.017742261290550232,-.8474804759025574,-.5305300354957581,.010982692241668701,-.8584359288215637,.5128030776977539,.010982692241668701,-.8584359288215637,.5128030776977539,.010982692241668701,-.8584359288215637,.5128030776977539,.010982692241668701,-.8584359288215637,.5128030776977539,-.011000136844813824,-.8584293127059937,-.512813925743103,-.011000136844813824,-.8584293127059937,-.512813925743103,-.011000136844813824,-.8584293127059937,-.512813925743103,-.011000136844813824,-.8584293127059937,-.512813925743103,.5127899050712585,-.010951489210128784,-.858444333076477,.5127899050712585,-.010951489210128784,-.858444333076477,.5127899050712585,-.010951489210128784,-.858444333076477,.5127899050712585,-.010951489210128784,-.858444333076477,-.8474836945533752,.530524492263794,-.017755359411239624,-.8474836945533752,.530524492263794,-.017755359411239624,-.8474836945533752,.530524492263794,-.017755359411239624,-.8474836945533752,.530524492263794,-.017755359411239624,-.010949179530143738,-.8584410548210144,.5127953290939331,-.010949179530143738,-.8584410548210144,.5127953290939331,-.010949179530143738,-.8584410548210144,.5127953290939331,-.010949179530143738,-.8584410548210144,.5127953290939331,.010959796607494354,.8584384918212891,.5127993226051331,.010959796607494354,.8584384918212891,.5127993226051331,.010959796607494354,.8584384918212891,.5127993226051331,.010959796607494354,.8584384918212891,.5127993226051331,.840688943862915,.5415182709693909,23245811462402344e-22,.840688943862915,.5415182709693909,23245811462402344e-22,.840688943862915,.5415182709693909,23245811462402344e-22,.840688943862915,.5415182709693909,23245811462402344e-22,.010956525802612305,-.85843825340271,-.512799859046936,.010956525802612305,-.85843825340271,-.512799859046936,.010956525802612305,-.85843825340271,-.512799859046936,.010956525802612305,-.85843825340271,-.512799859046936,.5128072500228882,.010947109200060368,.8584340214729309,.5128072500228882,.010947109200060368,.8584340214729309,.5128072500228882,.010947109200060368,.8584340214729309,.5128072500228882,.010947109200060368,.8584340214729309,-2372264862060547e-20,-.8406915664672852,.5415141582489014,-2372264862060547e-20,-.8406915664672852,.5415141582489014,-2372264862060547e-20,-.8406915664672852,.5415141582489014,-2372264862060547e-20,-.8406915664672852,.5415141582489014,-.5415211319923401,58785080909729e-19,-.8406871557235718,-.5415211319923401,58785080909729e-19,-.8406871557235718,-.5415211319923401,58785080909729e-19,-.8406871557235718,-.5415211319923401,58785080909729e-19,-.8406871557235718,-.5305268168449402,.017754971981048584,-.8474822044372559,-.5305268168449402,.017754971981048584,-.8474822044372559,-.5305268168449402,.017754971981048584,-.8474822044372559,-.5305268168449402,.017754971981048584,-.8474822044372559,.8474643230438232,.530555784702301,-.017738506197929382,.8474643230438232,.530555784702301,-.017738506197929382,.8474643230438232,.530555784702301,-.017738506197929382,.8474643230438232,.530555784702301,-.017738506197929382,.5305773615837097,-.017735809087753296,.8474509716033936,.5305773615837097,-.017735809087753296,.8474509716033936,.5305773615837097,-.017735809087753296,.8474509716033936,.5305773615837097,-.017735809087753296,.8474509716033936,.017751533538103104,-.8474733233451843,.5305410623550415,.017751533538103104,-.8474733233451843,.5305410623550415,.017751533538103104,-.8474733233451843,.5305410623550415,.017751533538103104,-.8474733233451843,.5305410623550415],normalized:!1},uv:{itemSize:2,type:"Float32Array",array:[.04446648806333542,.07376205921173096,.20145824551582336,.23582905530929565,.21539996564388275,.12743210792541504,.37534299492836,.25084298849105835,.04809992015361786,.08560597896575928,.057846054434776306,.11768478155136108,.1833210289478302,.12743109464645386,.7991840243339539,.7345119714736938,.04446648806333542,.10164541006088257,.05784609913825989,.009287774562835693,.1456916183233261,.009287774562835693,.9510290026664734,.7345119714736938,.029962755739688873,.009287834167480469,.08629150688648224,.11558711528778076,.16937947273254395,.23582905530929565,.29914700984954834,.9847790002822876,.09967105835676193,.11768478155136108,.12479200214147568,.5006319880485535,.13174988329410553,.06191825866699219,.14569158852100372,.23582911491394043,.10386674106121063,.11768478155136108,.1178082525730133,.12743109464645386,.12811647355556488,.059820473194122314,.2996180057525635,.7345709800720215,.04809992015361786,.07166439294815063,.1038665845990181,.12743091583251953,.2112043797969818,.12743210792541504,.4983850121498108,.5901579856872559,.04809992015361786,.08980154991149902,.04809992015361786,.1274309754371643,.06204163283109665,.11768478155136108,.9510089755058289,.23450398445129395,.04809992015361786,.11348932981491089,.07598327845335007,.11768478155136108,.11361270397901535,.11768472194671631,.24789699912071228,.8405579924583435,.1178082674741745,.009287655353546143,.15963312983512878,.23582905530929565,.2148379236459732,.11348950862884521,.7521880269050598,.34043699502944946,.04446648806333542,.04587888717651367,.22514608502388,.00928884744644165,.2390877902507782,.23582905530929565,.9978780150413513,.34043699502944946,.12811647355556488,.08770370483398438,.15963324904441833,.12743109464645386,.23908784985542297,.12743210792541504,.8750330209732056,.25118499994277954,.04809989035129547,.0437811017036438,.22934159636497498,.12743210792541504,.24328330159187317,.23582911491394043,.5490679740905762,.2342810034751892,.04446648806333542,.11558705568313599,.0717877745628357,.11768478155136108,.12755444645881653,.12743091583251953,.20090700685977936,.4844740033149719,.03415820747613907,.009287834167480469,.07178772985935211,.009287774562835693,.08992494642734528,.11768484115600586,.24783000349998474,.3400610089302063,.029962942004203796,.1274297833442688,.08629149198532104,.05982053279876709,.17357508838176727,.009289085865020752,.7481870055198669,.5902109742164612,.07598324865102768,.12743091583251953,.13174989819526672,.10374313592910767,.2153998762369156,.23582905530929565,.25249800086021423,.34009504318237305,.08629149198532104,.07376205921173096,.20145824551582336,.1274312138557434,.22934159636497498,.11768591403961182,.49818700551986694,.34009504318237305,.04446648806333542,.05982053279876709,.07598326355218887,.23582905530929565,.22514608502388,.23582905530929565,.29941999912261963,.48450803756713867,.04809989035129547,.04797661304473877,.2251461148262024,.12743210792541504,.22934159636497498,.009288787841796875,.45126500725746155,.48450803756713867,.04809992015361786,.0995476245880127,.14149606227874756,.009287774562835693,.14569158852100372,.12743109464645386,.24763700366020203,.5898839831352234,.08572941273450851,.23582905530929565,.12811647355556488,.04587888717651367,.1456916183233261,.11768472194671631,.9979509711265564,.5900989770889282,.04809992015361786,.10374313592910767,.062041595578193665,.009287774562835693,.14149613678455353,.12743109464645386,.7991650104522705,.23450398445129395,.08629149198532104,.04587888717651367,.18332113325595856,.23582911491394043,.2014583796262741,.11768490076065063,.7522619962692261,.5900989770889282,.08992491662502289,.0437811017036438,.18751657009124756,.23582905530929565,.23908784985542297,.11768591403961182,.6249899864196777,.0006160140037536621,.043904468417167664,.1274309754371643,.0444665253162384,.08770382404327393,.18751657009124756,.12743109464645386,.7478349804878235,.08986800909042358,.08572938293218613,.1274309754371643,.13174991309642792,.0758599042892456,.2014583796262741,.009289026260375977,.8751059770584106,.5008469820022583,.034158237278461456,.23582905530929565,.0899249017238617,.10374313592910767,.15543770790100098,.11768490076065063,.49791398644447327,.840366005897522,.020216554403305054,.1274297833442688,.13174991309642792,.11768472194671631,.15543778240680695,.009287893772125244,.3750689923763275,.751114010810852,.04913000017404556,.9849709868431091,.0899249017238617,.05772274732589722,.1693795919418335,.009289145469665527,.17357489466667175,.12743103504180908,.034158237278461456,.1274297833442688,.0899249017238617,.06191825866699219,.16937938332557678,.1274309754371643,.45099198818206787,.9847790002822876,.020216554403305054,.23582911491394043,.029962696135044098,.11768358945846558,.2148379534482956,.0995478630065918,.25222501158714294,.840366005897522,.034158363938331604,.11768358945846558,.09967107325792313,.23582905530929565,.12498500198125839,.2508090138435364,.2148379534482956,.10374337434768677,.016021236777305603,.1274297833442688,.10386674106121063,.009288907051086426,.12811647355556488,.11558699607849121,.2526949942111969,.5901579856872559,.1136128157377243,.12743109464645386,.13174988329410553,.05772268772125244,.14149603247642517,.23582905530929565,.7522420287132263,.09009099006652832,.020216554403305054,.009286701679229736,.04887000098824501,.734296977519989,.08629149198532104,.10164541006088257,.15963326394557953,.11768490076065063,.002139999996870756,.3400610089302063,.04809992015361786,.0758599042892456,.0996711403131485,.12743091583251953,.197262704372406,.23582911491394043,.016021013259887695,.23582905530929565,.1038665771484375,.23582905530929565,.21120451390743256,.1016455888748169,.37553998827934265,.5009059906005859,.043904371559619904,.23582905530929565,.04809992015361786,.05772274732589722,.22934159636497498,.23582905530929565,.7009119987487793,.2342810034751892,.057846151292324066,.23582905530929565,.11361275613307953,.009287714958190918,.12505200505256653,.7513059973716736,.2148379236459732,.11768490076065063,.0022070000413805246,.8405579924583435,.057846054434776306,.1274309754371643,.08629149198532104,.08770382404327393,.16937938332557678,.11768496036529541,.07598327845335007,.009287774562835693,.08992494642734528,.11348938941955566,.17357489466667175,.23582911491394043,.2009740024805069,.9849709868431091,.06204158067703247,.23582905530929565,.15543770790100098,.23582905530929565,.21120451390743256,.11558717489242554,.5491099953651428,.48442399501800537,.13174989819526672,.08560597896575928,.15543770790100098,.12743109464645386,.24328330159187317,.009288966655731201,.7009549736976624,.48442399501800537,.08992491662502289,.04797661304473877,.1972629427909851,.11768496036529541,.24328330159187317,.11768591403961182,.7478770017623901,.3400120139122009,.08992493152618408,.1274309754371643,.13174991309642792,.07166433334350586,.18751657009124756,.11768484115600586,.5024970173835754,.5902109742164612,.06204158067703247,.1274309754371643,.08992491662502289,.0898016095161438,.18332108855247498,.009287834167480469,.5021880269050598,.3400120139122009,.13174989819526672,.08980154991149902,.2390877902507782,.009288907051086426,.24328330159187317,.12743210792541504,.502144992351532,.08986800909042358,.049063000828027725,.4844740033149719,.0899249017238617,.07166439294815063,.12755438685417175,.23582905530929565,.19726276397705078,.1274312138557434,.08992491662502289,.08560603857040405,.17357507348060608,.11768496036529541,.18751657009124756,.009287834167480469,.6253420114517212,.5009589791297913,.1178082600235939,.23582905530929565,.13174989819526672,.0995476245880127,.2112043797969818,.23582905530929565,.4514620006084442,.7345709800720215,.07178780436515808,.1274309754371643,.11361271142959595,.23582905530929565,.12811647355556488,.10164541006088257,.8750870227813721,.0008389949798583984,.12811648845672607,.07376205921173096,.1833210289478302,.11768484115600586,.197262704372406,.009289026260375977,.6250330209732056,.25075995922088623,.0019470000406727195,.5898839831352234,.09967128932476044,.009288907051086426,.13174991309642792,.11348927021026611,.15963326394557953,.009287893772125244,.01602097600698471,.009286701679229736,.029962696135044098,.23582905530929565,.0899249017238617,.0995476245880127,.7012640237808228,.7346240282058716,.04809992015361786,.11768478155136108,.1178082674741745,.11768472194671631,.13174991309642792,.12743091583251953,.799111008644104,.4848499894142151,.0899249017238617,.0758599042892456,.13174991309642792,.23582911491394043,.22514614462852478,.11768591403961182,.9509549736976624,.4848499894142151,.04809992015361786,.06191825866699219,.04809992015361786,.23582905530929565,.07178771495819092,.23582905530929565,.9979320168495178,.09009099006652832,.020216554403305054,.11768358945846558,.13174989819526672,.047976553440093994,.14149612188339233,.11768472194671631,.20071400701999664,.734296977519989,.01602107286453247,.11768358945846558,.08992485702037811,.23582905530929565,.13174989819526672,.0437811017036438,.5494199991226196,.7346240282058716],normalized:!1},color:{itemSize:4,type:"Uint16Array",array:[65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535],normalized:!0}},index:{type:"Uint16Array",array:[17,212,141,107,7,11,43,39,223,59,130,144,158,116,167,151,23,203,91,231,207,199,183,239,75,71,3,103,191,51,171,179,211,186,182,198,149,146,129,133,16,20,108,60,217,205,21,136,157,221,36,202,2,26,119,14,166,49,74,154,161,168,184,33,57,53,178,189,98,229,100,152,102,93,97,148,112,132,232,216,236,194,222,54,173,37,45,104,237,180,138,82,90,12,128,56,86,81,234,73,204,230,46,50,190,94,210,177,147,69,195,226,78,41,9,30,89,118,197,62,0,145,24,162,185,196,65,201,206,105,181,208,76,48,40,172,44,188,113,214,134,109,218,142,32,52,220,4,101,28,13,58,165,8,88,80,68,224,193,159,38,170,72,228,153,92,176,96,126,150,131,121,117,61,18,137,22,85,233,238,114,143,215,15,111,115,235,83,141,83,17,141,11,87,107,107,95,7,223,227,43,43,47,39,192,55,144,55,59,144,167,35,158,158,160,116,203,27,151,151,135,23,207,139,91,91,31,231,219,63,239,63,199,239,3,67,75,75,79,71,51,155,103,103,99,191,211,187,171,171,175,179,186,209,182,149,25,146,133,213,16,108,120,60,205,200,21,157,34,221,202,66,2,119,122,14,49,77,74,161,156,168,33,164,57,178,174,189,229,29,100,102,6,93,148,124,112,232,140,216,194,225,222,173,169,37,104,84,237,138,19,82,12,125,128,86,10,81,73,64,204,46,42,50,94,106,210,147,1,69,226,70,78,9,5,30,118,163,197,114,110,143,115,127,15,15,123,111]},boundingSphere:{center:[0,0,0],radius:144.59226795520192}},rotationCombinations:{"1,2":[90,0,-90],"1,3":[-90,0,-90],"1,4":[-32,18,-58],"1,5":[32,18,58],"1,6":[0,0,180],"1,7":[-180,0,0],"1,8":[-148,-18,-58],"1,9":[-148,-18,122],"1,10":[-90,0,90],"1,11":[90,0,90],"1,12":[-180,0,-180],"2,3":[-180,0,-180],"2,4":[90,0,-90],"2,5":[90,0,90],"2,6":[-122,-90,148],"2,7":[-69,30,21],"2,8":[-90,0,-90],"2,9":[-32,18,122],"2,10":[-180,0,0],"2,11":[0,0,180],"2,12":[-148,54,122],"3,4":[32,18,58],"3,5":[90,0,-90],"3,6":[32,54,-58],"3,7":[-32,-54,122],"3,8":[-148,-18,122],"3,9":[-90,0,-90],"3,10":[-148,18,-122],"3,11":[-180,0,0],"3,12":[-122,-90,148],"4,5":[0,0,180],"4,6":[90,0,90],"4,7":[-90,0,90],"4,8":[-180,0,-180],"4,9":[-180,0,0],"4,10":[148,-54,-58],"4,11":[-122,-90,148],"4,12":[-90,0,-90],"5,6":[-90,0,-90],"5,7":[90,0,-90],"5,8":[-180,0,0],"5,9":[-180,0,-180],"5,10":[-148,-18,122],"5,11":[32,18,58],"5,12":[90,0,90],"6,7":[-180,0,-180],"6,8":[148,18,122],"6,9":[-122,-90,148],"6,10":[90,0,-90],"6,11":[-148,54,-58],"6,12":[-148,-18,-58],"7,8":[32,-18,-58],"7,9":[-69,30,21],"7,10":[148,54,58],"7,11":[-90,0,90],"7,12":[-32,54,58],"8,9":[0,0,180],"8,10":[-148,-18,-58],"8,11":[-148,-54,58],"8,12":[-90,0,90],"9,10":[-31,18,-58],"9,11":[-148,-90,-58],"9,12":[90,0,-90],"10,11":[-180,0,-180],"10,12":[-90,90,-180],"11,12":[148,-54,-58]}},d14:{metadata:{version:4.5,type:"BufferGeometry",generator:"BufferGeometry.toJSON"},uuid:"55E8EC8E-D9C5-4E75-86AC-BC4F49CF5FEA",type:"BufferGeometry",data:{attributes:{position:{itemSize:3,type:"Float32Array",array:[-3.3639726638793945,6.319602012634277,-77.80762481689453,-3.3639726638793945,6.319602012634277,-77.80762481689453,-3.3639726638793945,6.319602012634277,-77.80762481689453,-3.3639726638793945,6.319602012634277,-77.80762481689453,2.563892364501953,84.39848327636719,-5.970834732055664,2.563892364501953,84.39848327636719,-5.970834732055664,2.563892364501953,84.39848327636719,-5.970834732055664,2.563892364501953,84.39848327636719,-5.970834732055664,2.563892364501953,84.39848327636719,-5.970834732055664,75.92582702636719,-2.281585454940796,-17.299819946289062,75.92582702636719,-2.281585454940796,-17.299819946289062,75.92582702636719,-2.281585454940796,-17.299819946289062,75.92582702636719,-2.281585454940796,-17.299819946289062,4.9952239990234375,84.37457275390625,4.497790336608887,4.9952239990234375,84.37457275390625,4.497790336608887,4.9952239990234375,84.37457275390625,4.497790336608887,4.9952239990234375,84.37457275390625,4.497790336608887,4.9952239990234375,84.37457275390625,4.497790336608887,-30.552932739257812,6.355025291442871,71.34111022949219,-30.552932739257812,6.355025291442871,71.34111022949219,-30.552932739257812,6.355025291442871,71.34111022949219,-30.552932739257812,6.355025291442871,71.34111022949219,31.1562557220459,6.31425142288208,71.49166870117188,31.1562557220459,6.31425142288208,71.49166870117188,31.1562557220459,6.31425142288208,71.49166870117188,31.1562557220459,6.31425142288208,71.49166870117188,-74.74581909179688,-6.299898624420166,-20.404645919799805,-74.74581909179688,-6.299898624420166,-20.404645919799805,-74.74581909179688,-6.299898624420166,-20.404645919799805,-74.74581909179688,-6.299898624420166,-20.404645919799805,30.55293846130371,-6.35502815246582,-71.34111022949219,30.55293846130371,-6.35502815246582,-71.34111022949219,30.55293846130371,-6.35502815246582,-71.34111022949219,30.55293846130371,-6.35502815246582,-71.34111022949219,-31.1562557220459,-6.31424617767334,-71.49166870117188,-31.1562557220459,-6.31424617767334,-71.49166870117188,-31.1562557220459,-6.31424617767334,-71.49166870117188,-31.1562557220459,-6.31424617767334,-71.49166870117188,5.657160758972168,-84.42521667480469,-4.448384761810303,5.657160758972168,-84.42521667480469,-4.448384761810303,5.657160758972168,-84.42521667480469,-4.448384761810303,5.657160758972168,-84.42521667480469,-4.448384761810303,5.657160758972168,-84.42521667480469,-4.448384761810303,62.504119873046875,-6.354261875152588,46.30989074707031,62.504119873046875,-6.354261875152588,46.30989074707031,62.504119873046875,-6.354261875152588,46.30989074707031,62.504119873046875,-6.354261875152588,46.30989074707031,7.009031295776367,-84.40763854980469,1.33268404006958,7.009031295776367,-84.40763854980469,1.33268404006958,7.009031295776367,-84.40763854980469,1.33268404006958,7.009031295776367,-84.40763854980469,1.33268404006958,7.009031295776367,-84.40763854980469,1.33268404006958,75.9446792602539,-6.379278182983398,-14.266926765441895,75.9446792602539,-6.379278182983398,-14.266926765441895,75.9446792602539,-6.379278182983398,-14.266926765441895,75.9446792602539,-6.379278182983398,-14.266926765441895,3.3639724254608154,-6.31959867477417,77.8076171875,3.3639724254608154,-6.31959867477417,77.8076171875,3.3639724254608154,-6.31959867477417,77.8076171875,3.3639724254608154,-6.31959867477417,77.8076171875,3.3671836853027344,-84.35977935791016,6.014355659484863,3.3671836853027344,-84.35977935791016,6.014355659484863,3.3671836853027344,-84.35977935791016,6.014355659484863,3.3671836853027344,-84.35977935791016,6.014355659484863,3.3671836853027344,-84.35977935791016,6.014355659484863,34.1295166015625,2.239828109741211,70.8094711303711,34.1295166015625,2.239828109741211,70.8094711303711,34.1295166015625,2.239828109741211,70.8094711303711,34.1295166015625,2.239828109741211,70.8094711303711,-75.9446792602539,6.379278182983398,14.26693058013916,-75.9446792602539,6.379278182983398,14.26693058013916,-75.9446792602539,6.379278182983398,14.26693058013916,-75.9446792602539,6.379278182983398,14.26693058013916,-76.03756713867188,-6.302979946136475,-14.609931945800781,-76.03756713867188,-6.302979946136475,-14.609931945800781,-76.03756713867188,-6.302979946136475,-14.609931945800781,-76.03756713867188,-6.302979946136475,-14.609931945800781,-76.0564956665039,-2.211188554763794,-17.664764404296875,-76.0564956665039,-2.211188554763794,-17.664764404296875,-76.0564956665039,-2.211188554763794,-17.664764404296875,-76.0564956665039,-2.211188554763794,-17.664764404296875,-62.504119873046875,6.354262351989746,-46.30989074707031,-62.504119873046875,6.354262351989746,-46.30989074707031,-62.504119873046875,6.354262351989746,-46.30989074707031,-62.504119873046875,6.354262351989746,-46.30989074707031,-61.1809196472168,2.2734644412994385,-49.07624435424805,-61.1809196472168,2.2734644412994385,-49.07624435424805,-61.1809196472168,2.2734644412994385,-49.07624435424805,-61.1809196472168,2.2734644412994385,-49.07624435424805,-58.829193115234375,6.3529181480407715,-50.964759826660156,-58.829193115234375,6.3529181480407715,-50.964759826660156,-58.829193115234375,6.3529181480407715,-50.964759826660156,-58.829193115234375,6.3529181480407715,-50.964759826660156,-36.493858337402344,-6.314887523651123,-68.91082763671875,-36.493858337402344,-6.314887523651123,-68.91082763671875,-36.493858337402344,-6.314887523651123,-68.91082763671875,-36.493858337402344,-6.314887523651123,-68.91082763671875,58.31211471557617,6.307106018066406,-50.69571304321289,58.31211471557617,6.307106018066406,-50.69571304321289,58.31211471557617,6.307106018066406,-50.69571304321289,58.31211471557617,6.307106018066406,-50.69571304321289,62.011024475097656,6.3075995445251465,-46.048179626464844,62.011024475097656,6.3075995445251465,-46.048179626464844,62.011024475097656,6.3075995445251465,-46.048179626464844,62.011024475097656,6.3075995445251465,-46.048179626464844,74.60848999023438,-6.379120826721191,-20.05154037475586,74.60848999023438,-6.379120826721191,-20.05154037475586,74.60848999023438,-6.379120826721191,-20.05154037475586,74.60848999023438,-6.379120826721191,-20.05154037475586,76.0564956665039,2.2111899852752686,17.664772033691406,76.0564956665039,2.2111899852752686,17.664772033691406,76.0564956665039,2.2111899852752686,17.664772033691406,76.0564956665039,2.2111899852752686,17.664772033691406,74.74581909179688,6.299901008605957,20.404653549194336,74.74581909179688,6.299901008605957,20.404653549194336,74.74581909179688,6.299901008605957,20.404653549194336,74.74581909179688,6.299901008605957,20.404653549194336,36.493858337402344,6.3148884773254395,68.91082763671875,36.493858337402344,6.3148884773254395,68.91082763671875,36.493858337402344,6.3148884773254395,68.91082763671875,36.493858337402344,6.3148884773254395,68.91082763671875,-2.5638914108276367,-84.39848327636719,5.9708333015441895,-2.5638914108276367,-84.39848327636719,5.9708333015441895,-2.5638914108276367,-84.39848327636719,5.9708333015441895,-2.5638914108276367,-84.39848327636719,5.9708333015441895,-2.5638914108276367,-84.39848327636719,5.9708333015441895,.3401651680469513,-84.3684310913086,-7.083171844482422,.3401651680469513,-84.3684310913086,-7.083171844482422,.3401651680469513,-84.3684310913086,-7.083171844482422,.3401651680469513,-84.3684310913086,-7.083171844482422,.3401651680469513,-84.3684310913086,-7.083171844482422,-5.657160758972168,84.42522430419922,4.448385238647461,-5.657160758972168,84.42522430419922,4.448385238647461,-5.657160758972168,84.42522430419922,4.448385238647461,-5.657160758972168,84.42522430419922,4.448385238647461,-5.657160758972168,84.42522430419922,4.448385238647461,-.4000111222267151,2.242583751678467,-78.4876937866211,-.4000111222267151,2.242583751678467,-78.4876937866211,-.4000111222267151,2.242583751678467,-78.4876937866211,-.4000111222267151,2.242583751678467,-78.4876937866211,-34.1295166015625,-2.239827871322632,-70.8094711303711,-34.1295166015625,-2.239827871322632,-70.8094711303711,-34.1295166015625,-2.239827871322632,-70.8094711303711,-34.1295166015625,-2.239827871322632,-70.8094711303711,2.5671069622039795,6.321245193481445,-77.7981948852539,2.5671069622039795,6.321245193481445,-77.7981948852539,2.5671069622039795,6.321245193481445,-77.7981948852539,2.5671069622039795,6.321245193481445,-77.7981948852539,60.691749572753906,2.211258888244629,-48.80388641357422,60.691749572753906,2.211258888244629,-48.80388641357422,60.691749572753906,2.211258888244629,-48.80388641357422,60.691749572753906,2.211258888244629,-48.80388641357422,35.8908576965332,-6.357795238494873,-68.75081634521484,35.8908576965332,-6.357795238494873,-68.75081634521484,35.8908576965332,-6.357795238494873,-68.75081634521484,35.8908576965332,-6.357795238494873,-68.75081634521484,33.49201583862305,-2.268580436706543,-70.65808868408203,33.49201583862305,-2.268580436706543,-70.65808868408203,33.49201583862305,-2.268580436706543,-70.65808868408203,33.49201583862305,-2.268580436706543,-70.65808868408203,76.03756713867188,6.302982807159424,14.609939575195312,76.03756713867188,6.302982807159424,14.609939575195312,76.03756713867188,6.302982807159424,14.609939575195312,76.03756713867188,6.302982807159424,14.609939575195312,61.1809196472168,-2.2734615802764893,49.07624435424805,61.1809196472168,-2.2734615802764893,49.07624435424805,61.1809196472168,-2.2734615802764893,49.07624435424805,61.1809196472168,-2.2734615802764893,49.07624435424805,-58.31211471557617,-6.307102203369141,50.69571304321289,-58.31211471557617,-6.307102203369141,50.69571304321289,-58.31211471557617,-6.307102203369141,50.69571304321289,-58.31211471557617,-6.307102203369141,50.69571304321289,-33.49201202392578,2.268582582473755,70.65808868408203,-33.49201202392578,2.268582582473755,70.65808868408203,-33.49201202392578,2.268582582473755,70.65808868408203,-33.49201202392578,2.268582582473755,70.65808868408203,-35.8908576965332,6.357793807983398,68.75082397460938,-35.8908576965332,6.357793807983398,68.75082397460938,-35.8908576965332,6.357793807983398,68.75082397460938,-35.8908576965332,6.357793807983398,68.75082397460938,-2.567105293273926,-6.321239948272705,77.7981948852539,-2.567105293273926,-6.321239948272705,77.7981948852539,-2.567105293273926,-6.321239948272705,77.7981948852539,-2.567105293273926,-6.321239948272705,77.7981948852539,.40001073479652405,-2.242581844329834,78.4876937866211,.40001073479652405,-2.242581844329834,78.4876937866211,.40001073479652405,-2.242581844329834,78.4876937866211,.40001073479652405,-2.242581844329834,78.4876937866211,-60.69174575805664,-2.211254835128784,48.803897857666016,-60.69174575805664,-2.211254835128784,48.803897857666016,-60.69174575805664,-2.211254835128784,48.803897857666016,-60.69174575805664,-2.211254835128784,48.803897857666016,-74.60848999023438,6.379125595092773,20.051544189453125,-74.60848999023438,6.379125595092773,20.051544189453125,-74.60848999023438,6.379125595092773,20.051544189453125,-74.60848999023438,6.379125595092773,20.051544189453125,-75.92582702636719,2.2815887928009033,17.29982566833496,-75.92582702636719,2.2815887928009033,17.29982566833496,-75.92582702636719,2.2815887928009033,17.29982566833496,-75.92582702636719,2.2815887928009033,17.29982566833496,-62.011024475097656,-6.307600975036621,46.04818344116211,-62.011024475097656,-6.307600975036621,46.04818344116211,-62.011024475097656,-6.307600975036621,46.04818344116211,-62.011024475097656,-6.307600975036621,46.04818344116211,-6.242546081542969,-84.4273681640625,1.3070549964904785,-6.242546081542969,-84.4273681640625,1.3070549964904785,-6.242546081542969,-84.4273681640625,1.3070549964904785,-6.242546081542969,-84.4273681640625,1.3070549964904785,-6.242546081542969,-84.4273681640625,1.3070549964904785,-4.99522066116333,-84.37457275390625,-4.497788429260254,-4.99522066116333,-84.37457275390625,-4.497788429260254,-4.99522066116333,-84.37457275390625,-4.497788429260254,-4.99522066116333,-84.37457275390625,-4.497788429260254,-4.99522066116333,-84.37457275390625,-4.497788429260254,58.829200744628906,-6.3529205322265625,50.964759826660156,58.829200744628906,-6.3529205322265625,50.964759826660156,58.829200744628906,-6.3529205322265625,50.964759826660156,58.829200744628906,-6.3529205322265625,50.964759826660156,-.34016573429107666,84.3684310913086,7.083171844482422,-.34016573429107666,84.3684310913086,7.083171844482422,-.34016573429107666,84.3684310913086,7.083171844482422,-.34016573429107666,84.3684310913086,7.083171844482422,-.34016573429107666,84.3684310913086,7.083171844482422,6.242546081542969,84.4273681640625,-1.307053804397583,6.242546081542969,84.4273681640625,-1.307053804397583,6.242546081542969,84.4273681640625,-1.307053804397583,6.242546081542969,84.4273681640625,-1.307053804397583,6.242546081542969,84.4273681640625,-1.307053804397583,-3.3671834468841553,84.35977935791016,-6.0143561363220215,-3.3671834468841553,84.35977935791016,-6.0143561363220215,-3.3671834468841553,84.35977935791016,-6.0143561363220215,-3.3671834468841553,84.35977935791016,-6.0143561363220215,-3.3671834468841553,84.35977935791016,-6.0143561363220215,-7.009029865264893,84.40763854980469,-1.3326834440231323,-7.009029865264893,84.40763854980469,-1.3326834440231323,-7.009029865264893,84.40763854980469,-1.3326834440231323,-7.009029865264893,84.40763854980469,-1.3326834440231323,-7.009029865264893,84.40763854980469,-1.3326834440231323,-.36670994758605957,87.28189849853516,.20025108754634857,-.36670994758605957,87.28189849853516,.20025108754634857,-.36670994758605957,87.28189849853516,.20025108754634857,-.36670994758605957,87.28189849853516,.20025108754634857,-.36670994758605957,87.28189849853516,.20025108754634857,-.36670994758605957,87.28189849853516,.20025108754634857,-.36670994758605957,87.28189849853516,.20025108754634857,.366711288690567,-87.28191375732422,-.2002510279417038,.366711288690567,-87.28191375732422,-.2002510279417038,.366711288690567,-87.28191375732422,-.2002510279417038,.366711288690567,-87.28191375732422,-.2002510279417038,.366711288690567,-87.28191375732422,-.2002510279417038,.366711288690567,-87.28191375732422,-.2002510279417038,.366711288690567,-87.28191375732422,-.2002510279417038],normalized:!1},normal:{itemSize:3,type:"Float32Array",array:[-.28516727685928345,.6296403408050537,-.7226566076278687,-.28516727685928345,.6296403408050537,-.7226566076278687,-.28516727685928345,.6296403408050537,-.7226566076278687,-.28516727685928345,.6296403408050537,-.7226566076278687,.3280982971191406,.6602655649185181,-.6755744218826294,.3280982971191406,.6602655649185181,-.6755744218826294,.3280982971191406,.6602655649185181,-.6755744218826294,.3280982971191406,.6602655649185181,-.6755744218826294,.3280982971191406,.6602655649185181,-.6755744218826294,.7842698693275452,.5933358073234558,-.18131035566329956,.7842698693275452,.5933358073234558,-.18131035566329956,.7842698693275452,.5933358073234558,-.18131035566329956,.7842698693275452,.5933358073234558,-.18131035566329956,.589374303817749,.6605231761932373,.46513107419013977,.589374303817749,.6605231761932373,.46513107419013977,.589374303817749,.6605231761932373,.46513107419013977,.589374303817749,.6605231761932373,.46513107419013977,.589374303817749,.6605231761932373,.46513107419013977,-.059090327471494675,.6272545456886292,.7765694260597229,-.059090327471494675,.6272545456886292,.7765694260597229,-.059090327471494675,.6272545456886292,.7765694260597229,-.059090327471494675,.6272545456886292,.7765694260597229,.05634559690952301,.6280144453048706,.7761592268943787,.05634559690952301,.6280144453048706,.7761592268943787,.05634559690952301,.6280144453048706,.7761592268943787,.05634559690952301,.6280144453048706,.7761592268943787,-.6443470120429993,-.6290098428726196,-.43492940068244934,-.6443470120429993,-.6290098428726196,-.43492940068244934,-.6443470120429993,-.6290098428726196,-.43492940068244934,-.6443470120429993,-.6290098428726196,-.43492940068244934,.05909096822142601,-.6272543668746948,-.7765696048736572,.05909096822142601,-.6272543668746948,-.7765696048736572,.05909096822142601,-.6272543668746948,-.7765696048736572,.05909096822142601,-.6272543668746948,-.7765696048736572,-.05632945895195007,-.6280063986778259,-.7761667966842651,-.05632945895195007,-.6280063986778259,-.7761667966842651,-.05632945895195007,-.6280063986778259,-.7761667966842651,-.05632945895195007,-.6280063986778259,-.7761667966842651,.5910056829452515,-.6553013920783997,-.4704173803329468,.5910056829452515,-.6553013920783997,-.4704173803329468,.5910056829452515,-.6553013920783997,-.4704173803329468,.5910056829452515,-.6553013920783997,-.4704173803329468,.5910056829452515,-.6553013920783997,-.4704173803329468,.7470955848693848,-.6255302429199219,.22485576570034027,.7470955848693848,-.6255302429199219,.22485576570034027,.7470955848693848,-.6255302429199219,.22485576570034027,.7470955848693848,-.6255302429199219,.22485576570034027,.7361034154891968,-.6567224264144897,.16391272842884064,.7361034154891968,-.6567224264144897,.16391272842884064,.7361034154891968,-.6567224264144897,.16391272842884064,.7361034154891968,-.6567224264144897,.16391272842884064,.7361034154891968,-.6567224264144897,.16391272842884064,.7726380228996277,-.6246670484542847,.11323241889476776,.7726380228996277,-.6246670484542847,.11323241889476776,.7726380228996277,-.6246670484542847,.11323241889476776,.7726380228996277,-.6246670484542847,.11323241889476776,.2852247953414917,-.6296125650405884,.7226580381393433,.2852247953414917,-.6296125650405884,.7226580381393433,.2852247953414917,-.6296125650405884,.7226580381393433,.2852247953414917,-.6296125650405884,.7226580381393433,.32667452096939087,-.6607898473739624,.6757517457008362,.32667452096939087,-.6607898473739624,.6757517457008362,.32667452096939087,-.6607898473739624,.6757517457008362,.32667452096939087,-.6607898473739624,.6757517457008362,.32667452096939087,-.6607898473739624,.6757517457008362,.3497964143753052,-.5950561165809631,.7235679030418396,.3497964143753052,-.5950561165809631,.7235679030418396,.3497964143753052,-.5950561165809631,.7235679030418396,.3497964143753052,-.5950561165809631,.7235679030418396,-.7726274132728577,.6246878504753113,-.11318989098072052,-.7726274132728577,.6246878504753113,-.11318989098072052,-.7726274132728577,.6246878504753113,-.11318989098072052,-.7726274132728577,.6246878504753113,-.11318989098072052,-.7692402005195618,-.6276887655258179,.11948297917842865,-.7692402005195618,-.6276887655258179,.11948297917842865,-.7692402005195618,-.6276887655258179,.11948297917842865,-.7692402005195618,-.6276887655258179,.11948297917842865,-.7877770662307739,.5905534625053406,-.17508289217948914,-.7877770662307739,.5905534625053406,-.17508289217948914,-.7877770662307739,.5905534625053406,-.17508289217948914,-.7877770662307739,.5905534625053406,-.17508289217948914,-.7470952868461609,.6255304217338562,-.22485589981079102,-.7470952868461609,.6255304217338562,-.22485589981079102,-.7470952868461609,.6255304217338562,-.22485589981079102,-.7470952868461609,.6255304217338562,-.22485589981079102,-.631263256072998,-.5948466658592224,-.4976588785648346,-.631263256072998,-.5948466658592224,-.4976588785648346,-.631263256072998,-.5948466658592224,-.4976588785648346,-.631263256072998,-.5948466658592224,-.4976588785648346,-.38938289880752563,.6292169094085693,-.6726565957069397,-.38938289880752563,.6292169094085693,-.6726565957069397,-.38938289880752563,.6292169094085693,-.6726565957069397,-.38938289880752563,.6292169094085693,-.6726565957069397,-.5729118585586548,-.6292456388473511,-.5251874923706055,-.5729118585586548,-.6292456388473511,-.5251874923706055,-.5729118585586548,-.6292456388473511,-.5251874923706055,-.5729118585586548,-.6292456388473511,-.5251874923706055,.3904346227645874,.628699541091919,-.6725307703018188,.3904346227645874,.628699541091919,-.6725307703018188,.3904346227645874,.628699541091919,-.6725307703018188,.3904346227645874,.628699541091919,-.6725307703018188,.7437728643417358,.6275497078895569,-.2301807701587677,.7437728643417358,.6275497078895569,-.2301807701587677,.7437728643417358,.6275497078895569,-.2301807701587677,.7437728643417358,.6275497078895569,-.2301807701587677,.6457582712173462,-.6233645677566528,-.4409227967262268,.6457582712173462,-.6233645677566528,-.4409227967262268,.6457582712173462,-.6233645677566528,-.4409227967262268,.6457582712173462,-.6233645677566528,-.4409227967262268,.7877867221832275,-.5905534029006958,.17503942549228668,.7877867221832275,-.5905534029006958,.17503942549228668,.7877867221832275,-.5905534029006958,.17503942549228668,.7877867221832275,-.5905534029006958,.17503942549228668,.6443431377410889,.6290005445480347,.43494871258735657,.6443431377410889,.6290005445480347,.43494871258735657,.6443431377410889,.6290005445480347,.43494871258735657,.6443431377410889,.6290005445480347,.43494871258735657,.5729120969772339,.6292457580566406,.5251871347427368,.5729120969772339,.6292457580566406,.5251871347427368,.5729120969772339,.6292457580566406,.5251871347427368,.5729120969772339,.6292457580566406,.5251871347427368,-.3281112611293793,-.6602649092674255,.6755688190460205,-.3281112611293793,-.6602649092674255,.6755688190460205,-.3281112611293793,-.6602649092674255,.6755688190460205,-.3281112611293793,-.6602649092674255,.6755688190460205,-.3281112611293793,-.6602649092674255,.6755688190460205,.0011704713106155396,-.6591591238975525,-.7520025968551636,.0011704713106155396,-.6591591238975525,-.7520025968551636,.0011704713106155396,-.6591591238975525,-.7520025968551636,.0011704713106155396,-.6591591238975525,-.7520025968551636,.0011704713106155396,-.6591591238975525,-.7520025968551636,-.5910052061080933,.6553022861480713,.47041675448417664,-.5910052061080933,.6553022861480713,.47041675448417664,-.5910052061080933,.6553022861480713,.47041675448417664,-.5910052061080933,.6553022861480713,.47041675448417664,-.5910052061080933,.6553022861480713,.47041675448417664,.0015861615538597107,-.5931890606880188,-.8050615787506104,.0015861615538597107,-.5931890606880188,-.8050615787506104,.0015861615538597107,-.5931890606880188,-.8050615787506104,.0015861615538597107,-.5931890606880188,-.8050615787506104,-.34979522228240967,.5950555801391602,-.7235690355300903,-.34979522228240967,.5950555801391602,-.7235690355300903,-.34979522228240967,.5950555801391602,-.7235690355300903,-.34979522228240967,.5950555801391602,-.7235690355300903,.2873671054840088,.6291413903236389,-.7222195863723755,.2873671054840088,.6291413903236389,-.7222195863723755,.2873671054840088,.6291413903236389,-.7222195863723755,.2873671054840088,.6291413903236389,-.7222195863723755,.6324546933174133,-.5889533758163452,-.5031253695487976,.6324546933174133,-.5889533758163452,-.5031253695487976,.6324546933174133,-.5889533758163452,-.5031253695487976,.6324546933174133,-.5889533758163452,-.5031253695487976,.574481725692749,-.6237778663635254,-.5299734473228455,.574481725692749,-.6237778663635254,-.5299734473228455,.574481725692749,-.6237778663635254,-.5299734473228455,.574481725692749,-.6237778663635254,-.5299734473228455,.35163187980651855,.594671368598938,-.7229945659637451,.35163187980651855,.594671368598938,-.7229945659637451,.35163187980651855,.594671368598938,-.7229945659637451,.35163187980651855,.594671368598938,-.7229945659637451,.7692419290542603,.6276857852935791,-.11948888003826141,.7692419290542603,.6276857852935791,-.11948888003826141,.7692419290542603,.6276857852935791,-.11948888003826141,.7692419290542603,.6276857852935791,-.11948888003826141,.6312867403030396,.5948468446731567,.49762865900993347,.6312867403030396,.5948468446731567,.49762865900993347,.6312867403030396,.5948468446731567,.49762865900993347,.6312867403030396,.5948468446731567,.49762865900993347,-.3904343545436859,-.6286999583244324,.6725306510925293,-.3904343545436859,-.6286999583244324,.6725306510925293,-.3904343545436859,-.6286999583244324,.6725306510925293,-.3904343545436859,-.6286999583244324,.6725306510925293,-.3516600430011749,-.5946711301803589,.7229809761047363,-.3516600430011749,-.5946711301803589,.7229809761047363,-.3516600430011749,-.5946711301803589,.7229809761047363,-.3516600430011749,-.5946711301803589,.7229809761047363,-.5744823813438416,.6237770915031433,.5299737453460693,-.5744823813438416,.6237770915031433,.5299737453460693,-.5744823813438416,.6237770915031433,.5299737453460693,-.5744823813438416,.6237770915031433,.5299737453460693,-.28738611936569214,-.6291320323944092,.722220242023468,-.28738611936569214,-.6291320323944092,.722220242023468,-.28738611936569214,-.6291320323944092,.722220242023468,-.28738611936569214,-.6291320323944092,.722220242023468,-.0015616416931152344,.5931897759437561,.8050611615180969,-.0015616416931152344,.5931897759437561,.8050611615180969,-.0015616416931152344,.5931897759437561,.8050611615180969,-.0015616416931152344,.5931897759437561,.8050611615180969,-.632463812828064,.5889529585838318,.5031142830848694,-.632463812828064,.5889529585838318,.5031142830848694,-.632463812828064,.5889529585838318,.5031142830848694,-.632463812828064,.5889529585838318,.5031142830848694,-.6457580924034119,.6233644485473633,.44092315435409546,-.6457580924034119,.6233644485473633,.44092315435409546,-.6457580924034119,.6233644485473633,.44092315435409546,-.6457580924034119,.6233644485473633,.44092315435409546,-.7842698097229004,-.593335747718811,.18131089210510254,-.7842698097229004,-.593335747718811,.18131089210510254,-.7842698097229004,-.593335747718811,.18131089210510254,-.7842698097229004,-.593335747718811,.18131089210510254,-.7437704205513,-.6275736689567566,.23012343049049377,-.7437704205513,-.6275736689567566,.23012343049049377,-.7437704205513,-.6275736689567566,.23012343049049377,-.7437704205513,-.6275736689567566,.23012343049049377,-.7328628301620483,-.6589818596839905,.16927775740623474,-.7328628301620483,-.6589818596839905,.16927775740623474,-.7328628301620483,-.6589818596839905,.16927775740623474,-.7328628301620483,-.6589818596839905,.16927775740623474,-.7328628301620483,-.6589818596839905,.16927775740623474,-.5893685817718506,-.6605226993560791,-.4651390612125397,-.5893685817718506,-.6605226993560791,-.4651390612125397,-.5893685817718506,-.6605226993560791,-.4651390612125397,-.5893685817718506,-.6605226993560791,-.4651390612125397,-.5893685817718506,-.6605226993560791,-.4651390612125397,.38937872648239136,-.6292127966880798,.6726629734039307,.38937872648239136,-.6292127966880798,.6726629734039307,.38937872648239136,-.6292127966880798,.6726629734039307,.38937872648239136,-.6292127966880798,.6726629734039307,-.0011698007583618164,.6591596007347107,.7520022988319397,-.0011698007583618164,.6591596007347107,.7520022988319397,-.0011698007583618164,.6591596007347107,.7520022988319397,-.0011698007583618164,.6591596007347107,.7520022988319397,-.0011698007583618164,.6591596007347107,.7520022988319397,.7328664064407349,.6589823961257935,-.16926002502441406,.7328664064407349,.6589823961257935,-.16926002502441406,.7328664064407349,.6589823961257935,-.16926002502441406,.7328664064407349,.6589823961257935,-.16926002502441406,.7328664064407349,.6589823961257935,-.16926002502441406,-.3266833424568176,.6607902646064758,-.6757471561431885,-.3266833424568176,.6607902646064758,-.6757471561431885,-.3266833424568176,.6607902646064758,-.6757471561431885,-.3266833424568176,.6607902646064758,-.6757471561431885,-.3266833424568176,.6607902646064758,-.6757471561431885,-.7360942959785461,.6567226648330688,-.16395282745361328,-.7360942959785461,.6567226648330688,-.16395282745361328,-.7360942959785461,.6567226648330688,-.16395282745361328,-.7360942959785461,.6567226648330688,-.16395282745361328,-.7360942959785461,.6567226648330688,-.16395282745361328,.0001270859647775069,1,6240241782506928e-20,.0001270859647775069,1,6240241782506928e-20,.0001270859647775069,1,6240241782506928e-20,.0001270859647775069,1,6240241782506928e-20,.0001270859647775069,1,6240241782506928e-20,.0001270859647775069,1,6240241782506928e-20,.0001270859647775069,1,6240241782506928e-20,-.00012663456436712295,-1,-6260263762669638e-20,-.00012663456436712295,-1,-6260263762669638e-20,-.00012663456436712295,-1,-6260263762669638e-20,-.00012663456436712295,-1,-6260263762669638e-20,-.00012663456436712295,-1,-6260263762669638e-20,-.00012663456436712295,-1,-6260263762669638e-20,-.00012663456436712295,-1,-6260263762669638e-20],normalized:!1},uv:{itemSize:2,type:"Float32Array",array:[.012080706655979156,.01143413782119751,.02038293331861496,.2402452826499939,.07275813817977905,.7014026641845703,.23399420082569122,.044198572635650635,.012080706655979156,.09173142910003662,.09271499514579773,.0920637845993042,.22834762930870056,.033225297927856445,.24569767713546753,.027156472206115723,.8750260472297668,.27947235107421875,.15672194957733154,.03217524290084839,.15672194957733154,.040720343589782715,.21759822964668274,.041023433208465576,.624879777431488,.4702685475349426,.04823240637779236,.03318381309509277,.07462695240974426,.2401202917098999,.1386493444442749,.24023151397705078,.20049551129341125,.03662097454071045,.3756515383720398,.27943485975265503,.04823240637779236,.08685857057571411,.07282328605651855,.45090705156326294,.16252003610134125,.018233835697174072,.2011767327785492,.2402452826499939,.1273123025894165,.01617354154586792,.14694836735725403,.09188961982727051,.17717677354812622,.4513193964958191,.25039011240005493,.08733206987380981,.04823240637779236,.09189057350158691,.05499856173992157,.009189963340759277,.0725666880607605,.9514256715774536,.14694836735725403,.043423593044281006,.07372921705245972,.016311585903167725,.07462692260742188,.08685952425003052,.21925535798072815,.09241074323654175,.4275488257408142,.9517285227775574,.12057686597108841,.09188848733901978,.14611805975437164,.009021878242492676,.22737187147140503,.08733206987380981,.32245123386383057,.9515766501426697,.11080294847488403,.026038765907287598,.12057653814554214,.029400944709777832,.21095037460327148,.2402452826499939,.24711300432682037,.0928187370300293,.6267523169517517,.7800135612487793,.09018958359956741,.008709728717803955,.12057658284902573,.04346507787704468,.1830982267856598,.09213989973068237,.9277936816215515,.951744794845581,.10317572951316833,.0293390154838562,.1393822878599167,.032990872859954834,.1830982267856598,.2402452826499939,.255423367023468,.09287703037261963,.8746025562286377,.7797321677207947,.16253256797790527,.03631782531738281,.16336379945278168,.04333001375198364,.2554234266281128,.2402452826499939,.8222063779830933,.9510524272918701,.03845880925655365,.09173208475112915,.10992515832185745,.01626521348953247,.24376779794692993,.04419851303100586,.42733103036880493,.701709508895874,.03845880925655365,.026774346828460693,.03845880925655365,.24016445875167847,.14694836735725403,.036410391330718994,.174796923995018,.24008393287658691,.37455111742019653,.5295032858848572,.03845880925655365,.08928269147872925,.1273123025894165,.009048819541931152,.24376779794692993,.08995997905731201,.37507760524749756,.7204967141151428,.17645640671253204,.043330609798431396,.21771717071533203,.016403138637542725,.22902902960777283,.2402452826499939,.6778356432914734,.20166105031967163,.04823240637779236,.014015018939971924,.056542813777923584,.09192115068435669,.1830982267856598,.08697599172592163,.9278727769851685,.7018176913261414,.05499856173992157,.0163193941116333,.1403140127658844,.040812790393829346,.17645637691020966,.08961743116378784,.6247076988220215,.22033452987670898,.140313982963562,.08676266670227051,.15672211349010468,.09213924407958984,.18057595193386078,.017045259475708008,.5721643567085266,.201244056224823,.012080706655979156,.08928197622299194,.12499088048934937,.9704728722572327,.14694836735725403,.08941596746444702,.17478692531585693,.012857019901275635,.018697038292884827,.08670186996459961,.16502328217029572,.09206610918045044,.17724192142486572,.7014986276626587,.18057595193386078,.008743643760681152,.012080706655979156,.04335254430770874,.12887565791606903,.09186422824859619,.1393822878599167,.013869822025299072,.1774333119392395,.9517008662223816,.09104300290346146,.04336506128311157,.09271499514579773,.2402452826499939,.19964106380939484,.009263157844543457,.8223589658737183,.45139479637145996,.08440056443214417,.24022287130355835,.1928718537092209,.014091014862060547,.21759822964668274,.08731919527053833,.6777778267860413,.45166242122650146,.16253256797790527,.02800750732421875,.21095037460327148,.04365772008895874,.24711309373378754,.24022060632705688,.6778541803359985,.951484739780426,.12057655304670334,.08941489458084106,.16336379945278168,.08961677551269531,.2351137399673462,.009227573871612549,.8750938177108765,.9702678322792053,.07462695240974426,.0918915867805481,.12721094489097595,.0868040919303894,.2351137399673462,.0163571834564209,.4274844527244568,.45174920558929443,.031842514872550964,.08667910099029541,.12057653814554214,.011325597763061523,.13864925503730774,.09186530113220215,.3225155472755432,.45152556896209717,.012080706655979156,.03307300806045532,.030156202614307404,.026774346828460693,.030156515538692474,.2402452826499939,.10248857736587524,.092063307762146,.6261616945266724,.5296865701675415,.12057653814554214,.2402452826499939,.1281311959028244,.025947153568267822,.21095037460327148,.029455959796905518,.21925535798072815,.2400715947151184,.3766971230506897,.7794159054756165,.07462692260742188,.02608513832092285,.1928718537092209,.09240931272506714,.23733942210674286,.0928187370300293,.24569767713546753,.007925331592559814,.875484049320221,.02962595224380493,.01882428675889969,.009150922298431396,.07462692260742188,.04079252481460571,.22737182676792145,.04158461093902588,.37476611137390137,.9705840945243835,.018697038292884827,.0407489538192749,.12485933303833008,.7203324437141418,.14611805975437164,.016146481037139893,.23399420082569122,.08995997905731201,.012080781161785126,.24023497104644775,.01882428675889969,.01627671718597412,.06800204515457153,.04341691732406616,.9276410341262817,.4518194794654846,.08440056443214417,.04074656963348389,.19964106380939484,.01640307903289795,.21095037460327148,.08995997905731201,.6247829794883728,.9699863791465759,.06695697456598282,.011504054069519043,.08440056443214417,.08688396215438843,.21095052361488342,.09248226881027222,.5721458196640015,.9508618116378784,.06800201535224915,.0894421935081482,.07372921705245972,.009201109409332275,.09104300290346146,.08953815698623657,.8750190138816833,.47052764892578125,.06631660461425781,.09192222356796265,.15672194957733154,.08697539567947388,.22834759950637817,.011532008647918701,.5722221732139587,.4511365294456482,.03184248507022858,.04074972867965698,.08440056443214417,.012897908687591553,.12721094489097595,.04081183671951294,.374919056892395,.47056519985198975,.030156202614307404,.014692902565002441,.10248860716819763,.2402452826499939,.10416048020124435,.043364644050598145,.6775245070457458,.7015867233276367,.054857321083545685,.08944112062454224,.10416045039892197,.08953768014907837,.15672194957733154,.014117896556854248,.6248504519462585,.7203134894371033,.11080294847488403,.086883544921875,.16252003610134125,.009928703308105469,.19287201762199402,.24017375707626343,.9280667304992676,.20186400413513184,.030156604945659637,.09174239635467529,.054857321083545685,.043415963649749756,.10317572951316833,.011430740356445312,.5724754929542542,.7012842297554016,.04823240637779236,.04079157114028931,.10992515832185745,.009145617485046387,.12513083219528198,.4699118137359619,.25039011240005493,.04158461093902588,.03691284358501434,.017000675201416016,.11080294847488403,.04074627161026001,.1928718537092209,.041023433208465576,.8749712705612183,.22037410736083984,.1928718537092209,.0873255729675293,.21095037460327148,.011578857898712158,.23733942210674286,.2402205467224121,.8219332098960876,.20110386610031128,.1830982267856598,.040720999240875244,.19951972365379333,.08995997905731201,.21771717071533203,.009267032146453857,.8749260902404785,.7204409241676331,.03691284358501434,.009847462177276611,.11080294847488403,.24022287130355835,.19951972365379333,.04366427659988403,.8221272826194763,.7012577056884766,.01972394436597824,.03634655475616455,.056542813777923584,.2402452826499939,.11080294847488403,.09198707342147827,.18309825658798218,.026818931102752686,.8757262825965881,.5295590758323669,.04823248088359833,.2401202917098999,.1251671314239502,.7795271873474121,.12887565791606903,.24023151397705078,.17478697001934052,.026818931102752686,.21857404708862305,.026176750659942627,.03845880925655365,.04332977533340454,.09018958359956741,.01701122522354126,.1747969537973404,.09206688404083252,.32266902923583984,.7014552354812622,.06695697456598282,.02927464246749878,.1242377758026123,.2800881862640381,.14694832265377045,.2402452826499939,.1928718090057373,.03334176540374756,.2011767327785492,.09258311986923218,.05590075999498367,.036389052867889404,.06631642580032349,.2402452826499939,.08440063893795013,.09198743104934692,.25401246547698975,.027156472206115723,.6260393857955933,.2797313928604126,.02038293331861496,.09181225299835205,.09270339459180832,.026784837245941162,.12602335214614868,.5296675562858582,.16502328217029572,.24008393287658691,.2359241247177124,.03662097454071045,.08440056443214417,.026784837245941162,.15672194957733154,.2402452826499939,.22902897000312805,.09287703037261963,.25400829315185547,.007925331592559814,.6272023916244507,.02966541051864624,.05590075999498367,.026093125343322754,.07462692260742188,.03639000654220581,.08838308602571487,.03634411096572876,.20049551129341125,.026176750659942627,.2359241247177124,.026130735874176025,.24978983402252197,.01738286018371582,.2499590814113617,.03662097454071045,.01972394436597824,.0260503888130188,.034168489277362823,.036347150802612305,.11080294847488403,.03634369373321533,.1281311959028244,.03640943765640259,.14694836735725403,.02592015266418457,.1791275292634964,.03631848096847534,.21857404708862305,.03662097454071045],normalized:!1}},index:{type:"Uint16Array",array:[96,28,86,33,37,139,108,155,151,195,179,135,120,116,17,171,183,175,84,72,237,2,91,230,100,147,8,163,104,227,46,55,112,170,176,189,19,24,219,101,5,225,106,103,11,83,92,88,45,63,49,192,202,190,209,74,26,182,57,185,165,215,43,93,89,140,194,235,71,3,36,143,168,188,200,142,35,95,75,69,79,228,144,1,31,146,156,107,50,41,44,114,166,136,0,145,97,153,158,162,115,111,124,201,206,14,160,224,82,231,90,30,157,152,70,198,193,102,149,99,214,117,65,34,211,94,53,161,110,9,52,105,73,77,27,58,25,187,66,118,22,154,129,32,81,29,78,222,178,21,15,23,119,18,181,184,76,203,199,180,61,56,59,217,68,20,177,174,6,232,242,229,233,240,236,134,243,131,218,239,221,16,241,13,223,238,226,7,244,60,122,246,121,204,245,207,212,250,213,128,251,127,39,248,38,47,247,48,62,249,96,210,28,33,130,37,108,42,155,195,191,179,120,167,116,171,125,183,84,80,72,2,141,91,100,159,147,163,12,104,46,51,55,170,173,176,19,186,24,101,98,5,106,150,103,45,216,63,192,197,202,209,205,74,93,85,89,194,133,235,3,138,36,75,196,69,228,4,144,31,137,146,107,54,50,44,109,114,97,148,153,124,169,201,14,113,160,82,234,231,214,164,117,34,126,211,53,10,161,58,67,25,154,40,129,81,87,29,222,132,178,15,220,23,18,172,181,76,208,203,180,123,61,59,64,217]},boundingSphere:{center:[0,-762939453125e-17,0],radius:139.86793680588863}},rotationCombinations:{"1,2":[1,-51,0],"1,3":[-1,-103,-1],"1,4":[0,-155,0],"1,5":[0,154,0],"1,6":[2,103,-2],"1,7":[0,52,1],"1,8":[2,-77,-178],"1,9":[180,-51,-1],"1,10":[-180,0,0],"1,11":[-179,51,-1],"1,12":[-1,77,-179],"1,13":[0,26,180],"1,14":[1,-26,-180],"2,3":[0,-52,0],"2,4":[-2,-103,-2],"2,5":[0,-154,0],"2,6":[0,154,0],"2,7":[2,103,-2],"2,8":[0,-26,-180],"2,9":[2,-77,-178],"2,10":[180,-52,-1],"2,11":[-180,0,0],"2,12":[-180,51,-1],"2,13":[-1,77,-179],"2,14":[0,26,180],"3,4":[1,-52,1],"3,5":[-2,-103,-2],"3,6":[0,-154,0],"3,7":[0,155,-1],"3,8":[0,26,-180],"3,9":[0,-26,-179],"3,10":[1,-77,-179],"3,11":[180,-52,0],"3,12":[180,0,-1],"3,13":[-180,51,-1],"3,14":[0,77,180],"4,5":[0,-51,0],"4,6":[0,-103,1],"4,7":[0,-154,0],"4,8":[1,77,179],"4,9":[0,26,-180],"4,10":[0,-25,-180],"4,11":[-1,-77,180],"4,12":[180,-52,0],"4,13":[180,0,0],"4,14":[179,51,0],"5,6":[0,-51,0],"5,7":[1,-103,1],"5,8":[180,51,0],"5,9":[1,77,179],"5,10":[0,26,-180],"5,11":[0,-25,180],"5,12":[0,-77,180],"5,13":[180,-52,0],"5,14":[180,0,0],"6,7":[0,-51,-1],"6,8":[180,0,0],"6,9":[180,52,1],"6,10":[1,77,180],"6,11":[0,26,180],"6,12":[0,-26,180],"6,13":[0,-77,179],"6,14":[180,-51,0],"7,8":[180,-51,-1],"7,9":[-180,0,0],"7,10":[-180,51,0],"7,11":[-1,77,-179],"7,12":[0,26,180],"7,13":[0,-26,180],"7,14":[2,-77,-178],"8,9":[0,51,1],"8,10":[1,103,0],"8,11":[0,154,0],"8,12":[0,-155,0],"8,13":[0,-103,-1],"8,14":[0,-52,0],"9,10":[0,51,0],"9,11":[-1,103,1],"9,12":[0,154,0],"9,13":[0,-154,0],"9,14":[2,-103,2],"10,11":[0,51,0],"10,12":[0,103,0],"10,13":[0,154,0],"10,14":[0,-154,0],"11,12":[0,52,0],"11,13":[0,103,-1],"11,14":[0,155,0],"12,13":[0,52,0],"12,14":[3,103,-3],"13,14":[-1,51,1]}},d16:{metadata:{version:4.5,type:"BufferGeometry",generator:"BufferGeometry.toJSON"},uuid:"C14C9443-AE98-4545-B8F9-EEF68D99E5CB",type:"BufferGeometry",data:{attributes:{position:{itemSize:3,type:"Float32Array",array:[1.9203956127166748,-75.6114730834961,4.636213302612305,1.9203956127166748,-75.6114730834961,4.636213302612305,1.9203956127166748,-75.6114730834961,4.636213302612305,1.9203956127166748,-75.6114730834961,4.636213302612305,1.9203956127166748,-75.6114730834961,4.636213302612305,1.9203956127166748,-75.6114730834961,4.636213302612305,-1.9200903177261353,1.4698024988174438,78.77789306640625,-1.9200903177261353,1.4698024988174438,78.77789306640625,-1.9200903177261353,1.4698024988174438,78.77789306640625,-1.9200903177261353,1.4698024988174438,78.77789306640625,-1.9200903177261353,1.4698024988174438,78.77789306640625,57.06234359741211,-1.4698084592819214,54.34610366821289,57.06234359741211,-1.4698084592819214,54.34610366821289,57.06234359741211,-1.4698084592819214,54.34610366821289,57.06234359741211,-1.4698084592819214,54.34610366821289,57.06234359741211,-1.4698084592819214,54.34610366821289,-1.9204055070877075,-75.6114730834961,-4.63621187210083,-1.9204055070877075,-75.6114730834961,-4.63621187210083,-1.9204055070877075,-75.6114730834961,-4.63621187210083,-1.9204055070877075,-75.6114730834961,-4.63621187210083,-1.9204055070877075,-75.6114730834961,-4.63621187210083,54.34610366821289,1.4697924852371216,-57.06234359741211,54.34610366821289,1.4697924852371216,-57.06234359741211,54.34610366821289,1.4697924852371216,-57.06234359741211,54.34610366821289,1.4697924852371216,-57.06234359741211,54.34610366821289,1.4697924852371216,-57.06234359741211,1.9206753969192505,1.4697996377944946,78.77787780761719,1.9206753969192505,1.4697996377944946,78.77787780761719,1.9206753969192505,1.4697996377944946,78.77787780761719,1.9206753969192505,1.4697996377944946,78.77787780761719,1.9206753969192505,1.4697996377944946,78.77787780761719,1.9206753969192505,1.4697996377944946,78.77787780761719,-4.6361985206604,75.6114730834961,1.9204007387161255,-4.6361985206604,75.6114730834961,1.9204007387161255,-4.6361985206604,75.6114730834961,1.9204007387161255,-4.6361985206604,75.6114730834961,1.9204007387161255,-4.6361985206604,75.6114730834961,1.9204007387161255,-57.06234359741211,1.469807744026184,-54.34610366821289,-57.06234359741211,1.469807744026184,-54.34610366821289,-57.06234359741211,1.469807744026184,-54.34610366821289,-57.06234359741211,1.469807744026184,-54.34610366821289,-57.06234359741211,1.469807744026184,-54.34610366821289,-57.06234359741211,1.469807744026184,-54.34610366821289,-57.06234359741211,1.469807744026184,-54.34610366821289,78.77787780761719,-1.4698125123977661,-1.9206798076629639,78.77787780761719,-1.4698125123977661,-1.9206798076629639,78.77787780761719,-1.4698125123977661,-1.9206798076629639,78.77787780761719,-1.4698125123977661,-1.9206798076629639,78.77787780761719,-1.4698125123977661,-1.9206798076629639,78.77787780761719,-1.4698125123977661,-1.9206798076629639,4.6362080574035645,-75.6114730834961,-1.9204015731811523,4.6362080574035645,-75.6114730834961,-1.9204015731811523,4.6362080574035645,-75.6114730834961,-1.9204015731811523,4.6362080574035645,-75.6114730834961,-1.9204015731811523,4.6362080574035645,-75.6114730834961,-1.9204015731811523,4.6362080574035645,-75.6114730834961,-1.9204015731811523,57.06194305419922,-1.4698078632354736,-54.346519470214844,57.06194305419922,-1.4698078632354736,-54.346519470214844,57.06194305419922,-1.4698078632354736,-54.346519470214844,57.06194305419922,-1.4698078632354736,-54.346519470214844,1.9201017618179321,-1.4698004722595215,-78.77789306640625,1.9201017618179321,-1.4698004722595215,-78.77789306640625,1.9201017618179321,-1.4698004722595215,-78.77789306640625,1.9201017618179321,-1.4698004722595215,-78.77789306640625,1.9201017618179321,-1.4698004722595215,-78.77789306640625,54.34610366821289,-1.4698083400726318,-57.06234359741211,54.34610366821289,-1.4698083400726318,-57.06234359741211,54.34610366821289,-1.4698083400726318,-57.06234359741211,54.34610366821289,-1.4698083400726318,-57.06234359741211,54.34610366821289,-1.4698083400726318,-57.06234359741211,54.34610366821289,-1.4698083400726318,-57.06234359741211,57.06194305419922,1.469793438911438,-54.346519470214844,57.06194305419922,1.469793438911438,-54.346519470214844,57.06194305419922,1.469793438911438,-54.346519470214844,57.06194305419922,1.469793438911438,-54.346519470214844,57.06194305419922,1.469793438911438,-54.346519470214844,78.77787780761719,1.4697893857955933,-1.920678734779358,78.77787780761719,1.4697893857955933,-1.920678734779358,78.77787780761719,1.4697893857955933,-1.920678734779358,78.77787780761719,1.4697893857955933,-1.920678734779358,78.77787780761719,1.4697893857955933,-1.920678734779358,-54.34610366821289,1.469807505607605,57.06234359741211,-54.34610366821289,1.469807505607605,57.06234359741211,-54.34610366821289,1.469807505607605,57.06234359741211,-54.34610366821289,1.469807505607605,57.06234359741211,-57.06194305419922,-1.469792366027832,54.346519470214844,-57.06194305419922,-1.469792366027832,54.346519470214844,-57.06194305419922,-1.469792366027832,54.346519470214844,-57.06194305419922,-1.469792366027832,54.346519470214844,-78.77787780761719,1.4698104858398438,1.920676589012146,-78.77787780761719,1.4698104858398438,1.920676589012146,-78.77787780761719,1.4698104858398438,1.920676589012146,-78.77787780761719,1.4698104858398438,1.920676589012146,-78.77787780761719,1.4698104858398438,1.920676589012146,-78.77787780761719,1.4698104858398438,1.920676589012146,-57.06234359741211,-1.469793438911438,-54.34610366821289,-57.06234359741211,-1.469793438911438,-54.34610366821289,-57.06234359741211,-1.469793438911438,-54.34610366821289,-57.06234359741211,-1.469793438911438,-54.34610366821289,4.6362409591674805,75.6114730834961,1.920365810394287,4.6362409591674805,75.6114730834961,1.920365810394287,4.6362409591674805,75.6114730834961,1.920365810394287,4.6362409591674805,75.6114730834961,1.920365810394287,4.6362409591674805,75.6114730834961,1.920365810394287,-1.9203522205352783,75.6114730834961,4.636227607727051,-1.9203522205352783,75.6114730834961,4.636227607727051,-1.9203522205352783,75.6114730834961,4.636227607727051,-1.9203522205352783,75.6114730834961,4.636227607727051,-1.9203522205352783,75.6114730834961,4.636227607727051,-1.9203522205352783,75.6114730834961,4.636227607727051,-1.9203522205352783,75.6114730834961,4.636227607727051,1.9204154014587402,75.61146545410156,4.636213302612305,1.9204154014587402,75.61146545410156,4.636213302612305,1.9204154014587402,75.61146545410156,4.636213302612305,1.9204154014587402,75.61146545410156,4.636213302612305,1.9204154014587402,75.61146545410156,4.636213302612305,1.9204154014587402,75.61146545410156,4.636213302612305,-1.9203720092773438,-75.6114730834961,4.636226177215576,-1.9203720092773438,-75.6114730834961,4.636226177215576,-1.9203720092773438,-75.6114730834961,4.636226177215576,-1.9203720092773438,-75.6114730834961,4.636226177215576,-1.9203720092773438,-75.6114730834961,4.636226177215576,-4.636218547821045,-75.61146545410156,1.920400619506836,-4.636218547821045,-75.61146545410156,1.920400619506836,-4.636218547821045,-75.61146545410156,1.920400619506836,-4.636218547821045,-75.61146545410156,1.920400619506836,-4.636218547821045,-75.61146545410156,1.920400619506836,-4.636218547821045,-75.61146545410156,1.920400619506836,-4.636231899261475,-75.61146545410156,-1.9203662872314453,-4.636231899261475,-75.61146545410156,-1.9203662872314453,-4.636231899261475,-75.61146545410156,-1.9203662872314453,-4.636231899261475,-75.61146545410156,-1.9203662872314453,-4.636231899261475,-75.61146545410156,-1.9203662872314453,-4.636231899261475,-75.61146545410156,-1.9203662872314453,-4.636231899261475,-75.61146545410156,-1.9203662872314453,-54.34610366821289,-1.4697926044464111,57.06234359741211,-54.34610366821289,-1.4697926044464111,57.06234359741211,-54.34610366821289,-1.4697926044464111,57.06234359741211,-54.34610366821289,-1.4697926044464111,57.06234359741211,-54.34610366821289,-1.4697926044464111,57.06234359741211,-54.34610366821289,-1.4697926044464111,57.06234359741211,-57.06194305419922,1.4698082208633423,54.346519470214844,-57.06194305419922,1.4698082208633423,54.346519470214844,-57.06194305419922,1.4698082208633423,54.346519470214844,-57.06194305419922,1.4698082208633423,54.346519470214844,-57.06194305419922,1.4698082208633423,54.346519470214844,-57.06194305419922,1.4698082208633423,54.346519470214844,-1.9206644296646118,-1.469801664352417,-78.77787780761719,-1.9206644296646118,-1.469801664352417,-78.77787780761719,-1.9206644296646118,-1.469801664352417,-78.77787780761719,-1.9206644296646118,-1.469801664352417,-78.77787780761719,-1.9206644296646118,-1.469801664352417,-78.77787780761719,-1.9206644296646118,-1.469801664352417,-78.77787780761719,78.77789306640625,1.469791293144226,1.9200873374938965,78.77789306640625,1.469791293144226,1.9200873374938965,78.77789306640625,1.469791293144226,1.9200873374938965,78.77789306640625,1.469791293144226,1.9200873374938965,78.77789306640625,1.469791293144226,1.9200873374938965,78.77789306640625,1.469791293144226,1.9200873374938965,57.06234359741211,1.4697922468185425,54.34610366821289,57.06234359741211,1.4697922468185425,54.34610366821289,57.06234359741211,1.4697922468185425,54.34610366821289,57.06234359741211,1.4697922468185425,54.34610366821289,57.06234359741211,1.4697922468185425,54.34610366821289,78.77789306640625,-1.4698106050491333,1.9200865030288696,78.77789306640625,-1.4698106050491333,1.9200865030288696,78.77789306640625,-1.4698106050491333,1.9200865030288696,78.77789306640625,-1.4698106050491333,1.9200865030288696,78.77789306640625,-1.4698106050491333,1.9200865030288696,54.346519470214844,-1.4698073863983154,57.06194305419922,54.346519470214844,-1.4698073863983154,57.06194305419922,54.346519470214844,-1.4698073863983154,57.06194305419922,54.346519470214844,-1.4698073863983154,57.06194305419922,54.346519470214844,-1.4698073863983154,57.06194305419922,54.346519470214844,1.4697927236557007,57.06194305419922,54.346519470214844,1.4697927236557007,57.06194305419922,54.346519470214844,1.4697927236557007,57.06194305419922,54.346519470214844,1.4697927236557007,57.06194305419922,54.346519470214844,1.4697927236557007,57.06194305419922,-78.77789306640625,1.469812273979187,-1.920089602470398,-78.77789306640625,1.469812273979187,-1.920089602470398,-78.77789306640625,1.469812273979187,-1.920089602470398,-78.77789306640625,1.469812273979187,-1.920089602470398,-4.636211395263672,75.6114730834961,-1.920365810394287,-4.636211395263672,75.6114730834961,-1.920365810394287,-4.636211395263672,75.6114730834961,-1.920365810394287,-4.636211395263672,75.6114730834961,-1.920365810394287,-4.636211395263672,75.6114730834961,-1.920365810394287,-4.636211395263672,75.6114730834961,-1.920365810394287,-54.346519470214844,1.4698083400726318,-57.06194305419922,-54.346519470214844,1.4698083400726318,-57.06194305419922,-54.346519470214844,1.4698083400726318,-57.06194305419922,-54.346519470214844,1.4698083400726318,-57.06194305419922,-54.346519470214844,1.4698083400726318,-57.06194305419922,-1.9206633567810059,1.4698004722595215,-78.77787780761719,-1.9206633567810059,1.4698004722595215,-78.77787780761719,-1.9206633567810059,1.4698004722595215,-78.77787780761719,-1.9206633567810059,1.4698004722595215,-78.77787780761719,-1.9206633567810059,1.4698004722595215,-78.77787780761719,-1.9206633567810059,1.4698004722595215,-78.77787780761719,-1.920385479927063,75.6114730834961,-4.636212348937988,-1.920385479927063,75.6114730834961,-4.636212348937988,-1.920385479927063,75.6114730834961,-4.636212348937988,-1.920385479927063,75.6114730834961,-4.636212348937988,-1.920385479927063,75.6114730834961,-4.636212348937988,-1.920385479927063,75.6114730834961,-4.636212348937988,1.9201031923294067,1.469801664352417,-78.77789306640625,1.9201031923294067,1.469801664352417,-78.77789306640625,1.9201031923294067,1.469801664352417,-78.77789306640625,1.9201031923294067,1.469801664352417,-78.77789306640625,1.9201031923294067,1.469801664352417,-78.77789306640625,1.9203814268112183,75.61146545410156,-4.636227130889893,1.9203814268112183,75.61146545410156,-4.636227130889893,1.9203814268112183,75.61146545410156,-4.636227130889893,1.9203814268112183,75.61146545410156,-4.636227130889893,1.9203814268112183,75.61146545410156,-4.636227130889893,1.9203814268112183,75.61146545410156,-4.636227130889893,4.636227607727051,75.61146545410156,-1.9204010963439941,4.636227607727051,75.61146545410156,-1.9204010963439941,4.636227607727051,75.61146545410156,-1.9204010963439941,4.636227607727051,75.61146545410156,-1.9204010963439941,4.636227607727051,75.61146545410156,-1.9204010963439941,4.636227607727051,75.61146545410156,-1.9204010963439941,4.636227607727051,75.61146545410156,-1.9204010963439941,1.9203611612319946,-75.6114730834961,-4.636227130889893,1.9203611612319946,-75.6114730834961,-4.636227130889893,1.9203611612319946,-75.6114730834961,-4.636227130889893,1.9203611612319946,-75.6114730834961,-4.636227130889893,1.9203611612319946,-75.6114730834961,-4.636227130889893,1.9203611612319946,-75.6114730834961,-4.636227130889893,4.636220455169678,-75.6114730834961,1.9203660488128662,4.636220455169678,-75.6114730834961,1.9203660488128662,4.636220455169678,-75.6114730834961,1.9203660488128662,4.636220455169678,-75.6114730834961,1.9203660488128662,4.636220455169678,-75.6114730834961,1.9203660488128662,4.636220455169678,-75.6114730834961,1.9203660488128662,4.636220455169678,-75.6114730834961,1.9203660488128662,-1.9200901985168457,-1.4697996377944946,78.77789306640625,-1.9200901985168457,-1.4697996377944946,78.77789306640625,-1.9200901985168457,-1.4697996377944946,78.77789306640625,-1.9200901985168457,-1.4697996377944946,78.77789306640625,-1.9200901985168457,-1.4697996377944946,78.77789306640625,-1.9200901985168457,-1.4697996377944946,78.77789306640625,1.9206759929656982,-1.4698023796081543,78.77787780761719,1.9206759929656982,-1.4698023796081543,78.77787780761719,1.9206759929656982,-1.4698023796081543,78.77787780761719,1.9206759929656982,-1.4698023796081543,78.77787780761719,1.9206759929656982,-1.4698023796081543,78.77787780761719,-78.77789306640625,-1.4697893857955933,-1.9200888872146606,-78.77789306640625,-1.4697893857955933,-1.9200888872146606,-78.77789306640625,-1.4697893857955933,-1.9200888872146606,-78.77789306640625,-1.4697893857955933,-1.9200888872146606,-78.77789306640625,-1.4697893857955933,-1.9200888872146606,-78.77789306640625,-1.4697893857955933,-1.9200888872146606,-78.77787780761719,-1.4697915315628052,1.9206773042678833,-78.77787780761719,-1.4697915315628052,1.9206773042678833,-78.77787780761719,-1.4697915315628052,1.9206773042678833,-78.77787780761719,-1.4697915315628052,1.9206773042678833,-78.77787780761719,-1.4697915315628052,1.9206773042678833,-78.77787780761719,-1.4697915315628052,1.9206773042678833,-54.346519470214844,-1.4697924852371216,-57.06194305419922,-54.346519470214844,-1.4697924852371216,-57.06194305419922,-54.346519470214844,-1.4697924852371216,-57.06194305419922,-54.346519470214844,-1.4697924852371216,-57.06194305419922,-54.346519470214844,-1.4697924852371216,-57.06194305419922,-54.346519470214844,-1.4697924852371216,-57.06194305419922,1482796960772248e-20,77.15787506103516,4.608693302543543e-7,1482796960772248e-20,77.15787506103516,4.608693302543543e-7,1482796960772248e-20,77.15787506103516,4.608693302543543e-7,1482796960772248e-20,77.15787506103516,4.608693302543543e-7,1482796960772248e-20,77.15787506103516,4.608693302543543e-7,1482796960772248e-20,77.15787506103516,4.608693302543543e-7,1482796960772248e-20,77.15787506103516,4.608693302543543e-7,1482796960772248e-20,77.15787506103516,4.608693302543543e-7,-5149714979779674e-21,-77.15787506103516,8.015119590254471e-8,-5149714979779674e-21,-77.15787506103516,8.015119590254471e-8,-5149714979779674e-21,-77.15787506103516,8.015119590254471e-8,-5149714979779674e-21,-77.15787506103516,8.015119590254471e-8,-5149714979779674e-21,-77.15787506103516,8.015119590254471e-8,-5149714979779674e-21,-77.15787506103516,8.015119590254471e-8,-5149714979779674e-21,-77.15787506103516,8.015119590254471e-8,-5149714979779674e-21,-77.15787506103516,8.015119590254471e-8],normalized:!1},normal:{itemSize:3,type:"Float32Array",array:[.276015043258667,-.6926735639572144,.6663474440574646,.27601727843284607,-.6926627159118652,.6663578748703003,.2760189175605774,-.692660391330719,.6663596630096436,.2760222256183624,-.6926570534706116,.6663616299629211,.276040256023407,-.6926739811897278,.6663366556167603,.276040256023407,-.6926739811897278,.6663366556167603,-.25681689381599426,.6585057377815247,.707400381565094,-.25677764415740967,.6585237979888916,.7073978781700134,-.25676974654197693,.6585195064544678,.7074047327041626,-.25676843523979187,.658514142036438,.7074101567268372,-.25676360726356506,.6585231423377991,.7074034810066223,.6817693710327148,-.6585230231285095,.3186502456665039,.6817746758460999,-.6585193276405334,.31864672899246216,.6817750930786133,-.6585239171981812,.3186362087726593,.6817806363105774,-.6585127711296082,.3186471462249756,.6818035244941711,-.6585102081298828,.3186035752296448,-.27603888511657715,-.6926746368408203,-.6663365960121155,-.27603888511657715,-.6926746368408203,-.6663365960121155,-.2760240435600281,-.6926567554473877,-.6663613319396973,-.27601906657218933,-.6926603317260742,-.6663596034049988,-.276016503572464,-.6926576495170593,-.6663634777069092,.31860223412513733,.6585102677345276,-.6818041205406189,.31864118576049805,.6585193872451782,-.6817771792411804,.31864672899246216,.6585192680358887,-.6817746162414551,.31865164637565613,.6585074067115784,-.6817838549613953,.3186781108379364,.6585215926170349,-.6817577481269836,.2567409873008728,.6585215926170349,.7074131965637207,.2567734122276306,.6585090756416321,.7074129581451416,.2567753195762634,.6585192680358887,.7074028849601746,.2567766308784485,.6585201025009155,.7074016332626343,.25684815645217896,.6585031747817993,.7073915004730225,.2568749189376831,.6584857106208801,.707397997379303,-.6663634181022644,.6926576495170593,.2760165333747864,-.6663627028465271,.6926561594009399,.27602237462997437,-.6663594245910645,.6926605105400085,.27601903676986694,-.666336178779602,.6926746368408203,.2760397791862488,-.666336178779602,.6926746368408203,.2760397791862488,-.6818409562110901,.6584908962249756,-.3185632526874542,-.6818210482597351,.6585003733634949,-.3185865879058838,-.6817838549613953,.6585077047348022,-.3186509609222412,-.6817764043807983,.6585201025009155,-.3186413049697876,-.6817750930786133,.6585239171981812,-.31863611936569214,-.6817746162414551,.6585193872451782,-.3186466097831726,-.6817693710327148,.6585230827331543,-.3186500072479248,.7073933482170105,-.6585105061531067,-.256823867559433,.7073962092399597,-.6585232615470886,-.2567831575870514,.7074015736579895,-.6585202813148499,-.2567760646343231,.7074017524719238,-.6585232019424438,-.25676846504211426,.707402765750885,-.658519446849823,-.25677525997161865,.7074130177497864,-.6585090756416321,-.2567734122276306,.6663360595703125,-.6926746964454651,-.27603980898857117,.6663360595703125,-.6926746964454651,-.27603980898857117,.6663508415222168,-.6926715970039368,-.276012122631073,.6663575768470764,-.6926620602607727,-.27601906657218933,.6663594841957092,-.6926604509353638,-.2760190963745117,.6663633584976196,-.6926577091217041,-.27601656317710876,.6817554831504822,-.6585215926170349,-.31868305802345276,.6817722320556641,-.6585193276405334,-.3186517655849457,.6817790865898132,-.6585125923156738,-.3186511695384979,.6818022131919861,-.6585102677345276,-.3186061382293701,.2567366063594818,-.65851891040802,-.7074173092842102,.2567683160305023,-.6585140228271484,-.7074102163314819,.2567698359489441,-.6585193872451782,-.7074047923088074,.25684165954589844,-.6584954261779785,-.7074009776115417,.25686919689178467,-.6584891676902771,-.7073968052864075,.3186025023460388,-.6585103273391724,-.6818039417266846,.3186361789703369,-.6585239768028259,-.6817750930786133,.3186422288417816,-.6585192084312439,-.6817768216133118,.31864655017852783,-.6585193276405334,-.6817747354507446,.3186500072479248,-.6585085988044739,-.6817831993103027,.3186507225036621,-.6585209369659424,-.6817711591720581,.6817664504051208,.6585237383842468,-.31865495443344116,.6817724108695984,.6585192084312439,-.3186517655849457,.6817728281021118,.6585238575935364,-.31864115595817566,.6817781925201416,.6585131287574768,-.31865185499191284,.681801974773407,.6585103869438171,-.31860649585723877,.7073934674263,.6585009098052979,-.25684863328933716,.707394540309906,.6584897637367249,-.2568739354610443,.7074029445648193,.6585192680358887,-.25677525997161865,.70740807056427,.6585136651992798,-.2567750811576843,.707412600517273,.6585222482681274,-.2567406892776489,-.318678081035614,.6585216522216797,.6817576885223389,-.3186471462249756,.6585129499435425,.6817804574966431,-.3186464309692383,.658519446849823,.6817746758460999,-.31860098242759705,.6585105657577515,.681804358959198,-.6818021535873413,-.6585102677345276,.3186064064502716,-.6817792654037476,-.6585121750831604,.3186511993408203,-.6817723512649536,-.6585192680358887,.31865155696868896,-.6817554831504822,-.6585215926170349,.31868308782577515,-.7074131965637207,.6585215926170349,.2567409873008728,-.7074130773544312,.6585090756416321,.2567734122276306,-.7074027061462402,.6585195064544678,.2567752003669739,-.7074015140533447,.6585204005241394,.25677624344825745,-.7073948979377747,.6584895253181458,.25687336921691895,-.7073922157287598,.6585012078285217,.25685107707977295,-.681803286075592,-.6585100293159485,-.3186042904853821,-.681780993938446,-.6585121750831604,-.3186477720737457,-.6817747354507446,-.6585192084312439,-.31864655017852783,-.6817577481269836,-.6585215926170349,-.3186781406402588,.6663422584533691,.6926707029342651,.27603498101234436,.6663422584533691,.6926707029342651,.27603498101234436,.6663618087768555,.6926602721214294,.27601414918899536,.6663632988929749,.6926569938659668,.27601855993270874,.6663657426834106,.6926578283309937,.27601078152656555,-.276034414768219,.6926738619804382,.666339099407196,-.276034414768219,.6926738619804382,.666339099407196,-.27601510286331177,.6926615834236145,.6663600206375122,-.27601391077041626,.6926605701446533,.6663616299629211,-.2760116159915924,.6926630735397339,.6663599014282227,-.2760094106197357,.6926736831665039,.6663497686386108,-.2760079801082611,.6926721930503845,.666351854801178,.2760111689567566,.6926732659339905,.6663495302200317,.27601638436317444,.6926575303077698,.666363537311554,.276017963886261,.692661464214325,.6663587093353271,.2760191559791565,.6926603317260742,.6663596034049988,.2760407030582428,.6926730871200562,.6663374900817871,.2760407030582428,.6926730871200562,.6663374900817871,-.27603691816329956,-.6926735043525696,.6663385629653931,-.27603691816329956,-.6926735043525696,.6663385629653931,-.27601784467697144,-.6926572918891907,.6663633584976196,-.2760142683982849,-.692660391330719,.6663615703582764,-.2760106921195984,-.6926577687263489,.6663656830787659,-.6663632392883301,-.6926574110984802,.27601781487464905,-.6663596034049988,-.692660391330719,.276018887758255,-.666358232498169,-.6926620006561279,.2760181128978729,-.6663506031036377,-.6926716566085815,.27601203322410583,-.6663397550582886,-.6926713585853577,.2760394513607025,-.6663397550582886,-.6926713585853577,.2760394513607025,-.6663616299629211,-.6926603317260742,-.2760140001773834,-.6663612723350525,-.6926611661911011,-.2760130763053894,-.6663604378700256,-.6926630735397339,-.2760102152824402,-.6663517951965332,-.6926720142364502,-.27600860595703125,-.6663496494293213,-.6926732659339905,-.2760104537010193,-.6663398742675781,-.6926730871200562,-.27603474259376526,-.6663398742675781,-.6926730871200562,-.27603474259376526,-.318651407957077,-.6585085988044739,.6817827820777893,-.31865057349205017,-.6585232019424438,.6817690134048462,-.3186468183994293,-.6585192680358887,.6817746758460999,-.31864237785339355,-.6585188508033752,.6817769408226013,-.3186362087726593,-.6585239768028259,.6817749738693237,-.3185986876487732,-.6585110425949097,.6818050146102905,-.6818026900291443,.6585108637809753,.3186039626598358,-.6817818284034729,.6585076451301575,.31865543127059937,-.681774914264679,.6585193276405334,.3186458647251129,-.6817728281021118,.6585239171981812,.31864118576049805,-.6817721724510193,.6585193872451782,.3186517059803009,-.6817666888237,.6585231423377991,.3186558485031128,-.25682297348976135,-.6585092544555664,-.7073948383331299,-.25678229331970215,-.6585257649421692,-.7073943018913269,-.25677669048309326,-.6585200428962708,-.7074015140533447,-.2567752003669739,-.6585193276405334,-.7074028849601746,-.25677335262298584,-.6585087776184082,-.7074132561683655,-.25676870346069336,-.6585231423377991,-.7074016332626343,.7073953151702881,.6585105657577515,.25681835412979126,.7073976993560791,.6585239768028259,.2567773759365082,.7074037194252014,.6585230827331543,.25676336884498596,.7074037790298462,.6585202813148499,.25676998496055603,.7074049115180969,.6585192680358887,.2567700147628784,.707414984703064,.658509373664856,.2567674517631531,.6817577481269836,.6585216522216797,.3186781108379364,.6817748546600342,.6585191488265991,.3186466693878174,.6817762851715088,.6585201025009155,.31864142417907715,.6817829012870789,.6585080027580261,.31865206360816956,.6818039417266846,.6585102081298828,.3186025619506836,.7073953747749329,-.6585008502006531,.25684332847595215,.7073964476585388,-.6584898233413696,.25686851143836975,.7074047327041626,-.6585193872451782,.2567700147628784,.7074100375175476,-.6585139036178589,.25676897168159485,.7074150443077087,-.6585217118263245,.2567354738712311,.31860607862472534,-.6585102677345276,.6818023324012756,.31864601373672485,-.6585190892219543,.6817750334739685,.31865158677101135,-.6585192680358887,.6817724108695984,.3186558485031128,-.6585085988044739,.6817806363105774,.31868311762809753,-.6585216522216797,.6817553639411926,.31860703229904175,.658510148525238,.6818019151687622,.3186412453651428,.6585239768028259,.6817727088928223,.31865087151527405,.6585137248039246,.6817781329154968,.31865182518959045,.6585192084312439,.6817723512649536,.3186556100845337,.6585230827331543,.6817667484283447,-.707414984703064,.6585217118263245,-.25673556327819824,-.7074099779129028,.6585142612457275,-.2567688226699829,-.7074046730995178,.6585195064544678,-.25676992535591125,-.7073950171470642,.658510684967041,-.25681883096694946,-.666364312171936,.6926564574241638,-.2760176658630371,-.6663615703582764,.6926605105400085,-.2760140895843506,-.6663599610328674,.6926629543304443,-.2760114371776581,-.6663492918014526,.6926740407943726,-.27600976824760437,-.6663401126861572,.692672848701477,-.276034951210022,-.6663401126861572,.692672848701477,-.276034951210022,-.3186555504798889,.6585217118263245,-.6817682385444641,-.3186514973640442,.6585192680358887,-.6817724108695984,-.31865087151527405,.6585137248039246,-.6817781329154968,-.3186410963535309,.6585239768028259,-.6817727088928223,-.31860843300819397,.6585099697113037,-.6818014979362488,-.25687503814697266,.6584945321083069,-.7073897123336792,-.25684797763824463,.6585018634796143,-.7073926329612732,-.25677669048309326,.6585201025009155,-.7074015736579895,-.25677499175071716,.6585193276405334,-.7074029445648193,-.2567721903324127,.6585090160369873,-.7074134349822998,-.256741464138031,.6585198640823364,-.7074146270751953,-.2760404050350189,.6926735043525696,-.6663371324539185,-.2760404050350189,.6926735043525696,-.6663371324539185,-.27601927518844604,.6926617622375488,-.6663580536842346,-.27601882815361023,.692660391330719,-.6663596630096436,-.27601534128189087,.6926579475402832,-.6663636565208435,-.2760111093521118,.6926732659339905,-.666349470615387,.25676339864730835,.6585231423377991,-.7074035406112671,.2567683756351471,.658514142036438,-.7074102163314819,.2567700743675232,.6585193872451782,-.7074046730995178,.2567768692970276,.6585267186164856,-.7073954343795776,.25681787729263306,.6585150361061096,-.7073912620544434,.27600938081741333,.6926736831665039,-.6663497090339661,.27601268887519836,.6926624774932861,-.6663600206375122,.27601420879364014,.692660391330719,-.6663615703582764,.2760183811187744,.6926562786102295,-.6663641929626465,.27603667974472046,.692672848701477,-.6663392782211304,.27603667974472046,.692672848701477,-.6663392782211304,.6663398146629333,.6926707625389099,-.2760407030582428,.6663398146629333,.6926707625389099,-.2760407030582428,.666347861289978,.6926729083061218,-.2760158181190491,.6663495898246765,.6926727294921875,-.27601224184036255,.666358232498169,.6926625370979309,-.2760171592235565,.6663585901260376,.6926613450050354,-.27601903676986694,.6663596630096436,.6926603317260742,-.2760190963745117,.27600938081741333,-.6926738023757935,-.6663495302200317,.27601149678230286,-.6926628947257996,-.6663601398468018,.2760140001773834,-.6926604509353638,-.6663616299629211,.2760170102119446,-.6926567554473877,-.6663640737533569,.27603477239608765,-.6926739811897278,-.6663388609886169,.27603477239608765,-.6926739811897278,-.6663388609886169,.6663395166397095,-.6926735043525696,.2760348320007324,.6663395166397095,-.6926735043525696,.2760348320007324,.6663496494293213,-.69267338514328,.2760099768638611,.6663513779640198,-.6926727294921875,.2760077118873596,.6663597822189331,-.6926623582839966,.27601343393325806,.6663600206375122,-.6926628947257996,.2760114371776581,.6663615703582764,-.6926604509353638,.27601417899131775,-.2568694055080414,-.6584880352020264,.7073978185653687,-.25684303045272827,-.658505916595459,.7073907852172852,-.25677070021629333,-.6585201025009155,.7074036002159119,-.2567701041698456,-.6585193276405334,.7074047327041626,-.2567673623561859,-.6585090160369873,.7074152231216431,-.25673583149909973,-.6585217118263245,.7074149250984192,.25676846504211426,-.6585231423377991,.7074017524719238,.2567743957042694,-.6585140228271484,.7074080109596252,.2567751109600067,-.6585193276405334,.7074029445648193,.25678279995918274,-.6585239768028259,.7073957920074463,.256822794675827,-.6585081815719604,.7073959708213806,-.7074099779129028,-.6585137248039246,-.25676944851875305,-.7074047923088074,-.6585192680358887,-.2567698359489441,-.7074031233787537,-.6585232019424438,-.25676456093788147,-.7073982357978821,-.658488929271698,-.2568660080432892,-.7073976397514343,-.6585239171981812,-.2567775249481201,-.707395076751709,-.6585009098052979,-.25684383511543274,-.7074130177497864,-.6585085988044739,.25677454471588135,-.7074028849601746,-.6585193872451782,.2567750811576843,-.7074017524719238,-.6585231423377991,.2567686140537262,-.7074016332626343,-.6585202813148499,.2567755877971649,-.7073957920074463,-.6585239171981812,.2567828893661499,-.7073920369148254,-.6585111021995544,.2568261921405792,-.31868305802345276,-.6585215926170349,-.6817554235458374,-.3186575174331665,-.658507764339447,-.6817806363105774,-.3186517059803009,-.6585192084312439,-.6817723512649536,-.3186461925506592,-.658518373966217,-.6817757487297058,-.3185906708240509,-.6585003137588501,-.6818190813064575,-.3185673952102661,-.6584908366203308,-.6818392276763916,1342588575425907e-21,1,-7.968073134634324e-8,1342588575425907e-21,1,-7.968073134634324e-8,1342588575425907e-21,1,-7.968073134634324e-8,1342588575425907e-21,1,-7.968073134634324e-8,1342588575425907e-21,1,-7.968073134634324e-8,1342588575425907e-21,1,-7.968073134634324e-8,1342588575425907e-21,1,-7.968073134634324e-8,1342588575425907e-21,1,-7.968073134634324e-8,-7.788058837832068e-7,-1,-7.342277541511066e-8,-7.788058837832068e-7,-1,-7.342277541511066e-8,-7.788058837832068e-7,-1,-7.342277541511066e-8,-7.788058837832068e-7,-1,-7.342277541511066e-8,-7.788058837832068e-7,-1,-7.342277541511066e-8,-7.788058837832068e-7,-1,-7.342277541511066e-8,-7.788058837832068e-7,-1,-7.342277541511066e-8,-7.788058837832068e-7,-1,-7.342277541511066e-8],normalized:!1},uv:{itemSize:2,type:"Float32Array",array:[.03048560582101345,.01567864418029785,.03048560582101345,.01567864418029785,.4374997317790985,.2620980143547058,.03719213604927063,.12196230888366699,.034566912800073624,.013053596019744873,.04797939583659172,.007471561431884766,.023779170587658882,.004848778247833252,.11408431828022003,.12196230888366699,.09070630371570587,.23767399787902832,.07480431348085403,.01567620038986206,.11408431828022003,.12196230888366699,.11983299255371094,.12196230888366699,.3407820463180542,.3628087639808655,.11983299255371094,.12196230888366699,.041273150593042374,.015676438808441162,.004617570899426937,.005231618881225586,.08821681886911392,.00785917043685913,.104537233710289,.00896519422531128,.017072739079594612,.12196230888366699,.3124997019767761,.3871912360191345,.04389829561114311,.015676259994506836,.034566912800073624,.004848778247833252,.014447606168687344,.12196230888366699,.5343227386474609,.23762238025665283,.014447606168687344,.12196230888366699,.12820686399936676,.06416767835617065,.11096081137657166,.06416738033294678,.0707232654094696,.01567620038986206,.15942715108394623,.23743665218353271,.0707232654094696,.01567620038986206,.023779170587658882,.0007677078247070312,.023779170587658882,.0007677078247070312,.07742954790592194,.12196230888366699,.007741174660623074,.12196230888366699,.5624786019325256,.012261509895324707,.061391860246658325,.013051092624664307,.07480429112911224,.007857918739318848,.01348982285708189,.004848778247833252,.01348982285708189,.004848778247833252,.027860479429364204,.12196230888366699,.027860479429364204,.12196230888366699,.12245811522006989,.06416767835617065,.4092179536819458,.11280876398086548,.12245811522006989,.06416767835617065,.07072323560714722,.005232870578765869,.12245811522006989,.06679385900497437,.06401706486940384,.12196230888366699,.12245811522006989,.06679385900497437,.21575646102428436,.36276328563690186,.06401706486940384,.12196230888366699,.05060452222824097,.007858037948608398,.06809809058904648,.007857978343963623,.09084202349185944,.12196230888366699,.09084202349185944,.12196230888366699,.18749970197677612,.26223671436309814,.06401699781417847,.015676140785217285,.12245821952819824,.12196230888366699,.15924353897571564,.36276328563690186,.09084194898605347,.015676438808441162,.03144339099526405,.000767827033996582,.13133037090301514,.003871619701385498,.04797939583659172,.12196230888366699,.03418757766485214,.362862765789032,.08725927770137787,.005232870578765869,.08725927770137787,.005232870578765869,.03144339099526405,.004848778247833252,.13133037090301514,.06416767835617065,.09492307156324387,.015676438808441162,.09081242233514786,.362862765789032,.09492307156324387,.015676438808441162,.13133037090301514,.06416767835617065,.1255817413330078,.12196230888366699,.4657820463180542,.23780876398086548,.1255817413330078,.12196230888366699,.01036630105227232,.12196230888366699,.034566912800073624,.000767827033996582,.07384677231311798,.005232870578765869,.07384677231311798,.005232870578765869,.4092180132865906,.23780876398086548,.057310834527015686,.015676259994506836,.1255817413330078,.06679385900497437,.11408431828022003,.0667925477027893,.0036600297316908836,.015675067901611328,.03429369255900383,.23767399787902832,.06497455388307571,.0011516809463500977,.06809809058904648,.005232870578765869,.09754816442728043,.015677452087402344,.15919587016105652,.48784810304641724,.12820686399936676,.12196230888366699,.13133040070533752,.06679350137710571,.07742944359779358,.01567739248275757,.5342592000961304,.11273849010467529,.07742944359779358,.01567739248275757,.05060454457998276,.0011516809463500977,.05060454457998276,.0011516809463500977,.01036630105227232,.004848778247833252,.021154051646590233,.01567864418029785,.09083183109760284,.4878973960876465,.12558168172836304,.06416767835617065,.017355674877762794,.008966445922851562,.07771223783493042,.011559724807739258,.3124997019767761,.1371912956237793,.10425447672605515,.12196230888366699,.06139186769723892,.12196230888366699,.07072321325540543,.007857918739318848,.09112466126680374,.011558711528778076,.003660283051431179,.12196230888366699,.06249973922967911,.13732600212097168,.07480431348085403,.12196230888366699,.07480431348085403,.12196230888366699,.003660283051431179,.12196230888366699,.10833562910556793,.12196230888366699,.07072321325540543,.12196230888366699,.10833562910556793,.12196230888366699,.1875002682209015,.13756322860717773,.021154051646590233,.007474005222320557,.09492305666208267,.013051152229309082,.04418101906776428,.008964121341705322,.09783096611499786,.011559903621673584,.10162932425737381,.12196230888366699,.5625002384185791,.26224493980407715,.034566912800073624,.01567864418029785,.08821682631969452,.12196230888366699,.1874997317790985,.387151837348938,.09754827618598938,.12196230888366699,.09754827618598938,.12196230888366699,.007741096429526806,.00785684585571289,.1016293466091156,.013052403926849365,.06250026077032089,.3871026635169983,.021154044196009636,.12196230888366699,.08413578569889069,.12196230888366699,.021154044196009636,.12196230888366699,.08413578569889069,.12196230888366699,.0036600297316908836,.00785684585571289,.10833562910556793,.0074727535247802734,.10162932425737381,.015677452087402344,.11096075177192688,.0667925477027893,.5907518267631531,.3627550005912781,.10162932425737381,.015677452087402344,.11096075177192688,.0667925477027893,.06809809058904648,.0011516809463500977,.06497455388307571,.005232870578765869,.007741174660623074,.015675067901611328,.007741174660623074,.015675067901611328,.13133040070533752,.12196230888366699,.5907407999038696,.11272633075714111,.13133040070533752,.12196230888366699,.08725927770137787,.0011516809463500977,.11670946329832077,.003871321678161621,.04389836639165878,.12196230888366699,.3407820463180542,.4878087639808655,.04389836639165878,.12196230888366699,.11670946329832077,.003871321678161621,.07384677231311798,.0011516809463500977,.11670953035354614,.06679290533065796,.11670953035354614,.06679290533065796,.06139186769723892,.015676259994506836,.34078195691108704,.2378087043762207,.06139186769723892,.015676259994506836,.11670944094657898,.12196230888366699,.2842180132865906,.2378087043762207,.1042545735836029,.01567751169204712,.1042545735836029,.01567751169204712,.007741096429526806,.005231618881225586,.07072323560714722,.0011516809463500977,.07072323560714722,.0011516809463500977,.2842179536819458,.3628087639808655,.06809809058904648,.12196230888366699,.11983299255371094,.06679290533065796,.004617570899426937,.0011506080627441406,.03719203174114227,.015676438808441162,.40916556119918823,.3629019856452942,.03719203174114227,.015676438808441162,.11408430337905884,.003871619701385498,.007741096429526806,.0011506080627441406,.11096075177192688,.003871619701385498,.10833562910556793,.01567751169204712,.21557284891605377,.23743665218353271,.11096075177192688,.003871619701385498,.12245815992355347,.003871917724609375,.08151060342788696,.01567739248275757,.4657820463180542,.11280876398086548,.05060454457998276,.005232870578765869,.02786046452820301,.01567864418029785,.4374997317790985,.012191295623779297,.08151060342788696,.12196230888366699,.08151060342788696,.12196230888366699,.01036630105227232,.008966505527496338,.05759349465370178,.011558592319488525,.11983299255371094,.06416738033294678,.3407820463180542,.1128087043762207,.02377944253385067,.12196230888366699,.11983299255371094,.06416738033294678,.01348982285708189,.000767827033996582,.0841357409954071,.0011516809463500977,.0841357409954071,.0011516809463500977,.05060460418462753,.015676259994506836,.2842179536819458,.11280876398086548,.05060460418462753,.015676259994506836,.11983299255371094,.003871321678161621,.014164685271680355,.007474005222320557,.03719203174114227,.008964121341705322,.023779170587658882,.01567864418029785,.31250008940696716,.012191236019134521,.05060452222824097,.12196230888366699,.023779170587658882,.01567864418029785,.12820683419704437,.0038716793060302734,.05468563735485077,.01567620038986206,.5906772613525391,.23762238025665283,.12820683419704437,.0038716793060302734,.0841357409954071,.005232870578765869,.05468563735485077,.12196230888366699,.05468563735485077,.12196230888366699,.5624997615814209,.1373775601387024,.014447621069848537,.015678703784942627,.02377917803823948,.008966445922851562,.040990397334098816,.007471561431884766,.027577554807066917,.007474005222320557,.08151061087846756,.01305234432220459,.05731076002120972,.12196230888366699,.010366610251367092,.015678703784942627,.05731076002120972,.12196230888366699,.010366610251367092,.015678703784942627,.4375002980232239,.13719123601913452,.04797941446304321,.015676259994506836,.04797941446304321,.015676259994506836,.06250029802322388,.262137234210968,.09492305666208267,.12196230888366699,.05468561500310898,.007858037948608398,.08413572609424591,.00785917043685913,.03076852671802044,.011561095714569092,.06401699781417847,.007857978343963623,.06809809058904648,.015676140785217285,.04127315804362297,.12196230888366699,.04127315804362297,.12196230888366699,.06809809058904648,.015676140785217285,.3125002682209015,.26219117641448975,.026902692392468452,.004848778247833252,.026902692392468452,.004848778247833252,.034566912800073624,.12196230888366699,.5342481732368469,.3627550005912781,.034566912800073624,.12196230888366699,.11096090078353882,.12196230888366699,.11408430337905884,.06416738033294678,.03048589639365673,.12196230888366699,.46583443880081177,.3629019856452942,.11408430337905884,.06416738033294678,.026902692392468452,.0007677078247070312,.08413572609424591,.015676140785217285,.034168168902397156,.4878973960876465,.12558168172836304,.003871917724609375,.05372808128595352,.005232870578765869,.12558168172836304,.003871917724609375,.05372808128595352,.005232870578765869,.08821682631969452,.015676140785217285,.21580412983894348,.48784810304641724,.12820687890052795,.06679350137710571,.08821682631969452,.015676140785217285,.12820687890052795,.06679350137710571,.05372808128595352,.0011516809463500977,.11670944094657898,.06416738033294678,.01707303337752819,.01567864418029785,.2842179536819458,.4878087639808655,.01707303337752819,.01567864418029785,.01036630105227232,.000767827033996582,.01036630105227232,.000767827033996582,.014164685271680355,.013053655624389648,.021154051646590233,.013053596019744873,.027577554807066917,.013053596019744873,.040990397334098816,.013051152229309082,.061391860246658325,.00747150182723999,.07276374846696854,.013051033020019531,.08151061087846756,.007472634315490723,.09492305666208267,.007471621036529541,.005700557492673397,.013049840927124023,.034566912800073624,.007474005222320557,.04797939583659172,.013051152229309082,.052645064890384674,.013051152229309082,.06605753302574158,.013051152229309082,.08617626875638962,.01305234432220459,.1016293466091156,.0074727535247802734,.10833562910556793,.013052403926849365],normalized:!1}},index:{type:"Uint16Array",array:[97,128,249,171,245,2,83,8,107,137,120,240,12,236,166,262,150,19,23,208,213,190,203,197,78,72,223,101,160,157,255,123,87,114,28,177,91,145,34,42,181,184,48,54,57,238,31,6,76,165,44,254,130,122,108,27,112,126,133,274,192,152,260,142,106,33,38,265,95,253,93,182,185,90,32,239,0,244,69,53,227,212,198,204,161,111,176,129,261,18,85,84,141,258,146,89,13,155,159,219,156,79,139,10,81,169,163,174,170,233,14,21,59,65,125,138,86,73,47,56,40,205,191,224,149,61,246,178,26,222,24,214,250,41,98,232,46,167,209,70,60,63,194,210,68,226,62,36,104,271,105,116,273,115,99,267,100,218,272,217,215,268,216,201,269,200,187,266,188,35,270,134,17,281,16,229,279,228,50,277,51,231,278,230,4,275,5,117,276,118,127,280,237,247,30,77,153,164,257,248,132,109,9,29,189,199,148,143,82,110,37,193,264,251,259,94,186,180,92,241,121,1,67,58,52,211,207,196,162,102,113,131,96,263,85,140,84,256,88,144,11,168,154,221,103,158,136,242,7,169,15,163,172,3,234,21,75,59,124,119,135,71,80,45,39,183,202,225,20,151,243,173,175,220,74,22,252,179,43,235,55,49,206,25,66,64,147,195]},boundingSphere:{center:[0,0,0],radius:135.51845097955697}},rotationCombinations:{"1,2":[-1,-46,-1],"1,3":[44,-91,44],"1,4":[0,-135,0],"1,5":[-1,179,1],"1,6":[-1,134,1],"1,7":[44,89,-44],"1,8":[1,44,-2],"1,9":[-1,0,180],"1,10":[-2,-45,179],"1,11":[-103,-89,78],"1,12":[-180,-45,0],"1,13":[179,2,1],"1,14":[179,46,1],"1,15":[13,89,166],"1,16":[0,44,179],"2,3":[0,-45,0],"2,4":[43,-90,43],"2,5":[0,-135,0],"2,6":[0,180,0],"2,7":[0,135,0],"2,8":[38,89,-39],"2,9":[0,45,-180],"2,10":[0,0,180],"2,11":[-1,-45,179],"2,12":[-3,-89,177],"2,13":[-180,-44,1],"2,14":[-179,0,0],"2,15":[-179,45,0],"2,16":[-6,90,-174],"3,4":[0,-45,0],"3,5":[-54,-90,-54],"3,6":[0,-135,0],"3,7":[0,-180,0],"3,8":[-1,134,0],"3,9":[-177,90,-3],"3,10":[-1,45,-180],"3,11":[-1,0,180],"3,12":[0,-44,179],"3,13":[-179,-89,2],"3,14":[-179,-45,1],"3,15":[-180,0,0],"3,16":[-180,45,0],"4,5":[0,-45,1],"4,6":[-47,-90,-47],"4,7":[-1,-135,0],"4,8":[-1,179,-1],"4,9":[-180,45,0],"4,10":[-98,89,-83],"4,11":[-1,45,-179],"4,12":[0,1,180],"4,13":[0,-46,-179],"4,14":[-161,-89,20],"4,15":[180,-44,0],"4,16":[180,1,0],"5,6":[-1,-45,0],"5,7":[-60,-90,-59],"5,8":[-1,-136,-1],"5,9":[180,-1,1],"5,10":[180,44,0],"5,11":[-159,89,-21],"5,12":[0,46,179],"5,13":[0,-1,-180],"5,14":[-1,-45,179],"5,15":[-109,-89,72],"5,16":[-180,-45,0],"6,7":[0,-45,0],"6,8":[-38,-91,-39],"6,9":[-180,-45,0],"6,10":[-180,0,0],"6,11":[-179,45,-1],"6,12":[-177,89,-3],"6,13":[0,44,-179],"6,14":[-1,0,-180],"6,15":[-1,-45,180],"6,16":[-174,-90,6],"7,8":[1,-46,0],"7,9":[-3,-90,177],"7,10":[-179,-45,0],"7,11":[-179,0,0],"7,12":[-180,44,-1],"7,13":[-1,89,-178],"7,14":[-1,45,-179],"7,15":[0,0,-180],"7,16":[0,-45,180],"8,9":[0,-44,-179],"8,10":[12,-89,-167],"8,11":[179,-46,-1],"8,12":[179,-2,-1],"8,13":[-180,45,0],"8,14":[-109,89,-71],"8,15":[-2,45,-178],"8,16":[-1,0,-180],"9,10":[1,45,-1],"9,11":[89,89,-89],"9,12":[0,135,0],"9,13":[0,-179,1],"9,14":[0,-134,0],"9,15":[7,-89,7],"9,16":[0,-44,-1],"10,11":[0,45,0],"10,12":[-9,89,8],"10,13":[0,136,1],"10,14":[-1,-179,0],"10,15":[-1,-134,0],"10,16":[11,-89,12],"11,12":[-1,45,-1],"11,13":[4,91,-4],"11,14":[-1,136,1],"11,15":[-1,-179,0],"11,16":[-1,-134,0],"12,13":[-1,47,2],"12,14":[6,91,-6],"12,15":[0,136,0],"12,16":[0,-179,-1],"13,14":[1,44,-1],"13,15":[68,89,-68],"13,16":[-1,135,1],"14,15":[0,45,0],"14,16":[-86,90,85],"15,16":[0,45,-1]}},d20:{metadata:{version:4.5,type:"BufferGeometry",generator:"BufferGeometry.toJSON"},uuid:"4947963B-5ABA-4507-A373-1DA7805EB4DE",type:"BufferGeometry",data:{attributes:{position:{itemSize:3,type:"Float32Array",array:[-83.39456939697266,2.066877841949463,52.33057403564453,-83.39456939697266,2.066877841949463,52.33057403564453,-83.39456939697266,2.066877841949463,52.33057403564453,-83.39456939697266,2.066877841949463,52.33057403564453,-53.607669830322266,82.60527038574219,.00019691196212079376,-53.607669830322266,82.60527038574219,.00019691196212079376,-53.607669830322266,82.60527038574219,.00019691196212079376,-53.607669830322266,82.60527038574219,.00019691196212079376,-84.67233276367188,1.2774014472961426,-50.26307678222656,-84.67233276367188,1.2774014472961426,-50.26307678222656,-84.67233276367188,1.2774014472961426,-50.26307678222656,-84.67233276367188,1.2774014472961426,-50.26307678222656,-84.67233276367188,-1.2774014472961426,-50.26307678222656,-84.67233276367188,-1.2774014472961426,-50.26307678222656,-84.67233276367188,-1.2774014472961426,-50.26307678222656,-84.67233276367188,-1.2774014472961426,-50.26307678222656,-52.330257415771484,-83.39476013183594,2.0670700073242188,-52.330257415771484,-83.39476013183594,2.0670700073242188,-52.330257415771484,-83.39476013183594,2.0670700073242188,-52.330257415771484,-83.39476013183594,2.0670700073242188,-1.2770904302597046,-50.263389587402344,84.67215728759766,-1.2770904302597046,-50.263389587402344,84.67215728759766,-1.2770904302597046,-50.263389587402344,84.67215728759766,-1.2770904302597046,-50.263389587402344,84.67215728759766,-52.33027648925781,83.39476013183594,-2.066685438156128,-52.33027648925781,83.39476013183594,-2.066685438156128,-52.33027648925781,83.39476013183594,-2.066685438156128,-52.33027648925781,83.39476013183594,-2.066685438156128,-50.26338577270508,84.67214965820312,1.2775861024856567,-50.26338577270508,84.67214965820312,1.2775861024856567,-50.26338577270508,84.67214965820312,1.2775861024856567,-50.26338577270508,84.67214965820312,1.2775861024856567,1.2777124643325806,-50.263389587402344,84.6721420288086,1.2777124643325806,-50.263389587402344,84.6721420288086,1.2777124643325806,-50.263389587402344,84.6721420288086,1.2777124643325806,-50.263389587402344,84.6721420288086,-2.0671839714050293,-52.330265045166016,-83.39474487304688,-2.0671839714050293,-52.330265045166016,-83.39474487304688,-2.0671839714050293,-52.330265045166016,-83.39474487304688,-2.0671839714050293,-52.330265045166016,-83.39474487304688,83.39456939697266,2.066877841949463,-52.33057403564453,83.39456939697266,2.066877841949463,-52.33057403564453,83.39456939697266,2.066877841949463,-52.33057403564453,83.39456939697266,2.066877841949463,-52.33057403564453,84.67233276367188,1.2774014472961426,50.26307678222656,84.67233276367188,1.2774014472961426,50.26307678222656,84.67233276367188,1.2774014472961426,50.26307678222656,84.67233276367188,1.2774014472961426,50.26307678222656,53.607669830322266,-82.60527038574219,-.00019691196212079376,53.607669830322266,-82.60527038574219,-.00019691196212079376,53.607669830322266,-82.60527038574219,-.00019691196212079376,53.607669830322266,-82.60527038574219,-.00019691196212079376,83.39456939697266,-2.066877841949463,-52.33057403564453,83.39456939697266,-2.066877841949463,-52.33057403564453,83.39456939697266,-2.066877841949463,-52.33057403564453,83.39456939697266,-2.066877841949463,-52.33057403564453,1.2770904302597046,50.263389587402344,-84.67215728759766,1.2770904302597046,50.263389587402344,-84.67215728759766,1.2770904302597046,50.263389587402344,-84.67215728759766,1.2770904302597046,50.263389587402344,-84.67215728759766,50.26338577270508,84.67214965820312,-1.2775861024856567,50.26338577270508,84.67214965820312,-1.2775861024856567,50.26338577270508,84.67214965820312,-1.2775861024856567,50.26338577270508,84.67214965820312,-1.2775861024856567,83.39495086669922,-2.066877841949463,52.329959869384766,83.39495086669922,-2.066877841949463,52.329959869384766,83.39495086669922,-2.066877841949463,52.329959869384766,83.39495086669922,-2.066877841949463,52.329959869384766,-50.26339340209961,-84.67214965820312,-1.2772167921066284,-50.26339340209961,-84.67214965820312,-1.2772167921066284,-50.26339340209961,-84.67214965820312,-1.2772167921066284,-50.26339340209961,-84.67214965820312,-1.2772167921066284,-1.2777124643325806,-50.263389587402344,-84.6721420288086,-1.2777124643325806,-50.263389587402344,-84.6721420288086,-1.2777124643325806,-50.263389587402344,-84.6721420288086,-1.2777124643325806,-50.263389587402344,-84.6721420288086,-52.330257415771484,83.39476013183594,2.0670700073242188,-52.330257415771484,83.39476013183594,2.0670700073242188,-52.330257415771484,83.39476013183594,2.0670700073242188,-52.330257415771484,83.39476013183594,2.0670700073242188,-82.60507202148438,0,53.60797119140625,-82.60507202148438,0,53.60797119140625,-82.60507202148438,0,53.60797119140625,-82.60507202148438,0,53.60797119140625,-2.0665714740753174,52.330265045166016,83.39476776123047,-2.0665714740753174,52.330265045166016,83.39476776123047,-2.0665714740753174,52.330265045166016,83.39476776123047,-2.0665714740753174,52.330265045166016,83.39476776123047,-84.67196655273438,-1.2774014472961426,50.26369857788086,-84.67196655273438,-1.2774014472961426,50.26369857788086,-84.67196655273438,-1.2774014472961426,50.26369857788086,-84.67196655273438,-1.2774014472961426,50.26369857788086,-84.67196655273438,1.2774014472961426,50.26369857788086,-84.67196655273438,1.2774014472961426,50.26369857788086,-84.67196655273438,1.2774014472961426,50.26369857788086,-84.67196655273438,1.2774014472961426,50.26369857788086,-53.607669830322266,-82.60527038574219,.00019691196212079376,-53.607669830322266,-82.60527038574219,.00019691196212079376,-53.607669830322266,-82.60527038574219,.00019691196212079376,-53.607669830322266,-82.60527038574219,.00019691196212079376,-83.39456939697266,-2.066877841949463,52.33057403564453,-83.39456939697266,-2.066877841949463,52.33057403564453,-83.39456939697266,-2.066877841949463,52.33057403564453,-83.39456939697266,-2.066877841949463,52.33057403564453,-52.33027648925781,-83.39476013183594,-2.066685438156128,-52.33027648925781,-83.39476013183594,-2.066685438156128,-52.33027648925781,-83.39476013183594,-2.066685438156128,-52.33027648925781,-83.39476013183594,-2.066685438156128,-2.0665714740753174,-52.330265045166016,83.39476776123047,-2.0665714740753174,-52.330265045166016,83.39476776123047,-2.0665714740753174,-52.330265045166016,83.39476776123047,-2.0665714740753174,-52.330265045166016,83.39476776123047,-1.2770904302597046,50.263389587402344,84.67215728759766,-1.2770904302597046,50.263389587402344,84.67215728759766,-1.2770904302597046,50.263389587402344,84.67215728759766,-1.2770904302597046,50.263389587402344,84.67215728759766,-.0003034261171706021,53.607669830322266,-82.60527038574219,-.0003034261171706021,53.607669830322266,-82.60527038574219,-.0003034261171706021,53.607669830322266,-82.60527038574219,-.0003034261171706021,53.607669830322266,-82.60527038574219,-2.0671839714050293,52.330265045166016,-83.39474487304688,-2.0671839714050293,52.330265045166016,-83.39474487304688,-2.0671839714050293,52.330265045166016,-83.39474487304688,-2.0671839714050293,52.330265045166016,-83.39474487304688,-83.39495086669922,2.066877841949463,-52.329959869384766,-83.39495086669922,2.066877841949463,-52.329959869384766,-83.39495086669922,2.066877841949463,-52.329959869384766,-83.39495086669922,2.066877841949463,-52.329959869384766,50.26339340209961,84.67214965820312,1.2772167921066284,50.26339340209961,84.67214965820312,1.2772167921066284,50.26339340209961,84.67214965820312,1.2772167921066284,50.26339340209961,84.67214965820312,1.2772167921066284,-50.26339340209961,84.67214965820312,-1.2772167921066284,-50.26339340209961,84.67214965820312,-1.2772167921066284,-50.26339340209961,84.67214965820312,-1.2772167921066284,-50.26339340209961,84.67214965820312,-1.2772167921066284,2.0671839714050293,52.330265045166016,83.39474487304688,2.0671839714050293,52.330265045166016,83.39474487304688,2.0671839714050293,52.330265045166016,83.39474487304688,2.0671839714050293,52.330265045166016,83.39474487304688,82.60547637939453,0,53.607364654541016,82.60547637939453,0,53.607364654541016,82.60547637939453,0,53.607364654541016,82.60547637939453,0,53.607364654541016,83.39495086669922,2.066877841949463,52.329959869384766,83.39495086669922,2.066877841949463,52.329959869384766,83.39495086669922,2.066877841949463,52.329959869384766,83.39495086669922,2.066877841949463,52.329959869384766,50.26339340209961,-84.67214965820312,1.2772167921066284,50.26339340209961,-84.67214965820312,1.2772167921066284,50.26339340209961,-84.67214965820312,1.2772167921066284,50.26339340209961,-84.67214965820312,1.2772167921066284,2.0671839714050293,-52.330265045166016,83.39474487304688,2.0671839714050293,-52.330265045166016,83.39474487304688,2.0671839714050293,-52.330265045166016,83.39474487304688,2.0671839714050293,-52.330265045166016,83.39474487304688,50.26338577270508,-84.67214965820312,-1.2775861024856567,50.26338577270508,-84.67214965820312,-1.2775861024856567,50.26338577270508,-84.67214965820312,-1.2775861024856567,50.26338577270508,-84.67214965820312,-1.2775861024856567,-83.39495086669922,-2.066877841949463,-52.329959869384766,-83.39495086669922,-2.066877841949463,-52.329959869384766,-83.39495086669922,-2.066877841949463,-52.329959869384766,-83.39495086669922,-2.066877841949463,-52.329959869384766,-82.60547637939453,0,-53.607364654541016,-82.60547637939453,0,-53.607364654541016,-82.60547637939453,0,-53.607364654541016,-82.60547637939453,0,-53.607364654541016,52.330257415771484,83.39476013183594,-2.0670700073242188,52.330257415771484,83.39476013183594,-2.0670700073242188,52.330257415771484,83.39476013183594,-2.0670700073242188,52.330257415771484,83.39476013183594,-2.0670700073242188,53.607669830322266,82.60527038574219,-.00019691196212079376,53.607669830322266,82.60527038574219,-.00019691196212079376,53.607669830322266,82.60527038574219,-.00019691196212079376,53.607669830322266,82.60527038574219,-.00019691196212079376,2.0665714740753174,52.330265045166016,-83.39476776123047,2.0665714740753174,52.330265045166016,-83.39476776123047,2.0665714740753174,52.330265045166016,-83.39476776123047,2.0665714740753174,52.330265045166016,-83.39476776123047,84.67233276367188,-1.2774014472961426,50.26307678222656,84.67233276367188,-1.2774014472961426,50.26307678222656,84.67233276367188,-1.2774014472961426,50.26307678222656,84.67233276367188,-1.2774014472961426,50.26307678222656,84.67196655273438,-1.2774014472961426,-50.26369857788086,84.67196655273438,-1.2774014472961426,-50.26369857788086,84.67196655273438,-1.2774014472961426,-50.26369857788086,84.67196655273438,-1.2774014472961426,-50.26369857788086,84.67196655273438,1.2774014472961426,-50.26369857788086,84.67196655273438,1.2774014472961426,-50.26369857788086,84.67196655273438,1.2774014472961426,-50.26369857788086,84.67196655273438,1.2774014472961426,-50.26369857788086,52.33027648925781,83.39476013183594,2.066685438156128,52.33027648925781,83.39476013183594,2.066685438156128,52.33027648925781,83.39476013183594,2.066685438156128,52.33027648925781,83.39476013183594,2.066685438156128,52.330257415771484,-83.39476013183594,-2.0670700073242188,52.330257415771484,-83.39476013183594,-2.0670700073242188,52.330257415771484,-83.39476013183594,-2.0670700073242188,52.330257415771484,-83.39476013183594,-2.0670700073242188,82.60507202148438,0,-53.60797119140625,82.60507202148438,0,-53.60797119140625,82.60507202148438,0,-53.60797119140625,82.60507202148438,0,-53.60797119140625,52.33027648925781,-83.39476013183594,2.066685438156128,52.33027648925781,-83.39476013183594,2.066685438156128,52.33027648925781,-83.39476013183594,2.066685438156128,52.33027648925781,-83.39476013183594,2.066685438156128,-50.26338577270508,-84.67214965820312,1.2775861024856567,-50.26338577270508,-84.67214965820312,1.2775861024856567,-50.26338577270508,-84.67214965820312,1.2775861024856567,-50.26338577270508,-84.67214965820312,1.2775861024856567,1.2770904302597046,-50.263389587402344,-84.67215728759766,1.2770904302597046,-50.263389587402344,-84.67215728759766,1.2770904302597046,-50.263389587402344,-84.67215728759766,1.2770904302597046,-50.263389587402344,-84.67215728759766,2.0665714740753174,-52.330265045166016,-83.39476776123047,2.0665714740753174,-52.330265045166016,-83.39476776123047,2.0665714740753174,-52.330265045166016,-83.39476776123047,2.0665714740753174,-52.330265045166016,-83.39476776123047,-.0003034261171706021,-53.607669830322266,-82.60527038574219,-.0003034261171706021,-53.607669830322266,-82.60527038574219,-.0003034261171706021,-53.607669830322266,-82.60527038574219,-.0003034261171706021,-53.607669830322266,-82.60527038574219,-1.2777124643325806,50.263389587402344,-84.6721420288086,-1.2777124643325806,50.263389587402344,-84.6721420288086,-1.2777124643325806,50.263389587402344,-84.6721420288086,-1.2777124643325806,50.263389587402344,-84.6721420288086,.0003034261171706021,-53.607669830322266,82.60527038574219,.0003034261171706021,-53.607669830322266,82.60527038574219,.0003034261171706021,-53.607669830322266,82.60527038574219,.0003034261171706021,-53.607669830322266,82.60527038574219,1.2777124643325806,50.263389587402344,84.6721420288086,1.2777124643325806,50.263389587402344,84.6721420288086,1.2777124643325806,50.263389587402344,84.6721420288086,1.2777124643325806,50.263389587402344,84.6721420288086,.0003034261171706021,53.607669830322266,82.60527038574219,.0003034261171706021,53.607669830322266,82.60527038574219,.0003034261171706021,53.607669830322266,82.60527038574219,.0003034261171706021,53.607669830322266,82.60527038574219],normalized:!1},normal:{itemSize:3,type:"Float32Array",array:[-.5902835130691528,.5619468092918396,.5794662833213806,-.5902835130691528,.5619468092918396,.5794662833213806,-.5902835130691528,.5619468092918396,.5794662833213806,-.5902835130691528,.5619468092918396,.5794662833213806,-.9267594814300537,.3756551742553711,-3.650784492492676e-7,-.9267594814300537,.3756551742553711,-3.650784492492676e-7,-.9267594814300537,.3756551742553711,-3.650784492492676e-7,-.9267594814300537,.3756551742553711,-3.650784492492676e-7,-.9375927448272705,.3472937345504761,-.01751660369336605,-.9375927448272705,.3472937345504761,-.01751660369336605,-.9375927448272705,.3472937345504761,-.01751660369336605,-.9375927448272705,.3472937345504761,-.01751660369336605,-.9375886917114258,-.34730517864227295,-.01751125603914261,-.9375886917114258,-.34730517864227295,-.01751125603914261,-.9375886917114258,-.34730517864227295,-.01751125603914261,-.9375886917114258,-.34730517864227295,-.01751125603914261,-.5794563889503479,-.5902886986732483,.5619516968727112,-.5794563889503479,-.5902886986732483,.5619516968727112,-.5794563889503479,-.5902886986732483,.5619516968727112,-.5794563889503479,-.5902886986732483,.5619516968727112,-.34728965163230896,-.01751914620399475,.9375942349433899,-.34728965163230896,-.01751914620399475,.9375942349433899,-.34728965163230896,-.01751914620399475,.9375942349433899,-.34728965163230896,-.01751914620399475,.9375942349433899,-.579460859298706,.5902918577194214,-.5619436502456665,-.579460859298706,.5902918577194214,-.5619436502456665,-.579460859298706,.5902918577194214,-.5619436502456665,-.579460859298706,.5902918577194214,-.5619436502456665,-.017521724104881287,.9375901818275452,.34730058908462524,-.017521724104881287,.9375901818275452,.34730058908462524,-.017521724104881287,.9375901818275452,.34730058908462524,-.017521724104881287,.9375901818275452,.34730058908462524,.3473122715950012,-.017512619495391846,.9375860095024109,.3473122715950012,-.017512619495391846,.9375860095024109,.3473122715950012,-.017512619495391846,.9375860095024109,.3473122715950012,-.017512619495391846,.9375860095024109,-.5619495511054993,-.579465389251709,-.5902817845344543,-.5619495511054993,-.579465389251709,-.5902817845344543,-.5619495511054993,-.579465389251709,-.5902817845344543,-.5619495511054993,-.579465389251709,-.5902817845344543,.5902835130691528,.5619468092918396,-.5794662833213806,.5902835130691528,.5619468092918396,-.5794662833213806,.5902835130691528,.5619468092918396,-.5794662833213806,.5902835130691528,.5619468092918396,-.5794662833213806,.9375926852226257,.3472939133644104,.017516572028398514,.9375926852226257,.3472939133644104,.017516572028398514,.9375926852226257,.3472939133644104,.017516572028398514,.9375926852226257,.3472939133644104,.017516572028398514,.9267594814300537,-.3756551742553711,-7398426532745361e-21,.9267594814300537,-.3756551742553711,-7398426532745361e-21,.9267594814300537,-.3756551742553711,-7398426532745361e-21,.9267594814300537,-.3756551742553711,-7398426532745361e-21,.590289294719696,-.5619460344314575,-.5794610977172852,.590289294719696,-.5619460344314575,-.5794610977172852,.590289294719696,-.5619460344314575,-.5794610977172852,.590289294719696,-.5619460344314575,-.5794610977172852,.3473011553287506,.017513729631900787,-.9375900626182556,.3473011553287506,.017513729631900787,-.9375900626182556,.3473011553287506,.017513729631900787,-.9375900626182556,.3473011553287506,.017513729631900787,-.9375900626182556,.01752115786075592,.9375901818275452,-.3473004698753357,.01752115786075592,.9375901818275452,-.3473004698753357,.01752115786075592,.9375901818275452,-.3473004698753357,.01752115786075592,.9375901818275452,-.3473004698753357,.5902906656265259,-.5619435906410217,.5794621706008911,.5902906656265259,-.5619435906410217,.5794621706008911,.5902906656265259,-.5619435906410217,.5794621706008911,.5902906656265259,-.5619435906410217,.5794621706008911,-.01751122623682022,-.9375880360603333,-.34730690717697144,-.01751122623682022,-.9375880360603333,-.34730690717697144,-.01751122623682022,-.9375880360603333,-.34730690717697144,-.01751122623682022,-.9375880360603333,-.34730690717697144,-.34731000661849976,-.01751551777124405,-.9375866651535034,-.34731000661849976,-.01751551777124405,-.9375866651535034,-.34731000661849976,-.01751551777124405,-.9375866651535034,-.34731000661849976,-.01751551777124405,-.9375866651535034,-.5794625282287598,.5902847647666931,.5619492530822754,-.5794625282287598,.5902847647666931,.5619492530822754,-.5794625282287598,.5902847647666931,.5619492530822754,-.5794625282287598,.5902847647666931,.5619492530822754,-.3756488859653473,-4090368747711182e-21,.9267621040344238,-.3756488859653473,-4090368747711182e-21,.9267621040344238,-.3756488859653473,-4090368747711182e-21,.9267621040344238,-.3756488859653473,-4090368747711182e-21,.9267621040344238,-.5619439482688904,.5794651508331299,.5902872681617737,-.5619439482688904,.5794651508331299,.5902872681617737,-.5619439482688904,.5794651508331299,.5902872681617737,-.5619439482688904,.5794651508331299,.5902872681617737,-.9375901818275452,-.34730082750320435,.017511630430817604,-.9375901818275452,-.34730082750320435,.017511630430817604,-.9375901818275452,-.34730082750320435,.017511630430817604,-.9375901818275452,-.34730082750320435,.017511630430817604,-.9375885128974915,.3473053276538849,.017515607178211212,-.9375885128974915,.3473053276538849,.017515607178211212,-.9375885128974915,.3473053276538849,.017515607178211212,-.9375885128974915,.3473053276538849,.017515607178211212,-.9267594814300537,-.3756551742553711,7398426532745361e-21,-.9267594814300537,-.3756551742553711,7398426532745361e-21,-.9267594814300537,-.3756551742553711,7398426532745361e-21,-.9267594814300537,-.3756551742553711,7398426532745361e-21,-.590289294719696,-.5619460344314575,.5794610977172852,-.590289294719696,-.5619460344314575,.5794610977172852,-.590289294719696,-.5619460344314575,.5794610977172852,-.590289294719696,-.5619460344314575,.5794610977172852,-.5794673562049866,-.5902878642082214,-.5619411468505859,-.5794673562049866,-.5902878642082214,-.5619411468505859,-.5794673562049866,-.5902878642082214,-.5619411468505859,-.5794673562049866,-.5902878642082214,-.5619411468505859,-.56194669008255,-.5794578194618225,.5902919173240662,-.56194669008255,-.5794578194618225,.5902919173240662,-.56194669008255,-.5794578194618225,.5902919173240662,-.56194669008255,-.5794578194618225,.5902919173240662,-.3473033905029297,.01751108467578888,.9375893473625183,-.3473033905029297,.01751108467578888,.9375893473625183,-.3473033905029297,.01751108467578888,.9375893473625183,-.3473033905029297,.01751108467578888,.9375893473625183,-6303191184997559e-21,.9267597794532776,-.3756546974182129,-6303191184997559e-21,.9267597794532776,-.3756546974182129,-6303191184997559e-21,.9267597794532776,-.3756546974182129,-6303191184997559e-21,.9267597794532776,-.3756546974182129,-.5619495511054993,.5794599056243896,-.5902870297431946,-.5619495511054993,.5794599056243896,-.5902870297431946,-.5619495511054993,.5794599056243896,-.5902870297431946,-.5619495511054993,.5794599056243896,-.5902870297431946,-.590303897857666,.5619341731071472,-.5794578194618225,-.590303897857666,.5619341731071472,-.5794578194618225,-.590303897857666,.5619341731071472,-.5794578194618225,-.590303897857666,.5619341731071472,-.5794578194618225,.017507383599877357,.9375904202461243,.34730064868927,.017507383599877357,.9375904202461243,.34730064868927,.017507383599877357,.9375904202461243,.34730064868927,.017507383599877357,.9375904202461243,.34730064868927,-.017507383599877357,.9375904202461243,-.3473004698753357,-.017507383599877357,.9375904202461243,-.3473004698753357,-.017507383599877357,.9375904202461243,-.3473004698753357,-.017507383599877357,.9375904202461243,-.3473004698753357,.5619532465934753,.5794590711593628,.5902844667434692,.5619532465934753,.5794590711593628,.5902844667434692,.5619532465934753,.5794590711593628,.5902844667434692,.5619532465934753,.5794590711593628,.5902844667434692,.3756416141986847,29206275939941406e-22,.926764965057373,.3756416141986847,29206275939941406e-22,.926764965057373,.3756416141986847,29206275939941406e-22,.926764965057373,.3756416141986847,29206275939941406e-22,.926764965057373,.5902771949768066,.5619665384292603,.5794534683227539,.5902771949768066,.5619665384292603,.5794534683227539,.5902771949768066,.5619665384292603,.5794534683227539,.5902771949768066,.5619665384292603,.5794534683227539,.017511233687400818,-.937588095664978,.3473067581653595,.017511233687400818,-.937588095664978,.3473067581653595,.017511233687400818,-.937588095664978,.3473067581653595,.017511233687400818,-.937588095664978,.3473067581653595,.5619463324546814,-.579465389251709,.5902849435806274,.5619463324546814,-.579465389251709,.5902849435806274,.5619463324546814,-.579465389251709,.5902849435806274,.5619463324546814,-.579465389251709,.5902849435806274,.017518242821097374,-.9375925660133362,-.34729424118995667,.017518242821097374,-.9375925660133362,-.34729424118995667,.017518242821097374,-.9375925660133362,-.34729424118995667,.017518242821097374,-.9375925660133362,-.34729424118995667,-.5902858376502991,-.5619493722915649,-.5794615745544434,-.5902858376502991,-.5619493722915649,-.5794615745544434,-.5902858376502991,-.5619493722915649,-.5794615745544434,-.5902858376502991,-.5619493722915649,-.5794615745544434,-.37564951181411743,28908252716064453e-22,-.9267617464065552,-.37564951181411743,28908252716064453e-22,-.9267617464065552,-.37564951181411743,28908252716064453e-22,-.9267617464065552,-.37564951181411743,28908252716064453e-22,-.9267617464065552,.5794623494148254,.5902848839759827,-.5619493126869202,.5794623494148254,.5902848839759827,-.5619493126869202,.5794623494148254,.5902848839759827,-.5619493126869202,.5794623494148254,.5902848839759827,-.5619493126869202,.9267598390579224,.3756541609764099,2.980232238769531e-7,.9267598390579224,.3756541609764099,2.980232238769531e-7,.9267598390579224,.3756541609764099,2.980232238769531e-7,.9267598390579224,.3756541609764099,2.980232238769531e-7,.5619441866874695,.5794647932052612,-.5902873873710632,.5619441866874695,.5794647932052612,-.5902873873710632,.5619441866874695,.5794647932052612,-.5902873873710632,.5619441866874695,.5794647932052612,-.5902873873710632,.9375880360603333,-.347307026386261,.017507091164588928,.9375880360603333,-.347307026386261,.017507091164588928,.9375880360603333,-.347307026386261,.017507091164588928,.9375880360603333,-.347307026386261,.017507091164588928,.9375901818275452,-.34730082750320435,-.017511630430817604,.9375901818275452,-.34730082750320435,-.017511630430817604,.9375901818275452,-.34730082750320435,-.017511630430817604,.9375901818275452,-.34730082750320435,-.017511630430817604,.9375885128974915,.3473053276538849,-.017515607178211212,.9375885128974915,.3473053276538849,-.017515607178211212,.9375885128974915,.3473053276538849,-.017515607178211212,.9375885128974915,.3473053276538849,-.017515607178211212,.5794609785079956,.5902916789054871,.5619437098503113,.5794609785079956,.5902916789054871,.5619437098503113,.5794609785079956,.5902916789054871,.5619437098503113,.5794609785079956,.5902916789054871,.5619437098503113,.5794563889503479,-.5902886986732483,-.5619516968727112,.5794563889503479,-.5902886986732483,-.5619516968727112,.5794563889503479,-.5902886986732483,-.5619516968727112,.5794563889503479,-.5902886986732483,-.5619516968727112,.3756488859653473,-4090368747711182e-21,-.9267621040344238,.3756488859653473,-4090368747711182e-21,-.9267621040344238,.3756488859653473,-4090368747711182e-21,-.9267621040344238,.3756488859653473,-4090368747711182e-21,-.9267621040344238,.5794673562049866,-.5902878642082214,.5619410276412964,.5794673562049866,-.5902878642082214,.5619410276412964,.5794673562049866,-.5902878642082214,.5619410276412964,.5794673562049866,-.5902878642082214,.5619410276412964,-.017518242821097374,-.9375925660133362,.34729424118995667,-.017518242821097374,-.9375925660133362,.34729424118995667,-.017518242821097374,-.9375925660133362,.34729424118995667,-.017518242821097374,-.9375925660133362,.34729424118995667,.34729689359664917,-.017507314682006836,-.9375919103622437,.34729689359664917,-.017507314682006836,-.9375919103622437,.34729689359664917,-.017507314682006836,-.9375919103622437,.34729689359664917,-.017507314682006836,-.9375919103622437,.5619431734085083,-.5794587135314941,-.5902944207191467,.5619431734085083,-.5794587135314941,-.5902944207191467,.5619431734085083,-.5794587135314941,-.5902944207191467,.5619431734085083,-.5794587135314941,-.5902944207191467,16316771507263184e-22,-.9267597794532776,-.3756546974182129,16316771507263184e-22,-.9267597794532776,-.3756546974182129,16316771507263184e-22,-.9267597794532776,-.3756546974182129,16316771507263184e-22,-.9267597794532776,-.3756546974182129,-.3473055958747864,.017509743571281433,-.9375884532928467,-.3473055958747864,.017509743571281433,-.9375884532928467,-.3473055958747864,.017509743571281433,-.9375884532928467,-.3473055958747864,.017509743571281433,-.9375884532928467,-12889504432678223e-22,-.9267591834068298,.3756559193134308,-12889504432678223e-22,-.9267591834068298,.3756559193134308,-12889504432678223e-22,-.9267591834068298,.3756559193134308,-12889504432678223e-22,-.9267591834068298,.3756559193134308,.3473014235496521,.01751813292503357,.9375898241996765,.3473014235496521,.01751813292503357,.9375898241996765,.3473014235496521,.01751813292503357,.9375898241996765,.3473014235496521,.01751813292503357,.9375898241996765,6429851055145264e-21,.9267741441726685,.37561920285224915,6429851055145264e-21,.9267741441726685,.37561920285224915,6429851055145264e-21,.9267741441726685,.37561920285224915,6429851055145264e-21,.9267741441726685,.37561920285224915],normalized:!1},uv:{itemSize:2,type:"Float32Array",array:[.050937071442604065,.0637897253036499,.11147573590278625,.05759662389755249,.1211576759815216,.10764795541763306,.12535500526428223,.35762202739715576,.05231131985783577,.1178632378578186,.07363925129175186,.11786329746246338,.119850754737854,.015513718128204346,.6247040033340454,.2332320213317871,.02066764421761036,.05759531259536743,.07363908737897873,.06378960609436035,.1211576759815216,.005298316478729248,.5624589920043945,.1254199743270874,.0220418032258749,.05759531259536743,.08258064091205597,.0637897253036499,.1211576759815216,.0066724419593811035,.24976900219917297,.6079350113868713,.02066793106496334,.11786329746246338,.02823532558977604,.06378841400146484,.1211576759815216,.09218895435333252,.4997659921646118,.1081160306930542,.08120644837617874,.057596445083618164,.0977153331041336,.11786329746246338,.1190430074930191,.039651691913604736,.4997679889202118,.3578059673309326,.05987865850329399,.0035230517387390137,.07501331716775894,.11786329746246338,.1190430074930191,.014401912689208984,.3747130036354065,.48311901092529297,.037176623940467834,.06378841400146484,.08877374976873398,.0637897253036499,.1211576759815216,.013714849948883057,.3754439949989319,.48308396339416504,.01310031395405531,.057595252990722656,.08258060365915298,.05759638547897339,.119850754737854,.038539886474609375,.24988000094890594,.4829980134963989,.04336973652243614,.003524184226989746,.06254100054502487,.37501800060272217,.08877380937337875,.05759662389755249,.11985072493553162,.04695647954940796,.00035799999022856355,.6079339981079102,.02823505364358425,.05759531259536743,.096341073513031,.0035229921340942383,.1190430074930191,.02281850576400757,.06744597852230072,.05759650468826294,.07363912463188171,.05759662389755249,.121157705783844,.0557977557182312,.3125090003013611,960230827331543e-19,.0055332062765955925,.11786329746246338,.10390840470790863,.0637897253036499,.11985082179307938,.09880667924880981,.5625389814376831,.25025200843811035,.0069072050973773,.06378835439682007,.05093708261847496,.0035218000411987305,.1211576759815216,.02213144302368164,.2504560053348541,.3578009605407715,.0296091977506876,.0035229921340942383,.06246799975633621,.25025999546051025,.10390840470790863,.0035241246223449707,.1211576759815216,.0823981761932373,.044743988662958145,.06378841400146484,.09014798700809479,.11786329746246338,.1211576759815216,.11606442928314209,.5002009868621826,.10809803009033203,.014474472962319851,.003522932529449463,.10528266429901123,.1178632378578186,.119850754737854,.05759662389755249,.24995200335979462,.2328779697418213,.006907171569764614,.057595252990722656,.062495000660419464,.12494999170303345,.0901479572057724,.0035241246223449707,.11904306709766388,.09150189161300659,.04474392160773277,.003524184226989746,.10528260469436646,.05759662389755249,.1190430074930191,.048068225383758545,.37474000453948975,.23276197910308838,.03580237179994583,.06378841400146484,.05093725398182869,.11786329746246338,.1211576759815216,.015089035034179688,.1876010000705719,.24980902671813965,.09771531820297241,.0637897253036499,.1128498986363411,.05759662389755249,.1211576759815216,.10902208089828491,.37527701258659363,.3578059673309326,.03580237179994583,.11786329746246338,.11147570610046387,.003524184226989746,.119850754737854,.030123412609100342,.24984599649906158,.35762202739715576,.02204183302819729,.0035229921340942383,.029609275981783867,.11786329746246338,.11904306709766388,.10833495855331421,.12527799606323242,.6079350113868713,.02066764421761036,.0035229921340942383,.05231131985783577,.0637897253036499,.11985082179307938,.1072232723236084,.5002130270004272,.2332320213317871,.029609275981783867,.06378841400146484,.08258064091205597,.11786329746246338,.1211576759815216,.09081476926803589,.1875240057706833,.5001220107078552,.028234990313649178,.11786329746246338,.096341073513031,.0637897253036499,.11985072493553162,.1094467043876648,.37527498602867126,.1081160306930542,.00029600001289509237,.4828310012817383,.08120640367269516,.11786329746246338,.08877374976873398,.0035241246223449707,.11985082179307938,.09039008617401123,.02066764421761036,.06378841400146484,.09634126722812653,.11786329746246338,.119850754737854,.04076343774795532,.43751999735832214,.00030297040939331055,.08120640367269516,.0035240650177001953,.1128498986363411,.003524184226989746,.1190430074930191,.031235098838806152,.4375219941139221,.2499929666519165,.04474368318915367,.11786329746246338,.05850442126393318,.05759662389755249,.119850754737854,.0841970443725586,.6246920228004456,.10809803009033203,.059878647327423096,.05759662389755249,.06607192009687424,.11786329746246338,.11904306709766388,.08308535814285278,.3124679923057556,.37530601024627686,.06607174873352051,.0637897253036499,.07501332461833954,.06378960609436035,.119850754737854,.00487363338470459,.25022199749946594,.48311901092529297,.05987865850329399,.11786329746246338,.0887739360332489,.11786329746246338,.119850754737854,.11563986539840698,.43768998980522156,.3752709627151489,.05850460007786751,.0035230517387390137,.09014798700809479,.0637897253036499,.11985069513320923,.013290226459503174,.5624470114707947,.00028502941131591797,.05850442126393318,.06378966569900513,.11147573590278625,.11786329746246338,.1211576759815216,.031922221183776855,.43765100836753845,.12517499923706055,.013100284151732922,.003522932529449463,.11284996569156647,.0637897253036499,.1190430074930191,.056484758853912354,.18763400614261627,.3751859664916992,.06607174873352051,.05759650468826294,.11147589981555939,.0637897253036499,.119850754737854,.05537313222885132,.3754050135612488,.23298698663711548,.005532982759177685,.0035241246223449707,.037176575511693954,.0035229921340942383,.119850754737854,.10103017091751099,.5628489851951599,.37501800060272217,.014474472962319851,.057595252990722656,.03580237179994583,.05759531259536743,.1211576759815216,.03896456956863403,.18770700693130493,.12506598234176636,.006907171569764614,.0035241246223449707,.014474536292254925,.11786329746246338,.1211576759815216,.10060548782348633,.12473999708890915,.23276197910308838,.04336966946721077,.05759531259536743,.08120658993721008,.0637897253036499,.119850754737854,.007097125053405762,.12478700280189514,.4828310012817383,.04474392160773277,.05759531259536743,.06744600087404251,.0637897253036499,.1190430074930191,.005985379219055176,.31249499320983887,.12494999170303345,.04336971789598465,.06378841400146484,.06260299682617188,.500120997428894,.09634125232696533,.05759662389755249,.1211576759815216,.11743861436843872,.06744597852230072,.003522932529449463,.09771530330181122,.05759662389755249,.11985082179307938,.11786329746246338,.37475401163101196,.10790902376174927,.02823500521481037,.0035229921340942383,.04336973652243614,.11786329746246338,.1211576759815216,.08377236127853394,.12484899908304214,.6079339981079102,.07501329481601715,.05759662389755249,.10390856862068176,.11786329746246338,.121157705783844,.05717200040817261,.624783992767334,.35806500911712646,.005532919429242611,.06378835439682007,.07501330226659775,.0035242438316345215,.1211576759815216,.02350562810897827,.5002930164337158,.35806500911712646,.07363908737897873,.0035242438316345215,.09771530330181122,.0035229921340942383,.119850754737854,.02393031120300293,.2502630054950714,.10790902376174927,.05850442126393318,.11786329746246338,.06607190519571304,.003522932529449463,.11904306709766388,.11675161123275757,.49989598989486694,.23298698663711548,.0069072050973773,.11786329746246338,.01310060080140829,.11786329746246338,.1211576759815216,.09923136234283447,.3749470114707947,.3578009605407715,.00022200000239536166,.35807204246520996,.0296091977506876,.05759531259536743,.052311308681964874,.0035218000411987305,.119850754737854,.021706759929656982,.035802435129880905,.0035229921340942383,.10528266429901123,.06378966569900513,.11904306709766388,.0999184250831604,.12546099722385406,.2328779697418213,.005532919429242611,.057595252990722656,.02204192988574505,.11786329746246338,.11985082179307938,.09261363744735718,.625095009803772,.4828310012817383,.05231131985783577,.05759531259536743,.10390844196081161,.05759662389755249,.11985072493553162,.049180030822753906,.1247130036354065,.35807204246520996,.013100284151732922,.06378841400146484,.050937261432409286,.05759531259536743,.1211576759815216,.04875540733337402,.3127020001411438,.24998903274536133,.00024900000425986946,.23276197910308838,.014474536292254925,.06378841400146484,.0901479572057724,.05759662389755249,.1211576759815216,.04738116264343262,.06744600087404251,.11786329746246338,.10528260469436646,.0035241246223449707,.11985082179307938,.0819736123085022,.2502489984035492,.23276197910308838,.022041896358132362,.06378841400146484,.037176575511693954,.05759531259536743,.1211576759815216,.040338754653930664,.500603973865509,.4828310012817383,.08258060365915298,.00352400541305542,.11284996569156647,.11786329746246338,.119850754737854,.03234678506851196,.1253889948129654,.4829980134963989,.03717633709311485,.11786329746246338,.05987846478819847,.06378966569900513,.1211576759815216,.03054797649383545,.4999360144138336,.48308396339416504],normalized:!1},color:{itemSize:4,type:"Uint16Array",array:[65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535],normalized:!0}},index:{type:"Uint16Array",array:[3,87,79,95,7,11,91,15,99,103,19,111,83,23,115,127,27,123,31,239,131,235,35,143,231,211,151,104,163,37,40,179,169,191,175,47,187,183,51,55,199,219,200,215,57,63,119,135,147,195,139,207,67,155,220,159,69,227,75,167,42,173,189,176,201,56,168,116,60,58,73,225,144,172,193,36,164,72,49,65,205,106,222,70,221,197,157,92,12,88,233,145,137,54,43,190,148,68,156,140,152,64,52,48,196,117,24,132,228,16,209,229,204,153,125,5,25,124,224,165,202,217,212,192,237,136,0,4,93,133,129,61,85,81,113,100,96,17,76,236,28,80,109,21,97,161,105,188,180,185,26,78,30,10,126,166,206,158,198,86,114,234,110,230,154,62,130,194,59,226,122,107,210,18,74,214,218,102,2,94,112,33,232,66,46,146,42,170,173,176,41,201,168,177,116,58,213,73,144,44,172,36,160,164,49,181,65,106,38,222,221,216,197,92,8,12,233,141,145,190,186,54,54,203,43,148,208,68,140,32,152,52,184,48,117,120,24,228,108,16,229,149,204,125,9,5,124,121,224,202,53,217,192,128,237,0,77,4,133,29,129,85,1,81,100,89,96,76,84,236,80,101,109,97,13,161,188,45,180,30,134,26,26,6,78,166,162,14,14,10,166,198,50,206,206,150,158,234,138,238,238,86,234,154,34,22,22,110,154,174,171,194,171,62,194,118,178,122,178,59,122,18,98,107,107,71,210,223,39,218,39,74,218,94,90,102,102,82,2,112,20,33,146,142,66,66,182,46]},boundingSphere:{center:[0,0,0],radius:146.65657531498138}},rotationCombinations:{"1,2":[-58,18,148],"1,3":[-21,-30,-69],"1,4":[-159,-30,69],"1,5":[-122,18,32],"1,6":[58,-54,-148],"1,7":[-58,18,-31],"1,8":[180,0,180],"1,9":[58,-54,30],"1,10":[122,54,-148],"1,11":[-122,-54,31],"1,12":[-58,54,-148],"1,13":[58,18,31],"1,14":[58,-18,148],"1,15":[148,90,-58],"1,16":[122,-18,-148],"1,17":[159,30,-110],"1,18":[21,30,110],"1,19":[158,-30,-69],"1,20":[0,0,180],"2,3":[-159,-30,68],"2,4":[-159,-30,-110],"2,5":[122,-54,148],"2,6":[-122,54,148],"2,7":[-32,-90,-122],"2,8":[-20,30,69],"2,9":[-122,54,-32],"2,10":[58,18,30],"2,11":[-180,90,90],"2,12":[21,-30,69],"2,13":[-21,30,-110],"2,14":[158,30,-110],"2,15":[21,-30,-110],"2,16":[0,90,90],"2,17":[-58,-54,148],"2,18":[-58,-54,-32],"2,19":[158,30,69],"2,20":[58,54,-30],"3,4":[0,0,180],"3,5":[-158,30,-69],"3,6":[90,0,90],"3,7":[-159,-30,-110],"3,8":[158,-30,110],"3,9":[90,0,-90],"3,10":[-58,18,-32],"3,11":[58,-54,-148],"3,12":[-90,0,-90],"3,13":[-21,-30,110],"3,14":[21,-30,-110],"3,15":[-90,0,90],"3,16":[58,-54,30],"3,17":[-180,0,180],"3,18":[180,0,0],"3,19":[58,54,-32],"3,20":[158,30,69],"4,5":[58,-18,-32],"4,6":[-58,18,148],"4,7":[158,30,69],"4,8":[-90,-90,0],"4,9":[-58,18,-32],"4,10":[58,-18,148],"4,11":[-122,-18,148],"4,12":[122,18,-32],"4,13":[0,-90,-90],"4,14":[-122,18,-148],"4,15":[122,18,148],"4,16":[-122,-18,-32],"4,17":[58,-54,-148],"4,18":[58,54,-32],"4,19":[-58,-54,148],"4,20":[-158,-30,-110],"5,6":[-122,-18,148],"5,7":[122,54,30],"5,8":[58,-54,-148],"5,9":[-122,-54,-148],"5,10":[0,0,180],"5,11":[-58,-54,-32],"5,12":[58,54,-32],"5,13":[-58,18,-32],"5,14":[180,0,-180],"5,15":[58,54,148],"5,16":[-58,-54,148],"5,17":[122,18,-32],"5,18":[-58,54,32],"5,19":[-180,0,0],"5,20":[-122,54,148],"6,7":[-159,30,110],"6,8":[-58,-54,-32],"6,9":[21,30,-69],"6,10":[122,-54,148],"6,11":[58,54,-32],"6,12":[159,-30,110],"6,13":[-122,54,148],"6,14":[-21,-30,-69],"6,15":[159,-30,-69],"6,16":[58,54,148],"6,17":[90,-90,-180],"6,18":[122,18,-32],"6,19":[-21,-30,110],"6,20":[122,54,32],"7,8":[21,-30,-110],"7,9":[159,-30,-69],"7,10":[21,30,-69],"7,11":[90,0,90],"7,12":[-58,54,32],"7,13":[122,54,32],"7,14":[58,-54,-148],"7,15":[-21,30,69],"7,16":[90,0,-90],"7,17":[58,54,-32],"7,18":[-21,-30,110],"7,19":[-159,-30,-110],"7,20":[-158,30,110],"8,9":[122,54,-148],"8,10":[58,-54,32],"8,11":[-58,54,-148],"8,12":[-122,-54,32],"8,13":[0,0,180],"8,14":[122,18,-32],"8,15":[0,-90,90],"8,16":[-58,54,32],"8,17":[-90,0,90],"8,18":[-90,0,-90],"8,19":[-122,54,148],"8,20":[180,0,0],"9,10":[-159,-30,-110],"9,11":[58,-18,-32],"9,12":[180,0,180],"9,13":[58,54,-32],"9,14":[21,30,110],"9,15":[-180,0,0],"9,16":[-58,-54,-32],"9,17":[-122,-18,-32],"9,18":[90,90,0],"9,19":[-58,-18,32],"9,20":[-58,54,-148],"10,11":[58,54,148],"10,12":[-58,-18,32],"10,13":[58,-18,148],"10,14":[90,0,-90],"10,15":[-58,-54,-32],"10,16":[120,-18,32],"10,17":[-122,-18,148],"10,18":[58,-54,-148],"10,19":[-180,0,-180],"10,20":[122,-54,-32],"11,12":[159,30,-110],"11,13":[-159,-30,69],"11,14":[21,-30,69],"11,15":[122,18,-32],"11,16":[0,0,-180],"11,17":[159,-30,-69],"11,18":[58,18,32],"11,19":[-122,-54,30],"11,20":[21,30,110],"12,13":[58,54,148],"12,14":[-122,18,32],"12,15":[0,0,-180],"12,16":[-122,54,148],"12,17":[-110,-90,159],"12,18":[58,18,-148],"12,19":[159,-30,110],"12,20":[90,0,-90],"13,14":[122,-54,148],"13,15":[58,54,-32],"13,16":[-58,-18,-148],"13,17":[-21,30,-110],"13,18":[-21,30,69],"13,19":[122,-54,-32],"13,20":[-180,0,-180],"14,15":[122,-18,-148],"14,16":[21,30,110],"14,17":[58,-18,148],"14,18":[58,-18,-32],"14,19":[0,0,-180],"14,20":[58,18,32],"15,16":[159,30,-110],"15,17":[58,-18,-32],"15,18":[-58,-18,32],"15,19":[122,-18,32],"15,20":[58,-54,-148],"16,17":[122,-54,148],"16,18":[122,-54,-32],"16,19":[122,54,-148],"16,20":[-122,54,-32],"17,18":[0,0,180],"17,19":[122,-54,148],"17,20":[21,-30,-110],"18,19":[-159,-30,69],"18,20":[158,30,-110],"19,20":[58,54,148]}},d24:{metadata:{version:4.5,type:"BufferGeometry",generator:"BufferGeometry.toJSON"},uuid:"D1B379DE-9640-4151-A394-D6DF1846E49C",type:"BufferGeometry",data:{attributes:{position:{itemSize:3,type:"Float32Array",array:[-93.4049072265625,-3.781350612640381,3.7816989421844482,-93.4049072265625,-3.781350612640381,3.7816989421844482,-93.4049072265625,-3.781350612640381,3.7816989421844482,-93.4049072265625,-3.781350612640381,3.7816989421844482,-49.7835578918457,55.42812728881836,-49.783199310302734,-49.7835578918457,55.42812728881836,-49.783199310302734,-49.7835578918457,55.42812728881836,-49.783199310302734,-49.7835578918457,55.42812728881836,-49.783199310302734,-63.36488342285156,68.7131118774414,-3.781550168991089,-63.36488342285156,68.7131118774414,-3.781550168991089,-63.36488342285156,68.7131118774414,-3.781550168991089,-63.36488342285156,68.7131118774414,-3.781550168991089,-3.7813644409179688,93.4049301147461,-3.7813427448272705,-3.7813644409179688,93.4049301147461,-3.7813427448272705,-3.7813644409179688,93.4049301147461,-3.7813427448272705,-3.7813644409179688,93.4049301147461,-3.7813427448272705,3.7820396423339844,63.364871978759766,68.71309661865234,3.7820396423339844,63.364871978759766,68.71309661865234,3.7820396423339844,63.364871978759766,68.71309661865234,3.7820396423339844,63.364871978759766,68.71309661865234,49.78358840942383,49.783382415771484,55.427940368652344,49.78358840942383,49.783382415771484,55.427940368652344,49.78358840942383,49.783382415771484,55.427940368652344,49.78358840942383,49.783382415771484,55.427940368652344,-93.40494537353516,3.7813589572906494,-3.781012773513794,-93.40494537353516,3.7813589572906494,-3.781012773513794,-93.40494537353516,3.7813589572906494,-3.781012773513794,-93.40494537353516,3.7813589572906494,-3.781012773513794,-55.42829895019531,49.78338623046875,-49.78317642211914,-55.42829895019531,49.78338623046875,-49.78317642211914,-55.42829895019531,49.78338623046875,-49.78317642211914,-55.42829895019531,49.78338623046875,-49.78317642211914,-63.3648567199707,68.7131118774414,3.7820181846618652,-63.3648567199707,68.7131118774414,3.7820181846618652,-63.3648567199707,68.7131118774414,3.7820181846618652,-63.3648567199707,68.7131118774414,3.7820181846618652,49.7835693359375,55.42811965942383,49.783199310302734,49.7835693359375,55.42811965942383,49.783199310302734,49.7835693359375,55.42811965942383,49.783199310302734,49.7835693359375,55.42811965942383,49.783199310302734,63.364891052246094,68.7131118774414,3.781550168991089,63.364891052246094,68.7131118774414,3.781550168991089,63.364891052246094,68.7131118774414,3.781550168991089,63.364891052246094,68.7131118774414,3.781550168991089,63.3646240234375,3.781778573989868,-68.71334075927734,63.3646240234375,3.781778573989868,-68.71334075927734,63.3646240234375,3.781778573989868,-68.71334075927734,63.3646240234375,3.781778573989868,-68.71334075927734,68.71309661865234,63.3648681640625,-3.7820355892181396,68.71309661865234,63.3648681640625,-3.7820355892181396,68.71309661865234,63.3648681640625,-3.7820355892181396,68.71309661865234,63.3648681640625,-3.7820355892181396,93.4049072265625,3.781350612640381,-3.7816996574401855,93.4049072265625,3.781350612640381,-3.7816996574401855,93.4049072265625,3.781350612640381,-3.7816996574401855,93.4049072265625,3.781350612640381,-3.7816996574401855,68.71288299560547,3.781782865524292,-63.36511993408203,68.71288299560547,3.781782865524292,-63.36511993408203,68.71288299560547,3.781782865524292,-63.36511993408203,68.71288299560547,3.781782865524292,-63.36511993408203,55.42794418334961,49.783382415771484,-49.7835807800293,55.42794418334961,49.783382415771484,-49.7835807800293,55.42794418334961,49.783382415771484,-49.7835807800293,55.42794418334961,49.783382415771484,-49.7835807800293,49.783203125,55.42811965942383,-49.7835578918457,49.783203125,55.42811965942383,-49.7835578918457,49.783203125,55.42811965942383,-49.7835578918457,49.783203125,55.42811965942383,-49.7835578918457,3.7813453674316406,93.4049301147461,-3.781369686126709,3.7813453674316406,93.4049301147461,-3.781369686126709,3.7813453674316406,93.4049301147461,-3.781369686126709,3.7813453674316406,93.4049301147461,-3.781369686126709,93.40494537353516,-3.7813589572906494,3.7810134887695312,93.40494537353516,-3.7813589572906494,3.7810134887695312,93.40494537353516,-3.7813589572906494,3.7810134887695312,93.40494537353516,-3.7813589572906494,3.7810134887695312,-3.7816996574401855,3.7813563346862793,-93.40489196777344,-3.7816996574401855,3.7813563346862793,-93.40489196777344,-3.7816996574401855,3.7813563346862793,-93.40489196777344,-3.7816996574401855,3.7813563346862793,-93.40489196777344,-49.7835807800293,49.78338623046875,-55.427940368652344,-49.7835807800293,49.78338623046875,-55.427940368652344,-49.7835807800293,49.78338623046875,-55.427940368652344,-49.7835807800293,49.78338623046875,-55.427940368652344,55.428306579589844,49.783382415771484,49.78317642211914,55.428306579589844,49.783382415771484,49.78317642211914,55.428306579589844,49.783382415771484,49.78317642211914,55.428306579589844,49.783382415771484,49.78317642211914,-3.7813727855682373,-93.4049301147461,-3.781342029571533,-3.7813727855682373,-93.4049301147461,-3.781342029571533,-3.7813727855682373,-93.4049301147461,-3.781342029571533,-3.7813727855682373,-93.4049301147461,-3.781342029571533,-68.71334838867188,-3.781782865524292,-63.36461639404297,-68.71334838867188,-3.781782865524292,-63.36461639404297,-68.71334838867188,-3.781782865524292,-63.36461639404297,-68.71334838867188,-3.781782865524292,-63.36461639404297,-3.7820396423339844,-63.364871978759766,-68.71309661865234,-3.7820396423339844,-63.364871978759766,-68.71309661865234,-3.7820396423339844,-63.364871978759766,-68.71309661865234,-3.7820396423339844,-63.364871978759766,-68.71309661865234,-49.7835807800293,-49.783382415771484,-55.427940368652344,-49.7835807800293,-49.783382415771484,-55.427940368652344,-49.7835807800293,-49.783382415771484,-55.427940368652344,-49.7835807800293,-49.783382415771484,-55.427940368652344,63.3648567199707,-68.7131118774414,-3.7820160388946533,63.3648567199707,-68.7131118774414,-3.7820160388946533,63.3648567199707,-68.7131118774414,-3.7820160388946533,63.3648567199707,-68.7131118774414,-3.7820160388946533,3.781336784362793,-93.4049301147461,-3.7813704013824463,3.781336784362793,-93.4049301147461,-3.7813704013824463,3.781336784362793,-93.4049301147461,-3.7813704013824463,3.781336784362793,-93.4049301147461,-3.7813704013824463,3.7815499305725098,-68.7131118774414,-63.36488342285156,3.7815499305725098,-68.7131118774414,-63.36488342285156,3.7815499305725098,-68.7131118774414,-63.36488342285156,3.7815499305725098,-68.7131118774414,-63.36488342285156,-63.3646240234375,3.781787157058716,68.71334075927734,-63.3646240234375,3.781787157058716,68.71334075927734,-63.3646240234375,3.781787157058716,68.71334075927734,-63.3646240234375,3.781787157058716,68.71334075927734,3.7820351123809814,-63.364871978759766,68.71309661865234,3.7820351123809814,-63.364871978759766,68.71309661865234,3.7820351123809814,-63.364871978759766,68.71309661865234,3.7820351123809814,-63.364871978759766,68.71309661865234,63.3651237487793,-3.781787157058716,68.71287536621094,63.3651237487793,-3.781787157058716,68.71287536621094,63.3651237487793,-3.781787157058716,68.71287536621094,63.3651237487793,-3.781787157058716,68.71287536621094,55.42794418334961,-49.783382415771484,-49.7835807800293,55.42794418334961,-49.783382415771484,-49.7835807800293,55.42794418334961,-49.783382415771484,-49.7835807800293,55.42794418334961,-49.783382415771484,-49.7835807800293,-93.4049072265625,3.7813589572906494,3.7816996574401855,-93.4049072265625,3.7813589572906494,3.7816996574401855,-93.4049072265625,3.7813589572906494,3.7816996574401855,-93.4049072265625,3.7813589572906494,3.7816996574401855,-55.42794418334961,49.78338623046875,49.7835807800293,-55.42794418334961,49.78338623046875,49.7835807800293,-55.42794418334961,49.78338623046875,49.7835807800293,-55.42794418334961,49.78338623046875,49.7835807800293,68.71311950683594,-63.3648796081543,3.7815308570861816,68.71311950683594,-63.3648796081543,3.7815308570861816,68.71311950683594,-63.3648796081543,3.7815308570861816,68.71311950683594,-63.3648796081543,3.7815308570861816,3.781013250350952,3.7813565731048584,-93.4049301147461,3.781013250350952,3.7813565731048584,-93.4049301147461,3.781013250350952,3.7813565731048584,-93.4049301147461,3.781013250350952,3.7813565731048584,-93.4049301147461,-63.3651237487793,3.781787157058716,-68.71288299560547,-63.3651237487793,3.781787157058716,-68.71288299560547,-63.3651237487793,3.781787157058716,-68.71288299560547,-63.3651237487793,3.781787157058716,-68.71288299560547,-63.3651237487793,-3.781778573989868,-68.71287536621094,-63.3651237487793,-3.781778573989868,-68.71287536621094,-63.3651237487793,-3.781778573989868,-68.71287536621094,-63.3651237487793,-3.781778573989868,-68.71287536621094,3.7815260887145996,-63.364871978759766,-68.71311950683594,3.7815260887145996,-63.364871978759766,-68.71311950683594,3.7815260887145996,-63.364871978759766,-68.71311950683594,3.7815260887145996,-63.364871978759766,-68.71311950683594,-3.781545639038086,68.7131118774414,63.36488342285156,-3.781545639038086,68.7131118774414,63.36488342285156,-3.781545639038086,68.7131118774414,63.36488342285156,-3.781545639038086,68.7131118774414,63.36488342285156,-3.7815303802490234,63.364871978759766,68.71312713623047,-3.7815303802490234,63.364871978759766,68.71312713623047,-3.7815303802490234,63.364871978759766,68.71312713623047,-3.7815303802490234,63.364871978759766,68.71312713623047,3.7820241451263428,68.7131118774414,63.3648567199707,3.7820241451263428,68.7131118774414,63.3648567199707,3.7820241451263428,68.7131118774414,63.3648567199707,3.7820241451263428,68.7131118774414,63.3648567199707,3.7820115089416504,-68.7131118774414,63.3648567199707,3.7820115089416504,-68.7131118774414,63.3648567199707,3.7820115089416504,-68.7131118774414,63.3648567199707,3.7820115089416504,-68.7131118774414,63.3648567199707,93.4049072265625,-3.7813589572906494,-3.7816989421844482,93.4049072265625,-3.7813589572906494,-3.7816989421844482,93.4049072265625,-3.7813589572906494,-3.7816989421844482,93.4049072265625,-3.7813589572906494,-3.7816989421844482,63.36486053466797,68.7131118774414,-3.7820181846618652,63.36486053466797,68.7131118774414,-3.7820181846618652,63.36486053466797,68.7131118774414,-3.7820181846618652,63.36486053466797,68.7131118774414,-3.7820181846618652,68.71312713623047,63.3648681640625,3.7815330028533936,68.71312713623047,63.3648681640625,3.7815330028533936,68.71312713623047,63.3648681640625,3.7815330028533936,68.71312713623047,63.3648681640625,3.7815330028533936,3.7815349102020264,63.364871978759766,-68.71312713623047,3.7815349102020264,63.364871978759766,-68.71312713623047,3.7815349102020264,63.364871978759766,-68.71312713623047,3.7815349102020264,63.364871978759766,-68.71312713623047,-3.7820308208465576,63.364871978759766,-68.71309661865234,-3.7820308208465576,63.364871978759766,-68.71309661865234,-3.7820308208465576,63.364871978759766,-68.71309661865234,-3.7820308208465576,63.364871978759766,-68.71309661865234,-68.71309661865234,-63.3648681640625,3.7820377349853516,-68.71309661865234,-63.3648681640625,3.7820377349853516,-68.71309661865234,-63.3648681640625,3.7820377349853516,-68.71309661865234,-63.3648681640625,3.7820377349853516,-68.71312713623047,-63.3648681640625,-3.7815308570861816,-68.71312713623047,-63.3648681640625,-3.7815308570861816,-68.71312713623047,-63.3648681640625,-3.7815308570861816,-68.71312713623047,-63.3648681640625,-3.7815308570861816,-55.42830276489258,-49.783382415771484,-49.78317642211914,-55.42830276489258,-49.783382415771484,-49.78317642211914,-55.42830276489258,-49.783382415771484,-49.78317642211914,-55.42830276489258,-49.783382415771484,-49.78317642211914,3.7813644409179688,-93.4049301147461,3.781342029571533,3.7813644409179688,-93.4049301147461,3.781342029571533,3.7813644409179688,-93.4049301147461,3.781342029571533,3.7813644409179688,-93.4049301147461,3.781342029571533,63.36488342285156,-68.7131118774414,3.781552314758301,63.36488342285156,-68.7131118774414,3.781552314758301,63.36488342285156,-68.7131118774414,3.781552314758301,63.36488342285156,-68.7131118774414,3.781552314758301,93.40494537353516,3.781350612640381,3.781012773513794,93.40494537353516,3.781350612640381,3.781012773513794,93.40494537353516,3.781350612640381,3.781012773513794,93.40494537353516,3.781350612640381,3.781012773513794,-3.7810142040252686,-3.781355857849121,93.4049301147461,-3.7810142040252686,-3.781355857849121,93.4049301147461,-3.7810142040252686,-3.781355857849121,93.4049301147461,-3.7810142040252686,-3.781355857849121,93.4049301147461,-63.36488723754883,-68.7131118774414,-3.781552314758301,-63.36488723754883,-68.7131118774414,-3.781552314758301,-63.36488723754883,-68.7131118774414,-3.781552314758301,-63.36488723754883,-68.7131118774414,-3.781552314758301,-3.7813453674316406,-93.4049301147461,3.7813704013824463,-3.7813453674316406,-93.4049301147461,3.7813704013824463,-3.7813453674316406,-93.4049301147461,3.7813704013824463,-3.7813453674316406,-93.4049301147461,3.7813704013824463,-63.364864349365234,-68.7131118774414,3.7820160388946533,-63.364864349365234,-68.7131118774414,3.7820160388946533,-63.364864349365234,-68.7131118774414,3.7820160388946533,-63.364864349365234,-68.7131118774414,3.7820160388946533,-3.7816994190216064,-3.7813565731048584,-93.40489196777344,-3.7816994190216064,-3.7813565731048584,-93.40489196777344,-3.7816994190216064,-3.7813565731048584,-93.40489196777344,-3.7816994190216064,-3.7813565731048584,-93.40489196777344,63.3646240234375,-3.781787157058716,-68.71334838867188,63.3646240234375,-3.781787157058716,-68.71334838867188,63.3646240234375,-3.781787157058716,-68.71334838867188,63.3646240234375,-3.781787157058716,-68.71334838867188,3.7810134887695312,-3.7813563346862793,-93.4049301147461,3.7810134887695312,-3.7813563346862793,-93.4049301147461,3.7810134887695312,-3.7813563346862793,-93.4049301147461,3.7810134887695312,-3.7813563346862793,-93.4049301147461,68.71309661865234,-63.364871978759766,-3.7820377349853516,68.71309661865234,-63.364871978759766,-3.7820377349853516,68.71309661865234,-63.364871978759766,-3.7820377349853516,68.71309661865234,-63.364871978759766,-3.7820377349853516,68.71288299560547,-3.781787157058716,-63.36511993408203,68.71288299560547,-3.781787157058716,-63.36511993408203,68.71288299560547,-3.781787157058716,-63.36511993408203,68.71288299560547,-3.781787157058716,-63.36511993408203,-93.40494537353516,-3.781350612640381,-3.7810134887695312,-93.40494537353516,-3.781350612640381,-3.7810134887695312,-93.40494537353516,-3.781350612640381,-3.7810134887695312,-93.40494537353516,-3.781350612640381,-3.7810134887695312,-68.71312713623047,63.364871978759766,-3.7815330028533936,-68.71312713623047,63.364871978759766,-3.7815330028533936,-68.71312713623047,63.364871978759766,-3.7815330028533936,-68.71312713623047,63.364871978759766,-3.7815330028533936,68.71334838867188,-3.7817912101745605,63.36461639404297,68.71334838867188,-3.7817912101745605,63.36461639404297,68.71334838867188,-3.7817912101745605,63.36461639404297,68.71334838867188,-3.7817912101745605,63.36461639404297,-3.782020092010498,-68.7131118774414,-63.3648567199707,-3.782020092010498,-68.7131118774414,-63.3648567199707,-3.782020092010498,-68.7131118774414,-63.3648567199707,-3.782020092010498,-68.7131118774414,-63.3648567199707,-3.781336784362793,93.4049301147461,3.781369686126709,-3.781336784362793,93.4049301147461,3.781369686126709,-3.781336784362793,93.4049301147461,3.781369686126709,-3.781336784362793,93.4049301147461,3.781369686126709,3.7813727855682373,93.4049301147461,3.7813427448272705,3.7813727855682373,93.4049301147461,3.7813427448272705,3.7813727855682373,93.4049301147461,3.7813427448272705,3.7813727855682373,93.4049301147461,3.7813427448272705,3.781700372695923,3.781355857849121,93.40489196777344,3.781700372695923,3.781355857849121,93.40489196777344,3.781700372695923,3.781355857849121,93.40489196777344,3.781700372695923,3.781355857849121,93.40489196777344,3.7816989421844482,-3.7813572883605957,93.40489196777344,3.7816989421844482,-3.7813572883605957,93.40489196777344,3.7816989421844482,-3.7813572883605957,93.40489196777344,3.7816989421844482,-3.7813572883605957,93.40489196777344,-3.781012773513794,3.7813572883605957,93.4049301147461,-3.781012773513794,3.7813572883605957,93.4049301147461,-3.781012773513794,3.7813572883605957,93.4049301147461,-3.781012773513794,3.7813572883605957,93.4049301147461,3.7815542221069336,68.7131118774414,-63.36488342285156,3.7815542221069336,68.7131118774414,-63.36488342285156,3.7815542221069336,68.7131118774414,-63.36488342285156,3.7815542221069336,68.7131118774414,-63.36488342285156,-49.78318405151367,-49.783382415771484,55.42829895019531,-49.78318405151367,-49.783382415771484,55.42829895019531,-49.78318405151367,-49.783382415771484,55.42829895019531,-49.78318405151367,-49.783382415771484,55.42829895019531,49.7835807800293,-49.783382415771484,55.42793655395508,49.7835807800293,-49.783382415771484,55.42793655395508,49.7835807800293,-49.783382415771484,55.42793655395508,49.7835807800293,-49.783382415771484,55.42793655395508,49.783565521240234,-55.42811965942383,49.78319549560547,49.783565521240234,-55.42811965942383,49.78319549560547,49.783565521240234,-55.42811965942383,49.78319549560547,49.783565521240234,-55.42811965942383,49.78319549560547,55.42829895019531,-49.783382415771484,49.783172607421875,55.42829895019531,-49.783382415771484,49.783172607421875,55.42829895019531,-49.783382415771484,49.783172607421875,55.42829895019531,-49.783382415771484,49.783172607421875,-49.7835578918457,-55.42811965942383,-49.783199310302734,-49.7835578918457,-55.42811965942383,-49.783199310302734,-49.7835578918457,-55.42811965942383,-49.783199310302734,-49.7835578918457,-55.42811965942383,-49.783199310302734,-49.783199310302734,-55.42811965942383,49.7835578918457,-49.783199310302734,-55.42811965942383,49.7835578918457,-49.783199310302734,-55.42811965942383,49.7835578918457,-49.783199310302734,-55.42811965942383,49.7835578918457,49.78318405151367,-49.783382415771484,-55.42829895019531,49.78318405151367,-49.783382415771484,-55.42829895019531,49.78318405151367,-49.783382415771484,-55.42829895019531,49.78318405151367,-49.783382415771484,-55.42829895019531,-55.42794418334961,-49.783382415771484,49.7835807800293,-55.42794418334961,-49.783382415771484,49.7835807800293,-55.42794418334961,-49.783382415771484,49.7835807800293,-55.42794418334961,-49.783382415771484,49.7835807800293,49.78318405151367,49.783382415771484,-55.42829895019531,49.78318405151367,49.783382415771484,-55.42829895019531,49.78318405151367,49.783382415771484,-55.42829895019531,49.78318405151367,49.783382415771484,-55.42829895019531,-49.78318405151367,49.78338623046875,55.42829895019531,-49.78318405151367,49.78338623046875,55.42829895019531,-49.78318405151367,49.78338623046875,55.42829895019531,-49.78318405151367,49.78338623046875,55.42829895019531,-49.783199310302734,55.42812728881836,49.7835578918457,-49.783199310302734,55.42812728881836,49.7835578918457,-49.783199310302734,55.42812728881836,49.7835578918457,-49.783199310302734,55.42812728881836,49.7835578918457,-63.3646240234375,-3.781782865524292,68.71334838867188,-63.3646240234375,-3.781782865524292,68.71334838867188,-63.3646240234375,-3.781782865524292,68.71334838867188,-63.3646240234375,-3.781782865524292,68.71334838867188,-68.71288299560547,-3.781778573989868,63.36511993408203,-68.71288299560547,-3.781778573989868,63.36511993408203,-68.71288299560547,-3.781778573989868,63.36511993408203,-68.71288299560547,-3.781778573989868,63.36511993408203,-3.7815349102020264,-63.364871978759766,68.71311950683594,-3.7815349102020264,-63.364871978759766,68.71311950683594,-3.7815349102020264,-63.364871978759766,68.71311950683594,-3.7815349102020264,-63.364871978759766,68.71311950683594,-3.7815582752227783,-68.7131118774414,63.36488342285156,-3.7815582752227783,-68.7131118774414,63.36488342285156,-3.7815582752227783,-68.7131118774414,63.36488342285156,-3.7815582752227783,-68.7131118774414,63.36488342285156,-3.782015800476074,68.7131118774414,-63.3648567199707,-3.782015800476074,68.7131118774414,-63.3648567199707,-3.782015800476074,68.7131118774414,-63.3648567199707,-3.782015800476074,68.7131118774414,-63.3648567199707,-68.71334838867188,3.781787157058716,-63.36461639404297,-68.71334838867188,3.781787157058716,-63.36461639404297,-68.71334838867188,3.781787157058716,-63.36461639404297,-68.71334838867188,3.781787157058716,-63.36461639404297,63.3651237487793,3.781782865524292,68.71288299560547,63.3651237487793,3.781782865524292,68.71288299560547,63.3651237487793,3.781782865524292,68.71288299560547,63.3651237487793,3.781782865524292,68.71288299560547,68.71334838867188,3.781778573989868,63.36461639404297,68.71334838867188,3.781778573989868,63.36461639404297,68.71334838867188,3.781778573989868,63.36461639404297,68.71334838867188,3.781778573989868,63.36461639404297,-68.71309661865234,63.3648796081543,3.7820355892181396,-68.71309661865234,63.3648796081543,3.7820355892181396,-68.71309661865234,63.3648796081543,3.7820355892181396,-68.71309661865234,63.3648796081543,3.7820355892181396,-68.71288299560547,3.7817912101745605,63.36511993408203,-68.71288299560547,3.7817912101745605,63.36511993408203,-68.71288299560547,3.7817912101745605,63.36511993408203,-68.71288299560547,3.7817912101745605,63.36511993408203,49.783203125,-55.42811965942383,-49.7835578918457,49.783203125,-55.42811965942383,-49.7835578918457,49.783203125,-55.42811965942383,-49.7835578918457,49.783203125,-55.42811965942383,-49.7835578918457],normalized:!1},normal:{itemSize:3,type:"Float32Array",array:[-.8930176496505737,-.31821155548095703,.31821513175964355,-.8930176496505737,-.31821155548095703,.31821513175964355,-.8930176496505737,-.31821155548095703,.31821513175964355,-.8930176496505737,-.31821155548095703,.31821513175964355,-.3939540982246399,.8304173350334167,-.3939635753631592,-.3939540982246399,.8304173350334167,-.3939635753631592,-.3939540982246399,.8304173350334167,-.3939635753631592,-.3939540982246399,.8304173350334167,-.3939635753631592,-.39820414781570435,.8611265420913696,-.31606101989746094,-.39820414781570435,.8611265420913696,-.31606101989746094,-.39820414781570435,.8611265420913696,-.31606101989746094,-.39820414781570435,.8611265420913696,-.31606101989746094,-.3181779980659485,.8930322527885437,-.3182079792022705,-.3181779980659485,.8930322527885437,-.3182079792022705,-.3181779980659485,.8930322527885437,-.3182079792022705,-.3181779980659485,.8930322527885437,-.3182079792022705,.3160579800605774,.3982042074203491,.8611275553703308,.3160579800605774,.3982042074203491,.8611275553703308,.3160579800605774,.3982042074203491,.8611275553703308,.3160579800605774,.3982042074203491,.8611275553703308,.39394938945770264,.39396142959594727,.8304205536842346,.39394938945770264,.39396142959594727,.8304205536842346,.39394938945770264,.39396142959594727,.8304205536842346,.39394938945770264,.39396142959594727,.8304205536842346,-.8930201530456543,.3182116746902466,-.31820809841156006,-.8930201530456543,.3182116746902466,-.31820809841156006,-.8930201530456543,.3182116746902466,-.31820809841156006,-.8930201530456543,.3182116746902466,-.31820809841156006,-.8304393887519836,.3939298987388611,-.39394134283065796,-.8304393887519836,.3939298987388611,-.39394134283065796,-.8304393887519836,.3939298987388611,-.39394134283065796,-.8304393887519836,.3939298987388611,-.39394134283065796,-.39819657802581787,.8611276745796204,.31606724858283997,-.39819657802581787,.8611276745796204,.31606724858283997,-.39819657802581787,.8611276745796204,.31606724858283997,-.39819657802581787,.8611276745796204,.31606724858283997,.3939548134803772,.8304223418235779,.3939521610736847,.3939548134803772,.8304223418235779,.3939521610736847,.3939548134803772,.8304223418235779,.3939521610736847,.3939548134803772,.8304223418235779,.3939521610736847,.398190438747406,.8611446022987366,.31602901220321655,.398190438747406,.8611446022987366,.31602901220321655,.398190438747406,.8611446022987366,.31602901220321655,.398190438747406,.8611446022987366,.31602901220321655,.39820146560668945,.3160552680492401,-.8611298203468323,.39820146560668945,.3160552680492401,-.8611298203468323,.39820146560668945,.3160552680492401,-.8611298203468323,.39820146560668945,.3160552680492401,-.8611298203468323,.8611258268356323,.39821386337280273,-.31605064868927,.8611258268356323,.39821386337280273,-.31605064868927,.8611258268356323,.39821386337280273,-.31605064868927,.8611258268356323,.39821386337280273,-.31605064868927,.8930308818817139,.3181929588317871,-.318196564912796,.8930308818817139,.3181929588317871,-.318196564912796,.8930308818817139,.3181929588317871,-.318196564912796,.8930308818817139,.3181929588317871,-.318196564912796,.8611277937889099,.3160572052001953,-.39820432662963867,.8611277937889099,.3160572052001953,-.39820432662963867,.8611277937889099,.3160572052001953,-.39820432662963867,.8611277937889099,.3160572052001953,-.39820432662963867,.8304156064987183,.3939667344093323,-.3939545154571533,.8304156064987183,.3939667344093323,-.3939545154571533,.8304156064987183,.3939667344093323,-.3939545154571533,.8304156064987183,.3939667344093323,-.3939545154571533,.39395228028297424,.8304221630096436,-.3939549922943115,.39395228028297424,.8304221630096436,-.3939549922943115,.39395228028297424,.8304221630096436,-.3939549922943115,.39395228028297424,.8304221630096436,-.3939549922943115,.31819266080856323,.893029510974884,-.31820082664489746,.31819266080856323,.893029510974884,-.31820082664489746,.31819266080856323,.893029510974884,-.31820082664489746,.31819266080856323,.893029510974884,-.31820082664489746,.8930361866950989,-.3181893527507782,.3181857466697693,.8930361866950989,-.3181893527507782,.3181857466697693,.8930361866950989,-.3181893527507782,.3181857466697693,.8930361866950989,-.3181893527507782,.3181857466697693,-.3182153105735779,.31821152567863464,-.8930174708366394,-.3182153105735779,.31821152567863464,-.8930174708366394,-.3182153105735779,.31821152567863464,-.8930174708366394,-.3182153105735779,.31821152567863464,-.8930174708366394,-.3939494788646698,.39396119117736816,-.8304205536842346,-.3939494788646698,.39396119117736816,-.8304205536842346,-.3939494788646698,.39396119117736816,-.8304205536842346,-.3939494788646698,.39396119117736816,-.8304205536842346,.8304232358932495,.3939468264579773,.3939582109451294,.8304232358932495,.3939468264579773,.3939582109451294,.8304232358932495,.3939468264579773,.3939582109451294,.8304232358932495,.3939468264579773,.3939582109451294,-.3181976079940796,-.8930297493934631,-.3181954622268677,-.3181976079940796,-.8930297493934631,-.3181954622268677,-.3181976079940796,-.8930297493934631,-.3181954622268677,-.3181976079940796,-.8930297493934631,-.3181954622268677,-.8611258268356323,-.3160642981529236,-.3982030749320984,-.8611258268356323,-.3160642981529236,-.3982030749320984,-.8611258268356323,-.3160642981529236,-.3982030749320984,-.8611258268356323,-.3160642981529236,-.3982030749320984,-.31608039140701294,-.3982047438621521,-.8611190915107727,-.31608039140701294,-.3982047438621521,-.8611190915107727,-.31608039140701294,-.3982047438621521,-.8611190915107727,-.31608039140701294,-.3982047438621521,-.8611190915107727,-.3939639627933502,-.3939467966556549,-.8304204940795898,-.3939639627933502,-.3939467966556549,-.8304204940795898,-.3939639627933502,-.3939467966556549,-.8304204940795898,-.3939639627933502,-.3939467966556549,-.8304204940795898,.39820337295532227,-.8611286282539368,-.31605619192123413,.39820337295532227,-.8611286282539368,-.31605619192123413,.39820337295532227,-.8611286282539368,-.31605619192123413,.39820337295532227,-.8611286282539368,-.31605619192123413,.3181878924369812,-.8930350542068481,-.31819045543670654,.3181878924369812,-.8930350542068481,-.31819045543670654,.3181878924369812,-.8930350542068481,-.31819045543670654,.3181878924369812,-.8930350542068481,-.31819045543670654,.3160671591758728,-.8611257672309875,-.39820101857185364,.3160671591758728,-.8611257672309875,-.39820101857185364,.3160671591758728,-.8611257672309875,-.39820101857185364,.3160671591758728,-.8611257672309875,-.39820101857185364,-.3982013761997223,.3160552680492401,.861129879951477,-.3982013761997223,.3160552680492401,.861129879951477,-.3982013761997223,.3160552680492401,.861129879951477,-.3982013761997223,.3160552680492401,.861129879951477,.31605467200279236,-.39822202920913696,.8611205220222473,.31605467200279236,-.39822202920913696,.8611205220222473,.31605467200279236,-.39822202920913696,.8611205220222473,.31605467200279236,-.39822202920913696,.8611205220222473,.39822128415107727,-.3160440921783447,.8611248135566711,.39822128415107727,-.3160440921783447,.8611248135566711,.39822128415107727,-.3160440921783447,.8611248135566711,.39822128415107727,-.3160440921783447,.8611248135566711,.830415666103363,-.3939518928527832,-.39396917819976807,.830415666103363,-.3939518928527832,-.39396917819976807,.830415666103363,-.3939518928527832,-.39396917819976807,.830415666103363,-.3939518928527832,-.39396917819976807,-.8930335640907288,.31818917393684387,.3181927800178528,-.8930335640907288,.31818917393684387,.3181927800178528,-.8930335640907288,.31818917393684387,.3181927800178528,-.8930335640907288,.31818917393684387,.3181927800178528,-.8304204344749451,.3939615488052368,.39394932985305786,-.8304204344749451,.3939615488052368,.39394932985305786,-.8304204344749451,.3939615488052368,.39394932985305786,-.8304204344749451,.3939615488052368,.39394932985305786,.8611295819282532,-.39820489287376404,.3160513937473297,.8611295819282532,-.39820489287376404,.3160513937473297,.8611295819282532,-.39820489287376404,.3160513937473297,.8611295819282532,-.39820489287376404,.3160513937473297,.31818902492523193,.3181936740875244,-.8930333852767944,.31818902492523193,.3181936740875244,-.8930333852767944,.31818902492523193,.3181936740875244,-.8930333852767944,.31818902492523193,.3181936740875244,-.8930333852767944,-.3982042670249939,.3160568177700043,-.861128032207489,-.3982042670249939,.3160568177700043,-.861128032207489,-.3982042670249939,.3160568177700043,-.861128032207489,-.3982042670249939,.3160568177700043,-.861128032207489,-.3982074558734894,-.31605467200279236,-.8611272573471069,-.3982074558734894,-.31605467200279236,-.8611272573471069,-.3982074558734894,-.31605467200279236,-.8611272573471069,-.3982074558734894,-.31605467200279236,-.8611272573471069,.31604087352752686,-.3982185125350952,-.8611272573471069,.31604087352752686,-.3982185125350952,-.8611272573471069,.31604087352752686,-.3982185125350952,-.8611272573471069,.31604087352752686,-.3982185125350952,-.8611272573471069,-.31601834297180176,.8611423373222351,.39820387959480286,-.31601834297180176,.8611423373222351,.39820387959480286,-.31601834297180176,.8611423373222351,.39820387959480286,-.31601834297180176,.8611423373222351,.39820387959480286,-.31606096029281616,.39820629358291626,.8611255288124084,-.31606096029281616,.39820629358291626,.8611255288124084,-.31606096029281616,.39820629358291626,.8611255288124084,-.31606096029281616,.39820629358291626,.8611255288124084,.31606805324554443,.8611271977424622,.39819690585136414,.31606805324554443,.8611271977424622,.39819690585136414,.31606805324554443,.8611271977424622,.39819690585136414,.31606805324554443,.8611271977424622,.39819690585136414,.31605327129364014,-.8611239194869995,.3982159495353699,.31605327129364014,-.8611239194869995,.3982159495353699,.31605327129364014,-.8611239194869995,.3982159495353699,.31605327129364014,-.8611239194869995,.3982159495353699,.8930177092552185,-.31821155548095703,-.31821513175964355,.8930177092552185,-.31821155548095703,-.31821513175964355,.8930177092552185,-.31821155548095703,-.31821513175964355,.8930177092552185,-.31821155548095703,-.31821513175964355,.39822056889533997,.8611229658126831,-.3160500228404999,.39822056889533997,.8611229658126831,-.3160500228404999,.39822056889533997,.8611229658126831,-.3160500228404999,.39822056889533997,.8611229658126831,-.3160500228404999,.8611273765563965,.3982042968273163,.3160584568977356,.8611273765563965,.3982042968273163,.3160584568977356,.8611273765563965,.3982042968273163,.3160584568977356,.8611273765563965,.3982042968273163,.3160584568977356,.31604790687561035,.3982231020927429,-.8611226081848145,.31604790687561035,.3982231020927429,-.8611226081848145,.31604790687561035,.3982231020927429,-.8611226081848145,.31604790687561035,.3982231020927429,-.8611226081848145,-.3160579800605774,.39820435643196106,-.8611276149749756,-.3160579800605774,.39820435643196106,-.8611276149749756,-.3160579800605774,.39820435643196106,-.8611276149749756,-.3160579800605774,.39820435643196106,-.8611276149749756,-.8611293435096741,-.3981947600841522,.31606513261795044,-.8611293435096741,-.3981947600841522,.31606513261795044,-.8611293435096741,-.3981947600841522,.31606513261795044,-.8611293435096741,-.3981947600841522,.31606513261795044,-.8611273169517517,-.3982181251049042,-.31604093313217163,-.8611273169517517,-.3982181251049042,-.31604093313217163,-.8611273169517517,-.3982181251049042,-.31604093313217163,-.8611273169517517,-.3982181251049042,-.31604093313217163,-.8304233551025391,-.3939613699913025,-.39394333958625793,-.8304233551025391,-.3939613699913025,-.39394333958625793,-.8304233551025391,-.3939613699913025,-.39394333958625793,-.8304233551025391,-.3939613699913025,-.39394333958625793,.31822317838668823,-.8930189609527588,.31819969415664673,.31822317838668823,-.8930189609527588,.31819969415664673,.31822317838668823,-.8930189609527588,.31819969415664673,.31822317838668823,-.8930189609527588,.31819969415664673,.398205429315567,-.861126184463501,.3160603642463684,.398205429315567,-.861126184463501,.3160603642463684,.398205429315567,-.861126184463501,.3160603642463684,.398205429315567,-.861126184463501,.3160603642463684,.8930307030677795,.31819677352905273,.31819313764572144,.8930307030677795,.31819677352905273,.31819313764572144,.8930307030677795,.31819677352905273,.31819313764572144,.8930307030677795,.31819677352905273,.31819313764572144,-.31818729639053345,-.31819117069244385,.8930348753929138,-.31818729639053345,-.31819117069244385,.8930348753929138,-.31818729639053345,-.31819117069244385,.8930348753929138,-.31818729639053345,-.31819117069244385,.8930348753929138,-.39820730686187744,-.8611242771148682,-.31606295704841614,-.39820730686187744,-.8611242771148682,-.31606295704841614,-.39820730686187744,-.8611242771148682,-.31606295704841614,-.39820730686187744,-.8611242771148682,-.31606295704841614,-.3181917071342468,-.8930321931838989,.31819429993629456,-.3181917071342468,-.8930321931838989,.31819429993629456,-.3181917071342468,-.8930321931838989,.31819429993629456,-.3181917071342468,-.8930321931838989,.31819429993629456,-.39820390939712524,-.8611285090446472,.31605613231658936,-.39820390939712524,-.8611285090446472,.31605613231658936,-.39820390939712524,-.8611285090446472,.31605613231658936,-.39820390939712524,-.8611285090446472,.31605613231658936,-.3181929588317871,-.3181893825531006,-.8930334448814392,-.3181929588317871,-.3181893825531006,-.8930334448814392,-.3181929588317871,-.3181893825531006,-.8930334448814392,-.3181929588317871,-.3181893825531006,-.8930334448814392,.398214727640152,-.3160427510738373,-.8611282706260681,.398214727640152,-.3160427510738373,-.8611282706260681,.398214727640152,-.3160427510738373,-.8611282706260681,.398214727640152,-.3160427510738373,-.8611282706260681,.31819266080856323,-.31819653511047363,-.8930309414863586,.31819266080856323,-.31819653511047363,-.8930309414863586,.31819266080856323,-.31819653511047363,-.8930309414863586,.31819266080856323,-.31819653511047363,-.8930309414863586,.8611248731613159,-.39820438623428345,-.31606507301330566,.8611248731613159,-.39820438623428345,-.31606507301330566,.8611248731613159,-.39820438623428345,-.31606507301330566,.8611248731613159,-.39820438623428345,-.31606507301330566,.8611255884170532,-.3160474896430969,-.39821693301200867,.8611255884170532,-.3160474896430969,-.39821693301200867,.8611255884170532,-.3160474896430969,-.39821693301200867,.8611255884170532,-.3160474896430969,-.39821693301200867,-.8930345773696899,-.3181912899017334,-.31818774342536926,-.8930345773696899,-.3181912899017334,-.31818774342536926,-.8930345773696899,-.3181912899017334,-.31818774342536926,-.8930345773696899,-.3181912899017334,-.31818774342536926,-.8611279726028442,.3982178866863251,-.3160398602485657,-.8611279726028442,.3982178866863251,-.3160398602485657,-.8611279726028442,.3982178866863251,-.3160398602485657,-.8611279726028442,.3982178866863251,-.3160398602485657,.8611286878585815,-.3160666823387146,.39819496870040894,.8611286878585815,-.3160666823387146,.39819496870040894,.8611286878585815,-.3160666823387146,.39819496870040894,.8611286878585815,-.3160666823387146,.39819496870040894,-.31604599952697754,-.8611259460449219,-.3982173800468445,-.31604599952697754,-.8611259460449219,-.3982173800468445,-.31604599952697754,-.8611259460449219,-.3982173800468445,-.31604599952697754,-.8611259460449219,-.3982173800468445,-.3182077705860138,.8930187225341797,.31821584701538086,-.3182077705860138,.8930187225341797,.31821584701538086,-.3182077705860138,.8930187225341797,.31821584701538086,-.3182077705860138,.8930187225341797,.31821584701538086,.31819307804107666,.8930350542068481,.3181852102279663,.31819307804107666,.8930350542068481,.3181852102279663,.31819307804107666,.8930350542068481,.3181852102279663,.31819307804107666,.8930350542068481,.3181852102279663,.3181931972503662,.3181889057159424,.893033504486084,.3181931972503662,.3181889057159424,.893033504486084,.3181931972503662,.3181889057159424,.893033504486084,.3181931972503662,.3181889057159424,.893033504486084,.3182152509689331,-.3182116150856018,.893017590045929,.3182152509689331,-.3182116150856018,.893017590045929,.3182152509689331,-.3182116150856018,.893017590045929,.3182152509689331,-.3182116150856018,.893017590045929,-.3182075023651123,.31821173429489136,.8930203914642334,-.3182075023651123,.31821173429489136,.8930203914642334,-.3182075023651123,.31821173429489136,.8930203914642334,-.3182075023651123,.31821173429489136,.8930203914642334,.3160323202610016,.8611453771591187,-.39818620681762695,.3160323202610016,.8611453771591187,-.39818620681762695,.3160323202610016,.8611453771591187,-.39818620681762695,.3160323202610016,.8611453771591187,-.39818620681762695,-.39394327998161316,-.39396142959594727,.8304233551025391,-.39394327998161316,-.39396142959594727,.8304233551025391,-.39394327998161316,-.39396142959594727,.8304233551025391,-.39394327998161316,-.39396142959594727,.8304233551025391,.39394742250442505,-.3939295709133148,.8304365277290344,.39394742250442505,-.3939295709133148,.8304365277290344,.39394742250442505,-.3939295709133148,.8304365277290344,.39394742250442505,-.3939295709133148,.8304365277290344,.393976092338562,-.8304168581962585,.39394256472587585,.393976092338562,-.8304168581962585,.39394256472587585,.393976092338562,-.8304168581962585,.39394256472587585,.393976092338562,-.8304168581962585,.39394256472587585,.8304234743118286,-.39396101236343384,.3939433991909027,.8304234743118286,-.39396101236343384,.3939433991909027,.8304234743118286,-.39396101236343384,.3939433991909027,.8304234743118286,-.39396101236343384,.3939433991909027,-.3939476013183594,-.8304222822189331,-.3939594626426697,-.3939476013183594,-.8304222822189331,-.3939594626426697,-.3939476013183594,-.8304222822189331,-.3939594626426697,-.3939476013183594,-.8304222822189331,-.3939594626426697,-.3939593434333801,-.8304222822189331,.3939477205276489,-.3939593434333801,-.8304222822189331,.3939477205276489,-.3939593434333801,-.8304222822189331,.3939477205276489,-.3939593434333801,-.8304222822189331,.3939477205276489,.393926739692688,-.3939448595046997,-.8304391503334045,.393926739692688,-.3939448595046997,-.8304391503334045,.393926739692688,-.3939448595046997,-.8304391503334045,.393926739692688,-.3939448595046997,-.8304391503334045,-.8304203152656555,-.39394691586494446,.39396411180496216,-.8304203152656555,-.39394691586494446,.39396411180496216,-.8304203152656555,-.39394691586494446,.39396411180496216,-.8304203152656555,-.39394691586494446,.39396411180496216,.3939414918422699,.393930047750473,-.8304392099380493,.3939414918422699,.393930047750473,-.8304392099380493,.3939414918422699,.393930047750473,-.8304392099380493,.3939414918422699,.393930047750473,-.8304392099380493,-.3939580023288727,.39394649863243103,.8304234743118286,-.3939580023288727,.39394649863243103,.8304234743118286,-.3939580023288727,.39394649863243103,.8304234743118286,-.3939580023288727,.39394649863243103,.8304234743118286,-.39395201206207275,.8304221630096436,.39395517110824585,-.39395201206207275,.8304221630096436,.39395517110824585,-.39395201206207275,.8304221630096436,.39395517110824585,-.39395201206207275,.8304221630096436,.39395517110824585,-.39820295572280884,-.3160640299320221,.8611259460449219,-.39820295572280884,-.3160640299320221,.8611259460449219,-.39820295572280884,-.3160640299320221,.8611259460449219,-.39820295572280884,-.3160640299320221,.8611259460449219,-.8611248135566711,-.3160442113876343,.39822128415107727,-.8611248135566711,-.3160442113876343,.39822128415107727,-.8611248135566711,-.3160442113876343,.39822128415107727,-.8611248135566711,-.3160442113876343,.39822128415107727,-.31604111194610596,-.3982183337211609,.8611273169517517,-.31604111194610596,-.3982183337211609,.8611273169517517,-.31604111194610596,-.3982183337211609,.8611273169517517,-.31604111194610596,-.3982183337211609,.8611273169517517,-.3160600960254669,-.8611261248588562,.39820581674575806,-.3160600960254669,-.8611261248588562,.39820581674575806,-.3160600960254669,-.8611261248588562,.39820581674575806,-.3160600960254669,-.8611261248588562,.39820581674575806,-.31606826186180115,.8611270189285278,-.39819711446762085,-.31606826186180115,.8611270189285278,-.39819711446762085,-.31606826186180115,.8611270189285278,-.39819711446762085,-.31606826186180115,.8611270189285278,-.39819711446762085,-.8611301183700562,.3160545825958252,-.3982013463973999,-.8611301183700562,.3160545825958252,-.3982013463973999,-.8611301183700562,.3160545825958252,-.3982013463973999,-.8611301183700562,.3160545825958252,-.3982013463973999,.3982081413269043,.31607723236083984,.8611186742782593,.3982081413269043,.31607723236083984,.8611186742782593,.3982081413269043,.31607723236083984,.8611186742782593,.3982081413269043,.31607723236083984,.8611186742782593,.8611276745796204,.3160439729690552,.3982152044773102,.8611276745796204,.3160439729690552,.3982152044773102,.8611276745796204,.3160439729690552,.3982152044773102,.8611276745796204,.3160439729690552,.3982152044773102,-.8611273765563965,.39820489287376404,.3160577416419983,-.8611273765563965,.39820489287376404,.3160577416419983,-.8611273765563965,.39820489287376404,.3160577416419983,-.8611273765563965,.39820489287376404,.3160577416419983,-.8611289858818054,.3160620927810669,.3981979489326477,-.8611289858818054,.3160620927810669,.3981979489326477,-.8611289858818054,.3160620927810669,.3981979489326477,-.8611289858818054,.3160620927810669,.3981979489326477,.3939596116542816,-.8304221630096436,-.39394763112068176,.3939596116542816,-.8304221630096436,-.39394763112068176,.3939596116542816,-.8304221630096436,-.39394763112068176,.3939596116542816,-.8304221630096436,-.39394763112068176],normalized:!1},uv:{itemSize:2,type:"Float32Array",array:[.04120219498872757,.12086033821105957,.05345028638839722,.08731907606124878,.11187556385993958,.0670785903930664,.6875278949737549,.13345998525619507,.04903397709131241,.004412055015563965,.0771341323852539,.03593343496322632,.11686006188392639,.03130292892456055,.31248292326927185,.10850334167480469,.0489392951130867,.02688688039779663,.06469712406396866,.01563972234725952,.0803603008389473,.0917351245880127,.3686402440071106,.07315778732299805,.08036012947559357,.12086033821105957,.09260810911655426,.08731895685195923,.10864977538585663,.015640199184417725,.31252771615982056,.008440375328063965,.07252871245145798,.0917351245880127,.08828651905059814,.02688688039779663,.10081818699836731,.02688688039779663,.4936917722225189,.19815367460250854,.08025602996349335,.04575681686401367,.08838120102882385,.004412055015563965,.1084604263305664,.0983855128288269,.4374849796295166,.23353207111358643,.037787072360515594,.08731907606124878,.049033790826797485,.08731907606124878,.1084604263305664,.06366342306137085,.18752798438072205,.38353127241134644,.04542912542819977,.004412055015563965,.08025602996349335,.034130990505218506,.1040443629026413,.06484419107437134,.18748320639133453,.4834633469581604,.006349444389343262,.5731359720230103,.006555216386914253,.02688688039779663,.06469712406396866,.01905524730682373,.07694480568170547,.0917351245880127,.030523335561156273,.02688688039779663,.0771341323852539,.043954312801361084,.08477634936571121,.004412055015563965,.4374811053276062,.35838615894317627,.014292115345597267,.12086033821105957,.03061802126467228,.004412055015563965,.0964021235704422,.015639781951904297,.4934193789958954,.32318025827407837,.053450047969818115,.01905524730682373,.06469716131687164,.0917351245880127,.09630745649337769,.05377775430679321,.49373188614845276,.44814980030059814,.009876048192381859,.0917351245880127,.09298662841320038,.01905524730682373,.11999154090881348,.09396946430206299,.6183853149414062,.3231801986694336,.00987587682902813,.12086033821105957,.029955485835671425,.12086033821105957,.06469673663377762,.007808566093444824,.562527596950531,.2587568163871765,.0299553032964468,.0917351245880127,.05686555057764053,.01905524730682373,.09289196133613586,.05377775430679321,.5065897703170776,.32315701246261597,.056571945548057556,.0421520471572876,.09279727190732956,.03130292892456055,.1200861781835556,.07149463891983032,.5624833106994629,.35836511850357056,.018086323514580727,.004412055015563965,.056571945548057556,.04575687646865845,.11648134887218475,.07149463891983032,.18748287856578827,.3584839701652527,.017707442864775658,.09173506498336792,.09602326154708862,.08731895685195923,.1120648980140686,.015640199184417725,.1875280737876892,.2584848999977112,.05345025658607483,.12086033821105957,.06128161400556564,.011223673820495605,.07252849638462067,.08731907606124878,.3125280439853668,.13357031345367432,.03337060660123825,.08731913566589355,.0769449844956398,.087319016456604,.10864977538585663,.0078089237213134766,.5625283718109131,.133742094039917,.08025602996349335,.03773587942123413,.10043948143720627,.06484419107437134,.12046489119529724,.03130292892456055,.5624833703041077,.23337173461914062,.03412818908691406,.02688688039779663,.08025602996349335,.04215192794799805,.11206528544425964,.0983855128288269,.18748319149017334,.23347699642181396,.006460724398493767,.087319016456604,.017707442864775658,.087319016456604,.06252795457839966,.25844651460647583,.1120649129152298,.023471713066101074,.014576157554984093,.05377775430679321,.04561847448348999,.058193862438201904,.1008182168006897,.01563972234725952,.25627732276916504,.44812923669815063,.006148636341094971,.4481179118156433,.05686555057764053,.026886820793151855,.08819183707237244,.12086033821105957,.10893382132053375,.05377775430679321,.018086323514580727,.03130292892456055,.056571945548057556,.05017292499542236,.06248307228088379,.48360395431518555,.10883913934230804,.03130292892456055,.025539224967360497,.05819380283355713,.07252870500087738,.01563972234725952,.1039496660232544,.12086033821105957,.49378809332847595,.07314485311508179,.014292331412434578,.087319016456604,.025539005175232887,.087319016456604,.10864977538585663,.023471713066101074,.4375278651714325,.008257150650024414,.009970692917704582,.03130298852920532,.014292115345597267,.05819380283355713,.053450047969818115,.023471355438232422,.3811866044998169,.07312166690826416,.0490339919924736,.0917351245880127,.0803602933883667,.01563972234725952,.10432836413383484,.05377775430679321,.6185856461524963,.44816309213638306,.02601257897913456,.03130292892456055,.061281636357307434,.05819380283355713,.06469713896512985,.02688688039779663,.6315924525260925,.32315754890441895,.03061799891293049,.03130292892456055,.06911320239305496,.023471355438232422,.09602341055870056,.09173518419265747,.7433825731277466,.32318103313446045,.08477634936571121,.05377775430679321,.10043948143720627,.0983855128288269,.11629162728786469,.0652761459350586,.687483012676239,.4834805130958557,.037787072360515594,.12086033821105957,.041202202439308167,.08731907606124878,.11187553405761719,.06366342306137085,.5625277757644653,.00847846269607544,.010065404698252678,.004412055015563965,.05345005542039871,.035933494567871094,.1008182168006897,.03130298852920532,.5624833703041077,.10848653316497803,.02601257897913456,.02688688039779663,.06911320239305496,.01905524730682373,.07252870500087738,.05819380283355713,.3685356378555298,.19816696643829346,.029955485835671425,.08731913566589355,.06469696015119553,.12086033821105957,.10864977538585663,.011224091053009033,.43752849102020264,.38332629203796387,.07694479078054428,.05819380283355713,.10053417086601257,.08731895685195923,.10423369705677032,.01905524730682373,.5065778493881226,.19815611839294434,.017991656437516212,.05377775430679321,.0803602933883667,.05819380283355713,.10423369705677032,.01563972234725952,.1188262403011322,.4481416940689087,.0065551940351724625,.03130298852920532,.05686555057764053,.023471355438232422,.084776371717453,.12086033821105957,.7436801791191101,.07315462827682495,.025539247319102287,.09173518419265747,.06460244953632355,.05377769470214844,.10423369705677032,.023471355438232422,.11862531304359436,.5731591582298279,.06118693947792053,.05377769470214844,.06911322474479675,.0917351245880127,.10081818699836731,.023471355438232422,.5063889026641846,.4481391906738281,.022123711183667183,.09173518419265747,.08487099409103394,.02688688039779663,.10423369705677032,.02688688039779663,.38155296444892883,.3231542706489563,.02259708009660244,.03130292892456055,.06128162145614624,.02688688039779663,.08819186687469482,.05819392204284668,.24363532662391663,.5731584429740906,.03337061405181885,.12086033821105957,.06469673663377762,.011223673820495605,.0691133663058281,.08731907606124878,.687528133392334,.3834933042526245,.017707636579871178,.12086033821105957,.0964021235704422,.01905524730682373,.11657601594924927,.09396946430206299,.1313704252243042,.32313746213912964,.006460549309849739,.0917351245880127,.03403352200984955,.004412055015563965,.09298662841320038,.015639781951904297,.13138353824615479,.1981390118598938,.014576157554984093,.02688688039779663,.0299553032964468,.05819392204284668,.0803602784872055,.026886820793151855,.38124242424964905,.4481261968612671,.033370792865753174,.05819392204284668,.0803602784872055,.023471355438232422,.12037022411823273,.05377775430679321,.6183971166610718,.19817936420440674,.05345005542039871,.058193862438201904,.0964021235704422,.02688688039779663,.11999151110649109,.0983855128288269,.6313499808311462,.1981356143951416,.056865572929382324,.058193862438201904,.06920789182186127,.03130286931991577,.0964021235704422,.023471355438232422,.3686973452568054,.4481528401374817,.014481494203209877,.03130292892456055,.056571945548057556,.05377781391143799,.06911319494247437,.05377769470214844,.3124830424785614,.48353415727615356,.022123875096440315,.087319016456604,.08819165080785751,.08731907606124878,.10864977538585663,.02688688039779663,.18752774596214294,.5084468126296997,.022123703733086586,.05819380283355713,.02259708009660244,.02688688039779663,.07252870500087738,.01905524730682373,.1313396394252777,.5731350779533386,.00646076537668705,.12086033821105957,.05686537176370621,.12086033821105957,.06128161400556564,.007808566093444824,.18752765655517578,.1335013508796692,.04561866074800491,.12086033821105957,.053450047969818115,.007808566093444824,.06252825260162354,.1334705352783203,.06469693779945374,.08731907606124878,.006339132785797119,.3231348991394043,.006460549309849739,.05819380283355713,.07262339442968369,.03130286931991577,.09298662841320038,.023471355438232422,.009875854477286339,.087319016456604,.08477649837732315,.08731907606124878,.1120649129152298,.02688688039779663,.31252795457839966,.25839555263519287,.009876048192381859,.05819380283355713,.09298662841320038,.02688688039779663,.11657601594924927,.0983855128288269,.36867624521255493,.3231545090675354,.06252825260162354,.383209228515625,.08036010712385178,.087319016456604,.0881916955113411,.09173506498336792,.1120649129152298,.0078089237213134766,.053450047969818115,.01563972234725952,.06128164380788803,.0917351245880127,.08828655630350113,.03130298852920532,.6312947273254395,.073131263256073,.061281830072402954,.12086033821105957,.08477656543254852,.09173506498336792,.1120649129152298,.011224091053009033,.6875279545783997,.008391082286834717,.06911320239305496,.01563972234725952,.06911322474479675,.05819380283355713,.10053417086601257,.12086033821105957,.631377100944519,.44813835620880127,.033370815217494965,.0917351245880127,.05686555057764053,.01563972234725952,.08487105369567871,.03130298852920532,.7435976266860962,.44816213846206665,.04561866074800491,.08731907606124878,.05686540901660919,.08731907606124878,.1084604263305664,.0670785903930664,.3125280737876892,.3833693861961365,.037786878645420074,.05819380283355713,.04552379250526428,.02688688039779663,.06128161400556564,.01563972234725952,.13140809535980225,.4481407403945923,.03403349965810776,.03130292892456055,.05345005542039871,.0917351245880127,.06911320239305496,.026886820793151855,.2564394772052765,.19814354181289673,.017707636579871178,.05819380283355713,.053450047969818115,.026886820793151855,.11234933137893677,.05377775430679321,.11863547563552856,.32315850257873535,.025539016351103783,.12086033821105957,.0625276267528534,.5084590315818787,.07694500684738159,.12086033821105957,.10864977538585663,.01905524730682373,.014292312785983086,.09173506498336792,.022123919799923897,.12086033821105957,.1120648980140686,.01905524730682373,.43752825260162354,.2587151527404785,.05686517059803009,.011223673820495605,.07252854108810425,.12086033821105957,.09260810166597366,.12086033821105957,.4375276267528534,.13337987661361694,.053450047969818115,.011223673820495605,.06128180772066116,.08731907606124878,.09602323174476624,.12086033821105957,.687527596950531,.2587602138519287,.049033790826797485,.12086033821105957,.05686517059803009,.007808566093444824,.06911341845989227,.12086033821105957,.5625280141830444,.38350802659988403,.017991656437516212,.02688688039779663,.07694479078054428,.02688688039779663,.09602341055870056,.05819380283355713,.24360424280166626,.3231614828109741,.045429132878780365,.03130298852920532,.06248307228088379,.2334902286529541,.11206528544425964,.07149463891983032,.11960287392139435,.023281991481781006,.026107268407940865,.05377775430679321,.030523335561156273,.05377775430679321,.08025602996349335,.05377769470214844,.6874831914901733,.3583640456199646,.022502413019537926,.004412055015563965,.022502413019537926,.05377775430679321,.08025602996349335,.05017286539077759,.18748320639133453,.6085007190704346,.026107246056199074,.004412055015563965,.03412819653749466,.05377775430679321,.0771341323852539,.0519753098487854,.3124833106994629,.2334464192390442,.05345005542039871,.051975369453430176,.062483012676239014,.3585008978843689,.0727180615067482,.05377769470214844,.11244398355484009,.03130292892456055,.1084604263305664,.07149463891983032,.11648134887218475,.12086033821105957,.11960287392139435,.02688688039779663,.31248316168785095,.35852259397506714,.006460549309849739,.05377775430679321,.08838121592998505,.05377775430679321,.11941350996494293,.06347370147705078,.6874832510948181,.10852515697479248,.0490339919924736,.03130298852920532,.11648097634315491,.02508443593978882,.1200861781835556,.12086033821105957,.6874829530715942,.23349487781524658,.014481494203209877,.004412055015563965,.05345005542039871,.043954432010650635,.0964021235704422,.03130292892456055,.43748292326927185,.4835529923439026,.05657196044921875,.037735939025878906,.061092279851436615,.03130286931991577,.10442306846380234,.03130298852920532,.5624828934669495,.4834739565849304,.006460549309849739,.004412055015563965,.056571945548057556,.03413110971450806,.06248317286372185,.6084953546524048,.06469713896512985,.03130286931991577,.006358683109283447,.198136568069458,.04552381485700607,.05377781391143799,.04561847448348999,.0917351245880127,.0803602933883667,.01905524730682373,.04120240360498428,.0917351245880127,.04893931746482849,.05377781391143799,.07694479078054428,.01905524730682373,.7436245679855347,.1981593370437622,.06469712406396866,.023471355438232422,.06469712406396866,.05819380283355713,.11197057366371155,.09396946430206299,.11861595511436462,.1981601119041443,.06128162145614624,.023471355438232422,.084776371717453,.05819392204284668,.10855509340763092,.09396940469741821,.25629860162734985,.32313108444213867,.07694478332996368,.023471355438232422,.09260791540145874,.05819380283355713,.1169547289609909,.05377775430679321,.256334125995636,.07313430309295654,.049033984541893005,.058193862438201904,.1008182168006897,.01905524730682373,.1039496511220932,.08731895685195923,.2435668408870697,.448164165019989,.07252871245145798,.023471355438232422,.09260791540145874,.09173518419265747,.10855511575937271,.12086033821105957,.38128527998924255,.19813251495361328,.056865572929382324,.0917351245880127,.07252871245145798,.026886820793151855,.11197061836719513,.12086033821105957,.2435913383960724,.19816231727600098,.009970737621188164,.02688688039779663,.04120238125324249,.05819380283355713,.06128162145614624,.01905524730682373,.6186096668243408,.07316023111343384,.037786878645420074,.0917351245880127,.07694479078054428,.01563972234725952,.10091288387775421,.05377775430679321,.5063652992248535,.07313716411590576,.010065404698252678,.05377775430679321,.10404433310031891,.0983855128288269,.11941350996494293,.0670785903930664,.4374832212924957,.10858356952667236],normalized:!1}},index:{type:"Uint16Array",array:[283,23,19,231,319,235,27,31,363,338,273,32,39,279,171,147,331,47,55,63,51,67,71,183,75,311,143,79,83,195,222,297,351,219,87,371,90,313,271,259,207,203,236,102,155,111,383,107,291,335,119,247,323,159,287,303,127,179,131,255,135,139,375,3,327,347,308,213,140,91,210,230,70,275,278,348,173,122,269,157,114,36,185,41,193,293,190,108,268,113,28,8,4,294,13,69,18,162,166,9,374,34,82,358,194,26,2,134,361,154,94,233,202,227,277,160,168,117,346,343,99,315,103,260,133,373,246,78,146,212,109,104,276,180,68,301,264,124,369,125,266,284,289,221,177,218,73,381,250,106,172,300,120,33,136,336,322,130,382,112,320,380,298,354,350,238,158,98,285,349,121,249,74,142,228,225,88,176,56,53,132,344,376,189,76,192,274,10,35,368,72,217,237,148,77,1,200,196,342,288,116,165,281,16,184,52,48,241,145,45,25,93,256,126,282,286,339,164,161,42,49,181,92,100,204,341,324,296,378,334,138,312,205,101,149,30,81,337,137,332,105,141,214,226,206,314,5,80,29,60,329,65,44,253,240,66,50,62,299,325,318,328,292,64,37,20,85,366,86,22,58,330,61,254,321,242,211,307,175,15,7,11,310,302,306,198,317,326,353,209,174,21,169,17,283,367,23,231,355,319,27,263,31,338,163,273,39,43,279,147,191,331,55,59,63,67,295,71,75,267,311,79,151,83,222,340,297,219,187,87,90,224,313,259,95,207,236,96,102,111,115,383,291,167,335,247,243,323,287,123,303,179,251,131,135,379,139,3,199,327,308,304,213,91,110,210,70,14,275,348,352,173,269,97,157,36,84,185,193,356,293,108,89,268,28,261,8,294,357,13,18,170,162,9,262,374,82,6,358,26,258,2,361,150,154,233,197,202,277,272,160,117,377,346,99,270,315,260,24,133,246,239,78,212,208,109,276,40,180,301,309,264,369,364,125,284,280,289,177,54,218,381,129,250,172,305,300,33,372,136,112,156,320,298,316,354,238,245,158,285,223,349,249,178,74,228,232,225,176,252,56,132,0,344,189,144,76,274,12,10,368,265,72,237,153,148,1,257,200,342,220,288,165,290,281,184,216,52,241,244,145,25,360,93,126,365,282,339,333,164,42,186,49,92,152,100,341,345,324,378,118,334,149,362,30,105,248,141,226,201,206,44,57,253,66,182,50,328,188,292,366,370,86,58,46,330,254,128,321,211,215,307,15,359,7,198,234,317,353,229,209,21,38,169]},boundingSphere:{center:[0,0,0],radius:161.78209344582697}},rotationCombinations:{"1,2":[0,0,180],"1,3":[-180,0,90],"1,4":[90,0,-90],"1,5":[-90,0,-90],"1,6":[-130,-90,-40],"1,7":[0,-180,90],"1,8":[-90,0,90],"1,9":[90,0,90],"1,10":[50,-90,-40],"1,11":[0,90,-180],"1,12":[0,90,0],"1,13":[180,0,0],"1,14":[0,180,0],"1,15":[0,0,90],"1,16":[90,180,0],"1,17":[90,0,0],"1,18":[-130,90,40],"1,19":[0,0,-90],"1,20":[90,0,-180],"1,21":[-90,0,0],"1,22":[50,90,40],"1,23":[0,-90,0],"1,24":[0,-90,-180],"2,3":[0,180,90],"2,4":[-90,0,90],"2,5":[90,0,90],"2,6":[-50,90,-40],"2,7":[180,0,90],"2,8":[90,0,-90],"2,9":[-90,0,-90],"2,10":[130,90,-40],"2,11":[0,-90,0],"2,12":[0,-90,180],"2,13":[0,-180,0],"2,14":[-180,0,0],"2,15":[0,0,-90],"2,16":[90,0,0],"2,17":[-90,0,-180],"2,18":[-50,-90,40],"2,19":[0,0,90],"2,20":[-90,0,0],"2,21":[-90,-180,0],"2,22":[130,-90,40],"2,23":[0,90,-180],"2,24":[0,90,0],"3,4":[0,90,-180],"3,5":[0,-90,180],"3,6":[-90,0,-180],"3,7":[0,0,180],"3,8":[0,-90,0],"3,9":[0,90,0],"3,10":[-90,0,0],"3,11":[90,0,-90],"3,12":[90,0,90],"3,13":[0,0,-90],"3,14":[0,0,90],"3,15":[0,180,0],"3,16":[45,-90,135],"3,17":[-135,90,45],"3,18":[90,0,0],"3,19":[-180,0,0],"3,20":[45,90,45],"3,21":[45,-90,-45],"3,22":[-90,180,0],"3,23":[-90,0,90],"3,24":[-90,0,-90],"4,5":[0,180,0],"4,6":[90,0,-90],"4,7":[0,90,0],"4,8":[180,0,0],"4,9":[0,0,-180],"4,10":[90,0,90],"4,11":[-90,0,180],"4,12":[-90,0,0],"4,13":[-40,90,130],"4,14":[-40,90,-50],"4,15":[0,-90,-180],"4,16":[-180,0,90],"4,17":[0,0,90],"4,18":[-90,0,-90],"4,19":[0,-90,0],"4,20":[0,0,-90],"4,21":[0,180,90],"4,22":[-90,0,90],"4,23":[-90,180,0],"4,24":[90,0,0],"5,6":[90,0,90],"5,7":[0,-90,0],"5,8":[0,0,180],"5,9":[180,0,0],"5,10":[90,0,-90],"5,11":[-90,0,0],"5,12":[90,180,0],"5,13":[40,-90,130],"5,14":[40,-90,-50],"5,15":[0,90,180],"5,16":[0,0,-90],"5,17":[180,0,-90],"5,18":[-90,0,90],"5,19":[0,90,0],"5,20":[0,180,-90],"5,21":[0,0,90],"5,22":[-90,0,-90],"5,23":[90,0,0],"5,24":[90,0,-180],"6,7":[-90,0,0],"6,8":[45,90,45],"6,9":[45,-90,-45],"6,10":[0,0,-180],"6,11":[0,180,-90],"6,12":[-180,0,-90],"6,13":[-90,0,90],"6,14":[-90,0,-90],"6,15":[90,0,0],"6,16":[0,90,-180],"6,17":[0,-90,-180],"6,18":[0,-180,0],"6,19":[-90,-180,0],"6,20":[0,-90,0],"6,21":[0,90,0],"6,22":[-180,0,0],"6,23":[0,0,-90],"6,24":[0,0,90],"7,8":[0,90,180],"7,9":[0,-90,-180],"7,10":[90,0,-180],"7,11":[-90,0,90],"7,12":[-90,0,-90],"7,13":[0,0,90],"7,14":[0,0,-90],"7,15":[180,0,0],"7,16":[-45,90,-45],"7,17":[-45,-90,45],"7,18":[90,-180,0],"7,19":[0,180,0],"7,20":[135,-90,45],"7,21":[135,90,-45],"7,22":[-90,0,0],"7,23":[90,0,-90],"7,24":[90,0,90],"8,9":[0,-180,0],"8,10":[-90,0,90],"8,11":[-90,-180,0],"8,12":[90,0,0],"8,13":[-40,90,-50],"8,14":[-40,90,130],"8,15":[0,-90,0],"8,16":[0,0,90],"8,17":[0,-180,-90],"8,18":[90,0,-90],"8,19":[0,-90,-180],"8,20":[-180,0,-90],"8,21":[0,0,-90],"8,22":[90,0,90],"8,23":[-90,0,-180],"8,24":[-90,0,0],"9,10":[-90,0,-90],"9,11":[90,0,0],"9,12":[90,0,180],"9,13":[40,-90,-50],"9,14":[40,-90,130],"9,15":[0,90,0],"9,16":[0,-180,90],"9,17":[0,0,-90],"9,18":[90,0,90],"9,19":[0,90,-180],"9,20":[0,0,90],"9,21":[180,0,90],"9,22":[90,0,-90],"9,23":[-90,0,0],"9,24":[90,-180,0],"10,11":[180,0,-90],"10,12":[0,-180,-90],"10,13":[90,0,-90],"10,14":[90,0,90],"10,15":[90,180,0],"10,16":[0,-90,0],"10,17":[0,90,0],"10,18":[180,0,0],"10,19":[-90,0,0],"10,20":[0,90,180],"10,21":[0,-90,-180],"10,22":[0,180,0],"10,23":[0,0,90],"10,24":[0,0,-90],"11,12":[0,0,180],"11,13":[0,-90,0],"11,14":[0,-90,180],"11,15":[-50,90,-40],"11,16":[90,0,-90],"11,17":[-90,0,-90],"11,18":[0,0,90],"11,19":[130,90,-40],"11,20":[-90,0,90],"11,21":[90,0,90],"11,22":[0,0,-90],"11,23":[-180,0,0],"11,24":[0,-180,0],"12,13":[0,90,-180],"12,14":[0,90,0],"12,15":[-130,-90,-40],"12,16":[-90,0,90],"12,17":[90,0,90],"12,18":[0,0,-90],"12,19":[50,-90,-40],"12,20":[90,0,-90],"12,21":[-90,0,-90],"12,22":[0,0,90],"12,23":[0,-180,0],"12,24":[-180,0,0],"13,14":[0,0,180],"13,15":[0,180,-90],"13,16":[90,0,180],"13,17":[-90,0,0],"13,18":[50,90,40],"13,19":[-180,0,-90],"13,20":[90,-180,0],"13,21":[90,0,0],"13,22":[-130,90,40],"13,23":[0,-90,180],"13,24":[0,-90,0],"14,15":[180,0,-90],"14,16":[-90,0,0],"14,17":[-90,180,0],"14,18":[130,-90,40],"14,19":[0,-180,-90],"14,20":[90,0,0],"14,21":[-90,0,180],"14,22":[-50,-90,40],"14,23":[0,90,0],"14,24":[0,90,-180],"15,16":[-45,90,135],"15,17":[-45,-90,-135],"15,18":[90,0,180],"15,19":[0,0,180],"15,20":[-45,-90,45],"15,21":[-45,90,-45],"15,22":[90,0,0],"15,23":[-90,0,-90],"15,24":[-90,0,90],"16,17":[0,180,0],"16,18":[0,-90,-180],"16,19":[-90,0,90],"16,20":[180,0,0],"16,21":[0,0,180],"16,22":[0,-90,0],"16,23":[40,90,50],"16,24":[40,90,-130],"17,18":[0,90,-180],"17,19":[-90,0,-90],"17,20":[0,0,180],"17,21":[180,0,0],"17,22":[0,90,0],"17,23":[-40,-90,50],"17,24":[-40,-90,-130],"18,19":[90,0,0],"18,20":[0,90,0],"18,21":[0,-90,0],"18,22":[0,0,180],"18,23":[180,0,90],"18,24":[0,180,90],"19,20":[-135,90,45],"19,21":[-135,-90,-45],"19,22":[-90,0,180],"19,23":[90,0,90],"19,24":[90,0,-90],"20,21":[0,180,0],"20,22":[0,-90,180],"20,23":[40,90,-130],"20,24":[40,90,50],"21,22":[0,90,180],"21,23":[-40,-90,-130],"21,24":[-40,-90,50],"22,23":[0,-180,90],"22,24":[-180,0,90],"23,24":[0,0,-180]}},d30:{metadata:{version:4.5,type:"BufferGeometry",generator:"BufferGeometry.toJSON"},uuid:"6D1EB50D-67F2-45C7-BF93-23245B31E912",type:"BufferGeometry",data:{attributes:{position:{itemSize:3,type:"Float32Array",array:[-55.942420959472656,58.09579086303711,-56.76457214355469,-55.942420959472656,58.09579086303711,-56.76457214355469,-55.942420959472656,58.09579086303711,-56.76457214355469,-55.942420959472656,58.09579086303711,-56.76457214355469,-55.942420959472656,58.09579086303711,-56.76457214355469,-55.942420959472656,58.09579086303711,-56.76457214355469,-55.54539108276367,91.2035140991211,-2.153374433517456,-55.54539108276367,91.2035140991211,-2.153374433517456,-55.54539108276367,91.2035140991211,-2.153374433517456,-55.54539108276367,91.2035140991211,-2.153374433517456,-55.54539108276367,91.2035140991211,-2.153374433517456,58.09599685668945,56.76477813720703,55.94200897216797,58.09599685668945,56.76477813720703,55.94200897216797,58.09599685668945,56.76477813720703,55.94200897216797,58.09599685668945,56.76477813720703,55.94200897216797,58.09599685668945,56.76477813720703,55.94200897216797,-2.1539175510406494,-55.545379638671875,-91.20350646972656,-2.1539175510406494,-55.545379638671875,-91.20350646972656,-2.1539175510406494,-55.545379638671875,-91.20350646972656,-2.1539175510406494,-55.545379638671875,-91.20350646972656,-2.1539175510406494,-55.545379638671875,-91.20350646972656,-2.1539175510406494,-55.545379638671875,-91.20350646972656,35.903011322021484,1.3310145139694214,-91.8457260131836,35.903011322021484,1.3310145139694214,-91.8457260131836,35.903011322021484,1.3310145139694214,-91.8457260131836,35.903011322021484,1.3310145139694214,-91.8457260131836,35.903011322021484,1.3310145139694214,-91.8457260131836,35.903011322021484,1.3310145139694214,-91.8457260131836,33.74937438964844,-5.019184072807548e-7,-92.66828918457031,33.74937438964844,-5.019184072807548e-7,-92.66828918457031,33.74937438964844,-5.019184072807548e-7,-92.66828918457031,33.74937438964844,-5.019184072807548e-7,-92.66828918457031,35.903690338134766,1.331014633178711,91.84544372558594,35.903690338134766,1.331014633178711,91.84544372558594,35.903690338134766,1.331014633178711,91.84544372558594,35.903690338134766,1.331014633178711,91.84544372558594,35.903690338134766,1.331014633178711,91.84544372558594,56.76499557495117,55.94220733642578,58.0955924987793,56.76499557495117,55.94220733642578,58.0955924987793,56.76499557495117,55.94220733642578,58.0955924987793,56.76499557495117,55.94220733642578,58.0955924987793,56.76499557495117,55.94220733642578,58.0955924987793,-1.3306841850280762,-57.6989631652832,89.87248229980469,-1.3306841850280762,-57.6989631652832,89.87248229980469,-1.3306841850280762,-57.6989631652832,89.87248229980469,-1.3306841850280762,-57.6989631652832,89.87248229980469,-1.3306841850280762,-57.6989631652832,89.87248229980469,-1.3306841850280762,-57.6989631652832,89.87248229980469,92.66816711425781,33.749717712402344,-.00033652668935246766,92.66816711425781,33.749717712402344,-.00033652668935246766,92.66816711425781,33.749717712402344,-.00033652668935246766,92.66816711425781,33.749717712402344,-.00033652668935246766,.0001248687185579911,92.66816711425781,33.74972152709961,.0001248687185579911,92.66816711425781,33.74972152709961,.0001248687185579911,92.66816711425781,33.74972152709961,.0001248687185579911,92.66816711425781,33.74972152709961,-91.8455810546875,-35.903350830078125,1.3313559293746948,-91.8455810546875,-35.903350830078125,1.3313559293746948,-91.8455810546875,-35.903350830078125,1.3313559293746948,-91.8455810546875,-35.903350830078125,1.3313559293746948,-91.8455810546875,-35.903350830078125,1.3313559293746948,-91.8455810546875,-35.903350830078125,1.3313559293746948,-56.76499557495117,55.94220733642578,-58.095577239990234,-56.76499557495117,55.94220733642578,-58.095577239990234,-56.76499557495117,55.94220733642578,-58.095577239990234,-56.76499557495117,55.94220733642578,-58.095577239990234,-92.66815185546875,-33.749717712402344,.000344159547239542,-92.66815185546875,-33.749717712402344,.000344159547239542,-92.66815185546875,-33.749717712402344,.000344159547239542,-92.66815185546875,-33.749717712402344,.000344159547239542,-91.84559631347656,-35.903350830078125,-1.3306736946105957,-91.84559631347656,-35.903350830078125,-1.3306736946105957,-91.84559631347656,-35.903350830078125,-1.3306736946105957,-91.84559631347656,-35.903350830078125,-1.3306736946105957,-91.84559631347656,-35.903350830078125,-1.3306736946105957,-91.2037124633789,-2.1535837650299072,-55.54503631591797,-91.2037124633789,-2.1535837650299072,-55.54503631591797,-91.2037124633789,-2.1535837650299072,-55.54503631591797,-91.2037124633789,-2.1535837650299072,-55.54503631591797,-91.2037124633789,-2.1535837650299072,-55.54503631591797,1.3308831453323364,91.84559631347656,-35.90335464477539,1.3308831453323364,91.84559631347656,-35.90335464477539,1.3308831453323364,91.84559631347656,-35.90335464477539,1.3308831453323364,91.84559631347656,-35.90335464477539,1.3308831453323364,91.84559631347656,-35.90335464477539,55.545372009277344,91.2035140991211,-2.1537835597991943,55.545372009277344,91.2035140991211,-2.1537835597991943,55.545372009277344,91.2035140991211,-2.1537835597991943,55.545372009277344,91.2035140991211,-2.1537835597991943,55.545372009277344,91.2035140991211,-2.1537835597991943,55.545372009277344,91.2035140991211,-2.1537835597991943,-91.84558868408203,35.903350830078125,1.331355094909668,-91.84558868408203,35.903350830078125,1.331355094909668,-91.84558868408203,35.903350830078125,1.331355094909668,-91.84558868408203,35.903350830078125,1.331355094909668,-91.84558868408203,35.903350830078125,1.331355094909668,-91.84558868408203,35.903350830078125,1.331355094909668,-58.09558868408203,56.76477813720703,55.94243240356445,-58.09558868408203,56.76477813720703,55.94243240356445,-58.09558868408203,56.76477813720703,55.94243240356445,-58.09558868408203,56.76477813720703,55.94243240356445,-58.09558868408203,56.76477813720703,55.94243240356445,-57.698951721191406,89.87249755859375,1.3312309980392456,-57.698951721191406,89.87249755859375,1.3312309980392456,-57.698951721191406,89.87249755859375,1.3312309980392456,-57.698951721191406,89.87249755859375,1.3312309980392456,-55.54539108276367,-91.20350646972656,-2.1533758640289307,-55.54539108276367,-91.20350646972656,-2.1533758640289307,-55.54539108276367,-91.20350646972656,-2.1533758640289307,-55.54539108276367,-91.20350646972656,-2.1533758640289307,-55.54539108276367,-91.20350646972656,-2.1533758640289307,-55.545372009277344,91.2035140991211,2.1537914276123047,-55.545372009277344,91.2035140991211,2.1537914276123047,-55.545372009277344,91.2035140991211,2.1537914276123047,-55.545372009277344,91.2035140991211,2.1537914276123047,-55.545372009277344,91.2035140991211,2.1537914276123047,-55.545372009277344,91.2035140991211,2.1537914276123047,-55.545372009277344,91.2035140991211,2.1537914276123047,-55.9420051574707,58.09578323364258,56.764991760253906,-55.9420051574707,58.09578323364258,56.764991760253906,-55.9420051574707,58.09578323364258,56.764991760253906,-55.9420051574707,58.09578323364258,56.764991760253906,1.3308836221694946,-91.84559631347656,-35.90335464477539,1.3308836221694946,-91.84559631347656,-35.90335464477539,1.3308836221694946,-91.84559631347656,-35.90335464477539,1.3308836221694946,-91.84559631347656,-35.90335464477539,1.3308836221694946,-91.84559631347656,-35.90335464477539,-91.20330047607422,-2.153582811355591,55.54571533203125,-91.20330047607422,-2.153582811355591,55.54571533203125,-91.20330047607422,-2.153582811355591,55.54571533203125,-91.20330047607422,-2.153582811355591,55.54571533203125,-91.20330047607422,-2.153582811355591,55.54571533203125,-91.20330047607422,2.1535825729370117,55.54571533203125,-91.20330047607422,2.1535825729370117,55.54571533203125,-91.20330047607422,2.1535825729370117,55.54571533203125,-91.20330047607422,2.1535825729370117,55.54571533203125,-91.20330047607422,2.1535825729370117,55.54571533203125,-91.20330047607422,2.1535825729370117,55.54571533203125,-91.8456039428711,35.903350830078125,-1.3306739330291748,-91.8456039428711,35.903350830078125,-1.3306739330291748,-91.8456039428711,35.903350830078125,-1.3306739330291748,-91.8456039428711,35.903350830078125,-1.3306739330291748,-91.8456039428711,35.903350830078125,-1.3306739330291748,33.750057220458984,-3.255321701089997e-7,92.66802978515625,33.750057220458984,-3.255321701089997e-7,92.66802978515625,33.750057220458984,-3.255321701089997e-7,92.66802978515625,33.750057220458984,-3.255321701089997e-7,92.66802978515625,89.87269592285156,-1.3310151100158691,57.698638916015625,89.87269592285156,-1.3310151100158691,57.698638916015625,89.87269592285156,-1.3310151100158691,57.698638916015625,89.87269592285156,-1.3310151100158691,57.698638916015625,89.87269592285156,-1.3310151100158691,57.698638916015625,91.2037124633789,2.153581380844116,55.545047760009766,91.2037124633789,2.153581380844116,55.545047760009766,91.2037124633789,2.153581380844116,55.545047760009766,91.2037124633789,2.153581380844116,55.545047760009766,91.2037124633789,2.153581380844116,55.545047760009766,91.2037124633789,2.153581380844116,55.545047760009766,-35.903011322021484,1.3310145139694214,91.84571075439453,-35.903011322021484,1.3310145139694214,91.84571075439453,-35.903011322021484,1.3310145139694214,91.84571075439453,-35.903011322021484,1.3310145139694214,91.84571075439453,-35.903011322021484,1.3310145139694214,91.84571075439453,-35.903011322021484,-1.33101487159729,91.84571075439453,-35.903011322021484,-1.33101487159729,91.84571075439453,-35.903011322021484,-1.33101487159729,91.84571075439453,-35.903011322021484,-1.33101487159729,91.84571075439453,-35.903011322021484,-1.33101487159729,91.84571075439453,-33.74938201904297,-5.100424687043414e-7,92.66827392578125,-33.74938201904297,-5.100424687043414e-7,92.66827392578125,-33.74938201904297,-5.100424687043414e-7,92.66827392578125,-33.74938201904297,-5.100424687043414e-7,92.66827392578125,1.0764577388763428,55.84297561645508,-91.01956939697266,1.0764577388763428,55.84297561645508,-91.01956939697266,1.0764577388763428,55.84297561645508,-91.01956939697266,1.0764577388763428,55.84297561645508,-91.01956939697266,1.0764577388763428,55.84297561645508,-91.01956939697266,1.0764577388763428,55.84297561645508,-91.01956939697266,1.0764577388763428,55.84297561645508,-91.01956939697266,-.00033518741838634014,55.17742919921875,-91.43085479736328,-.00033518741838634014,55.17742919921875,-91.43085479736328,-.00033518741838634014,55.17742919921875,-91.43085479736328,-.00033518741838634014,55.17742919921875,-91.43085479736328,-.00033518741838634014,55.17742919921875,-91.43085479736328,-.00033518741838634014,55.17742919921875,-91.43085479736328,54.21428298950195,-92.02606964111328,-.00019521401554811746,54.21428298950195,-92.02606964111328,-.00019521401554811746,54.21428298950195,-92.02606964111328,-.00019521401554811746,54.21428298950195,-92.02606964111328,-.00019521401554811746,54.21428298950195,-92.02606964111328,-.00019521401554811746,54.21428298950195,-92.02606964111328,-.00019521401554811746,55.545372009277344,-91.20350646972656,-2.153782844543457,55.545372009277344,-91.20350646972656,-2.153782844543457,55.545372009277344,-91.20350646972656,-2.153782844543457,55.545372009277344,-91.20350646972656,-2.153782844543457,55.545372009277344,-91.20350646972656,-2.153782844543457,91.8455810546875,-35.903350830078125,-1.331348180770874,91.8455810546875,-35.903350830078125,-1.331348180770874,91.8455810546875,-35.903350830078125,-1.331348180770874,91.8455810546875,-35.903350830078125,-1.331348180770874,91.8455810546875,-35.903350830078125,-1.331348180770874,91.8455810546875,-35.903350830078125,-1.331348180770874,-54.21428298950195,92.02607727050781,.00020320962357800454,-54.21428298950195,92.02607727050781,.00020320962357800454,-54.21428298950195,92.02607727050781,.00020320962357800454,-54.21428298950195,92.02607727050781,.00020320962357800454,-54.21428298950195,92.02607727050781,.00020320962357800454,-54.21428298950195,92.02607727050781,.00020320962357800454,55.9420051574707,58.09579086303711,-56.76498031616211,55.9420051574707,58.09579086303711,-56.76498031616211,55.9420051574707,58.09579086303711,-56.76498031616211,55.9420051574707,58.09579086303711,-56.76498031616211,55.9420051574707,58.09579086303711,-56.76498031616211,57.69895935058594,89.87249755859375,1.3308056592941284,57.69895935058594,89.87249755859375,1.3308056592941284,57.69895935058594,89.87249755859375,1.3308056592941284,57.69895935058594,89.87249755859375,1.3308056592941284,57.69895935058594,89.87249755859375,1.3308056592941284,57.69895935058594,89.87249755859375,1.3308056592941284,57.69895935058594,89.87249755859375,1.3308056592941284,-1.330683946609497,57.698951721191406,89.87248229980469,-1.330683946609497,57.698951721191406,89.87248229980469,-1.330683946609497,57.698951721191406,89.87248229980469,-1.330683946609497,57.698951721191406,89.87248229980469,-1.330683946609497,57.698951721191406,89.87248229980469,1.3313459157943726,57.698951721191406,89.87246704101562,1.3313459157943726,57.698951721191406,89.87246704101562,1.3313459157943726,57.698951721191406,89.87246704101562,1.3313459157943726,57.698951721191406,89.87246704101562,1.3313459157943726,57.698951721191406,89.87246704101562,1.3313459157943726,57.698951721191406,89.87246704101562,-33.75006103515625,-3.2792155479910434e-7,-92.66804504394531,-33.75006103515625,-3.2792155479910434e-7,-92.66804504394531,-33.75006103515625,-3.2792155479910434e-7,-92.66804504394531,-33.75006103515625,-3.2792155479910434e-7,-92.66804504394531,1.3306846618652344,-57.69895935058594,-89.87250518798828,1.3306846618652344,-57.69895935058594,-89.87250518798828,1.3306846618652344,-57.69895935058594,-89.87250518798828,1.3306846618652344,-57.69895935058594,-89.87250518798828,1.3306846618652344,-57.69895935058594,-89.87250518798828,35.903011322021484,-1.33101487159729,-91.8457260131836,35.903011322021484,-1.33101487159729,-91.8457260131836,35.903011322021484,-1.33101487159729,-91.8457260131836,35.903011322021484,-1.33101487159729,-91.8457260131836,35.903011322021484,-1.33101487159729,-91.8457260131836,1.331345796585083,-57.6989631652832,89.87246704101562,1.331345796585083,-57.6989631652832,89.87246704101562,1.331345796585083,-57.6989631652832,89.87246704101562,1.331345796585083,-57.6989631652832,89.87246704101562,1.331345796585083,-57.6989631652832,89.87246704101562,1.331345796585083,-57.6989631652832,89.87246704101562,-58.09558868408203,-56.76478576660156,55.94243240356445,-58.09558868408203,-56.76478576660156,55.94243240356445,-58.09558868408203,-56.76478576660156,55.94243240356445,-58.09558868408203,-56.76478576660156,55.94243240356445,-55.9420051574707,-58.09579849243164,56.764991760253906,-55.9420051574707,-58.09579849243164,56.764991760253906,-55.9420051574707,-58.09579849243164,56.764991760253906,-55.9420051574707,-58.09579849243164,56.764991760253906,-55.9420051574707,-58.09579849243164,56.764991760253906,-89.87269592285156,1.3310145139694214,-57.69862365722656,-89.87269592285156,1.3310145139694214,-57.69862365722656,-89.87269592285156,1.3310145139694214,-57.69862365722656,-89.87269592285156,1.3310145139694214,-57.69862365722656,-89.87269592285156,1.3310145139694214,-57.69862365722656,-89.87269592285156,1.3310145139694214,-57.69862365722656,55.942420959472656,58.09578323364258,56.764583587646484,55.942420959472656,58.09578323364258,56.764583587646484,55.942420959472656,58.09578323364258,56.764583587646484,55.942420959472656,58.09578323364258,56.764583587646484,55.942420959472656,58.09578323364258,56.764583587646484,-.00012307056749705225,-92.66816711425781,-33.749717712402344,-.00012307056749705225,-92.66816711425781,-33.749717712402344,-.00012307056749705225,-92.66816711425781,-33.749717712402344,-.00012307056749705225,-92.66816711425781,-33.749717712402344,-1.3311455249786377,-91.84559631347656,-35.90334701538086,-1.3311455249786377,-91.84559631347656,-35.90334701538086,-1.3311455249786377,-91.84559631347656,-35.90334701538086,-1.3311455249786377,-91.84559631347656,-35.90334701538086,-1.3311455249786377,-91.84559631347656,-35.90334701538086,-1.3311455249786377,-91.84559631347656,-35.90334701538086,58.09599685668945,-56.76478576660156,55.94200897216797,58.09599685668945,-56.76478576660156,55.94200897216797,58.09599685668945,-56.76478576660156,55.94200897216797,58.09599685668945,-56.76478576660156,55.94200897216797,55.54539108276367,91.2035140991211,2.15338134765625,55.54539108276367,91.2035140991211,2.15338134765625,55.54539108276367,91.2035140991211,2.15338134765625,55.54539108276367,91.2035140991211,2.15338134765625,55.54539108276367,91.2035140991211,2.15338134765625,2.153247594833374,-55.545379638671875,-91.20352172851562,2.153247594833374,-55.545379638671875,-91.20352172851562,2.153247594833374,-55.545379638671875,-91.20352172851562,2.153247594833374,-55.545379638671875,-91.20352172851562,2.153247594833374,-55.545379638671875,-91.20352172851562,2.153247594833374,-55.545379638671875,-91.20352172851562,2.153247594833374,-55.545379638671875,-91.20352172851562,-.0003373770450707525,-54.21428298950195,-92.02607727050781,-.0003373770450707525,-54.21428298950195,-92.02607727050781,-.0003373770450707525,-54.21428298950195,-92.02607727050781,-.0003373770450707525,-54.21428298950195,-92.02607727050781,-.0003373770450707525,-54.21428298950195,-92.02607727050781,-.0003373770450707525,-54.21428298950195,-92.02607727050781,1.3311474323272705,91.84559631347656,35.90334701538086,1.3311474323272705,91.84559631347656,35.90334701538086,1.3311474323272705,91.84559631347656,35.90334701538086,1.3311474323272705,91.84559631347656,35.90334701538086,1.3311474323272705,91.84559631347656,35.90334701538086,54.21428298950195,92.02607727050781,-.00019560271175578237,54.21428298950195,92.02607727050781,-.00019560271175578237,54.21428298950195,92.02607727050781,-.00019560271175578237,54.21428298950195,92.02607727050781,-.00019560271175578237,54.21428298950195,92.02607727050781,-.00019560271175578237,54.21428298950195,92.02607727050781,-.00019560271175578237,-56.76456832885742,55.94220733642578,58.096012115478516,-56.76456832885742,55.94220733642578,58.096012115478516,-56.76456832885742,55.94220733642578,58.096012115478516,-56.76456832885742,55.94220733642578,58.096012115478516,-56.76456832885742,55.94220733642578,58.096012115478516,-56.76456832885742,55.94220733642578,58.096012115478516,-1.3308817148208618,91.84559631347656,35.90335464477539,-1.3308817148208618,91.84559631347656,35.90335464477539,-1.3308817148208618,91.84559631347656,35.90335464477539,-1.3308817148208618,91.84559631347656,35.90335464477539,-1.3308817148208618,91.84559631347656,35.90335464477539,-1.3308817148208618,91.84559631347656,35.90335464477539,-92.66816711425781,33.749717712402344,.0003441836452111602,-92.66816711425781,33.749717712402344,.0003441836452111602,-92.66816711425781,33.749717712402344,.0003441836452111602,-92.66816711425781,33.749717712402344,.0003441836452111602,-92.02587127685547,-3.414504305965238e-7,54.21462631225586,-92.02587127685547,-3.414504305965238e-7,54.21462631225586,-92.02587127685547,-3.414504305965238e-7,54.21462631225586,-92.02587127685547,-3.414504305965238e-7,54.21462631225586,-92.02587127685547,-3.414504305965238e-7,54.21462631225586,-92.02587127685547,-3.414504305965238e-7,54.21462631225586,-92.02587127685547,-3.414504305965238e-7,54.21462631225586,-89.87227630615234,-1.3310153484344482,57.69929885864258,-89.87227630615234,-1.3310153484344482,57.69929885864258,-89.87227630615234,-1.3310153484344482,57.69929885864258,-89.87227630615234,-1.3310153484344482,57.69929885864258,-89.87227630615234,-1.3310153484344482,57.69929885864258,-89.87227630615234,-1.3310153484344482,57.69929885864258,-56.76499557495117,-55.94221496582031,-58.095577239990234,-56.76499557495117,-55.94221496582031,-58.095577239990234,-56.76499557495117,-55.94221496582031,-58.095577239990234,-56.76499557495117,-55.94221496582031,-58.095577239990234,-89.87269592285156,-1.3310151100158691,-57.69862365722656,-89.87269592285156,-1.3310151100158691,-57.69862365722656,-89.87269592285156,-1.3310151100158691,-57.69862365722656,-89.87269592285156,-1.3310151100158691,-57.69862365722656,-89.87269592285156,-1.3310151100158691,-57.69862365722656,-91.2037124633789,2.1535816192626953,-55.54503631591797,-91.2037124633789,2.1535816192626953,-55.54503631591797,-91.2037124633789,2.1535816192626953,-55.54503631591797,-91.2037124633789,2.1535816192626953,-55.54503631591797,-91.2037124633789,2.1535816192626953,-55.54503631591797,-91.2037124633789,2.1535816192626953,-55.54503631591797,-57.6989631652832,-89.87248229980469,-1.3307993412017822,-57.6989631652832,-89.87248229980469,-1.3307993412017822,-57.6989631652832,-89.87248229980469,-1.3307993412017822,-57.6989631652832,-89.87248229980469,-1.3307993412017822,-57.6989631652832,-89.87248229980469,-1.3307993412017822,-57.6989631652832,-89.87248229980469,-1.3307993412017822,-57.69895553588867,-89.87248229980469,1.331230640411377,-57.69895553588867,-89.87248229980469,1.331230640411377,-57.69895553588867,-89.87248229980469,1.331230640411377,-57.69895553588867,-89.87248229980469,1.331230640411377,-57.69895553588867,-89.87248229980469,1.331230640411377,-57.69895553588867,-89.87248229980469,1.331230640411377,-57.69895553588867,-89.87248229980469,1.331230640411377,91.2037124633789,-2.1535840034484863,55.545047760009766,91.2037124633789,-2.1535840034484863,55.545047760009766,91.2037124633789,-2.1535840034484863,55.545047760009766,91.2037124633789,-2.1535840034484863,55.545047760009766,91.2037124633789,-2.1535840034484863,55.545047760009766,91.84559631347656,-35.903350830078125,1.3306814432144165,91.84559631347656,-35.903350830078125,1.3306814432144165,91.84559631347656,-35.903350830078125,1.3306814432144165,91.84559631347656,-35.903350830078125,1.3306814432144165,91.84559631347656,-35.903350830078125,1.3306814432144165,.00033884088043123484,-54.21428298950195,92.02606964111328,.00033884088043123484,-54.21428298950195,92.02606964111328,.00033884088043123484,-54.21428298950195,92.02606964111328,.00033884088043123484,-54.21428298950195,92.02606964111328,.00033884088043123484,-54.21428298950195,92.02606964111328,.00033884088043123484,-54.21428298950195,92.02606964111328,1.3311470746994019,-91.84559631347656,35.90334701538086,1.3311470746994019,-91.84559631347656,35.90334701538086,1.3311470746994019,-91.84559631347656,35.90334701538086,1.3311470746994019,-91.84559631347656,35.90334701538086,1.3311470746994019,-91.84559631347656,35.90334701538086,91.8456039428711,35.903350830078125,1.330681324005127,91.8456039428711,35.903350830078125,1.330681324005127,91.8456039428711,35.903350830078125,1.330681324005127,91.8456039428711,35.903350830078125,1.330681324005127,91.8456039428711,35.903350830078125,1.330681324005127,57.698951721191406,89.87249755859375,-1.3312232494354248,57.698951721191406,89.87249755859375,-1.3312232494354248,57.698951721191406,89.87249755859375,-1.3312232494354248,57.698951721191406,89.87249755859375,-1.3312232494354248,35.903690338134766,-1.331014633178711,91.84544372558594,35.903690338134766,-1.331014633178711,91.84544372558594,35.903690338134766,-1.331014633178711,91.84544372558594,35.903690338134766,-1.331014633178711,91.84544372558594,35.903690338134766,-1.331014633178711,91.84544372558594,35.903690338134766,-1.331014633178711,91.84544372558594,-56.76456832885742,-55.94221496582031,58.096012115478516,-56.76456832885742,-55.94221496582031,58.096012115478516,-56.76456832885742,-55.94221496582031,58.096012115478516,-56.76456832885742,-55.94221496582031,58.096012115478516,-56.76456832885742,-55.94221496582031,58.096012115478516,-56.76456832885742,-55.94221496582031,58.096012115478516,-2.1532464027404785,-55.545379638671875,91.20350646972656,-2.1532464027404785,-55.545379638671875,91.20350646972656,-2.1532464027404785,-55.545379638671875,91.20350646972656,-2.1532464027404785,-55.545379638671875,91.20350646972656,-2.1532464027404785,-55.545379638671875,91.20350646972656,.00012470953515730798,-92.66816711425781,33.74972152709961,.00012470953515730798,-92.66816711425781,33.74972152709961,.00012470953515730798,-92.66816711425781,33.74972152709961,.00012470953515730798,-92.66816711425781,33.74972152709961,-1.33088219165802,-91.84559631347656,35.90335464477539,-1.33088219165802,-91.84559631347656,35.90335464477539,-1.33088219165802,-91.84559631347656,35.90335464477539,-1.33088219165802,-91.84559631347656,35.90335464477539,-1.33088219165802,-91.84559631347656,35.90335464477539,-1.33088219165802,-91.84559631347656,35.90335464477539,-55.545372009277344,-91.20350646972656,2.153789758682251,-55.545372009277344,-91.20350646972656,2.153789758682251,-55.545372009277344,-91.20350646972656,2.153789758682251,-55.545372009277344,-91.20350646972656,2.153789758682251,56.76456832885742,-55.94221878051758,-58.09599304199219,56.76456832885742,-55.94221878051758,-58.09599304199219,56.76456832885742,-55.94221878051758,-58.09599304199219,56.76456832885742,-55.94221878051758,-58.09599304199219,92.66815185546875,-33.749717712402344,-.0003363910655025393,92.66815185546875,-33.749717712402344,-.0003363910655025393,92.66815185546875,-33.749717712402344,-.0003363910655025393,92.66815185546875,-33.749717712402344,-.0003363910655025393,91.20330047607422,-2.1535825729370117,-55.54570388793945,91.20330047607422,-2.1535825729370117,-55.54570388793945,91.20330047607422,-2.1535825729370117,-55.54570388793945,91.20330047607422,-2.1535825729370117,-55.54570388793945,91.20330047607422,-2.1535825729370117,-55.54570388793945,92.02587127685547,-3.892050415288395e-7,-54.2146110534668,92.02587127685547,-3.892050415288395e-7,-54.2146110534668,92.02587127685547,-3.892050415288395e-7,-54.2146110534668,92.02587127685547,-3.892050415288395e-7,-54.2146110534668,92.02587127685547,-3.892050415288395e-7,-54.2146110534668,92.02587127685547,-3.892050415288395e-7,-54.2146110534668,92.02587127685547,-3.892050415288395e-7,-54.2146110534668,.0003386797325219959,54.21427536010742,92.02606964111328,.0003386797325219959,54.21427536010742,92.02606964111328,.0003386797325219959,54.21427536010742,92.02606964111328,.0003386797325219959,54.21427536010742,92.02606964111328,.0003386797325219959,54.21427536010742,92.02606964111328,.0003386797325219959,54.21427536010742,92.02606964111328,2.1539180278778076,55.54536819458008,91.2034912109375,2.1539180278778076,55.54536819458008,91.2034912109375,2.1539180278778076,55.54536819458008,91.2034912109375,2.1539180278778076,55.54536819458008,91.2034912109375,91.20330047607422,2.153582811355591,-55.54570388793945,91.20330047607422,2.153582811355591,-55.54570388793945,91.20330047607422,2.153582811355591,-55.54570388793945,91.20330047607422,2.153582811355591,-55.54570388793945,91.20330047607422,2.153582811355591,-55.54570388793945,89.87227630615234,1.3310145139694214,-57.69927978515625,89.87227630615234,1.3310145139694214,-57.69927978515625,89.87227630615234,1.3310145139694214,-57.69927978515625,89.87227630615234,1.3310145139694214,-57.69927978515625,89.87227630615234,1.3310145139694214,-57.69927978515625,89.87227630615234,1.3310145139694214,-57.69927978515625,56.76456832885742,55.94220733642578,-58.09599304199219,56.76456832885742,55.94220733642578,-58.09599304199219,56.76456832885742,55.94220733642578,-58.09599304199219,56.76456832885742,55.94220733642578,-58.09599304199219,56.76456832885742,55.94220733642578,-58.09599304199219,58.09558868408203,56.76477813720703,-55.942420959472656,58.09558868408203,56.76477813720703,-55.942420959472656,58.09558868408203,56.76477813720703,-55.942420959472656,58.09558868408203,56.76477813720703,-55.942420959472656,55.54539108276367,-91.20350646972656,2.153383255004883,55.54539108276367,-91.20350646972656,2.153383255004883,55.54539108276367,-91.20350646972656,2.153383255004883,55.54539108276367,-91.20350646972656,2.153383255004883,55.54539108276367,-91.20350646972656,2.153383255004883,55.54539108276367,-91.20350646972656,2.153383255004883,91.84558868408203,35.903350830078125,-1.3313480615615845,91.84558868408203,35.903350830078125,-1.3313480615615845,91.84558868408203,35.903350830078125,-1.3313480615615845,91.84558868408203,35.903350830078125,-1.3313480615615845,91.84558868408203,35.903350830078125,-1.3313480615615845,91.84558868408203,35.903350830078125,-1.3313480615615845,-35.903690338134766,-1.331014633178711,-91.84546661376953,-35.903690338134766,-1.331014633178711,-91.84546661376953,-35.903690338134766,-1.331014633178711,-91.84546661376953,-35.903690338134766,-1.331014633178711,-91.84546661376953,-35.903690338134766,-1.331014633178711,-91.84546661376953,-35.903690338134766,-1.331014633178711,-91.84546661376953,-54.21428298950195,-92.02606964111328,.00020284479251131415,-54.21428298950195,-92.02606964111328,.00020284479251131415,-54.21428298950195,-92.02606964111328,.00020284479251131415,-54.21428298950195,-92.02606964111328,.00020284479251131415,-54.21428298950195,-92.02606964111328,.00020284479251131415,-54.21428298950195,-92.02606964111328,.00020284479251131415,-54.21428298950195,-92.02606964111328,.00020284479251131415,-35.903690338134766,1.331014633178711,-91.84546661376953,-35.903690338134766,1.331014633178711,-91.84546661376953,-35.903690338134766,1.331014633178711,-91.84546661376953,-35.903690338134766,1.331014633178711,-91.84546661376953,-35.903690338134766,1.331014633178711,-91.84546661376953,89.87227630615234,-1.3310154676437378,-57.69927978515625,89.87227630615234,-1.3310154676437378,-57.69927978515625,89.87227630615234,-1.3310154676437378,-57.69927978515625,89.87227630615234,-1.3310154676437378,-57.69927978515625,89.87227630615234,-1.3310154676437378,-57.69927978515625,89.87227630615234,-1.3310154676437378,-57.69927978515625,55.942420959472656,-58.09579849243164,56.764583587646484,55.942420959472656,-58.09579849243164,56.764583587646484,55.942420959472656,-58.09579849243164,56.764583587646484,55.942420959472656,-58.09579849243164,56.764583587646484,55.942420959472656,-58.09579849243164,56.764583587646484,56.76499557495117,-55.94221496582031,58.0955924987793,56.76499557495117,-55.94221496582031,58.0955924987793,56.76499557495117,-55.94221496582031,58.0955924987793,56.76499557495117,-55.94221496582031,58.0955924987793,56.76499557495117,-55.94221496582031,58.0955924987793,2.1539194583892822,-55.545379638671875,91.2034912109375,2.1539194583892822,-55.545379638671875,91.2034912109375,2.1539194583892822,-55.545379638671875,91.2034912109375,2.1539194583892822,-55.545379638671875,91.2034912109375,2.1539194583892822,-55.545379638671875,91.2034912109375,2.1539194583892822,-55.545379638671875,91.2034912109375,-55.942420959472656,-58.09579849243164,-56.76457214355469,-55.942420959472656,-58.09579849243164,-56.76457214355469,-55.942420959472656,-58.09579849243164,-56.76457214355469,-55.942420959472656,-58.09579849243164,-56.76457214355469,-55.942420959472656,-58.09579849243164,-56.76457214355469,-55.942420959472656,-58.09579849243164,-56.76457214355469,-58.09599685668945,-56.76478576660156,-55.941993713378906,-58.09599685668945,-56.76478576660156,-55.941993713378906,-58.09599685668945,-56.76478576660156,-55.941993713378906,-58.09599685668945,-56.76478576660156,-55.941993713378906,92.0262680053711,-4.4363298457028577e-7,54.21394729614258,92.0262680053711,-4.4363298457028577e-7,54.21394729614258,92.0262680053711,-4.4363298457028577e-7,54.21394729614258,92.0262680053711,-4.4363298457028577e-7,54.21394729614258,92.0262680053711,-4.4363298457028577e-7,54.21394729614258,92.0262680053711,-4.4363298457028577e-7,54.21394729614258,55.9420051574707,-58.095802307128906,-56.76498031616211,55.9420051574707,-58.095802307128906,-56.76498031616211,55.9420051574707,-58.095802307128906,-56.76498031616211,55.9420051574707,-58.095802307128906,-56.76498031616211,55.9420051574707,-58.095802307128906,-56.76498031616211,55.9420051574707,-58.095802307128906,-56.76498031616211,58.09558868408203,-56.76478576660156,-55.942420959472656,58.09558868408203,-56.76478576660156,-55.942420959472656,58.09558868408203,-56.76478576660156,-55.942420959472656,58.09558868408203,-56.76478576660156,-55.942420959472656,58.09558868408203,-56.76478576660156,-55.942420959472656,89.87269592285156,1.3310145139694214,57.698638916015625,89.87269592285156,1.3310145139694214,57.698638916015625,89.87269592285156,1.3310145139694214,57.698638916015625,89.87269592285156,1.3310145139694214,57.698638916015625,89.87269592285156,1.3310145139694214,57.698638916015625,89.87269592285156,1.3310145139694214,57.698638916015625,57.6989631652832,-89.87248229980469,1.330806851387024,57.6989631652832,-89.87248229980469,1.330806851387024,57.6989631652832,-89.87248229980469,1.330806851387024,57.6989631652832,-89.87248229980469,1.330806851387024,57.6989631652832,-89.87248229980469,1.330806851387024,57.6989631652832,-89.87248229980469,1.330806851387024,57.69895553588867,-89.87248229980469,-1.3312231302261353,57.69895553588867,-89.87248229980469,-1.3312231302261353,57.69895553588867,-89.87248229980469,-1.3312231302261353,57.69895553588867,-89.87248229980469,-1.3312231302261353,57.69895553588867,-89.87248229980469,-1.3312231302261353,57.69895553588867,-89.87248229980469,-1.3312231302261353,-1.331344485282898,-57.69895935058594,-89.87249755859375,-1.331344485282898,-57.69895935058594,-89.87249755859375,-1.331344485282898,-57.69895935058594,-89.87249755859375,-1.331344485282898,-57.69895935058594,-89.87249755859375,-1.331344485282898,-57.69895935058594,-89.87249755859375,-92.0262680053711,-3.9587837363797007e-7,-54.21393585205078,-92.0262680053711,-3.9587837363797007e-7,-54.21393585205078,-92.0262680053711,-3.9587837363797007e-7,-54.21393585205078,-92.0262680053711,-3.9587837363797007e-7,-54.21393585205078,-92.0262680053711,-3.9587837363797007e-7,-54.21393585205078,-92.0262680053711,-3.9587837363797007e-7,-54.21393585205078,-58.09599685668945,56.76477813720703,-55.941993713378906,-58.09599685668945,56.76477813720703,-55.941993713378906,-58.09599685668945,56.76477813720703,-55.941993713378906,-58.09599685668945,56.76477813720703,-55.941993713378906,-58.09599685668945,56.76477813720703,-55.941993713378906,-57.69895935058594,89.87249755859375,-1.3307981491088867,-57.69895935058594,89.87249755859375,-1.3307981491088867,-57.69895935058594,89.87249755859375,-1.3307981491088867,-57.69895935058594,89.87249755859375,-1.3307981491088867,-57.69895935058594,89.87249755859375,-1.3307981491088867,-57.69895935058594,89.87249755859375,-1.3307981491088867,-57.69895935058594,89.87249755859375,-1.3307981491088867,-1.0771249532699585,55.84297561645508,-91.01956939697266,-1.0771249532699585,55.84297561645508,-91.01956939697266,-1.0771249532699585,55.84297561645508,-91.01956939697266,-1.0771249532699585,55.84297561645508,-91.01956939697266,-1.0771249532699585,55.84297561645508,-91.01956939697266,-1.0771249532699585,55.84297561645508,-91.01956939697266,.6651760339736938,56.91976547241211,-90.35406494140625,.6651760339736938,56.91976547241211,-90.35406494140625,.6651760339736938,56.91976547241211,-90.35406494140625,.6651760339736938,56.91976547241211,-90.35406494140625,.6651760339736938,56.91976547241211,-90.35406494140625,-.6658390760421753,56.91976547241211,-90.35406494140625,-.6658390760421753,56.91976547241211,-90.35406494140625,-.6658390760421753,56.91976547241211,-90.35406494140625,-.6658390760421753,56.91976547241211,-90.35406494140625,-.6658390760421753,56.91976547241211,-90.35406494140625,-1.3311461210250854,91.84559631347656,-35.90334701538086,-1.3311461210250854,91.84559631347656,-35.90334701538086,-1.3311461210250854,91.84559631347656,-35.90334701538086,-1.3311461210250854,91.84559631347656,-35.90334701538086,-1.3311461210250854,91.84559631347656,-35.90334701538086,-1.3311461210250854,91.84559631347656,-35.90334701538086,-.00012322973634582013,92.66816711425781,-33.749717712402344,-.00012322973634582013,92.66816711425781,-33.749717712402344,-.00012322973634582013,92.66816711425781,-33.749717712402344,-.00012322973634582013,92.66816711425781,-33.749717712402344,-89.87227630615234,1.3310145139694214,57.69929885864258,-89.87227630615234,1.3310145139694214,57.69929885864258,-89.87227630615234,1.3310145139694214,57.69929885864258,-89.87227630615234,1.3310145139694214,57.69929885864258,-2.153247833251953,55.54536819458008,91.20350646972656,-2.153247833251953,55.54536819458008,91.20350646972656,-2.153247833251953,55.54536819458008,91.20350646972656,-2.153247833251953,55.54536819458008,91.20350646972656],normalized:!1},normal:{itemSize:3,type:"Float32Array",array:[-.32300448417663574,.7980563640594482,-.5086984634399414,-.3229999840259552,.7980471849441528,-.5087158679962158,-.32299789786338806,.7980540990829468,-.5087060928344727,-.3229975402355194,.7980594038963318,-.5086981654167175,-.322995662689209,.7980546951293945,-.5087066292762756,-.32297030091285706,.7980630397796631,-.5087097883224487,-.3145313560962677,.8124136924743652,-.4909725487232208,-.3145303428173065,.8124191761016846,-.4909641742706299,-.31452667713165283,.8123946189880371,-.49100714921951294,-.31452617049217224,.8124018907546997,-.49099525809288025,-.31451353430747986,.8124081492424011,-.49099329113960266,.7977177500724792,.5067335963249207,.3269055485725403,.797724187374115,.5067331790924072,.3268907070159912,.7977266907691956,.5067335367202759,.32688409090042114,.797727644443512,.5067120790481567,.3269153833389282,.7977277636528015,.5067290663719177,.3268887996673584,-.48681509494781494,-.3170761168003082,-.8139249086380005,-.486814022064209,-.31705862283706665,-.8139324188232422,-.4868130683898926,-.31705430150032043,-.8139346241950989,-.486799031496048,-.3170582056045532,-.8139415383338928,-.48679620027542114,-.31705963611602783,-.8139426112174988,-.4867938756942749,-.3170706033706665,-.8139398097991943,.4910266399383545,.2948715388774872,-.8197216391563416,.4910283386707306,.29487162828445435,-.8197205662727356,.4910544753074646,.29487064480781555,-.8197053670883179,.49105706810951233,.2948714792728424,-.8197034597396851,.49106070399284363,.2948935925960541,-.8196933269500732,.49107053875923157,.29487308859825134,-.8196947574615479,.019486773759126663,.0034609902650117874,-.9998041391372681,.01950395107269287,.003431154415011406,-.9998038411140442,.01951080560684204,.0034348517656326294,-.9998037219047546,.019518375396728516,.003450945019721985,-.9998035430908203,.4929899275302887,.2909228503704071,.8199541568756104,.4929942488670349,.29094332456588745,.8199442028999329,.49299705028533936,.29093438386917114,.8199459314346313,.49300453066825867,.29094645380973816,.8199370503425598,.49301400780677795,.29092937707901,.8199374079704285,.506730854511261,.3268951177597046,.7977238893508911,.5067356824874878,.32688724994659424,.797724187374115,.5067362189292908,.3268929123878479,.7977213859558105,.5067363381385803,.3269083499908447,.7977150082588196,.5067551732063293,.32688796520233154,.7977114319801331,-.30085650086402893,-.8039307594299316,.5130113363265991,-.3008539080619812,-.8039156794548035,.5130366683006287,-.3008496165275574,-.8039196729660034,.5130329728126526,-.30084699392318726,-.8039218187332153,.5130308866500854,-.3008323013782501,-.8039500713348389,.5129954814910889,-.3008321523666382,-.8039198517799377,.5130428671836853,.999752938747406,.022229939699172974,-27254223823547363e-21,.9997531175613403,.02221774309873581,2555549144744873e-21,.9997531175613403,.022219747304916382,-11578202247619629e-21,.9997537136077881,.022191841155290604,-5044043064117432e-21,-6690621376037598e-21,.9997531771659851,.022219300270080566,15208497643470764e-22,.9997526407241821,.02224019356071949,7711350917816162e-21,.9997531771659851,.022218987345695496,25779008865356445e-21,.9997528791427612,.022229254245758057,-.8199474215507507,-.4929923415184021,.29093796014785767,-.8199467658996582,-.49298861622810364,.29094576835632324,-.8199445605278015,-.4929924011230469,.2909456789493561,-.8199410438537598,-.4930053651332855,.2909337878227234,-.8199405670166016,-.4929971694946289,.29094862937927246,-.8199316263198853,-.4930025041103363,.2909652292728424,-.503142237663269,.32643717527389526,-.800179123878479,-.503139078617096,.3264300227165222,-.8001841306686401,-.5031341314315796,.3264409899711609,-.8001827001571655,-.5031154155731201,.32642847299575806,-.800199568271637,-.9997532367706299,-.02221621572971344,-50961971282958984e-22,-.9997530579566956,-.02221750095486641,10980293154716492e-21,-.9997529983520508,-.022224798798561096,-216066837310791e-19,-.9997526407241821,-.022240420803427696,5041249096393585e-21,-.8199519515037537,-.4929916560649872,-.29092633724212646,-.8199494481086731,-.4929870665073395,-.29094117879867554,-.8199440240859985,-.4930054545402527,-.29092511534690857,-.8199396729469299,-.4930015802383423,-.29094383120536804,-.8199336528778076,-.4930025637149811,-.29095908999443054,-.8139479756355286,-.48679518699645996,-.3170475959777832,-.8139445185661316,-.4867909550666809,-.31706294417381287,-.8139359951019287,-.4868128299713135,-.3170514404773712,-.8139359951019287,-.4868128299713135,-.3170514404773712,-.8139272928237915,-.4868120551109314,-.3170749247074127,.291377991437912,.817572832107544,-.4966624081134796,.2913815379142761,.817571222782135,-.4966628849506378,.29140985012054443,.8175534605979919,-.49667567014694214,.29141905903816223,.8175671696662903,-.49664777517318726,.2914317846298218,.8175531625747681,-.49666333198547363,.3144916296005249,.8124189376831055,-.4909893870353699,.314521849155426,.812416136264801,-.4909745156764984,.31452593207359314,.8124017119407654,-.4909958243370056,.31453219056129456,.8123990893363953,-.4909961223602295,.31453219056129456,.8123990893363953,-.4909961223602295,.31453603506088257,.8124093413352966,-.49097663164138794,-.8199474215507507,.4929920434951782,.2909386157989502,-.8199455142021179,.4929906129837036,.29094627499580383,-.8199436664581299,.492990642786026,.29095107316970825,-.8199414610862732,.4929976165294647,.2909456193447113,-.8199408054351807,.49300891160964966,.290928453207016,-.8199315071105957,.4930025339126587,.2909652292728424,-.7977402210235596,.5067192316055298,.3268728256225586,-.797728419303894,.5067235827445984,.3268952965736389,-.7977269291877747,.5067242383956909,.32689791917800903,-.7977257370948792,.5067130923271179,.3269180655479431,-.7977219223976135,.5067331790924072,.32689642906188965,-.8039276003837585,.513014554977417,.30085939168930054,-.803920328617096,.5130298733711243,.30085256695747375,-.8039193153381348,.513033926486969,.30084848403930664,-.8039184808731079,.5130314230918884,.3008551299571991,-.3170892596244812,-.8139346837997437,-.4867902398109436,-.3170653283596039,-.813935399055481,-.48680463433265686,-.3170589804649353,-.8139439225196838,-.4867946207523346,-.3170560896396637,-.8139365315437317,-.486808717250824,-.31703075766563416,-.813947319984436,-.4868071973323822,-.3170735538005829,.8139387965202332,.4867936074733734,-.31706538796424866,.8139315843582153,.48681098222732544,-.3170650601387024,.8139441609382629,.4867902994155884,-.31706249713897705,.8139439225196838,.4867921471595764,-.3170546293258667,.8139438629150391,.4867975413799286,-.31705403327941895,.8139353394508362,.4868120551109314,-.31705284118652344,.8139360547065735,.4868115782737732,-.32690656185150146,.797716498374939,.5067349672317505,-.32688647508621216,.7977249026298523,.5067349076271057,-.32688552141189575,.7977311611175537,.506725549697876,-.3268853724002838,.7977126240730286,.5067547559738159,.2909286618232727,-.8199402689933777,-.49300962686538696,.290932297706604,-.8199490904808044,-.4929928183555603,.290941059589386,-.8199471831321716,-.49299079179763794,.2909466624259949,-.8199383020401001,-.49300238490104675,.2909603714942932,-.8199326395988464,-.49300357699394226,-.8139441013336182,-.4867924749851227,.31706178188323975,-.8139419555664062,-.4867969751358032,.3170603811740875,-.8139404058456421,-.4868042469024658,.31705325841903687,-.8139353394508362,-.48680993914604187,.31705722212791443,-.8139327764511108,-.486809641122818,.3170642554759979,-.8139600157737732,.48677366971969604,.31704968214035034,-.8139446973800659,.4867933988571167,.31705862283706665,-.8139420747756958,.48679694533348083,.31706005334854126,-.813937246799469,.48679330945014954,.3170780539512634,-.8139326572418213,.4868103265762329,.3170636296272278,-.8139210939407349,.4868491590023041,.31703364849090576,-.8199512958526611,.4929920434951782,-.29092729091644287,-.8199489712715149,.4929892122745514,-.2909389138221741,-.8199403882026672,.49300849437713623,-.29093047976493835,-.8199390172958374,.4930011034011841,-.2909468710422516,-.8199335932731628,.49300262331962585,-.2909591794013977,.022224154323339462,8113682270050049e-21,.999752938747406,.022224217653274536,-7063150405883789e-21,.9997529983520508,.02223508059978485,-2683699131011963e-20,.9997528195381165,.022243808954954147,14416873455047607e-22,.9997525811195374,.5130226612091064,-.30085763335227966,.8039230704307556,.5130249857902527,-.30090412497520447,.8039043545722961,.5130347013473511,-.3008493185043335,.8039185404777527,.5130426287651062,-.30085936188697815,.8039097785949707,.5130426287651062,-.30085936188697815,.8039097785949707,.8139259815216064,.4868123233318329,.31707778573036194,.8139373064041138,.4867918789386749,.31708046793937683,.8139375448226929,.48680996894836426,.3170512318611145,.8139379024505615,.4868050515651703,.3170582354068756,.8139469027519226,.48679566383361816,.3170495331287384,.8139491677284241,.48678889870643616,.31705406308174133,-.49300631880760193,.29092955589294434,.8199419379234314,-.4929933547973633,.29095086455345154,.8199421167373657,-.4929933547973633,.29095086455345154,.8199421167373657,-.49299073219299316,.2909349799156189,.8199493885040283,-.4929877817630768,.290939062833786,.8199498057365417,-.49300646781921387,-.29092955589294434,.8199418783187866,-.4929991066455841,-.2909305989742279,.8199458718299866,-.4929991066455841,-.2909305989742279,.8199458718299866,-.4929906129837036,-.29093536734580994,.8199493885040283,-.49298787117004395,-.2909401059150696,.819949209690094,-.022236576303839684,-14398247003555298e-22,.9997527003288269,-.022226199507713318,26732683181762695e-21,.9997529983520508,-.022215761244297028,-4159286618232727e-21,.9997531771659851,-.022215470671653748,28014183044433594e-22,.9997532963752747,.4860762059688568,.31750911474227905,-.8141976594924927,.4860828220844269,.3174929618835449,-.8142000436782837,.4860839545726776,.31748220324516296,-.8142036199569702,.48609045147895813,.31749191880226135,-.8141958713531494,.48609644174575806,.31749197840690613,-.8141922950744629,.48610714077949524,.3175130784511566,-.8141777515411377,.48611539602279663,.31747305393218994,-.8141883611679077,-346451997756958e-19,.016819089651107788,-.9998586177825928,-2047419548034668e-20,.016789883375167847,-.999859094619751,-13813376426696777e-21,.016806378960609436,-.9998587369918823,-277138315141201e-20,.016810698434710503,-.9998586773872375,65267086029052734e-22,.016805753111839294,-.9998587965965271,18220569472759962e-21,.016794271767139435,-.9998589754104614,.016185671091079712,-.9998690485954285,-3345310688018799e-20,.01620444655418396,-.999868631362915,-10926742106676102e-22,.016207069158554077,-.999868631362915,11086463928222656e-21,.01620793342590332,-.999868631362915,-10415911674499512e-21,.016219258308410645,-.9998684525489807,-2.980232238769531e-7,.016219640150666237,-.9998684525489807,-4.5890919864177704e-7,.3170523941516876,-.8139364719390869,-.486811101436615,.3170545697212219,-.8139440417289734,-.48679736256599426,.31706172227859497,-.8139370083808899,-.48680418729782104,.3170723617076874,-.8139404058456421,-.486791729927063,.31707704067230225,-.8139263391494751,-.48681217432022095,.8199406266212463,-.4929971992969513,-.29094862937927246,.8199410438537598,-.49300533533096313,-.290933758020401,.8199447989463806,-.49299201369285583,-.2909456193447113,.8199467658996582,-.4929884672164917,-.290946364402771,.819947361946106,-.492992103099823,-.2909383773803711,.8199547529220581,-.49298709630966187,-.2909259796142578,-.016219263896346092,.9998684525489807,5.702022463083267e-7,-.016217336058616638,.9998685717582703,-4.023313522338867e-7,-.016208097338676453,.9998686909675598,-1023709774017334e-20,-.016207024455070496,.9998686909675598,11369585990905762e-21,-.01620444655418396,.9998686909675598,10926742106676102e-22,-.01616719365119934,.9998693466186523,33482909202575684e-21,.32295531034469604,.7980619072914124,-.5087209343910217,.32295531034469604,.7980619072914124,-.5087209343910217,.3229907155036926,.798053503036499,-.5087116956710815,.3229965567588806,.7980476021766663,-.50871741771698,.32300084829330444,.7980570793151855,-.5086997747421265,.8039142489433289,.5130448937416077,.30084332823753357,.8039181232452393,.5130343437194824,.3008510172367096,.8039227724075317,.5130297541618347,.300846129655838,.8039230108261108,.5130389332771301,.300830215215683,.8039236664772034,.5130265355110168,.30084937810897827,.8039326667785645,.5130090117454529,.3008555769920349,.8039484024047852,.512998104095459,.3008320927619934,-.30085283517837524,.8039165735244751,.5130358934402466,-.300849586725235,.8039194345474243,.5130332708358765,-.3008473813533783,.803921639919281,.5130310654640198,-.3008348345756531,.8039216995239258,.5130383372306824,-.3008311986923218,.8039206862449646,.5130419731140137,.300837904214859,.803917407989502,.5130431056022644,.30084890127182007,.8039129972457886,.5130437016487122,.30085113644599915,.803921639919281,.5130288004875183,.3008517622947693,.8039230704307556,.5130261182785034,.3008546531200409,.8039194941520691,.5130301117897034,.3008613586425781,.8039342164993286,.5130031108856201,-.019525907933712006,.0034512635320425034,-.999803364276886,-.019515730440616608,.003434911370277405,-.9998036623001099,-.01951080560684204,.0034344345331192017,-.9998037815093994,-.01949400082230568,.003460988402366638,-.9998040795326233,.30084559321403503,-.8039190173149109,-.5130363702774048,.3008456826210022,-.8039130568504333,-.5130454301834106,.30084726214408875,-.8039217591285706,-.5130307674407959,.30084937810897827,-.8039229512214661,-.5130279660224915,.3008571267127991,-.803926944732666,-.5130170583724976,.49298426508903503,-.29092302918434143,-.8199574947357178,.4929867684841156,-.290944904088974,-.819948136806488,.4929903745651245,-.29092836380004883,-.8199520111083984,.4929988384246826,-.29094645380973816,-.819940447807312,.4930066466331482,-.29092955589294434,-.8199417591094971,.30083754658699036,-.8039181232452393,.5130423307418823,.3008488714694977,-.8039132356643677,.5130434036254883,.3008507788181305,-.8039216995239258,.5130287408828735,.30085182189941406,-.8039235472679138,.5130254030227661,.30085495114326477,-.8039181232452393,.5130321383476257,.30085986852645874,-.8039340376853943,.5130043029785156,-.797728419303894,-.5067229270935059,.3268962502479553,-.7977258563041687,-.506712794303894,.3269183933734894,-.797725260257721,-.5067326426506042,.3268887996673584,-.7977154850959778,-.5067335367202759,.32691144943237305,-.3269064426422119,-.7977167367935181,.5067347884178162,-.3268938660621643,-.7977226376533508,.5067335367202759,-.3268907070159912,-.7977270483970642,.5067287087440491,-.3268868923187256,-.7977240085601807,.5067360997200012,-.3268852233886719,-.7977129817008972,.5067545175552368,-.5089601278305054,.3034306466579437,-.805536687374115,-.5089573860168457,.30343058705329895,-.805538535118103,-.5089519619941711,.30339932441711426,-.8055538535118103,-.5089257955551147,.30343857407569885,-.8055554628372192,-.5089184045791626,.3034357726573944,-.8055611252784729,-.5088995695114136,.30344462394714355,-.8055697679519653,.3268873393535614,.7977280616760254,.5067291259765625,.32689282298088074,.7977269887924194,.5067273378372192,.3269011378288269,.7977209091186523,.5067315101623535,.3269102871417999,.7977165579795837,.5067325234413147,.32691535353660583,.7977278828620911,.5067119002342224,-26047229766845703e-21,-.999752938747406,-.02222883701324463,-8940696716308594e-21,-.9997531175613403,-.022218912839889526,-15245750546455383e-22,-.9997526407241821,-.02224019728600979,7366761565208435e-21,-.9997531175613403,-.02221873588860035,-.290948748588562,-.8199450969696045,-.49298956990242004,-.2909458875656128,-.8199467658996582,-.49298855662345886,-.2909458577632904,-.8199422955513,-.4929962456226349,-.29093700647354126,-.8199491500854492,-.4929898679256439,-.29093021154403687,-.8199409246444702,-.4930077791213989,-.2909247875213623,-.8199558854103088,-.4929860532283783,.7977120280265808,-.5067539215087891,.32688847184181213,.7977270483970642,-.506733775138855,.3268832564353943,.7977273464202881,-.5067236423492432,.32689768075942993,.7977273464202881,-.5067236423492432,.32689768075942993,.3170563578605652,.8139361143112183,.48680925369262695,.3170570433139801,.8139445185661316,.4867948889732361,.3170689344406128,.813934862613678,.4868030846118927,.3170716166496277,.8139290809631348,.4868110716342926,.31707435846328735,.8139417171478271,.48678815364837646,.4867840111255646,-.3170663118362427,-.8139473795890808,.486789345741272,-.3170621991157532,-.8139458894729614,.4867922365665436,-.31707215309143066,-.8139402270317078,.48679348826408386,-.317050039768219,-.8139480948448181,.4868071973323822,-.3170592784881592,-.8139362335205078,.48680734634399414,-.31705474853515625,-.8139378428459167,.4868084490299225,-.3170764446258545,-.8139288425445557,-13574957847595215e-21,-.01111060380935669,-.9999383091926575,-4933535819873214e-21,-.011075659655034542,-.9999386072158813,7039896445348859e-21,-.011118302121758461,-.9999381303787231,852346420288086e-20,-.01112416386604309,-.9999381899833679,14200806617736816e-21,-.011078417301177979,-.9999385476112366,3071129322052002e-20,-.011100709438323975,-.9999383687973022,.29092466831207275,.8199556469917297,.49298620223999023,.2909298241138458,.8199406862258911,.4930081367492676,.2909347116947174,.8199495077133179,.4929908514022827,.2909448742866516,.8199471235275269,.49298879504203796,.29094886779785156,.8199383020401001,.49300071597099304,.016171813011169434,.9998692274093628,-3343820571899414e-20,.01620444655418396,.999868631362915,-10915100574493408e-22,.01620711386203766,.9998686909675598,-10520219802856445e-21,.01620851457118988,.9998686909675598,1023709774017334e-20,.01621788740158081,.9998685121536255,1.7881393432617188e-7,.016219263896346092,.9998685121536255,-3.4598633646965027e-7,-.5067505836486816,.3268905580043793,.7977132201194763,-.5067304372787476,.3269084393978119,.7977187037467957,-.5067296028137207,.3268975615501404,.797723650932312,-.5067266225814819,.3268991708755493,.7977248430252075,-.5067264437675476,.32688987255096436,.7977288961410522,-.5067263245582581,.32689154148101807,.7977282404899597,-.2909603714942932,.8199325203895569,.49300387501716614,-.2909455895423889,.8199446797370911,.4929923117160797,-.2909436821937561,.8199417591094971,.4929981827735901,-.2909405529499054,.8199470639228821,.4929913282394409,-.2909325659275055,.8199489712715149,.4929928183555603,-.2909291386604309,.819939911365509,.4930098354816437,-.9997537136077881,.022191839292645454,504031777381897e-20,-.9997531175613403,.02221798151731491,-2693384885787964e-21,-.9997531175613403,.022219747304916382,11652708053588867e-21,-.9997529983520508,.022228829562664032,273287296295166e-19,-.9998690485954285,-4357099533081055e-20,.01618865132331848,-.999868631362915,8.069910109043121e-7,.016208183020353317,-.9998685717582703,-448375940322876e-19,.01621093973517418,-.9998685717582703,-8761882781982422e-21,.01621145009994507,-.9998685717582703,11309981346130371e-21,.01621215045452118,-.9998684525489807,-10132789611816406e-22,.01622423529624939,-.9998683929443359,10335352271795273e-22,.016223950311541557,-.5130453705787659,-.3008093237876892,.8039266467094421,-.5130453705787659,-.3008093237876892,.8039266467094421,-.5130347013473511,-.30084866285324097,.8039188385009766,-.5130272507667542,-.3008646070957184,.803917646408081,-.5130270719528198,-.3008405864238739,.8039267659187317,-.5130001902580261,-.3008325397968292,.8039469718933105,-.5067576169967651,-.3268996477127075,-.7977050542831421,-.5067576169967651,-.3268996477127075,-.7977050542831421,-.5067268013954163,-.3268904387950897,-.7977283596992493,-.5067136287689209,-.32691413164138794,-.7977270483970642,-.5130422711372375,-.30085960030555725,-.8039097785949707,-.5130422711372375,-.30085960030555725,-.8039097785949707,-.5130351185798645,-.3008493185043335,-.8039183616638184,-.5130186080932617,-.30085819959640503,-.8039255738258362,-.5130038857460022,-.3008323609828949,-.8039445877075195,-.8139479756355286,.4867886006832123,-.31705790758132935,-.8139469027519226,.4867956042289734,-.3170493245124817,-.8139386773109436,.4867936074733734,-.31707385182380676,-.8139375448226929,.48680996894836426,-.3170512914657593,-.8139374256134033,.486805260181427,-.3170590400695801,-.8139272928237915,.4868119955062866,-.31707483530044556,-.8039371967315674,-.5130016803741455,-.3008561134338379,-.8039246797561646,-.5130265951156616,-.30084672570228577,-.8039228916168213,-.5130297541618347,-.30084607005119324,-.803920567035675,-.5130411386489868,-.3008330762386322,-.803917407989502,-.5130360126495361,-.3008502721786499,-.8039128184318542,-.5130437016487122,-.30084937810897827,-.8039510250091553,-.5129914879798889,.30083632469177246,-.803925633430481,-.513030469417572,.30083781480789185,-.8039206862449646,-.5130295753479004,.3008521795272827,-.8039200901985168,-.5130325555801392,.3008491098880768,-.8039183616638184,-.5130420923233032,.30083730816841125,-.8039169311523438,-.513033390045166,.3008556663990021,-.8039165735244751,-.5130240321159363,.3008728623390198,.8139259219169617,-.4868123531341553,.3170778751373291,.8139362335205078,-.48681262135505676,.31705108284950256,.8139362335205078,-.48681262135505676,.31705108284950256,.8139456510543823,-.4867914915084839,.31705909967422485,.8139479756355286,-.4867952764034271,.3170475363731384,.8199337124824524,-.4930025637149811,.29095906019210815,.8199397325515747,-.4930015802383423,.29094383120536804,.8199440240859985,-.4930053949356079,.29092511534690857,.8199495673179626,-.49298688769340515,.290941059589386,.8199518918991089,-.4929915964603424,.29092657566070557,-30502676963806152e-21,-.01617613434791565,.9998691082000732,-8180737495422363e-21,-.016205251216888428,.999868631362915,11175870895385742e-22,-.01622094213962555,.9998685121536255,46496279537677765e-22,-.01620444841682911,.9998686909675598,6626127287745476e-21,-.016218557953834534,.9998685121536255,16480684280395508e-21,-.016207247972488403,.999868631362915,.2909298837184906,-.8199405670166016,.493008553981781,.2909371554851532,-.819949209690094,.49298959970474243,.290944904088974,-.8199470043182373,.4929887652397156,.29094886779785156,-.8199384212493896,.4930006265640259,.29096388816833496,-.8199325799942017,.49300146102905273,.8199388980865479,.4930010437965393,.2909468710422516,.8199397325515747,.4930093288421631,.2909305691719055,.8199490904808044,.49298906326293945,.2909387946128845,.8199512362480164,.4929920732975006,.2909274697303772,.8199567198753357,.4929872155189514,.29091987013816833,.8039079904556274,.5130425095558167,-.30086418986320496,.8039079904556274,.5130425095558167,-.30086418986320496,.8039183616638184,.513031542301178,-.3008551597595215,.8039308786392212,.5130091905593872,-.30085980892181396,.4929937720298767,-.29094550013542175,.8199437856674194,.4929945468902588,-.2909424602985382,.819944441318512,.4929971694946289,-.2909335792064667,.8199460506439209,.49299973249435425,-.29094603657722473,.8199400305747986,.4930054247379303,-.2909621000289917,.819930911064148,.4930139482021332,-.2909294068813324,.8199374079704285,-.5067506432533264,-.326890766620636,.7977131605148315,-.5067328214645386,-.32690688967704773,.797717809677124,-.5067287087440491,-.326896071434021,.7977248430252075,-.5067263841629028,-.3268885314464569,.7977295517921448,-.5067260265350342,-.3268907368183136,.7977287173271179,-.5067246556282043,-.3268979489803314,.7977266907691956,-.4868078827857971,-.31707385182380676,.8139301538467407,-.48680680990219116,-.31705403327941895,.8139384388923645,-.4868009090423584,-.3170638084411621,.8139382600784302,-.4867950677871704,-.3170577883720398,.8139441013336182,-.486785888671875,-.31707119941711426,.8139443397521973,-63907355070114136e-22,-.9997531175613403,.02221914753317833,15255063772201538e-22,-.9997526407241821,.022240199148654938,7659196853637695e-21,-.9997530579566956,.022218987345695496,25704503059387207e-21,-.9997528791427612,.022229783236980438,-.2909602224826813,-.8199326992034912,.49300363659858704,-.2909456193447113,-.8199447989463806,.4929920732975006,-.2909436523914337,-.8199417591094971,.4929981827735901,-.2909403145313263,-.8199471235275269,.4929913580417633,-.2909320592880249,-.8199489116668701,.4929931163787842,-.2909291386604309,-.8199397325515747,.4930102229118347,-.3170614242553711,-.8139365911483765,.4868052303791046,-.3170546591281891,-.8139438629150391,.4867975413799286,-.31705236434936523,-.8139365911483765,.4868110716342926,-.31705206632614136,-.8139435052871704,.4867997169494629,.5067088007926941,-.32691431045532227,-.7977301478385925,.5067205429077148,-.32689112424850464,-.7977320551872253,.506729781627655,-.32688722014427185,-.7977279424667358,.5067307949066162,-.32690852880477905,-.797718346118927,.9997526407241821,-.022240418940782547,-5042180418968201e-21,.9997529983520508,-.02222476899623871,216066837310791e-19,.9997532367706299,-.022217553108930588,-11643394827842712e-21,.9997532963752747,-.022216007113456726,49620866775512695e-22,.8139346837997437,-.48679178953170776,-.31708675622940063,.8139352798461914,-.48680993914604187,-.31705716252326965,.8139358758926392,-.48680379986763,-.31706541776657104,.8139419555664062,-.4867968261241913,-.3170607388019562,.8139616847038269,-.4867711067199707,-.3170492947101593,.9998683333396912,9.019859135150909e-7,-.016223222017288208,.9998684525489807,-9.5367431640625e-7,-.016224414110183716,.999868631362915,-858306884765625e-20,-.01621215045452118,.999868631362915,8.074566721916199e-7,-.016208184882998466,.999868631362915,11593103408813477e-21,-.016211628913879395,.9998686909675598,-31620264053344727e-21,-.016208022832870483,.9998689293861389,-4826486110687256e-20,-.0161912702023983,-838935375213623e-20,.016203731298446655,.9998688101768494,9.622890502214432e-7,.01622016541659832,.9998683929443359,4648929461836815e-21,.01620445027947426,.9998686909675598,64373016357421875e-22,.01621994376182556,.9998685717582703,1582503318786621e-20,.016208693385124207,.9998685121536255,3847479820251465e-20,.016177505254745483,.999869167804718,.48680007457733154,.31705743074417114,.813941240310669,.48680129647254944,.3170565962791443,.8139409422874451,.4868077337741852,.3170599937438965,.8139355778694153,.48685207962989807,.3170304000377655,.8139206767082214,.8139327168464661,.48680904507637024,-.31706565618515015,.8139352798461914,.48680996894836426,-.3170573115348816,.813941240310669,.48680001497268677,-.31705746054649353,.8139423727989197,.4867967665195465,-.31705957651138306,.8139436841011047,.48679426312446594,-.3170599341392517,.5088772773742676,.30341875553131104,-.8055935502052307,.5089110136032104,.3034226894378662,-.8055708408355713,.5089132785797119,.30345800518989563,-.8055559992790222,.5089139342308044,.30345267057418823,-.8055576086044312,.508934497833252,.30343055725097656,-.8055529594421387,.5089894533157349,.303387314081192,-.8055344820022583,.5031076073646545,.3264298439025879,-.8002038598060608,.5031241178512573,.3264410197734833,-.8001890182495117,.5031249523162842,.32645124197006226,-.8001842498779297,.5031318664550781,.3264358937740326,-.8001861572265625,.5031365752220154,.3264387249946594,-.8001821041107178,.797707200050354,.506753146648407,-.3269011378288269,.797707200050354,.506753146648407,-.3269011378288269,.7977266907691956,.5067112445831299,-.32691892981529236,.7977287769317627,.5067213773727417,-.3268980383872986,.3170560896396637,-.8139365315437317,.486808717250824,.31705886125564575,-.8139439821243286,.48679447174072266,.3170628845691681,-.813936173915863,.4868050217628479,.3170718252658844,-.8139439821243286,.48678603768348694,.31708014011383057,-.8139369487762451,.48679235577583313,.31708040833473206,-.8139251470565796,.48681211471557617,.8199315071105957,.4930025637149811,-.2909652590751648,.8199403285980225,.49300968647003174,-.2909284830093384,.8199413418769836,.49299755692481995,-.2909456491470337,.8199435472488403,.49299076199531555,-.29095104336738586,.8199455142021179,.4929905831813812,-.2909463047981262,.8199475407600403,.4929920434951782,-.2909378409385681,-.49301081895828247,-.2909294068813324,-.8199392557144165,-.4930001497268677,-.29094603657722473,-.8199397325515747,-.4929942190647125,-.29094552993774414,-.8199436664581299,-.49299415946006775,-.2909356355667114,-.8199470043182373,-.4929927885532379,-.2909421920776367,-.8199455738067627,-.49299028515815735,-.29092299938201904,-.8199537992477417,-.016219697892665863,-.9998685121536255,1.8882565200328827e-7,-.016219332814216614,-.9998683929443359,4.917383193969727e-7,-.016213014721870422,-.9998685121536255,4868209362030029e-20,-.016209125518798828,-.999868631362915,-10088086128234863e-21,-.016207367181777954,-.999868631362915,10952353477478027e-21,-.01620444655418396,-.9998686909675598,-9.727664291858673e-7,-.01618608832359314,-.9998689889907837,3844499588012695e-20,-.49107488989830017,.2948729395866394,-.8196921944618225,-.49106675386428833,.29489362239837646,-.8196896314620972,-.49106061458587646,.2948709726333618,-.8197014927864075,-.49105924367904663,.2948675751686096,-.8197035193443298,-.4910484552383423,.2948729693889618,-.8197080492973328,.5130017399787903,-.30085939168930054,-.8039357662200928,.5130244493484497,-.30084937810897827,-.803925096988678,.513026773929596,-.3008493483066559,-.8039234280586243,.513030469417572,-.30085432529449463,-.8039193749427795,.5130401253700256,-.30083391070365906,-.8039209842681885,.5130414366722107,-.30084913969039917,-.8039143681526184,.32688838243484497,-.7977268695831299,.5067307949066162,.3268934488296509,-.797727644443512,.5067262649536133,.3268952965736389,-.7977220416069031,.5067338347434998,.3269088566303253,-.7977157235145569,.5067347288131714,.32691681385040283,-.7977270483970642,.5067120790481567,.506731390953064,-.3268928527832031,.7977245450019836,.5067368745803833,-.3268938362598419,.7977205514907837,.5067563056945801,-.3268866240978241,.7977113723754883,.5067574977874756,-.3268994987010956,.7977052927017212,.5067574977874756,-.3268994987010956,.7977052927017212,.48679232597351074,-.31706538796424866,.8139427304267883,.4867943525314331,-.3170838952064514,.8139344453811646,.48680126667022705,-.317055344581604,.8139413595199585,.48680776357650757,-.31706103682518005,.8139351010322571,.4868128001689911,-.3170541524887085,.813934862613678,.4868144989013672,-.3170735836029053,.8139262199401855,-.3269168436527252,-.7977273464202881,-.5067114233970642,-.3269089162349701,-.7977157235145569,-.5067346096038818,-.32690006494522095,-.7977253198623657,-.5067254304885864,-.3268975615501404,-.7977211475372314,-.5067336559295654,-.326894074678421,-.7977250218391418,-.5067296624183655,-.32689133286476135,-.7977280020713806,-.5067267417907715,-.7977375388145447,-.5067383050918579,-.3268502950668335,-.7977375388145447,-.5067383050918579,-.3268502950668335,-.7977255582809448,-.5067352652549744,-.326884001493454,-.7977122068405151,-.5067542791366577,-.32688724994659424,.9998685717582703,-1.9371509552001953e-7,.016211718320846558,.9998686909675598,-7063150405883789e-21,.01620452105998993,.9998686909675598,5.688052624464035e-7,.01620963215827942,.9998687505722046,8.088536560535431e-7,.01620098017156124,.9998687505722046,9447336196899414e-21,.016203224658966064,.9998690485954285,-34227967262268066e-21,.01618596911430359,.3268680274486542,-.7977415323257446,-.5067204236984253,.3268900513648987,-.7977254986763,-.5067315697669983,.32689306139945984,-.7977262735366821,-.5067285299301147,.3268945813179016,-.7977228164672852,-.5067329406738281,.32689517736434937,-.7977268099784851,-.5067262649536133,.32691502571105957,-.7977272272109985,-.5067128539085388,.7977112531661987,-.5067529678344727,-.32689201831817627,.7977154850959778,-.5067335963249207,-.32691144943237305,.7977215647697449,-.506732702255249,-.32689809799194336,.7977254390716553,-.5067287087440491,-.32689452171325684,.7977267503738403,-.5067309141159058,-.32688814401626587,.5130077004432678,.30085963010787964,.8039320707321167,.5130297541618347,.30084937810897827,.8039216995239258,.5130323171615601,.3008490204811096,.8039200901985168,.5130364894866943,.30085432529449463,.8039156794548035,.5130462050437927,.3008359372615814,.8039162158966064,.51304692029953,.30084913969039917,.8039107918739319,.8039127588272095,-.5130437612533569,.30084940791130066,.8039186596870422,-.5130347609519958,.3008493483066559,.8039190769195557,-.5130429863929749,.30083420872688293,.8039229512214661,-.5130298137664795,.30084604024887085,.8039247393608093,-.5130265951156616,.3008466958999634,.8039315938949585,-.5130106210708618,.3008553087711334,.8039183616638184,-.5130316615104675,-.30085524916648865,.803918719291687,-.5130422711372375,-.3008360266685486,.8039200305938721,-.5130326151847839,-.30084913969039917,.8039206862449646,-.5130296349525452,-.3008522093296051,.8039317727088928,-.513005793094635,-.30086347460746765,.8039458394050598,-.5129998922348022,-.3008357584476471,-.30086222290992737,-.8039306402206421,-.5130082964897156,-.30085277557373047,-.8039199113845825,-.513030469417572,-.300851047039032,-.8039217591285706,-.513028621673584,-.3008507788181305,-.8039173483848572,-.5130357146263123,-.3008337914943695,-.8039432168006897,-.5130053162574768,-.9998691082000732,-34242868423461914e-21,-.01618131995201111,-.9998687505722046,8.067581802606583e-7,-.01620098017156124,-.9998687505722046,9641051292419434e-21,-.016203448176383972,-.9998686909675598,-7212162017822266e-21,-.016204625368118286,-.9998686909675598,6.223563104867935e-7,-.016209648922085762,-.9998685121536255,-1.9371509552001953e-7,-.01621153950691223,-.7977283596992493,.5067322254180908,-.326882004737854,-.7977277636528015,.5067290663719177,-.3268887996673584,-.7977234125137329,.5067338943481445,-.32689157128334045,-.7977177500724792,.5067336559295654,-.32690560817718506,-.7977122068405151,.5067541599273682,-.326887309551239,-.8039452433586121,.5130032300949097,-.3008318245410919,-.8039326071739197,.5130090713500977,-.3008555769920349,-.8039237856864929,.5130265951156616,-.30084937810897827,-.8039227724075317,.5130298137664795,-.3008461892604828,-.8039199709892273,.5130324363708496,-.30084940791130066,-.8039199709892273,.5130419135093689,-.30083346366882324,-.8039143681526184,.5130447745323181,-.30084335803985596,-.4861213266849518,.3174731433391571,-.8141847252845764,-.4861072897911072,.3175134062767029,-.8141775131225586,-.4861047863960266,.31748297810554504,-.8141908049583435,-.4861007332801819,.3174685537815094,-.8141988515853882,-.4860859811306,.31749480962753296,-.8141974210739136,-.48608478903770447,.3174983561038971,-.814196765422821,.30044397711753845,.8036642670631409,-.5136703848838806,.30044645071029663,.8036598563194275,-.5136758685112,.3004480004310608,.8036625981330872,-.5136705636978149,.3004538118839264,.8036926984786987,-.5136200785636902,.30045652389526367,.8036901950836182,-.5136222839355469,-.3004720211029053,.8036836981773376,-.5136234760284424,-.30045682191848755,.8036627769470215,-.513664960861206,-.3004477024078369,.8036642670631409,-.5136681795120239,-.30044496059417725,.8036916851997375,-.5136268734931946,-.3004448711872101,.8036707043647766,-.5136595964431763,-.29143548011779785,.8175532221794128,-.4966612160205841,-.2914249300956726,.8175643086433411,-.4966491460800171,-.2914220690727234,.8175652623176575,-.49664899706840515,-.2914113402366638,.8175539374351501,-.4966740012168884,-.2913860082626343,.8175709843635559,-.49666067957878113,-.2913796901702881,.8175732493400574,-.49666085839271545,-2612173557281494e-20,.9997528791427612,-.022229932248592377,-7601454854011536e-21,.9997532367706299,-.02221878245472908,13606622815132141e-22,.9997526407241821,-.02224019542336464,6318092346191406e-21,.9997531771659851,-.022218704223632812,-.5130420923233032,.3008320927619934,.8039203882217407,-.5130420923233032,.3008320927619934,.8039203882217407,-.513036847114563,.30085039138793945,.8039168119430542,-.5130102634429932,.3008587956428528,.8039306998252869,-.48680686950683594,.31705421209335327,.8139384388923645,-.48680058121681213,.31706511974334717,.8139378428459167,-.4867952764034271,.3170567750930786,.8139443397521973,-.48679250478744507,.3170604407787323,.8139445781707764],normalized:!1},uv:{itemSize:2,type:"Float32Array",array:[.01962309330701828,.012889564037322998,.02023136429488659,.10979831218719482,.07965327799320221,.07732349634170532,.07965327799320221,.07732349634170532,.02023136429488659,.10979831218719482,.5619750022888184,.14709901809692383,.02450018748641014,.02645343542098999,.06788178533315659,.04795658588409424,.0796533077955246,.04795646667480469,.02450018748641014,.02645343542098999,.503350019454956,.1835920214653015,.3125010132789612,.3969320058822632,.10002404451370239,.04638880491256714,.0839850902557373,.04795658588409424,.01962309330701828,.008929312229156494,.10002404451370239,.04638880491256714,.018139563500881195,.03942161798477173,.05488619580864906,.04795628786087036,.503491997718811,.058592021465301514,.09820473194122314,.10979831218719482,.05488619580864906,.04795628786087036,.018139563500881195,.03942161798477173,.04933025687932968,.08043122291564941,.04933025687932968,.08043122291564941,.03322688490152359,.0800524353981018,.03322688490152359,.0800524353981018,.0619719997048378,.7201650142669678,.012844499200582504,.020931720733642578,.5630499720573425,.345100998878479,.09606381505727768,.008966565132141113,.011493649333715439,.020151853561401367,.03200281038880348,.0800524353981018,.6875010132789612,.5218279957771301,.05055434629321098,.07732337713241577,.05055434629321098,.07732337713241577,.11814413964748383,.008967041969299316,.0850236713886261,.029828131198883057,.057423245161771774,.008966565132141113,.10158386081457138,.04638880491256714,.057423245161771774,.008966565132141113,.6874989867210388,.5953599810600281,.01827225834131241,.008149445056915283,.019623126834630966,.045423686504364014,.03755871579051018,.047578275203704834,.09387288242578506,.07732349634170532,.24622400104999542,.4335950016975403,.019623126834630966,.045423686504364014,.03755871579051018,.047578275203704834,.0850236713886261,.040868282318115234,.07398355007171631,.008967041969299316,.07532140612602234,.08043128252029419,.18750199675559998,.5220270156860352,.04066653922200203,.04795628786087036,.3125,.021938025951385498,.10997618734836578,.10979831218719482,.02358332648873329,.01918947696685791,.05190323293209076,.046388089656829834,.05190323293209076,.046388089656829834,.05488622561097145,.08043128252029419,.08367279171943665,.023528218269348145,.05488622561097145,.08043128252029419,.3124989867210388,.5957159996032715,.018272243440151215,.013669490814208984,.10554412007331848,.008966803550720215,.019007263705134392,.10979831218719482,.4383139908313751,.39722001552581787,.10253656655550003,.10979831218719482,.0503433421254158,.04638814926147461,.0850236713886261,.024307966232299805,.3124980032444,.22047501802444458,.10131248831748962,.10979825258255005,.10131248831748962,.10979825258255005,.0850236713886261,.022748231887817383,.05366211757063866,.08043128252029419,.1875,.27190500497817993,.10131251811981201,.08043169975280762,.02450021728873253,.04338186979293823,.06294332444667816,.008966565132141113,.1285640001296997,.3085939884185791,.02450021728873253,.04338186979293823,.09387288242578506,.08043169975280762,.09387288242578506,.08043169975280762,.006182555109262466,.02567189931869507,.027670973911881447,.08005237579345703,.312734991312027,.34500598907470703,.09387288242578506,.10979831218719482,.007099363952875137,.04590404033660889,.007099363952875137,.04590404033660889,.059218067675828934,.08043104410171509,.37151700258255005,.3090599775314331,.007099363952875137,.04590404033660889,.10997628420591354,.07732337713241577,.10997628420591354,.07732337713241577,.10253656655550003,.07732349634170532,.10253656655550003,.07732349634170532,.006182555109262466,.020151853561401367,.0625,.14693999290466309,.0625,.2202470302581787,.03322688490152359,.07694470882415771,.03378301486372948,.04638814926147461,.08502364158630371,.013267934322357178,.03378301486372948,.04638814926147461,.02598363533616066,.024411678314208984,.12137900292873383,.1835939884185791,.03378315269947052,.008967041969299316,.10253656655550003,.04795682430267334,.02450018748641014,.030413687229156494,.028895026072859764,.047577083110809326,.04622248187661171,.07732313871383667,.6290850043296814,.1835920214653015,.02450018748641014,.030413687229156494,.02450018748641014,.0239296555519104,.02450018748641014,.0239296555519104,.02450018748641014,.0239296555519104,.035342950373888016,.008967041969299316,.041890617460012436,.07732313871383667,.035342950373888016,.008967041969299316,.4962030053138733,.3085950016975403,.4375010132789612,.27205002307891846,.02333913929760456,.07694411277770996,.035342950373888016,.04638814926147461,.08367279171943665,.012488067150115967,.012844499200582504,.024891972541809082,.06232589855790138,.047956228256225586,.06232589855790138,.047956228256225586,.0883169174194336,.07732337713241577,.06249900162220001,.47056400775909424,.08087734878063202,.10979831218719482,.05190323293209076,.00896763801574707,.024500157684087753,.03689777851104736,.25286900997161865,.5585929751396179,.08087734878063202,.10979831218719482,.02598368003964424,.038939595222473145,.03322688490152359,.047577738761901855,.10997621715068817,.04795706272125244,.02598368003964424,.038939595222473145,.03322688490152359,.047577738761901855,.003621000098064542,.1835939884185791,.07794374972581863,.008966684341430664,.07794374972581863,.008966684341430664,.007533404976129532,.020931720733642578,.10131248831748962,.07732349634170532,.5625010132789612,.5218250155448914,.04933026805520058,.07732349634170532,.07532145082950592,.04795658588409424,.0850236713886261,.028268277645111084,.6875020265579224,.2718750238418579,.008582886308431625,.03737819194793701,.008582886308431625,.03737819194793701,.11658430099487305,.04638892412185669,.11106422543525696,.00896674394607544,.12150800228118896,.3085930347442627,.007099427282810211,.03942000865936279,.007099427282810211,.03942000865936279,.25360798835754395,.4335930347442627,.10002404451370239,.00896674394607544,.07242370396852493,.046388447284698486,.007099427282810211,.03942000865936279,.01857360079884529,.019969403743743896,.0462225005030632,.10979831218719482,.06249900162220001,.5952410101890564,.059218067675828934,.04795658588409424,.059218067675828934,.04795658588409424,.01857360079884529,.018409550189971924,.044998399913311005,.10979831218719482,.4374989867210388,.09534800052642822,.06690356880426407,.008966684341430664,.06690356880426407,.008966684341430664,.6874979734420776,.34531301259994507,.017222747206687927,.01918947696685791,.06846341490745544,.008966624736785889,.057993993163108826,.04795658588409424,.032921500504016876,.10979831218719482,.029636148363351822,.019969403743743896,.02364526502788067,.10979831218719482,.029636148363351822,.019969403743743896,.02364526502788067,.10979831218719482,.01326248049736023,.04464298486709595,.12177500128746033,.6835950016975403,.012804049998521805,.04527390003204346,.0372520349919796,.10979831218719482,.0372520349919796,.10979831218719482,.5033249855041504,.3086329698562622,.03230946138501167,.10979831218719482,.03230946138501167,.10979831218719482,.019623063504695892,.032455623149871826,.12873399257659912,.6835910081863403,.06665770709514618,.10979819297790527,.06354992836713791,.07732325792312622,.06354992836713791,.07732325792312622,.06665770709514618,.10979819297790527,.0031109999399632215,.4335930347442627,.06232583895325661,.077323317527771,.04066653922200203,.08043086528778076,.019623063504695892,.030895769596099854,.019623063504695892,.030895769596099854,.0635499358177185,.08043128252029419,.08367279171943665,.018008112907409668,.0635499358177185,.08043128252029419,.07098956406116486,.04795658588409424,.07098956406116486,.04795658588409424,.4375010132789612,.5215610265731812,.04066656902432442,.0773230791091919,.06665772199630737,.047956645488739014,.06665772199630737,.047956645488739014,.04066656902432442,.0773230791091919,.37138599157333374,.0585939884185791,.0235833041369915,.02519160509109497,.05921806022524834,.10979831218719482,.3133150041103363,.27218103408813477,.024563191458582878,.08005183935165405,.024563191458582878,.08005183935165405,.006182555109262466,.014631807804107666,.1068684309720993,.10979831218719482,.08398514240980148,.07732337713241577,.37139201164245605,.4335950016975403,.08398514240980148,.07732337713241577,.1068684309720993,.10979831218719482,.007099427282810211,.04338020086288452,.007099427282810211,.04338020086288452,.02333918772637844,.047576963901519775,.1056443378329277,.07732349634170532,.3787969946861267,.3085930347442627,.018139638006687164,.02645343542098999,.02333918772637844,.047576963901519775,.0558633916079998,.046388328075408936,.1068684458732605,.07732337713241577,.6207290291786194,.4335950016975403,.1068684458732605,.07732337713241577,.0558633916079998,.046388328075408936,.017222747206687927,.02519160509109497,.037558771669864655,.08005297183990479,.08367282897233963,.04560840129852295,.09698063135147095,.08043169975280762,.5630019903182983,.2720860242843628,.09054373949766159,.008966386318206787,.08831693977117538,.047956764698028564,.12188900262117386,.4335950016975403,.08831693977117538,.047956764698028564,.018139630556106567,.03689777851104736,.4375010132789612,.14693796634674072,.09450394660234451,.008966565132141113,.09450394660234451,.008966565132141113,.05055436119437218,.08043122291564941,.012844499200582504,.01937192678451538,.039303116500377655,.008966505527496338,.09264880418777466,.07732337713241577,.7453330159187317,.4335939884185791,.09264880418777466,.07732337713241577,.039303116500377655,.008966505527496338,.019623126834630966,.043863773345947266,.08087734878063202,.08043140172958374,.012844476848840714,.01385188102722168,.08831700682640076,.08043140172958374,.3125010132789612,.5214719772338867,.1875009983778,.3970370292663574,.08954101800918579,.08043140172958374,.08954101800918579,.08043140172958374,.03755873069167137,.0769452452659607,.011493649333715439,.014631807804107666,.07098963111639023,.08043122291564941,.07098963111639023,.08043122291564941,.10554413497447968,.046388864517211914,.10554413497447968,.046388864517211914,.49645400047302246,.4340590238571167,.025983694940805435,.045423686504364014,.05586344376206398,.008966565132141113,.08520916849374771,.04795658588409424,.08520916849374771,.04795658588409424,.5625010132789612,.39734500646591187,.01962309330701828,.007369518280029297,.011493649333715439,.02567189931869507,.04499842971563339,.04795628786087036,.18750199675559998,.6470130085945129,.06354992836713791,.04795616865158081,.08954101800918579,.07732349634170532,.04622248187661171,.04795628786087036,.08954101800918579,.07732349634170532,.04622248187661171,.04795628786087036,.012844499200582504,.026451826095581055,.6875010132789612,.14722901582717896,.024934161454439163,.01444941759109497,.04638303443789482,.008966565132141113,.11262404918670654,.046388864517211914,.6874989867210388,.09525102376937866,.5042709708213806,.4335930347442627,.1112002432346344,.08043169975280762,.08520916849374771,.07732337713241577,.008582878857851028,.043862223625183105,.008582878857851028,.043862223625183105,.01962309330701828,.03737986087799072,.08898389339447021,.008966386318206787,.01962309330701828,.03737986087799072,.09450394660234451,.04638838768005371,.08898389339447021,.008966386318206787,.4963819980621338,.18359601497650146,.01962309330701828,.03737986087799072,.09606381505727768,.046388328075408936,.6216750144958496,.308555006980896,.09698067605495453,.10979819297790527,.09698067605495453,.10979819297790527,.09606381505727768,.046388328075408936,.01962309330701828,.038939714431762695,.5624989867210388,.46984195709228516,.02493416890501976,.0184096097946167,.1112002432346344,.10979825258255005,.1112002432346344,.10979825258255005,.1068684458732605,.04795706272125244,.008582878857851028,.04542207717895508,.25361400842666626,.0585939884185791,.09264880418777466,.10979819297790527,.10997617989778519,.08043175935745239,.10997617989778519,.08043175935745239,.09264880418777466,.10979819297790527,.08502364158630371,.01170814037322998,.06250099837779999,.5219460129737854,.024563191458582878,.07694411277770996,.03200285881757736,.07694464921951294,.024563191458582878,.07694411277770996,.03200285881757736,.07694464921951294,.4374989867210388,.3451380133628845,.10564440488815308,.04795706272125244,.10564440488815308,.04795706272125244,.041890617460012436,.04795628786087036,.041890617460012436,.04795628786087036,.02493416890501976,.019969403743743896,.3125019967556,.14671200513839722,.0795036107301712,.008966624736785889,.11120033264160156,.07732337713241577,.007533404976129532,.01937192678451538,.02598368003964424,.03737974166870117,.37174901366233826,.18359798192977905,.02598368003964424,.03737974166870117,.05034333094954491,.00896763801574707,.11120033264160156,.04795718193054199,.05034333094954491,.00896763801574707,.11120033264160156,.04795718193054199,.04499838873744011,.08043122291564941,.49654099345207214,.058596014976501465,.07965327799320221,.10979831218719482,.023583341389894485,.038159728050231934,.023583341389894485,.038159728050231934,.023583341389894485,.038159728050231934,.06138351559638977,.04638826847076416,.5624989867210388,.09532797336578369,.05488619580864906,.07732349634170532,.007533375173807144,.009891688823699951,.061383482068777084,.008966565132141113,.621508002281189,.058596014976501465,.07221363484859467,.08043122291564941,.025983694940805435,.043863773345947266,.025983694940805435,.043863773345947266,.02450021728873253,.04590564966201782,.07794374972581863,.04638850688934326,.02450021728873253,.04590564966201782,.6215639710426331,.5585950016975403,.10710396617650986,.046388864517211914,.02450021728873253,.04590564966201782,.025983672589063644,.030895769596099854,.05366221442818642,.10979831218719482,.2464359998703003,.3085939884185791,.02767101861536503,.047577083110809326,.02767101861536503,.047577083110809326,.05366221442818642,.10979831218719482,.025983672589063644,.032455503940582275,.025983672589063644,.032455503940582275,.37213099002838135,.5585950016975403,.05488622561097145,.10979831218719482,.08831696212291718,.10979831218719482,.08831696212291718,.10979831218719482,.025983672589063644,.032455503940582275,.007099442183971405,.03689616918563843,.11262404918670654,.00896674394607544,.6286150217056274,.058592021465301514,.007099442183971405,.03689616918563843,.12366431206464767,.046389102935791016,.6875010132789612,.021937012672424316,.06232582405209541,.08043128252029419,.0850236713886261,.017228126525878906,.12366431206464767,.00896763801574707,.12366431206464767,.00896763801574707,.017222747206687927,.04464375972747803,.06846341490745544,.04638838768005371,.06846341490745544,.04638838768005371,.7464879751205444,.30859601497650146,.07532142847776413,.077323317527771,.07532142847776413,.077323317527771,.0850236713886261,.033788442611694336,.06788180023431778,.08043128252029419,.06788180023431778,.08043128252029419,.09264878183603287,.04795682430267334,.6875,.3975909948348999,.1068684309720993,.08043169975280762,.08367282897233963,.04008835554122925,.07242365181446075,.008967041969299316,.07242365181446075,.008967041969299316,.3124989867210388,.4702550172805786,.057993993163108826,.08043110370635986,.2463259994983673,.18359601497650146,.1056443527340889,.10979831218719482,.006182555109262466,.044642090797424316,.11658430099487305,.008967041969299316,.07654549926519394,.04795658588409424,.07654549926519394,.04795658588409424,.11658430099487305,.008967041969299316,.0625,.2718600034713745,.08367279171943665,.029048264026641846,.012844476848840714,.015411734580993652,.4375010132789612,.02183997631072998,.03633471950888634,.0769452452659607,.03633471950888634,.0769452452659607,.07965333014726639,.08043140172958374,.07965333014726639,.08043140172958374,.018139638006687164,.04590564966201782,.37845900654792786,.058592021465301514,.036334652453660965,.047578275203704834,.06690356880426407,.04638850688934326,.018139638006687164,.04590564966201782,.09698062390089035,.07732349634170532,.18749800324440002,.7201740145683289,.06665777415037155,.08043122291564941,.0850236713886261,.03534823656082153,.1874990016222,.47015100717544556,.09387288242578506,.04795682430267334,.09387288242578506,.04795682430267334,.09820473194122314,.07732337713241577,.09820473194122314,.07732337713241577,.08367279171943665,.03456830978393555,.08954101800918579,.10979831218719482,.09820473194122314,.04795682430267334,.12877599895000458,.4335930347442627,.02450018748641014,.032937586307525635,.012844454497098923,.008331894874572754,.08898389339447021,.04638838768005371,.08398512005805969,.08043140172958374,.4374989867210388,.2202489972114563,.18749800324440002,.5951610207557678,.0850236713886261,.018788039684295654,.07221363484859467,.04795658588409424,.12210442870855331,.00896763801574707,.007099363952875137,.03041207790374756,.4969879984855652,.5585939884185791,.0852091833949089,.10979831218719482,.07098958641290665,.07732349634170532,.007099363952875137,.03041207790374756,.0753214880824089,.10979819297790527,.07221363484859467,.07732337713241577,.07221363484859467,.07732337713241577,.24624399840831757,.5585960149765015,.0753214880824089,.10979819297790527,.008582886308431625,.030893981456756592,.008582886308431625,.030893981456756592,.05799401178956032,.07732337713241577,.05799401178956032,.07732337713241577,.6285120248794556,.30859100818634033,.04933030903339386,.047956645488739014,.04933030903339386,.047956645488739014,.01962307095527649,.024411559104919434,.018139563500881195,.0239296555519104,.05055434629321098,.04795658588409424,.057423245161771774,.046388328075408936,.7465599775314331,.5585950016975403,.02023131214082241,.0475764274597168,.1286740005016327,.1835920214653015,.008582886308431625,.032453835010528564,.07654549926519394,.10979831218719482,.02023131214082241,.0475764274597168,.007099427282810211,.03293585777282715,.007099427282810211,.03293585777282715,.019007263705134392,.0475764274597168,.007099427282810211,.03293585777282715,.04933033511042595,.10979831218719482,.0032250001095235348,.6835929751396179,.061973001807928085,.647022008895874,.01900731585919857,.07694333791732788,.02333913929760456,.08005183935165405,.01900731585919857,.07694333791732788,.007533375173807144,.01385188102722168,.05799407511949539,.10979831218719482,.1874990016222,.22021400928497314,.007533375173807144,.015411734580993652,.02023131214082241,.07694333791732788,.6296669840812683,.4335930347442627,.06788180023431778,.10979831218719482,.04482320323586464,.04638856649398804,.018139563500881195,.032937586307525635,.018139563500881195,.032937586307525635,.018139563500881195,.032937586307525635,.1875009983778,.14697301387786865,.0850236713886261,.03930848836898804,.1056443378329277,.08043169975280762,.1056443378329277,.08043169975280762,.07654549926519394,.08043128252029419,.07654549926519394,.08043128252029419,.0850236713886261,.04638838768005371,.07221363484859467,.10979831218719482,.07221363484859467,.10979831218719482,.09820473194122314,.08043169975280762,.09820473194122314,.08043169975280762,.5625010132789612,.02186000347137451,.044998399913311005,.0773230791091919,.09698063135147095,.04795682430267334,.023583319038152695,.031675636768341064,.044998399913311005,.0773230791091919,.09698063135147095,.04795682430267334,.24626600742340088,.6835960149765015,.023583319038152695,.031675636768341064,.0850236713886261,.044828593730926514,.437734991312027,.46996796131134033,.036334652453660965,.08005297183990479,.036334652453660965,.08005297183990479,.07098956406116486,.10979831218719482,.006182555109262466,.031673967838287354,.05055436119437218,.10979831218719482,.3786180019378662,.1835920214653015,.08398512005805969,.10979831218719482,.08398512005805969,.10979831218719482,.05055436119437218,.10979831218719482,.03930313140153885,.04638850688934326,.04482320323586464,.008966565132141113,.04482320323586464,.008966565132141113,.6875,.4695960283279419,.02358332648873329,.013669490814208984,.04086293280124664,.04638850688934326,.04086293280124664,.04638850688934326,.024934161454439163,.012889564037322998,.0625,.3453270196914673,.11106422543525696,.04638880491256714,.018139638006687164,.04338186979293823,.018139638006687164,.04338186979293823,.07654549926519394,.07732349634170532,.04086294770240784,.008966505527496338,.0034920000471174717,.3085939884185791,.018139638006687164,.04338186979293823,.007533375173807144,.008331894874572754,.6874989867210388,.21995800733566284,.05366221442818642,.07732349634170532,.028895026072859764,.07694411277770996,.05366221442818642,.07732349634170532,.028895026072859764,.07694411277770996,.06294332444667816,.04638826847076416,.1875,.34528303146362305,.027670973911881447,.07694411277770996,.006182555109262466,.009111762046813965,.07398355007171631,.04638838768005371,.12210451066493988,.046389102935791016,.12210451066493988,.046389102935791016,.12875600159168243,.5585910081863403,.07398355007171631,.04638838768005371,.006182555109262466,.03815799951553345,.06250099837779999,.39662301540374756,.0905437171459198,.04638838768005371,.040666673332452774,.10979831218719482,.040666673332452774,.10979831218719482,.0905437171459198,.04638838768005371,.012844454497098923,.009891688823699951,.011493615806102753,.009111762046813965,.4374989867210388,.5956270098686218,.08520913124084473,.08043140172958374,.08520913124084473,.08043140172958374,.04189063608646393,.10979831218719482,.008582908660173416,.03893798589706421,.11814413964748383,.04638892412185669,.6284400224685669,.5585929751396179,.10158386081457138,.00896674394607544,.10158386081457138,.00896674394607544,.11814413964748383,.04638892412185669,.06232590600848198,.10979831218719482,.04638301953673363,.04638856649398804,.04638301953673363,.04638856649398804,.7463849782943726,.058596014976501465,.06232590600848198,.10979831218719482,.01722273975610733,.031675636768341064,.04189063608646393,.08043086528778076,.04189063608646393,.08043086528778076,.0635499358177185,.10979831218719482,.3780120015144348,.5585929751396179,.018139611929655075,.030413687229156494,.018139611929655075,.030413687229156494,.017222747206687927,.038159728050231934,.08954101800918579,.047956764698028564,.7459149956703186,.18359500169754028,.05366213247179985,.04795628786087036,.017222747206687927,.038159728050231934,.023583341389894485,.04464375972747803,.25325098633766174,.18358999490737915,.0795036107301712,.04638838768005371,.10253656655550003,.08043175935745239,.10253656655550003,.08043175935745239,.0795036107301712,.04638838768005371,.08087733387947083,.07732349634170532,.10710396617650986,.008966803550720215,.10710396617650986,.008966803550720215,.5624989867210388,.5953620076179504,.01962309330701828,.014449357986450195,.025983653962612152,.02597147226333618,.025983653962612152,.02597147226333618,.10131251811981201,.04795682430267334,.5034360289573669,.5585929751396179,.08087733387947083,.04795646667480469,.08087733387947083,.04795646667480469,.10131251811981201,.04795682430267334,.37854599952697754,.4331200122833252,.01326248049736023,.04590487480163574,.019313467666506767,.08005118370056152,.03664000332355499,.10979831218719482,.019313467666506767,.08005118370056152,.029636148363351822,.018707633018493652,.25348299741744995,.3081200122833252,.02889440953731537,.019728541374206543,.024257240816950798,.10979831218719482,.02797701396048069,.10979831218719482,.02797701396048069,.10979831218719482,.02889440953731537,.01894855499267578,.028589049354195595,.10979831218719482,.621649980545044,.18359601497650146,.02889440953731537,.01894855499267578,.019925372675061226,.08005118370056152,.561972975730896,.22008800506591797,.02889503724873066,.08005237579345703,.02889503724873066,.08005237579345703,.007533404976129532,.02645176649093628,.06788178533315659,.07732349634170532,.06788178533315659,.07732349634170532,.007533404976129532,.024891972541809082,.06665770709514618,.07732349634170532,.3125,.0952489972114563,.09264882653951645,.08043169975280762,.0036299999337643385,.5585929751396179,.04622241482138634,.08043122291564941,.03200281038880348,.047577738761901855,.024500224739313126,.03942161798477173,.12137000262737274,.5585950016975403,.024563191458582878,.047576963901519775,.059218067675828934,.07732349634170532,.01962307095527649,.025971412658691406],normalized:!1}},index:{type:"Uint16Array",array:[28,234,182,303,269,285,521,391,482,142,593,355,209,84,89,440,512,467,168,146,454,320,118,222,535,280,109,40,32,563,488,479,398,419,273,186,541,74,78,326,69,331,240,435,295,473,26,178,626,53,309,51,436,448,96,97,103,255,422,45,5,618,615,65,508,264,284,376,373,315,160,632,550,126,237,254,61,366,499,344,348,165,408,414,557,201,576,506,431,365,329,95,140,145,406,36,578,572,486,16,302,296,72,59,68,158,163,169,177,179,603,62,594,0,393,48,489,352,350,76,543,346,534,378,197,437,528,417,42,480,477,212,613,173,607,230,223,635,595,102,111,555,432,556,494,507,232,86,289,218,314,121,100,244,30,27,407,252,259,304,55,325,157,147,374,396,11,154,14,270,41,271,279,122,330,129,341,522,281,525,624,82,621,427,421,387,199,447,438,495,260,511,80,313,85,573,552,560,501,426,429,43,410,258,187,389,420,248,424,390,493,445,465,347,540,77,411,131,251,462,474,481,12,565,155,150,283,372,490,217,392,587,71,66,386,402,144,161,453,634,58,363,367,94,597,141,277,238,125,3,600,8,136,319,98,300,498,233,17,538,345,324,202,115,394,548,49,318,220,119,33,456,143,335,56,128,39,225,460,91,336,134,198,567,575,361,537,107,383,166,416,404,562,35,189,123,192,211,174,610,116,101,120,208,397,478,515,559,434,226,321,221,306,311,54,620,612,614,369,257,253,291,554,235,139,586,327,245,524,531,268,216,287,569,520,484,23,513,243,622,204,625,1,604,64,545,379,439,592,263,356,509,181,231,25,184,172,297,242,293,503,276,272,405,526,151,159,337,164,28,298,234,303,227,269,521,247,391,142,598,593,209,608,84,468,464,451,450,444,470,168,384,146,320,117,118,535,581,280,40,461,32,488,463,479,419,505,273,541,360,74,326,585,69,240,514,435,473,472,26,626,206,53,51,547,436,96,137,97,255,430,422,5,10,618,65,602,508,284,570,376,315,628,160,550,191,126,254,130,61,499,18,344,165,338,408,557,441,201,358,106,364,110,502,370,185,195,487,194,577,485,239,583,292,579,21,290,79,584,357,354,265,351,46,250,529,533,381,413,616,609,175,457,458,635,458,230,635,112,207,9,6,596,113,219,400,90,87,308,288,371,549,152,153,561,148,396,215,11,631,135,342,132,332,340,200,443,446,496,349,261,81,627,310,574,193,553,504,418,425,47,415,409,190,483,388,246,44,423,492,50,449,347,343,540,412,339,127,466,469,476,15,38,564,150,527,283,491,399,213,588,75,70,385,530,403,162,171,452,60,73,359,93,105,601,275,580,236,2,590,599,133,630,317,299,19,497,20,582,536,323,52,205,395,156,544,316,633,224,34,459,455,333,67,57,37,266,229,92,328,334,196,377,571,362,542,539,382,170,167,401,149,566,188,274,124,210,475,176,114,104,99,208,88,397,516,442,558,228,307,322,305,286,312,619,83,611,368,428,256,294,433,551,138,353,589,249,518,523,267,13,214,568,282,519,22,471,517,623,7,203,4,617,606,546,375,380,591,63,262,510,605,180,24,31,183,301,29,241,500,108,278,405,532,526,159,629,337]},boundingSphere:{center:[0,0,-762939453125e-17],radius:160.50603975869993}},rotationCombinations:{"1,2":[-58,-18,-148],"1,3":[122,-18,32],"1,4":[-159,30,-69],"1,5":[21,150,-69],"1,6":[21,-30,69],"1,7":[0,90,-90],"1,8":[122,18,-32],"1,9":[-58,126,32],"1,10":[58,54,148],"1,11":[-122,-18,-32],"1,12":[159,30,69],"1,13":[58,54,-32],"1,14":[-58,54,32],"1,15":[90,0,90],"1,16":[-90,0,-90],"1,17":[122,54,32],"1,18":[-122,54,-32],"1,19":[-21,30,69],"1,20":[58,-18,-32],"1,21":[58,126,-32],"1,22":[-58,54,-148],"1,23":[-58,18,-32],"1,24":[0,90,90],"1,25":[-21,30,-111],"1,26":[21,30,111],"1,27":[-21,-150,-69],"1,28":[-58,-18,32],"1,29":[58,18,32],"1,30":[-180,0,0],"2,3":[-21,150,69],"2,4":[-58,-126,-32],"2,5":[122,-54,-32],"2,6":[-58,54,-148],"2,7":[-122,-54,32],"2,8":[0,-180,0],"2,9":[-159,-30,69],"2,10":[-122,-18,-32],"2,11":[58,-18,148],"2,12":[159,-30,-69],"2,13":[58,-162,-32],"2,14":[-58,-54,148],"2,15":[-159,30,-69],"2,16":[21,-30,69],"2,17":[21,-150,69],"2,18":[0,-90,90],"2,19":[-58,-18,-148],"2,20":[58,126,-32],"2,21":[0,-90,-90],"2,22":[-58,-54,-32],"2,23":[-21,-30,111],"2,24":[58,-126,32],"2,25":[-58,-18,32],"2,26":[-90,0,-90],"2,27":[122,18,-32],"2,28":[0,0,-180],"2,29":[58,162,32],"2,30":[-58,-162,32],"3,4":[90,0,-90],"3,5":[90,0,90],"3,6":[-90,0,90],"3,7":[122,54,32],"3,8":[21,30,-69],"3,9":[58,54,148],"3,10":[0,90,90],"3,11":[122,-54,-32],"3,12":[58,18,32],"3,13":[0,90,-90],"3,14":[159,30,69],"3,15":[-21,30,69],"3,16":[159,-30,-69],"3,17":[58,54,-32],"3,18":[122,18,-32],"3,19":[21,150,-69],"3,20":[-58,18,-32],"3,21":[-58,162,-32],"3,22":[-21,150,69],"3,23":[180,0,0],"3,24":[-58,126,32],"3,25":[-159,30,-69],"3,26":[58,126,-32],"3,27":[21,-30,69],"3,28":[-159,-30,69],"3,29":[-58,54,32],"3,30":[58,-18,-32],"4,5":[0,0,180],"4,6":[180,0,0],"4,7":[-58,18,148],"4,8":[-58,-54,-32],"4,9":[-58,-18,-148],"4,10":[-90,0,90],"4,11":[58,18,32],"4,12":[-21,-30,111],"4,13":[-90,0,-90],"4,14":[-58,54,-148],"4,15":[-122,-54,32],"4,16":[58,54,-32],"4,17":[-58,-18,32],"4,18":[-21,30,69],"4,19":[-122,54,-32],"4,20":[21,-150,69],"4,21":[-21,30,-111],"4,22":[-58,54,32],"4,23":[0,90,90],"4,24":[-58,18,-32],"4,25":[58,126,-32],"4,26":[-122,18,32],"4,27":[58,-54,-148],"4,28":[122,54,32],"4,29":[-122,-18,-32],"4,30":[21,-30,69],"5,6":[0,180,0],"5,7":[58,-18,-32],"5,8":[58,54,148],"5,9":[58,18,32],"5,10":[90,0,-90],"5,11":[-58,-18,-148],"5,12":[21,30,-69],"5,13":[90,0,90],"5,14":[58,-54,32],"5,15":[-58,126,32],"5,16":[-58,-54,148],"5,17":[58,18,-148],"5,18":[21,-30,-111],"5,19":[-58,-126,-32],"5,20":[159,30,69],"5,21":[21,-30,69],"5,22":[58,-54,-148],"5,23":[0,-90,-90],"5,24":[58,-18,148],"5,25":[122,-54,-32],"5,26":[-58,-162,32],"5,27":[-58,54,32],"5,28":[58,-126,32],"5,29":[-58,162,-32],"5,30":[-21,30,-111],"6,7":[-58,162,-32],"6,8":[122,-54,-32],"6,9":[-58,-162,32],"6,10":[90,0,90],"6,11":[-122,18,32],"6,12":[-21,-150,-69],"6,13":[90,0,-90],"6,14":[-58,126,32],"6,15":[58,-54,32],"6,16":[-122,54,-32],"6,17":[122,-18,32],"6,18":[159,30,69],"6,19":[58,54,-32],"6,20":[21,-30,-111],"6,21":[-21,150,69],"6,22":[122,54,32],"6,23":[0,90,-90],"6,24":[122,18,-32],"6,25":[58,54,148],"6,26":[58,18,32],"6,27":[58,-126,32],"6,28":[-58,54,32],"6,29":[58,-18,-32],"6,30":[-159,-30,69],"7,8":[-58,54,-148],"7,9":[-21,30,69],"7,10":[21,30,-69],"7,11":[58,-126,32],"7,12":[-58,18,-32],"7,13":[21,30,111],"7,14":[21,-30,69],"7,15":[0,90,-90],"7,16":[0,-90,-90],"7,17":[-21,30,-111],"7,18":[-21,-30,-69],"7,19":[58,-18,148],"7,20":[122,54,32],"7,21":[-21,-30,111],"7,22":[21,-30,-111],"7,23":[58,-54,32],"7,24":[0,0,180],"7,25":[58,-18,-32],"7,26":[58,18,-148],"7,27":[-122,18,32],"7,28":[-58,-126,-32],"7,29":[58,54,148],"7,30":[-90,0,-90],"8,9":[-21,30,-111],"8,10":[-58,18,148],"8,11":[122,18,-32],"8,12":[21,30,111],"8,13":[-58,18,-32],"8,14":[-122,54,-32],"8,15":[-21,-30,111],"8,16":[-21,150,69],"8,17":[-21,30,69],"8,18":[0,90,90],"8,19":[-122,18,32],"8,20":[-58,-54,-32],"8,21":[0,90,-90],"8,22":[58,126,-32],"8,23":[-159,30,-69],"8,24":[-58,54,32],"8,25":[58,162,32],"8,26":[-90,0,90],"8,27":[58,-18,148],"8,28":[180,0,0],"8,29":[-58,-18,32],"8,30":[58,18,32],"9,10":[21,-30,-111],"9,11":[58,162,32],"9,12":[-21,30,-111],"9,13":[21,-30,69],"9,14":[-58,-54,-32],"9,15":[58,18,-148],"9,16":[58,-162,-32],"9,17":[0,0,-180],"9,18":[-58,-18,-148],"9,19":[0,-90,90],"9,20":[90,0,90],"9,21":[-58,-18,32],"9,22":[-58,-54,148],"9,23":[58,-126,32],"9,24":[-21,-30,111],"9,25":[0,-90,-90],"9,26":[58,-54,-148],"9,27":[0,90,-90],"9,28":[21,-150,69],"9,29":[58,-18,148],"9,30":[-58,54,-148],"10,11":[-21,-150,-69],"10,12":[-58,-54,-32],"10,13":[0,0,180],"10,14":[58,-18,148],"10,15":[-58,18,-32],"10,16":[122,-18,32],"10,17":[-21,-30,-69],"10,18":[58,-54,32],"10,19":[58,18,-148],"10,20":[-58,54,-148],"10,21":[58,-54,-148],"10,22":[58,-18,-32],"10,23":[90,0,90],"10,24":[21,-30,-111],"10,25":[58,18,32],"10,26":[21,30,-69],"10,27":[-122,-18,-32],"10,28":[-58,162,-32],"10,29":[-21,30,-111],"10,30":[58,-126,32],"11,12":[-90,0,90],"11,13":[-159,30,-69],"11,14":[0,90,90],"11,15":[-159,-30,69],"11,16":[21,30,-69],"11,17":[-122,18,32],"11,18":[-58,54,32],"11,19":[122,54,32],"11,20":[159,-30,-69],"11,21":[-58,54,-148],"11,22":[0,90,-90],"11,23":[58,54,-32],"11,24":[-122,54,-32],"11,25":[-58,126,32],"11,26":[159,30,69],"11,27":[-58,-54,148],"11,28":[58,18,32],"11,29":[-180,0,0],"11,30":[-58,-18,32],"12,13":[58,54,148],"12,14":[90,0,90],"12,15":[-58,54,32],"12,16":[122,-54,-32],"12,17":[21,30,-69],"12,18":[58,-18,-32],"12,19":[-58,162,-32],"12,20":[-122,54,-32],"12,21":[58,-18,148],"12,22":[90,0,-90],"12,23":[122,-18,32],"12,24":[58,18,-148],"12,25":[122,18,-32],"12,26":[-58,126,32],"12,27":[-58,-18,32],"12,28":[-21,-150,-69],"12,29":[0,90,-90],"12,30":[-21,-30,-69],"13,14":[-58,18,-32],"13,15":[58,-18,148],"13,16":[58,162,32],"13,17":[21,30,111],"13,18":[-58,54,-148],"13,19":[-58,-18,32],"13,20":[58,-54,32],"13,21":[-58,54,32],"13,22":[-58,18,148],"13,23":[-90,0,-90],"13,24":[-21,30,69],"13,25":[-58,-18,-148],"13,26":[-21,-30,111],"13,27":[-58,162,-32],"13,28":[-122,-18,-32],"13,29":[21,-30,69],"13,30":[122,54,32],"14,15":[-58,162,-32],"14,16":[-58,-18,-148],"14,17":[58,54,148],"14,18":[-21,30,-111],"14,19":[21,-30,69],"14,20":[122,-18,32],"14,21":[-21,30,69],"14,22":[0,0,180],"14,23":[-21,-30,-69],"14,24":[21,30,111],"14,25":[21,-30,-111],"14,26":[58,-18,148],"14,27":[21,150,-69],"14,28":[-58,-54,-32],"14,29":[90,0,90],"14,30":[-122,54,-32],"15,16":[180,0,0],"15,17":[58,-18,-32],"15,18":[122,-18,32],"15,19":[-58,126,32],"15,20":[-21,30,-111],"15,21":[-58,-162,32],"15,22":[122,18,-32],"15,23":[159,30,69],"15,24":[90,0,-90],"15,25":[122,54,32],"15,26":[58,54,-32],"15,27":[-58,-54,-32],"15,28":[21,150,-69],"15,29":[21,30,-69],"15,30":[0,-90,-90],"16,17":[-122,-18,-32],"16,18":[-58,-18,32],"16,19":[-58,54,-148],"16,20":[-21,150,69],"16,21":[-58,-18,-148],"16,22":[-58,18,-32],"16,23":[-21,30,69],"16,24":[-90,0,-90],"16,25":[-58,54,32],"16,26":[-122,54,-32],"16,27":[122,-54,-32],"16,28":[21,30,111],"16,29":[-159,30,-69],"16,30":[0,-90,90],"17,18":[58,18,32],"17,19":[0,90,-90],"17,20":[-90,0,-90],"17,21":[58,18,-148],"17,22":[58,54,-32],"17,23":[122,54,32],"17,24":[21,30,-69],"17,25":[0,90,90],"17,26":[-58,54,32],"17,27":[0,-90,90],"17,28":[159,30,69],"17,29":[-58,18,-32],"17,30":[58,-54,32],"18,19":[58,54,148],"18,20":[-159,30,-69],"18,21":[0,0,-180],"18,22":[21,30,-69],"18,23":[58,18,32],"18,24":[-21,30,-111],"18,25":[58,54,-32],"18,26":[0,90,-90],"18,27":[-122,-54,32],"18,28":[90,0,90],"18,29":[-122,54,-32],"18,30":[-58,-54,-32],"19,20":[0,-90,-90],"19,21":[58,54,-32],"19,22":[21,30,111],"19,23":[-21,30,-111],"19,24":[58,18,32],"19,25":[0,0,180],"19,26":[21,-30,69],"19,27":[0,180,0],"19,28":[-58,18,-32],"19,29":[58,-54,32],"19,30":[159,30,69],"20,21":[21,150,-69],"20,22":[58,162,32],"20,23":[-122,-18,-32],"20,24":[58,126,-32],"20,25":[-90,0,-90],"20,26":[-58,18,148],"20,27":[90,0,90],"20,28":[-122,-54,32],"20,29":[-21,30,69],"20,30":[122,18,-32],"21,22":[-21,-30,111],"21,23":[-58,-18,-148],"21,24":[21,-30,69],"21,25":[-58,-54,148],"21,26":[0,-90,90],"21,27":[-58,126,32],"21,28":[-90,0,-90],"21,29":[-58,-126,-32],"21,30":[58,54,148],"22,23":[21,30,111],"22,24":[-21,-30,-69],"22,25":[-21,30,69],"22,26":[-58,18,-32],"22,27":[159,-30,-69],"22,28":[58,54,148],"22,29":[-90,0,-90],"22,30":[-58,-126,-32],"23,24":[-58,54,-148],"23,25":[21,30,-69],"23,26":[58,54,148],"23,27":[-159,-30,69],"23,28":[21,-30,69],"23,29":[122,54,32],"23,30":[-122,-18,-32],"24,25":[-58,18,148],"24,26":[-58,-18,32],"24,27":[-58,-162,32],"24,28":[-122,54,-32],"24,29":[-58,-54,-32],"24,30":[90,0,90],"25,26":[-21,30,-111],"25,27":[-180,0,0],"25,28":[58,-18,148],"25,29":[-58,54,-148],"25,30":[21,-150,69],"26,27":[21,-150,69],"26,28":[0,90,-90],"26,29":[-21,-30,-69],"26,30":[-21,-150,-69],"27,28":[58,-162,-32],"27,29":[-58,126,32],"27,30":[21,-30,-111],"28,29":[122,-18,32],"28,30":[-122,18,32],"29,30":[122,-18,32]}}},u="172",p=0,m=1,g=2,y=100,v=101,x=102,b=200,_=201,S=202,M=203,w=204,T=205,E=206,A=207,C=208,P=209,R=210,I=211,D=212,L=213,N=214,O=0,U=1,B=2,z=3,V=4,k=5,G=6,H=7,W="attached",j=301,X=302,q=306,Y=1e3,Z=1001,K=1002,Q=1003,J=1004,ee=1005,te=1006,ie=1007,ne=1008,re=1009,se=1010,ae=1011,oe=1012,le=1013,ce=1014,he=1015,de=1016,ue=1017,pe=1018,me=1020,fe=35902,ge=1023,ye=1026,ve=1027,xe=1028,be=1029,_e=1031,Se=1033,Me=33776,we=33777,Te=33778,Ee=33779,Ae=35840,Ce=35841,Pe=35842,Re=35843,Ie=36196,De=37492,Le=37496,Fe=37808,Ne=37809,Oe=37810,Ue=37811,Be=37812,ze=37813,Ve=37814,ke=37815,Ge=37816,He=37817,We=37818,je=37819,Xe=37820,qe=37821,Ye=36492,Ze=36494,Ke=36495,Qe=36284,Je=36285,$e=36286,et=2300,tt=2301,it=2302,nt=2400,rt=2401,st=2402,at=2500,ot="",lt="srgb",ct="srgb-linear",ht="linear",dt="srgb",ut=7680,pt=512,mt=513,ft=514,gt=515,yt=516,vt=517,xt=518,bt=519,_t=35044,St="300 es",Mt=2e3,wt=2001;
/**
 * @license
 * Copyright 2010-2024 Three.js Authors
 * SPDX-License-Identifier: MIT
 */let Tt=class EventDispatcher{addEventListener(t,i){void 0===this._listeners&&(this._listeners={});const r=this._listeners;void 0===r[t]&&(r[t]=[]),-1===r[t].indexOf(i)&&r[t].push(i)}hasEventListener(t,i){if(void 0===this._listeners)return!1;const r=this._listeners;return void 0!==r[t]&&-1!==r[t].indexOf(i)}removeEventListener(t,i){if(void 0===this._listeners)return;const r=this._listeners[t];if(void 0!==r){const t=r.indexOf(i);-1!==t&&r.splice(t,1)}}dispatchEvent(t){if(void 0===this._listeners)return;const i=this._listeners[t.type];if(void 0!==i){t.target=this;const r=i.slice(0);for(let i=0,a=r.length;i<a;i++)r[i].call(this,t);t.target=null}}};const Et=["00","01","02","03","04","05","06","07","08","09","0a","0b","0c","0d","0e","0f","10","11","12","13","14","15","16","17","18","19","1a","1b","1c","1d","1e","1f","20","21","22","23","24","25","26","27","28","29","2a","2b","2c","2d","2e","2f","30","31","32","33","34","35","36","37","38","39","3a","3b","3c","3d","3e","3f","40","41","42","43","44","45","46","47","48","49","4a","4b","4c","4d","4e","4f","50","51","52","53","54","55","56","57","58","59","5a","5b","5c","5d","5e","5f","60","61","62","63","64","65","66","67","68","69","6a","6b","6c","6d","6e","6f","70","71","72","73","74","75","76","77","78","79","7a","7b","7c","7d","7e","7f","80","81","82","83","84","85","86","87","88","89","8a","8b","8c","8d","8e","8f","90","91","92","93","94","95","96","97","98","99","9a","9b","9c","9d","9e","9f","a0","a1","a2","a3","a4","a5","a6","a7","a8","a9","aa","ab","ac","ad","ae","af","b0","b1","b2","b3","b4","b5","b6","b7","b8","b9","ba","bb","bc","bd","be","bf","c0","c1","c2","c3","c4","c5","c6","c7","c8","c9","ca","cb","cc","cd","ce","cf","d0","d1","d2","d3","d4","d5","d6","d7","d8","d9","da","db","dc","dd","de","df","e0","e1","e2","e3","e4","e5","e6","e7","e8","e9","ea","eb","ec","ed","ee","ef","f0","f1","f2","f3","f4","f5","f6","f7","f8","f9","fa","fb","fc","fd","fe","ff"];let At=1234567;const Ct=Math.PI/180,Pt=180/Math.PI;function generateUUID(){const t=4294967295*Math.random()|0,i=4294967295*Math.random()|0,r=4294967295*Math.random()|0,a=4294967295*Math.random()|0;return(Et[255&t]+Et[t>>8&255]+Et[t>>16&255]+Et[t>>24&255]+"-"+Et[255&i]+Et[i>>8&255]+"-"+Et[i>>16&15|64]+Et[i>>24&255]+"-"+Et[63&r|128]+Et[r>>8&255]+"-"+Et[r>>16&255]+Et[r>>24&255]+Et[255&a]+Et[a>>8&255]+Et[a>>16&255]+Et[a>>24&255]).toLowerCase()}function clamp(t,i,r){return Math.max(i,Math.min(r,t))}function euclideanModulo(t,i){return(t%i+i)%i}function lerp(t,i,r){return(1-r)*t+r*i}function denormalize(t,i){switch(i.constructor){case Float32Array:return t;case Uint32Array:return t/4294967295;case Uint16Array:return t/65535;case Uint8Array:return t/255;case Int32Array:return Math.max(t/2147483647,-1);case Int16Array:return Math.max(t/32767,-1);case Int8Array:return Math.max(t/127,-1);default:throw new Error("Invalid component type.")}}function normalize(t,i){switch(i.constructor){case Float32Array:return t;case Uint32Array:return Math.round(4294967295*t);case Uint16Array:return Math.round(65535*t);case Uint8Array:return Math.round(255*t);case Int32Array:return Math.round(2147483647*t);case Int16Array:return Math.round(32767*t);case Int8Array:return Math.round(127*t);default:throw new Error("Invalid component type.")}}const Rt={DEG2RAD:Ct,RAD2DEG:Pt,generateUUID,clamp,euclideanModulo,mapLinear:function mapLinear(t,i,r,a,o){return a+(t-i)*(o-a)/(r-i)},inverseLerp:function inverseLerp(t,i,r){return t!==i?(r-t)/(i-t):0},lerp,damp:function damp(t,i,r,a){return lerp(t,i,1-Math.exp(-r*a))},pingpong:function pingpong(t,i=1){return i-Math.abs(euclideanModulo(t,2*i)-i)},smoothstep:function smoothstep(t,i,r){return t<=i?0:t>=r?1:(t=(t-i)/(r-i))*t*(3-2*t)},smootherstep:function smootherstep(t,i,r){return t<=i?0:t>=r?1:(t=(t-i)/(r-i))*t*t*(t*(6*t-15)+10)},randInt:function randInt(t,i){return t+Math.floor(Math.random()*(i-t+1))},randFloat:function randFloat(t,i){return t+Math.random()*(i-t)},randFloatSpread:function randFloatSpread(t){return t*(.5-Math.random())},seededRandom:function seededRandom(t){void 0!==t&&(At=t);let i=At+=1831565813;return i=Math.imul(i^i>>>15,1|i),i^=i+Math.imul(i^i>>>7,61|i),((i^i>>>14)>>>0)/4294967296},degToRad:function degToRad(t){return t*Ct},radToDeg:function radToDeg(t){return t*Pt},isPowerOfTwo:function isPowerOfTwo(t){return!(t&t-1)&&0!==t},ceilPowerOfTwo:function ceilPowerOfTwo(t){return Math.pow(2,Math.ceil(Math.log(t)/Math.LN2))},floorPowerOfTwo:function floorPowerOfTwo(t){return Math.pow(2,Math.floor(Math.log(t)/Math.LN2))},setQuaternionFromProperEuler:function setQuaternionFromProperEuler(t,i,r,a,o){const l=Math.cos,c=Math.sin,h=l(r/2),d=c(r/2),u=l((i+a)/2),p=c((i+a)/2),m=l((i-a)/2),g=c((i-a)/2),y=l((a-i)/2),v=c((a-i)/2);switch(o){case"XYX":t.set(h*p,d*m,d*g,h*u);break;case"YZY":t.set(d*g,h*p,d*m,h*u);break;case"ZXZ":t.set(d*m,d*g,h*p,h*u);break;case"XZX":t.set(h*p,d*v,d*y,h*u);break;case"YXY":t.set(d*y,h*p,d*v,h*u);break;case"ZYZ":t.set(d*v,d*y,h*p,h*u)}},normalize,denormalize};class Vector2{constructor(t=0,i=0){Vector2.prototype.isVector2=!0,this.x=t,this.y=i}get width(){return this.x}set width(t){this.x=t}get height(){return this.y}set height(t){this.y=t}set(t,i){return this.x=t,this.y=i,this}setScalar(t){return this.x=t,this.y=t,this}setX(t){return this.x=t,this}setY(t){return this.y=t,this}setComponent(t,i){switch(t){case 0:this.x=i;break;case 1:this.y=i;break;default:throw new Error("index is out of range: "+t)}return this}getComponent(t){switch(t){case 0:return this.x;case 1:return this.y;default:throw new Error("index is out of range: "+t)}}clone(){return new this.constructor(this.x,this.y)}copy(t){return this.x=t.x,this.y=t.y,this}add(t){return this.x+=t.x,this.y+=t.y,this}addScalar(t){return this.x+=t,this.y+=t,this}addVectors(t,i){return this.x=t.x+i.x,this.y=t.y+i.y,this}addScaledVector(t,i){return this.x+=t.x*i,this.y+=t.y*i,this}sub(t){return this.x-=t.x,this.y-=t.y,this}subScalar(t){return this.x-=t,this.y-=t,this}subVectors(t,i){return this.x=t.x-i.x,this.y=t.y-i.y,this}multiply(t){return this.x*=t.x,this.y*=t.y,this}multiplyScalar(t){return this.x*=t,this.y*=t,this}divide(t){return this.x/=t.x,this.y/=t.y,this}divideScalar(t){return this.multiplyScalar(1/t)}applyMatrix3(t){const i=this.x,r=this.y,a=t.elements;return this.x=a[0]*i+a[3]*r+a[6],this.y=a[1]*i+a[4]*r+a[7],this}min(t){return this.x=Math.min(this.x,t.x),this.y=Math.min(this.y,t.y),this}max(t){return this.x=Math.max(this.x,t.x),this.y=Math.max(this.y,t.y),this}clamp(t,i){return this.x=clamp(this.x,t.x,i.x),this.y=clamp(this.y,t.y,i.y),this}clampScalar(t,i){return this.x=clamp(this.x,t,i),this.y=clamp(this.y,t,i),this}clampLength(t,i){const r=this.length();return this.divideScalar(r||1).multiplyScalar(clamp(r,t,i))}floor(){return this.x=Math.floor(this.x),this.y=Math.floor(this.y),this}ceil(){return this.x=Math.ceil(this.x),this.y=Math.ceil(this.y),this}round(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this}roundToZero(){return this.x=Math.trunc(this.x),this.y=Math.trunc(this.y),this}negate(){return this.x=-this.x,this.y=-this.y,this}dot(t){return this.x*t.x+this.y*t.y}cross(t){return this.x*t.y-this.y*t.x}lengthSq(){return this.x*this.x+this.y*this.y}length(){return Math.sqrt(this.x*this.x+this.y*this.y)}manhattanLength(){return Math.abs(this.x)+Math.abs(this.y)}normalize(){return this.divideScalar(this.length()||1)}angle(){return Math.atan2(-this.y,-this.x)+Math.PI}angleTo(t){const i=Math.sqrt(this.lengthSq()*t.lengthSq());if(0===i)return Math.PI/2;const r=this.dot(t)/i;return Math.acos(clamp(r,-1,1))}distanceTo(t){return Math.sqrt(this.distanceToSquared(t))}distanceToSquared(t){const i=this.x-t.x,r=this.y-t.y;return i*i+r*r}manhattanDistanceTo(t){return Math.abs(this.x-t.x)+Math.abs(this.y-t.y)}setLength(t){return this.normalize().multiplyScalar(t)}lerp(t,i){return this.x+=(t.x-this.x)*i,this.y+=(t.y-this.y)*i,this}lerpVectors(t,i,r){return this.x=t.x+(i.x-t.x)*r,this.y=t.y+(i.y-t.y)*r,this}equals(t){return t.x===this.x&&t.y===this.y}fromArray(t,i=0){return this.x=t[i],this.y=t[i+1],this}toArray(t=[],i=0){return t[i]=this.x,t[i+1]=this.y,t}fromBufferAttribute(t,i){return this.x=t.getX(i),this.y=t.getY(i),this}rotateAround(t,i){const r=Math.cos(i),a=Math.sin(i),o=this.x-t.x,l=this.y-t.y;return this.x=o*r-l*a+t.x,this.y=o*a+l*r+t.y,this}random(){return this.x=Math.random(),this.y=Math.random(),this}*[Symbol.iterator](){yield this.x,yield this.y}}class Matrix3{constructor(t,i,r,a,o,l,c,h,d){Matrix3.prototype.isMatrix3=!0,this.elements=[1,0,0,0,1,0,0,0,1],void 0!==t&&this.set(t,i,r,a,o,l,c,h,d)}set(t,i,r,a,o,l,c,h,d){const u=this.elements;return u[0]=t,u[1]=a,u[2]=c,u[3]=i,u[4]=o,u[5]=h,u[6]=r,u[7]=l,u[8]=d,this}identity(){return this.set(1,0,0,0,1,0,0,0,1),this}copy(t){const i=this.elements,r=t.elements;return i[0]=r[0],i[1]=r[1],i[2]=r[2],i[3]=r[3],i[4]=r[4],i[5]=r[5],i[6]=r[6],i[7]=r[7],i[8]=r[8],this}extractBasis(t,i,r){return t.setFromMatrix3Column(this,0),i.setFromMatrix3Column(this,1),r.setFromMatrix3Column(this,2),this}setFromMatrix4(t){const i=t.elements;return this.set(i[0],i[4],i[8],i[1],i[5],i[9],i[2],i[6],i[10]),this}multiply(t){return this.multiplyMatrices(this,t)}premultiply(t){return this.multiplyMatrices(t,this)}multiplyMatrices(t,i){const r=t.elements,a=i.elements,o=this.elements,l=r[0],c=r[3],h=r[6],d=r[1],u=r[4],p=r[7],m=r[2],g=r[5],y=r[8],v=a[0],x=a[3],b=a[6],_=a[1],S=a[4],M=a[7],w=a[2],T=a[5],E=a[8];return o[0]=l*v+c*_+h*w,o[3]=l*x+c*S+h*T,o[6]=l*b+c*M+h*E,o[1]=d*v+u*_+p*w,o[4]=d*x+u*S+p*T,o[7]=d*b+u*M+p*E,o[2]=m*v+g*_+y*w,o[5]=m*x+g*S+y*T,o[8]=m*b+g*M+y*E,this}multiplyScalar(t){const i=this.elements;return i[0]*=t,i[3]*=t,i[6]*=t,i[1]*=t,i[4]*=t,i[7]*=t,i[2]*=t,i[5]*=t,i[8]*=t,this}determinant(){const t=this.elements,i=t[0],r=t[1],a=t[2],o=t[3],l=t[4],c=t[5],h=t[6],d=t[7],u=t[8];return i*l*u-i*c*d-r*o*u+r*c*h+a*o*d-a*l*h}invert(){const t=this.elements,i=t[0],r=t[1],a=t[2],o=t[3],l=t[4],c=t[5],h=t[6],d=t[7],u=t[8],p=u*l-c*d,m=c*h-u*o,g=d*o-l*h,y=i*p+r*m+a*g;if(0===y)return this.set(0,0,0,0,0,0,0,0,0);const v=1/y;return t[0]=p*v,t[1]=(a*d-u*r)*v,t[2]=(c*r-a*l)*v,t[3]=m*v,t[4]=(u*i-a*h)*v,t[5]=(a*o-c*i)*v,t[6]=g*v,t[7]=(r*h-d*i)*v,t[8]=(l*i-r*o)*v,this}transpose(){let t;const i=this.elements;return t=i[1],i[1]=i[3],i[3]=t,t=i[2],i[2]=i[6],i[6]=t,t=i[5],i[5]=i[7],i[7]=t,this}getNormalMatrix(t){return this.setFromMatrix4(t).invert().transpose()}transposeIntoArray(t){const i=this.elements;return t[0]=i[0],t[1]=i[3],t[2]=i[6],t[3]=i[1],t[4]=i[4],t[5]=i[7],t[6]=i[2],t[7]=i[5],t[8]=i[8],this}setUvTransform(t,i,r,a,o,l,c){const h=Math.cos(o),d=Math.sin(o);return this.set(r*h,r*d,-r*(h*l+d*c)+l+t,-a*d,a*h,-a*(-d*l+h*c)+c+i,0,0,1),this}scale(t,i){return this.premultiply(It.makeScale(t,i)),this}rotate(t){return this.premultiply(It.makeRotation(-t)),this}translate(t,i){return this.premultiply(It.makeTranslation(t,i)),this}makeTranslation(t,i){return t.isVector2?this.set(1,0,t.x,0,1,t.y,0,0,1):this.set(1,0,t,0,1,i,0,0,1),this}makeRotation(t){const i=Math.cos(t),r=Math.sin(t);return this.set(i,-r,0,r,i,0,0,0,1),this}makeScale(t,i){return this.set(t,0,0,0,i,0,0,0,1),this}equals(t){const i=this.elements,r=t.elements;for(let t=0;t<9;t++)if(i[t]!==r[t])return!1;return!0}fromArray(t,i=0){for(let r=0;r<9;r++)this.elements[r]=t[r+i];return this}toArray(t=[],i=0){const r=this.elements;return t[i]=r[0],t[i+1]=r[1],t[i+2]=r[2],t[i+3]=r[3],t[i+4]=r[4],t[i+5]=r[5],t[i+6]=r[6],t[i+7]=r[7],t[i+8]=r[8],t}clone(){return(new this.constructor).fromArray(this.elements)}}const It=new Matrix3;function arrayNeedsUint32(t){for(let i=t.length-1;i>=0;--i)if(t[i]>=65535)return!0;return!1}const Dt={Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array};function getTypedArray(t,i){return new Dt[t](i)}function createElementNS(t){return document.createElementNS("http://www.w3.org/1999/xhtml",t)}function createCanvasElement(){const t=createElementNS("canvas");return t.style.display="block",t}const Lt={};function warnOnce(t){t in Lt||(Lt[t]=!0)}const Ft=(new Matrix3).set(.4123908,.3575843,.1804808,.212639,.7151687,.0721923,.0193308,.1191948,.9505322),Nt=(new Matrix3).set(3.2409699,-1.5373832,-.4986108,-.9692436,1.8759675,.0415551,.0556301,-.203977,1.0569715);function createColorManagement(){const t={enabled:!0,workingColorSpace:ct,spaces:{},convert:function(t,i,r){return!1!==this.enabled&&i!==r&&i&&r?(this.spaces[i].transfer===dt&&(t.r=SRGBToLinear(t.r),t.g=SRGBToLinear(t.g),t.b=SRGBToLinear(t.b)),this.spaces[i].primaries!==this.spaces[r].primaries&&(t.applyMatrix3(this.spaces[i].toXYZ),t.applyMatrix3(this.spaces[r].fromXYZ)),this.spaces[r].transfer===dt&&(t.r=LinearToSRGB(t.r),t.g=LinearToSRGB(t.g),t.b=LinearToSRGB(t.b)),t):t},fromWorkingColorSpace:function(t,i){return this.convert(t,this.workingColorSpace,i)},toWorkingColorSpace:function(t,i){return this.convert(t,i,this.workingColorSpace)},getPrimaries:function(t){return this.spaces[t].primaries},getTransfer:function(t){return t===ot?ht:this.spaces[t].transfer},getLuminanceCoefficients:function(t,i=this.workingColorSpace){return t.fromArray(this.spaces[i].luminanceCoefficients)},define:function(t){Object.assign(this.spaces,t)},_getMatrix:function(t,i,r){return t.copy(this.spaces[i].toXYZ).multiply(this.spaces[r].fromXYZ)},_getDrawingBufferColorSpace:function(t){return this.spaces[t].outputColorSpaceConfig.drawingBufferColorSpace},_getUnpackColorSpace:function(t=this.workingColorSpace){return this.spaces[t].workingColorSpaceConfig.unpackColorSpace}},i=[.64,.33,.3,.6,.15,.06],r=[.2126,.7152,.0722],a=[.3127,.329];return t.define({[ct]:{primaries:i,whitePoint:a,transfer:ht,toXYZ:Ft,fromXYZ:Nt,luminanceCoefficients:r,workingColorSpaceConfig:{unpackColorSpace:lt},outputColorSpaceConfig:{drawingBufferColorSpace:lt}},[lt]:{primaries:i,whitePoint:a,transfer:dt,toXYZ:Ft,fromXYZ:Nt,luminanceCoefficients:r,outputColorSpaceConfig:{drawingBufferColorSpace:lt}}}),t}const Ot=createColorManagement();function SRGBToLinear(t){return t<.04045?.0773993808*t:Math.pow(.9478672986*t+.0521327014,2.4)}function LinearToSRGB(t){return t<.0031308?12.92*t:1.055*Math.pow(t,.41666)-.055}let Ut;class ImageUtils{static getDataURL(t){if(/^data:/i.test(t.src))return t.src;if("undefined"==typeof HTMLCanvasElement)return t.src;let i;if(t instanceof HTMLCanvasElement)i=t;else{void 0===Ut&&(Ut=createElementNS("canvas")),Ut.width=t.width,Ut.height=t.height;const r=Ut.getContext("2d");t instanceof ImageData?r.putImageData(t,0,0):r.drawImage(t,0,0,t.width,t.height),i=Ut}return i.width>2048||i.height>2048?i.toDataURL("image/jpeg",.6):i.toDataURL("image/png")}static sRGBToLinear(t){if("undefined"!=typeof HTMLImageElement&&t instanceof HTMLImageElement||"undefined"!=typeof HTMLCanvasElement&&t instanceof HTMLCanvasElement||"undefined"!=typeof ImageBitmap&&t instanceof ImageBitmap){const i=createElementNS("canvas");i.width=t.width,i.height=t.height;const r=i.getContext("2d");r.drawImage(t,0,0,t.width,t.height);const a=r.getImageData(0,0,t.width,t.height),o=a.data;for(let t=0;t<o.length;t++)o[t]=255*SRGBToLinear(o[t]/255);return r.putImageData(a,0,0),i}if(t.data){const i=t.data.slice(0);for(let t=0;t<i.length;t++)i instanceof Uint8Array||i instanceof Uint8ClampedArray?i[t]=Math.floor(255*SRGBToLinear(i[t]/255)):i[t]=SRGBToLinear(i[t]);return{data:i,width:t.width,height:t.height}}return t}}let Bt=0;class Source{constructor(t=null){this.isSource=!0,Object.defineProperty(this,"id",{value:Bt++}),this.uuid=generateUUID(),this.data=t,this.dataReady=!0,this.version=0}set needsUpdate(t){!0===t&&this.version++}toJSON(t){const i=void 0===t||"string"==typeof t;if(!i&&void 0!==t.images[this.uuid])return t.images[this.uuid];const r={uuid:this.uuid,url:""},a=this.data;if(null!==a){let t;if(Array.isArray(a)){t=[];for(let i=0,r=a.length;i<r;i++)a[i].isDataTexture?t.push(serializeImage(a[i].image)):t.push(serializeImage(a[i]))}else t=serializeImage(a);r.url=t}return i||(t.images[this.uuid]=r),r}}function serializeImage(t){return"undefined"!=typeof HTMLImageElement&&t instanceof HTMLImageElement||"undefined"!=typeof HTMLCanvasElement&&t instanceof HTMLCanvasElement||"undefined"!=typeof ImageBitmap&&t instanceof ImageBitmap?ImageUtils.getDataURL(t):t.data?{data:Array.from(t.data),width:t.width,height:t.height,type:t.data.constructor.name}:{}}let zt=0;class Texture extends Tt{constructor(t=Texture.DEFAULT_IMAGE,i=Texture.DEFAULT_MAPPING,r=1001,a=1001,o=1006,l=1008,c=1023,h=1009,d=Texture.DEFAULT_ANISOTROPY,u=""){super(),this.isTexture=!0,Object.defineProperty(this,"id",{value:zt++}),this.uuid=generateUUID(),this.name="",this.source=new Source(t),this.mipmaps=[],this.mapping=i,this.channel=0,this.wrapS=r,this.wrapT=a,this.magFilter=o,this.minFilter=l,this.anisotropy=d,this.format=c,this.internalFormat=null,this.type=h,this.offset=new Vector2(0,0),this.repeat=new Vector2(1,1),this.center=new Vector2(0,0),this.rotation=0,this.matrixAutoUpdate=!0,this.matrix=new Matrix3,this.generateMipmaps=!0,this.premultiplyAlpha=!1,this.flipY=!0,this.unpackAlignment=4,this.colorSpace=u,this.userData={},this.version=0,this.onUpdate=null,this.renderTarget=null,this.isRenderTargetTexture=!1,this.pmremVersion=0}get image(){return this.source.data}set image(t=null){this.source.data=t}updateMatrix(){this.matrix.setUvTransform(this.offset.x,this.offset.y,this.repeat.x,this.repeat.y,this.rotation,this.center.x,this.center.y)}clone(){return(new this.constructor).copy(this)}copy(t){return this.name=t.name,this.source=t.source,this.mipmaps=t.mipmaps.slice(0),this.mapping=t.mapping,this.channel=t.channel,this.wrapS=t.wrapS,this.wrapT=t.wrapT,this.magFilter=t.magFilter,this.minFilter=t.minFilter,this.anisotropy=t.anisotropy,this.format=t.format,this.internalFormat=t.internalFormat,this.type=t.type,this.offset.copy(t.offset),this.repeat.copy(t.repeat),this.center.copy(t.center),this.rotation=t.rotation,this.matrixAutoUpdate=t.matrixAutoUpdate,this.matrix.copy(t.matrix),this.generateMipmaps=t.generateMipmaps,this.premultiplyAlpha=t.premultiplyAlpha,this.flipY=t.flipY,this.unpackAlignment=t.unpackAlignment,this.colorSpace=t.colorSpace,this.renderTarget=t.renderTarget,this.isRenderTargetTexture=t.isRenderTargetTexture,this.userData=JSON.parse(JSON.stringify(t.userData)),this.needsUpdate=!0,this}toJSON(t){const i=void 0===t||"string"==typeof t;if(!i&&void 0!==t.textures[this.uuid])return t.textures[this.uuid];const r={metadata:{version:4.6,type:"Texture",generator:"Texture.toJSON"},uuid:this.uuid,name:this.name,image:this.source.toJSON(t).uuid,mapping:this.mapping,channel:this.channel,repeat:[this.repeat.x,this.repeat.y],offset:[this.offset.x,this.offset.y],center:[this.center.x,this.center.y],rotation:this.rotation,wrap:[this.wrapS,this.wrapT],format:this.format,internalFormat:this.internalFormat,type:this.type,colorSpace:this.colorSpace,minFilter:this.minFilter,magFilter:this.magFilter,anisotropy:this.anisotropy,flipY:this.flipY,generateMipmaps:this.generateMipmaps,premultiplyAlpha:this.premultiplyAlpha,unpackAlignment:this.unpackAlignment};return Object.keys(this.userData).length>0&&(r.userData=this.userData),i||(t.textures[this.uuid]=r),r}dispose(){this.dispatchEvent({type:"dispose"})}transformUv(t){if(300!==this.mapping)return t;if(t.applyMatrix3(this.matrix),t.x<0||t.x>1)switch(this.wrapS){case Y:t.x=t.x-Math.floor(t.x);break;case Z:t.x=t.x<0?0:1;break;case K:1===Math.abs(Math.floor(t.x)%2)?t.x=Math.ceil(t.x)-t.x:t.x=t.x-Math.floor(t.x)}if(t.y<0||t.y>1)switch(this.wrapT){case Y:t.y=t.y-Math.floor(t.y);break;case Z:t.y=t.y<0?0:1;break;case K:1===Math.abs(Math.floor(t.y)%2)?t.y=Math.ceil(t.y)-t.y:t.y=t.y-Math.floor(t.y)}return this.flipY&&(t.y=1-t.y),t}set needsUpdate(t){!0===t&&(this.version++,this.source.needsUpdate=!0)}set needsPMREMUpdate(t){!0===t&&this.pmremVersion++}}Texture.DEFAULT_IMAGE=null,Texture.DEFAULT_MAPPING=300,Texture.DEFAULT_ANISOTROPY=1;class Vector4{constructor(t=0,i=0,r=0,a=1){Vector4.prototype.isVector4=!0,this.x=t,this.y=i,this.z=r,this.w=a}get width(){return this.z}set width(t){this.z=t}get height(){return this.w}set height(t){this.w=t}set(t,i,r,a){return this.x=t,this.y=i,this.z=r,this.w=a,this}setScalar(t){return this.x=t,this.y=t,this.z=t,this.w=t,this}setX(t){return this.x=t,this}setY(t){return this.y=t,this}setZ(t){return this.z=t,this}setW(t){return this.w=t,this}setComponent(t,i){switch(t){case 0:this.x=i;break;case 1:this.y=i;break;case 2:this.z=i;break;case 3:this.w=i;break;default:throw new Error("index is out of range: "+t)}return this}getComponent(t){switch(t){case 0:return this.x;case 1:return this.y;case 2:return this.z;case 3:return this.w;default:throw new Error("index is out of range: "+t)}}clone(){return new this.constructor(this.x,this.y,this.z,this.w)}copy(t){return this.x=t.x,this.y=t.y,this.z=t.z,this.w=void 0!==t.w?t.w:1,this}add(t){return this.x+=t.x,this.y+=t.y,this.z+=t.z,this.w+=t.w,this}addScalar(t){return this.x+=t,this.y+=t,this.z+=t,this.w+=t,this}addVectors(t,i){return this.x=t.x+i.x,this.y=t.y+i.y,this.z=t.z+i.z,this.w=t.w+i.w,this}addScaledVector(t,i){return this.x+=t.x*i,this.y+=t.y*i,this.z+=t.z*i,this.w+=t.w*i,this}sub(t){return this.x-=t.x,this.y-=t.y,this.z-=t.z,this.w-=t.w,this}subScalar(t){return this.x-=t,this.y-=t,this.z-=t,this.w-=t,this}subVectors(t,i){return this.x=t.x-i.x,this.y=t.y-i.y,this.z=t.z-i.z,this.w=t.w-i.w,this}multiply(t){return this.x*=t.x,this.y*=t.y,this.z*=t.z,this.w*=t.w,this}multiplyScalar(t){return this.x*=t,this.y*=t,this.z*=t,this.w*=t,this}applyMatrix4(t){const i=this.x,r=this.y,a=this.z,o=this.w,l=t.elements;return this.x=l[0]*i+l[4]*r+l[8]*a+l[12]*o,this.y=l[1]*i+l[5]*r+l[9]*a+l[13]*o,this.z=l[2]*i+l[6]*r+l[10]*a+l[14]*o,this.w=l[3]*i+l[7]*r+l[11]*a+l[15]*o,this}divide(t){return this.x/=t.x,this.y/=t.y,this.z/=t.z,this.w/=t.w,this}divideScalar(t){return this.multiplyScalar(1/t)}setAxisAngleFromQuaternion(t){this.w=2*Math.acos(t.w);const i=Math.sqrt(1-t.w*t.w);return i<1e-4?(this.x=1,this.y=0,this.z=0):(this.x=t.x/i,this.y=t.y/i,this.z=t.z/i),this}setAxisAngleFromRotationMatrix(t){let i,r,a,o;const l=.01,c=.1,h=t.elements,d=h[0],u=h[4],p=h[8],m=h[1],g=h[5],y=h[9],v=h[2],x=h[6],b=h[10];if(Math.abs(u-m)<l&&Math.abs(p-v)<l&&Math.abs(y-x)<l){if(Math.abs(u+m)<c&&Math.abs(p+v)<c&&Math.abs(y+x)<c&&Math.abs(d+g+b-3)<c)return this.set(1,0,0,0),this;i=Math.PI;const t=(d+1)/2,h=(g+1)/2,_=(b+1)/2,S=(u+m)/4,M=(p+v)/4,w=(y+x)/4;return t>h&&t>_?t<l?(r=0,a=.707106781,o=.707106781):(r=Math.sqrt(t),a=S/r,o=M/r):h>_?h<l?(r=.707106781,a=0,o=.707106781):(a=Math.sqrt(h),r=S/a,o=w/a):_<l?(r=.707106781,a=.707106781,o=0):(o=Math.sqrt(_),r=M/o,a=w/o),this.set(r,a,o,i),this}let _=Math.sqrt((x-y)*(x-y)+(p-v)*(p-v)+(m-u)*(m-u));return Math.abs(_)<.001&&(_=1),this.x=(x-y)/_,this.y=(p-v)/_,this.z=(m-u)/_,this.w=Math.acos((d+g+b-1)/2),this}setFromMatrixPosition(t){const i=t.elements;return this.x=i[12],this.y=i[13],this.z=i[14],this.w=i[15],this}min(t){return this.x=Math.min(this.x,t.x),this.y=Math.min(this.y,t.y),this.z=Math.min(this.z,t.z),this.w=Math.min(this.w,t.w),this}max(t){return this.x=Math.max(this.x,t.x),this.y=Math.max(this.y,t.y),this.z=Math.max(this.z,t.z),this.w=Math.max(this.w,t.w),this}clamp(t,i){return this.x=clamp(this.x,t.x,i.x),this.y=clamp(this.y,t.y,i.y),this.z=clamp(this.z,t.z,i.z),this.w=clamp(this.w,t.w,i.w),this}clampScalar(t,i){return this.x=clamp(this.x,t,i),this.y=clamp(this.y,t,i),this.z=clamp(this.z,t,i),this.w=clamp(this.w,t,i),this}clampLength(t,i){const r=this.length();return this.divideScalar(r||1).multiplyScalar(clamp(r,t,i))}floor(){return this.x=Math.floor(this.x),this.y=Math.floor(this.y),this.z=Math.floor(this.z),this.w=Math.floor(this.w),this}ceil(){return this.x=Math.ceil(this.x),this.y=Math.ceil(this.y),this.z=Math.ceil(this.z),this.w=Math.ceil(this.w),this}round(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this.z=Math.round(this.z),this.w=Math.round(this.w),this}roundToZero(){return this.x=Math.trunc(this.x),this.y=Math.trunc(this.y),this.z=Math.trunc(this.z),this.w=Math.trunc(this.w),this}negate(){return this.x=-this.x,this.y=-this.y,this.z=-this.z,this.w=-this.w,this}dot(t){return this.x*t.x+this.y*t.y+this.z*t.z+this.w*t.w}lengthSq(){return this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w}length(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w)}manhattanLength(){return Math.abs(this.x)+Math.abs(this.y)+Math.abs(this.z)+Math.abs(this.w)}normalize(){return this.divideScalar(this.length()||1)}setLength(t){return this.normalize().multiplyScalar(t)}lerp(t,i){return this.x+=(t.x-this.x)*i,this.y+=(t.y-this.y)*i,this.z+=(t.z-this.z)*i,this.w+=(t.w-this.w)*i,this}lerpVectors(t,i,r){return this.x=t.x+(i.x-t.x)*r,this.y=t.y+(i.y-t.y)*r,this.z=t.z+(i.z-t.z)*r,this.w=t.w+(i.w-t.w)*r,this}equals(t){return t.x===this.x&&t.y===this.y&&t.z===this.z&&t.w===this.w}fromArray(t,i=0){return this.x=t[i],this.y=t[i+1],this.z=t[i+2],this.w=t[i+3],this}toArray(t=[],i=0){return t[i]=this.x,t[i+1]=this.y,t[i+2]=this.z,t[i+3]=this.w,t}fromBufferAttribute(t,i){return this.x=t.getX(i),this.y=t.getY(i),this.z=t.getZ(i),this.w=t.getW(i),this}random(){return this.x=Math.random(),this.y=Math.random(),this.z=Math.random(),this.w=Math.random(),this}*[Symbol.iterator](){yield this.x,yield this.y,yield this.z,yield this.w}}class RenderTarget extends Tt{constructor(t=1,i=1,r={}){super(),this.isRenderTarget=!0,this.width=t,this.height=i,this.depth=1,this.scissor=new Vector4(0,0,t,i),this.scissorTest=!1,this.viewport=new Vector4(0,0,t,i);const a={width:t,height:i,depth:1};r=Object.assign({generateMipmaps:!1,internalFormat:null,minFilter:te,depthBuffer:!0,stencilBuffer:!1,resolveDepthBuffer:!0,resolveStencilBuffer:!0,depthTexture:null,samples:0,count:1},r);const o=new Texture(a,r.mapping,r.wrapS,r.wrapT,r.magFilter,r.minFilter,r.format,r.type,r.anisotropy,r.colorSpace);o.flipY=!1,o.generateMipmaps=r.generateMipmaps,o.internalFormat=r.internalFormat,this.textures=[];const l=r.count;for(let t=0;t<l;t++)this.textures[t]=o.clone(),this.textures[t].isRenderTargetTexture=!0,this.textures[t].renderTarget=this;this.depthBuffer=r.depthBuffer,this.stencilBuffer=r.stencilBuffer,this.resolveDepthBuffer=r.resolveDepthBuffer,this.resolveStencilBuffer=r.resolveStencilBuffer,this._depthTexture=null,this.depthTexture=r.depthTexture,this.samples=r.samples}get texture(){return this.textures[0]}set texture(t){this.textures[0]=t}set depthTexture(t){null!==this._depthTexture&&(this._depthTexture.renderTarget=null),null!==t&&(t.renderTarget=this),this._depthTexture=t}get depthTexture(){return this._depthTexture}setSize(t,i,r=1){if(this.width!==t||this.height!==i||this.depth!==r){this.width=t,this.height=i,this.depth=r;for(let a=0,o=this.textures.length;a<o;a++)this.textures[a].image.width=t,this.textures[a].image.height=i,this.textures[a].image.depth=r;this.dispose()}this.viewport.set(0,0,t,i),this.scissor.set(0,0,t,i)}clone(){return(new this.constructor).copy(this)}copy(t){this.width=t.width,this.height=t.height,this.depth=t.depth,this.scissor.copy(t.scissor),this.scissorTest=t.scissorTest,this.viewport.copy(t.viewport),this.textures.length=0;for(let i=0,r=t.textures.length;i<r;i++)this.textures[i]=t.textures[i].clone(),this.textures[i].isRenderTargetTexture=!0,this.textures[i].renderTarget=this;const i=Object.assign({},t.texture.image);return this.texture.source=new Source(i),this.depthBuffer=t.depthBuffer,this.stencilBuffer=t.stencilBuffer,this.resolveDepthBuffer=t.resolveDepthBuffer,this.resolveStencilBuffer=t.resolveStencilBuffer,null!==t.depthTexture&&(this.depthTexture=t.depthTexture.clone()),this.samples=t.samples,this}dispose(){this.dispatchEvent({type:"dispose"})}}class WebGLRenderTarget extends RenderTarget{constructor(t=1,i=1,r={}){super(t,i,r),this.isWebGLRenderTarget=!0}}class DataArrayTexture extends Texture{constructor(t=null,i=1,r=1,a=1){super(null),this.isDataArrayTexture=!0,this.image={data:t,width:i,height:r,depth:a},this.magFilter=Q,this.minFilter=Q,this.wrapR=Z,this.generateMipmaps=!1,this.flipY=!1,this.unpackAlignment=1,this.layerUpdates=new Set}addLayerUpdate(t){this.layerUpdates.add(t)}clearLayerUpdates(){this.layerUpdates.clear()}}class Data3DTexture extends Texture{constructor(t=null,i=1,r=1,a=1){super(null),this.isData3DTexture=!0,this.image={data:t,width:i,height:r,depth:a},this.magFilter=Q,this.minFilter=Q,this.wrapR=Z,this.generateMipmaps=!1,this.flipY=!1,this.unpackAlignment=1}}let Vt=class Quaternion{constructor(t=0,i=0,r=0,a=1){this.isQuaternion=!0,this._x=t,this._y=i,this._z=r,this._w=a}static slerpFlat(t,i,r,a,o,l,c){let h=r[a+0],d=r[a+1],u=r[a+2],p=r[a+3];const m=o[l+0],g=o[l+1],y=o[l+2],v=o[l+3];if(0===c)return t[i+0]=h,t[i+1]=d,t[i+2]=u,void(t[i+3]=p);if(1===c)return t[i+0]=m,t[i+1]=g,t[i+2]=y,void(t[i+3]=v);if(p!==v||h!==m||d!==g||u!==y){let t=1-c;const i=h*m+d*g+u*y+p*v,r=i>=0?1:-1,a=1-i*i;if(a>Number.EPSILON){const o=Math.sqrt(a),l=Math.atan2(o,i*r);t=Math.sin(t*l)/o,c=Math.sin(c*l)/o}const o=c*r;if(h=h*t+m*o,d=d*t+g*o,u=u*t+y*o,p=p*t+v*o,t===1-c){const t=1/Math.sqrt(h*h+d*d+u*u+p*p);h*=t,d*=t,u*=t,p*=t}}t[i]=h,t[i+1]=d,t[i+2]=u,t[i+3]=p}static multiplyQuaternionsFlat(t,i,r,a,o,l){const c=r[a],h=r[a+1],d=r[a+2],u=r[a+3],p=o[l],m=o[l+1],g=o[l+2],y=o[l+3];return t[i]=c*y+u*p+h*g-d*m,t[i+1]=h*y+u*m+d*p-c*g,t[i+2]=d*y+u*g+c*m-h*p,t[i+3]=u*y-c*p-h*m-d*g,t}get x(){return this._x}set x(t){this._x=t,this._onChangeCallback()}get y(){return this._y}set y(t){this._y=t,this._onChangeCallback()}get z(){return this._z}set z(t){this._z=t,this._onChangeCallback()}get w(){return this._w}set w(t){this._w=t,this._onChangeCallback()}set(t,i,r,a){return this._x=t,this._y=i,this._z=r,this._w=a,this._onChangeCallback(),this}clone(){return new this.constructor(this._x,this._y,this._z,this._w)}copy(t){return this._x=t.x,this._y=t.y,this._z=t.z,this._w=t.w,this._onChangeCallback(),this}setFromEuler(t,i=!0){const r=t._x,a=t._y,o=t._z,l=t._order,c=Math.cos,h=Math.sin,d=c(r/2),u=c(a/2),p=c(o/2),m=h(r/2),g=h(a/2),y=h(o/2);switch(l){case"XYZ":this._x=m*u*p+d*g*y,this._y=d*g*p-m*u*y,this._z=d*u*y+m*g*p,this._w=d*u*p-m*g*y;break;case"YXZ":this._x=m*u*p+d*g*y,this._y=d*g*p-m*u*y,this._z=d*u*y-m*g*p,this._w=d*u*p+m*g*y;break;case"ZXY":this._x=m*u*p-d*g*y,this._y=d*g*p+m*u*y,this._z=d*u*y+m*g*p,this._w=d*u*p-m*g*y;break;case"ZYX":this._x=m*u*p-d*g*y,this._y=d*g*p+m*u*y,this._z=d*u*y-m*g*p,this._w=d*u*p+m*g*y;break;case"YZX":this._x=m*u*p+d*g*y,this._y=d*g*p+m*u*y,this._z=d*u*y-m*g*p,this._w=d*u*p-m*g*y;break;case"XZY":this._x=m*u*p-d*g*y,this._y=d*g*p-m*u*y,this._z=d*u*y+m*g*p,this._w=d*u*p+m*g*y}return!0===i&&this._onChangeCallback(),this}setFromAxisAngle(t,i){const r=i/2,a=Math.sin(r);return this._x=t.x*a,this._y=t.y*a,this._z=t.z*a,this._w=Math.cos(r),this._onChangeCallback(),this}setFromRotationMatrix(t){const i=t.elements,r=i[0],a=i[4],o=i[8],l=i[1],c=i[5],h=i[9],d=i[2],u=i[6],p=i[10],m=r+c+p;if(m>0){const t=.5/Math.sqrt(m+1);this._w=.25/t,this._x=(u-h)*t,this._y=(o-d)*t,this._z=(l-a)*t}else if(r>c&&r>p){const t=2*Math.sqrt(1+r-c-p);this._w=(u-h)/t,this._x=.25*t,this._y=(a+l)/t,this._z=(o+d)/t}else if(c>p){const t=2*Math.sqrt(1+c-r-p);this._w=(o-d)/t,this._x=(a+l)/t,this._y=.25*t,this._z=(h+u)/t}else{const t=2*Math.sqrt(1+p-r-c);this._w=(l-a)/t,this._x=(o+d)/t,this._y=(h+u)/t,this._z=.25*t}return this._onChangeCallback(),this}setFromUnitVectors(t,i){let r=t.dot(i)+1;return r<Number.EPSILON?(r=0,Math.abs(t.x)>Math.abs(t.z)?(this._x=-t.y,this._y=t.x,this._z=0,this._w=r):(this._x=0,this._y=-t.z,this._z=t.y,this._w=r)):(this._x=t.y*i.z-t.z*i.y,this._y=t.z*i.x-t.x*i.z,this._z=t.x*i.y-t.y*i.x,this._w=r),this.normalize()}angleTo(t){return 2*Math.acos(Math.abs(clamp(this.dot(t),-1,1)))}rotateTowards(t,i){const r=this.angleTo(t);if(0===r)return this;const a=Math.min(1,i/r);return this.slerp(t,a),this}identity(){return this.set(0,0,0,1)}invert(){return this.conjugate()}conjugate(){return this._x*=-1,this._y*=-1,this._z*=-1,this._onChangeCallback(),this}dot(t){return this._x*t._x+this._y*t._y+this._z*t._z+this._w*t._w}lengthSq(){return this._x*this._x+this._y*this._y+this._z*this._z+this._w*this._w}length(){return Math.sqrt(this._x*this._x+this._y*this._y+this._z*this._z+this._w*this._w)}normalize(){let t=this.length();return 0===t?(this._x=0,this._y=0,this._z=0,this._w=1):(t=1/t,this._x=this._x*t,this._y=this._y*t,this._z=this._z*t,this._w=this._w*t),this._onChangeCallback(),this}multiply(t){return this.multiplyQuaternions(this,t)}premultiply(t){return this.multiplyQuaternions(t,this)}multiplyQuaternions(t,i){const r=t._x,a=t._y,o=t._z,l=t._w,c=i._x,h=i._y,d=i._z,u=i._w;return this._x=r*u+l*c+a*d-o*h,this._y=a*u+l*h+o*c-r*d,this._z=o*u+l*d+r*h-a*c,this._w=l*u-r*c-a*h-o*d,this._onChangeCallback(),this}slerp(t,i){if(0===i)return this;if(1===i)return this.copy(t);const r=this._x,a=this._y,o=this._z,l=this._w;let c=l*t._w+r*t._x+a*t._y+o*t._z;if(c<0?(this._w=-t._w,this._x=-t._x,this._y=-t._y,this._z=-t._z,c=-c):this.copy(t),c>=1)return this._w=l,this._x=r,this._y=a,this._z=o,this;const h=1-c*c;if(h<=Number.EPSILON){const t=1-i;return this._w=t*l+i*this._w,this._x=t*r+i*this._x,this._y=t*a+i*this._y,this._z=t*o+i*this._z,this.normalize(),this}const d=Math.sqrt(h),u=Math.atan2(d,c),p=Math.sin((1-i)*u)/d,m=Math.sin(i*u)/d;return this._w=l*p+this._w*m,this._x=r*p+this._x*m,this._y=a*p+this._y*m,this._z=o*p+this._z*m,this._onChangeCallback(),this}slerpQuaternions(t,i,r){return this.copy(t).slerp(i,r)}random(){const t=2*Math.PI*Math.random(),i=2*Math.PI*Math.random(),r=Math.random(),a=Math.sqrt(1-r),o=Math.sqrt(r);return this.set(a*Math.sin(t),a*Math.cos(t),o*Math.sin(i),o*Math.cos(i))}equals(t){return t._x===this._x&&t._y===this._y&&t._z===this._z&&t._w===this._w}fromArray(t,i=0){return this._x=t[i],this._y=t[i+1],this._z=t[i+2],this._w=t[i+3],this._onChangeCallback(),this}toArray(t=[],i=0){return t[i]=this._x,t[i+1]=this._y,t[i+2]=this._z,t[i+3]=this._w,t}fromBufferAttribute(t,i){return this._x=t.getX(i),this._y=t.getY(i),this._z=t.getZ(i),this._w=t.getW(i),this._onChangeCallback(),this}toJSON(){return this.toArray()}_onChange(t){return this._onChangeCallback=t,this}_onChangeCallback(){}*[Symbol.iterator](){yield this._x,yield this._y,yield this._z,yield this._w}};class Vector3{constructor(t=0,i=0,r=0){Vector3.prototype.isVector3=!0,this.x=t,this.y=i,this.z=r}set(t,i,r){return void 0===r&&(r=this.z),this.x=t,this.y=i,this.z=r,this}setScalar(t){return this.x=t,this.y=t,this.z=t,this}setX(t){return this.x=t,this}setY(t){return this.y=t,this}setZ(t){return this.z=t,this}setComponent(t,i){switch(t){case 0:this.x=i;break;case 1:this.y=i;break;case 2:this.z=i;break;default:throw new Error("index is out of range: "+t)}return this}getComponent(t){switch(t){case 0:return this.x;case 1:return this.y;case 2:return this.z;default:throw new Error("index is out of range: "+t)}}clone(){return new this.constructor(this.x,this.y,this.z)}copy(t){return this.x=t.x,this.y=t.y,this.z=t.z,this}add(t){return this.x+=t.x,this.y+=t.y,this.z+=t.z,this}addScalar(t){return this.x+=t,this.y+=t,this.z+=t,this}addVectors(t,i){return this.x=t.x+i.x,this.y=t.y+i.y,this.z=t.z+i.z,this}addScaledVector(t,i){return this.x+=t.x*i,this.y+=t.y*i,this.z+=t.z*i,this}sub(t){return this.x-=t.x,this.y-=t.y,this.z-=t.z,this}subScalar(t){return this.x-=t,this.y-=t,this.z-=t,this}subVectors(t,i){return this.x=t.x-i.x,this.y=t.y-i.y,this.z=t.z-i.z,this}multiply(t){return this.x*=t.x,this.y*=t.y,this.z*=t.z,this}multiplyScalar(t){return this.x*=t,this.y*=t,this.z*=t,this}multiplyVectors(t,i){return this.x=t.x*i.x,this.y=t.y*i.y,this.z=t.z*i.z,this}applyEuler(t){return this.applyQuaternion(Gt.setFromEuler(t))}applyAxisAngle(t,i){return this.applyQuaternion(Gt.setFromAxisAngle(t,i))}applyMatrix3(t){const i=this.x,r=this.y,a=this.z,o=t.elements;return this.x=o[0]*i+o[3]*r+o[6]*a,this.y=o[1]*i+o[4]*r+o[7]*a,this.z=o[2]*i+o[5]*r+o[8]*a,this}applyNormalMatrix(t){return this.applyMatrix3(t).normalize()}applyMatrix4(t){const i=this.x,r=this.y,a=this.z,o=t.elements,l=1/(o[3]*i+o[7]*r+o[11]*a+o[15]);return this.x=(o[0]*i+o[4]*r+o[8]*a+o[12])*l,this.y=(o[1]*i+o[5]*r+o[9]*a+o[13])*l,this.z=(o[2]*i+o[6]*r+o[10]*a+o[14])*l,this}applyQuaternion(t){const i=this.x,r=this.y,a=this.z,o=t.x,l=t.y,c=t.z,h=t.w,d=2*(l*a-c*r),u=2*(c*i-o*a),p=2*(o*r-l*i);return this.x=i+h*d+l*p-c*u,this.y=r+h*u+c*d-o*p,this.z=a+h*p+o*u-l*d,this}project(t){return this.applyMatrix4(t.matrixWorldInverse).applyMatrix4(t.projectionMatrix)}unproject(t){return this.applyMatrix4(t.projectionMatrixInverse).applyMatrix4(t.matrixWorld)}transformDirection(t){const i=this.x,r=this.y,a=this.z,o=t.elements;return this.x=o[0]*i+o[4]*r+o[8]*a,this.y=o[1]*i+o[5]*r+o[9]*a,this.z=o[2]*i+o[6]*r+o[10]*a,this.normalize()}divide(t){return this.x/=t.x,this.y/=t.y,this.z/=t.z,this}divideScalar(t){return this.multiplyScalar(1/t)}min(t){return this.x=Math.min(this.x,t.x),this.y=Math.min(this.y,t.y),this.z=Math.min(this.z,t.z),this}max(t){return this.x=Math.max(this.x,t.x),this.y=Math.max(this.y,t.y),this.z=Math.max(this.z,t.z),this}clamp(t,i){return this.x=clamp(this.x,t.x,i.x),this.y=clamp(this.y,t.y,i.y),this.z=clamp(this.z,t.z,i.z),this}clampScalar(t,i){return this.x=clamp(this.x,t,i),this.y=clamp(this.y,t,i),this.z=clamp(this.z,t,i),this}clampLength(t,i){const r=this.length();return this.divideScalar(r||1).multiplyScalar(clamp(r,t,i))}floor(){return this.x=Math.floor(this.x),this.y=Math.floor(this.y),this.z=Math.floor(this.z),this}ceil(){return this.x=Math.ceil(this.x),this.y=Math.ceil(this.y),this.z=Math.ceil(this.z),this}round(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this.z=Math.round(this.z),this}roundToZero(){return this.x=Math.trunc(this.x),this.y=Math.trunc(this.y),this.z=Math.trunc(this.z),this}negate(){return this.x=-this.x,this.y=-this.y,this.z=-this.z,this}dot(t){return this.x*t.x+this.y*t.y+this.z*t.z}lengthSq(){return this.x*this.x+this.y*this.y+this.z*this.z}length(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z)}manhattanLength(){return Math.abs(this.x)+Math.abs(this.y)+Math.abs(this.z)}normalize(){return this.divideScalar(this.length()||1)}setLength(t){return this.normalize().multiplyScalar(t)}lerp(t,i){return this.x+=(t.x-this.x)*i,this.y+=(t.y-this.y)*i,this.z+=(t.z-this.z)*i,this}lerpVectors(t,i,r){return this.x=t.x+(i.x-t.x)*r,this.y=t.y+(i.y-t.y)*r,this.z=t.z+(i.z-t.z)*r,this}cross(t){return this.crossVectors(this,t)}crossVectors(t,i){const r=t.x,a=t.y,o=t.z,l=i.x,c=i.y,h=i.z;return this.x=a*h-o*c,this.y=o*l-r*h,this.z=r*c-a*l,this}projectOnVector(t){const i=t.lengthSq();if(0===i)return this.set(0,0,0);const r=t.dot(this)/i;return this.copy(t).multiplyScalar(r)}projectOnPlane(t){return kt.copy(this).projectOnVector(t),this.sub(kt)}reflect(t){return this.sub(kt.copy(t).multiplyScalar(2*this.dot(t)))}angleTo(t){const i=Math.sqrt(this.lengthSq()*t.lengthSq());if(0===i)return Math.PI/2;const r=this.dot(t)/i;return Math.acos(clamp(r,-1,1))}distanceTo(t){return Math.sqrt(this.distanceToSquared(t))}distanceToSquared(t){const i=this.x-t.x,r=this.y-t.y,a=this.z-t.z;return i*i+r*r+a*a}manhattanDistanceTo(t){return Math.abs(this.x-t.x)+Math.abs(this.y-t.y)+Math.abs(this.z-t.z)}setFromSpherical(t){return this.setFromSphericalCoords(t.radius,t.phi,t.theta)}setFromSphericalCoords(t,i,r){const a=Math.sin(i)*t;return this.x=a*Math.sin(r),this.y=Math.cos(i)*t,this.z=a*Math.cos(r),this}setFromCylindrical(t){return this.setFromCylindricalCoords(t.radius,t.theta,t.y)}setFromCylindricalCoords(t,i,r){return this.x=t*Math.sin(i),this.y=r,this.z=t*Math.cos(i),this}setFromMatrixPosition(t){const i=t.elements;return this.x=i[12],this.y=i[13],this.z=i[14],this}setFromMatrixScale(t){const i=this.setFromMatrixColumn(t,0).length(),r=this.setFromMatrixColumn(t,1).length(),a=this.setFromMatrixColumn(t,2).length();return this.x=i,this.y=r,this.z=a,this}setFromMatrixColumn(t,i){return this.fromArray(t.elements,4*i)}setFromMatrix3Column(t,i){return this.fromArray(t.elements,3*i)}setFromEuler(t){return this.x=t._x,this.y=t._y,this.z=t._z,this}setFromColor(t){return this.x=t.r,this.y=t.g,this.z=t.b,this}equals(t){return t.x===this.x&&t.y===this.y&&t.z===this.z}fromArray(t,i=0){return this.x=t[i],this.y=t[i+1],this.z=t[i+2],this}toArray(t=[],i=0){return t[i]=this.x,t[i+1]=this.y,t[i+2]=this.z,t}fromBufferAttribute(t,i){return this.x=t.getX(i),this.y=t.getY(i),this.z=t.getZ(i),this}random(){return this.x=Math.random(),this.y=Math.random(),this.z=Math.random(),this}randomDirection(){const t=Math.random()*Math.PI*2,i=2*Math.random()-1,r=Math.sqrt(1-i*i);return this.x=r*Math.cos(t),this.y=i,this.z=r*Math.sin(t),this}*[Symbol.iterator](){yield this.x,yield this.y,yield this.z}}const kt=new Vector3,Gt=new Vt;class Box3{constructor(t=new Vector3(1/0,1/0,1/0),i=new Vector3(-1/0,-1/0,-1/0)){this.isBox3=!0,this.min=t,this.max=i}set(t,i){return this.min.copy(t),this.max.copy(i),this}setFromArray(t){this.makeEmpty();for(let i=0,r=t.length;i<r;i+=3)this.expandByPoint(Wt.fromArray(t,i));return this}setFromBufferAttribute(t){this.makeEmpty();for(let i=0,r=t.count;i<r;i++)this.expandByPoint(Wt.fromBufferAttribute(t,i));return this}setFromPoints(t){this.makeEmpty();for(let i=0,r=t.length;i<r;i++)this.expandByPoint(t[i]);return this}setFromCenterAndSize(t,i){const r=Wt.copy(i).multiplyScalar(.5);return this.min.copy(t).sub(r),this.max.copy(t).add(r),this}setFromObject(t,i=!1){return this.makeEmpty(),this.expandByObject(t,i)}clone(){return(new this.constructor).copy(this)}copy(t){return this.min.copy(t.min),this.max.copy(t.max),this}makeEmpty(){return this.min.x=this.min.y=this.min.z=1/0,this.max.x=this.max.y=this.max.z=-1/0,this}isEmpty(){return this.max.x<this.min.x||this.max.y<this.min.y||this.max.z<this.min.z}getCenter(t){return this.isEmpty()?t.set(0,0,0):t.addVectors(this.min,this.max).multiplyScalar(.5)}getSize(t){return this.isEmpty()?t.set(0,0,0):t.subVectors(this.max,this.min)}expandByPoint(t){return this.min.min(t),this.max.max(t),this}expandByVector(t){return this.min.sub(t),this.max.add(t),this}expandByScalar(t){return this.min.addScalar(-t),this.max.addScalar(t),this}expandByObject(t,i=!1){t.updateWorldMatrix(!1,!1);const r=t.geometry;if(void 0!==r){const a=r.getAttribute("position");if(!0===i&&void 0!==a&&!0!==t.isInstancedMesh)for(let i=0,r=a.count;i<r;i++)!0===t.isMesh?t.getVertexPosition(i,Wt):Wt.fromBufferAttribute(a,i),Wt.applyMatrix4(t.matrixWorld),this.expandByPoint(Wt);else void 0!==t.boundingBox?(null===t.boundingBox&&t.computeBoundingBox(),jt.copy(t.boundingBox)):(null===r.boundingBox&&r.computeBoundingBox(),jt.copy(r.boundingBox)),jt.applyMatrix4(t.matrixWorld),this.union(jt)}const a=t.children;for(let t=0,r=a.length;t<r;t++)this.expandByObject(a[t],i);return this}containsPoint(t){return t.x>=this.min.x&&t.x<=this.max.x&&t.y>=this.min.y&&t.y<=this.max.y&&t.z>=this.min.z&&t.z<=this.max.z}containsBox(t){return this.min.x<=t.min.x&&t.max.x<=this.max.x&&this.min.y<=t.min.y&&t.max.y<=this.max.y&&this.min.z<=t.min.z&&t.max.z<=this.max.z}getParameter(t,i){return i.set((t.x-this.min.x)/(this.max.x-this.min.x),(t.y-this.min.y)/(this.max.y-this.min.y),(t.z-this.min.z)/(this.max.z-this.min.z))}intersectsBox(t){return t.max.x>=this.min.x&&t.min.x<=this.max.x&&t.max.y>=this.min.y&&t.min.y<=this.max.y&&t.max.z>=this.min.z&&t.min.z<=this.max.z}intersectsSphere(t){return this.clampPoint(t.center,Wt),Wt.distanceToSquared(t.center)<=t.radius*t.radius}intersectsPlane(t){let i,r;return t.normal.x>0?(i=t.normal.x*this.min.x,r=t.normal.x*this.max.x):(i=t.normal.x*this.max.x,r=t.normal.x*this.min.x),t.normal.y>0?(i+=t.normal.y*this.min.y,r+=t.normal.y*this.max.y):(i+=t.normal.y*this.max.y,r+=t.normal.y*this.min.y),t.normal.z>0?(i+=t.normal.z*this.min.z,r+=t.normal.z*this.max.z):(i+=t.normal.z*this.max.z,r+=t.normal.z*this.min.z),i<=-t.constant&&r>=-t.constant}intersectsTriangle(t){if(this.isEmpty())return!1;this.getCenter(Jt),$t.subVectors(this.max,Jt),Xt.subVectors(t.a,Jt),qt.subVectors(t.b,Jt),Yt.subVectors(t.c,Jt),Zt.subVectors(qt,Xt),Kt.subVectors(Yt,qt),Qt.subVectors(Xt,Yt);let i=[0,-Zt.z,Zt.y,0,-Kt.z,Kt.y,0,-Qt.z,Qt.y,Zt.z,0,-Zt.x,Kt.z,0,-Kt.x,Qt.z,0,-Qt.x,-Zt.y,Zt.x,0,-Kt.y,Kt.x,0,-Qt.y,Qt.x,0];return!!satForAxes(i,Xt,qt,Yt,$t)&&(i=[1,0,0,0,1,0,0,0,1],!!satForAxes(i,Xt,qt,Yt,$t)&&(ei.crossVectors(Zt,Kt),i=[ei.x,ei.y,ei.z],satForAxes(i,Xt,qt,Yt,$t)))}clampPoint(t,i){return i.copy(t).clamp(this.min,this.max)}distanceToPoint(t){return this.clampPoint(t,Wt).distanceTo(t)}getBoundingSphere(t){return this.isEmpty()?t.makeEmpty():(this.getCenter(t.center),t.radius=.5*this.getSize(Wt).length()),t}intersect(t){return this.min.max(t.min),this.max.min(t.max),this.isEmpty()&&this.makeEmpty(),this}union(t){return this.min.min(t.min),this.max.max(t.max),this}applyMatrix4(t){return this.isEmpty()||(Ht[0].set(this.min.x,this.min.y,this.min.z).applyMatrix4(t),Ht[1].set(this.min.x,this.min.y,this.max.z).applyMatrix4(t),Ht[2].set(this.min.x,this.max.y,this.min.z).applyMatrix4(t),Ht[3].set(this.min.x,this.max.y,this.max.z).applyMatrix4(t),Ht[4].set(this.max.x,this.min.y,this.min.z).applyMatrix4(t),Ht[5].set(this.max.x,this.min.y,this.max.z).applyMatrix4(t),Ht[6].set(this.max.x,this.max.y,this.min.z).applyMatrix4(t),Ht[7].set(this.max.x,this.max.y,this.max.z).applyMatrix4(t),this.setFromPoints(Ht)),this}translate(t){return this.min.add(t),this.max.add(t),this}equals(t){return t.min.equals(this.min)&&t.max.equals(this.max)}}const Ht=[new Vector3,new Vector3,new Vector3,new Vector3,new Vector3,new Vector3,new Vector3,new Vector3],Wt=new Vector3,jt=new Box3,Xt=new Vector3,qt=new Vector3,Yt=new Vector3,Zt=new Vector3,Kt=new Vector3,Qt=new Vector3,Jt=new Vector3,$t=new Vector3,ei=new Vector3,ti=new Vector3;function satForAxes(t,i,r,a,o){for(let l=0,c=t.length-3;l<=c;l+=3){ti.fromArray(t,l);const c=o.x*Math.abs(ti.x)+o.y*Math.abs(ti.y)+o.z*Math.abs(ti.z),h=i.dot(ti),d=r.dot(ti),u=a.dot(ti);if(Math.max(-Math.max(h,d,u),Math.min(h,d,u))>c)return!1}return!0}const ii=new Box3,ni=new Vector3,ri=new Vector3;class Sphere{constructor(t=new Vector3,i=-1){this.isSphere=!0,this.center=t,this.radius=i}set(t,i){return this.center.copy(t),this.radius=i,this}setFromPoints(t,i){const r=this.center;void 0!==i?r.copy(i):ii.setFromPoints(t).getCenter(r);let a=0;for(let i=0,o=t.length;i<o;i++)a=Math.max(a,r.distanceToSquared(t[i]));return this.radius=Math.sqrt(a),this}copy(t){return this.center.copy(t.center),this.radius=t.radius,this}isEmpty(){return this.radius<0}makeEmpty(){return this.center.set(0,0,0),this.radius=-1,this}containsPoint(t){return t.distanceToSquared(this.center)<=this.radius*this.radius}distanceToPoint(t){return t.distanceTo(this.center)-this.radius}intersectsSphere(t){const i=this.radius+t.radius;return t.center.distanceToSquared(this.center)<=i*i}intersectsBox(t){return t.intersectsSphere(this)}intersectsPlane(t){return Math.abs(t.distanceToPoint(this.center))<=this.radius}clampPoint(t,i){const r=this.center.distanceToSquared(t);return i.copy(t),r>this.radius*this.radius&&(i.sub(this.center).normalize(),i.multiplyScalar(this.radius).add(this.center)),i}getBoundingBox(t){return this.isEmpty()?(t.makeEmpty(),t):(t.set(this.center,this.center),t.expandByScalar(this.radius),t)}applyMatrix4(t){return this.center.applyMatrix4(t),this.radius=this.radius*t.getMaxScaleOnAxis(),this}translate(t){return this.center.add(t),this}expandByPoint(t){if(this.isEmpty())return this.center.copy(t),this.radius=0,this;ni.subVectors(t,this.center);const i=ni.lengthSq();if(i>this.radius*this.radius){const t=Math.sqrt(i),r=.5*(t-this.radius);this.center.addScaledVector(ni,r/t),this.radius+=r}return this}union(t){return t.isEmpty()?this:this.isEmpty()?(this.copy(t),this):(!0===this.center.equals(t.center)?this.radius=Math.max(this.radius,t.radius):(ri.subVectors(t.center,this.center).setLength(t.radius),this.expandByPoint(ni.copy(t.center).add(ri)),this.expandByPoint(ni.copy(t.center).sub(ri))),this)}equals(t){return t.center.equals(this.center)&&t.radius===this.radius}clone(){return(new this.constructor).copy(this)}}const si=new Vector3,ai=new Vector3,oi=new Vector3,li=new Vector3,ci=new Vector3,hi=new Vector3,di=new Vector3;class Ray{constructor(t=new Vector3,i=new Vector3(0,0,-1)){this.origin=t,this.direction=i}set(t,i){return this.origin.copy(t),this.direction.copy(i),this}copy(t){return this.origin.copy(t.origin),this.direction.copy(t.direction),this}at(t,i){return i.copy(this.origin).addScaledVector(this.direction,t)}lookAt(t){return this.direction.copy(t).sub(this.origin).normalize(),this}recast(t){return this.origin.copy(this.at(t,si)),this}closestPointToPoint(t,i){i.subVectors(t,this.origin);const r=i.dot(this.direction);return r<0?i.copy(this.origin):i.copy(this.origin).addScaledVector(this.direction,r)}distanceToPoint(t){return Math.sqrt(this.distanceSqToPoint(t))}distanceSqToPoint(t){const i=si.subVectors(t,this.origin).dot(this.direction);return i<0?this.origin.distanceToSquared(t):(si.copy(this.origin).addScaledVector(this.direction,i),si.distanceToSquared(t))}distanceSqToSegment(t,i,r,a){ai.copy(t).add(i).multiplyScalar(.5),oi.copy(i).sub(t).normalize(),li.copy(this.origin).sub(ai);const o=.5*t.distanceTo(i),l=-this.direction.dot(oi),c=li.dot(this.direction),h=-li.dot(oi),d=li.lengthSq(),u=Math.abs(1-l*l);let p,m,g,y;if(u>0)if(p=l*h-c,m=l*c-h,y=o*u,p>=0)if(m>=-y)if(m<=y){const t=1/u;p*=t,m*=t,g=p*(p+l*m+2*c)+m*(l*p+m+2*h)+d}else m=o,p=Math.max(0,-(l*m+c)),g=-p*p+m*(m+2*h)+d;else m=-o,p=Math.max(0,-(l*m+c)),g=-p*p+m*(m+2*h)+d;else m<=-y?(p=Math.max(0,-(-l*o+c)),m=p>0?-o:Math.min(Math.max(-o,-h),o),g=-p*p+m*(m+2*h)+d):m<=y?(p=0,m=Math.min(Math.max(-o,-h),o),g=m*(m+2*h)+d):(p=Math.max(0,-(l*o+c)),m=p>0?o:Math.min(Math.max(-o,-h),o),g=-p*p+m*(m+2*h)+d);else m=l>0?-o:o,p=Math.max(0,-(l*m+c)),g=-p*p+m*(m+2*h)+d;return r&&r.copy(this.origin).addScaledVector(this.direction,p),a&&a.copy(ai).addScaledVector(oi,m),g}intersectSphere(t,i){si.subVectors(t.center,this.origin);const r=si.dot(this.direction),a=si.dot(si)-r*r,o=t.radius*t.radius;if(a>o)return null;const l=Math.sqrt(o-a),c=r-l,h=r+l;return h<0?null:c<0?this.at(h,i):this.at(c,i)}intersectsSphere(t){return this.distanceSqToPoint(t.center)<=t.radius*t.radius}distanceToPlane(t){const i=t.normal.dot(this.direction);if(0===i)return 0===t.distanceToPoint(this.origin)?0:null;const r=-(this.origin.dot(t.normal)+t.constant)/i;return r>=0?r:null}intersectPlane(t,i){const r=this.distanceToPlane(t);return null===r?null:this.at(r,i)}intersectsPlane(t){const i=t.distanceToPoint(this.origin);if(0===i)return!0;return t.normal.dot(this.direction)*i<0}intersectBox(t,i){let r,a,o,l,c,h;const d=1/this.direction.x,u=1/this.direction.y,p=1/this.direction.z,m=this.origin;return d>=0?(r=(t.min.x-m.x)*d,a=(t.max.x-m.x)*d):(r=(t.max.x-m.x)*d,a=(t.min.x-m.x)*d),u>=0?(o=(t.min.y-m.y)*u,l=(t.max.y-m.y)*u):(o=(t.max.y-m.y)*u,l=(t.min.y-m.y)*u),r>l||o>a?null:((o>r||isNaN(r))&&(r=o),(l<a||isNaN(a))&&(a=l),p>=0?(c=(t.min.z-m.z)*p,h=(t.max.z-m.z)*p):(c=(t.max.z-m.z)*p,h=(t.min.z-m.z)*p),r>h||c>a?null:((c>r||r!=r)&&(r=c),(h<a||a!=a)&&(a=h),a<0?null:this.at(r>=0?r:a,i)))}intersectsBox(t){return null!==this.intersectBox(t,si)}intersectTriangle(t,i,r,a,o){ci.subVectors(i,t),hi.subVectors(r,t),di.crossVectors(ci,hi);let l,c=this.direction.dot(di);if(c>0){if(a)return null;l=1}else{if(!(c<0))return null;l=-1,c=-c}li.subVectors(this.origin,t);const h=l*this.direction.dot(hi.crossVectors(li,hi));if(h<0)return null;const d=l*this.direction.dot(ci.cross(li));if(d<0)return null;if(h+d>c)return null;const u=-l*li.dot(di);return u<0?null:this.at(u/c,o)}applyMatrix4(t){return this.origin.applyMatrix4(t),this.direction.transformDirection(t),this}equals(t){return t.origin.equals(this.origin)&&t.direction.equals(this.direction)}clone(){return(new this.constructor).copy(this)}}class Matrix4{constructor(t,i,r,a,o,l,c,h,d,u,p,m,g,y,v,x){Matrix4.prototype.isMatrix4=!0,this.elements=[1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1],void 0!==t&&this.set(t,i,r,a,o,l,c,h,d,u,p,m,g,y,v,x)}set(t,i,r,a,o,l,c,h,d,u,p,m,g,y,v,x){const b=this.elements;return b[0]=t,b[4]=i,b[8]=r,b[12]=a,b[1]=o,b[5]=l,b[9]=c,b[13]=h,b[2]=d,b[6]=u,b[10]=p,b[14]=m,b[3]=g,b[7]=y,b[11]=v,b[15]=x,this}identity(){return this.set(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1),this}clone(){return(new Matrix4).fromArray(this.elements)}copy(t){const i=this.elements,r=t.elements;return i[0]=r[0],i[1]=r[1],i[2]=r[2],i[3]=r[3],i[4]=r[4],i[5]=r[5],i[6]=r[6],i[7]=r[7],i[8]=r[8],i[9]=r[9],i[10]=r[10],i[11]=r[11],i[12]=r[12],i[13]=r[13],i[14]=r[14],i[15]=r[15],this}copyPosition(t){const i=this.elements,r=t.elements;return i[12]=r[12],i[13]=r[13],i[14]=r[14],this}setFromMatrix3(t){const i=t.elements;return this.set(i[0],i[3],i[6],0,i[1],i[4],i[7],0,i[2],i[5],i[8],0,0,0,0,1),this}extractBasis(t,i,r){return t.setFromMatrixColumn(this,0),i.setFromMatrixColumn(this,1),r.setFromMatrixColumn(this,2),this}makeBasis(t,i,r){return this.set(t.x,i.x,r.x,0,t.y,i.y,r.y,0,t.z,i.z,r.z,0,0,0,0,1),this}extractRotation(t){const i=this.elements,r=t.elements,a=1/pi.setFromMatrixColumn(t,0).length(),o=1/pi.setFromMatrixColumn(t,1).length(),l=1/pi.setFromMatrixColumn(t,2).length();return i[0]=r[0]*a,i[1]=r[1]*a,i[2]=r[2]*a,i[3]=0,i[4]=r[4]*o,i[5]=r[5]*o,i[6]=r[6]*o,i[7]=0,i[8]=r[8]*l,i[9]=r[9]*l,i[10]=r[10]*l,i[11]=0,i[12]=0,i[13]=0,i[14]=0,i[15]=1,this}makeRotationFromEuler(t){const i=this.elements,r=t.x,a=t.y,o=t.z,l=Math.cos(r),c=Math.sin(r),h=Math.cos(a),d=Math.sin(a),u=Math.cos(o),p=Math.sin(o);if("XYZ"===t.order){const t=l*u,r=l*p,a=c*u,o=c*p;i[0]=h*u,i[4]=-h*p,i[8]=d,i[1]=r+a*d,i[5]=t-o*d,i[9]=-c*h,i[2]=o-t*d,i[6]=a+r*d,i[10]=l*h}else if("YXZ"===t.order){const t=h*u,r=h*p,a=d*u,o=d*p;i[0]=t+o*c,i[4]=a*c-r,i[8]=l*d,i[1]=l*p,i[5]=l*u,i[9]=-c,i[2]=r*c-a,i[6]=o+t*c,i[10]=l*h}else if("ZXY"===t.order){const t=h*u,r=h*p,a=d*u,o=d*p;i[0]=t-o*c,i[4]=-l*p,i[8]=a+r*c,i[1]=r+a*c,i[5]=l*u,i[9]=o-t*c,i[2]=-l*d,i[6]=c,i[10]=l*h}else if("ZYX"===t.order){const t=l*u,r=l*p,a=c*u,o=c*p;i[0]=h*u,i[4]=a*d-r,i[8]=t*d+o,i[1]=h*p,i[5]=o*d+t,i[9]=r*d-a,i[2]=-d,i[6]=c*h,i[10]=l*h}else if("YZX"===t.order){const t=l*h,r=l*d,a=c*h,o=c*d;i[0]=h*u,i[4]=o-t*p,i[8]=a*p+r,i[1]=p,i[5]=l*u,i[9]=-c*u,i[2]=-d*u,i[6]=r*p+a,i[10]=t-o*p}else if("XZY"===t.order){const t=l*h,r=l*d,a=c*h,o=c*d;i[0]=h*u,i[4]=-p,i[8]=d*u,i[1]=t*p+o,i[5]=l*u,i[9]=r*p-a,i[2]=a*p-r,i[6]=c*u,i[10]=o*p+t}return i[3]=0,i[7]=0,i[11]=0,i[12]=0,i[13]=0,i[14]=0,i[15]=1,this}makeRotationFromQuaternion(t){return this.compose(fi,t,gi)}lookAt(t,i,r){const a=this.elements;return xi.subVectors(t,i),0===xi.lengthSq()&&(xi.z=1),xi.normalize(),yi.crossVectors(r,xi),0===yi.lengthSq()&&(1===Math.abs(r.z)?xi.x+=1e-4:xi.z+=1e-4,xi.normalize(),yi.crossVectors(r,xi)),yi.normalize(),vi.crossVectors(xi,yi),a[0]=yi.x,a[4]=vi.x,a[8]=xi.x,a[1]=yi.y,a[5]=vi.y,a[9]=xi.y,a[2]=yi.z,a[6]=vi.z,a[10]=xi.z,this}multiply(t){return this.multiplyMatrices(this,t)}premultiply(t){return this.multiplyMatrices(t,this)}multiplyMatrices(t,i){const r=t.elements,a=i.elements,o=this.elements,l=r[0],c=r[4],h=r[8],d=r[12],u=r[1],p=r[5],m=r[9],g=r[13],y=r[2],v=r[6],x=r[10],b=r[14],_=r[3],S=r[7],M=r[11],w=r[15],T=a[0],E=a[4],A=a[8],C=a[12],P=a[1],R=a[5],I=a[9],D=a[13],L=a[2],N=a[6],O=a[10],U=a[14],B=a[3],z=a[7],V=a[11],k=a[15];return o[0]=l*T+c*P+h*L+d*B,o[4]=l*E+c*R+h*N+d*z,o[8]=l*A+c*I+h*O+d*V,o[12]=l*C+c*D+h*U+d*k,o[1]=u*T+p*P+m*L+g*B,o[5]=u*E+p*R+m*N+g*z,o[9]=u*A+p*I+m*O+g*V,o[13]=u*C+p*D+m*U+g*k,o[2]=y*T+v*P+x*L+b*B,o[6]=y*E+v*R+x*N+b*z,o[10]=y*A+v*I+x*O+b*V,o[14]=y*C+v*D+x*U+b*k,o[3]=_*T+S*P+M*L+w*B,o[7]=_*E+S*R+M*N+w*z,o[11]=_*A+S*I+M*O+w*V,o[15]=_*C+S*D+M*U+w*k,this}multiplyScalar(t){const i=this.elements;return i[0]*=t,i[4]*=t,i[8]*=t,i[12]*=t,i[1]*=t,i[5]*=t,i[9]*=t,i[13]*=t,i[2]*=t,i[6]*=t,i[10]*=t,i[14]*=t,i[3]*=t,i[7]*=t,i[11]*=t,i[15]*=t,this}determinant(){const t=this.elements,i=t[0],r=t[4],a=t[8],o=t[12],l=t[1],c=t[5],h=t[9],d=t[13],u=t[2],p=t[6],m=t[10],g=t[14];return t[3]*(+o*h*p-a*d*p-o*c*m+r*d*m+a*c*g-r*h*g)+t[7]*(+i*h*g-i*d*m+o*l*m-a*l*g+a*d*u-o*h*u)+t[11]*(+i*d*p-i*c*g-o*l*p+r*l*g+o*c*u-r*d*u)+t[15]*(-a*c*u-i*h*p+i*c*m+a*l*p-r*l*m+r*h*u)}transpose(){const t=this.elements;let i;return i=t[1],t[1]=t[4],t[4]=i,i=t[2],t[2]=t[8],t[8]=i,i=t[6],t[6]=t[9],t[9]=i,i=t[3],t[3]=t[12],t[12]=i,i=t[7],t[7]=t[13],t[13]=i,i=t[11],t[11]=t[14],t[14]=i,this}setPosition(t,i,r){const a=this.elements;return t.isVector3?(a[12]=t.x,a[13]=t.y,a[14]=t.z):(a[12]=t,a[13]=i,a[14]=r),this}invert(){const t=this.elements,i=t[0],r=t[1],a=t[2],o=t[3],l=t[4],c=t[5],h=t[6],d=t[7],u=t[8],p=t[9],m=t[10],g=t[11],y=t[12],v=t[13],x=t[14],b=t[15],_=p*x*d-v*m*d+v*h*g-c*x*g-p*h*b+c*m*b,S=y*m*d-u*x*d-y*h*g+l*x*g+u*h*b-l*m*b,M=u*v*d-y*p*d+y*c*g-l*v*g-u*c*b+l*p*b,w=y*p*h-u*v*h-y*c*m+l*v*m+u*c*x-l*p*x,T=i*_+r*S+a*M+o*w;if(0===T)return this.set(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);const E=1/T;return t[0]=_*E,t[1]=(v*m*o-p*x*o-v*a*g+r*x*g+p*a*b-r*m*b)*E,t[2]=(c*x*o-v*h*o+v*a*d-r*x*d-c*a*b+r*h*b)*E,t[3]=(p*h*o-c*m*o-p*a*d+r*m*d+c*a*g-r*h*g)*E,t[4]=S*E,t[5]=(u*x*o-y*m*o+y*a*g-i*x*g-u*a*b+i*m*b)*E,t[6]=(y*h*o-l*x*o-y*a*d+i*x*d+l*a*b-i*h*b)*E,t[7]=(l*m*o-u*h*o+u*a*d-i*m*d-l*a*g+i*h*g)*E,t[8]=M*E,t[9]=(y*p*o-u*v*o-y*r*g+i*v*g+u*r*b-i*p*b)*E,t[10]=(l*v*o-y*c*o+y*r*d-i*v*d-l*r*b+i*c*b)*E,t[11]=(u*c*o-l*p*o-u*r*d+i*p*d+l*r*g-i*c*g)*E,t[12]=w*E,t[13]=(u*v*a-y*p*a+y*r*m-i*v*m-u*r*x+i*p*x)*E,t[14]=(y*c*a-l*v*a-y*r*h+i*v*h+l*r*x-i*c*x)*E,t[15]=(l*p*a-u*c*a+u*r*h-i*p*h-l*r*m+i*c*m)*E,this}scale(t){const i=this.elements,r=t.x,a=t.y,o=t.z;return i[0]*=r,i[4]*=a,i[8]*=o,i[1]*=r,i[5]*=a,i[9]*=o,i[2]*=r,i[6]*=a,i[10]*=o,i[3]*=r,i[7]*=a,i[11]*=o,this}getMaxScaleOnAxis(){const t=this.elements,i=t[0]*t[0]+t[1]*t[1]+t[2]*t[2],r=t[4]*t[4]+t[5]*t[5]+t[6]*t[6],a=t[8]*t[8]+t[9]*t[9]+t[10]*t[10];return Math.sqrt(Math.max(i,r,a))}makeTranslation(t,i,r){return t.isVector3?this.set(1,0,0,t.x,0,1,0,t.y,0,0,1,t.z,0,0,0,1):this.set(1,0,0,t,0,1,0,i,0,0,1,r,0,0,0,1),this}makeRotationX(t){const i=Math.cos(t),r=Math.sin(t);return this.set(1,0,0,0,0,i,-r,0,0,r,i,0,0,0,0,1),this}makeRotationY(t){const i=Math.cos(t),r=Math.sin(t);return this.set(i,0,r,0,0,1,0,0,-r,0,i,0,0,0,0,1),this}makeRotationZ(t){const i=Math.cos(t),r=Math.sin(t);return this.set(i,-r,0,0,r,i,0,0,0,0,1,0,0,0,0,1),this}makeRotationAxis(t,i){const r=Math.cos(i),a=Math.sin(i),o=1-r,l=t.x,c=t.y,h=t.z,d=o*l,u=o*c;return this.set(d*l+r,d*c-a*h,d*h+a*c,0,d*c+a*h,u*c+r,u*h-a*l,0,d*h-a*c,u*h+a*l,o*h*h+r,0,0,0,0,1),this}makeScale(t,i,r){return this.set(t,0,0,0,0,i,0,0,0,0,r,0,0,0,0,1),this}makeShear(t,i,r,a,o,l){return this.set(1,r,o,0,t,1,l,0,i,a,1,0,0,0,0,1),this}compose(t,i,r){const a=this.elements,o=i._x,l=i._y,c=i._z,h=i._w,d=o+o,u=l+l,p=c+c,m=o*d,g=o*u,y=o*p,v=l*u,x=l*p,b=c*p,_=h*d,S=h*u,M=h*p,w=r.x,T=r.y,E=r.z;return a[0]=(1-(v+b))*w,a[1]=(g+M)*w,a[2]=(y-S)*w,a[3]=0,a[4]=(g-M)*T,a[5]=(1-(m+b))*T,a[6]=(x+_)*T,a[7]=0,a[8]=(y+S)*E,a[9]=(x-_)*E,a[10]=(1-(m+v))*E,a[11]=0,a[12]=t.x,a[13]=t.y,a[14]=t.z,a[15]=1,this}decompose(t,i,r){const a=this.elements;let o=pi.set(a[0],a[1],a[2]).length();const l=pi.set(a[4],a[5],a[6]).length(),c=pi.set(a[8],a[9],a[10]).length();this.determinant()<0&&(o=-o),t.x=a[12],t.y=a[13],t.z=a[14],mi.copy(this);const h=1/o,d=1/l,u=1/c;return mi.elements[0]*=h,mi.elements[1]*=h,mi.elements[2]*=h,mi.elements[4]*=d,mi.elements[5]*=d,mi.elements[6]*=d,mi.elements[8]*=u,mi.elements[9]*=u,mi.elements[10]*=u,i.setFromRotationMatrix(mi),r.x=o,r.y=l,r.z=c,this}makePerspective(t,i,r,a,o,l,c=2e3){const h=this.elements,d=2*o/(i-t),u=2*o/(r-a),p=(i+t)/(i-t),m=(r+a)/(r-a);let g,y;if(c===Mt)g=-(l+o)/(l-o),y=-2*l*o/(l-o);else{if(c!==wt)throw new Error("THREE.Matrix4.makePerspective(): Invalid coordinate system: "+c);g=-l/(l-o),y=-l*o/(l-o)}return h[0]=d,h[4]=0,h[8]=p,h[12]=0,h[1]=0,h[5]=u,h[9]=m,h[13]=0,h[2]=0,h[6]=0,h[10]=g,h[14]=y,h[3]=0,h[7]=0,h[11]=-1,h[15]=0,this}makeOrthographic(t,i,r,a,o,l,c=2e3){const h=this.elements,d=1/(i-t),u=1/(r-a),p=1/(l-o),m=(i+t)*d,g=(r+a)*u;let y,v;if(c===Mt)y=(l+o)*p,v=-2*p;else{if(c!==wt)throw new Error("THREE.Matrix4.makeOrthographic(): Invalid coordinate system: "+c);y=o*p,v=-1*p}return h[0]=2*d,h[4]=0,h[8]=0,h[12]=-m,h[1]=0,h[5]=2*u,h[9]=0,h[13]=-g,h[2]=0,h[6]=0,h[10]=v,h[14]=-y,h[3]=0,h[7]=0,h[11]=0,h[15]=1,this}equals(t){const i=this.elements,r=t.elements;for(let t=0;t<16;t++)if(i[t]!==r[t])return!1;return!0}fromArray(t,i=0){for(let r=0;r<16;r++)this.elements[r]=t[r+i];return this}toArray(t=[],i=0){const r=this.elements;return t[i]=r[0],t[i+1]=r[1],t[i+2]=r[2],t[i+3]=r[3],t[i+4]=r[4],t[i+5]=r[5],t[i+6]=r[6],t[i+7]=r[7],t[i+8]=r[8],t[i+9]=r[9],t[i+10]=r[10],t[i+11]=r[11],t[i+12]=r[12],t[i+13]=r[13],t[i+14]=r[14],t[i+15]=r[15],t}}const pi=new Vector3,mi=new Matrix4,fi=new Vector3(0,0,0),gi=new Vector3(1,1,1),yi=new Vector3,vi=new Vector3,xi=new Vector3,bi=new Matrix4,_i=new Vt;class Euler{constructor(t=0,i=0,r=0,a=Euler.DEFAULT_ORDER){this.isEuler=!0,this._x=t,this._y=i,this._z=r,this._order=a}get x(){return this._x}set x(t){this._x=t,this._onChangeCallback()}get y(){return this._y}set y(t){this._y=t,this._onChangeCallback()}get z(){return this._z}set z(t){this._z=t,this._onChangeCallback()}get order(){return this._order}set order(t){this._order=t,this._onChangeCallback()}set(t,i,r,a=this._order){return this._x=t,this._y=i,this._z=r,this._order=a,this._onChangeCallback(),this}clone(){return new this.constructor(this._x,this._y,this._z,this._order)}copy(t){return this._x=t._x,this._y=t._y,this._z=t._z,this._order=t._order,this._onChangeCallback(),this}setFromRotationMatrix(t,i=this._order,r=!0){const a=t.elements,o=a[0],l=a[4],c=a[8],h=a[1],d=a[5],u=a[9],p=a[2],m=a[6],g=a[10];switch(i){case"XYZ":this._y=Math.asin(clamp(c,-1,1)),Math.abs(c)<.9999999?(this._x=Math.atan2(-u,g),this._z=Math.atan2(-l,o)):(this._x=Math.atan2(m,d),this._z=0);break;case"YXZ":this._x=Math.asin(-clamp(u,-1,1)),Math.abs(u)<.9999999?(this._y=Math.atan2(c,g),this._z=Math.atan2(h,d)):(this._y=Math.atan2(-p,o),this._z=0);break;case"ZXY":this._x=Math.asin(clamp(m,-1,1)),Math.abs(m)<.9999999?(this._y=Math.atan2(-p,g),this._z=Math.atan2(-l,d)):(this._y=0,this._z=Math.atan2(h,o));break;case"ZYX":this._y=Math.asin(-clamp(p,-1,1)),Math.abs(p)<.9999999?(this._x=Math.atan2(m,g),this._z=Math.atan2(h,o)):(this._x=0,this._z=Math.atan2(-l,d));break;case"YZX":this._z=Math.asin(clamp(h,-1,1)),Math.abs(h)<.9999999?(this._x=Math.atan2(-u,d),this._y=Math.atan2(-p,o)):(this._x=0,this._y=Math.atan2(c,g));break;case"XZY":this._z=Math.asin(-clamp(l,-1,1)),Math.abs(l)<.9999999?(this._x=Math.atan2(m,d),this._y=Math.atan2(c,o)):(this._x=Math.atan2(-u,g),this._y=0)}return this._order=i,!0===r&&this._onChangeCallback(),this}setFromQuaternion(t,i,r){return bi.makeRotationFromQuaternion(t),this.setFromRotationMatrix(bi,i,r)}setFromVector3(t,i=this._order){return this.set(t.x,t.y,t.z,i)}reorder(t){return _i.setFromEuler(this),this.setFromQuaternion(_i,t)}equals(t){return t._x===this._x&&t._y===this._y&&t._z===this._z&&t._order===this._order}fromArray(t){return this._x=t[0],this._y=t[1],this._z=t[2],void 0!==t[3]&&(this._order=t[3]),this._onChangeCallback(),this}toArray(t=[],i=0){return t[i]=this._x,t[i+1]=this._y,t[i+2]=this._z,t[i+3]=this._order,t}_onChange(t){return this._onChangeCallback=t,this}_onChangeCallback(){}*[Symbol.iterator](){yield this._x,yield this._y,yield this._z,yield this._order}}Euler.DEFAULT_ORDER="XYZ";class Layers{constructor(){this.mask=1}set(t){this.mask=1<<t>>>0}enable(t){this.mask|=1<<t}enableAll(){this.mask=-1}toggle(t){this.mask^=1<<t}disable(t){this.mask&=~(1<<t)}disableAll(){this.mask=0}test(t){return!!(this.mask&t.mask)}isEnabled(t){return!!(this.mask&1<<t)}}let Si=0;const Mi=new Vector3,wi=new Vt,Ti=new Matrix4,Ei=new Vector3,Ai=new Vector3,Ci=new Vector3,Pi=new Vt,Ri=new Vector3(1,0,0),Ii=new Vector3(0,1,0),Di=new Vector3(0,0,1),Li={type:"added"},Fi={type:"removed"},Ni={type:"childadded",child:null},Oi={type:"childremoved",child:null};class Object3D extends Tt{constructor(){super(),this.isObject3D=!0,Object.defineProperty(this,"id",{value:Si++}),this.uuid=generateUUID(),this.name="",this.type="Object3D",this.parent=null,this.children=[],this.up=Object3D.DEFAULT_UP.clone();const t=new Vector3,i=new Euler,r=new Vt,a=new Vector3(1,1,1);i._onChange((function onRotationChange(){r.setFromEuler(i,!1)})),r._onChange((function onQuaternionChange(){i.setFromQuaternion(r,void 0,!1)})),Object.defineProperties(this,{position:{configurable:!0,enumerable:!0,value:t},rotation:{configurable:!0,enumerable:!0,value:i},quaternion:{configurable:!0,enumerable:!0,value:r},scale:{configurable:!0,enumerable:!0,value:a},modelViewMatrix:{value:new Matrix4},normalMatrix:{value:new Matrix3}}),this.matrix=new Matrix4,this.matrixWorld=new Matrix4,this.matrixAutoUpdate=Object3D.DEFAULT_MATRIX_AUTO_UPDATE,this.matrixWorldAutoUpdate=Object3D.DEFAULT_MATRIX_WORLD_AUTO_UPDATE,this.matrixWorldNeedsUpdate=!1,this.layers=new Layers,this.visible=!0,this.castShadow=!1,this.receiveShadow=!1,this.frustumCulled=!0,this.renderOrder=0,this.animations=[],this.userData={}}onBeforeShadow(){}onAfterShadow(){}onBeforeRender(){}onAfterRender(){}applyMatrix4(t){this.matrixAutoUpdate&&this.updateMatrix(),this.matrix.premultiply(t),this.matrix.decompose(this.position,this.quaternion,this.scale)}applyQuaternion(t){return this.quaternion.premultiply(t),this}setRotationFromAxisAngle(t,i){this.quaternion.setFromAxisAngle(t,i)}setRotationFromEuler(t){this.quaternion.setFromEuler(t,!0)}setRotationFromMatrix(t){this.quaternion.setFromRotationMatrix(t)}setRotationFromQuaternion(t){this.quaternion.copy(t)}rotateOnAxis(t,i){return wi.setFromAxisAngle(t,i),this.quaternion.multiply(wi),this}rotateOnWorldAxis(t,i){return wi.setFromAxisAngle(t,i),this.quaternion.premultiply(wi),this}rotateX(t){return this.rotateOnAxis(Ri,t)}rotateY(t){return this.rotateOnAxis(Ii,t)}rotateZ(t){return this.rotateOnAxis(Di,t)}translateOnAxis(t,i){return Mi.copy(t).applyQuaternion(this.quaternion),this.position.add(Mi.multiplyScalar(i)),this}translateX(t){return this.translateOnAxis(Ri,t)}translateY(t){return this.translateOnAxis(Ii,t)}translateZ(t){return this.translateOnAxis(Di,t)}localToWorld(t){return this.updateWorldMatrix(!0,!1),t.applyMatrix4(this.matrixWorld)}worldToLocal(t){return this.updateWorldMatrix(!0,!1),t.applyMatrix4(Ti.copy(this.matrixWorld).invert())}lookAt(t,i,r){t.isVector3?Ei.copy(t):Ei.set(t,i,r);const a=this.parent;this.updateWorldMatrix(!0,!1),Ai.setFromMatrixPosition(this.matrixWorld),this.isCamera||this.isLight?Ti.lookAt(Ai,Ei,this.up):Ti.lookAt(Ei,Ai,this.up),this.quaternion.setFromRotationMatrix(Ti),a&&(Ti.extractRotation(a.matrixWorld),wi.setFromRotationMatrix(Ti),this.quaternion.premultiply(wi.invert()))}add(t){if(arguments.length>1){for(let t=0;t<arguments.length;t++)this.add(arguments[t]);return this}return t===this||t&&t.isObject3D&&(t.removeFromParent(),t.parent=this,this.children.push(t),t.dispatchEvent(Li),Ni.child=t,this.dispatchEvent(Ni),Ni.child=null),this}remove(t){if(arguments.length>1){for(let t=0;t<arguments.length;t++)this.remove(arguments[t]);return this}const i=this.children.indexOf(t);return-1!==i&&(t.parent=null,this.children.splice(i,1),t.dispatchEvent(Fi),Oi.child=t,this.dispatchEvent(Oi),Oi.child=null),this}removeFromParent(){const t=this.parent;return null!==t&&t.remove(this),this}clear(){return this.remove(...this.children)}attach(t){return this.updateWorldMatrix(!0,!1),Ti.copy(this.matrixWorld).invert(),null!==t.parent&&(t.parent.updateWorldMatrix(!0,!1),Ti.multiply(t.parent.matrixWorld)),t.applyMatrix4(Ti),t.removeFromParent(),t.parent=this,this.children.push(t),t.updateWorldMatrix(!1,!0),t.dispatchEvent(Li),Ni.child=t,this.dispatchEvent(Ni),Ni.child=null,this}getObjectById(t){return this.getObjectByProperty("id",t)}getObjectByName(t){return this.getObjectByProperty("name",t)}getObjectByProperty(t,i){if(this[t]===i)return this;for(let r=0,a=this.children.length;r<a;r++){const a=this.children[r].getObjectByProperty(t,i);if(void 0!==a)return a}}getObjectsByProperty(t,i,r=[]){this[t]===i&&r.push(this);const a=this.children;for(let o=0,l=a.length;o<l;o++)a[o].getObjectsByProperty(t,i,r);return r}getWorldPosition(t){return this.updateWorldMatrix(!0,!1),t.setFromMatrixPosition(this.matrixWorld)}getWorldQuaternion(t){return this.updateWorldMatrix(!0,!1),this.matrixWorld.decompose(Ai,t,Ci),t}getWorldScale(t){return this.updateWorldMatrix(!0,!1),this.matrixWorld.decompose(Ai,Pi,t),t}getWorldDirection(t){this.updateWorldMatrix(!0,!1);const i=this.matrixWorld.elements;return t.set(i[8],i[9],i[10]).normalize()}raycast(){}traverse(t){t(this);const i=this.children;for(let r=0,a=i.length;r<a;r++)i[r].traverse(t)}traverseVisible(t){if(!1===this.visible)return;t(this);const i=this.children;for(let r=0,a=i.length;r<a;r++)i[r].traverseVisible(t)}traverseAncestors(t){const i=this.parent;null!==i&&(t(i),i.traverseAncestors(t))}updateMatrix(){this.matrix.compose(this.position,this.quaternion,this.scale),this.matrixWorldNeedsUpdate=!0}updateMatrixWorld(t){this.matrixAutoUpdate&&this.updateMatrix(),(this.matrixWorldNeedsUpdate||t)&&(!0===this.matrixWorldAutoUpdate&&(null===this.parent?this.matrixWorld.copy(this.matrix):this.matrixWorld.multiplyMatrices(this.parent.matrixWorld,this.matrix)),this.matrixWorldNeedsUpdate=!1,t=!0);const i=this.children;for(let r=0,a=i.length;r<a;r++){i[r].updateMatrixWorld(t)}}updateWorldMatrix(t,i){const r=this.parent;if(!0===t&&null!==r&&r.updateWorldMatrix(!0,!1),this.matrixAutoUpdate&&this.updateMatrix(),!0===this.matrixWorldAutoUpdate&&(null===this.parent?this.matrixWorld.copy(this.matrix):this.matrixWorld.multiplyMatrices(this.parent.matrixWorld,this.matrix)),!0===i){const t=this.children;for(let i=0,r=t.length;i<r;i++){t[i].updateWorldMatrix(!1,!0)}}}toJSON(t){const i=void 0===t||"string"==typeof t,r={};i&&(t={geometries:{},materials:{},textures:{},images:{},shapes:{},skeletons:{},animations:{},nodes:{}},r.metadata={version:4.6,type:"Object",generator:"Object3D.toJSON"});const a={};function serialize(i,r){return void 0===i[r.uuid]&&(i[r.uuid]=r.toJSON(t)),r.uuid}if(a.uuid=this.uuid,a.type=this.type,""!==this.name&&(a.name=this.name),!0===this.castShadow&&(a.castShadow=!0),!0===this.receiveShadow&&(a.receiveShadow=!0),!1===this.visible&&(a.visible=!1),!1===this.frustumCulled&&(a.frustumCulled=!1),0!==this.renderOrder&&(a.renderOrder=this.renderOrder),Object.keys(this.userData).length>0&&(a.userData=this.userData),a.layers=this.layers.mask,a.matrix=this.matrix.toArray(),a.up=this.up.toArray(),!1===this.matrixAutoUpdate&&(a.matrixAutoUpdate=!1),this.isInstancedMesh&&(a.type="InstancedMesh",a.count=this.count,a.instanceMatrix=this.instanceMatrix.toJSON(),null!==this.instanceColor&&(a.instanceColor=this.instanceColor.toJSON())),this.isBatchedMesh&&(a.type="BatchedMesh",a.perObjectFrustumCulled=this.perObjectFrustumCulled,a.sortObjects=this.sortObjects,a.drawRanges=this._drawRanges,a.reservedRanges=this._reservedRanges,a.visibility=this._visibility,a.active=this._active,a.bounds=this._bounds.map((t=>({boxInitialized:t.boxInitialized,boxMin:t.box.min.toArray(),boxMax:t.box.max.toArray(),sphereInitialized:t.sphereInitialized,sphereRadius:t.sphere.radius,sphereCenter:t.sphere.center.toArray()}))),a.maxInstanceCount=this._maxInstanceCount,a.maxVertexCount=this._maxVertexCount,a.maxIndexCount=this._maxIndexCount,a.geometryInitialized=this._geometryInitialized,a.geometryCount=this._geometryCount,a.matricesTexture=this._matricesTexture.toJSON(t),null!==this._colorsTexture&&(a.colorsTexture=this._colorsTexture.toJSON(t)),null!==this.boundingSphere&&(a.boundingSphere={center:a.boundingSphere.center.toArray(),radius:a.boundingSphere.radius}),null!==this.boundingBox&&(a.boundingBox={min:a.boundingBox.min.toArray(),max:a.boundingBox.max.toArray()})),this.isScene)this.background&&(this.background.isColor?a.background=this.background.toJSON():this.background.isTexture&&(a.background=this.background.toJSON(t).uuid)),this.environment&&this.environment.isTexture&&!0!==this.environment.isRenderTargetTexture&&(a.environment=this.environment.toJSON(t).uuid);else if(this.isMesh||this.isLine||this.isPoints){a.geometry=serialize(t.geometries,this.geometry);const i=this.geometry.parameters;if(void 0!==i&&void 0!==i.shapes){const r=i.shapes;if(Array.isArray(r))for(let i=0,a=r.length;i<a;i++){const a=r[i];serialize(t.shapes,a)}else serialize(t.shapes,r)}}if(this.isSkinnedMesh&&(a.bindMode=this.bindMode,a.bindMatrix=this.bindMatrix.toArray(),void 0!==this.skeleton&&(serialize(t.skeletons,this.skeleton),a.skeleton=this.skeleton.uuid)),void 0!==this.material)if(Array.isArray(this.material)){const i=[];for(let r=0,a=this.material.length;r<a;r++)i.push(serialize(t.materials,this.material[r]));a.material=i}else a.material=serialize(t.materials,this.material);if(this.children.length>0){a.children=[];for(let i=0;i<this.children.length;i++)a.children.push(this.children[i].toJSON(t).object)}if(this.animations.length>0){a.animations=[];for(let i=0;i<this.animations.length;i++){const r=this.animations[i];a.animations.push(serialize(t.animations,r))}}if(i){const i=extractFromCache(t.geometries),a=extractFromCache(t.materials),o=extractFromCache(t.textures),l=extractFromCache(t.images),c=extractFromCache(t.shapes),h=extractFromCache(t.skeletons),d=extractFromCache(t.animations),u=extractFromCache(t.nodes);i.length>0&&(r.geometries=i),a.length>0&&(r.materials=a),o.length>0&&(r.textures=o),l.length>0&&(r.images=l),c.length>0&&(r.shapes=c),h.length>0&&(r.skeletons=h),d.length>0&&(r.animations=d),u.length>0&&(r.nodes=u)}return r.object=a,r;function extractFromCache(t){const i=[];for(const r in t){const a=t[r];delete a.metadata,i.push(a)}return i}}clone(t){return(new this.constructor).copy(this,t)}copy(t,i=!0){if(this.name=t.name,this.up.copy(t.up),this.position.copy(t.position),this.rotation.order=t.rotation.order,this.quaternion.copy(t.quaternion),this.scale.copy(t.scale),this.matrix.copy(t.matrix),this.matrixWorld.copy(t.matrixWorld),this.matrixAutoUpdate=t.matrixAutoUpdate,this.matrixWorldAutoUpdate=t.matrixWorldAutoUpdate,this.matrixWorldNeedsUpdate=t.matrixWorldNeedsUpdate,this.layers.mask=t.layers.mask,this.visible=t.visible,this.castShadow=t.castShadow,this.receiveShadow=t.receiveShadow,this.frustumCulled=t.frustumCulled,this.renderOrder=t.renderOrder,this.animations=t.animations.slice(),this.userData=JSON.parse(JSON.stringify(t.userData)),!0===i)for(let i=0;i<t.children.length;i++){const r=t.children[i];this.add(r.clone())}return this}}Object3D.DEFAULT_UP=new Vector3(0,1,0),Object3D.DEFAULT_MATRIX_AUTO_UPDATE=!0,Object3D.DEFAULT_MATRIX_WORLD_AUTO_UPDATE=!0;const Ui=new Vector3,Bi=new Vector3,zi=new Vector3,Vi=new Vector3,ki=new Vector3,Gi=new Vector3,Hi=new Vector3,Wi=new Vector3,ji=new Vector3,Xi=new Vector3,qi=new Vector4,Yi=new Vector4,Zi=new Vector4;class Triangle{constructor(t=new Vector3,i=new Vector3,r=new Vector3){this.a=t,this.b=i,this.c=r}static getNormal(t,i,r,a){a.subVectors(r,i),Ui.subVectors(t,i),a.cross(Ui);const o=a.lengthSq();return o>0?a.multiplyScalar(1/Math.sqrt(o)):a.set(0,0,0)}static getBarycoord(t,i,r,a,o){Ui.subVectors(a,i),Bi.subVectors(r,i),zi.subVectors(t,i);const l=Ui.dot(Ui),c=Ui.dot(Bi),h=Ui.dot(zi),d=Bi.dot(Bi),u=Bi.dot(zi),p=l*d-c*c;if(0===p)return o.set(0,0,0),null;const m=1/p,g=(d*h-c*u)*m,y=(l*u-c*h)*m;return o.set(1-g-y,y,g)}static containsPoint(t,i,r,a){return null!==this.getBarycoord(t,i,r,a,Vi)&&(Vi.x>=0&&Vi.y>=0&&Vi.x+Vi.y<=1)}static getInterpolation(t,i,r,a,o,l,c,h){return null===this.getBarycoord(t,i,r,a,Vi)?(h.x=0,h.y=0,"z"in h&&(h.z=0),"w"in h&&(h.w=0),null):(h.setScalar(0),h.addScaledVector(o,Vi.x),h.addScaledVector(l,Vi.y),h.addScaledVector(c,Vi.z),h)}static getInterpolatedAttribute(t,i,r,a,o,l){return qi.setScalar(0),Yi.setScalar(0),Zi.setScalar(0),qi.fromBufferAttribute(t,i),Yi.fromBufferAttribute(t,r),Zi.fromBufferAttribute(t,a),l.setScalar(0),l.addScaledVector(qi,o.x),l.addScaledVector(Yi,o.y),l.addScaledVector(Zi,o.z),l}static isFrontFacing(t,i,r,a){return Ui.subVectors(r,i),Bi.subVectors(t,i),Ui.cross(Bi).dot(a)<0}set(t,i,r){return this.a.copy(t),this.b.copy(i),this.c.copy(r),this}setFromPointsAndIndices(t,i,r,a){return this.a.copy(t[i]),this.b.copy(t[r]),this.c.copy(t[a]),this}setFromAttributeAndIndices(t,i,r,a){return this.a.fromBufferAttribute(t,i),this.b.fromBufferAttribute(t,r),this.c.fromBufferAttribute(t,a),this}clone(){return(new this.constructor).copy(this)}copy(t){return this.a.copy(t.a),this.b.copy(t.b),this.c.copy(t.c),this}getArea(){return Ui.subVectors(this.c,this.b),Bi.subVectors(this.a,this.b),.5*Ui.cross(Bi).length()}getMidpoint(t){return t.addVectors(this.a,this.b).add(this.c).multiplyScalar(1/3)}getNormal(t){return Triangle.getNormal(this.a,this.b,this.c,t)}getPlane(t){return t.setFromCoplanarPoints(this.a,this.b,this.c)}getBarycoord(t,i){return Triangle.getBarycoord(t,this.a,this.b,this.c,i)}getInterpolation(t,i,r,a,o){return Triangle.getInterpolation(t,this.a,this.b,this.c,i,r,a,o)}containsPoint(t){return Triangle.containsPoint(t,this.a,this.b,this.c)}isFrontFacing(t){return Triangle.isFrontFacing(this.a,this.b,this.c,t)}intersectsBox(t){return t.intersectsTriangle(this)}closestPointToPoint(t,i){const r=this.a,a=this.b,o=this.c;let l,c;ki.subVectors(a,r),Gi.subVectors(o,r),Wi.subVectors(t,r);const h=ki.dot(Wi),d=Gi.dot(Wi);if(h<=0&&d<=0)return i.copy(r);ji.subVectors(t,a);const u=ki.dot(ji),p=Gi.dot(ji);if(u>=0&&p<=u)return i.copy(a);const m=h*p-u*d;if(m<=0&&h>=0&&u<=0)return l=h/(h-u),i.copy(r).addScaledVector(ki,l);Xi.subVectors(t,o);const g=ki.dot(Xi),y=Gi.dot(Xi);if(y>=0&&g<=y)return i.copy(o);const v=g*d-h*y;if(v<=0&&d>=0&&y<=0)return c=d/(d-y),i.copy(r).addScaledVector(Gi,c);const x=u*y-g*p;if(x<=0&&p-u>=0&&g-y>=0)return Hi.subVectors(o,a),c=(p-u)/(p-u+(g-y)),i.copy(a).addScaledVector(Hi,c);const b=1/(x+v+m);return l=v*b,c=m*b,i.copy(r).addScaledVector(ki,l).addScaledVector(Gi,c)}equals(t){return t.a.equals(this.a)&&t.b.equals(this.b)&&t.c.equals(this.c)}}const Ki={aliceblue:15792383,antiquewhite:16444375,aqua:65535,aquamarine:8388564,azure:15794175,beige:16119260,bisque:16770244,black:0,blanchedalmond:16772045,blue:255,blueviolet:9055202,brown:10824234,burlywood:14596231,cadetblue:6266528,chartreuse:8388352,chocolate:13789470,coral:16744272,cornflowerblue:6591981,cornsilk:16775388,crimson:14423100,cyan:65535,darkblue:139,darkcyan:35723,darkgoldenrod:12092939,darkgray:11119017,darkgreen:25600,darkgrey:11119017,darkkhaki:12433259,darkmagenta:9109643,darkolivegreen:5597999,darkorange:16747520,darkorchid:10040012,darkred:9109504,darksalmon:15308410,darkseagreen:9419919,darkslateblue:4734347,darkslategray:3100495,darkslategrey:3100495,darkturquoise:52945,darkviolet:9699539,deeppink:16716947,deepskyblue:49151,dimgray:6908265,dimgrey:6908265,dodgerblue:2003199,firebrick:11674146,floralwhite:16775920,forestgreen:2263842,fuchsia:16711935,gainsboro:14474460,ghostwhite:16316671,gold:16766720,goldenrod:14329120,gray:8421504,green:32768,greenyellow:11403055,grey:8421504,honeydew:15794160,hotpink:16738740,indianred:13458524,indigo:4915330,ivory:16777200,khaki:15787660,lavender:15132410,lavenderblush:16773365,lawngreen:8190976,lemonchiffon:16775885,lightblue:11393254,lightcoral:15761536,lightcyan:14745599,lightgoldenrodyellow:16448210,lightgray:13882323,lightgreen:9498256,lightgrey:13882323,lightpink:16758465,lightsalmon:16752762,lightseagreen:2142890,lightskyblue:8900346,lightslategray:7833753,lightslategrey:7833753,lightsteelblue:11584734,lightyellow:16777184,lime:65280,limegreen:3329330,linen:16445670,magenta:16711935,maroon:8388608,mediumaquamarine:6737322,mediumblue:205,mediumorchid:12211667,mediumpurple:9662683,mediumseagreen:3978097,mediumslateblue:8087790,mediumspringgreen:64154,mediumturquoise:4772300,mediumvioletred:13047173,midnightblue:1644912,mintcream:16121850,mistyrose:16770273,moccasin:16770229,navajowhite:16768685,navy:128,oldlace:16643558,olive:8421376,olivedrab:7048739,orange:16753920,orangered:16729344,orchid:14315734,palegoldenrod:15657130,palegreen:10025880,paleturquoise:11529966,palevioletred:14381203,papayawhip:16773077,peachpuff:16767673,peru:13468991,pink:16761035,plum:14524637,powderblue:11591910,purple:8388736,rebeccapurple:6697881,red:16711680,rosybrown:12357519,royalblue:4286945,saddlebrown:9127187,salmon:16416882,sandybrown:16032864,seagreen:3050327,seashell:16774638,sienna:10506797,silver:12632256,skyblue:8900331,slateblue:6970061,slategray:7372944,slategrey:7372944,snow:16775930,springgreen:65407,steelblue:4620980,tan:13808780,teal:32896,thistle:14204888,tomato:16737095,turquoise:4251856,violet:15631086,wheat:16113331,white:16777215,whitesmoke:16119285,yellow:16776960,yellowgreen:10145074},Qi={h:0,s:0,l:0},Ji={h:0,s:0,l:0};function hue2rgb(t,i,r){return r<0&&(r+=1),r>1&&(r-=1),r<1/6?t+6*(i-t)*r:r<.5?i:r<2/3?t+6*(i-t)*(2/3-r):t}let $i=class Color{constructor(t,i,r){return this.isColor=!0,this.r=1,this.g=1,this.b=1,this.set(t,i,r)}set(t,i,r){if(void 0===i&&void 0===r){const i=t;i&&i.isColor?this.copy(i):"number"==typeof i?this.setHex(i):"string"==typeof i&&this.setStyle(i)}else this.setRGB(t,i,r);return this}setScalar(t){return this.r=t,this.g=t,this.b=t,this}setHex(t,i=lt){return t=Math.floor(t),this.r=(t>>16&255)/255,this.g=(t>>8&255)/255,this.b=(255&t)/255,Ot.toWorkingColorSpace(this,i),this}setRGB(t,i,r,a=Ot.workingColorSpace){return this.r=t,this.g=i,this.b=r,Ot.toWorkingColorSpace(this,a),this}setHSL(t,i,r,a=Ot.workingColorSpace){if(t=euclideanModulo(t,1),i=clamp(i,0,1),r=clamp(r,0,1),0===i)this.r=this.g=this.b=r;else{const a=r<=.5?r*(1+i):r+i-r*i,o=2*r-a;this.r=hue2rgb(o,a,t+1/3),this.g=hue2rgb(o,a,t),this.b=hue2rgb(o,a,t-1/3)}return Ot.toWorkingColorSpace(this,a),this}setStyle(t,i=lt){function handleAlpha(t){void 0!==t&&parseFloat(t)}let r;if(r=/^(\w+)\(([^\)]*)\)/.exec(t)){let t;const a=r[1],o=r[2];switch(a){case"rgb":case"rgba":if(t=/^\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*(?:,\s*(\d*\.?\d+)\s*)?$/.exec(o))return handleAlpha(t[4]),this.setRGB(Math.min(255,parseInt(t[1],10))/255,Math.min(255,parseInt(t[2],10))/255,Math.min(255,parseInt(t[3],10))/255,i);if(t=/^\s*(\d+)\%\s*,\s*(\d+)\%\s*,\s*(\d+)\%\s*(?:,\s*(\d*\.?\d+)\s*)?$/.exec(o))return handleAlpha(t[4]),this.setRGB(Math.min(100,parseInt(t[1],10))/100,Math.min(100,parseInt(t[2],10))/100,Math.min(100,parseInt(t[3],10))/100,i);break;case"hsl":case"hsla":if(t=/^\s*(\d*\.?\d+)\s*,\s*(\d*\.?\d+)\%\s*,\s*(\d*\.?\d+)\%\s*(?:,\s*(\d*\.?\d+)\s*)?$/.exec(o))return handleAlpha(t[4]),this.setHSL(parseFloat(t[1])/360,parseFloat(t[2])/100,parseFloat(t[3])/100,i)}}else if(r=/^\#([A-Fa-f\d]+)$/.exec(t)){const t=r[1],a=t.length;if(3===a)return this.setRGB(parseInt(t.charAt(0),16)/15,parseInt(t.charAt(1),16)/15,parseInt(t.charAt(2),16)/15,i);if(6===a)return this.setHex(parseInt(t,16),i)}else if(t&&t.length>0)return this.setColorName(t,i);return this}setColorName(t,i=lt){const r=Ki[t.toLowerCase()];return void 0!==r&&this.setHex(r,i),this}clone(){return new this.constructor(this.r,this.g,this.b)}copy(t){return this.r=t.r,this.g=t.g,this.b=t.b,this}copySRGBToLinear(t){return this.r=SRGBToLinear(t.r),this.g=SRGBToLinear(t.g),this.b=SRGBToLinear(t.b),this}copyLinearToSRGB(t){return this.r=LinearToSRGB(t.r),this.g=LinearToSRGB(t.g),this.b=LinearToSRGB(t.b),this}convertSRGBToLinear(){return this.copySRGBToLinear(this),this}convertLinearToSRGB(){return this.copyLinearToSRGB(this),this}getHex(t=lt){return Ot.fromWorkingColorSpace(en.copy(this),t),65536*Math.round(clamp(255*en.r,0,255))+256*Math.round(clamp(255*en.g,0,255))+Math.round(clamp(255*en.b,0,255))}getHexString(t=lt){return("000000"+this.getHex(t).toString(16)).slice(-6)}getHSL(t,i=Ot.workingColorSpace){Ot.fromWorkingColorSpace(en.copy(this),i);const r=en.r,a=en.g,o=en.b,l=Math.max(r,a,o),c=Math.min(r,a,o);let h,d;const u=(c+l)/2;if(c===l)h=0,d=0;else{const t=l-c;switch(d=u<=.5?t/(l+c):t/(2-l-c),l){case r:h=(a-o)/t+(a<o?6:0);break;case a:h=(o-r)/t+2;break;case o:h=(r-a)/t+4}h/=6}return t.h=h,t.s=d,t.l=u,t}getRGB(t,i=Ot.workingColorSpace){return Ot.fromWorkingColorSpace(en.copy(this),i),t.r=en.r,t.g=en.g,t.b=en.b,t}getStyle(t=lt){Ot.fromWorkingColorSpace(en.copy(this),t);const i=en.r,r=en.g,a=en.b;return t!==lt?`color(${t} ${i.toFixed(3)} ${r.toFixed(3)} ${a.toFixed(3)})`:`rgb(${Math.round(255*i)},${Math.round(255*r)},${Math.round(255*a)})`}offsetHSL(t,i,r){return this.getHSL(Qi),this.setHSL(Qi.h+t,Qi.s+i,Qi.l+r)}add(t){return this.r+=t.r,this.g+=t.g,this.b+=t.b,this}addColors(t,i){return this.r=t.r+i.r,this.g=t.g+i.g,this.b=t.b+i.b,this}addScalar(t){return this.r+=t,this.g+=t,this.b+=t,this}sub(t){return this.r=Math.max(0,this.r-t.r),this.g=Math.max(0,this.g-t.g),this.b=Math.max(0,this.b-t.b),this}multiply(t){return this.r*=t.r,this.g*=t.g,this.b*=t.b,this}multiplyScalar(t){return this.r*=t,this.g*=t,this.b*=t,this}lerp(t,i){return this.r+=(t.r-this.r)*i,this.g+=(t.g-this.g)*i,this.b+=(t.b-this.b)*i,this}lerpColors(t,i,r){return this.r=t.r+(i.r-t.r)*r,this.g=t.g+(i.g-t.g)*r,this.b=t.b+(i.b-t.b)*r,this}lerpHSL(t,i){this.getHSL(Qi),t.getHSL(Ji);const r=lerp(Qi.h,Ji.h,i),a=lerp(Qi.s,Ji.s,i),o=lerp(Qi.l,Ji.l,i);return this.setHSL(r,a,o),this}setFromVector3(t){return this.r=t.x,this.g=t.y,this.b=t.z,this}applyMatrix3(t){const i=this.r,r=this.g,a=this.b,o=t.elements;return this.r=o[0]*i+o[3]*r+o[6]*a,this.g=o[1]*i+o[4]*r+o[7]*a,this.b=o[2]*i+o[5]*r+o[8]*a,this}equals(t){return t.r===this.r&&t.g===this.g&&t.b===this.b}fromArray(t,i=0){return this.r=t[i],this.g=t[i+1],this.b=t[i+2],this}toArray(t=[],i=0){return t[i]=this.r,t[i+1]=this.g,t[i+2]=this.b,t}fromBufferAttribute(t,i){return this.r=t.getX(i),this.g=t.getY(i),this.b=t.getZ(i),this}toJSON(){return this.getHex()}*[Symbol.iterator](){yield this.r,yield this.g,yield this.b}};const en=new $i;$i.NAMES=Ki;let tn=0;class Material extends Tt{constructor(){super(),this.isMaterial=!0,Object.defineProperty(this,"id",{value:tn++}),this.uuid=generateUUID(),this.name="",this.type="Material",this.blending=1,this.side=0,this.vertexColors=!1,this.opacity=1,this.transparent=!1,this.alphaHash=!1,this.blendSrc=w,this.blendDst=205,this.blendEquation=y,this.blendSrcAlpha=null,this.blendDstAlpha=null,this.blendEquationAlpha=null,this.blendColor=new $i(0,0,0),this.blendAlpha=0,this.depthFunc=3,this.depthTest=!0,this.depthWrite=!0,this.stencilWriteMask=255,this.stencilFunc=519,this.stencilRef=0,this.stencilFuncMask=255,this.stencilFail=ut,this.stencilZFail=ut,this.stencilZPass=ut,this.stencilWrite=!1,this.clippingPlanes=null,this.clipIntersection=!1,this.clipShadows=!1,this.shadowSide=null,this.colorWrite=!0,this.precision=null,this.polygonOffset=!1,this.polygonOffsetFactor=0,this.polygonOffsetUnits=0,this.dithering=!1,this.alphaToCoverage=!1,this.premultipliedAlpha=!1,this.forceSinglePass=!1,this.visible=!0,this.toneMapped=!0,this.userData={},this.version=0,this._alphaTest=0}get alphaTest(){return this._alphaTest}set alphaTest(t){this._alphaTest>0!=t>0&&this.version++,this._alphaTest=t}onBeforeRender(){}onBeforeCompile(){}customProgramCacheKey(){return this.onBeforeCompile.toString()}setValues(t){if(void 0!==t)for(const i in t){const r=t[i];if(void 0===r)continue;const a=this[i];void 0!==a&&(a&&a.isColor?a.set(r):a&&a.isVector3&&r&&r.isVector3?a.copy(r):this[i]=r)}}toJSON(t){const i=void 0===t||"string"==typeof t;i&&(t={textures:{},images:{}});const r={metadata:{version:4.6,type:"Material",generator:"Material.toJSON"}};function extractFromCache(t){const i=[];for(const r in t){const a=t[r];delete a.metadata,i.push(a)}return i}if(r.uuid=this.uuid,r.type=this.type,""!==this.name&&(r.name=this.name),this.color&&this.color.isColor&&(r.color=this.color.getHex()),void 0!==this.roughness&&(r.roughness=this.roughness),void 0!==this.metalness&&(r.metalness=this.metalness),void 0!==this.sheen&&(r.sheen=this.sheen),this.sheenColor&&this.sheenColor.isColor&&(r.sheenColor=this.sheenColor.getHex()),void 0!==this.sheenRoughness&&(r.sheenRoughness=this.sheenRoughness),this.emissive&&this.emissive.isColor&&(r.emissive=this.emissive.getHex()),void 0!==this.emissiveIntensity&&1!==this.emissiveIntensity&&(r.emissiveIntensity=this.emissiveIntensity),this.specular&&this.specular.isColor&&(r.specular=this.specular.getHex()),void 0!==this.specularIntensity&&(r.specularIntensity=this.specularIntensity),this.specularColor&&this.specularColor.isColor&&(r.specularColor=this.specularColor.getHex()),void 0!==this.shininess&&(r.shininess=this.shininess),void 0!==this.clearcoat&&(r.clearcoat=this.clearcoat),void 0!==this.clearcoatRoughness&&(r.clearcoatRoughness=this.clearcoatRoughness),this.clearcoatMap&&this.clearcoatMap.isTexture&&(r.clearcoatMap=this.clearcoatMap.toJSON(t).uuid),this.clearcoatRoughnessMap&&this.clearcoatRoughnessMap.isTexture&&(r.clearcoatRoughnessMap=this.clearcoatRoughnessMap.toJSON(t).uuid),this.clearcoatNormalMap&&this.clearcoatNormalMap.isTexture&&(r.clearcoatNormalMap=this.clearcoatNormalMap.toJSON(t).uuid,r.clearcoatNormalScale=this.clearcoatNormalScale.toArray()),void 0!==this.dispersion&&(r.dispersion=this.dispersion),void 0!==this.iridescence&&(r.iridescence=this.iridescence),void 0!==this.iridescenceIOR&&(r.iridescenceIOR=this.iridescenceIOR),void 0!==this.iridescenceThicknessRange&&(r.iridescenceThicknessRange=this.iridescenceThicknessRange),this.iridescenceMap&&this.iridescenceMap.isTexture&&(r.iridescenceMap=this.iridescenceMap.toJSON(t).uuid),this.iridescenceThicknessMap&&this.iridescenceThicknessMap.isTexture&&(r.iridescenceThicknessMap=this.iridescenceThicknessMap.toJSON(t).uuid),void 0!==this.anisotropy&&(r.anisotropy=this.anisotropy),void 0!==this.anisotropyRotation&&(r.anisotropyRotation=this.anisotropyRotation),this.anisotropyMap&&this.anisotropyMap.isTexture&&(r.anisotropyMap=this.anisotropyMap.toJSON(t).uuid),this.map&&this.map.isTexture&&(r.map=this.map.toJSON(t).uuid),this.matcap&&this.matcap.isTexture&&(r.matcap=this.matcap.toJSON(t).uuid),this.alphaMap&&this.alphaMap.isTexture&&(r.alphaMap=this.alphaMap.toJSON(t).uuid),this.lightMap&&this.lightMap.isTexture&&(r.lightMap=this.lightMap.toJSON(t).uuid,r.lightMapIntensity=this.lightMapIntensity),this.aoMap&&this.aoMap.isTexture&&(r.aoMap=this.aoMap.toJSON(t).uuid,r.aoMapIntensity=this.aoMapIntensity),this.bumpMap&&this.bumpMap.isTexture&&(r.bumpMap=this.bumpMap.toJSON(t).uuid,r.bumpScale=this.bumpScale),this.normalMap&&this.normalMap.isTexture&&(r.normalMap=this.normalMap.toJSON(t).uuid,r.normalMapType=this.normalMapType,r.normalScale=this.normalScale.toArray()),this.displacementMap&&this.displacementMap.isTexture&&(r.displacementMap=this.displacementMap.toJSON(t).uuid,r.displacementScale=this.displacementScale,r.displacementBias=this.displacementBias),this.roughnessMap&&this.roughnessMap.isTexture&&(r.roughnessMap=this.roughnessMap.toJSON(t).uuid),this.metalnessMap&&this.metalnessMap.isTexture&&(r.metalnessMap=this.metalnessMap.toJSON(t).uuid),this.emissiveMap&&this.emissiveMap.isTexture&&(r.emissiveMap=this.emissiveMap.toJSON(t).uuid),this.specularMap&&this.specularMap.isTexture&&(r.specularMap=this.specularMap.toJSON(t).uuid),this.specularIntensityMap&&this.specularIntensityMap.isTexture&&(r.specularIntensityMap=this.specularIntensityMap.toJSON(t).uuid),this.specularColorMap&&this.specularColorMap.isTexture&&(r.specularColorMap=this.specularColorMap.toJSON(t).uuid),this.envMap&&this.envMap.isTexture&&(r.envMap=this.envMap.toJSON(t).uuid,void 0!==this.combine&&(r.combine=this.combine)),void 0!==this.envMapRotation&&(r.envMapRotation=this.envMapRotation.toArray()),void 0!==this.envMapIntensity&&(r.envMapIntensity=this.envMapIntensity),void 0!==this.reflectivity&&(r.reflectivity=this.reflectivity),void 0!==this.refractionRatio&&(r.refractionRatio=this.refractionRatio),this.gradientMap&&this.gradientMap.isTexture&&(r.gradientMap=this.gradientMap.toJSON(t).uuid),void 0!==this.transmission&&(r.transmission=this.transmission),this.transmissionMap&&this.transmissionMap.isTexture&&(r.transmissionMap=this.transmissionMap.toJSON(t).uuid),void 0!==this.thickness&&(r.thickness=this.thickness),this.thicknessMap&&this.thicknessMap.isTexture&&(r.thicknessMap=this.thicknessMap.toJSON(t).uuid),void 0!==this.attenuationDistance&&this.attenuationDistance!==1/0&&(r.attenuationDistance=this.attenuationDistance),void 0!==this.attenuationColor&&(r.attenuationColor=this.attenuationColor.getHex()),void 0!==this.size&&(r.size=this.size),null!==this.shadowSide&&(r.shadowSide=this.shadowSide),void 0!==this.sizeAttenuation&&(r.sizeAttenuation=this.sizeAttenuation),1!==this.blending&&(r.blending=this.blending),0!==this.side&&(r.side=this.side),!0===this.vertexColors&&(r.vertexColors=!0),this.opacity<1&&(r.opacity=this.opacity),!0===this.transparent&&(r.transparent=!0),this.blendSrc!==w&&(r.blendSrc=this.blendSrc),205!==this.blendDst&&(r.blendDst=this.blendDst),this.blendEquation!==y&&(r.blendEquation=this.blendEquation),null!==this.blendSrcAlpha&&(r.blendSrcAlpha=this.blendSrcAlpha),null!==this.blendDstAlpha&&(r.blendDstAlpha=this.blendDstAlpha),null!==this.blendEquationAlpha&&(r.blendEquationAlpha=this.blendEquationAlpha),this.blendColor&&this.blendColor.isColor&&(r.blendColor=this.blendColor.getHex()),0!==this.blendAlpha&&(r.blendAlpha=this.blendAlpha),3!==this.depthFunc&&(r.depthFunc=this.depthFunc),!1===this.depthTest&&(r.depthTest=this.depthTest),!1===this.depthWrite&&(r.depthWrite=this.depthWrite),!1===this.colorWrite&&(r.colorWrite=this.colorWrite),255!==this.stencilWriteMask&&(r.stencilWriteMask=this.stencilWriteMask),519!==this.stencilFunc&&(r.stencilFunc=this.stencilFunc),0!==this.stencilRef&&(r.stencilRef=this.stencilRef),255!==this.stencilFuncMask&&(r.stencilFuncMask=this.stencilFuncMask),this.stencilFail!==ut&&(r.stencilFail=this.stencilFail),this.stencilZFail!==ut&&(r.stencilZFail=this.stencilZFail),this.stencilZPass!==ut&&(r.stencilZPass=this.stencilZPass),!0===this.stencilWrite&&(r.stencilWrite=this.stencilWrite),void 0!==this.rotation&&0!==this.rotation&&(r.rotation=this.rotation),!0===this.polygonOffset&&(r.polygonOffset=!0),0!==this.polygonOffsetFactor&&(r.polygonOffsetFactor=this.polygonOffsetFactor),0!==this.polygonOffsetUnits&&(r.polygonOffsetUnits=this.polygonOffsetUnits),void 0!==this.linewidth&&1!==this.linewidth&&(r.linewidth=this.linewidth),void 0!==this.dashSize&&(r.dashSize=this.dashSize),void 0!==this.gapSize&&(r.gapSize=this.gapSize),void 0!==this.scale&&(r.scale=this.scale),!0===this.dithering&&(r.dithering=!0),this.alphaTest>0&&(r.alphaTest=this.alphaTest),!0===this.alphaHash&&(r.alphaHash=!0),!0===this.alphaToCoverage&&(r.alphaToCoverage=!0),!0===this.premultipliedAlpha&&(r.premultipliedAlpha=!0),!0===this.forceSinglePass&&(r.forceSinglePass=!0),!0===this.wireframe&&(r.wireframe=!0),this.wireframeLinewidth>1&&(r.wireframeLinewidth=this.wireframeLinewidth),"round"!==this.wireframeLinecap&&(r.wireframeLinecap=this.wireframeLinecap),"round"!==this.wireframeLinejoin&&(r.wireframeLinejoin=this.wireframeLinejoin),!0===this.flatShading&&(r.flatShading=!0),!1===this.visible&&(r.visible=!1),!1===this.toneMapped&&(r.toneMapped=!1),!1===this.fog&&(r.fog=!1),Object.keys(this.userData).length>0&&(r.userData=this.userData),i){const i=extractFromCache(t.textures),a=extractFromCache(t.images);i.length>0&&(r.textures=i),a.length>0&&(r.images=a)}return r}clone(){return(new this.constructor).copy(this)}copy(t){this.name=t.name,this.blending=t.blending,this.side=t.side,this.vertexColors=t.vertexColors,this.opacity=t.opacity,this.transparent=t.transparent,this.blendSrc=t.blendSrc,this.blendDst=t.blendDst,this.blendEquation=t.blendEquation,this.blendSrcAlpha=t.blendSrcAlpha,this.blendDstAlpha=t.blendDstAlpha,this.blendEquationAlpha=t.blendEquationAlpha,this.blendColor.copy(t.blendColor),this.blendAlpha=t.blendAlpha,this.depthFunc=t.depthFunc,this.depthTest=t.depthTest,this.depthWrite=t.depthWrite,this.stencilWriteMask=t.stencilWriteMask,this.stencilFunc=t.stencilFunc,this.stencilRef=t.stencilRef,this.stencilFuncMask=t.stencilFuncMask,this.stencilFail=t.stencilFail,this.stencilZFail=t.stencilZFail,this.stencilZPass=t.stencilZPass,this.stencilWrite=t.stencilWrite;const i=t.clippingPlanes;let r=null;if(null!==i){const t=i.length;r=new Array(t);for(let a=0;a!==t;++a)r[a]=i[a].clone()}return this.clippingPlanes=r,this.clipIntersection=t.clipIntersection,this.clipShadows=t.clipShadows,this.shadowSide=t.shadowSide,this.colorWrite=t.colorWrite,this.precision=t.precision,this.polygonOffset=t.polygonOffset,this.polygonOffsetFactor=t.polygonOffsetFactor,this.polygonOffsetUnits=t.polygonOffsetUnits,this.dithering=t.dithering,this.alphaTest=t.alphaTest,this.alphaHash=t.alphaHash,this.alphaToCoverage=t.alphaToCoverage,this.premultipliedAlpha=t.premultipliedAlpha,this.forceSinglePass=t.forceSinglePass,this.visible=t.visible,this.toneMapped=t.toneMapped,this.userData=JSON.parse(JSON.stringify(t.userData)),this}dispose(){this.dispatchEvent({type:"dispose"})}set needsUpdate(t){!0===t&&this.version++}onBuild(){}}class MeshBasicMaterial extends Material{constructor(t){super(),this.isMeshBasicMaterial=!0,this.type="MeshBasicMaterial",this.color=new $i(16777215),this.map=null,this.lightMap=null,this.lightMapIntensity=1,this.aoMap=null,this.aoMapIntensity=1,this.specularMap=null,this.alphaMap=null,this.envMap=null,this.envMapRotation=new Euler,this.combine=0,this.reflectivity=1,this.refractionRatio=.98,this.wireframe=!1,this.wireframeLinewidth=1,this.wireframeLinecap="round",this.wireframeLinejoin="round",this.fog=!0,this.setValues(t)}copy(t){return super.copy(t),this.color.copy(t.color),this.map=t.map,this.lightMap=t.lightMap,this.lightMapIntensity=t.lightMapIntensity,this.aoMap=t.aoMap,this.aoMapIntensity=t.aoMapIntensity,this.specularMap=t.specularMap,this.alphaMap=t.alphaMap,this.envMap=t.envMap,this.envMapRotation.copy(t.envMapRotation),this.combine=t.combine,this.reflectivity=t.reflectivity,this.refractionRatio=t.refractionRatio,this.wireframe=t.wireframe,this.wireframeLinewidth=t.wireframeLinewidth,this.wireframeLinecap=t.wireframeLinecap,this.wireframeLinejoin=t.wireframeLinejoin,this.fog=t.fog,this}}const nn=_generateTables();function _generateTables(){const t=new ArrayBuffer(4),i=new Float32Array(t),r=new Uint32Array(t),a=new Uint32Array(512),o=new Uint32Array(512);for(let t=0;t<256;++t){const i=t-127;i<-27?(a[t]=0,a[256|t]=32768,o[t]=24,o[256|t]=24):i<-14?(a[t]=1024>>-i-14,a[256|t]=1024>>-i-14|32768,o[t]=-i-1,o[256|t]=-i-1):i<=15?(a[t]=i+15<<10,a[256|t]=i+15<<10|32768,o[t]=13,o[256|t]=13):i<128?(a[t]=31744,a[256|t]=64512,o[t]=24,o[256|t]=24):(a[t]=31744,a[256|t]=64512,o[t]=13,o[256|t]=13)}const l=new Uint32Array(2048),c=new Uint32Array(64),h=new Uint32Array(64);for(let t=1;t<1024;++t){let i=t<<13,r=0;for(;!(8388608&i);)i<<=1,r-=8388608;i&=-8388609,r+=947912704,l[t]=i|r}for(let t=1024;t<2048;++t)l[t]=939524096+(t-1024<<13);for(let t=1;t<31;++t)c[t]=t<<23;c[31]=1199570944,c[32]=2147483648;for(let t=33;t<63;++t)c[t]=2147483648+(t-32<<23);c[63]=3347054592;for(let t=1;t<64;++t)32!==t&&(h[t]=1024);return{floatView:i,uint32View:r,baseTable:a,shiftTable:o,mantissaTable:l,exponentTable:c,offsetTable:h}}const rn={toHalfFloat:function toHalfFloat(t){Math.abs(t),t=clamp(t,-65504,65504),nn.floatView[0]=t;const i=nn.uint32View[0],r=i>>23&511;return nn.baseTable[r]+((8388607&i)>>nn.shiftTable[r])},fromHalfFloat:function fromHalfFloat(t){const i=t>>10;return nn.uint32View[0]=nn.mantissaTable[nn.offsetTable[i]+(1023&t)]+nn.exponentTable[i],nn.floatView[0]}},sn=new Vector3,an=new Vector2;class BufferAttribute{constructor(t,i,r=!1){if(Array.isArray(t))throw new TypeError("THREE.BufferAttribute: array should be a Typed Array.");this.isBufferAttribute=!0,this.name="",this.array=t,this.itemSize=i,this.count=void 0!==t?t.length/i:0,this.normalized=r,this.usage=_t,this.updateRanges=[],this.gpuType=he,this.version=0}onUploadCallback(){}set needsUpdate(t){!0===t&&this.version++}setUsage(t){return this.usage=t,this}addUpdateRange(t,i){this.updateRanges.push({start:t,count:i})}clearUpdateRanges(){this.updateRanges.length=0}copy(t){return this.name=t.name,this.array=new t.array.constructor(t.array),this.itemSize=t.itemSize,this.count=t.count,this.normalized=t.normalized,this.usage=t.usage,this.gpuType=t.gpuType,this}copyAt(t,i,r){t*=this.itemSize,r*=i.itemSize;for(let a=0,o=this.itemSize;a<o;a++)this.array[t+a]=i.array[r+a];return this}copyArray(t){return this.array.set(t),this}applyMatrix3(t){if(2===this.itemSize)for(let i=0,r=this.count;i<r;i++)an.fromBufferAttribute(this,i),an.applyMatrix3(t),this.setXY(i,an.x,an.y);else if(3===this.itemSize)for(let i=0,r=this.count;i<r;i++)sn.fromBufferAttribute(this,i),sn.applyMatrix3(t),this.setXYZ(i,sn.x,sn.y,sn.z);return this}applyMatrix4(t){for(let i=0,r=this.count;i<r;i++)sn.fromBufferAttribute(this,i),sn.applyMatrix4(t),this.setXYZ(i,sn.x,sn.y,sn.z);return this}applyNormalMatrix(t){for(let i=0,r=this.count;i<r;i++)sn.fromBufferAttribute(this,i),sn.applyNormalMatrix(t),this.setXYZ(i,sn.x,sn.y,sn.z);return this}transformDirection(t){for(let i=0,r=this.count;i<r;i++)sn.fromBufferAttribute(this,i),sn.transformDirection(t),this.setXYZ(i,sn.x,sn.y,sn.z);return this}set(t,i=0){return this.array.set(t,i),this}getComponent(t,i){let r=this.array[t*this.itemSize+i];return this.normalized&&(r=denormalize(r,this.array)),r}setComponent(t,i,r){return this.normalized&&(r=normalize(r,this.array)),this.array[t*this.itemSize+i]=r,this}getX(t){let i=this.array[t*this.itemSize];return this.normalized&&(i=denormalize(i,this.array)),i}setX(t,i){return this.normalized&&(i=normalize(i,this.array)),this.array[t*this.itemSize]=i,this}getY(t){let i=this.array[t*this.itemSize+1];return this.normalized&&(i=denormalize(i,this.array)),i}setY(t,i){return this.normalized&&(i=normalize(i,this.array)),this.array[t*this.itemSize+1]=i,this}getZ(t){let i=this.array[t*this.itemSize+2];return this.normalized&&(i=denormalize(i,this.array)),i}setZ(t,i){return this.normalized&&(i=normalize(i,this.array)),this.array[t*this.itemSize+2]=i,this}getW(t){let i=this.array[t*this.itemSize+3];return this.normalized&&(i=denormalize(i,this.array)),i}setW(t,i){return this.normalized&&(i=normalize(i,this.array)),this.array[t*this.itemSize+3]=i,this}setXY(t,i,r){return t*=this.itemSize,this.normalized&&(i=normalize(i,this.array),r=normalize(r,this.array)),this.array[t+0]=i,this.array[t+1]=r,this}setXYZ(t,i,r,a){return t*=this.itemSize,this.normalized&&(i=normalize(i,this.array),r=normalize(r,this.array),a=normalize(a,this.array)),this.array[t+0]=i,this.array[t+1]=r,this.array[t+2]=a,this}setXYZW(t,i,r,a,o){return t*=this.itemSize,this.normalized&&(i=normalize(i,this.array),r=normalize(r,this.array),a=normalize(a,this.array),o=normalize(o,this.array)),this.array[t+0]=i,this.array[t+1]=r,this.array[t+2]=a,this.array[t+3]=o,this}onUpload(t){return this.onUploadCallback=t,this}clone(){return new this.constructor(this.array,this.itemSize).copy(this)}toJSON(){const t={itemSize:this.itemSize,type:this.array.constructor.name,array:Array.from(this.array),normalized:this.normalized};return""!==this.name&&(t.name=this.name),this.usage!==_t&&(t.usage=this.usage),t}}class Uint16BufferAttribute extends BufferAttribute{constructor(t,i,r){super(new Uint16Array(t),i,r)}}class Uint32BufferAttribute extends BufferAttribute{constructor(t,i,r){super(new Uint32Array(t),i,r)}}class Float32BufferAttribute extends BufferAttribute{constructor(t,i,r){super(new Float32Array(t),i,r)}}let ln=0;const cn=new Matrix4,hn=new Object3D,dn=new Vector3,un=new Box3,pn=new Box3,mn=new Vector3;class BufferGeometry extends Tt{constructor(){super(),this.isBufferGeometry=!0,Object.defineProperty(this,"id",{value:ln++}),this.uuid=generateUUID(),this.name="",this.type="BufferGeometry",this.index=null,this.indirect=null,this.attributes={},this.morphAttributes={},this.morphTargetsRelative=!1,this.groups=[],this.boundingBox=null,this.boundingSphere=null,this.drawRange={start:0,count:1/0},this.userData={}}getIndex(){return this.index}setIndex(t){return Array.isArray(t)?this.index=new(arrayNeedsUint32(t)?Uint32BufferAttribute:Uint16BufferAttribute)(t,1):this.index=t,this}setIndirect(t){return this.indirect=t,this}getIndirect(){return this.indirect}getAttribute(t){return this.attributes[t]}setAttribute(t,i){return this.attributes[t]=i,this}deleteAttribute(t){return delete this.attributes[t],this}hasAttribute(t){return void 0!==this.attributes[t]}addGroup(t,i,r=0){this.groups.push({start:t,count:i,materialIndex:r})}clearGroups(){this.groups=[]}setDrawRange(t,i){this.drawRange.start=t,this.drawRange.count=i}applyMatrix4(t){const i=this.attributes.position;void 0!==i&&(i.applyMatrix4(t),i.needsUpdate=!0);const r=this.attributes.normal;if(void 0!==r){const i=(new Matrix3).getNormalMatrix(t);r.applyNormalMatrix(i),r.needsUpdate=!0}const a=this.attributes.tangent;return void 0!==a&&(a.transformDirection(t),a.needsUpdate=!0),null!==this.boundingBox&&this.computeBoundingBox(),null!==this.boundingSphere&&this.computeBoundingSphere(),this}applyQuaternion(t){return cn.makeRotationFromQuaternion(t),this.applyMatrix4(cn),this}rotateX(t){return cn.makeRotationX(t),this.applyMatrix4(cn),this}rotateY(t){return cn.makeRotationY(t),this.applyMatrix4(cn),this}rotateZ(t){return cn.makeRotationZ(t),this.applyMatrix4(cn),this}translate(t,i,r){return cn.makeTranslation(t,i,r),this.applyMatrix4(cn),this}scale(t,i,r){return cn.makeScale(t,i,r),this.applyMatrix4(cn),this}lookAt(t){return hn.lookAt(t),hn.updateMatrix(),this.applyMatrix4(hn.matrix),this}center(){return this.computeBoundingBox(),this.boundingBox.getCenter(dn).negate(),this.translate(dn.x,dn.y,dn.z),this}setFromPoints(t){const i=this.getAttribute("position");if(void 0===i){const i=[];for(let r=0,a=t.length;r<a;r++){const a=t[r];i.push(a.x,a.y,a.z||0)}this.setAttribute("position",new Float32BufferAttribute(i,3))}else{const r=Math.min(t.length,i.count);for(let a=0;a<r;a++){const r=t[a];i.setXYZ(a,r.x,r.y,r.z||0)}t.length,i.count,i.needsUpdate=!0}return this}computeBoundingBox(){null===this.boundingBox&&(this.boundingBox=new Box3);const t=this.attributes.position,i=this.morphAttributes.position;if(t&&t.isGLBufferAttribute)this.boundingBox.set(new Vector3(-1/0,-1/0,-1/0),new Vector3(1/0,1/0,1/0));else{if(void 0!==t){if(this.boundingBox.setFromBufferAttribute(t),i)for(let t=0,r=i.length;t<r;t++){const r=i[t];un.setFromBufferAttribute(r),this.morphTargetsRelative?(mn.addVectors(this.boundingBox.min,un.min),this.boundingBox.expandByPoint(mn),mn.addVectors(this.boundingBox.max,un.max),this.boundingBox.expandByPoint(mn)):(this.boundingBox.expandByPoint(un.min),this.boundingBox.expandByPoint(un.max))}}else this.boundingBox.makeEmpty();isNaN(this.boundingBox.min.x)||isNaN(this.boundingBox.min.y)||isNaN(this.boundingBox.min.z)}}computeBoundingSphere(){null===this.boundingSphere&&(this.boundingSphere=new Sphere);const t=this.attributes.position,i=this.morphAttributes.position;if(t&&t.isGLBufferAttribute)this.boundingSphere.set(new Vector3,1/0);else if(t){const r=this.boundingSphere.center;if(un.setFromBufferAttribute(t),i)for(let t=0,r=i.length;t<r;t++){const r=i[t];pn.setFromBufferAttribute(r),this.morphTargetsRelative?(mn.addVectors(un.min,pn.min),un.expandByPoint(mn),mn.addVectors(un.max,pn.max),un.expandByPoint(mn)):(un.expandByPoint(pn.min),un.expandByPoint(pn.max))}un.getCenter(r);let a=0;for(let i=0,o=t.count;i<o;i++)mn.fromBufferAttribute(t,i),a=Math.max(a,r.distanceToSquared(mn));if(i)for(let o=0,l=i.length;o<l;o++){const l=i[o],c=this.morphTargetsRelative;for(let i=0,o=l.count;i<o;i++)mn.fromBufferAttribute(l,i),c&&(dn.fromBufferAttribute(t,i),mn.add(dn)),a=Math.max(a,r.distanceToSquared(mn))}this.boundingSphere.radius=Math.sqrt(a),isNaN(this.boundingSphere.radius)}}computeTangents(){const t=this.index,i=this.attributes;if(null===t||void 0===i.position||void 0===i.normal||void 0===i.uv)return;const r=i.position,a=i.normal,o=i.uv;!1===this.hasAttribute("tangent")&&this.setAttribute("tangent",new BufferAttribute(new Float32Array(4*r.count),4));const l=this.getAttribute("tangent"),c=[],h=[];for(let t=0;t<r.count;t++)c[t]=new Vector3,h[t]=new Vector3;const d=new Vector3,u=new Vector3,p=new Vector3,m=new Vector2,g=new Vector2,y=new Vector2,v=new Vector3,x=new Vector3;function handleTriangle(t,i,a){d.fromBufferAttribute(r,t),u.fromBufferAttribute(r,i),p.fromBufferAttribute(r,a),m.fromBufferAttribute(o,t),g.fromBufferAttribute(o,i),y.fromBufferAttribute(o,a),u.sub(d),p.sub(d),g.sub(m),y.sub(m);const l=1/(g.x*y.y-y.x*g.y);isFinite(l)&&(v.copy(u).multiplyScalar(y.y).addScaledVector(p,-g.y).multiplyScalar(l),x.copy(p).multiplyScalar(g.x).addScaledVector(u,-y.x).multiplyScalar(l),c[t].add(v),c[i].add(v),c[a].add(v),h[t].add(x),h[i].add(x),h[a].add(x))}let b=this.groups;0===b.length&&(b=[{start:0,count:t.count}]);for(let i=0,r=b.length;i<r;++i){const r=b[i],a=r.start;for(let i=a,o=a+r.count;i<o;i+=3)handleTriangle(t.getX(i+0),t.getX(i+1),t.getX(i+2))}const _=new Vector3,S=new Vector3,M=new Vector3,w=new Vector3;function handleVertex(t){M.fromBufferAttribute(a,t),w.copy(M);const i=c[t];_.copy(i),_.sub(M.multiplyScalar(M.dot(i))).normalize(),S.crossVectors(w,i);const r=S.dot(h[t])<0?-1:1;l.setXYZW(t,_.x,_.y,_.z,r)}for(let i=0,r=b.length;i<r;++i){const r=b[i],a=r.start;for(let i=a,o=a+r.count;i<o;i+=3)handleVertex(t.getX(i+0)),handleVertex(t.getX(i+1)),handleVertex(t.getX(i+2))}}computeVertexNormals(){const t=this.index,i=this.getAttribute("position");if(void 0!==i){let r=this.getAttribute("normal");if(void 0===r)r=new BufferAttribute(new Float32Array(3*i.count),3),this.setAttribute("normal",r);else for(let t=0,i=r.count;t<i;t++)r.setXYZ(t,0,0,0);const a=new Vector3,o=new Vector3,l=new Vector3,c=new Vector3,h=new Vector3,d=new Vector3,u=new Vector3,p=new Vector3;if(t)for(let m=0,g=t.count;m<g;m+=3){const g=t.getX(m+0),y=t.getX(m+1),v=t.getX(m+2);a.fromBufferAttribute(i,g),o.fromBufferAttribute(i,y),l.fromBufferAttribute(i,v),u.subVectors(l,o),p.subVectors(a,o),u.cross(p),c.fromBufferAttribute(r,g),h.fromBufferAttribute(r,y),d.fromBufferAttribute(r,v),c.add(u),h.add(u),d.add(u),r.setXYZ(g,c.x,c.y,c.z),r.setXYZ(y,h.x,h.y,h.z),r.setXYZ(v,d.x,d.y,d.z)}else for(let t=0,c=i.count;t<c;t+=3)a.fromBufferAttribute(i,t+0),o.fromBufferAttribute(i,t+1),l.fromBufferAttribute(i,t+2),u.subVectors(l,o),p.subVectors(a,o),u.cross(p),r.setXYZ(t+0,u.x,u.y,u.z),r.setXYZ(t+1,u.x,u.y,u.z),r.setXYZ(t+2,u.x,u.y,u.z);this.normalizeNormals(),r.needsUpdate=!0}}normalizeNormals(){const t=this.attributes.normal;for(let i=0,r=t.count;i<r;i++)mn.fromBufferAttribute(t,i),mn.normalize(),t.setXYZ(i,mn.x,mn.y,mn.z)}toNonIndexed(){function convertBufferAttribute(t,i){const r=t.array,a=t.itemSize,o=t.normalized,l=new r.constructor(i.length*a);let c=0,h=0;for(let o=0,d=i.length;o<d;o++){c=t.isInterleavedBufferAttribute?i[o]*t.data.stride+t.offset:i[o]*a;for(let t=0;t<a;t++)l[h++]=r[c++]}return new BufferAttribute(l,a,o)}if(null===this.index)return this;const t=new BufferGeometry,i=this.index.array,r=this.attributes;for(const a in r){const o=convertBufferAttribute(r[a],i);t.setAttribute(a,o)}const a=this.morphAttributes;for(const r in a){const o=[],l=a[r];for(let t=0,r=l.length;t<r;t++){const r=convertBufferAttribute(l[t],i);o.push(r)}t.morphAttributes[r]=o}t.morphTargetsRelative=this.morphTargetsRelative;const o=this.groups;for(let i=0,r=o.length;i<r;i++){const r=o[i];t.addGroup(r.start,r.count,r.materialIndex)}return t}toJSON(){const t={metadata:{version:4.6,type:"BufferGeometry",generator:"BufferGeometry.toJSON"}};if(t.uuid=this.uuid,t.type=this.type,""!==this.name&&(t.name=this.name),Object.keys(this.userData).length>0&&(t.userData=this.userData),void 0!==this.parameters){const i=this.parameters;for(const r in i)void 0!==i[r]&&(t[r]=i[r]);return t}t.data={attributes:{}};const i=this.index;null!==i&&(t.data.index={type:i.array.constructor.name,array:Array.prototype.slice.call(i.array)});const r=this.attributes;for(const i in r){const a=r[i];t.data.attributes[i]=a.toJSON(t.data)}const a={};let o=!1;for(const i in this.morphAttributes){const r=this.morphAttributes[i],l=[];for(let i=0,a=r.length;i<a;i++){const a=r[i];l.push(a.toJSON(t.data))}l.length>0&&(a[i]=l,o=!0)}o&&(t.data.morphAttributes=a,t.data.morphTargetsRelative=this.morphTargetsRelative);const l=this.groups;l.length>0&&(t.data.groups=JSON.parse(JSON.stringify(l)));const c=this.boundingSphere;return null!==c&&(t.data.boundingSphere={center:c.center.toArray(),radius:c.radius}),t}clone(){return(new this.constructor).copy(this)}copy(t){this.index=null,this.attributes={},this.morphAttributes={},this.groups=[],this.boundingBox=null,this.boundingSphere=null;const i={};this.name=t.name;const r=t.index;null!==r&&this.setIndex(r.clone(i));const a=t.attributes;for(const t in a){const r=a[t];this.setAttribute(t,r.clone(i))}const o=t.morphAttributes;for(const t in o){const r=[],a=o[t];for(let t=0,o=a.length;t<o;t++)r.push(a[t].clone(i));this.morphAttributes[t]=r}this.morphTargetsRelative=t.morphTargetsRelative;const l=t.groups;for(let t=0,i=l.length;t<i;t++){const i=l[t];this.addGroup(i.start,i.count,i.materialIndex)}const c=t.boundingBox;null!==c&&(this.boundingBox=c.clone());const h=t.boundingSphere;return null!==h&&(this.boundingSphere=h.clone()),this.drawRange.start=t.drawRange.start,this.drawRange.count=t.drawRange.count,this.userData=t.userData,this}dispose(){this.dispatchEvent({type:"dispose"})}}const fn=new Matrix4,gn=new Ray,yn=new Sphere,vn=new Vector3,xn=new Vector3,bn=new Vector3,_n=new Vector3,Sn=new Vector3,Mn=new Vector3,wn=new Vector3,Tn=new Vector3;class Mesh extends Object3D{constructor(t=new BufferGeometry,i=new MeshBasicMaterial){super(),this.isMesh=!0,this.type="Mesh",this.geometry=t,this.material=i,this.updateMorphTargets()}copy(t,i){return super.copy(t,i),void 0!==t.morphTargetInfluences&&(this.morphTargetInfluences=t.morphTargetInfluences.slice()),void 0!==t.morphTargetDictionary&&(this.morphTargetDictionary=Object.assign({},t.morphTargetDictionary)),this.material=Array.isArray(t.material)?t.material.slice():t.material,this.geometry=t.geometry,this}updateMorphTargets(){const t=this.geometry.morphAttributes,i=Object.keys(t);if(i.length>0){const r=t[i[0]];if(void 0!==r){this.morphTargetInfluences=[],this.morphTargetDictionary={};for(let t=0,i=r.length;t<i;t++){const i=r[t].name||String(t);this.morphTargetInfluences.push(0),this.morphTargetDictionary[i]=t}}}}getVertexPosition(t,i){const r=this.geometry,a=r.attributes.position,o=r.morphAttributes.position,l=r.morphTargetsRelative;i.fromBufferAttribute(a,t);const c=this.morphTargetInfluences;if(o&&c){Mn.set(0,0,0);for(let r=0,a=o.length;r<a;r++){const a=c[r],h=o[r];0!==a&&(Sn.fromBufferAttribute(h,t),l?Mn.addScaledVector(Sn,a):Mn.addScaledVector(Sn.sub(i),a))}i.add(Mn)}return i}raycast(t,i){const r=this.geometry,a=this.material,o=this.matrixWorld;if(void 0!==a){if(null===r.boundingSphere&&r.computeBoundingSphere(),yn.copy(r.boundingSphere),yn.applyMatrix4(o),gn.copy(t.ray).recast(t.near),!1===yn.containsPoint(gn.origin)){if(null===gn.intersectSphere(yn,vn))return;if(gn.origin.distanceToSquared(vn)>(t.far-t.near)**2)return}fn.copy(o).invert(),gn.copy(t.ray).applyMatrix4(fn),null!==r.boundingBox&&!1===gn.intersectsBox(r.boundingBox)||this._computeIntersections(t,i,gn)}}_computeIntersections(t,i,r){let a;const o=this.geometry,l=this.material,c=o.index,h=o.attributes.position,d=o.attributes.uv,u=o.attributes.uv1,p=o.attributes.normal,m=o.groups,g=o.drawRange;if(null!==c)if(Array.isArray(l))for(let o=0,h=m.length;o<h;o++){const h=m[o],y=l[h.materialIndex];for(let o=Math.max(h.start,g.start),l=Math.min(c.count,Math.min(h.start+h.count,g.start+g.count));o<l;o+=3){a=checkGeometryIntersection(this,y,t,r,d,u,p,c.getX(o),c.getX(o+1),c.getX(o+2)),a&&(a.faceIndex=Math.floor(o/3),a.face.materialIndex=h.materialIndex,i.push(a))}}else{for(let o=Math.max(0,g.start),h=Math.min(c.count,g.start+g.count);o<h;o+=3){a=checkGeometryIntersection(this,l,t,r,d,u,p,c.getX(o),c.getX(o+1),c.getX(o+2)),a&&(a.faceIndex=Math.floor(o/3),i.push(a))}}else if(void 0!==h)if(Array.isArray(l))for(let o=0,c=m.length;o<c;o++){const c=m[o],y=l[c.materialIndex];for(let o=Math.max(c.start,g.start),l=Math.min(h.count,Math.min(c.start+c.count,g.start+g.count));o<l;o+=3){a=checkGeometryIntersection(this,y,t,r,d,u,p,o,o+1,o+2),a&&(a.faceIndex=Math.floor(o/3),a.face.materialIndex=c.materialIndex,i.push(a))}}else{for(let o=Math.max(0,g.start),c=Math.min(h.count,g.start+g.count);o<c;o+=3){a=checkGeometryIntersection(this,l,t,r,d,u,p,o,o+1,o+2),a&&(a.faceIndex=Math.floor(o/3),i.push(a))}}}}function checkGeometryIntersection(t,i,r,a,o,l,c,h,d,u){t.getVertexPosition(h,xn),t.getVertexPosition(d,bn),t.getVertexPosition(u,_n);const p=function checkIntersection$1(t,i,r,a,o,l,c,h){let d;if(d=1===i.side?a.intersectTriangle(c,l,o,!0,h):a.intersectTriangle(o,l,c,0===i.side,h),null===d)return null;Tn.copy(h),Tn.applyMatrix4(t.matrixWorld);const u=r.ray.origin.distanceTo(Tn);return u<r.near||u>r.far?null:{distance:u,point:Tn.clone(),object:t}}(t,i,r,a,xn,bn,_n,wn);if(p){const t=new Vector3;Triangle.getBarycoord(wn,xn,bn,_n,t),o&&(p.uv=Triangle.getInterpolatedAttribute(o,h,d,u,t,new Vector2)),l&&(p.uv1=Triangle.getInterpolatedAttribute(l,h,d,u,t,new Vector2)),c&&(p.normal=Triangle.getInterpolatedAttribute(c,h,d,u,t,new Vector3),p.normal.dot(a.direction)>0&&p.normal.multiplyScalar(-1));const i={a:h,b:d,c:u,normal:new Vector3,materialIndex:0};Triangle.getNormal(xn,bn,_n,i.normal),p.face=i,p.barycoord=t}return p}class BoxGeometry extends BufferGeometry{constructor(t=1,i=1,r=1,a=1,o=1,l=1){super(),this.type="BoxGeometry",this.parameters={width:t,height:i,depth:r,widthSegments:a,heightSegments:o,depthSegments:l};const c=this;a=Math.floor(a),o=Math.floor(o),l=Math.floor(l);const h=[],d=[],u=[],p=[];let m=0,g=0;function buildPlane(t,i,r,a,o,l,y,v,x,b,_){const S=l/x,M=y/b,w=l/2,T=y/2,E=v/2,A=x+1,C=b+1;let P=0,R=0;const I=new Vector3;for(let l=0;l<C;l++){const c=l*M-T;for(let h=0;h<A;h++){const m=h*S-w;I[t]=m*a,I[i]=c*o,I[r]=E,d.push(I.x,I.y,I.z),I[t]=0,I[i]=0,I[r]=v>0?1:-1,u.push(I.x,I.y,I.z),p.push(h/x),p.push(1-l/b),P+=1}}for(let t=0;t<b;t++)for(let i=0;i<x;i++){const r=m+i+A*t,a=m+i+A*(t+1),o=m+(i+1)+A*(t+1),l=m+(i+1)+A*t;h.push(r,a,l),h.push(a,o,l),R+=6}c.addGroup(g,R,_),g+=R,m+=P}buildPlane("z","y","x",-1,-1,r,i,t,l,o,0),buildPlane("z","y","x",1,-1,r,i,-t,l,o,1),buildPlane("x","z","y",1,1,t,r,i,a,l,2),buildPlane("x","z","y",1,-1,t,r,-i,a,l,3),buildPlane("x","y","z",1,-1,t,i,r,a,o,4),buildPlane("x","y","z",-1,-1,t,i,-r,a,o,5),this.setIndex(h),this.setAttribute("position",new Float32BufferAttribute(d,3)),this.setAttribute("normal",new Float32BufferAttribute(u,3)),this.setAttribute("uv",new Float32BufferAttribute(p,2))}copy(t){return super.copy(t),this.parameters=Object.assign({},t.parameters),this}static fromJSON(t){return new BoxGeometry(t.width,t.height,t.depth,t.widthSegments,t.heightSegments,t.depthSegments)}}function cloneUniforms(t){const i={};for(const r in t){i[r]={};for(const a in t[r]){const o=t[r][a];o&&(o.isColor||o.isMatrix3||o.isMatrix4||o.isVector2||o.isVector3||o.isVector4||o.isTexture||o.isQuaternion)?o.isRenderTargetTexture?i[r][a]=null:i[r][a]=o.clone():Array.isArray(o)?i[r][a]=o.slice():i[r][a]=o}}return i}function mergeUniforms(t){const i={};for(let r=0;r<t.length;r++){const a=cloneUniforms(t[r]);for(const t in a)i[t]=a[t]}return i}function getUnlitUniformColorSpace(t){const i=t.getRenderTarget();return null===i?t.outputColorSpace:!0===i.isXRRenderTarget?i.texture.colorSpace:Ot.workingColorSpace}const En={clone:cloneUniforms,merge:mergeUniforms};class ShaderMaterial extends Material{constructor(t){super(),this.isShaderMaterial=!0,this.type="ShaderMaterial",this.defines={},this.uniforms={},this.uniformsGroups=[],this.vertexShader="void main() {\n\tgl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",this.fragmentShader="void main() {\n\tgl_FragColor = vec4( 1.0, 0.0, 0.0, 1.0 );\n}",this.linewidth=1,this.wireframe=!1,this.wireframeLinewidth=1,this.fog=!1,this.lights=!1,this.clipping=!1,this.forceSinglePass=!0,this.extensions={clipCullDistance:!1,multiDraw:!1},this.defaultAttributeValues={color:[1,1,1],uv:[0,0],uv1:[0,0]},this.index0AttributeName=void 0,this.uniformsNeedUpdate=!1,this.glslVersion=null,void 0!==t&&this.setValues(t)}copy(t){return super.copy(t),this.fragmentShader=t.fragmentShader,this.vertexShader=t.vertexShader,this.uniforms=cloneUniforms(t.uniforms),this.uniformsGroups=function cloneUniformsGroups(t){const i=[];for(let r=0;r<t.length;r++)i.push(t[r].clone());return i}(t.uniformsGroups),this.defines=Object.assign({},t.defines),this.wireframe=t.wireframe,this.wireframeLinewidth=t.wireframeLinewidth,this.fog=t.fog,this.lights=t.lights,this.clipping=t.clipping,this.extensions=Object.assign({},t.extensions),this.glslVersion=t.glslVersion,this}toJSON(t){const i=super.toJSON(t);i.glslVersion=this.glslVersion,i.uniforms={};for(const r in this.uniforms){const a=this.uniforms[r].value;a&&a.isTexture?i.uniforms[r]={type:"t",value:a.toJSON(t).uuid}:a&&a.isColor?i.uniforms[r]={type:"c",value:a.getHex()}:a&&a.isVector2?i.uniforms[r]={type:"v2",value:a.toArray()}:a&&a.isVector3?i.uniforms[r]={type:"v3",value:a.toArray()}:a&&a.isVector4?i.uniforms[r]={type:"v4",value:a.toArray()}:a&&a.isMatrix3?i.uniforms[r]={type:"m3",value:a.toArray()}:a&&a.isMatrix4?i.uniforms[r]={type:"m4",value:a.toArray()}:i.uniforms[r]={value:a}}Object.keys(this.defines).length>0&&(i.defines=this.defines),i.vertexShader=this.vertexShader,i.fragmentShader=this.fragmentShader,i.lights=this.lights,i.clipping=this.clipping;const r={};for(const t in this.extensions)!0===this.extensions[t]&&(r[t]=!0);return Object.keys(r).length>0&&(i.extensions=r),i}}class Camera extends Object3D{constructor(){super(),this.isCamera=!0,this.type="Camera",this.matrixWorldInverse=new Matrix4,this.projectionMatrix=new Matrix4,this.projectionMatrixInverse=new Matrix4,this.coordinateSystem=Mt}copy(t,i){return super.copy(t,i),this.matrixWorldInverse.copy(t.matrixWorldInverse),this.projectionMatrix.copy(t.projectionMatrix),this.projectionMatrixInverse.copy(t.projectionMatrixInverse),this.coordinateSystem=t.coordinateSystem,this}getWorldDirection(t){return super.getWorldDirection(t).negate()}updateMatrixWorld(t){super.updateMatrixWorld(t),this.matrixWorldInverse.copy(this.matrixWorld).invert()}updateWorldMatrix(t,i){super.updateWorldMatrix(t,i),this.matrixWorldInverse.copy(this.matrixWorld).invert()}clone(){return(new this.constructor).copy(this)}}const An=new Vector3,Cn=new Vector2,Pn=new Vector2;class PerspectiveCamera extends Camera{constructor(t=50,i=1,r=.1,a=2e3){super(),this.isPerspectiveCamera=!0,this.type="PerspectiveCamera",this.fov=t,this.zoom=1,this.near=r,this.far=a,this.focus=10,this.aspect=i,this.view=null,this.filmGauge=35,this.filmOffset=0,this.updateProjectionMatrix()}copy(t,i){return super.copy(t,i),this.fov=t.fov,this.zoom=t.zoom,this.near=t.near,this.far=t.far,this.focus=t.focus,this.aspect=t.aspect,this.view=null===t.view?null:Object.assign({},t.view),this.filmGauge=t.filmGauge,this.filmOffset=t.filmOffset,this}setFocalLength(t){const i=.5*this.getFilmHeight()/t;this.fov=2*Pt*Math.atan(i),this.updateProjectionMatrix()}getFocalLength(){const t=Math.tan(.5*Ct*this.fov);return.5*this.getFilmHeight()/t}getEffectiveFOV(){return 2*Pt*Math.atan(Math.tan(.5*Ct*this.fov)/this.zoom)}getFilmWidth(){return this.filmGauge*Math.min(this.aspect,1)}getFilmHeight(){return this.filmGauge/Math.max(this.aspect,1)}getViewBounds(t,i,r){An.set(-1,-1,.5).applyMatrix4(this.projectionMatrixInverse),i.set(An.x,An.y).multiplyScalar(-t/An.z),An.set(1,1,.5).applyMatrix4(this.projectionMatrixInverse),r.set(An.x,An.y).multiplyScalar(-t/An.z)}getViewSize(t,i){return this.getViewBounds(t,Cn,Pn),i.subVectors(Pn,Cn)}setViewOffset(t,i,r,a,o,l){this.aspect=t/i,null===this.view&&(this.view={enabled:!0,fullWidth:1,fullHeight:1,offsetX:0,offsetY:0,width:1,height:1}),this.view.enabled=!0,this.view.fullWidth=t,this.view.fullHeight=i,this.view.offsetX=r,this.view.offsetY=a,this.view.width=o,this.view.height=l,this.updateProjectionMatrix()}clearViewOffset(){null!==this.view&&(this.view.enabled=!1),this.updateProjectionMatrix()}updateProjectionMatrix(){const t=this.near;let i=t*Math.tan(.5*Ct*this.fov)/this.zoom,r=2*i,a=this.aspect*r,o=-.5*a;const l=this.view;if(null!==this.view&&this.view.enabled){const t=l.fullWidth,c=l.fullHeight;o+=l.offsetX*a/t,i-=l.offsetY*r/c,a*=l.width/t,r*=l.height/c}const c=this.filmOffset;0!==c&&(o+=t*c/this.getFilmWidth()),this.projectionMatrix.makePerspective(o,o+a,i,i-r,t,this.far,this.coordinateSystem),this.projectionMatrixInverse.copy(this.projectionMatrix).invert()}toJSON(t){const i=super.toJSON(t);return i.object.fov=this.fov,i.object.zoom=this.zoom,i.object.near=this.near,i.object.far=this.far,i.object.focus=this.focus,i.object.aspect=this.aspect,null!==this.view&&(i.object.view=Object.assign({},this.view)),i.object.filmGauge=this.filmGauge,i.object.filmOffset=this.filmOffset,i}}const Rn=-90;class CubeCamera extends Object3D{constructor(t,i,r){super(),this.type="CubeCamera",this.renderTarget=r,this.coordinateSystem=null,this.activeMipmapLevel=0;const a=new PerspectiveCamera(Rn,1,t,i);a.layers=this.layers,this.add(a);const o=new PerspectiveCamera(Rn,1,t,i);o.layers=this.layers,this.add(o);const l=new PerspectiveCamera(Rn,1,t,i);l.layers=this.layers,this.add(l);const c=new PerspectiveCamera(Rn,1,t,i);c.layers=this.layers,this.add(c);const h=new PerspectiveCamera(Rn,1,t,i);h.layers=this.layers,this.add(h);const d=new PerspectiveCamera(Rn,1,t,i);d.layers=this.layers,this.add(d)}updateCoordinateSystem(){const t=this.coordinateSystem,i=this.children.concat(),[r,a,o,l,c,h]=i;for(const t of i)this.remove(t);if(t===Mt)r.up.set(0,1,0),r.lookAt(1,0,0),a.up.set(0,1,0),a.lookAt(-1,0,0),o.up.set(0,0,-1),o.lookAt(0,1,0),l.up.set(0,0,1),l.lookAt(0,-1,0),c.up.set(0,1,0),c.lookAt(0,0,1),h.up.set(0,1,0),h.lookAt(0,0,-1);else{if(t!==wt)throw new Error("THREE.CubeCamera.updateCoordinateSystem(): Invalid coordinate system: "+t);r.up.set(0,-1,0),r.lookAt(-1,0,0),a.up.set(0,-1,0),a.lookAt(1,0,0),o.up.set(0,0,1),o.lookAt(0,1,0),l.up.set(0,0,-1),l.lookAt(0,-1,0),c.up.set(0,-1,0),c.lookAt(0,0,1),h.up.set(0,-1,0),h.lookAt(0,0,-1)}for(const t of i)this.add(t),t.updateMatrixWorld()}update(t,i){null===this.parent&&this.updateMatrixWorld();const{renderTarget:r,activeMipmapLevel:a}=this;this.coordinateSystem!==t.coordinateSystem&&(this.coordinateSystem=t.coordinateSystem,this.updateCoordinateSystem());const[o,l,c,h,d,u]=this.children,p=t.getRenderTarget(),m=t.getActiveCubeFace(),g=t.getActiveMipmapLevel(),y=t.xr.enabled;t.xr.enabled=!1;const v=r.texture.generateMipmaps;r.texture.generateMipmaps=!1,t.setRenderTarget(r,0,a),t.render(i,o),t.setRenderTarget(r,1,a),t.render(i,l),t.setRenderTarget(r,2,a),t.render(i,c),t.setRenderTarget(r,3,a),t.render(i,h),t.setRenderTarget(r,4,a),t.render(i,d),r.texture.generateMipmaps=v,t.setRenderTarget(r,5,a),t.render(i,u),t.setRenderTarget(p,m,g),t.xr.enabled=y,r.texture.needsPMREMUpdate=!0}}class CubeTexture extends Texture{constructor(t,i,r,a,o,l,c,h,d,u){super(t=void 0!==t?t:[],i=void 0!==i?i:j,r,a,o,l,c,h,d,u),this.isCubeTexture=!0,this.flipY=!1}get images(){return this.image}set images(t){this.image=t}}class WebGLCubeRenderTarget extends WebGLRenderTarget{constructor(t=1,i={}){super(t,t,i),this.isWebGLCubeRenderTarget=!0;const r={width:t,height:t,depth:1},a=[r,r,r,r,r,r];this.texture=new CubeTexture(a,i.mapping,i.wrapS,i.wrapT,i.magFilter,i.minFilter,i.format,i.type,i.anisotropy,i.colorSpace),this.texture.isRenderTargetTexture=!0,this.texture.generateMipmaps=void 0!==i.generateMipmaps&&i.generateMipmaps,this.texture.minFilter=void 0!==i.minFilter?i.minFilter:te}fromEquirectangularTexture(t,i){this.texture.type=i.type,this.texture.colorSpace=i.colorSpace,this.texture.generateMipmaps=i.generateMipmaps,this.texture.minFilter=i.minFilter,this.texture.magFilter=i.magFilter;const r={uniforms:{tEquirect:{value:null}},vertexShader:"\n\n\t\t\t\tvarying vec3 vWorldDirection;\n\n\t\t\t\tvec3 transformDirection( in vec3 dir, in mat4 matrix ) {\n\n\t\t\t\t\treturn normalize( ( matrix * vec4( dir, 0.0 ) ).xyz );\n\n\t\t\t\t}\n\n\t\t\t\tvoid main() {\n\n\t\t\t\t\tvWorldDirection = transformDirection( position, modelMatrix );\n\n\t\t\t\t\t#include <begin_vertex>\n\t\t\t\t\t#include <project_vertex>\n\n\t\t\t\t}\n\t\t\t",fragmentShader:"\n\n\t\t\t\tuniform sampler2D tEquirect;\n\n\t\t\t\tvarying vec3 vWorldDirection;\n\n\t\t\t\t#include <common>\n\n\t\t\t\tvoid main() {\n\n\t\t\t\t\tvec3 direction = normalize( vWorldDirection );\n\n\t\t\t\t\tvec2 sampleUV = equirectUv( direction );\n\n\t\t\t\t\tgl_FragColor = texture2D( tEquirect, sampleUV );\n\n\t\t\t\t}\n\t\t\t"},a=new BoxGeometry(5,5,5),o=new ShaderMaterial({name:"CubemapFromEquirect",uniforms:cloneUniforms(r.uniforms),vertexShader:r.vertexShader,fragmentShader:r.fragmentShader,side:1,blending:0});o.uniforms.tEquirect.value=i;const l=new Mesh(a,o),c=i.minFilter;i.minFilter===ne&&(i.minFilter=te);return new CubeCamera(1,10,this).update(t,l),i.minFilter=c,l.geometry.dispose(),l.material.dispose(),this}clear(t,i,r,a){const o=t.getRenderTarget();for(let o=0;o<6;o++)t.setRenderTarget(this,o),t.clear(i,r,a);t.setRenderTarget(o)}}class Scene extends Object3D{constructor(){super(),this.isScene=!0,this.type="Scene",this.background=null,this.environment=null,this.fog=null,this.backgroundBlurriness=0,this.backgroundIntensity=1,this.backgroundRotation=new Euler,this.environmentIntensity=1,this.environmentRotation=new Euler,this.overrideMaterial=null,"undefined"!=typeof __THREE_DEVTOOLS__&&__THREE_DEVTOOLS__.dispatchEvent(new CustomEvent("observe",{detail:this}))}copy(t,i){return super.copy(t,i),null!==t.background&&(this.background=t.background.clone()),null!==t.environment&&(this.environment=t.environment.clone()),null!==t.fog&&(this.fog=t.fog.clone()),this.backgroundBlurriness=t.backgroundBlurriness,this.backgroundIntensity=t.backgroundIntensity,this.backgroundRotation.copy(t.backgroundRotation),this.environmentIntensity=t.environmentIntensity,this.environmentRotation.copy(t.environmentRotation),null!==t.overrideMaterial&&(this.overrideMaterial=t.overrideMaterial.clone()),this.matrixAutoUpdate=t.matrixAutoUpdate,this}toJSON(t){const i=super.toJSON(t);return null!==this.fog&&(i.object.fog=this.fog.toJSON()),this.backgroundBlurriness>0&&(i.object.backgroundBlurriness=this.backgroundBlurriness),1!==this.backgroundIntensity&&(i.object.backgroundIntensity=this.backgroundIntensity),i.object.backgroundRotation=this.backgroundRotation.toArray(),1!==this.environmentIntensity&&(i.object.environmentIntensity=this.environmentIntensity),i.object.environmentRotation=this.environmentRotation.toArray(),i}}class InterleavedBuffer{constructor(t,i){this.isInterleavedBuffer=!0,this.array=t,this.stride=i,this.count=void 0!==t?t.length/i:0,this.usage=_t,this.updateRanges=[],this.version=0,this.uuid=generateUUID()}onUploadCallback(){}set needsUpdate(t){!0===t&&this.version++}setUsage(t){return this.usage=t,this}addUpdateRange(t,i){this.updateRanges.push({start:t,count:i})}clearUpdateRanges(){this.updateRanges.length=0}copy(t){return this.array=new t.array.constructor(t.array),this.count=t.count,this.stride=t.stride,this.usage=t.usage,this}copyAt(t,i,r){t*=this.stride,r*=i.stride;for(let a=0,o=this.stride;a<o;a++)this.array[t+a]=i.array[r+a];return this}set(t,i=0){return this.array.set(t,i),this}clone(t){void 0===t.arrayBuffers&&(t.arrayBuffers={}),void 0===this.array.buffer._uuid&&(this.array.buffer._uuid=generateUUID()),void 0===t.arrayBuffers[this.array.buffer._uuid]&&(t.arrayBuffers[this.array.buffer._uuid]=this.array.slice(0).buffer);const i=new this.array.constructor(t.arrayBuffers[this.array.buffer._uuid]),r=new this.constructor(i,this.stride);return r.setUsage(this.usage),r}onUpload(t){return this.onUploadCallback=t,this}toJSON(t){return void 0===t.arrayBuffers&&(t.arrayBuffers={}),void 0===this.array.buffer._uuid&&(this.array.buffer._uuid=generateUUID()),void 0===t.arrayBuffers[this.array.buffer._uuid]&&(t.arrayBuffers[this.array.buffer._uuid]=Array.from(new Uint32Array(this.array.buffer))),{uuid:this.uuid,buffer:this.array.buffer._uuid,type:this.array.constructor.name,stride:this.stride}}}const In=new Vector3;class InterleavedBufferAttribute{constructor(t,i,r,a=!1){this.isInterleavedBufferAttribute=!0,this.name="",this.data=t,this.itemSize=i,this.offset=r,this.normalized=a}get count(){return this.data.count}get array(){return this.data.array}set needsUpdate(t){this.data.needsUpdate=t}applyMatrix4(t){for(let i=0,r=this.data.count;i<r;i++)In.fromBufferAttribute(this,i),In.applyMatrix4(t),this.setXYZ(i,In.x,In.y,In.z);return this}applyNormalMatrix(t){for(let i=0,r=this.count;i<r;i++)In.fromBufferAttribute(this,i),In.applyNormalMatrix(t),this.setXYZ(i,In.x,In.y,In.z);return this}transformDirection(t){for(let i=0,r=this.count;i<r;i++)In.fromBufferAttribute(this,i),In.transformDirection(t),this.setXYZ(i,In.x,In.y,In.z);return this}getComponent(t,i){let r=this.array[t*this.data.stride+this.offset+i];return this.normalized&&(r=denormalize(r,this.array)),r}setComponent(t,i,r){return this.normalized&&(r=normalize(r,this.array)),this.data.array[t*this.data.stride+this.offset+i]=r,this}setX(t,i){return this.normalized&&(i=normalize(i,this.array)),this.data.array[t*this.data.stride+this.offset]=i,this}setY(t,i){return this.normalized&&(i=normalize(i,this.array)),this.data.array[t*this.data.stride+this.offset+1]=i,this}setZ(t,i){return this.normalized&&(i=normalize(i,this.array)),this.data.array[t*this.data.stride+this.offset+2]=i,this}setW(t,i){return this.normalized&&(i=normalize(i,this.array)),this.data.array[t*this.data.stride+this.offset+3]=i,this}getX(t){let i=this.data.array[t*this.data.stride+this.offset];return this.normalized&&(i=denormalize(i,this.array)),i}getY(t){let i=this.data.array[t*this.data.stride+this.offset+1];return this.normalized&&(i=denormalize(i,this.array)),i}getZ(t){let i=this.data.array[t*this.data.stride+this.offset+2];return this.normalized&&(i=denormalize(i,this.array)),i}getW(t){let i=this.data.array[t*this.data.stride+this.offset+3];return this.normalized&&(i=denormalize(i,this.array)),i}setXY(t,i,r){return t=t*this.data.stride+this.offset,this.normalized&&(i=normalize(i,this.array),r=normalize(r,this.array)),this.data.array[t+0]=i,this.data.array[t+1]=r,this}setXYZ(t,i,r,a){return t=t*this.data.stride+this.offset,this.normalized&&(i=normalize(i,this.array),r=normalize(r,this.array),a=normalize(a,this.array)),this.data.array[t+0]=i,this.data.array[t+1]=r,this.data.array[t+2]=a,this}setXYZW(t,i,r,a,o){return t=t*this.data.stride+this.offset,this.normalized&&(i=normalize(i,this.array),r=normalize(r,this.array),a=normalize(a,this.array),o=normalize(o,this.array)),this.data.array[t+0]=i,this.data.array[t+1]=r,this.data.array[t+2]=a,this.data.array[t+3]=o,this}clone(t){if(void 0===t){const t=[];for(let i=0;i<this.count;i++){const r=i*this.data.stride+this.offset;for(let i=0;i<this.itemSize;i++)t.push(this.data.array[r+i])}return new BufferAttribute(new this.array.constructor(t),this.itemSize,this.normalized)}return void 0===t.interleavedBuffers&&(t.interleavedBuffers={}),void 0===t.interleavedBuffers[this.data.uuid]&&(t.interleavedBuffers[this.data.uuid]=this.data.clone(t)),new InterleavedBufferAttribute(t.interleavedBuffers[this.data.uuid],this.itemSize,this.offset,this.normalized)}toJSON(t){if(void 0===t){const t=[];for(let i=0;i<this.count;i++){const r=i*this.data.stride+this.offset;for(let i=0;i<this.itemSize;i++)t.push(this.data.array[r+i])}return{itemSize:this.itemSize,type:this.array.constructor.name,array:t,normalized:this.normalized}}return void 0===t.interleavedBuffers&&(t.interleavedBuffers={}),void 0===t.interleavedBuffers[this.data.uuid]&&(t.interleavedBuffers[this.data.uuid]=this.data.toJSON(t)),{isInterleavedBufferAttribute:!0,itemSize:this.itemSize,data:this.data.uuid,offset:this.offset,normalized:this.normalized}}}class SpriteMaterial extends Material{constructor(t){super(),this.isSpriteMaterial=!0,this.type="SpriteMaterial",this.color=new $i(16777215),this.map=null,this.alphaMap=null,this.rotation=0,this.sizeAttenuation=!0,this.transparent=!0,this.fog=!0,this.setValues(t)}copy(t){return super.copy(t),this.color.copy(t.color),this.map=t.map,this.alphaMap=t.alphaMap,this.rotation=t.rotation,this.sizeAttenuation=t.sizeAttenuation,this.fog=t.fog,this}}let Dn;const Ln=new Vector3,Fn=new Vector3,Nn=new Vector3,On=new Vector2,Un=new Vector2,Bn=new Matrix4,zn=new Vector3,Vn=new Vector3,kn=new Vector3,Gn=new Vector2,Hn=new Vector2,Wn=new Vector2;class Sprite extends Object3D{constructor(t=new SpriteMaterial){if(super(),this.isSprite=!0,this.type="Sprite",void 0===Dn){Dn=new BufferGeometry;const t=new Float32Array([-.5,-.5,0,0,0,.5,-.5,0,1,0,.5,.5,0,1,1,-.5,.5,0,0,1]),i=new InterleavedBuffer(t,5);Dn.setIndex([0,1,2,0,2,3]),Dn.setAttribute("position",new InterleavedBufferAttribute(i,3,0,!1)),Dn.setAttribute("uv",new InterleavedBufferAttribute(i,2,3,!1))}this.geometry=Dn,this.material=t,this.center=new Vector2(.5,.5)}raycast(t,i){t.camera,Fn.setFromMatrixScale(this.matrixWorld),Bn.copy(t.camera.matrixWorld),this.modelViewMatrix.multiplyMatrices(t.camera.matrixWorldInverse,this.matrixWorld),Nn.setFromMatrixPosition(this.modelViewMatrix),t.camera.isPerspectiveCamera&&!1===this.material.sizeAttenuation&&Fn.multiplyScalar(-Nn.z);const r=this.material.rotation;let a,o;0!==r&&(o=Math.cos(r),a=Math.sin(r));const l=this.center;transformVertex(zn.set(-.5,-.5,0),Nn,l,Fn,a,o),transformVertex(Vn.set(.5,-.5,0),Nn,l,Fn,a,o),transformVertex(kn.set(.5,.5,0),Nn,l,Fn,a,o),Gn.set(0,0),Hn.set(1,0),Wn.set(1,1);let c=t.ray.intersectTriangle(zn,Vn,kn,!1,Ln);if(null===c&&(transformVertex(Vn.set(-.5,.5,0),Nn,l,Fn,a,o),Hn.set(0,1),c=t.ray.intersectTriangle(zn,kn,Vn,!1,Ln),null===c))return;const h=t.ray.origin.distanceTo(Ln);h<t.near||h>t.far||i.push({distance:h,point:Ln.clone(),uv:Triangle.getInterpolation(Ln,zn,Vn,kn,Gn,Hn,Wn,new Vector2),face:null,object:this})}copy(t,i){return super.copy(t,i),void 0!==t.center&&this.center.copy(t.center),this.material=t.material,this}}function transformVertex(t,i,r,a,o,l){On.subVectors(t,r).addScalar(.5).multiply(a),void 0!==o?(Un.x=l*On.x-o*On.y,Un.y=o*On.x+l*On.y):Un.copy(On),t.copy(i),t.x+=Un.x,t.y+=Un.y,t.applyMatrix4(Bn)}const jn=new Vector3,Xn=new Vector4,qn=new Vector4,Yn=new Vector3,Zn=new Matrix4,Kn=new Vector3,Qn=new Sphere,Jn=new Matrix4,$n=new Ray;class SkinnedMesh extends Mesh{constructor(t,i){super(t,i),this.isSkinnedMesh=!0,this.type="SkinnedMesh",this.bindMode=W,this.bindMatrix=new Matrix4,this.bindMatrixInverse=new Matrix4,this.boundingBox=null,this.boundingSphere=null}computeBoundingBox(){const t=this.geometry;null===this.boundingBox&&(this.boundingBox=new Box3),this.boundingBox.makeEmpty();const i=t.getAttribute("position");for(let t=0;t<i.count;t++)this.getVertexPosition(t,Kn),this.boundingBox.expandByPoint(Kn)}computeBoundingSphere(){const t=this.geometry;null===this.boundingSphere&&(this.boundingSphere=new Sphere),this.boundingSphere.makeEmpty();const i=t.getAttribute("position");for(let t=0;t<i.count;t++)this.getVertexPosition(t,Kn),this.boundingSphere.expandByPoint(Kn)}copy(t,i){return super.copy(t,i),this.bindMode=t.bindMode,this.bindMatrix.copy(t.bindMatrix),this.bindMatrixInverse.copy(t.bindMatrixInverse),this.skeleton=t.skeleton,null!==t.boundingBox&&(this.boundingBox=t.boundingBox.clone()),null!==t.boundingSphere&&(this.boundingSphere=t.boundingSphere.clone()),this}raycast(t,i){const r=this.material,a=this.matrixWorld;void 0!==r&&(null===this.boundingSphere&&this.computeBoundingSphere(),Qn.copy(this.boundingSphere),Qn.applyMatrix4(a),!1!==t.ray.intersectsSphere(Qn)&&(Jn.copy(a).invert(),$n.copy(t.ray).applyMatrix4(Jn),null!==this.boundingBox&&!1===$n.intersectsBox(this.boundingBox)||this._computeIntersections(t,i,$n)))}getVertexPosition(t,i){return super.getVertexPosition(t,i),this.applyBoneTransform(t,i),i}bind(t,i){this.skeleton=t,void 0===i&&(this.updateMatrixWorld(!0),this.skeleton.calculateInverses(),i=this.matrixWorld),this.bindMatrix.copy(i),this.bindMatrixInverse.copy(i).invert()}pose(){this.skeleton.pose()}normalizeSkinWeights(){const t=new Vector4,i=this.geometry.attributes.skinWeight;for(let r=0,a=i.count;r<a;r++){t.fromBufferAttribute(i,r);const a=1/t.manhattanLength();a!==1/0?t.multiplyScalar(a):t.set(1,0,0,0),i.setXYZW(r,t.x,t.y,t.z,t.w)}}updateMatrixWorld(t){super.updateMatrixWorld(t),this.bindMode===W?this.bindMatrixInverse.copy(this.matrixWorld).invert():"detached"===this.bindMode&&this.bindMatrixInverse.copy(this.bindMatrix).invert()}applyBoneTransform(t,i){const r=this.skeleton,a=this.geometry;Xn.fromBufferAttribute(a.attributes.skinIndex,t),qn.fromBufferAttribute(a.attributes.skinWeight,t),jn.copy(i).applyMatrix4(this.bindMatrix),i.set(0,0,0);for(let t=0;t<4;t++){const a=qn.getComponent(t);if(0!==a){const o=Xn.getComponent(t);Zn.multiplyMatrices(r.bones[o].matrixWorld,r.boneInverses[o]),i.addScaledVector(Yn.copy(jn).applyMatrix4(Zn),a)}}return i.applyMatrix4(this.bindMatrixInverse)}}class Bone extends Object3D{constructor(){super(),this.isBone=!0,this.type="Bone"}}class DataTexture extends Texture{constructor(t=null,i=1,r=1,a,o,l,c,h,d=1003,u=1003,p,m){super(null,l,c,h,d,u,a,o,p,m),this.isDataTexture=!0,this.image={data:t,width:i,height:r},this.generateMipmaps=!1,this.flipY=!1,this.unpackAlignment=1}}const er=new Matrix4,tr=new Matrix4;class Skeleton{constructor(t=[],i=[]){this.uuid=generateUUID(),this.bones=t.slice(0),this.boneInverses=i,this.boneMatrices=null,this.boneTexture=null,this.init()}init(){const t=this.bones,i=this.boneInverses;if(this.boneMatrices=new Float32Array(16*t.length),0===i.length)this.calculateInverses();else if(t.length!==i.length){this.boneInverses=[];for(let t=0,i=this.bones.length;t<i;t++)this.boneInverses.push(new Matrix4)}}calculateInverses(){this.boneInverses.length=0;for(let t=0,i=this.bones.length;t<i;t++){const i=new Matrix4;this.bones[t]&&i.copy(this.bones[t].matrixWorld).invert(),this.boneInverses.push(i)}}pose(){for(let t=0,i=this.bones.length;t<i;t++){const i=this.bones[t];i&&i.matrixWorld.copy(this.boneInverses[t]).invert()}for(let t=0,i=this.bones.length;t<i;t++){const i=this.bones[t];i&&(i.parent&&i.parent.isBone?(i.matrix.copy(i.parent.matrixWorld).invert(),i.matrix.multiply(i.matrixWorld)):i.matrix.copy(i.matrixWorld),i.matrix.decompose(i.position,i.quaternion,i.scale))}}update(){const t=this.bones,i=this.boneInverses,r=this.boneMatrices,a=this.boneTexture;for(let a=0,o=t.length;a<o;a++){const o=t[a]?t[a].matrixWorld:tr;er.multiplyMatrices(o,i[a]),er.toArray(r,16*a)}null!==a&&(a.needsUpdate=!0)}clone(){return new Skeleton(this.bones,this.boneInverses)}computeBoneTexture(){let t=Math.sqrt(4*this.bones.length);t=4*Math.ceil(t/4),t=Math.max(t,4);const i=new Float32Array(t*t*4);i.set(this.boneMatrices);const r=new DataTexture(i,t,t,ge,he);return r.needsUpdate=!0,this.boneMatrices=i,this.boneTexture=r,this}getBoneByName(t){for(let i=0,r=this.bones.length;i<r;i++){const r=this.bones[i];if(r.name===t)return r}}dispose(){null!==this.boneTexture&&(this.boneTexture.dispose(),this.boneTexture=null)}fromJSON(t,i){this.uuid=t.uuid;for(let r=0,a=t.bones.length;r<a;r++){let a=i[t.bones[r]];void 0===a&&(a=new Bone),this.bones.push(a),this.boneInverses.push((new Matrix4).fromArray(t.boneInverses[r]))}return this.init(),this}toJSON(){const t={metadata:{version:4.6,type:"Skeleton",generator:"Skeleton.toJSON"},bones:[],boneInverses:[]};t.uuid=this.uuid;const i=this.bones,r=this.boneInverses;for(let a=0,o=i.length;a<o;a++){const o=i[a];t.bones.push(o.uuid);const l=r[a];t.boneInverses.push(l.toArray())}return t}}class InstancedBufferAttribute extends BufferAttribute{constructor(t,i,r,a=1){super(t,i,r),this.isInstancedBufferAttribute=!0,this.meshPerAttribute=a}copy(t){return super.copy(t),this.meshPerAttribute=t.meshPerAttribute,this}toJSON(){const t=super.toJSON();return t.meshPerAttribute=this.meshPerAttribute,t.isInstancedBufferAttribute=!0,t}}const ir=new Matrix4,nr=new Matrix4,rr=[],sr=new Box3,ar=new Matrix4,or=new Mesh,lr=new Sphere;class InstancedMesh extends Mesh{constructor(t,i,r){super(t,i),this.isInstancedMesh=!0,this.instanceMatrix=new InstancedBufferAttribute(new Float32Array(16*r),16),this.instanceColor=null,this.morphTexture=null,this.count=r,this.boundingBox=null,this.boundingSphere=null;for(let t=0;t<r;t++)this.setMatrixAt(t,ar)}computeBoundingBox(){const t=this.geometry,i=this.count;null===this.boundingBox&&(this.boundingBox=new Box3),null===t.boundingBox&&t.computeBoundingBox(),this.boundingBox.makeEmpty();for(let r=0;r<i;r++)this.getMatrixAt(r,ir),sr.copy(t.boundingBox).applyMatrix4(ir),this.boundingBox.union(sr)}computeBoundingSphere(){const t=this.geometry,i=this.count;null===this.boundingSphere&&(this.boundingSphere=new Sphere),null===t.boundingSphere&&t.computeBoundingSphere(),this.boundingSphere.makeEmpty();for(let r=0;r<i;r++)this.getMatrixAt(r,ir),lr.copy(t.boundingSphere).applyMatrix4(ir),this.boundingSphere.union(lr)}copy(t,i){return super.copy(t,i),this.instanceMatrix.copy(t.instanceMatrix),null!==t.morphTexture&&(this.morphTexture=t.morphTexture.clone()),null!==t.instanceColor&&(this.instanceColor=t.instanceColor.clone()),this.count=t.count,null!==t.boundingBox&&(this.boundingBox=t.boundingBox.clone()),null!==t.boundingSphere&&(this.boundingSphere=t.boundingSphere.clone()),this}getColorAt(t,i){i.fromArray(this.instanceColor.array,3*t)}getMatrixAt(t,i){i.fromArray(this.instanceMatrix.array,16*t)}getMorphAt(t,i){const r=i.morphTargetInfluences,a=this.morphTexture.source.data.data,o=t*(r.length+1)+1;for(let t=0;t<r.length;t++)r[t]=a[o+t]}raycast(t,i){const r=this.matrixWorld,a=this.count;if(or.geometry=this.geometry,or.material=this.material,void 0!==or.material&&(null===this.boundingSphere&&this.computeBoundingSphere(),lr.copy(this.boundingSphere),lr.applyMatrix4(r),!1!==t.ray.intersectsSphere(lr)))for(let o=0;o<a;o++){this.getMatrixAt(o,ir),nr.multiplyMatrices(r,ir),or.matrixWorld=nr,or.raycast(t,rr);for(let t=0,r=rr.length;t<r;t++){const r=rr[t];r.instanceId=o,r.object=this,i.push(r)}rr.length=0}}setColorAt(t,i){null===this.instanceColor&&(this.instanceColor=new InstancedBufferAttribute(new Float32Array(3*this.instanceMatrix.count).fill(1),3)),i.toArray(this.instanceColor.array,3*t)}setMatrixAt(t,i){i.toArray(this.instanceMatrix.array,16*t)}setMorphAt(t,i){const r=i.morphTargetInfluences,a=r.length+1;null===this.morphTexture&&(this.morphTexture=new DataTexture(new Float32Array(a*this.count),a,this.count,xe,he));const o=this.morphTexture.source.data.data;let l=0;for(let t=0;t<r.length;t++)l+=r[t];const c=this.geometry.morphTargetsRelative?1:1-l,h=a*t;o[h]=c,o.set(r,h+1)}updateMorphTargets(){}dispose(){return this.dispatchEvent({type:"dispose"}),null!==this.morphTexture&&(this.morphTexture.dispose(),this.morphTexture=null),this}}const cr=new Vector3,hr=new Vector3,dr=new Matrix3;class Plane{constructor(t=new Vector3(1,0,0),i=0){this.isPlane=!0,this.normal=t,this.constant=i}set(t,i){return this.normal.copy(t),this.constant=i,this}setComponents(t,i,r,a){return this.normal.set(t,i,r),this.constant=a,this}setFromNormalAndCoplanarPoint(t,i){return this.normal.copy(t),this.constant=-i.dot(this.normal),this}setFromCoplanarPoints(t,i,r){const a=cr.subVectors(r,i).cross(hr.subVectors(t,i)).normalize();return this.setFromNormalAndCoplanarPoint(a,t),this}copy(t){return this.normal.copy(t.normal),this.constant=t.constant,this}normalize(){const t=1/this.normal.length();return this.normal.multiplyScalar(t),this.constant*=t,this}negate(){return this.constant*=-1,this.normal.negate(),this}distanceToPoint(t){return this.normal.dot(t)+this.constant}distanceToSphere(t){return this.distanceToPoint(t.center)-t.radius}projectPoint(t,i){return i.copy(t).addScaledVector(this.normal,-this.distanceToPoint(t))}intersectLine(t,i){const r=t.delta(cr),a=this.normal.dot(r);if(0===a)return 0===this.distanceToPoint(t.start)?i.copy(t.start):null;const o=-(t.start.dot(this.normal)+this.constant)/a;return o<0||o>1?null:i.copy(t.start).addScaledVector(r,o)}intersectsLine(t){const i=this.distanceToPoint(t.start),r=this.distanceToPoint(t.end);return i<0&&r>0||r<0&&i>0}intersectsBox(t){return t.intersectsPlane(this)}intersectsSphere(t){return t.intersectsPlane(this)}coplanarPoint(t){return t.copy(this.normal).multiplyScalar(-this.constant)}applyMatrix4(t,i){const r=i||dr.getNormalMatrix(t),a=this.coplanarPoint(cr).applyMatrix4(t),o=this.normal.applyMatrix3(r).normalize();return this.constant=-a.dot(o),this}translate(t){return this.constant-=t.dot(this.normal),this}equals(t){return t.normal.equals(this.normal)&&t.constant===this.constant}clone(){return(new this.constructor).copy(this)}}const ur=new Sphere,pr=new Vector3;class Frustum{constructor(t=new Plane,i=new Plane,r=new Plane,a=new Plane,o=new Plane,l=new Plane){this.planes=[t,i,r,a,o,l]}set(t,i,r,a,o,l){const c=this.planes;return c[0].copy(t),c[1].copy(i),c[2].copy(r),c[3].copy(a),c[4].copy(o),c[5].copy(l),this}copy(t){const i=this.planes;for(let r=0;r<6;r++)i[r].copy(t.planes[r]);return this}setFromProjectionMatrix(t,i=2e3){const r=this.planes,a=t.elements,o=a[0],l=a[1],c=a[2],h=a[3],d=a[4],u=a[5],p=a[6],m=a[7],g=a[8],y=a[9],v=a[10],x=a[11],b=a[12],_=a[13],S=a[14],M=a[15];if(r[0].setComponents(h-o,m-d,x-g,M-b).normalize(),r[1].setComponents(h+o,m+d,x+g,M+b).normalize(),r[2].setComponents(h+l,m+u,x+y,M+_).normalize(),r[3].setComponents(h-l,m-u,x-y,M-_).normalize(),r[4].setComponents(h-c,m-p,x-v,M-S).normalize(),i===Mt)r[5].setComponents(h+c,m+p,x+v,M+S).normalize();else{if(i!==wt)throw new Error("THREE.Frustum.setFromProjectionMatrix(): Invalid coordinate system: "+i);r[5].setComponents(c,p,v,S).normalize()}return this}intersectsObject(t){if(void 0!==t.boundingSphere)null===t.boundingSphere&&t.computeBoundingSphere(),ur.copy(t.boundingSphere).applyMatrix4(t.matrixWorld);else{const i=t.geometry;null===i.boundingSphere&&i.computeBoundingSphere(),ur.copy(i.boundingSphere).applyMatrix4(t.matrixWorld)}return this.intersectsSphere(ur)}intersectsSprite(t){return ur.center.set(0,0,0),ur.radius=.7071067811865476,ur.applyMatrix4(t.matrixWorld),this.intersectsSphere(ur)}intersectsSphere(t){const i=this.planes,r=t.center,a=-t.radius;for(let t=0;t<6;t++){if(i[t].distanceToPoint(r)<a)return!1}return!0}intersectsBox(t){const i=this.planes;for(let r=0;r<6;r++){const a=i[r];if(pr.x=a.normal.x>0?t.max.x:t.min.x,pr.y=a.normal.y>0?t.max.y:t.min.y,pr.z=a.normal.z>0?t.max.z:t.min.z,a.distanceToPoint(pr)<0)return!1}return!0}containsPoint(t){const i=this.planes;for(let r=0;r<6;r++)if(i[r].distanceToPoint(t)<0)return!1;return!0}clone(){return(new this.constructor).copy(this)}}class LineBasicMaterial extends Material{constructor(t){super(),this.isLineBasicMaterial=!0,this.type="LineBasicMaterial",this.color=new $i(16777215),this.map=null,this.linewidth=1,this.linecap="round",this.linejoin="round",this.fog=!0,this.setValues(t)}copy(t){return super.copy(t),this.color.copy(t.color),this.map=t.map,this.linewidth=t.linewidth,this.linecap=t.linecap,this.linejoin=t.linejoin,this.fog=t.fog,this}}const mr=new Vector3,fr=new Vector3,gr=new Matrix4,yr=new Ray,vr=new Sphere,xr=new Vector3,br=new Vector3;class Line extends Object3D{constructor(t=new BufferGeometry,i=new LineBasicMaterial){super(),this.isLine=!0,this.type="Line",this.geometry=t,this.material=i,this.updateMorphTargets()}copy(t,i){return super.copy(t,i),this.material=Array.isArray(t.material)?t.material.slice():t.material,this.geometry=t.geometry,this}computeLineDistances(){const t=this.geometry;if(null===t.index){const i=t.attributes.position,r=[0];for(let t=1,a=i.count;t<a;t++)mr.fromBufferAttribute(i,t-1),fr.fromBufferAttribute(i,t),r[t]=r[t-1],r[t]+=mr.distanceTo(fr);t.setAttribute("lineDistance",new Float32BufferAttribute(r,1))}return this}raycast(t,i){const r=this.geometry,a=this.matrixWorld,o=t.params.Line.threshold,l=r.drawRange;if(null===r.boundingSphere&&r.computeBoundingSphere(),vr.copy(r.boundingSphere),vr.applyMatrix4(a),vr.radius+=o,!1===t.ray.intersectsSphere(vr))return;gr.copy(a).invert(),yr.copy(t.ray).applyMatrix4(gr);const c=o/((this.scale.x+this.scale.y+this.scale.z)/3),h=c*c,d=this.isLineSegments?2:1,u=r.index,p=r.attributes.position;if(null!==u){const r=Math.max(0,l.start),a=Math.min(u.count,l.start+l.count);for(let o=r,l=a-1;o<l;o+=d){const r=u.getX(o),a=u.getX(o+1),l=checkIntersection(this,t,yr,h,r,a);l&&i.push(l)}if(this.isLineLoop){const o=u.getX(a-1),l=u.getX(r),c=checkIntersection(this,t,yr,h,o,l);c&&i.push(c)}}else{const r=Math.max(0,l.start),a=Math.min(p.count,l.start+l.count);for(let o=r,l=a-1;o<l;o+=d){const r=checkIntersection(this,t,yr,h,o,o+1);r&&i.push(r)}if(this.isLineLoop){const o=checkIntersection(this,t,yr,h,a-1,r);o&&i.push(o)}}}updateMorphTargets(){const t=this.geometry.morphAttributes,i=Object.keys(t);if(i.length>0){const r=t[i[0]];if(void 0!==r){this.morphTargetInfluences=[],this.morphTargetDictionary={};for(let t=0,i=r.length;t<i;t++){const i=r[t].name||String(t);this.morphTargetInfluences.push(0),this.morphTargetDictionary[i]=t}}}}}function checkIntersection(t,i,r,a,o,l){const c=t.geometry.attributes.position;mr.fromBufferAttribute(c,o),fr.fromBufferAttribute(c,l);if(r.distanceSqToSegment(mr,fr,xr,br)>a)return;xr.applyMatrix4(t.matrixWorld);const h=i.ray.origin.distanceTo(xr);return h<i.near||h>i.far?void 0:{distance:h,point:br.clone().applyMatrix4(t.matrixWorld),index:o,face:null,faceIndex:null,barycoord:null,object:t}}const _r=new Vector3,Sr=new Vector3;class LineSegments extends Line{constructor(t,i){super(t,i),this.isLineSegments=!0,this.type="LineSegments"}computeLineDistances(){const t=this.geometry;if(null===t.index){const i=t.attributes.position,r=[];for(let t=0,a=i.count;t<a;t+=2)_r.fromBufferAttribute(i,t),Sr.fromBufferAttribute(i,t+1),r[t]=0===t?0:r[t-1],r[t+1]=r[t]+_r.distanceTo(Sr);t.setAttribute("lineDistance",new Float32BufferAttribute(r,1))}return this}}class LineLoop extends Line{constructor(t,i){super(t,i),this.isLineLoop=!0,this.type="LineLoop"}}class PointsMaterial extends Material{constructor(t){super(),this.isPointsMaterial=!0,this.type="PointsMaterial",this.color=new $i(16777215),this.map=null,this.alphaMap=null,this.size=1,this.sizeAttenuation=!0,this.fog=!0,this.setValues(t)}copy(t){return super.copy(t),this.color.copy(t.color),this.map=t.map,this.alphaMap=t.alphaMap,this.size=t.size,this.sizeAttenuation=t.sizeAttenuation,this.fog=t.fog,this}}const Mr=new Matrix4,wr=new Ray,Tr=new Sphere,Er=new Vector3;class Points extends Object3D{constructor(t=new BufferGeometry,i=new PointsMaterial){super(),this.isPoints=!0,this.type="Points",this.geometry=t,this.material=i,this.updateMorphTargets()}copy(t,i){return super.copy(t,i),this.material=Array.isArray(t.material)?t.material.slice():t.material,this.geometry=t.geometry,this}raycast(t,i){const r=this.geometry,a=this.matrixWorld,o=t.params.Points.threshold,l=r.drawRange;if(null===r.boundingSphere&&r.computeBoundingSphere(),Tr.copy(r.boundingSphere),Tr.applyMatrix4(a),Tr.radius+=o,!1===t.ray.intersectsSphere(Tr))return;Mr.copy(a).invert(),wr.copy(t.ray).applyMatrix4(Mr);const c=o/((this.scale.x+this.scale.y+this.scale.z)/3),h=c*c,d=r.index,u=r.attributes.position;if(null!==d){for(let r=Math.max(0,l.start),o=Math.min(d.count,l.start+l.count);r<o;r++){const o=d.getX(r);Er.fromBufferAttribute(u,o),testPoint(Er,o,h,a,t,i,this)}}else{for(let r=Math.max(0,l.start),o=Math.min(u.count,l.start+l.count);r<o;r++)Er.fromBufferAttribute(u,r),testPoint(Er,r,h,a,t,i,this)}}updateMorphTargets(){const t=this.geometry.morphAttributes,i=Object.keys(t);if(i.length>0){const r=t[i[0]];if(void 0!==r){this.morphTargetInfluences=[],this.morphTargetDictionary={};for(let t=0,i=r.length;t<i;t++){const i=r[t].name||String(t);this.morphTargetInfluences.push(0),this.morphTargetDictionary[i]=t}}}}}function testPoint(t,i,r,a,o,l,c){const h=wr.distanceSqToPoint(t);if(h<r){const r=new Vector3;wr.closestPointToPoint(t,r),r.applyMatrix4(a);const d=o.ray.origin.distanceTo(r);if(d<o.near||d>o.far)return;l.push({distance:d,distanceToRay:Math.sqrt(h),point:r,index:i,face:null,faceIndex:null,barycoord:null,object:c})}}class Group extends Object3D{constructor(){super(),this.isGroup=!0,this.type="Group"}}class CanvasTexture extends Texture{constructor(t,i,r,a,o,l,c,h,d){super(t,i,r,a,o,l,c,h,d),this.isCanvasTexture=!0,this.needsUpdate=!0}}class DepthTexture extends Texture{constructor(t,i,r,a,o,l,c,h,d,u=1026){if(u!==ye&&u!==ve)throw new Error("DepthTexture format must be either THREE.DepthFormat or THREE.DepthStencilFormat");void 0===r&&u===ye&&(r=ce),void 0===r&&u===ve&&(r=me),super(null,a,o,l,c,h,u,r,d),this.isDepthTexture=!0,this.image={width:t,height:i},this.magFilter=void 0!==c?c:Q,this.minFilter=void 0!==h?h:Q,this.flipY=!1,this.generateMipmaps=!1,this.compareFunction=null}copy(t){return super.copy(t),this.compareFunction=t.compareFunction,this}toJSON(t){const i=super.toJSON(t);return null!==this.compareFunction&&(i.compareFunction=this.compareFunction),i}}class Curve{constructor(){this.type="Curve",this.arcLengthDivisions=200}getPoint(){return null}getPointAt(t,i){const r=this.getUtoTmapping(t);return this.getPoint(r,i)}getPoints(t=5){const i=[];for(let r=0;r<=t;r++)i.push(this.getPoint(r/t));return i}getSpacedPoints(t=5){const i=[];for(let r=0;r<=t;r++)i.push(this.getPointAt(r/t));return i}getLength(){const t=this.getLengths();return t[t.length-1]}getLengths(t=this.arcLengthDivisions){if(this.cacheArcLengths&&this.cacheArcLengths.length===t+1&&!this.needsUpdate)return this.cacheArcLengths;this.needsUpdate=!1;const i=[];let r,a=this.getPoint(0),o=0;i.push(0);for(let l=1;l<=t;l++)r=this.getPoint(l/t),o+=r.distanceTo(a),i.push(o),a=r;return this.cacheArcLengths=i,i}updateArcLengths(){this.needsUpdate=!0,this.getLengths()}getUtoTmapping(t,i){const r=this.getLengths();let a=0;const o=r.length;let l;l=i||t*r[o-1];let c,h=0,d=o-1;for(;h<=d;)if(a=Math.floor(h+(d-h)/2),c=r[a]-l,c<0)h=a+1;else{if(!(c>0)){d=a;break}d=a-1}if(a=d,r[a]===l)return a/(o-1);const u=r[a];return(a+(l-u)/(r[a+1]-u))/(o-1)}getTangent(t,i){const r=1e-4;let a=t-r,o=t+r;a<0&&(a=0),o>1&&(o=1);const l=this.getPoint(a),c=this.getPoint(o),h=i||(l.isVector2?new Vector2:new Vector3);return h.copy(c).sub(l).normalize(),h}getTangentAt(t,i){const r=this.getUtoTmapping(t);return this.getTangent(r,i)}computeFrenetFrames(t,i){const r=new Vector3,a=[],o=[],l=[],c=new Vector3,h=new Matrix4;for(let i=0;i<=t;i++){const r=i/t;a[i]=this.getTangentAt(r,new Vector3)}o[0]=new Vector3,l[0]=new Vector3;let d=Number.MAX_VALUE;const u=Math.abs(a[0].x),p=Math.abs(a[0].y),m=Math.abs(a[0].z);u<=d&&(d=u,r.set(1,0,0)),p<=d&&(d=p,r.set(0,1,0)),m<=d&&r.set(0,0,1),c.crossVectors(a[0],r).normalize(),o[0].crossVectors(a[0],c),l[0].crossVectors(a[0],o[0]);for(let i=1;i<=t;i++){if(o[i]=o[i-1].clone(),l[i]=l[i-1].clone(),c.crossVectors(a[i-1],a[i]),c.length()>Number.EPSILON){c.normalize();const t=Math.acos(clamp(a[i-1].dot(a[i]),-1,1));o[i].applyMatrix4(h.makeRotationAxis(c,t))}l[i].crossVectors(a[i],o[i])}if(!0===i){let i=Math.acos(clamp(o[0].dot(o[t]),-1,1));i/=t,a[0].dot(c.crossVectors(o[0],o[t]))>0&&(i=-i);for(let r=1;r<=t;r++)o[r].applyMatrix4(h.makeRotationAxis(a[r],i*r)),l[r].crossVectors(a[r],o[r])}return{tangents:a,normals:o,binormals:l}}clone(){return(new this.constructor).copy(this)}copy(t){return this.arcLengthDivisions=t.arcLengthDivisions,this}toJSON(){const t={metadata:{version:4.6,type:"Curve",generator:"Curve.toJSON"}};return t.arcLengthDivisions=this.arcLengthDivisions,t.type=this.type,t}fromJSON(t){return this.arcLengthDivisions=t.arcLengthDivisions,this}}function CubicPoly(){let t=0,i=0,r=0,a=0;function init(o,l,c,h){t=o,i=c,r=-3*o+3*l-2*c-h,a=2*o-2*l+c+h}return{initCatmullRom:function(t,i,r,a,o){init(i,r,o*(r-t),o*(a-i))},initNonuniformCatmullRom:function(t,i,r,a,o,l,c){let h=(i-t)/o-(r-t)/(o+l)+(r-i)/l,d=(r-i)/l-(a-i)/(l+c)+(a-r)/c;h*=l,d*=l,init(i,r,h,d)},calc:function(o){const l=o*o;return t+i*o+r*l+a*(l*o)}}}const Ar=new Vector3,Cr=new CubicPoly,Pr=new CubicPoly,Rr=new CubicPoly;class CatmullRomCurve3 extends Curve{constructor(t=[],i=!1,r="centripetal",a=.5){super(),this.isCatmullRomCurve3=!0,this.type="CatmullRomCurve3",this.points=t,this.closed=i,this.curveType=r,this.tension=a}getPoint(t,i=new Vector3){const r=i,a=this.points,o=a.length,l=(o-(this.closed?0:1))*t;let c,h,d=Math.floor(l),u=l-d;this.closed?d+=d>0?0:(Math.floor(Math.abs(d)/o)+1)*o:0===u&&d===o-1&&(d=o-2,u=1),this.closed||d>0?c=a[(d-1)%o]:(Ar.subVectors(a[0],a[1]).add(a[0]),c=Ar);const p=a[d%o],m=a[(d+1)%o];if(this.closed||d+2<o?h=a[(d+2)%o]:(Ar.subVectors(a[o-1],a[o-2]).add(a[o-1]),h=Ar),"centripetal"===this.curveType||"chordal"===this.curveType){const t="chordal"===this.curveType?.5:.25;let i=Math.pow(c.distanceToSquared(p),t),r=Math.pow(p.distanceToSquared(m),t),a=Math.pow(m.distanceToSquared(h),t);r<1e-4&&(r=1),i<1e-4&&(i=r),a<1e-4&&(a=r),Cr.initNonuniformCatmullRom(c.x,p.x,m.x,h.x,i,r,a),Pr.initNonuniformCatmullRom(c.y,p.y,m.y,h.y,i,r,a),Rr.initNonuniformCatmullRom(c.z,p.z,m.z,h.z,i,r,a)}else"catmullrom"===this.curveType&&(Cr.initCatmullRom(c.x,p.x,m.x,h.x,this.tension),Pr.initCatmullRom(c.y,p.y,m.y,h.y,this.tension),Rr.initCatmullRom(c.z,p.z,m.z,h.z,this.tension));return r.set(Cr.calc(u),Pr.calc(u),Rr.calc(u)),r}copy(t){super.copy(t),this.points=[];for(let i=0,r=t.points.length;i<r;i++){const r=t.points[i];this.points.push(r.clone())}return this.closed=t.closed,this.curveType=t.curveType,this.tension=t.tension,this}toJSON(){const t=super.toJSON();t.points=[];for(let i=0,r=this.points.length;i<r;i++){const r=this.points[i];t.points.push(r.toArray())}return t.closed=this.closed,t.curveType=this.curveType,t.tension=this.tension,t}fromJSON(t){super.fromJSON(t),this.points=[];for(let i=0,r=t.points.length;i<r;i++){const r=t.points[i];this.points.push((new Vector3).fromArray(r))}return this.closed=t.closed,this.curveType=t.curveType,this.tension=t.tension,this}}class PolyhedronGeometry extends BufferGeometry{constructor(t=[],i=[],r=1,a=0){super(),this.type="PolyhedronGeometry",this.parameters={vertices:t,indices:i,radius:r,detail:a};const o=[],l=[];function subdivideFace(t,i,r,a){const o=a+1,l=[];for(let a=0;a<=o;a++){l[a]=[];const c=t.clone().lerp(r,a/o),h=i.clone().lerp(r,a/o),d=o-a;for(let t=0;t<=d;t++)l[a][t]=0===t&&a===o?c:c.clone().lerp(h,t/d)}for(let t=0;t<o;t++)for(let i=0;i<2*(o-t)-1;i++){const r=Math.floor(i/2);i%2==0?(pushVertex(l[t][r+1]),pushVertex(l[t+1][r]),pushVertex(l[t][r])):(pushVertex(l[t][r+1]),pushVertex(l[t+1][r+1]),pushVertex(l[t+1][r]))}}function pushVertex(t){o.push(t.x,t.y,t.z)}function getVertexByIndex(i,r){const a=3*i;r.x=t[a+0],r.y=t[a+1],r.z=t[a+2]}function correctUV(t,i,r,a){a<0&&1===t.x&&(l[i]=t.x-1),0===r.x&&0===r.z&&(l[i]=a/2/Math.PI+.5)}function azimuth(t){return Math.atan2(t.z,-t.x)}!function subdivide(t){const r=new Vector3,a=new Vector3,o=new Vector3;for(let l=0;l<i.length;l+=3)getVertexByIndex(i[l+0],r),getVertexByIndex(i[l+1],a),getVertexByIndex(i[l+2],o),subdivideFace(r,a,o,t)}(a),function applyRadius(t){const i=new Vector3;for(let r=0;r<o.length;r+=3)i.x=o[r+0],i.y=o[r+1],i.z=o[r+2],i.normalize().multiplyScalar(t),o[r+0]=i.x,o[r+1]=i.y,o[r+2]=i.z}(r),function generateUVs(){const t=new Vector3;for(let r=0;r<o.length;r+=3){t.x=o[r+0],t.y=o[r+1],t.z=o[r+2];const a=azimuth(t)/2/Math.PI+.5,c=(i=t,Math.atan2(-i.y,Math.sqrt(i.x*i.x+i.z*i.z))/Math.PI+.5);l.push(a,1-c)}var i;(function correctUVs(){const t=new Vector3,i=new Vector3,r=new Vector3,a=new Vector3,c=new Vector2,h=new Vector2,d=new Vector2;for(let u=0,p=0;u<o.length;u+=9,p+=6){t.set(o[u+0],o[u+1],o[u+2]),i.set(o[u+3],o[u+4],o[u+5]),r.set(o[u+6],o[u+7],o[u+8]),c.set(l[p+0],l[p+1]),h.set(l[p+2],l[p+3]),d.set(l[p+4],l[p+5]),a.copy(t).add(i).add(r).divideScalar(3);const m=azimuth(a);correctUV(c,p+0,t,m),correctUV(h,p+2,i,m),correctUV(d,p+4,r,m)}})(),function correctSeam(){for(let t=0;t<l.length;t+=6){const i=l[t+0],r=l[t+2],a=l[t+4],o=Math.max(i,r,a),c=Math.min(i,r,a);o>.9&&c<.1&&(i<.2&&(l[t+0]+=1),r<.2&&(l[t+2]+=1),a<.2&&(l[t+4]+=1))}}()}(),this.setAttribute("position",new Float32BufferAttribute(o,3)),this.setAttribute("normal",new Float32BufferAttribute(o.slice(),3)),this.setAttribute("uv",new Float32BufferAttribute(l,2)),0===a?this.computeVertexNormals():this.normalizeNormals()}copy(t){return super.copy(t),this.parameters=Object.assign({},t.parameters),this}static fromJSON(t){return new PolyhedronGeometry(t.vertices,t.indices,t.radius,t.details)}}class OctahedronGeometry extends PolyhedronGeometry{constructor(t=1,i=0){super([1,0,0,-1,0,0,0,1,0,0,-1,0,0,0,1,0,0,-1],[0,2,4,0,4,3,0,3,5,0,5,2,1,2,5,1,5,3,1,3,4,1,4,2],t,i),this.type="OctahedronGeometry",this.parameters={radius:t,detail:i}}static fromJSON(t){return new OctahedronGeometry(t.radius,t.detail)}}class PlaneGeometry extends BufferGeometry{constructor(t=1,i=1,r=1,a=1){super(),this.type="PlaneGeometry",this.parameters={width:t,height:i,widthSegments:r,heightSegments:a};const o=t/2,l=i/2,c=Math.floor(r),h=Math.floor(a),d=c+1,u=h+1,p=t/c,m=i/h,g=[],y=[],v=[],x=[];for(let t=0;t<u;t++){const i=t*m-l;for(let r=0;r<d;r++){const a=r*p-o;y.push(a,-i,0),v.push(0,0,1),x.push(r/c),x.push(1-t/h)}}for(let t=0;t<h;t++)for(let i=0;i<c;i++){const r=i+d*t,a=i+d*(t+1),o=i+1+d*(t+1),l=i+1+d*t;g.push(r,a,l),g.push(a,o,l)}this.setIndex(g),this.setAttribute("position",new Float32BufferAttribute(y,3)),this.setAttribute("normal",new Float32BufferAttribute(v,3)),this.setAttribute("uv",new Float32BufferAttribute(x,2))}copy(t){return super.copy(t),this.parameters=Object.assign({},t.parameters),this}static fromJSON(t){return new PlaneGeometry(t.width,t.height,t.widthSegments,t.heightSegments)}}class SphereGeometry extends BufferGeometry{constructor(t=1,i=32,r=16,a=0,o=2*Math.PI,l=0,c=Math.PI){super(),this.type="SphereGeometry",this.parameters={radius:t,widthSegments:i,heightSegments:r,phiStart:a,phiLength:o,thetaStart:l,thetaLength:c},i=Math.max(3,Math.floor(i)),r=Math.max(2,Math.floor(r));const h=Math.min(l+c,Math.PI);let d=0;const u=[],p=new Vector3,m=new Vector3,g=[],y=[],v=[],x=[];for(let g=0;g<=r;g++){const b=[],_=g/r;let S=0;0===g&&0===l?S=.5/i:g===r&&h===Math.PI&&(S=-.5/i);for(let r=0;r<=i;r++){const h=r/i;p.x=-t*Math.cos(a+h*o)*Math.sin(l+_*c),p.y=t*Math.cos(l+_*c),p.z=t*Math.sin(a+h*o)*Math.sin(l+_*c),y.push(p.x,p.y,p.z),m.copy(p).normalize(),v.push(m.x,m.y,m.z),x.push(h+S,1-_),b.push(d++)}u.push(b)}for(let t=0;t<r;t++)for(let a=0;a<i;a++){const i=u[t][a+1],o=u[t][a],c=u[t+1][a],d=u[t+1][a+1];(0!==t||l>0)&&g.push(i,o,d),(t!==r-1||h<Math.PI)&&g.push(o,c,d)}this.setIndex(g),this.setAttribute("position",new Float32BufferAttribute(y,3)),this.setAttribute("normal",new Float32BufferAttribute(v,3)),this.setAttribute("uv",new Float32BufferAttribute(x,2))}copy(t){return super.copy(t),this.parameters=Object.assign({},t.parameters),this}static fromJSON(t){return new SphereGeometry(t.radius,t.widthSegments,t.heightSegments,t.phiStart,t.phiLength,t.thetaStart,t.thetaLength)}}class ShadowMaterial extends Material{constructor(t){super(),this.isShadowMaterial=!0,this.type="ShadowMaterial",this.color=new $i(0),this.transparent=!0,this.fog=!0,this.setValues(t)}copy(t){return super.copy(t),this.color.copy(t.color),this.fog=t.fog,this}}class MeshStandardMaterial extends Material{constructor(t){super(),this.isMeshStandardMaterial=!0,this.type="MeshStandardMaterial",this.defines={STANDARD:""},this.color=new $i(16777215),this.roughness=1,this.metalness=0,this.map=null,this.lightMap=null,this.lightMapIntensity=1,this.aoMap=null,this.aoMapIntensity=1,this.emissive=new $i(0),this.emissiveIntensity=1,this.emissiveMap=null,this.bumpMap=null,this.bumpScale=1,this.normalMap=null,this.normalMapType=0,this.normalScale=new Vector2(1,1),this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.roughnessMap=null,this.metalnessMap=null,this.alphaMap=null,this.envMap=null,this.envMapRotation=new Euler,this.envMapIntensity=1,this.wireframe=!1,this.wireframeLinewidth=1,this.wireframeLinecap="round",this.wireframeLinejoin="round",this.flatShading=!1,this.fog=!0,this.setValues(t)}copy(t){return super.copy(t),this.defines={STANDARD:""},this.color.copy(t.color),this.roughness=t.roughness,this.metalness=t.metalness,this.map=t.map,this.lightMap=t.lightMap,this.lightMapIntensity=t.lightMapIntensity,this.aoMap=t.aoMap,this.aoMapIntensity=t.aoMapIntensity,this.emissive.copy(t.emissive),this.emissiveMap=t.emissiveMap,this.emissiveIntensity=t.emissiveIntensity,this.bumpMap=t.bumpMap,this.bumpScale=t.bumpScale,this.normalMap=t.normalMap,this.normalMapType=t.normalMapType,this.normalScale.copy(t.normalScale),this.displacementMap=t.displacementMap,this.displacementScale=t.displacementScale,this.displacementBias=t.displacementBias,this.roughnessMap=t.roughnessMap,this.metalnessMap=t.metalnessMap,this.alphaMap=t.alphaMap,this.envMap=t.envMap,this.envMapRotation.copy(t.envMapRotation),this.envMapIntensity=t.envMapIntensity,this.wireframe=t.wireframe,this.wireframeLinewidth=t.wireframeLinewidth,this.wireframeLinecap=t.wireframeLinecap,this.wireframeLinejoin=t.wireframeLinejoin,this.flatShading=t.flatShading,this.fog=t.fog,this}}class MeshPhysicalMaterial extends MeshStandardMaterial{constructor(t){super(),this.isMeshPhysicalMaterial=!0,this.defines={STANDARD:"",PHYSICAL:""},this.type="MeshPhysicalMaterial",this.anisotropyRotation=0,this.anisotropyMap=null,this.clearcoatMap=null,this.clearcoatRoughness=0,this.clearcoatRoughnessMap=null,this.clearcoatNormalScale=new Vector2(1,1),this.clearcoatNormalMap=null,this.ior=1.5,Object.defineProperty(this,"reflectivity",{get:function(){return clamp(2.5*(this.ior-1)/(this.ior+1),0,1)},set:function(t){this.ior=(1+.4*t)/(1-.4*t)}}),this.iridescenceMap=null,this.iridescenceIOR=1.3,this.iridescenceThicknessRange=[100,400],this.iridescenceThicknessMap=null,this.sheenColor=new $i(0),this.sheenColorMap=null,this.sheenRoughness=1,this.sheenRoughnessMap=null,this.transmissionMap=null,this.thickness=0,this.thicknessMap=null,this.attenuationDistance=1/0,this.attenuationColor=new $i(1,1,1),this.specularIntensity=1,this.specularIntensityMap=null,this.specularColor=new $i(1,1,1),this.specularColorMap=null,this._anisotropy=0,this._clearcoat=0,this._dispersion=0,this._iridescence=0,this._sheen=0,this._transmission=0,this.setValues(t)}get anisotropy(){return this._anisotropy}set anisotropy(t){this._anisotropy>0!=t>0&&this.version++,this._anisotropy=t}get clearcoat(){return this._clearcoat}set clearcoat(t){this._clearcoat>0!=t>0&&this.version++,this._clearcoat=t}get iridescence(){return this._iridescence}set iridescence(t){this._iridescence>0!=t>0&&this.version++,this._iridescence=t}get dispersion(){return this._dispersion}set dispersion(t){this._dispersion>0!=t>0&&this.version++,this._dispersion=t}get sheen(){return this._sheen}set sheen(t){this._sheen>0!=t>0&&this.version++,this._sheen=t}get transmission(){return this._transmission}set transmission(t){this._transmission>0!=t>0&&this.version++,this._transmission=t}copy(t){return super.copy(t),this.defines={STANDARD:"",PHYSICAL:""},this.anisotropy=t.anisotropy,this.anisotropyRotation=t.anisotropyRotation,this.anisotropyMap=t.anisotropyMap,this.clearcoat=t.clearcoat,this.clearcoatMap=t.clearcoatMap,this.clearcoatRoughness=t.clearcoatRoughness,this.clearcoatRoughnessMap=t.clearcoatRoughnessMap,this.clearcoatNormalMap=t.clearcoatNormalMap,this.clearcoatNormalScale.copy(t.clearcoatNormalScale),this.dispersion=t.dispersion,this.ior=t.ior,this.iridescence=t.iridescence,this.iridescenceMap=t.iridescenceMap,this.iridescenceIOR=t.iridescenceIOR,this.iridescenceThicknessRange=[...t.iridescenceThicknessRange],this.iridescenceThicknessMap=t.iridescenceThicknessMap,this.sheen=t.sheen,this.sheenColor.copy(t.sheenColor),this.sheenColorMap=t.sheenColorMap,this.sheenRoughness=t.sheenRoughness,this.sheenRoughnessMap=t.sheenRoughnessMap,this.transmission=t.transmission,this.transmissionMap=t.transmissionMap,this.thickness=t.thickness,this.thicknessMap=t.thicknessMap,this.attenuationDistance=t.attenuationDistance,this.attenuationColor.copy(t.attenuationColor),this.specularIntensity=t.specularIntensity,this.specularIntensityMap=t.specularIntensityMap,this.specularColor.copy(t.specularColor),this.specularColorMap=t.specularColorMap,this}}class MeshPhongMaterial extends Material{constructor(t){super(),this.isMeshPhongMaterial=!0,this.type="MeshPhongMaterial",this.color=new $i(16777215),this.specular=new $i(1118481),this.shininess=30,this.map=null,this.lightMap=null,this.lightMapIntensity=1,this.aoMap=null,this.aoMapIntensity=1,this.emissive=new $i(0),this.emissiveIntensity=1,this.emissiveMap=null,this.bumpMap=null,this.bumpScale=1,this.normalMap=null,this.normalMapType=0,this.normalScale=new Vector2(1,1),this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.specularMap=null,this.alphaMap=null,this.envMap=null,this.envMapRotation=new Euler,this.combine=0,this.reflectivity=1,this.refractionRatio=.98,this.wireframe=!1,this.wireframeLinewidth=1,this.wireframeLinecap="round",this.wireframeLinejoin="round",this.flatShading=!1,this.fog=!0,this.setValues(t)}copy(t){return super.copy(t),this.color.copy(t.color),this.specular.copy(t.specular),this.shininess=t.shininess,this.map=t.map,this.lightMap=t.lightMap,this.lightMapIntensity=t.lightMapIntensity,this.aoMap=t.aoMap,this.aoMapIntensity=t.aoMapIntensity,this.emissive.copy(t.emissive),this.emissiveMap=t.emissiveMap,this.emissiveIntensity=t.emissiveIntensity,this.bumpMap=t.bumpMap,this.bumpScale=t.bumpScale,this.normalMap=t.normalMap,this.normalMapType=t.normalMapType,this.normalScale.copy(t.normalScale),this.displacementMap=t.displacementMap,this.displacementScale=t.displacementScale,this.displacementBias=t.displacementBias,this.specularMap=t.specularMap,this.alphaMap=t.alphaMap,this.envMap=t.envMap,this.envMapRotation.copy(t.envMapRotation),this.combine=t.combine,this.reflectivity=t.reflectivity,this.refractionRatio=t.refractionRatio,this.wireframe=t.wireframe,this.wireframeLinewidth=t.wireframeLinewidth,this.wireframeLinecap=t.wireframeLinecap,this.wireframeLinejoin=t.wireframeLinejoin,this.flatShading=t.flatShading,this.fog=t.fog,this}}class MeshLambertMaterial extends Material{constructor(t){super(),this.isMeshLambertMaterial=!0,this.type="MeshLambertMaterial",this.color=new $i(16777215),this.map=null,this.lightMap=null,this.lightMapIntensity=1,this.aoMap=null,this.aoMapIntensity=1,this.emissive=new $i(0),this.emissiveIntensity=1,this.emissiveMap=null,this.bumpMap=null,this.bumpScale=1,this.normalMap=null,this.normalMapType=0,this.normalScale=new Vector2(1,1),this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.specularMap=null,this.alphaMap=null,this.envMap=null,this.envMapRotation=new Euler,this.combine=0,this.reflectivity=1,this.refractionRatio=.98,this.wireframe=!1,this.wireframeLinewidth=1,this.wireframeLinecap="round",this.wireframeLinejoin="round",this.flatShading=!1,this.fog=!0,this.setValues(t)}copy(t){return super.copy(t),this.color.copy(t.color),this.map=t.map,this.lightMap=t.lightMap,this.lightMapIntensity=t.lightMapIntensity,this.aoMap=t.aoMap,this.aoMapIntensity=t.aoMapIntensity,this.emissive.copy(t.emissive),this.emissiveMap=t.emissiveMap,this.emissiveIntensity=t.emissiveIntensity,this.bumpMap=t.bumpMap,this.bumpScale=t.bumpScale,this.normalMap=t.normalMap,this.normalMapType=t.normalMapType,this.normalScale.copy(t.normalScale),this.displacementMap=t.displacementMap,this.displacementScale=t.displacementScale,this.displacementBias=t.displacementBias,this.specularMap=t.specularMap,this.alphaMap=t.alphaMap,this.envMap=t.envMap,this.envMapRotation.copy(t.envMapRotation),this.combine=t.combine,this.reflectivity=t.reflectivity,this.refractionRatio=t.refractionRatio,this.wireframe=t.wireframe,this.wireframeLinewidth=t.wireframeLinewidth,this.wireframeLinecap=t.wireframeLinecap,this.wireframeLinejoin=t.wireframeLinejoin,this.flatShading=t.flatShading,this.fog=t.fog,this}}class MeshDepthMaterial extends Material{constructor(t){super(),this.isMeshDepthMaterial=!0,this.type="MeshDepthMaterial",this.depthPacking=3200,this.map=null,this.alphaMap=null,this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.wireframe=!1,this.wireframeLinewidth=1,this.setValues(t)}copy(t){return super.copy(t),this.depthPacking=t.depthPacking,this.map=t.map,this.alphaMap=t.alphaMap,this.displacementMap=t.displacementMap,this.displacementScale=t.displacementScale,this.displacementBias=t.displacementBias,this.wireframe=t.wireframe,this.wireframeLinewidth=t.wireframeLinewidth,this}}class MeshDistanceMaterial extends Material{constructor(t){super(),this.isMeshDistanceMaterial=!0,this.type="MeshDistanceMaterial",this.map=null,this.alphaMap=null,this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.setValues(t)}copy(t){return super.copy(t),this.map=t.map,this.alphaMap=t.alphaMap,this.displacementMap=t.displacementMap,this.displacementScale=t.displacementScale,this.displacementBias=t.displacementBias,this}}function convertArray(t,i,r){return!t||!r&&t.constructor===i?t:"number"==typeof i.BYTES_PER_ELEMENT?new i(t):Array.prototype.slice.call(t)}function getKeyframeOrder(t){const i=t.length,r=new Array(i);for(let t=0;t!==i;++t)r[t]=t;return r.sort((function compareTime(i,r){return t[i]-t[r]})),r}function sortedArray(t,i,r){const a=t.length,o=new t.constructor(a);for(let l=0,c=0;c!==a;++l){const a=r[l]*i;for(let r=0;r!==i;++r)o[c++]=t[a+r]}return o}function flattenJSON(t,i,r,a){let o=1,l=t[0];for(;void 0!==l&&void 0===l[a];)l=t[o++];if(void 0===l)return;let c=l[a];if(void 0!==c)if(Array.isArray(c))do{c=l[a],void 0!==c&&(i.push(l.time),r.push.apply(r,c)),l=t[o++]}while(void 0!==l);else if(void 0!==c.toArray)do{c=l[a],void 0!==c&&(i.push(l.time),c.toArray(r,r.length)),l=t[o++]}while(void 0!==l);else do{c=l[a],void 0!==c&&(i.push(l.time),r.push(c)),l=t[o++]}while(void 0!==l)}class Interpolant{constructor(t,i,r,a){this.parameterPositions=t,this._cachedIndex=0,this.resultBuffer=void 0!==a?a:new i.constructor(r),this.sampleValues=i,this.valueSize=r,this.settings=null,this.DefaultSettings_={}}evaluate(t){const i=this.parameterPositions;let r=this._cachedIndex,a=i[r],o=i[r-1];e:{t:{let l;i:{n:if(!(t<a)){for(let l=r+2;;){if(void 0===a){if(t<o)break n;return r=i.length,this._cachedIndex=r,this.copySampleValue_(r-1)}if(r===l)break;if(o=a,a=i[++r],t<a)break t}l=i.length;break i}if(t>=o)break e;{const c=i[1];t<c&&(r=2,o=c);for(let l=r-2;;){if(void 0===o)return this._cachedIndex=0,this.copySampleValue_(0);if(r===l)break;if(a=o,o=i[--r-1],t>=o)break t}l=r,r=0}}for(;r<l;){const a=r+l>>>1;t<i[a]?l=a:r=a+1}if(a=i[r],o=i[r-1],void 0===o)return this._cachedIndex=0,this.copySampleValue_(0);if(void 0===a)return r=i.length,this._cachedIndex=r,this.copySampleValue_(r-1)}this._cachedIndex=r,this.intervalChanged_(r,o,a)}return this.interpolate_(r,o,t,a)}getSettings_(){return this.settings||this.DefaultSettings_}copySampleValue_(t){const i=this.resultBuffer,r=this.sampleValues,a=this.valueSize,o=t*a;for(let t=0;t!==a;++t)i[t]=r[o+t];return i}interpolate_(){throw new Error("call to abstract method")}intervalChanged_(){}}class CubicInterpolant extends Interpolant{constructor(t,i,r,a){super(t,i,r,a),this._weightPrev=-0,this._offsetPrev=-0,this._weightNext=-0,this._offsetNext=-0,this.DefaultSettings_={endingStart:nt,endingEnd:nt}}intervalChanged_(t,i,r){const a=this.parameterPositions;let o=t-2,l=t+1,c=a[o],h=a[l];if(void 0===c)switch(this.getSettings_().endingStart){case rt:o=t,c=2*i-r;break;case st:o=a.length-2,c=i+a[o]-a[o+1];break;default:o=t,c=r}if(void 0===h)switch(this.getSettings_().endingEnd){case rt:l=t,h=2*r-i;break;case st:l=1,h=r+a[1]-a[0];break;default:l=t-1,h=i}const d=.5*(r-i),u=this.valueSize;this._weightPrev=d/(i-c),this._weightNext=d/(h-r),this._offsetPrev=o*u,this._offsetNext=l*u}interpolate_(t,i,r,a){const o=this.resultBuffer,l=this.sampleValues,c=this.valueSize,h=t*c,d=h-c,u=this._offsetPrev,p=this._offsetNext,m=this._weightPrev,g=this._weightNext,y=(r-i)/(a-i),v=y*y,x=v*y,b=-m*x+2*m*v-m*y,_=(1+m)*x+(-1.5-2*m)*v+(-.5+m)*y+1,S=(-1-g)*x+(1.5+g)*v+.5*y,M=g*x-g*v;for(let t=0;t!==c;++t)o[t]=b*l[u+t]+_*l[d+t]+S*l[h+t]+M*l[p+t];return o}}class LinearInterpolant extends Interpolant{constructor(t,i,r,a){super(t,i,r,a)}interpolate_(t,i,r,a){const o=this.resultBuffer,l=this.sampleValues,c=this.valueSize,h=t*c,d=h-c,u=(r-i)/(a-i),p=1-u;for(let t=0;t!==c;++t)o[t]=l[d+t]*p+l[h+t]*u;return o}}class DiscreteInterpolant extends Interpolant{constructor(t,i,r,a){super(t,i,r,a)}interpolate_(t){return this.copySampleValue_(t-1)}}class KeyframeTrack{constructor(t,i,r,a){if(void 0===t)throw new Error("THREE.KeyframeTrack: track name is undefined");if(void 0===i||0===i.length)throw new Error("THREE.KeyframeTrack: no keyframes in track named "+t);this.name=t,this.times=convertArray(i,this.TimeBufferType),this.values=convertArray(r,this.ValueBufferType),this.setInterpolation(a||this.DefaultInterpolation)}static toJSON(t){const i=t.constructor;let r;if(i.toJSON!==this.toJSON)r=i.toJSON(t);else{r={name:t.name,times:convertArray(t.times,Array),values:convertArray(t.values,Array)};const i=t.getInterpolation();i!==t.DefaultInterpolation&&(r.interpolation=i)}return r.type=t.ValueTypeName,r}InterpolantFactoryMethodDiscrete(t){return new DiscreteInterpolant(this.times,this.values,this.getValueSize(),t)}InterpolantFactoryMethodLinear(t){return new LinearInterpolant(this.times,this.values,this.getValueSize(),t)}InterpolantFactoryMethodSmooth(t){return new CubicInterpolant(this.times,this.values,this.getValueSize(),t)}setInterpolation(t){let i;switch(t){case et:i=this.InterpolantFactoryMethodDiscrete;break;case tt:i=this.InterpolantFactoryMethodLinear;break;case it:i=this.InterpolantFactoryMethodSmooth}if(void 0===i){const i="unsupported interpolation for "+this.ValueTypeName+" keyframe track named "+this.name;if(void 0===this.createInterpolant){if(t===this.DefaultInterpolation)throw new Error(i);this.setInterpolation(this.DefaultInterpolation)}return this}return this.createInterpolant=i,this}getInterpolation(){switch(this.createInterpolant){case this.InterpolantFactoryMethodDiscrete:return et;case this.InterpolantFactoryMethodLinear:return tt;case this.InterpolantFactoryMethodSmooth:return it}}getValueSize(){return this.values.length/this.times.length}shift(t){if(0!==t){const i=this.times;for(let r=0,a=i.length;r!==a;++r)i[r]+=t}return this}scale(t){if(1!==t){const i=this.times;for(let r=0,a=i.length;r!==a;++r)i[r]*=t}return this}trim(t,i){const r=this.times,a=r.length;let o=0,l=a-1;for(;o!==a&&r[o]<t;)++o;for(;-1!==l&&r[l]>i;)--l;if(++l,0!==o||l!==a){o>=l&&(l=Math.max(l,1),o=l-1);const t=this.getValueSize();this.times=r.slice(o,l),this.values=this.values.slice(o*t,l*t)}return this}validate(){let t=!0;const i=this.getValueSize();i-Math.floor(i)!=0&&(t=!1);const r=this.times,a=this.values,o=r.length;0===o&&(t=!1);let l=null;for(let i=0;i!==o;i++){const a=r[i];if("number"==typeof a&&isNaN(a)){t=!1;break}if(null!==l&&l>a){t=!1;break}l=a}if(void 0!==a&&function isTypedArray(t){return ArrayBuffer.isView(t)&&!(t instanceof DataView)}(a))for(let i=0,r=a.length;i!==r;++i){const r=a[i];if(isNaN(r)){t=!1;break}}return t}optimize(){const t=this.times.slice(),i=this.values.slice(),r=this.getValueSize(),a=this.getInterpolation()===it,o=t.length-1;let l=1;for(let c=1;c<o;++c){let o=!1;const h=t[c];if(h!==t[c+1]&&(1!==c||h!==t[0]))if(a)o=!0;else{const t=c*r,a=t-r,l=t+r;for(let c=0;c!==r;++c){const r=i[t+c];if(r!==i[a+c]||r!==i[l+c]){o=!0;break}}}if(o){if(c!==l){t[l]=t[c];const a=c*r,o=l*r;for(let t=0;t!==r;++t)i[o+t]=i[a+t]}++l}}if(o>0){t[l]=t[o];for(let t=o*r,a=l*r,c=0;c!==r;++c)i[a+c]=i[t+c];++l}return l!==t.length?(this.times=t.slice(0,l),this.values=i.slice(0,l*r)):(this.times=t,this.values=i),this}clone(){const t=this.times.slice(),i=this.values.slice(),r=new(0,this.constructor)(this.name,t,i);return r.createInterpolant=this.createInterpolant,r}}KeyframeTrack.prototype.TimeBufferType=Float32Array,KeyframeTrack.prototype.ValueBufferType=Float32Array,KeyframeTrack.prototype.DefaultInterpolation=tt;class BooleanKeyframeTrack extends KeyframeTrack{constructor(t,i,r){super(t,i,r)}}BooleanKeyframeTrack.prototype.ValueTypeName="bool",BooleanKeyframeTrack.prototype.ValueBufferType=Array,BooleanKeyframeTrack.prototype.DefaultInterpolation=et,BooleanKeyframeTrack.prototype.InterpolantFactoryMethodLinear=void 0,BooleanKeyframeTrack.prototype.InterpolantFactoryMethodSmooth=void 0;class ColorKeyframeTrack extends KeyframeTrack{}ColorKeyframeTrack.prototype.ValueTypeName="color";class NumberKeyframeTrack extends KeyframeTrack{}NumberKeyframeTrack.prototype.ValueTypeName="number";class QuaternionLinearInterpolant extends Interpolant{constructor(t,i,r,a){super(t,i,r,a)}interpolate_(t,i,r,a){const o=this.resultBuffer,l=this.sampleValues,c=this.valueSize,h=(r-i)/(a-i);let d=t*c;for(let t=d+c;d!==t;d+=4)Vt.slerpFlat(o,0,l,d-c,l,d,h);return o}}class QuaternionKeyframeTrack extends KeyframeTrack{InterpolantFactoryMethodLinear(t){return new QuaternionLinearInterpolant(this.times,this.values,this.getValueSize(),t)}}QuaternionKeyframeTrack.prototype.ValueTypeName="quaternion",QuaternionKeyframeTrack.prototype.InterpolantFactoryMethodSmooth=void 0;class StringKeyframeTrack extends KeyframeTrack{constructor(t,i,r){super(t,i,r)}}StringKeyframeTrack.prototype.ValueTypeName="string",StringKeyframeTrack.prototype.ValueBufferType=Array,StringKeyframeTrack.prototype.DefaultInterpolation=et,StringKeyframeTrack.prototype.InterpolantFactoryMethodLinear=void 0,StringKeyframeTrack.prototype.InterpolantFactoryMethodSmooth=void 0;class VectorKeyframeTrack extends KeyframeTrack{}VectorKeyframeTrack.prototype.ValueTypeName="vector";class AnimationClip{constructor(t="",i=-1,r=[],a=2500){this.name=t,this.tracks=r,this.duration=i,this.blendMode=a,this.uuid=generateUUID(),this.duration<0&&this.resetDuration()}static parse(t){const i=[],r=t.tracks,a=1/(t.fps||1);for(let t=0,o=r.length;t!==o;++t)i.push(parseKeyframeTrack(r[t]).scale(a));const o=new this(t.name,t.duration,i,t.blendMode);return o.uuid=t.uuid,o}static toJSON(t){const i=[],r=t.tracks,a={name:t.name,duration:t.duration,tracks:i,uuid:t.uuid,blendMode:t.blendMode};for(let t=0,a=r.length;t!==a;++t)i.push(KeyframeTrack.toJSON(r[t]));return a}static CreateFromMorphTargetSequence(t,i,r,a){const o=i.length,l=[];for(let t=0;t<o;t++){let c=[],h=[];c.push((t+o-1)%o,t,(t+1)%o),h.push(0,1,0);const d=getKeyframeOrder(c);c=sortedArray(c,1,d),h=sortedArray(h,1,d),a||0!==c[0]||(c.push(o),h.push(h[0])),l.push(new NumberKeyframeTrack(".morphTargetInfluences["+i[t].name+"]",c,h).scale(1/r))}return new this(t,-1,l)}static findByName(t,i){let r=t;if(!Array.isArray(t)){const i=t;r=i.geometry&&i.geometry.animations||i.animations}for(let t=0;t<r.length;t++)if(r[t].name===i)return r[t];return null}static CreateClipsFromMorphTargetSequences(t,i,r){const a={},o=/^([\w-]*?)([\d]+)$/;for(let i=0,r=t.length;i<r;i++){const r=t[i],l=r.name.match(o);if(l&&l.length>1){const t=l[1];let i=a[t];i||(a[t]=i=[]),i.push(r)}}const l=[];for(const t in a)l.push(this.CreateFromMorphTargetSequence(t,a[t],i,r));return l}static parseAnimation(t,i){if(!t)return null;const addNonemptyTrack=function(t,i,r,a,o){if(0!==r.length){const l=[],c=[];flattenJSON(r,l,c,a),0!==l.length&&o.push(new t(i,l,c))}},r=[],a=t.name||"default",o=t.fps||30,l=t.blendMode;let c=t.length||-1;const h=t.hierarchy||[];for(let t=0;t<h.length;t++){const a=h[t].keys;if(a&&0!==a.length)if(a[0].morphTargets){const t={};let i;for(i=0;i<a.length;i++)if(a[i].morphTargets)for(let r=0;r<a[i].morphTargets.length;r++)t[a[i].morphTargets[r]]=-1;for(const o in t){const t=[],l=[];for(let r=0;r!==a[i].morphTargets.length;++r){const r=a[i];t.push(r.time),l.push(r.morphTarget===o?1:0)}r.push(new NumberKeyframeTrack(".morphTargetInfluence["+o+"]",t,l))}c=t.length*o}else{const o=".bones["+i[t].name+"]";addNonemptyTrack(VectorKeyframeTrack,o+".position",a,"pos",r),addNonemptyTrack(QuaternionKeyframeTrack,o+".quaternion",a,"rot",r),addNonemptyTrack(VectorKeyframeTrack,o+".scale",a,"scl",r)}}if(0===r.length)return null;return new this(a,c,r,l)}resetDuration(){let t=0;for(let i=0,r=this.tracks.length;i!==r;++i){const r=this.tracks[i];t=Math.max(t,r.times[r.times.length-1])}return this.duration=t,this}trim(){for(let t=0;t<this.tracks.length;t++)this.tracks[t].trim(0,this.duration);return this}validate(){let t=!0;for(let i=0;i<this.tracks.length;i++)t=t&&this.tracks[i].validate();return t}optimize(){for(let t=0;t<this.tracks.length;t++)this.tracks[t].optimize();return this}clone(){const t=[];for(let i=0;i<this.tracks.length;i++)t.push(this.tracks[i].clone());return new this.constructor(this.name,this.duration,t,this.blendMode)}toJSON(){return this.constructor.toJSON(this)}}function parseKeyframeTrack(t){if(void 0===t.type)throw new Error("THREE.KeyframeTrack: track type undefined, can not parse");const i=function getTrackTypeForValueTypeName(t){switch(t.toLowerCase()){case"scalar":case"double":case"float":case"number":case"integer":return NumberKeyframeTrack;case"vector":case"vector2":case"vector3":case"vector4":return VectorKeyframeTrack;case"color":return ColorKeyframeTrack;case"quaternion":return QuaternionKeyframeTrack;case"bool":case"boolean":return BooleanKeyframeTrack;case"string":return StringKeyframeTrack}throw new Error("THREE.KeyframeTrack: Unsupported typeName: "+t)}(t.type);if(void 0===t.times){const i=[],r=[];flattenJSON(t.keys,i,r,"value"),t.times=i,t.values=r}return void 0!==i.parse?i.parse(t):new i(t.name,t.times,t.values,t.interpolation)}const Ir={enabled:!1,files:{},add:function(t,i){!1!==this.enabled&&(this.files[t]=i)},get:function(t){if(!1!==this.enabled)return this.files[t]},remove:function(t){delete this.files[t]},clear:function(){this.files={}}};class LoadingManager{constructor(t,i,r){const a=this;let o,l=!1,c=0,h=0;const d=[];this.onStart=void 0,this.onLoad=t,this.onProgress=i,this.onError=r,this.itemStart=function(t){h++,!1===l&&void 0!==a.onStart&&a.onStart(t,c,h),l=!0},this.itemEnd=function(t){c++,void 0!==a.onProgress&&a.onProgress(t,c,h),c===h&&(l=!1,void 0!==a.onLoad&&a.onLoad())},this.itemError=function(t){void 0!==a.onError&&a.onError(t)},this.resolveURL=function(t){return o?o(t):t},this.setURLModifier=function(t){return o=t,this},this.addHandler=function(t,i){return d.push(t,i),this},this.removeHandler=function(t){const i=d.indexOf(t);return-1!==i&&d.splice(i,2),this},this.getHandler=function(t){for(let i=0,r=d.length;i<r;i+=2){const r=d[i],a=d[i+1];if(r.global&&(r.lastIndex=0),r.test(t))return a}return null}}}const Dr=new LoadingManager;class Loader{constructor(t){this.manager=void 0!==t?t:Dr,this.crossOrigin="anonymous",this.withCredentials=!1,this.path="",this.resourcePath="",this.requestHeader={}}load(){}loadAsync(t,i){const r=this;return new Promise((function(a,o){r.load(t,a,i,o)}))}parse(){}setCrossOrigin(t){return this.crossOrigin=t,this}setWithCredentials(t){return this.withCredentials=t,this}setPath(t){return this.path=t,this}setResourcePath(t){return this.resourcePath=t,this}setRequestHeader(t){return this.requestHeader=t,this}}Loader.DEFAULT_MATERIAL_NAME="__DEFAULT";const Lr={};class HttpError extends Error{constructor(t,i){super(t),this.response=i}}class FileLoader extends Loader{constructor(t){super(t)}load(t,i,r,a){void 0===t&&(t=""),void 0!==this.path&&(t=this.path+t),t=this.manager.resolveURL(t);const o=Ir.get(t);if(void 0!==o)return this.manager.itemStart(t),setTimeout((()=>{i&&i(o),this.manager.itemEnd(t)}),0),o;if(void 0!==Lr[t])return void Lr[t].push({onLoad:i,onProgress:r,onError:a});Lr[t]=[],Lr[t].push({onLoad:i,onProgress:r,onError:a});const l=new Request(t,{headers:new Headers(this.requestHeader),credentials:this.withCredentials?"include":"same-origin"}),c=this.mimeType,h=this.responseType;fetch(l).then((i=>{if(200===i.status||0===i.status){if(i.status,"undefined"==typeof ReadableStream||void 0===i.body||void 0===i.body.getReader)return i;const r=Lr[t],a=i.body.getReader(),o=i.headers.get("X-File-Size")||i.headers.get("Content-Length"),l=o?parseInt(o):0,c=0!==l;let h=0;const d=new ReadableStream({start(t){!function readData(){a.read().then((({done:i,value:a})=>{if(i)t.close();else{h+=a.byteLength;const i=new ProgressEvent("progress",{lengthComputable:c,loaded:h,total:l});for(let t=0,a=r.length;t<a;t++){const a=r[t];a.onProgress&&a.onProgress(i)}t.enqueue(a),readData()}}),(i=>{t.error(i)}))}()}});return new Response(d)}throw new HttpError(`fetch for "${i.url}" responded with ${i.status}: ${i.statusText}`,i)})).then((t=>{switch(h){case"arraybuffer":return t.arrayBuffer();case"blob":return t.blob();case"document":return t.text().then((t=>(new DOMParser).parseFromString(t,c)));case"json":return t.json();default:if(void 0===c)return t.text();{const i=/charset="?([^;"\s]*)"?/i.exec(c),r=i&&i[1]?i[1].toLowerCase():void 0,a=new TextDecoder(r);return t.arrayBuffer().then((t=>a.decode(t)))}}})).then((i=>{Ir.add(t,i);const r=Lr[t];delete Lr[t];for(let t=0,a=r.length;t<a;t++){const a=r[t];a.onLoad&&a.onLoad(i)}})).catch((i=>{const r=Lr[t];if(void 0===r)throw this.manager.itemError(t),i;delete Lr[t];for(let t=0,a=r.length;t<a;t++){const a=r[t];a.onError&&a.onError(i)}this.manager.itemError(t)})).finally((()=>{this.manager.itemEnd(t)})),this.manager.itemStart(t)}setResponseType(t){return this.responseType=t,this}setMimeType(t){return this.mimeType=t,this}}class ImageLoader extends Loader{constructor(t){super(t)}load(t,i,r,a){void 0!==this.path&&(t=this.path+t),t=this.manager.resolveURL(t);const o=this,l=Ir.get(t);if(void 0!==l)return o.manager.itemStart(t),setTimeout((function(){i&&i(l),o.manager.itemEnd(t)}),0),l;const c=createElementNS("img");function onImageLoad(){removeEventListeners(),Ir.add(t,this),i&&i(this),o.manager.itemEnd(t)}function onImageError(i){removeEventListeners(),a&&a(i),o.manager.itemError(t),o.manager.itemEnd(t)}function removeEventListeners(){c.removeEventListener("load",onImageLoad,!1),c.removeEventListener("error",onImageError,!1)}return c.addEventListener("load",onImageLoad,!1),c.addEventListener("error",onImageError,!1),"data:"!==t.slice(0,5)&&void 0!==this.crossOrigin&&(c.crossOrigin=this.crossOrigin),o.manager.itemStart(t),c.src=t,c}}class CubeTextureLoader extends Loader{constructor(t){super(t)}load(t,i,r,a){const o=new CubeTexture;o.colorSpace=lt;const l=new ImageLoader(this.manager);l.setCrossOrigin(this.crossOrigin),l.setPath(this.path);let c=0;function loadTexture(r){l.load(t[r],(function(t){o.images[r]=t,c++,6===c&&(o.needsUpdate=!0,i&&i(o))}),void 0,a)}for(let i=0;i<t.length;++i)loadTexture(i);return o}}class DataTextureLoader extends Loader{constructor(t){super(t)}load(t,i,r,a){const o=this,l=new DataTexture,c=new FileLoader(this.manager);return c.setResponseType("arraybuffer"),c.setRequestHeader(this.requestHeader),c.setPath(this.path),c.setWithCredentials(o.withCredentials),c.load(t,(function(t){let r;try{r=o.parse(t)}catch(t){if(void 0===a)return;a(t)}void 0!==r.image?l.image=r.image:void 0!==r.data&&(l.image.width=r.width,l.image.height=r.height,l.image.data=r.data),l.wrapS=void 0!==r.wrapS?r.wrapS:Z,l.wrapT=void 0!==r.wrapT?r.wrapT:Z,l.magFilter=void 0!==r.magFilter?r.magFilter:te,l.minFilter=void 0!==r.minFilter?r.minFilter:te,l.anisotropy=void 0!==r.anisotropy?r.anisotropy:1,void 0!==r.colorSpace&&(l.colorSpace=r.colorSpace),void 0!==r.flipY&&(l.flipY=r.flipY),void 0!==r.format&&(l.format=r.format),void 0!==r.type&&(l.type=r.type),void 0!==r.mipmaps&&(l.mipmaps=r.mipmaps,l.minFilter=ne),1===r.mipmapCount&&(l.minFilter=te),void 0!==r.generateMipmaps&&(l.generateMipmaps=r.generateMipmaps),l.needsUpdate=!0,i&&i(l,r)}),r,a),l}}class TextureLoader extends Loader{constructor(t){super(t)}load(t,i,r,a){const o=new Texture,l=new ImageLoader(this.manager);return l.setCrossOrigin(this.crossOrigin),l.setPath(this.path),l.load(t,(function(t){o.image=t,o.needsUpdate=!0,void 0!==i&&i(o)}),r,a),o}}class Light extends Object3D{constructor(t,i=1){super(),this.isLight=!0,this.type="Light",this.color=new $i(t),this.intensity=i}dispose(){}copy(t,i){return super.copy(t,i),this.color.copy(t.color),this.intensity=t.intensity,this}toJSON(t){const i=super.toJSON(t);return i.object.color=this.color.getHex(),i.object.intensity=this.intensity,void 0!==this.groundColor&&(i.object.groundColor=this.groundColor.getHex()),void 0!==this.distance&&(i.object.distance=this.distance),void 0!==this.angle&&(i.object.angle=this.angle),void 0!==this.decay&&(i.object.decay=this.decay),void 0!==this.penumbra&&(i.object.penumbra=this.penumbra),void 0!==this.shadow&&(i.object.shadow=this.shadow.toJSON()),void 0!==this.target&&(i.object.target=this.target.uuid),i}}class HemisphereLight extends Light{constructor(t,i,r){super(t,r),this.isHemisphereLight=!0,this.type="HemisphereLight",this.position.copy(Object3D.DEFAULT_UP),this.updateMatrix(),this.groundColor=new $i(i)}copy(t,i){return super.copy(t,i),this.groundColor.copy(t.groundColor),this}}const Fr=new Matrix4,Nr=new Vector3,Or=new Vector3;class LightShadow{constructor(t){this.camera=t,this.intensity=1,this.bias=0,this.normalBias=0,this.radius=1,this.blurSamples=8,this.mapSize=new Vector2(512,512),this.map=null,this.mapPass=null,this.matrix=new Matrix4,this.autoUpdate=!0,this.needsUpdate=!1,this._frustum=new Frustum,this._frameExtents=new Vector2(1,1),this._viewportCount=1,this._viewports=[new Vector4(0,0,1,1)]}getViewportCount(){return this._viewportCount}getFrustum(){return this._frustum}updateMatrices(t){const i=this.camera,r=this.matrix;Nr.setFromMatrixPosition(t.matrixWorld),i.position.copy(Nr),Or.setFromMatrixPosition(t.target.matrixWorld),i.lookAt(Or),i.updateMatrixWorld(),Fr.multiplyMatrices(i.projectionMatrix,i.matrixWorldInverse),this._frustum.setFromProjectionMatrix(Fr),r.set(.5,0,0,.5,0,.5,0,.5,0,0,.5,.5,0,0,0,1),r.multiply(Fr)}getViewport(t){return this._viewports[t]}getFrameExtents(){return this._frameExtents}dispose(){this.map&&this.map.dispose(),this.mapPass&&this.mapPass.dispose()}copy(t){return this.camera=t.camera.clone(),this.intensity=t.intensity,this.bias=t.bias,this.radius=t.radius,this.mapSize.copy(t.mapSize),this}clone(){return(new this.constructor).copy(this)}toJSON(){const t={};return 1!==this.intensity&&(t.intensity=this.intensity),0!==this.bias&&(t.bias=this.bias),0!==this.normalBias&&(t.normalBias=this.normalBias),1!==this.radius&&(t.radius=this.radius),512===this.mapSize.x&&512===this.mapSize.y||(t.mapSize=this.mapSize.toArray()),t.camera=this.camera.toJSON(!1).object,delete t.camera.matrix,t}}class SpotLightShadow extends LightShadow{constructor(){super(new PerspectiveCamera(50,1,.5,500)),this.isSpotLightShadow=!0,this.focus=1}updateMatrices(t){const i=this.camera,r=2*Pt*t.angle*this.focus,a=this.mapSize.width/this.mapSize.height,o=t.distance||i.far;r===i.fov&&a===i.aspect&&o===i.far||(i.fov=r,i.aspect=a,i.far=o,i.updateProjectionMatrix()),super.updateMatrices(t)}copy(t){return super.copy(t),this.focus=t.focus,this}}class SpotLight extends Light{constructor(t,i,r=0,a=Math.PI/3,o=0,l=2){super(t,i),this.isSpotLight=!0,this.type="SpotLight",this.position.copy(Object3D.DEFAULT_UP),this.updateMatrix(),this.target=new Object3D,this.distance=r,this.angle=a,this.penumbra=o,this.decay=l,this.map=null,this.shadow=new SpotLightShadow}get power(){return this.intensity*Math.PI}set power(t){this.intensity=t/Math.PI}dispose(){this.shadow.dispose()}copy(t,i){return super.copy(t,i),this.distance=t.distance,this.angle=t.angle,this.penumbra=t.penumbra,this.decay=t.decay,this.target=t.target.clone(),this.shadow=t.shadow.clone(),this}}const Ur=new Matrix4,Br=new Vector3,zr=new Vector3;class PointLightShadow extends LightShadow{constructor(){super(new PerspectiveCamera(90,1,.5,500)),this.isPointLightShadow=!0,this._frameExtents=new Vector2(4,2),this._viewportCount=6,this._viewports=[new Vector4(2,1,1,1),new Vector4(0,1,1,1),new Vector4(3,1,1,1),new Vector4(1,1,1,1),new Vector4(3,0,1,1),new Vector4(1,0,1,1)],this._cubeDirections=[new Vector3(1,0,0),new Vector3(-1,0,0),new Vector3(0,0,1),new Vector3(0,0,-1),new Vector3(0,1,0),new Vector3(0,-1,0)],this._cubeUps=[new Vector3(0,1,0),new Vector3(0,1,0),new Vector3(0,1,0),new Vector3(0,1,0),new Vector3(0,0,1),new Vector3(0,0,-1)]}updateMatrices(t,i=0){const r=this.camera,a=this.matrix,o=t.distance||r.far;o!==r.far&&(r.far=o,r.updateProjectionMatrix()),Br.setFromMatrixPosition(t.matrixWorld),r.position.copy(Br),zr.copy(r.position),zr.add(this._cubeDirections[i]),r.up.copy(this._cubeUps[i]),r.lookAt(zr),r.updateMatrixWorld(),a.makeTranslation(-Br.x,-Br.y,-Br.z),Ur.multiplyMatrices(r.projectionMatrix,r.matrixWorldInverse),this._frustum.setFromProjectionMatrix(Ur)}}class PointLight extends Light{constructor(t,i,r=0,a=2){super(t,i),this.isPointLight=!0,this.type="PointLight",this.distance=r,this.decay=a,this.shadow=new PointLightShadow}get power(){return 4*this.intensity*Math.PI}set power(t){this.intensity=t/(4*Math.PI)}dispose(){this.shadow.dispose()}copy(t,i){return super.copy(t,i),this.distance=t.distance,this.decay=t.decay,this.shadow=t.shadow.clone(),this}}class OrthographicCamera extends Camera{constructor(t=-1,i=1,r=1,a=-1,o=.1,l=2e3){super(),this.isOrthographicCamera=!0,this.type="OrthographicCamera",this.zoom=1,this.view=null,this.left=t,this.right=i,this.top=r,this.bottom=a,this.near=o,this.far=l,this.updateProjectionMatrix()}copy(t,i){return super.copy(t,i),this.left=t.left,this.right=t.right,this.top=t.top,this.bottom=t.bottom,this.near=t.near,this.far=t.far,this.zoom=t.zoom,this.view=null===t.view?null:Object.assign({},t.view),this}setViewOffset(t,i,r,a,o,l){null===this.view&&(this.view={enabled:!0,fullWidth:1,fullHeight:1,offsetX:0,offsetY:0,width:1,height:1}),this.view.enabled=!0,this.view.fullWidth=t,this.view.fullHeight=i,this.view.offsetX=r,this.view.offsetY=a,this.view.width=o,this.view.height=l,this.updateProjectionMatrix()}clearViewOffset(){null!==this.view&&(this.view.enabled=!1),this.updateProjectionMatrix()}updateProjectionMatrix(){const t=(this.right-this.left)/(2*this.zoom),i=(this.top-this.bottom)/(2*this.zoom),r=(this.right+this.left)/2,a=(this.top+this.bottom)/2;let o=r-t,l=r+t,c=a+i,h=a-i;if(null!==this.view&&this.view.enabled){const t=(this.right-this.left)/this.view.fullWidth/this.zoom,i=(this.top-this.bottom)/this.view.fullHeight/this.zoom;o+=t*this.view.offsetX,l=o+t*this.view.width,c-=i*this.view.offsetY,h=c-i*this.view.height}this.projectionMatrix.makeOrthographic(o,l,c,h,this.near,this.far,this.coordinateSystem),this.projectionMatrixInverse.copy(this.projectionMatrix).invert()}toJSON(t){const i=super.toJSON(t);return i.object.zoom=this.zoom,i.object.left=this.left,i.object.right=this.right,i.object.top=this.top,i.object.bottom=this.bottom,i.object.near=this.near,i.object.far=this.far,null!==this.view&&(i.object.view=Object.assign({},this.view)),i}}class DirectionalLightShadow extends LightShadow{constructor(){super(new OrthographicCamera(-5,5,5,-5,.5,500)),this.isDirectionalLightShadow=!0}}class DirectionalLight extends Light{constructor(t,i){super(t,i),this.isDirectionalLight=!0,this.type="DirectionalLight",this.position.copy(Object3D.DEFAULT_UP),this.updateMatrix(),this.target=new Object3D,this.shadow=new DirectionalLightShadow}dispose(){this.shadow.dispose()}copy(t){return super.copy(t),this.target=t.target.clone(),this.shadow=t.shadow.clone(),this}}class LoaderUtils{static decodeText(t){if("undefined"!=typeof TextDecoder)return(new TextDecoder).decode(t);let i="";for(let r=0,a=t.length;r<a;r++)i+=String.fromCharCode(t[r]);try{return decodeURIComponent(escape(i))}catch(t){return i}}static extractUrlBase(t){const i=t.lastIndexOf("/");return-1===i?"./":t.slice(0,i+1)}static resolveURL(t,i){return"string"!=typeof t||""===t?"":(/^https?:\/\//i.test(i)&&/^\//.test(t)&&(i=i.replace(/(^https?:\/\/[^\/]+).*/i,"$1")),/^(https?:)?\/\//i.test(t)||/^data:.*,.*$/i.test(t)||/^blob:.*$/i.test(t)?t:i+t)}}class InstancedBufferGeometry extends BufferGeometry{constructor(){super(),this.isInstancedBufferGeometry=!0,this.type="InstancedBufferGeometry",this.instanceCount=1/0}copy(t){return super.copy(t),this.instanceCount=t.instanceCount,this}toJSON(){const t=super.toJSON();return t.instanceCount=this.instanceCount,t.isInstancedBufferGeometry=!0,t}}class BufferGeometryLoader extends Loader{constructor(t){super(t)}load(t,i,r,a){const o=this,l=new FileLoader(o.manager);l.setPath(o.path),l.setRequestHeader(o.requestHeader),l.setWithCredentials(o.withCredentials),l.load(t,(function(r){try{i(o.parse(JSON.parse(r)))}catch(i){a&&a(i),o.manager.itemError(t)}}),r,a)}parse(t){const i={},r={};function getInterleavedBuffer(t,a){if(void 0!==i[a])return i[a];const o=t.interleavedBuffers[a],l=function getArrayBuffer(t,i){if(void 0!==r[i])return r[i];const a=t.arrayBuffers,o=a[i],l=new Uint32Array(o).buffer;return r[i]=l,l}(t,o.buffer),c=getTypedArray(o.type,l),h=new InterleavedBuffer(c,o.stride);return h.uuid=o.uuid,i[a]=h,h}const a=t.isInstancedBufferGeometry?new InstancedBufferGeometry:new BufferGeometry,o=t.data.index;if(void 0!==o){const t=getTypedArray(o.type,o.array);a.setIndex(new BufferAttribute(t,1))}const l=t.data.attributes;for(const i in l){const r=l[i];let o;if(r.isInterleavedBufferAttribute){const i=getInterleavedBuffer(t.data,r.data);o=new InterleavedBufferAttribute(i,r.itemSize,r.offset,r.normalized)}else{const t=getTypedArray(r.type,r.array);o=new(r.isInstancedBufferAttribute?InstancedBufferAttribute:BufferAttribute)(t,r.itemSize,r.normalized)}void 0!==r.name&&(o.name=r.name),void 0!==r.usage&&o.setUsage(r.usage),a.setAttribute(i,o)}const c=t.data.morphAttributes;if(c)for(const i in c){const r=c[i],o=[];for(let i=0,a=r.length;i<a;i++){const a=r[i];let l;if(a.isInterleavedBufferAttribute){const i=getInterleavedBuffer(t.data,a.data);l=new InterleavedBufferAttribute(i,a.itemSize,a.offset,a.normalized)}else{const t=getTypedArray(a.type,a.array);l=new BufferAttribute(t,a.itemSize,a.normalized)}void 0!==a.name&&(l.name=a.name),o.push(l)}a.morphAttributes[i]=o}t.data.morphTargetsRelative&&(a.morphTargetsRelative=!0);const h=t.data.groups||t.data.drawcalls||t.data.offsets;if(void 0!==h)for(let t=0,i=h.length;t!==i;++t){const i=h[t];a.addGroup(i.start,i.count,i.materialIndex)}const d=t.data.boundingSphere;if(void 0!==d){const t=new Vector3;void 0!==d.center&&t.fromArray(d.center),a.boundingSphere=new Sphere(t,d.radius)}return t.name&&(a.name=t.name),t.userData&&(a.userData=t.userData),a}}class ImageBitmapLoader extends Loader{constructor(t){super(t),this.isImageBitmapLoader=!0,this.options={premultiplyAlpha:"none"}}setOptions(t){return this.options=t,this}load(t,i,r,a){void 0===t&&(t=""),void 0!==this.path&&(t=this.path+t),t=this.manager.resolveURL(t);const o=this,l=Ir.get(t);if(void 0!==l)return o.manager.itemStart(t),l.then?void l.then((r=>{i&&i(r),o.manager.itemEnd(t)})).catch((t=>{a&&a(t)})):(setTimeout((function(){i&&i(l),o.manager.itemEnd(t)}),0),l);const c={};c.credentials="anonymous"===this.crossOrigin?"same-origin":"include",c.headers=this.requestHeader;const h=fetch(t,c).then((function(t){return t.blob()})).then((function(t){return createImageBitmap(t,Object.assign(o.options,{colorSpaceConversion:"none"}))})).then((function(r){return Ir.add(t,r),i&&i(r),o.manager.itemEnd(t),r})).catch((function(i){a&&a(i),Ir.remove(t),o.manager.itemError(t),o.manager.itemEnd(t)}));Ir.add(t,h),o.manager.itemStart(t)}}class ArrayCamera extends PerspectiveCamera{constructor(t=[]){super(),this.isArrayCamera=!0,this.cameras=t}}class Clock{constructor(t=!0){this.autoStart=t,this.startTime=0,this.oldTime=0,this.elapsedTime=0,this.running=!1}start(){this.startTime=now(),this.oldTime=this.startTime,this.elapsedTime=0,this.running=!0}stop(){this.getElapsedTime(),this.running=!1,this.autoStart=!1}getElapsedTime(){return this.getDelta(),this.elapsedTime}getDelta(){let t=0;if(this.autoStart&&!this.running)return this.start(),0;if(this.running){const i=now();t=(i-this.oldTime)/1e3,this.oldTime=i,this.elapsedTime+=t}return t}}function now(){return performance.now()}class PropertyMixer{constructor(t,i,r){let a,o,l;switch(this.binding=t,this.valueSize=r,i){case"quaternion":a=this._slerp,o=this._slerpAdditive,l=this._setAdditiveIdentityQuaternion,this.buffer=new Float64Array(6*r),this._workIndex=5;break;case"string":case"bool":a=this._select,o=this._select,l=this._setAdditiveIdentityOther,this.buffer=new Array(5*r);break;default:a=this._lerp,o=this._lerpAdditive,l=this._setAdditiveIdentityNumeric,this.buffer=new Float64Array(5*r)}this._mixBufferRegion=a,this._mixBufferRegionAdditive=o,this._setIdentity=l,this._origIndex=3,this._addIndex=4,this.cumulativeWeight=0,this.cumulativeWeightAdditive=0,this.useCount=0,this.referenceCount=0}accumulate(t,i){const r=this.buffer,a=this.valueSize,o=t*a+a;let l=this.cumulativeWeight;if(0===l){for(let t=0;t!==a;++t)r[o+t]=r[t];l=i}else{l+=i;const t=i/l;this._mixBufferRegion(r,o,0,t,a)}this.cumulativeWeight=l}accumulateAdditive(t){const i=this.buffer,r=this.valueSize,a=r*this._addIndex;0===this.cumulativeWeightAdditive&&this._setIdentity(),this._mixBufferRegionAdditive(i,a,0,t,r),this.cumulativeWeightAdditive+=t}apply(t){const i=this.valueSize,r=this.buffer,a=t*i+i,o=this.cumulativeWeight,l=this.cumulativeWeightAdditive,c=this.binding;if(this.cumulativeWeight=0,this.cumulativeWeightAdditive=0,o<1){const t=i*this._origIndex;this._mixBufferRegion(r,a,t,1-o,i)}l>0&&this._mixBufferRegionAdditive(r,a,this._addIndex*i,1,i);for(let t=i,o=i+i;t!==o;++t)if(r[t]!==r[t+i]){c.setValue(r,a);break}}saveOriginalState(){const t=this.binding,i=this.buffer,r=this.valueSize,a=r*this._origIndex;t.getValue(i,a);for(let t=r,o=a;t!==o;++t)i[t]=i[a+t%r];this._setIdentity(),this.cumulativeWeight=0,this.cumulativeWeightAdditive=0}restoreOriginalState(){const t=3*this.valueSize;this.binding.setValue(this.buffer,t)}_setAdditiveIdentityNumeric(){const t=this._addIndex*this.valueSize,i=t+this.valueSize;for(let r=t;r<i;r++)this.buffer[r]=0}_setAdditiveIdentityQuaternion(){this._setAdditiveIdentityNumeric(),this.buffer[this._addIndex*this.valueSize+3]=1}_setAdditiveIdentityOther(){const t=this._origIndex*this.valueSize,i=this._addIndex*this.valueSize;for(let r=0;r<this.valueSize;r++)this.buffer[i+r]=this.buffer[t+r]}_select(t,i,r,a,o){if(a>=.5)for(let a=0;a!==o;++a)t[i+a]=t[r+a]}_slerp(t,i,r,a){Vt.slerpFlat(t,i,t,i,t,r,a)}_slerpAdditive(t,i,r,a,o){const l=this._workIndex*o;Vt.multiplyQuaternionsFlat(t,l,t,i,t,r),Vt.slerpFlat(t,i,t,i,t,l,a)}_lerp(t,i,r,a,o){const l=1-a;for(let c=0;c!==o;++c){const o=i+c;t[o]=t[o]*l+t[r+c]*a}}_lerpAdditive(t,i,r,a,o){for(let l=0;l!==o;++l){const o=i+l;t[o]=t[o]+t[r+l]*a}}}const Vr="\\[\\]\\.:\\/",kr=new RegExp("["+Vr+"]","g"),Gr="[^"+Vr+"]",Hr="[^"+Vr.replace("\\.","")+"]",Wr=new RegExp("^"+/((?:WC+[\/:])*)/.source.replace("WC",Gr)+/(WCOD+)?/.source.replace("WCOD",Hr)+/(?:\.(WC+)(?:\[(.+)\])?)?/.source.replace("WC",Gr)+/\.(WC+)(?:\[(.+)\])?/.source.replace("WC",Gr)+"$"),jr=["material","materials","bones","map"];class PropertyBinding{constructor(t,i,r){this.path=i,this.parsedPath=r||PropertyBinding.parseTrackName(i),this.node=PropertyBinding.findNode(t,this.parsedPath.nodeName),this.rootNode=t,this.getValue=this._getValue_unbound,this.setValue=this._setValue_unbound}static create(t,i,r){return t&&t.isAnimationObjectGroup?new PropertyBinding.Composite(t,i,r):new PropertyBinding(t,i,r)}static sanitizeNodeName(t){return t.replace(/\s/g,"_").replace(kr,"")}static parseTrackName(t){const i=Wr.exec(t);if(null===i)throw new Error("PropertyBinding: Cannot parse trackName: "+t);const r={nodeName:i[2],objectName:i[3],objectIndex:i[4],propertyName:i[5],propertyIndex:i[6]},a=r.nodeName&&r.nodeName.lastIndexOf(".");if(void 0!==a&&-1!==a){const t=r.nodeName.substring(a+1);-1!==jr.indexOf(t)&&(r.nodeName=r.nodeName.substring(0,a),r.objectName=t)}if(null===r.propertyName||0===r.propertyName.length)throw new Error("PropertyBinding: can not parse propertyName from trackName: "+t);return r}static findNode(t,i){if(void 0===i||""===i||"."===i||-1===i||i===t.name||i===t.uuid)return t;if(t.skeleton){const r=t.skeleton.getBoneByName(i);if(void 0!==r)return r}if(t.children){const searchNodeSubtree=function(t){for(let r=0;r<t.length;r++){const a=t[r];if(a.name===i||a.uuid===i)return a;const o=searchNodeSubtree(a.children);if(o)return o}return null},r=searchNodeSubtree(t.children);if(r)return r}return null}_getValue_unavailable(){}_setValue_unavailable(){}_getValue_direct(t,i){t[i]=this.targetObject[this.propertyName]}_getValue_array(t,i){const r=this.resolvedProperty;for(let a=0,o=r.length;a!==o;++a)t[i++]=r[a]}_getValue_arrayElement(t,i){t[i]=this.resolvedProperty[this.propertyIndex]}_getValue_toArray(t,i){this.resolvedProperty.toArray(t,i)}_setValue_direct(t,i){this.targetObject[this.propertyName]=t[i]}_setValue_direct_setNeedsUpdate(t,i){this.targetObject[this.propertyName]=t[i],this.targetObject.needsUpdate=!0}_setValue_direct_setMatrixWorldNeedsUpdate(t,i){this.targetObject[this.propertyName]=t[i],this.targetObject.matrixWorldNeedsUpdate=!0}_setValue_array(t,i){const r=this.resolvedProperty;for(let a=0,o=r.length;a!==o;++a)r[a]=t[i++]}_setValue_array_setNeedsUpdate(t,i){const r=this.resolvedProperty;for(let a=0,o=r.length;a!==o;++a)r[a]=t[i++];this.targetObject.needsUpdate=!0}_setValue_array_setMatrixWorldNeedsUpdate(t,i){const r=this.resolvedProperty;for(let a=0,o=r.length;a!==o;++a)r[a]=t[i++];this.targetObject.matrixWorldNeedsUpdate=!0}_setValue_arrayElement(t,i){this.resolvedProperty[this.propertyIndex]=t[i]}_setValue_arrayElement_setNeedsUpdate(t,i){this.resolvedProperty[this.propertyIndex]=t[i],this.targetObject.needsUpdate=!0}_setValue_arrayElement_setMatrixWorldNeedsUpdate(t,i){this.resolvedProperty[this.propertyIndex]=t[i],this.targetObject.matrixWorldNeedsUpdate=!0}_setValue_fromArray(t,i){this.resolvedProperty.fromArray(t,i)}_setValue_fromArray_setNeedsUpdate(t,i){this.resolvedProperty.fromArray(t,i),this.targetObject.needsUpdate=!0}_setValue_fromArray_setMatrixWorldNeedsUpdate(t,i){this.resolvedProperty.fromArray(t,i),this.targetObject.matrixWorldNeedsUpdate=!0}_getValue_unbound(t,i){this.bind(),this.getValue(t,i)}_setValue_unbound(t,i){this.bind(),this.setValue(t,i)}bind(){let t=this.node;const i=this.parsedPath,r=i.objectName,a=i.propertyName;let o=i.propertyIndex;if(t||(t=PropertyBinding.findNode(this.rootNode,i.nodeName),this.node=t),this.getValue=this._getValue_unavailable,this.setValue=this._setValue_unavailable,!t)return;if(r){let a=i.objectIndex;switch(r){case"materials":if(!t.material)return;if(!t.material.materials)return;t=t.material.materials;break;case"bones":if(!t.skeleton)return;t=t.skeleton.bones;for(let i=0;i<t.length;i++)if(t[i].name===a){a=i;break}break;case"map":if("map"in t){t=t.map;break}if(!t.material)return;if(!t.material.map)return;t=t.material.map;break;default:if(void 0===t[r])return;t=t[r]}if(void 0!==a){if(void 0===t[a])return;t=t[a]}}const l=t[a];if(void 0===l){i.nodeName;return}let c=this.Versioning.None;this.targetObject=t,!0===t.isMaterial?c=this.Versioning.NeedsUpdate:!0===t.isObject3D&&(c=this.Versioning.MatrixWorldNeedsUpdate);let h=this.BindingType.Direct;if(void 0!==o){if("morphTargetInfluences"===a){if(!t.geometry)return;if(!t.geometry.morphAttributes)return;void 0!==t.morphTargetDictionary[o]&&(o=t.morphTargetDictionary[o])}h=this.BindingType.ArrayElement,this.resolvedProperty=l,this.propertyIndex=o}else void 0!==l.fromArray&&void 0!==l.toArray?(h=this.BindingType.HasFromToArray,this.resolvedProperty=l):Array.isArray(l)?(h=this.BindingType.EntireArray,this.resolvedProperty=l):this.propertyName=a;this.getValue=this.GetterByBindingType[h],this.setValue=this.SetterByBindingTypeAndVersioning[h][c]}unbind(){this.node=null,this.getValue=this._getValue_unbound,this.setValue=this._setValue_unbound}}PropertyBinding.Composite=class Composite{constructor(t,i,r){const a=r||PropertyBinding.parseTrackName(i);this._targetGroup=t,this._bindings=t.subscribe_(i,a)}getValue(t,i){this.bind();const r=this._targetGroup.nCachedObjects_,a=this._bindings[r];void 0!==a&&a.getValue(t,i)}setValue(t,i){const r=this._bindings;for(let a=this._targetGroup.nCachedObjects_,o=r.length;a!==o;++a)r[a].setValue(t,i)}bind(){const t=this._bindings;for(let i=this._targetGroup.nCachedObjects_,r=t.length;i!==r;++i)t[i].bind()}unbind(){const t=this._bindings;for(let i=this._targetGroup.nCachedObjects_,r=t.length;i!==r;++i)t[i].unbind()}},PropertyBinding.prototype.BindingType={Direct:0,EntireArray:1,ArrayElement:2,HasFromToArray:3},PropertyBinding.prototype.Versioning={None:0,NeedsUpdate:1,MatrixWorldNeedsUpdate:2},PropertyBinding.prototype.GetterByBindingType=[PropertyBinding.prototype._getValue_direct,PropertyBinding.prototype._getValue_array,PropertyBinding.prototype._getValue_arrayElement,PropertyBinding.prototype._getValue_toArray],PropertyBinding.prototype.SetterByBindingTypeAndVersioning=[[PropertyBinding.prototype._setValue_direct,PropertyBinding.prototype._setValue_direct_setNeedsUpdate,PropertyBinding.prototype._setValue_direct_setMatrixWorldNeedsUpdate],[PropertyBinding.prototype._setValue_array,PropertyBinding.prototype._setValue_array_setNeedsUpdate,PropertyBinding.prototype._setValue_array_setMatrixWorldNeedsUpdate],[PropertyBinding.prototype._setValue_arrayElement,PropertyBinding.prototype._setValue_arrayElement_setNeedsUpdate,PropertyBinding.prototype._setValue_arrayElement_setMatrixWorldNeedsUpdate],[PropertyBinding.prototype._setValue_fromArray,PropertyBinding.prototype._setValue_fromArray_setNeedsUpdate,PropertyBinding.prototype._setValue_fromArray_setMatrixWorldNeedsUpdate]];class AnimationAction{constructor(t,i,r=null,a=i.blendMode){this._mixer=t,this._clip=i,this._localRoot=r,this.blendMode=a;const o=i.tracks,l=o.length,c=new Array(l),h={endingStart:nt,endingEnd:nt};for(let t=0;t!==l;++t){const i=o[t].createInterpolant(null);c[t]=i,i.settings=h}this._interpolantSettings=h,this._interpolants=c,this._propertyBindings=new Array(l),this._cacheIndex=null,this._byClipCacheIndex=null,this._timeScaleInterpolant=null,this._weightInterpolant=null,this.loop=2201,this._loopCount=-1,this._startTime=null,this.time=0,this.timeScale=1,this._effectiveTimeScale=1,this.weight=1,this._effectiveWeight=1,this.repetitions=1/0,this.paused=!1,this.enabled=!0,this.clampWhenFinished=!1,this.zeroSlopeAtStart=!0,this.zeroSlopeAtEnd=!0}play(){return this._mixer._activateAction(this),this}stop(){return this._mixer._deactivateAction(this),this.reset()}reset(){return this.paused=!1,this.enabled=!0,this.time=0,this._loopCount=-1,this._startTime=null,this.stopFading().stopWarping()}isRunning(){return this.enabled&&!this.paused&&0!==this.timeScale&&null===this._startTime&&this._mixer._isActiveAction(this)}isScheduled(){return this._mixer._isActiveAction(this)}startAt(t){return this._startTime=t,this}setLoop(t,i){return this.loop=t,this.repetitions=i,this}setEffectiveWeight(t){return this.weight=t,this._effectiveWeight=this.enabled?t:0,this.stopFading()}getEffectiveWeight(){return this._effectiveWeight}fadeIn(t){return this._scheduleFading(t,0,1)}fadeOut(t){return this._scheduleFading(t,1,0)}crossFadeFrom(t,i,r){if(t.fadeOut(i),this.fadeIn(i),r){const r=this._clip.duration,a=t._clip.duration,o=a/r,l=r/a;t.warp(1,o,i),this.warp(l,1,i)}return this}crossFadeTo(t,i,r){return t.crossFadeFrom(this,i,r)}stopFading(){const t=this._weightInterpolant;return null!==t&&(this._weightInterpolant=null,this._mixer._takeBackControlInterpolant(t)),this}setEffectiveTimeScale(t){return this.timeScale=t,this._effectiveTimeScale=this.paused?0:t,this.stopWarping()}getEffectiveTimeScale(){return this._effectiveTimeScale}setDuration(t){return this.timeScale=this._clip.duration/t,this.stopWarping()}syncWith(t){return this.time=t.time,this.timeScale=t.timeScale,this.stopWarping()}halt(t){return this.warp(this._effectiveTimeScale,0,t)}warp(t,i,r){const a=this._mixer,o=a.time,l=this.timeScale;let c=this._timeScaleInterpolant;null===c&&(c=a._lendControlInterpolant(),this._timeScaleInterpolant=c);const h=c.parameterPositions,d=c.sampleValues;return h[0]=o,h[1]=o+r,d[0]=t/l,d[1]=i/l,this}stopWarping(){const t=this._timeScaleInterpolant;return null!==t&&(this._timeScaleInterpolant=null,this._mixer._takeBackControlInterpolant(t)),this}getMixer(){return this._mixer}getClip(){return this._clip}getRoot(){return this._localRoot||this._mixer._root}_update(t,i,r,a){if(!this.enabled)return void this._updateWeight(t);const o=this._startTime;if(null!==o){const a=(t-o)*r;a<0||0===r?i=0:(this._startTime=null,i=r*a)}i*=this._updateTimeScale(t);const l=this._updateTime(i),c=this._updateWeight(t);if(c>0){const t=this._interpolants,i=this._propertyBindings;if(2501===this.blendMode)for(let r=0,a=t.length;r!==a;++r)t[r].evaluate(l),i[r].accumulateAdditive(c);else for(let r=0,o=t.length;r!==o;++r)t[r].evaluate(l),i[r].accumulate(a,c)}}_updateWeight(t){let i=0;if(this.enabled){i=this.weight;const r=this._weightInterpolant;if(null!==r){const a=r.evaluate(t)[0];i*=a,t>r.parameterPositions[1]&&(this.stopFading(),0===a&&(this.enabled=!1))}}return this._effectiveWeight=i,i}_updateTimeScale(t){let i=0;if(!this.paused){i=this.timeScale;const r=this._timeScaleInterpolant;if(null!==r){i*=r.evaluate(t)[0],t>r.parameterPositions[1]&&(this.stopWarping(),0===i?this.paused=!0:this.timeScale=i)}}return this._effectiveTimeScale=i,i}_updateTime(t){const i=this._clip.duration,r=this.loop;let a=this.time+t,o=this._loopCount;const l=2202===r;if(0===t)return-1===o||!l||1&~o?a:i-a;if(2200===r){-1===o&&(this._loopCount=0,this._setEndings(!0,!0,!1));e:{if(a>=i)a=i;else{if(!(a<0)){this.time=a;break e}a=0}this.clampWhenFinished?this.paused=!0:this.enabled=!1,this.time=a,this._mixer.dispatchEvent({type:"finished",action:this,direction:t<0?-1:1})}}else{if(-1===o&&(t>=0?(o=0,this._setEndings(!0,0===this.repetitions,l)):this._setEndings(0===this.repetitions,!0,l)),a>=i||a<0){const r=Math.floor(a/i);a-=i*r,o+=Math.abs(r);const c=this.repetitions-o;if(c<=0)this.clampWhenFinished?this.paused=!0:this.enabled=!1,a=t>0?i:0,this.time=a,this._mixer.dispatchEvent({type:"finished",action:this,direction:t>0?1:-1});else{if(1===c){const i=t<0;this._setEndings(i,!i,l)}else this._setEndings(!1,!1,l);this._loopCount=o,this.time=a,this._mixer.dispatchEvent({type:"loop",action:this,loopDelta:r})}}else this.time=a;if(l&&!(1&~o))return i-a}return a}_setEndings(t,i,r){const a=this._interpolantSettings;r?(a.endingStart=rt,a.endingEnd=rt):(a.endingStart=t?this.zeroSlopeAtStart?rt:nt:st,a.endingEnd=i?this.zeroSlopeAtEnd?rt:nt:st)}_scheduleFading(t,i,r){const a=this._mixer,o=a.time;let l=this._weightInterpolant;null===l&&(l=a._lendControlInterpolant(),this._weightInterpolant=l);const c=l.parameterPositions,h=l.sampleValues;return c[0]=o,h[0]=i,c[1]=o+t,h[1]=r,this}}const Xr=new Float32Array(1);class AnimationMixer extends Tt{constructor(t){super(),this._root=t,this._initMemoryManager(),this._accuIndex=0,this.time=0,this.timeScale=1}_bindAction(t,i){const r=t._localRoot||this._root,a=t._clip.tracks,o=a.length,l=t._propertyBindings,c=t._interpolants,h=r.uuid,d=this._bindingsByRootAndName;let u=d[h];void 0===u&&(u={},d[h]=u);for(let t=0;t!==o;++t){const o=a[t],d=o.name;let p=u[d];if(void 0!==p)++p.referenceCount,l[t]=p;else{if(p=l[t],void 0!==p){null===p._cacheIndex&&(++p.referenceCount,this._addInactiveBinding(p,h,d));continue}const a=i&&i._propertyBindings[t].binding.parsedPath;p=new PropertyMixer(PropertyBinding.create(r,d,a),o.ValueTypeName,o.getValueSize()),++p.referenceCount,this._addInactiveBinding(p,h,d),l[t]=p}c[t].resultBuffer=p.buffer}}_activateAction(t){if(!this._isActiveAction(t)){if(null===t._cacheIndex){const i=(t._localRoot||this._root).uuid,r=t._clip.uuid,a=this._actionsByClip[r];this._bindAction(t,a&&a.knownActions[0]),this._addInactiveAction(t,r,i)}const i=t._propertyBindings;for(let t=0,r=i.length;t!==r;++t){const r=i[t];0==r.useCount++&&(this._lendBinding(r),r.saveOriginalState())}this._lendAction(t)}}_deactivateAction(t){if(this._isActiveAction(t)){const i=t._propertyBindings;for(let t=0,r=i.length;t!==r;++t){const r=i[t];0==--r.useCount&&(r.restoreOriginalState(),this._takeBackBinding(r))}this._takeBackAction(t)}}_initMemoryManager(){this._actions=[],this._nActiveActions=0,this._actionsByClip={},this._bindings=[],this._nActiveBindings=0,this._bindingsByRootAndName={},this._controlInterpolants=[],this._nActiveControlInterpolants=0;const t=this;this.stats={actions:{get total(){return t._actions.length},get inUse(){return t._nActiveActions}},bindings:{get total(){return t._bindings.length},get inUse(){return t._nActiveBindings}},controlInterpolants:{get total(){return t._controlInterpolants.length},get inUse(){return t._nActiveControlInterpolants}}}}_isActiveAction(t){const i=t._cacheIndex;return null!==i&&i<this._nActiveActions}_addInactiveAction(t,i,r){const a=this._actions,o=this._actionsByClip;let l=o[i];if(void 0===l)l={knownActions:[t],actionByRoot:{}},t._byClipCacheIndex=0,o[i]=l;else{const i=l.knownActions;t._byClipCacheIndex=i.length,i.push(t)}t._cacheIndex=a.length,a.push(t),l.actionByRoot[r]=t}_removeInactiveAction(t){const i=this._actions,r=i[i.length-1],a=t._cacheIndex;r._cacheIndex=a,i[a]=r,i.pop(),t._cacheIndex=null;const o=t._clip.uuid,l=this._actionsByClip,c=l[o],h=c.knownActions,d=h[h.length-1],u=t._byClipCacheIndex;d._byClipCacheIndex=u,h[u]=d,h.pop(),t._byClipCacheIndex=null;delete c.actionByRoot[(t._localRoot||this._root).uuid],0===h.length&&delete l[o],this._removeInactiveBindingsForAction(t)}_removeInactiveBindingsForAction(t){const i=t._propertyBindings;for(let t=0,r=i.length;t!==r;++t){const r=i[t];0==--r.referenceCount&&this._removeInactiveBinding(r)}}_lendAction(t){const i=this._actions,r=t._cacheIndex,a=this._nActiveActions++,o=i[a];t._cacheIndex=a,i[a]=t,o._cacheIndex=r,i[r]=o}_takeBackAction(t){const i=this._actions,r=t._cacheIndex,a=--this._nActiveActions,o=i[a];t._cacheIndex=a,i[a]=t,o._cacheIndex=r,i[r]=o}_addInactiveBinding(t,i,r){const a=this._bindingsByRootAndName,o=this._bindings;let l=a[i];void 0===l&&(l={},a[i]=l),l[r]=t,t._cacheIndex=o.length,o.push(t)}_removeInactiveBinding(t){const i=this._bindings,r=t.binding,a=r.rootNode.uuid,o=r.path,l=this._bindingsByRootAndName,c=l[a],h=i[i.length-1],d=t._cacheIndex;h._cacheIndex=d,i[d]=h,i.pop(),delete c[o],0===Object.keys(c).length&&delete l[a]}_lendBinding(t){const i=this._bindings,r=t._cacheIndex,a=this._nActiveBindings++,o=i[a];t._cacheIndex=a,i[a]=t,o._cacheIndex=r,i[r]=o}_takeBackBinding(t){const i=this._bindings,r=t._cacheIndex,a=--this._nActiveBindings,o=i[a];t._cacheIndex=a,i[a]=t,o._cacheIndex=r,i[r]=o}_lendControlInterpolant(){const t=this._controlInterpolants,i=this._nActiveControlInterpolants++;let r=t[i];return void 0===r&&(r=new LinearInterpolant(new Float32Array(2),new Float32Array(2),1,Xr),r.__cacheIndex=i,t[i]=r),r}_takeBackControlInterpolant(t){const i=this._controlInterpolants,r=t.__cacheIndex,a=--this._nActiveControlInterpolants,o=i[a];t.__cacheIndex=a,i[a]=t,o.__cacheIndex=r,i[r]=o}clipAction(t,i,r){const a=i||this._root,o=a.uuid;let l="string"==typeof t?AnimationClip.findByName(a,t):t;const c=null!==l?l.uuid:t,h=this._actionsByClip[c];let d=null;if(void 0===r&&(r=null!==l?l.blendMode:at),void 0!==h){const t=h.actionByRoot[o];if(void 0!==t&&t.blendMode===r)return t;d=h.knownActions[0],null===l&&(l=d._clip)}if(null===l)return null;const u=new AnimationAction(this,l,i,r);return this._bindAction(u,d),this._addInactiveAction(u,c,o),u}existingAction(t,i){const r=i||this._root,a=r.uuid,o="string"==typeof t?AnimationClip.findByName(r,t):t,l=o?o.uuid:t,c=this._actionsByClip[l];return void 0!==c&&c.actionByRoot[a]||null}stopAllAction(){const t=this._actions;for(let i=this._nActiveActions-1;i>=0;--i)t[i].stop();return this}update(t){t*=this.timeScale;const i=this._actions,r=this._nActiveActions,a=this.time+=t,o=Math.sign(t),l=this._accuIndex^=1;for(let c=0;c!==r;++c){i[c]._update(a,t,o,l)}const c=this._bindings,h=this._nActiveBindings;for(let t=0;t!==h;++t)c[t].apply(l);return this}setTime(t){this.time=0;for(let t=0;t<this._actions.length;t++)this._actions[t].time=0;return this.update(t)}getRoot(){return this._root}uncacheClip(t){const i=this._actions,r=t.uuid,a=this._actionsByClip,o=a[r];if(void 0!==o){const t=o.knownActions;for(let r=0,a=t.length;r!==a;++r){const a=t[r];this._deactivateAction(a);const o=a._cacheIndex,l=i[i.length-1];a._cacheIndex=null,a._byClipCacheIndex=null,l._cacheIndex=o,i[o]=l,i.pop(),this._removeInactiveBindingsForAction(a)}delete a[r]}}uncacheRoot(t){const i=t.uuid,r=this._actionsByClip;for(const t in r){const a=r[t].actionByRoot[i];void 0!==a&&(this._deactivateAction(a),this._removeInactiveAction(a))}const a=this._bindingsByRootAndName[i];if(void 0!==a)for(const t in a){const i=a[t];i.restoreOriginalState(),this._removeInactiveBinding(i)}}uncacheAction(t,i){const r=this.existingAction(t,i);null!==r&&(this._deactivateAction(r),this._removeInactiveAction(r))}}const qr=new Matrix4;class Raycaster{constructor(t,i,r=0,a=1/0){this.ray=new Ray(t,i),this.near=r,this.far=a,this.camera=null,this.layers=new Layers,this.params={Mesh:{},Line:{threshold:1},LOD:{},Points:{threshold:1},Sprite:{}}}set(t,i){this.ray.set(t,i)}setFromCamera(t,i){i.isPerspectiveCamera?(this.ray.origin.setFromMatrixPosition(i.matrixWorld),this.ray.direction.set(t.x,t.y,.5).unproject(i).sub(this.ray.origin).normalize(),this.camera=i):i.isOrthographicCamera&&(this.ray.origin.set(t.x,t.y,(i.near+i.far)/(i.near-i.far)).unproject(i),this.ray.direction.set(0,0,-1).transformDirection(i.matrixWorld),this.camera=i)}setFromXRController(t){return qr.identity().extractRotation(t.matrixWorld),this.ray.origin.setFromMatrixPosition(t.matrixWorld),this.ray.direction.set(0,0,-1).applyMatrix4(qr),this}intersectObject(t,i=!0,r=[]){return intersect(t,this,r,i),r.sort(ascSort),r}intersectObjects(t,i=!0,r=[]){for(let a=0,o=t.length;a<o;a++)intersect(t[a],this,r,i);return r.sort(ascSort),r}}function ascSort(t,i){return t.distance-i.distance}function intersect(t,i,r,a){let o=!0;if(t.layers.test(i.layers)){!1===t.raycast(i,r)&&(o=!1)}if(!0===o&&!0===a){const a=t.children;for(let t=0,o=a.length;t<o;t++)intersect(a[t],i,r,!0)}}function getByteLength(t,i,r,a){const o=function getTextureTypeByteLength(t){switch(t){case re:case se:return{byteLength:1,components:1};case oe:case ae:case de:return{byteLength:2,components:1};case ue:case pe:return{byteLength:2,components:4};case ce:case le:case he:return{byteLength:4,components:1};case fe:return{byteLength:4,components:3}}throw new Error(`Unknown texture type ${t}.`)}(a);switch(r){case 1021:case 1024:return t*i;case 1025:return t*i*2;case xe:case be:return t*i/o.components*o.byteLength;case 1030:case _e:return t*i*2/o.components*o.byteLength;case 1022:return t*i*3/o.components*o.byteLength;case ge:case Se:return t*i*4/o.components*o.byteLength;case Me:case we:return Math.floor((t+3)/4)*Math.floor((i+3)/4)*8;case Te:case Ee:return Math.floor((t+3)/4)*Math.floor((i+3)/4)*16;case Ce:case Re:return Math.max(t,16)*Math.max(i,8)/4;case Ae:case Pe:return Math.max(t,8)*Math.max(i,8)/2;case Ie:case De:return Math.floor((t+3)/4)*Math.floor((i+3)/4)*8;case Le:case Fe:return Math.floor((t+3)/4)*Math.floor((i+3)/4)*16;case Ne:return Math.floor((t+4)/5)*Math.floor((i+3)/4)*16;case Oe:return Math.floor((t+4)/5)*Math.floor((i+4)/5)*16;case Ue:return Math.floor((t+5)/6)*Math.floor((i+4)/5)*16;case Be:return Math.floor((t+5)/6)*Math.floor((i+5)/6)*16;case ze:return Math.floor((t+7)/8)*Math.floor((i+4)/5)*16;case Ve:return Math.floor((t+7)/8)*Math.floor((i+5)/6)*16;case ke:return Math.floor((t+7)/8)*Math.floor((i+7)/8)*16;case Ge:return Math.floor((t+9)/10)*Math.floor((i+4)/5)*16;case He:return Math.floor((t+9)/10)*Math.floor((i+5)/6)*16;case We:return Math.floor((t+9)/10)*Math.floor((i+7)/8)*16;case je:return Math.floor((t+9)/10)*Math.floor((i+9)/10)*16;case Xe:return Math.floor((t+11)/12)*Math.floor((i+9)/10)*16;case qe:return Math.floor((t+11)/12)*Math.floor((i+11)/12)*16;case Ye:case Ze:case Ke:return Math.ceil(t/4)*Math.ceil(i/4)*16;case 36283:case Qe:return Math.ceil(t/4)*Math.ceil(i/4)*8;case Je:case $e:return Math.ceil(t/4)*Math.ceil(i/4)*16}throw new Error(`Unable to determine texture byte length for ${r} format.`)}
/**
 * @license
 * Copyright 2010-2024 Three.js Authors
 * SPDX-License-Identifier: MIT
 */
function WebGLAnimation(){let t=null,i=!1,r=null,a=null;function onAnimationFrame(i,o){r(i,o),a=t.requestAnimationFrame(onAnimationFrame)}return{start:function(){!0!==i&&null!==r&&(a=t.requestAnimationFrame(onAnimationFrame),i=!0)},stop:function(){t.cancelAnimationFrame(a),i=!1},setAnimationLoop:function(t){r=t},setContext:function(i){t=i}}}function WebGLAttributes(t){const i=new WeakMap;return{get:function get(t){return t.isInterleavedBufferAttribute&&(t=t.data),i.get(t)},remove:function remove(r){r.isInterleavedBufferAttribute&&(r=r.data);const a=i.get(r);a&&(t.deleteBuffer(a.buffer),i.delete(r))},update:function update(r,a){if(r.isInterleavedBufferAttribute&&(r=r.data),r.isGLBufferAttribute){const t=i.get(r);return void((!t||t.version<r.version)&&i.set(r,{buffer:r.buffer,type:r.type,bytesPerElement:r.elementSize,version:r.version}))}const o=i.get(r);if(void 0===o)i.set(r,function createBuffer(i,r){const a=i.array,o=i.usage,l=a.byteLength,c=t.createBuffer();let h;if(t.bindBuffer(r,c),t.bufferData(r,a,o),i.onUploadCallback(),a instanceof Float32Array)h=t.FLOAT;else if(a instanceof Uint16Array)h=i.isFloat16BufferAttribute?t.HALF_FLOAT:t.UNSIGNED_SHORT;else if(a instanceof Int16Array)h=t.SHORT;else if(a instanceof Uint32Array)h=t.UNSIGNED_INT;else if(a instanceof Int32Array)h=t.INT;else if(a instanceof Int8Array)h=t.BYTE;else if(a instanceof Uint8Array)h=t.UNSIGNED_BYTE;else{if(!(a instanceof Uint8ClampedArray))throw new Error("THREE.WebGLAttributes: Unsupported buffer data format: "+a);h=t.UNSIGNED_BYTE}return{buffer:c,type:h,bytesPerElement:a.BYTES_PER_ELEMENT,version:i.version,size:l}}(r,a));else if(o.version<r.version){if(o.size!==r.array.byteLength)throw new Error("THREE.WebGLAttributes: The size of the buffer attribute's array buffer does not match the original size. Resizing buffer attributes is not supported.");!function updateBuffer(i,r,a){const o=r.array,l=r.updateRanges;if(t.bindBuffer(a,i),0===l.length)t.bufferSubData(a,0,o);else{l.sort(((t,i)=>t.start-i.start));let i=0;for(let t=1;t<l.length;t++){const r=l[i],a=l[t];a.start<=r.start+r.count+1?r.count=Math.max(r.count,a.start+a.count-r.start):(++i,l[i]=a)}l.length=i+1;for(let i=0,r=l.length;i<r;i++){const r=l[i];t.bufferSubData(a,r.start*o.BYTES_PER_ELEMENT,o,r.start,r.count)}r.clearUpdateRanges()}r.onUploadCallback()}(o.buffer,r,a),o.version=r.version}}}}"undefined"!=typeof __THREE_DEVTOOLS__&&__THREE_DEVTOOLS__.dispatchEvent(new CustomEvent("register",{detail:{revision:u}})),"undefined"!=typeof window&&(window.__THREE__||(window.__THREE__=u));const Yr={alphahash_fragment:"#ifdef USE_ALPHAHASH\n\tif ( diffuseColor.a < getAlphaHashThreshold( vPosition ) ) discard;\n#endif",alphahash_pars_fragment:"#ifdef USE_ALPHAHASH\n\tconst float ALPHA_HASH_SCALE = 0.05;\n\tfloat hash2D( vec2 value ) {\n\t\treturn fract( 1.0e4 * sin( 17.0 * value.x + 0.1 * value.y ) * ( 0.1 + abs( sin( 13.0 * value.y + value.x ) ) ) );\n\t}\n\tfloat hash3D( vec3 value ) {\n\t\treturn hash2D( vec2( hash2D( value.xy ), value.z ) );\n\t}\n\tfloat getAlphaHashThreshold( vec3 position ) {\n\t\tfloat maxDeriv = max(\n\t\t\tlength( dFdx( position.xyz ) ),\n\t\t\tlength( dFdy( position.xyz ) )\n\t\t);\n\t\tfloat pixScale = 1.0 / ( ALPHA_HASH_SCALE * maxDeriv );\n\t\tvec2 pixScales = vec2(\n\t\t\texp2( floor( log2( pixScale ) ) ),\n\t\t\texp2( ceil( log2( pixScale ) ) )\n\t\t);\n\t\tvec2 alpha = vec2(\n\t\t\thash3D( floor( pixScales.x * position.xyz ) ),\n\t\t\thash3D( floor( pixScales.y * position.xyz ) )\n\t\t);\n\t\tfloat lerpFactor = fract( log2( pixScale ) );\n\t\tfloat x = ( 1.0 - lerpFactor ) * alpha.x + lerpFactor * alpha.y;\n\t\tfloat a = min( lerpFactor, 1.0 - lerpFactor );\n\t\tvec3 cases = vec3(\n\t\t\tx * x / ( 2.0 * a * ( 1.0 - a ) ),\n\t\t\t( x - 0.5 * a ) / ( 1.0 - a ),\n\t\t\t1.0 - ( ( 1.0 - x ) * ( 1.0 - x ) / ( 2.0 * a * ( 1.0 - a ) ) )\n\t\t);\n\t\tfloat threshold = ( x < ( 1.0 - a ) )\n\t\t\t? ( ( x < a ) ? cases.x : cases.y )\n\t\t\t: cases.z;\n\t\treturn clamp( threshold , 1.0e-6, 1.0 );\n\t}\n#endif",alphamap_fragment:"#ifdef USE_ALPHAMAP\n\tdiffuseColor.a *= texture2D( alphaMap, vAlphaMapUv ).g;\n#endif",alphamap_pars_fragment:"#ifdef USE_ALPHAMAP\n\tuniform sampler2D alphaMap;\n#endif",alphatest_fragment:"#ifdef USE_ALPHATEST\n\t#ifdef ALPHA_TO_COVERAGE\n\tdiffuseColor.a = smoothstep( alphaTest, alphaTest + fwidth( diffuseColor.a ), diffuseColor.a );\n\tif ( diffuseColor.a == 0.0 ) discard;\n\t#else\n\tif ( diffuseColor.a < alphaTest ) discard;\n\t#endif\n#endif",alphatest_pars_fragment:"#ifdef USE_ALPHATEST\n\tuniform float alphaTest;\n#endif",aomap_fragment:"#ifdef USE_AOMAP\n\tfloat ambientOcclusion = ( texture2D( aoMap, vAoMapUv ).r - 1.0 ) * aoMapIntensity + 1.0;\n\treflectedLight.indirectDiffuse *= ambientOcclusion;\n\t#if defined( USE_CLEARCOAT ) \n\t\tclearcoatSpecularIndirect *= ambientOcclusion;\n\t#endif\n\t#if defined( USE_SHEEN ) \n\t\tsheenSpecularIndirect *= ambientOcclusion;\n\t#endif\n\t#if defined( USE_ENVMAP ) && defined( STANDARD )\n\t\tfloat dotNV = saturate( dot( geometryNormal, geometryViewDir ) );\n\t\treflectedLight.indirectSpecular *= computeSpecularOcclusion( dotNV, ambientOcclusion, material.roughness );\n\t#endif\n#endif",aomap_pars_fragment:"#ifdef USE_AOMAP\n\tuniform sampler2D aoMap;\n\tuniform float aoMapIntensity;\n#endif",batching_pars_vertex:"#ifdef USE_BATCHING\n\t#if ! defined( GL_ANGLE_multi_draw )\n\t#define gl_DrawID _gl_DrawID\n\tuniform int _gl_DrawID;\n\t#endif\n\tuniform highp sampler2D batchingTexture;\n\tuniform highp usampler2D batchingIdTexture;\n\tmat4 getBatchingMatrix( const in float i ) {\n\t\tint size = textureSize( batchingTexture, 0 ).x;\n\t\tint j = int( i ) * 4;\n\t\tint x = j % size;\n\t\tint y = j / size;\n\t\tvec4 v1 = texelFetch( batchingTexture, ivec2( x, y ), 0 );\n\t\tvec4 v2 = texelFetch( batchingTexture, ivec2( x + 1, y ), 0 );\n\t\tvec4 v3 = texelFetch( batchingTexture, ivec2( x + 2, y ), 0 );\n\t\tvec4 v4 = texelFetch( batchingTexture, ivec2( x + 3, y ), 0 );\n\t\treturn mat4( v1, v2, v3, v4 );\n\t}\n\tfloat getIndirectIndex( const in int i ) {\n\t\tint size = textureSize( batchingIdTexture, 0 ).x;\n\t\tint x = i % size;\n\t\tint y = i / size;\n\t\treturn float( texelFetch( batchingIdTexture, ivec2( x, y ), 0 ).r );\n\t}\n#endif\n#ifdef USE_BATCHING_COLOR\n\tuniform sampler2D batchingColorTexture;\n\tvec3 getBatchingColor( const in float i ) {\n\t\tint size = textureSize( batchingColorTexture, 0 ).x;\n\t\tint j = int( i );\n\t\tint x = j % size;\n\t\tint y = j / size;\n\t\treturn texelFetch( batchingColorTexture, ivec2( x, y ), 0 ).rgb;\n\t}\n#endif",batching_vertex:"#ifdef USE_BATCHING\n\tmat4 batchingMatrix = getBatchingMatrix( getIndirectIndex( gl_DrawID ) );\n#endif",begin_vertex:"vec3 transformed = vec3( position );\n#ifdef USE_ALPHAHASH\n\tvPosition = vec3( position );\n#endif",beginnormal_vertex:"vec3 objectNormal = vec3( normal );\n#ifdef USE_TANGENT\n\tvec3 objectTangent = vec3( tangent.xyz );\n#endif",bsdfs:"float G_BlinnPhong_Implicit( ) {\n\treturn 0.25;\n}\nfloat D_BlinnPhong( const in float shininess, const in float dotNH ) {\n\treturn RECIPROCAL_PI * ( shininess * 0.5 + 1.0 ) * pow( dotNH, shininess );\n}\nvec3 BRDF_BlinnPhong( const in vec3 lightDir, const in vec3 viewDir, const in vec3 normal, const in vec3 specularColor, const in float shininess ) {\n\tvec3 halfDir = normalize( lightDir + viewDir );\n\tfloat dotNH = saturate( dot( normal, halfDir ) );\n\tfloat dotVH = saturate( dot( viewDir, halfDir ) );\n\tvec3 F = F_Schlick( specularColor, 1.0, dotVH );\n\tfloat G = G_BlinnPhong_Implicit( );\n\tfloat D = D_BlinnPhong( shininess, dotNH );\n\treturn F * ( G * D );\n} // validated",iridescence_fragment:"#ifdef USE_IRIDESCENCE\n\tconst mat3 XYZ_TO_REC709 = mat3(\n\t\t 3.2404542, -0.9692660,  0.0556434,\n\t\t-1.5371385,  1.8760108, -0.2040259,\n\t\t-0.4985314,  0.0415560,  1.0572252\n\t);\n\tvec3 Fresnel0ToIor( vec3 fresnel0 ) {\n\t\tvec3 sqrtF0 = sqrt( fresnel0 );\n\t\treturn ( vec3( 1.0 ) + sqrtF0 ) / ( vec3( 1.0 ) - sqrtF0 );\n\t}\n\tvec3 IorToFresnel0( vec3 transmittedIor, float incidentIor ) {\n\t\treturn pow2( ( transmittedIor - vec3( incidentIor ) ) / ( transmittedIor + vec3( incidentIor ) ) );\n\t}\n\tfloat IorToFresnel0( float transmittedIor, float incidentIor ) {\n\t\treturn pow2( ( transmittedIor - incidentIor ) / ( transmittedIor + incidentIor ));\n\t}\n\tvec3 evalSensitivity( float OPD, vec3 shift ) {\n\t\tfloat phase = 2.0 * PI * OPD * 1.0e-9;\n\t\tvec3 val = vec3( 5.4856e-13, 4.4201e-13, 5.2481e-13 );\n\t\tvec3 pos = vec3( 1.6810e+06, 1.7953e+06, 2.2084e+06 );\n\t\tvec3 var = vec3( 4.3278e+09, 9.3046e+09, 6.6121e+09 );\n\t\tvec3 xyz = val * sqrt( 2.0 * PI * var ) * cos( pos * phase + shift ) * exp( - pow2( phase ) * var );\n\t\txyz.x += 9.7470e-14 * sqrt( 2.0 * PI * 4.5282e+09 ) * cos( 2.2399e+06 * phase + shift[ 0 ] ) * exp( - 4.5282e+09 * pow2( phase ) );\n\t\txyz /= 1.0685e-7;\n\t\tvec3 rgb = XYZ_TO_REC709 * xyz;\n\t\treturn rgb;\n\t}\n\tvec3 evalIridescence( float outsideIOR, float eta2, float cosTheta1, float thinFilmThickness, vec3 baseF0 ) {\n\t\tvec3 I;\n\t\tfloat iridescenceIOR = mix( outsideIOR, eta2, smoothstep( 0.0, 0.03, thinFilmThickness ) );\n\t\tfloat sinTheta2Sq = pow2( outsideIOR / iridescenceIOR ) * ( 1.0 - pow2( cosTheta1 ) );\n\t\tfloat cosTheta2Sq = 1.0 - sinTheta2Sq;\n\t\tif ( cosTheta2Sq < 0.0 ) {\n\t\t\treturn vec3( 1.0 );\n\t\t}\n\t\tfloat cosTheta2 = sqrt( cosTheta2Sq );\n\t\tfloat R0 = IorToFresnel0( iridescenceIOR, outsideIOR );\n\t\tfloat R12 = F_Schlick( R0, 1.0, cosTheta1 );\n\t\tfloat T121 = 1.0 - R12;\n\t\tfloat phi12 = 0.0;\n\t\tif ( iridescenceIOR < outsideIOR ) phi12 = PI;\n\t\tfloat phi21 = PI - phi12;\n\t\tvec3 baseIOR = Fresnel0ToIor( clamp( baseF0, 0.0, 0.9999 ) );\t\tvec3 R1 = IorToFresnel0( baseIOR, iridescenceIOR );\n\t\tvec3 R23 = F_Schlick( R1, 1.0, cosTheta2 );\n\t\tvec3 phi23 = vec3( 0.0 );\n\t\tif ( baseIOR[ 0 ] < iridescenceIOR ) phi23[ 0 ] = PI;\n\t\tif ( baseIOR[ 1 ] < iridescenceIOR ) phi23[ 1 ] = PI;\n\t\tif ( baseIOR[ 2 ] < iridescenceIOR ) phi23[ 2 ] = PI;\n\t\tfloat OPD = 2.0 * iridescenceIOR * thinFilmThickness * cosTheta2;\n\t\tvec3 phi = vec3( phi21 ) + phi23;\n\t\tvec3 R123 = clamp( R12 * R23, 1e-5, 0.9999 );\n\t\tvec3 r123 = sqrt( R123 );\n\t\tvec3 Rs = pow2( T121 ) * R23 / ( vec3( 1.0 ) - R123 );\n\t\tvec3 C0 = R12 + Rs;\n\t\tI = C0;\n\t\tvec3 Cm = Rs - T121;\n\t\tfor ( int m = 1; m <= 2; ++ m ) {\n\t\t\tCm *= r123;\n\t\t\tvec3 Sm = 2.0 * evalSensitivity( float( m ) * OPD, float( m ) * phi );\n\t\t\tI += Cm * Sm;\n\t\t}\n\t\treturn max( I, vec3( 0.0 ) );\n\t}\n#endif",bumpmap_pars_fragment:"#ifdef USE_BUMPMAP\n\tuniform sampler2D bumpMap;\n\tuniform float bumpScale;\n\tvec2 dHdxy_fwd() {\n\t\tvec2 dSTdx = dFdx( vBumpMapUv );\n\t\tvec2 dSTdy = dFdy( vBumpMapUv );\n\t\tfloat Hll = bumpScale * texture2D( bumpMap, vBumpMapUv ).x;\n\t\tfloat dBx = bumpScale * texture2D( bumpMap, vBumpMapUv + dSTdx ).x - Hll;\n\t\tfloat dBy = bumpScale * texture2D( bumpMap, vBumpMapUv + dSTdy ).x - Hll;\n\t\treturn vec2( dBx, dBy );\n\t}\n\tvec3 perturbNormalArb( vec3 surf_pos, vec3 surf_norm, vec2 dHdxy, float faceDirection ) {\n\t\tvec3 vSigmaX = normalize( dFdx( surf_pos.xyz ) );\n\t\tvec3 vSigmaY = normalize( dFdy( surf_pos.xyz ) );\n\t\tvec3 vN = surf_norm;\n\t\tvec3 R1 = cross( vSigmaY, vN );\n\t\tvec3 R2 = cross( vN, vSigmaX );\n\t\tfloat fDet = dot( vSigmaX, R1 ) * faceDirection;\n\t\tvec3 vGrad = sign( fDet ) * ( dHdxy.x * R1 + dHdxy.y * R2 );\n\t\treturn normalize( abs( fDet ) * surf_norm - vGrad );\n\t}\n#endif",clipping_planes_fragment:"#if NUM_CLIPPING_PLANES > 0\n\tvec4 plane;\n\t#ifdef ALPHA_TO_COVERAGE\n\t\tfloat distanceToPlane, distanceGradient;\n\t\tfloat clipOpacity = 1.0;\n\t\t#pragma unroll_loop_start\n\t\tfor ( int i = 0; i < UNION_CLIPPING_PLANES; i ++ ) {\n\t\t\tplane = clippingPlanes[ i ];\n\t\t\tdistanceToPlane = - dot( vClipPosition, plane.xyz ) + plane.w;\n\t\t\tdistanceGradient = fwidth( distanceToPlane ) / 2.0;\n\t\t\tclipOpacity *= smoothstep( - distanceGradient, distanceGradient, distanceToPlane );\n\t\t\tif ( clipOpacity == 0.0 ) discard;\n\t\t}\n\t\t#pragma unroll_loop_end\n\t\t#if UNION_CLIPPING_PLANES < NUM_CLIPPING_PLANES\n\t\t\tfloat unionClipOpacity = 1.0;\n\t\t\t#pragma unroll_loop_start\n\t\t\tfor ( int i = UNION_CLIPPING_PLANES; i < NUM_CLIPPING_PLANES; i ++ ) {\n\t\t\t\tplane = clippingPlanes[ i ];\n\t\t\t\tdistanceToPlane = - dot( vClipPosition, plane.xyz ) + plane.w;\n\t\t\t\tdistanceGradient = fwidth( distanceToPlane ) / 2.0;\n\t\t\t\tunionClipOpacity *= 1.0 - smoothstep( - distanceGradient, distanceGradient, distanceToPlane );\n\t\t\t}\n\t\t\t#pragma unroll_loop_end\n\t\t\tclipOpacity *= 1.0 - unionClipOpacity;\n\t\t#endif\n\t\tdiffuseColor.a *= clipOpacity;\n\t\tif ( diffuseColor.a == 0.0 ) discard;\n\t#else\n\t\t#pragma unroll_loop_start\n\t\tfor ( int i = 0; i < UNION_CLIPPING_PLANES; i ++ ) {\n\t\t\tplane = clippingPlanes[ i ];\n\t\t\tif ( dot( vClipPosition, plane.xyz ) > plane.w ) discard;\n\t\t}\n\t\t#pragma unroll_loop_end\n\t\t#if UNION_CLIPPING_PLANES < NUM_CLIPPING_PLANES\n\t\t\tbool clipped = true;\n\t\t\t#pragma unroll_loop_start\n\t\t\tfor ( int i = UNION_CLIPPING_PLANES; i < NUM_CLIPPING_PLANES; i ++ ) {\n\t\t\t\tplane = clippingPlanes[ i ];\n\t\t\t\tclipped = ( dot( vClipPosition, plane.xyz ) > plane.w ) && clipped;\n\t\t\t}\n\t\t\t#pragma unroll_loop_end\n\t\t\tif ( clipped ) discard;\n\t\t#endif\n\t#endif\n#endif",clipping_planes_pars_fragment:"#if NUM_CLIPPING_PLANES > 0\n\tvarying vec3 vClipPosition;\n\tuniform vec4 clippingPlanes[ NUM_CLIPPING_PLANES ];\n#endif",clipping_planes_pars_vertex:"#if NUM_CLIPPING_PLANES > 0\n\tvarying vec3 vClipPosition;\n#endif",clipping_planes_vertex:"#if NUM_CLIPPING_PLANES > 0\n\tvClipPosition = - mvPosition.xyz;\n#endif",color_fragment:"#if defined( USE_COLOR_ALPHA )\n\tdiffuseColor *= vColor;\n#elif defined( USE_COLOR )\n\tdiffuseColor.rgb *= vColor;\n#endif",color_pars_fragment:"#if defined( USE_COLOR_ALPHA )\n\tvarying vec4 vColor;\n#elif defined( USE_COLOR )\n\tvarying vec3 vColor;\n#endif",color_pars_vertex:"#if defined( USE_COLOR_ALPHA )\n\tvarying vec4 vColor;\n#elif defined( USE_COLOR ) || defined( USE_INSTANCING_COLOR ) || defined( USE_BATCHING_COLOR )\n\tvarying vec3 vColor;\n#endif",color_vertex:"#if defined( USE_COLOR_ALPHA )\n\tvColor = vec4( 1.0 );\n#elif defined( USE_COLOR ) || defined( USE_INSTANCING_COLOR ) || defined( USE_BATCHING_COLOR )\n\tvColor = vec3( 1.0 );\n#endif\n#ifdef USE_COLOR\n\tvColor *= color;\n#endif\n#ifdef USE_INSTANCING_COLOR\n\tvColor.xyz *= instanceColor.xyz;\n#endif\n#ifdef USE_BATCHING_COLOR\n\tvec3 batchingColor = getBatchingColor( getIndirectIndex( gl_DrawID ) );\n\tvColor.xyz *= batchingColor.xyz;\n#endif",common:"#define PI 3.141592653589793\n#define PI2 6.283185307179586\n#define PI_HALF 1.5707963267948966\n#define RECIPROCAL_PI 0.3183098861837907\n#define RECIPROCAL_PI2 0.15915494309189535\n#define EPSILON 1e-6\n#ifndef saturate\n#define saturate( a ) clamp( a, 0.0, 1.0 )\n#endif\n#define whiteComplement( a ) ( 1.0 - saturate( a ) )\nfloat pow2( const in float x ) { return x*x; }\nvec3 pow2( const in vec3 x ) { return x*x; }\nfloat pow3( const in float x ) { return x*x*x; }\nfloat pow4( const in float x ) { float x2 = x*x; return x2*x2; }\nfloat max3( const in vec3 v ) { return max( max( v.x, v.y ), v.z ); }\nfloat average( const in vec3 v ) { return dot( v, vec3( 0.3333333 ) ); }\nhighp float rand( const in vec2 uv ) {\n\tconst highp float a = 12.9898, b = 78.233, c = 43758.5453;\n\thighp float dt = dot( uv.xy, vec2( a,b ) ), sn = mod( dt, PI );\n\treturn fract( sin( sn ) * c );\n}\n#ifdef HIGH_PRECISION\n\tfloat precisionSafeLength( vec3 v ) { return length( v ); }\n#else\n\tfloat precisionSafeLength( vec3 v ) {\n\t\tfloat maxComponent = max3( abs( v ) );\n\t\treturn length( v / maxComponent ) * maxComponent;\n\t}\n#endif\nstruct IncidentLight {\n\tvec3 color;\n\tvec3 direction;\n\tbool visible;\n};\nstruct ReflectedLight {\n\tvec3 directDiffuse;\n\tvec3 directSpecular;\n\tvec3 indirectDiffuse;\n\tvec3 indirectSpecular;\n};\n#ifdef USE_ALPHAHASH\n\tvarying vec3 vPosition;\n#endif\nvec3 transformDirection( in vec3 dir, in mat4 matrix ) {\n\treturn normalize( ( matrix * vec4( dir, 0.0 ) ).xyz );\n}\nvec3 inverseTransformDirection( in vec3 dir, in mat4 matrix ) {\n\treturn normalize( ( vec4( dir, 0.0 ) * matrix ).xyz );\n}\nmat3 transposeMat3( const in mat3 m ) {\n\tmat3 tmp;\n\ttmp[ 0 ] = vec3( m[ 0 ].x, m[ 1 ].x, m[ 2 ].x );\n\ttmp[ 1 ] = vec3( m[ 0 ].y, m[ 1 ].y, m[ 2 ].y );\n\ttmp[ 2 ] = vec3( m[ 0 ].z, m[ 1 ].z, m[ 2 ].z );\n\treturn tmp;\n}\nbool isPerspectiveMatrix( mat4 m ) {\n\treturn m[ 2 ][ 3 ] == - 1.0;\n}\nvec2 equirectUv( in vec3 dir ) {\n\tfloat u = atan( dir.z, dir.x ) * RECIPROCAL_PI2 + 0.5;\n\tfloat v = asin( clamp( dir.y, - 1.0, 1.0 ) ) * RECIPROCAL_PI + 0.5;\n\treturn vec2( u, v );\n}\nvec3 BRDF_Lambert( const in vec3 diffuseColor ) {\n\treturn RECIPROCAL_PI * diffuseColor;\n}\nvec3 F_Schlick( const in vec3 f0, const in float f90, const in float dotVH ) {\n\tfloat fresnel = exp2( ( - 5.55473 * dotVH - 6.98316 ) * dotVH );\n\treturn f0 * ( 1.0 - fresnel ) + ( f90 * fresnel );\n}\nfloat F_Schlick( const in float f0, const in float f90, const in float dotVH ) {\n\tfloat fresnel = exp2( ( - 5.55473 * dotVH - 6.98316 ) * dotVH );\n\treturn f0 * ( 1.0 - fresnel ) + ( f90 * fresnel );\n} // validated",cube_uv_reflection_fragment:"#ifdef ENVMAP_TYPE_CUBE_UV\n\t#define cubeUV_minMipLevel 4.0\n\t#define cubeUV_minTileSize 16.0\n\tfloat getFace( vec3 direction ) {\n\t\tvec3 absDirection = abs( direction );\n\t\tfloat face = - 1.0;\n\t\tif ( absDirection.x > absDirection.z ) {\n\t\t\tif ( absDirection.x > absDirection.y )\n\t\t\t\tface = direction.x > 0.0 ? 0.0 : 3.0;\n\t\t\telse\n\t\t\t\tface = direction.y > 0.0 ? 1.0 : 4.0;\n\t\t} else {\n\t\t\tif ( absDirection.z > absDirection.y )\n\t\t\t\tface = direction.z > 0.0 ? 2.0 : 5.0;\n\t\t\telse\n\t\t\t\tface = direction.y > 0.0 ? 1.0 : 4.0;\n\t\t}\n\t\treturn face;\n\t}\n\tvec2 getUV( vec3 direction, float face ) {\n\t\tvec2 uv;\n\t\tif ( face == 0.0 ) {\n\t\t\tuv = vec2( direction.z, direction.y ) / abs( direction.x );\n\t\t} else if ( face == 1.0 ) {\n\t\t\tuv = vec2( - direction.x, - direction.z ) / abs( direction.y );\n\t\t} else if ( face == 2.0 ) {\n\t\t\tuv = vec2( - direction.x, direction.y ) / abs( direction.z );\n\t\t} else if ( face == 3.0 ) {\n\t\t\tuv = vec2( - direction.z, direction.y ) / abs( direction.x );\n\t\t} else if ( face == 4.0 ) {\n\t\t\tuv = vec2( - direction.x, direction.z ) / abs( direction.y );\n\t\t} else {\n\t\t\tuv = vec2( direction.x, direction.y ) / abs( direction.z );\n\t\t}\n\t\treturn 0.5 * ( uv + 1.0 );\n\t}\n\tvec3 bilinearCubeUV( sampler2D envMap, vec3 direction, float mipInt ) {\n\t\tfloat face = getFace( direction );\n\t\tfloat filterInt = max( cubeUV_minMipLevel - mipInt, 0.0 );\n\t\tmipInt = max( mipInt, cubeUV_minMipLevel );\n\t\tfloat faceSize = exp2( mipInt );\n\t\thighp vec2 uv = getUV( direction, face ) * ( faceSize - 2.0 ) + 1.0;\n\t\tif ( face > 2.0 ) {\n\t\t\tuv.y += faceSize;\n\t\t\tface -= 3.0;\n\t\t}\n\t\tuv.x += face * faceSize;\n\t\tuv.x += filterInt * 3.0 * cubeUV_minTileSize;\n\t\tuv.y += 4.0 * ( exp2( CUBEUV_MAX_MIP ) - faceSize );\n\t\tuv.x *= CUBEUV_TEXEL_WIDTH;\n\t\tuv.y *= CUBEUV_TEXEL_HEIGHT;\n\t\t#ifdef texture2DGradEXT\n\t\t\treturn texture2DGradEXT( envMap, uv, vec2( 0.0 ), vec2( 0.0 ) ).rgb;\n\t\t#else\n\t\t\treturn texture2D( envMap, uv ).rgb;\n\t\t#endif\n\t}\n\t#define cubeUV_r0 1.0\n\t#define cubeUV_m0 - 2.0\n\t#define cubeUV_r1 0.8\n\t#define cubeUV_m1 - 1.0\n\t#define cubeUV_r4 0.4\n\t#define cubeUV_m4 2.0\n\t#define cubeUV_r5 0.305\n\t#define cubeUV_m5 3.0\n\t#define cubeUV_r6 0.21\n\t#define cubeUV_m6 4.0\n\tfloat roughnessToMip( float roughness ) {\n\t\tfloat mip = 0.0;\n\t\tif ( roughness >= cubeUV_r1 ) {\n\t\t\tmip = ( cubeUV_r0 - roughness ) * ( cubeUV_m1 - cubeUV_m0 ) / ( cubeUV_r0 - cubeUV_r1 ) + cubeUV_m0;\n\t\t} else if ( roughness >= cubeUV_r4 ) {\n\t\t\tmip = ( cubeUV_r1 - roughness ) * ( cubeUV_m4 - cubeUV_m1 ) / ( cubeUV_r1 - cubeUV_r4 ) + cubeUV_m1;\n\t\t} else if ( roughness >= cubeUV_r5 ) {\n\t\t\tmip = ( cubeUV_r4 - roughness ) * ( cubeUV_m5 - cubeUV_m4 ) / ( cubeUV_r4 - cubeUV_r5 ) + cubeUV_m4;\n\t\t} else if ( roughness >= cubeUV_r6 ) {\n\t\t\tmip = ( cubeUV_r5 - roughness ) * ( cubeUV_m6 - cubeUV_m5 ) / ( cubeUV_r5 - cubeUV_r6 ) + cubeUV_m5;\n\t\t} else {\n\t\t\tmip = - 2.0 * log2( 1.16 * roughness );\t\t}\n\t\treturn mip;\n\t}\n\tvec4 textureCubeUV( sampler2D envMap, vec3 sampleDir, float roughness ) {\n\t\tfloat mip = clamp( roughnessToMip( roughness ), cubeUV_m0, CUBEUV_MAX_MIP );\n\t\tfloat mipF = fract( mip );\n\t\tfloat mipInt = floor( mip );\n\t\tvec3 color0 = bilinearCubeUV( envMap, sampleDir, mipInt );\n\t\tif ( mipF == 0.0 ) {\n\t\t\treturn vec4( color0, 1.0 );\n\t\t} else {\n\t\t\tvec3 color1 = bilinearCubeUV( envMap, sampleDir, mipInt + 1.0 );\n\t\t\treturn vec4( mix( color0, color1, mipF ), 1.0 );\n\t\t}\n\t}\n#endif",defaultnormal_vertex:"vec3 transformedNormal = objectNormal;\n#ifdef USE_TANGENT\n\tvec3 transformedTangent = objectTangent;\n#endif\n#ifdef USE_BATCHING\n\tmat3 bm = mat3( batchingMatrix );\n\ttransformedNormal /= vec3( dot( bm[ 0 ], bm[ 0 ] ), dot( bm[ 1 ], bm[ 1 ] ), dot( bm[ 2 ], bm[ 2 ] ) );\n\ttransformedNormal = bm * transformedNormal;\n\t#ifdef USE_TANGENT\n\t\ttransformedTangent = bm * transformedTangent;\n\t#endif\n#endif\n#ifdef USE_INSTANCING\n\tmat3 im = mat3( instanceMatrix );\n\ttransformedNormal /= vec3( dot( im[ 0 ], im[ 0 ] ), dot( im[ 1 ], im[ 1 ] ), dot( im[ 2 ], im[ 2 ] ) );\n\ttransformedNormal = im * transformedNormal;\n\t#ifdef USE_TANGENT\n\t\ttransformedTangent = im * transformedTangent;\n\t#endif\n#endif\ntransformedNormal = normalMatrix * transformedNormal;\n#ifdef FLIP_SIDED\n\ttransformedNormal = - transformedNormal;\n#endif\n#ifdef USE_TANGENT\n\ttransformedTangent = ( modelViewMatrix * vec4( transformedTangent, 0.0 ) ).xyz;\n\t#ifdef FLIP_SIDED\n\t\ttransformedTangent = - transformedTangent;\n\t#endif\n#endif",displacementmap_pars_vertex:"#ifdef USE_DISPLACEMENTMAP\n\tuniform sampler2D displacementMap;\n\tuniform float displacementScale;\n\tuniform float displacementBias;\n#endif",displacementmap_vertex:"#ifdef USE_DISPLACEMENTMAP\n\ttransformed += normalize( objectNormal ) * ( texture2D( displacementMap, vDisplacementMapUv ).x * displacementScale + displacementBias );\n#endif",emissivemap_fragment:"#ifdef USE_EMISSIVEMAP\n\tvec4 emissiveColor = texture2D( emissiveMap, vEmissiveMapUv );\n\t#ifdef DECODE_VIDEO_TEXTURE_EMISSIVE\n\t\temissiveColor = sRGBTransferEOTF( emissiveColor );\n\t#endif\n\ttotalEmissiveRadiance *= emissiveColor.rgb;\n#endif",emissivemap_pars_fragment:"#ifdef USE_EMISSIVEMAP\n\tuniform sampler2D emissiveMap;\n#endif",colorspace_fragment:"gl_FragColor = linearToOutputTexel( gl_FragColor );",colorspace_pars_fragment:"vec4 LinearTransferOETF( in vec4 value ) {\n\treturn value;\n}\nvec4 sRGBTransferEOTF( in vec4 value ) {\n\treturn vec4( mix( pow( value.rgb * 0.9478672986 + vec3( 0.0521327014 ), vec3( 2.4 ) ), value.rgb * 0.0773993808, vec3( lessThanEqual( value.rgb, vec3( 0.04045 ) ) ) ), value.a );\n}\nvec4 sRGBTransferOETF( in vec4 value ) {\n\treturn vec4( mix( pow( value.rgb, vec3( 0.41666 ) ) * 1.055 - vec3( 0.055 ), value.rgb * 12.92, vec3( lessThanEqual( value.rgb, vec3( 0.0031308 ) ) ) ), value.a );\n}",envmap_fragment:"#ifdef USE_ENVMAP\n\t#ifdef ENV_WORLDPOS\n\t\tvec3 cameraToFrag;\n\t\tif ( isOrthographic ) {\n\t\t\tcameraToFrag = normalize( vec3( - viewMatrix[ 0 ][ 2 ], - viewMatrix[ 1 ][ 2 ], - viewMatrix[ 2 ][ 2 ] ) );\n\t\t} else {\n\t\t\tcameraToFrag = normalize( vWorldPosition - cameraPosition );\n\t\t}\n\t\tvec3 worldNormal = inverseTransformDirection( normal, viewMatrix );\n\t\t#ifdef ENVMAP_MODE_REFLECTION\n\t\t\tvec3 reflectVec = reflect( cameraToFrag, worldNormal );\n\t\t#else\n\t\t\tvec3 reflectVec = refract( cameraToFrag, worldNormal, refractionRatio );\n\t\t#endif\n\t#else\n\t\tvec3 reflectVec = vReflect;\n\t#endif\n\t#ifdef ENVMAP_TYPE_CUBE\n\t\tvec4 envColor = textureCube( envMap, envMapRotation * vec3( flipEnvMap * reflectVec.x, reflectVec.yz ) );\n\t#else\n\t\tvec4 envColor = vec4( 0.0 );\n\t#endif\n\t#ifdef ENVMAP_BLENDING_MULTIPLY\n\t\toutgoingLight = mix( outgoingLight, outgoingLight * envColor.xyz, specularStrength * reflectivity );\n\t#elif defined( ENVMAP_BLENDING_MIX )\n\t\toutgoingLight = mix( outgoingLight, envColor.xyz, specularStrength * reflectivity );\n\t#elif defined( ENVMAP_BLENDING_ADD )\n\t\toutgoingLight += envColor.xyz * specularStrength * reflectivity;\n\t#endif\n#endif",envmap_common_pars_fragment:"#ifdef USE_ENVMAP\n\tuniform float envMapIntensity;\n\tuniform float flipEnvMap;\n\tuniform mat3 envMapRotation;\n\t#ifdef ENVMAP_TYPE_CUBE\n\t\tuniform samplerCube envMap;\n\t#else\n\t\tuniform sampler2D envMap;\n\t#endif\n\t\n#endif",envmap_pars_fragment:"#ifdef USE_ENVMAP\n\tuniform float reflectivity;\n\t#if defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG ) || defined( LAMBERT )\n\t\t#define ENV_WORLDPOS\n\t#endif\n\t#ifdef ENV_WORLDPOS\n\t\tvarying vec3 vWorldPosition;\n\t\tuniform float refractionRatio;\n\t#else\n\t\tvarying vec3 vReflect;\n\t#endif\n#endif",envmap_pars_vertex:"#ifdef USE_ENVMAP\n\t#if defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG ) || defined( LAMBERT )\n\t\t#define ENV_WORLDPOS\n\t#endif\n\t#ifdef ENV_WORLDPOS\n\t\t\n\t\tvarying vec3 vWorldPosition;\n\t#else\n\t\tvarying vec3 vReflect;\n\t\tuniform float refractionRatio;\n\t#endif\n#endif",envmap_physical_pars_fragment:"#ifdef USE_ENVMAP\n\tvec3 getIBLIrradiance( const in vec3 normal ) {\n\t\t#ifdef ENVMAP_TYPE_CUBE_UV\n\t\t\tvec3 worldNormal = inverseTransformDirection( normal, viewMatrix );\n\t\t\tvec4 envMapColor = textureCubeUV( envMap, envMapRotation * worldNormal, 1.0 );\n\t\t\treturn PI * envMapColor.rgb * envMapIntensity;\n\t\t#else\n\t\t\treturn vec3( 0.0 );\n\t\t#endif\n\t}\n\tvec3 getIBLRadiance( const in vec3 viewDir, const in vec3 normal, const in float roughness ) {\n\t\t#ifdef ENVMAP_TYPE_CUBE_UV\n\t\t\tvec3 reflectVec = reflect( - viewDir, normal );\n\t\t\treflectVec = normalize( mix( reflectVec, normal, roughness * roughness) );\n\t\t\treflectVec = inverseTransformDirection( reflectVec, viewMatrix );\n\t\t\tvec4 envMapColor = textureCubeUV( envMap, envMapRotation * reflectVec, roughness );\n\t\t\treturn envMapColor.rgb * envMapIntensity;\n\t\t#else\n\t\t\treturn vec3( 0.0 );\n\t\t#endif\n\t}\n\t#ifdef USE_ANISOTROPY\n\t\tvec3 getIBLAnisotropyRadiance( const in vec3 viewDir, const in vec3 normal, const in float roughness, const in vec3 bitangent, const in float anisotropy ) {\n\t\t\t#ifdef ENVMAP_TYPE_CUBE_UV\n\t\t\t\tvec3 bentNormal = cross( bitangent, viewDir );\n\t\t\t\tbentNormal = normalize( cross( bentNormal, bitangent ) );\n\t\t\t\tbentNormal = normalize( mix( bentNormal, normal, pow2( pow2( 1.0 - anisotropy * ( 1.0 - roughness ) ) ) ) );\n\t\t\t\treturn getIBLRadiance( viewDir, bentNormal, roughness );\n\t\t\t#else\n\t\t\t\treturn vec3( 0.0 );\n\t\t\t#endif\n\t\t}\n\t#endif\n#endif",envmap_vertex:"#ifdef USE_ENVMAP\n\t#ifdef ENV_WORLDPOS\n\t\tvWorldPosition = worldPosition.xyz;\n\t#else\n\t\tvec3 cameraToVertex;\n\t\tif ( isOrthographic ) {\n\t\t\tcameraToVertex = normalize( vec3( - viewMatrix[ 0 ][ 2 ], - viewMatrix[ 1 ][ 2 ], - viewMatrix[ 2 ][ 2 ] ) );\n\t\t} else {\n\t\t\tcameraToVertex = normalize( worldPosition.xyz - cameraPosition );\n\t\t}\n\t\tvec3 worldNormal = inverseTransformDirection( transformedNormal, viewMatrix );\n\t\t#ifdef ENVMAP_MODE_REFLECTION\n\t\t\tvReflect = reflect( cameraToVertex, worldNormal );\n\t\t#else\n\t\t\tvReflect = refract( cameraToVertex, worldNormal, refractionRatio );\n\t\t#endif\n\t#endif\n#endif",fog_vertex:"#ifdef USE_FOG\n\tvFogDepth = - mvPosition.z;\n#endif",fog_pars_vertex:"#ifdef USE_FOG\n\tvarying float vFogDepth;\n#endif",fog_fragment:"#ifdef USE_FOG\n\t#ifdef FOG_EXP2\n\t\tfloat fogFactor = 1.0 - exp( - fogDensity * fogDensity * vFogDepth * vFogDepth );\n\t#else\n\t\tfloat fogFactor = smoothstep( fogNear, fogFar, vFogDepth );\n\t#endif\n\tgl_FragColor.rgb = mix( gl_FragColor.rgb, fogColor, fogFactor );\n#endif",fog_pars_fragment:"#ifdef USE_FOG\n\tuniform vec3 fogColor;\n\tvarying float vFogDepth;\n\t#ifdef FOG_EXP2\n\t\tuniform float fogDensity;\n\t#else\n\t\tuniform float fogNear;\n\t\tuniform float fogFar;\n\t#endif\n#endif",gradientmap_pars_fragment:"#ifdef USE_GRADIENTMAP\n\tuniform sampler2D gradientMap;\n#endif\nvec3 getGradientIrradiance( vec3 normal, vec3 lightDirection ) {\n\tfloat dotNL = dot( normal, lightDirection );\n\tvec2 coord = vec2( dotNL * 0.5 + 0.5, 0.0 );\n\t#ifdef USE_GRADIENTMAP\n\t\treturn vec3( texture2D( gradientMap, coord ).r );\n\t#else\n\t\tvec2 fw = fwidth( coord ) * 0.5;\n\t\treturn mix( vec3( 0.7 ), vec3( 1.0 ), smoothstep( 0.7 - fw.x, 0.7 + fw.x, coord.x ) );\n\t#endif\n}",lightmap_pars_fragment:"#ifdef USE_LIGHTMAP\n\tuniform sampler2D lightMap;\n\tuniform float lightMapIntensity;\n#endif",lights_lambert_fragment:"LambertMaterial material;\nmaterial.diffuseColor = diffuseColor.rgb;\nmaterial.specularStrength = specularStrength;",lights_lambert_pars_fragment:"varying vec3 vViewPosition;\nstruct LambertMaterial {\n\tvec3 diffuseColor;\n\tfloat specularStrength;\n};\nvoid RE_Direct_Lambert( const in IncidentLight directLight, const in vec3 geometryPosition, const in vec3 geometryNormal, const in vec3 geometryViewDir, const in vec3 geometryClearcoatNormal, const in LambertMaterial material, inout ReflectedLight reflectedLight ) {\n\tfloat dotNL = saturate( dot( geometryNormal, directLight.direction ) );\n\tvec3 irradiance = dotNL * directLight.color;\n\treflectedLight.directDiffuse += irradiance * BRDF_Lambert( material.diffuseColor );\n}\nvoid RE_IndirectDiffuse_Lambert( const in vec3 irradiance, const in vec3 geometryPosition, const in vec3 geometryNormal, const in vec3 geometryViewDir, const in vec3 geometryClearcoatNormal, const in LambertMaterial material, inout ReflectedLight reflectedLight ) {\n\treflectedLight.indirectDiffuse += irradiance * BRDF_Lambert( material.diffuseColor );\n}\n#define RE_Direct\t\t\t\tRE_Direct_Lambert\n#define RE_IndirectDiffuse\t\tRE_IndirectDiffuse_Lambert",lights_pars_begin:"uniform bool receiveShadow;\nuniform vec3 ambientLightColor;\n#if defined( USE_LIGHT_PROBES )\n\tuniform vec3 lightProbe[ 9 ];\n#endif\nvec3 shGetIrradianceAt( in vec3 normal, in vec3 shCoefficients[ 9 ] ) {\n\tfloat x = normal.x, y = normal.y, z = normal.z;\n\tvec3 result = shCoefficients[ 0 ] * 0.886227;\n\tresult += shCoefficients[ 1 ] * 2.0 * 0.511664 * y;\n\tresult += shCoefficients[ 2 ] * 2.0 * 0.511664 * z;\n\tresult += shCoefficients[ 3 ] * 2.0 * 0.511664 * x;\n\tresult += shCoefficients[ 4 ] * 2.0 * 0.429043 * x * y;\n\tresult += shCoefficients[ 5 ] * 2.0 * 0.429043 * y * z;\n\tresult += shCoefficients[ 6 ] * ( 0.743125 * z * z - 0.247708 );\n\tresult += shCoefficients[ 7 ] * 2.0 * 0.429043 * x * z;\n\tresult += shCoefficients[ 8 ] * 0.429043 * ( x * x - y * y );\n\treturn result;\n}\nvec3 getLightProbeIrradiance( const in vec3 lightProbe[ 9 ], const in vec3 normal ) {\n\tvec3 worldNormal = inverseTransformDirection( normal, viewMatrix );\n\tvec3 irradiance = shGetIrradianceAt( worldNormal, lightProbe );\n\treturn irradiance;\n}\nvec3 getAmbientLightIrradiance( const in vec3 ambientLightColor ) {\n\tvec3 irradiance = ambientLightColor;\n\treturn irradiance;\n}\nfloat getDistanceAttenuation( const in float lightDistance, const in float cutoffDistance, const in float decayExponent ) {\n\tfloat distanceFalloff = 1.0 / max( pow( lightDistance, decayExponent ), 0.01 );\n\tif ( cutoffDistance > 0.0 ) {\n\t\tdistanceFalloff *= pow2( saturate( 1.0 - pow4( lightDistance / cutoffDistance ) ) );\n\t}\n\treturn distanceFalloff;\n}\nfloat getSpotAttenuation( const in float coneCosine, const in float penumbraCosine, const in float angleCosine ) {\n\treturn smoothstep( coneCosine, penumbraCosine, angleCosine );\n}\n#if NUM_DIR_LIGHTS > 0\n\tstruct DirectionalLight {\n\t\tvec3 direction;\n\t\tvec3 color;\n\t};\n\tuniform DirectionalLight directionalLights[ NUM_DIR_LIGHTS ];\n\tvoid getDirectionalLightInfo( const in DirectionalLight directionalLight, out IncidentLight light ) {\n\t\tlight.color = directionalLight.color;\n\t\tlight.direction = directionalLight.direction;\n\t\tlight.visible = true;\n\t}\n#endif\n#if NUM_POINT_LIGHTS > 0\n\tstruct PointLight {\n\t\tvec3 position;\n\t\tvec3 color;\n\t\tfloat distance;\n\t\tfloat decay;\n\t};\n\tuniform PointLight pointLights[ NUM_POINT_LIGHTS ];\n\tvoid getPointLightInfo( const in PointLight pointLight, const in vec3 geometryPosition, out IncidentLight light ) {\n\t\tvec3 lVector = pointLight.position - geometryPosition;\n\t\tlight.direction = normalize( lVector );\n\t\tfloat lightDistance = length( lVector );\n\t\tlight.color = pointLight.color;\n\t\tlight.color *= getDistanceAttenuation( lightDistance, pointLight.distance, pointLight.decay );\n\t\tlight.visible = ( light.color != vec3( 0.0 ) );\n\t}\n#endif\n#if NUM_SPOT_LIGHTS > 0\n\tstruct SpotLight {\n\t\tvec3 position;\n\t\tvec3 direction;\n\t\tvec3 color;\n\t\tfloat distance;\n\t\tfloat decay;\n\t\tfloat coneCos;\n\t\tfloat penumbraCos;\n\t};\n\tuniform SpotLight spotLights[ NUM_SPOT_LIGHTS ];\n\tvoid getSpotLightInfo( const in SpotLight spotLight, const in vec3 geometryPosition, out IncidentLight light ) {\n\t\tvec3 lVector = spotLight.position - geometryPosition;\n\t\tlight.direction = normalize( lVector );\n\t\tfloat angleCos = dot( light.direction, spotLight.direction );\n\t\tfloat spotAttenuation = getSpotAttenuation( spotLight.coneCos, spotLight.penumbraCos, angleCos );\n\t\tif ( spotAttenuation > 0.0 ) {\n\t\t\tfloat lightDistance = length( lVector );\n\t\t\tlight.color = spotLight.color * spotAttenuation;\n\t\t\tlight.color *= getDistanceAttenuation( lightDistance, spotLight.distance, spotLight.decay );\n\t\t\tlight.visible = ( light.color != vec3( 0.0 ) );\n\t\t} else {\n\t\t\tlight.color = vec3( 0.0 );\n\t\t\tlight.visible = false;\n\t\t}\n\t}\n#endif\n#if NUM_RECT_AREA_LIGHTS > 0\n\tstruct RectAreaLight {\n\t\tvec3 color;\n\t\tvec3 position;\n\t\tvec3 halfWidth;\n\t\tvec3 halfHeight;\n\t};\n\tuniform sampler2D ltc_1;\tuniform sampler2D ltc_2;\n\tuniform RectAreaLight rectAreaLights[ NUM_RECT_AREA_LIGHTS ];\n#endif\n#if NUM_HEMI_LIGHTS > 0\n\tstruct HemisphereLight {\n\t\tvec3 direction;\n\t\tvec3 skyColor;\n\t\tvec3 groundColor;\n\t};\n\tuniform HemisphereLight hemisphereLights[ NUM_HEMI_LIGHTS ];\n\tvec3 getHemisphereLightIrradiance( const in HemisphereLight hemiLight, const in vec3 normal ) {\n\t\tfloat dotNL = dot( normal, hemiLight.direction );\n\t\tfloat hemiDiffuseWeight = 0.5 * dotNL + 0.5;\n\t\tvec3 irradiance = mix( hemiLight.groundColor, hemiLight.skyColor, hemiDiffuseWeight );\n\t\treturn irradiance;\n\t}\n#endif",lights_toon_fragment:"ToonMaterial material;\nmaterial.diffuseColor = diffuseColor.rgb;",lights_toon_pars_fragment:"varying vec3 vViewPosition;\nstruct ToonMaterial {\n\tvec3 diffuseColor;\n};\nvoid RE_Direct_Toon( const in IncidentLight directLight, const in vec3 geometryPosition, const in vec3 geometryNormal, const in vec3 geometryViewDir, const in vec3 geometryClearcoatNormal, const in ToonMaterial material, inout ReflectedLight reflectedLight ) {\n\tvec3 irradiance = getGradientIrradiance( geometryNormal, directLight.direction ) * directLight.color;\n\treflectedLight.directDiffuse += irradiance * BRDF_Lambert( material.diffuseColor );\n}\nvoid RE_IndirectDiffuse_Toon( const in vec3 irradiance, const in vec3 geometryPosition, const in vec3 geometryNormal, const in vec3 geometryViewDir, const in vec3 geometryClearcoatNormal, const in ToonMaterial material, inout ReflectedLight reflectedLight ) {\n\treflectedLight.indirectDiffuse += irradiance * BRDF_Lambert( material.diffuseColor );\n}\n#define RE_Direct\t\t\t\tRE_Direct_Toon\n#define RE_IndirectDiffuse\t\tRE_IndirectDiffuse_Toon",lights_phong_fragment:"BlinnPhongMaterial material;\nmaterial.diffuseColor = diffuseColor.rgb;\nmaterial.specularColor = specular;\nmaterial.specularShininess = shininess;\nmaterial.specularStrength = specularStrength;",lights_phong_pars_fragment:"varying vec3 vViewPosition;\nstruct BlinnPhongMaterial {\n\tvec3 diffuseColor;\n\tvec3 specularColor;\n\tfloat specularShininess;\n\tfloat specularStrength;\n};\nvoid RE_Direct_BlinnPhong( const in IncidentLight directLight, const in vec3 geometryPosition, const in vec3 geometryNormal, const in vec3 geometryViewDir, const in vec3 geometryClearcoatNormal, const in BlinnPhongMaterial material, inout ReflectedLight reflectedLight ) {\n\tfloat dotNL = saturate( dot( geometryNormal, directLight.direction ) );\n\tvec3 irradiance = dotNL * directLight.color;\n\treflectedLight.directDiffuse += irradiance * BRDF_Lambert( material.diffuseColor );\n\treflectedLight.directSpecular += irradiance * BRDF_BlinnPhong( directLight.direction, geometryViewDir, geometryNormal, material.specularColor, material.specularShininess ) * material.specularStrength;\n}\nvoid RE_IndirectDiffuse_BlinnPhong( const in vec3 irradiance, const in vec3 geometryPosition, const in vec3 geometryNormal, const in vec3 geometryViewDir, const in vec3 geometryClearcoatNormal, const in BlinnPhongMaterial material, inout ReflectedLight reflectedLight ) {\n\treflectedLight.indirectDiffuse += irradiance * BRDF_Lambert( material.diffuseColor );\n}\n#define RE_Direct\t\t\t\tRE_Direct_BlinnPhong\n#define RE_IndirectDiffuse\t\tRE_IndirectDiffuse_BlinnPhong",lights_physical_fragment:"PhysicalMaterial material;\nmaterial.diffuseColor = diffuseColor.rgb * ( 1.0 - metalnessFactor );\nvec3 dxy = max( abs( dFdx( nonPerturbedNormal ) ), abs( dFdy( nonPerturbedNormal ) ) );\nfloat geometryRoughness = max( max( dxy.x, dxy.y ), dxy.z );\nmaterial.roughness = max( roughnessFactor, 0.0525 );material.roughness += geometryRoughness;\nmaterial.roughness = min( material.roughness, 1.0 );\n#ifdef IOR\n\tmaterial.ior = ior;\n\t#ifdef USE_SPECULAR\n\t\tfloat specularIntensityFactor = specularIntensity;\n\t\tvec3 specularColorFactor = specularColor;\n\t\t#ifdef USE_SPECULAR_COLORMAP\n\t\t\tspecularColorFactor *= texture2D( specularColorMap, vSpecularColorMapUv ).rgb;\n\t\t#endif\n\t\t#ifdef USE_SPECULAR_INTENSITYMAP\n\t\t\tspecularIntensityFactor *= texture2D( specularIntensityMap, vSpecularIntensityMapUv ).a;\n\t\t#endif\n\t\tmaterial.specularF90 = mix( specularIntensityFactor, 1.0, metalnessFactor );\n\t#else\n\t\tfloat specularIntensityFactor = 1.0;\n\t\tvec3 specularColorFactor = vec3( 1.0 );\n\t\tmaterial.specularF90 = 1.0;\n\t#endif\n\tmaterial.specularColor = mix( min( pow2( ( material.ior - 1.0 ) / ( material.ior + 1.0 ) ) * specularColorFactor, vec3( 1.0 ) ) * specularIntensityFactor, diffuseColor.rgb, metalnessFactor );\n#else\n\tmaterial.specularColor = mix( vec3( 0.04 ), diffuseColor.rgb, metalnessFactor );\n\tmaterial.specularF90 = 1.0;\n#endif\n#ifdef USE_CLEARCOAT\n\tmaterial.clearcoat = clearcoat;\n\tmaterial.clearcoatRoughness = clearcoatRoughness;\n\tmaterial.clearcoatF0 = vec3( 0.04 );\n\tmaterial.clearcoatF90 = 1.0;\n\t#ifdef USE_CLEARCOATMAP\n\t\tmaterial.clearcoat *= texture2D( clearcoatMap, vClearcoatMapUv ).x;\n\t#endif\n\t#ifdef USE_CLEARCOAT_ROUGHNESSMAP\n\t\tmaterial.clearcoatRoughness *= texture2D( clearcoatRoughnessMap, vClearcoatRoughnessMapUv ).y;\n\t#endif\n\tmaterial.clearcoat = saturate( material.clearcoat );\tmaterial.clearcoatRoughness = max( material.clearcoatRoughness, 0.0525 );\n\tmaterial.clearcoatRoughness += geometryRoughness;\n\tmaterial.clearcoatRoughness = min( material.clearcoatRoughness, 1.0 );\n#endif\n#ifdef USE_DISPERSION\n\tmaterial.dispersion = dispersion;\n#endif\n#ifdef USE_IRIDESCENCE\n\tmaterial.iridescence = iridescence;\n\tmaterial.iridescenceIOR = iridescenceIOR;\n\t#ifdef USE_IRIDESCENCEMAP\n\t\tmaterial.iridescence *= texture2D( iridescenceMap, vIridescenceMapUv ).r;\n\t#endif\n\t#ifdef USE_IRIDESCENCE_THICKNESSMAP\n\t\tmaterial.iridescenceThickness = (iridescenceThicknessMaximum - iridescenceThicknessMinimum) * texture2D( iridescenceThicknessMap, vIridescenceThicknessMapUv ).g + iridescenceThicknessMinimum;\n\t#else\n\t\tmaterial.iridescenceThickness = iridescenceThicknessMaximum;\n\t#endif\n#endif\n#ifdef USE_SHEEN\n\tmaterial.sheenColor = sheenColor;\n\t#ifdef USE_SHEEN_COLORMAP\n\t\tmaterial.sheenColor *= texture2D( sheenColorMap, vSheenColorMapUv ).rgb;\n\t#endif\n\tmaterial.sheenRoughness = clamp( sheenRoughness, 0.07, 1.0 );\n\t#ifdef USE_SHEEN_ROUGHNESSMAP\n\t\tmaterial.sheenRoughness *= texture2D( sheenRoughnessMap, vSheenRoughnessMapUv ).a;\n\t#endif\n#endif\n#ifdef USE_ANISOTROPY\n\t#ifdef USE_ANISOTROPYMAP\n\t\tmat2 anisotropyMat = mat2( anisotropyVector.x, anisotropyVector.y, - anisotropyVector.y, anisotropyVector.x );\n\t\tvec3 anisotropyPolar = texture2D( anisotropyMap, vAnisotropyMapUv ).rgb;\n\t\tvec2 anisotropyV = anisotropyMat * normalize( 2.0 * anisotropyPolar.rg - vec2( 1.0 ) ) * anisotropyPolar.b;\n\t#else\n\t\tvec2 anisotropyV = anisotropyVector;\n\t#endif\n\tmaterial.anisotropy = length( anisotropyV );\n\tif( material.anisotropy == 0.0 ) {\n\t\tanisotropyV = vec2( 1.0, 0.0 );\n\t} else {\n\t\tanisotropyV /= material.anisotropy;\n\t\tmaterial.anisotropy = saturate( material.anisotropy );\n\t}\n\tmaterial.alphaT = mix( pow2( material.roughness ), 1.0, pow2( material.anisotropy ) );\n\tmaterial.anisotropyT = tbn[ 0 ] * anisotropyV.x + tbn[ 1 ] * anisotropyV.y;\n\tmaterial.anisotropyB = tbn[ 1 ] * anisotropyV.x - tbn[ 0 ] * anisotropyV.y;\n#endif",lights_physical_pars_fragment:"struct PhysicalMaterial {\n\tvec3 diffuseColor;\n\tfloat roughness;\n\tvec3 specularColor;\n\tfloat specularF90;\n\tfloat dispersion;\n\t#ifdef USE_CLEARCOAT\n\t\tfloat clearcoat;\n\t\tfloat clearcoatRoughness;\n\t\tvec3 clearcoatF0;\n\t\tfloat clearcoatF90;\n\t#endif\n\t#ifdef USE_IRIDESCENCE\n\t\tfloat iridescence;\n\t\tfloat iridescenceIOR;\n\t\tfloat iridescenceThickness;\n\t\tvec3 iridescenceFresnel;\n\t\tvec3 iridescenceF0;\n\t#endif\n\t#ifdef USE_SHEEN\n\t\tvec3 sheenColor;\n\t\tfloat sheenRoughness;\n\t#endif\n\t#ifdef IOR\n\t\tfloat ior;\n\t#endif\n\t#ifdef USE_TRANSMISSION\n\t\tfloat transmission;\n\t\tfloat transmissionAlpha;\n\t\tfloat thickness;\n\t\tfloat attenuationDistance;\n\t\tvec3 attenuationColor;\n\t#endif\n\t#ifdef USE_ANISOTROPY\n\t\tfloat anisotropy;\n\t\tfloat alphaT;\n\t\tvec3 anisotropyT;\n\t\tvec3 anisotropyB;\n\t#endif\n};\nvec3 clearcoatSpecularDirect = vec3( 0.0 );\nvec3 clearcoatSpecularIndirect = vec3( 0.0 );\nvec3 sheenSpecularDirect = vec3( 0.0 );\nvec3 sheenSpecularIndirect = vec3(0.0 );\nvec3 Schlick_to_F0( const in vec3 f, const in float f90, const in float dotVH ) {\n    float x = clamp( 1.0 - dotVH, 0.0, 1.0 );\n    float x2 = x * x;\n    float x5 = clamp( x * x2 * x2, 0.0, 0.9999 );\n    return ( f - vec3( f90 ) * x5 ) / ( 1.0 - x5 );\n}\nfloat V_GGX_SmithCorrelated( const in float alpha, const in float dotNL, const in float dotNV ) {\n\tfloat a2 = pow2( alpha );\n\tfloat gv = dotNL * sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNV ) );\n\tfloat gl = dotNV * sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNL ) );\n\treturn 0.5 / max( gv + gl, EPSILON );\n}\nfloat D_GGX( const in float alpha, const in float dotNH ) {\n\tfloat a2 = pow2( alpha );\n\tfloat denom = pow2( dotNH ) * ( a2 - 1.0 ) + 1.0;\n\treturn RECIPROCAL_PI * a2 / pow2( denom );\n}\n#ifdef USE_ANISOTROPY\n\tfloat V_GGX_SmithCorrelated_Anisotropic( const in float alphaT, const in float alphaB, const in float dotTV, const in float dotBV, const in float dotTL, const in float dotBL, const in float dotNV, const in float dotNL ) {\n\t\tfloat gv = dotNL * length( vec3( alphaT * dotTV, alphaB * dotBV, dotNV ) );\n\t\tfloat gl = dotNV * length( vec3( alphaT * dotTL, alphaB * dotBL, dotNL ) );\n\t\tfloat v = 0.5 / ( gv + gl );\n\t\treturn saturate(v);\n\t}\n\tfloat D_GGX_Anisotropic( const in float alphaT, const in float alphaB, const in float dotNH, const in float dotTH, const in float dotBH ) {\n\t\tfloat a2 = alphaT * alphaB;\n\t\thighp vec3 v = vec3( alphaB * dotTH, alphaT * dotBH, a2 * dotNH );\n\t\thighp float v2 = dot( v, v );\n\t\tfloat w2 = a2 / v2;\n\t\treturn RECIPROCAL_PI * a2 * pow2 ( w2 );\n\t}\n#endif\n#ifdef USE_CLEARCOAT\n\tvec3 BRDF_GGX_Clearcoat( const in vec3 lightDir, const in vec3 viewDir, const in vec3 normal, const in PhysicalMaterial material) {\n\t\tvec3 f0 = material.clearcoatF0;\n\t\tfloat f90 = material.clearcoatF90;\n\t\tfloat roughness = material.clearcoatRoughness;\n\t\tfloat alpha = pow2( roughness );\n\t\tvec3 halfDir = normalize( lightDir + viewDir );\n\t\tfloat dotNL = saturate( dot( normal, lightDir ) );\n\t\tfloat dotNV = saturate( dot( normal, viewDir ) );\n\t\tfloat dotNH = saturate( dot( normal, halfDir ) );\n\t\tfloat dotVH = saturate( dot( viewDir, halfDir ) );\n\t\tvec3 F = F_Schlick( f0, f90, dotVH );\n\t\tfloat V = V_GGX_SmithCorrelated( alpha, dotNL, dotNV );\n\t\tfloat D = D_GGX( alpha, dotNH );\n\t\treturn F * ( V * D );\n\t}\n#endif\nvec3 BRDF_GGX( const in vec3 lightDir, const in vec3 viewDir, const in vec3 normal, const in PhysicalMaterial material ) {\n\tvec3 f0 = material.specularColor;\n\tfloat f90 = material.specularF90;\n\tfloat roughness = material.roughness;\n\tfloat alpha = pow2( roughness );\n\tvec3 halfDir = normalize( lightDir + viewDir );\n\tfloat dotNL = saturate( dot( normal, lightDir ) );\n\tfloat dotNV = saturate( dot( normal, viewDir ) );\n\tfloat dotNH = saturate( dot( normal, halfDir ) );\n\tfloat dotVH = saturate( dot( viewDir, halfDir ) );\n\tvec3 F = F_Schlick( f0, f90, dotVH );\n\t#ifdef USE_IRIDESCENCE\n\t\tF = mix( F, material.iridescenceFresnel, material.iridescence );\n\t#endif\n\t#ifdef USE_ANISOTROPY\n\t\tfloat dotTL = dot( material.anisotropyT, lightDir );\n\t\tfloat dotTV = dot( material.anisotropyT, viewDir );\n\t\tfloat dotTH = dot( material.anisotropyT, halfDir );\n\t\tfloat dotBL = dot( material.anisotropyB, lightDir );\n\t\tfloat dotBV = dot( material.anisotropyB, viewDir );\n\t\tfloat dotBH = dot( material.anisotropyB, halfDir );\n\t\tfloat V = V_GGX_SmithCorrelated_Anisotropic( material.alphaT, alpha, dotTV, dotBV, dotTL, dotBL, dotNV, dotNL );\n\t\tfloat D = D_GGX_Anisotropic( material.alphaT, alpha, dotNH, dotTH, dotBH );\n\t#else\n\t\tfloat V = V_GGX_SmithCorrelated( alpha, dotNL, dotNV );\n\t\tfloat D = D_GGX( alpha, dotNH );\n\t#endif\n\treturn F * ( V * D );\n}\nvec2 LTC_Uv( const in vec3 N, const in vec3 V, const in float roughness ) {\n\tconst float LUT_SIZE = 64.0;\n\tconst float LUT_SCALE = ( LUT_SIZE - 1.0 ) / LUT_SIZE;\n\tconst float LUT_BIAS = 0.5 / LUT_SIZE;\n\tfloat dotNV = saturate( dot( N, V ) );\n\tvec2 uv = vec2( roughness, sqrt( 1.0 - dotNV ) );\n\tuv = uv * LUT_SCALE + LUT_BIAS;\n\treturn uv;\n}\nfloat LTC_ClippedSphereFormFactor( const in vec3 f ) {\n\tfloat l = length( f );\n\treturn max( ( l * l + f.z ) / ( l + 1.0 ), 0.0 );\n}\nvec3 LTC_EdgeVectorFormFactor( const in vec3 v1, const in vec3 v2 ) {\n\tfloat x = dot( v1, v2 );\n\tfloat y = abs( x );\n\tfloat a = 0.8543985 + ( 0.4965155 + 0.0145206 * y ) * y;\n\tfloat b = 3.4175940 + ( 4.1616724 + y ) * y;\n\tfloat v = a / b;\n\tfloat theta_sintheta = ( x > 0.0 ) ? v : 0.5 * inversesqrt( max( 1.0 - x * x, 1e-7 ) ) - v;\n\treturn cross( v1, v2 ) * theta_sintheta;\n}\nvec3 LTC_Evaluate( const in vec3 N, const in vec3 V, const in vec3 P, const in mat3 mInv, const in vec3 rectCoords[ 4 ] ) {\n\tvec3 v1 = rectCoords[ 1 ] - rectCoords[ 0 ];\n\tvec3 v2 = rectCoords[ 3 ] - rectCoords[ 0 ];\n\tvec3 lightNormal = cross( v1, v2 );\n\tif( dot( lightNormal, P - rectCoords[ 0 ] ) < 0.0 ) return vec3( 0.0 );\n\tvec3 T1, T2;\n\tT1 = normalize( V - N * dot( V, N ) );\n\tT2 = - cross( N, T1 );\n\tmat3 mat = mInv * transposeMat3( mat3( T1, T2, N ) );\n\tvec3 coords[ 4 ];\n\tcoords[ 0 ] = mat * ( rectCoords[ 0 ] - P );\n\tcoords[ 1 ] = mat * ( rectCoords[ 1 ] - P );\n\tcoords[ 2 ] = mat * ( rectCoords[ 2 ] - P );\n\tcoords[ 3 ] = mat * ( rectCoords[ 3 ] - P );\n\tcoords[ 0 ] = normalize( coords[ 0 ] );\n\tcoords[ 1 ] = normalize( coords[ 1 ] );\n\tcoords[ 2 ] = normalize( coords[ 2 ] );\n\tcoords[ 3 ] = normalize( coords[ 3 ] );\n\tvec3 vectorFormFactor = vec3( 0.0 );\n\tvectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 0 ], coords[ 1 ] );\n\tvectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 1 ], coords[ 2 ] );\n\tvectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 2 ], coords[ 3 ] );\n\tvectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 3 ], coords[ 0 ] );\n\tfloat result = LTC_ClippedSphereFormFactor( vectorFormFactor );\n\treturn vec3( result );\n}\n#if defined( USE_SHEEN )\nfloat D_Charlie( float roughness, float dotNH ) {\n\tfloat alpha = pow2( roughness );\n\tfloat invAlpha = 1.0 / alpha;\n\tfloat cos2h = dotNH * dotNH;\n\tfloat sin2h = max( 1.0 - cos2h, 0.0078125 );\n\treturn ( 2.0 + invAlpha ) * pow( sin2h, invAlpha * 0.5 ) / ( 2.0 * PI );\n}\nfloat V_Neubelt( float dotNV, float dotNL ) {\n\treturn saturate( 1.0 / ( 4.0 * ( dotNL + dotNV - dotNL * dotNV ) ) );\n}\nvec3 BRDF_Sheen( const in vec3 lightDir, const in vec3 viewDir, const in vec3 normal, vec3 sheenColor, const in float sheenRoughness ) {\n\tvec3 halfDir = normalize( lightDir + viewDir );\n\tfloat dotNL = saturate( dot( normal, lightDir ) );\n\tfloat dotNV = saturate( dot( normal, viewDir ) );\n\tfloat dotNH = saturate( dot( normal, halfDir ) );\n\tfloat D = D_Charlie( sheenRoughness, dotNH );\n\tfloat V = V_Neubelt( dotNV, dotNL );\n\treturn sheenColor * ( D * V );\n}\n#endif\nfloat IBLSheenBRDF( const in vec3 normal, const in vec3 viewDir, const in float roughness ) {\n\tfloat dotNV = saturate( dot( normal, viewDir ) );\n\tfloat r2 = roughness * roughness;\n\tfloat a = roughness < 0.25 ? -339.2 * r2 + 161.4 * roughness - 25.9 : -8.48 * r2 + 14.3 * roughness - 9.95;\n\tfloat b = roughness < 0.25 ? 44.0 * r2 - 23.7 * roughness + 3.26 : 1.97 * r2 - 3.27 * roughness + 0.72;\n\tfloat DG = exp( a * dotNV + b ) + ( roughness < 0.25 ? 0.0 : 0.1 * ( roughness - 0.25 ) );\n\treturn saturate( DG * RECIPROCAL_PI );\n}\nvec2 DFGApprox( const in vec3 normal, const in vec3 viewDir, const in float roughness ) {\n\tfloat dotNV = saturate( dot( normal, viewDir ) );\n\tconst vec4 c0 = vec4( - 1, - 0.0275, - 0.572, 0.022 );\n\tconst vec4 c1 = vec4( 1, 0.0425, 1.04, - 0.04 );\n\tvec4 r = roughness * c0 + c1;\n\tfloat a004 = min( r.x * r.x, exp2( - 9.28 * dotNV ) ) * r.x + r.y;\n\tvec2 fab = vec2( - 1.04, 1.04 ) * a004 + r.zw;\n\treturn fab;\n}\nvec3 EnvironmentBRDF( const in vec3 normal, const in vec3 viewDir, const in vec3 specularColor, const in float specularF90, const in float roughness ) {\n\tvec2 fab = DFGApprox( normal, viewDir, roughness );\n\treturn specularColor * fab.x + specularF90 * fab.y;\n}\n#ifdef USE_IRIDESCENCE\nvoid computeMultiscatteringIridescence( const in vec3 normal, const in vec3 viewDir, const in vec3 specularColor, const in float specularF90, const in float iridescence, const in vec3 iridescenceF0, const in float roughness, inout vec3 singleScatter, inout vec3 multiScatter ) {\n#else\nvoid computeMultiscattering( const in vec3 normal, const in vec3 viewDir, const in vec3 specularColor, const in float specularF90, const in float roughness, inout vec3 singleScatter, inout vec3 multiScatter ) {\n#endif\n\tvec2 fab = DFGApprox( normal, viewDir, roughness );\n\t#ifdef USE_IRIDESCENCE\n\t\tvec3 Fr = mix( specularColor, iridescenceF0, iridescence );\n\t#else\n\t\tvec3 Fr = specularColor;\n\t#endif\n\tvec3 FssEss = Fr * fab.x + specularF90 * fab.y;\n\tfloat Ess = fab.x + fab.y;\n\tfloat Ems = 1.0 - Ess;\n\tvec3 Favg = Fr + ( 1.0 - Fr ) * 0.047619;\tvec3 Fms = FssEss * Favg / ( 1.0 - Ems * Favg );\n\tsingleScatter += FssEss;\n\tmultiScatter += Fms * Ems;\n}\n#if NUM_RECT_AREA_LIGHTS > 0\n\tvoid RE_Direct_RectArea_Physical( const in RectAreaLight rectAreaLight, const in vec3 geometryPosition, const in vec3 geometryNormal, const in vec3 geometryViewDir, const in vec3 geometryClearcoatNormal, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {\n\t\tvec3 normal = geometryNormal;\n\t\tvec3 viewDir = geometryViewDir;\n\t\tvec3 position = geometryPosition;\n\t\tvec3 lightPos = rectAreaLight.position;\n\t\tvec3 halfWidth = rectAreaLight.halfWidth;\n\t\tvec3 halfHeight = rectAreaLight.halfHeight;\n\t\tvec3 lightColor = rectAreaLight.color;\n\t\tfloat roughness = material.roughness;\n\t\tvec3 rectCoords[ 4 ];\n\t\trectCoords[ 0 ] = lightPos + halfWidth - halfHeight;\t\trectCoords[ 1 ] = lightPos - halfWidth - halfHeight;\n\t\trectCoords[ 2 ] = lightPos - halfWidth + halfHeight;\n\t\trectCoords[ 3 ] = lightPos + halfWidth + halfHeight;\n\t\tvec2 uv = LTC_Uv( normal, viewDir, roughness );\n\t\tvec4 t1 = texture2D( ltc_1, uv );\n\t\tvec4 t2 = texture2D( ltc_2, uv );\n\t\tmat3 mInv = mat3(\n\t\t\tvec3( t1.x, 0, t1.y ),\n\t\t\tvec3(    0, 1,    0 ),\n\t\t\tvec3( t1.z, 0, t1.w )\n\t\t);\n\t\tvec3 fresnel = ( material.specularColor * t2.x + ( vec3( 1.0 ) - material.specularColor ) * t2.y );\n\t\treflectedLight.directSpecular += lightColor * fresnel * LTC_Evaluate( normal, viewDir, position, mInv, rectCoords );\n\t\treflectedLight.directDiffuse += lightColor * material.diffuseColor * LTC_Evaluate( normal, viewDir, position, mat3( 1.0 ), rectCoords );\n\t}\n#endif\nvoid RE_Direct_Physical( const in IncidentLight directLight, const in vec3 geometryPosition, const in vec3 geometryNormal, const in vec3 geometryViewDir, const in vec3 geometryClearcoatNormal, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {\n\tfloat dotNL = saturate( dot( geometryNormal, directLight.direction ) );\n\tvec3 irradiance = dotNL * directLight.color;\n\t#ifdef USE_CLEARCOAT\n\t\tfloat dotNLcc = saturate( dot( geometryClearcoatNormal, directLight.direction ) );\n\t\tvec3 ccIrradiance = dotNLcc * directLight.color;\n\t\tclearcoatSpecularDirect += ccIrradiance * BRDF_GGX_Clearcoat( directLight.direction, geometryViewDir, geometryClearcoatNormal, material );\n\t#endif\n\t#ifdef USE_SHEEN\n\t\tsheenSpecularDirect += irradiance * BRDF_Sheen( directLight.direction, geometryViewDir, geometryNormal, material.sheenColor, material.sheenRoughness );\n\t#endif\n\treflectedLight.directSpecular += irradiance * BRDF_GGX( directLight.direction, geometryViewDir, geometryNormal, material );\n\treflectedLight.directDiffuse += irradiance * BRDF_Lambert( material.diffuseColor );\n}\nvoid RE_IndirectDiffuse_Physical( const in vec3 irradiance, const in vec3 geometryPosition, const in vec3 geometryNormal, const in vec3 geometryViewDir, const in vec3 geometryClearcoatNormal, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {\n\treflectedLight.indirectDiffuse += irradiance * BRDF_Lambert( material.diffuseColor );\n}\nvoid RE_IndirectSpecular_Physical( const in vec3 radiance, const in vec3 irradiance, const in vec3 clearcoatRadiance, const in vec3 geometryPosition, const in vec3 geometryNormal, const in vec3 geometryViewDir, const in vec3 geometryClearcoatNormal, const in PhysicalMaterial material, inout ReflectedLight reflectedLight) {\n\t#ifdef USE_CLEARCOAT\n\t\tclearcoatSpecularIndirect += clearcoatRadiance * EnvironmentBRDF( geometryClearcoatNormal, geometryViewDir, material.clearcoatF0, material.clearcoatF90, material.clearcoatRoughness );\n\t#endif\n\t#ifdef USE_SHEEN\n\t\tsheenSpecularIndirect += irradiance * material.sheenColor * IBLSheenBRDF( geometryNormal, geometryViewDir, material.sheenRoughness );\n\t#endif\n\tvec3 singleScattering = vec3( 0.0 );\n\tvec3 multiScattering = vec3( 0.0 );\n\tvec3 cosineWeightedIrradiance = irradiance * RECIPROCAL_PI;\n\t#ifdef USE_IRIDESCENCE\n\t\tcomputeMultiscatteringIridescence( geometryNormal, geometryViewDir, material.specularColor, material.specularF90, material.iridescence, material.iridescenceFresnel, material.roughness, singleScattering, multiScattering );\n\t#else\n\t\tcomputeMultiscattering( geometryNormal, geometryViewDir, material.specularColor, material.specularF90, material.roughness, singleScattering, multiScattering );\n\t#endif\n\tvec3 totalScattering = singleScattering + multiScattering;\n\tvec3 diffuse = material.diffuseColor * ( 1.0 - max( max( totalScattering.r, totalScattering.g ), totalScattering.b ) );\n\treflectedLight.indirectSpecular += radiance * singleScattering;\n\treflectedLight.indirectSpecular += multiScattering * cosineWeightedIrradiance;\n\treflectedLight.indirectDiffuse += diffuse * cosineWeightedIrradiance;\n}\n#define RE_Direct\t\t\t\tRE_Direct_Physical\n#define RE_Direct_RectArea\t\tRE_Direct_RectArea_Physical\n#define RE_IndirectDiffuse\t\tRE_IndirectDiffuse_Physical\n#define RE_IndirectSpecular\t\tRE_IndirectSpecular_Physical\nfloat computeSpecularOcclusion( const in float dotNV, const in float ambientOcclusion, const in float roughness ) {\n\treturn saturate( pow( dotNV + ambientOcclusion, exp2( - 16.0 * roughness - 1.0 ) ) - 1.0 + ambientOcclusion );\n}",lights_fragment_begin:"\nvec3 geometryPosition = - vViewPosition;\nvec3 geometryNormal = normal;\nvec3 geometryViewDir = ( isOrthographic ) ? vec3( 0, 0, 1 ) : normalize( vViewPosition );\nvec3 geometryClearcoatNormal = vec3( 0.0 );\n#ifdef USE_CLEARCOAT\n\tgeometryClearcoatNormal = clearcoatNormal;\n#endif\n#ifdef USE_IRIDESCENCE\n\tfloat dotNVi = saturate( dot( normal, geometryViewDir ) );\n\tif ( material.iridescenceThickness == 0.0 ) {\n\t\tmaterial.iridescence = 0.0;\n\t} else {\n\t\tmaterial.iridescence = saturate( material.iridescence );\n\t}\n\tif ( material.iridescence > 0.0 ) {\n\t\tmaterial.iridescenceFresnel = evalIridescence( 1.0, material.iridescenceIOR, dotNVi, material.iridescenceThickness, material.specularColor );\n\t\tmaterial.iridescenceF0 = Schlick_to_F0( material.iridescenceFresnel, 1.0, dotNVi );\n\t}\n#endif\nIncidentLight directLight;\n#if ( NUM_POINT_LIGHTS > 0 ) && defined( RE_Direct )\n\tPointLight pointLight;\n\t#if defined( USE_SHADOWMAP ) && NUM_POINT_LIGHT_SHADOWS > 0\n\tPointLightShadow pointLightShadow;\n\t#endif\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_POINT_LIGHTS; i ++ ) {\n\t\tpointLight = pointLights[ i ];\n\t\tgetPointLightInfo( pointLight, geometryPosition, directLight );\n\t\t#if defined( USE_SHADOWMAP ) && ( UNROLLED_LOOP_INDEX < NUM_POINT_LIGHT_SHADOWS )\n\t\tpointLightShadow = pointLightShadows[ i ];\n\t\tdirectLight.color *= ( directLight.visible && receiveShadow ) ? getPointShadow( pointShadowMap[ i ], pointLightShadow.shadowMapSize, pointLightShadow.shadowIntensity, pointLightShadow.shadowBias, pointLightShadow.shadowRadius, vPointShadowCoord[ i ], pointLightShadow.shadowCameraNear, pointLightShadow.shadowCameraFar ) : 1.0;\n\t\t#endif\n\t\tRE_Direct( directLight, geometryPosition, geometryNormal, geometryViewDir, geometryClearcoatNormal, material, reflectedLight );\n\t}\n\t#pragma unroll_loop_end\n#endif\n#if ( NUM_SPOT_LIGHTS > 0 ) && defined( RE_Direct )\n\tSpotLight spotLight;\n\tvec4 spotColor;\n\tvec3 spotLightCoord;\n\tbool inSpotLightMap;\n\t#if defined( USE_SHADOWMAP ) && NUM_SPOT_LIGHT_SHADOWS > 0\n\tSpotLightShadow spotLightShadow;\n\t#endif\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_SPOT_LIGHTS; i ++ ) {\n\t\tspotLight = spotLights[ i ];\n\t\tgetSpotLightInfo( spotLight, geometryPosition, directLight );\n\t\t#if ( UNROLLED_LOOP_INDEX < NUM_SPOT_LIGHT_SHADOWS_WITH_MAPS )\n\t\t#define SPOT_LIGHT_MAP_INDEX UNROLLED_LOOP_INDEX\n\t\t#elif ( UNROLLED_LOOP_INDEX < NUM_SPOT_LIGHT_SHADOWS )\n\t\t#define SPOT_LIGHT_MAP_INDEX NUM_SPOT_LIGHT_MAPS\n\t\t#else\n\t\t#define SPOT_LIGHT_MAP_INDEX ( UNROLLED_LOOP_INDEX - NUM_SPOT_LIGHT_SHADOWS + NUM_SPOT_LIGHT_SHADOWS_WITH_MAPS )\n\t\t#endif\n\t\t#if ( SPOT_LIGHT_MAP_INDEX < NUM_SPOT_LIGHT_MAPS )\n\t\t\tspotLightCoord = vSpotLightCoord[ i ].xyz / vSpotLightCoord[ i ].w;\n\t\t\tinSpotLightMap = all( lessThan( abs( spotLightCoord * 2. - 1. ), vec3( 1.0 ) ) );\n\t\t\tspotColor = texture2D( spotLightMap[ SPOT_LIGHT_MAP_INDEX ], spotLightCoord.xy );\n\t\t\tdirectLight.color = inSpotLightMap ? directLight.color * spotColor.rgb : directLight.color;\n\t\t#endif\n\t\t#undef SPOT_LIGHT_MAP_INDEX\n\t\t#if defined( USE_SHADOWMAP ) && ( UNROLLED_LOOP_INDEX < NUM_SPOT_LIGHT_SHADOWS )\n\t\tspotLightShadow = spotLightShadows[ i ];\n\t\tdirectLight.color *= ( directLight.visible && receiveShadow ) ? getShadow( spotShadowMap[ i ], spotLightShadow.shadowMapSize, spotLightShadow.shadowIntensity, spotLightShadow.shadowBias, spotLightShadow.shadowRadius, vSpotLightCoord[ i ] ) : 1.0;\n\t\t#endif\n\t\tRE_Direct( directLight, geometryPosition, geometryNormal, geometryViewDir, geometryClearcoatNormal, material, reflectedLight );\n\t}\n\t#pragma unroll_loop_end\n#endif\n#if ( NUM_DIR_LIGHTS > 0 ) && defined( RE_Direct )\n\tDirectionalLight directionalLight;\n\t#if defined( USE_SHADOWMAP ) && NUM_DIR_LIGHT_SHADOWS > 0\n\tDirectionalLightShadow directionalLightShadow;\n\t#endif\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_DIR_LIGHTS; i ++ ) {\n\t\tdirectionalLight = directionalLights[ i ];\n\t\tgetDirectionalLightInfo( directionalLight, directLight );\n\t\t#if defined( USE_SHADOWMAP ) && ( UNROLLED_LOOP_INDEX < NUM_DIR_LIGHT_SHADOWS )\n\t\tdirectionalLightShadow = directionalLightShadows[ i ];\n\t\tdirectLight.color *= ( directLight.visible && receiveShadow ) ? getShadow( directionalShadowMap[ i ], directionalLightShadow.shadowMapSize, directionalLightShadow.shadowIntensity, directionalLightShadow.shadowBias, directionalLightShadow.shadowRadius, vDirectionalShadowCoord[ i ] ) : 1.0;\n\t\t#endif\n\t\tRE_Direct( directLight, geometryPosition, geometryNormal, geometryViewDir, geometryClearcoatNormal, material, reflectedLight );\n\t}\n\t#pragma unroll_loop_end\n#endif\n#if ( NUM_RECT_AREA_LIGHTS > 0 ) && defined( RE_Direct_RectArea )\n\tRectAreaLight rectAreaLight;\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_RECT_AREA_LIGHTS; i ++ ) {\n\t\trectAreaLight = rectAreaLights[ i ];\n\t\tRE_Direct_RectArea( rectAreaLight, geometryPosition, geometryNormal, geometryViewDir, geometryClearcoatNormal, material, reflectedLight );\n\t}\n\t#pragma unroll_loop_end\n#endif\n#if defined( RE_IndirectDiffuse )\n\tvec3 iblIrradiance = vec3( 0.0 );\n\tvec3 irradiance = getAmbientLightIrradiance( ambientLightColor );\n\t#if defined( USE_LIGHT_PROBES )\n\t\tirradiance += getLightProbeIrradiance( lightProbe, geometryNormal );\n\t#endif\n\t#if ( NUM_HEMI_LIGHTS > 0 )\n\t\t#pragma unroll_loop_start\n\t\tfor ( int i = 0; i < NUM_HEMI_LIGHTS; i ++ ) {\n\t\t\tirradiance += getHemisphereLightIrradiance( hemisphereLights[ i ], geometryNormal );\n\t\t}\n\t\t#pragma unroll_loop_end\n\t#endif\n#endif\n#if defined( RE_IndirectSpecular )\n\tvec3 radiance = vec3( 0.0 );\n\tvec3 clearcoatRadiance = vec3( 0.0 );\n#endif",lights_fragment_maps:"#if defined( RE_IndirectDiffuse )\n\t#ifdef USE_LIGHTMAP\n\t\tvec4 lightMapTexel = texture2D( lightMap, vLightMapUv );\n\t\tvec3 lightMapIrradiance = lightMapTexel.rgb * lightMapIntensity;\n\t\tirradiance += lightMapIrradiance;\n\t#endif\n\t#if defined( USE_ENVMAP ) && defined( STANDARD ) && defined( ENVMAP_TYPE_CUBE_UV )\n\t\tiblIrradiance += getIBLIrradiance( geometryNormal );\n\t#endif\n#endif\n#if defined( USE_ENVMAP ) && defined( RE_IndirectSpecular )\n\t#ifdef USE_ANISOTROPY\n\t\tradiance += getIBLAnisotropyRadiance( geometryViewDir, geometryNormal, material.roughness, material.anisotropyB, material.anisotropy );\n\t#else\n\t\tradiance += getIBLRadiance( geometryViewDir, geometryNormal, material.roughness );\n\t#endif\n\t#ifdef USE_CLEARCOAT\n\t\tclearcoatRadiance += getIBLRadiance( geometryViewDir, geometryClearcoatNormal, material.clearcoatRoughness );\n\t#endif\n#endif",lights_fragment_end:"#if defined( RE_IndirectDiffuse )\n\tRE_IndirectDiffuse( irradiance, geometryPosition, geometryNormal, geometryViewDir, geometryClearcoatNormal, material, reflectedLight );\n#endif\n#if defined( RE_IndirectSpecular )\n\tRE_IndirectSpecular( radiance, iblIrradiance, clearcoatRadiance, geometryPosition, geometryNormal, geometryViewDir, geometryClearcoatNormal, material, reflectedLight );\n#endif",logdepthbuf_fragment:"#if defined( USE_LOGDEPTHBUF )\n\tgl_FragDepth = vIsPerspective == 0.0 ? gl_FragCoord.z : log2( vFragDepth ) * logDepthBufFC * 0.5;\n#endif",logdepthbuf_pars_fragment:"#if defined( USE_LOGDEPTHBUF )\n\tuniform float logDepthBufFC;\n\tvarying float vFragDepth;\n\tvarying float vIsPerspective;\n#endif",logdepthbuf_pars_vertex:"#ifdef USE_LOGDEPTHBUF\n\tvarying float vFragDepth;\n\tvarying float vIsPerspective;\n#endif",logdepthbuf_vertex:"#ifdef USE_LOGDEPTHBUF\n\tvFragDepth = 1.0 + gl_Position.w;\n\tvIsPerspective = float( isPerspectiveMatrix( projectionMatrix ) );\n#endif",map_fragment:"#ifdef USE_MAP\n\tvec4 sampledDiffuseColor = texture2D( map, vMapUv );\n\t#ifdef DECODE_VIDEO_TEXTURE\n\t\tsampledDiffuseColor = sRGBTransferEOTF( sampledDiffuseColor );\n\t#endif\n\tdiffuseColor *= sampledDiffuseColor;\n#endif",map_pars_fragment:"#ifdef USE_MAP\n\tuniform sampler2D map;\n#endif",map_particle_fragment:"#if defined( USE_MAP ) || defined( USE_ALPHAMAP )\n\t#if defined( USE_POINTS_UV )\n\t\tvec2 uv = vUv;\n\t#else\n\t\tvec2 uv = ( uvTransform * vec3( gl_PointCoord.x, 1.0 - gl_PointCoord.y, 1 ) ).xy;\n\t#endif\n#endif\n#ifdef USE_MAP\n\tdiffuseColor *= texture2D( map, uv );\n#endif\n#ifdef USE_ALPHAMAP\n\tdiffuseColor.a *= texture2D( alphaMap, uv ).g;\n#endif",map_particle_pars_fragment:"#if defined( USE_POINTS_UV )\n\tvarying vec2 vUv;\n#else\n\t#if defined( USE_MAP ) || defined( USE_ALPHAMAP )\n\t\tuniform mat3 uvTransform;\n\t#endif\n#endif\n#ifdef USE_MAP\n\tuniform sampler2D map;\n#endif\n#ifdef USE_ALPHAMAP\n\tuniform sampler2D alphaMap;\n#endif",metalnessmap_fragment:"float metalnessFactor = metalness;\n#ifdef USE_METALNESSMAP\n\tvec4 texelMetalness = texture2D( metalnessMap, vMetalnessMapUv );\n\tmetalnessFactor *= texelMetalness.b;\n#endif",metalnessmap_pars_fragment:"#ifdef USE_METALNESSMAP\n\tuniform sampler2D metalnessMap;\n#endif",morphinstance_vertex:"#ifdef USE_INSTANCING_MORPH\n\tfloat morphTargetInfluences[ MORPHTARGETS_COUNT ];\n\tfloat morphTargetBaseInfluence = texelFetch( morphTexture, ivec2( 0, gl_InstanceID ), 0 ).r;\n\tfor ( int i = 0; i < MORPHTARGETS_COUNT; i ++ ) {\n\t\tmorphTargetInfluences[i] =  texelFetch( morphTexture, ivec2( i + 1, gl_InstanceID ), 0 ).r;\n\t}\n#endif",morphcolor_vertex:"#if defined( USE_MORPHCOLORS )\n\tvColor *= morphTargetBaseInfluence;\n\tfor ( int i = 0; i < MORPHTARGETS_COUNT; i ++ ) {\n\t\t#if defined( USE_COLOR_ALPHA )\n\t\t\tif ( morphTargetInfluences[ i ] != 0.0 ) vColor += getMorph( gl_VertexID, i, 2 ) * morphTargetInfluences[ i ];\n\t\t#elif defined( USE_COLOR )\n\t\t\tif ( morphTargetInfluences[ i ] != 0.0 ) vColor += getMorph( gl_VertexID, i, 2 ).rgb * morphTargetInfluences[ i ];\n\t\t#endif\n\t}\n#endif",morphnormal_vertex:"#ifdef USE_MORPHNORMALS\n\tobjectNormal *= morphTargetBaseInfluence;\n\tfor ( int i = 0; i < MORPHTARGETS_COUNT; i ++ ) {\n\t\tif ( morphTargetInfluences[ i ] != 0.0 ) objectNormal += getMorph( gl_VertexID, i, 1 ).xyz * morphTargetInfluences[ i ];\n\t}\n#endif",morphtarget_pars_vertex:"#ifdef USE_MORPHTARGETS\n\t#ifndef USE_INSTANCING_MORPH\n\t\tuniform float morphTargetBaseInfluence;\n\t\tuniform float morphTargetInfluences[ MORPHTARGETS_COUNT ];\n\t#endif\n\tuniform sampler2DArray morphTargetsTexture;\n\tuniform ivec2 morphTargetsTextureSize;\n\tvec4 getMorph( const in int vertexIndex, const in int morphTargetIndex, const in int offset ) {\n\t\tint texelIndex = vertexIndex * MORPHTARGETS_TEXTURE_STRIDE + offset;\n\t\tint y = texelIndex / morphTargetsTextureSize.x;\n\t\tint x = texelIndex - y * morphTargetsTextureSize.x;\n\t\tivec3 morphUV = ivec3( x, y, morphTargetIndex );\n\t\treturn texelFetch( morphTargetsTexture, morphUV, 0 );\n\t}\n#endif",morphtarget_vertex:"#ifdef USE_MORPHTARGETS\n\ttransformed *= morphTargetBaseInfluence;\n\tfor ( int i = 0; i < MORPHTARGETS_COUNT; i ++ ) {\n\t\tif ( morphTargetInfluences[ i ] != 0.0 ) transformed += getMorph( gl_VertexID, i, 0 ).xyz * morphTargetInfluences[ i ];\n\t}\n#endif",normal_fragment_begin:"float faceDirection = gl_FrontFacing ? 1.0 : - 1.0;\n#ifdef FLAT_SHADED\n\tvec3 fdx = dFdx( vViewPosition );\n\tvec3 fdy = dFdy( vViewPosition );\n\tvec3 normal = normalize( cross( fdx, fdy ) );\n#else\n\tvec3 normal = normalize( vNormal );\n\t#ifdef DOUBLE_SIDED\n\t\tnormal *= faceDirection;\n\t#endif\n#endif\n#if defined( USE_NORMALMAP_TANGENTSPACE ) || defined( USE_CLEARCOAT_NORMALMAP ) || defined( USE_ANISOTROPY )\n\t#ifdef USE_TANGENT\n\t\tmat3 tbn = mat3( normalize( vTangent ), normalize( vBitangent ), normal );\n\t#else\n\t\tmat3 tbn = getTangentFrame( - vViewPosition, normal,\n\t\t#if defined( USE_NORMALMAP )\n\t\t\tvNormalMapUv\n\t\t#elif defined( USE_CLEARCOAT_NORMALMAP )\n\t\t\tvClearcoatNormalMapUv\n\t\t#else\n\t\t\tvUv\n\t\t#endif\n\t\t);\n\t#endif\n\t#if defined( DOUBLE_SIDED ) && ! defined( FLAT_SHADED )\n\t\ttbn[0] *= faceDirection;\n\t\ttbn[1] *= faceDirection;\n\t#endif\n#endif\n#ifdef USE_CLEARCOAT_NORMALMAP\n\t#ifdef USE_TANGENT\n\t\tmat3 tbn2 = mat3( normalize( vTangent ), normalize( vBitangent ), normal );\n\t#else\n\t\tmat3 tbn2 = getTangentFrame( - vViewPosition, normal, vClearcoatNormalMapUv );\n\t#endif\n\t#if defined( DOUBLE_SIDED ) && ! defined( FLAT_SHADED )\n\t\ttbn2[0] *= faceDirection;\n\t\ttbn2[1] *= faceDirection;\n\t#endif\n#endif\nvec3 nonPerturbedNormal = normal;",normal_fragment_maps:"#ifdef USE_NORMALMAP_OBJECTSPACE\n\tnormal = texture2D( normalMap, vNormalMapUv ).xyz * 2.0 - 1.0;\n\t#ifdef FLIP_SIDED\n\t\tnormal = - normal;\n\t#endif\n\t#ifdef DOUBLE_SIDED\n\t\tnormal = normal * faceDirection;\n\t#endif\n\tnormal = normalize( normalMatrix * normal );\n#elif defined( USE_NORMALMAP_TANGENTSPACE )\n\tvec3 mapN = texture2D( normalMap, vNormalMapUv ).xyz * 2.0 - 1.0;\n\tmapN.xy *= normalScale;\n\tnormal = normalize( tbn * mapN );\n#elif defined( USE_BUMPMAP )\n\tnormal = perturbNormalArb( - vViewPosition, normal, dHdxy_fwd(), faceDirection );\n#endif",normal_pars_fragment:"#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n\t#ifdef USE_TANGENT\n\t\tvarying vec3 vTangent;\n\t\tvarying vec3 vBitangent;\n\t#endif\n#endif",normal_pars_vertex:"#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n\t#ifdef USE_TANGENT\n\t\tvarying vec3 vTangent;\n\t\tvarying vec3 vBitangent;\n\t#endif\n#endif",normal_vertex:"#ifndef FLAT_SHADED\n\tvNormal = normalize( transformedNormal );\n\t#ifdef USE_TANGENT\n\t\tvTangent = normalize( transformedTangent );\n\t\tvBitangent = normalize( cross( vNormal, vTangent ) * tangent.w );\n\t#endif\n#endif",normalmap_pars_fragment:"#ifdef USE_NORMALMAP\n\tuniform sampler2D normalMap;\n\tuniform vec2 normalScale;\n#endif\n#ifdef USE_NORMALMAP_OBJECTSPACE\n\tuniform mat3 normalMatrix;\n#endif\n#if ! defined ( USE_TANGENT ) && ( defined ( USE_NORMALMAP_TANGENTSPACE ) || defined ( USE_CLEARCOAT_NORMALMAP ) || defined( USE_ANISOTROPY ) )\n\tmat3 getTangentFrame( vec3 eye_pos, vec3 surf_norm, vec2 uv ) {\n\t\tvec3 q0 = dFdx( eye_pos.xyz );\n\t\tvec3 q1 = dFdy( eye_pos.xyz );\n\t\tvec2 st0 = dFdx( uv.st );\n\t\tvec2 st1 = dFdy( uv.st );\n\t\tvec3 N = surf_norm;\n\t\tvec3 q1perp = cross( q1, N );\n\t\tvec3 q0perp = cross( N, q0 );\n\t\tvec3 T = q1perp * st0.x + q0perp * st1.x;\n\t\tvec3 B = q1perp * st0.y + q0perp * st1.y;\n\t\tfloat det = max( dot( T, T ), dot( B, B ) );\n\t\tfloat scale = ( det == 0.0 ) ? 0.0 : inversesqrt( det );\n\t\treturn mat3( T * scale, B * scale, N );\n\t}\n#endif",clearcoat_normal_fragment_begin:"#ifdef USE_CLEARCOAT\n\tvec3 clearcoatNormal = nonPerturbedNormal;\n#endif",clearcoat_normal_fragment_maps:"#ifdef USE_CLEARCOAT_NORMALMAP\n\tvec3 clearcoatMapN = texture2D( clearcoatNormalMap, vClearcoatNormalMapUv ).xyz * 2.0 - 1.0;\n\tclearcoatMapN.xy *= clearcoatNormalScale;\n\tclearcoatNormal = normalize( tbn2 * clearcoatMapN );\n#endif",clearcoat_pars_fragment:"#ifdef USE_CLEARCOATMAP\n\tuniform sampler2D clearcoatMap;\n#endif\n#ifdef USE_CLEARCOAT_NORMALMAP\n\tuniform sampler2D clearcoatNormalMap;\n\tuniform vec2 clearcoatNormalScale;\n#endif\n#ifdef USE_CLEARCOAT_ROUGHNESSMAP\n\tuniform sampler2D clearcoatRoughnessMap;\n#endif",iridescence_pars_fragment:"#ifdef USE_IRIDESCENCEMAP\n\tuniform sampler2D iridescenceMap;\n#endif\n#ifdef USE_IRIDESCENCE_THICKNESSMAP\n\tuniform sampler2D iridescenceThicknessMap;\n#endif",opaque_fragment:"#ifdef OPAQUE\ndiffuseColor.a = 1.0;\n#endif\n#ifdef USE_TRANSMISSION\ndiffuseColor.a *= material.transmissionAlpha;\n#endif\ngl_FragColor = vec4( outgoingLight, diffuseColor.a );",packing:"vec3 packNormalToRGB( const in vec3 normal ) {\n\treturn normalize( normal ) * 0.5 + 0.5;\n}\nvec3 unpackRGBToNormal( const in vec3 rgb ) {\n\treturn 2.0 * rgb.xyz - 1.0;\n}\nconst float PackUpscale = 256. / 255.;const float UnpackDownscale = 255. / 256.;const float ShiftRight8 = 1. / 256.;\nconst float Inv255 = 1. / 255.;\nconst vec4 PackFactors = vec4( 1.0, 256.0, 256.0 * 256.0, 256.0 * 256.0 * 256.0 );\nconst vec2 UnpackFactors2 = vec2( UnpackDownscale, 1.0 / PackFactors.g );\nconst vec3 UnpackFactors3 = vec3( UnpackDownscale / PackFactors.rg, 1.0 / PackFactors.b );\nconst vec4 UnpackFactors4 = vec4( UnpackDownscale / PackFactors.rgb, 1.0 / PackFactors.a );\nvec4 packDepthToRGBA( const in float v ) {\n\tif( v <= 0.0 )\n\t\treturn vec4( 0., 0., 0., 0. );\n\tif( v >= 1.0 )\n\t\treturn vec4( 1., 1., 1., 1. );\n\tfloat vuf;\n\tfloat af = modf( v * PackFactors.a, vuf );\n\tfloat bf = modf( vuf * ShiftRight8, vuf );\n\tfloat gf = modf( vuf * ShiftRight8, vuf );\n\treturn vec4( vuf * Inv255, gf * PackUpscale, bf * PackUpscale, af );\n}\nvec3 packDepthToRGB( const in float v ) {\n\tif( v <= 0.0 )\n\t\treturn vec3( 0., 0., 0. );\n\tif( v >= 1.0 )\n\t\treturn vec3( 1., 1., 1. );\n\tfloat vuf;\n\tfloat bf = modf( v * PackFactors.b, vuf );\n\tfloat gf = modf( vuf * ShiftRight8, vuf );\n\treturn vec3( vuf * Inv255, gf * PackUpscale, bf );\n}\nvec2 packDepthToRG( const in float v ) {\n\tif( v <= 0.0 )\n\t\treturn vec2( 0., 0. );\n\tif( v >= 1.0 )\n\t\treturn vec2( 1., 1. );\n\tfloat vuf;\n\tfloat gf = modf( v * 256., vuf );\n\treturn vec2( vuf * Inv255, gf );\n}\nfloat unpackRGBAToDepth( const in vec4 v ) {\n\treturn dot( v, UnpackFactors4 );\n}\nfloat unpackRGBToDepth( const in vec3 v ) {\n\treturn dot( v, UnpackFactors3 );\n}\nfloat unpackRGToDepth( const in vec2 v ) {\n\treturn v.r * UnpackFactors2.r + v.g * UnpackFactors2.g;\n}\nvec4 pack2HalfToRGBA( const in vec2 v ) {\n\tvec4 r = vec4( v.x, fract( v.x * 255.0 ), v.y, fract( v.y * 255.0 ) );\n\treturn vec4( r.x - r.y / 255.0, r.y, r.z - r.w / 255.0, r.w );\n}\nvec2 unpackRGBATo2Half( const in vec4 v ) {\n\treturn vec2( v.x + ( v.y / 255.0 ), v.z + ( v.w / 255.0 ) );\n}\nfloat viewZToOrthographicDepth( const in float viewZ, const in float near, const in float far ) {\n\treturn ( viewZ + near ) / ( near - far );\n}\nfloat orthographicDepthToViewZ( const in float depth, const in float near, const in float far ) {\n\treturn depth * ( near - far ) - near;\n}\nfloat viewZToPerspectiveDepth( const in float viewZ, const in float near, const in float far ) {\n\treturn ( ( near + viewZ ) * far ) / ( ( far - near ) * viewZ );\n}\nfloat perspectiveDepthToViewZ( const in float depth, const in float near, const in float far ) {\n\treturn ( near * far ) / ( ( far - near ) * depth - far );\n}",premultiplied_alpha_fragment:"#ifdef PREMULTIPLIED_ALPHA\n\tgl_FragColor.rgb *= gl_FragColor.a;\n#endif",project_vertex:"vec4 mvPosition = vec4( transformed, 1.0 );\n#ifdef USE_BATCHING\n\tmvPosition = batchingMatrix * mvPosition;\n#endif\n#ifdef USE_INSTANCING\n\tmvPosition = instanceMatrix * mvPosition;\n#endif\nmvPosition = modelViewMatrix * mvPosition;\ngl_Position = projectionMatrix * mvPosition;",dithering_fragment:"#ifdef DITHERING\n\tgl_FragColor.rgb = dithering( gl_FragColor.rgb );\n#endif",dithering_pars_fragment:"#ifdef DITHERING\n\tvec3 dithering( vec3 color ) {\n\t\tfloat grid_position = rand( gl_FragCoord.xy );\n\t\tvec3 dither_shift_RGB = vec3( 0.25 / 255.0, -0.25 / 255.0, 0.25 / 255.0 );\n\t\tdither_shift_RGB = mix( 2.0 * dither_shift_RGB, -2.0 * dither_shift_RGB, grid_position );\n\t\treturn color + dither_shift_RGB;\n\t}\n#endif",roughnessmap_fragment:"float roughnessFactor = roughness;\n#ifdef USE_ROUGHNESSMAP\n\tvec4 texelRoughness = texture2D( roughnessMap, vRoughnessMapUv );\n\troughnessFactor *= texelRoughness.g;\n#endif",roughnessmap_pars_fragment:"#ifdef USE_ROUGHNESSMAP\n\tuniform sampler2D roughnessMap;\n#endif",shadowmap_pars_fragment:"#if NUM_SPOT_LIGHT_COORDS > 0\n\tvarying vec4 vSpotLightCoord[ NUM_SPOT_LIGHT_COORDS ];\n#endif\n#if NUM_SPOT_LIGHT_MAPS > 0\n\tuniform sampler2D spotLightMap[ NUM_SPOT_LIGHT_MAPS ];\n#endif\n#ifdef USE_SHADOWMAP\n\t#if NUM_DIR_LIGHT_SHADOWS > 0\n\t\tuniform sampler2D directionalShadowMap[ NUM_DIR_LIGHT_SHADOWS ];\n\t\tvarying vec4 vDirectionalShadowCoord[ NUM_DIR_LIGHT_SHADOWS ];\n\t\tstruct DirectionalLightShadow {\n\t\t\tfloat shadowIntensity;\n\t\t\tfloat shadowBias;\n\t\t\tfloat shadowNormalBias;\n\t\t\tfloat shadowRadius;\n\t\t\tvec2 shadowMapSize;\n\t\t};\n\t\tuniform DirectionalLightShadow directionalLightShadows[ NUM_DIR_LIGHT_SHADOWS ];\n\t#endif\n\t#if NUM_SPOT_LIGHT_SHADOWS > 0\n\t\tuniform sampler2D spotShadowMap[ NUM_SPOT_LIGHT_SHADOWS ];\n\t\tstruct SpotLightShadow {\n\t\t\tfloat shadowIntensity;\n\t\t\tfloat shadowBias;\n\t\t\tfloat shadowNormalBias;\n\t\t\tfloat shadowRadius;\n\t\t\tvec2 shadowMapSize;\n\t\t};\n\t\tuniform SpotLightShadow spotLightShadows[ NUM_SPOT_LIGHT_SHADOWS ];\n\t#endif\n\t#if NUM_POINT_LIGHT_SHADOWS > 0\n\t\tuniform sampler2D pointShadowMap[ NUM_POINT_LIGHT_SHADOWS ];\n\t\tvarying vec4 vPointShadowCoord[ NUM_POINT_LIGHT_SHADOWS ];\n\t\tstruct PointLightShadow {\n\t\t\tfloat shadowIntensity;\n\t\t\tfloat shadowBias;\n\t\t\tfloat shadowNormalBias;\n\t\t\tfloat shadowRadius;\n\t\t\tvec2 shadowMapSize;\n\t\t\tfloat shadowCameraNear;\n\t\t\tfloat shadowCameraFar;\n\t\t};\n\t\tuniform PointLightShadow pointLightShadows[ NUM_POINT_LIGHT_SHADOWS ];\n\t#endif\n\tfloat texture2DCompare( sampler2D depths, vec2 uv, float compare ) {\n\t\treturn step( compare, unpackRGBAToDepth( texture2D( depths, uv ) ) );\n\t}\n\tvec2 texture2DDistribution( sampler2D shadow, vec2 uv ) {\n\t\treturn unpackRGBATo2Half( texture2D( shadow, uv ) );\n\t}\n\tfloat VSMShadow (sampler2D shadow, vec2 uv, float compare ){\n\t\tfloat occlusion = 1.0;\n\t\tvec2 distribution = texture2DDistribution( shadow, uv );\n\t\tfloat hard_shadow = step( compare , distribution.x );\n\t\tif (hard_shadow != 1.0 ) {\n\t\t\tfloat distance = compare - distribution.x ;\n\t\t\tfloat variance = max( 0.00000, distribution.y * distribution.y );\n\t\t\tfloat softness_probability = variance / (variance + distance * distance );\t\t\tsoftness_probability = clamp( ( softness_probability - 0.3 ) / ( 0.95 - 0.3 ), 0.0, 1.0 );\t\t\tocclusion = clamp( max( hard_shadow, softness_probability ), 0.0, 1.0 );\n\t\t}\n\t\treturn occlusion;\n\t}\n\tfloat getShadow( sampler2D shadowMap, vec2 shadowMapSize, float shadowIntensity, float shadowBias, float shadowRadius, vec4 shadowCoord ) {\n\t\tfloat shadow = 1.0;\n\t\tshadowCoord.xyz /= shadowCoord.w;\n\t\tshadowCoord.z += shadowBias;\n\t\tbool inFrustum = shadowCoord.x >= 0.0 && shadowCoord.x <= 1.0 && shadowCoord.y >= 0.0 && shadowCoord.y <= 1.0;\n\t\tbool frustumTest = inFrustum && shadowCoord.z <= 1.0;\n\t\tif ( frustumTest ) {\n\t\t#if defined( SHADOWMAP_TYPE_PCF )\n\t\t\tvec2 texelSize = vec2( 1.0 ) / shadowMapSize;\n\t\t\tfloat dx0 = - texelSize.x * shadowRadius;\n\t\t\tfloat dy0 = - texelSize.y * shadowRadius;\n\t\t\tfloat dx1 = + texelSize.x * shadowRadius;\n\t\t\tfloat dy1 = + texelSize.y * shadowRadius;\n\t\t\tfloat dx2 = dx0 / 2.0;\n\t\t\tfloat dy2 = dy0 / 2.0;\n\t\t\tfloat dx3 = dx1 / 2.0;\n\t\t\tfloat dy3 = dy1 / 2.0;\n\t\t\tshadow = (\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx0, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( 0.0, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx1, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx2, dy2 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( 0.0, dy2 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx3, dy2 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx0, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx2, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy, shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx3, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx1, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx2, dy3 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( 0.0, dy3 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx3, dy3 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx0, dy1 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( 0.0, dy1 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx1, dy1 ), shadowCoord.z )\n\t\t\t) * ( 1.0 / 17.0 );\n\t\t#elif defined( SHADOWMAP_TYPE_PCF_SOFT )\n\t\t\tvec2 texelSize = vec2( 1.0 ) / shadowMapSize;\n\t\t\tfloat dx = texelSize.x;\n\t\t\tfloat dy = texelSize.y;\n\t\t\tvec2 uv = shadowCoord.xy;\n\t\t\tvec2 f = fract( uv * shadowMapSize + 0.5 );\n\t\t\tuv -= f * texelSize;\n\t\t\tshadow = (\n\t\t\t\ttexture2DCompare( shadowMap, uv, shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, uv + vec2( dx, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, uv + vec2( 0.0, dy ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, uv + texelSize, shadowCoord.z ) +\n\t\t\t\tmix( texture2DCompare( shadowMap, uv + vec2( -dx, 0.0 ), shadowCoord.z ),\n\t\t\t\t\t texture2DCompare( shadowMap, uv + vec2( 2.0 * dx, 0.0 ), shadowCoord.z ),\n\t\t\t\t\t f.x ) +\n\t\t\t\tmix( texture2DCompare( shadowMap, uv + vec2( -dx, dy ), shadowCoord.z ),\n\t\t\t\t\t texture2DCompare( shadowMap, uv + vec2( 2.0 * dx, dy ), shadowCoord.z ),\n\t\t\t\t\t f.x ) +\n\t\t\t\tmix( texture2DCompare( shadowMap, uv + vec2( 0.0, -dy ), shadowCoord.z ),\n\t\t\t\t\t texture2DCompare( shadowMap, uv + vec2( 0.0, 2.0 * dy ), shadowCoord.z ),\n\t\t\t\t\t f.y ) +\n\t\t\t\tmix( texture2DCompare( shadowMap, uv + vec2( dx, -dy ), shadowCoord.z ),\n\t\t\t\t\t texture2DCompare( shadowMap, uv + vec2( dx, 2.0 * dy ), shadowCoord.z ),\n\t\t\t\t\t f.y ) +\n\t\t\t\tmix( mix( texture2DCompare( shadowMap, uv + vec2( -dx, -dy ), shadowCoord.z ),\n\t\t\t\t\t\t  texture2DCompare( shadowMap, uv + vec2( 2.0 * dx, -dy ), shadowCoord.z ),\n\t\t\t\t\t\t  f.x ),\n\t\t\t\t\t mix( texture2DCompare( shadowMap, uv + vec2( -dx, 2.0 * dy ), shadowCoord.z ),\n\t\t\t\t\t\t  texture2DCompare( shadowMap, uv + vec2( 2.0 * dx, 2.0 * dy ), shadowCoord.z ),\n\t\t\t\t\t\t  f.x ),\n\t\t\t\t\t f.y )\n\t\t\t) * ( 1.0 / 9.0 );\n\t\t#elif defined( SHADOWMAP_TYPE_VSM )\n\t\t\tshadow = VSMShadow( shadowMap, shadowCoord.xy, shadowCoord.z );\n\t\t#else\n\t\t\tshadow = texture2DCompare( shadowMap, shadowCoord.xy, shadowCoord.z );\n\t\t#endif\n\t\t}\n\t\treturn mix( 1.0, shadow, shadowIntensity );\n\t}\n\tvec2 cubeToUV( vec3 v, float texelSizeY ) {\n\t\tvec3 absV = abs( v );\n\t\tfloat scaleToCube = 1.0 / max( absV.x, max( absV.y, absV.z ) );\n\t\tabsV *= scaleToCube;\n\t\tv *= scaleToCube * ( 1.0 - 2.0 * texelSizeY );\n\t\tvec2 planar = v.xy;\n\t\tfloat almostATexel = 1.5 * texelSizeY;\n\t\tfloat almostOne = 1.0 - almostATexel;\n\t\tif ( absV.z >= almostOne ) {\n\t\t\tif ( v.z > 0.0 )\n\t\t\t\tplanar.x = 4.0 - v.x;\n\t\t} else if ( absV.x >= almostOne ) {\n\t\t\tfloat signX = sign( v.x );\n\t\t\tplanar.x = v.z * signX + 2.0 * signX;\n\t\t} else if ( absV.y >= almostOne ) {\n\t\t\tfloat signY = sign( v.y );\n\t\t\tplanar.x = v.x + 2.0 * signY + 2.0;\n\t\t\tplanar.y = v.z * signY - 2.0;\n\t\t}\n\t\treturn vec2( 0.125, 0.25 ) * planar + vec2( 0.375, 0.75 );\n\t}\n\tfloat getPointShadow( sampler2D shadowMap, vec2 shadowMapSize, float shadowIntensity, float shadowBias, float shadowRadius, vec4 shadowCoord, float shadowCameraNear, float shadowCameraFar ) {\n\t\tfloat shadow = 1.0;\n\t\tvec3 lightToPosition = shadowCoord.xyz;\n\t\t\n\t\tfloat lightToPositionLength = length( lightToPosition );\n\t\tif ( lightToPositionLength - shadowCameraFar <= 0.0 && lightToPositionLength - shadowCameraNear >= 0.0 ) {\n\t\t\tfloat dp = ( lightToPositionLength - shadowCameraNear ) / ( shadowCameraFar - shadowCameraNear );\t\t\tdp += shadowBias;\n\t\t\tvec3 bd3D = normalize( lightToPosition );\n\t\t\tvec2 texelSize = vec2( 1.0 ) / ( shadowMapSize * vec2( 4.0, 2.0 ) );\n\t\t\t#if defined( SHADOWMAP_TYPE_PCF ) || defined( SHADOWMAP_TYPE_PCF_SOFT ) || defined( SHADOWMAP_TYPE_VSM )\n\t\t\t\tvec2 offset = vec2( - 1, 1 ) * shadowRadius * texelSize.y;\n\t\t\t\tshadow = (\n\t\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xyy, texelSize.y ), dp ) +\n\t\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yyy, texelSize.y ), dp ) +\n\t\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xyx, texelSize.y ), dp ) +\n\t\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yyx, texelSize.y ), dp ) +\n\t\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D, texelSize.y ), dp ) +\n\t\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xxy, texelSize.y ), dp ) +\n\t\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yxy, texelSize.y ), dp ) +\n\t\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xxx, texelSize.y ), dp ) +\n\t\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yxx, texelSize.y ), dp )\n\t\t\t\t) * ( 1.0 / 9.0 );\n\t\t\t#else\n\t\t\t\tshadow = texture2DCompare( shadowMap, cubeToUV( bd3D, texelSize.y ), dp );\n\t\t\t#endif\n\t\t}\n\t\treturn mix( 1.0, shadow, shadowIntensity );\n\t}\n#endif",shadowmap_pars_vertex:"#if NUM_SPOT_LIGHT_COORDS > 0\n\tuniform mat4 spotLightMatrix[ NUM_SPOT_LIGHT_COORDS ];\n\tvarying vec4 vSpotLightCoord[ NUM_SPOT_LIGHT_COORDS ];\n#endif\n#ifdef USE_SHADOWMAP\n\t#if NUM_DIR_LIGHT_SHADOWS > 0\n\t\tuniform mat4 directionalShadowMatrix[ NUM_DIR_LIGHT_SHADOWS ];\n\t\tvarying vec4 vDirectionalShadowCoord[ NUM_DIR_LIGHT_SHADOWS ];\n\t\tstruct DirectionalLightShadow {\n\t\t\tfloat shadowIntensity;\n\t\t\tfloat shadowBias;\n\t\t\tfloat shadowNormalBias;\n\t\t\tfloat shadowRadius;\n\t\t\tvec2 shadowMapSize;\n\t\t};\n\t\tuniform DirectionalLightShadow directionalLightShadows[ NUM_DIR_LIGHT_SHADOWS ];\n\t#endif\n\t#if NUM_SPOT_LIGHT_SHADOWS > 0\n\t\tstruct SpotLightShadow {\n\t\t\tfloat shadowIntensity;\n\t\t\tfloat shadowBias;\n\t\t\tfloat shadowNormalBias;\n\t\t\tfloat shadowRadius;\n\t\t\tvec2 shadowMapSize;\n\t\t};\n\t\tuniform SpotLightShadow spotLightShadows[ NUM_SPOT_LIGHT_SHADOWS ];\n\t#endif\n\t#if NUM_POINT_LIGHT_SHADOWS > 0\n\t\tuniform mat4 pointShadowMatrix[ NUM_POINT_LIGHT_SHADOWS ];\n\t\tvarying vec4 vPointShadowCoord[ NUM_POINT_LIGHT_SHADOWS ];\n\t\tstruct PointLightShadow {\n\t\t\tfloat shadowIntensity;\n\t\t\tfloat shadowBias;\n\t\t\tfloat shadowNormalBias;\n\t\t\tfloat shadowRadius;\n\t\t\tvec2 shadowMapSize;\n\t\t\tfloat shadowCameraNear;\n\t\t\tfloat shadowCameraFar;\n\t\t};\n\t\tuniform PointLightShadow pointLightShadows[ NUM_POINT_LIGHT_SHADOWS ];\n\t#endif\n#endif",shadowmap_vertex:"#if ( defined( USE_SHADOWMAP ) && ( NUM_DIR_LIGHT_SHADOWS > 0 || NUM_POINT_LIGHT_SHADOWS > 0 ) ) || ( NUM_SPOT_LIGHT_COORDS > 0 )\n\tvec3 shadowWorldNormal = inverseTransformDirection( transformedNormal, viewMatrix );\n\tvec4 shadowWorldPosition;\n#endif\n#if defined( USE_SHADOWMAP )\n\t#if NUM_DIR_LIGHT_SHADOWS > 0\n\t\t#pragma unroll_loop_start\n\t\tfor ( int i = 0; i < NUM_DIR_LIGHT_SHADOWS; i ++ ) {\n\t\t\tshadowWorldPosition = worldPosition + vec4( shadowWorldNormal * directionalLightShadows[ i ].shadowNormalBias, 0 );\n\t\t\tvDirectionalShadowCoord[ i ] = directionalShadowMatrix[ i ] * shadowWorldPosition;\n\t\t}\n\t\t#pragma unroll_loop_end\n\t#endif\n\t#if NUM_POINT_LIGHT_SHADOWS > 0\n\t\t#pragma unroll_loop_start\n\t\tfor ( int i = 0; i < NUM_POINT_LIGHT_SHADOWS; i ++ ) {\n\t\t\tshadowWorldPosition = worldPosition + vec4( shadowWorldNormal * pointLightShadows[ i ].shadowNormalBias, 0 );\n\t\t\tvPointShadowCoord[ i ] = pointShadowMatrix[ i ] * shadowWorldPosition;\n\t\t}\n\t\t#pragma unroll_loop_end\n\t#endif\n#endif\n#if NUM_SPOT_LIGHT_COORDS > 0\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_SPOT_LIGHT_COORDS; i ++ ) {\n\t\tshadowWorldPosition = worldPosition;\n\t\t#if ( defined( USE_SHADOWMAP ) && UNROLLED_LOOP_INDEX < NUM_SPOT_LIGHT_SHADOWS )\n\t\t\tshadowWorldPosition.xyz += shadowWorldNormal * spotLightShadows[ i ].shadowNormalBias;\n\t\t#endif\n\t\tvSpotLightCoord[ i ] = spotLightMatrix[ i ] * shadowWorldPosition;\n\t}\n\t#pragma unroll_loop_end\n#endif",shadowmask_pars_fragment:"float getShadowMask() {\n\tfloat shadow = 1.0;\n\t#ifdef USE_SHADOWMAP\n\t#if NUM_DIR_LIGHT_SHADOWS > 0\n\tDirectionalLightShadow directionalLight;\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_DIR_LIGHT_SHADOWS; i ++ ) {\n\t\tdirectionalLight = directionalLightShadows[ i ];\n\t\tshadow *= receiveShadow ? getShadow( directionalShadowMap[ i ], directionalLight.shadowMapSize, directionalLight.shadowIntensity, directionalLight.shadowBias, directionalLight.shadowRadius, vDirectionalShadowCoord[ i ] ) : 1.0;\n\t}\n\t#pragma unroll_loop_end\n\t#endif\n\t#if NUM_SPOT_LIGHT_SHADOWS > 0\n\tSpotLightShadow spotLight;\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_SPOT_LIGHT_SHADOWS; i ++ ) {\n\t\tspotLight = spotLightShadows[ i ];\n\t\tshadow *= receiveShadow ? getShadow( spotShadowMap[ i ], spotLight.shadowMapSize, spotLight.shadowIntensity, spotLight.shadowBias, spotLight.shadowRadius, vSpotLightCoord[ i ] ) : 1.0;\n\t}\n\t#pragma unroll_loop_end\n\t#endif\n\t#if NUM_POINT_LIGHT_SHADOWS > 0\n\tPointLightShadow pointLight;\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_POINT_LIGHT_SHADOWS; i ++ ) {\n\t\tpointLight = pointLightShadows[ i ];\n\t\tshadow *= receiveShadow ? getPointShadow( pointShadowMap[ i ], pointLight.shadowMapSize, pointLight.shadowIntensity, pointLight.shadowBias, pointLight.shadowRadius, vPointShadowCoord[ i ], pointLight.shadowCameraNear, pointLight.shadowCameraFar ) : 1.0;\n\t}\n\t#pragma unroll_loop_end\n\t#endif\n\t#endif\n\treturn shadow;\n}",skinbase_vertex:"#ifdef USE_SKINNING\n\tmat4 boneMatX = getBoneMatrix( skinIndex.x );\n\tmat4 boneMatY = getBoneMatrix( skinIndex.y );\n\tmat4 boneMatZ = getBoneMatrix( skinIndex.z );\n\tmat4 boneMatW = getBoneMatrix( skinIndex.w );\n#endif",skinning_pars_vertex:"#ifdef USE_SKINNING\n\tuniform mat4 bindMatrix;\n\tuniform mat4 bindMatrixInverse;\n\tuniform highp sampler2D boneTexture;\n\tmat4 getBoneMatrix( const in float i ) {\n\t\tint size = textureSize( boneTexture, 0 ).x;\n\t\tint j = int( i ) * 4;\n\t\tint x = j % size;\n\t\tint y = j / size;\n\t\tvec4 v1 = texelFetch( boneTexture, ivec2( x, y ), 0 );\n\t\tvec4 v2 = texelFetch( boneTexture, ivec2( x + 1, y ), 0 );\n\t\tvec4 v3 = texelFetch( boneTexture, ivec2( x + 2, y ), 0 );\n\t\tvec4 v4 = texelFetch( boneTexture, ivec2( x + 3, y ), 0 );\n\t\treturn mat4( v1, v2, v3, v4 );\n\t}\n#endif",skinning_vertex:"#ifdef USE_SKINNING\n\tvec4 skinVertex = bindMatrix * vec4( transformed, 1.0 );\n\tvec4 skinned = vec4( 0.0 );\n\tskinned += boneMatX * skinVertex * skinWeight.x;\n\tskinned += boneMatY * skinVertex * skinWeight.y;\n\tskinned += boneMatZ * skinVertex * skinWeight.z;\n\tskinned += boneMatW * skinVertex * skinWeight.w;\n\ttransformed = ( bindMatrixInverse * skinned ).xyz;\n#endif",skinnormal_vertex:"#ifdef USE_SKINNING\n\tmat4 skinMatrix = mat4( 0.0 );\n\tskinMatrix += skinWeight.x * boneMatX;\n\tskinMatrix += skinWeight.y * boneMatY;\n\tskinMatrix += skinWeight.z * boneMatZ;\n\tskinMatrix += skinWeight.w * boneMatW;\n\tskinMatrix = bindMatrixInverse * skinMatrix * bindMatrix;\n\tobjectNormal = vec4( skinMatrix * vec4( objectNormal, 0.0 ) ).xyz;\n\t#ifdef USE_TANGENT\n\t\tobjectTangent = vec4( skinMatrix * vec4( objectTangent, 0.0 ) ).xyz;\n\t#endif\n#endif",specularmap_fragment:"float specularStrength;\n#ifdef USE_SPECULARMAP\n\tvec4 texelSpecular = texture2D( specularMap, vSpecularMapUv );\n\tspecularStrength = texelSpecular.r;\n#else\n\tspecularStrength = 1.0;\n#endif",specularmap_pars_fragment:"#ifdef USE_SPECULARMAP\n\tuniform sampler2D specularMap;\n#endif",tonemapping_fragment:"#if defined( TONE_MAPPING )\n\tgl_FragColor.rgb = toneMapping( gl_FragColor.rgb );\n#endif",tonemapping_pars_fragment:"#ifndef saturate\n#define saturate( a ) clamp( a, 0.0, 1.0 )\n#endif\nuniform float toneMappingExposure;\nvec3 LinearToneMapping( vec3 color ) {\n\treturn saturate( toneMappingExposure * color );\n}\nvec3 ReinhardToneMapping( vec3 color ) {\n\tcolor *= toneMappingExposure;\n\treturn saturate( color / ( vec3( 1.0 ) + color ) );\n}\nvec3 CineonToneMapping( vec3 color ) {\n\tcolor *= toneMappingExposure;\n\tcolor = max( vec3( 0.0 ), color - 0.004 );\n\treturn pow( ( color * ( 6.2 * color + 0.5 ) ) / ( color * ( 6.2 * color + 1.7 ) + 0.06 ), vec3( 2.2 ) );\n}\nvec3 RRTAndODTFit( vec3 v ) {\n\tvec3 a = v * ( v + 0.0245786 ) - 0.000090537;\n\tvec3 b = v * ( 0.983729 * v + 0.4329510 ) + 0.238081;\n\treturn a / b;\n}\nvec3 ACESFilmicToneMapping( vec3 color ) {\n\tconst mat3 ACESInputMat = mat3(\n\t\tvec3( 0.59719, 0.07600, 0.02840 ),\t\tvec3( 0.35458, 0.90834, 0.13383 ),\n\t\tvec3( 0.04823, 0.01566, 0.83777 )\n\t);\n\tconst mat3 ACESOutputMat = mat3(\n\t\tvec3(  1.60475, -0.10208, -0.00327 ),\t\tvec3( -0.53108,  1.10813, -0.07276 ),\n\t\tvec3( -0.07367, -0.00605,  1.07602 )\n\t);\n\tcolor *= toneMappingExposure / 0.6;\n\tcolor = ACESInputMat * color;\n\tcolor = RRTAndODTFit( color );\n\tcolor = ACESOutputMat * color;\n\treturn saturate( color );\n}\nconst mat3 LINEAR_REC2020_TO_LINEAR_SRGB = mat3(\n\tvec3( 1.6605, - 0.1246, - 0.0182 ),\n\tvec3( - 0.5876, 1.1329, - 0.1006 ),\n\tvec3( - 0.0728, - 0.0083, 1.1187 )\n);\nconst mat3 LINEAR_SRGB_TO_LINEAR_REC2020 = mat3(\n\tvec3( 0.6274, 0.0691, 0.0164 ),\n\tvec3( 0.3293, 0.9195, 0.0880 ),\n\tvec3( 0.0433, 0.0113, 0.8956 )\n);\nvec3 agxDefaultContrastApprox( vec3 x ) {\n\tvec3 x2 = x * x;\n\tvec3 x4 = x2 * x2;\n\treturn + 15.5 * x4 * x2\n\t\t- 40.14 * x4 * x\n\t\t+ 31.96 * x4\n\t\t- 6.868 * x2 * x\n\t\t+ 0.4298 * x2\n\t\t+ 0.1191 * x\n\t\t- 0.00232;\n}\nvec3 AgXToneMapping( vec3 color ) {\n\tconst mat3 AgXInsetMatrix = mat3(\n\t\tvec3( 0.856627153315983, 0.137318972929847, 0.11189821299995 ),\n\t\tvec3( 0.0951212405381588, 0.761241990602591, 0.0767994186031903 ),\n\t\tvec3( 0.0482516061458583, 0.101439036467562, 0.811302368396859 )\n\t);\n\tconst mat3 AgXOutsetMatrix = mat3(\n\t\tvec3( 1.1271005818144368, - 0.1413297634984383, - 0.14132976349843826 ),\n\t\tvec3( - 0.11060664309660323, 1.157823702216272, - 0.11060664309660294 ),\n\t\tvec3( - 0.016493938717834573, - 0.016493938717834257, 1.2519364065950405 )\n\t);\n\tconst float AgxMinEv = - 12.47393;\tconst float AgxMaxEv = 4.026069;\n\tcolor *= toneMappingExposure;\n\tcolor = LINEAR_SRGB_TO_LINEAR_REC2020 * color;\n\tcolor = AgXInsetMatrix * color;\n\tcolor = max( color, 1e-10 );\tcolor = log2( color );\n\tcolor = ( color - AgxMinEv ) / ( AgxMaxEv - AgxMinEv );\n\tcolor = clamp( color, 0.0, 1.0 );\n\tcolor = agxDefaultContrastApprox( color );\n\tcolor = AgXOutsetMatrix * color;\n\tcolor = pow( max( vec3( 0.0 ), color ), vec3( 2.2 ) );\n\tcolor = LINEAR_REC2020_TO_LINEAR_SRGB * color;\n\tcolor = clamp( color, 0.0, 1.0 );\n\treturn color;\n}\nvec3 NeutralToneMapping( vec3 color ) {\n\tconst float StartCompression = 0.8 - 0.04;\n\tconst float Desaturation = 0.15;\n\tcolor *= toneMappingExposure;\n\tfloat x = min( color.r, min( color.g, color.b ) );\n\tfloat offset = x < 0.08 ? x - 6.25 * x * x : 0.04;\n\tcolor -= offset;\n\tfloat peak = max( color.r, max( color.g, color.b ) );\n\tif ( peak < StartCompression ) return color;\n\tfloat d = 1. - StartCompression;\n\tfloat newPeak = 1. - d * d / ( peak + d - StartCompression );\n\tcolor *= newPeak / peak;\n\tfloat g = 1. - 1. / ( Desaturation * ( peak - newPeak ) + 1. );\n\treturn mix( color, vec3( newPeak ), g );\n}\nvec3 CustomToneMapping( vec3 color ) { return color; }",transmission_fragment:"#ifdef USE_TRANSMISSION\n\tmaterial.transmission = transmission;\n\tmaterial.transmissionAlpha = 1.0;\n\tmaterial.thickness = thickness;\n\tmaterial.attenuationDistance = attenuationDistance;\n\tmaterial.attenuationColor = attenuationColor;\n\t#ifdef USE_TRANSMISSIONMAP\n\t\tmaterial.transmission *= texture2D( transmissionMap, vTransmissionMapUv ).r;\n\t#endif\n\t#ifdef USE_THICKNESSMAP\n\t\tmaterial.thickness *= texture2D( thicknessMap, vThicknessMapUv ).g;\n\t#endif\n\tvec3 pos = vWorldPosition;\n\tvec3 v = normalize( cameraPosition - pos );\n\tvec3 n = inverseTransformDirection( normal, viewMatrix );\n\tvec4 transmitted = getIBLVolumeRefraction(\n\t\tn, v, material.roughness, material.diffuseColor, material.specularColor, material.specularF90,\n\t\tpos, modelMatrix, viewMatrix, projectionMatrix, material.dispersion, material.ior, material.thickness,\n\t\tmaterial.attenuationColor, material.attenuationDistance );\n\tmaterial.transmissionAlpha = mix( material.transmissionAlpha, transmitted.a, material.transmission );\n\ttotalDiffuse = mix( totalDiffuse, transmitted.rgb, material.transmission );\n#endif",transmission_pars_fragment:"#ifdef USE_TRANSMISSION\n\tuniform float transmission;\n\tuniform float thickness;\n\tuniform float attenuationDistance;\n\tuniform vec3 attenuationColor;\n\t#ifdef USE_TRANSMISSIONMAP\n\t\tuniform sampler2D transmissionMap;\n\t#endif\n\t#ifdef USE_THICKNESSMAP\n\t\tuniform sampler2D thicknessMap;\n\t#endif\n\tuniform vec2 transmissionSamplerSize;\n\tuniform sampler2D transmissionSamplerMap;\n\tuniform mat4 modelMatrix;\n\tuniform mat4 projectionMatrix;\n\tvarying vec3 vWorldPosition;\n\tfloat w0( float a ) {\n\t\treturn ( 1.0 / 6.0 ) * ( a * ( a * ( - a + 3.0 ) - 3.0 ) + 1.0 );\n\t}\n\tfloat w1( float a ) {\n\t\treturn ( 1.0 / 6.0 ) * ( a *  a * ( 3.0 * a - 6.0 ) + 4.0 );\n\t}\n\tfloat w2( float a ){\n\t\treturn ( 1.0 / 6.0 ) * ( a * ( a * ( - 3.0 * a + 3.0 ) + 3.0 ) + 1.0 );\n\t}\n\tfloat w3( float a ) {\n\t\treturn ( 1.0 / 6.0 ) * ( a * a * a );\n\t}\n\tfloat g0( float a ) {\n\t\treturn w0( a ) + w1( a );\n\t}\n\tfloat g1( float a ) {\n\t\treturn w2( a ) + w3( a );\n\t}\n\tfloat h0( float a ) {\n\t\treturn - 1.0 + w1( a ) / ( w0( a ) + w1( a ) );\n\t}\n\tfloat h1( float a ) {\n\t\treturn 1.0 + w3( a ) / ( w2( a ) + w3( a ) );\n\t}\n\tvec4 bicubic( sampler2D tex, vec2 uv, vec4 texelSize, float lod ) {\n\t\tuv = uv * texelSize.zw + 0.5;\n\t\tvec2 iuv = floor( uv );\n\t\tvec2 fuv = fract( uv );\n\t\tfloat g0x = g0( fuv.x );\n\t\tfloat g1x = g1( fuv.x );\n\t\tfloat h0x = h0( fuv.x );\n\t\tfloat h1x = h1( fuv.x );\n\t\tfloat h0y = h0( fuv.y );\n\t\tfloat h1y = h1( fuv.y );\n\t\tvec2 p0 = ( vec2( iuv.x + h0x, iuv.y + h0y ) - 0.5 ) * texelSize.xy;\n\t\tvec2 p1 = ( vec2( iuv.x + h1x, iuv.y + h0y ) - 0.5 ) * texelSize.xy;\n\t\tvec2 p2 = ( vec2( iuv.x + h0x, iuv.y + h1y ) - 0.5 ) * texelSize.xy;\n\t\tvec2 p3 = ( vec2( iuv.x + h1x, iuv.y + h1y ) - 0.5 ) * texelSize.xy;\n\t\treturn g0( fuv.y ) * ( g0x * textureLod( tex, p0, lod ) + g1x * textureLod( tex, p1, lod ) ) +\n\t\t\tg1( fuv.y ) * ( g0x * textureLod( tex, p2, lod ) + g1x * textureLod( tex, p3, lod ) );\n\t}\n\tvec4 textureBicubic( sampler2D sampler, vec2 uv, float lod ) {\n\t\tvec2 fLodSize = vec2( textureSize( sampler, int( lod ) ) );\n\t\tvec2 cLodSize = vec2( textureSize( sampler, int( lod + 1.0 ) ) );\n\t\tvec2 fLodSizeInv = 1.0 / fLodSize;\n\t\tvec2 cLodSizeInv = 1.0 / cLodSize;\n\t\tvec4 fSample = bicubic( sampler, uv, vec4( fLodSizeInv, fLodSize ), floor( lod ) );\n\t\tvec4 cSample = bicubic( sampler, uv, vec4( cLodSizeInv, cLodSize ), ceil( lod ) );\n\t\treturn mix( fSample, cSample, fract( lod ) );\n\t}\n\tvec3 getVolumeTransmissionRay( const in vec3 n, const in vec3 v, const in float thickness, const in float ior, const in mat4 modelMatrix ) {\n\t\tvec3 refractionVector = refract( - v, normalize( n ), 1.0 / ior );\n\t\tvec3 modelScale;\n\t\tmodelScale.x = length( vec3( modelMatrix[ 0 ].xyz ) );\n\t\tmodelScale.y = length( vec3( modelMatrix[ 1 ].xyz ) );\n\t\tmodelScale.z = length( vec3( modelMatrix[ 2 ].xyz ) );\n\t\treturn normalize( refractionVector ) * thickness * modelScale;\n\t}\n\tfloat applyIorToRoughness( const in float roughness, const in float ior ) {\n\t\treturn roughness * clamp( ior * 2.0 - 2.0, 0.0, 1.0 );\n\t}\n\tvec4 getTransmissionSample( const in vec2 fragCoord, const in float roughness, const in float ior ) {\n\t\tfloat lod = log2( transmissionSamplerSize.x ) * applyIorToRoughness( roughness, ior );\n\t\treturn textureBicubic( transmissionSamplerMap, fragCoord.xy, lod );\n\t}\n\tvec3 volumeAttenuation( const in float transmissionDistance, const in vec3 attenuationColor, const in float attenuationDistance ) {\n\t\tif ( isinf( attenuationDistance ) ) {\n\t\t\treturn vec3( 1.0 );\n\t\t} else {\n\t\t\tvec3 attenuationCoefficient = -log( attenuationColor ) / attenuationDistance;\n\t\t\tvec3 transmittance = exp( - attenuationCoefficient * transmissionDistance );\t\t\treturn transmittance;\n\t\t}\n\t}\n\tvec4 getIBLVolumeRefraction( const in vec3 n, const in vec3 v, const in float roughness, const in vec3 diffuseColor,\n\t\tconst in vec3 specularColor, const in float specularF90, const in vec3 position, const in mat4 modelMatrix,\n\t\tconst in mat4 viewMatrix, const in mat4 projMatrix, const in float dispersion, const in float ior, const in float thickness,\n\t\tconst in vec3 attenuationColor, const in float attenuationDistance ) {\n\t\tvec4 transmittedLight;\n\t\tvec3 transmittance;\n\t\t#ifdef USE_DISPERSION\n\t\t\tfloat halfSpread = ( ior - 1.0 ) * 0.025 * dispersion;\n\t\t\tvec3 iors = vec3( ior - halfSpread, ior, ior + halfSpread );\n\t\t\tfor ( int i = 0; i < 3; i ++ ) {\n\t\t\t\tvec3 transmissionRay = getVolumeTransmissionRay( n, v, thickness, iors[ i ], modelMatrix );\n\t\t\t\tvec3 refractedRayExit = position + transmissionRay;\n\t\t\t\tvec4 ndcPos = projMatrix * viewMatrix * vec4( refractedRayExit, 1.0 );\n\t\t\t\tvec2 refractionCoords = ndcPos.xy / ndcPos.w;\n\t\t\t\trefractionCoords += 1.0;\n\t\t\t\trefractionCoords /= 2.0;\n\t\t\t\tvec4 transmissionSample = getTransmissionSample( refractionCoords, roughness, iors[ i ] );\n\t\t\t\ttransmittedLight[ i ] = transmissionSample[ i ];\n\t\t\t\ttransmittedLight.a += transmissionSample.a;\n\t\t\t\ttransmittance[ i ] = diffuseColor[ i ] * volumeAttenuation( length( transmissionRay ), attenuationColor, attenuationDistance )[ i ];\n\t\t\t}\n\t\t\ttransmittedLight.a /= 3.0;\n\t\t#else\n\t\t\tvec3 transmissionRay = getVolumeTransmissionRay( n, v, thickness, ior, modelMatrix );\n\t\t\tvec3 refractedRayExit = position + transmissionRay;\n\t\t\tvec4 ndcPos = projMatrix * viewMatrix * vec4( refractedRayExit, 1.0 );\n\t\t\tvec2 refractionCoords = ndcPos.xy / ndcPos.w;\n\t\t\trefractionCoords += 1.0;\n\t\t\trefractionCoords /= 2.0;\n\t\t\ttransmittedLight = getTransmissionSample( refractionCoords, roughness, ior );\n\t\t\ttransmittance = diffuseColor * volumeAttenuation( length( transmissionRay ), attenuationColor, attenuationDistance );\n\t\t#endif\n\t\tvec3 attenuatedColor = transmittance * transmittedLight.rgb;\n\t\tvec3 F = EnvironmentBRDF( n, v, specularColor, specularF90, roughness );\n\t\tfloat transmittanceFactor = ( transmittance.r + transmittance.g + transmittance.b ) / 3.0;\n\t\treturn vec4( ( 1.0 - F ) * attenuatedColor, 1.0 - ( 1.0 - transmittedLight.a ) * transmittanceFactor );\n\t}\n#endif",uv_pars_fragment:"#if defined( USE_UV ) || defined( USE_ANISOTROPY )\n\tvarying vec2 vUv;\n#endif\n#ifdef USE_MAP\n\tvarying vec2 vMapUv;\n#endif\n#ifdef USE_ALPHAMAP\n\tvarying vec2 vAlphaMapUv;\n#endif\n#ifdef USE_LIGHTMAP\n\tvarying vec2 vLightMapUv;\n#endif\n#ifdef USE_AOMAP\n\tvarying vec2 vAoMapUv;\n#endif\n#ifdef USE_BUMPMAP\n\tvarying vec2 vBumpMapUv;\n#endif\n#ifdef USE_NORMALMAP\n\tvarying vec2 vNormalMapUv;\n#endif\n#ifdef USE_EMISSIVEMAP\n\tvarying vec2 vEmissiveMapUv;\n#endif\n#ifdef USE_METALNESSMAP\n\tvarying vec2 vMetalnessMapUv;\n#endif\n#ifdef USE_ROUGHNESSMAP\n\tvarying vec2 vRoughnessMapUv;\n#endif\n#ifdef USE_ANISOTROPYMAP\n\tvarying vec2 vAnisotropyMapUv;\n#endif\n#ifdef USE_CLEARCOATMAP\n\tvarying vec2 vClearcoatMapUv;\n#endif\n#ifdef USE_CLEARCOAT_NORMALMAP\n\tvarying vec2 vClearcoatNormalMapUv;\n#endif\n#ifdef USE_CLEARCOAT_ROUGHNESSMAP\n\tvarying vec2 vClearcoatRoughnessMapUv;\n#endif\n#ifdef USE_IRIDESCENCEMAP\n\tvarying vec2 vIridescenceMapUv;\n#endif\n#ifdef USE_IRIDESCENCE_THICKNESSMAP\n\tvarying vec2 vIridescenceThicknessMapUv;\n#endif\n#ifdef USE_SHEEN_COLORMAP\n\tvarying vec2 vSheenColorMapUv;\n#endif\n#ifdef USE_SHEEN_ROUGHNESSMAP\n\tvarying vec2 vSheenRoughnessMapUv;\n#endif\n#ifdef USE_SPECULARMAP\n\tvarying vec2 vSpecularMapUv;\n#endif\n#ifdef USE_SPECULAR_COLORMAP\n\tvarying vec2 vSpecularColorMapUv;\n#endif\n#ifdef USE_SPECULAR_INTENSITYMAP\n\tvarying vec2 vSpecularIntensityMapUv;\n#endif\n#ifdef USE_TRANSMISSIONMAP\n\tuniform mat3 transmissionMapTransform;\n\tvarying vec2 vTransmissionMapUv;\n#endif\n#ifdef USE_THICKNESSMAP\n\tuniform mat3 thicknessMapTransform;\n\tvarying vec2 vThicknessMapUv;\n#endif",uv_pars_vertex:"#if defined( USE_UV ) || defined( USE_ANISOTROPY )\n\tvarying vec2 vUv;\n#endif\n#ifdef USE_MAP\n\tuniform mat3 mapTransform;\n\tvarying vec2 vMapUv;\n#endif\n#ifdef USE_ALPHAMAP\n\tuniform mat3 alphaMapTransform;\n\tvarying vec2 vAlphaMapUv;\n#endif\n#ifdef USE_LIGHTMAP\n\tuniform mat3 lightMapTransform;\n\tvarying vec2 vLightMapUv;\n#endif\n#ifdef USE_AOMAP\n\tuniform mat3 aoMapTransform;\n\tvarying vec2 vAoMapUv;\n#endif\n#ifdef USE_BUMPMAP\n\tuniform mat3 bumpMapTransform;\n\tvarying vec2 vBumpMapUv;\n#endif\n#ifdef USE_NORMALMAP\n\tuniform mat3 normalMapTransform;\n\tvarying vec2 vNormalMapUv;\n#endif\n#ifdef USE_DISPLACEMENTMAP\n\tuniform mat3 displacementMapTransform;\n\tvarying vec2 vDisplacementMapUv;\n#endif\n#ifdef USE_EMISSIVEMAP\n\tuniform mat3 emissiveMapTransform;\n\tvarying vec2 vEmissiveMapUv;\n#endif\n#ifdef USE_METALNESSMAP\n\tuniform mat3 metalnessMapTransform;\n\tvarying vec2 vMetalnessMapUv;\n#endif\n#ifdef USE_ROUGHNESSMAP\n\tuniform mat3 roughnessMapTransform;\n\tvarying vec2 vRoughnessMapUv;\n#endif\n#ifdef USE_ANISOTROPYMAP\n\tuniform mat3 anisotropyMapTransform;\n\tvarying vec2 vAnisotropyMapUv;\n#endif\n#ifdef USE_CLEARCOATMAP\n\tuniform mat3 clearcoatMapTransform;\n\tvarying vec2 vClearcoatMapUv;\n#endif\n#ifdef USE_CLEARCOAT_NORMALMAP\n\tuniform mat3 clearcoatNormalMapTransform;\n\tvarying vec2 vClearcoatNormalMapUv;\n#endif\n#ifdef USE_CLEARCOAT_ROUGHNESSMAP\n\tuniform mat3 clearcoatRoughnessMapTransform;\n\tvarying vec2 vClearcoatRoughnessMapUv;\n#endif\n#ifdef USE_SHEEN_COLORMAP\n\tuniform mat3 sheenColorMapTransform;\n\tvarying vec2 vSheenColorMapUv;\n#endif\n#ifdef USE_SHEEN_ROUGHNESSMAP\n\tuniform mat3 sheenRoughnessMapTransform;\n\tvarying vec2 vSheenRoughnessMapUv;\n#endif\n#ifdef USE_IRIDESCENCEMAP\n\tuniform mat3 iridescenceMapTransform;\n\tvarying vec2 vIridescenceMapUv;\n#endif\n#ifdef USE_IRIDESCENCE_THICKNESSMAP\n\tuniform mat3 iridescenceThicknessMapTransform;\n\tvarying vec2 vIridescenceThicknessMapUv;\n#endif\n#ifdef USE_SPECULARMAP\n\tuniform mat3 specularMapTransform;\n\tvarying vec2 vSpecularMapUv;\n#endif\n#ifdef USE_SPECULAR_COLORMAP\n\tuniform mat3 specularColorMapTransform;\n\tvarying vec2 vSpecularColorMapUv;\n#endif\n#ifdef USE_SPECULAR_INTENSITYMAP\n\tuniform mat3 specularIntensityMapTransform;\n\tvarying vec2 vSpecularIntensityMapUv;\n#endif\n#ifdef USE_TRANSMISSIONMAP\n\tuniform mat3 transmissionMapTransform;\n\tvarying vec2 vTransmissionMapUv;\n#endif\n#ifdef USE_THICKNESSMAP\n\tuniform mat3 thicknessMapTransform;\n\tvarying vec2 vThicknessMapUv;\n#endif",uv_vertex:"#if defined( USE_UV ) || defined( USE_ANISOTROPY )\n\tvUv = vec3( uv, 1 ).xy;\n#endif\n#ifdef USE_MAP\n\tvMapUv = ( mapTransform * vec3( MAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_ALPHAMAP\n\tvAlphaMapUv = ( alphaMapTransform * vec3( ALPHAMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_LIGHTMAP\n\tvLightMapUv = ( lightMapTransform * vec3( LIGHTMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_AOMAP\n\tvAoMapUv = ( aoMapTransform * vec3( AOMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_BUMPMAP\n\tvBumpMapUv = ( bumpMapTransform * vec3( BUMPMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_NORMALMAP\n\tvNormalMapUv = ( normalMapTransform * vec3( NORMALMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_DISPLACEMENTMAP\n\tvDisplacementMapUv = ( displacementMapTransform * vec3( DISPLACEMENTMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_EMISSIVEMAP\n\tvEmissiveMapUv = ( emissiveMapTransform * vec3( EMISSIVEMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_METALNESSMAP\n\tvMetalnessMapUv = ( metalnessMapTransform * vec3( METALNESSMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_ROUGHNESSMAP\n\tvRoughnessMapUv = ( roughnessMapTransform * vec3( ROUGHNESSMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_ANISOTROPYMAP\n\tvAnisotropyMapUv = ( anisotropyMapTransform * vec3( ANISOTROPYMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_CLEARCOATMAP\n\tvClearcoatMapUv = ( clearcoatMapTransform * vec3( CLEARCOATMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_CLEARCOAT_NORMALMAP\n\tvClearcoatNormalMapUv = ( clearcoatNormalMapTransform * vec3( CLEARCOAT_NORMALMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_CLEARCOAT_ROUGHNESSMAP\n\tvClearcoatRoughnessMapUv = ( clearcoatRoughnessMapTransform * vec3( CLEARCOAT_ROUGHNESSMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_IRIDESCENCEMAP\n\tvIridescenceMapUv = ( iridescenceMapTransform * vec3( IRIDESCENCEMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_IRIDESCENCE_THICKNESSMAP\n\tvIridescenceThicknessMapUv = ( iridescenceThicknessMapTransform * vec3( IRIDESCENCE_THICKNESSMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_SHEEN_COLORMAP\n\tvSheenColorMapUv = ( sheenColorMapTransform * vec3( SHEEN_COLORMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_SHEEN_ROUGHNESSMAP\n\tvSheenRoughnessMapUv = ( sheenRoughnessMapTransform * vec3( SHEEN_ROUGHNESSMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_SPECULARMAP\n\tvSpecularMapUv = ( specularMapTransform * vec3( SPECULARMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_SPECULAR_COLORMAP\n\tvSpecularColorMapUv = ( specularColorMapTransform * vec3( SPECULAR_COLORMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_SPECULAR_INTENSITYMAP\n\tvSpecularIntensityMapUv = ( specularIntensityMapTransform * vec3( SPECULAR_INTENSITYMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_TRANSMISSIONMAP\n\tvTransmissionMapUv = ( transmissionMapTransform * vec3( TRANSMISSIONMAP_UV, 1 ) ).xy;\n#endif\n#ifdef USE_THICKNESSMAP\n\tvThicknessMapUv = ( thicknessMapTransform * vec3( THICKNESSMAP_UV, 1 ) ).xy;\n#endif",worldpos_vertex:"#if defined( USE_ENVMAP ) || defined( DISTANCE ) || defined ( USE_SHADOWMAP ) || defined ( USE_TRANSMISSION ) || NUM_SPOT_LIGHT_COORDS > 0\n\tvec4 worldPosition = vec4( transformed, 1.0 );\n\t#ifdef USE_BATCHING\n\t\tworldPosition = batchingMatrix * worldPosition;\n\t#endif\n\t#ifdef USE_INSTANCING\n\t\tworldPosition = instanceMatrix * worldPosition;\n\t#endif\n\tworldPosition = modelMatrix * worldPosition;\n#endif",background_vert:"varying vec2 vUv;\nuniform mat3 uvTransform;\nvoid main() {\n\tvUv = ( uvTransform * vec3( uv, 1 ) ).xy;\n\tgl_Position = vec4( position.xy, 1.0, 1.0 );\n}",background_frag:"uniform sampler2D t2D;\nuniform float backgroundIntensity;\nvarying vec2 vUv;\nvoid main() {\n\tvec4 texColor = texture2D( t2D, vUv );\n\t#ifdef DECODE_VIDEO_TEXTURE\n\t\ttexColor = vec4( mix( pow( texColor.rgb * 0.9478672986 + vec3( 0.0521327014 ), vec3( 2.4 ) ), texColor.rgb * 0.0773993808, vec3( lessThanEqual( texColor.rgb, vec3( 0.04045 ) ) ) ), texColor.w );\n\t#endif\n\ttexColor.rgb *= backgroundIntensity;\n\tgl_FragColor = texColor;\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n}",backgroundCube_vert:"varying vec3 vWorldDirection;\n#include <common>\nvoid main() {\n\tvWorldDirection = transformDirection( position, modelMatrix );\n\t#include <begin_vertex>\n\t#include <project_vertex>\n\tgl_Position.z = gl_Position.w;\n}",backgroundCube_frag:"#ifdef ENVMAP_TYPE_CUBE\n\tuniform samplerCube envMap;\n#elif defined( ENVMAP_TYPE_CUBE_UV )\n\tuniform sampler2D envMap;\n#endif\nuniform float flipEnvMap;\nuniform float backgroundBlurriness;\nuniform float backgroundIntensity;\nuniform mat3 backgroundRotation;\nvarying vec3 vWorldDirection;\n#include <cube_uv_reflection_fragment>\nvoid main() {\n\t#ifdef ENVMAP_TYPE_CUBE\n\t\tvec4 texColor = textureCube( envMap, backgroundRotation * vec3( flipEnvMap * vWorldDirection.x, vWorldDirection.yz ) );\n\t#elif defined( ENVMAP_TYPE_CUBE_UV )\n\t\tvec4 texColor = textureCubeUV( envMap, backgroundRotation * vWorldDirection, backgroundBlurriness );\n\t#else\n\t\tvec4 texColor = vec4( 0.0, 0.0, 0.0, 1.0 );\n\t#endif\n\ttexColor.rgb *= backgroundIntensity;\n\tgl_FragColor = texColor;\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n}",cube_vert:"varying vec3 vWorldDirection;\n#include <common>\nvoid main() {\n\tvWorldDirection = transformDirection( position, modelMatrix );\n\t#include <begin_vertex>\n\t#include <project_vertex>\n\tgl_Position.z = gl_Position.w;\n}",cube_frag:"uniform samplerCube tCube;\nuniform float tFlip;\nuniform float opacity;\nvarying vec3 vWorldDirection;\nvoid main() {\n\tvec4 texColor = textureCube( tCube, vec3( tFlip * vWorldDirection.x, vWorldDirection.yz ) );\n\tgl_FragColor = texColor;\n\tgl_FragColor.a *= opacity;\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n}",depth_vert:"#include <common>\n#include <batching_pars_vertex>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvarying vec2 vHighPrecisionZW;\nvoid main() {\n\t#include <uv_vertex>\n\t#include <batching_vertex>\n\t#include <skinbase_vertex>\n\t#include <morphinstance_vertex>\n\t#ifdef USE_DISPLACEMENTMAP\n\t\t#include <beginnormal_vertex>\n\t\t#include <morphnormal_vertex>\n\t\t#include <skinnormal_vertex>\n\t#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\tvHighPrecisionZW = gl_Position.zw;\n}",depth_frag:"#if DEPTH_PACKING == 3200\n\tuniform float opacity;\n#endif\n#include <common>\n#include <packing>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <alphahash_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvarying vec2 vHighPrecisionZW;\nvoid main() {\n\tvec4 diffuseColor = vec4( 1.0 );\n\t#include <clipping_planes_fragment>\n\t#if DEPTH_PACKING == 3200\n\t\tdiffuseColor.a = opacity;\n\t#endif\n\t#include <map_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <alphahash_fragment>\n\t#include <logdepthbuf_fragment>\n\tfloat fragCoordZ = 0.5 * vHighPrecisionZW[0] / vHighPrecisionZW[1] + 0.5;\n\t#if DEPTH_PACKING == 3200\n\t\tgl_FragColor = vec4( vec3( 1.0 - fragCoordZ ), opacity );\n\t#elif DEPTH_PACKING == 3201\n\t\tgl_FragColor = packDepthToRGBA( fragCoordZ );\n\t#elif DEPTH_PACKING == 3202\n\t\tgl_FragColor = vec4( packDepthToRGB( fragCoordZ ), 1.0 );\n\t#elif DEPTH_PACKING == 3203\n\t\tgl_FragColor = vec4( packDepthToRG( fragCoordZ ), 0.0, 1.0 );\n\t#endif\n}",distanceRGBA_vert:"#define DISTANCE\nvarying vec3 vWorldPosition;\n#include <common>\n#include <batching_pars_vertex>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <batching_vertex>\n\t#include <skinbase_vertex>\n\t#include <morphinstance_vertex>\n\t#ifdef USE_DISPLACEMENTMAP\n\t\t#include <beginnormal_vertex>\n\t\t#include <morphnormal_vertex>\n\t\t#include <skinnormal_vertex>\n\t#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <worldpos_vertex>\n\t#include <clipping_planes_vertex>\n\tvWorldPosition = worldPosition.xyz;\n}",distanceRGBA_frag:"#define DISTANCE\nuniform vec3 referencePosition;\nuniform float nearDistance;\nuniform float farDistance;\nvarying vec3 vWorldPosition;\n#include <common>\n#include <packing>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <alphahash_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main () {\n\tvec4 diffuseColor = vec4( 1.0 );\n\t#include <clipping_planes_fragment>\n\t#include <map_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <alphahash_fragment>\n\tfloat dist = length( vWorldPosition - referencePosition );\n\tdist = ( dist - nearDistance ) / ( farDistance - nearDistance );\n\tdist = saturate( dist );\n\tgl_FragColor = packDepthToRGBA( dist );\n}",equirect_vert:"varying vec3 vWorldDirection;\n#include <common>\nvoid main() {\n\tvWorldDirection = transformDirection( position, modelMatrix );\n\t#include <begin_vertex>\n\t#include <project_vertex>\n}",equirect_frag:"uniform sampler2D tEquirect;\nvarying vec3 vWorldDirection;\n#include <common>\nvoid main() {\n\tvec3 direction = normalize( vWorldDirection );\n\tvec2 sampleUV = equirectUv( direction );\n\tgl_FragColor = texture2D( tEquirect, sampleUV );\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n}",linedashed_vert:"uniform float scale;\nattribute float lineDistance;\nvarying float vLineDistance;\n#include <common>\n#include <uv_pars_vertex>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\tvLineDistance = scale * lineDistance;\n\t#include <uv_vertex>\n\t#include <color_vertex>\n\t#include <morphinstance_vertex>\n\t#include <morphcolor_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <fog_vertex>\n}",linedashed_frag:"uniform vec3 diffuse;\nuniform float opacity;\nuniform float dashSize;\nuniform float totalSize;\nvarying float vLineDistance;\n#include <common>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <fog_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <clipping_planes_fragment>\n\tif ( mod( vLineDistance, totalSize ) > dashSize ) {\n\t\tdiscard;\n\t}\n\tvec3 outgoingLight = vec3( 0.0 );\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\toutgoingLight = diffuseColor.rgb;\n\t#include <opaque_fragment>\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n}",meshbasic_vert:"#include <common>\n#include <batching_pars_vertex>\n#include <uv_pars_vertex>\n#include <envmap_pars_vertex>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <color_vertex>\n\t#include <morphinstance_vertex>\n\t#include <morphcolor_vertex>\n\t#include <batching_vertex>\n\t#if defined ( USE_ENVMAP ) || defined ( USE_SKINNING )\n\t\t#include <beginnormal_vertex>\n\t\t#include <morphnormal_vertex>\n\t\t#include <skinbase_vertex>\n\t\t#include <skinnormal_vertex>\n\t\t#include <defaultnormal_vertex>\n\t#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <worldpos_vertex>\n\t#include <envmap_vertex>\n\t#include <fog_vertex>\n}",meshbasic_frag:"uniform vec3 diffuse;\nuniform float opacity;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\n#include <common>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <alphahash_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <envmap_common_pars_fragment>\n#include <envmap_pars_fragment>\n#include <fog_pars_fragment>\n#include <specularmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <clipping_planes_fragment>\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <alphahash_fragment>\n\t#include <specularmap_fragment>\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\t#ifdef USE_LIGHTMAP\n\t\tvec4 lightMapTexel = texture2D( lightMap, vLightMapUv );\n\t\treflectedLight.indirectDiffuse += lightMapTexel.rgb * lightMapIntensity * RECIPROCAL_PI;\n\t#else\n\t\treflectedLight.indirectDiffuse += vec3( 1.0 );\n\t#endif\n\t#include <aomap_fragment>\n\treflectedLight.indirectDiffuse *= diffuseColor.rgb;\n\tvec3 outgoingLight = reflectedLight.indirectDiffuse;\n\t#include <envmap_fragment>\n\t#include <opaque_fragment>\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}",meshlambert_vert:"#define LAMBERT\nvarying vec3 vViewPosition;\n#include <common>\n#include <batching_pars_vertex>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <envmap_pars_vertex>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <normal_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <color_vertex>\n\t#include <morphinstance_vertex>\n\t#include <morphcolor_vertex>\n\t#include <batching_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#include <normal_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\tvViewPosition = - mvPosition.xyz;\n\t#include <worldpos_vertex>\n\t#include <envmap_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n}",meshlambert_frag:"#define LAMBERT\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform float opacity;\n#include <common>\n#include <packing>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <alphahash_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <envmap_common_pars_fragment>\n#include <envmap_pars_fragment>\n#include <fog_pars_fragment>\n#include <bsdfs>\n#include <lights_pars_begin>\n#include <normal_pars_fragment>\n#include <lights_lambert_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <specularmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <clipping_planes_fragment>\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\tvec3 totalEmissiveRadiance = emissive;\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <alphahash_fragment>\n\t#include <specularmap_fragment>\n\t#include <normal_fragment_begin>\n\t#include <normal_fragment_maps>\n\t#include <emissivemap_fragment>\n\t#include <lights_lambert_fragment>\n\t#include <lights_fragment_begin>\n\t#include <lights_fragment_maps>\n\t#include <lights_fragment_end>\n\t#include <aomap_fragment>\n\tvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + totalEmissiveRadiance;\n\t#include <envmap_fragment>\n\t#include <opaque_fragment>\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}",meshmatcap_vert:"#define MATCAP\nvarying vec3 vViewPosition;\n#include <common>\n#include <batching_pars_vertex>\n#include <uv_pars_vertex>\n#include <color_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <fog_pars_vertex>\n#include <normal_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <color_vertex>\n\t#include <morphinstance_vertex>\n\t#include <morphcolor_vertex>\n\t#include <batching_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#include <normal_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <fog_vertex>\n\tvViewPosition = - mvPosition.xyz;\n}",meshmatcap_frag:"#define MATCAP\nuniform vec3 diffuse;\nuniform float opacity;\nuniform sampler2D matcap;\nvarying vec3 vViewPosition;\n#include <common>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <alphahash_pars_fragment>\n#include <fog_pars_fragment>\n#include <normal_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <clipping_planes_fragment>\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <alphahash_fragment>\n\t#include <normal_fragment_begin>\n\t#include <normal_fragment_maps>\n\tvec3 viewDir = normalize( vViewPosition );\n\tvec3 x = normalize( vec3( viewDir.z, 0.0, - viewDir.x ) );\n\tvec3 y = cross( viewDir, x );\n\tvec2 uv = vec2( dot( x, normal ), dot( y, normal ) ) * 0.495 + 0.5;\n\t#ifdef USE_MATCAP\n\t\tvec4 matcapColor = texture2D( matcap, uv );\n\t#else\n\t\tvec4 matcapColor = vec4( vec3( mix( 0.2, 0.8, uv.y ) ), 1.0 );\n\t#endif\n\tvec3 outgoingLight = diffuseColor.rgb * matcapColor.rgb;\n\t#include <opaque_fragment>\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}",meshnormal_vert:"#define NORMAL\n#if defined( FLAT_SHADED ) || defined( USE_BUMPMAP ) || defined( USE_NORMALMAP_TANGENTSPACE )\n\tvarying vec3 vViewPosition;\n#endif\n#include <common>\n#include <batching_pars_vertex>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <normal_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <batching_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphinstance_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#include <normal_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n#if defined( FLAT_SHADED ) || defined( USE_BUMPMAP ) || defined( USE_NORMALMAP_TANGENTSPACE )\n\tvViewPosition = - mvPosition.xyz;\n#endif\n}",meshnormal_frag:"#define NORMAL\nuniform float opacity;\n#if defined( FLAT_SHADED ) || defined( USE_BUMPMAP ) || defined( USE_NORMALMAP_TANGENTSPACE )\n\tvarying vec3 vViewPosition;\n#endif\n#include <packing>\n#include <uv_pars_fragment>\n#include <normal_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\tvec4 diffuseColor = vec4( 0.0, 0.0, 0.0, opacity );\n\t#include <clipping_planes_fragment>\n\t#include <logdepthbuf_fragment>\n\t#include <normal_fragment_begin>\n\t#include <normal_fragment_maps>\n\tgl_FragColor = vec4( packNormalToRGB( normal ), diffuseColor.a );\n\t#ifdef OPAQUE\n\t\tgl_FragColor.a = 1.0;\n\t#endif\n}",meshphong_vert:"#define PHONG\nvarying vec3 vViewPosition;\n#include <common>\n#include <batching_pars_vertex>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <envmap_pars_vertex>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <normal_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <color_vertex>\n\t#include <morphcolor_vertex>\n\t#include <batching_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphinstance_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#include <normal_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\tvViewPosition = - mvPosition.xyz;\n\t#include <worldpos_vertex>\n\t#include <envmap_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n}",meshphong_frag:"#define PHONG\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform vec3 specular;\nuniform float shininess;\nuniform float opacity;\n#include <common>\n#include <packing>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <alphahash_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <envmap_common_pars_fragment>\n#include <envmap_pars_fragment>\n#include <fog_pars_fragment>\n#include <bsdfs>\n#include <lights_pars_begin>\n#include <normal_pars_fragment>\n#include <lights_phong_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <specularmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <clipping_planes_fragment>\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\tvec3 totalEmissiveRadiance = emissive;\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <alphahash_fragment>\n\t#include <specularmap_fragment>\n\t#include <normal_fragment_begin>\n\t#include <normal_fragment_maps>\n\t#include <emissivemap_fragment>\n\t#include <lights_phong_fragment>\n\t#include <lights_fragment_begin>\n\t#include <lights_fragment_maps>\n\t#include <lights_fragment_end>\n\t#include <aomap_fragment>\n\tvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + reflectedLight.directSpecular + reflectedLight.indirectSpecular + totalEmissiveRadiance;\n\t#include <envmap_fragment>\n\t#include <opaque_fragment>\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}",meshphysical_vert:"#define STANDARD\nvarying vec3 vViewPosition;\n#ifdef USE_TRANSMISSION\n\tvarying vec3 vWorldPosition;\n#endif\n#include <common>\n#include <batching_pars_vertex>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <normal_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <color_vertex>\n\t#include <morphinstance_vertex>\n\t#include <morphcolor_vertex>\n\t#include <batching_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#include <normal_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\tvViewPosition = - mvPosition.xyz;\n\t#include <worldpos_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n#ifdef USE_TRANSMISSION\n\tvWorldPosition = worldPosition.xyz;\n#endif\n}",meshphysical_frag:"#define STANDARD\n#ifdef PHYSICAL\n\t#define IOR\n\t#define USE_SPECULAR\n#endif\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform float roughness;\nuniform float metalness;\nuniform float opacity;\n#ifdef IOR\n\tuniform float ior;\n#endif\n#ifdef USE_SPECULAR\n\tuniform float specularIntensity;\n\tuniform vec3 specularColor;\n\t#ifdef USE_SPECULAR_COLORMAP\n\t\tuniform sampler2D specularColorMap;\n\t#endif\n\t#ifdef USE_SPECULAR_INTENSITYMAP\n\t\tuniform sampler2D specularIntensityMap;\n\t#endif\n#endif\n#ifdef USE_CLEARCOAT\n\tuniform float clearcoat;\n\tuniform float clearcoatRoughness;\n#endif\n#ifdef USE_DISPERSION\n\tuniform float dispersion;\n#endif\n#ifdef USE_IRIDESCENCE\n\tuniform float iridescence;\n\tuniform float iridescenceIOR;\n\tuniform float iridescenceThicknessMinimum;\n\tuniform float iridescenceThicknessMaximum;\n#endif\n#ifdef USE_SHEEN\n\tuniform vec3 sheenColor;\n\tuniform float sheenRoughness;\n\t#ifdef USE_SHEEN_COLORMAP\n\t\tuniform sampler2D sheenColorMap;\n\t#endif\n\t#ifdef USE_SHEEN_ROUGHNESSMAP\n\t\tuniform sampler2D sheenRoughnessMap;\n\t#endif\n#endif\n#ifdef USE_ANISOTROPY\n\tuniform vec2 anisotropyVector;\n\t#ifdef USE_ANISOTROPYMAP\n\t\tuniform sampler2D anisotropyMap;\n\t#endif\n#endif\nvarying vec3 vViewPosition;\n#include <common>\n#include <packing>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <alphahash_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <iridescence_fragment>\n#include <cube_uv_reflection_fragment>\n#include <envmap_common_pars_fragment>\n#include <envmap_physical_pars_fragment>\n#include <fog_pars_fragment>\n#include <lights_pars_begin>\n#include <normal_pars_fragment>\n#include <lights_physical_pars_fragment>\n#include <transmission_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <clearcoat_pars_fragment>\n#include <iridescence_pars_fragment>\n#include <roughnessmap_pars_fragment>\n#include <metalnessmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <clipping_planes_fragment>\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\tvec3 totalEmissiveRadiance = emissive;\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <alphahash_fragment>\n\t#include <roughnessmap_fragment>\n\t#include <metalnessmap_fragment>\n\t#include <normal_fragment_begin>\n\t#include <normal_fragment_maps>\n\t#include <clearcoat_normal_fragment_begin>\n\t#include <clearcoat_normal_fragment_maps>\n\t#include <emissivemap_fragment>\n\t#include <lights_physical_fragment>\n\t#include <lights_fragment_begin>\n\t#include <lights_fragment_maps>\n\t#include <lights_fragment_end>\n\t#include <aomap_fragment>\n\tvec3 totalDiffuse = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse;\n\tvec3 totalSpecular = reflectedLight.directSpecular + reflectedLight.indirectSpecular;\n\t#include <transmission_fragment>\n\tvec3 outgoingLight = totalDiffuse + totalSpecular + totalEmissiveRadiance;\n\t#ifdef USE_SHEEN\n\t\tfloat sheenEnergyComp = 1.0 - 0.157 * max3( material.sheenColor );\n\t\toutgoingLight = outgoingLight * sheenEnergyComp + sheenSpecularDirect + sheenSpecularIndirect;\n\t#endif\n\t#ifdef USE_CLEARCOAT\n\t\tfloat dotNVcc = saturate( dot( geometryClearcoatNormal, geometryViewDir ) );\n\t\tvec3 Fcc = F_Schlick( material.clearcoatF0, material.clearcoatF90, dotNVcc );\n\t\toutgoingLight = outgoingLight * ( 1.0 - material.clearcoat * Fcc ) + ( clearcoatSpecularDirect + clearcoatSpecularIndirect ) * material.clearcoat;\n\t#endif\n\t#include <opaque_fragment>\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}",meshtoon_vert:"#define TOON\nvarying vec3 vViewPosition;\n#include <common>\n#include <batching_pars_vertex>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <normal_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <color_vertex>\n\t#include <morphinstance_vertex>\n\t#include <morphcolor_vertex>\n\t#include <batching_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#include <normal_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\tvViewPosition = - mvPosition.xyz;\n\t#include <worldpos_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n}",meshtoon_frag:"#define TOON\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform float opacity;\n#include <common>\n#include <packing>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <alphahash_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <gradientmap_pars_fragment>\n#include <fog_pars_fragment>\n#include <bsdfs>\n#include <lights_pars_begin>\n#include <normal_pars_fragment>\n#include <lights_toon_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <clipping_planes_fragment>\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\tvec3 totalEmissiveRadiance = emissive;\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <alphahash_fragment>\n\t#include <normal_fragment_begin>\n\t#include <normal_fragment_maps>\n\t#include <emissivemap_fragment>\n\t#include <lights_toon_fragment>\n\t#include <lights_fragment_begin>\n\t#include <lights_fragment_maps>\n\t#include <lights_fragment_end>\n\t#include <aomap_fragment>\n\tvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + totalEmissiveRadiance;\n\t#include <opaque_fragment>\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}",points_vert:"uniform float size;\nuniform float scale;\n#include <common>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\n#ifdef USE_POINTS_UV\n\tvarying vec2 vUv;\n\tuniform mat3 uvTransform;\n#endif\nvoid main() {\n\t#ifdef USE_POINTS_UV\n\t\tvUv = ( uvTransform * vec3( uv, 1 ) ).xy;\n\t#endif\n\t#include <color_vertex>\n\t#include <morphinstance_vertex>\n\t#include <morphcolor_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <project_vertex>\n\tgl_PointSize = size;\n\t#ifdef USE_SIZEATTENUATION\n\t\tbool isPerspective = isPerspectiveMatrix( projectionMatrix );\n\t\tif ( isPerspective ) gl_PointSize *= ( scale / - mvPosition.z );\n\t#endif\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <worldpos_vertex>\n\t#include <fog_vertex>\n}",points_frag:"uniform vec3 diffuse;\nuniform float opacity;\n#include <common>\n#include <color_pars_fragment>\n#include <map_particle_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <alphahash_pars_fragment>\n#include <fog_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <clipping_planes_fragment>\n\tvec3 outgoingLight = vec3( 0.0 );\n\t#include <logdepthbuf_fragment>\n\t#include <map_particle_fragment>\n\t#include <color_fragment>\n\t#include <alphatest_fragment>\n\t#include <alphahash_fragment>\n\toutgoingLight = diffuseColor.rgb;\n\t#include <opaque_fragment>\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n}",shadow_vert:"#include <common>\n#include <batching_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <shadowmap_pars_vertex>\nvoid main() {\n\t#include <batching_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphinstance_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <worldpos_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n}",shadow_frag:"uniform vec3 color;\nuniform float opacity;\n#include <common>\n#include <packing>\n#include <fog_pars_fragment>\n#include <bsdfs>\n#include <lights_pars_begin>\n#include <logdepthbuf_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <shadowmask_pars_fragment>\nvoid main() {\n\t#include <logdepthbuf_fragment>\n\tgl_FragColor = vec4( color, opacity * ( 1.0 - getShadowMask() ) );\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n\t#include <fog_fragment>\n}",sprite_vert:"uniform float rotation;\nuniform vec2 center;\n#include <common>\n#include <uv_pars_vertex>\n#include <fog_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\tvec4 mvPosition = modelViewMatrix[ 3 ];\n\tvec2 scale = vec2( length( modelMatrix[ 0 ].xyz ), length( modelMatrix[ 1 ].xyz ) );\n\t#ifndef USE_SIZEATTENUATION\n\t\tbool isPerspective = isPerspectiveMatrix( projectionMatrix );\n\t\tif ( isPerspective ) scale *= - mvPosition.z;\n\t#endif\n\tvec2 alignedPosition = ( position.xy - ( center - vec2( 0.5 ) ) ) * scale;\n\tvec2 rotatedPosition;\n\trotatedPosition.x = cos( rotation ) * alignedPosition.x - sin( rotation ) * alignedPosition.y;\n\trotatedPosition.y = sin( rotation ) * alignedPosition.x + cos( rotation ) * alignedPosition.y;\n\tmvPosition.xy += rotatedPosition;\n\tgl_Position = projectionMatrix * mvPosition;\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <fog_vertex>\n}",sprite_frag:"uniform vec3 diffuse;\nuniform float opacity;\n#include <common>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <alphahash_pars_fragment>\n#include <fog_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <clipping_planes_fragment>\n\tvec3 outgoingLight = vec3( 0.0 );\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <alphahash_fragment>\n\toutgoingLight = diffuseColor.rgb;\n\t#include <opaque_fragment>\n\t#include <tonemapping_fragment>\n\t#include <colorspace_fragment>\n\t#include <fog_fragment>\n}"},Zr={common:{diffuse:{value:new $i(16777215)},opacity:{value:1},map:{value:null},mapTransform:{value:new Matrix3},alphaMap:{value:null},alphaMapTransform:{value:new Matrix3},alphaTest:{value:0}},specularmap:{specularMap:{value:null},specularMapTransform:{value:new Matrix3}},envmap:{envMap:{value:null},envMapRotation:{value:new Matrix3},flipEnvMap:{value:-1},reflectivity:{value:1},ior:{value:1.5},refractionRatio:{value:.98}},aomap:{aoMap:{value:null},aoMapIntensity:{value:1},aoMapTransform:{value:new Matrix3}},lightmap:{lightMap:{value:null},lightMapIntensity:{value:1},lightMapTransform:{value:new Matrix3}},bumpmap:{bumpMap:{value:null},bumpMapTransform:{value:new Matrix3},bumpScale:{value:1}},normalmap:{normalMap:{value:null},normalMapTransform:{value:new Matrix3},normalScale:{value:new Vector2(1,1)}},displacementmap:{displacementMap:{value:null},displacementMapTransform:{value:new Matrix3},displacementScale:{value:1},displacementBias:{value:0}},emissivemap:{emissiveMap:{value:null},emissiveMapTransform:{value:new Matrix3}},metalnessmap:{metalnessMap:{value:null},metalnessMapTransform:{value:new Matrix3}},roughnessmap:{roughnessMap:{value:null},roughnessMapTransform:{value:new Matrix3}},gradientmap:{gradientMap:{value:null}},fog:{fogDensity:{value:25e-5},fogNear:{value:1},fogFar:{value:2e3},fogColor:{value:new $i(16777215)}},lights:{ambientLightColor:{value:[]},lightProbe:{value:[]},directionalLights:{value:[],properties:{direction:{},color:{}}},directionalLightShadows:{value:[],properties:{shadowIntensity:1,shadowBias:{},shadowNormalBias:{},shadowRadius:{},shadowMapSize:{}}},directionalShadowMap:{value:[]},directionalShadowMatrix:{value:[]},spotLights:{value:[],properties:{color:{},position:{},direction:{},distance:{},coneCos:{},penumbraCos:{},decay:{}}},spotLightShadows:{value:[],properties:{shadowIntensity:1,shadowBias:{},shadowNormalBias:{},shadowRadius:{},shadowMapSize:{}}},spotLightMap:{value:[]},spotShadowMap:{value:[]},spotLightMatrix:{value:[]},pointLights:{value:[],properties:{color:{},position:{},decay:{},distance:{}}},pointLightShadows:{value:[],properties:{shadowIntensity:1,shadowBias:{},shadowNormalBias:{},shadowRadius:{},shadowMapSize:{},shadowCameraNear:{},shadowCameraFar:{}}},pointShadowMap:{value:[]},pointShadowMatrix:{value:[]},hemisphereLights:{value:[],properties:{direction:{},skyColor:{},groundColor:{}}},rectAreaLights:{value:[],properties:{color:{},position:{},width:{},height:{}}},ltc_1:{value:null},ltc_2:{value:null}},points:{diffuse:{value:new $i(16777215)},opacity:{value:1},size:{value:1},scale:{value:1},map:{value:null},alphaMap:{value:null},alphaMapTransform:{value:new Matrix3},alphaTest:{value:0},uvTransform:{value:new Matrix3}},sprite:{diffuse:{value:new $i(16777215)},opacity:{value:1},center:{value:new Vector2(.5,.5)},rotation:{value:0},map:{value:null},mapTransform:{value:new Matrix3},alphaMap:{value:null},alphaMapTransform:{value:new Matrix3},alphaTest:{value:0}}},Kr={basic:{uniforms:mergeUniforms([Zr.common,Zr.specularmap,Zr.envmap,Zr.aomap,Zr.lightmap,Zr.fog]),vertexShader:Yr.meshbasic_vert,fragmentShader:Yr.meshbasic_frag},lambert:{uniforms:mergeUniforms([Zr.common,Zr.specularmap,Zr.envmap,Zr.aomap,Zr.lightmap,Zr.emissivemap,Zr.bumpmap,Zr.normalmap,Zr.displacementmap,Zr.fog,Zr.lights,{emissive:{value:new $i(0)}}]),vertexShader:Yr.meshlambert_vert,fragmentShader:Yr.meshlambert_frag},phong:{uniforms:mergeUniforms([Zr.common,Zr.specularmap,Zr.envmap,Zr.aomap,Zr.lightmap,Zr.emissivemap,Zr.bumpmap,Zr.normalmap,Zr.displacementmap,Zr.fog,Zr.lights,{emissive:{value:new $i(0)},specular:{value:new $i(1118481)},shininess:{value:30}}]),vertexShader:Yr.meshphong_vert,fragmentShader:Yr.meshphong_frag},standard:{uniforms:mergeUniforms([Zr.common,Zr.envmap,Zr.aomap,Zr.lightmap,Zr.emissivemap,Zr.bumpmap,Zr.normalmap,Zr.displacementmap,Zr.roughnessmap,Zr.metalnessmap,Zr.fog,Zr.lights,{emissive:{value:new $i(0)},roughness:{value:1},metalness:{value:0},envMapIntensity:{value:1}}]),vertexShader:Yr.meshphysical_vert,fragmentShader:Yr.meshphysical_frag},toon:{uniforms:mergeUniforms([Zr.common,Zr.aomap,Zr.lightmap,Zr.emissivemap,Zr.bumpmap,Zr.normalmap,Zr.displacementmap,Zr.gradientmap,Zr.fog,Zr.lights,{emissive:{value:new $i(0)}}]),vertexShader:Yr.meshtoon_vert,fragmentShader:Yr.meshtoon_frag},matcap:{uniforms:mergeUniforms([Zr.common,Zr.bumpmap,Zr.normalmap,Zr.displacementmap,Zr.fog,{matcap:{value:null}}]),vertexShader:Yr.meshmatcap_vert,fragmentShader:Yr.meshmatcap_frag},points:{uniforms:mergeUniforms([Zr.points,Zr.fog]),vertexShader:Yr.points_vert,fragmentShader:Yr.points_frag},dashed:{uniforms:mergeUniforms([Zr.common,Zr.fog,{scale:{value:1},dashSize:{value:1},totalSize:{value:2}}]),vertexShader:Yr.linedashed_vert,fragmentShader:Yr.linedashed_frag},depth:{uniforms:mergeUniforms([Zr.common,Zr.displacementmap]),vertexShader:Yr.depth_vert,fragmentShader:Yr.depth_frag},normal:{uniforms:mergeUniforms([Zr.common,Zr.bumpmap,Zr.normalmap,Zr.displacementmap,{opacity:{value:1}}]),vertexShader:Yr.meshnormal_vert,fragmentShader:Yr.meshnormal_frag},sprite:{uniforms:mergeUniforms([Zr.sprite,Zr.fog]),vertexShader:Yr.sprite_vert,fragmentShader:Yr.sprite_frag},background:{uniforms:{uvTransform:{value:new Matrix3},t2D:{value:null},backgroundIntensity:{value:1}},vertexShader:Yr.background_vert,fragmentShader:Yr.background_frag},backgroundCube:{uniforms:{envMap:{value:null},flipEnvMap:{value:-1},backgroundBlurriness:{value:0},backgroundIntensity:{value:1},backgroundRotation:{value:new Matrix3}},vertexShader:Yr.backgroundCube_vert,fragmentShader:Yr.backgroundCube_frag},cube:{uniforms:{tCube:{value:null},tFlip:{value:-1},opacity:{value:1}},vertexShader:Yr.cube_vert,fragmentShader:Yr.cube_frag},equirect:{uniforms:{tEquirect:{value:null}},vertexShader:Yr.equirect_vert,fragmentShader:Yr.equirect_frag},distanceRGBA:{uniforms:mergeUniforms([Zr.common,Zr.displacementmap,{referencePosition:{value:new Vector3},nearDistance:{value:1},farDistance:{value:1e3}}]),vertexShader:Yr.distanceRGBA_vert,fragmentShader:Yr.distanceRGBA_frag},shadow:{uniforms:mergeUniforms([Zr.lights,Zr.fog,{color:{value:new $i(0)},opacity:{value:1}}]),vertexShader:Yr.shadow_vert,fragmentShader:Yr.shadow_frag}};Kr.physical={uniforms:mergeUniforms([Kr.standard.uniforms,{clearcoat:{value:0},clearcoatMap:{value:null},clearcoatMapTransform:{value:new Matrix3},clearcoatNormalMap:{value:null},clearcoatNormalMapTransform:{value:new Matrix3},clearcoatNormalScale:{value:new Vector2(1,1)},clearcoatRoughness:{value:0},clearcoatRoughnessMap:{value:null},clearcoatRoughnessMapTransform:{value:new Matrix3},dispersion:{value:0},iridescence:{value:0},iridescenceMap:{value:null},iridescenceMapTransform:{value:new Matrix3},iridescenceIOR:{value:1.3},iridescenceThicknessMinimum:{value:100},iridescenceThicknessMaximum:{value:400},iridescenceThicknessMap:{value:null},iridescenceThicknessMapTransform:{value:new Matrix3},sheen:{value:0},sheenColor:{value:new $i(0)},sheenColorMap:{value:null},sheenColorMapTransform:{value:new Matrix3},sheenRoughness:{value:1},sheenRoughnessMap:{value:null},sheenRoughnessMapTransform:{value:new Matrix3},transmission:{value:0},transmissionMap:{value:null},transmissionMapTransform:{value:new Matrix3},transmissionSamplerSize:{value:new Vector2},transmissionSamplerMap:{value:null},thickness:{value:0},thicknessMap:{value:null},thicknessMapTransform:{value:new Matrix3},attenuationDistance:{value:0},attenuationColor:{value:new $i(0)},specularColor:{value:new $i(1,1,1)},specularColorMap:{value:null},specularColorMapTransform:{value:new Matrix3},specularIntensity:{value:1},specularIntensityMap:{value:null},specularIntensityMapTransform:{value:new Matrix3},anisotropyVector:{value:new Vector2},anisotropyMap:{value:null},anisotropyMapTransform:{value:new Matrix3}}]),vertexShader:Yr.meshphysical_vert,fragmentShader:Yr.meshphysical_frag};const Qr={r:0,b:0,g:0},Jr=new Euler,$r=new Matrix4;function WebGLBackground(t,i,r,a,o,l,c){const h=new $i(0);let d,u,p=!0===l?0:1,m=null,g=0,y=null;function getBackground(t){let a=!0===t.isScene?t.background:null;if(a&&a.isTexture){a=(t.backgroundBlurriness>0?r:i).get(a)}return a}function setClear(i,r){i.getRGB(Qr,getUnlitUniformColorSpace(t)),a.buffers.color.setClear(Qr.r,Qr.g,Qr.b,r,c)}return{getClearColor:function(){return h},setClearColor:function(t,i=1){h.set(t),p=i,setClear(h,p)},getClearAlpha:function(){return p},setClearAlpha:function(t){p=t,setClear(h,p)},render:function render(i){let r=!1;const o=getBackground(i);null===o?setClear(h,p):o&&o.isColor&&(setClear(o,1),r=!0);const l=t.xr.getEnvironmentBlendMode();"additive"===l?a.buffers.color.setClear(0,0,0,1,c):"alpha-blend"===l&&a.buffers.color.setClear(0,0,0,0,c),(t.autoClear||r)&&(a.buffers.depth.setTest(!0),a.buffers.depth.setMask(!0),a.buffers.color.setMask(!0),t.clear(t.autoClearColor,t.autoClearDepth,t.autoClearStencil))},addToRenderList:function addToRenderList(i,r){const a=getBackground(r);a&&(a.isCubeTexture||a.mapping===q)?(void 0===u&&(u=new Mesh(new BoxGeometry(1,1,1),new ShaderMaterial({name:"BackgroundCubeMaterial",uniforms:cloneUniforms(Kr.backgroundCube.uniforms),vertexShader:Kr.backgroundCube.vertexShader,fragmentShader:Kr.backgroundCube.fragmentShader,side:1,depthTest:!1,depthWrite:!1,fog:!1})),u.geometry.deleteAttribute("normal"),u.geometry.deleteAttribute("uv"),u.onBeforeRender=function(t,i,r){this.matrixWorld.copyPosition(r.matrixWorld)},Object.defineProperty(u.material,"envMap",{get:function(){return this.uniforms.envMap.value}}),o.update(u)),Jr.copy(r.backgroundRotation),Jr.x*=-1,Jr.y*=-1,Jr.z*=-1,a.isCubeTexture&&!1===a.isRenderTargetTexture&&(Jr.y*=-1,Jr.z*=-1),u.material.uniforms.envMap.value=a,u.material.uniforms.flipEnvMap.value=a.isCubeTexture&&!1===a.isRenderTargetTexture?-1:1,u.material.uniforms.backgroundBlurriness.value=r.backgroundBlurriness,u.material.uniforms.backgroundIntensity.value=r.backgroundIntensity,u.material.uniforms.backgroundRotation.value.setFromMatrix4($r.makeRotationFromEuler(Jr)),u.material.toneMapped=Ot.getTransfer(a.colorSpace)!==dt,m===a&&g===a.version&&y===t.toneMapping||(u.material.needsUpdate=!0,m=a,g=a.version,y=t.toneMapping),u.layers.enableAll(),i.unshift(u,u.geometry,u.material,0,0,null)):a&&a.isTexture&&(void 0===d&&(d=new Mesh(new PlaneGeometry(2,2),new ShaderMaterial({name:"BackgroundMaterial",uniforms:cloneUniforms(Kr.background.uniforms),vertexShader:Kr.background.vertexShader,fragmentShader:Kr.background.fragmentShader,side:0,depthTest:!1,depthWrite:!1,fog:!1})),d.geometry.deleteAttribute("normal"),Object.defineProperty(d.material,"map",{get:function(){return this.uniforms.t2D.value}}),o.update(d)),d.material.uniforms.t2D.value=a,d.material.uniforms.backgroundIntensity.value=r.backgroundIntensity,d.material.toneMapped=Ot.getTransfer(a.colorSpace)!==dt,!0===a.matrixAutoUpdate&&a.updateMatrix(),d.material.uniforms.uvTransform.value.copy(a.matrix),m===a&&g===a.version&&y===t.toneMapping||(d.material.needsUpdate=!0,m=a,g=a.version,y=t.toneMapping),d.layers.enableAll(),i.unshift(d,d.geometry,d.material,0,0,null))},dispose:function dispose(){void 0!==u&&(u.geometry.dispose(),u.material.dispose()),void 0!==d&&(d.geometry.dispose(),d.material.dispose())}}}function WebGLBindingStates(t,i){const r=t.getParameter(t.MAX_VERTEX_ATTRIBS),a={},o=createBindingState(null);let l=o,c=!1;function bindVertexArrayObject(i){return t.bindVertexArray(i)}function deleteVertexArrayObject(i){return t.deleteVertexArray(i)}function createBindingState(t){const i=[],a=[],o=[];for(let t=0;t<r;t++)i[t]=0,a[t]=0,o[t]=0;return{geometry:null,program:null,wireframe:!1,newAttributes:i,enabledAttributes:a,attributeDivisors:o,object:t,attributes:{},index:null}}function initAttributes(){const t=l.newAttributes;for(let i=0,r=t.length;i<r;i++)t[i]=0}function enableAttribute(t){enableAttributeAndDivisor(t,0)}function enableAttributeAndDivisor(i,r){const a=l.newAttributes,o=l.enabledAttributes,c=l.attributeDivisors;a[i]=1,0===o[i]&&(t.enableVertexAttribArray(i),o[i]=1),c[i]!==r&&(t.vertexAttribDivisor(i,r),c[i]=r)}function disableUnusedAttributes(){const i=l.newAttributes,r=l.enabledAttributes;for(let a=0,o=r.length;a<o;a++)r[a]!==i[a]&&(t.disableVertexAttribArray(a),r[a]=0)}function vertexAttribPointer(i,r,a,o,l,c,h){!0===h?t.vertexAttribIPointer(i,r,a,l,c):t.vertexAttribPointer(i,r,a,o,l,c)}function reset(){resetDefaultState(),c=!0,l!==o&&(l=o,bindVertexArrayObject(l.object))}function resetDefaultState(){o.geometry=null,o.program=null,o.wireframe=!1}return{setup:function setup(r,o,h,d,u){let p=!1;const m=function getBindingState(i,r,o){const l=!0===o.wireframe;let c=a[i.id];void 0===c&&(c={},a[i.id]=c);let h=c[r.id];void 0===h&&(h={},c[r.id]=h);let d=h[l];void 0===d&&(d=createBindingState(function createVertexArrayObject(){return t.createVertexArray()}()),h[l]=d);return d}(d,h,o);l!==m&&(l=m,bindVertexArrayObject(l.object)),p=function needsUpdate(t,i,r,a){const o=l.attributes,c=i.attributes;let h=0;const d=r.getAttributes();for(const i in d){if(d[i].location>=0){const r=o[i];let a=c[i];if(void 0===a&&("instanceMatrix"===i&&t.instanceMatrix&&(a=t.instanceMatrix),"instanceColor"===i&&t.instanceColor&&(a=t.instanceColor)),void 0===r)return!0;if(r.attribute!==a)return!0;if(a&&r.data!==a.data)return!0;h++}}return l.attributesNum!==h||l.index!==a}(r,d,h,u),p&&function saveCache(t,i,r,a){const o={},c=i.attributes;let h=0;const d=r.getAttributes();for(const i in d){if(d[i].location>=0){let r=c[i];void 0===r&&("instanceMatrix"===i&&t.instanceMatrix&&(r=t.instanceMatrix),"instanceColor"===i&&t.instanceColor&&(r=t.instanceColor));const a={};a.attribute=r,r&&r.data&&(a.data=r.data),o[i]=a,h++}}l.attributes=o,l.attributesNum=h,l.index=a}(r,d,h,u),null!==u&&i.update(u,t.ELEMENT_ARRAY_BUFFER),(p||c)&&(c=!1,function setupVertexAttributes(r,a,o,l){initAttributes();const c=l.attributes,h=o.getAttributes(),d=a.defaultAttributeValues;for(const a in h){const o=h[a];if(o.location>=0){let h=c[a];if(void 0===h&&("instanceMatrix"===a&&r.instanceMatrix&&(h=r.instanceMatrix),"instanceColor"===a&&r.instanceColor&&(h=r.instanceColor)),void 0!==h){const a=h.normalized,c=h.itemSize,d=i.get(h);if(void 0===d)continue;const u=d.buffer,p=d.type,m=d.bytesPerElement,g=p===t.INT||p===t.UNSIGNED_INT||h.gpuType===le;if(h.isInterleavedBufferAttribute){const i=h.data,d=i.stride,y=h.offset;if(i.isInstancedInterleavedBuffer){for(let t=0;t<o.locationSize;t++)enableAttributeAndDivisor(o.location+t,i.meshPerAttribute);!0!==r.isInstancedMesh&&void 0===l._maxInstanceCount&&(l._maxInstanceCount=i.meshPerAttribute*i.count)}else for(let t=0;t<o.locationSize;t++)enableAttribute(o.location+t);t.bindBuffer(t.ARRAY_BUFFER,u);for(let t=0;t<o.locationSize;t++)vertexAttribPointer(o.location+t,c/o.locationSize,p,a,d*m,(y+c/o.locationSize*t)*m,g)}else{if(h.isInstancedBufferAttribute){for(let t=0;t<o.locationSize;t++)enableAttributeAndDivisor(o.location+t,h.meshPerAttribute);!0!==r.isInstancedMesh&&void 0===l._maxInstanceCount&&(l._maxInstanceCount=h.meshPerAttribute*h.count)}else for(let t=0;t<o.locationSize;t++)enableAttribute(o.location+t);t.bindBuffer(t.ARRAY_BUFFER,u);for(let t=0;t<o.locationSize;t++)vertexAttribPointer(o.location+t,c/o.locationSize,p,a,c*m,c/o.locationSize*t*m,g)}}else if(void 0!==d){const i=d[a];if(void 0!==i)switch(i.length){case 2:t.vertexAttrib2fv(o.location,i);break;case 3:t.vertexAttrib3fv(o.location,i);break;case 4:t.vertexAttrib4fv(o.location,i);break;default:t.vertexAttrib1fv(o.location,i)}}}}disableUnusedAttributes()}(r,o,h,d),null!==u&&t.bindBuffer(t.ELEMENT_ARRAY_BUFFER,i.get(u).buffer))},reset,resetDefaultState,dispose:function dispose(){reset();for(const t in a){const i=a[t];for(const t in i){const r=i[t];for(const t in r)deleteVertexArrayObject(r[t].object),delete r[t];delete i[t]}delete a[t]}},releaseStatesOfGeometry:function releaseStatesOfGeometry(t){if(void 0===a[t.id])return;const i=a[t.id];for(const t in i){const r=i[t];for(const t in r)deleteVertexArrayObject(r[t].object),delete r[t];delete i[t]}delete a[t.id]},releaseStatesOfProgram:function releaseStatesOfProgram(t){for(const i in a){const r=a[i];if(void 0===r[t.id])continue;const o=r[t.id];for(const t in o)deleteVertexArrayObject(o[t].object),delete o[t];delete r[t.id]}},initAttributes,enableAttribute,disableUnusedAttributes}}function WebGLBufferRenderer(t,i,r){let a;function renderInstances(i,o,l){0!==l&&(t.drawArraysInstanced(a,i,o,l),r.update(o,a,l))}this.setMode=function setMode(t){a=t},this.render=function render(i,o){t.drawArrays(a,i,o),r.update(o,a,1)},this.renderInstances=renderInstances,this.renderMultiDraw=function renderMultiDraw(t,o,l){if(0===l)return;i.get("WEBGL_multi_draw").multiDrawArraysWEBGL(a,t,0,o,0,l);let c=0;for(let t=0;t<l;t++)c+=o[t];r.update(c,a,1)},this.renderMultiDrawInstances=function renderMultiDrawInstances(t,o,l,c){if(0===l)return;const h=i.get("WEBGL_multi_draw");if(null===h)for(let i=0;i<t.length;i++)renderInstances(t[i],o[i],c[i]);else{h.multiDrawArraysInstancedWEBGL(a,t,0,o,0,c,0,l);let i=0;for(let t=0;t<l;t++)i+=o[t]*c[t];r.update(i,a,1)}}}function WebGLCapabilities(t,i,r,a){let o;function getMaxPrecision(i){if("highp"===i){if(t.getShaderPrecisionFormat(t.VERTEX_SHADER,t.HIGH_FLOAT).precision>0&&t.getShaderPrecisionFormat(t.FRAGMENT_SHADER,t.HIGH_FLOAT).precision>0)return"highp";i="mediump"}return"mediump"===i&&t.getShaderPrecisionFormat(t.VERTEX_SHADER,t.MEDIUM_FLOAT).precision>0&&t.getShaderPrecisionFormat(t.FRAGMENT_SHADER,t.MEDIUM_FLOAT).precision>0?"mediump":"lowp"}let l=void 0!==r.precision?r.precision:"highp";const c=getMaxPrecision(l);c!==l&&(l=c);const h=!0===r.logarithmicDepthBuffer,d=!0===r.reverseDepthBuffer&&i.has("EXT_clip_control"),u=t.getParameter(t.MAX_TEXTURE_IMAGE_UNITS),p=t.getParameter(t.MAX_VERTEX_TEXTURE_IMAGE_UNITS);return{isWebGL2:!0,getMaxAnisotropy:function getMaxAnisotropy(){if(void 0!==o)return o;if(!0===i.has("EXT_texture_filter_anisotropic")){const r=i.get("EXT_texture_filter_anisotropic");o=t.getParameter(r.MAX_TEXTURE_MAX_ANISOTROPY_EXT)}else o=0;return o},getMaxPrecision,textureFormatReadable:function textureFormatReadable(i){return i===ge||a.convert(i)===t.getParameter(t.IMPLEMENTATION_COLOR_READ_FORMAT)},textureTypeReadable:function textureTypeReadable(r){const o=r===de&&(i.has("EXT_color_buffer_half_float")||i.has("EXT_color_buffer_float"));return!(r!==re&&a.convert(r)!==t.getParameter(t.IMPLEMENTATION_COLOR_READ_TYPE)&&r!==he&&!o)},precision:l,logarithmicDepthBuffer:h,reverseDepthBuffer:d,maxTextures:u,maxVertexTextures:p,maxTextureSize:t.getParameter(t.MAX_TEXTURE_SIZE),maxCubemapSize:t.getParameter(t.MAX_CUBE_MAP_TEXTURE_SIZE),maxAttributes:t.getParameter(t.MAX_VERTEX_ATTRIBS),maxVertexUniforms:t.getParameter(t.MAX_VERTEX_UNIFORM_VECTORS),maxVaryings:t.getParameter(t.MAX_VARYING_VECTORS),maxFragmentUniforms:t.getParameter(t.MAX_FRAGMENT_UNIFORM_VECTORS),vertexTextures:p>0,maxSamples:t.getParameter(t.MAX_SAMPLES)}}function WebGLClipping(t){const i=this;let r=null,a=0,o=!1,l=!1;const c=new Plane,h=new Matrix3,d={value:null,needsUpdate:!1};function projectPlanes(t,r,a,o){const l=null!==t?t.length:0;let u=null;if(0!==l){if(u=d.value,!0!==o||null===u){const i=a+4*l,o=r.matrixWorldInverse;h.getNormalMatrix(o),(null===u||u.length<i)&&(u=new Float32Array(i));for(let i=0,r=a;i!==l;++i,r+=4)c.copy(t[i]).applyMatrix4(o,h),c.normal.toArray(u,r),u[r+3]=c.constant}d.value=u,d.needsUpdate=!0}return i.numPlanes=l,i.numIntersection=0,u}this.uniform=d,this.numPlanes=0,this.numIntersection=0,this.init=function(t,i){const r=0!==t.length||i||0!==a||o;return o=i,a=t.length,r},this.beginShadows=function(){l=!0,projectPlanes(null)},this.endShadows=function(){l=!1},this.setGlobalState=function(t,i){r=projectPlanes(t,i,0)},this.setState=function(c,h,u){const p=c.clippingPlanes,m=c.clipIntersection,g=c.clipShadows,y=t.get(c);if(!o||null===p||0===p.length||l&&!g)l?projectPlanes(null):function resetGlobalState(){d.value!==r&&(d.value=r,d.needsUpdate=a>0);i.numPlanes=a,i.numIntersection=0}();else{const t=l?0:a,i=4*t;let o=y.clippingState||null;d.value=o,o=projectPlanes(p,h,i,u);for(let t=0;t!==i;++t)o[t]=r[t];y.clippingState=o,this.numIntersection=m?this.numPlanes:0,this.numPlanes+=t}}}function WebGLCubeMaps(t){let i=new WeakMap;function mapTextureMapping(t,i){return 303===i?t.mapping=j:304===i&&(t.mapping=X),t}function onTextureDispose(t){const r=t.target;r.removeEventListener("dispose",onTextureDispose);const a=i.get(r);void 0!==a&&(i.delete(r),a.dispose())}return{get:function get(r){if(r&&r.isTexture){const a=r.mapping;if(303===a||304===a){if(i.has(r)){return mapTextureMapping(i.get(r).texture,r.mapping)}{const a=r.image;if(a&&a.height>0){const o=new WebGLCubeRenderTarget(a.height);return o.fromEquirectangularTexture(t,r),i.set(r,o),r.addEventListener("dispose",onTextureDispose),mapTextureMapping(o.texture,r.mapping)}return null}}}return r},dispose:function dispose(){i=new WeakMap}}}const es=[.125,.215,.35,.446,.526,.582],ts=20,is=new OrthographicCamera,ns=new $i;let rs=null,ss=0,as=0,os=!1;const ls=(1+Math.sqrt(5))/2,cs=1/ls,hs=[new Vector3(-ls,cs,0),new Vector3(ls,cs,0),new Vector3(-cs,0,ls),new Vector3(cs,0,ls),new Vector3(0,ls,-cs),new Vector3(0,ls,cs),new Vector3(-1,1,-1),new Vector3(1,1,-1),new Vector3(-1,1,1),new Vector3(1,1,1)];class PMREMGenerator{constructor(t){this._renderer=t,this._pingPongRenderTarget=null,this._lodMax=0,this._cubeSize=0,this._lodPlanes=[],this._sizeLods=[],this._sigmas=[],this._blurMaterial=null,this._cubemapMaterial=null,this._equirectMaterial=null,this._compileMaterial(this._blurMaterial)}fromScene(t,i=0,r=.1,a=100){rs=this._renderer.getRenderTarget(),ss=this._renderer.getActiveCubeFace(),as=this._renderer.getActiveMipmapLevel(),os=this._renderer.xr.enabled,this._renderer.xr.enabled=!1,this._setSize(256);const o=this._allocateTargets();return o.depthBuffer=!0,this._sceneToCubeUV(t,r,a,o),i>0&&this._blur(o,0,0,i),this._applyPMREM(o),this._cleanup(o),o}fromEquirectangular(t,i=null){return this._fromTexture(t,i)}fromCubemap(t,i=null){return this._fromTexture(t,i)}compileCubemapShader(){null===this._cubemapMaterial&&(this._cubemapMaterial=_getCubemapMaterial(),this._compileMaterial(this._cubemapMaterial))}compileEquirectangularShader(){null===this._equirectMaterial&&(this._equirectMaterial=_getEquirectMaterial(),this._compileMaterial(this._equirectMaterial))}dispose(){this._dispose(),null!==this._cubemapMaterial&&this._cubemapMaterial.dispose(),null!==this._equirectMaterial&&this._equirectMaterial.dispose()}_setSize(t){this._lodMax=Math.floor(Math.log2(t)),this._cubeSize=Math.pow(2,this._lodMax)}_dispose(){null!==this._blurMaterial&&this._blurMaterial.dispose(),null!==this._pingPongRenderTarget&&this._pingPongRenderTarget.dispose();for(let t=0;t<this._lodPlanes.length;t++)this._lodPlanes[t].dispose()}_cleanup(t){this._renderer.setRenderTarget(rs,ss,as),this._renderer.xr.enabled=os,t.scissorTest=!1,_setViewport(t,0,0,t.width,t.height)}_fromTexture(t,i){t.mapping===j||t.mapping===X?this._setSize(0===t.image.length?16:t.image[0].width||t.image[0].image.width):this._setSize(t.image.width/4),rs=this._renderer.getRenderTarget(),ss=this._renderer.getActiveCubeFace(),as=this._renderer.getActiveMipmapLevel(),os=this._renderer.xr.enabled,this._renderer.xr.enabled=!1;const r=i||this._allocateTargets();return this._textureToCubeUV(t,r),this._applyPMREM(r),this._cleanup(r),r}_allocateTargets(){const t=3*Math.max(this._cubeSize,112),i=4*this._cubeSize,r={magFilter:te,minFilter:te,generateMipmaps:!1,type:de,format:ge,colorSpace:ct,depthBuffer:!1},a=_createRenderTarget(t,i,r);if(null===this._pingPongRenderTarget||this._pingPongRenderTarget.width!==t||this._pingPongRenderTarget.height!==i){null!==this._pingPongRenderTarget&&this._dispose(),this._pingPongRenderTarget=_createRenderTarget(t,i,r);const{_lodMax:a}=this;({sizeLods:this._sizeLods,lodPlanes:this._lodPlanes,sigmas:this._sigmas}=function _createPlanes(t){const i=[],r=[],a=[];let o=t;const l=t-4+1+es.length;for(let c=0;c<l;c++){const l=Math.pow(2,o);r.push(l);let h=1/l;c>t-4?h=es[c-t+4-1]:0===c&&(h=0),a.push(h);const d=1/(l-2),u=-d,p=1+d,m=[u,u,p,u,p,p,u,u,p,p,u,p],g=6,y=6,v=3,x=2,b=1,_=new Float32Array(v*y*g),S=new Float32Array(x*y*g),M=new Float32Array(b*y*g);for(let t=0;t<g;t++){const i=t%3*2/3-1,r=t>2?0:-1,a=[i,r,0,i+2/3,r,0,i+2/3,r+1,0,i,r,0,i+2/3,r+1,0,i,r+1,0];_.set(a,v*y*t),S.set(m,x*y*t);const o=[t,t,t,t,t,t];M.set(o,b*y*t)}const w=new BufferGeometry;w.setAttribute("position",new BufferAttribute(_,v)),w.setAttribute("uv",new BufferAttribute(S,x)),w.setAttribute("faceIndex",new BufferAttribute(M,b)),i.push(w),o>4&&o--}return{lodPlanes:i,sizeLods:r,sigmas:a}}(a)),this._blurMaterial=function _getBlurShader(t,i,r){const a=new Float32Array(ts),o=new Vector3(0,1,0),l=new ShaderMaterial({name:"SphericalGaussianBlur",defines:{n:ts,CUBEUV_TEXEL_WIDTH:1/i,CUBEUV_TEXEL_HEIGHT:1/r,CUBEUV_MAX_MIP:`${t}.0`},uniforms:{envMap:{value:null},samples:{value:1},weights:{value:a},latitudinal:{value:!1},dTheta:{value:0},mipInt:{value:0},poleAxis:{value:o}},vertexShader:_getCommonVertexShader(),fragmentShader:"\n\n\t\t\tprecision mediump float;\n\t\t\tprecision mediump int;\n\n\t\t\tvarying vec3 vOutputDirection;\n\n\t\t\tuniform sampler2D envMap;\n\t\t\tuniform int samples;\n\t\t\tuniform float weights[ n ];\n\t\t\tuniform bool latitudinal;\n\t\t\tuniform float dTheta;\n\t\t\tuniform float mipInt;\n\t\t\tuniform vec3 poleAxis;\n\n\t\t\t#define ENVMAP_TYPE_CUBE_UV\n\t\t\t#include <cube_uv_reflection_fragment>\n\n\t\t\tvec3 getSample( float theta, vec3 axis ) {\n\n\t\t\t\tfloat cosTheta = cos( theta );\n\t\t\t\t// Rodrigues' axis-angle rotation\n\t\t\t\tvec3 sampleDirection = vOutputDirection * cosTheta\n\t\t\t\t\t+ cross( axis, vOutputDirection ) * sin( theta )\n\t\t\t\t\t+ axis * dot( axis, vOutputDirection ) * ( 1.0 - cosTheta );\n\n\t\t\t\treturn bilinearCubeUV( envMap, sampleDirection, mipInt );\n\n\t\t\t}\n\n\t\t\tvoid main() {\n\n\t\t\t\tvec3 axis = latitudinal ? poleAxis : cross( poleAxis, vOutputDirection );\n\n\t\t\t\tif ( all( equal( axis, vec3( 0.0 ) ) ) ) {\n\n\t\t\t\t\taxis = vec3( vOutputDirection.z, 0.0, - vOutputDirection.x );\n\n\t\t\t\t}\n\n\t\t\t\taxis = normalize( axis );\n\n\t\t\t\tgl_FragColor = vec4( 0.0, 0.0, 0.0, 1.0 );\n\t\t\t\tgl_FragColor.rgb += weights[ 0 ] * getSample( 0.0, axis );\n\n\t\t\t\tfor ( int i = 1; i < n; i++ ) {\n\n\t\t\t\t\tif ( i >= samples ) {\n\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\t}\n\n\t\t\t\t\tfloat theta = dTheta * float( i );\n\t\t\t\t\tgl_FragColor.rgb += weights[ i ] * getSample( -1.0 * theta, axis );\n\t\t\t\t\tgl_FragColor.rgb += weights[ i ] * getSample( theta, axis );\n\n\t\t\t\t}\n\n\t\t\t}\n\t\t",blending:0,depthTest:!1,depthWrite:!1});return l}(a,t,i)}return a}_compileMaterial(t){const i=new Mesh(this._lodPlanes[0],t);this._renderer.compile(i,is)}_sceneToCubeUV(t,i,r,a){const o=new PerspectiveCamera(90,1,i,r),l=[1,-1,1,1,1,1],c=[1,1,1,-1,-1,-1],h=this._renderer,d=h.autoClear,u=h.toneMapping;h.getClearColor(ns),h.toneMapping=0,h.autoClear=!1;const p=new MeshBasicMaterial({name:"PMREM.Background",side:1,depthWrite:!1,depthTest:!1}),m=new Mesh(new BoxGeometry,p);let g=!1;const y=t.background;y?y.isColor&&(p.color.copy(y),t.background=null,g=!0):(p.color.copy(ns),g=!0);for(let i=0;i<6;i++){const r=i%3;0===r?(o.up.set(0,l[i],0),o.lookAt(c[i],0,0)):1===r?(o.up.set(0,0,l[i]),o.lookAt(0,c[i],0)):(o.up.set(0,l[i],0),o.lookAt(0,0,c[i]));const d=this._cubeSize;_setViewport(a,r*d,i>2?d:0,d,d),h.setRenderTarget(a),g&&h.render(m,o),h.render(t,o)}m.geometry.dispose(),m.material.dispose(),h.toneMapping=u,h.autoClear=d,t.background=y}_textureToCubeUV(t,i){const r=this._renderer,a=t.mapping===j||t.mapping===X;a?(null===this._cubemapMaterial&&(this._cubemapMaterial=_getCubemapMaterial()),this._cubemapMaterial.uniforms.flipEnvMap.value=!1===t.isRenderTargetTexture?-1:1):null===this._equirectMaterial&&(this._equirectMaterial=_getEquirectMaterial());const o=a?this._cubemapMaterial:this._equirectMaterial,l=new Mesh(this._lodPlanes[0],o);o.uniforms.envMap.value=t;const c=this._cubeSize;_setViewport(i,0,0,3*c,2*c),r.setRenderTarget(i),r.render(l,is)}_applyPMREM(t){const i=this._renderer,r=i.autoClear;i.autoClear=!1;const a=this._lodPlanes.length;for(let i=1;i<a;i++){const r=Math.sqrt(this._sigmas[i]*this._sigmas[i]-this._sigmas[i-1]*this._sigmas[i-1]),o=hs[(a-i-1)%hs.length];this._blur(t,i-1,i,r,o)}i.autoClear=r}_blur(t,i,r,a,o){const l=this._pingPongRenderTarget;this._halfBlur(t,l,i,r,a,"latitudinal",o),this._halfBlur(l,t,r,r,a,"longitudinal",o)}_halfBlur(t,i,r,a,o,l,c){const h=this._renderer,d=this._blurMaterial,u=new Mesh(this._lodPlanes[a],d),p=d.uniforms,m=this._sizeLods[r]-1,g=isFinite(o)?Math.PI/(2*m):2*Math.PI/39,y=o/g,v=isFinite(o)?1+Math.floor(3*y):ts,x=[];let b=0;for(let t=0;t<ts;++t){const i=t/y,r=Math.exp(-i*i/2);x.push(r),0===t?b+=r:t<v&&(b+=2*r)}for(let t=0;t<x.length;t++)x[t]=x[t]/b;p.envMap.value=t.texture,p.samples.value=v,p.weights.value=x,p.latitudinal.value="latitudinal"===l,c&&(p.poleAxis.value=c);const{_lodMax:_}=this;p.dTheta.value=g,p.mipInt.value=_-r;const S=this._sizeLods[a];_setViewport(i,3*S*(a>_-4?a-_+4:0),4*(this._cubeSize-S),3*S,2*S),h.setRenderTarget(i),h.render(u,is)}}function _createRenderTarget(t,i,r){const a=new WebGLRenderTarget(t,i,r);return a.texture.mapping=q,a.texture.name="PMREM.cubeUv",a.scissorTest=!0,a}function _setViewport(t,i,r,a,o){t.viewport.set(i,r,a,o),t.scissor.set(i,r,a,o)}function _getEquirectMaterial(){return new ShaderMaterial({name:"EquirectangularToCubeUV",uniforms:{envMap:{value:null}},vertexShader:_getCommonVertexShader(),fragmentShader:"\n\n\t\t\tprecision mediump float;\n\t\t\tprecision mediump int;\n\n\t\t\tvarying vec3 vOutputDirection;\n\n\t\t\tuniform sampler2D envMap;\n\n\t\t\t#include <common>\n\n\t\t\tvoid main() {\n\n\t\t\t\tvec3 outputDirection = normalize( vOutputDirection );\n\t\t\t\tvec2 uv = equirectUv( outputDirection );\n\n\t\t\t\tgl_FragColor = vec4( texture2D ( envMap, uv ).rgb, 1.0 );\n\n\t\t\t}\n\t\t",blending:0,depthTest:!1,depthWrite:!1})}function _getCubemapMaterial(){return new ShaderMaterial({name:"CubemapToCubeUV",uniforms:{envMap:{value:null},flipEnvMap:{value:-1}},vertexShader:_getCommonVertexShader(),fragmentShader:"\n\n\t\t\tprecision mediump float;\n\t\t\tprecision mediump int;\n\n\t\t\tuniform float flipEnvMap;\n\n\t\t\tvarying vec3 vOutputDirection;\n\n\t\t\tuniform samplerCube envMap;\n\n\t\t\tvoid main() {\n\n\t\t\t\tgl_FragColor = textureCube( envMap, vec3( flipEnvMap * vOutputDirection.x, vOutputDirection.yz ) );\n\n\t\t\t}\n\t\t",blending:0,depthTest:!1,depthWrite:!1})}function _getCommonVertexShader(){return"\n\n\t\tprecision mediump float;\n\t\tprecision mediump int;\n\n\t\tattribute float faceIndex;\n\n\t\tvarying vec3 vOutputDirection;\n\n\t\t// RH coordinate system; PMREM face-indexing convention\n\t\tvec3 getDirection( vec2 uv, float face ) {\n\n\t\t\tuv = 2.0 * uv - 1.0;\n\n\t\t\tvec3 direction = vec3( uv, 1.0 );\n\n\t\t\tif ( face == 0.0 ) {\n\n\t\t\t\tdirection = direction.zyx; // ( 1, v, u ) pos x\n\n\t\t\t} else if ( face == 1.0 ) {\n\n\t\t\t\tdirection = direction.xzy;\n\t\t\t\tdirection.xz *= -1.0; // ( -u, 1, -v ) pos y\n\n\t\t\t} else if ( face == 2.0 ) {\n\n\t\t\t\tdirection.x *= -1.0; // ( -u, v, 1 ) pos z\n\n\t\t\t} else if ( face == 3.0 ) {\n\n\t\t\t\tdirection = direction.zyx;\n\t\t\t\tdirection.xz *= -1.0; // ( -1, v, -u ) neg x\n\n\t\t\t} else if ( face == 4.0 ) {\n\n\t\t\t\tdirection = direction.xzy;\n\t\t\t\tdirection.xy *= -1.0; // ( -u, -1, v ) neg y\n\n\t\t\t} else if ( face == 5.0 ) {\n\n\t\t\t\tdirection.z *= -1.0; // ( u, v, -1 ) neg z\n\n\t\t\t}\n\n\t\t\treturn direction;\n\n\t\t}\n\n\t\tvoid main() {\n\n\t\t\tvOutputDirection = getDirection( uv, faceIndex );\n\t\t\tgl_Position = vec4( position, 1.0 );\n\n\t\t}\n\t"}function WebGLCubeUVMaps(t){let i=new WeakMap,r=null;function onTextureDispose(t){const r=t.target;r.removeEventListener("dispose",onTextureDispose);const a=i.get(r);void 0!==a&&(i.delete(r),a.dispose())}return{get:function get(a){if(a&&a.isTexture){const o=a.mapping,l=303===o||304===o,c=o===j||o===X;if(l||c){let o=i.get(a);const h=void 0!==o?o.texture.pmremVersion:0;if(a.isRenderTargetTexture&&a.pmremVersion!==h)return null===r&&(r=new PMREMGenerator(t)),o=l?r.fromEquirectangular(a,o):r.fromCubemap(a,o),o.texture.pmremVersion=a.pmremVersion,i.set(a,o),o.texture;if(void 0!==o)return o.texture;{const h=a.image;return l&&h&&h.height>0||c&&h&&function isCubeTextureComplete(t){let i=0;const r=6;for(let a=0;a<r;a++)void 0!==t[a]&&i++;return i===r}(h)?(null===r&&(r=new PMREMGenerator(t)),o=l?r.fromEquirectangular(a):r.fromCubemap(a),o.texture.pmremVersion=a.pmremVersion,i.set(a,o),a.addEventListener("dispose",onTextureDispose),o.texture):null}}}return a},dispose:function dispose(){i=new WeakMap,null!==r&&(r.dispose(),r=null)}}}function WebGLExtensions(t){const i={};function getExtension(r){if(void 0!==i[r])return i[r];let a;switch(r){case"WEBGL_depth_texture":a=t.getExtension("WEBGL_depth_texture")||t.getExtension("MOZ_WEBGL_depth_texture")||t.getExtension("WEBKIT_WEBGL_depth_texture");break;case"EXT_texture_filter_anisotropic":a=t.getExtension("EXT_texture_filter_anisotropic")||t.getExtension("MOZ_EXT_texture_filter_anisotropic")||t.getExtension("WEBKIT_EXT_texture_filter_anisotropic");break;case"WEBGL_compressed_texture_s3tc":a=t.getExtension("WEBGL_compressed_texture_s3tc")||t.getExtension("MOZ_WEBGL_compressed_texture_s3tc")||t.getExtension("WEBKIT_WEBGL_compressed_texture_s3tc");break;case"WEBGL_compressed_texture_pvrtc":a=t.getExtension("WEBGL_compressed_texture_pvrtc")||t.getExtension("WEBKIT_WEBGL_compressed_texture_pvrtc");break;default:a=t.getExtension(r)}return i[r]=a,a}return{has:function(t){return null!==getExtension(t)},init:function(){getExtension("EXT_color_buffer_float"),getExtension("WEBGL_clip_cull_distance"),getExtension("OES_texture_float_linear"),getExtension("EXT_color_buffer_half_float"),getExtension("WEBGL_multisampled_render_to_texture"),getExtension("WEBGL_render_shared_exponent")},get:function(t){const i=getExtension(t);return null===i&&warnOnce("THREE.WebGLRenderer: "+t+" extension not supported."),i}}}function WebGLGeometries(t,i,r,a){const o={},l=new WeakMap;function onGeometryDispose(t){const c=t.target;null!==c.index&&i.remove(c.index);for(const t in c.attributes)i.remove(c.attributes[t]);c.removeEventListener("dispose",onGeometryDispose),delete o[c.id];const h=l.get(c);h&&(i.remove(h),l.delete(c)),a.releaseStatesOfGeometry(c),!0===c.isInstancedBufferGeometry&&delete c._maxInstanceCount,r.memory.geometries--}function updateWireframeAttribute(t){const r=[],a=t.index,o=t.attributes.position;let c=0;if(null!==a){const t=a.array;c=a.version;for(let i=0,a=t.length;i<a;i+=3){const a=t[i+0],o=t[i+1],l=t[i+2];r.push(a,o,o,l,l,a)}}else{if(void 0===o)return;{const t=o.array;c=o.version;for(let i=0,a=t.length/3-1;i<a;i+=3){const t=i+0,a=i+1,o=i+2;r.push(t,a,a,o,o,t)}}}const h=new(arrayNeedsUint32(r)?Uint32BufferAttribute:Uint16BufferAttribute)(r,1);h.version=c;const d=l.get(t);d&&i.remove(d),l.set(t,h)}return{get:function get(t,i){return!0===o[i.id]||(i.addEventListener("dispose",onGeometryDispose),o[i.id]=!0,r.memory.geometries++),i},update:function update(r){const a=r.attributes;for(const r in a)i.update(a[r],t.ARRAY_BUFFER)},getWireframeAttribute:function getWireframeAttribute(t){const i=l.get(t);if(i){const r=t.index;null!==r&&i.version<r.version&&updateWireframeAttribute(t)}else updateWireframeAttribute(t);return l.get(t)}}}function WebGLIndexedBufferRenderer(t,i,r){let a,o,l;function renderInstances(i,c,h){0!==h&&(t.drawElementsInstanced(a,c,o,i*l,h),r.update(c,a,h))}this.setMode=function setMode(t){a=t},this.setIndex=function setIndex(t){o=t.type,l=t.bytesPerElement},this.render=function render(i,c){t.drawElements(a,c,o,i*l),r.update(c,a,1)},this.renderInstances=renderInstances,this.renderMultiDraw=function renderMultiDraw(t,l,c){if(0===c)return;i.get("WEBGL_multi_draw").multiDrawElementsWEBGL(a,l,0,o,t,0,c);let h=0;for(let t=0;t<c;t++)h+=l[t];r.update(h,a,1)},this.renderMultiDrawInstances=function renderMultiDrawInstances(t,c,h,d){if(0===h)return;const u=i.get("WEBGL_multi_draw");if(null===u)for(let i=0;i<t.length;i++)renderInstances(t[i]/l,c[i],d[i]);else{u.multiDrawElementsInstancedWEBGL(a,c,0,o,t,0,d,0,h);let i=0;for(let t=0;t<h;t++)i+=c[t]*d[t];r.update(i,a,1)}}}function WebGLInfo(t){const i={frame:0,calls:0,triangles:0,points:0,lines:0};return{memory:{geometries:0,textures:0},render:i,programs:null,autoReset:!0,reset:function reset(){i.calls=0,i.triangles=0,i.points=0,i.lines=0},update:function update(r,a,o){switch(i.calls++,a){case t.TRIANGLES:i.triangles+=o*(r/3);break;case t.LINES:i.lines+=o*(r/2);break;case t.LINE_STRIP:i.lines+=o*(r-1);break;case t.LINE_LOOP:i.lines+=o*r;break;case t.POINTS:i.points+=o*r}}}}function WebGLMorphtargets(t,i,r){const a=new WeakMap,o=new Vector4;return{update:function update(l,c,h){const d=l.morphTargetInfluences,u=c.morphAttributes.position||c.morphAttributes.normal||c.morphAttributes.color,p=void 0!==u?u.length:0;let m=a.get(c);if(void 0===m||m.count!==p){void 0!==m&&m.texture.dispose();const g=void 0!==c.morphAttributes.position,y=void 0!==c.morphAttributes.normal,v=void 0!==c.morphAttributes.color,x=c.morphAttributes.position||[],b=c.morphAttributes.normal||[],_=c.morphAttributes.color||[];let S=0;!0===g&&(S=1),!0===y&&(S=2),!0===v&&(S=3);let M=c.attributes.position.count*S,w=1;M>i.maxTextureSize&&(w=Math.ceil(M/i.maxTextureSize),M=i.maxTextureSize);const T=new Float32Array(M*w*4*p),E=new DataArrayTexture(T,M,w,p);E.type=he,E.needsUpdate=!0;const A=4*S;for(let C=0;C<p;C++){const P=x[C],R=b[C],I=_[C],D=M*w*4*C;for(let L=0;L<P.count;L++){const N=L*A;!0===g&&(o.fromBufferAttribute(P,L),T[D+N+0]=o.x,T[D+N+1]=o.y,T[D+N+2]=o.z,T[D+N+3]=0),!0===y&&(o.fromBufferAttribute(R,L),T[D+N+4]=o.x,T[D+N+5]=o.y,T[D+N+6]=o.z,T[D+N+7]=0),!0===v&&(o.fromBufferAttribute(I,L),T[D+N+8]=o.x,T[D+N+9]=o.y,T[D+N+10]=o.z,T[D+N+11]=4===I.itemSize?o.w:1)}}function disposeTexture(){E.dispose(),a.delete(c),c.removeEventListener("dispose",disposeTexture)}m={count:p,texture:E,size:new Vector2(M,w)},a.set(c,m),c.addEventListener("dispose",disposeTexture)}if(!0===l.isInstancedMesh&&null!==l.morphTexture)h.getUniforms().setValue(t,"morphTexture",l.morphTexture,r);else{let O=0;for(let B=0;B<d.length;B++)O+=d[B];const U=c.morphTargetsRelative?1:1-O;h.getUniforms().setValue(t,"morphTargetBaseInfluence",U),h.getUniforms().setValue(t,"morphTargetInfluences",d)}h.getUniforms().setValue(t,"morphTargetsTexture",m.texture,r),h.getUniforms().setValue(t,"morphTargetsTextureSize",m.size)}}}function WebGLObjects(t,i,r,a){let o=new WeakMap;function onInstancedMeshDispose(t){const i=t.target;i.removeEventListener("dispose",onInstancedMeshDispose),r.remove(i.instanceMatrix),null!==i.instanceColor&&r.remove(i.instanceColor)}return{update:function update(l){const c=a.render.frame,h=l.geometry,d=i.get(l,h);if(o.get(d)!==c&&(i.update(d),o.set(d,c)),l.isInstancedMesh&&(!1===l.hasEventListener("dispose",onInstancedMeshDispose)&&l.addEventListener("dispose",onInstancedMeshDispose),o.get(l)!==c&&(r.update(l.instanceMatrix,t.ARRAY_BUFFER),null!==l.instanceColor&&r.update(l.instanceColor,t.ARRAY_BUFFER),o.set(l,c))),l.isSkinnedMesh){const t=l.skeleton;o.get(t)!==c&&(t.update(),o.set(t,c))}return d},dispose:function dispose(){o=new WeakMap}}}const ds=new Texture,us=new DepthTexture(1,1),ps=new DataArrayTexture,ms=new Data3DTexture,fs=new CubeTexture,gs=[],ys=[],vs=new Float32Array(16),xs=new Float32Array(9),bs=new Float32Array(4);function flatten(t,i,r){const a=t[0];if(a<=0||a>0)return t;const o=i*r;let l=gs[o];if(void 0===l&&(l=new Float32Array(o),gs[o]=l),0!==i){a.toArray(l,0);for(let a=1,o=0;a!==i;++a)o+=r,t[a].toArray(l,o)}return l}function arraysEqual(t,i){if(t.length!==i.length)return!1;for(let r=0,a=t.length;r<a;r++)if(t[r]!==i[r])return!1;return!0}function copyArray(t,i){for(let r=0,a=i.length;r<a;r++)t[r]=i[r]}function allocTexUnits(t,i){let r=ys[i];void 0===r&&(r=new Int32Array(i),ys[i]=r);for(let a=0;a!==i;++a)r[a]=t.allocateTextureUnit();return r}function setValueV1f(t,i){const r=this.cache;r[0]!==i&&(t.uniform1f(this.addr,i),r[0]=i)}function setValueV2f(t,i){const r=this.cache;if(void 0!==i.x)r[0]===i.x&&r[1]===i.y||(t.uniform2f(this.addr,i.x,i.y),r[0]=i.x,r[1]=i.y);else{if(arraysEqual(r,i))return;t.uniform2fv(this.addr,i),copyArray(r,i)}}function setValueV3f(t,i){const r=this.cache;if(void 0!==i.x)r[0]===i.x&&r[1]===i.y&&r[2]===i.z||(t.uniform3f(this.addr,i.x,i.y,i.z),r[0]=i.x,r[1]=i.y,r[2]=i.z);else if(void 0!==i.r)r[0]===i.r&&r[1]===i.g&&r[2]===i.b||(t.uniform3f(this.addr,i.r,i.g,i.b),r[0]=i.r,r[1]=i.g,r[2]=i.b);else{if(arraysEqual(r,i))return;t.uniform3fv(this.addr,i),copyArray(r,i)}}function setValueV4f(t,i){const r=this.cache;if(void 0!==i.x)r[0]===i.x&&r[1]===i.y&&r[2]===i.z&&r[3]===i.w||(t.uniform4f(this.addr,i.x,i.y,i.z,i.w),r[0]=i.x,r[1]=i.y,r[2]=i.z,r[3]=i.w);else{if(arraysEqual(r,i))return;t.uniform4fv(this.addr,i),copyArray(r,i)}}function setValueM2(t,i){const r=this.cache,a=i.elements;if(void 0===a){if(arraysEqual(r,i))return;t.uniformMatrix2fv(this.addr,!1,i),copyArray(r,i)}else{if(arraysEqual(r,a))return;bs.set(a),t.uniformMatrix2fv(this.addr,!1,bs),copyArray(r,a)}}function setValueM3(t,i){const r=this.cache,a=i.elements;if(void 0===a){if(arraysEqual(r,i))return;t.uniformMatrix3fv(this.addr,!1,i),copyArray(r,i)}else{if(arraysEqual(r,a))return;xs.set(a),t.uniformMatrix3fv(this.addr,!1,xs),copyArray(r,a)}}function setValueM4(t,i){const r=this.cache,a=i.elements;if(void 0===a){if(arraysEqual(r,i))return;t.uniformMatrix4fv(this.addr,!1,i),copyArray(r,i)}else{if(arraysEqual(r,a))return;vs.set(a),t.uniformMatrix4fv(this.addr,!1,vs),copyArray(r,a)}}function setValueV1i(t,i){const r=this.cache;r[0]!==i&&(t.uniform1i(this.addr,i),r[0]=i)}function setValueV2i(t,i){const r=this.cache;if(void 0!==i.x)r[0]===i.x&&r[1]===i.y||(t.uniform2i(this.addr,i.x,i.y),r[0]=i.x,r[1]=i.y);else{if(arraysEqual(r,i))return;t.uniform2iv(this.addr,i),copyArray(r,i)}}function setValueV3i(t,i){const r=this.cache;if(void 0!==i.x)r[0]===i.x&&r[1]===i.y&&r[2]===i.z||(t.uniform3i(this.addr,i.x,i.y,i.z),r[0]=i.x,r[1]=i.y,r[2]=i.z);else{if(arraysEqual(r,i))return;t.uniform3iv(this.addr,i),copyArray(r,i)}}function setValueV4i(t,i){const r=this.cache;if(void 0!==i.x)r[0]===i.x&&r[1]===i.y&&r[2]===i.z&&r[3]===i.w||(t.uniform4i(this.addr,i.x,i.y,i.z,i.w),r[0]=i.x,r[1]=i.y,r[2]=i.z,r[3]=i.w);else{if(arraysEqual(r,i))return;t.uniform4iv(this.addr,i),copyArray(r,i)}}function setValueV1ui(t,i){const r=this.cache;r[0]!==i&&(t.uniform1ui(this.addr,i),r[0]=i)}function setValueV2ui(t,i){const r=this.cache;if(void 0!==i.x)r[0]===i.x&&r[1]===i.y||(t.uniform2ui(this.addr,i.x,i.y),r[0]=i.x,r[1]=i.y);else{if(arraysEqual(r,i))return;t.uniform2uiv(this.addr,i),copyArray(r,i)}}function setValueV3ui(t,i){const r=this.cache;if(void 0!==i.x)r[0]===i.x&&r[1]===i.y&&r[2]===i.z||(t.uniform3ui(this.addr,i.x,i.y,i.z),r[0]=i.x,r[1]=i.y,r[2]=i.z);else{if(arraysEqual(r,i))return;t.uniform3uiv(this.addr,i),copyArray(r,i)}}function setValueV4ui(t,i){const r=this.cache;if(void 0!==i.x)r[0]===i.x&&r[1]===i.y&&r[2]===i.z&&r[3]===i.w||(t.uniform4ui(this.addr,i.x,i.y,i.z,i.w),r[0]=i.x,r[1]=i.y,r[2]=i.z,r[3]=i.w);else{if(arraysEqual(r,i))return;t.uniform4uiv(this.addr,i),copyArray(r,i)}}function setValueT1(t,i,r){const a=this.cache,o=r.allocateTextureUnit();let l;a[0]!==o&&(t.uniform1i(this.addr,o),a[0]=o),this.type===t.SAMPLER_2D_SHADOW?(us.compareFunction=515,l=us):l=ds,r.setTexture2D(i||l,o)}function setValueT3D1(t,i,r){const a=this.cache,o=r.allocateTextureUnit();a[0]!==o&&(t.uniform1i(this.addr,o),a[0]=o),r.setTexture3D(i||ms,o)}function setValueT6(t,i,r){const a=this.cache,o=r.allocateTextureUnit();a[0]!==o&&(t.uniform1i(this.addr,o),a[0]=o),r.setTextureCube(i||fs,o)}function setValueT2DArray1(t,i,r){const a=this.cache,o=r.allocateTextureUnit();a[0]!==o&&(t.uniform1i(this.addr,o),a[0]=o),r.setTexture2DArray(i||ps,o)}function setValueV1fArray(t,i){t.uniform1fv(this.addr,i)}function setValueV2fArray(t,i){const r=flatten(i,this.size,2);t.uniform2fv(this.addr,r)}function setValueV3fArray(t,i){const r=flatten(i,this.size,3);t.uniform3fv(this.addr,r)}function setValueV4fArray(t,i){const r=flatten(i,this.size,4);t.uniform4fv(this.addr,r)}function setValueM2Array(t,i){const r=flatten(i,this.size,4);t.uniformMatrix2fv(this.addr,!1,r)}function setValueM3Array(t,i){const r=flatten(i,this.size,9);t.uniformMatrix3fv(this.addr,!1,r)}function setValueM4Array(t,i){const r=flatten(i,this.size,16);t.uniformMatrix4fv(this.addr,!1,r)}function setValueV1iArray(t,i){t.uniform1iv(this.addr,i)}function setValueV2iArray(t,i){t.uniform2iv(this.addr,i)}function setValueV3iArray(t,i){t.uniform3iv(this.addr,i)}function setValueV4iArray(t,i){t.uniform4iv(this.addr,i)}function setValueV1uiArray(t,i){t.uniform1uiv(this.addr,i)}function setValueV2uiArray(t,i){t.uniform2uiv(this.addr,i)}function setValueV3uiArray(t,i){t.uniform3uiv(this.addr,i)}function setValueV4uiArray(t,i){t.uniform4uiv(this.addr,i)}function setValueT1Array(t,i,r){const a=this.cache,o=i.length,l=allocTexUnits(r,o);arraysEqual(a,l)||(t.uniform1iv(this.addr,l),copyArray(a,l));for(let t=0;t!==o;++t)r.setTexture2D(i[t]||ds,l[t])}function setValueT3DArray(t,i,r){const a=this.cache,o=i.length,l=allocTexUnits(r,o);arraysEqual(a,l)||(t.uniform1iv(this.addr,l),copyArray(a,l));for(let t=0;t!==o;++t)r.setTexture3D(i[t]||ms,l[t])}function setValueT6Array(t,i,r){const a=this.cache,o=i.length,l=allocTexUnits(r,o);arraysEqual(a,l)||(t.uniform1iv(this.addr,l),copyArray(a,l));for(let t=0;t!==o;++t)r.setTextureCube(i[t]||fs,l[t])}function setValueT2DArrayArray(t,i,r){const a=this.cache,o=i.length,l=allocTexUnits(r,o);arraysEqual(a,l)||(t.uniform1iv(this.addr,l),copyArray(a,l));for(let t=0;t!==o;++t)r.setTexture2DArray(i[t]||ps,l[t])}class SingleUniform{constructor(t,i,r){this.id=t,this.addr=r,this.cache=[],this.type=i.type,this.setValue=function getSingularSetter(t){switch(t){case 5126:return setValueV1f;case 35664:return setValueV2f;case 35665:return setValueV3f;case 35666:return setValueV4f;case 35674:return setValueM2;case 35675:return setValueM3;case 35676:return setValueM4;case 5124:case 35670:return setValueV1i;case 35667:case 35671:return setValueV2i;case 35668:case 35672:return setValueV3i;case 35669:case 35673:return setValueV4i;case 5125:return setValueV1ui;case 36294:return setValueV2ui;case 36295:return setValueV3ui;case 36296:return setValueV4ui;case 35678:case 36198:case 36298:case 36306:case 35682:return setValueT1;case 35679:case 36299:case 36307:return setValueT3D1;case 35680:case 36300:case 36308:case 36293:return setValueT6;case 36289:case 36303:case 36311:case 36292:return setValueT2DArray1}}(i.type)}}class PureArrayUniform{constructor(t,i,r){this.id=t,this.addr=r,this.cache=[],this.type=i.type,this.size=i.size,this.setValue=function getPureArraySetter(t){switch(t){case 5126:return setValueV1fArray;case 35664:return setValueV2fArray;case 35665:return setValueV3fArray;case 35666:return setValueV4fArray;case 35674:return setValueM2Array;case 35675:return setValueM3Array;case 35676:return setValueM4Array;case 5124:case 35670:return setValueV1iArray;case 35667:case 35671:return setValueV2iArray;case 35668:case 35672:return setValueV3iArray;case 35669:case 35673:return setValueV4iArray;case 5125:return setValueV1uiArray;case 36294:return setValueV2uiArray;case 36295:return setValueV3uiArray;case 36296:return setValueV4uiArray;case 35678:case 36198:case 36298:case 36306:case 35682:return setValueT1Array;case 35679:case 36299:case 36307:return setValueT3DArray;case 35680:case 36300:case 36308:case 36293:return setValueT6Array;case 36289:case 36303:case 36311:case 36292:return setValueT2DArrayArray}}(i.type)}}class StructuredUniform{constructor(t){this.id=t,this.seq=[],this.map={}}setValue(t,i,r){const a=this.seq;for(let o=0,l=a.length;o!==l;++o){const l=a[o];l.setValue(t,i[l.id],r)}}}const _s=/(\w+)(\])?(\[|\.)?/g;function addUniform(t,i){t.seq.push(i),t.map[i.id]=i}function parseUniform(t,i,r){const a=t.name,o=a.length;for(_s.lastIndex=0;;){const l=_s.exec(a),c=_s.lastIndex;let h=l[1];const d="]"===l[2],u=l[3];if(d&&(h|=0),void 0===u||"["===u&&c+2===o){addUniform(r,void 0===u?new SingleUniform(h,t,i):new PureArrayUniform(h,t,i));break}{let t=r.map[h];void 0===t&&(t=new StructuredUniform(h),addUniform(r,t)),r=t}}}class WebGLUniforms{constructor(t,i){this.seq=[],this.map={};const r=t.getProgramParameter(i,t.ACTIVE_UNIFORMS);for(let a=0;a<r;++a){const r=t.getActiveUniform(i,a);parseUniform(r,t.getUniformLocation(i,r.name),this)}}setValue(t,i,r,a){const o=this.map[i];void 0!==o&&o.setValue(t,r,a)}setOptional(t,i,r){const a=i[r];void 0!==a&&this.setValue(t,r,a)}static upload(t,i,r,a){for(let o=0,l=i.length;o!==l;++o){const l=i[o],c=r[l.id];!1!==c.needsUpdate&&l.setValue(t,c.value,a)}}static seqWithValue(t,i){const r=[];for(let a=0,o=t.length;a!==o;++a){const o=t[a];o.id in i&&r.push(o)}return r}}function WebGLShader(t,i,r){const a=t.createShader(i);return t.shaderSource(a,r),t.compileShader(a),a}let Ss=0;const Ms=new Matrix3;function getShaderErrors(t,i,r){const a=t.getShaderParameter(i,t.COMPILE_STATUS),o=t.getShaderInfoLog(i).trim();if(a&&""===o)return"";const l=/ERROR: 0:(\d+)/.exec(o);if(l){const a=parseInt(l[1]);return r.toUpperCase()+"\n\n"+o+"\n\n"+function handleSource(t,i){const r=t.split("\n"),a=[],o=Math.max(i-6,0),l=Math.min(i+6,r.length);for(let t=o;t<l;t++){const o=t+1;a.push(`${o===i?">":" "} ${o}: ${r[t]}`)}return a.join("\n")}(t.getShaderSource(i),a)}return o}function getTexelEncodingFunction(t,i){const r=function getEncodingComponents(t){Ot._getMatrix(Ms,Ot.workingColorSpace,t);const i=`mat3( ${Ms.elements.map((t=>t.toFixed(4)))} )`;switch(Ot.getTransfer(t)){case ht:return[i,"LinearTransferOETF"];case dt:return[i,"sRGBTransferOETF"];default:return[i,"LinearTransferOETF"]}}(i);return[`vec4 ${t}( vec4 value ) {`,`\treturn ${r[1]}( vec4( value.rgb * ${r[0]}, value.a ) );`,"}"].join("\n")}function getToneMappingFunction(t,i){let r;switch(i){case 1:default:r="Linear";break;case 2:r="Reinhard";break;case 3:r="Cineon";break;case 4:r="ACESFilmic";break;case 6:r="AgX";break;case 7:r="Neutral";break;case 5:r="Custom"}return"vec3 "+t+"( vec3 color ) { return "+r+"ToneMapping( color ); }"}const ws=new Vector3;function getLuminanceFunction(){Ot.getLuminanceCoefficients(ws);return["float luminance( const in vec3 rgb ) {",`\tconst vec3 weights = vec3( ${ws.x.toFixed(4)}, ${ws.y.toFixed(4)}, ${ws.z.toFixed(4)} );`,"\treturn dot( weights, rgb );","}"].join("\n")}function filterEmptyLine(t){return""!==t}function replaceLightNums(t,i){const r=i.numSpotLightShadows+i.numSpotLightMaps-i.numSpotLightShadowsWithMaps;return t.replace(/NUM_DIR_LIGHTS/g,i.numDirLights).replace(/NUM_SPOT_LIGHTS/g,i.numSpotLights).replace(/NUM_SPOT_LIGHT_MAPS/g,i.numSpotLightMaps).replace(/NUM_SPOT_LIGHT_COORDS/g,r).replace(/NUM_RECT_AREA_LIGHTS/g,i.numRectAreaLights).replace(/NUM_POINT_LIGHTS/g,i.numPointLights).replace(/NUM_HEMI_LIGHTS/g,i.numHemiLights).replace(/NUM_DIR_LIGHT_SHADOWS/g,i.numDirLightShadows).replace(/NUM_SPOT_LIGHT_SHADOWS_WITH_MAPS/g,i.numSpotLightShadowsWithMaps).replace(/NUM_SPOT_LIGHT_SHADOWS/g,i.numSpotLightShadows).replace(/NUM_POINT_LIGHT_SHADOWS/g,i.numPointLightShadows)}function replaceClippingPlaneNums(t,i){return t.replace(/NUM_CLIPPING_PLANES/g,i.numClippingPlanes).replace(/UNION_CLIPPING_PLANES/g,i.numClippingPlanes-i.numClipIntersection)}const Ts=/^[ \t]*#include +<([\w\d./]+)>/gm;function resolveIncludes(t){return t.replace(Ts,includeReplacer)}const Es=new Map;function includeReplacer(t,i){let r=Yr[i];if(void 0===r){const t=Es.get(i);if(void 0===t)throw new Error("Can not resolve #include <"+i+">");r=Yr[t]}return resolveIncludes(r)}const As=/#pragma unroll_loop_start\s+for\s*\(\s*int\s+i\s*=\s*(\d+)\s*;\s*i\s*<\s*(\d+)\s*;\s*i\s*\+\+\s*\)\s*{([\s\S]+?)}\s+#pragma unroll_loop_end/g;function unrollLoops(t){return t.replace(As,loopReplacer)}function loopReplacer(t,i,r,a){let o="";for(let t=parseInt(i);t<parseInt(r);t++)o+=a.replace(/\[\s*i\s*\]/g,"[ "+t+" ]").replace(/UNROLLED_LOOP_INDEX/g,t);return o}function generatePrecision(t){let i=`precision ${t.precision} float;\n\tprecision ${t.precision} int;\n\tprecision ${t.precision} sampler2D;\n\tprecision ${t.precision} samplerCube;\n\tprecision ${t.precision} sampler3D;\n\tprecision ${t.precision} sampler2DArray;\n\tprecision ${t.precision} sampler2DShadow;\n\tprecision ${t.precision} samplerCubeShadow;\n\tprecision ${t.precision} sampler2DArrayShadow;\n\tprecision ${t.precision} isampler2D;\n\tprecision ${t.precision} isampler3D;\n\tprecision ${t.precision} isamplerCube;\n\tprecision ${t.precision} isampler2DArray;\n\tprecision ${t.precision} usampler2D;\n\tprecision ${t.precision} usampler3D;\n\tprecision ${t.precision} usamplerCube;\n\tprecision ${t.precision} usampler2DArray;\n\t`;return"highp"===t.precision?i+="\n#define HIGH_PRECISION":"mediump"===t.precision?i+="\n#define MEDIUM_PRECISION":"lowp"===t.precision&&(i+="\n#define LOW_PRECISION"),i}function WebGLProgram(t,i,r,a){const o=t.getContext(),l=r.defines;let c=r.vertexShader,h=r.fragmentShader;const d=function generateShadowMapTypeDefine(t){let i="SHADOWMAP_TYPE_BASIC";return 1===t.shadowMapType?i="SHADOWMAP_TYPE_PCF":2===t.shadowMapType?i="SHADOWMAP_TYPE_PCF_SOFT":3===t.shadowMapType&&(i="SHADOWMAP_TYPE_VSM"),i}(r),u=function generateEnvMapTypeDefine(t){let i="ENVMAP_TYPE_CUBE";if(t.envMap)switch(t.envMapMode){case j:case X:i="ENVMAP_TYPE_CUBE";break;case q:i="ENVMAP_TYPE_CUBE_UV"}return i}(r),p=function generateEnvMapModeDefine(t){let i="ENVMAP_MODE_REFLECTION";t.envMap&&t.envMapMode===X&&(i="ENVMAP_MODE_REFRACTION");return i}(r),m=function generateEnvMapBlendingDefine(t){let i="ENVMAP_BLENDING_NONE";if(t.envMap)switch(t.combine){case 0:i="ENVMAP_BLENDING_MULTIPLY";break;case 1:i="ENVMAP_BLENDING_MIX";break;case 2:i="ENVMAP_BLENDING_ADD"}return i}(r),g=function generateCubeUVSize(t){const i=t.envMapCubeUVHeight;if(null===i)return null;const r=Math.log2(i)-2,a=1/i;return{texelWidth:1/(3*Math.max(Math.pow(2,r),112)),texelHeight:a,maxMip:r}}(r),y=function generateVertexExtensions(t){return[t.extensionClipCullDistance?"#extension GL_ANGLE_clip_cull_distance : require":"",t.extensionMultiDraw?"#extension GL_ANGLE_multi_draw : require":""].filter(filterEmptyLine).join("\n")}(r),v=function generateDefines(t){const i=[];for(const r in t){const a=t[r];!1!==a&&i.push("#define "+r+" "+a)}return i.join("\n")}(l),x=o.createProgram();let b,_,S=r.glslVersion?"#version "+r.glslVersion+"\n":"";r.isRawShaderMaterial?(b=["#define SHADER_TYPE "+r.shaderType,"#define SHADER_NAME "+r.shaderName,v].filter(filterEmptyLine).join("\n"),b.length>0&&(b+="\n"),_=["#define SHADER_TYPE "+r.shaderType,"#define SHADER_NAME "+r.shaderName,v].filter(filterEmptyLine).join("\n"),_.length>0&&(_+="\n")):(b=[generatePrecision(r),"#define SHADER_TYPE "+r.shaderType,"#define SHADER_NAME "+r.shaderName,v,r.extensionClipCullDistance?"#define USE_CLIP_DISTANCE":"",r.batching?"#define USE_BATCHING":"",r.batchingColor?"#define USE_BATCHING_COLOR":"",r.instancing?"#define USE_INSTANCING":"",r.instancingColor?"#define USE_INSTANCING_COLOR":"",r.instancingMorph?"#define USE_INSTANCING_MORPH":"",r.useFog&&r.fog?"#define USE_FOG":"",r.useFog&&r.fogExp2?"#define FOG_EXP2":"",r.map?"#define USE_MAP":"",r.envMap?"#define USE_ENVMAP":"",r.envMap?"#define "+p:"",r.lightMap?"#define USE_LIGHTMAP":"",r.aoMap?"#define USE_AOMAP":"",r.bumpMap?"#define USE_BUMPMAP":"",r.normalMap?"#define USE_NORMALMAP":"",r.normalMapObjectSpace?"#define USE_NORMALMAP_OBJECTSPACE":"",r.normalMapTangentSpace?"#define USE_NORMALMAP_TANGENTSPACE":"",r.displacementMap?"#define USE_DISPLACEMENTMAP":"",r.emissiveMap?"#define USE_EMISSIVEMAP":"",r.anisotropy?"#define USE_ANISOTROPY":"",r.anisotropyMap?"#define USE_ANISOTROPYMAP":"",r.clearcoatMap?"#define USE_CLEARCOATMAP":"",r.clearcoatRoughnessMap?"#define USE_CLEARCOAT_ROUGHNESSMAP":"",r.clearcoatNormalMap?"#define USE_CLEARCOAT_NORMALMAP":"",r.iridescenceMap?"#define USE_IRIDESCENCEMAP":"",r.iridescenceThicknessMap?"#define USE_IRIDESCENCE_THICKNESSMAP":"",r.specularMap?"#define USE_SPECULARMAP":"",r.specularColorMap?"#define USE_SPECULAR_COLORMAP":"",r.specularIntensityMap?"#define USE_SPECULAR_INTENSITYMAP":"",r.roughnessMap?"#define USE_ROUGHNESSMAP":"",r.metalnessMap?"#define USE_METALNESSMAP":"",r.alphaMap?"#define USE_ALPHAMAP":"",r.alphaHash?"#define USE_ALPHAHASH":"",r.transmission?"#define USE_TRANSMISSION":"",r.transmissionMap?"#define USE_TRANSMISSIONMAP":"",r.thicknessMap?"#define USE_THICKNESSMAP":"",r.sheenColorMap?"#define USE_SHEEN_COLORMAP":"",r.sheenRoughnessMap?"#define USE_SHEEN_ROUGHNESSMAP":"",r.mapUv?"#define MAP_UV "+r.mapUv:"",r.alphaMapUv?"#define ALPHAMAP_UV "+r.alphaMapUv:"",r.lightMapUv?"#define LIGHTMAP_UV "+r.lightMapUv:"",r.aoMapUv?"#define AOMAP_UV "+r.aoMapUv:"",r.emissiveMapUv?"#define EMISSIVEMAP_UV "+r.emissiveMapUv:"",r.bumpMapUv?"#define BUMPMAP_UV "+r.bumpMapUv:"",r.normalMapUv?"#define NORMALMAP_UV "+r.normalMapUv:"",r.displacementMapUv?"#define DISPLACEMENTMAP_UV "+r.displacementMapUv:"",r.metalnessMapUv?"#define METALNESSMAP_UV "+r.metalnessMapUv:"",r.roughnessMapUv?"#define ROUGHNESSMAP_UV "+r.roughnessMapUv:"",r.anisotropyMapUv?"#define ANISOTROPYMAP_UV "+r.anisotropyMapUv:"",r.clearcoatMapUv?"#define CLEARCOATMAP_UV "+r.clearcoatMapUv:"",r.clearcoatNormalMapUv?"#define CLEARCOAT_NORMALMAP_UV "+r.clearcoatNormalMapUv:"",r.clearcoatRoughnessMapUv?"#define CLEARCOAT_ROUGHNESSMAP_UV "+r.clearcoatRoughnessMapUv:"",r.iridescenceMapUv?"#define IRIDESCENCEMAP_UV "+r.iridescenceMapUv:"",r.iridescenceThicknessMapUv?"#define IRIDESCENCE_THICKNESSMAP_UV "+r.iridescenceThicknessMapUv:"",r.sheenColorMapUv?"#define SHEEN_COLORMAP_UV "+r.sheenColorMapUv:"",r.sheenRoughnessMapUv?"#define SHEEN_ROUGHNESSMAP_UV "+r.sheenRoughnessMapUv:"",r.specularMapUv?"#define SPECULARMAP_UV "+r.specularMapUv:"",r.specularColorMapUv?"#define SPECULAR_COLORMAP_UV "+r.specularColorMapUv:"",r.specularIntensityMapUv?"#define SPECULAR_INTENSITYMAP_UV "+r.specularIntensityMapUv:"",r.transmissionMapUv?"#define TRANSMISSIONMAP_UV "+r.transmissionMapUv:"",r.thicknessMapUv?"#define THICKNESSMAP_UV "+r.thicknessMapUv:"",r.vertexTangents&&!1===r.flatShading?"#define USE_TANGENT":"",r.vertexColors?"#define USE_COLOR":"",r.vertexAlphas?"#define USE_COLOR_ALPHA":"",r.vertexUv1s?"#define USE_UV1":"",r.vertexUv2s?"#define USE_UV2":"",r.vertexUv3s?"#define USE_UV3":"",r.pointsUvs?"#define USE_POINTS_UV":"",r.flatShading?"#define FLAT_SHADED":"",r.skinning?"#define USE_SKINNING":"",r.morphTargets?"#define USE_MORPHTARGETS":"",r.morphNormals&&!1===r.flatShading?"#define USE_MORPHNORMALS":"",r.morphColors?"#define USE_MORPHCOLORS":"",r.morphTargetsCount>0?"#define MORPHTARGETS_TEXTURE_STRIDE "+r.morphTextureStride:"",r.morphTargetsCount>0?"#define MORPHTARGETS_COUNT "+r.morphTargetsCount:"",r.doubleSided?"#define DOUBLE_SIDED":"",r.flipSided?"#define FLIP_SIDED":"",r.shadowMapEnabled?"#define USE_SHADOWMAP":"",r.shadowMapEnabled?"#define "+d:"",r.sizeAttenuation?"#define USE_SIZEATTENUATION":"",r.numLightProbes>0?"#define USE_LIGHT_PROBES":"",r.logarithmicDepthBuffer?"#define USE_LOGDEPTHBUF":"",r.reverseDepthBuffer?"#define USE_REVERSEDEPTHBUF":"","uniform mat4 modelMatrix;","uniform mat4 modelViewMatrix;","uniform mat4 projectionMatrix;","uniform mat4 viewMatrix;","uniform mat3 normalMatrix;","uniform vec3 cameraPosition;","uniform bool isOrthographic;","#ifdef USE_INSTANCING","\tattribute mat4 instanceMatrix;","#endif","#ifdef USE_INSTANCING_COLOR","\tattribute vec3 instanceColor;","#endif","#ifdef USE_INSTANCING_MORPH","\tuniform sampler2D morphTexture;","#endif","attribute vec3 position;","attribute vec3 normal;","attribute vec2 uv;","#ifdef USE_UV1","\tattribute vec2 uv1;","#endif","#ifdef USE_UV2","\tattribute vec2 uv2;","#endif","#ifdef USE_UV3","\tattribute vec2 uv3;","#endif","#ifdef USE_TANGENT","\tattribute vec4 tangent;","#endif","#if defined( USE_COLOR_ALPHA )","\tattribute vec4 color;","#elif defined( USE_COLOR )","\tattribute vec3 color;","#endif","#ifdef USE_SKINNING","\tattribute vec4 skinIndex;","\tattribute vec4 skinWeight;","#endif","\n"].filter(filterEmptyLine).join("\n"),_=[generatePrecision(r),"#define SHADER_TYPE "+r.shaderType,"#define SHADER_NAME "+r.shaderName,v,r.useFog&&r.fog?"#define USE_FOG":"",r.useFog&&r.fogExp2?"#define FOG_EXP2":"",r.alphaToCoverage?"#define ALPHA_TO_COVERAGE":"",r.map?"#define USE_MAP":"",r.matcap?"#define USE_MATCAP":"",r.envMap?"#define USE_ENVMAP":"",r.envMap?"#define "+u:"",r.envMap?"#define "+p:"",r.envMap?"#define "+m:"",g?"#define CUBEUV_TEXEL_WIDTH "+g.texelWidth:"",g?"#define CUBEUV_TEXEL_HEIGHT "+g.texelHeight:"",g?"#define CUBEUV_MAX_MIP "+g.maxMip+".0":"",r.lightMap?"#define USE_LIGHTMAP":"",r.aoMap?"#define USE_AOMAP":"",r.bumpMap?"#define USE_BUMPMAP":"",r.normalMap?"#define USE_NORMALMAP":"",r.normalMapObjectSpace?"#define USE_NORMALMAP_OBJECTSPACE":"",r.normalMapTangentSpace?"#define USE_NORMALMAP_TANGENTSPACE":"",r.emissiveMap?"#define USE_EMISSIVEMAP":"",r.anisotropy?"#define USE_ANISOTROPY":"",r.anisotropyMap?"#define USE_ANISOTROPYMAP":"",r.clearcoat?"#define USE_CLEARCOAT":"",r.clearcoatMap?"#define USE_CLEARCOATMAP":"",r.clearcoatRoughnessMap?"#define USE_CLEARCOAT_ROUGHNESSMAP":"",r.clearcoatNormalMap?"#define USE_CLEARCOAT_NORMALMAP":"",r.dispersion?"#define USE_DISPERSION":"",r.iridescence?"#define USE_IRIDESCENCE":"",r.iridescenceMap?"#define USE_IRIDESCENCEMAP":"",r.iridescenceThicknessMap?"#define USE_IRIDESCENCE_THICKNESSMAP":"",r.specularMap?"#define USE_SPECULARMAP":"",r.specularColorMap?"#define USE_SPECULAR_COLORMAP":"",r.specularIntensityMap?"#define USE_SPECULAR_INTENSITYMAP":"",r.roughnessMap?"#define USE_ROUGHNESSMAP":"",r.metalnessMap?"#define USE_METALNESSMAP":"",r.alphaMap?"#define USE_ALPHAMAP":"",r.alphaTest?"#define USE_ALPHATEST":"",r.alphaHash?"#define USE_ALPHAHASH":"",r.sheen?"#define USE_SHEEN":"",r.sheenColorMap?"#define USE_SHEEN_COLORMAP":"",r.sheenRoughnessMap?"#define USE_SHEEN_ROUGHNESSMAP":"",r.transmission?"#define USE_TRANSMISSION":"",r.transmissionMap?"#define USE_TRANSMISSIONMAP":"",r.thicknessMap?"#define USE_THICKNESSMAP":"",r.vertexTangents&&!1===r.flatShading?"#define USE_TANGENT":"",r.vertexColors||r.instancingColor||r.batchingColor?"#define USE_COLOR":"",r.vertexAlphas?"#define USE_COLOR_ALPHA":"",r.vertexUv1s?"#define USE_UV1":"",r.vertexUv2s?"#define USE_UV2":"",r.vertexUv3s?"#define USE_UV3":"",r.pointsUvs?"#define USE_POINTS_UV":"",r.gradientMap?"#define USE_GRADIENTMAP":"",r.flatShading?"#define FLAT_SHADED":"",r.doubleSided?"#define DOUBLE_SIDED":"",r.flipSided?"#define FLIP_SIDED":"",r.shadowMapEnabled?"#define USE_SHADOWMAP":"",r.shadowMapEnabled?"#define "+d:"",r.premultipliedAlpha?"#define PREMULTIPLIED_ALPHA":"",r.numLightProbes>0?"#define USE_LIGHT_PROBES":"",r.decodeVideoTexture?"#define DECODE_VIDEO_TEXTURE":"",r.decodeVideoTextureEmissive?"#define DECODE_VIDEO_TEXTURE_EMISSIVE":"",r.logarithmicDepthBuffer?"#define USE_LOGDEPTHBUF":"",r.reverseDepthBuffer?"#define USE_REVERSEDEPTHBUF":"","uniform mat4 viewMatrix;","uniform vec3 cameraPosition;","uniform bool isOrthographic;",0!==r.toneMapping?"#define TONE_MAPPING":"",0!==r.toneMapping?Yr.tonemapping_pars_fragment:"",0!==r.toneMapping?getToneMappingFunction("toneMapping",r.toneMapping):"",r.dithering?"#define DITHERING":"",r.opaque?"#define OPAQUE":"",Yr.colorspace_pars_fragment,getTexelEncodingFunction("linearToOutputTexel",r.outputColorSpace),getLuminanceFunction(),r.useDepthPacking?"#define DEPTH_PACKING "+r.depthPacking:"","\n"].filter(filterEmptyLine).join("\n")),c=resolveIncludes(c),c=replaceLightNums(c,r),c=replaceClippingPlaneNums(c,r),h=resolveIncludes(h),h=replaceLightNums(h,r),h=replaceClippingPlaneNums(h,r),c=unrollLoops(c),h=unrollLoops(h),!0!==r.isRawShaderMaterial&&(S="#version 300 es\n",b=[y,"#define attribute in","#define varying out","#define texture2D texture"].join("\n")+"\n"+b,_=["#define varying in",r.glslVersion===St?"":"layout(location = 0) out highp vec4 pc_fragColor;",r.glslVersion===St?"":"#define gl_FragColor pc_fragColor","#define gl_FragDepthEXT gl_FragDepth","#define texture2D texture","#define textureCube texture","#define texture2DProj textureProj","#define texture2DLodEXT textureLod","#define texture2DProjLodEXT textureProjLod","#define textureCubeLodEXT textureLod","#define texture2DGradEXT textureGrad","#define texture2DProjGradEXT textureProjGrad","#define textureCubeGradEXT textureGrad"].join("\n")+"\n"+_);const M=S+b+c,w=S+_+h,T=WebGLShader(o,o.VERTEX_SHADER,M),E=WebGLShader(o,o.FRAGMENT_SHADER,w);function onFirstUse(i){if(t.debug.checkShaderErrors){const r=o.getProgramInfoLog(x).trim(),a=o.getShaderInfoLog(T).trim(),l=o.getShaderInfoLog(E).trim();let c=!0,h=!0;if(!1===o.getProgramParameter(x,o.LINK_STATUS))if(c=!1,"function"==typeof t.debug.onShaderError)t.debug.onShaderError(o,x,T,E);else{getShaderErrors(o,T,"vertex"),getShaderErrors(o,E,"fragment")}else""!==r||""!==a&&""!==l||(h=!1);h&&(i.diagnostics={runnable:c,programLog:r,vertexShader:{log:a,prefix:b},fragmentShader:{log:l,prefix:_}})}o.deleteShader(T),o.deleteShader(E),A=new WebGLUniforms(o,x),C=function fetchAttributeLocations(t,i){const r={},a=t.getProgramParameter(i,t.ACTIVE_ATTRIBUTES);for(let o=0;o<a;o++){const a=t.getActiveAttrib(i,o),l=a.name;let c=1;a.type===t.FLOAT_MAT2&&(c=2),a.type===t.FLOAT_MAT3&&(c=3),a.type===t.FLOAT_MAT4&&(c=4),r[l]={type:a.type,location:t.getAttribLocation(i,l),locationSize:c}}return r}(o,x)}let A,C;o.attachShader(x,T),o.attachShader(x,E),void 0!==r.index0AttributeName?o.bindAttribLocation(x,0,r.index0AttributeName):!0===r.morphTargets&&o.bindAttribLocation(x,0,"position"),o.linkProgram(x),this.getUniforms=function(){return void 0===A&&onFirstUse(this),A},this.getAttributes=function(){return void 0===C&&onFirstUse(this),C};let P=!1===r.rendererExtensionParallelShaderCompile;return this.isReady=function(){return!1===P&&(P=o.getProgramParameter(x,37297)),P},this.destroy=function(){a.releaseStatesOfProgram(this),o.deleteProgram(x),this.program=void 0},this.type=r.shaderType,this.name=r.shaderName,this.id=Ss++,this.cacheKey=i,this.usedTimes=1,this.program=x,this.vertexShader=T,this.fragmentShader=E,this}let Cs=0;class WebGLShaderCache{constructor(){this.shaderCache=new Map,this.materialCache=new Map}update(t){const i=t.vertexShader,r=t.fragmentShader,a=this._getShaderStage(i),o=this._getShaderStage(r),l=this._getShaderCacheForMaterial(t);return!1===l.has(a)&&(l.add(a),a.usedTimes++),!1===l.has(o)&&(l.add(o),o.usedTimes++),this}remove(t){const i=this.materialCache.get(t);for(const t of i)t.usedTimes--,0===t.usedTimes&&this.shaderCache.delete(t.code);return this.materialCache.delete(t),this}getVertexShaderID(t){return this._getShaderStage(t.vertexShader).id}getFragmentShaderID(t){return this._getShaderStage(t.fragmentShader).id}dispose(){this.shaderCache.clear(),this.materialCache.clear()}_getShaderCacheForMaterial(t){const i=this.materialCache;let r=i.get(t);return void 0===r&&(r=new Set,i.set(t,r)),r}_getShaderStage(t){const i=this.shaderCache;let r=i.get(t);return void 0===r&&(r=new WebGLShaderStage(t),i.set(t,r)),r}}class WebGLShaderStage{constructor(t){this.id=Cs++,this.code=t,this.usedTimes=0}}function WebGLPrograms(t,i,r,a,o,l,c){const h=new Layers,d=new WebGLShaderCache,u=new Set,p=[],m=o.logarithmicDepthBuffer,g=o.vertexTextures;let y=o.precision;const v={MeshDepthMaterial:"depth",MeshDistanceMaterial:"distanceRGBA",MeshNormalMaterial:"normal",MeshBasicMaterial:"basic",MeshLambertMaterial:"lambert",MeshPhongMaterial:"phong",MeshToonMaterial:"toon",MeshStandardMaterial:"physical",MeshPhysicalMaterial:"physical",MeshMatcapMaterial:"matcap",LineBasicMaterial:"basic",LineDashedMaterial:"dashed",PointsMaterial:"points",ShadowMaterial:"shadow",SpriteMaterial:"sprite"};function getChannel(t){return u.add(t),0===t?"uv":`uv${t}`}return{getParameters:function getParameters(l,h,p,x,b){const _=x.fog,S=b.geometry,M=l.isMeshStandardMaterial?x.environment:null,w=(l.isMeshStandardMaterial?r:i).get(l.envMap||M),T=w&&w.mapping===q?w.image.height:null,E=v[l.type];null!==l.precision&&(y=o.getMaxPrecision(l.precision),l.precision);const A=S.morphAttributes.position||S.morphAttributes.normal||S.morphAttributes.color,C=void 0!==A?A.length:0;let P,R,I,D,L=0;if(void 0!==S.morphAttributes.position&&(L=1),void 0!==S.morphAttributes.normal&&(L=2),void 0!==S.morphAttributes.color&&(L=3),E){const t=Kr[E];P=t.vertexShader,R=t.fragmentShader}else P=l.vertexShader,R=l.fragmentShader,d.update(l),I=d.getVertexShaderID(l),D=d.getFragmentShaderID(l);const N=t.getRenderTarget(),O=t.state.buffers.depth.getReversed(),U=!0===b.isInstancedMesh,B=!0===b.isBatchedMesh,z=!!l.map,V=!!l.matcap,k=!!w,G=!!l.aoMap,H=!!l.lightMap,W=!!l.bumpMap,j=!!l.normalMap,X=!!l.displacementMap,Y=!!l.emissiveMap,Z=!!l.metalnessMap,K=!!l.roughnessMap,Q=l.anisotropy>0,J=l.clearcoat>0,$=l.dispersion>0,ee=l.iridescence>0,te=l.sheen>0,ie=l.transmission>0,ne=Q&&!!l.anisotropyMap,re=J&&!!l.clearcoatMap,se=J&&!!l.clearcoatNormalMap,ae=J&&!!l.clearcoatRoughnessMap,oe=ee&&!!l.iridescenceMap,le=ee&&!!l.iridescenceThicknessMap,ce=te&&!!l.sheenColorMap,he=te&&!!l.sheenRoughnessMap,de=!!l.specularMap,ue=!!l.specularColorMap,pe=!!l.specularIntensityMap,me=ie&&!!l.transmissionMap,fe=ie&&!!l.thicknessMap,ge=!!l.gradientMap,ye=!!l.alphaMap,ve=l.alphaTest>0,xe=!!l.alphaHash,be=!!l.extensions;let _e=0;l.toneMapped&&(null!==N&&!0!==N.isXRRenderTarget||(_e=t.toneMapping));const Se={shaderID:E,shaderType:l.type,shaderName:l.name,vertexShader:P,fragmentShader:R,defines:l.defines,customVertexShaderID:I,customFragmentShaderID:D,isRawShaderMaterial:!0===l.isRawShaderMaterial,glslVersion:l.glslVersion,precision:y,batching:B,batchingColor:B&&null!==b._colorsTexture,instancing:U,instancingColor:U&&null!==b.instanceColor,instancingMorph:U&&null!==b.morphTexture,supportsVertexTextures:g,outputColorSpace:null===N?t.outputColorSpace:!0===N.isXRRenderTarget?N.texture.colorSpace:ct,alphaToCoverage:!!l.alphaToCoverage,map:z,matcap:V,envMap:k,envMapMode:k&&w.mapping,envMapCubeUVHeight:T,aoMap:G,lightMap:H,bumpMap:W,normalMap:j,displacementMap:g&&X,emissiveMap:Y,normalMapObjectSpace:j&&1===l.normalMapType,normalMapTangentSpace:j&&0===l.normalMapType,metalnessMap:Z,roughnessMap:K,anisotropy:Q,anisotropyMap:ne,clearcoat:J,clearcoatMap:re,clearcoatNormalMap:se,clearcoatRoughnessMap:ae,dispersion:$,iridescence:ee,iridescenceMap:oe,iridescenceThicknessMap:le,sheen:te,sheenColorMap:ce,sheenRoughnessMap:he,specularMap:de,specularColorMap:ue,specularIntensityMap:pe,transmission:ie,transmissionMap:me,thicknessMap:fe,gradientMap:ge,opaque:!1===l.transparent&&1===l.blending&&!1===l.alphaToCoverage,alphaMap:ye,alphaTest:ve,alphaHash:xe,combine:l.combine,mapUv:z&&getChannel(l.map.channel),aoMapUv:G&&getChannel(l.aoMap.channel),lightMapUv:H&&getChannel(l.lightMap.channel),bumpMapUv:W&&getChannel(l.bumpMap.channel),normalMapUv:j&&getChannel(l.normalMap.channel),displacementMapUv:X&&getChannel(l.displacementMap.channel),emissiveMapUv:Y&&getChannel(l.emissiveMap.channel),metalnessMapUv:Z&&getChannel(l.metalnessMap.channel),roughnessMapUv:K&&getChannel(l.roughnessMap.channel),anisotropyMapUv:ne&&getChannel(l.anisotropyMap.channel),clearcoatMapUv:re&&getChannel(l.clearcoatMap.channel),clearcoatNormalMapUv:se&&getChannel(l.clearcoatNormalMap.channel),clearcoatRoughnessMapUv:ae&&getChannel(l.clearcoatRoughnessMap.channel),iridescenceMapUv:oe&&getChannel(l.iridescenceMap.channel),iridescenceThicknessMapUv:le&&getChannel(l.iridescenceThicknessMap.channel),sheenColorMapUv:ce&&getChannel(l.sheenColorMap.channel),sheenRoughnessMapUv:he&&getChannel(l.sheenRoughnessMap.channel),specularMapUv:de&&getChannel(l.specularMap.channel),specularColorMapUv:ue&&getChannel(l.specularColorMap.channel),specularIntensityMapUv:pe&&getChannel(l.specularIntensityMap.channel),transmissionMapUv:me&&getChannel(l.transmissionMap.channel),thicknessMapUv:fe&&getChannel(l.thicknessMap.channel),alphaMapUv:ye&&getChannel(l.alphaMap.channel),vertexTangents:!!S.attributes.tangent&&(j||Q),vertexColors:l.vertexColors,vertexAlphas:!0===l.vertexColors&&!!S.attributes.color&&4===S.attributes.color.itemSize,pointsUvs:!0===b.isPoints&&!!S.attributes.uv&&(z||ye),fog:!!_,useFog:!0===l.fog,fogExp2:!!_&&_.isFogExp2,flatShading:!0===l.flatShading,sizeAttenuation:!0===l.sizeAttenuation,logarithmicDepthBuffer:m,reverseDepthBuffer:O,skinning:!0===b.isSkinnedMesh,morphTargets:void 0!==S.morphAttributes.position,morphNormals:void 0!==S.morphAttributes.normal,morphColors:void 0!==S.morphAttributes.color,morphTargetsCount:C,morphTextureStride:L,numDirLights:h.directional.length,numPointLights:h.point.length,numSpotLights:h.spot.length,numSpotLightMaps:h.spotLightMap.length,numRectAreaLights:h.rectArea.length,numHemiLights:h.hemi.length,numDirLightShadows:h.directionalShadowMap.length,numPointLightShadows:h.pointShadowMap.length,numSpotLightShadows:h.spotShadowMap.length,numSpotLightShadowsWithMaps:h.numSpotLightShadowsWithMaps,numLightProbes:h.numLightProbes,numClippingPlanes:c.numPlanes,numClipIntersection:c.numIntersection,dithering:l.dithering,shadowMapEnabled:t.shadowMap.enabled&&p.length>0,shadowMapType:t.shadowMap.type,toneMapping:_e,decodeVideoTexture:z&&!0===l.map.isVideoTexture&&Ot.getTransfer(l.map.colorSpace)===dt,decodeVideoTextureEmissive:Y&&!0===l.emissiveMap.isVideoTexture&&Ot.getTransfer(l.emissiveMap.colorSpace)===dt,premultipliedAlpha:l.premultipliedAlpha,doubleSided:2===l.side,flipSided:1===l.side,useDepthPacking:l.depthPacking>=0,depthPacking:l.depthPacking||0,index0AttributeName:l.index0AttributeName,extensionClipCullDistance:be&&!0===l.extensions.clipCullDistance&&a.has("WEBGL_clip_cull_distance"),extensionMultiDraw:(be&&!0===l.extensions.multiDraw||B)&&a.has("WEBGL_multi_draw"),rendererExtensionParallelShaderCompile:a.has("KHR_parallel_shader_compile"),customProgramCacheKey:l.customProgramCacheKey()};return Se.vertexUv1s=u.has(1),Se.vertexUv2s=u.has(2),Se.vertexUv3s=u.has(3),u.clear(),Se},getProgramCacheKey:function getProgramCacheKey(i){const r=[];if(i.shaderID?r.push(i.shaderID):(r.push(i.customVertexShaderID),r.push(i.customFragmentShaderID)),void 0!==i.defines)for(const t in i.defines)r.push(t),r.push(i.defines[t]);return!1===i.isRawShaderMaterial&&(!function getProgramCacheKeyParameters(t,i){t.push(i.precision),t.push(i.outputColorSpace),t.push(i.envMapMode),t.push(i.envMapCubeUVHeight),t.push(i.mapUv),t.push(i.alphaMapUv),t.push(i.lightMapUv),t.push(i.aoMapUv),t.push(i.bumpMapUv),t.push(i.normalMapUv),t.push(i.displacementMapUv),t.push(i.emissiveMapUv),t.push(i.metalnessMapUv),t.push(i.roughnessMapUv),t.push(i.anisotropyMapUv),t.push(i.clearcoatMapUv),t.push(i.clearcoatNormalMapUv),t.push(i.clearcoatRoughnessMapUv),t.push(i.iridescenceMapUv),t.push(i.iridescenceThicknessMapUv),t.push(i.sheenColorMapUv),t.push(i.sheenRoughnessMapUv),t.push(i.specularMapUv),t.push(i.specularColorMapUv),t.push(i.specularIntensityMapUv),t.push(i.transmissionMapUv),t.push(i.thicknessMapUv),t.push(i.combine),t.push(i.fogExp2),t.push(i.sizeAttenuation),t.push(i.morphTargetsCount),t.push(i.morphAttributeCount),t.push(i.numDirLights),t.push(i.numPointLights),t.push(i.numSpotLights),t.push(i.numSpotLightMaps),t.push(i.numHemiLights),t.push(i.numRectAreaLights),t.push(i.numDirLightShadows),t.push(i.numPointLightShadows),t.push(i.numSpotLightShadows),t.push(i.numSpotLightShadowsWithMaps),t.push(i.numLightProbes),t.push(i.shadowMapType),t.push(i.toneMapping),t.push(i.numClippingPlanes),t.push(i.numClipIntersection),t.push(i.depthPacking)}(r,i),function getProgramCacheKeyBooleans(t,i){h.disableAll(),i.supportsVertexTextures&&h.enable(0);i.instancing&&h.enable(1);i.instancingColor&&h.enable(2);i.instancingMorph&&h.enable(3);i.matcap&&h.enable(4);i.envMap&&h.enable(5);i.normalMapObjectSpace&&h.enable(6);i.normalMapTangentSpace&&h.enable(7);i.clearcoat&&h.enable(8);i.iridescence&&h.enable(9);i.alphaTest&&h.enable(10);i.vertexColors&&h.enable(11);i.vertexAlphas&&h.enable(12);i.vertexUv1s&&h.enable(13);i.vertexUv2s&&h.enable(14);i.vertexUv3s&&h.enable(15);i.vertexTangents&&h.enable(16);i.anisotropy&&h.enable(17);i.alphaHash&&h.enable(18);i.batching&&h.enable(19);i.dispersion&&h.enable(20);i.batchingColor&&h.enable(21);t.push(h.mask),h.disableAll(),i.fog&&h.enable(0);i.useFog&&h.enable(1);i.flatShading&&h.enable(2);i.logarithmicDepthBuffer&&h.enable(3);i.reverseDepthBuffer&&h.enable(4);i.skinning&&h.enable(5);i.morphTargets&&h.enable(6);i.morphNormals&&h.enable(7);i.morphColors&&h.enable(8);i.premultipliedAlpha&&h.enable(9);i.shadowMapEnabled&&h.enable(10);i.doubleSided&&h.enable(11);i.flipSided&&h.enable(12);i.useDepthPacking&&h.enable(13);i.dithering&&h.enable(14);i.transmission&&h.enable(15);i.sheen&&h.enable(16);i.opaque&&h.enable(17);i.pointsUvs&&h.enable(18);i.decodeVideoTexture&&h.enable(19);i.decodeVideoTextureEmissive&&h.enable(20);i.alphaToCoverage&&h.enable(21);t.push(h.mask)}(r,i),r.push(t.outputColorSpace)),r.push(i.customProgramCacheKey),r.join()},getUniforms:function getUniforms(t){const i=v[t.type];let r;if(i){const t=Kr[i];r=En.clone(t.uniforms)}else r=t.uniforms;return r},acquireProgram:function acquireProgram(i,r){let a;for(let t=0,i=p.length;t<i;t++){const i=p[t];if(i.cacheKey===r){a=i,++a.usedTimes;break}}return void 0===a&&(a=new WebGLProgram(t,r,i,l),p.push(a)),a},releaseProgram:function releaseProgram(t){if(0==--t.usedTimes){const i=p.indexOf(t);p[i]=p[p.length-1],p.pop(),t.destroy()}},releaseShaderCache:function releaseShaderCache(t){d.remove(t)},programs:p,dispose:function dispose(){d.dispose()}}}function WebGLProperties(){let t=new WeakMap;return{has:function has(i){return t.has(i)},get:function get(i){let r=t.get(i);return void 0===r&&(r={},t.set(i,r)),r},remove:function remove(i){t.delete(i)},update:function update(i,r,a){t.get(i)[r]=a},dispose:function dispose(){t=new WeakMap}}}function painterSortStable(t,i){return t.groupOrder!==i.groupOrder?t.groupOrder-i.groupOrder:t.renderOrder!==i.renderOrder?t.renderOrder-i.renderOrder:t.material.id!==i.material.id?t.material.id-i.material.id:t.z!==i.z?t.z-i.z:t.id-i.id}function reversePainterSortStable(t,i){return t.groupOrder!==i.groupOrder?t.groupOrder-i.groupOrder:t.renderOrder!==i.renderOrder?t.renderOrder-i.renderOrder:t.z!==i.z?i.z-t.z:t.id-i.id}function WebGLRenderList(){const t=[];let i=0;const r=[],a=[],o=[];function getNextRenderItem(r,a,o,l,c,h){let d=t[i];return void 0===d?(d={id:r.id,object:r,geometry:a,material:o,groupOrder:l,renderOrder:r.renderOrder,z:c,group:h},t[i]=d):(d.id=r.id,d.object=r,d.geometry=a,d.material=o,d.groupOrder=l,d.renderOrder=r.renderOrder,d.z=c,d.group=h),i++,d}return{opaque:r,transmissive:a,transparent:o,init:function init(){i=0,r.length=0,a.length=0,o.length=0},push:function push(t,i,l,c,h,d){const u=getNextRenderItem(t,i,l,c,h,d);l.transmission>0?a.push(u):!0===l.transparent?o.push(u):r.push(u)},unshift:function unshift(t,i,l,c,h,d){const u=getNextRenderItem(t,i,l,c,h,d);l.transmission>0?a.unshift(u):!0===l.transparent?o.unshift(u):r.unshift(u)},finish:function finish(){for(let r=i,a=t.length;r<a;r++){const i=t[r];if(null===i.id)break;i.id=null,i.object=null,i.geometry=null,i.material=null,i.group=null}},sort:function sort(t,i){r.length>1&&r.sort(t||painterSortStable),a.length>1&&a.sort(i||reversePainterSortStable),o.length>1&&o.sort(i||reversePainterSortStable)}}}function WebGLRenderLists(){let t=new WeakMap;return{get:function get(i,r){const a=t.get(i);let o;return void 0===a?(o=new WebGLRenderList,t.set(i,[o])):r>=a.length?(o=new WebGLRenderList,a.push(o)):o=a[r],o},dispose:function dispose(){t=new WeakMap}}}function UniformsCache(){const t={};return{get:function(i){if(void 0!==t[i.id])return t[i.id];let r;switch(i.type){case"DirectionalLight":r={direction:new Vector3,color:new $i};break;case"SpotLight":r={position:new Vector3,direction:new Vector3,color:new $i,distance:0,coneCos:0,penumbraCos:0,decay:0};break;case"PointLight":r={position:new Vector3,color:new $i,distance:0,decay:0};break;case"HemisphereLight":r={direction:new Vector3,skyColor:new $i,groundColor:new $i};break;case"RectAreaLight":r={color:new $i,position:new Vector3,halfWidth:new Vector3,halfHeight:new Vector3}}return t[i.id]=r,r}}}let Ps=0;function shadowCastingAndTexturingLightsFirst(t,i){return(i.castShadow?2:0)-(t.castShadow?2:0)+(i.map?1:0)-(t.map?1:0)}function WebGLLights(t){const i=new UniformsCache,r=function ShadowUniformsCache(){const t={};return{get:function(i){if(void 0!==t[i.id])return t[i.id];let r;switch(i.type){case"DirectionalLight":case"SpotLight":r={shadowIntensity:1,shadowBias:0,shadowNormalBias:0,shadowRadius:1,shadowMapSize:new Vector2};break;case"PointLight":r={shadowIntensity:1,shadowBias:0,shadowNormalBias:0,shadowRadius:1,shadowMapSize:new Vector2,shadowCameraNear:1,shadowCameraFar:1e3}}return t[i.id]=r,r}}}(),a={version:0,hash:{directionalLength:-1,pointLength:-1,spotLength:-1,rectAreaLength:-1,hemiLength:-1,numDirectionalShadows:-1,numPointShadows:-1,numSpotShadows:-1,numSpotMaps:-1,numLightProbes:-1},ambient:[0,0,0],probe:[],directional:[],directionalShadow:[],directionalShadowMap:[],directionalShadowMatrix:[],spot:[],spotLightMap:[],spotShadow:[],spotShadowMap:[],spotLightMatrix:[],rectArea:[],rectAreaLTC1:null,rectAreaLTC2:null,point:[],pointShadow:[],pointShadowMap:[],pointShadowMatrix:[],hemi:[],numSpotLightShadowsWithMaps:0,numLightProbes:0};for(let t=0;t<9;t++)a.probe.push(new Vector3);const o=new Vector3,l=new Matrix4,c=new Matrix4;return{setup:function setup(o){let l=0,c=0,h=0;for(let t=0;t<9;t++)a.probe[t].set(0,0,0);let d=0,u=0,p=0,m=0,g=0,y=0,v=0,x=0,b=0,_=0,S=0;o.sort(shadowCastingAndTexturingLightsFirst);for(let t=0,M=o.length;t<M;t++){const M=o[t],w=M.color,T=M.intensity,E=M.distance,A=M.shadow&&M.shadow.map?M.shadow.map.texture:null;if(M.isAmbientLight)l+=w.r*T,c+=w.g*T,h+=w.b*T;else if(M.isLightProbe){for(let t=0;t<9;t++)a.probe[t].addScaledVector(M.sh.coefficients[t],T);S++}else if(M.isDirectionalLight){const t=i.get(M);if(t.color.copy(M.color).multiplyScalar(M.intensity),M.castShadow){const t=M.shadow,i=r.get(M);i.shadowIntensity=t.intensity,i.shadowBias=t.bias,i.shadowNormalBias=t.normalBias,i.shadowRadius=t.radius,i.shadowMapSize=t.mapSize,a.directionalShadow[d]=i,a.directionalShadowMap[d]=A,a.directionalShadowMatrix[d]=M.shadow.matrix,y++}a.directional[d]=t,d++}else if(M.isSpotLight){const t=i.get(M);t.position.setFromMatrixPosition(M.matrixWorld),t.color.copy(w).multiplyScalar(T),t.distance=E,t.coneCos=Math.cos(M.angle),t.penumbraCos=Math.cos(M.angle*(1-M.penumbra)),t.decay=M.decay,a.spot[p]=t;const o=M.shadow;if(M.map&&(a.spotLightMap[b]=M.map,b++,o.updateMatrices(M),M.castShadow&&_++),a.spotLightMatrix[p]=o.matrix,M.castShadow){const t=r.get(M);t.shadowIntensity=o.intensity,t.shadowBias=o.bias,t.shadowNormalBias=o.normalBias,t.shadowRadius=o.radius,t.shadowMapSize=o.mapSize,a.spotShadow[p]=t,a.spotShadowMap[p]=A,x++}p++}else if(M.isRectAreaLight){const t=i.get(M);t.color.copy(w).multiplyScalar(T),t.halfWidth.set(.5*M.width,0,0),t.halfHeight.set(0,.5*M.height,0),a.rectArea[m]=t,m++}else if(M.isPointLight){const t=i.get(M);if(t.color.copy(M.color).multiplyScalar(M.intensity),t.distance=M.distance,t.decay=M.decay,M.castShadow){const t=M.shadow,i=r.get(M);i.shadowIntensity=t.intensity,i.shadowBias=t.bias,i.shadowNormalBias=t.normalBias,i.shadowRadius=t.radius,i.shadowMapSize=t.mapSize,i.shadowCameraNear=t.camera.near,i.shadowCameraFar=t.camera.far,a.pointShadow[u]=i,a.pointShadowMap[u]=A,a.pointShadowMatrix[u]=M.shadow.matrix,v++}a.point[u]=t,u++}else if(M.isHemisphereLight){const t=i.get(M);t.skyColor.copy(M.color).multiplyScalar(T),t.groundColor.copy(M.groundColor).multiplyScalar(T),a.hemi[g]=t,g++}}m>0&&(!0===t.has("OES_texture_float_linear")?(a.rectAreaLTC1=Zr.LTC_FLOAT_1,a.rectAreaLTC2=Zr.LTC_FLOAT_2):(a.rectAreaLTC1=Zr.LTC_HALF_1,a.rectAreaLTC2=Zr.LTC_HALF_2)),a.ambient[0]=l,a.ambient[1]=c,a.ambient[2]=h;const M=a.hash;M.directionalLength===d&&M.pointLength===u&&M.spotLength===p&&M.rectAreaLength===m&&M.hemiLength===g&&M.numDirectionalShadows===y&&M.numPointShadows===v&&M.numSpotShadows===x&&M.numSpotMaps===b&&M.numLightProbes===S||(a.directional.length=d,a.spot.length=p,a.rectArea.length=m,a.point.length=u,a.hemi.length=g,a.directionalShadow.length=y,a.directionalShadowMap.length=y,a.pointShadow.length=v,a.pointShadowMap.length=v,a.spotShadow.length=x,a.spotShadowMap.length=x,a.directionalShadowMatrix.length=y,a.pointShadowMatrix.length=v,a.spotLightMatrix.length=x+b-_,a.spotLightMap.length=b,a.numSpotLightShadowsWithMaps=_,a.numLightProbes=S,M.directionalLength=d,M.pointLength=u,M.spotLength=p,M.rectAreaLength=m,M.hemiLength=g,M.numDirectionalShadows=y,M.numPointShadows=v,M.numSpotShadows=x,M.numSpotMaps=b,M.numLightProbes=S,a.version=Ps++)},setupView:function setupView(t,i){let r=0,h=0,d=0,u=0,p=0;const m=i.matrixWorldInverse;for(let i=0,g=t.length;i<g;i++){const g=t[i];if(g.isDirectionalLight){const t=a.directional[r];t.direction.setFromMatrixPosition(g.matrixWorld),o.setFromMatrixPosition(g.target.matrixWorld),t.direction.sub(o),t.direction.transformDirection(m),r++}else if(g.isSpotLight){const t=a.spot[d];t.position.setFromMatrixPosition(g.matrixWorld),t.position.applyMatrix4(m),t.direction.setFromMatrixPosition(g.matrixWorld),o.setFromMatrixPosition(g.target.matrixWorld),t.direction.sub(o),t.direction.transformDirection(m),d++}else if(g.isRectAreaLight){const t=a.rectArea[u];t.position.setFromMatrixPosition(g.matrixWorld),t.position.applyMatrix4(m),c.identity(),l.copy(g.matrixWorld),l.premultiply(m),c.extractRotation(l),t.halfWidth.set(.5*g.width,0,0),t.halfHeight.set(0,.5*g.height,0),t.halfWidth.applyMatrix4(c),t.halfHeight.applyMatrix4(c),u++}else if(g.isPointLight){const t=a.point[h];t.position.setFromMatrixPosition(g.matrixWorld),t.position.applyMatrix4(m),h++}else if(g.isHemisphereLight){const t=a.hemi[p];t.direction.setFromMatrixPosition(g.matrixWorld),t.direction.transformDirection(m),p++}}},state:a}}function WebGLRenderState(t){const i=new WebGLLights(t),r=[],a=[];const o={lightsArray:r,shadowsArray:a,camera:null,lights:i,transmissionRenderTarget:{}};return{init:function init(t){o.camera=t,r.length=0,a.length=0},state:o,setupLights:function setupLights(){i.setup(r)},setupLightsView:function setupLightsView(t){i.setupView(r,t)},pushLight:function pushLight(t){r.push(t)},pushShadow:function pushShadow(t){a.push(t)}}}function WebGLRenderStates(t){let i=new WeakMap;return{get:function get(r,a=0){const o=i.get(r);let l;return void 0===o?(l=new WebGLRenderState(t),i.set(r,[l])):a>=o.length?(l=new WebGLRenderState(t),o.push(l)):l=o[a],l},dispose:function dispose(){i=new WeakMap}}}function WebGLShadowMap(t,i,r){let a=new Frustum;const o=new Vector2,l=new Vector2,c=new Vector4,h=new MeshDepthMaterial({depthPacking:3201}),d=new MeshDistanceMaterial,u={},y=r.maxTextureSize,v={[p]:1,[m]:0,[g]:2},x=new ShaderMaterial({defines:{VSM_SAMPLES:8},uniforms:{shadow_pass:{value:null},resolution:{value:new Vector2},radius:{value:4}},vertexShader:"void main() {\n\tgl_Position = vec4( position, 1.0 );\n}",fragmentShader:"uniform sampler2D shadow_pass;\nuniform vec2 resolution;\nuniform float radius;\n#include <packing>\nvoid main() {\n\tconst float samples = float( VSM_SAMPLES );\n\tfloat mean = 0.0;\n\tfloat squared_mean = 0.0;\n\tfloat uvStride = samples <= 1.0 ? 0.0 : 2.0 / ( samples - 1.0 );\n\tfloat uvStart = samples <= 1.0 ? 0.0 : - 1.0;\n\tfor ( float i = 0.0; i < samples; i ++ ) {\n\t\tfloat uvOffset = uvStart + i * uvStride;\n\t\t#ifdef HORIZONTAL_PASS\n\t\t\tvec2 distribution = unpackRGBATo2Half( texture2D( shadow_pass, ( gl_FragCoord.xy + vec2( uvOffset, 0.0 ) * radius ) / resolution ) );\n\t\t\tmean += distribution.x;\n\t\t\tsquared_mean += distribution.y * distribution.y + distribution.x * distribution.x;\n\t\t#else\n\t\t\tfloat depth = unpackRGBAToDepth( texture2D( shadow_pass, ( gl_FragCoord.xy + vec2( 0.0, uvOffset ) * radius ) / resolution ) );\n\t\t\tmean += depth;\n\t\t\tsquared_mean += depth * depth;\n\t\t#endif\n\t}\n\tmean = mean / samples;\n\tsquared_mean = squared_mean / samples;\n\tfloat std_dev = sqrt( squared_mean - mean * mean );\n\tgl_FragColor = pack2HalfToRGBA( vec2( mean, std_dev ) );\n}"}),b=x.clone();b.defines.HORIZONTAL_PASS=1;const _=new BufferGeometry;_.setAttribute("position",new BufferAttribute(new Float32Array([-1,-1,.5,3,-1,.5,-1,3,.5]),3));const S=new Mesh(_,x),M=this;this.enabled=!1,this.autoUpdate=!0,this.needsUpdate=!1,this.type=1;let w=this.type;function VSMPass(r,a){const l=i.update(S);x.defines.VSM_SAMPLES!==r.blurSamples&&(x.defines.VSM_SAMPLES=r.blurSamples,b.defines.VSM_SAMPLES=r.blurSamples,x.needsUpdate=!0,b.needsUpdate=!0),null===r.mapPass&&(r.mapPass=new WebGLRenderTarget(o.x,o.y)),x.uniforms.shadow_pass.value=r.map.texture,x.uniforms.resolution.value=r.mapSize,x.uniforms.radius.value=r.radius,t.setRenderTarget(r.mapPass),t.clear(),t.renderBufferDirect(a,null,l,x,S,null),b.uniforms.shadow_pass.value=r.mapPass.texture,b.uniforms.resolution.value=r.mapSize,b.uniforms.radius.value=r.radius,t.setRenderTarget(r.map),t.clear(),t.renderBufferDirect(a,null,l,b,S,null)}function getDepthMaterial(i,r,a,o){let l=null;const c=!0===a.isPointLight?i.customDistanceMaterial:i.customDepthMaterial;if(void 0!==c)l=c;else if(l=!0===a.isPointLight?d:h,t.localClippingEnabled&&!0===r.clipShadows&&Array.isArray(r.clippingPlanes)&&0!==r.clippingPlanes.length||r.displacementMap&&0!==r.displacementScale||r.alphaMap&&r.alphaTest>0||r.map&&r.alphaTest>0){const t=l.uuid,i=r.uuid;let a=u[t];void 0===a&&(a={},u[t]=a);let o=a[i];void 0===o&&(o=l.clone(),a[i]=o,r.addEventListener("dispose",onMaterialDispose)),l=o}if(l.visible=r.visible,l.wireframe=r.wireframe,l.side=3===o?null!==r.shadowSide?r.shadowSide:r.side:null!==r.shadowSide?r.shadowSide:v[r.side],l.alphaMap=r.alphaMap,l.alphaTest=r.alphaTest,l.map=r.map,l.clipShadows=r.clipShadows,l.clippingPlanes=r.clippingPlanes,l.clipIntersection=r.clipIntersection,l.displacementMap=r.displacementMap,l.displacementScale=r.displacementScale,l.displacementBias=r.displacementBias,l.wireframeLinewidth=r.wireframeLinewidth,l.linewidth=r.linewidth,!0===a.isPointLight&&!0===l.isMeshDistanceMaterial){t.properties.get(l).light=a}return l}function renderObject(r,o,l,c,h){if(!1===r.visible)return;if(r.layers.test(o.layers)&&(r.isMesh||r.isLine||r.isPoints)&&(r.castShadow||r.receiveShadow&&3===h)&&(!r.frustumCulled||a.intersectsObject(r))){r.modelViewMatrix.multiplyMatrices(l.matrixWorldInverse,r.matrixWorld);const a=i.update(r),d=r.material;if(Array.isArray(d)){const i=a.groups;for(let u=0,p=i.length;u<p;u++){const p=i[u],m=d[p.materialIndex];if(m&&m.visible){const i=getDepthMaterial(r,m,c,h);r.onBeforeShadow(t,r,o,l,a,i,p),t.renderBufferDirect(l,null,a,i,r,p),r.onAfterShadow(t,r,o,l,a,i,p)}}}else if(d.visible){const i=getDepthMaterial(r,d,c,h);r.onBeforeShadow(t,r,o,l,a,i,null),t.renderBufferDirect(l,null,a,i,r,null),r.onAfterShadow(t,r,o,l,a,i,null)}}const d=r.children;for(let t=0,i=d.length;t<i;t++)renderObject(d[t],o,l,c,h)}function onMaterialDispose(t){t.target.removeEventListener("dispose",onMaterialDispose);for(const i in u){const r=u[i],a=t.target.uuid;if(a in r){r[a].dispose(),delete r[a]}}}this.render=function(i,r,h){if(!1===M.enabled)return;if(!1===M.autoUpdate&&!1===M.needsUpdate)return;if(0===i.length)return;const d=t.getRenderTarget(),u=t.getActiveCubeFace(),p=t.getActiveMipmapLevel(),m=t.state;m.setBlending(0),m.buffers.color.setClear(1,1,1,1),m.buffers.depth.setTest(!0),m.setScissorTest(!1);const g=3!==w&&3===this.type,v=3===w&&3!==this.type;for(let d=0,u=i.length;d<u;d++){const u=i[d],p=u.shadow;if(void 0===p)continue;if(!1===p.autoUpdate&&!1===p.needsUpdate)continue;o.copy(p.mapSize);const x=p.getFrameExtents();if(o.multiply(x),l.copy(p.mapSize),(o.x>y||o.y>y)&&(o.x>y&&(l.x=Math.floor(y/x.x),o.x=l.x*x.x,p.mapSize.x=l.x),o.y>y&&(l.y=Math.floor(y/x.y),o.y=l.y*x.y,p.mapSize.y=l.y)),null===p.map||!0===g||!0===v){const t=3!==this.type?{minFilter:Q,magFilter:Q}:{};null!==p.map&&p.map.dispose(),p.map=new WebGLRenderTarget(o.x,o.y,t),p.map.texture.name=u.name+".shadowMap",p.camera.updateProjectionMatrix()}t.setRenderTarget(p.map),t.clear();const b=p.getViewportCount();for(let t=0;t<b;t++){const i=p.getViewport(t);c.set(l.x*i.x,l.y*i.y,l.x*i.z,l.y*i.w),m.viewport(c),p.updateMatrices(u,t),a=p.getFrustum(),renderObject(r,h,p.camera,u,this.type)}!0!==p.isPointLightShadow&&3===this.type&&VSMPass(p,h),p.needsUpdate=!1}w=this.type,M.needsUpdate=!1,t.setRenderTarget(d,u,p)}}const Rs={[O]:1,[B]:6,[V]:7,[z]:5,[U]:0,[G]:2,[H]:4,[k]:3};function WebGLState(t,i){const r=new function ColorBuffer(){let i=!1;const r=new Vector4;let a=null;const o=new Vector4(0,0,0,0);return{setMask:function(r){a===r||i||(t.colorMask(r,r,r,r),a=r)},setLocked:function(t){i=t},setClear:function(i,a,l,c,h){!0===h&&(i*=c,a*=c,l*=c),r.set(i,a,l,c),!1===o.equals(r)&&(t.clearColor(i,a,l,c),o.copy(r))},reset:function(){i=!1,a=null,o.set(-1,0,0,0)}}},a=new function DepthBuffer(){let r=!1,a=!1,o=null,l=null,c=null;return{setReversed:function(t){if(a!==t){const t=i.get("EXT_clip_control");a?t.clipControlEXT(t.LOWER_LEFT_EXT,t.ZERO_TO_ONE_EXT):t.clipControlEXT(t.LOWER_LEFT_EXT,t.NEGATIVE_ONE_TO_ONE_EXT);const r=c;c=null,this.setClear(r)}a=t},getReversed:function(){return a},setTest:function(i){i?enable(t.DEPTH_TEST):disable(t.DEPTH_TEST)},setMask:function(i){o===i||r||(t.depthMask(i),o=i)},setFunc:function(i){if(a&&(i=Rs[i]),l!==i){switch(i){case 0:t.depthFunc(t.NEVER);break;case 1:t.depthFunc(t.ALWAYS);break;case 2:t.depthFunc(t.LESS);break;case 3:default:t.depthFunc(t.LEQUAL);break;case 4:t.depthFunc(t.EQUAL);break;case 5:t.depthFunc(t.GEQUAL);break;case 6:t.depthFunc(t.GREATER);break;case 7:t.depthFunc(t.NOTEQUAL)}l=i}},setLocked:function(t){r=t},setClear:function(i){c!==i&&(a&&(i=1-i),t.clearDepth(i),c=i)},reset:function(){r=!1,o=null,l=null,c=null,a=!1}}},o=new function StencilBuffer(){let i=!1,r=null,a=null,o=null,l=null,c=null,h=null,d=null,u=null;return{setTest:function(r){i||(r?enable(t.STENCIL_TEST):disable(t.STENCIL_TEST))},setMask:function(a){r===a||i||(t.stencilMask(a),r=a)},setFunc:function(i,r,c){a===i&&o===r&&l===c||(t.stencilFunc(i,r,c),a=i,o=r,l=c)},setOp:function(i,r,a){c===i&&h===r&&d===a||(t.stencilOp(i,r,a),c=i,h=r,d=a)},setLocked:function(t){i=t},setClear:function(i){u!==i&&(t.clearStencil(i),u=i)},reset:function(){i=!1,r=null,a=null,o=null,l=null,c=null,h=null,d=null,u=null}}},l=new WeakMap,c=new WeakMap;let h={},d={},u=new WeakMap,p=[],m=null,g=!1,O=null,U=null,B=null,z=null,V=null,k=null,G=null,H=new $i(0,0,0),W=0,j=!1,X=null,q=null,Y=null,Z=null,K=null;const Q=t.getParameter(t.MAX_COMBINED_TEXTURE_IMAGE_UNITS);let J=!1,$=0;const ee=t.getParameter(t.VERSION);-1!==ee.indexOf("WebGL")?($=parseFloat(/^WebGL (\d)/.exec(ee)[1]),J=$>=1):-1!==ee.indexOf("OpenGL ES")&&($=parseFloat(/^OpenGL ES (\d)/.exec(ee)[1]),J=$>=2);let te=null,ie={};const ne=t.getParameter(t.SCISSOR_BOX),re=t.getParameter(t.VIEWPORT),se=(new Vector4).fromArray(ne),ae=(new Vector4).fromArray(re);function createTexture(i,r,a,o){const l=new Uint8Array(4),c=t.createTexture();t.bindTexture(i,c),t.texParameteri(i,t.TEXTURE_MIN_FILTER,t.NEAREST),t.texParameteri(i,t.TEXTURE_MAG_FILTER,t.NEAREST);for(let c=0;c<a;c++)i===t.TEXTURE_3D||i===t.TEXTURE_2D_ARRAY?t.texImage3D(r,0,t.RGBA,1,1,o,0,t.RGBA,t.UNSIGNED_BYTE,l):t.texImage2D(r+c,0,t.RGBA,1,1,0,t.RGBA,t.UNSIGNED_BYTE,l);return c}const oe={};function enable(i){!0!==h[i]&&(t.enable(i),h[i]=!0)}function disable(i){!1!==h[i]&&(t.disable(i),h[i]=!1)}oe[t.TEXTURE_2D]=createTexture(t.TEXTURE_2D,t.TEXTURE_2D,1),oe[t.TEXTURE_CUBE_MAP]=createTexture(t.TEXTURE_CUBE_MAP,t.TEXTURE_CUBE_MAP_POSITIVE_X,6),oe[t.TEXTURE_2D_ARRAY]=createTexture(t.TEXTURE_2D_ARRAY,t.TEXTURE_2D_ARRAY,1,1),oe[t.TEXTURE_3D]=createTexture(t.TEXTURE_3D,t.TEXTURE_3D,1,1),r.setClear(0,0,0,1),a.setClear(1),o.setClear(0),enable(t.DEPTH_TEST),a.setFunc(3),setFlipSided(!1),setCullFace(1),enable(t.CULL_FACE),setBlending(0);const le={[y]:t.FUNC_ADD,[v]:t.FUNC_SUBTRACT,[x]:t.FUNC_REVERSE_SUBTRACT};le[103]=t.MIN,le[104]=t.MAX;const ce={[b]:t.ZERO,[_]:t.ONE,[S]:t.SRC_COLOR,[w]:t.SRC_ALPHA,[R]:t.SRC_ALPHA_SATURATE,[C]:t.DST_COLOR,[E]:t.DST_ALPHA,[M]:t.ONE_MINUS_SRC_COLOR,[T]:t.ONE_MINUS_SRC_ALPHA,[P]:t.ONE_MINUS_DST_COLOR,[A]:t.ONE_MINUS_DST_ALPHA,[I]:t.CONSTANT_COLOR,[D]:t.ONE_MINUS_CONSTANT_COLOR,[L]:t.CONSTANT_ALPHA,[N]:t.ONE_MINUS_CONSTANT_ALPHA};function setBlending(i,r,a,o,l,c,h,d,u,p){if(0!==i){if(!1===g&&(enable(t.BLEND),g=!0),5===i)l=l||r,c=c||a,h=h||o,r===U&&l===V||(t.blendEquationSeparate(le[r],le[l]),U=r,V=l),a===B&&o===z&&c===k&&h===G||(t.blendFuncSeparate(ce[a],ce[o],ce[c],ce[h]),B=a,z=o,k=c,G=h),!1!==d.equals(H)&&u===W||(t.blendColor(d.r,d.g,d.b,u),H.copy(d),W=u),O=i,j=!1;else if(i!==O||p!==j){if(U===y&&V===y||(t.blendEquation(t.FUNC_ADD),U=y,V=y),p)switch(i){case 1:t.blendFuncSeparate(t.ONE,t.ONE_MINUS_SRC_ALPHA,t.ONE,t.ONE_MINUS_SRC_ALPHA);break;case 2:t.blendFunc(t.ONE,t.ONE);break;case 3:t.blendFuncSeparate(t.ZERO,t.ONE_MINUS_SRC_COLOR,t.ZERO,t.ONE);break;case 4:t.blendFuncSeparate(t.ZERO,t.SRC_COLOR,t.ZERO,t.SRC_ALPHA)}else switch(i){case 1:t.blendFuncSeparate(t.SRC_ALPHA,t.ONE_MINUS_SRC_ALPHA,t.ONE,t.ONE_MINUS_SRC_ALPHA);break;case 2:t.blendFunc(t.SRC_ALPHA,t.ONE);break;case 3:t.blendFuncSeparate(t.ZERO,t.ONE_MINUS_SRC_COLOR,t.ZERO,t.ONE);break;case 4:t.blendFunc(t.ZERO,t.SRC_COLOR)}B=null,z=null,k=null,G=null,H.set(0,0,0),W=0,O=i,j=p}}else!0===g&&(disable(t.BLEND),g=!1)}function setFlipSided(i){X!==i&&(i?t.frontFace(t.CW):t.frontFace(t.CCW),X=i)}function setCullFace(i){0!==i?(enable(t.CULL_FACE),i!==q&&(1===i?t.cullFace(t.BACK):2===i?t.cullFace(t.FRONT):t.cullFace(t.FRONT_AND_BACK))):disable(t.CULL_FACE),q=i}function setPolygonOffset(i,r,a){i?(enable(t.POLYGON_OFFSET_FILL),Z===r&&K===a||(t.polygonOffset(r,a),Z=r,K=a)):disable(t.POLYGON_OFFSET_FILL)}return{buffers:{color:r,depth:a,stencil:o},enable,disable,bindFramebuffer:function bindFramebuffer(i,r){return d[i]!==r&&(t.bindFramebuffer(i,r),d[i]=r,i===t.DRAW_FRAMEBUFFER&&(d[t.FRAMEBUFFER]=r),i===t.FRAMEBUFFER&&(d[t.DRAW_FRAMEBUFFER]=r),!0)},drawBuffers:function drawBuffers(i,r){let a=p,o=!1;if(i){a=u.get(r),void 0===a&&(a=[],u.set(r,a));const l=i.textures;if(a.length!==l.length||a[0]!==t.COLOR_ATTACHMENT0){for(let i=0,r=l.length;i<r;i++)a[i]=t.COLOR_ATTACHMENT0+i;a.length=l.length,o=!0}}else a[0]!==t.BACK&&(a[0]=t.BACK,o=!0);o&&t.drawBuffers(a)},useProgram:function useProgram(i){return m!==i&&(t.useProgram(i),m=i,!0)},setBlending,setMaterial:function setMaterial(i,l){2===i.side?disable(t.CULL_FACE):enable(t.CULL_FACE);let c=1===i.side;l&&(c=!c),setFlipSided(c),1===i.blending&&!1===i.transparent?setBlending(0):setBlending(i.blending,i.blendEquation,i.blendSrc,i.blendDst,i.blendEquationAlpha,i.blendSrcAlpha,i.blendDstAlpha,i.blendColor,i.blendAlpha,i.premultipliedAlpha),a.setFunc(i.depthFunc),a.setTest(i.depthTest),a.setMask(i.depthWrite),r.setMask(i.colorWrite);const h=i.stencilWrite;o.setTest(h),h&&(o.setMask(i.stencilWriteMask),o.setFunc(i.stencilFunc,i.stencilRef,i.stencilFuncMask),o.setOp(i.stencilFail,i.stencilZFail,i.stencilZPass)),setPolygonOffset(i.polygonOffset,i.polygonOffsetFactor,i.polygonOffsetUnits),!0===i.alphaToCoverage?enable(t.SAMPLE_ALPHA_TO_COVERAGE):disable(t.SAMPLE_ALPHA_TO_COVERAGE)},setFlipSided,setCullFace,setLineWidth:function setLineWidth(i){i!==Y&&(J&&t.lineWidth(i),Y=i)},setPolygonOffset,setScissorTest:function setScissorTest(i){i?enable(t.SCISSOR_TEST):disable(t.SCISSOR_TEST)},activeTexture:function activeTexture(i){void 0===i&&(i=t.TEXTURE0+Q-1),te!==i&&(t.activeTexture(i),te=i)},bindTexture:function bindTexture(i,r,a){void 0===a&&(a=null===te?t.TEXTURE0+Q-1:te);let o=ie[a];void 0===o&&(o={type:void 0,texture:void 0},ie[a]=o),o.type===i&&o.texture===r||(te!==a&&(t.activeTexture(a),te=a),t.bindTexture(i,r||oe[i]),o.type=i,o.texture=r)},unbindTexture:function unbindTexture(){const i=ie[te];void 0!==i&&void 0!==i.type&&(t.bindTexture(i.type,null),i.type=void 0,i.texture=void 0)},compressedTexImage2D:function compressedTexImage2D(){try{t.compressedTexImage2D.apply(t,arguments)}catch(t){}},compressedTexImage3D:function compressedTexImage3D(){try{t.compressedTexImage3D.apply(t,arguments)}catch(t){}},texImage2D:function texImage2D(){try{t.texImage2D.apply(t,arguments)}catch(t){}},texImage3D:function texImage3D(){try{t.texImage3D.apply(t,arguments)}catch(t){}},updateUBOMapping:function updateUBOMapping(i,r){let a=c.get(r);void 0===a&&(a=new WeakMap,c.set(r,a));let o=a.get(i);void 0===o&&(o=t.getUniformBlockIndex(r,i.name),a.set(i,o))},uniformBlockBinding:function uniformBlockBinding(i,r){const a=c.get(r).get(i);l.get(r)!==a&&(t.uniformBlockBinding(r,a,i.__bindingPointIndex),l.set(r,a))},texStorage2D:function texStorage2D(){try{t.texStorage2D.apply(t,arguments)}catch(t){}},texStorage3D:function texStorage3D(){try{t.texStorage3D.apply(t,arguments)}catch(t){}},texSubImage2D:function texSubImage2D(){try{t.texSubImage2D.apply(t,arguments)}catch(t){}},texSubImage3D:function texSubImage3D(){try{t.texSubImage3D.apply(t,arguments)}catch(t){}},compressedTexSubImage2D:function compressedTexSubImage2D(){try{t.compressedTexSubImage2D.apply(t,arguments)}catch(t){}},compressedTexSubImage3D:function compressedTexSubImage3D(){try{t.compressedTexSubImage3D.apply(t,arguments)}catch(t){}},scissor:function scissor(i){!1===se.equals(i)&&(t.scissor(i.x,i.y,i.z,i.w),se.copy(i))},viewport:function viewport(i){!1===ae.equals(i)&&(t.viewport(i.x,i.y,i.z,i.w),ae.copy(i))},reset:function reset(){t.disable(t.BLEND),t.disable(t.CULL_FACE),t.disable(t.DEPTH_TEST),t.disable(t.POLYGON_OFFSET_FILL),t.disable(t.SCISSOR_TEST),t.disable(t.STENCIL_TEST),t.disable(t.SAMPLE_ALPHA_TO_COVERAGE),t.blendEquation(t.FUNC_ADD),t.blendFunc(t.ONE,t.ZERO),t.blendFuncSeparate(t.ONE,t.ZERO,t.ONE,t.ZERO),t.blendColor(0,0,0,0),t.colorMask(!0,!0,!0,!0),t.clearColor(0,0,0,0),t.depthMask(!0),t.depthFunc(t.LESS),a.setReversed(!1),t.clearDepth(1),t.stencilMask(4294967295),t.stencilFunc(t.ALWAYS,0,4294967295),t.stencilOp(t.KEEP,t.KEEP,t.KEEP),t.clearStencil(0),t.cullFace(t.BACK),t.frontFace(t.CCW),t.polygonOffset(0,0),t.activeTexture(t.TEXTURE0),t.bindFramebuffer(t.FRAMEBUFFER,null),t.bindFramebuffer(t.DRAW_FRAMEBUFFER,null),t.bindFramebuffer(t.READ_FRAMEBUFFER,null),t.useProgram(null),t.lineWidth(1),t.scissor(0,0,t.canvas.width,t.canvas.height),t.viewport(0,0,t.canvas.width,t.canvas.height),h={},te=null,ie={},d={},u=new WeakMap,p=[],m=null,g=!1,O=null,U=null,B=null,z=null,V=null,k=null,G=null,H=new $i(0,0,0),W=0,j=!1,X=null,q=null,Y=null,Z=null,K=null,se.set(0,0,t.canvas.width,t.canvas.height),ae.set(0,0,t.canvas.width,t.canvas.height),r.reset(),a.reset(),o.reset()}}}function WebGLTextures(t,i,r,a,o,l,c){const h=i.has("WEBGL_multisampled_render_to_texture")?i.get("WEBGL_multisampled_render_to_texture"):null,d="undefined"!=typeof navigator&&/OculusBrowser/g.test(navigator.userAgent),u=new Vector2,p=new WeakMap;let m;const g=new WeakMap;let y=!1;try{y="undefined"!=typeof OffscreenCanvas&&null!==new OffscreenCanvas(1,1).getContext("2d")}catch(t){}function createCanvas(t,i){return y?new OffscreenCanvas(t,i):createElementNS("canvas")}function resizeImage(t,i,r){let a=1;const o=getDimensions(t);if((o.width>r||o.height>r)&&(a=r/Math.max(o.width,o.height)),a<1){if("undefined"!=typeof HTMLImageElement&&t instanceof HTMLImageElement||"undefined"!=typeof HTMLCanvasElement&&t instanceof HTMLCanvasElement||"undefined"!=typeof ImageBitmap&&t instanceof ImageBitmap||"undefined"!=typeof VideoFrame&&t instanceof VideoFrame){const r=Math.floor(a*o.width),l=Math.floor(a*o.height);void 0===m&&(m=createCanvas(r,l));const c=i?createCanvas(r,l):m;c.width=r,c.height=l;return c.getContext("2d").drawImage(t,0,0,r,l),c}return t}return t}function textureNeedsGenerateMipmaps(t){return t.generateMipmaps}function generateMipmap(i){t.generateMipmap(i)}function getTargetType(i){return i.isWebGLCubeRenderTarget?t.TEXTURE_CUBE_MAP:i.isWebGL3DRenderTarget?t.TEXTURE_3D:i.isWebGLArrayRenderTarget||i.isCompressedArrayTexture?t.TEXTURE_2D_ARRAY:t.TEXTURE_2D}function getInternalFormat(r,a,o,l,c=!1){if(null!==r&&void 0!==t[r])return t[r];let h=a;if(a===t.RED&&(o===t.FLOAT&&(h=t.R32F),o===t.HALF_FLOAT&&(h=t.R16F),o===t.UNSIGNED_BYTE&&(h=t.R8)),a===t.RED_INTEGER&&(o===t.UNSIGNED_BYTE&&(h=t.R8UI),o===t.UNSIGNED_SHORT&&(h=t.R16UI),o===t.UNSIGNED_INT&&(h=t.R32UI),o===t.BYTE&&(h=t.R8I),o===t.SHORT&&(h=t.R16I),o===t.INT&&(h=t.R32I)),a===t.RG&&(o===t.FLOAT&&(h=t.RG32F),o===t.HALF_FLOAT&&(h=t.RG16F),o===t.UNSIGNED_BYTE&&(h=t.RG8)),a===t.RG_INTEGER&&(o===t.UNSIGNED_BYTE&&(h=t.RG8UI),o===t.UNSIGNED_SHORT&&(h=t.RG16UI),o===t.UNSIGNED_INT&&(h=t.RG32UI),o===t.BYTE&&(h=t.RG8I),o===t.SHORT&&(h=t.RG16I),o===t.INT&&(h=t.RG32I)),a===t.RGB_INTEGER&&(o===t.UNSIGNED_BYTE&&(h=t.RGB8UI),o===t.UNSIGNED_SHORT&&(h=t.RGB16UI),o===t.UNSIGNED_INT&&(h=t.RGB32UI),o===t.BYTE&&(h=t.RGB8I),o===t.SHORT&&(h=t.RGB16I),o===t.INT&&(h=t.RGB32I)),a===t.RGBA_INTEGER&&(o===t.UNSIGNED_BYTE&&(h=t.RGBA8UI),o===t.UNSIGNED_SHORT&&(h=t.RGBA16UI),o===t.UNSIGNED_INT&&(h=t.RGBA32UI),o===t.BYTE&&(h=t.RGBA8I),o===t.SHORT&&(h=t.RGBA16I),o===t.INT&&(h=t.RGBA32I)),a===t.RGB&&o===t.UNSIGNED_INT_5_9_9_9_REV&&(h=t.RGB9_E5),a===t.RGBA){const i=c?ht:Ot.getTransfer(l);o===t.FLOAT&&(h=t.RGBA32F),o===t.HALF_FLOAT&&(h=t.RGBA16F),o===t.UNSIGNED_BYTE&&(h=i===dt?t.SRGB8_ALPHA8:t.RGBA8),o===t.UNSIGNED_SHORT_4_4_4_4&&(h=t.RGBA4),o===t.UNSIGNED_SHORT_5_5_5_1&&(h=t.RGB5_A1)}return h!==t.R16F&&h!==t.R32F&&h!==t.RG16F&&h!==t.RG32F&&h!==t.RGBA16F&&h!==t.RGBA32F||i.get("EXT_color_buffer_float"),h}function getInternalDepthFormat(i,r){let a;return i?null===r||r===ce||r===me?a=t.DEPTH24_STENCIL8:r===he?a=t.DEPTH32F_STENCIL8:r===oe&&(a=t.DEPTH24_STENCIL8):null===r||r===ce||r===me?a=t.DEPTH_COMPONENT24:r===he?a=t.DEPTH_COMPONENT32F:r===oe&&(a=t.DEPTH_COMPONENT16),a}function getMipLevels(t,i){return!0===textureNeedsGenerateMipmaps(t)||t.isFramebufferTexture&&t.minFilter!==Q&&t.minFilter!==te?Math.log2(Math.max(i.width,i.height))+1:void 0!==t.mipmaps&&t.mipmaps.length>0?t.mipmaps.length:t.isCompressedTexture&&Array.isArray(t.image)?i.mipmaps.length:1}function onTextureDispose(t){const i=t.target;i.removeEventListener("dispose",onTextureDispose),function deallocateTexture(t){const i=a.get(t);if(void 0===i.__webglInit)return;const r=t.source,o=g.get(r);if(o){const a=o[i.__cacheKey];a.usedTimes--,0===a.usedTimes&&deleteTexture(t),0===Object.keys(o).length&&g.delete(r)}a.remove(t)}(i),i.isVideoTexture&&p.delete(i)}function onRenderTargetDispose(i){const r=i.target;r.removeEventListener("dispose",onRenderTargetDispose),function deallocateRenderTarget(i){const r=a.get(i);i.depthTexture&&(i.depthTexture.dispose(),a.remove(i.depthTexture));if(i.isWebGLCubeRenderTarget)for(let i=0;i<6;i++){if(Array.isArray(r.__webglFramebuffer[i]))for(let a=0;a<r.__webglFramebuffer[i].length;a++)t.deleteFramebuffer(r.__webglFramebuffer[i][a]);else t.deleteFramebuffer(r.__webglFramebuffer[i]);r.__webglDepthbuffer&&t.deleteRenderbuffer(r.__webglDepthbuffer[i])}else{if(Array.isArray(r.__webglFramebuffer))for(let i=0;i<r.__webglFramebuffer.length;i++)t.deleteFramebuffer(r.__webglFramebuffer[i]);else t.deleteFramebuffer(r.__webglFramebuffer);if(r.__webglDepthbuffer&&t.deleteRenderbuffer(r.__webglDepthbuffer),r.__webglMultisampledFramebuffer&&t.deleteFramebuffer(r.__webglMultisampledFramebuffer),r.__webglColorRenderbuffer)for(let i=0;i<r.__webglColorRenderbuffer.length;i++)r.__webglColorRenderbuffer[i]&&t.deleteRenderbuffer(r.__webglColorRenderbuffer[i]);r.__webglDepthRenderbuffer&&t.deleteRenderbuffer(r.__webglDepthRenderbuffer)}const o=i.textures;for(let i=0,r=o.length;i<r;i++){const r=a.get(o[i]);r.__webglTexture&&(t.deleteTexture(r.__webglTexture),c.memory.textures--),a.remove(o[i])}a.remove(i)}(r)}function deleteTexture(i){const r=a.get(i);t.deleteTexture(r.__webglTexture);const o=i.source;delete g.get(o)[r.__cacheKey],c.memory.textures--}let v=0;function setTexture2D(i,o){const l=a.get(i);if(i.isVideoTexture&&function updateVideoTexture(t){const i=c.render.frame;p.get(t)!==i&&(p.set(t,i),t.update())}(i),!1===i.isRenderTargetTexture&&i.version>0&&l.__version!==i.version){const t=i.image;if(null===t);else if(!1!==t.complete)return void uploadTexture(l,i,o)}r.bindTexture(t.TEXTURE_2D,l.__webglTexture,t.TEXTURE0+o)}const x={[Y]:t.REPEAT,[Z]:t.CLAMP_TO_EDGE,[K]:t.MIRRORED_REPEAT},b={[Q]:t.NEAREST,[J]:t.NEAREST_MIPMAP_NEAREST,[ee]:t.NEAREST_MIPMAP_LINEAR,[te]:t.LINEAR,[ie]:t.LINEAR_MIPMAP_NEAREST,[ne]:t.LINEAR_MIPMAP_LINEAR},_={[pt]:t.NEVER,[bt]:t.ALWAYS,[mt]:t.LESS,[gt]:t.LEQUAL,[ft]:t.EQUAL,[xt]:t.GEQUAL,[yt]:t.GREATER,[vt]:t.NOTEQUAL};function setTextureParameters(r,l){if(l.type===he&&!1===i.has("OES_texture_float_linear")&&(l.magFilter===te||l.magFilter===ie||l.magFilter===ee||l.magFilter===ne||l.minFilter===te||l.minFilter===ie||l.minFilter===ee||l.minFilter),t.texParameteri(r,t.TEXTURE_WRAP_S,x[l.wrapS]),t.texParameteri(r,t.TEXTURE_WRAP_T,x[l.wrapT]),r!==t.TEXTURE_3D&&r!==t.TEXTURE_2D_ARRAY||t.texParameteri(r,t.TEXTURE_WRAP_R,x[l.wrapR]),t.texParameteri(r,t.TEXTURE_MAG_FILTER,b[l.magFilter]),t.texParameteri(r,t.TEXTURE_MIN_FILTER,b[l.minFilter]),l.compareFunction&&(t.texParameteri(r,t.TEXTURE_COMPARE_MODE,t.COMPARE_REF_TO_TEXTURE),t.texParameteri(r,t.TEXTURE_COMPARE_FUNC,_[l.compareFunction])),!0===i.has("EXT_texture_filter_anisotropic")){if(l.magFilter===Q)return;if(l.minFilter!==ee&&l.minFilter!==ne)return;if(l.type===he&&!1===i.has("OES_texture_float_linear"))return;if(l.anisotropy>1||a.get(l).__currentAnisotropy){const c=i.get("EXT_texture_filter_anisotropic");t.texParameterf(r,c.TEXTURE_MAX_ANISOTROPY_EXT,Math.min(l.anisotropy,o.getMaxAnisotropy())),a.get(l).__currentAnisotropy=l.anisotropy}}}function initTexture(i,r){let a=!1;void 0===i.__webglInit&&(i.__webglInit=!0,r.addEventListener("dispose",onTextureDispose));const o=r.source;let l=g.get(o);void 0===l&&(l={},g.set(o,l));const h=function getTextureCacheKey(t){const i=[];return i.push(t.wrapS),i.push(t.wrapT),i.push(t.wrapR||0),i.push(t.magFilter),i.push(t.minFilter),i.push(t.anisotropy),i.push(t.internalFormat),i.push(t.format),i.push(t.type),i.push(t.generateMipmaps),i.push(t.premultiplyAlpha),i.push(t.flipY),i.push(t.unpackAlignment),i.push(t.colorSpace),i.join()}(r);if(h!==i.__cacheKey){void 0===l[h]&&(l[h]={texture:t.createTexture(),usedTimes:0},c.memory.textures++,a=!0),l[h].usedTimes++;const o=l[i.__cacheKey];void 0!==o&&(l[i.__cacheKey].usedTimes--,0===o.usedTimes&&deleteTexture(r)),i.__cacheKey=h,i.__webglTexture=l[h].texture}return a}function uploadTexture(i,c,h){let d=t.TEXTURE_2D;(c.isDataArrayTexture||c.isCompressedArrayTexture)&&(d=t.TEXTURE_2D_ARRAY),c.isData3DTexture&&(d=t.TEXTURE_3D);const u=initTexture(i,c),p=c.source;r.bindTexture(d,i.__webglTexture,t.TEXTURE0+h);const m=a.get(p);if(p.version!==m.__version||!0===u){r.activeTexture(t.TEXTURE0+h);const i=Ot.getPrimaries(Ot.workingColorSpace),a=c.colorSpace===ot?null:Ot.getPrimaries(c.colorSpace),g=c.colorSpace===ot||i===a?t.NONE:t.BROWSER_DEFAULT_WEBGL;t.pixelStorei(t.UNPACK_FLIP_Y_WEBGL,c.flipY),t.pixelStorei(t.UNPACK_PREMULTIPLY_ALPHA_WEBGL,c.premultiplyAlpha),t.pixelStorei(t.UNPACK_ALIGNMENT,c.unpackAlignment),t.pixelStorei(t.UNPACK_COLORSPACE_CONVERSION_WEBGL,g);let y=resizeImage(c.image,!1,o.maxTextureSize);y=verifyColorSpace(c,y);const v=l.convert(c.format,c.colorSpace),x=l.convert(c.type);let b,_=getInternalFormat(c.internalFormat,v,x,c.colorSpace,c.isVideoTexture);setTextureParameters(d,c);const S=c.mipmaps,M=!0!==c.isVideoTexture,w=void 0===m.__version||!0===u,T=p.dataReady,E=getMipLevels(c,y);if(c.isDepthTexture)_=getInternalDepthFormat(c.format===ve,c.type),w&&(M?r.texStorage2D(t.TEXTURE_2D,1,_,y.width,y.height):r.texImage2D(t.TEXTURE_2D,0,_,y.width,y.height,0,v,x,null));else if(c.isDataTexture)if(S.length>0){M&&w&&r.texStorage2D(t.TEXTURE_2D,E,_,S[0].width,S[0].height);for(let i=0,a=S.length;i<a;i++)b=S[i],M?T&&r.texSubImage2D(t.TEXTURE_2D,i,0,0,b.width,b.height,v,x,b.data):r.texImage2D(t.TEXTURE_2D,i,_,b.width,b.height,0,v,x,b.data);c.generateMipmaps=!1}else M?(w&&r.texStorage2D(t.TEXTURE_2D,E,_,y.width,y.height),T&&r.texSubImage2D(t.TEXTURE_2D,0,0,0,y.width,y.height,v,x,y.data)):r.texImage2D(t.TEXTURE_2D,0,_,y.width,y.height,0,v,x,y.data);else if(c.isCompressedTexture)if(c.isCompressedArrayTexture){M&&w&&r.texStorage3D(t.TEXTURE_2D_ARRAY,E,_,S[0].width,S[0].height,y.depth);for(let i=0,a=S.length;i<a;i++)if(b=S[i],c.format!==ge){if(null!==v)if(M){if(T)if(c.layerUpdates.size>0){const a=getByteLength(b.width,b.height,c.format,c.type);for(const o of c.layerUpdates){const l=b.data.subarray(o*a/b.data.BYTES_PER_ELEMENT,(o+1)*a/b.data.BYTES_PER_ELEMENT);r.compressedTexSubImage3D(t.TEXTURE_2D_ARRAY,i,0,0,o,b.width,b.height,1,v,l)}c.clearLayerUpdates()}else r.compressedTexSubImage3D(t.TEXTURE_2D_ARRAY,i,0,0,0,b.width,b.height,y.depth,v,b.data)}else r.compressedTexImage3D(t.TEXTURE_2D_ARRAY,i,_,b.width,b.height,y.depth,0,b.data,0,0)}else M?T&&r.texSubImage3D(t.TEXTURE_2D_ARRAY,i,0,0,0,b.width,b.height,y.depth,v,x,b.data):r.texImage3D(t.TEXTURE_2D_ARRAY,i,_,b.width,b.height,y.depth,0,v,x,b.data)}else{M&&w&&r.texStorage2D(t.TEXTURE_2D,E,_,S[0].width,S[0].height);for(let i=0,a=S.length;i<a;i++)b=S[i],c.format!==ge?null!==v&&(M?T&&r.compressedTexSubImage2D(t.TEXTURE_2D,i,0,0,b.width,b.height,v,b.data):r.compressedTexImage2D(t.TEXTURE_2D,i,_,b.width,b.height,0,b.data)):M?T&&r.texSubImage2D(t.TEXTURE_2D,i,0,0,b.width,b.height,v,x,b.data):r.texImage2D(t.TEXTURE_2D,i,_,b.width,b.height,0,v,x,b.data)}else if(c.isDataArrayTexture)if(M){if(w&&r.texStorage3D(t.TEXTURE_2D_ARRAY,E,_,y.width,y.height,y.depth),T)if(c.layerUpdates.size>0){const i=getByteLength(y.width,y.height,c.format,c.type);for(const a of c.layerUpdates){const o=y.data.subarray(a*i/y.data.BYTES_PER_ELEMENT,(a+1)*i/y.data.BYTES_PER_ELEMENT);r.texSubImage3D(t.TEXTURE_2D_ARRAY,0,0,0,a,y.width,y.height,1,v,x,o)}c.clearLayerUpdates()}else r.texSubImage3D(t.TEXTURE_2D_ARRAY,0,0,0,0,y.width,y.height,y.depth,v,x,y.data)}else r.texImage3D(t.TEXTURE_2D_ARRAY,0,_,y.width,y.height,y.depth,0,v,x,y.data);else if(c.isData3DTexture)M?(w&&r.texStorage3D(t.TEXTURE_3D,E,_,y.width,y.height,y.depth),T&&r.texSubImage3D(t.TEXTURE_3D,0,0,0,0,y.width,y.height,y.depth,v,x,y.data)):r.texImage3D(t.TEXTURE_3D,0,_,y.width,y.height,y.depth,0,v,x,y.data);else if(c.isFramebufferTexture){if(w)if(M)r.texStorage2D(t.TEXTURE_2D,E,_,y.width,y.height);else{let i=y.width,a=y.height;for(let o=0;o<E;o++)r.texImage2D(t.TEXTURE_2D,o,_,i,a,0,v,x,null),i>>=1,a>>=1}}else if(S.length>0){if(M&&w){const i=getDimensions(S[0]);r.texStorage2D(t.TEXTURE_2D,E,_,i.width,i.height)}for(let i=0,a=S.length;i<a;i++)b=S[i],M?T&&r.texSubImage2D(t.TEXTURE_2D,i,0,0,v,x,b):r.texImage2D(t.TEXTURE_2D,i,_,v,x,b);c.generateMipmaps=!1}else if(M){if(w){const i=getDimensions(y);r.texStorage2D(t.TEXTURE_2D,E,_,i.width,i.height)}T&&r.texSubImage2D(t.TEXTURE_2D,0,0,0,v,x,y)}else r.texImage2D(t.TEXTURE_2D,0,_,v,x,y);textureNeedsGenerateMipmaps(c)&&generateMipmap(d),m.__version=p.version,c.onUpdate&&c.onUpdate(c)}i.__version=c.version}function setupFrameBufferTexture(i,o,c,d,u,p){const m=l.convert(c.format,c.colorSpace),g=l.convert(c.type),y=getInternalFormat(c.internalFormat,m,g,c.colorSpace),v=a.get(o),x=a.get(c);if(x.__renderTarget=o,!v.__hasExternalTextures){const i=Math.max(1,o.width>>p),a=Math.max(1,o.height>>p);u===t.TEXTURE_3D||u===t.TEXTURE_2D_ARRAY?r.texImage3D(u,p,y,i,a,o.depth,0,m,g,null):r.texImage2D(u,p,y,i,a,0,m,g,null)}r.bindFramebuffer(t.FRAMEBUFFER,i),useMultisampledRTT(o)?h.framebufferTexture2DMultisampleEXT(t.FRAMEBUFFER,d,u,x.__webglTexture,0,getRenderTargetSamples(o)):(u===t.TEXTURE_2D||u>=t.TEXTURE_CUBE_MAP_POSITIVE_X&&u<=t.TEXTURE_CUBE_MAP_NEGATIVE_Z)&&t.framebufferTexture2D(t.FRAMEBUFFER,d,u,x.__webglTexture,p),r.bindFramebuffer(t.FRAMEBUFFER,null)}function setupRenderBufferStorage(i,r,a){if(t.bindRenderbuffer(t.RENDERBUFFER,i),r.depthBuffer){const o=r.depthTexture,l=o&&o.isDepthTexture?o.type:null,c=getInternalDepthFormat(r.stencilBuffer,l),d=r.stencilBuffer?t.DEPTH_STENCIL_ATTACHMENT:t.DEPTH_ATTACHMENT,u=getRenderTargetSamples(r);useMultisampledRTT(r)?h.renderbufferStorageMultisampleEXT(t.RENDERBUFFER,u,c,r.width,r.height):a?t.renderbufferStorageMultisample(t.RENDERBUFFER,u,c,r.width,r.height):t.renderbufferStorage(t.RENDERBUFFER,c,r.width,r.height),t.framebufferRenderbuffer(t.FRAMEBUFFER,d,t.RENDERBUFFER,i)}else{const i=r.textures;for(let o=0;o<i.length;o++){const c=i[o],d=l.convert(c.format,c.colorSpace),u=l.convert(c.type),p=getInternalFormat(c.internalFormat,d,u,c.colorSpace),m=getRenderTargetSamples(r);a&&!1===useMultisampledRTT(r)?t.renderbufferStorageMultisample(t.RENDERBUFFER,m,p,r.width,r.height):useMultisampledRTT(r)?h.renderbufferStorageMultisampleEXT(t.RENDERBUFFER,m,p,r.width,r.height):t.renderbufferStorage(t.RENDERBUFFER,p,r.width,r.height)}}t.bindRenderbuffer(t.RENDERBUFFER,null)}function setupDepthRenderbuffer(i){const o=a.get(i),l=!0===i.isWebGLCubeRenderTarget;if(o.__boundDepthTexture!==i.depthTexture){const t=i.depthTexture;if(o.__depthDisposeCallback&&o.__depthDisposeCallback(),t){const disposeEvent=()=>{delete o.__boundDepthTexture,delete o.__depthDisposeCallback,t.removeEventListener("dispose",disposeEvent)};t.addEventListener("dispose",disposeEvent),o.__depthDisposeCallback=disposeEvent}o.__boundDepthTexture=t}if(i.depthTexture&&!o.__autoAllocateDepthBuffer){if(l)throw new Error("target.depthTexture not supported in Cube render targets");!function setupDepthTexture(i,o){if(o&&o.isWebGLCubeRenderTarget)throw new Error("Depth Texture with cube render targets is not supported");if(r.bindFramebuffer(t.FRAMEBUFFER,i),!o.depthTexture||!o.depthTexture.isDepthTexture)throw new Error("renderTarget.depthTexture must be an instance of THREE.DepthTexture");const l=a.get(o.depthTexture);l.__renderTarget=o,l.__webglTexture&&o.depthTexture.image.width===o.width&&o.depthTexture.image.height===o.height||(o.depthTexture.image.width=o.width,o.depthTexture.image.height=o.height,o.depthTexture.needsUpdate=!0),setTexture2D(o.depthTexture,0);const c=l.__webglTexture,d=getRenderTargetSamples(o);if(o.depthTexture.format===ye)useMultisampledRTT(o)?h.framebufferTexture2DMultisampleEXT(t.FRAMEBUFFER,t.DEPTH_ATTACHMENT,t.TEXTURE_2D,c,0,d):t.framebufferTexture2D(t.FRAMEBUFFER,t.DEPTH_ATTACHMENT,t.TEXTURE_2D,c,0);else{if(o.depthTexture.format!==ve)throw new Error("Unknown depthTexture format");useMultisampledRTT(o)?h.framebufferTexture2DMultisampleEXT(t.FRAMEBUFFER,t.DEPTH_STENCIL_ATTACHMENT,t.TEXTURE_2D,c,0,d):t.framebufferTexture2D(t.FRAMEBUFFER,t.DEPTH_STENCIL_ATTACHMENT,t.TEXTURE_2D,c,0)}}(o.__webglFramebuffer,i)}else if(l){o.__webglDepthbuffer=[];for(let a=0;a<6;a++)if(r.bindFramebuffer(t.FRAMEBUFFER,o.__webglFramebuffer[a]),void 0===o.__webglDepthbuffer[a])o.__webglDepthbuffer[a]=t.createRenderbuffer(),setupRenderBufferStorage(o.__webglDepthbuffer[a],i,!1);else{const r=i.stencilBuffer?t.DEPTH_STENCIL_ATTACHMENT:t.DEPTH_ATTACHMENT,l=o.__webglDepthbuffer[a];t.bindRenderbuffer(t.RENDERBUFFER,l),t.framebufferRenderbuffer(t.FRAMEBUFFER,r,t.RENDERBUFFER,l)}}else if(r.bindFramebuffer(t.FRAMEBUFFER,o.__webglFramebuffer),void 0===o.__webglDepthbuffer)o.__webglDepthbuffer=t.createRenderbuffer(),setupRenderBufferStorage(o.__webglDepthbuffer,i,!1);else{const r=i.stencilBuffer?t.DEPTH_STENCIL_ATTACHMENT:t.DEPTH_ATTACHMENT,a=o.__webglDepthbuffer;t.bindRenderbuffer(t.RENDERBUFFER,a),t.framebufferRenderbuffer(t.FRAMEBUFFER,r,t.RENDERBUFFER,a)}r.bindFramebuffer(t.FRAMEBUFFER,null)}const S=[],M=[];function getRenderTargetSamples(t){return Math.min(o.maxSamples,t.samples)}function useMultisampledRTT(t){const r=a.get(t);return t.samples>0&&!0===i.has("WEBGL_multisampled_render_to_texture")&&!1!==r.__useRenderToTexture}function verifyColorSpace(t,i){const r=t.colorSpace;t.format,t.type;return!0===t.isCompressedTexture||!0===t.isVideoTexture||r!==ct&&r!==ot&&Ot.getTransfer(r),i}function getDimensions(t){return"undefined"!=typeof HTMLImageElement&&t instanceof HTMLImageElement?(u.width=t.naturalWidth||t.width,u.height=t.naturalHeight||t.height):"undefined"!=typeof VideoFrame&&t instanceof VideoFrame?(u.width=t.displayWidth,u.height=t.displayHeight):(u.width=t.width,u.height=t.height),u}this.allocateTextureUnit=function allocateTextureUnit(){const t=v;return o.maxTextures,v+=1,t},this.resetTextureUnits=function resetTextureUnits(){v=0},this.setTexture2D=setTexture2D,this.setTexture2DArray=function setTexture2DArray(i,o){const l=a.get(i);i.version>0&&l.__version!==i.version?uploadTexture(l,i,o):r.bindTexture(t.TEXTURE_2D_ARRAY,l.__webglTexture,t.TEXTURE0+o)},this.setTexture3D=function setTexture3D(i,o){const l=a.get(i);i.version>0&&l.__version!==i.version?uploadTexture(l,i,o):r.bindTexture(t.TEXTURE_3D,l.__webglTexture,t.TEXTURE0+o)},this.setTextureCube=function setTextureCube(i,c){const h=a.get(i);i.version>0&&h.__version!==i.version?function uploadCubeTexture(i,c,h){if(6!==c.image.length)return;const d=initTexture(i,c),u=c.source;r.bindTexture(t.TEXTURE_CUBE_MAP,i.__webglTexture,t.TEXTURE0+h);const p=a.get(u);if(u.version!==p.__version||!0===d){r.activeTexture(t.TEXTURE0+h);const i=Ot.getPrimaries(Ot.workingColorSpace),a=c.colorSpace===ot?null:Ot.getPrimaries(c.colorSpace),m=c.colorSpace===ot||i===a?t.NONE:t.BROWSER_DEFAULT_WEBGL;t.pixelStorei(t.UNPACK_FLIP_Y_WEBGL,c.flipY),t.pixelStorei(t.UNPACK_PREMULTIPLY_ALPHA_WEBGL,c.premultiplyAlpha),t.pixelStorei(t.UNPACK_ALIGNMENT,c.unpackAlignment),t.pixelStorei(t.UNPACK_COLORSPACE_CONVERSION_WEBGL,m);const g=c.isCompressedTexture||c.image[0].isCompressedTexture,y=c.image[0]&&c.image[0].isDataTexture,v=[];for(let t=0;t<6;t++)v[t]=g||y?y?c.image[t].image:c.image[t]:resizeImage(c.image[t],!0,o.maxCubemapSize),v[t]=verifyColorSpace(c,v[t]);const x=v[0],b=l.convert(c.format,c.colorSpace),_=l.convert(c.type),S=getInternalFormat(c.internalFormat,b,_,c.colorSpace),M=!0!==c.isVideoTexture,w=void 0===p.__version||!0===d,T=u.dataReady;let E,A=getMipLevels(c,x);if(setTextureParameters(t.TEXTURE_CUBE_MAP,c),g){M&&w&&r.texStorage2D(t.TEXTURE_CUBE_MAP,A,S,x.width,x.height);for(let i=0;i<6;i++){E=v[i].mipmaps;for(let a=0;a<E.length;a++){const o=E[a];c.format!==ge?null!==b&&(M?T&&r.compressedTexSubImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+i,a,0,0,o.width,o.height,b,o.data):r.compressedTexImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+i,a,S,o.width,o.height,0,o.data)):M?T&&r.texSubImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+i,a,0,0,o.width,o.height,b,_,o.data):r.texImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+i,a,S,o.width,o.height,0,b,_,o.data)}}}else{if(E=c.mipmaps,M&&w){E.length>0&&A++;const i=getDimensions(v[0]);r.texStorage2D(t.TEXTURE_CUBE_MAP,A,S,i.width,i.height)}for(let i=0;i<6;i++)if(y){M?T&&r.texSubImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+i,0,0,0,v[i].width,v[i].height,b,_,v[i].data):r.texImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+i,0,S,v[i].width,v[i].height,0,b,_,v[i].data);for(let a=0;a<E.length;a++){const o=E[a].image[i].image;M?T&&r.texSubImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+i,a+1,0,0,o.width,o.height,b,_,o.data):r.texImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+i,a+1,S,o.width,o.height,0,b,_,o.data)}}else{M?T&&r.texSubImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+i,0,0,0,b,_,v[i]):r.texImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+i,0,S,b,_,v[i]);for(let a=0;a<E.length;a++){const o=E[a];M?T&&r.texSubImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+i,a+1,0,0,b,_,o.image[i]):r.texImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+i,a+1,S,b,_,o.image[i])}}}textureNeedsGenerateMipmaps(c)&&generateMipmap(t.TEXTURE_CUBE_MAP),p.__version=u.version,c.onUpdate&&c.onUpdate(c)}i.__version=c.version}(h,i,c):r.bindTexture(t.TEXTURE_CUBE_MAP,h.__webglTexture,t.TEXTURE0+c)},this.rebindTextures=function rebindTextures(i,r,o){const l=a.get(i);void 0!==r&&setupFrameBufferTexture(l.__webglFramebuffer,i,i.texture,t.COLOR_ATTACHMENT0,t.TEXTURE_2D,0),void 0!==o&&setupDepthRenderbuffer(i)},this.setupRenderTarget=function setupRenderTarget(i){const o=i.texture,h=a.get(i),d=a.get(o);i.addEventListener("dispose",onRenderTargetDispose);const u=i.textures,p=!0===i.isWebGLCubeRenderTarget,m=u.length>1;if(m||(void 0===d.__webglTexture&&(d.__webglTexture=t.createTexture()),d.__version=o.version,c.memory.textures++),p){h.__webglFramebuffer=[];for(let i=0;i<6;i++)if(o.mipmaps&&o.mipmaps.length>0){h.__webglFramebuffer[i]=[];for(let r=0;r<o.mipmaps.length;r++)h.__webglFramebuffer[i][r]=t.createFramebuffer()}else h.__webglFramebuffer[i]=t.createFramebuffer()}else{if(o.mipmaps&&o.mipmaps.length>0){h.__webglFramebuffer=[];for(let i=0;i<o.mipmaps.length;i++)h.__webglFramebuffer[i]=t.createFramebuffer()}else h.__webglFramebuffer=t.createFramebuffer();if(m)for(let i=0,r=u.length;i<r;i++){const r=a.get(u[i]);void 0===r.__webglTexture&&(r.__webglTexture=t.createTexture(),c.memory.textures++)}if(i.samples>0&&!1===useMultisampledRTT(i)){h.__webglMultisampledFramebuffer=t.createFramebuffer(),h.__webglColorRenderbuffer=[],r.bindFramebuffer(t.FRAMEBUFFER,h.__webglMultisampledFramebuffer);for(let r=0;r<u.length;r++){const a=u[r];h.__webglColorRenderbuffer[r]=t.createRenderbuffer(),t.bindRenderbuffer(t.RENDERBUFFER,h.__webglColorRenderbuffer[r]);const o=l.convert(a.format,a.colorSpace),c=l.convert(a.type),d=getInternalFormat(a.internalFormat,o,c,a.colorSpace,!0===i.isXRRenderTarget),p=getRenderTargetSamples(i);t.renderbufferStorageMultisample(t.RENDERBUFFER,p,d,i.width,i.height),t.framebufferRenderbuffer(t.FRAMEBUFFER,t.COLOR_ATTACHMENT0+r,t.RENDERBUFFER,h.__webglColorRenderbuffer[r])}t.bindRenderbuffer(t.RENDERBUFFER,null),i.depthBuffer&&(h.__webglDepthRenderbuffer=t.createRenderbuffer(),setupRenderBufferStorage(h.__webglDepthRenderbuffer,i,!0)),r.bindFramebuffer(t.FRAMEBUFFER,null)}}if(p){r.bindTexture(t.TEXTURE_CUBE_MAP,d.__webglTexture),setTextureParameters(t.TEXTURE_CUBE_MAP,o);for(let r=0;r<6;r++)if(o.mipmaps&&o.mipmaps.length>0)for(let a=0;a<o.mipmaps.length;a++)setupFrameBufferTexture(h.__webglFramebuffer[r][a],i,o,t.COLOR_ATTACHMENT0,t.TEXTURE_CUBE_MAP_POSITIVE_X+r,a);else setupFrameBufferTexture(h.__webglFramebuffer[r],i,o,t.COLOR_ATTACHMENT0,t.TEXTURE_CUBE_MAP_POSITIVE_X+r,0);textureNeedsGenerateMipmaps(o)&&generateMipmap(t.TEXTURE_CUBE_MAP),r.unbindTexture()}else if(m){for(let o=0,l=u.length;o<l;o++){const l=u[o],c=a.get(l);r.bindTexture(t.TEXTURE_2D,c.__webglTexture),setTextureParameters(t.TEXTURE_2D,l),setupFrameBufferTexture(h.__webglFramebuffer,i,l,t.COLOR_ATTACHMENT0+o,t.TEXTURE_2D,0),textureNeedsGenerateMipmaps(l)&&generateMipmap(t.TEXTURE_2D)}r.unbindTexture()}else{let a=t.TEXTURE_2D;if((i.isWebGL3DRenderTarget||i.isWebGLArrayRenderTarget)&&(a=i.isWebGL3DRenderTarget?t.TEXTURE_3D:t.TEXTURE_2D_ARRAY),r.bindTexture(a,d.__webglTexture),setTextureParameters(a,o),o.mipmaps&&o.mipmaps.length>0)for(let r=0;r<o.mipmaps.length;r++)setupFrameBufferTexture(h.__webglFramebuffer[r],i,o,t.COLOR_ATTACHMENT0,a,r);else setupFrameBufferTexture(h.__webglFramebuffer,i,o,t.COLOR_ATTACHMENT0,a,0);textureNeedsGenerateMipmaps(o)&&generateMipmap(a),r.unbindTexture()}i.depthBuffer&&setupDepthRenderbuffer(i)},this.updateRenderTargetMipmap=function updateRenderTargetMipmap(t){const i=t.textures;for(let o=0,l=i.length;o<l;o++){const l=i[o];if(textureNeedsGenerateMipmaps(l)){const i=getTargetType(t),o=a.get(l).__webglTexture;r.bindTexture(i,o),generateMipmap(i),r.unbindTexture()}}},this.updateMultisampleRenderTarget=function updateMultisampleRenderTarget(i){if(i.samples>0)if(!1===useMultisampledRTT(i)){const o=i.textures,l=i.width,c=i.height;let h=t.COLOR_BUFFER_BIT;const u=i.stencilBuffer?t.DEPTH_STENCIL_ATTACHMENT:t.DEPTH_ATTACHMENT,p=a.get(i),m=o.length>1;if(m)for(let i=0;i<o.length;i++)r.bindFramebuffer(t.FRAMEBUFFER,p.__webglMultisampledFramebuffer),t.framebufferRenderbuffer(t.FRAMEBUFFER,t.COLOR_ATTACHMENT0+i,t.RENDERBUFFER,null),r.bindFramebuffer(t.FRAMEBUFFER,p.__webglFramebuffer),t.framebufferTexture2D(t.DRAW_FRAMEBUFFER,t.COLOR_ATTACHMENT0+i,t.TEXTURE_2D,null,0);r.bindFramebuffer(t.READ_FRAMEBUFFER,p.__webglMultisampledFramebuffer),r.bindFramebuffer(t.DRAW_FRAMEBUFFER,p.__webglFramebuffer);for(let r=0;r<o.length;r++){if(i.resolveDepthBuffer&&(i.depthBuffer&&(h|=t.DEPTH_BUFFER_BIT),i.stencilBuffer&&i.resolveStencilBuffer&&(h|=t.STENCIL_BUFFER_BIT)),m){t.framebufferRenderbuffer(t.READ_FRAMEBUFFER,t.COLOR_ATTACHMENT0,t.RENDERBUFFER,p.__webglColorRenderbuffer[r]);const i=a.get(o[r]).__webglTexture;t.framebufferTexture2D(t.DRAW_FRAMEBUFFER,t.COLOR_ATTACHMENT0,t.TEXTURE_2D,i,0)}t.blitFramebuffer(0,0,l,c,0,0,l,c,h,t.NEAREST),!0===d&&(S.length=0,M.length=0,S.push(t.COLOR_ATTACHMENT0+r),i.depthBuffer&&!1===i.resolveDepthBuffer&&(S.push(u),M.push(u),t.invalidateFramebuffer(t.DRAW_FRAMEBUFFER,M)),t.invalidateFramebuffer(t.READ_FRAMEBUFFER,S))}if(r.bindFramebuffer(t.READ_FRAMEBUFFER,null),r.bindFramebuffer(t.DRAW_FRAMEBUFFER,null),m)for(let i=0;i<o.length;i++){r.bindFramebuffer(t.FRAMEBUFFER,p.__webglMultisampledFramebuffer),t.framebufferRenderbuffer(t.FRAMEBUFFER,t.COLOR_ATTACHMENT0+i,t.RENDERBUFFER,p.__webglColorRenderbuffer[i]);const l=a.get(o[i]).__webglTexture;r.bindFramebuffer(t.FRAMEBUFFER,p.__webglFramebuffer),t.framebufferTexture2D(t.DRAW_FRAMEBUFFER,t.COLOR_ATTACHMENT0+i,t.TEXTURE_2D,l,0)}r.bindFramebuffer(t.DRAW_FRAMEBUFFER,p.__webglMultisampledFramebuffer)}else if(i.depthBuffer&&!1===i.resolveDepthBuffer&&d){const r=i.stencilBuffer?t.DEPTH_STENCIL_ATTACHMENT:t.DEPTH_ATTACHMENT;t.invalidateFramebuffer(t.DRAW_FRAMEBUFFER,[r])}},this.setupDepthRenderbuffer=setupDepthRenderbuffer,this.setupFrameBufferTexture=setupFrameBufferTexture,this.useMultisampledRTT=useMultisampledRTT}function WebGLUtils(t,i){return{convert:function convert(r,a=""){let o;const l=Ot.getTransfer(a);if(r===re)return t.UNSIGNED_BYTE;if(r===ue)return t.UNSIGNED_SHORT_4_4_4_4;if(r===pe)return t.UNSIGNED_SHORT_5_5_5_1;if(r===fe)return t.UNSIGNED_INT_5_9_9_9_REV;if(r===se)return t.BYTE;if(r===ae)return t.SHORT;if(r===oe)return t.UNSIGNED_SHORT;if(r===le)return t.INT;if(r===ce)return t.UNSIGNED_INT;if(r===he)return t.FLOAT;if(r===de)return t.HALF_FLOAT;if(1021===r)return t.ALPHA;if(1022===r)return t.RGB;if(r===ge)return t.RGBA;if(1024===r)return t.LUMINANCE;if(1025===r)return t.LUMINANCE_ALPHA;if(r===ye)return t.DEPTH_COMPONENT;if(r===ve)return t.DEPTH_STENCIL;if(r===xe)return t.RED;if(r===be)return t.RED_INTEGER;if(1030===r)return t.RG;if(r===_e)return t.RG_INTEGER;if(r===Se)return t.RGBA_INTEGER;if(r===Me||r===we||r===Te||r===Ee)if(l===dt){if(o=i.get("WEBGL_compressed_texture_s3tc_srgb"),null===o)return null;if(r===Me)return o.COMPRESSED_SRGB_S3TC_DXT1_EXT;if(r===we)return o.COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT;if(r===Te)return o.COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT;if(r===Ee)return o.COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT}else{if(o=i.get("WEBGL_compressed_texture_s3tc"),null===o)return null;if(r===Me)return o.COMPRESSED_RGB_S3TC_DXT1_EXT;if(r===we)return o.COMPRESSED_RGBA_S3TC_DXT1_EXT;if(r===Te)return o.COMPRESSED_RGBA_S3TC_DXT3_EXT;if(r===Ee)return o.COMPRESSED_RGBA_S3TC_DXT5_EXT}if(r===Ae||r===Ce||r===Pe||r===Re){if(o=i.get("WEBGL_compressed_texture_pvrtc"),null===o)return null;if(r===Ae)return o.COMPRESSED_RGB_PVRTC_4BPPV1_IMG;if(r===Ce)return o.COMPRESSED_RGB_PVRTC_2BPPV1_IMG;if(r===Pe)return o.COMPRESSED_RGBA_PVRTC_4BPPV1_IMG;if(r===Re)return o.COMPRESSED_RGBA_PVRTC_2BPPV1_IMG}if(r===Ie||r===De||r===Le){if(o=i.get("WEBGL_compressed_texture_etc"),null===o)return null;if(r===Ie||r===De)return l===dt?o.COMPRESSED_SRGB8_ETC2:o.COMPRESSED_RGB8_ETC2;if(r===Le)return l===dt?o.COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:o.COMPRESSED_RGBA8_ETC2_EAC}if(r===Fe||r===Ne||r===Oe||r===Ue||r===Be||r===ze||r===Ve||r===ke||r===Ge||r===He||r===We||r===je||r===Xe||r===qe){if(o=i.get("WEBGL_compressed_texture_astc"),null===o)return null;if(r===Fe)return l===dt?o.COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR:o.COMPRESSED_RGBA_ASTC_4x4_KHR;if(r===Ne)return l===dt?o.COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR:o.COMPRESSED_RGBA_ASTC_5x4_KHR;if(r===Oe)return l===dt?o.COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR:o.COMPRESSED_RGBA_ASTC_5x5_KHR;if(r===Ue)return l===dt?o.COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR:o.COMPRESSED_RGBA_ASTC_6x5_KHR;if(r===Be)return l===dt?o.COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR:o.COMPRESSED_RGBA_ASTC_6x6_KHR;if(r===ze)return l===dt?o.COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR:o.COMPRESSED_RGBA_ASTC_8x5_KHR;if(r===Ve)return l===dt?o.COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR:o.COMPRESSED_RGBA_ASTC_8x6_KHR;if(r===ke)return l===dt?o.COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR:o.COMPRESSED_RGBA_ASTC_8x8_KHR;if(r===Ge)return l===dt?o.COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR:o.COMPRESSED_RGBA_ASTC_10x5_KHR;if(r===He)return l===dt?o.COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR:o.COMPRESSED_RGBA_ASTC_10x6_KHR;if(r===We)return l===dt?o.COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR:o.COMPRESSED_RGBA_ASTC_10x8_KHR;if(r===je)return l===dt?o.COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR:o.COMPRESSED_RGBA_ASTC_10x10_KHR;if(r===Xe)return l===dt?o.COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR:o.COMPRESSED_RGBA_ASTC_12x10_KHR;if(r===qe)return l===dt?o.COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR:o.COMPRESSED_RGBA_ASTC_12x12_KHR}if(r===Ye||r===Ze||r===Ke){if(o=i.get("EXT_texture_compression_bptc"),null===o)return null;if(r===Ye)return l===dt?o.COMPRESSED_SRGB_ALPHA_BPTC_UNORM_EXT:o.COMPRESSED_RGBA_BPTC_UNORM_EXT;if(r===Ze)return o.COMPRESSED_RGB_BPTC_SIGNED_FLOAT_EXT;if(r===Ke)return o.COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_EXT}if(36283===r||r===Qe||r===Je||r===$e){if(o=i.get("EXT_texture_compression_rgtc"),null===o)return null;if(r===Ye)return o.COMPRESSED_RED_RGTC1_EXT;if(r===Qe)return o.COMPRESSED_SIGNED_RED_RGTC1_EXT;if(r===Je)return o.COMPRESSED_RED_GREEN_RGTC2_EXT;if(r===$e)return o.COMPRESSED_SIGNED_RED_GREEN_RGTC2_EXT}return r===me?t.UNSIGNED_INT_24_8:void 0!==t[r]?t[r]:null}}}const Is={type:"move"};class WebXRController{constructor(){this._targetRay=null,this._grip=null,this._hand=null}getHandSpace(){return null===this._hand&&(this._hand=new Group,this._hand.matrixAutoUpdate=!1,this._hand.visible=!1,this._hand.joints={},this._hand.inputState={pinching:!1}),this._hand}getTargetRaySpace(){return null===this._targetRay&&(this._targetRay=new Group,this._targetRay.matrixAutoUpdate=!1,this._targetRay.visible=!1,this._targetRay.hasLinearVelocity=!1,this._targetRay.linearVelocity=new Vector3,this._targetRay.hasAngularVelocity=!1,this._targetRay.angularVelocity=new Vector3),this._targetRay}getGripSpace(){return null===this._grip&&(this._grip=new Group,this._grip.matrixAutoUpdate=!1,this._grip.visible=!1,this._grip.hasLinearVelocity=!1,this._grip.linearVelocity=new Vector3,this._grip.hasAngularVelocity=!1,this._grip.angularVelocity=new Vector3),this._grip}dispatchEvent(t){return null!==this._targetRay&&this._targetRay.dispatchEvent(t),null!==this._grip&&this._grip.dispatchEvent(t),null!==this._hand&&this._hand.dispatchEvent(t),this}connect(t){if(t&&t.hand){const i=this._hand;if(i)for(const r of t.hand.values())this._getHandJoint(i,r)}return this.dispatchEvent({type:"connected",data:t}),this}disconnect(t){return this.dispatchEvent({type:"disconnected",data:t}),null!==this._targetRay&&(this._targetRay.visible=!1),null!==this._grip&&(this._grip.visible=!1),null!==this._hand&&(this._hand.visible=!1),this}update(t,i,r){let a=null,o=null,l=null;const c=this._targetRay,h=this._grip,d=this._hand;if(t&&"visible-blurred"!==i.session.visibilityState){if(d&&t.hand){l=!0;for(const a of t.hand.values()){const t=i.getJointPose(a,r),o=this._getHandJoint(d,a);null!==t&&(o.matrix.fromArray(t.transform.matrix),o.matrix.decompose(o.position,o.rotation,o.scale),o.matrixWorldNeedsUpdate=!0,o.jointRadius=t.radius),o.visible=null!==t}const a=d.joints["index-finger-tip"],o=d.joints["thumb-tip"],c=a.position.distanceTo(o.position),h=.02,u=.005;d.inputState.pinching&&c>h+u?(d.inputState.pinching=!1,this.dispatchEvent({type:"pinchend",handedness:t.handedness,target:this})):!d.inputState.pinching&&c<=h-u&&(d.inputState.pinching=!0,this.dispatchEvent({type:"pinchstart",handedness:t.handedness,target:this}))}else null!==h&&t.gripSpace&&(o=i.getPose(t.gripSpace,r),null!==o&&(h.matrix.fromArray(o.transform.matrix),h.matrix.decompose(h.position,h.rotation,h.scale),h.matrixWorldNeedsUpdate=!0,o.linea