import { debugEnabled, warn } from "../../midi-qol.js";
import { ReplaceDefaultActivities, configSettings } from "../settings.js";
import { MidiActivityMixin, MidiActivityMixinSheet } from "./MidiActivityMixin.js";
export var MidiCastActivity;
export var MidiCastSheet;
export function setupCastActivity() {
	if (debugEnabled > 0)
		warn("MidiQOL | CastActivity | setupCastActivity | Called");
	//@ts-expect-error
	const GameSystemConfig = game.system.config;
	//@ts-expect-error
	MidiCastSheet = defineMidiCastSheetClass(game.system.applications.activity.CastSheet);
	MidiCastActivity = defineMidiCastActivityClass(GameSystemConfig.activityTypes.cast.documentClass);
	if (ReplaceDefaultActivities) {
		// GameSystemConfig.activityTypes["dnd5eCast"] = GameSystemConfig.activityTypes.cast;
		GameSystemConfig.activityTypes.cast = { documentClass: MidiCastActivity };
	}
	else {
		GameSystemConfig.activityTypes["midiCast"] = { documentClass: MidiCastActivity };
	}
}
let defineMidiCastSheetClass = (baseClass) => {
	return class MidiCastSheet extends MidiActivityMixinSheet(baseClass) {
	};
};
let defineMidiCastActivityClass = (ActivityClass) => {
	return class MidiCastActivity extends MidiActivityMixin(ActivityClass) {
		static LOCALIZATION_PREFIXES = ["midi-qol.CAST", ...super.LOCALIZATION_PREFIXES];
		static metadata = foundry.utils.mergeObject(super.metadata, {
			title: configSettings.activityNamePrefix ? "midi-qol.CAST.Title.one" : ActivityClass.metadata.title,
			dnd5eTitle: ActivityClass.metadata.title,
			sheetClass: MidiCastSheet,
			usage: {
				chatCard: "modules/midi-qol/templates/activity-card.hbs",
				dialog: ActivityClass.metadata.usage.dialog,
			},
		}, { inplace: false, insertKeys: true, insertValues: true });
		async use(usage, dialog, message) {
			return ActivityClass.prototype.use.bind(this)(usage, dialog, message);
		}
		get possibleOtherActivity() {
			return false;
		}
		get isSelfTriggerableOnly() {
			return false;
		}
		get isTriggerableActivity() {
			return true;
		}
		get forcedTargetConfirmation() {
			return "never";
		}
	};
};
