const foundryContextId = "foundryContextId", settings = { users: "users", usersMenu: "usersMenu", lastActorId: "lastActorId" };
var FoundryUserRoles = ((t4) => (t4[t4.NONE = 0] = "NONE", t4[t4.PLAYER = 1] = "PLAYER", t4[t4.TRUSTED_PLAYER = 2] = "TRUSTED_PLAYER", t4[t4.ASSISTANT_GM = 3] = "ASSISTANT_GM", t4[t4.GAMEMASTER = 4] = "GAMEMASTER", t4))(FoundryUserRoles || {});
let subModuleId = "", currentSheet, factory;
function setSubModuleId(t4) {
  subModuleId = t4;
}
function getFullModuleId() {
  return "mobile-companion-" + subModuleId;
}
function getBaseModuleId() {
  return "mobile-companion";
}
function saveLastActorId(t4) {
  game.settings.set(getFullModuleId(), settings.lastActorId, t4);
}
function getLastActorId() {
  return game.settings.get(getFullModuleId(), settings.lastActorId);
}
function isMobileCompanion() {
  const t4 = game.settings.get(getFullModuleId(), settings.users)[game.user.id];
  if (t4) {
    if (t4.enabled) {
      const e = t4.screenWidth;
      if (e <= 0) return true;
      if (screen.width < e) return true;
    }
  }
  return false;
}
function activateSheet(t4) {
  factory = t4, checkCanvas(), popupSheet(), addEventListener("resize", onResize);
}
function onResize() {
  currentSheet?.element.css({ width: window.innerWidth, height: window.innerHeight });
}
function checkCanvas() {
  game.settings.get("core", "noCanvas") || game.settings.set("core", "noCanvas", true);
}
function popupSheet() {
  const t4 = getOwnedActors(), e = getLastActorId();
  if (e) {
    const n = game.actors.get(e), o2 = t4.some((t5) => t5.id === e);
    if (n && (o2 || game.user.isGM)) return void switchToActor(n);
  }
  if (!(t4?.length > 0)) throw console.error("No actor for user found."), new NoActorFoundError("No actor found!. You are not the owner of any actor. Please ask your GM to get access to the actor.");
  switchToActor(t4[0]);
}
class NoActorFoundError extends Error {
  constructor(t4 = "No actor found") {
    super(t4), this.name = "NoActorFoundError";
  }
}
function getOwnedActors() {
  return game.user.isGM ? game.actors.contents : game.actors.filter((t4) => isActorOwnedByUser(t4));
}
function isActorOwnedByUser(t4) {
  return 3 === t4.ownership[game.user.id];
}
function switchToActor(t4) {
  currentSheet && currentSheet.close(), openMobileCompanion(t4), saveLastActorId(t4.id);
}
function openMobileCompanion(t4) {
  currentSheet = factory(t4), currentSheet ? currentSheet.render(true, { focus: true }) : console.error("Mobile-Companion does not support this system. Please disable Mobile-Companion.");
}
const DOM_REMOVE = "dom-remove-or-hide", MAIN_WIDTH = "main-width", BACKGROUND_IMG = "background-img";
function getCommonSettings(t4, e) {
  const n = [];
  return n.push({ namespace: t4, key: DOM_REMOVE, options: { name: "Debug: Hide instead of remove DOM elements", hint: "Hides instead of removes non-mobile-companion DOM elements.", scope: "world", config: true, type: Boolean, default: false } }), n.push({ namespace: t4, key: "main-width", options: { name: "App Width", hint: "Determines the width in percent of the app. If you are using quite a large device you might prefer the app not stretching the full display width.", scope: "client", range: { min: 0, max: 100, step: 1 }, config: true, type: Number, default: 100, onChange: (t5) => {
    e.getWritableStore(MAIN_WIDTH)?.set(t5);
  } } }), n.push({ namespace: t4, key: "background-img", options: { name: "Background Image", hint: "(Pro Feature) Set an URL to an image (animated gifs work, too) which will be displayed behind the app. Only use this if you set the app width smaller than 100.", scope: "client", config: true, type: String, onChange: (t5) => {
    e.getWritableStore(BACKGROUND_IMG)?.set(t5);
  } } }), n;
}
let hideInsteadOfRemove = false;
function hideAllElements() {
  hideInsteadOfRemove = game.settings.get(getFullModuleId(), DOM_REMOVE);
  [50, 500, 1e3].forEach((t4) => {
    setTimeout(hideOtherElements, t4);
  }), startObserver();
}
function startObserver() {
  setTimeout(() => {
    const t4 = new MutationObserver((t5) => {
      for (const e of t5) "childList" === e.type && e.addedNodes.forEach((t6) => {
        if (t6.nodeType === Node.ELEMENT_NODE) {
          const e2 = t6;
          let n = e2.classList.contains("window-app"), o2 = "mobile-companion" === e2.id, i = "client-settings" === e2.id, a = e2.classList.contains("mobile-companion");
          !n || o2 || i || a || hideOrRemoveElement(e2);
        }
      });
    });
    t4.observe(document.body, { childList: true, subtree: false });
  }, 1e3);
}
function disableSounds() {
  game.settings.set("core", "globalPlaylistVolume", 0), game.settings.set("core", "globalAmbientVolume", 0), game.settings.set("core", "globalInterfaceVolume", 0);
}
function hideOtherElements() {
  Array.from(document.body.children).forEach((t4) => {
    if (t4.id !== getBaseModuleId()) {
      hideOrRemoveElement(t4);
    }
  });
}
function hideOrRemoveElement(t4) {
  hideInsteadOfRemove ? t4.style.display = "none" : (t4.remove(), reapplyDummyElements());
}
function reapplyDummyElements() {
  if (!document.getElementById("navigation")) {
    const t4 = document.createElement("nav");
    t4.id = "navigation", t4.textContent = "This is an empty dummy navigation bar to prevent Foundry error", t4.style.display = "none", document.body.appendChild(t4);
  }
  if (!document.getElementById("loading")) {
    const t4 = document.createElement("div");
    t4.id = "loading", t4.textContent = "This is an empty dummy loading bar bar to prevent Foundry error", t4.style.display = "none", document.body.appendChild(t4);
  }
}
function noop$3() {
}
const identity = (t4) => t4;
function assign(t4, e) {
  for (const n in e) t4[n] = e[n];
  return t4;
}
function is_promise(t4) {
  return !!t4 && ("object" == typeof t4 || "function" == typeof t4) && "function" == typeof t4.then;
}
function run(t4) {
  return t4();
}
function blank_object() {
  return /* @__PURE__ */ Object.create(null);
}
function run_all(t4) {
  t4.forEach(run);
}
function is_function(t4) {
  return "function" == typeof t4;
}
function safe_not_equal(t4, e) {
  return t4 != t4 ? e == e : t4 !== e || t4 && "object" == typeof t4 || "function" == typeof t4;
}
let src_url_equal_anchor;
function src_url_equal(t4, e) {
  return t4 === e || (src_url_equal_anchor || (src_url_equal_anchor = document.createElement("a")), src_url_equal_anchor.href = e, t4 === src_url_equal_anchor.href);
}
function is_empty(t4) {
  return 0 === Object.keys(t4).length;
}
function subscribe(t4, ...e) {
  if (null == t4) {
    for (const t5 of e) t5(void 0);
    return noop$3;
  }
  const n = t4.subscribe(...e);
  return n.unsubscribe ? () => n.unsubscribe() : n;
}
function get_store_value(t4) {
  let e;
  return subscribe(t4, (t5) => e = t5)(), e;
}
function component_subscribe(t4, e, n) {
  t4.$$.on_destroy.push(subscribe(e, n));
}
function create_slot(t4, e, n, o2) {
  if (t4) {
    const i = get_slot_context(t4, e, n, o2);
    return t4[0](i);
  }
}
function get_slot_context(t4, e, n, o2) {
  return t4[1] && o2 ? assign(n.ctx.slice(), t4[1](o2(e))) : n.ctx;
}
function get_slot_changes(t4, e, n, o2) {
  if (t4[2] && o2) {
    const i = t4[2](o2(n));
    if (void 0 === e.dirty) return i;
    if ("object" == typeof i) {
      const t5 = [], n2 = Math.max(e.dirty.length, i.length);
      for (let o3 = 0; o3 < n2; o3 += 1) t5[o3] = e.dirty[o3] | i[o3];
      return t5;
    }
    return e.dirty | i;
  }
  return e.dirty;
}
function update_slot_base(t4, e, n, o2, i, a) {
  if (i) {
    const r2 = get_slot_context(e, n, o2, a);
    t4.p(r2, i);
  }
}
function get_all_dirty_from_scope(t4) {
  if (t4.ctx.length > 32) {
    const e = [], n = t4.ctx.length / 32;
    for (let t5 = 0; t5 < n; t5++) e[t5] = -1;
    return e;
  }
  return -1;
}
function exclude_internal_props(t4) {
  const e = {};
  for (const n in t4) "$" !== n[0] && (e[n] = t4[n]);
  return e;
}
function compute_rest_props(t4, e) {
  const n = {};
  e = new Set(e);
  for (const o2 in t4) e.has(o2) || "$" === o2[0] || (n[o2] = t4[o2]);
  return n;
}
function null_to_empty(t4) {
  return null == t4 ? "" : t4;
}
function action_destroyer(t4) {
  return t4 && is_function(t4.destroy) ? t4.destroy : noop$3;
}
const is_client = "undefined" != typeof window;
let now = is_client ? () => window.performance.now() : () => Date.now(), raf = is_client ? (t4) => requestAnimationFrame(t4) : noop$3;
const tasks = /* @__PURE__ */ new Set();
function run_tasks(t4) {
  tasks.forEach((e) => {
    e.c(t4) || (tasks.delete(e), e.f());
  }), 0 !== tasks.size && raf(run_tasks);
}
function loop(t4) {
  let e;
  return 0 === tasks.size && raf(run_tasks), { promise: new Promise((n) => {
    tasks.add(e = { c: t4, f: n });
  }), abort() {
    tasks.delete(e);
  } };
}
function append(t4, e) {
  t4.appendChild(e);
}
function get_root_for_style(t4) {
  if (!t4) return document;
  const e = t4.getRootNode ? t4.getRootNode() : t4.ownerDocument;
  return e && e.host ? e : t4.ownerDocument;
}
function append_empty_stylesheet(t4) {
  const e = element("style");
  return e.textContent = "/* empty */", append_stylesheet(get_root_for_style(t4), e), e.sheet;
}
function append_stylesheet(t4, e) {
  return append(t4.head || t4, e), e.sheet;
}
function insert(t4, e, n) {
  t4.insertBefore(e, n || null);
}
function detach(t4) {
  t4.parentNode && t4.parentNode.removeChild(t4);
}
function destroy_each(t4, e) {
  for (let n = 0; n < t4.length; n += 1) t4[n] && t4[n].d(e);
}
function element(t4) {
  return document.createElement(t4);
}
function svg_element(t4) {
  return document.createElementNS("http://www.w3.org/2000/svg", t4);
}
function text(t4) {
  return document.createTextNode(t4);
}
function space() {
  return text(" ");
}
function empty() {
  return text("");
}
function listen(t4, e, n, o2) {
  return t4.addEventListener(e, n, o2), () => t4.removeEventListener(e, n, o2);
}
function prevent_default(t4) {
  return function(e) {
    return e.preventDefault(), t4.call(this, e);
  };
}
function stop_propagation(t4) {
  return function(e) {
    return e.stopPropagation(), t4.call(this, e);
  };
}
function attr(t4, e, n) {
  null == n ? t4.removeAttribute(e) : t4.getAttribute(e) !== n && t4.setAttribute(e, n);
}
function set_svg_attributes(t4, e) {
  for (const n in e) attr(t4, n, e[n]);
}
function set_custom_element_data(t4, e, n) {
  const o2 = e.toLowerCase();
  o2 in t4 ? t4[o2] = "boolean" == typeof t4[o2] && "" === n || n : e in t4 ? t4[e] = "boolean" == typeof t4[e] && "" === n || n : attr(t4, e, n);
}
function to_number(t4) {
  return "" === t4 ? null : +t4;
}
function children(t4) {
  return Array.from(t4.childNodes);
}
function set_data(t4, e) {
  e = "" + e, t4.data !== e && (t4.data = e);
}
function set_input_value(t4, e) {
  t4.value = null == e ? "" : e;
}
function set_style(t4, e, n, o2) {
  null == n ? t4.style.removeProperty(e) : t4.style.setProperty(e, n, "");
}
function select_option(t4, e, n) {
  for (let n2 = 0; n2 < t4.options.length; n2 += 1) {
    const o2 = t4.options[n2];
    if (o2.__value === e) return void (o2.selected = true);
  }
  n && void 0 === e || (t4.selectedIndex = -1);
}
function select_value(t4) {
  const e = t4.querySelector(":checked");
  return e && e.__value;
}
function toggle_class(t4, e, n) {
  t4.classList.toggle(e, !!n);
}
function custom_event(t4, e, { bubbles: n = false, cancelable: o2 = false } = {}) {
  return new CustomEvent(t4, { detail: e, bubbles: n, cancelable: o2 });
}
class HtmlTag {
  is_svg = false;
  e = void 0;
  n = void 0;
  t = void 0;
  a = void 0;
  constructor(t4 = false) {
    this.is_svg = t4, this.e = this.n = null;
  }
  c(t4) {
    this.h(t4);
  }
  m(t4, e, n = null) {
    this.e || (this.is_svg ? this.e = svg_element(e.nodeName) : this.e = element(11 === e.nodeType ? "TEMPLATE" : e.nodeName), this.t = "TEMPLATE" !== e.tagName ? e : e.content, this.c(t4)), this.i(n);
  }
  h(t4) {
    this.e.innerHTML = t4, this.n = Array.from("TEMPLATE" === this.e.nodeName ? this.e.content.childNodes : this.e.childNodes);
  }
  i(t4) {
    for (let e = 0; e < this.n.length; e += 1) insert(this.t, this.n[e], t4);
  }
  p(t4) {
    this.d(), this.h(t4), this.i(this.a);
  }
  d() {
    this.n.forEach(detach);
  }
}
function construct_svelte_component(t4, e) {
  return new t4(e);
}
const managed_styles = /* @__PURE__ */ new Map();
let active = 0, current_component;
function hash(t4) {
  let e = 5381, n = t4.length;
  for (; n--; ) e = (e << 5) - e ^ t4.charCodeAt(n);
  return e >>> 0;
}
function create_style_information(t4, e) {
  const n = { stylesheet: append_empty_stylesheet(e), rules: {} };
  return managed_styles.set(t4, n), n;
}
function create_rule(t4, e, n, o2, i, a, r2, s2 = 0) {
  const c = 16.666 / o2;
  let l = "{\n";
  for (let t5 = 0; t5 <= 1; t5 += c) {
    const o3 = e + (n - e) * a(t5);
    l += 100 * t5 + `%{${r2(o3, 1 - o3)}}
`;
  }
  const u = l + `100% {${r2(n, 1 - n)}}
}`, p2 = `__svelte_${hash(u)}_${s2}`, d = get_root_for_style(t4), { stylesheet: m, rules: f } = managed_styles.get(d) || create_style_information(d, t4);
  f[p2] || (f[p2] = true, m.insertRule(`@keyframes ${p2} ${u}`, m.cssRules.length));
  const _ = t4.style.animation || "";
  return t4.style.animation = `${_ ? `${_}, ` : ""}${p2} ${o2}ms linear ${i}ms 1 both`, active += 1, p2;
}
function delete_rule(t4, e) {
  const n = (t4.style.animation || "").split(", "), o2 = n.filter(e ? (t5) => t5.indexOf(e) < 0 : (t5) => -1 === t5.indexOf("__svelte")), i = n.length - o2.length;
  i && (t4.style.animation = o2.join(", "), active -= i, active || clear_rules());
}
function clear_rules() {
  raf(() => {
    active || (managed_styles.forEach((t4) => {
      const { ownerNode: e } = t4.stylesheet;
      e && detach(e);
    }), managed_styles.clear());
  });
}
function set_current_component(t4) {
  current_component = t4;
}
function get_current_component() {
  if (!current_component) throw new Error("Function called outside component initialization");
  return current_component;
}
function onMount(t4) {
  get_current_component().$$.on_mount.push(t4);
}
function onDestroy(t4) {
  get_current_component().$$.on_destroy.push(t4);
}
function createEventDispatcher() {
  const t4 = get_current_component();
  return (e, n, { cancelable: o2 = false } = {}) => {
    const i = t4.$$.callbacks[e];
    if (i) {
      const a = custom_event(e, n, { cancelable: o2 });
      return i.slice().forEach((e2) => {
        e2.call(t4, a);
      }), !a.defaultPrevented;
    }
    return true;
  };
}
function setContext(t4, e) {
  return get_current_component().$$.context.set(t4, e), e;
}
function getContext(t4) {
  return get_current_component().$$.context.get(t4);
}
const dirty_components = [], binding_callbacks = [];
let render_callbacks = [];
const flush_callbacks = [], resolved_promise = Promise.resolve();
let update_scheduled = false;
function schedule_update() {
  update_scheduled || (update_scheduled = true, resolved_promise.then(flush));
}
function tick() {
  return schedule_update(), resolved_promise;
}
function add_render_callback(t4) {
  render_callbacks.push(t4);
}
function add_flush_callback(t4) {
  flush_callbacks.push(t4);
}
const seen_callbacks = /* @__PURE__ */ new Set();
let flushidx = 0, promise;
function flush() {
  if (0 !== flushidx) return;
  const t4 = current_component;
  do {
    try {
      for (; flushidx < dirty_components.length; ) {
        const t5 = dirty_components[flushidx];
        flushidx++, set_current_component(t5), update(t5.$$);
      }
    } catch (t5) {
      throw dirty_components.length = 0, flushidx = 0, t5;
    }
    for (set_current_component(null), dirty_components.length = 0, flushidx = 0; binding_callbacks.length; ) binding_callbacks.pop()();
    for (let t5 = 0; t5 < render_callbacks.length; t5 += 1) {
      const e = render_callbacks[t5];
      seen_callbacks.has(e) || (seen_callbacks.add(e), e());
    }
    render_callbacks.length = 0;
  } while (dirty_components.length);
  for (; flush_callbacks.length; ) flush_callbacks.pop()();
  update_scheduled = false, seen_callbacks.clear(), set_current_component(t4);
}
function update(t4) {
  if (null !== t4.fragment) {
    t4.update(), run_all(t4.before_update);
    const e = t4.dirty;
    t4.dirty = [-1], t4.fragment && t4.fragment.p(t4.ctx, e), t4.after_update.forEach(add_render_callback);
  }
}
function flush_render_callbacks(t4) {
  const e = [], n = [];
  render_callbacks.forEach((o2) => -1 === t4.indexOf(o2) ? e.push(o2) : n.push(o2)), n.forEach((t5) => t5()), render_callbacks = e;
}
function wait() {
  return promise || (promise = Promise.resolve(), promise.then(() => {
    promise = null;
  })), promise;
}
function dispatch(t4, e, n) {
  t4.dispatchEvent(custom_event(`${e ? "intro" : "outro"}${n}`));
}
const outroing = /* @__PURE__ */ new Set();
let outros;
function group_outros() {
  outros = { r: 0, c: [], p: outros };
}
function check_outros() {
  outros.r || run_all(outros.c), outros = outros.p;
}
function transition_in(t4, e) {
  t4 && t4.i && (outroing.delete(t4), t4.i(e));
}
function transition_out(t4, e, n, o2) {
  if (t4 && t4.o) {
    if (outroing.has(t4)) return;
    outroing.add(t4), outros.c.push(() => {
      outroing.delete(t4), o2 && (n && t4.d(1), o2());
    }), t4.o(e);
  } else o2 && o2();
}
const null_transition = { duration: 0 };
function create_in_transition(t4, e, n) {
  const o2 = { direction: "in" };
  let i, a, r2 = e(t4, n, o2), s2 = false, c = 0;
  function l() {
    i && delete_rule(t4, i);
  }
  function u() {
    const { delay: e2 = 0, duration: n2 = 300, easing: o3 = identity, tick: u2 = noop$3, css: p3 } = r2 || null_transition;
    p3 && (i = create_rule(t4, 0, 1, n2, e2, o3, p3, c++)), u2(0, 1);
    const d = now() + e2, m = d + n2;
    a && a.abort(), s2 = true, add_render_callback(() => dispatch(t4, true, "start")), a = loop((e3) => {
      if (s2) {
        if (e3 >= m) return u2(1, 0), dispatch(t4, true, "end"), l(), s2 = false;
        if (e3 >= d) {
          const t5 = o3((e3 - d) / n2);
          u2(t5, 1 - t5);
        }
      }
      return s2;
    });
  }
  let p2 = false;
  return { start() {
    p2 || (p2 = true, delete_rule(t4), is_function(r2) ? (r2 = r2(o2), wait().then(u)) : u());
  }, invalidate() {
    p2 = false;
  }, end() {
    s2 && (l(), s2 = false);
  } };
}
function create_out_transition(t4, e, n) {
  const o2 = { direction: "out" };
  let i, a = e(t4, n, o2), r2 = true;
  const s2 = outros;
  let c;
  function l() {
    const { delay: e2 = 0, duration: n2 = 300, easing: o3 = identity, tick: l2 = noop$3, css: u } = a || null_transition;
    u && (i = create_rule(t4, 1, 0, n2, e2, o3, u));
    const p2 = now() + e2, d = p2 + n2;
    add_render_callback(() => dispatch(t4, false, "start")), "inert" in t4 && (c = t4.inert, t4.inert = true), loop((e3) => {
      if (r2) {
        if (e3 >= d) return l2(0, 1), dispatch(t4, false, "end"), --s2.r || run_all(s2.c), false;
        if (e3 >= p2) {
          const t5 = o3((e3 - p2) / n2);
          l2(1 - t5, t5);
        }
      }
      return r2;
    });
  }
  return s2.r += 1, is_function(a) ? wait().then(() => {
    a = a(o2), l();
  }) : l(), { end(e2) {
    e2 && "inert" in t4 && (t4.inert = c), e2 && a.tick && a.tick(1, 0), r2 && (i && delete_rule(t4, i), r2 = false);
  } };
}
function create_bidirectional_transition(t4, e, n, o2) {
  let i, a = e(t4, n, { direction: "both" }), r2 = o2 ? 0 : 1, s2 = null, c = null, l = null;
  function u() {
    l && delete_rule(t4, l);
  }
  function p2(t5, e2) {
    const n2 = t5.b - r2;
    return e2 *= Math.abs(n2), { a: r2, b: t5.b, d: n2, duration: e2, start: t5.start, end: t5.start + e2, group: t5.group };
  }
  function d(e2) {
    const { delay: n2 = 0, duration: o3 = 300, easing: d2 = identity, tick: m = noop$3, css: f } = a || null_transition, _ = { start: now() + n2, b: e2 };
    e2 || (_.group = outros, outros.r += 1), "inert" in t4 && (e2 ? void 0 !== i && (t4.inert = i) : (i = t4.inert, t4.inert = true)), s2 || c ? c = _ : (f && (u(), l = create_rule(t4, r2, e2, o3, n2, d2, f)), e2 && m(0, 1), s2 = p2(_, o3), add_render_callback(() => dispatch(t4, e2, "start")), loop((e3) => {
      if (c && e3 > c.start && (s2 = p2(c, o3), c = null, dispatch(t4, s2.b, "start"), f && (u(), l = create_rule(t4, r2, s2.b, s2.duration, 0, d2, a.css))), s2) {
        if (e3 >= s2.end) m(r2 = s2.b, 1 - r2), dispatch(t4, s2.b, "end"), c || (s2.b ? u() : --s2.group.r || run_all(s2.group.c)), s2 = null;
        else if (e3 >= s2.start) {
          const t5 = e3 - s2.start;
          r2 = s2.a + s2.d * d2(t5 / s2.duration), m(r2, 1 - r2);
        }
      }
      return !(!s2 && !c);
    }));
  }
  return { run(t5) {
    is_function(a) ? wait().then(() => {
      a = a({ direction: t5 ? "in" : "out" }), d(t5);
    }) : d(t5);
  }, end() {
    u(), s2 = c = null;
  } };
}
function handle_promise(t4, e) {
  const n = e.token = {};
  function o2(t5, o3, i, a) {
    if (e.token !== n) return;
    e.resolved = a;
    let r2 = e.ctx;
    void 0 !== i && (r2 = r2.slice(), r2[i] = a);
    const s2 = t5 && (e.current = t5)(r2);
    let c = false;
    e.block && (e.blocks ? e.blocks.forEach((t6, n2) => {
      n2 !== o3 && t6 && (group_outros(), transition_out(t6, 1, 1, () => {
        e.blocks[n2] === t6 && (e.blocks[n2] = null);
      }), check_outros());
    }) : e.block.d(1), s2.c(), transition_in(s2, 1), s2.m(e.mount(), e.anchor), c = true), e.block = s2, e.blocks && (e.blocks[o3] = s2), c && flush();
  }
  if (is_promise(t4)) {
    const n2 = get_current_component();
    if (t4.then((t5) => {
      set_current_component(n2), o2(e.then, 1, e.value, t5), set_current_component(null);
    }, (t5) => {
      if (set_current_component(n2), o2(e.catch, 2, e.error, t5), set_current_component(null), !e.hasCatch) throw t5;
    }), e.current !== e.pending) return o2(e.pending, 0), true;
  } else {
    if (e.current !== e.then) return o2(e.then, 1, e.value, t4), true;
    e.resolved = t4;
  }
}
function update_await_block_branch(t4, e, n) {
  const o2 = e.slice(), { resolved: i } = t4;
  t4.current === t4.then && (o2[t4.value] = i), t4.current === t4.catch && (o2[t4.error] = i), t4.block.p(o2, n);
}
function ensure_array_like(t4) {
  return void 0 !== t4?.length ? t4 : Array.from(t4);
}
function destroy_block(t4, e) {
  t4.d(1), e.delete(t4.key);
}
function outro_and_destroy_block(t4, e) {
  transition_out(t4, 1, 1, () => {
    e.delete(t4.key);
  });
}
function update_keyed_each(t4, e, n, o2, i, a, r2, s2, c, l, u, p2) {
  let d = t4.length, m = a.length, f = d;
  const _ = {};
  for (; f--; ) _[t4[f].key] = f;
  const h = [], g2 = /* @__PURE__ */ new Map(), $2 = /* @__PURE__ */ new Map(), b = [];
  for (f = m; f--; ) {
    const t5 = p2(i, a, f), o3 = n(t5);
    let s3 = r2.get(o3);
    s3 ? b.push(() => s3.p(t5, e)) : (s3 = l(o3, t5), s3.c()), g2.set(o3, h[f] = s3), o3 in _ && $2.set(o3, Math.abs(f - _[o3]));
  }
  const y = /* @__PURE__ */ new Set(), v = /* @__PURE__ */ new Set();
  function k(t5) {
    transition_in(t5, 1), t5.m(s2, u), r2.set(t5.key, t5), u = t5.first, m--;
  }
  for (; d && m; ) {
    const e2 = h[m - 1], n2 = t4[d - 1], o3 = e2.key, i2 = n2.key;
    e2 === n2 ? (u = e2.first, d--, m--) : g2.has(i2) ? !r2.has(o3) || y.has(o3) ? k(e2) : v.has(i2) ? d-- : $2.get(o3) > $2.get(i2) ? (v.add(o3), k(e2)) : (y.add(i2), d--) : (c(n2, r2), d--);
  }
  for (; d--; ) {
    const e2 = t4[d];
    g2.has(e2.key) || c(e2, r2);
  }
  for (; m; ) k(h[m - 1]);
  return run_all(b), h;
}
function get_spread_update(t4, e) {
  const n = {}, o2 = {}, i = { $$scope: 1 };
  let a = t4.length;
  for (; a--; ) {
    const r2 = t4[a], s2 = e[a];
    if (s2) {
      for (const t5 in r2) t5 in s2 || (o2[t5] = 1);
      for (const t5 in s2) i[t5] || (n[t5] = s2[t5], i[t5] = 1);
      t4[a] = s2;
    } else for (const t5 in r2) i[t5] = 1;
  }
  for (const t5 in o2) t5 in n || (n[t5] = void 0);
  return n;
}
function get_spread_object(t4) {
  return "object" == typeof t4 && null !== t4 ? t4 : {};
}
function bind(t4, e, n) {
  const o2 = t4.$$.props[e];
  void 0 !== o2 && (t4.$$.bound[o2] = n, n(t4.$$.ctx[o2]));
}
function create_component(t4) {
  t4 && t4.c();
}
function mount_component(t4, e, n) {
  const { fragment: o2, after_update: i } = t4.$$;
  o2 && o2.m(e, n), add_render_callback(() => {
    const e2 = t4.$$.on_mount.map(run).filter(is_function);
    t4.$$.on_destroy ? t4.$$.on_destroy.push(...e2) : run_all(e2), t4.$$.on_mount = [];
  }), i.forEach(add_render_callback);
}
function destroy_component(t4, e) {
  const n = t4.$$;
  null !== n.fragment && (flush_render_callbacks(n.after_update), run_all(n.on_destroy), n.fragment && n.fragment.d(e), n.on_destroy = n.fragment = null, n.ctx = []);
}
function make_dirty(t4, e) {
  -1 === t4.$$.dirty[0] && (dirty_components.push(t4), schedule_update(), t4.$$.dirty.fill(0)), t4.$$.dirty[e / 31 | 0] |= 1 << e % 31;
}
function init(t4, e, n, o2, i, a, r2 = null, s2 = [-1]) {
  const c = current_component;
  set_current_component(t4);
  const l = t4.$$ = { fragment: null, ctx: [], props: a, update: noop$3, not_equal: i, bound: blank_object(), on_mount: [], on_destroy: [], on_disconnect: [], before_update: [], after_update: [], context: new Map(e.context || (c ? c.$$.context : [])), callbacks: blank_object(), dirty: s2, skip_bound: false, root: e.target || c.$$.root };
  r2 && r2(l.root);
  let u = false;
  if (l.ctx = n ? n(t4, e.props || {}, (e2, n2, ...o3) => {
    const a2 = o3.length ? o3[0] : n2;
    return l.ctx && i(l.ctx[e2], l.ctx[e2] = a2) && (!l.skip_bound && l.bound[e2] && l.bound[e2](a2), u && make_dirty(t4, e2)), n2;
  }) : [], l.update(), u = true, run_all(l.before_update), l.fragment = !!o2 && o2(l.ctx), e.target) {
    if (e.hydrate) {
      const t5 = children(e.target);
      l.fragment && l.fragment.l(t5), t5.forEach(detach);
    } else l.fragment && l.fragment.c();
    e.intro && transition_in(t4.$$.fragment), mount_component(t4, e.target, e.anchor), flush();
  }
  set_current_component(c);
}
class SvelteComponent {
  $$ = void 0;
  $$set = void 0;
  $destroy() {
    destroy_component(this, 1), this.$destroy = noop$3;
  }
  $on(t4, e) {
    if (!is_function(e)) return noop$3;
    const n = this.$$.callbacks[t4] || (this.$$.callbacks[t4] = []);
    return n.push(e), () => {
      const t5 = n.indexOf(e);
      -1 !== t5 && n.splice(t5, 1);
    };
  }
  $set(t4) {
    this.$$set && !is_empty(t4) && (this.$$.skip_bound = true, this.$$set(t4), this.$$.skip_bound = false);
  }
}
const PUBLIC_VERSION = "4", subscriber_queue = [];
function readable(t4, e) {
  return { subscribe: writable(t4, e).subscribe };
}
function writable(t4, e = noop$3) {
  let n;
  const o2 = /* @__PURE__ */ new Set();
  function i(e2) {
    if (safe_not_equal(t4, e2) && (t4 = e2, n)) {
      const e3 = !subscriber_queue.length;
      for (const e4 of o2) e4[1](), subscriber_queue.push(e4, t4);
      if (e3) {
        for (let t5 = 0; t5 < subscriber_queue.length; t5 += 2) subscriber_queue[t5][0](subscriber_queue[t5 + 1]);
        subscriber_queue.length = 0;
      }
    }
  }
  function a(e2) {
    i(e2(t4));
  }
  return { set: i, update: a, subscribe: function(r2, s2 = noop$3) {
    const c = [r2, s2];
    return o2.add(c), 1 === o2.size && (n = e(i, a) || noop$3), r2(t4), () => {
      o2.delete(c), 0 === o2.size && n && (n(), n = null);
    };
  } };
}
function derived(t4, e, n) {
  const o2 = !Array.isArray(t4), i = o2 ? [t4] : t4;
  if (!i.every(Boolean)) throw new Error("derived() expects stores as input, got a falsy value");
  const a = e.length < 2;
  return readable(n, (t5, n2) => {
    let r2 = false;
    const s2 = [];
    let c = 0, l = noop$3;
    const u = () => {
      if (c) return;
      l();
      const i2 = e(o2 ? s2[0] : s2, t5, n2);
      a ? t5(i2) : l = is_function(i2) ? i2 : noop$3;
    }, p2 = i.map((t6, e2) => subscribe(t6, (t7) => {
      s2[e2] = t7, c &= ~(1 << e2), r2 && u();
    }, () => {
      c |= 1 << e2;
    }));
    return r2 = true, u(), function() {
      run_all(p2), l(), r2 = false;
    };
  });
}
const largeScreen = writable(false);
window.MIN_WINDOW_WIDTH = 200, window.MIN_WINDOW_HEIGHT = 50;
const LARGE_SCREEN_WIDTH = 600;
function onReady(t4) {
  isMobileCompanion() && (hideAllElements(), disableSounds(), window.addEventListener("resize", updateScreenWidth), t4());
}
function getIsLargeScreen() {
  return window.innerWidth >= LARGE_SCREEN_WIDTH;
}
const updateScreenWidth = () => {
  largeScreen.set(getIsLargeScreen());
};
function onRenderItemSheet(t4) {
  isMobileCompanion() && (t4.element.addClass(getBaseModuleId() + " full-size-sheet"), t4.setPosition({ top: 0, left: 0 }));
}
function renderSettingsConfig(t4) {
  if (isMobileCompanion() && (t4.css({ zIndex: 2e3 }), window.innerWidth < 600)) {
    const e = t4.find(".window-content .flexrow");
    e.removeClass("flexrow"), e.addClass("flexcol");
  }
}
function isMinimalWritableStore(t4) {
  if (null == t4) return false;
  switch (typeof t4) {
    case "function":
    case "object":
      return "function" == typeof t4.subscribe && "function" == typeof t4.set;
  }
  return false;
}
function isWritableStore(t4) {
  if (null == t4) return false;
  switch (typeof t4) {
    case "function":
    case "object":
      return "function" == typeof t4.subscribe && "function" == typeof t4.set && "function" == typeof t4.update;
  }
  return false;
}
function subscribeIgnoreFirst(t4, e) {
  let n = false;
  return t4.subscribe((t5) => {
    n ? e(t5) : n = true;
  });
}
function deepMerge(t4, ...e) {
  if ("[object Object]" !== Object.prototype.toString.call(t4)) throw new TypeError("deepMerge error: 'target' is not an object.");
  if (0 === e.length) throw new TypeError("deepMerge error: 'sourceObj' is not an object.");
  for (let t5 = 0; t5 < e.length; t5++) if ("[object Object]" !== Object.prototype.toString.call(e[t5])) throw new TypeError(`deepMerge error: 'sourceObj[${t5}]' is not an object.`);
  if (1 === e.length) {
    const n = [];
    for (const o2 of e) n.push({ target: t4, source: o2 });
    for (; n.length > 0; ) {
      const { target: t5, source: e2 } = n.pop();
      for (const o2 in e2) if (Object.hasOwn(e2, o2)) {
        const i = e2[o2], a = t5[o2];
        Object.hasOwn(t5, o2) && a?.constructor === Object && i?.constructor === Object ? n.push({ target: a, source: i }) : t5[o2] = i;
      }
    }
  } else {
    const n = [{ target: t4, sources: e }];
    for (; n.length > 0; ) {
      const { target: t5, sources: e2 } = n.pop();
      for (const o2 of e2) for (const e3 in o2) if (Object.hasOwn(o2, e3)) {
        const i = o2[e3], a = t5[e3];
        Object.hasOwn(t5, e3) && a?.constructor === Object && i?.constructor === Object ? (t5[e3] = Object.assign({}, a), n.push({ target: t5[e3], sources: [i] })) : t5[e3] = i;
      }
    }
  }
  return t4;
}
function hasGetter(t4, e) {
  if ("object" != typeof t4 || null == t4) return false;
  const n = Object.getOwnPropertyDescriptor(t4, e);
  if (void 0 !== n && void 0 !== n.get) return true;
  for (let n2 = Object.getPrototypeOf(t4); n2; n2 = Object.getPrototypeOf(n2)) {
    const t5 = Object.getOwnPropertyDescriptor(n2, e);
    if (void 0 !== t5 && void 0 !== t5.get) return true;
  }
  return false;
}
function hasPrototype(t4, e) {
  if ("function" != typeof t4) return false;
  if (t4 === e) return true;
  for (let n = Object.getPrototypeOf(t4); n; n = Object.getPrototypeOf(n)) if (n === e) return true;
  return false;
}
function isIterable(t4) {
  return null != t4 && "object" == typeof t4 && Symbol.iterator in t4;
}
function isObject$1(t4) {
  return null !== t4 && "object" == typeof t4 && !Array.isArray(t4);
}
function isPlainObject(t4) {
  if ("[object Object]" !== Object.prototype.toString.call(t4)) return false;
  const e = Object.getPrototypeOf(t4);
  return null === e || e === Object.prototype;
}
function safeAccess(t4, e, n) {
  if ("object" != typeof t4 || null === t4) return n;
  if ("string" != typeof e) return n;
  const o2 = e.split(".");
  let i = t4;
  for (let t5 = 0; t5 < o2.length; t5++) {
    if (void 0 === i[o2[t5]] || null === i[o2[t5]]) return n;
    i = i[o2[t5]];
  }
  return i;
}
function safeSet(t4, e, n, { operation: o2 = "set", createMissing: i = false } = {}) {
  if ("object" != typeof t4 || null === t4) throw new TypeError("safeSet error: 'data' is not an object.");
  if ("string" != typeof e) throw new TypeError("safeSet error: 'accessor' is not a string.");
  if ("string" != typeof o2) throw new TypeError("safeSet error: 'options.operation' is not a string.");
  if ("add" !== o2 && "div" !== o2 && "mult" !== o2 && "set" !== o2 && "set-undefined" !== o2 && "sub" !== o2) throw new Error("safeSet error: Unknown 'options.operation'.");
  if ("boolean" != typeof i) throw new TypeError("safeSet error: 'options.createMissing' is not a boolean.");
  const a = e.split(".");
  let r2 = false;
  if (1 === a.length && !i && !(a[0] in t4)) return false;
  for (let e2 = 0; e2 < a.length; e2++) {
    if (Array.isArray(t4)) {
      const t5 = +a[e2];
      if (!Number.isInteger(t5) || t5 < 0) return false;
    }
    if (e2 === a.length - 1) switch (o2) {
      case "add":
        t4[a[e2]] += n, r2 = true;
        break;
      case "div":
        t4[a[e2]] /= n, r2 = true;
        break;
      case "mult":
        t4[a[e2]] *= n, r2 = true;
        break;
      case "set":
        t4[a[e2]] = n, r2 = true;
        break;
      case "set-undefined":
        void 0 === t4[a[e2]] && (t4[a[e2]] = n), r2 = true;
        break;
      case "sub":
        t4[a[e2]] -= n, r2 = true;
    }
    else {
      if (i && void 0 === t4[a[e2]] && (t4[a[e2]] = {}), null === t4[a[e2]] || "object" != typeof t4[a[e2]]) return false;
      t4 = t4[a[e2]];
    }
  }
  return r2;
}
class CrossWindow {
  constructor() {
  }
  static #t = ["HTMLAnchorElement", "HTMLButtonElement", "HTMLDetailsElement", "HTMLEmbedElement", "HTMLIFrameElement", "HTMLInputElement", "HTMLObjectElement", "HTMLSelectElement", "HTMLTextAreaElement"];
  static #e = /* @__PURE__ */ new Set([Node.ELEMENT_NODE, Node.TEXT_NODE, Node.COMMENT_NODE, Node.DOCUMENT_FRAGMENT_NODE]);
  static #n = /* @__PURE__ */ new Set(["MouseEvent", "PointerEvent"]);
  static #o = /* @__PURE__ */ new Set(["UIEvent", "FocusEvent", "MouseEvent", "WheelEvent", "KeyboardEvent", "PointerEvent", "TouchEvent", "InputEvent", "CompositionEvent", "DragEvent"]);
  static #i = /* @__PURE__ */ new Set(["KeyboardEvent", "MouseEvent", "PointerEvent"]);
  static #a = { throws: false };
  static getActiveElement(t4, { throws: e = true } = {}) {
    if (this.#e.has(t4?.nodeType)) return t4?.ownerDocument?.activeElement ?? null;
    if (this.isUIEvent(t4) && isObject$1(t4?.view)) return t4?.view?.document?.activeElement ?? null;
    if (isObject$1(t4?.defaultView)) return t4?.activeElement ?? null;
    if (isObject$1(t4?.document) && isObject$1(t4?.location)) return t4?.document?.activeElement ?? null;
    if (e) throw new TypeError("'target' must be a DOM Node / Element, Document, UIEvent, or Window.");
  }
  static getDocument(t4, { throws: e = true } = {}) {
    if (this.#e.has(t4?.nodeType)) return t4?.ownerDocument;
    if (this.isUIEvent(t4) && isObject$1(t4?.view)) return t4?.view?.document;
    if (isObject$1(t4?.defaultView)) return t4;
    if (isObject$1(t4?.document) && isObject$1(t4?.location)) return t4?.document;
    if (e) throw new TypeError("'target' must be a DOM Node / Element, Document, UIEvent, or Window.");
  }
  static getWindow(t4, { throws: e = true } = {}) {
    if (this.#e.has(t4?.nodeType)) return t4.ownerDocument?.defaultView ?? globalThis;
    if (this.isUIEvent(t4) && isObject$1(t4?.view)) return t4.view ?? globalThis;
    if (isObject$1(t4?.defaultView)) return t4.defaultView ?? globalThis;
    if (isObject$1(t4?.document) && isObject$1(t4?.location)) return t4;
    if (e) throw new TypeError("'target' must be a DOM Node / Element, Document, UIEvent, or Window.");
  }
  static isDocument(t4) {
    return isObject$1(t4) && "[object Document]" === Object.prototype.toString.call(t4);
  }
  static isMap(t4) {
    return isObject$1(t4) && "[object Map]" === Object.prototype.toString.call(t4);
  }
  static isPromise(t4) {
    return isObject$1(t4) && "[object Promise]" === Object.prototype.toString.call(t4);
  }
  static isRegExp(t4) {
    return isObject$1(t4) && "[object RegExp]" === Object.prototype.toString.call(t4);
  }
  static isSet(t4) {
    return isObject$1(t4) && "[object Set]" === Object.prototype.toString.call(t4);
  }
  static isURL(t4) {
    return isObject$1(t4) && "[object URL]" === Object.prototype.toString.call(t4);
  }
  static isWindow(t4) {
    return isObject$1(t4) && "[object Window]" === Object.prototype.toString.call(t4);
  }
  static isFocusableHTMLElement(t4) {
    for (let e = this.#t.length; --e >= 0; ) if (this.#r(t4, Node.ELEMENT_NODE, this.#t[e])) return true;
    return false;
  }
  static isDocumentFragment(t4) {
    return this.#r(t4, Node.DOCUMENT_FRAGMENT_NODE, "DocumentFragment");
  }
  static isElement(t4) {
    return this.#r(t4, Node.ELEMENT_NODE, "Element");
  }
  static isHTMLAnchorElement(t4) {
    return this.#r(t4, Node.ELEMENT_NODE, "HTMLAnchorElement");
  }
  static isHTMLElement(t4) {
    return this.#r(t4, Node.ELEMENT_NODE, "HTMLElement");
  }
  static isNode(t4) {
    if ("number" != typeof t4?.nodeType) return false;
    if (t4 instanceof globalThis.Node) return true;
    const e = this.getWindow(t4, this.#a), n = e?.Node;
    return n && t4 instanceof n;
  }
  static isShadowRoot(t4) {
    return this.#r(t4, Node.DOCUMENT_FRAGMENT_NODE, "ShadowRoot");
  }
  static isSVGElement(t4) {
    return this.#r(t4, Node.ELEMENT_NODE, "SVGElement");
  }
  static isEvent(t4, e) {
    return "string" == typeof t4?.type && "boolean" == typeof t4?.defaultPrevented && "function" == typeof t4?.stopPropagation && (void 0 === e || this.isCtorName(t4, e));
  }
  static isPointerEvent(t4) {
    return this.isEvent(t4, this.#n);
  }
  static isUIEvent(t4) {
    return this.isEvent(t4, this.#o);
  }
  static isUserInputEvent(t4) {
    return this.isEvent(t4, this.#i);
  }
  static isCtorName(t4, e) {
    return !!isObject$1(t4) && ("string" == typeof e && t4?.constructor?.name === e || !!e?.has(t4?.constructor?.name));
  }
  static #r(t4, e, n) {
    if (!isObject$1(t4)) return false;
    if (t4.nodeType !== e) return false;
    const o2 = globalThis[n];
    if (o2 && t4 instanceof o2) return true;
    const i = this.#e.has(t4.nodeType) ? t4?.ownerDocument?.defaultView : this.getWindow(t4, this.#a), a = i?.[n];
    return a && t4 instanceof a;
  }
}
var _a$1;
class TJSGameSettings {
  #s;
  #c = [];
  #l = /* @__PURE__ */ new Map();
  constructor(t4) {
    if ("string" != typeof t4) throw new TypeError("'namespace' is not a string.");
    this.#s = t4;
  }
  static #u(t4) {
    return writable(t4);
  }
  get namespace() {
    return this.#s;
  }
  #p(t4, e) {
    let n = this.#l.get(t4);
    return void 0 === n && (n = _a$1.#u(e), this.#l.set(t4, n)), n;
  }
  getReadableStore(t4) {
    if (!this.#l.has(t4)) return void console.warn(`TJSGameSettings - getReadableStore: '${t4}' is not a registered setting.`);
    return { subscribe: this.#p(t4).subscribe };
  }
  getStore(t4) {
    return this.getWritableStore(t4);
  }
  getWritableStore(t4) {
    if (this.#l.has(t4)) return this.#p(t4);
    console.warn(`TJSGameSettings - getWritableStore: '${t4}' is not a registered setting.`);
  }
  register(t4, e = true) {
    if (!isObject$1(t4)) throw new TypeError("TJSGameSettings - register: setting is not an object.");
    if (!isObject$1(t4.options)) throw new TypeError("TJSGameSettings - register: 'setting.options' attribute is not an object.");
    if ("boolean" != typeof e) throw new TypeError("TJSGameSettings - register: 'coreConfig' is not an boolean.");
    if (void 0 !== t4.store && !isMinimalWritableStore(t4.store)) throw new TypeError("TJSGameSettings - register: 'setting.store' attribute is not a minimal writable store.");
    const n = t4.namespace ?? this.#s, o2 = t4.key, i = !!e && (t4.options.config ?? true);
    if ("string" != typeof n) throw new TypeError("TJSGameSettings - register: 'namespace' attribute is not a string.");
    if ("string" != typeof o2) throw new TypeError("TJSGameSettings - register: 'key' attribute is not a string.");
    const a = t4.store, r2 = t4.options, s2 = [];
    let c = false;
    if (s2.push((t5) => {
      const e2 = this.#p(o2);
      e2 && !c && (c = true, e2.set(t5), c = false);
    }), isIterable(r2?.onChange)) for (const t5 of r2.onChange) "function" == typeof t5 && s2.push(t5);
    else "function" == typeof r2.onChange && s2.push(r2.onChange);
    globalThis.game.settings.register(n, o2, { ...r2, config: i, onChange: (t5) => {
      for (const e2 of s2) e2(t5);
    } });
    const l = a || this.#p(o2, globalThis.game.settings.get(n, o2));
    a && (this.#l.set(o2, l), a.set(globalThis.game.settings.get(n, o2)));
    subscribeIgnoreFirst(l, async (t5) => {
      c || (c = true, await globalThis.game.settings.set(n, o2, t5)), c = false;
    });
    {
      const { store: e2, ...i2 } = t4, a2 = Object.assign({}, i2, { namespace: n, key: o2, options: r2 });
      Object.freeze(a2), this.#c.push(a2);
    }
  }
  registerAll(t4, e) {
    if (!isIterable(t4)) throw new TypeError("TJSGameSettings - registerAll: settings is not iterable.");
    for (const n of t4) {
      if (!isObject$1(n)) throw new TypeError("TJSGameSettings - registerAll: entry in settings is not an object.");
      if ("string" != typeof n.namespace) throw new TypeError("TJSGameSettings - registerAll: entry in settings missing 'namespace' attribute.");
      if ("string" != typeof n.key) throw new TypeError("TJSGameSettings - registerAll: entry in settings missing 'key' attribute.");
      if (!isObject$1(n.options)) throw new TypeError("TJSGameSettings - registerAll: entry in settings missing 'options' attribute.");
      this.register(n, e);
    }
  }
  *data(t4 = void 0) {
    if (void 0 !== t4 && !CrossWindow.isRegExp(t4)) throw new TypeError("'regex' is not a RegExp");
    if (this.#c.length) if (t4) for (const e of this.#c) t4.test(e.key) && (yield e);
    else for (const t5 of this.#c) yield t5;
  }
  *entries(t4 = void 0) {
    if (void 0 !== t4 && !CrossWindow.isRegExp(t4)) throw new TypeError("'regex' is not a RegExp");
    if (this.#l.size) if (t4) for (const e of this.#l.keys()) t4.test(e) && (yield [e, this.getStore(e)]);
    else for (const t5 of this.#l.keys()) yield [t5, this.getStore(t5)];
  }
  *keys(t4 = void 0) {
    if (void 0 !== t4 && !CrossWindow.isRegExp(t4)) throw new TypeError("'regex' is not a RegExp");
    if (this.#l.size) if (t4) for (const e of this.#l.keys()) t4.test(e) && (yield e);
    else for (const t5 of this.#l.keys()) yield t5;
  }
  *stores(t4 = void 0) {
    if (void 0 !== t4 && !CrossWindow.isRegExp(t4)) throw new TypeError("'regex' is not a RegExp");
    if (this.#l.size) if (t4) for (const e of this.#l.keys()) t4.test(e) && (yield this.getStore(e));
    else for (const t5 of this.#l.keys()) yield this.getStore(t5);
  }
}
function storeGenerator({ storage: t4, serialize: e = JSON.stringify, deserialize: n = JSON.parse }) {
  function o2(t5, e2, n2) {
    return { subscribe: i(t5, e2, n2).subscribe };
  }
  function i(o3, i2, a) {
    if (t4) {
      const a2 = t4.getItem(o3);
      try {
        a2 && (i2 = n(a2));
      } catch (t5) {
      }
      t4.setItem(o3, e(i2));
    }
    const r2 = writable(i2, a ? function(n2) {
      return a(function(i3) {
        return t4 && t4.setItem(o3, e(i3)), n2(i3);
      }, function(t5) {
        s2(t5(get_store_value(r2)));
      });
    } : void 0);
    function s2(n2) {
      t4 && t4.setItem(o3, e(n2)), r2.set(n2);
    }
    return { set: s2, update: function(t5) {
      s2(t5(get_store_value(r2)));
    }, subscribe: function(t5, e2) {
      return r2.subscribe(t5, e2);
    } };
  }
  return { readable: o2, writable: i, derived: function(e2, i2, a, r2) {
    const s2 = !Array.isArray(i2), c = s2 ? [i2] : i2;
    if (t4 && t4.getItem(e2)) try {
      r2 = n(t4.getItem(e2));
    } catch (t5) {
    }
    return o2(e2, r2, (t5, e3) => {
      let n2 = false;
      const o3 = [];
      let i3, r3 = 0;
      const l = () => {
        if (r3) return;
        i3?.();
        const n3 = s2 ? o3[0] : o3;
        if (a.length < 2) t5(a(n3));
        else {
          const o4 = a(n3, t5, e3);
          "function" == typeof o4 && (i3 = o4);
        }
      }, u = c.map((t6, e4) => t6.subscribe((t7) => {
        o3[e4] = t7, r3 &= ~(1 << e4), n2 && l();
      }, () => {
        r3 |= 1 << e4;
      }));
      return n2 = true, l(), function() {
        u.forEach((t6) => t6()), i3?.();
      };
    });
  }, storage: t4, serialize: e, deserialize: n };
}
_a$1 = TJSGameSettings;
const sessionStores = storeGenerator({ storage: globalThis?.sessionStorage });
class TJSWebStorage {
  #d;
  #l = /* @__PURE__ */ new Map();
  constructor(t4) {
    this.#d = t4;
  }
  #u(t4, e = void 0, n) {
    try {
      const o2 = this.#d.storage.getItem(t4);
      if (null !== o2) {
        e = (n?.deserialize ?? this.#d.deserialize)(o2);
      }
    } catch (t5) {
    }
    return (n?.writable ?? this.#d.writable)(t4, e);
  }
  #m(t4) {
    return this.#l.get(t4)?.deserialize ?? this.#d.deserialize;
  }
  #f(t4) {
    return this.#l.get(t4)?.serialize ?? this.#d.serialize;
  }
  #p(t4, e = void 0, n) {
    const o2 = this.#l.get(t4);
    if (o2) return o2.store;
    const i = this.#u(t4, e, n);
    return this.#l.set(t4, { store: i, deserialize: n?.deserialize, serialize: n?.serialize }), i;
  }
  getItem(t4, e) {
    let n = e;
    const o2 = this.#d.storage.getItem(t4);
    if (null !== o2) try {
      n = this.#m(t4)(o2);
    } catch (t5) {
      n = e;
    }
    else if (void 0 !== e) try {
      const n2 = this.#f(t4)(e);
      this.#d.storage.setItem(t4, n2);
    } catch (t5) {
    }
    return n;
  }
  getStore(t4, e, n) {
    return this.#p(t4, e, n);
  }
  hasStore(t4) {
    return this.#l.has(t4);
  }
  setItem(t4, e) {
    this.#p(t4).set(e);
  }
  swapItemBoolean(t4, e) {
    const n = this.#p(t4, e);
    let o2 = false;
    try {
      o2 = !!this.#m(t4)(this.#d.storage.getItem(t4));
    } catch (t5) {
    }
    const i = "boolean" == typeof o2 && !o2;
    return n.set(i), i;
  }
  *entries(t4 = void 0) {
    if (void 0 !== t4 && !CrossWindow.isRegExp(t4)) throw new TypeError("'regex' is not a RegExp");
    if (this.#l.size) if (t4) for (const e of this.#l.keys()) t4.test(e) && (yield [e, this.getStore(e)]);
    else for (const t5 of this.#l.keys()) yield [t5, this.getStore(t5)];
  }
  *keys(t4 = void 0) {
    if (void 0 !== t4 && !CrossWindow.isRegExp(t4)) throw new TypeError("'regex' is not a RegExp");
    if (this.#l.size) if (t4) for (const e of this.#l.keys()) t4.test(e) && (yield e);
    else for (const t5 of this.#l.keys()) yield t5;
  }
  *stores(t4 = void 0) {
    if (void 0 !== t4 && !CrossWindow.isRegExp(t4)) throw new TypeError("'regex' is not a RegExp");
    if (this.#l.size) if (t4) for (const e of this.#l.keys()) t4.test(e) && (yield this.getStore(e));
    else for (const t5 of this.#l.keys()) yield this.getStore(t5);
  }
}
class TJSSessionStorage extends TJSWebStorage {
  constructor() {
    super(sessionStores);
  }
}
function writableDerived(t4, e, n, o2) {
  var i, a, r2 = false, s2 = n.length >= 2, c = derived(t4, (t5, n2, o3) => {
    if (i = n2, s2 && (a = t5), !r2) {
      let i2 = e(t5, n2, o3);
      if (!(e.length < 2)) return i2;
      n2(i2);
    }
    r2 = false;
  }, o2), l = !Array.isArray(t4);
  var u = false;
  function p2(e2) {
    var o3, s3, p3, d;
    if (u) return d = e2(get_store_value(c)), void i(d);
    var m, f = c.subscribe((t5) => {
      u ? o3 ? s3 = true : o3 = true : p3 = t5;
    });
    d = e2(p3), u = true, i(d), f(), u = false, s3 && (d = get_store_value(c)), o3 && (m = n(d, a), l ? (r2 = true, t4.set(m)) : m.forEach((e3, n2) => {
      r2 = true, t4[n2].set(e3);
    }), r2 = false);
  }
  return { subscribe: c.subscribe, set(t5) {
    p2(() => t5);
  }, update: p2 };
}
function propertyStore(t4, e) {
  if (Array.isArray(e)) {
    let n = e.concat();
    return writableDerived(t4, (t5) => {
      for (let e2 = 0; e2 < n.length; ++e2) t5 = t5[n[e2]];
      return t5;
    }, (t5, e2) => {
      let o2 = e2;
      for (let t6 = 0; t6 < n.length - 1; ++t6) o2 = o2[n[t6]];
      return o2[n[n.length - 1]] = t5, e2;
    });
  }
  return writableDerived(t4, (t5) => t5[e], (t5, n) => (n[e] = t5, n));
}
class APIConfig {
  constructor() {
  }
  static isConfig(t4, { raiseException: e = false } = {}) {
    if (!isObject$1(t4)) {
      if (e) throw new TypeError("TJSSvelte.config.isConfig error: 'config' is not an object.");
      return false;
    }
    if (!TJSSvelte.util.isComponent(t4.class)) {
      if (e) throw new TypeError("TJSSvelte.config.isConfig error: 'config.class' is not a Svelte component constructor.");
      return false;
    }
    return true;
  }
  static isConfigEmbed(t4, { raiseException: e = false } = {}) {
    if (!isObject$1(t4)) {
      if (e) throw new TypeError("TJSSvelte.config.isConfigEmbed error: 'config' is not an object.");
      return false;
    }
    if (!TJSSvelte.util.isComponent(t4.class)) {
      if (e) throw new TypeError("TJSSvelte.config.isConfigEmbed error: 'config.class' is not a Svelte component constructor.");
      return false;
    }
    if (void 0 !== t4.props && !isObject$1(t4.props)) {
      if (e) throw new TypeError("TJSSvelte.config.isConfigEmbed error: 'config.props' is not an object.");
      return false;
    }
    return true;
  }
  static parseConfig(t4, { contextExternal: e = false, thisArg: n } = {}) {
    if (!isObject$1(t4)) throw new TypeError(`TJSSvelte.config.parseConfig - 'config' is not an object:
${JSON.stringify(t4)}.`);
    if (!TJSSvelte.util.isComponent(t4.class)) throw new TypeError(`TJSSvelte.config.parseConfig - 'class' is not a Svelte component constructor for config:
${JSON.stringify(t4)}.`);
    if (void 0 !== t4.hydrate && "boolean" != typeof t4.hydrate) throw new TypeError(`TJSSvelte.config.parseConfig - 'hydrate' is not a boolean for config:
${JSON.stringify(t4)}.`);
    if (void 0 !== t4.intro && "boolean" != typeof t4.intro) throw new TypeError(`TJSSvelte.config.parseConfig - 'intro' is not a boolean for config:
${JSON.stringify(t4)}.`);
    if (void 0 !== t4.target && !CrossWindow.isElement(t4.target) && !CrossWindow.isShadowRoot(t4.target) && !CrossWindow.isDocumentFragment(t4.target)) throw new TypeError(`TJSSvelte.config.parseConfig - 'target' is not a Element, ShadowRoot, or DocumentFragment for config:
${JSON.stringify(t4)}.`);
    if (void 0 !== t4.anchor && !CrossWindow.isElement(t4.anchor) && !CrossWindow.isShadowRoot(t4.anchor) && !CrossWindow.isDocumentFragment(t4.anchor)) throw new TypeError(`TJSSvelte.config.parseConfig - 'anchor' is not a string, Element for config:
${JSON.stringify(t4)}.`);
    if (void 0 !== t4.context && "function" != typeof t4.context && !isObject$1(t4.context)) throw new TypeError(`TJSSvelte.config.parseConfig - 'context' is not a function or object for config:
${JSON.stringify(t4)}.`);
    const o2 = { ...t4 };
    let i = {};
    if ("function" == typeof o2.context) {
      const e2 = o2.context;
      delete o2.context;
      const a = e2.call(n);
      if (!isObject$1(a)) throw new Error(`TJSSvelte.config.parseConfig - 'context' is a function that did not return an object for config:
${JSON.stringify(t4)}`);
      i = { ...a };
    } else isObject$1(o2.context) && (i = o2.context, delete o2.context);
    return o2.props = this.#_(o2.props, n, t4), e ? (o2.context = /* @__PURE__ */ new Map(), o2.context.set("#external", i)) : o2.context = new Map(Object.entries(i)), o2;
  }
  static #_(t4, e, n) {
    if ("function" == typeof t4) {
      const o2 = t4.call(e);
      if (isObject$1(o2)) return o2;
      throw new Error(`TJSSvelte.config.parseConfig - 'props' is a function that did not return an object for config:
${JSON.stringify(n)}`);
    }
    if (isObject$1(t4)) return t4;
    if (void 0 !== t4) throw new Error(`TJSSvelte.config.parseConfig - 'props' is not a function or an object for config:
${JSON.stringify(n)}`);
    return {};
  }
}
Object.seal(APIConfig);
class APIUtil {
  constructor() {
  }
  static isComponent(t4) {
    if (null == t4 || "function" != typeof t4) return false;
    const e = t4?.prototype?.constructor?.name;
    return !("string" != typeof e || !e.startsWith("Proxy<") && "ProxyComponent" !== e) || ("undefined" != typeof window ? "function" == typeof t4?.prototype?.$destroy && "function" == typeof t4?.prototype?.$on : "function" == typeof t4?.prototype?.render);
  }
  static isHMRProxy(t4) {
    const e = t4?.constructor?.name;
    if ("string" == typeof e && (e.startsWith("Proxy<") || "ProxyComponent" === e)) return true;
    const n = t4?.prototype?.constructor?.name;
    return "string" == typeof n && (n.startsWith("Proxy<") || "ProxyComponent" === n);
  }
  static async outroAndDestroy(t4) {
    return null == t4 ? Promise.resolve() : new Promise((e) => {
      t4?.$$?.fragment && t4?.$$?.fragment?.o ? (group_outros(), transition_out(t4.$$.fragment, 0, 0, () => {
        t4?.$destroy?.(), e();
      }), check_outros()) : (t4?.$destroy?.(), e());
    });
  }
}
Object.seal(APIUtil);
class TJSSvelte {
  constructor() {
  }
  static get config() {
    return APIConfig;
  }
  static get util() {
    return APIUtil;
  }
}
function backInOut(t4) {
  const e = 2.5949095;
  return (t4 *= 2) < 1 ? t4 * t4 * ((e + 1) * t4 - e) * 0.5 : 0.5 * ((t4 -= 2) * t4 * ((e + 1) * t4 + e) + 2);
}
function backIn(t4) {
  const e = 1.70158;
  return t4 * t4 * ((e + 1) * t4 - e);
}
function backOut(t4) {
  const e = 1.70158;
  return --t4 * t4 * ((e + 1) * t4 + e) + 1;
}
function bounceOut(t4) {
  const e = t4 * t4;
  return t4 < 4 / 11 ? 7.5625 * e : t4 < 8 / 11 ? 9.075 * e - 9.9 * t4 + 3.4 : t4 < 0.9 ? 4356 / 361 * e - 35442 / 1805 * t4 + 16061 / 1805 : 10.8 * t4 * t4 - 20.52 * t4 + 10.72;
}
function bounceInOut(t4) {
  return t4 < 0.5 ? 0.5 * (1 - bounceOut(1 - 2 * t4)) : 0.5 * bounceOut(2 * t4 - 1) + 0.5;
}
function bounceIn(t4) {
  return 1 - bounceOut(1 - t4);
}
function circInOut(t4) {
  return (t4 *= 2) < 1 ? -0.5 * (Math.sqrt(1 - t4 * t4) - 1) : 0.5 * (Math.sqrt(1 - (t4 -= 2) * t4) + 1);
}
function circIn(t4) {
  return 1 - Math.sqrt(1 - t4 * t4);
}
function circOut(t4) {
  return Math.sqrt(1 - --t4 * t4);
}
function cubicInOut(t4) {
  return t4 < 0.5 ? 4 * t4 * t4 * t4 : 0.5 * Math.pow(2 * t4 - 2, 3) + 1;
}
function cubicIn(t4) {
  return t4 * t4 * t4;
}
function cubicOut(t4) {
  const e = t4 - 1;
  return e * e * e + 1;
}
function elasticInOut(t4) {
  return t4 < 0.5 ? 0.5 * Math.sin(13 * Math.PI / 2 * 2 * t4) * Math.pow(2, 10 * (2 * t4 - 1)) : 0.5 * Math.sin(-13 * Math.PI / 2 * (2 * t4 - 1 + 1)) * Math.pow(2, -10 * (2 * t4 - 1)) + 1;
}
function elasticIn(t4) {
  return Math.sin(13 * t4 * Math.PI / 2) * Math.pow(2, 10 * (t4 - 1));
}
function elasticOut(t4) {
  return Math.sin(-13 * (t4 + 1) * Math.PI / 2) * Math.pow(2, -10 * t4) + 1;
}
function expoInOut(t4) {
  return 0 === t4 || 1 === t4 ? t4 : t4 < 0.5 ? 0.5 * Math.pow(2, 20 * t4 - 10) : -0.5 * Math.pow(2, 10 - 20 * t4) + 1;
}
function expoIn(t4) {
  return 0 === t4 ? t4 : Math.pow(2, 10 * (t4 - 1));
}
function expoOut(t4) {
  return 1 === t4 ? t4 : 1 - Math.pow(2, -10 * t4);
}
function quadInOut(t4) {
  return (t4 /= 0.5) < 1 ? 0.5 * t4 * t4 : -0.5 * (--t4 * (t4 - 2) - 1);
}
function quadIn(t4) {
  return t4 * t4;
}
function quadOut(t4) {
  return -t4 * (t4 - 2);
}
function quartInOut(t4) {
  return t4 < 0.5 ? 8 * Math.pow(t4, 4) : -8 * Math.pow(t4 - 1, 4) + 1;
}
function quartIn(t4) {
  return Math.pow(t4, 4);
}
function quartOut(t4) {
  return Math.pow(t4 - 1, 3) * (1 - t4) + 1;
}
function quintInOut(t4) {
  return (t4 *= 2) < 1 ? 0.5 * t4 * t4 * t4 * t4 * t4 : 0.5 * ((t4 -= 2) * t4 * t4 * t4 * t4 + 2);
}
function quintIn(t4) {
  return t4 * t4 * t4 * t4 * t4;
}
function quintOut(t4) {
  return --t4 * t4 * t4 * t4 * t4 + 1;
}
function sineInOut(t4) {
  return -0.5 * (Math.cos(Math.PI * t4) - 1);
}
function sineIn(t4) {
  const e = Math.cos(t4 * Math.PI * 0.5);
  return Math.abs(e) < 1e-14 ? 1 : 1 - e;
}
function sineOut(t4) {
  return Math.sin(t4 * Math.PI / 2);
}
Object.seal(TJSSvelte);
const svelteEasingFunc = Object.freeze(Object.defineProperty({ __proto__: null, backIn, backInOut, backOut, bounceIn, bounceInOut, bounceOut, circIn, circInOut, circOut, cubicIn, cubicInOut, cubicOut, elasticIn, elasticInOut, elasticOut, expoIn, expoInOut, expoOut, linear: identity, quadIn, quadInOut, quadOut, quartIn, quartInOut, quartOut, quintIn, quintInOut, quintOut, sineIn, sineInOut, sineOut }, Symbol.toStringTag, { value: "Module" })), easingFunc = svelteEasingFunc;
function getEasingFunc(t4, e) {
  if ("function" == typeof t4) return t4;
  const n = easingFunc[t4];
  return n || easingFunc[e?.default ?? "linear"];
}
class A11yHelper {
  static #h = false;
  static get debug() {
    return this.#h;
  }
  static set debug(t4) {
    if ("boolean" != typeof t4) throw new TypeError("'debug' is not a boolean.");
    this.#h = t4;
  }
  static get prefersReducedMotion() {
    return globalThis?.matchMedia("(prefers-reduced-motion: reduce)")?.matches ?? false;
  }
  static applyFocusSource(t4) {
    if (!isObject$1(t4)) return;
    const e = isObject$1(t4?.focusSource) ? t4.focusSource : t4;
    setTimeout(() => {
      const t5 = "boolean" == typeof e.debug ? this.debug || e.debug : this.debug;
      if (isIterable(e.focusEl)) {
        t5 && e.focusEl;
        for (const t6 of e.focusEl) {
          if (t6?.nodeType === Node.ELEMENT_NODE && t6?.isConnected) {
            t6?.focus();
            break;
          }
          if ("string" == typeof t6) {
            const e2 = document.querySelector(t6);
            if (e2?.nodeType === Node.ELEMENT_NODE && e2?.isConnected) {
              e2?.focus();
              break;
            }
          }
        }
      }
    }, 0);
  }
  static getFirstFocusableElement(t4 = document, e) {
    const n = this.getFocusableElements(t4, e);
    return n.length > 0 ? n[0] : void 0;
  }
  static getFocusableElements(t4 = document, { anchorHref: e = true, ignoreClasses: n, ignoreElements: o2, parentHidden: i = false, selectors: a } = {}) {
    if (t4?.nodeType !== Node.ELEMENT_NODE && t4?.nodeType !== Node.DOCUMENT_NODE) throw new TypeError("'element' is not a HTMLElement, SVGElement, or Document instance.");
    if ("boolean" != typeof e) throw new TypeError("'anchorHref' is not a boolean.");
    if (void 0 !== n && !isIterable(n)) throw new TypeError("'ignoreClasses' is not an iterable list.");
    if (void 0 !== o2 && !CrossWindow.isSet(o2)) throw new TypeError("'ignoreElements' is not a Set.");
    if (void 0 !== a && "string" != typeof a) throw new TypeError("'selectors' is not a string.");
    const r2 = a ?? this.#g(e);
    let s2 = [...t4.querySelectorAll(r2)];
    return s2 = o2 && n ? s2.filter((t5) => {
      let e2 = false;
      for (const o3 of n) if (t5.classList.contains(o3)) {
        e2 = true;
        break;
      }
      return !(e2 || o2.has(t5) || "none" === t5.style.display || "hidden" === t5.style.visibility || t5.hasAttribute("disabled") || t5.hasAttribute("inert") || "true" === t5.getAttribute("aria-hidden"));
    }) : n ? s2.filter((t5) => {
      let e2 = false;
      for (const o3 of n) if (t5.classList.contains(o3)) {
        e2 = true;
        break;
      }
      return !e2 && "none" !== t5.style.display && "hidden" !== t5.style.visibility && !t5.hasAttribute("disabled") && !t5.hasAttribute("inert") && "true" !== t5.getAttribute("aria-hidden");
    }) : o2 ? s2.filter((t5) => !o2.has(t5) && "none" !== t5.style.display && "hidden" !== t5.style.visibility && !t5.hasAttribute("disabled") && !t5.hasAttribute("inert") && "true" !== t5.getAttribute("aria-hidden")) : s2.filter((t5) => "none" !== t5.style.display && "hidden" !== t5.style.visibility && !t5.hasAttribute("disabled") && !t5.hasAttribute("inert") && "true" !== t5.getAttribute("aria-hidden")), i && (s2 = s2.filter((e2) => !this.isParentHidden(e2, t4))), s2;
  }
  static #g(t4 = true) {
    return `button, [contenteditable=""], [contenteditable="true"], details summary:not([tabindex="-1"]), embed, a${t4 ? "[href]" : ""}, iframe, object, input:not([type=hidden]), select, textarea, [tabindex]:not([tabindex="-1"])`;
  }
  static getFocusSource({ event: t4, x: e, y: n, focusEl: o2, debug: i = false }) {
    if (void 0 !== o2 && !this.isFocusSource(o2)) throw new TypeError("A11yHelper.getFocusSource error: 'focusEl' is not a HTMLElement, SVGElement, or string.");
    if (void 0 !== i && "boolean" != typeof i) throw new TypeError("A11yHelper.getFocusSource error: 'debug' is not a boolean.");
    const a = "boolean" == typeof i ? this.debug || i : this.debug;
    if (void 0 === t4) {
      if ("number" != typeof e) throw new TypeError("A11yHelper.getFocusSource error: 'event' not defined and 'x' is not a number.");
      if ("number" != typeof n) throw new TypeError("A11yHelper.getFocusSource error: 'event' not defined and 'y' is not a number.");
      const t5 = { debug: i, focusEl: void 0 !== o2 ? [o2] : void 0, x: e, y: n };
      return t5;
    }
    if (void 0 !== t4 && !CrossWindow.isUserInputEvent(t4)) throw new TypeError("A11yHelper.getFocusSource error: 'event' is not a KeyboardEvent, MouseEvent, or PointerEvent.");
    if (void 0 !== e && !Number.isInteger(e)) throw new TypeError("A11yHelper.getFocusSource error: 'x' is not a number.");
    if (void 0 !== n && !Number.isInteger(n)) throw new TypeError("A11yHelper.getFocusSource error: 'y' is not a number.");
    let r2;
    if (t4 && (A11yHelper.isFocusable(t4.target) ? r2 = t4.target : A11yHelper.isFocusable(t4.currentTarget) ? r2 = t4.currentTarget : a && (t4.target, t4.currentTarget), r2 && r2?.nodeType !== Node.ELEMENT_NODE && "function" != typeof r2?.focus)) throw new TypeError("A11yHelper.getFocusSource error: 'targetEl' is not an HTMLElement or SVGElement.");
    const s2 = { debug: i };
    if (CrossWindow.isPointerEvent(t4)) if (2 !== t4?.button && "contextmenu" === t4.type) {
      const i2 = (r2 ?? t4.target).getBoundingClientRect();
      s2.source = "keyboard", s2.x = e ?? i2.left + i2.width / 2, s2.y = n ?? i2.top + i2.height / 2, s2.focusEl = r2 ? [r2] : [], o2 && s2.focusEl.push(o2);
    } else s2.source = "pointer", s2.x = e ?? t4.pageX, s2.y = n ?? t4.pageY, s2.focusEl = r2 ? [r2] : [], o2 && s2.focusEl.push(o2);
    else {
      const i2 = r2 ?? t4?.target;
      if (i2) {
        const t5 = i2.getBoundingClientRect();
        s2.source = "keyboard", s2.x = e ?? t5.left + t5.width / 2, s2.y = n ?? t5.top + t5.height / 2, s2.focusEl = r2 ? [r2] : [];
      }
      o2 && s2.focusEl.push(o2);
    }
    return s2;
  }
  static getLastFocusableElement(t4 = document, e) {
    const n = this.getFocusableElements(t4, e);
    return n.length > 0 ? n[n.length - 1] : void 0;
  }
  static isFocusable(t4, { anchorHref: e = true, ignoreClasses: n } = {}) {
    if (null == t4 || t4?.hidden || !t4?.isConnected || t4?.nodeType !== Node.ELEMENT_NODE || "function" != typeof t4?.focus) return false;
    if ("boolean" != typeof e) throw new TypeError("'anchorHref' is not a boolean.");
    if (void 0 !== n && !isIterable(n)) throw new TypeError("'ignoreClasses' is not an iterable list.");
    const o2 = t4.getAttribute("contenteditable"), i = "string" == typeof o2 && ("" === o2 || "true" === o2), a = globalThis.parseInt(t4.getAttribute("tabindex")), r2 = Number.isInteger(a) && a >= 0;
    return !!(i || r2 || CrossWindow.isFocusableHTMLElement(t4)) && (!(e && !r2 && CrossWindow.isHTMLAnchorElement(t4) && "string" != typeof t4.getAttribute("href")) && ("none" !== t4.style.display && "hidden" !== t4.style.visibility && !t4.hasAttribute("disabled") && !t4.hasAttribute("inert") && "true" !== t4.getAttribute("aria-hidden")));
  }
  static isFocusSource(t4) {
    return "string" == typeof t4 || t4?.nodeType === Node.ELEMENT_NODE && "function" == typeof t4?.focus;
  }
  static isFocusTarget(t4) {
    return null != t4 && t4?.nodeType === Node.ELEMENT_NODE && "function" == typeof t4?.focus;
  }
  static isFocusWithin(t4) {
    if (!isObject$1(t4) || t4?.hidden || !t4?.isConnected) return false;
    let e = CrossWindow.getActiveElement(t4);
    if (!e) return false;
    for (; e; ) {
      if (e === t4) return true;
      e = e.parentElement;
    }
    return false;
  }
  static isParentHidden(t4, e) {
    if (!CrossWindow.isElement(t4)) throw new TypeError("'element' is not an Element.");
    if (e = e ?? CrossWindow.getDocument(t4)?.body, !CrossWindow.isElement(e)) throw new TypeError("'stopElement' must be an Element.");
    let n = t4.parentElement;
    for (; n && n !== e; ) {
      if (0 === n.offsetWidth && 0 === n.offsetHeight) return true;
      n = n.parentElement;
    }
    return false;
  }
}
function clamp(t4 = 0, e = 0, n = 0) {
  return Math.min(Math.max(t4, e), n);
}
function degToRad(t4) {
  return t4 * (Math.PI / 180);
}
function radToDeg(t4) {
  return t4 * (180 / Math.PI);
}
function lerp(t4, e, n) {
  return (1 - n) * t4 + n * e;
}
var GLM_EPSILON = 1e-6, Mat4 = class t2 extends Float32Array {
  static #$ = new Float32Array([1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1]);
  static #b = new Float32Array(3);
  constructor(...e) {
    switch (e.length) {
      case 16:
        super(e);
        break;
      case 2:
        super(e[0], e[1], 16);
        break;
      case 1:
        const n = e[0];
        "number" == typeof n ? super([n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n]) : super(n, 0, 16);
        break;
      default:
        super(t2.#$);
    }
  }
  get str() {
    return t2.str(this);
  }
  copy(t4) {
    return this.set(t4), this;
  }
  identity() {
    return this.set(t2.#$), this;
  }
  multiply(e) {
    return t2.multiply(this, this, e);
  }
  mul(t4) {
    return this;
  }
  transpose() {
    return t2.transpose(this, this);
  }
  invert() {
    return t2.invert(this, this);
  }
  translate(e) {
    return t2.translate(this, this, e);
  }
  rotate(e, n) {
    return t2.rotate(this, this, e, n);
  }
  scale(e) {
    return t2.scale(this, this, e);
  }
  rotateX(e) {
    return t2.rotateX(this, this, e);
  }
  rotateY(e) {
    return t2.rotateY(this, this, e);
  }
  rotateZ(e) {
    return t2.rotateZ(this, this, e);
  }
  perspectiveNO(e, n, o2, i) {
    return t2.perspectiveNO(this, e, n, o2, i);
  }
  perspectiveZO(e, n, o2, i) {
    return t2.perspectiveZO(this, e, n, o2, i);
  }
  orthoNO(e, n, o2, i, a, r2) {
    return t2.orthoNO(this, e, n, o2, i, a, r2);
  }
  orthoZO(e, n, o2, i, a, r2) {
    return t2.orthoZO(this, e, n, o2, i, a, r2);
  }
  static get BYTE_LENGTH() {
    return 16 * Float32Array.BYTES_PER_ELEMENT;
  }
  static create() {
    return new t2();
  }
  static clone(e) {
    return new t2(e);
  }
  static copy(t4, e) {
    return t4[0] = e[0], t4[1] = e[1], t4[2] = e[2], t4[3] = e[3], t4[4] = e[4], t4[5] = e[5], t4[6] = e[6], t4[7] = e[7], t4[8] = e[8], t4[9] = e[9], t4[10] = e[10], t4[11] = e[11], t4[12] = e[12], t4[13] = e[13], t4[14] = e[14], t4[15] = e[15], t4;
  }
  static fromValues(...e) {
    return new t2(...e);
  }
  static set(t4, ...e) {
    return t4[0] = e[0], t4[1] = e[1], t4[2] = e[2], t4[3] = e[3], t4[4] = e[4], t4[5] = e[5], t4[6] = e[6], t4[7] = e[7], t4[8] = e[8], t4[9] = e[9], t4[10] = e[10], t4[11] = e[11], t4[12] = e[12], t4[13] = e[13], t4[14] = e[14], t4[15] = e[15], t4;
  }
  static identity(t4) {
    return t4[0] = 1, t4[1] = 0, t4[2] = 0, t4[3] = 0, t4[4] = 0, t4[5] = 1, t4[6] = 0, t4[7] = 0, t4[8] = 0, t4[9] = 0, t4[10] = 1, t4[11] = 0, t4[12] = 0, t4[13] = 0, t4[14] = 0, t4[15] = 1, t4;
  }
  static transpose(t4, e) {
    if (t4 === e) {
      const n = e[1], o2 = e[2], i = e[3], a = e[6], r2 = e[7], s2 = e[11];
      t4[1] = e[4], t4[2] = e[8], t4[3] = e[12], t4[4] = n, t4[6] = e[9], t4[7] = e[13], t4[8] = o2, t4[9] = a, t4[11] = e[14], t4[12] = i, t4[13] = r2, t4[14] = s2;
    } else t4[0] = e[0], t4[1] = e[4], t4[2] = e[8], t4[3] = e[12], t4[4] = e[1], t4[5] = e[5], t4[6] = e[9], t4[7] = e[13], t4[8] = e[2], t4[9] = e[6], t4[10] = e[10], t4[11] = e[14], t4[12] = e[3], t4[13] = e[7], t4[14] = e[11], t4[15] = e[15];
    return t4;
  }
  static invert(t4, e) {
    const n = e[0], o2 = e[1], i = e[2], a = e[3], r2 = e[4], s2 = e[5], c = e[6], l = e[7], u = e[8], p2 = e[9], d = e[10], m = e[11], f = e[12], _ = e[13], h = e[14], g2 = e[15], $2 = n * s2 - o2 * r2, b = n * c - i * r2, y = n * l - a * r2, v = o2 * c - i * s2, k = o2 * l - a * s2, w2 = i * l - a * c, S2 = u * _ - p2 * f, T = u * h - d * f, x2 = u * g2 - m * f, E = p2 * h - d * _, O = p2 * g2 - m * _, A2 = d * g2 - m * h;
    let C = $2 * A2 - b * O + y * E + v * x2 - k * T + w2 * S2;
    return C ? (C = 1 / C, t4[0] = (s2 * A2 - c * O + l * E) * C, t4[1] = (i * O - o2 * A2 - a * E) * C, t4[2] = (_ * w2 - h * k + g2 * v) * C, t4[3] = (d * k - p2 * w2 - m * v) * C, t4[4] = (c * x2 - r2 * A2 - l * T) * C, t4[5] = (n * A2 - i * x2 + a * T) * C, t4[6] = (h * y - f * w2 - g2 * b) * C, t4[7] = (u * w2 - d * y + m * b) * C, t4[8] = (r2 * O - s2 * x2 + l * S2) * C, t4[9] = (o2 * x2 - n * O - a * S2) * C, t4[10] = (f * k - _ * y + g2 * $2) * C, t4[11] = (p2 * y - u * k - m * $2) * C, t4[12] = (s2 * T - r2 * E - c * S2) * C, t4[13] = (n * E - o2 * T + i * S2) * C, t4[14] = (_ * b - f * v - h * $2) * C, t4[15] = (u * v - p2 * b + d * $2) * C, t4) : null;
  }
  static adjoint(t4, e) {
    const n = e[0], o2 = e[1], i = e[2], a = e[3], r2 = e[4], s2 = e[5], c = e[6], l = e[7], u = e[8], p2 = e[9], d = e[10], m = e[11], f = e[12], _ = e[13], h = e[14], g2 = e[15], $2 = n * s2 - o2 * r2, b = n * c - i * r2, y = n * l - a * r2, v = o2 * c - i * s2, k = o2 * l - a * s2, w2 = i * l - a * c, S2 = u * _ - p2 * f, T = u * h - d * f, x2 = u * g2 - m * f, E = p2 * h - d * _, O = p2 * g2 - m * _, A2 = d * g2 - m * h;
    return t4[0] = s2 * A2 - c * O + l * E, t4[1] = i * O - o2 * A2 - a * E, t4[2] = _ * w2 - h * k + g2 * v, t4[3] = d * k - p2 * w2 - m * v, t4[4] = c * x2 - r2 * A2 - l * T, t4[5] = n * A2 - i * x2 + a * T, t4[6] = h * y - f * w2 - g2 * b, t4[7] = u * w2 - d * y + m * b, t4[8] = r2 * O - s2 * x2 + l * S2, t4[9] = o2 * x2 - n * O - a * S2, t4[10] = f * k - _ * y + g2 * $2, t4[11] = p2 * y - u * k - m * $2, t4[12] = s2 * T - r2 * E - c * S2, t4[13] = n * E - o2 * T + i * S2, t4[14] = _ * b - f * v - h * $2, t4[15] = u * v - p2 * b + d * $2, t4;
  }
  static determinant(t4) {
    const e = t4[0], n = t4[1], o2 = t4[2], i = t4[3], a = t4[4], r2 = t4[5], s2 = t4[6], c = t4[7], l = t4[8], u = t4[9], p2 = t4[10], d = t4[11], m = t4[12], f = t4[13], _ = t4[14], h = e * r2 - n * a, g2 = e * s2 - o2 * a, $2 = n * s2 - o2 * r2, b = l * f - u * m, y = l * _ - p2 * m, v = u * _ - p2 * f;
    return c * (e * v - n * y + o2 * b) - i * (a * v - r2 * y + s2 * b) + t4[15] * (l * $2 - u * g2 + p2 * h) - d * (m * $2 - f * g2 + _ * h);
  }
  static multiply(t4, e, n) {
    const o2 = e[0], i = e[1], a = e[2], r2 = e[3], s2 = e[4], c = e[5], l = e[6], u = e[7], p2 = e[8], d = e[9], m = e[10], f = e[11], _ = e[12], h = e[13], g2 = e[14], $2 = e[15];
    let b = n[0], y = n[1], v = n[2], k = n[3];
    return t4[0] = b * o2 + y * s2 + v * p2 + k * _, t4[1] = b * i + y * c + v * d + k * h, t4[2] = b * a + y * l + v * m + k * g2, t4[3] = b * r2 + y * u + v * f + k * $2, b = n[4], y = n[5], v = n[6], k = n[7], t4[4] = b * o2 + y * s2 + v * p2 + k * _, t4[5] = b * i + y * c + v * d + k * h, t4[6] = b * a + y * l + v * m + k * g2, t4[7] = b * r2 + y * u + v * f + k * $2, b = n[8], y = n[9], v = n[10], k = n[11], t4[8] = b * o2 + y * s2 + v * p2 + k * _, t4[9] = b * i + y * c + v * d + k * h, t4[10] = b * a + y * l + v * m + k * g2, t4[11] = b * r2 + y * u + v * f + k * $2, b = n[12], y = n[13], v = n[14], k = n[15], t4[12] = b * o2 + y * s2 + v * p2 + k * _, t4[13] = b * i + y * c + v * d + k * h, t4[14] = b * a + y * l + v * m + k * g2, t4[15] = b * r2 + y * u + v * f + k * $2, t4;
  }
  static mul(t4, e, n) {
    return t4;
  }
  static translate(t4, e, n) {
    const o2 = n[0], i = n[1], a = n[2];
    if (e === t4) t4[12] = e[0] * o2 + e[4] * i + e[8] * a + e[12], t4[13] = e[1] * o2 + e[5] * i + e[9] * a + e[13], t4[14] = e[2] * o2 + e[6] * i + e[10] * a + e[14], t4[15] = e[3] * o2 + e[7] * i + e[11] * a + e[15];
    else {
      const n2 = e[0], r2 = e[1], s2 = e[2], c = e[3], l = e[4], u = e[5], p2 = e[6], d = e[7], m = e[8], f = e[9], _ = e[10], h = e[11];
      t4[0] = n2, t4[1] = r2, t4[2] = s2, t4[3] = c, t4[4] = l, t4[5] = u, t4[6] = p2, t4[7] = d, t4[8] = m, t4[9] = f, t4[10] = _, t4[11] = h, t4[12] = n2 * o2 + l * i + m * a + e[12], t4[13] = r2 * o2 + u * i + f * a + e[13], t4[14] = s2 * o2 + p2 * i + _ * a + e[14], t4[15] = c * o2 + d * i + h * a + e[15];
    }
    return t4;
  }
  static scale(t4, e, n) {
    const o2 = n[0], i = n[1], a = n[2];
    return t4[0] = e[0] * o2, t4[1] = e[1] * o2, t4[2] = e[2] * o2, t4[3] = e[3] * o2, t4[4] = e[4] * i, t4[5] = e[5] * i, t4[6] = e[6] * i, t4[7] = e[7] * i, t4[8] = e[8] * a, t4[9] = e[9] * a, t4[10] = e[10] * a, t4[11] = e[11] * a, t4[12] = e[12], t4[13] = e[13], t4[14] = e[14], t4[15] = e[15], t4;
  }
  static rotate(t4, e, n, o2) {
    let i = o2[0], a = o2[1], r2 = o2[2], s2 = Math.sqrt(i * i + a * a + r2 * r2);
    if (s2 < GLM_EPSILON) return null;
    s2 = 1 / s2, i *= s2, a *= s2, r2 *= s2;
    const c = Math.sin(n), l = Math.cos(n), u = 1 - l, p2 = e[0], d = e[1], m = e[2], f = e[3], _ = e[4], h = e[5], g2 = e[6], $2 = e[7], b = e[8], y = e[9], v = e[10], k = e[11], w2 = i * i * u + l, S2 = a * i * u + r2 * c, T = r2 * i * u - a * c, x2 = i * a * u - r2 * c, E = a * a * u + l, O = r2 * a * u + i * c, A2 = i * r2 * u + a * c, C = a * r2 * u - i * c, D = r2 * r2 * u + l;
    return t4[0] = p2 * w2 + _ * S2 + b * T, t4[1] = d * w2 + h * S2 + y * T, t4[2] = m * w2 + g2 * S2 + v * T, t4[3] = f * w2 + $2 * S2 + k * T, t4[4] = p2 * x2 + _ * E + b * O, t4[5] = d * x2 + h * E + y * O, t4[6] = m * x2 + g2 * E + v * O, t4[7] = f * x2 + $2 * E + k * O, t4[8] = p2 * A2 + _ * C + b * D, t4[9] = d * A2 + h * C + y * D, t4[10] = m * A2 + g2 * C + v * D, t4[11] = f * A2 + $2 * C + k * D, e !== t4 && (t4[12] = e[12], t4[13] = e[13], t4[14] = e[14], t4[15] = e[15]), t4;
  }
  static rotateX(t4, e, n) {
    const o2 = Math.sin(n), i = Math.cos(n), a = e[4], r2 = e[5], s2 = e[6], c = e[7], l = e[8], u = e[9], p2 = e[10], d = e[11];
    return e !== t4 && (t4[0] = e[0], t4[1] = e[1], t4[2] = e[2], t4[3] = e[3], t4[12] = e[12], t4[13] = e[13], t4[14] = e[14], t4[15] = e[15]), t4[4] = a * i + l * o2, t4[5] = r2 * i + u * o2, t4[6] = s2 * i + p2 * o2, t4[7] = c * i + d * o2, t4[8] = l * i - a * o2, t4[9] = u * i - r2 * o2, t4[10] = p2 * i - s2 * o2, t4[11] = d * i - c * o2, t4;
  }
  static rotateY(t4, e, n) {
    const o2 = Math.sin(n), i = Math.cos(n), a = e[0], r2 = e[1], s2 = e[2], c = e[3], l = e[8], u = e[9], p2 = e[10], d = e[11];
    return e !== t4 && (t4[4] = e[4], t4[5] = e[5], t4[6] = e[6], t4[7] = e[7], t4[12] = e[12], t4[13] = e[13], t4[14] = e[14], t4[15] = e[15]), t4[0] = a * i - l * o2, t4[1] = r2 * i - u * o2, t4[2] = s2 * i - p2 * o2, t4[3] = c * i - d * o2, t4[8] = a * o2 + l * i, t4[9] = r2 * o2 + u * i, t4[10] = s2 * o2 + p2 * i, t4[11] = c * o2 + d * i, t4;
  }
  static rotateZ(t4, e, n) {
    const o2 = Math.sin(n), i = Math.cos(n), a = e[0], r2 = e[1], s2 = e[2], c = e[3], l = e[4], u = e[5], p2 = e[6], d = e[7];
    return e !== t4 && (t4[8] = e[8], t4[9] = e[9], t4[10] = e[10], t4[11] = e[11], t4[12] = e[12], t4[13] = e[13], t4[14] = e[14], t4[15] = e[15]), t4[0] = a * i + l * o2, t4[1] = r2 * i + u * o2, t4[2] = s2 * i + p2 * o2, t4[3] = c * i + d * o2, t4[4] = l * i - a * o2, t4[5] = u * i - r2 * o2, t4[6] = p2 * i - s2 * o2, t4[7] = d * i - c * o2, t4;
  }
  static fromTranslation(t4, e) {
    return t4[0] = 1, t4[1] = 0, t4[2] = 0, t4[3] = 0, t4[4] = 0, t4[5] = 1, t4[6] = 0, t4[7] = 0, t4[8] = 0, t4[9] = 0, t4[10] = 1, t4[11] = 0, t4[12] = e[0], t4[13] = e[1], t4[14] = e[2], t4[15] = 1, t4;
  }
  static fromScaling(t4, e) {
    return t4[0] = e[0], t4[1] = 0, t4[2] = 0, t4[3] = 0, t4[4] = 0, t4[5] = e[1], t4[6] = 0, t4[7] = 0, t4[8] = 0, t4[9] = 0, t4[10] = e[2], t4[11] = 0, t4[12] = 0, t4[13] = 0, t4[14] = 0, t4[15] = 1, t4;
  }
  static fromRotation(t4, e, n) {
    let o2 = n[0], i = n[1], a = n[2], r2 = Math.sqrt(o2 * o2 + i * i + a * a);
    if (r2 < GLM_EPSILON) return null;
    r2 = 1 / r2, o2 *= r2, i *= r2, a *= r2;
    const s2 = Math.sin(e), c = Math.cos(e), l = 1 - c;
    return t4[0] = o2 * o2 * l + c, t4[1] = i * o2 * l + a * s2, t4[2] = a * o2 * l - i * s2, t4[3] = 0, t4[4] = o2 * i * l - a * s2, t4[5] = i * i * l + c, t4[6] = a * i * l + o2 * s2, t4[7] = 0, t4[8] = o2 * a * l + i * s2, t4[9] = i * a * l - o2 * s2, t4[10] = a * a * l + c, t4[11] = 0, t4[12] = 0, t4[13] = 0, t4[14] = 0, t4[15] = 1, t4;
  }
  static fromXRotation(t4, e) {
    const n = Math.sin(e), o2 = Math.cos(e);
    return t4[0] = 1, t4[1] = 0, t4[2] = 0, t4[3] = 0, t4[4] = 0, t4[5] = o2, t4[6] = n, t4[7] = 0, t4[8] = 0, t4[9] = -n, t4[10] = o2, t4[11] = 0, t4[12] = 0, t4[13] = 0, t4[14] = 0, t4[15] = 1, t4;
  }
  static fromYRotation(t4, e) {
    const n = Math.sin(e), o2 = Math.cos(e);
    return t4[0] = o2, t4[1] = 0, t4[2] = -n, t4[3] = 0, t4[4] = 0, t4[5] = 1, t4[6] = 0, t4[7] = 0, t4[8] = n, t4[9] = 0, t4[10] = o2, t4[11] = 0, t4[12] = 0, t4[13] = 0, t4[14] = 0, t4[15] = 1, t4;
  }
  static fromZRotation(t4, e) {
    const n = Math.sin(e), o2 = Math.cos(e);
    return t4[0] = o2, t4[1] = n, t4[2] = 0, t4[3] = 0, t4[4] = -n, t4[5] = o2, t4[6] = 0, t4[7] = 0, t4[8] = 0, t4[9] = 0, t4[10] = 1, t4[11] = 0, t4[12] = 0, t4[13] = 0, t4[14] = 0, t4[15] = 1, t4;
  }
  static fromRotationTranslation(t4, e, n) {
    const o2 = e[0], i = e[1], a = e[2], r2 = e[3], s2 = o2 + o2, c = i + i, l = a + a, u = o2 * s2, p2 = o2 * c, d = o2 * l, m = i * c, f = i * l, _ = a * l, h = r2 * s2, g2 = r2 * c, $2 = r2 * l;
    return t4[0] = 1 - (m + _), t4[1] = p2 + $2, t4[2] = d - g2, t4[3] = 0, t4[4] = p2 - $2, t4[5] = 1 - (u + _), t4[6] = f + h, t4[7] = 0, t4[8] = d + g2, t4[9] = f - h, t4[10] = 1 - (u + m), t4[11] = 0, t4[12] = n[0], t4[13] = n[1], t4[14] = n[2], t4[15] = 1, t4;
  }
  static fromQuat2(e, n) {
    const o2 = -n[0], i = -n[1], a = -n[2], r2 = n[3], s2 = n[4], c = n[5], l = n[6], u = n[7], p2 = o2 * o2 + i * i + a * a + r2 * r2;
    return p2 > 0 ? (t2.#b[0] = 2 * (s2 * r2 + u * o2 + c * a - l * i) / p2, t2.#b[1] = 2 * (c * r2 + u * i + l * o2 - s2 * a) / p2, t2.#b[2] = 2 * (l * r2 + u * a + s2 * i - c * o2) / p2) : (t2.#b[0] = 2 * (s2 * r2 + u * o2 + c * a - l * i), t2.#b[1] = 2 * (c * r2 + u * i + l * o2 - s2 * a), t2.#b[2] = 2 * (l * r2 + u * a + s2 * i - c * o2)), t2.fromRotationTranslation(e, n, t2.#b), e;
  }
  static normalFromMat4(t4, e) {
    const n = e[0], o2 = e[1], i = e[2], a = e[3], r2 = e[4], s2 = e[5], c = e[6], l = e[7], u = e[8], p2 = e[9], d = e[10], m = e[11], f = e[12], _ = e[13], h = e[14], g2 = e[15], $2 = n * s2 - o2 * r2, b = n * c - i * r2, y = n * l - a * r2, v = o2 * c - i * s2, k = o2 * l - a * s2, w2 = i * l - a * c, S2 = u * _ - p2 * f, T = u * h - d * f, x2 = u * g2 - m * f, E = p2 * h - d * _, O = p2 * g2 - m * _, A2 = d * g2 - m * h;
    let C = $2 * A2 - b * O + y * E + v * x2 - k * T + w2 * S2;
    return C ? (C = 1 / C, t4[0] = (s2 * A2 - c * O + l * E) * C, t4[1] = (c * x2 - r2 * A2 - l * T) * C, t4[2] = (r2 * O - s2 * x2 + l * S2) * C, t4[3] = 0, t4[4] = (i * O - o2 * A2 - a * E) * C, t4[5] = (n * A2 - i * x2 + a * T) * C, t4[6] = (o2 * x2 - n * O - a * S2) * C, t4[7] = 0, t4[8] = (_ * w2 - h * k + g2 * v) * C, t4[9] = (h * y - f * w2 - g2 * b) * C, t4[10] = (f * k - _ * y + g2 * $2) * C, t4[11] = 0, t4[12] = 0, t4[13] = 0, t4[14] = 0, t4[15] = 1, t4) : null;
  }
  static normalFromMat4Fast(t4, e) {
    const n = e[0], o2 = e[1], i = e[2], a = e[4], r2 = e[5], s2 = e[6], c = e[8], l = e[9], u = e[10];
    return t4[0] = r2 * u - u * l, t4[1] = s2 * c - c * u, t4[2] = a * l - l * c, t4[3] = 0, t4[4] = l * i - u * o2, t4[5] = u * n - c * i, t4[6] = c * o2 - l * n, t4[7] = 0, t4[8] = o2 * s2 - i * r2, t4[9] = i * a - n * s2, t4[10] = n * r2 - o2 * a, t4[11] = 0, t4[12] = 0, t4[13] = 0, t4[14] = 0, t4[15] = 1, t4;
  }
  static getTranslation(t4, e) {
    return t4[0] = e[12], t4[1] = e[13], t4[2] = e[14], t4;
  }
  static getScaling(t4, e) {
    const n = e[0], o2 = e[1], i = e[2], a = e[4], r2 = e[5], s2 = e[6], c = e[8], l = e[9], u = e[10];
    return t4[0] = Math.sqrt(n * n + o2 * o2 + i * i), t4[1] = Math.sqrt(a * a + r2 * r2 + s2 * s2), t4[2] = Math.sqrt(c * c + l * l + u * u), t4;
  }
  static getRotation(e, n) {
    t2.getScaling(t2.#b, n);
    const o2 = 1 / t2.#b[0], i = 1 / t2.#b[1], a = 1 / t2.#b[2], r2 = n[0] * o2, s2 = n[1] * i, c = n[2] * a, l = n[4] * o2, u = n[5] * i, p2 = n[6] * a, d = n[8] * o2, m = n[9] * i, f = n[10] * a, _ = r2 + u + f;
    let h = 0;
    return _ > 0 ? (h = 2 * Math.sqrt(_ + 1), e[3] = 0.25 * h, e[0] = (p2 - m) / h, e[1] = (d - c) / h, e[2] = (s2 - l) / h) : r2 > u && r2 > f ? (h = 2 * Math.sqrt(1 + r2 - u - f), e[3] = (p2 - m) / h, e[0] = 0.25 * h, e[1] = (s2 + l) / h, e[2] = (d + c) / h) : u > f ? (h = 2 * Math.sqrt(1 + u - r2 - f), e[3] = (d - c) / h, e[0] = (s2 + l) / h, e[1] = 0.25 * h, e[2] = (p2 + m) / h) : (h = 2 * Math.sqrt(1 + f - r2 - u), e[3] = (s2 - l) / h, e[0] = (d + c) / h, e[1] = (p2 + m) / h, e[2] = 0.25 * h), e;
  }
  static decompose(t4, e, n, o2) {
    e[0] = o2[12], e[1] = o2[13], e[2] = o2[14];
    const i = o2[0], a = o2[1], r2 = o2[2], s2 = o2[4], c = o2[5], l = o2[6], u = o2[8], p2 = o2[9], d = o2[10];
    n[0] = Math.sqrt(i * i + a * a + r2 * r2), n[1] = Math.sqrt(s2 * s2 + c * c + l * l), n[2] = Math.sqrt(u * u + p2 * p2 + d * d);
    const m = 1 / n[0], f = 1 / n[1], _ = 1 / n[2], h = i * m, g2 = a * f, $2 = r2 * _, b = s2 * m, y = c * f, v = l * _, k = u * m, w2 = p2 * f, S2 = d * _, T = h + y + S2;
    let x2 = 0;
    return T > 0 ? (x2 = 2 * Math.sqrt(T + 1), t4[3] = 0.25 * x2, t4[0] = (v - w2) / x2, t4[1] = (k - $2) / x2, t4[2] = (g2 - b) / x2) : h > y && h > S2 ? (x2 = 2 * Math.sqrt(1 + h - y - S2), t4[3] = (v - w2) / x2, t4[0] = 0.25 * x2, t4[1] = (g2 + b) / x2, t4[2] = (k + $2) / x2) : y > S2 ? (x2 = 2 * Math.sqrt(1 + y - h - S2), t4[3] = (k - $2) / x2, t4[0] = (g2 + b) / x2, t4[1] = 0.25 * x2, t4[2] = (v + w2) / x2) : (x2 = 2 * Math.sqrt(1 + S2 - h - y), t4[3] = (g2 - b) / x2, t4[0] = (k + $2) / x2, t4[1] = (v + w2) / x2, t4[2] = 0.25 * x2), t4;
  }
  static fromRotationTranslationScale(t4, e, n, o2) {
    const i = e[0], a = e[1], r2 = e[2], s2 = e[3], c = i + i, l = a + a, u = r2 + r2, p2 = i * c, d = i * l, m = i * u, f = a * l, _ = a * u, h = r2 * u, g2 = s2 * c, $2 = s2 * l, b = s2 * u, y = o2[0], v = o2[1], k = o2[2];
    return t4[0] = (1 - (f + h)) * y, t4[1] = (d + b) * y, t4[2] = (m - $2) * y, t4[3] = 0, t4[4] = (d - b) * v, t4[5] = (1 - (p2 + h)) * v, t4[6] = (_ + g2) * v, t4[7] = 0, t4[8] = (m + $2) * k, t4[9] = (_ - g2) * k, t4[10] = (1 - (p2 + f)) * k, t4[11] = 0, t4[12] = n[0], t4[13] = n[1], t4[14] = n[2], t4[15] = 1, t4;
  }
  static fromRotationTranslationScaleOrigin(t4, e, n, o2, i) {
    const a = e[0], r2 = e[1], s2 = e[2], c = e[3], l = a + a, u = r2 + r2, p2 = s2 + s2, d = a * l, m = a * u, f = a * p2, _ = r2 * u, h = r2 * p2, g2 = s2 * p2, $2 = c * l, b = c * u, y = c * p2, v = o2[0], k = o2[1], w2 = o2[2], S2 = i[0], T = i[1], x2 = i[2], E = (1 - (_ + g2)) * v, O = (m + y) * v, A2 = (f - b) * v, C = (m - y) * k, D = (1 - (d + g2)) * k, M = (h + $2) * k, j = (f + b) * w2, I = (h - $2) * w2, N = (1 - (d + _)) * w2;
    return t4[0] = E, t4[1] = O, t4[2] = A2, t4[3] = 0, t4[4] = C, t4[5] = D, t4[6] = M, t4[7] = 0, t4[8] = j, t4[9] = I, t4[10] = N, t4[11] = 0, t4[12] = n[0] + S2 - (E * S2 + C * T + j * x2), t4[13] = n[1] + T - (O * S2 + D * T + I * x2), t4[14] = n[2] + x2 - (A2 * S2 + M * T + N * x2), t4[15] = 1, t4;
  }
  static fromQuat(t4, e) {
    const n = e[0], o2 = e[1], i = e[2], a = e[3], r2 = n + n, s2 = o2 + o2, c = i + i, l = n * r2, u = o2 * r2, p2 = o2 * s2, d = i * r2, m = i * s2, f = i * c, _ = a * r2, h = a * s2, g2 = a * c;
    return t4[0] = 1 - p2 - f, t4[1] = u + g2, t4[2] = d - h, t4[3] = 0, t4[4] = u - g2, t4[5] = 1 - l - f, t4[6] = m + _, t4[7] = 0, t4[8] = d + h, t4[9] = m - _, t4[10] = 1 - l - p2, t4[11] = 0, t4[12] = 0, t4[13] = 0, t4[14] = 0, t4[15] = 1, t4;
  }
  static frustumNO(t4, e, n, o2, i, a, r2 = 1 / 0) {
    const s2 = 1 / (n - e), c = 1 / (i - o2);
    if (t4[0] = 2 * a * s2, t4[1] = 0, t4[2] = 0, t4[3] = 0, t4[4] = 0, t4[5] = 2 * a * c, t4[6] = 0, t4[7] = 0, t4[8] = (n + e) * s2, t4[9] = (i + o2) * c, t4[11] = -1, t4[12] = 0, t4[13] = 0, t4[15] = 0, null != r2 && r2 !== 1 / 0) {
      const e2 = 1 / (a - r2);
      t4[10] = (r2 + a) * e2, t4[14] = 2 * r2 * a * e2;
    } else t4[10] = -1, t4[14] = -2 * a;
    return t4;
  }
  static frustum(t4, e, n, o2, i, a, r2 = 1 / 0) {
    return t4;
  }
  static frustumZO(t4, e, n, o2, i, a, r2 = 1 / 0) {
    const s2 = 1 / (n - e), c = 1 / (i - o2);
    if (t4[0] = 2 * a * s2, t4[1] = 0, t4[2] = 0, t4[3] = 0, t4[4] = 0, t4[5] = 2 * a * c, t4[6] = 0, t4[7] = 0, t4[8] = (n + e) * s2, t4[9] = (i + o2) * c, t4[11] = -1, t4[12] = 0, t4[13] = 0, t4[15] = 0, null != r2 && r2 !== 1 / 0) {
      const e2 = 1 / (a - r2);
      t4[10] = r2 * e2, t4[14] = r2 * a * e2;
    } else t4[10] = -1, t4[14] = -a;
    return t4;
  }
  static perspectiveNO(t4, e, n, o2, i = 1 / 0) {
    const a = 1 / Math.tan(e / 2);
    if (t4[0] = a / n, t4[1] = 0, t4[2] = 0, t4[3] = 0, t4[4] = 0, t4[5] = a, t4[6] = 0, t4[7] = 0, t4[8] = 0, t4[9] = 0, t4[11] = -1, t4[12] = 0, t4[13] = 0, t4[15] = 0, null != i && i !== 1 / 0) {
      const e2 = 1 / (o2 - i);
      t4[10] = (i + o2) * e2, t4[14] = 2 * i * o2 * e2;
    } else t4[10] = -1, t4[14] = -2 * o2;
    return t4;
  }
  static perspective(t4, e, n, o2, i = 1 / 0) {
    return t4;
  }
  static perspectiveZO(t4, e, n, o2, i = 1 / 0) {
    const a = 1 / Math.tan(e / 2);
    if (t4[0] = a / n, t4[1] = 0, t4[2] = 0, t4[3] = 0, t4[4] = 0, t4[5] = a, t4[6] = 0, t4[7] = 0, t4[8] = 0, t4[9] = 0, t4[11] = -1, t4[12] = 0, t4[13] = 0, t4[15] = 0, null != i && i !== 1 / 0) {
      const e2 = 1 / (o2 - i);
      t4[10] = i * e2, t4[14] = i * o2 * e2;
    } else t4[10] = -1, t4[14] = -o2;
    return t4;
  }
  static perspectiveFromFieldOfView(t4, e, n, o2) {
    const i = Math.tan(e.upDegrees * Math.PI / 180), a = Math.tan(e.downDegrees * Math.PI / 180), r2 = Math.tan(e.leftDegrees * Math.PI / 180), s2 = Math.tan(e.rightDegrees * Math.PI / 180), c = 2 / (r2 + s2), l = 2 / (i + a);
    return t4[0] = c, t4[1] = 0, t4[2] = 0, t4[3] = 0, t4[4] = 0, t4[5] = l, t4[6] = 0, t4[7] = 0, t4[8] = -(r2 - s2) * c * 0.5, t4[9] = (i - a) * l * 0.5, t4[10] = o2 / (n - o2), t4[11] = -1, t4[12] = 0, t4[13] = 0, t4[14] = o2 * n / (n - o2), t4[15] = 0, t4;
  }
  static orthoNO(t4, e, n, o2, i, a, r2) {
    const s2 = 1 / (e - n), c = 1 / (o2 - i), l = 1 / (a - r2);
    return t4[0] = -2 * s2, t4[1] = 0, t4[2] = 0, t4[3] = 0, t4[4] = 0, t4[5] = -2 * c, t4[6] = 0, t4[7] = 0, t4[8] = 0, t4[9] = 0, t4[10] = 2 * l, t4[11] = 0, t4[12] = (e + n) * s2, t4[13] = (i + o2) * c, t4[14] = (r2 + a) * l, t4[15] = 1, t4;
  }
  static ortho(t4, e, n, o2, i, a, r2) {
    return t4;
  }
  static orthoZO(t4, e, n, o2, i, a, r2) {
    const s2 = 1 / (e - n), c = 1 / (o2 - i), l = 1 / (a - r2);
    return t4[0] = -2 * s2, t4[1] = 0, t4[2] = 0, t4[3] = 0, t4[4] = 0, t4[5] = -2 * c, t4[6] = 0, t4[7] = 0, t4[8] = 0, t4[9] = 0, t4[10] = l, t4[11] = 0, t4[12] = (e + n) * s2, t4[13] = (i + o2) * c, t4[14] = a * l, t4[15] = 1, t4;
  }
  static lookAt(e, n, o2, i) {
    const a = n[0], r2 = n[1], s2 = n[2], c = i[0], l = i[1], u = i[2], p2 = o2[0], d = o2[1], m = o2[2];
    if (Math.abs(a - p2) < GLM_EPSILON && Math.abs(r2 - d) < GLM_EPSILON && Math.abs(s2 - m) < GLM_EPSILON) return t2.identity(e);
    let f = a - p2, _ = r2 - d, h = s2 - m, g2 = 1 / Math.sqrt(f * f + _ * _ + h * h);
    f *= g2, _ *= g2, h *= g2;
    let $2 = l * h - u * _, b = u * f - c * h, y = c * _ - l * f;
    g2 = Math.sqrt($2 * $2 + b * b + y * y), g2 ? (g2 = 1 / g2, $2 *= g2, b *= g2, y *= g2) : ($2 = 0, b = 0, y = 0);
    let v = _ * y - h * b, k = h * $2 - f * y, w2 = f * b - _ * $2;
    return g2 = Math.sqrt(v * v + k * k + w2 * w2), g2 ? (g2 = 1 / g2, v *= g2, k *= g2, w2 *= g2) : (v = 0, k = 0, w2 = 0), e[0] = $2, e[1] = v, e[2] = f, e[3] = 0, e[4] = b, e[5] = k, e[6] = _, e[7] = 0, e[8] = y, e[9] = w2, e[10] = h, e[11] = 0, e[12] = -($2 * a + b * r2 + y * s2), e[13] = -(v * a + k * r2 + w2 * s2), e[14] = -(f * a + _ * r2 + h * s2), e[15] = 1, e;
  }
  static targetTo(t4, e, n, o2) {
    const i = e[0], a = e[1], r2 = e[2], s2 = o2[0], c = o2[1], l = o2[2];
    let u = i - n[0], p2 = a - n[1], d = r2 - n[2], m = u * u + p2 * p2 + d * d;
    m > 0 && (m = 1 / Math.sqrt(m), u *= m, p2 *= m, d *= m);
    let f = c * d - l * p2, _ = l * u - s2 * d, h = s2 * p2 - c * u;
    return m = f * f + _ * _ + h * h, m > 0 && (m = 1 / Math.sqrt(m), f *= m, _ *= m, h *= m), t4[0] = f, t4[1] = _, t4[2] = h, t4[3] = 0, t4[4] = p2 * h - d * _, t4[5] = d * f - u * h, t4[6] = u * _ - p2 * f, t4[7] = 0, t4[8] = u, t4[9] = p2, t4[10] = d, t4[11] = 0, t4[12] = i, t4[13] = a, t4[14] = r2, t4[15] = 1, t4;
  }
  static frob(t4) {
    return Math.sqrt(t4[0] * t4[0] + t4[1] * t4[1] + t4[2] * t4[2] + t4[3] * t4[3] + t4[4] * t4[4] + t4[5] * t4[5] + t4[6] * t4[6] + t4[7] * t4[7] + t4[8] * t4[8] + t4[9] * t4[9] + t4[10] * t4[10] + t4[11] * t4[11] + t4[12] * t4[12] + t4[13] * t4[13] + t4[14] * t4[14] + t4[15] * t4[15]);
  }
  static add(t4, e, n) {
    return t4[0] = e[0] + n[0], t4[1] = e[1] + n[1], t4[2] = e[2] + n[2], t4[3] = e[3] + n[3], t4[4] = e[4] + n[4], t4[5] = e[5] + n[5], t4[6] = e[6] + n[6], t4[7] = e[7] + n[7], t4[8] = e[8] + n[8], t4[9] = e[9] + n[9], t4[10] = e[10] + n[10], t4[11] = e[11] + n[11], t4[12] = e[12] + n[12], t4[13] = e[13] + n[13], t4[14] = e[14] + n[14], t4[15] = e[15] + n[15], t4;
  }
  static subtract(t4, e, n) {
    return t4[0] = e[0] - n[0], t4[1] = e[1] - n[1], t4[2] = e[2] - n[2], t4[3] = e[3] - n[3], t4[4] = e[4] - n[4], t4[5] = e[5] - n[5], t4[6] = e[6] - n[6], t4[7] = e[7] - n[7], t4[8] = e[8] - n[8], t4[9] = e[9] - n[9], t4[10] = e[10] - n[10], t4[11] = e[11] - n[11], t4[12] = e[12] - n[12], t4[13] = e[13] - n[13], t4[14] = e[14] - n[14], t4[15] = e[15] - n[15], t4;
  }
  static sub(t4, e, n) {
    return t4;
  }
  static multiplyScalar(t4, e, n) {
    return t4[0] = e[0] * n, t4[1] = e[1] * n, t4[2] = e[2] * n, t4[3] = e[3] * n, t4[4] = e[4] * n, t4[5] = e[5] * n, t4[6] = e[6] * n, t4[7] = e[7] * n, t4[8] = e[8] * n, t4[9] = e[9] * n, t4[10] = e[10] * n, t4[11] = e[11] * n, t4[12] = e[12] * n, t4[13] = e[13] * n, t4[14] = e[14] * n, t4[15] = e[15] * n, t4;
  }
  static multiplyScalarAndAdd(t4, e, n, o2) {
    return t4[0] = e[0] + n[0] * o2, t4[1] = e[1] + n[1] * o2, t4[2] = e[2] + n[2] * o2, t4[3] = e[3] + n[3] * o2, t4[4] = e[4] + n[4] * o2, t4[5] = e[5] + n[5] * o2, t4[6] = e[6] + n[6] * o2, t4[7] = e[7] + n[7] * o2, t4[8] = e[8] + n[8] * o2, t4[9] = e[9] + n[9] * o2, t4[10] = e[10] + n[10] * o2, t4[11] = e[11] + n[11] * o2, t4[12] = e[12] + n[12] * o2, t4[13] = e[13] + n[13] * o2, t4[14] = e[14] + n[14] * o2, t4[15] = e[15] + n[15] * o2, t4;
  }
  static exactEquals(t4, e) {
    return t4[0] === e[0] && t4[1] === e[1] && t4[2] === e[2] && t4[3] === e[3] && t4[4] === e[4] && t4[5] === e[5] && t4[6] === e[6] && t4[7] === e[7] && t4[8] === e[8] && t4[9] === e[9] && t4[10] === e[10] && t4[11] === e[11] && t4[12] === e[12] && t4[13] === e[13] && t4[14] === e[14] && t4[15] === e[15];
  }
  static equals(t4, e) {
    const n = t4[0], o2 = t4[1], i = t4[2], a = t4[3], r2 = t4[4], s2 = t4[5], c = t4[6], l = t4[7], u = t4[8], p2 = t4[9], d = t4[10], m = t4[11], f = t4[12], _ = t4[13], h = t4[14], g2 = t4[15], $2 = e[0], b = e[1], y = e[2], v = e[3], k = e[4], w2 = e[5], S2 = e[6], T = e[7], x2 = e[8], E = e[9], O = e[10], A2 = e[11], C = e[12], D = e[13], M = e[14], j = e[15];
    return Math.abs(n - $2) <= GLM_EPSILON * Math.max(1, Math.abs(n), Math.abs($2)) && Math.abs(o2 - b) <= GLM_EPSILON * Math.max(1, Math.abs(o2), Math.abs(b)) && Math.abs(i - y) <= GLM_EPSILON * Math.max(1, Math.abs(i), Math.abs(y)) && Math.abs(a - v) <= GLM_EPSILON * Math.max(1, Math.abs(a), Math.abs(v)) && Math.abs(r2 - k) <= GLM_EPSILON * Math.max(1, Math.abs(r2), Math.abs(k)) && Math.abs(s2 - w2) <= GLM_EPSILON * Math.max(1, Math.abs(s2), Math.abs(w2)) && Math.abs(c - S2) <= GLM_EPSILON * Math.max(1, Math.abs(c), Math.abs(S2)) && Math.abs(l - T) <= GLM_EPSILON * Math.max(1, Math.abs(l), Math.abs(T)) && Math.abs(u - x2) <= GLM_EPSILON * Math.max(1, Math.abs(u), Math.abs(x2)) && Math.abs(p2 - E) <= GLM_EPSILON * Math.max(1, Math.abs(p2), Math.abs(E)) && Math.abs(d - O) <= GLM_EPSILON * Math.max(1, Math.abs(d), Math.abs(O)) && Math.abs(m - A2) <= GLM_EPSILON * Math.max(1, Math.abs(m), Math.abs(A2)) && Math.abs(f - C) <= GLM_EPSILON * Math.max(1, Math.abs(f), Math.abs(C)) && Math.abs(_ - D) <= GLM_EPSILON * Math.max(1, Math.abs(_), Math.abs(D)) && Math.abs(h - M) <= GLM_EPSILON * Math.max(1, Math.abs(h), Math.abs(M)) && Math.abs(g2 - j) <= GLM_EPSILON * Math.max(1, Math.abs(g2), Math.abs(j));
  }
  static str(t4) {
    return `Mat4(${t4.join(", ")})`;
  }
};
Mat4.prototype.mul = Mat4.prototype.multiply, Mat4.sub = Mat4.subtract, Mat4.mul = Mat4.multiply, Mat4.frustum = Mat4.frustumNO, Mat4.perspective = Mat4.perspectiveNO, Mat4.ortho = Mat4.orthoNO;
var Vec3 = class t3 extends Float32Array {
  constructor(...t4) {
    switch (t4.length) {
      case 3:
        super(t4);
        break;
      case 2:
        super(t4[0], t4[1], 3);
        break;
      case 1: {
        const e = t4[0];
        "number" == typeof e ? super([e, e, e]) : super(e, 0, 3);
        break;
      }
      default:
        super(3);
    }
  }
  get x() {
    return this[0];
  }
  set x(t4) {
    this[0] = t4;
  }
  get y() {
    return this[1];
  }
  set y(t4) {
    this[1] = t4;
  }
  get z() {
    return this[2];
  }
  set z(t4) {
    this[2] = t4;
  }
  get r() {
    return this[0];
  }
  set r(t4) {
    this[0] = t4;
  }
  get g() {
    return this[1];
  }
  set g(t4) {
    this[1] = t4;
  }
  get b() {
    return this[2];
  }
  set b(t4) {
    this[2] = t4;
  }
  get magnitude() {
    const t4 = this[0], e = this[1], n = this[2];
    return Math.sqrt(t4 * t4 + e * e + n * n);
  }
  get mag() {
    return this.magnitude;
  }
  get squaredMagnitude() {
    const t4 = this[0], e = this[1], n = this[2];
    return t4 * t4 + e * e + n * n;
  }
  get sqrMag() {
    return this.squaredMagnitude;
  }
  get str() {
    return t3.str(this);
  }
  copy(t4) {
    return this.set(t4), this;
  }
  add(t4) {
    return this[0] += t4[0], this[1] += t4[1], this[2] += t4[2], this;
  }
  subtract(t4) {
    return this[0] -= t4[0], this[1] -= t4[1], this[2] -= t4[2], this;
  }
  sub(t4) {
    return this;
  }
  multiply(t4) {
    return this[0] *= t4[0], this[1] *= t4[1], this[2] *= t4[2], this;
  }
  mul(t4) {
    return this;
  }
  divide(t4) {
    return this[0] /= t4[0], this[1] /= t4[1], this[2] /= t4[2], this;
  }
  div(t4) {
    return this;
  }
  scale(t4) {
    return this[0] *= t4, this[1] *= t4, this[2] *= t4, this;
  }
  scaleAndAdd(t4, e) {
    return this[0] += t4[0] * e, this[1] += t4[1] * e, this[2] += t4[2] * e, this;
  }
  distance(e) {
    return t3.distance(this, e);
  }
  dist(t4) {
    return 0;
  }
  squaredDistance(e) {
    return t3.squaredDistance(this, e);
  }
  sqrDist(t4) {
    return 0;
  }
  negate() {
    return this[0] *= -1, this[1] *= -1, this[2] *= -1, this;
  }
  invert() {
    return this[0] = 1 / this[0], this[1] = 1 / this[1], this[2] = 1 / this[2], this;
  }
  abs() {
    return this[0] = Math.abs(this[0]), this[1] = Math.abs(this[1]), this[2] = Math.abs(this[2]), this;
  }
  dot(t4) {
    return this[0] * t4[0] + this[1] * t4[1] + this[2] * t4[2];
  }
  normalize() {
    return t3.normalize(this, this);
  }
  static get BYTE_LENGTH() {
    return 3 * Float32Array.BYTES_PER_ELEMENT;
  }
  static create() {
    return new t3();
  }
  static clone(e) {
    return new t3(e);
  }
  static magnitude(t4) {
    const e = t4[0], n = t4[1], o2 = t4[2];
    return Math.sqrt(e * e + n * n + o2 * o2);
  }
  static mag(t4) {
    return 0;
  }
  static length(t4) {
    return 0;
  }
  static len(t4) {
    return 0;
  }
  static fromValues(e, n, o2) {
    return new t3(e, n, o2);
  }
  static copy(t4, e) {
    return t4[0] = e[0], t4[1] = e[1], t4[2] = e[2], t4;
  }
  static set(t4, e, n, o2) {
    return t4[0] = e, t4[1] = n, t4[2] = o2, t4;
  }
  static add(t4, e, n) {
    return t4[0] = e[0] + n[0], t4[1] = e[1] + n[1], t4[2] = e[2] + n[2], t4;
  }
  static subtract(t4, e, n) {
    return t4[0] = e[0] - n[0], t4[1] = e[1] - n[1], t4[2] = e[2] - n[2], t4;
  }
  static sub(t4, e, n) {
    return [0, 0, 0];
  }
  static multiply(t4, e, n) {
    return t4[0] = e[0] * n[0], t4[1] = e[1] * n[1], t4[2] = e[2] * n[2], t4;
  }
  static mul(t4, e, n) {
    return [0, 0, 0];
  }
  static divide(t4, e, n) {
    return t4[0] = e[0] / n[0], t4[1] = e[1] / n[1], t4[2] = e[2] / n[2], t4;
  }
  static div(t4, e, n) {
    return [0, 0, 0];
  }
  static ceil(t4, e) {
    return t4[0] = Math.ceil(e[0]), t4[1] = Math.ceil(e[1]), t4[2] = Math.ceil(e[2]), t4;
  }
  static floor(t4, e) {
    return t4[0] = Math.floor(e[0]), t4[1] = Math.floor(e[1]), t4[2] = Math.floor(e[2]), t4;
  }
  static min(t4, e, n) {
    return t4[0] = Math.min(e[0], n[0]), t4[1] = Math.min(e[1], n[1]), t4[2] = Math.min(e[2], n[2]), t4;
  }
  static max(t4, e, n) {
    return t4[0] = Math.max(e[0], n[0]), t4[1] = Math.max(e[1], n[1]), t4[2] = Math.max(e[2], n[2]), t4;
  }
  static scale(t4, e, n) {
    return t4[0] = e[0] * n, t4[1] = e[1] * n, t4[2] = e[2] * n, t4;
  }
  static scaleAndAdd(t4, e, n, o2) {
    return t4[0] = e[0] + n[0] * o2, t4[1] = e[1] + n[1] * o2, t4[2] = e[2] + n[2] * o2, t4;
  }
  static distance(t4, e) {
    const n = e[0] - t4[0], o2 = e[1] - t4[1], i = e[2] - t4[2];
    return Math.sqrt(n * n + o2 * o2 + i * i);
  }
  static dist(t4, e) {
    return 0;
  }
  static squaredDistance(t4, e) {
    const n = e[0] - t4[0], o2 = e[1] - t4[1], i = e[2] - t4[2];
    return n * n + o2 * o2 + i * i;
  }
  static sqrDist(t4, e) {
    return 0;
  }
  static squaredLength(t4) {
    const e = t4[0], n = t4[1], o2 = t4[2];
    return e * e + n * n + o2 * o2;
  }
  static sqrLen(t4, e) {
    return 0;
  }
  static negate(t4, e) {
    return t4[0] = -e[0], t4[1] = -e[1], t4[2] = -e[2], t4;
  }
  static inverse(t4, e) {
    return t4[0] = 1 / e[0], t4[1] = 1 / e[1], t4[2] = 1 / e[2], t4;
  }
  static abs(t4, e) {
    return t4[0] = Math.abs(e[0]), t4[1] = Math.abs(e[1]), t4[2] = Math.abs(e[2]), t4;
  }
  static normalize(t4, e) {
    const n = e[0], o2 = e[1], i = e[2];
    let a = n * n + o2 * o2 + i * i;
    return a > 0 && (a = 1 / Math.sqrt(a)), t4[0] = e[0] * a, t4[1] = e[1] * a, t4[2] = e[2] * a, t4;
  }
  static dot(t4, e) {
    return t4[0] * e[0] + t4[1] * e[1] + t4[2] * e[2];
  }
  static cross(t4, e, n) {
    const o2 = e[0], i = e[1], a = e[2], r2 = n[0], s2 = n[1], c = n[2];
    return t4[0] = i * c - a * s2, t4[1] = a * r2 - o2 * c, t4[2] = o2 * s2 - i * r2, t4;
  }
  static lerp(t4, e, n, o2) {
    const i = e[0], a = e[1], r2 = e[2];
    return t4[0] = i + o2 * (n[0] - i), t4[1] = a + o2 * (n[1] - a), t4[2] = r2 + o2 * (n[2] - r2), t4;
  }
  static slerp(e, n, o2, i) {
    const a = Math.acos(Math.min(Math.max(t3.dot(n, o2), -1), 1)), r2 = Math.sin(a), s2 = Math.sin((1 - i) * a) / r2, c = Math.sin(i * a) / r2;
    return e[0] = s2 * n[0] + c * o2[0], e[1] = s2 * n[1] + c * o2[1], e[2] = s2 * n[2] + c * o2[2], e;
  }
  static hermite(t4, e, n, o2, i, a) {
    const r2 = a * a, s2 = r2 * (2 * a - 3) + 1, c = r2 * (a - 2) + a, l = r2 * (a - 1), u = r2 * (3 - 2 * a);
    return t4[0] = e[0] * s2 + n[0] * c + o2[0] * l + i[0] * u, t4[1] = e[1] * s2 + n[1] * c + o2[1] * l + i[1] * u, t4[2] = e[2] * s2 + n[2] * c + o2[2] * l + i[2] * u, t4;
  }
  static bezier(t4, e, n, o2, i, a) {
    const r2 = 1 - a, s2 = r2 * r2, c = a * a, l = s2 * r2, u = 3 * a * s2, p2 = 3 * c * r2, d = c * a;
    return t4[0] = e[0] * l + n[0] * u + o2[0] * p2 + i[0] * d, t4[1] = e[1] * l + n[1] * u + o2[1] * p2 + i[1] * d, t4[2] = e[2] * l + n[2] * u + o2[2] * p2 + i[2] * d, t4;
  }
  static transformMat4(t4, e, n) {
    const o2 = e[0], i = e[1], a = e[2], r2 = n[3] * o2 + n[7] * i + n[11] * a + n[15] || 1;
    return t4[0] = (n[0] * o2 + n[4] * i + n[8] * a + n[12]) / r2, t4[1] = (n[1] * o2 + n[5] * i + n[9] * a + n[13]) / r2, t4[2] = (n[2] * o2 + n[6] * i + n[10] * a + n[14]) / r2, t4;
  }
  static transformMat3(t4, e, n) {
    const o2 = e[0], i = e[1], a = e[2];
    return t4[0] = o2 * n[0] + i * n[3] + a * n[6], t4[1] = o2 * n[1] + i * n[4] + a * n[7], t4[2] = o2 * n[2] + i * n[5] + a * n[8], t4;
  }
  static transformQuat(t4, e, n) {
    const o2 = n[0], i = n[1], a = n[2], r2 = 2 * n[3], s2 = e[0], c = e[1], l = e[2], u = i * l - a * c, p2 = a * s2 - o2 * l, d = o2 * c - i * s2, m = 2 * (i * d - a * p2), f = 2 * (a * u - o2 * d), _ = 2 * (o2 * p2 - i * u);
    return t4[0] = s2 + u * r2 + m, t4[1] = c + p2 * r2 + f, t4[2] = l + d * r2 + _, t4;
  }
  static rotateX(t4, e, n, o2) {
    const i = n[1], a = n[2], r2 = e[1] - i, s2 = e[2] - a;
    return t4[0] = e[0], t4[1] = r2 * Math.cos(o2) - s2 * Math.sin(o2) + i, t4[2] = r2 * Math.sin(o2) + s2 * Math.cos(o2) + a, t4;
  }
  static rotateY(t4, e, n, o2) {
    const i = n[0], a = n[2], r2 = e[0] - i, s2 = e[2] - a;
    return t4[0] = s2 * Math.sin(o2) + r2 * Math.cos(o2) + i, t4[1] = e[1], t4[2] = s2 * Math.cos(o2) - r2 * Math.sin(o2) + a, t4;
  }
  static rotateZ(t4, e, n, o2) {
    const i = n[0], a = n[1], r2 = e[0] - i, s2 = e[1] - a;
    return t4[0] = r2 * Math.cos(o2) - s2 * Math.sin(o2) + i, t4[1] = r2 * Math.sin(o2) + s2 * Math.cos(o2) + a, t4[2] = n[2], t4;
  }
  static angle(e, n) {
    const o2 = e[0], i = e[1], a = e[2], r2 = n[0], s2 = n[1], c = n[2], l = Math.sqrt((o2 * o2 + i * i + a * a) * (r2 * r2 + s2 * s2 + c * c)), u = l && t3.dot(e, n) / l;
    return Math.acos(Math.min(Math.max(u, -1), 1));
  }
  static zero(t4) {
    return t4[0] = 0, t4[1] = 0, t4[2] = 0, t4;
  }
  static str(t4) {
    return `Vec3(${t4.join(", ")})`;
  }
  static exactEquals(t4, e) {
    return t4[0] === e[0] && t4[1] === e[1] && t4[2] === e[2];
  }
  static equals(t4, e) {
    const n = t4[0], o2 = t4[1], i = t4[2], a = e[0], r2 = e[1], s2 = e[2];
    return Math.abs(n - a) <= GLM_EPSILON * Math.max(1, Math.abs(n), Math.abs(a)) && Math.abs(o2 - r2) <= GLM_EPSILON * Math.max(1, Math.abs(o2), Math.abs(r2)) && Math.abs(i - s2) <= GLM_EPSILON * Math.max(1, Math.abs(i), Math.abs(s2));
  }
}, _a;
Vec3.prototype.sub = Vec3.prototype.subtract, Vec3.prototype.mul = Vec3.prototype.multiply, Vec3.prototype.div = Vec3.prototype.divide, Vec3.prototype.dist = Vec3.prototype.distance, Vec3.prototype.sqrDist = Vec3.prototype.squaredDistance, Vec3.sub = Vec3.subtract, Vec3.mul = Vec3.multiply, Vec3.div = Vec3.divide, Vec3.dist = Vec3.distance, Vec3.sqrDist = Vec3.squaredDistance, Vec3.sqrLen = Vec3.squaredLength, Vec3.mag = Vec3.magnitude, Vec3.length = Vec3.magnitude, Vec3.len = Vec3.magnitude;
class StyleParse {
  static #y = /(\d+)\s*px/;
  static pixels(t4) {
    if ("string" != typeof t4) return;
    const e = this.#y.test(t4), n = parseInt(t4);
    return e && Number.isFinite(n) ? n : void 0;
  }
  static remPixels(t4 = 1, { targetDocument: e = document } = {}) {
    return e?.documentElement ? t4 * parseFloat(globalThis.getComputedStyle(e.documentElement).fontSize) : void 0;
  }
}
class TJSStyleManager {
  #v;
  #k;
  #w;
  #S;
  #T;
  constructor({ docKey: t4, selector: e = ":root", document: n = globalThis.document, version: o2 } = {}) {
    if ("string" != typeof t4) throw new TypeError("StyleManager error: 'docKey' is not a string.");
    if ("[object HTMLDocument]" !== Object.prototype.toString.call(n)) throw new TypeError("TJSStyleManager error: 'document' is not an instance of HTMLDocument.");
    if ("string" != typeof e) throw new TypeError("StyleManager error: 'selector' is not a string.");
    if (void 0 !== o2 && !Number.isSafeInteger(o2) && o2 < 1) throw new TypeError("StyleManager error: 'version' is defined and is not a positive integer >= 1.");
    if (this.#w = e, this.#k = t4, this.#T = o2, void 0 === n[this.#k]) this.#S = n.createElement("style"), n.head.append(this.#S), this.#S._STYLE_MANAGER_VERSION = o2, this.#S.sheet.insertRule(`${e} {}`, 0), this.#v = this.#S.sheet.cssRules[0], n[t4] = this.#S;
    else if (this.#S = n[t4], this.#v = this.#S.sheet.cssRules[0], o2) {
      o2 > (this.#S._STYLE_MANAGER_VERSION ?? 0) && (this.#v.style.cssText = "");
    }
  }
  get cssText() {
    return this.#v.style.cssText;
  }
  get version() {
    return this.#T;
  }
  clone(t4 = globalThis.document) {
    const e = new TJSStyleManager({ selector: this.#w, docKey: this.#k, document: t4, version: this.#T });
    return e.#v.style.cssText = this.#v.style.cssText, e;
  }
  get() {
    const t4 = this.#v.style.cssText, e = {};
    if ("" !== t4) {
      for (const n of t4.split(";")) if ("" !== n) {
        const t5 = n.split(":");
        e[t5[0].trim()] = t5[1];
      }
    }
    return e;
  }
  getProperty(t4) {
    if ("string" != typeof t4) throw new TypeError("StyleManager error: 'key' is not a string.");
    return this.#v.style.getPropertyValue(t4);
  }
  setProperties(t4, e = true) {
    if (!isObject$1(t4)) throw new TypeError("StyleManager error: 'rules' is not an object.");
    if ("boolean" != typeof e) throw new TypeError("StyleManager error: 'overwrite' is not a boolean.");
    if (e) for (const [e2, n] of Object.entries(t4)) this.#v.style.setProperty(e2, n);
    else for (const [e2, n] of Object.entries(t4)) "" === this.#v.style.getPropertyValue(e2) && this.#v.style.setProperty(e2, n);
  }
  setProperty(t4, e, n = true) {
    if ("string" != typeof t4) throw new TypeError("StyleManager error: 'key' is not a string.");
    if ("string" != typeof e) throw new TypeError("StyleManager error: 'value' is not a string.");
    if ("boolean" != typeof n) throw new TypeError("StyleManager error: 'overwrite' is not a boolean.");
    (n || "" === this.#v.style.getPropertyValue(t4)) && this.#v.style.setProperty(t4, e);
  }
  removeProperties(t4) {
    if (!isIterable(t4)) throw new TypeError("StyleManager error: 'keys' is not an iterable list.");
    for (const e of t4) "string" == typeof e && this.#v.style.removeProperty(e);
  }
  removeProperty(t4) {
    if ("string" != typeof t4) throw new TypeError("StyleManager error: 'key' is not a string.");
    return this.#v.style.removeProperty(t4);
  }
}
async function nextAnimationFrame(t4 = 1) {
  if (!Number.isInteger(t4) || t4 < 1) throw new TypeError("nextAnimationFrame error: 'cntr' must be a positive integer greater than 0.");
  let e;
  for (; --t4 >= 0; ) e = await new Promise((t5) => requestAnimationFrame(t5));
  return e;
}
function draggable(t4, { position: e, enabled: n = true, button: o2 = 0, storeDragging: i, tween: a = false, tweenOptions: r2 = { duration: 1, ease: "cubicOut" }, hasTargetClassList: s2, ignoreTargetClassList: c }) {
  if (void 0 !== s2 && !isIterable(s2)) throw new TypeError("'hasTargetClassList' is not iterable.");
  if (void 0 !== c && !isIterable(c)) throw new TypeError("'ignoreTargetClassList' is not iterable.");
  const l = { left: 0, top: 0 };
  let u = e?.position ?? e, p2 = null, d = { x: 0, y: 0 }, m = false, f = u.animate.quickTo(["top", "left"], r2);
  const _ = { dragDown: ["pointerdown", function(e2) {
    if (e2.button !== o2 || !e2.isPrimary) return;
    if (!u.enabled) return;
    if (void 0 !== c && A11yHelper.isFocusTarget(e2.target)) {
      for (const t5 of c) if (e2.target.classList.contains(t5)) return;
    }
    if (void 0 !== s2 && A11yHelper.isFocusTarget(e2.target)) {
      let t5 = false;
      for (const n2 of s2) if (e2.target.classList.contains(n2)) {
        t5 = true;
        break;
      }
      if (!t5) return;
    }
    e2.preventDefault(), m = false, p2 = u.get(), d = { x: e2.clientX, y: e2.clientY }, t4.addEventListener(..._.dragMove), t4.addEventListener(..._.dragUp), t4.setPointerCapture(e2.pointerId);
  }, false], dragMove: ["pointermove", function(t5) {
    if (!(1 & t5.buttons)) return void $2(t5);
    if (-1 !== t5.button || !t5.isPrimary) return;
    t5.preventDefault(), m || "function" != typeof i?.set || (m = true, i.set(true));
    const e2 = p2?.left + (t5.clientX - d.x), n2 = p2?.top + (t5.clientY - d.y);
    a ? f(n2, e2) : (l.left = e2, l.top = n2, u.set(l));
  }, false], dragUp: ["pointerup", $2, false] };
  function h() {
    t4.addEventListener(..._.dragDown), t4.classList.add("draggable");
  }
  function g2() {
    "function" == typeof i?.set && i.set(false), t4.removeEventListener(..._.dragDown), t4.removeEventListener(..._.dragMove), t4.removeEventListener(..._.dragUp), t4.classList.remove("draggable");
  }
  function $2(e2) {
    e2.preventDefault(), m = false, "function" == typeof i?.set && i.set(false), t4.removeEventListener(..._.dragMove), t4.removeEventListener(..._.dragUp);
  }
  return n && h(), { update: (t5) => {
    if (void 0 !== t5.position) {
      const e2 = t5.position?.position ?? t5.position;
      e2 !== u && (u = e2, f = u.animate.quickTo(["top", "left"], r2));
    }
    if ("boolean" == typeof t5.enabled && ((n = t5.enabled) ? h() : g2()), "number" == typeof t5.button && (o2 = t5.button), "boolean" == typeof t5.tween && (a = t5.tween), isObject$1(t5.tweenOptions) && (r2 = t5.tweenOptions, f.options(r2)), void 0 !== t5.hasTargetClassList) {
      if (!isIterable(t5.hasTargetClassList)) throw new TypeError("'hasTargetClassList' is not iterable.");
      s2 = t5.hasTargetClassList;
    }
    if (void 0 !== t5.ignoreTargetClassList) {
      if (!isIterable(t5.ignoreTargetClassList)) throw new TypeError("'ignoreTargetClassList' is not iterable.");
      c = t5.ignoreTargetClassList;
    }
  }, destroy: () => g2() };
}
class DraggableOptionsStore {
  tween;
  tweenOptions;
  #x;
  #E;
  #O = false;
  #A = { duration: 1, ease: "cubicOut" };
  #C = [];
  constructor({ tween: t4 = false, tweenOptions: e } = {}) {
    Object.defineProperty(this, "tween", { get: () => this.#O, set: (t5) => {
      if ("boolean" != typeof t5) throw new TypeError("'tween' is not a boolean.");
      this.#O = t5, this.#D();
    }, enumerable: true }), Object.defineProperty(this, "tweenOptions", { get: () => this.#A, set: (t5) => {
      if (!isObject$1(t5)) throw new TypeError("'tweenOptions' is not an object.");
      if (void 0 !== t5.duration) {
        if (!Number.isFinite(t5.duration)) throw new TypeError("'tweenOptions.duration' is not a finite number.");
        t5.duration < 0 ? this.#A.duration = 0 : this.#A.duration = t5.duration;
      }
      if (void 0 !== t5.ease) {
        if ("function" != typeof getEasingFunc(t5.ease)) throw new TypeError("'tweenOptions.ease' is not a function or Svelte easing function name.");
        this.#A.ease = t5.ease;
      }
      this.#D();
    }, enumerable: true }), void 0 !== t4 && (this.tween = t4), void 0 !== e && (this.tweenOptions = e), this.#x = this.#O, this.#E = Object.assign({}, this.#A);
  }
  get tweenDuration() {
    return this.#A.duration;
  }
  get tweenEase() {
    return this.#A.ease;
  }
  set tweenDuration(t4) {
    if (!Number.isFinite(t4)) throw new TypeError("'duration' is not a finite number.");
    t4 < 0 && (t4 = 0), this.#A.duration = t4, this.#D();
  }
  set tweenEase(t4) {
    if ("function" != typeof getEasingFunc(t4)) throw new TypeError("'ease' is not a function or Svelte easing function name.");
    this.#A.ease = t4, this.#D();
  }
  reset() {
    this.#O = this.#x, this.#A = Object.assign({}, this.#E), this.#D();
  }
  resetTween() {
    this.#O = this.#x, this.#D();
  }
  resetTweenOptions() {
    this.#A = Object.assign({}, this.#E), this.#D();
  }
  subscribe(t4) {
    return -1 === this.#C.findIndex((e) => e === t4) && (this.#C.push(t4), t4(this)), () => {
      const e = this.#C.findIndex((e2) => e2 === t4);
      -1 !== e && this.#C.splice(e, 1);
    };
  }
  #D() {
    const t4 = this.#C;
    if (t4.length > 0) for (let e = 0; e < t4.length; e++) t4[e](this);
  }
}
draggable.options = (t4) => new DraggableOptionsStore(t4);
class AnimationControl {
  #M;
  #j;
  #I;
  static #N = new AnimationControl(null);
  static get voidControl() {
    return this.#N;
  }
  constructor(t4, e = false) {
    this.#M = t4, this.#I = e, isObject$1(t4) && (t4.control = this);
  }
  get finished() {
    return CrossWindow.isPromise(this.#j) || (this.#j = this.#I ? new Promise((t4) => this.#M.resolve = t4) : Promise.resolve({ cancelled: false })), this.#j;
  }
  get isActive() {
    return this.#M?.active ?? false;
  }
  get isFinished() {
    return this.#M?.finished ?? true;
  }
  cancel() {
    const t4 = this.#M;
    null != t4 && (t4.cancelled = true);
  }
}
class AnimationManager {
  static cancelFn = (t4) => true !== t4?.quickTo;
  static cancelAllFn = () => true;
  static #P = Object.freeze({ immediateElementUpdate: true });
  static #F = [];
  static #R = (t4) => this.animate(t4);
  static #L = [];
  static #H = false;
  static #z;
  static #q;
  static get timeFrame() {
    return this.#z;
  }
  static get timeNow() {
    return this.#q;
  }
  static add(t4) {
    t4.cancelled ? this.#W(t4) : (AnimationManager.#L.push(t4), AnimationManager.#H || (AnimationManager.#H = true, globalThis.requestAnimationFrame(this.#R)));
  }
  static animate(t4) {
    if (AnimationManager.#H = false, AnimationManager.#q = globalThis.performance.now(), AnimationManager.#z = t4, 0 !== AnimationManager.#F.length || 0 !== AnimationManager.#L.length) {
      if (AnimationManager.#L.length) for (let t5 = AnimationManager.#L.length; --t5 >= 0; ) {
        const e = AnimationManager.#L[t5];
        (e.cancelled || void 0 !== e.el && !e.el.isConnected) && (AnimationManager.#L.splice(t5, 1), this.#W(e)), e.active && (e.transformOrigin && e.position.set({ transformOrigin: e.transformOrigin }), e.start = AnimationManager.#z, AnimationManager.#L.splice(t5, 1), AnimationManager.#F.push(e));
      }
      for (let e = AnimationManager.#F.length; --e >= 0; ) {
        const n = AnimationManager.#F[e];
        if (n.cancelled || void 0 !== n.el && !n.el.isConnected) {
          AnimationManager.#F.splice(e, 1), this.#W(n);
          continue;
        }
        if (n.current = t4 - n.start, n.current >= n.duration) {
          for (let t5 = n.keys.length; --t5 >= 0; ) {
            const e2 = n.keys[t5];
            n.newData[e2] = n.destination[e2];
          }
          n.position.set(n.newData, AnimationManager.#P), AnimationManager.#F.splice(e, 1), this.#W(n);
          continue;
        }
        const o2 = n.ease(n.current / n.duration);
        for (let t5 = n.keys.length; --t5 >= 0; ) {
          const e2 = n.keys[t5];
          n.newData[e2] = n.interpolate(n.initial[e2], n.destination[e2], o2);
        }
        n.position.set(n.newData, AnimationManager.#P);
      }
      globalThis.requestAnimationFrame(this.#R);
    }
  }
  static cancel(t4, e = AnimationManager.cancelFn) {
    for (let n = AnimationManager.#F.length; --n >= 0; ) {
      const o2 = AnimationManager.#F[n];
      o2.position === t4 && e(o2) && (AnimationManager.#F.splice(n, 1), o2.cancelled = true, this.#W(o2));
    }
    for (let n = AnimationManager.#L.length; --n >= 0; ) {
      const o2 = AnimationManager.#L[n];
      o2.position === t4 && e(o2) && (AnimationManager.#L.splice(n, 1), o2.cancelled = true, this.#W(o2));
    }
  }
  static cancelAll() {
    for (let t4 = AnimationManager.#F.length; --t4 >= 0; ) {
      const e = AnimationManager.#F[t4];
      e.cancelled = true, this.#W(e);
    }
    for (let t4 = AnimationManager.#L.length; --t4 >= 0; ) {
      const e = AnimationManager.#L[t4];
      e.cancelled = true, this.#W(e);
    }
    AnimationManager.#F.length = 0, AnimationManager.#L.length = 0;
  }
  static #W(t4) {
    t4.active = false, t4.finished = true, t4.transformOriginInitial && t4.position.set({ transformOrigin: t4.transformOriginInitial }), "function" == typeof t4.cleanup && t4.cleanup(t4), "function" == typeof t4.resolve && t4.resolve({ cancelled: t4.cancelled }), t4.quickTo || (t4.cleanup = void 0, t4.control = void 0, t4.destination = void 0, t4.el = void 0, t4.ease = void 0, t4.initial = void 0, t4.interpolate = void 0, t4.keys = void 0, t4.newData = void 0, t4.position = void 0, t4.resolve = void 0);
  }
  static getScheduled(t4) {
    const e = [];
    for (let n = AnimationManager.#F.length; --n >= 0; ) {
      const o2 = AnimationManager.#F[n];
      o2.position === t4 && o2.control && e.push(o2.control);
    }
    for (let n = AnimationManager.#L.length; --n >= 0; ) {
      const o2 = AnimationManager.#L[n];
      o2.position === t4 && o2.control && e.push(o2.control);
    }
    return e;
  }
  static isScheduled(t4, { active: e = true, pending: n = true } = {}) {
    if (e) {
      for (let e2 = AnimationManager.#F.length; --e2 >= 0; ) if (AnimationManager.#F[e2].position === t4) return true;
    }
    if (n) {
      for (let e2 = AnimationManager.#L.length; --e2 >= 0; ) if (AnimationManager.#L[e2].position === t4) return true;
    }
    return false;
  }
}
class TJSPositionData {
  height;
  left;
  maxHeight;
  maxWidth;
  minHeight;
  minWidth;
  rotateX;
  rotateY;
  rotateZ;
  scale;
  top;
  transformOrigin;
  translateX;
  translateY;
  translateZ;
  width;
  zIndex;
  constructor({ height: t4 = null, left: e = null, maxHeight: n = null, maxWidth: o2 = null, minHeight: i = null, minWidth: a = null, rotateX: r2 = null, rotateY: s2 = null, rotateZ: c = null, scale: l = null, translateX: u = null, translateY: p2 = null, translateZ: d = null, top: m = null, transformOrigin: f = null, width: _ = null, zIndex: h = null } = {}) {
    this.height = t4, this.left = e, this.maxHeight = n, this.maxWidth = o2, this.minHeight = i, this.minWidth = a, this.rotateX = r2, this.rotateY = s2, this.rotateZ = c, this.scale = l, this.top = m, this.transformOrigin = f, this.translateX = u, this.translateY = p2, this.translateZ = d, this.width = _, this.zIndex = h;
  }
}
class TJSPositionDataUtil {
  static #U = Object.freeze(/* @__PURE__ */ new Set(["left", "top", "maxWidth", "maxHeight", "minWidth", "minHeight", "width", "height", "rotateX", "rotateY", "rotateZ", "scale", "translateX", "translateY", "translateZ", "zIndex", "rotation"]));
  static #G = Object.freeze(/* @__PURE__ */ new Map([["rotation", "rotateZ"]]));
  static #B = Object.freeze({ height: 0, left: 0, maxHeight: null, maxWidth: null, minHeight: null, minWidth: null, top: 0, transformOrigin: null, width: 0, zIndex: null, rotateX: 0, rotateY: 0, rotateZ: 0, scale: 1, translateX: 0, translateY: 0, translateZ: 0 });
  static copyData(t4, e = new TJSPositionData()) {
    return e.height = t4.height ?? null, e.left = t4.left ?? null, e.maxHeight = t4.maxHeight ?? null, e.maxWidth = t4.maxWidth ?? null, e.minHeight = t4.minHeight ?? null, e.minWidth = t4.minWidth ?? null, e.rotateX = t4.rotateX ?? null, e.rotateY = t4.rotateY ?? null, e.rotateZ = t4.rotateZ ?? null, e.scale = t4.scale ?? null, e.top = t4.top ?? null, e.transformOrigin = t4.transformOrigin ?? null, e.translateX = t4.translateX ?? null, e.translateY = t4.translateY ?? null, e.translateZ = t4.translateZ ?? null, e.width = t4.width ?? null, e.zIndex = t4.zIndex ?? null, e;
  }
  static getAnimationKey(t4) {
    return this.#G.get(t4) ?? t4;
  }
  static getDataOrDefault(t4, e) {
    return t4[e = this.#G.get(e) ?? e] ?? this.#B[e];
  }
  static isAnimationKey(t4) {
    return this.#U.has(t4);
  }
  static setNumericDefaults(t4) {
    null === t4.rotateX && (t4.rotateX = 0), null === t4.rotateY && (t4.rotateY = 0), null === t4.rotateZ && (t4.rotateZ = 0), null === t4.translateX && (t4.translateX = 0), null === t4.translateY && (t4.translateY = 0), null === t4.translateZ && (t4.translateZ = 0), null === t4.scale && (t4.scale = 1);
  }
}
class ConvertStringData {
  static #J = { numPx: Object.freeze(/* @__PURE__ */ new Set(["left", "top", "maxWidth", "maxHeight", "minWidth", "minHeight", "width", "height", "translateX", "translateY", "translateZ"])), percentParent: Object.freeze(/* @__PURE__ */ new Set(["left", "top", "maxWidth", "maxHeight", "minWidth", "minHeight", "width", "height"])), rotationRadTurn: Object.freeze(/* @__PURE__ */ new Set(["rotateX", "rotateY", "rotateZ", "rotation"])) };
  static #V = /^(?<operation>[-+*]=)?(?<value>-?\d*\.?\d+)(?<unit>%|%~|px|rad|turn)?$/;
  static #X = Object.seal({ operation: void 0, value: 0, unit: void 0 });
  static process(t4, e, n) {
    let o2 = Number.NaN, i = Number.NaN;
    for (const a in t4) if (TJSPositionDataUtil.isAnimationKey(a)) {
      const r2 = t4[a];
      if ("string" != typeof r2) continue;
      if ("auto" === r2 || "inherit" === r2) continue;
      const s2 = a, c = this.#V.exec(r2);
      let l = false;
      if (c && c.groups) {
        const u = this.#X;
        u.operation = c.groups.operation, u.value = parseFloat(c.groups.value), u.unit = c.groups.unit;
        const p2 = TJSPositionDataUtil.getDataOrDefault(e, a);
        switch (u.unit) {
          case "%":
            if (this.#J.percentParent.has(a) && (Number.isNaN(o2) || Number.isNaN(i))) {
              if (!n?.parentElement?.isConnected) {
                o2 = 0, i = 0, console.warn(`TJSPosition - ConvertStringData warning: could not determine parent constraints for key '${a}' with value '${r2}'.`), t4[a] = void 0;
                continue;
              }
              o2 = n.parentElement.clientHeight, i = n.parentElement.clientWidth;
            }
            l = this.#Y(s2, p2, t4, u, o2, i);
            break;
          case "%~":
            l = this.#Z(s2, p2, t4, u);
            break;
          case "px":
            l = !!this.#J.numPx.has(a) && this.#K(s2, p2, t4, u);
            break;
          case "rad":
          case "turn":
            l = !!this.#J.rotationRadTurn.has(a) && this.#Q(s2, p2, t4, u);
            break;
          default:
            l = this.#K(s2, p2, t4, u);
        }
      }
      c && l || (console.warn(`TJSPosition - ConvertStringData warning: malformed key '${a}' with value '${r2}'.`), t4[a] = void 0);
    }
    return t4;
  }
  static #K(t4, e, n, o2) {
    if (!o2.operation) return n[t4] = o2.value, true;
    switch (o2.operation) {
      case "-=":
        n[t4] = e - o2.value;
        break;
      case "+=":
        n[t4] = e + o2.value;
        break;
      case "*=":
        n[t4] = e * o2.value;
        break;
      default:
        return false;
    }
    return true;
  }
  static #Y(t4, e, n, o2, i, a) {
    switch (t4) {
      case "left":
      case "maxWidth":
      case "minWidth":
      case "width":
      case "translateX":
        o2.value = a * (o2.value / 100);
        break;
      case "top":
      case "maxHeight":
      case "minHeight":
      case "height":
      case "translateY":
        o2.value = i * (o2.value / 100);
        break;
      case "rotateX":
      case "rotateY":
      case "rotateZ":
      case "rotation":
        o2.value = o2.value / 100 * 360;
        break;
      default:
        return false;
    }
    return this.#K(t4, e, n, o2);
  }
  static #Z(t4, e, n, o2) {
    if (o2.value = o2.value / 100, !o2.operation) return n[t4] = e * o2.value, true;
    switch (o2.operation) {
      case "-=":
        n[t4] = e - e * o2.value;
        break;
      case "+=":
        n[t4] = e + e * o2.value;
        break;
      case "*=":
        n[t4] = e * (e * o2.value);
        break;
      default:
        return false;
    }
    return true;
  }
  static #Q(t4, e, n, o2) {
    switch (o2.unit) {
      case "rad":
        o2.value = radToDeg(o2.value);
        break;
      case "turn":
        o2.value = 360 * o2.value;
    }
    return this.#K(t4, e, n, o2);
  }
}
class TJSTransformData {
  constructor() {
    Object.seal(this);
  }
  #tt = new DOMRect();
  #et = [new Vec3(), new Vec3(), new Vec3(), new Vec3()];
  #nt = new Mat4();
  #ot = [new Mat4(), new Mat4()];
  get boundingRect() {
    return this.#tt;
  }
  get corners() {
    return this.#et;
  }
  get css() {
    return `matrix3d(${this.mat4.join(",")})`;
  }
  get mat4() {
    return this.#nt;
  }
  get originTranslations() {
    return this.#ot;
  }
}
class NumberGuard {
  constructor() {
  }
  static isFinite(t4) {
    return "number" == typeof t4 && Number.isFinite(t4);
  }
  static isFiniteOrNull(t4) {
    return null === t4 || "number" == typeof t4 && Number.isFinite(t4);
  }
}
class TJSPositionStyleCache {
  el;
  computed;
  marginLeft;
  marginTop;
  maxHeight;
  maxWidth;
  minHeight;
  minWidth;
  hasWillChange;
  stores;
  resizeObserved;
  constructor() {
    this.el = void 0, this.computed = void 0, this.marginLeft = void 0, this.marginTop = void 0, this.maxHeight = void 0, this.maxWidth = void 0, this.minHeight = void 0, this.minWidth = void 0, this.hasWillChange = false, this.resizeObserved = Object.seal({ contentHeight: void 0, contentWidth: void 0, offsetHeight: void 0, offsetWidth: void 0 });
    const t4 = writable(this.resizeObserved);
    this.stores = { element: writable(this.el), resizeContentHeight: propertyStore(t4, "contentHeight"), resizeContentWidth: propertyStore(t4, "contentWidth"), resizeObserved: t4, resizeObservable: writable(false), resizeOffsetHeight: propertyStore(t4, "offsetHeight"), resizeOffsetWidth: propertyStore(t4, "offsetWidth") };
  }
  get offsetHeight() {
    if (void 0 !== this.el && A11yHelper.isFocusTarget(this.el)) return void 0 !== this.resizeObserved.offsetHeight ? this.resizeObserved.offsetHeight : this.el.offsetHeight;
    throw new Error("TJSPositionStyleCache - get offsetHeight error: no element assigned.");
  }
  get offsetWidth() {
    if (void 0 !== this.el && A11yHelper.isFocusTarget(this.el)) return void 0 !== this.resizeObserved.offsetWidth ? this.resizeObserved.offsetWidth : this.el.offsetWidth;
    throw new Error("TJSPositionStyleCache - get offsetWidth error: no element assigned.");
  }
  hasData(t4) {
    return this.el === t4;
  }
  reset() {
    void 0 !== this.el && A11yHelper.isFocusTarget(this.el) && this.el.isConnected && !this.hasWillChange && (this.el.style.willChange = ""), this.el = void 0, this.computed = void 0, this.marginLeft = void 0, this.marginTop = void 0, this.maxHeight = void 0, this.maxWidth = void 0, this.minHeight = void 0, this.minWidth = void 0, this.hasWillChange = false, this.resizeObserved.contentHeight = void 0, this.resizeObserved.contentWidth = void 0, this.resizeObserved.offsetHeight = void 0, this.resizeObserved.offsetWidth = void 0, this.stores.element.set(void 0);
  }
  update(t4) {
    this.el = t4, this.computed = globalThis.getComputedStyle(t4), this.marginLeft = StyleParse.pixels(t4.style.marginLeft) ?? StyleParse.pixels(this.computed.marginLeft), this.marginTop = StyleParse.pixels(t4.style.marginTop) ?? StyleParse.pixels(this.computed.marginTop), this.maxHeight = StyleParse.pixels(t4.style.maxHeight) ?? StyleParse.pixels(this.computed.maxHeight), this.maxWidth = StyleParse.pixels(t4.style.maxWidth) ?? StyleParse.pixels(this.computed.maxWidth), this.minHeight = StyleParse.pixels(t4.style.minHeight) ?? StyleParse.pixels(this.computed.minHeight), this.minWidth = StyleParse.pixels(t4.style.minWidth) ?? StyleParse.pixels(this.computed.minWidth);
    const e = "" !== t4.style.willChange ? t4.style.willChange : this.computed.willChange ?? "";
    this.hasWillChange = "" !== e && "auto" !== e, this.stores.element.set(t4);
  }
}
class TJSTransforms {
  #it = {};
  #at = [];
  static #rt = Object.freeze(["rotateX", "rotateY", "rotateZ", "scale", "translateX", "translateY", "translateZ"]);
  static #st(t4) {
    return this.#rt.includes(t4);
  }
  static #ct = Object.freeze({ rotateX: 1, rotateY: 2, rotateZ: 4, scale: 8, translateX: 16, translateY: 32, translateZ: 64 });
  static #lt = "top left";
  static #ut = Object.freeze(["top left", "top center", "top right", "center left", "center", "center right", "bottom left", "bottom center", "bottom right"]);
  static #pt = Object.freeze(new Set(this.#ut));
  static #dt = new Mat4();
  static #mt = new Mat4();
  static #ft = new Vec3();
  static #_t = [1, 1, 1];
  static #ht = [0, 0, 0];
  static get transformOrigins() {
    return this.#ut;
  }
  static isTransformOrigin(t4) {
    return this.#pt.has(t4);
  }
  get isActive() {
    return this.#at.length > 0;
  }
  get rotateX() {
    return this.#it.rotateX;
  }
  get rotateY() {
    return this.#it.rotateY;
  }
  get rotateZ() {
    return this.#it.rotateZ;
  }
  get scale() {
    return this.#it.scale;
  }
  get translateX() {
    return this.#it.translateX;
  }
  get translateY() {
    return this.#it.translateY;
  }
  get translateZ() {
    return this.#it.translateZ;
  }
  set rotateX(t4) {
    if (Number.isFinite(t4)) void 0 === this.#it.rotateX && this.#at.push("rotateX"), this.#it.rotateX = t4;
    else {
      if (void 0 !== this.#it.rotateX) {
        const t5 = this.#at.findIndex((t6) => "rotateX" === t6);
        t5 >= 0 && this.#at.splice(t5, 1);
      }
      delete this.#it.rotateX;
    }
  }
  set rotateY(t4) {
    if (Number.isFinite(t4)) void 0 === this.#it.rotateY && this.#at.push("rotateY"), this.#it.rotateY = t4;
    else {
      if (void 0 !== this.#it.rotateY) {
        const t5 = this.#at.findIndex((t6) => "rotateY" === t6);
        t5 >= 0 && this.#at.splice(t5, 1);
      }
      delete this.#it.rotateY;
    }
  }
  set rotateZ(t4) {
    if (Number.isFinite(t4)) void 0 === this.#it.rotateZ && this.#at.push("rotateZ"), this.#it.rotateZ = t4;
    else {
      if (void 0 !== this.#it.rotateZ) {
        const t5 = this.#at.findIndex((t6) => "rotateZ" === t6);
        t5 >= 0 && this.#at.splice(t5, 1);
      }
      delete this.#it.rotateZ;
    }
  }
  set scale(t4) {
    if (Number.isFinite(t4)) void 0 === this.#it.scale && this.#at.push("scale"), this.#it.scale = t4;
    else {
      if (void 0 !== this.#it.scale) {
        const t5 = this.#at.findIndex((t6) => "scale" === t6);
        t5 >= 0 && this.#at.splice(t5, 1);
      }
      delete this.#it.scale;
    }
  }
  set translateX(t4) {
    if (Number.isFinite(t4)) void 0 === this.#it.translateX && this.#at.push("translateX"), this.#it.translateX = t4;
    else {
      if (void 0 !== this.#it.translateX) {
        const t5 = this.#at.findIndex((t6) => "translateX" === t6);
        t5 >= 0 && this.#at.splice(t5, 1);
      }
      delete this.#it.translateX;
    }
  }
  set translateY(t4) {
    if (Number.isFinite(t4)) void 0 === this.#it.translateY && this.#at.push("translateY"), this.#it.translateY = t4;
    else {
      if (void 0 !== this.#it.translateY) {
        const t5 = this.#at.findIndex((t6) => "translateY" === t6);
        t5 >= 0 && this.#at.splice(t5, 1);
      }
      delete this.#it.translateY;
    }
  }
  set translateZ(t4) {
    if (Number.isFinite(t4)) void 0 === this.#it.translateZ && this.#at.push("translateZ"), this.#it.translateZ = t4;
    else {
      if (void 0 !== this.#it.translateZ) {
        const t5 = this.#at.findIndex((t6) => "translateZ" === t6);
        t5 >= 0 && this.#at.splice(t5, 1);
      }
      delete this.#it.translateZ;
    }
  }
  getCSS(t4 = this.#it) {
    return `matrix3d(${this.getMat4(t4, TJSTransforms.#dt).join(",")})`;
  }
  getCSSOrtho(t4 = this.#it) {
    return `matrix3d(${this.getMat4Ortho(t4, TJSTransforms.#dt).join(",")})`;
  }
  getData(t4, e = new TJSTransformData(), n) {
    const o2 = n?.width ?? 0, i = n?.height ?? 0, a = n?.offsetTop ?? n?.marginTop ?? 0, r2 = n?.offsetLeft ?? n?.marginLeft ?? 0;
    t4.top += a, t4.left += r2;
    const s2 = NumberGuard.isFinite(t4.width) ? t4.width : o2, c = NumberGuard.isFinite(t4.height) ? t4.height : i, l = e.corners;
    if (this.hasTransform(t4)) {
      l[0][0] = l[0][1] = l[0][2] = 0, l[1][0] = s2, l[1][1] = l[1][2] = 0, l[2][0] = s2, l[2][1] = c, l[2][2] = 0, l[3][0] = 0, l[3][1] = c, l[3][2] = 0;
      const n2 = this.getMat4(t4, e.mat4), o3 = TJSTransforms.#gt(t4.transformOrigin, s2, c, e.originTranslations);
      TJSTransforms.#lt === t4.transformOrigin ? (Vec3.transformMat4(l[0], l[0], n2), Vec3.transformMat4(l[1], l[1], n2), Vec3.transformMat4(l[2], l[2], n2), Vec3.transformMat4(l[3], l[3], n2)) : (Vec3.transformMat4(l[0], l[0], o3[0]), Vec3.transformMat4(l[0], l[0], n2), Vec3.transformMat4(l[0], l[0], o3[1]), Vec3.transformMat4(l[1], l[1], o3[0]), Vec3.transformMat4(l[1], l[1], n2), Vec3.transformMat4(l[1], l[1], o3[1]), Vec3.transformMat4(l[2], l[2], o3[0]), Vec3.transformMat4(l[2], l[2], n2), Vec3.transformMat4(l[2], l[2], o3[1]), Vec3.transformMat4(l[3], l[3], o3[0]), Vec3.transformMat4(l[3], l[3], n2), Vec3.transformMat4(l[3], l[3], o3[1])), l[0][0] = t4.left + l[0][0], l[0][1] = t4.top + l[0][1], l[1][0] = t4.left + l[1][0], l[1][1] = t4.top + l[1][1], l[2][0] = t4.left + l[2][0], l[2][1] = t4.top + l[2][1], l[3][0] = t4.left + l[3][0], l[3][1] = t4.top + l[3][1];
    } else l[0][0] = t4.left, l[0][1] = t4.top, l[1][0] = t4.left + s2, l[1][1] = t4.top, l[2][0] = t4.left + s2, l[2][1] = t4.top + c, l[3][0] = t4.left, l[3][1] = t4.top + c, Mat4.identity(e.mat4);
    let u = Number.MIN_SAFE_INTEGER, p2 = Number.MIN_SAFE_INTEGER, d = Number.MAX_SAFE_INTEGER, m = Number.MAX_SAFE_INTEGER;
    for (let t5 = 4; --t5 >= 0; ) l[t5][0] > u && (u = l[t5][0]), l[t5][0] < d && (d = l[t5][0]), l[t5][1] > p2 && (p2 = l[t5][1]), l[t5][1] < m && (m = l[t5][1]);
    const f = e.boundingRect;
    return f.x = d, f.y = m, f.width = u - d, f.height = p2 - m, t4.top -= a, t4.left -= r2, e;
  }
  getMat4(t4 = this.#it, e = new Mat4()) {
    const n = Mat4.identity(e);
    let o2 = 0;
    const i = this.#at;
    for (let e2 = 0; e2 < i.length; e2++) {
      const a = i[e2];
      switch (a) {
        case "rotateX":
          o2 |= TJSTransforms.#ct.rotateX, Mat4.multiply(n, n, Mat4.fromXRotation(TJSTransforms.#mt, degToRad(t4[a] ?? 0)));
          break;
        case "rotateY":
          o2 |= TJSTransforms.#ct.rotateY, Mat4.multiply(n, n, Mat4.fromYRotation(TJSTransforms.#mt, degToRad(t4[a] ?? 0)));
          break;
        case "rotateZ":
          o2 |= TJSTransforms.#ct.rotateZ, Mat4.multiply(n, n, Mat4.fromZRotation(TJSTransforms.#mt, degToRad(t4[a] ?? 0)));
          break;
        case "scale":
          o2 |= TJSTransforms.#ct.scale, TJSTransforms.#_t[0] = TJSTransforms.#_t[1] = t4[a] ?? 0, Mat4.multiply(n, n, Mat4.fromScaling(TJSTransforms.#mt, TJSTransforms.#_t));
          break;
        case "translateX":
          o2 |= TJSTransforms.#ct.translateX, TJSTransforms.#ht[0] = t4.translateX ?? 0, TJSTransforms.#ht[1] = 0, TJSTransforms.#ht[2] = 0, Mat4.multiply(n, n, Mat4.fromTranslation(TJSTransforms.#mt, TJSTransforms.#ht));
          break;
        case "translateY":
          o2 |= TJSTransforms.#ct.translateY, TJSTransforms.#ht[0] = 0, TJSTransforms.#ht[1] = t4.translateY ?? 0, TJSTransforms.#ht[2] = 0, Mat4.multiply(n, n, Mat4.fromTranslation(TJSTransforms.#mt, TJSTransforms.#ht));
          break;
        case "translateZ":
          o2 |= TJSTransforms.#ct.translateZ, TJSTransforms.#ht[0] = 0, TJSTransforms.#ht[1] = 0, TJSTransforms.#ht[2] = t4.translateZ ?? 0, Mat4.multiply(n, n, Mat4.fromTranslation(TJSTransforms.#mt, TJSTransforms.#ht));
      }
    }
    if (t4 !== this.#it) for (let e2 = 0; e2 < TJSTransforms.#rt.length; e2++) {
      const i2 = TJSTransforms.#rt[e2];
      if (null === t4[i2] || (o2 & TJSTransforms.#ct[i2]) > 0) continue;
      const a = t4[i2];
      switch (i2) {
        case "rotateX":
          Mat4.multiply(n, n, Mat4.fromXRotation(TJSTransforms.#mt, degToRad(a)));
          break;
        case "rotateY":
          Mat4.multiply(n, n, Mat4.fromYRotation(TJSTransforms.#mt, degToRad(a)));
          break;
        case "rotateZ":
          Mat4.multiply(n, n, Mat4.fromZRotation(TJSTransforms.#mt, degToRad(a)));
          break;
        case "scale":
          TJSTransforms.#_t[0] = TJSTransforms.#_t[1] = a, Mat4.multiply(n, n, Mat4.fromScaling(TJSTransforms.#mt, TJSTransforms.#_t));
          break;
        case "translateX":
          TJSTransforms.#ht[0] = a, TJSTransforms.#ht[1] = 0, TJSTransforms.#ht[2] = 0, Mat4.multiply(n, n, Mat4.fromTranslation(TJSTransforms.#mt, TJSTransforms.#ht));
          break;
        case "translateY":
          TJSTransforms.#ht[0] = 0, TJSTransforms.#ht[1] = a, TJSTransforms.#ht[2] = 0, Mat4.multiply(n, n, Mat4.fromTranslation(TJSTransforms.#mt, TJSTransforms.#ht));
          break;
        case "translateZ":
          TJSTransforms.#ht[0] = 0, TJSTransforms.#ht[1] = 0, TJSTransforms.#ht[2] = a, Mat4.multiply(n, n, Mat4.fromTranslation(TJSTransforms.#mt, TJSTransforms.#ht));
      }
    }
    return n;
  }
  getMat4Ortho(t4 = this.#it, e = new Mat4()) {
    const n = Mat4.identity(e);
    if (TJSTransforms.#ht[0] = (t4.left ?? 0) + (t4.translateX ?? 0), TJSTransforms.#ht[1] = (t4.top ?? 0) + (t4.translateY ?? 0), TJSTransforms.#ht[2] = t4.translateZ ?? 0, Mat4.multiply(n, n, Mat4.fromTranslation(TJSTransforms.#mt, TJSTransforms.#ht)), null !== t4.scale && void 0 !== t4.scale && (TJSTransforms.#_t[0] = TJSTransforms.#_t[1] = t4.scale, Mat4.multiply(n, n, Mat4.fromScaling(TJSTransforms.#mt, TJSTransforms.#_t))), null === t4.rotateX && null === t4.rotateY && null === t4.rotateZ) return n;
    let o2 = 0;
    const i = this.#at;
    for (let e2 = 0; e2 < i.length; e2++) {
      const a = i[e2];
      switch (a) {
        case "rotateX":
          o2 |= TJSTransforms.#ct.rotateX, Mat4.multiply(n, n, Mat4.fromXRotation(TJSTransforms.#mt, degToRad(t4[a] ?? 0)));
          break;
        case "rotateY":
          o2 |= TJSTransforms.#ct.rotateY, Mat4.multiply(n, n, Mat4.fromYRotation(TJSTransforms.#mt, degToRad(t4[a] ?? 0)));
          break;
        case "rotateZ":
          o2 |= TJSTransforms.#ct.rotateZ, Mat4.multiply(n, n, Mat4.fromZRotation(TJSTransforms.#mt, degToRad(t4[a] ?? 0)));
      }
    }
    if (t4 !== this.#it) for (let e2 = 0; e2 < TJSTransforms.#rt.length; e2++) {
      const i2 = TJSTransforms.#rt[e2];
      if (!(null === t4[i2] || (o2 & TJSTransforms.#ct[i2]) > 0)) switch (i2) {
        case "rotateX":
          Mat4.multiply(n, n, Mat4.fromXRotation(TJSTransforms.#mt, degToRad(t4[i2] ?? 0)));
          break;
        case "rotateY":
          Mat4.multiply(n, n, Mat4.fromYRotation(TJSTransforms.#mt, degToRad(t4[i2] ?? 0)));
          break;
        case "rotateZ":
          Mat4.multiply(n, n, Mat4.fromZRotation(TJSTransforms.#mt, degToRad(t4[i2] ?? 0)));
      }
    }
    return n;
  }
  hasTransform(t4) {
    for (const e of TJSTransforms.#rt) if (Number.isFinite(t4[e])) return true;
    return false;
  }
  reset(t4) {
    for (const e in t4) if (TJSTransforms.#st(e)) {
      const n = t4[e];
      if (NumberGuard.isFinite(n)) this.#it[e] = n;
      else {
        const t5 = this.#at.findIndex((t6) => t6 === e);
        t5 >= 0 && this.#at.splice(t5, 1), delete this.#it[e];
      }
    }
  }
  static #gt(t4, e, n, o2) {
    const i = TJSTransforms.#ft;
    switch (t4) {
      case "top left":
        i[0] = i[1] = 0, Mat4.fromTranslation(o2[0], i), Mat4.fromTranslation(o2[1], i);
        break;
      case "top center":
        i[0] = 0.5 * -e, i[1] = 0, Mat4.fromTranslation(o2[0], i), i[0] = 0.5 * e, Mat4.fromTranslation(o2[1], i);
        break;
      case "top right":
        i[0] = -e, i[1] = 0, Mat4.fromTranslation(o2[0], i), i[0] = e, Mat4.fromTranslation(o2[1], i);
        break;
      case "center left":
        i[0] = 0, i[1] = 0.5 * -n, Mat4.fromTranslation(o2[0], i), i[1] = 0.5 * n, Mat4.fromTranslation(o2[1], i);
        break;
      case null:
      case "center":
        i[0] = 0.5 * -e, i[1] = 0.5 * -n, Mat4.fromTranslation(o2[0], i), i[0] = 0.5 * e, i[1] = 0.5 * n, Mat4.fromTranslation(o2[1], i);
        break;
      case "center right":
        i[0] = -e, i[1] = 0.5 * -n, Mat4.fromTranslation(o2[0], i), i[0] = e, i[1] = 0.5 * n, Mat4.fromTranslation(o2[1], i);
        break;
      case "bottom left":
        i[0] = 0, i[1] = -n, Mat4.fromTranslation(o2[0], i), i[1] = n, Mat4.fromTranslation(o2[1], i);
        break;
      case "bottom center":
        i[0] = 0.5 * -e, i[1] = -n, Mat4.fromTranslation(o2[0], i), i[0] = 0.5 * e, i[1] = n, Mat4.fromTranslation(o2[1], i);
        break;
      case "bottom right":
        i[0] = -e, i[1] = -n, Mat4.fromTranslation(o2[0], i), i[0] = e, i[1] = n, Mat4.fromTranslation(o2[1], i);
        break;
      default:
        Mat4.identity(o2[0]), Mat4.identity(o2[1]);
    }
    return o2;
  }
}
class AnimationScheduler {
  static #it = {};
  static #$t = Object.freeze({ default: false });
  static #bt(t4, e, n, o2, i, a, r2, s2 = lerp, c, l, u) {
    TJSPositionDataUtil.setNumericDefaults(e), TJSPositionDataUtil.setNumericDefaults(n);
    for (const t5 in e) Number.isFinite(e[t5]) || delete e[t5];
    const p2 = Object.keys(e), d = Object.assign({}, e);
    if (0 === p2.length) return null;
    const m = { active: true, cleanup: u, cancelled: false, control: void 0, current: 0, destination: n, duration: 1e3 * o2, ease: r2, el: i, finished: false, initial: e, interpolate: s2, keys: p2, newData: d, position: t4, resolve: void 0, start: void 0, transformOrigin: c, transformOriginInitial: l, quickTo: false };
    return a > 0 && (m.active = false, setTimeout(() => m.active = true, 1e3 * a)), AnimationManager.add(m), new AnimationControl(m, true);
  }
  static from(t4, e, n = {}, o2) {
    if (!isObject$1(e)) throw new TypeError("AnimationAPI.from error: 'fromData' is not an object.");
    const i = t4.parent;
    if (void 0 !== i && "boolean" == typeof i?.options?.positionable && !i?.options?.positionable) return null;
    let { delay: a = 0, duration: r2 = 1, ease: s2 = "cubicOut", strategy: c, transformOrigin: l } = n;
    if (void 0 !== c && null === this.#yt(t4, c)) return null;
    const u = A11yHelper.isFocusTarget(i) ? i : i?.elementTarget, p2 = A11yHelper.isFocusTarget(u) && u.isConnected ? u : void 0;
    if (!Number.isFinite(a) || a < 0) throw new TypeError("AnimationScheduler.from error: 'delay' is not a positive number.");
    if (!Number.isFinite(r2) || r2 < 0) throw new TypeError("AnimationScheduler.from error: 'duration' is not a positive number.");
    if (s2 = getEasingFunc(s2, this.#$t), "function" != typeof s2) throw new TypeError("AnimationScheduler.from error: 'ease' is not a function or valid Svelte easing function name.");
    const d = {}, m = {};
    t4.get(this.#it), l = TJSTransforms.isTransformOrigin(l) ? l : void 0;
    const f = void 0 !== l ? this.#it.transformOrigin : void 0;
    for (const t5 in e) {
      const n2 = TJSPositionDataUtil.getAnimationKey(t5);
      void 0 !== this.#it[n2] && e[t5] !== this.#it[n2] && (d[t5] = e[t5], m[t5] = this.#it[n2]);
    }
    return ConvertStringData.process(d, this.#it, p2), this.#bt(t4, d, m, r2, p2, a, s2, lerp, l, f, o2);
  }
  static fromTo(t4, e, n, o2 = {}, i) {
    if (!isObject$1(e)) throw new TypeError("AnimationScheduler.fromTo error: 'fromData' is not an object.");
    if (!isObject$1(n)) throw new TypeError("AnimationScheduler.fromTo error: 'toData' is not an object.");
    const a = t4.parent;
    if (void 0 !== a && "boolean" == typeof a?.options?.positionable && !a?.options?.positionable) return null;
    let { delay: r2 = 0, duration: s2 = 1, ease: c = "cubicOut", strategy: l, transformOrigin: u } = o2;
    if (void 0 !== l && null === this.#yt(t4, l)) return null;
    const p2 = A11yHelper.isFocusTarget(a) ? a : a?.elementTarget, d = A11yHelper.isFocusTarget(p2) && p2.isConnected ? p2 : void 0;
    if (!Number.isFinite(r2) || r2 < 0) throw new TypeError("AnimationScheduler.fromTo error: 'delay' is not a positive number.");
    if (!Number.isFinite(s2) || s2 < 0) throw new TypeError("AnimationScheduler.fromTo error: 'duration' is not a positive number.");
    if (c = getEasingFunc(c, this.#$t), "function" != typeof c) throw new TypeError("AnimationScheduler.fromTo error: 'ease' is not a function or valid Svelte easing function name.");
    const m = {}, f = {};
    t4.get(this.#it), u = TJSTransforms.isTransformOrigin(u) ? u : void 0;
    const _ = void 0 !== u ? this.#it.transformOrigin : void 0;
    for (const t5 in e) {
      if (void 0 === n[t5]) {
        console.warn(`AnimationScheduler.fromTo warning: skipping key ('${t5}') from 'fromData' as it is missing in 'toData'.`);
        continue;
      }
      const o3 = TJSPositionDataUtil.getAnimationKey(t5);
      void 0 !== this.#it[o3] && (m[t5] = e[t5], f[t5] = n[t5]);
    }
    return ConvertStringData.process(m, this.#it, d), ConvertStringData.process(f, this.#it, d), this.#bt(t4, m, f, s2, d, r2, c, lerp, u, _, i);
  }
  static to(t4, e, n, o2) {
    if (!isObject$1(e)) throw new TypeError("AnimationScheduler.to error: 'toData' is not an object.");
    const i = t4.parent;
    if (void 0 !== i && "boolean" == typeof i?.options?.positionable && !i?.options?.positionable) return null;
    let { delay: a = 0, duration: r2 = 1, ease: s2 = "cubicOut", strategy: c, transformOrigin: l } = n;
    if (void 0 !== c && null === this.#yt(t4, c)) return null;
    const u = A11yHelper.isFocusTarget(i) ? i : i?.elementTarget, p2 = A11yHelper.isFocusTarget(u) && u.isConnected ? u : void 0;
    if (!Number.isFinite(a) || a < 0) throw new TypeError("AnimationScheduler.to error: 'delay' is not a positive number.");
    if (!Number.isFinite(r2) || r2 < 0) throw new TypeError("AnimationScheduler.to error: 'duration' is not a positive number.");
    if (s2 = getEasingFunc(s2, this.#$t), "function" != typeof s2) throw new TypeError("AnimationScheduler.to error: 'ease' is not a function or valid Svelte easing function name.");
    const d = {}, m = {};
    t4.get(this.#it), l = TJSTransforms.isTransformOrigin(l) ? l : void 0;
    const f = void 0 !== l ? this.#it.transformOrigin : void 0;
    for (const t5 in e) {
      const n2 = TJSPositionDataUtil.getAnimationKey(t5);
      void 0 !== this.#it[n2] && e[t5] !== this.#it[n2] && (m[t5] = e[t5], d[t5] = this.#it[n2]);
    }
    return ConvertStringData.process(m, this.#it, p2), this.#bt(t4, d, m, r2, p2, a, s2, lerp, l, f, o2);
  }
  static #yt(t4, e) {
    switch (e) {
      case "cancel":
        AnimationManager.isScheduled(t4) && AnimationManager.cancel(t4);
        break;
      case "cancelAll":
        AnimationManager.isScheduled(t4) && AnimationManager.cancel(t4, AnimationManager.cancelAllFn);
        break;
      case "exclusive":
        if (AnimationManager.isScheduled(t4)) return null;
        break;
      default:
        return console.warn("AnimationScheduler error: 'strategy' is not 'cancel', 'cancelAll', or 'exclusive'."), null;
    }
  }
}
class AnimationAPIImpl {
  static #$t = Object.freeze({ default: false });
  #it;
  #vt;
  constructor(t4, e) {
    this.#vt = t4, this.#it = e, Object.seal(this);
  }
  get isScheduled() {
    return AnimationManager.isScheduled(this.#vt);
  }
  cancel() {
    AnimationManager.cancel(this.#vt, AnimationManager.cancelAllFn);
  }
  getScheduled() {
    return AnimationManager.getScheduled(this.#vt);
  }
  from(t4, e) {
    const n = AnimationScheduler.from(this.#vt, t4, e);
    return n || AnimationControl.voidControl;
  }
  fromTo(t4, e, n) {
    const o2 = AnimationScheduler.fromTo(this.#vt, t4, e, n);
    return o2 || AnimationControl.voidControl;
  }
  to(t4, e) {
    const n = AnimationScheduler.to(this.#vt, t4, e);
    return n || AnimationControl.voidControl;
  }
  quickTo(t4, e = {}) {
    if (!isIterable(t4)) throw new TypeError("AnimationAPI.quickTo error: 'keys' is not an iterable list.");
    const n = this.#vt.parent;
    if (void 0 !== n && "boolean" == typeof n?.options?.positionable && !n?.options?.positionable) throw new Error("AnimationAPI.quickTo error: 'parent' is not positionable.");
    let { duration: o2 = 1, ease: i = "cubicOut" } = e;
    if (!Number.isFinite(o2) || o2 < 0) throw new TypeError("AnimationAPI.quickTo error: 'duration' is not a positive number.");
    if (i = getEasingFunc(i, AnimationAPIImpl.#$t), "function" != typeof i) throw new TypeError("AnimationAPI.quickTo error: 'ease' is not a function or valid Svelte easing function name.");
    const a = {}, r2 = {}, s2 = this.#it;
    for (const e2 of t4) {
      if ("string" != typeof e2) throw new TypeError(`AnimationAPI.quickTo error: key ('${e2}') is not a string.`);
      if (!TJSPositionDataUtil.isAnimationKey(e2)) throw new Error(`AnimationAPI.quickTo error: key ('${e2}') is not animatable.`);
      const t5 = TJSPositionDataUtil.getDataOrDefault(s2, e2);
      null !== t5 && (r2[e2] = t5, a[e2] = t5);
    }
    const c = [...t4];
    Object.freeze(c);
    const l = Object.assign({}, a), u = { active: true, cancelled: false, control: void 0, current: 0, destination: r2, duration: 1e3 * o2, ease: i, el: void 0, finished: true, initial: a, interpolate: lerp, keys: c, newData: l, position: this.#vt, resolve: void 0, start: 0, quickTo: true }, p2 = (...t5) => {
      const e2 = t5.length;
      if (0 === e2) return;
      for (let t6 = c.length; --t6 >= 0; ) {
        const e3 = c[t6], n2 = TJSPositionDataUtil.getAnimationKey(e3);
        void 0 !== s2[n2] && (a[e3] = s2[n2]);
      }
      if (isObject$1(t5[0])) {
        const e3 = t5[0];
        for (const t6 in e3) void 0 !== r2[t6] && (r2[t6] = e3[t6]);
      } else for (let n2 = 0; n2 < e2 && n2 < c.length; n2++) {
        const e3 = c[n2];
        void 0 !== r2[e3] && (r2[e3] = t5[n2]);
      }
      TJSPositionDataUtil.setNumericDefaults(a), TJSPositionDataUtil.setNumericDefaults(r2);
      const o3 = A11yHelper.isFocusTarget(n) ? n : n?.elementTarget;
      if (u.el = A11yHelper.isFocusTarget(o3) && o3.isConnected ? o3 : void 0, ConvertStringData.process(r2, s2, u.el), u.finished) u.cancelled = false, u.finished = false, u.active = true, u.current = 0, AnimationManager.add(u);
      else {
        const t6 = globalThis.performance.now();
        u.cancelled = false, u.current = 0, u.start = t6 + (AnimationManager.timeNow - t6);
      }
    };
    return Object.defineProperty(p2, "keys", { value: c, writable: false, configurable: false }), Object.defineProperty(p2, "options", { value: (t5) => {
      let { duration: e2, ease: n2 } = t5;
      if (void 0 !== e2 && (!Number.isFinite(e2) || e2 < 0)) throw new TypeError("AnimationAPI.quickTo.options error: 'duration' is not a positive number.");
      if (n2 = getEasingFunc(n2, AnimationAPIImpl.#$t), void 0 !== n2 && "function" != typeof n2) throw new TypeError("AnimationAPI.quickTo.options error: 'ease' is not a function or valid Svelte easing function name.");
      return NumberGuard.isFinite(e2) && e2 >= 0 && (u.duration = 1e3 * e2), n2 && (u.ease = n2), p2;
    }, writable: false, configurable: false }), p2;
  }
}
class AnimationGroupControl {
  #kt;
  #j;
  static #N = new AnimationGroupControl(null);
  static get voidControl() {
    return this.#N;
  }
  constructor(t4) {
    this.#kt = t4;
  }
  get finished() {
    const t4 = this.#kt;
    if (!CrossWindow.isPromise(this.#j)) if (null == t4 || 0 === t4.size) this.#j = Promise.resolve({ cancelled: false });
    else {
      const e = [];
      for (const n of t4) e.push(n.finished);
      this.#j = Promise.allSettled(e).then((t5) => ({ cancelled: t5.some((t6) => "rejected" === t6.status || "fulfilled" === t6.status && t6.value.cancelled) }));
    }
    return this.#j;
  }
  get isActive() {
    const t4 = this.#kt;
    if (null == t4 || 0 === t4.size) return false;
    for (const e of t4) if (e.isActive) return true;
    return false;
  }
  get isFinished() {
    const t4 = this.#kt;
    if (null == t4 || 0 === t4.size) return true;
    for (const e of t4) if (!e.isFinished) return false;
    return true;
  }
  cancel() {
    const t4 = this.#kt;
    if (null != t4 && 0 !== t4.size) for (const e of t4) e.cancel();
  }
}
class AnimationGroupAPIImpl {
  constructor() {
  }
  static #wt(t4) {
    return isObject$1(t4) ? t4.animate instanceof AnimationAPIImpl ? t4 : t4.position?.animate instanceof AnimationAPIImpl ? t4.position : null : null;
  }
  static cancel(t4) {
    if (isIterable(t4)) {
      let e = -1;
      for (const n of t4) {
        e++;
        const t5 = this.#wt(n);
        t5 ? AnimationManager.cancel(t5) : console.warn(`AnimationGroupAPI.cancel warning: No TJSPosition instance found at index: ${e}.`);
      }
    } else {
      const e = this.#wt(t4);
      if (!e) return void console.warn("AnimationGroupAPI.cancel warning: No TJSPosition instance found.");
      AnimationManager.cancel(e);
    }
  }
  static cancelAll() {
    AnimationManager.cancelAll();
  }
  static getScheduled(t4) {
    const e = [];
    if (isIterable(t4)) {
      let n = -1;
      for (const o2 of t4) {
        n++;
        const t5 = this.#wt(o2);
        if (!t5) {
          console.warn(`AnimationGroupAPI.getScheduled warning: No TJSPosition instance found at index: ${n}.`);
          continue;
        }
        const i = AnimationManager.getScheduled(t5);
        e.push({ position: t5, entry: t5 !== o2 ? o2 : void 0, controls: i });
      }
    } else {
      const n = this.#wt(t4);
      if (!n) return console.warn("AnimationGroupAPI.getScheduled warning: No TJSPosition instance found."), e;
      const o2 = AnimationManager.getScheduled(n);
      e.push({ position: n, entry: n !== t4 ? t4 : void 0, controls: o2 });
    }
    return e;
  }
  static isAnimationKey(t4) {
    return TJSPositionDataUtil.isAnimationKey(t4);
  }
  static isScheduled(t4, e) {
    if (isIterable(t4)) {
      let n = -1;
      for (const o2 of t4) {
        n++;
        const t5 = this.#wt(o2);
        if (t5) {
          if (!AnimationManager.isScheduled(t5, e)) return false;
        } else console.warn(`AnimationGroupAPI.isScheduled warning: No TJSPosition instance found at index: ${n}.`);
      }
    } else {
      const n = this.#wt(t4);
      if (!n) return console.warn("AnimationGroupAPI.isScheduled warning: No TJSPosition instance found."), false;
      if (!AnimationManager.isScheduled(n, e)) return false;
    }
    return true;
  }
  static from(t4, e, n) {
    if (!isObject$1(e) && "function" != typeof e) throw new TypeError("AnimationGroupAPI.from error: 'fromData' is not an object or function.");
    if (void 0 !== n && !isObject$1(n) && "function" != typeof n) throw new TypeError("AnimationGroupAPI.from error: 'options' is not an object or function.");
    const o2 = /* @__PURE__ */ new Set(), i = (t5) => o2.delete(t5.control);
    let a, r2 = -1;
    const s2 = "function" == typeof e, c = "function" == typeof n, l = s2 || c;
    l && (a = { index: r2, position: void 0, entry: void 0 });
    let u = e, p2 = isObject$1(n) ? n : void 0;
    if (isIterable(t4)) for (const d of t4) {
      r2++;
      const t5 = this.#wt(d);
      if (!t5) {
        console.warn(`AnimationGroupAPI.from warning: No TJSPosition instance found at index: ${r2}.`);
        continue;
      }
      if (l && (a.index = r2, a.position = t5, a.entry = t5 !== d ? d : void 0), s2 && "function" == typeof e) {
        if (u = e(a), null == u) continue;
        if (!isObject$1(u)) throw new TypeError(`AnimationGroupAPI.from error: 'fromData' callback function iteration(${r2}) failed to return an object.`);
      }
      if (c && "function" == typeof n) {
        if (p2 = n(a), null == p2) continue;
        if (!isObject$1(p2)) throw new TypeError(`AnimationGroupAPI.from error: 'options' callback function iteration(${r2}) failed to return an object.`);
      }
      const m = AnimationScheduler.from(t5, u, p2, i);
      m && o2.add(m);
    }
    else {
      const r3 = this.#wt(t4);
      if (!r3) return console.warn("AnimationGroupAPI.from warning: No TJSPosition instance found."), AnimationGroupControl.voidControl;
      if (l && (a.index = 0, a.position = r3, a.entry = r3 !== t4 ? t4 : void 0), s2 && "function" == typeof e) {
        if (u = e(a), null == u) return AnimationGroupControl.voidControl;
        if (!isObject$1(u)) throw new TypeError("AnimationGroupAPI.from error: 'fromData' callback function failed to return an object.");
      }
      if (c && "function" == typeof n) {
        if (p2 = n(a), null == p2) return AnimationGroupControl.voidControl;
        if (!isObject$1(p2)) throw new TypeError("AnimationGroupAPI.from error: 'options' callback function failed to return an object.");
      }
      const d = AnimationScheduler.from(r3, u, p2, i);
      d && o2.add(d);
    }
    return new AnimationGroupControl(o2);
  }
  static fromTo(t4, e, n, o2) {
    if (!isObject$1(e) && "function" != typeof e) throw new TypeError("AnimationGroupAPI.fromTo error: 'fromData' is not an object or function.");
    if (!isObject$1(n) && "function" != typeof n) throw new TypeError("AnimationGroupAPI.fromTo error: 'toData' is not an object or function.");
    if (void 0 !== o2 && !isObject$1(o2) && "function" != typeof o2) throw new TypeError("AnimationGroupAPI.fromTo error: 'options' is not an object or function.");
    const i = /* @__PURE__ */ new Set(), a = (t5) => i.delete(t5.control);
    let r2, s2 = -1;
    const c = "function" == typeof e, l = "function" == typeof n, u = "function" == typeof o2, p2 = c || l || u;
    p2 && (r2 = { index: s2, position: void 0, entry: void 0 });
    let d = e, m = n, f = isObject$1(o2) ? o2 : void 0;
    if (isIterable(t4)) for (const _ of t4) {
      s2++;
      const t5 = this.#wt(_);
      if (!t5) {
        console.warn(`AnimationGroupAPI.fromTo warning: No TJSPosition instance found at index: ${s2}.`);
        continue;
      }
      if (p2 && (r2.index = s2, r2.position = t5, r2.entry = t5 !== _ ? _ : void 0), c && "function" == typeof e) {
        if (d = e(r2), null == d) continue;
        if (!isObject$1(d)) throw new TypeError(`AnimationGroupAPI.fromTo error: 'fromData' callback function iteration(${s2}) failed to return an object.`);
      }
      if (l && "function" == typeof n) {
        if (m = n(r2), null == m) continue;
        if (!isObject$1(m)) throw new TypeError(`AnimationGroupAPI.fromTo error: 'toData' callback function iteration(${s2}) failed to return an object.`);
      }
      if (u && "function" == typeof o2) {
        if (f = o2(r2), null == f) continue;
        if (!isObject$1(f)) throw new TypeError(`AnimationGroupAPI.fromTo error: 'options' callback function iteration(${s2}) failed to return an object.`);
      }
      const h = AnimationScheduler.fromTo(t5, d, m, f, a);
      h && i.add(h);
    }
    else {
      const s3 = this.#wt(t4);
      if (!s3) return console.warn("AnimationGroupAPI.fromTo warning: No TJSPosition instance found."), AnimationGroupControl.voidControl;
      if (p2 && (r2.index = 0, r2.position = s3, r2.entry = s3 !== t4 ? t4 : void 0), c && "function" == typeof e) {
        if (d = e(r2), null == d) return AnimationGroupControl.voidControl;
        if (!isObject$1(d)) throw new TypeError("AnimationGroupAPI.fromTo error: 'fromData' callback function failed to return an object.");
      }
      if (l && "function" == typeof n) {
        if (m = n(r2), null == m) return AnimationGroupControl.voidControl;
        if (!isObject$1(m)) throw new TypeError("AnimationGroupAPI.fromTo error: 'toData' callback function failed to return an object.");
      }
      if (u && "function" == typeof o2) {
        if (f = o2(r2), null == f) return AnimationGroupControl.voidControl;
        if (!isObject$1(f)) throw new TypeError("AnimationGroupAPI.fromTo error: 'options' callback function failed to return an object.");
      }
      const _ = AnimationScheduler.fromTo(s3, d, m, f, a);
      _ && i.add(_);
    }
    return new AnimationGroupControl(i);
  }
  static to(t4, e, n) {
    if (!isObject$1(e) && "function" != typeof e) throw new TypeError("AnimationGroupAPI.to error: 'toData' is not an object or function.");
    if (void 0 !== n && !isObject$1(n) && "function" != typeof n) throw new TypeError("AnimationGroupAPI.to error: 'options' is not an object or function.");
    const o2 = /* @__PURE__ */ new Set(), i = (t5) => o2.delete(t5.control);
    let a, r2 = -1;
    const s2 = "function" == typeof e, c = "function" == typeof n, l = s2 || c;
    l && (a = { index: r2, position: void 0, entry: void 0 });
    let u = e, p2 = isObject$1(n) ? n : void 0;
    if (isIterable(t4)) for (const d of t4) {
      r2++;
      const t5 = this.#wt(d);
      if (!t5) {
        console.warn(`AnimationGroupAPI.to warning: No TJSPosition instance found at index: ${r2}.`);
        continue;
      }
      if (l && (a.index = r2, a.position = t5, a.entry = t5 !== d ? d : void 0), s2 && "function" == typeof e) {
        if (u = e(a), null == u) continue;
        if (!isObject$1(u)) throw new TypeError(`AnimationGroupAPI.to error: 'toData' callback function iteration(${r2}) failed to return an object.`);
      }
      if (c && "function" == typeof n) {
        if (p2 = n(a), null == p2) continue;
        if (!isObject$1(p2)) throw new TypeError(`AnimationGroupAPI.to error: 'options' callback function iteration(${r2}) failed to return an object.`);
      }
      const m = AnimationScheduler.to(t5, u, p2, i);
      m && o2.add(m);
    }
    else {
      const r3 = this.#wt(t4);
      if (!r3) return console.warn("AnimationGroupAPI.to warning: No TJSPosition instance found."), AnimationGroupControl.voidControl;
      if (l && (a.index = 0, a.position = r3, a.entry = r3 !== t4 ? t4 : void 0), s2 && "function" == typeof e) {
        if (u = e(a), null == u) return AnimationGroupControl.voidControl;
        if (!isObject$1(u)) throw new TypeError("AnimationGroupAPI.to error: 'toData' callback function failed to return an object.");
      }
      if (c && "function" == typeof n) {
        if (p2 = n(a), null == p2) return AnimationGroupControl.voidControl;
        if (!isObject$1(p2)) throw new TypeError("AnimationGroupAPI.to error: 'options' callback function failed to return an object.");
      }
      const d = AnimationScheduler.to(r3, u, p2, i);
      d && o2.add(d);
    }
    return new AnimationGroupControl(o2);
  }
  static quickTo(t4, e, n) {
    if (!isIterable(e)) throw new TypeError("AnimationGroupAPI.quickTo error: 'keys' is not an iterable list.");
    if (void 0 !== n && !isObject$1(n) && "function" != typeof n) throw new TypeError("AnimationGroupAPI.quickTo error: 'options' is not an object or function.");
    const o2 = [];
    let i = -1;
    const a = "function" == typeof n, r2 = { index: i, position: void 0, entry: void 0 };
    let s2 = isObject$1(n) ? n : void 0;
    if (isIterable(t4)) for (const c2 of t4) {
      i++;
      const t5 = this.#wt(c2);
      if (t5) {
        if (r2.index = i, r2.position = t5, r2.entry = t5 !== c2 ? c2 : void 0, a && "function" == typeof n) {
          if (s2 = n(r2), null == s2) continue;
          if (!isObject$1(s2)) throw new TypeError(`AnimationGroupAPI.quickTo error: 'options' callback function iteration(${i}) failed to return an object.`);
        }
        o2.push(t5.animate.quickTo(e, s2));
      } else console.warn(`AnimationGroupAPI.quickTo warning: No TJSPosition instance found at index: ${i}.`);
    }
    else {
      const i2 = this.#wt(t4);
      if (!i2) return void console.warn("AnimationGroupAPI.quickTo warning: No TJSPosition instance found.");
      if (r2.index = 0, r2.position = i2, r2.entry = i2 !== t4 ? t4 : void 0, a && "function" == typeof n) {
        if (s2 = n(r2), null == s2) return;
        if (!isObject$1(s2)) throw new TypeError("AnimationGroupAPI.quickTo error: 'options' callback function failed to return an object.");
      }
      o2.push(i2.animate.quickTo(e, s2));
    }
    const c = [...e];
    Object.freeze(c);
    const l = (...e2) => {
      if (0 !== e2.length) if ("function" == typeof e2[0]) {
        const n2 = e2[0];
        i = -1;
        let a2 = 0;
        if (isIterable(t4)) for (const e3 of t4) {
          i++;
          const t5 = this.#wt(e3);
          if (!t5) continue;
          r2.index = i, r2.position = t5, r2.entry = t5 !== e3 ? e3 : void 0;
          const s3 = n2(r2);
          if (null == s3) continue;
          const c2 = isIterable(s3);
          if (!Number.isFinite(s3) && !c2 && !isObject$1(s3)) throw new TypeError(`AnimationGroupAPI.quickTo error: 'toData' callback function iteration(${i}) failed to return a finite number, iterable list, or object.`);
          c2 ? o2[a2++](...s3) : o2[a2++](s3);
        }
        else {
          const e3 = this.#wt(t4);
          if (!e3) return;
          r2.index = 0, r2.position = e3, r2.entry = e3 !== t4 ? t4 : void 0;
          const s3 = n2(r2);
          if (null == s3) return;
          const c2 = isIterable(s3);
          if (!Number.isFinite(s3) && !c2 && !isObject$1(s3)) throw new TypeError(`AnimationGroupAPI.quickTo error: 'toData' callback function iteration(${i}) failed to return a finite number, iterable list, or object.`);
          c2 ? o2[a2++](...s3) : o2[a2++](s3);
        }
      } else for (let t5 = o2.length; --t5 >= 0; ) o2[t5](...e2);
    };
    return Object.defineProperty(l, "keys", { value: c, writable: false, configurable: false }), Object.defineProperty(l, "options", { value: (t5) => {
      if (void 0 !== t5 && !isObject$1(t5)) throw new TypeError("AnimationGroupAPI.quickTo error: 'options' is not an object.");
      if (isObject$1(t5)) for (let e2 = o2.length; --e2 >= 0; ) o2[e2].options(t5);
      return l;
    }, writable: false, configurable: false }), l;
  }
}
Object.seal(AnimationGroupAPIImpl);
class PositionStateAPI {
  #it;
  #St = /* @__PURE__ */ new Map();
  #vt;
  #Tt;
  constructor(t4, e, n) {
    this.#vt = t4, this.#it = e, this.#Tt = n, Object.seal(this);
  }
  clear() {
    for (const t4 of this.#St.keys()) "#defaultData" !== t4 && this.#St.delete(t4);
  }
  get({ name: t4 }) {
    if ("string" != typeof t4) throw new TypeError("TJSPosition - get error: 'name' is not a string.");
    return this.#St.get(t4);
  }
  getDefault() {
    return this.#St.get("#defaultData");
  }
  keys() {
    return this.#St.keys();
  }
  remove({ name: t4 }) {
    if ("string" != typeof t4) throw new TypeError("TJSPosition - remove: 'name' is not a string.");
    const e = this.#St.get(t4);
    return this.#St.delete(t4), e;
  }
  reset({ keepZIndex: t4 = false, invokeSet: e = true } = {}) {
    const n = this.#St.get("#defaultData");
    if (!isObject$1(n)) return false;
    this.#vt.animate.isScheduled && this.#vt.animate.cancel();
    const o2 = this.#vt.zIndex, i = Object.assign({}, n);
    t4 && (i.zIndex = o2), this.#Tt.reset(i);
    const a = this.#vt.parent;
    return a?.reactive?.minimized && a?.maximize?.({ animate: false, duration: 0 }), e && setTimeout(() => this.#vt.set(i), 0), true;
  }
  restore({ name: t4, remove: e = false, properties: n, silent: o2 = false, async: i = false, animateTo: a = false, duration: r2 = 0.1, ease: s2 = "linear" }) {
    if ("string" != typeof t4) throw new TypeError("TJSPosition - restore error: 'name' is not a string.");
    const c = this.#St.get(t4);
    if (c) {
      e && this.#St.delete(t4);
      let l = c;
      if (isIterable(n)) {
        l = {};
        for (const t5 of n) l[t5] = c[t5];
      }
      if (o2) {
        for (const t5 in l) t5 in this.#it && (this.#it[t5] = l[t5]);
        return c;
      }
      if (a) {
        if (l.transformOrigin !== this.#vt.transformOrigin && (this.#vt.transformOrigin = l.transformOrigin), i) return this.#vt.animate.to(l, { duration: r2, ease: s2 }).finished.then(() => c);
        this.#vt.animate.to(l, { duration: r2, ease: s2 });
      } else this.#vt.set(l);
    }
    return i ? Promise.resolve(c) : c;
  }
  save({ name: t4, ...e }, n) {
    if ("string" != typeof t4) throw new TypeError("TJSPosition - save error: 'name' is not a string.");
    const o2 = this.#vt.get(e, n);
    return this.#St.set(t4, o2), o2;
  }
  set({ name: t4, ...e }) {
    if ("string" != typeof t4) throw new TypeError("TJSPosition - set error: 'name' is not a string.");
    this.#St.set(t4, e);
  }
}
class SystemBase {
  #xt;
  #Et;
  #Ot;
  #At;
  #Ct;
  #C = [];
  #Dt;
  constructor({ constrain: t4 = true, element: e, enabled: n = true, lock: o2 = false, width: i, height: a } = {}) {
    this.#xt = true, this.#Ot = true, this.constrain = t4, this.element = e, this.enabled = n, this.width = i, this.height = a, this.#Ct = "boolean" == typeof o2 && o2;
  }
  get constrain() {
    return this.#xt;
  }
  get element() {
    return this.#Et;
  }
  get enabled() {
    return this.#Ot;
  }
  get height() {
    return this.#At;
  }
  get locked() {
    return this.#Ct;
  }
  get width() {
    return this.#Dt;
  }
  set constrain(t4) {
    if (!this.#Ct) {
      if ("boolean" != typeof t4) throw new TypeError("'constrain' is not a boolean.");
      this.#xt = t4, this.#D();
    }
  }
  set element(t4) {
    if (!this.#Ct) {
      if (null != t4 && !A11yHelper.isFocusTarget(t4)) throw new TypeError("'element' is not a HTMLElement, undefined, or null.");
      this.#Et = t4, this.#D();
    }
  }
  set enabled(t4) {
    if (!this.#Ct) {
      if ("boolean" != typeof t4) throw new TypeError("'enabled' is not a boolean.");
      this.#Ot = t4, this.#D();
    }
  }
  set height(t4) {
    if (!this.#Ct) {
      if (void 0 !== t4 && !Number.isFinite(t4)) throw new TypeError("'height' is not a finite number or undefined.");
      this.#At = t4, this.#D();
    }
  }
  set width(t4) {
    if (!this.#Ct) {
      if (void 0 !== t4 && !Number.isFinite(t4)) throw new TypeError("'width' is not a finite number or undefined.");
      this.#Dt = t4, this.#D();
    }
  }
  setDimension(t4, e) {
    if (!this.#Ct) {
      if (void 0 !== t4 && !Number.isFinite(t4)) throw new TypeError("'width' is not a finite number or undefined.");
      if (this.#Dt = t4, void 0 !== e && !Number.isFinite(e)) throw new TypeError("'height' is not a finite number or undefined.");
      this.#At = e, this.#D();
    }
  }
  subscribe(t4) {
    return -1 === this.#C.findIndex((e) => e === t4) && (this.#C.push(t4), t4(this)), () => {
      const e = this.#C.findIndex((e2) => e2 === t4);
      -1 !== e && this.#C.splice(e, 1);
    };
  }
  #D() {
    for (let t4 = 0; t4 < this.#C.length; t4++) this.#C[t4](this);
  }
}
class Centered extends SystemBase {
  getLeft(t4) {
    return ((this.width ?? this.element?.offsetWidth ?? globalThis.innerWidth) - t4) / 2;
  }
  getTop(t4) {
    return ((this.height ?? this.element?.offsetHeight ?? globalThis.innerHeight) - t4) / 2;
  }
}
class AdapterValidators {
  #Ot = true;
  #Mt;
  #jt = /* @__PURE__ */ new Map();
  #It;
  static create(t4) {
    const e = new AdapterValidators(t4);
    return [e, e.#Mt];
  }
  constructor(t4) {
    this.#Mt = [], this.#It = t4, Object.seal(this);
  }
  get enabled() {
    return this.#Ot;
  }
  get length() {
    return this.#Mt.length;
  }
  set enabled(t4) {
    if ("boolean" != typeof t4) throw new TypeError("'enabled' is not a boolean.");
    this.#Ot = t4;
  }
  *[Symbol.iterator]() {
    if (0 !== this.#Mt.length) for (const t4 of this.#Mt) yield { ...t4 };
  }
  add(...t4) {
    let e = 0;
    for (const n of t4) {
      const t5 = typeof n;
      if ("function" !== t5 && "object" !== t5 || null === n) throw new TypeError("AdapterValidator error: 'validator' is not a function or object.");
      let o2, i;
      switch (t5) {
        case "function":
          o2 = { id: void 0, validate: n, weight: 1 }, i = n.subscribe;
          break;
        case "object":
          if (!("validate" in n)) throw new TypeError("AdapterValidator error: 'validate' attribute is not a function.");
          if ("function" != typeof n.validate) throw new TypeError("AdapterValidator error: 'validate' attribute is not a function.");
          if (void 0 !== n.weight && "number" != typeof n.weight || n?.weight < 0 || n?.weight > 1) throw new TypeError("AdapterValidator error: 'weight' attribute is not a number between '0 - 1' inclusive.");
          o2 = { id: void 0 !== n.id ? n.id : void 0, validate: n.validate.bind(n), weight: n.weight || 1 }, i = n.validate.subscribe ?? n.subscribe;
      }
      const a = this.#Mt.findIndex((t6) => o2.weight < t6.weight);
      if (a >= 0 ? this.#Mt.splice(a, 0, o2) : this.#Mt.push(o2), "function" == typeof i) {
        const t6 = i.call(n, this.#It);
        if ("function" != typeof t6) throw new TypeError("AdapterValidator error: Validator has subscribe function, but no unsubscribe function is returned.");
        if (this.#jt.has(o2.validate)) throw new Error("AdapterValidator error: Validator added already has an unsubscribe function registered.");
        this.#jt.set(o2.validate, t6), e++;
      }
    }
    e < t4.length && this.#It();
  }
  clear() {
    this.#Mt.length = 0;
    for (const t4 of this.#jt.values()) t4();
    this.#jt.clear(), this.#It();
  }
  remove(...t4) {
    const e = this.#Mt.length;
    if (0 !== e) {
      for (const e2 of t4) {
        const t5 = "function" == typeof e2 ? e2 : isObject$1(e2) ? e2.validate : void 0;
        if (t5) {
          for (let e3 = this.#Mt.length; --e3 >= 0; ) if (this.#Mt[e3].validate === t5) {
            let n;
            this.#Mt.splice(e3, 1), "function" == typeof (n = this.#jt.get(t5)) && (n(), this.#jt.delete(t5));
          }
        }
      }
      e !== this.#Mt.length && this.#It();
    }
  }
  removeBy(t4) {
    const e = this.#Mt.length;
    if (0 !== e) {
      if ("function" != typeof t4) throw new TypeError("AdapterValidator error: 'callback' is not a function.");
      this.#Mt = this.#Mt.filter((e2) => {
        const n = t4.call(t4, { ...e2 });
        if (n) {
          let t5;
          "function" == typeof (t5 = this.#jt.get(e2.validate)) && (t5(), this.#jt.delete(e2.validate));
        }
        return !n;
      }), e !== this.#Mt.length && this.#It();
    }
  }
  removeById(...t4) {
    const e = this.#Mt.length;
    0 !== e && (this.#Mt = this.#Mt.filter((e2) => {
      let n = false;
      for (const o2 of t4) n ||= e2.id === o2;
      if (n) {
        let t5;
        "function" == typeof (t5 = this.#jt.get(e2.validate)) && (t5(), this.#jt.delete(e2.validate));
      }
      return !n;
    }), e !== this.#Mt.length && this.#It());
  }
}
class TransformBounds extends SystemBase {
  static #Nt = new TJSTransformData();
  validate(t4) {
    if (!this.enabled) return t4.position;
    const e = this.width ?? this.element?.offsetWidth ?? globalThis.innerWidth, n = this.height ?? this.element?.offsetHeight ?? globalThis.innerHeight;
    if ("number" == typeof t4.position.width) {
      const n2 = t4.maxWidth ?? (this.constrain ? e : Number.MAX_SAFE_INTEGER);
      t4.position.width = clamp(t4.width, t4.minWidth, n2);
    }
    if ("number" == typeof t4.position.height) {
      const e2 = t4.maxHeight ?? (this.constrain ? n : Number.MAX_SAFE_INTEGER);
      t4.position.height = clamp(t4.height, t4.minHeight, e2);
    }
    const o2 = t4.transforms.getData(t4.position, TransformBounds.#Nt, t4), i = o2.boundingRect.x, a = o2.boundingRect.y, r2 = t4.marginTop ?? 0, s2 = t4.marginLeft ?? 0;
    return o2.boundingRect.bottom + r2 > n && (o2.boundingRect.y += n - o2.boundingRect.bottom - r2), o2.boundingRect.right + s2 > e && (o2.boundingRect.x += e - o2.boundingRect.right - s2), o2.boundingRect.top - r2 < 0 && (o2.boundingRect.y += Math.abs(o2.boundingRect.top - r2)), o2.boundingRect.left - s2 < 0 && (o2.boundingRect.x += Math.abs(o2.boundingRect.left - s2)), t4.position.left -= i - o2.boundingRect.x, t4.position.top -= a - o2.boundingRect.y, t4.position;
  }
}
class PositionChangeSet {
  left;
  top;
  width;
  height;
  maxHeight;
  maxWidth;
  minHeight;
  minWidth;
  zIndex;
  transform;
  transformOrigin;
  constructor() {
    this.left = false, this.top = false, this.width = false, this.height = false, this.maxHeight = false, this.maxWidth = false, this.minHeight = false, this.minWidth = false, this.zIndex = false, this.transform = false, this.transformOrigin = false;
  }
  hasChange() {
    return this.left || this.top || this.width || this.height || this.maxHeight || this.maxWidth || this.minHeight || this.minWidth || this.zIndex || this.transform || this.transformOrigin;
  }
  set(t4) {
    this.left = t4, this.top = t4, this.width = t4, this.height = t4, this.maxHeight = t4, this.maxWidth = t4, this.minHeight = t4, this.minWidth = t4, this.zIndex = t4, this.transform = t4, this.transformOrigin = t4;
  }
}
class UpdateElementData {
  changeSet;
  data;
  dataSubscribers;
  dimensionData;
  options;
  queued;
  storeDimension;
  storeTransform;
  styleCache;
  subscribers;
  transforms;
  transformData;
  constructor(t4, e, n, o2, i, a) {
    this.changeSet = t4, this.data = e, this.dataSubscribers = Object.seal(new TJSPositionData()), this.dimensionData = Object.seal({ width: 0, height: 0 }), this.options = n, this.queued = false, this.styleCache = o2, this.storeDimension = writable(this.dimensionData), this.subscribers = i, this.transforms = a, this.transformData = new TJSTransformData(), this.storeTransform = writable(this.transformData, () => (this.options.transformSubscribed = true, () => this.options.transformSubscribed = false));
  }
}
class UpdateElementManager {
  static list = [];
  static listCntr = 0;
  static updatePromise;
  static add(t4, e) {
    if (this.listCntr < this.list.length) {
      const n = this.list[this.listCntr];
      n[0] = t4, n[1] = e;
    } else this.list.push([t4, e]);
    return this.listCntr++, e.queued = true, this.updatePromise || (this.updatePromise = this.wait()), this.updatePromise;
  }
  static async wait() {
    const t4 = await nextAnimationFrame();
    this.updatePromise = void 0;
    for (let t5 = this.listCntr; --t5 >= 0; ) {
      const e = this.list[t5], n = e[0], o2 = e[1];
      e[0] = void 0, e[1] = void 0, o2.queued = false, n.isConnected && (o2.options.ortho ? UpdateElementManager.#Pt(n, o2) : UpdateElementManager.#Ft(n, o2), (o2.options.calculateTransform || o2.options.transformSubscribed) && UpdateElementManager.#Rt(o2), this.updateSubscribers(o2));
    }
    return this.listCntr = 0, t4;
  }
  static immediate(t4, e) {
    t4.isConnected && (e.options.ortho ? UpdateElementManager.#Pt(t4, e) : UpdateElementManager.#Ft(t4, e), (e.options.calculateTransform || e.options.transformSubscribed) && UpdateElementManager.#Rt(e), this.updateSubscribers(e));
  }
  static updateSubscribers(t4) {
    const e = t4.data, n = t4.changeSet;
    if (!n.hasChange()) return;
    const o2 = TJSPositionDataUtil.copyData(e, t4.dataSubscribers), i = t4.subscribers;
    if (i.length > 0) for (let t5 = 0; t5 < i.length; t5++) i[t5](o2);
    (n.width || n.height) && (t4.dimensionData.width = e.width, t4.dimensionData.height = e.height, t4.storeDimension.set(t4.dimensionData)), n.set(false);
  }
  static #Lt = Object.seal({ height: 0, width: 0, marginLeft: 0, marginTop: 0 });
  static #Ft(t4, e) {
    const n = e.changeSet, o2 = e.data;
    n.left && (t4.style.left = `${o2.left}px`), n.top && (t4.style.top = `${o2.top}px`), n.zIndex && (t4.style.zIndex = "number" == typeof o2.zIndex ? `${o2.zIndex}` : ""), n.width && (t4.style.width = "number" == typeof o2.width ? `${o2.width}px` : o2.width), n.height && (t4.style.height = "number" == typeof o2.height ? `${o2.height}px` : o2.height), n.transformOrigin && (t4.style.transformOrigin = o2.transformOrigin), n.transform && (t4.style.transform = e.transforms.isActive ? e.transforms.getCSS() : "");
  }
  static #Pt(t4, e) {
    const n = e.changeSet, o2 = e.data;
    n.zIndex && (t4.style.zIndex = "number" == typeof o2.zIndex ? `${o2.zIndex}` : ""), n.width && (t4.style.width = "number" == typeof o2.width ? `${o2.width}px` : o2.width), n.height && (t4.style.height = "number" == typeof o2.height ? `${o2.height}px` : o2.height), n.transformOrigin && (t4.style.transformOrigin = o2.transformOrigin), (n.left || n.top || n.transform) && (t4.style.transform = e.transforms.getCSSOrtho(o2));
  }
  static #Rt(t4) {
    const e = this.#Lt;
    e.height = "auto" !== t4.data.height && "inherit" !== t4.data.height ? t4.data.height : t4.styleCache.offsetHeight, e.width = "auto" !== t4.data.width && "inherit" !== t4.data.width ? t4.data.width : t4.styleCache.offsetWidth, e.marginLeft = t4.styleCache.marginLeft, e.marginTop = t4.styleCache.marginTop, t4.transforms.getData(t4.data, t4.transformData, e), t4.storeTransform.set(t4.transformData);
  }
}
class TJSPosition {
  static #Ht = Object.freeze({ browserCentered: new Centered({ lock: true }), Centered });
  static #zt = Object.freeze({ TransformBounds, transformWindow: new TransformBounds({ lock: true }) });
  #it = Object.seal(new TJSPositionData());
  #qt = new AnimationAPIImpl(this, this.#it);
  #Ot = true;
  #Wt = { calculateTransform: false, initial: void 0, ortho: true, transformSubscribed: false };
  #Ut;
  #Gt = new PositionChangeSet();
  #Bt = false;
  #l;
  #Jt;
  #C = [];
  #Tt = new TJSTransforms();
  #Vt;
  #Xt;
  #Yt;
  #Mt;
  #Zt = new PositionStateAPI(this, this.#it, this.#Tt);
  static get Animate() {
    return AnimationGroupAPIImpl;
  }
  static get Data() {
    return TJSPositionData;
  }
  static get Initial() {
    return this.#Ht;
  }
  static get SystemBase() {
    return SystemBase;
  }
  static get TransformData() {
    return TJSTransformData;
  }
  static get Validators() {
    return this.#zt;
  }
  static get transformOrigins() {
    return TJSTransforms.transformOrigins;
  }
  static copyData(t4, e) {
    return TJSPositionDataUtil.copyData(t4, e);
  }
  static duplicate(t4, e = {}) {
    if (!(t4 instanceof _a)) throw new TypeError("'position' is not an instance of TJSPosition.");
    const n = new _a(e);
    return n.#Wt = Object.assign({}, t4.#Wt, e), n.#Yt.add(...t4.#Yt), n.set(t4.#it), n;
  }
  constructor(t4, e) {
    isPlainObject(t4) ? e = t4 : this.#Ut = t4, this.#Jt = new TJSPositionStyleCache();
    const n = new UpdateElementData(this.#Gt, this.#it, this.#Wt, this.#Jt, this.#C, this.#Tt);
    if (this.#Vt = n, "boolean" == typeof e?.calculateTransform && (this.#Wt.calculateTransform = e.calculateTransform), "boolean" == typeof e?.ortho && (this.#Wt.ortho = e.ortho), this.#l = Object.freeze({ height: propertyStore(this, "height"), left: propertyStore(this, "left"), rotateX: propertyStore(this, "rotateX"), rotateY: propertyStore(this, "rotateY"), rotateZ: propertyStore(this, "rotateZ"), scale: propertyStore(this, "scale"), top: propertyStore(this, "top"), transformOrigin: propertyStore(this, "transformOrigin"), translateX: propertyStore(this, "translateX"), translateY: propertyStore(this, "translateY"), translateZ: propertyStore(this, "translateZ"), width: propertyStore(this, "width"), zIndex: propertyStore(this, "zIndex"), maxHeight: propertyStore(this, "maxHeight"), maxWidth: propertyStore(this, "maxWidth"), minHeight: propertyStore(this, "minHeight"), minWidth: propertyStore(this, "minWidth"), dimension: { subscribe: n.storeDimension.subscribe }, element: { subscribe: this.#Jt.stores.element.subscribe }, resizeContentHeight: { subscribe: this.#Jt.stores.resizeContentHeight.subscribe }, resizeContentWidth: { subscribe: this.#Jt.stores.resizeContentWidth.subscribe }, resizeObservable: { subscribe: this.#Jt.stores.resizeObservable.subscribe }, resizeOffsetHeight: { subscribe: this.#Jt.stores.resizeOffsetHeight.subscribe }, resizeOffsetWidth: { subscribe: this.#Jt.stores.resizeOffsetWidth.subscribe }, transform: { subscribe: n.storeTransform.subscribe }, resizeObserved: this.#Jt.stores.resizeObserved }), Object.defineProperty(this.#l.transformOrigin, "values", { get: () => _a.transformOrigins }), subscribeIgnoreFirst(this.#l.resizeObserved, (t5) => {
      const e2 = this.#Ut, n2 = A11yHelper.isFocusTarget(e2) ? e2 : e2?.elementTarget;
      A11yHelper.isFocusTarget(n2) && Number.isFinite(t5?.offsetWidth) && Number.isFinite(t5?.offsetHeight) && this.set();
    }), [this.#Yt, this.#Mt] = AdapterValidators.create(() => this.set()), e?.initial) {
      const t5 = e.initial;
      if ("function" != typeof t5?.getLeft || "function" != typeof t5?.getTop) throw new Error("'options.initial' position helper does not contain 'getLeft' and / or 'getTop' functions.");
      this.#Wt.initial = t5;
    }
    if (e?.validator) if (isIterable(e?.validator)) this.validators.add(...e.validator);
    else {
      const t5 = e.validator;
      this.validators.add(t5);
    }
    Object.seal(this), isObject$1(e) && this.set(e);
  }
  get animate() {
    return this.#qt;
  }
  get dimension() {
    return this.#Vt.dimensionData;
  }
  get enabled() {
    return this.#Ot;
  }
  get element() {
    return this.#Jt.el;
  }
  get elementUpdated() {
    return this.#Xt;
  }
  get parent() {
    return this.#Ut;
  }
  get state() {
    return this.#Zt;
  }
  get stores() {
    return this.#l;
  }
  get transform() {
    return this.#Vt.transformData;
  }
  get validators() {
    return this.#Yt;
  }
  set enabled(t4) {
    if ("boolean" != typeof t4) throw new TypeError("'enabled' is not a boolean.");
    this.#Ot = t4;
  }
  set parent(t4) {
    if (void 0 !== t4 && !A11yHelper.isFocusTarget(t4) && !isObject$1(t4)) throw new TypeError("'parent' is not an HTMLElement, object, or undefined.");
    this.#Ut = t4, this.#Zt.remove({ name: "#defaultData" }), this.#Jt.reset(), t4 && this.set(this.#it);
  }
  get height() {
    return this.#it.height;
  }
  get left() {
    return this.#it.left;
  }
  get maxHeight() {
    return this.#it.maxHeight;
  }
  get maxWidth() {
    return this.#it.maxWidth;
  }
  get minHeight() {
    return this.#it.minHeight;
  }
  get minWidth() {
    return this.#it.minWidth;
  }
  get rotateX() {
    return this.#it.rotateX;
  }
  get rotateY() {
    return this.#it.rotateY;
  }
  get rotateZ() {
    return this.#it.rotateZ;
  }
  get rotation() {
    return this.#it.rotateZ;
  }
  get scale() {
    return this.#it.scale;
  }
  get top() {
    return this.#it.top;
  }
  get transformOrigin() {
    return this.#it.transformOrigin;
  }
  get translateX() {
    return this.#it.translateX;
  }
  get translateY() {
    return this.#it.translateY;
  }
  get translateZ() {
    return this.#it.translateZ;
  }
  get width() {
    return this.#it.width;
  }
  get zIndex() {
    return this.#it.zIndex;
  }
  set height(t4) {
    this.#l.height.set(t4);
  }
  set left(t4) {
    this.#l.left.set(t4);
  }
  set maxHeight(t4) {
    this.#l.maxHeight.set(t4);
  }
  set maxWidth(t4) {
    this.#l.maxWidth.set(t4);
  }
  set minHeight(t4) {
    this.#l.minHeight.set(t4);
  }
  set minWidth(t4) {
    this.#l.minWidth.set(t4);
  }
  set rotateX(t4) {
    this.#l.rotateX.set(t4);
  }
  set rotateY(t4) {
    this.#l.rotateY.set(t4);
  }
  set rotateZ(t4) {
    this.#l.rotateZ.set(t4);
  }
  set rotation(t4) {
    this.#l.rotateZ.set(t4);
  }
  set scale(t4) {
    this.#l.scale.set(t4);
  }
  set top(t4) {
    this.#l.top.set(t4);
  }
  set transformOrigin(t4) {
    TJSTransforms.transformOrigins.includes(t4) && this.#l.transformOrigin.set(t4);
  }
  set translateX(t4) {
    this.#l.translateX.set(t4);
  }
  set translateY(t4) {
    this.#l.translateY.set(t4);
  }
  set translateZ(t4) {
    this.#l.translateZ.set(t4);
  }
  set width(t4) {
    this.#l.width.set(t4);
  }
  set zIndex(t4) {
    this.#l.zIndex.set(t4);
  }
  get(t4 = {}, e = {}) {
    const n = e?.keys, o2 = e?.exclude, i = e?.nullable ?? true, a = e?.numeric ?? false;
    if (isIterable(n)) {
      for (const e2 of n) t4[e2] = a ? TJSPositionDataUtil.getDataOrDefault(this, e2) : this[e2], i || null !== t4[e2] || delete t4[e2];
      if (isIterable(o2)) for (const e2 of o2) delete t4[e2];
      return t4;
    }
    if (t4 = Object.assign(t4, this.#it), isIterable(o2)) for (const e2 of o2) delete t4[e2];
    if (a && TJSPositionDataUtil.setNumericDefaults(t4), !i) for (const e2 in t4) null === t4[e2] && delete t4[e2];
    return t4;
  }
  toJSON() {
    return Object.assign({}, this.#it);
  }
  set(t4 = {}, e = {}) {
    if (!isObject$1(t4)) throw new TypeError("TJSPosition - set error: 'position' is not an object.");
    const n = this.#Ut;
    if (!this.#Ot) return this;
    if (void 0 !== n && "boolean" == typeof n?.options?.positionable && !n?.options?.positionable) return this;
    const o2 = e?.immediateElementUpdate ?? false, i = this.#it, a = this.#Tt, r2 = A11yHelper.isFocusTarget(n) ? n : n?.elementTarget, s2 = A11yHelper.isFocusTarget(r2) && r2.isConnected ? r2 : void 0, c = this.#Gt, l = this.#Jt;
    if (s2 && (l.hasData(s2) || (l.update(s2), l.hasWillChange, c.set(true), this.#Vt.queued = false), ConvertStringData.process(t4, this.#it, s2), null === (t4 = this.#Kt(t4, n, s2, l)))) return this;
    NumberGuard.isFinite(t4.left) && (t4.left = Math.round(t4.left), i.left !== t4.left && (i.left = t4.left, c.left = true)), NumberGuard.isFinite(t4.top) && (t4.top = Math.round(t4.top), i.top !== t4.top && (i.top = t4.top, c.top = true)), NumberGuard.isFiniteOrNull(t4.maxHeight) && (t4.maxHeight = "number" == typeof t4.maxHeight ? Math.round(t4.maxHeight) : null, i.maxHeight !== t4.maxHeight && (i.maxHeight = t4.maxHeight, c.maxHeight = true)), NumberGuard.isFiniteOrNull(t4.maxWidth) && (t4.maxWidth = "number" == typeof t4.maxWidth ? Math.round(t4.maxWidth) : null, i.maxWidth !== t4.maxWidth && (i.maxWidth = t4.maxWidth, c.maxWidth = true)), NumberGuard.isFiniteOrNull(t4.minHeight) && (t4.minHeight = "number" == typeof t4.minHeight ? Math.round(t4.minHeight) : null, i.minHeight !== t4.minHeight && (i.minHeight = t4.minHeight, c.minHeight = true)), NumberGuard.isFiniteOrNull(t4.minWidth) && (t4.minWidth = "number" == typeof t4.minWidth ? Math.round(t4.minWidth) : null, i.minWidth !== t4.minWidth && (i.minWidth = t4.minWidth, c.minWidth = true)), NumberGuard.isFiniteOrNull(t4.rotateX) && i.rotateX !== t4.rotateX && (i.rotateX = a.rotateX = t4.rotateX, c.transform = true), NumberGuard.isFiniteOrNull(t4.rotateY) && i.rotateY !== t4.rotateY && (i.rotateY = a.rotateY = t4.rotateY, c.transform = true), NumberGuard.isFiniteOrNull(t4.rotateZ) && i.rotateZ !== t4.rotateZ && (i.rotateZ = a.rotateZ = t4.rotateZ, c.transform = true), NumberGuard.isFiniteOrNull(t4.scale) && (t4.scale = "number" == typeof t4.scale ? clamp(t4.scale, 0, 1e3) : null, i.scale !== t4.scale && (i.scale = a.scale = t4.scale, c.transform = true)), ("string" == typeof t4.transformOrigin && TJSTransforms.transformOrigins.includes(t4.transformOrigin) || null === t4.transformOrigin) && i.transformOrigin !== t4.transformOrigin && (i.transformOrigin = t4.transformOrigin, c.transformOrigin = true), NumberGuard.isFiniteOrNull(t4.translateX) && i.translateX !== t4.translateX && (i.translateX = a.translateX = t4.translateX, c.transform = true), NumberGuard.isFiniteOrNull(t4.translateY) && i.translateY !== t4.translateY && (i.translateY = a.translateY = t4.translateY, c.transform = true), NumberGuard.isFiniteOrNull(t4.translateZ) && i.translateZ !== t4.translateZ && (i.translateZ = a.translateZ = t4.translateZ, c.transform = true), NumberGuard.isFinite(t4.zIndex) && (t4.zIndex = Math.round(t4.zIndex), i.zIndex !== t4.zIndex && (i.zIndex = t4.zIndex, c.zIndex = true));
    const u = "auto" === t4.width || "inherit" === t4.width;
    (NumberGuard.isFiniteOrNull(t4.width) || u) && (t4.width = "number" == typeof t4.width ? Math.round(t4.width) : t4.width, i.width !== t4.width && (i.width = t4.width, c.width = true));
    const p2 = "auto" === t4.height || "inherit" === t4.height;
    (NumberGuard.isFiniteOrNull(t4.height) || p2) && (t4.height = "number" == typeof t4.height ? Math.round(t4.height) : t4.height, i.height !== t4.height && (i.height = t4.height, c.height = true));
    const d = u || p2;
    if (this.#Bt !== d && (this.#Bt = d, this.#Jt.stores.resizeObservable.set(d)), s2) {
      isObject$1(this.#Zt.getDefault()) || this.#Zt.save({ name: "#defaultData", ...Object.assign({}, i) }), o2 ? (UpdateElementManager.immediate(s2, this.#Vt), this.#Xt = Promise.resolve(globalThis.performance.now())) : this.#Vt.queued || (this.#Xt = UpdateElementManager.add(s2, this.#Vt));
    } else UpdateElementManager.updateSubscribers(this.#Vt);
    return this;
  }
  subscribe(t4) {
    return -1 === this.#C.findIndex((e) => e === t4) && (this.#C.push(t4), t4(Object.assign({}, this.#it))), () => {
      const e = this.#C.findIndex((e2) => e2 === t4);
      -1 !== e && this.#C.splice(e, 1);
    };
  }
  update(t4) {
    const e = t4(this.get());
    if (!isObject$1(e)) throw new TypeError("'result' of 'updater' is not an object.");
    this.set(e);
  }
  static #Qt = Object.seal(new TJSPositionData());
  static #Lt = Object.seal({ position: void 0, parent: void 0, el: void 0, computed: void 0, transforms: void 0, height: void 0, width: void 0, marginLeft: void 0, marginTop: void 0, maxHeight: void 0, maxWidth: void 0, minHeight: void 0, minWidth: void 0, rest: void 0 });
  #Kt({ left: t4, top: e, maxWidth: n, maxHeight: o2, minWidth: i, minHeight: a, width: r2, height: s2, rotateX: c, rotateY: l, rotateZ: u, scale: p2, transformOrigin: d, translateX: m, translateY: f, translateZ: _, zIndex: h, rotation: g2, ...$2 }, b, y, v) {
    let k = TJSPositionDataUtil.copyData(this.#it, _a.#Qt);
    if (void 0 !== r2 || "" === y.style.width) {
      const t5 = null === r2 || Number.isFinite(r2);
      if ("auto" === r2 || "auto" === k.width && !t5) k.width = "auto", r2 = v.offsetWidth;
      else if ("inherit" === r2 || "inherit" === k.width && !t5) k.width = "inherit", r2 = v.offsetWidth;
      else {
        const t6 = NumberGuard.isFinite(r2) ? r2 : k.width;
        k.width = r2 = NumberGuard.isFinite(t6) ? Math.round(t6) : v.offsetWidth;
      }
    } else r2 = Number.isFinite(k.width) ? k.width : v.offsetWidth;
    if (void 0 !== s2 || "" === y.style.height) {
      const t5 = null === s2 || Number.isFinite(s2);
      if ("auto" === s2 || "auto" === k.height && !t5) k.height = "auto", s2 = v.offsetHeight;
      else if ("inherit" === s2 || "inherit" === k.height && !t5) k.height = "inherit", s2 = v.offsetHeight;
      else {
        const t6 = NumberGuard.isFinite(s2) ? s2 : k.height;
        k.height = s2 = NumberGuard.isFinite(t6) ? Math.round(t6) : v.offsetHeight;
      }
    } else s2 = Number.isFinite(k.height) ? k.height : v.offsetHeight;
    NumberGuard.isFinite(t4) ? k.left = t4 : Number.isFinite(k.left) || (k.left = "function" == typeof this.#Wt?.initial?.getLeft ? this.#Wt.initial.getLeft(r2) : 0), Number.isFinite(e) ? k.top = e : Number.isFinite(k.top) || (k.top = "function" == typeof this.#Wt?.initial?.getTop ? this.#Wt.initial.getTop(s2) : 0), NumberGuard.isFiniteOrNull(o2) && (k.maxHeight = NumberGuard.isFinite(o2) ? Math.round(o2) : null), NumberGuard.isFiniteOrNull(n) && (k.maxWidth = NumberGuard.isFinite(n) ? Math.round(n) : null), NumberGuard.isFiniteOrNull(a) && (k.minHeight = NumberGuard.isFinite(a) ? Math.round(a) : null), NumberGuard.isFiniteOrNull(i) && (k.minWidth = NumberGuard.isFinite(i) ? Math.round(i) : null), NumberGuard.isFiniteOrNull(c) && (k.rotateX = c), NumberGuard.isFiniteOrNull(l) && (k.rotateY = l), u !== k.rotateZ && NumberGuard.isFiniteOrNull(u) ? k.rotateZ = u : g2 !== k.rotateZ && NumberGuard.isFiniteOrNull(g2) && (k.rotateZ = g2), NumberGuard.isFiniteOrNull(m) && (k.translateX = m), NumberGuard.isFiniteOrNull(f) && (k.translateY = f), NumberGuard.isFiniteOrNull(_) && (k.translateZ = _), NumberGuard.isFiniteOrNull(p2) && (k.scale = "number" == typeof p2 ? clamp(p2, 0, 1e3) : null), "string" != typeof d && null !== d || (k.transformOrigin = TJSTransforms.transformOrigins.includes(d) ? d : null), NumberGuard.isFiniteOrNull(h) && (k.zIndex = "number" == typeof h ? Math.round(h) : h);
    const w2 = this.#Mt;
    if (this.#Yt.enabled && w2.length) {
      const t5 = _a.#Lt;
      t5.parent = b, t5.el = y, t5.computed = v.computed, t5.transforms = this.#Tt, t5.height = s2, t5.width = r2, t5.marginLeft = v.marginLeft, t5.marginTop = v.marginTop, t5.maxHeight = v.maxHeight ?? k.maxHeight, t5.maxWidth = v.maxWidth ?? k.maxWidth;
      const e2 = b?.reactive?.minimized ?? false;
      t5.minHeight = e2 ? k.minHeight ?? 0 : v.minHeight || (k.minHeight ?? 0), t5.minWidth = e2 ? k.minWidth ?? 0 : v.minWidth || (k.minWidth ?? 0);
      for (let e3 = 0; e3 < w2.length; e3++) if (t5.position = k, t5.rest = $2, k = w2[e3].validate(t5), null === k) return null;
    }
    return k;
  }
}
function fade(t4, { delay: e = 0, duration: n = 400, easing: o2 = identity } = {}) {
  const i = +getComputedStyle(t4).opacity;
  return { delay: e, duration: n, easing: o2, css: (t5) => "opacity: " + t5 * i };
}
function slide(t4, { delay: e = 0, duration: n = 400, easing: o2 = cubicOut, axis: i = "y" } = {}) {
  const a = getComputedStyle(t4), r2 = +a.opacity, s2 = "y" === i ? "height" : "width", c = parseFloat(a[s2]), l = "y" === i ? ["top", "bottom"] : ["left", "right"], u = l.map((t5) => `${t5[0].toUpperCase()}${t5.slice(1)}`), p2 = parseFloat(a[`padding${u[0]}`]), d = parseFloat(a[`padding${u[1]}`]), m = parseFloat(a[`margin${u[0]}`]), f = parseFloat(a[`margin${u[1]}`]), _ = parseFloat(a[`border${u[0]}Width`]), h = parseFloat(a[`border${u[1]}Width`]);
  return { delay: e, duration: n, easing: o2, css: (t5) => `overflow: hidden;opacity: ${Math.min(20 * t5, 1) * r2};${s2}: ${t5 * c}px;padding-${l[0]}: ${t5 * p2}px;padding-${l[1]}: ${t5 * d}px;margin-${l[0]}: ${t5 * m}px;margin-${l[1]}: ${t5 * f}px;border-${l[0]}-width: ${t5 * _}px;border-${l[1]}-width: ${t5 * h}px;` };
}
function scale(t4, { delay: e = 0, duration: n = 400, easing: o2 = cubicOut, start: i = 0, opacity: a = 0 } = {}) {
  const r2 = getComputedStyle(t4), s2 = +r2.opacity, c = "none" === r2.transform ? "" : r2.transform, l = 1 - i, u = s2 * (1 - a);
  return { delay: e, duration: n, easing: o2, css: (t5, e2) => `
			transform: ${c} scale(${1 - l * e2});
			opacity: ${s2 - u * e2}
		` };
}
_a = TJSPosition, "undefined" != typeof window && (window.__svelte || (window.__svelte = { v: /* @__PURE__ */ new Set() })).v.add(PUBLIC_VERSION);
const cssVariables = new TJSStyleManager({ docKey: "#__trl-root-styles", version: 1 });
class ResizeObserverManager {
  #te = /* @__PURE__ */ new Map();
  #ee;
  static #ne = Object.freeze({ none: 0, attribute: 1, function: 2, resizeObserved: 3, setContentBounds: 4, setDimension: 5, storeObject: 6, storesObject: 7 });
  constructor() {
    this.#ee = new ResizeObserver((t4) => {
      for (const e of t4) {
        const t5 = this.#te.get(e?.target);
        if (Array.isArray(t5)) {
          const n = e.contentRect.width, o2 = e.contentRect.height;
          for (const e2 of t5) ResizeObserverManager.#oe(e2, n, o2);
        }
      }
    });
  }
  add(t4, e) {
    if (!CrossWindow.isHTMLElement(t4)) throw new TypeError("ResizeObserverManager.add error: 'el' is not a HTMLElement.");
    if (this.#ie(t4, e)) return;
    const n = ResizeObserverManager.#ae(e);
    if (0 === n) throw new Error("ResizeObserverManager.add error: 'target' is not a valid ResizeObserverManager target.");
    const o2 = globalThis.getComputedStyle(t4), i = StyleParse.pixels(t4.style.borderBottom) ?? StyleParse.pixels(o2.borderBottom) ?? 0, a = StyleParse.pixels(t4.style.borderLeft) ?? StyleParse.pixels(o2.borderLeft) ?? 0, r2 = StyleParse.pixels(t4.style.borderRight) ?? StyleParse.pixels(o2.borderRight) ?? 0, s2 = StyleParse.pixels(t4.style.borderTop) ?? StyleParse.pixels(o2.borderTop) ?? 0, c = StyleParse.pixels(t4.style.paddingBottom) ?? StyleParse.pixels(o2.paddingBottom) ?? 0, l = { updateType: n, target: e, contentWidth: 0, contentHeight: 0, styles: { additionalWidth: a + r2 + (StyleParse.pixels(t4.style.paddingLeft) ?? StyleParse.pixels(o2.paddingLeft) ?? 0) + (StyleParse.pixels(t4.style.paddingRight) ?? StyleParse.pixels(o2.paddingRight) ?? 0), additionalHeight: s2 + i + (StyleParse.pixels(t4.style.paddingTop) ?? StyleParse.pixels(o2.paddingTop) ?? 0) + c } };
    if (this.#te.has(t4)) {
      this.#te.get(t4).push(l);
    } else this.#te.set(t4, [l]);
    this.#ee.observe(t4);
  }
  clear() {
    for (const t4 of this.#te.keys()) this.#ee.unobserve(t4);
    this.#te.clear();
  }
  remove(t4, e = void 0) {
    const n = this.#te.get(t4);
    if (Array.isArray(n)) {
      if (void 0 !== e) {
        const t5 = n.findIndex((t6) => t6.target === e);
        t5 >= 0 && n.splice(t5, 1);
      } else n.length = 0;
      0 === n.length && (this.#te.delete(t4), this.#ee.unobserve(t4));
    }
  }
  updateCache(t4) {
    const e = this.#te.get(t4);
    if (Array.isArray(e)) {
      const n = globalThis.getComputedStyle(t4), o2 = StyleParse.pixels(t4.style.borderBottom) ?? StyleParse.pixels(n.borderBottom) ?? 0, i = StyleParse.pixels(t4.style.borderLeft) ?? StyleParse.pixels(n.borderLeft) ?? 0, a = StyleParse.pixels(t4.style.borderRight) ?? StyleParse.pixels(n.borderRight) ?? 0, r2 = StyleParse.pixels(t4.style.borderTop) ?? StyleParse.pixels(n.borderTop) ?? 0, s2 = StyleParse.pixels(t4.style.paddingBottom) ?? StyleParse.pixels(n.paddingBottom) ?? 0, c = i + a + (StyleParse.pixels(t4.style.paddingLeft) ?? StyleParse.pixels(n.paddingLeft) ?? 0) + (StyleParse.pixels(t4.style.paddingRight) ?? StyleParse.pixels(n.paddingRight) ?? 0), l = r2 + o2 + (StyleParse.pixels(t4.style.paddingTop) ?? StyleParse.pixels(n.paddingTop) ?? 0) + s2;
      for (const t5 of e) t5.styles.additionalWidth = c, t5.styles.additionalHeight = l, ResizeObserverManager.#oe(t5, t5.contentWidth, t5.contentHeight);
    }
  }
  static #ae(t4) {
    if ("function" == typeof t4?.resizeObserved) return this.#ne.resizeObserved;
    if ("function" == typeof t4?.setDimension) return this.#ne.setDimension;
    if ("function" == typeof t4?.setContentBounds) return this.#ne.setContentBounds;
    const e = typeof t4;
    if (null !== e && ("object" === e || "function" === e)) {
      if (isWritableStore(t4.resizeObserved)) return this.#ne.storeObject;
      const e2 = t4?.stores;
      if ((isObject$1(e2) || "function" == typeof e2) && isWritableStore(e2.resizeObserved)) return this.#ne.storesObject;
    }
    return null !== e && "object" === e ? this.#ne.attribute : "function" === e ? this.#ne.function : this.#ne.none;
  }
  #ie(t4, e) {
    if (null == e) return false;
    const n = this.#te.get(t4);
    return !!Array.isArray(n) && n.findIndex((t5) => t5.target === e) >= 0;
  }
  static #oe(t4, e, n) {
    const o2 = t4.styles;
    t4.contentWidth = e, t4.contentHeight = n;
    const i = Number.isFinite(e) ? e + o2.additionalWidth : void 0, a = Number.isFinite(n) ? n + o2.additionalHeight : void 0, r2 = t4.target;
    switch (t4.updateType) {
      case this.#ne.attribute:
        r2.contentWidth = e, r2.contentHeight = n, r2.offsetWidth = i, r2.offsetHeight = a;
        break;
      case this.#ne.function:
        r2?.(i, a, e, n);
        break;
      case this.#ne.resizeObserved:
        r2.resizeObserved?.(i, a, e, n);
        break;
      case this.#ne.setContentBounds:
        r2.setContentBounds?.(e, n);
        break;
      case this.#ne.setDimension:
        r2.setDimension?.(i, a);
        break;
      case this.#ne.storeObject:
        r2.resizeObserved.update((t5) => (t5.contentHeight = n, t5.contentWidth = e, t5.offsetHeight = a, t5.offsetWidth = i, t5));
        break;
      case this.#ne.storesObject:
        r2.stores.resizeObserved.update((t5) => (t5.contentHeight = n, t5.contentWidth = e, t5.offsetHeight = a, t5.offsetWidth = i, t5));
    }
  }
}
const resizeObserverActionManager = new ResizeObserverManager();
function resizeObserver(t4, e) {
  return resizeObserverActionManager.add(t4, e), { update: (n) => {
    resizeObserverActionManager.remove(t4, e), e = n, resizeObserverActionManager.add(t4, e);
  }, destroy: () => {
    resizeObserverActionManager.remove(t4, e);
  } };
}
function applyStyles(t4, e) {
  function n() {
    if (isObject$1(e)) for (const n2 of Object.keys(e)) t4.style.setProperty(`${n2}`, e[n2]);
  }
  return n(), { update: (t5) => {
    e = t5, n();
  } };
}
function dynamicAction(t4, { action: e, data: n } = {}) {
  let o2;
  return "function" == typeof e && (o2 = e(t4, n)), { update: (i) => {
    if (!isObject$1(i)) return o2?.destroy?.(), e = void 0, void (n = void 0);
    const { action: a, data: r2 } = i;
    if ("function" != typeof a) return void console.warn("dynamicAction.update warning: Aborting as 'action' is not a function.");
    const s2 = r2 !== n;
    s2 && (n = r2), a !== e ? (o2?.destroy?.(), o2 = (e = a)(t4, n)) : s2 && o2?.update?.(n);
  }, destroy: () => {
    o2?.destroy?.(), e = void 0, n = void 0, o2 = void 0;
  } };
}
resizeObserver.updateCache = function(t4) {
  resizeObserverActionManager.updateCache(t4);
};
class TJSDefaultTransition {
  static #Wt = {};
  static #re = () => {
  };
  static get default() {
    return this.#re;
  }
  static get options() {
    return this.#Wt;
  }
}
class AppShellContextInternal {
  #l;
  constructor() {
    this.#l = { elementContent: writable(void 0), elementRoot: writable(void 0) }, Object.freeze(this.#l), Object.seal(this);
  }
  get stores() {
    return this.#l;
  }
}
function localize(t4, e) {
  const n = isObject$1(e) ? globalThis.game.i18n.format(t4, e) : globalThis.game.i18n.localize(t4);
  return void 0 !== n ? n : "";
}
function create_if_block$1o(t4) {
  let e, n;
  return { c() {
    e = element("span"), n = text(t4[3]), attr(e, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-acci"), toggle_class(e, "has-icon", void 0 !== t4[4]);
  }, m(t5, o2) {
    insert(t5, e, o2), append(e, n);
  }, p(t5, o2) {
    8 & o2 && set_data(n, t5[3]), 16 & o2 && toggle_class(e, "has-icon", void 0 !== t5[4]);
  }, d(t5) {
    t5 && detach(e);
  } };
}
function create_fragment$2c(t4) {
  let e, n, o2, i, a, r2, s2, c = t4[3] && create_if_block$1o(t4);
  return { c() {
    e = element("a"), n = new HtmlTag(false), o2 = empty(), c && c.c(), n.a = o2, attr(e, "class", i = "header-button " + t4[0].class + " svelte-mobile-companion-dnd5e-81nkluj30u9vsd-acci"), attr(e, "aria-label", t4[3]), attr(e, "tabindex", "0"), attr(e, "role", "button"), toggle_class(e, "keep-minimized", t4[2]);
  }, m(i2, l) {
    insert(i2, e, l), n.m(t4[4], e), append(e, o2), c && c.m(e, null), r2 || (s2 = [listen(e, "click", stop_propagation(prevent_default(t4[5]))), listen(e, "contextmenu", stop_propagation(prevent_default(t4[6]))), listen(e, "keydown", t4[7]), listen(e, "keyup", t4[8]), action_destroyer(a = applyStyles.call(null, e, t4[1]))], r2 = true);
  }, p(t5, [o3]) {
    16 & o3 && n.p(t5[4]), t5[3] ? c ? c.p(t5, o3) : (c = create_if_block$1o(t5), c.c(), c.m(e, null)) : c && (c.d(1), c = null), 1 & o3 && i !== (i = "header-button " + t5[0].class + " svelte-mobile-companion-dnd5e-81nkluj30u9vsd-acci") && attr(e, "class", i), 8 & o3 && attr(e, "aria-label", t5[3]), a && is_function(a.update) && 2 & o3 && a.update.call(null, t5[1]), 5 & o3 && toggle_class(e, "keep-minimized", t5[2]);
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e), c && c.d(), r2 = false, run_all(s2);
  } };
}
const s_REGEX_HTML = /^\s*<.*>$/;
function instance$2b(t4, e, n) {
  let o2, i, a, r2, s2, c, { button: l } = e;
  return t4.$$set = (t5) => {
    "button" in t5 && n(0, l = t5.button);
  }, t4.$$.update = () => {
    1 & t4.$$.dirty && n(9, o2 = isObject$1(l) && "string" == typeof l.title ? localize(l.title) : ""), 513 & t4.$$.dirty && n(4, i = isObject$1(l) && "string" != typeof l.icon ? void 0 : s_REGEX_HTML.test(l.icon) ? l.icon : `<i class="${l.icon}" title="${o2}"></i>`), 1 & t4.$$.dirty && n(3, a = isObject$1(l) && "string" == typeof l.label ? localize(l.label) : void 0), 1 & t4.$$.dirty && n(2, r2 = !(!isObject$1(l) || "boolean" != typeof l.keepMinimized) && l.keepMinimized), 1 & t4.$$.dirty && (s2 = isObject$1(l) && "string" == typeof l.keyCode ? l.keyCode : "Enter"), 1 & t4.$$.dirty && n(1, c = isObject$1(l) && isObject$1(l.styles) ? l.styles : void 0);
  }, [l, c, r2, a, i, function(t5) {
    const e2 = l?.onPress ?? l?.onclick;
    "function" == typeof e2 && (e2({ button: l, event: t5 }), n(0, l));
  }, function(t5) {
    "function" === l?.onContextMenu && (l.onContextMenu({ button: l, event: t5 }), n(0, l));
  }, function(t5) {
    t5.code === s2 && (t5.preventDefault(), t5.stopPropagation());
  }, function(t5) {
    if (t5.code === s2) {
      const e2 = l.onPress ?? l.onclick;
      "function" == typeof e2 && (e2({ button: l, event: t5 }), n(0, l)), t5.preventDefault(), t5.stopPropagation();
    }
  }, o2];
}
class TJSHeaderButton extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$2b, create_fragment$2c, safe_not_equal, { button: 0 });
  }
  get button() {
    return this.$$.ctx[0];
  }
  set button(t4) {
    this.$$set({ button: t4 }), flush();
  }
}
function get_each_context$v(t4, e, n) {
  const o2 = t4.slice();
  return o2[31] = e[n], o2;
}
function get_each_context_1$8(t4, e, n) {
  const o2 = t4.slice();
  return o2[31] = e[n], o2;
}
function create_if_block$1n(t4) {
  let e, n;
  return { c() {
    e = element("img"), attr(e, "class", "tjs-app-icon keep-minimized svelte-mobile-companion-dnd5e-81nkluj30u9vsd-5lh4qo"), src_url_equal(e.src, n = t4[6]) || attr(e, "src", n), attr(e, "alt", "icon");
  }, m(t5, n2) {
    insert(t5, e, n2);
  }, p(t5, o2) {
    64 & o2[0] && !src_url_equal(e.src, n = t5[6]) && attr(e, "src", n);
  }, d(t5) {
    t5 && detach(e);
  } };
}
function create_each_block_1$8(t4) {
  let e, n, o2;
  const i = [t4[31].props];
  var a = t4[31].class;
  function r2(t5, e2) {
    let n2 = {};
    for (let t6 = 0; t6 < i.length; t6 += 1) n2 = assign(n2, i[t6]);
    return void 0 !== e2 && 2 & e2[0] && (n2 = assign(n2, get_spread_update(i, [get_spread_object(t5[31].props)]))), { props: n2 };
  }
  return a && (e = construct_svelte_component(a, r2(t4))), { c() {
    e && create_component(e.$$.fragment), n = empty();
  }, m(t5, i2) {
    e && mount_component(e, t5, i2), insert(t5, n, i2), o2 = true;
  }, p(t5, o3) {
    if (2 & o3[0] && a !== (a = t5[31].class)) {
      if (e) {
        group_outros();
        const t6 = e;
        transition_out(t6.$$.fragment, 1, 0, () => {
          destroy_component(t6, 1);
        }), check_outros();
      }
      a ? (e = construct_svelte_component(a, r2(t5, o3)), create_component(e.$$.fragment), transition_in(e.$$.fragment, 1), mount_component(e, n.parentNode, n)) : e = null;
    } else if (a) {
      const n2 = 2 & o3[0] ? get_spread_update(i, [get_spread_object(t5[31].props)]) : {};
      e.$set(n2);
    }
  }, i(t5) {
    o2 || (e && transition_in(e.$$.fragment, t5), o2 = true);
  }, o(t5) {
    e && transition_out(e.$$.fragment, t5), o2 = false;
  }, d(t5) {
    t5 && detach(n), e && destroy_component(e, t5);
  } };
}
function create_each_block$v(t4) {
  let e, n, o2;
  const i = [t4[31].props];
  var a = t4[31].class;
  function r2(t5, e2) {
    let n2 = {};
    for (let t6 = 0; t6 < i.length; t6 += 1) n2 = assign(n2, i[t6]);
    return void 0 !== e2 && 4 & e2[0] && (n2 = assign(n2, get_spread_update(i, [get_spread_object(t5[31].props)]))), { props: n2 };
  }
  return a && (e = construct_svelte_component(a, r2(t4))), { c() {
    e && create_component(e.$$.fragment), n = empty();
  }, m(t5, i2) {
    e && mount_component(e, t5, i2), insert(t5, n, i2), o2 = true;
  }, p(t5, o3) {
    if (4 & o3[0] && a !== (a = t5[31].class)) {
      if (e) {
        group_outros();
        const t6 = e;
        transition_out(t6.$$.fragment, 1, 0, () => {
          destroy_component(t6, 1);
        }), check_outros();
      }
      a ? (e = construct_svelte_component(a, r2(t5, o3)), create_component(e.$$.fragment), transition_in(e.$$.fragment, 1), mount_component(e, n.parentNode, n)) : e = null;
    } else if (a) {
      const n2 = 4 & o3[0] ? get_spread_update(i, [get_spread_object(t5[31].props)]) : {};
      e.$set(n2);
    }
  }, i(t5) {
    o2 || (e && transition_in(e.$$.fragment, t5), o2 = true);
  }, o(t5) {
    e && transition_out(e.$$.fragment, t5), o2 = false;
  }, d(t5) {
    t5 && detach(n), e && destroy_component(e, t5);
  } };
}
function create_key_block$1(t4) {
  let e, n, o2, i, a, r2, s2, c, l, u, p2, d, m, f = localize(t4[7]) + "", _ = "string" == typeof t4[6] && create_if_block$1n(t4), h = ensure_array_like(t4[1]), g2 = [];
  for (let e2 = 0; e2 < h.length; e2 += 1) g2[e2] = create_each_block_1$8(get_each_context_1$8(t4, h, e2));
  const $2 = (t5) => transition_out(g2[t5], 1, 1, () => {
    g2[t5] = null;
  });
  let b = ensure_array_like(t4[2]), y = [];
  for (let e2 = 0; e2 < b.length; e2 += 1) y[e2] = create_each_block$v(get_each_context$v(t4, b, e2));
  const v = (t5) => transition_out(y[t5], 1, 1, () => {
    y[t5] = null;
  });
  return { c() {
    e = element("header"), _ && _.c(), n = space(), o2 = element("h4"), i = text(f), a = space();
    for (let t5 = 0; t5 < g2.length; t5 += 1) g2[t5].c();
    r2 = space(), s2 = element("span"), c = space();
    for (let t5 = 0; t5 < y.length; t5 += 1) y[t5].c();
    attr(o2, "class", "window-title svelte-mobile-companion-dnd5e-81nkluj30u9vsd-5lh4qo"), set_style(o2, "display", t4[4]), attr(s2, "class", "tjs-window-header-spacer keep-minimized svelte-mobile-companion-dnd5e-81nkluj30u9vsd-5lh4qo"), attr(e, "class", "window-header flexrow svelte-mobile-companion-dnd5e-81nkluj30u9vsd-5lh4qo");
  }, m(f2, h2) {
    insert(f2, e, h2), _ && _.m(e, null), append(e, n), append(e, o2), append(o2, i), append(e, a);
    for (let t5 = 0; t5 < g2.length; t5 += 1) g2[t5] && g2[t5].m(e, null);
    append(e, r2), append(e, s2), append(e, c);
    for (let t5 = 0; t5 < y.length; t5 += 1) y[t5] && y[t5].m(e, null);
    p2 = true, d || (m = [listen(e, "pointerdown", t4[19]), action_destroyer(l = t4[0].call(null, e, t4[3])), action_destroyer(u = t4[18].call(null, e, t4[5]))], d = true);
  }, p(t5, a2) {
    if ("string" == typeof t5[6] ? _ ? _.p(t5, a2) : (_ = create_if_block$1n(t5), _.c(), _.m(e, n)) : _ && (_.d(1), _ = null), (!p2 || 128 & a2[0]) && f !== (f = localize(t5[7]) + "") && set_data(i, f), 16 & a2[0] && set_style(o2, "display", t5[4]), 2 & a2[0]) {
      let n2;
      for (h = ensure_array_like(t5[1]), n2 = 0; n2 < h.length; n2 += 1) {
        const o3 = get_each_context_1$8(t5, h, n2);
        g2[n2] ? (g2[n2].p(o3, a2), transition_in(g2[n2], 1)) : (g2[n2] = create_each_block_1$8(o3), g2[n2].c(), transition_in(g2[n2], 1), g2[n2].m(e, r2));
      }
      for (group_outros(), n2 = h.length; n2 < g2.length; n2 += 1) $2(n2);
      check_outros();
    }
    if (4 & a2[0]) {
      let n2;
      for (b = ensure_array_like(t5[2]), n2 = 0; n2 < b.length; n2 += 1) {
        const o3 = get_each_context$v(t5, b, n2);
        y[n2] ? (y[n2].p(o3, a2), transition_in(y[n2], 1)) : (y[n2] = create_each_block$v(o3), y[n2].c(), transition_in(y[n2], 1), y[n2].m(e, null));
      }
      for (group_outros(), n2 = b.length; n2 < y.length; n2 += 1) v(n2);
      check_outros();
    }
    l && is_function(l.update) && 8 & a2[0] && l.update.call(null, t5[3]), u && is_function(u.update) && 32 & a2[0] && u.update.call(null, t5[5]);
  }, i(t5) {
    if (!p2) {
      for (let t6 = 0; t6 < h.length; t6 += 1) transition_in(g2[t6]);
      for (let t6 = 0; t6 < b.length; t6 += 1) transition_in(y[t6]);
      p2 = true;
    }
  }, o(t5) {
    g2 = g2.filter(Boolean);
    for (let t6 = 0; t6 < g2.length; t6 += 1) transition_out(g2[t6]);
    y = y.filter(Boolean);
    for (let t6 = 0; t6 < y.length; t6 += 1) transition_out(y[t6]);
    p2 = false;
  }, d(t5) {
    t5 && detach(e), _ && _.d(), destroy_each(g2, t5), destroy_each(y, t5), d = false, run_all(m);
  } };
}
function create_fragment$2b(t4) {
  let e, n, o2 = t4[0], i = create_key_block$1(t4);
  return { c() {
    i.c(), e = empty();
  }, m(t5, o3) {
    i.m(t5, o3), insert(t5, e, o3), n = true;
  }, p(t5, n2) {
    1 & n2[0] && safe_not_equal(o2, o2 = t5[0]) ? (group_outros(), transition_out(i, 1, 1, noop$3), check_outros(), i = create_key_block$1(t5), i.c(), transition_in(i, 1), i.m(e.parentNode, e)) : i.p(t5, n2);
  }, i(t5) {
    n || (transition_in(i), n = true);
  }, o(t5) {
    transition_out(i), n = false;
  }, d(t5) {
    t5 && detach(e), i.d(t5);
  } };
}
function instance$2a(t4, e, n) {
  let o2, i, a, r2, s2, c, l, u, p2, d, { draggable: m } = e, { draggableOptions: f } = e;
  const _ = getContext("#external")?.application, { focusAuto: h, focusKeep: g2 } = _.reactive.storeAppOptions;
  component_subscribe(t4, h, (t5) => n(26, i = t5)), component_subscribe(t4, g2, (t5) => n(25, o2 = t5));
  const { elementRoot: $2 } = getContext("#internal").stores;
  component_subscribe(t4, $2, (t5) => n(27, a = t5));
  const b = _.reactive.storeAppOptions.title;
  component_subscribe(t4, b, (t5) => n(7, d = t5));
  const y = _.reactive.storeAppOptions.draggable;
  component_subscribe(t4, y, (t5) => n(24, l = t5));
  const v = _.reactive.storeUIState.dragging, k = _.reactive.storeUIState.headerButtons;
  component_subscribe(t4, k, (t5) => n(21, r2 = t5));
  const w2 = _.reactive.storeAppOptions.headerIcon;
  component_subscribe(t4, w2, (t5) => n(6, p2 = t5));
  const S2 = _.reactive.storeAppOptions.headerNoTitleMinimized;
  component_subscribe(t4, S2, (t5) => n(23, c = t5));
  const T = _.reactive.storeAppOptions.minimizable;
  component_subscribe(t4, T, (t5) => n(5, u = t5));
  const x2 = _.reactive.storeUIState.minimized;
  component_subscribe(t4, x2, (t5) => n(22, s2 = t5));
  const E = Object.freeze(["tjs-app-icon", "tjs-window-header-spacer", "window-header", "window-title"]);
  let O, A2, C, D;
  return t4.$$set = (t5) => {
    "draggable" in t5 && n(0, m = t5.draggable), "draggableOptions" in t5 && n(20, f = t5.draggableOptions);
  }, t4.$$.update = () => {
    if (1 & t4.$$.dirty[0] && n(0, m = "function" == typeof m ? m : draggable), 17825792 & t4.$$.dirty[0] && n(3, O = Object.assign({}, { tween: true, tweenOptions: { duration: 0.06, ease: "cubicOut" } }, isObject$1(f) ? f : {}, { position: _.position, enabled: l, storeDragging: v, hasTargetClassList: E })), 12582912 & t4.$$.dirty[0] && n(4, A2 = c && s2 ? "none" : null), 2097158 & t4.$$.dirty[0]) {
      n(1, C = []), n(2, D = []);
      for (const t5 of r2) {
        ("boolean" == typeof t5?.alignLeft && t5?.alignLeft ? C : D).push(TJSSvelte.config.isConfigEmbed(t5?.svelte) ? { ...t5.svelte } : { class: TJSHeaderButton, props: { button: t5 } });
      }
    }
  }, [m, C, D, O, A2, u, p2, d, h, g2, $2, b, y, k, w2, S2, T, x2, function(t5, e2) {
    const n2 = (t6) => {
      (t6.target.classList.contains("window-title") || t6.target.classList.contains("window-header") || t6.target.classList.contains("keep-minimized")) && _._onToggleMinimize(t6);
    };
    function o3() {
      t5.addEventListener("dblclick", n2);
    }
    function i2() {
      t5.removeEventListener("dblclick", n2);
    }
    return e2 && o3(), { update: (t6) => {
      t6 ? o3() : i2();
    }, destroy: () => i2() };
  }, function(t5) {
    const e2 = a;
    if (_.position.animate.cancel(), i && A11yHelper.isFocusTarget(e2) && e2?.isConnected) if (o2) {
      const n2 = _.reactive.activeWindow;
      A11yHelper.isFocusTarget(n2.document.activeElement) && !e2.contains(n2.document.activeElement) ? e2.focus() : t5.preventDefault();
    } else e2.focus();
  }, f, r2, s2, c, l];
}
class TJSApplicationHeader extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$2a, create_fragment$2b, safe_not_equal, { draggable: 0, draggableOptions: 20 }, null, [-1, -1]);
  }
}
class ResizeHandleTransform {
  static #se = new Mat4();
  static #ce = new Vec3();
  static #le = new Vec3();
  static #ue = new Vec3();
  static #pe = new Vec3();
  static #de = new Vec3();
  static computeDelta(t4, e, n, o2, i) {
    return Mat4.invert(this.#se, t4), this.#pe[0] = e, this.#pe[1] = n, this.#de[0] = o2, this.#de[1] = i, Vec3.transformMat4(this.#le, this.#pe, this.#se), Vec3.transformMat4(this.#ue, this.#de, this.#se), this.#ce[0] = this.#ue[0] - this.#le[0], this.#ce[1] = this.#ue[1] - this.#le[1], this.#ce;
  }
}
function create_fragment$2a(t4) {
  let e, n, o2, i;
  return { c() {
    e = element("div"), e.innerHTML = '<i class="fas fa-arrows-alt-h svelte-mobile-companion-dnd5e-81nkluj30u9vsd-gtiiil"></i>', attr(e, "class", "window-resizable-handle svelte-mobile-companion-dnd5e-81nkluj30u9vsd-gtiiil");
  }, m(a, r2) {
    insert(a, e, r2), t4[11](e), o2 || (i = [listen(e, "pointerdown", t4[6]), action_destroyer(n = t4[7].call(null, e, { active: t4[1], storeResizing: t4[5] }))], o2 = true);
  }, p(t5, [e2]) {
    n && is_function(n.update) && 2 & e2 && n.update.call(null, { active: t5[1], storeResizing: t5[5] });
  }, i: noop$3, o: noop$3, d(n2) {
    n2 && detach(e), t4[11](null), o2 = false, run_all(i);
  } };
}
function instance$29(t4, e, n) {
  let o2, i, a, { isResizable: r2 = false } = e;
  const s2 = getContext("#external")?.application, c = getContext("#internal").stores.elementRoot;
  component_subscribe(t4, c, (t5) => n(9, o2 = t5));
  const l = s2.reactive.storeAppOptions.resizable;
  component_subscribe(t4, l, (t5) => n(1, a = t5));
  const u = s2.reactive.storeUIState.minimized;
  component_subscribe(t4, u, (t5) => n(10, i = t5));
  const p2 = s2.reactive.storeUIState.resizing;
  let d;
  return t4.$$set = (t5) => {
    "isResizable" in t5 && n(8, r2 = t5.isResizable);
  }, t4.$$.update = () => {
    if (1793 & t4.$$.dirty && d) {
      n(0, d.style.display = r2 && !i ? "block" : "none", d);
      o2 && o2.classList[r2 ? "add" : "remove"]("resizable");
    }
  }, [d, a, c, l, u, p2, function() {
    s2.position.animate.cancel();
  }, function(t5, { active: e2 = true, storeResizing: i2 } = {}) {
    let a2 = null, c2 = false, l2 = 0, u2 = 0;
    const p3 = { resizeDown: ["pointerdown", (e3) => function(e4) {
      e4.preventDefault(), c2 = false, a2 = s2.position.get(), "auto" === a2.height && (a2.height = o2.clientHeight);
      "auto" === a2.width && (a2.width = o2.clientWidth);
      l2 = e4.clientX, u2 = e4.clientY, t5.addEventListener(...p3.resizeMove), t5.addEventListener(...p3.resizeUp), t5.setPointerCapture(e4.pointerId);
    }(e3), false], resizeMove: ["pointermove", (t6) => function(t7) {
      t7.preventDefault(), c2 || "function" != typeof i2?.set || (c2 = true, i2.set(true));
      const e3 = ResizeHandleTransform.computeDelta(s2.position.transform.mat4, l2, u2, t7.clientX, t7.clientY);
      s2.position.set({ width: a2.width + e3[0], height: a2.height + e3[1] });
    }(t6), false], resizeUp: ["pointerup", (e3) => function(e4) {
      c2 = false, "function" == typeof i2?.set && i2.set(false);
      e4.preventDefault(), t5.removeEventListener(...p3.resizeMove), t5.removeEventListener(...p3.resizeUp), s2?._onResize?.(e4);
    }(e3), false] };
    function d2() {
      t5.addEventListener(...p3.resizeDown), n(8, r2 = true), t5.style.display = "block";
    }
    function m() {
      "function" == typeof i2?.set && i2.set(false), t5.removeEventListener(...p3.resizeDown), t5.removeEventListener(...p3.resizeMove), t5.removeEventListener(...p3.resizeUp), t5.style.display = "none", n(8, r2 = false);
    }
    return e2 ? d2() : t5.style.display = "none", { update: ({ active: t6 }) => {
      t6 ? d2() : m();
    }, destroy: () => m() };
  }, r2, o2, i, function(t5) {
    binding_callbacks[t5 ? "unshift" : "push"](() => {
      d = t5, n(0, d), n(8, r2), n(10, i), n(9, o2);
    });
  }];
}
class ResizableHandle extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$29, create_fragment$2a, safe_not_equal, { isResizable: 8 });
  }
}
function create_fragment$29(t4) {
  let e, n, o2;
  return { c() {
    e = element("div"), attr(e, "class", "tjs-focus-wrap svelte-mobile-companion-dnd5e-81nkluj30u9vsd-kjcljd"), attr(e, "tabindex", "0");
  }, m(i, a) {
    insert(i, e, a), t4[4](e), n || (o2 = listen(e, "focus", t4[1]), n = true);
  }, p: noop$3, i: noop$3, o: noop$3, d(i) {
    i && detach(e), t4[4](null), n = false, o2();
  } };
}
function instance$28(t4, e, n) {
  let o2, i, { elementRoot: a } = e, { enabled: r2 = true } = e;
  return t4.$$set = (t5) => {
    "elementRoot" in t5 && n(2, a = t5.elementRoot), "enabled" in t5 && n(3, r2 = t5.enabled);
  }, t4.$$.update = () => {
    1 & t4.$$.dirty && i && (o2 = /* @__PURE__ */ new Set([i]));
  }, [i, function() {
    if (r2 && A11yHelper.isFocusTarget(a)) {
      const t5 = A11yHelper.getFirstFocusableElement(a, o2);
      A11yHelper.isFocusTarget(t5) && t5 !== i ? t5.focus() : a.focus();
    }
  }, a, r2, function(t5) {
    binding_callbacks[t5 ? "unshift" : "push"](() => {
      i = t5, n(0, i);
    });
  }];
}
class TJSFocusWrap extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$28, create_fragment$29, safe_not_equal, { elementRoot: 2, enabled: 3 });
  }
}
function create_else_block$f(t4) {
  let e, n, o2, i, a, r2, s2, c, l, u, p2, d, m, f, _, h, g2;
  n = new TJSApplicationHeader({ props: { draggable: t4[6], draggableOptions: t4[7] } });
  const $2 = t4[37].default, b = create_slot($2, t4, t4[36], null);
  return s2 = new ResizableHandle({}), l = new TJSFocusWrap({ props: { elementRoot: t4[1], enabled: t4[11] } }), { c() {
    e = element("div"), create_component(n.$$.fragment), o2 = space(), i = element("section"), b && b.c(), r2 = space(), create_component(s2.$$.fragment), c = space(), create_component(l.$$.fragment), attr(i, "class", "window-content svelte-mobile-companion-dnd5e-81nkluj30u9vsd-90z1oq"), attr(i, "tabindex", "-1"), attr(e, "id", u = t4[10].id), attr(e, "class", p2 = "app window-app " + t4[10].options.classes.join(" ") + " svelte-mobile-companion-dnd5e-81nkluj30u9vsd-90z1oq"), attr(e, "data-appid", d = t4[10].appId), attr(e, "role", "application"), attr(e, "tabindex", "-1");
  }, m(u2, p3) {
    insert(u2, e, p3), mount_component(n, e, null), append(e, o2), append(e, i), b && b.m(i, null), t4[40](i), append(e, r2), mount_component(s2, e, null), append(e, c), mount_component(l, e, null), t4[41](e), _ = true, h || (g2 = [listen(i, "pointerdown", t4[22]), action_destroyer(a = applyStyles.call(null, i, t4[9])), action_destroyer(t4[18].call(null, i, t4[23])), listen(e, "close:popup", stop_propagation(prevent_default(t4[19]))), listen(e, "keydown", t4[20]), listen(e, "pointerdown", t4[21], true), action_destroyer(m = applyStyles.call(null, e, t4[8])), action_destroyer(f = dynamicAction.call(null, e, t4[12]))], h = true);
  }, p(t5, o3) {
    const i2 = {};
    64 & o3[0] && (i2.draggable = t5[6]), 128 & o3[0] && (i2.draggableOptions = t5[7]), n.$set(i2), b && b.p && (!_ || 32 & o3[1]) && update_slot_base(b, $2, t5, t5[36], _ ? get_slot_changes($2, t5[36], o3, null) : get_all_dirty_from_scope(t5[36]), null), a && is_function(a.update) && 512 & o3[0] && a.update.call(null, t5[9]);
    const r3 = {};
    2 & o3[0] && (r3.elementRoot = t5[1]), 2048 & o3[0] && (r3.enabled = t5[11]), l.$set(r3), (!_ || 1024 & o3[0] && u !== (u = t5[10].id)) && attr(e, "id", u), (!_ || 1024 & o3[0] && p2 !== (p2 = "app window-app " + t5[10].options.classes.join(" ") + " svelte-mobile-companion-dnd5e-81nkluj30u9vsd-90z1oq")) && attr(e, "class", p2), (!_ || 1024 & o3[0] && d !== (d = t5[10].appId)) && attr(e, "data-appid", d), m && is_function(m.update) && 256 & o3[0] && m.update.call(null, t5[8]), f && is_function(f.update) && 4096 & o3[0] && f.update.call(null, t5[12]);
  }, i(t5) {
    _ || (transition_in(n.$$.fragment, t5), transition_in(b, t5), transition_in(s2.$$.fragment, t5), transition_in(l.$$.fragment, t5), _ = true);
  }, o(t5) {
    transition_out(n.$$.fragment, t5), transition_out(b, t5), transition_out(s2.$$.fragment, t5), transition_out(l.$$.fragment, t5), _ = false;
  }, d(o3) {
    o3 && detach(e), destroy_component(n), b && b.d(o3), t4[40](null), destroy_component(s2), destroy_component(l), t4[41](null), h = false, run_all(g2);
  } };
}
function create_if_block$1m(t4) {
  let e, n, o2, i, a, r2, s2, c, l, u, p2, d, m, f, _, h, g2, $2, b;
  n = new TJSApplicationHeader({ props: { draggable: t4[6], draggableOptions: t4[7] } });
  const y = t4[37].default, v = create_slot(y, t4, t4[36], null);
  return s2 = new ResizableHandle({}), l = new TJSFocusWrap({ props: { elementRoot: t4[1] } }), { c() {
    e = element("div"), create_component(n.$$.fragment), o2 = space(), i = element("section"), v && v.c(), r2 = space(), create_component(s2.$$.fragment), c = space(), create_component(l.$$.fragment), attr(i, "class", "window-content svelte-mobile-companion-dnd5e-81nkluj30u9vsd-90z1oq"), attr(i, "tabindex", "-1"), attr(e, "id", u = t4[10].id), attr(e, "class", p2 = "app window-app " + t4[10].options.classes.join(" ") + " svelte-mobile-companion-dnd5e-81nkluj30u9vsd-90z1oq"), attr(e, "data-appid", d = t4[10].appId), attr(e, "role", "application"), attr(e, "tabindex", "-1");
  }, m(u2, p3) {
    insert(u2, e, p3), mount_component(n, e, null), append(e, o2), append(e, i), v && v.m(i, null), t4[38](i), append(e, r2), mount_component(s2, e, null), append(e, c), mount_component(l, e, null), t4[39](e), g2 = true, $2 || (b = [listen(i, "pointerdown", t4[22]), action_destroyer(a = applyStyles.call(null, i, t4[9])), action_destroyer(t4[18].call(null, i, t4[23])), listen(e, "close:popup", stop_propagation(prevent_default(t4[19]))), listen(e, "keydown", t4[20]), listen(e, "pointerdown", t4[21], true), action_destroyer(m = applyStyles.call(null, e, t4[8])), action_destroyer(f = dynamicAction.call(null, e, t4[12]))], $2 = true);
  }, p(o3, i2) {
    t4 = o3;
    const r3 = {};
    64 & i2[0] && (r3.draggable = t4[6]), 128 & i2[0] && (r3.draggableOptions = t4[7]), n.$set(r3), v && v.p && (!g2 || 32 & i2[1]) && update_slot_base(v, y, t4, t4[36], g2 ? get_slot_changes(y, t4[36], i2, null) : get_all_dirty_from_scope(t4[36]), null), a && is_function(a.update) && 512 & i2[0] && a.update.call(null, t4[9]);
    const s3 = {};
    2 & i2[0] && (s3.elementRoot = t4[1]), l.$set(s3), (!g2 || 1024 & i2[0] && u !== (u = t4[10].id)) && attr(e, "id", u), (!g2 || 1024 & i2[0] && p2 !== (p2 = "app window-app " + t4[10].options.classes.join(" ") + " svelte-mobile-companion-dnd5e-81nkluj30u9vsd-90z1oq")) && attr(e, "class", p2), (!g2 || 1024 & i2[0] && d !== (d = t4[10].appId)) && attr(e, "data-appid", d), m && is_function(m.update) && 256 & i2[0] && m.update.call(null, t4[8]), f && is_function(f.update) && 4096 & i2[0] && f.update.call(null, t4[12]);
  }, i(o3) {
    g2 || (transition_in(n.$$.fragment, o3), transition_in(v, o3), transition_in(s2.$$.fragment, o3), transition_in(l.$$.fragment, o3), add_render_callback(() => {
      g2 && (h && h.end(1), _ = create_in_transition(e, t4[2], t4[4]), _.start());
    }), g2 = true);
  }, o(o3) {
    transition_out(n.$$.fragment, o3), transition_out(v, o3), transition_out(s2.$$.fragment, o3), transition_out(l.$$.fragment, o3), _ && _.invalidate(), h = create_out_transition(e, t4[3], t4[5]), g2 = false;
  }, d(o3) {
    o3 && detach(e), destroy_component(n), v && v.d(o3), t4[38](null), destroy_component(s2), destroy_component(l), t4[39](null), o3 && h && h.end(), $2 = false, run_all(b);
  } };
}
function create_fragment$28(t4) {
  let e, n, o2, i;
  const a = [create_if_block$1m, create_else_block$f], r2 = [];
  function s2(t5, e2) {
    return t5[2] !== TJSDefaultTransition.default || t5[3] !== TJSDefaultTransition.default ? 0 : 1;
  }
  return e = s2(t4), n = r2[e] = a[e](t4), { c() {
    n.c(), o2 = empty();
  }, m(t5, n2) {
    r2[e].m(t5, n2), insert(t5, o2, n2), i = true;
  }, p(t5, i2) {
    let c = e;
    e = s2(t5), e === c ? r2[e].p(t5, i2) : (group_outros(), transition_out(r2[c], 1, 1, () => {
      r2[c] = null;
    }), check_outros(), n = r2[e], n ? n.p(t5, i2) : (n = r2[e] = a[e](t5), n.c()), transition_in(n, 1), n.m(o2.parentNode, o2));
  }, i(t5) {
    i || (transition_in(n), i = true);
  }, o(t5) {
    transition_out(n), i = false;
  }, d(t5) {
    t5 && detach(o2), r2[e].d(t5);
  } };
}
function instance$27(t4, e, n) {
  let o2, i, a, r2, s2, c, { $$slots: l = {}, $$scope: u } = e, { elementContent: p2 } = e, { elementRoot: d } = e, { draggable: m } = e, { draggableOptions: f } = e, { stylesApp: _ } = e, { stylesContent: h } = e;
  const g2 = getContext("#external")?.application, { focusAuto: $2, focusKeep: b, focusTrap: y } = g2.reactive.storeAppOptions;
  component_subscribe(t4, $2, (t5) => n(32, a = t5)), component_subscribe(t4, b, (t5) => n(42, i = t5)), component_subscribe(t4, y, (t5) => n(34, s2 = t5));
  const { minimized: v } = g2.reactive.storeUIState;
  component_subscribe(t4, v, (t5) => n(33, r2 = t5));
  const { resizeObservable: k } = g2.position.stores;
  component_subscribe(t4, k, (t5) => n(35, c = t5));
  let { appOffsetHeight: w2 = false } = e, { appOffsetWidth: S2 = false } = e;
  const T = !!w2 || !!S2;
  let { contentOffsetHeight: x2 = false } = e, { contentOffsetWidth: E = false } = e;
  const O = x2 || E ? resizeObserver : () => null, A2 = new AppShellContextInternal(), C = { ignoreClasses: ["tjs-focus-wrap"] };
  let D;
  setContext("#internal", A2);
  let M, { transition: j = TJSDefaultTransition.default } = e, { inTransition: I = TJSDefaultTransition.default } = e, { outTransition: N = TJSDefaultTransition.default } = e, { transitionOptions: P2 } = e, { inTransitionOptions: F = TJSDefaultTransition.options } = e, { outTransitionOptions: R = TJSDefaultTransition.options } = e, L2 = TJSDefaultTransition.default;
  function H(t5, e2, o3, i2) {
    g2.position.stores.resizeObserved.update((n2) => (n2.contentWidth = o3, n2.contentHeight = i2, n2.offsetWidth = t5, n2.offsetHeight = e2, n2)), n(24, w2 = e2), n(25, S2 = t5);
  }
  return onMount(() => d.focus()), t4.$$set = (t5) => {
    "elementContent" in t5 && n(0, p2 = t5.elementContent), "elementRoot" in t5 && n(1, d = t5.elementRoot), "draggable" in t5 && n(6, m = t5.draggable), "draggableOptions" in t5 && n(7, f = t5.draggableOptions), "stylesApp" in t5 && n(8, _ = t5.stylesApp), "stylesContent" in t5 && n(9, h = t5.stylesContent), "appOffsetHeight" in t5 && n(24, w2 = t5.appOffsetHeight), "appOffsetWidth" in t5 && n(25, S2 = t5.appOffsetWidth), "contentOffsetHeight" in t5 && n(26, x2 = t5.contentOffsetHeight), "contentOffsetWidth" in t5 && n(27, E = t5.contentOffsetWidth), "transition" in t5 && n(28, j = t5.transition), "inTransition" in t5 && n(2, I = t5.inTransition), "outTransition" in t5 && n(3, N = t5.outTransition), "transitionOptions" in t5 && n(29, P2 = t5.transitionOptions), "inTransitionOptions" in t5 && n(4, F = t5.inTransitionOptions), "outTransitionOptions" in t5 && n(5, R = t5.outTransitionOptions), "$$scope" in t5 && n(36, u = t5.$$scope);
  }, t4.$$.update = () => {
    if (16 & t4.$$.dirty[1] && n(12, o2 = T || c ? { action: resizeObserver, data: H } : void 0), 1 & t4.$$.dirty[0] && null != p2 && getContext("#internal").stores.elementContent.set(p2), 2 & t4.$$.dirty[0] && null != d && getContext("#internal").stores.elementRoot.set(d), 14 & t4.$$.dirty[1] && n(11, D = a && s2 && !r2), 1342177280 & t4.$$.dirty[0] && L2 !== j) {
      const t5 = "function" == typeof j ? j : TJSDefaultTransition.default;
      n(2, I = t5), n(3, N = t5), n(30, L2 = t5);
    }
    if (536870912 & t4.$$.dirty[0] | 1 & t4.$$.dirty[1] && M !== P2) {
      const t5 = P2 !== TJSDefaultTransition.options && isObject$1(P2) ? P2 : TJSDefaultTransition.options;
      n(4, F = t5), n(5, R = t5), n(31, M = t5);
    }
    if (4 & t4.$$.dirty[0] && "function" != typeof I && n(2, I = TJSDefaultTransition.default), 1032 & t4.$$.dirty[0]) {
      "function" != typeof N && n(3, N = TJSDefaultTransition.default);
      const t5 = g2?.options?.defaultCloseAnimation;
      "boolean" == typeof t5 && t5 && N !== TJSDefaultTransition.default && n(10, g2.options.defaultCloseAnimation = false, g2);
    }
    16 & t4.$$.dirty[0] && (isObject$1(F) || n(4, F = TJSDefaultTransition.options)), 32 & t4.$$.dirty[0] && (isObject$1(R) || n(5, R = TJSDefaultTransition.options));
  }, [p2, d, I, N, F, R, m, f, _, h, g2, D, o2, $2, b, y, v, k, O, function(t5) {
    if (!a) return;
    const e2 = t5?.detail?.target;
    if (!A11yHelper.isFocusTarget(e2)) return;
    if (A11yHelper.isFocusable(e2)) return;
    const n2 = d.contains(e2);
    e2 === d ? d.focus() : e2 === p2 ? p2.focus() : n2 && (p2.contains(e2) ? p2.focus() : d.focus());
  }, function(t5) {
    if (t5.target !== d && t5.target !== p2 || !KeyboardManager || !KeyboardManager?._getMatchingActions?.(KeyboardManager?.getKeyboardEventContext?.(t5))?.length) {
      if (D && t5.shiftKey && "Tab" === t5.code) {
        const e2 = A11yHelper.getFocusableElements(d, C), n2 = e2.length > 0 ? e2[0] : void 0, o3 = e2.length > 0 ? e2[e2.length - 1] : void 0, i2 = g2.reactive.activeWindow;
        d !== i2.document.activeElement && n2 !== i2.document.activeElement || (A11yHelper.isFocusTarget(o3) && n2 !== o3 && o3.focus(), t5.preventDefault(), t5.stopPropagation());
      }
      "boolean" == typeof g2?.options?.popOut && g2.options.popOut && g2 !== globalThis.ui?.activeWindow && g2.bringToTop.call(g2);
    } else t5.target?.blur();
  }, function() {
    "boolean" == typeof g2?.options?.popOut && g2.options.popOut && g2 !== globalThis.ui?.activeWindow && g2.bringToTop.call(g2);
  }, function(t5) {
    if (!A11yHelper.isFocusable(t5.target) && a) if (i) {
      const e2 = g2.reactive.activeWindow;
      !d.contains(e2.document.activeElement) ? p2.focus() : t5.preventDefault();
    } else p2.focus();
  }, function(t5, e2) {
    n(27, E = t5), n(26, x2 = e2);
  }, w2, S2, x2, E, j, P2, L2, M, a, r2, s2, c, u, l, function(t5) {
    binding_callbacks[t5 ? "unshift" : "push"](() => {
      p2 = t5, n(0, p2);
    });
  }, function(t5) {
    binding_callbacks[t5 ? "unshift" : "push"](() => {
      d = t5, n(1, d);
    });
  }, function(t5) {
    binding_callbacks[t5 ? "unshift" : "push"](() => {
      p2 = t5, n(0, p2);
    });
  }, function(t5) {
    binding_callbacks[t5 ? "unshift" : "push"](() => {
      d = t5, n(1, d);
    });
  }];
}
class ApplicationShell extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$27, create_fragment$28, safe_not_equal, { elementContent: 0, elementRoot: 1, draggable: 6, draggableOptions: 7, stylesApp: 8, stylesContent: 9, appOffsetHeight: 24, appOffsetWidth: 25, contentOffsetHeight: 26, contentOffsetWidth: 27, transition: 28, inTransition: 2, outTransition: 3, transitionOptions: 29, inTransitionOptions: 4, outTransitionOptions: 5 }, null, [-1, -1]);
  }
  get elementContent() {
    return this.$$.ctx[0];
  }
  set elementContent(t4) {
    this.$$set({ elementContent: t4 }), flush();
  }
  get elementRoot() {
    return this.$$.ctx[1];
  }
  set elementRoot(t4) {
    this.$$set({ elementRoot: t4 }), flush();
  }
  get draggable() {
    return this.$$.ctx[6];
  }
  set draggable(t4) {
    this.$$set({ draggable: t4 }), flush();
  }
  get draggableOptions() {
    return this.$$.ctx[7];
  }
  set draggableOptions(t4) {
    this.$$set({ draggableOptions: t4 }), flush();
  }
  get stylesApp() {
    return this.$$.ctx[8];
  }
  set stylesApp(t4) {
    this.$$set({ stylesApp: t4 }), flush();
  }
  get stylesContent() {
    return this.$$.ctx[9];
  }
  set stylesContent(t4) {
    this.$$set({ stylesContent: t4 }), flush();
  }
  get appOffsetHeight() {
    return this.$$.ctx[24];
  }
  set appOffsetHeight(t4) {
    this.$$set({ appOffsetHeight: t4 }), flush();
  }
  get appOffsetWidth() {
    return this.$$.ctx[25];
  }
  set appOffsetWidth(t4) {
    this.$$set({ appOffsetWidth: t4 }), flush();
  }
  get contentOffsetHeight() {
    return this.$$.ctx[26];
  }
  set contentOffsetHeight(t4) {
    this.$$set({ contentOffsetHeight: t4 }), flush();
  }
  get contentOffsetWidth() {
    return this.$$.ctx[27];
  }
  set contentOffsetWidth(t4) {
    this.$$set({ contentOffsetWidth: t4 }), flush();
  }
  get transition() {
    return this.$$.ctx[28];
  }
  set transition(t4) {
    this.$$set({ transition: t4 }), flush();
  }
  get inTransition() {
    return this.$$.ctx[2];
  }
  set inTransition(t4) {
    this.$$set({ inTransition: t4 }), flush();
  }
  get outTransition() {
    return this.$$.ctx[3];
  }
  set outTransition(t4) {
    this.$$set({ outTransition: t4 }), flush();
  }
  get transitionOptions() {
    return this.$$.ctx[29];
  }
  set transitionOptions(t4) {
    this.$$set({ transitionOptions: t4 }), flush();
  }
  get inTransitionOptions() {
    return this.$$.ctx[4];
  }
  set inTransitionOptions(t4) {
    this.$$set({ inTransitionOptions: t4 }), flush();
  }
  get outTransitionOptions() {
    return this.$$.ctx[5];
  }
  set outTransitionOptions(t4) {
    this.$$set({ outTransitionOptions: t4 }), flush();
  }
}
cssVariables.setProperties({ "--tjs-default-text-shadow-focus-hover": "0 0 8px var(--color-shadow-primary)", "--tjs-app-background": `url("${globalThis.foundry.utils.getRoute("/ui/denim075.png")}")` }, false);
class ApplicationState {
  #me;
  #fe;
  #St = /* @__PURE__ */ new Map();
  constructor(t4) {
    this.#me = t4, Object.seal(this);
  }
  clear() {
    this.#St.clear();
  }
  current(t4 = {}) {
    return Object.assign(t4, { position: this.#me?.position?.get(), beforeMinimized: this.#me?.position?.state.get({ name: "#beforeMinimized" }), options: this.#me?.reactive?.toJSON(), ui: { minimized: this.#me?.reactive?.minimized } });
  }
  get({ name: t4 }) {
    if ("string" != typeof t4) throw new TypeError("[SvelteApp.state.get] error: 'name' is not a string.");
    return this.#St.get(t4);
  }
  keys() {
    return this.#St.keys();
  }
  remove({ name: t4 }) {
    if ("string" != typeof t4) throw new TypeError("[SvelteApp.state.remove] error: 'name' is not a string.");
    const e = this.#St.get(t4);
    return this.#St.delete(t4), e;
  }
  restore({ name: t4, remove: e = false, animateTo: n = false, duration: o2 = 0.1, ease: i = "linear" }) {
    if ("string" != typeof t4) throw new TypeError("[SvelteApp.state.restore] error: 'name' is not a string.");
    const a = this.#St.get(t4);
    return a && (e && this.#St.delete(t4), n && t4 !== this.#fe && (this.#fe = t4, this.#_e(a, { animateTo: n, async: true, duration: o2, ease: i }).then(() => {
      t4 === this.#fe && (this.#fe = void 0);
    }))), a;
  }
  save({ name: t4, ...e }) {
    if ("string" != typeof t4) throw new TypeError("[SvelteApp.state.save] error: 'name' is not a string.");
    const n = this.current(e);
    return this.#St.set(t4, n), n;
  }
  set(t4, e = {}) {
    this.#_e(t4, { ...e, async: false });
  }
  #_e(t4, { async: e = false, animateTo: n = false, duration: o2 = 0.1, ease: i = "linear" } = {}) {
    if (!isObject$1(t4)) throw new TypeError("[SvelteApp.state.set] error: 'data' is not an object.");
    const a = this.#me;
    if (!isObject$1(t4?.position)) return void console.warn("[SvelteApp.state.set] warning: 'data.position' is not an object.");
    const r2 = a.rendered;
    if (n) {
      if (!r2) return void console.warn("[SvelteApp.state.set] warning: application is not rendered and 'animateTo' is true.");
      if (t4.position.transformOrigin !== a.position.transformOrigin && (a.position.transformOrigin = t4.position.transformOrigin), isObject$1(t4?.ui)) {
        const e2 = "boolean" == typeof t4.ui?.minimized && t4.ui.minimized;
        a?.reactive?.minimized && !e2 && a.maximize({ animate: false, duration: 0 });
      }
      const n2 = a.position.animate.to(t4.position, { duration: o2, ease: i, strategy: "cancelAll" }).finished.then(({ cancelled: e2 }) => {
        if (!e2) {
          if (isObject$1(t4?.options) && a?.reactive.mergeOptions(t4.options), isObject$1(t4?.ui)) {
            const e3 = "boolean" == typeof t4.ui?.minimized && t4.ui.minimized;
            !a?.reactive?.minimized && e3 && a.minimize({ animate: false, duration: 0 });
          }
          isObject$1(t4?.beforeMinimized) && a.position.state.set({ name: "#beforeMinimized", ...t4.beforeMinimized });
        }
      });
      if (e) return n2;
    } else if (r2) {
      if (isObject$1(t4?.options) && a?.reactive.mergeOptions(t4.options), isObject$1(t4?.ui)) {
        const e2 = "boolean" == typeof t4.ui?.minimized && t4.ui.minimized;
        a?.reactive?.minimized && !e2 ? a.maximize({ animate: false, duration: 0 }) : !a?.reactive?.minimized && e2 && a.minimize({ animate: false, duration: o2 });
      }
      isObject$1(t4?.beforeMinimized) && a.position.state.set({ name: "#beforeMinimized", ...t4.beforeMinimized }), a.position.set(t4.position);
    } else {
      let e2 = t4.position;
      isObject$1(t4.beforeMinimized) && (e2 = t4.beforeMinimized, e2.left = t4.position.left, e2.top = t4.position.top), a.position.set(e2);
    }
  }
}
class GetSvelteData {
  #he;
  #ge;
  constructor(t4, e) {
    this.#he = t4, this.#ge = e;
  }
  get appShell() {
    return this.#he[0];
  }
  get applicationShell() {
    return this.#he[0];
  }
  get appShellData() {
    return this.#ge[0];
  }
}
class SvelteReactive {
  #me;
  #$e = false;
  #be;
  #ye;
  #ve;
  #ke;
  #we;
  #Se;
  #Te = [];
  constructor(t4) {
    this.#me = t4;
    const e = t4?.options?.sessionStorage;
    if (void 0 !== e && !(e instanceof TJSWebStorage)) throw new TypeError("'options.sessionStorage' is not an instance of TJSWebStorage.");
    this.#be = void 0 !== e ? e : new TJSSessionStorage();
  }
  initialize() {
    if (!this.#$e) return this.#$e = true, this.#xe(), { appOptionsUpdate: this.#ve, uiStateUpdate: this.#Se, subscribe: this.#Ee.bind(this), unsubscribe: this.#Oe.bind(this) };
  }
  get sessionStorage() {
    return this.#be;
  }
  get storeAppOptions() {
    return this.#ye;
  }
  get storeUIState() {
    return this.#we;
  }
  get activeWindow() {
    return this.#ke.activeWindow ?? globalThis;
  }
  get dragging() {
    return this.#ke.dragging;
  }
  get minimized() {
    return this.#ke.minimized;
  }
  get resizing() {
    return this.#ke.resizing;
  }
  set activeWindow(t4) {
    null != t4 && "[object Window]" !== Object.prototype.toString.call(t4) || this.#Se((e) => deepMerge(e, { activeWindow: t4 ?? globalThis }));
  }
  get draggable() {
    return this.#me?.options?.draggable;
  }
  get focusAuto() {
    return this.#me?.options?.focusAuto;
  }
  get focusKeep() {
    return this.#me?.options?.focusKeep;
  }
  get focusTrap() {
    return this.#me?.options?.focusTrap;
  }
  get headerButtonNoClose() {
    return this.#me?.options?.headerButtonNoClose;
  }
  get headerButtonNoLabel() {
    return this.#me?.options?.headerButtonNoLabel;
  }
  get headerIcon() {
    return this.#me?.options?.headerIcon;
  }
  get headerNoTitleMinimized() {
    return this.#me?.options?.headerNoTitleMinimized;
  }
  get minimizable() {
    return this.#me?.options?.minimizable;
  }
  get popOut() {
    return this.#me.popOut;
  }
  get positionable() {
    return this.#me?.options?.positionable;
  }
  get resizable() {
    return this.#me?.options?.resizable;
  }
  get title() {
    return this.#me.title;
  }
  set draggable(t4) {
    "boolean" == typeof t4 && this.setOptions("draggable", t4);
  }
  set focusAuto(t4) {
    "boolean" == typeof t4 && this.setOptions("focusAuto", t4);
  }
  set focusKeep(t4) {
    "boolean" == typeof t4 && this.setOptions("focusKeep", t4);
  }
  set focusTrap(t4) {
    "boolean" == typeof t4 && this.setOptions("focusTrap", t4);
  }
  set headerButtonNoClose(t4) {
    "boolean" == typeof t4 && this.setOptions("headerButtonNoClose", t4);
  }
  set headerButtonNoLabel(t4) {
    "boolean" == typeof t4 && this.setOptions("headerButtonNoLabel", t4);
  }
  set headerIcon(t4) {
    void 0 !== t4 && "string" != typeof t4 || this.setOptions("headerIcon", t4);
  }
  set headerNoTitleMinimized(t4) {
    "boolean" == typeof t4 && this.setOptions("headerNoTitleMinimized", t4);
  }
  set minimizable(t4) {
    "boolean" == typeof t4 && this.setOptions("minimizable", t4);
  }
  set popOut(t4) {
    "boolean" == typeof t4 && this.setOptions("popOut", t4);
  }
  set positionable(t4) {
    "boolean" == typeof t4 && this.setOptions("positionable", t4);
  }
  set resizable(t4) {
    "boolean" == typeof t4 && this.setOptions("resizable", t4);
  }
  set title(t4) {
    "string" == typeof t4 ? this.setOptions("title", t4) : null == t4 && this.setOptions("title", "");
  }
  getOptions(t4, e) {
    return safeAccess(this.#me.options, t4, e);
  }
  mergeOptions(t4) {
    this.#ve((e) => deepMerge(e, t4));
  }
  setOptions(t4, e) {
    safeSet(this.#me.options, t4, e, { createMissing: true }) && this.#ve(() => this.#me.options);
  }
  toJSON() {
    return { draggable: this.#me?.options?.draggable ?? true, focusAuto: this.#me?.options?.focusAuto ?? true, focusKeep: this.#me?.options?.focusKeep ?? false, focusTrap: this.#me?.options?.focusTrap ?? true, headerButtonNoClose: this.#me?.options?.headerButtonNoClose ?? false, headerButtonNoLabel: this.#me?.options?.headerButtonNoLabel ?? false, headerNoTitleMinimized: this.#me?.options?.headerNoTitleMinimized ?? false, minimizable: this.#me?.options?.minimizable ?? true, positionable: this.#me?.options?.positionable ?? true, resizable: this.#me?.options?.resizable ?? true };
  }
  updateHeaderButtons({ headerButtonNoClose: t4 = this.#me.options.headerButtonNoClose, headerButtonNoLabel: e = this.#me.options.headerButtonNoLabel } = {}) {
    let n = this.#me._getHeaderButtons();
    if ("boolean" == typeof t4 && t4 && (n = n.filter((t5) => "close" !== t5.class)), "boolean" == typeof e && e) for (const t5 of n) t5.label = void 0;
    this.#Se((t5) => (t5.headerButtons = n, t5));
  }
  #xe() {
    const t4 = writable(this.#me.options);
    this.#ve = t4.update;
    const e = { subscribe: t4.subscribe, draggable: propertyStore(t4, "draggable"), focusAuto: propertyStore(t4, "focusAuto"), focusKeep: propertyStore(t4, "focusKeep"), focusTrap: propertyStore(t4, "focusTrap"), headerButtonNoClose: propertyStore(t4, "headerButtonNoClose"), headerButtonNoLabel: propertyStore(t4, "headerButtonNoLabel"), headerIcon: propertyStore(t4, "headerIcon"), headerNoTitleMinimized: propertyStore(t4, "headerNoTitleMinimized"), minimizable: propertyStore(t4, "minimizable"), popOut: propertyStore(t4, "popOut"), positionable: propertyStore(t4, "positionable"), resizable: propertyStore(t4, "resizable"), title: propertyStore(t4, "title") };
    Object.freeze(e), this.#ye = e, this.#ke = { activeWindow: globalThis, dragging: false, headerButtons: [], minimized: this.#me._minimized, resizing: false };
    const n = writable(this.#ke);
    this.#Se = n.update;
    const o2 = { subscribe: n.subscribe, activeWindow: derived(n, (t5, e2) => e2(t5.activeWindow)), dragging: propertyStore(n, "dragging"), headerButtons: derived(n, (t5, e2) => e2(t5.headerButtons)), minimized: derived(n, (t5, e2) => e2(t5.minimized)), resizing: propertyStore(n, "resizing") };
    Object.freeze(o2), this.#we = o2;
  }
  #Ee() {
    this.#Te.push(subscribeIgnoreFirst(this.#ye.headerButtonNoClose, (t4) => {
      this.updateHeaderButtons({ headerButtonNoClose: t4 });
    })), this.#Te.push(subscribeIgnoreFirst(this.#ye.headerButtonNoLabel, (t4) => {
      this.updateHeaderButtons({ headerButtonNoLabel: t4 });
    })), this.#Te.push(subscribeIgnoreFirst(this.#ye.popOut, (t4) => {
      t4 && this.#me.rendered ? globalThis.ui.windows[this.#me.appId] = this.#me : delete globalThis.ui.windows[this.#me.appId];
    }));
  }
  #Oe() {
    this.#Te.forEach((t4) => t4()), this.#Te = [];
  }
}
const applicationShellContract = ["elementRoot"];
function isApplicationShell(t4) {
  if (null == t4) return false;
  let e = true, n = true;
  for (const n2 of applicationShellContract) {
    const o3 = Object.getOwnPropertyDescriptor(t4, n2);
    void 0 !== o3 && void 0 !== o3.get && void 0 !== o3.set || (e = false);
  }
  const o2 = Object.getPrototypeOf(t4);
  for (const t5 of applicationShellContract) {
    const e2 = Object.getOwnPropertyDescriptor(o2, t5);
    void 0 !== e2 && void 0 !== e2.get && void 0 !== e2.set || (n = false);
  }
  return e || n;
}
function loadSvelteConfig({ app: t4, config: e, elementRootUpdate: n } = {}) {
  let o2;
  if (CrossWindow.isHTMLElement(e.target)) o2 = e.target;
  else if ("string" == typeof e.target) {
    const n2 = t4?.reactive?.activeWindow;
    o2 = n2?.document?.querySelector(e.target);
  }
  if (!CrossWindow.isHTMLElement(o2)) throw e.target, new Error();
  const i = e.class, a = TJSSvelte.config.parseConfig({ ...e, target: o2 }, { contextExternal: true, thisArg: t4 }), r2 = a.context.get("#external");
  let s2;
  r2.application = t4, r2.elementRootUpdate = n, r2.sessionStorage = t4.reactive.sessionStorage, isObject$1(t4._eventbus) && "function" == typeof t4._eventbus.createProxy && (s2 = t4._eventbus.createProxy(), r2.eventbus = s2), Object.seal(r2);
  const c = new i(a);
  let l;
  if (a.eventbus = s2, isApplicationShell(c) && (l = c.elementRoot), !CrossWindow.isHTMLElement(l)) throw new Error();
  return { config: a, component: c, element: l };
}
Object.freeze(applicationShellContract);
class TJSAppIndex {
  static #Ae = /* @__PURE__ */ new Map();
  static add(t4) {
    this.#Ae.set(t4.id, t4);
  }
  static delete(t4) {
    this.#Ae.delete(t4.id);
  }
  static get(t4) {
    return this.#Ae.get(t4);
  }
  static has(t4) {
    return this.#Ae.has(t4);
  }
  static keys() {
    return this.#Ae.keys();
  }
  static values() {
    return this.#Ae.values();
  }
}
class SvelteApp extends Application {
  #he = [null];
  #Ce;
  #De = null;
  #Me = null;
  #je = false;
  #Ie = 95;
  #Ne = false;
  #vt;
  #Pe;
  #ge = [null];
  #Fe = new GetSvelteData(this.#he, this.#ge);
  #l;
  constructor(t4 = {}) {
    if (super(t4), !isObject$1(this.options.svelte)) throw new Error("SvelteApp - constructor - No Svelte configuration object found in 'options'.");
    this.#Ce = new ApplicationState(this), this.#vt = new TJSPosition(this, { ...this.position, ...this.options, initial: this.options.positionInitial, ortho: this.options.positionOrtho, validator: this.options.positionValidator }), delete this.position, Object.defineProperty(this, "position", { get: () => this.#vt, set: (t5) => {
      isObject$1(t5) && this.#vt.set(t5);
    } }), this.#Pe = new SvelteReactive(this), this.#l = this.#Pe.initialize();
  }
  static get defaultOptions() {
    return deepMerge(super.defaultOptions, { defaultCloseAnimation: true, draggable: true, focusAuto: true, focusKeep: false, focusSource: void 0, focusTrap: true, headerButtonNoClose: false, headerButtonNoLabel: false, headerIcon: void 0, headerNoTitleMinimized: false, minHeight: MIN_WINDOW_HEIGHT, minWidth: MIN_WINDOW_WIDTH, positionable: true, positionInitial: TJSPosition.Initial.browserCentered, positionOrtho: true, positionValidator: TJSPosition.Validators.transformWindow, sessionStorage: void 0, svelte: void 0, transformOrigin: "top left" });
  }
  get elementContent() {
    return this.#Me;
  }
  get elementTarget() {
    return this.#De;
  }
  get reactive() {
    return this.#Pe;
  }
  get state() {
    return this.#Ce;
  }
  get svelte() {
    return this.#Fe;
  }
  _activateCoreListeners(t4) {
    super._activateCoreListeners("string" == typeof this.options.template ? t4 : [this.popOut ? this.#De?.firstChild : this.#De]);
  }
  bringToTop({ focus: t4 = true, force: e = false } = {}) {
    if (this.reactive.activeWindow !== globalThis) return;
    (e || this.popOut) && super.bringToTop();
    const n = this.elementTarget, o2 = document.activeElement;
    t4 && n && o2 !== n && !n?.contains(o2) && (A11yHelper.isFocusTarget(o2) && o2.blur(), n?.focus()), globalThis.ui.activeWindow = this;
  }
  async close(t4 = {}) {
    const e = Application.RENDER_STATES;
    if (!t4.force && ![e.RENDERED, e.ERROR].includes(this._state)) return;
    const n = this.#De;
    if (!n) return void (this._state = e.CLOSED);
    if (CrossWindow.getWindow(n, { throws: false }) !== globalThis) return;
    this._state = e.CLOSING, this.#l.unsubscribe();
    const o2 = n.querySelector(".window-content");
    if (o2) {
      o2.style.overflow = "hidden";
      for (let t5 = o2.children.length; --t5 >= 0; ) o2.children[t5].style.overflow = "hidden";
    }
    for (const t5 of this.constructor._getInheritanceChain()) Hooks.call(`close${t5.name}`, this, $(n));
    if ("boolean" != typeof this.options.defaultCloseAnimation || this.options.defaultCloseAnimation) {
      n.style.minHeight = "0";
      const { paddingBottom: t5, paddingTop: e2 } = globalThis.getComputedStyle(n);
      await n.animate([{ maxHeight: `${n.clientHeight}px`, paddingTop: e2, paddingBottom: t5 }, { maxHeight: 0, paddingTop: 0, paddingBottom: 0 }], { duration: 250, easing: "ease-in", fill: "forwards" }).finished;
    }
    const i = [];
    for (const t5 of this.#ge) {
      if (!isObject$1(t5)) continue;
      i.push(TJSSvelte.util.outroAndDestroy(t5.component));
      const e2 = t5.config.eventbus;
      isObject$1(e2) && "function" == typeof e2.off && (e2.off(), t5.config.eventbus = void 0);
    }
    await Promise.allSettled(i), TJSAppIndex.delete(this), this.#ge[0] = null, n.remove(), this.position.state.restore({ name: "#beforeMinimized", properties: ["width", "height"], silent: true, remove: true }), this.#he[0] = null, this._element = null, this.#Me = null, this.#De = null, delete globalThis.ui.windows[this.appId], this._minimized = false, this._scrollPositions = null, this._state = e.CLOSED, this.#Ne = false, this.#l.uiStateUpdate((t5) => deepMerge(t5, { minimized: this._minimized })), A11yHelper.applyFocusSource(this.options.focusSource), delete this.options.focusSource;
  }
  _getHeaderButtons() {
    return super._getHeaderButtons();
  }
  _injectHTML() {
    this.reactive.updateHeaderButtons();
    if (!isObject$1(this.options.svelte)) throw new Error("SvelteApp - _injectHTML - No Svelte configuration object found in 'options'.");
    const t4 = loadSvelteConfig({ app: this, config: this.options.svelte, elementRootUpdate: () => {
      let t5 = 0;
      return (e) => null != e && t5++ > 0 && (this.#Re(), true);
    } });
    if (null !== this.svelte.appShell) throw new Error(`SvelteApp - _injectHTML - An application shell is already mounted; offending config:
${JSON.stringify(this.options.svelte)}`);
    this.#he[0] = t4.component, TJSSvelte.util.isHMRProxy(t4.component) && Array.isArray(t4.component?.$$?.on_hmr) && t4.component.$$.on_hmr.push(() => () => this.#Re()), this.#ge[0] = t4, this._element = $(this.svelte.appShell.elementRoot), this.#Me = hasGetter(this.svelte.appShell, "elementContent") ? this.svelte.appShell.elementContent : null, this.#De = hasGetter(this.svelte.appShell, "elementTarget") ? this.svelte.appShell.elementTarget : this.svelte.appShell.elementRoot, "boolean" == typeof this.options.positionable && this.options.positionable && (this.#De.style.zIndex = "number" == typeof this.options.zIndex ? this.options.zIndex : this.#Ie ?? 95), this.#l.subscribe();
  }
  async maximize({ animate: t4 = true, duration: e = 0.1 } = {}) {
    if (!this.popOut || [false, null].includes(this._minimized)) return;
    this._minimized = null;
    const n = 1e3 * e, o2 = this.elementTarget, i = o2.querySelector(".window-header"), a = o2.querySelector(".window-content"), r2 = this.position.state.get({ name: "#beforeMinimized" });
    t4 && await this.position.state.restore({ name: "#beforeMinimized", async: true, animateTo: true, properties: ["width"], duration: 0.1 }), o2.classList.remove("minimized");
    for (let t5 = i.children.length; --t5 >= 0; ) i.children[t5].style.display = null;
    let s2;
    a.style.display = null, { constraints: s2 } = t4 ? this.position.state.restore({ name: "#beforeMinimized", animateTo: true, properties: ["height"], remove: true, duration: e }) : this.position.state.remove({ name: "#beforeMinimized" }), await a.animate([{ maxHeight: 0, paddingTop: 0, paddingBottom: 0, offset: 0 }, { ...s2, offset: 1 }, { maxHeight: "100%", offset: 1 }], { duration: n, fill: "forwards" }).finished, this.position.set({ minHeight: r2.minHeight ?? this.options?.minHeight ?? MIN_WINDOW_HEIGHT, minWidth: r2.minWidth ?? this.options?.minWidth ?? MIN_WINDOW_WIDTH }), o2.style.minWidth = null, o2.style.minHeight = null, this._minimized = false, setTimeout(() => {
      a.style.overflow = null;
      for (let t5 = a.children.length; --t5 >= 0; ) a.children[t5].style.overflow = null;
    }, 50), this.#l.uiStateUpdate((t5) => deepMerge(t5, { minimized: false }));
  }
  async minimize({ animate: t4 = true, duration: e = 0.1 } = {}) {
    if (!this.rendered || !this.popOut || [true, null].includes(this._minimized)) return;
    this.#l.uiStateUpdate((t5) => deepMerge(t5, { minimized: true })), this._minimized = null;
    const n = 1e3 * e, o2 = this.elementTarget, i = o2.querySelector(".window-header"), a = o2.querySelector(".window-content"), r2 = this.position.minWidth, s2 = this.position.minHeight;
    if (this.position.set({ minWidth: 100, minHeight: 30 }), o2.style.minWidth = "100px", o2.style.minHeight = "30px", a) {
      a.style.overflow = "hidden";
      for (let t5 = a.children.length; --t5 >= 0; ) a.children[t5].style.overflow = "hidden";
    }
    const { paddingBottom: c, paddingTop: l } = globalThis.getComputedStyle(a), u = { maxHeight: `${a.clientHeight}px`, paddingTop: l, paddingBottom: c };
    if (t4) {
      a.animate([u, { maxHeight: 0, paddingTop: 0, paddingBottom: 0 }], { duration: n, fill: "forwards" }).finished.then(() => a.style.display = "none");
    } else setTimeout(() => a.style.display = "none", n);
    const p2 = this.position.state.save({ name: "#beforeMinimized", constraints: u });
    p2.minWidth = r2, p2.minHeight = s2;
    const d = i.offsetHeight;
    this.position.minHeight = d, t4 && await this.position.animate.to({ height: d }, { duration: e }).finished;
    for (let t5 = i.children.length; --t5 >= 0; ) {
      const e2 = i.children[t5].className;
      e2.includes("window-title") || e2.includes("close") || (e2.includes("keep-minimized") ? i.children[t5].style.display = "block" : i.children[t5].style.display = "none");
    }
    t4 && await this.position.animate.to({ width: MIN_WINDOW_WIDTH }, { duration: 0.1 }).finished, o2.classList.add("minimized"), this._minimized = true;
  }
  onSvelteMount() {
  }
  onSvelteRemount() {
  }
  _replaceHTML(t4, e) {
    t4.length && this.reactive.updateHeaderButtons();
  }
  async _render(t4 = false, e = {}) {
    isObject$1(e?.focusSource) && (this.options.focusSource = e.focusSource);
    const n = this.reactive.activeWindow;
    try {
      if (this._state === Application.RENDER_STATES.NONE && A11yHelper.isFocusTarget(n.document.querySelector(`#${this.id}`))) return void console.warn(`SvelteApp - _render: A DOM element already exists for CSS ID '${this.id}'. Cancelling initial render for new application with appId '${this.appId}'.`);
    } catch (t5) {
      return void console.warn(`SvelteApp - _render: Potentially malformed application ID '${this.id}'. Cancelling initial render for new application with appId '${this.appId}'.`);
    }
    this.#je = true, await super._render(t4, e), this.#je = false, [Application.RENDER_STATES.CLOSING, Application.RENDER_STATES.RENDERING].includes(this._state) || !t4 && this._state <= Application.RENDER_STATES.NONE || (this._minimized || this.#vt.set({ left: "string" == typeof this.options?.left ? this.options.left : void 0, height: "string" == typeof this.options?.height ? this.options.height : void 0, maxHeight: "string" == typeof this.options?.maxHeight ? this.options.maxHeight : void 0, maxWidth: "string" == typeof this.options?.maxWidth ? this.options.maxWidth : void 0, minHeight: "string" == typeof this.options?.minHeight ? this.options.minHeight : void 0, minWidth: "string" == typeof this.options?.minWidth ? this.options.minWidth : void 0, rotateX: "string" == typeof this.options?.rotateX ? this.options.rotateX : void 0, rotateY: "string" == typeof this.options?.rotateY ? this.options.rotateY : void 0, rotateZ: "string" == typeof this.options?.rotateZ ? this.options.rotateZ : void 0, rotation: "string" == typeof this.options?.rotation ? this.options.rotation : void 0, top: "string" == typeof this.options?.top ? this.options.top : void 0, width: "string" == typeof this.options?.width ? this.options.width : void 0, ...e }), this.#Ne || (TJSAppIndex.add(this), this.onSvelteMount(), this.#Ne = true));
  }
  async _renderInner() {
    const t4 = this.reactive.activeWindow.document.createDocumentFragment();
    return $(t4);
  }
  async _renderOuter() {
    const t4 = await super._renderOuter();
    return this.#Ie = t4[0].style.zIndex, t4;
  }
  setPosition(t4) {
    return this.#je ? this.position : this.position.set(t4);
  }
  #Re() {
    const t4 = this.svelte.appShell;
    null !== t4 && (this._element = $(t4.elementRoot), this.#Me = hasGetter(t4, "elementContent") ? t4.elementContent : null, this.#De = hasGetter(t4, "elementTarget") ? t4.elementTarget : null, null === this.#De && (this.#De = "string" == typeof this.options.selectorTarget ? this._element[0].querySelector(this.options.selectorTarget) : this._element[0]), "boolean" == typeof this.options.positionable && this.options.positionable && (this.#De.style.zIndex = "number" == typeof this.options.zIndex ? this.options.zIndex : this.#Ie ?? 95, super.bringToTop(), this.position.set(this.position.get())), super._activateCoreListeners([this.popOut ? this.#De?.firstChild : this.#De]), this.onSvelteRemount());
  }
}
class PopoutSupport {
  static initialize() {
    Hooks.on("PopOut:loading", (t4, e) => {
      t4 instanceof SvelteApp && (t4.position.enabled = false, t4.state.save({ name: "#beforePopout", headerButtonNoClose: t4.reactive.headerButtonNoClose }), t4.reactive.activeWindow = e, t4.reactive.headerButtonNoClose = true);
    }), Hooks.on("PopOut:popin", (t4) => this.#Le(t4)), Hooks.on("PopOut:close", (t4) => this.#Le(t4));
  }
  static #Le(t4) {
    if (t4 instanceof SvelteApp) {
      t4.position.enabled = true;
      const e = t4.state.remove({ name: "#beforePopout" });
      e && (t4.reactive.headerButtonNoClose = e?.headerButtonNoClose ?? false), t4.reactive.activeWindow = void 0;
    }
  }
}
function get_each_context$u(t4, e, n) {
  const o2 = t4.slice();
  return o2[9] = e[n], o2[10] = e, o2[11] = n, o2;
}
function create_each_block$u(t4, e) {
  let n, o2, i, a, r2, s2, c, l, u, p2, d, m, f, _, h = e[9].name + "";
  function g2() {
    e[4].call(c, e[10], e[11]);
  }
  function $2() {
    e[5].call(p2, e[10], e[11]);
  }
  return { key: t4, first: null, c() {
    n = element("li"), o2 = element("div"), i = element("h4"), a = text(h), r2 = space(), s2 = element("div"), c = element("input"), l = space(), u = element("div"), p2 = element("input"), m = space(), attr(c, "type", "checkbox"), attr(p2, "type", "number"), p2.disabled = d = !e[9].enabled, attr(n, "class", "item svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1jj7tri"), attr(n, "data-item-id", this.id), this.first = n;
  }, m(t5, d2) {
    insert(t5, n, d2), append(n, o2), append(o2, i), append(i, a), append(n, r2), append(n, s2), append(s2, c), c.checked = e[9].enabled, append(n, l), append(n, u), append(u, p2), set_input_value(p2, e[9].screenWidth), append(n, m), f || (_ = [listen(c, "change", g2), listen(p2, "input", $2)], f = true);
  }, p(t5, n2) {
    e = t5, 2 & n2 && h !== (h = e[9].name + "") && set_data(a, h), 2 & n2 && (c.checked = e[9].enabled), 2 & n2 && d !== (d = !e[9].enabled) && (p2.disabled = d), 2 & n2 && to_number(p2.value) !== e[9].screenWidth && set_input_value(p2, e[9].screenWidth);
  }, d(t5) {
    t5 && detach(n), f = false, run_all(_);
  } };
}
function create_default_slot$i(t4) {
  let e, n, o2, i, a, r2, s2, c, l, u, p2, d, m = [], f = /* @__PURE__ */ new Map(), _ = ensure_array_like(t4[1]);
  const h = (t5) => t5[9].id;
  for (let e2 = 0; e2 < _.length; e2 += 1) {
    let n2 = get_each_context$u(t4, _, e2), o3 = h(n2);
    f.set(o3, m[e2] = create_each_block$u(o3, n2));
  }
  return { c() {
    e = element("form"), n = element("div"), o2 = element("ol"), i = element("li"), i.innerHTML = "<div>Player</div> <div>Enable</div> <div>Activation screen width</div>", a = space(), r2 = element("ol");
    for (let t5 = 0; t5 < m.length; t5 += 1) m[t5].c();
    s2 = space(), c = element("button"), c.textContent = "Save", l = space(), u = element("button"), u.textContent = "Cancel", attr(i, "class", "table-header svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1jj7tri"), attr(r2, "class", "item-list svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1jj7tri"), attr(o2, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1jj7tri"), attr(n, "class", "settings svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1jj7tri"), attr(u, "type", "reset"), set_style(e, "height", "100%"), attr(e, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1jj7tri");
  }, m(f2, _2) {
    insert(f2, e, _2), append(e, n), append(n, o2), append(o2, i), append(o2, a), append(o2, r2);
    for (let t5 = 0; t5 < m.length; t5 += 1) m[t5] && m[t5].m(r2, null);
    append(e, s2), append(e, c), append(e, l), append(e, u), p2 || (d = [listen(c, "click", prevent_default(t4[3])), listen(u, "click", prevent_default(t4[6]))], p2 = true);
  }, p(t5, e2) {
    2 & e2 && (_ = ensure_array_like(t5[1]), m = update_keyed_each(m, e2, h, 1, t5, _, f, r2, destroy_block, create_each_block$u, null, get_each_context$u));
  }, d(t5) {
    t5 && detach(e);
    for (let t6 = 0; t6 < m.length; t6 += 1) m[t6].d();
    p2 = false, run_all(d);
  } };
}
function create_fragment$27(t4) {
  let e, n, o2;
  function i(e2) {
    t4[7](e2);
  }
  let a = { $$slots: { default: [create_default_slot$i] }, $$scope: { ctx: t4 } };
  return void 0 !== t4[0] && (a.elementRoot = t4[0]), e = new ApplicationShell({ props: a }), binding_callbacks.push(() => bind(e, "elementRoot", i)), { c() {
    create_component(e.$$.fragment);
  }, m(t5, n2) {
    mount_component(e, t5, n2), o2 = true;
  }, p(t5, [o3]) {
    const i2 = {};
    4098 & o3 && (i2.$$scope = { dirty: o3, ctx: t5 }), !n && 1 & o3 && (n = true, i2.elementRoot = t5[0], add_flush_callback(() => n = false)), e.$set(i2);
  }, i(t5) {
    o2 || (transition_in(e.$$.fragment, t5), o2 = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), o2 = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function instance$26(t4, e, n) {
  let { elementRoot: o2 } = e;
  const { application: i } = getContext("#external"), a = game.settings.get(getFullModuleId(), settings.users);
  let r2 = game.users.filter((t5) => t5.role !== FoundryUserRoles.GAMEMASTER.valueOf()).map((t5) => {
    let e2 = a[t5.id] || {};
    return foundry.utils.isNewerVersion(game.version, "12") ? foundry.utils.mergeObject({ id: t5.id, name: t5.name, enabled: false, screenWidth: 0 }, e2) : mergeObject({ id: t5.id, name: t5.name, enabled: false, screenWidth: 0 }, e2);
  });
  return t4.$$set = (t5) => {
    "elementRoot" in t5 && n(0, o2 = t5.elementRoot);
  }, [o2, r2, i, function() {
    r2.forEach((t5) => {
      let e2 = a[t5.id] || {};
      e2.enabled = t5.enabled, e2.screenWidth = t5.screenWidth || 0, a[t5.id] = e2;
    }), game.settings.set(getFullModuleId(), settings.users, a), i.close();
  }, function(t5, e2) {
    t5[e2].enabled = this.checked, n(1, r2);
  }, function(t5, e2) {
    t5[e2].screenWidth = to_number(this.value), n(1, r2);
  }, () => i.close(), function(t5) {
    o2 = t5, n(0, o2);
  }];
}
PopoutSupport.initialize();
let UserSetupShell$1 = class extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$26, create_fragment$27, safe_not_equal, { elementRoot: 0 });
  }
  get elementRoot() {
    return this.$$.ctx[0];
  }
  set elementRoot(t4) {
    this.$$set({ elementRoot: t4 }), flush();
  }
};
class UserSetupShell extends SvelteApp {
  static get defaultOptions() {
    return foundry.utils.mergeObject(super.defaultOptions, { title: "Settings", width: "auto", height: "auto", resizable: false, svelte: { class: UserSetupShell$1, target: document.body } });
  }
}
class SettingsUser extends FormApplication {
  static #He;
  static showSettings() {
    return this.#He = this.#He ? this.#He : new UserSetupShell(), this.#He.render(true, { focus: true }), this.#He;
  }
  constructor(t4 = {}) {
    super({}, t4), SettingsUser.showSettings();
  }
  async _updateObject(t4, e) {
    await super._updateObject(t4, e);
  }
  render() {
    this.close();
  }
}
function i18n(t4) {
  return game.i18n.localize(t4);
}
function myi18n(t4) {
  return i18n("Mobile-Companion.".concat(t4));
}
function i18nFormat(t4, e) {
  return game.i18n.format(t4, e);
}
async function enrichText(t4, e = []) {
  let n = t4;
  for (const t5 of e) {
    const e2 = new RegExp(t5.find, "g");
    n = n.replace(e2, t5.replace);
  }
  return n = foundry.utils.isNewerVersion(game.version, "12.343") ? await foundry.applications.ux.TextEditor.implementation.enrichHTML(n) : await TextEditor.enrichHTML(n), n;
}
const USE_CURRENCY = "useCurrency", USE_ENCUMBRANCE = "useEncumbrance", USE_CONTAINER = "useContainer", USE_ADDITIONAL_INFO = "useAdditionalInfo", SHOW_AVERAGE_DAMAGE = "showAverageDamage", SHOW_BIO_TAB = "showBioTab", ALLOW_BIO_EDIT = "allowBioEdit", SPLITSCREEN_ENABLED = "splitscreenEnabled", LAST_ACTOR_ID = "lastActorId";
class MobileCompanionGameSettings extends TJSGameSettings {
  constructor() {
    super(getFullModuleId());
  }
  getWritableStore(t4) {
    return super.getWritableStore(t4);
  }
  init() {
    const t4 = getFullModuleId();
    game.settings.registerMenu(t4, settings.usersMenu, { name: "Set users", label: "Users", hint: "Set up users who use mobile companion", type: SettingsUser, icon: "fas fa-users", restricted: true }), game.settings.register(t4, settings.users, { scope: "world", config: false, default: {}, type: Object }), game.settings.register(t4, LAST_ACTOR_ID, { scope: "client", config: false, type: String, default: "" }), super.registerAll(getDnd5eSettings(t4), true), super.registerAll(getCommonSettings(t4, mobileCompanionGameSettings));
  }
}
function getDnd5eSettings(t4) {
  const e = [];
  return e.push({ namespace: t4, key: USE_CURRENCY, options: { name: myi18n("Settings.UseCurrency.Name"), hint: myi18n("Settings.UseCurrency.Hint"), scope: "client", config: true, type: Boolean, default: true } }), e.push({ namespace: t4, key: USE_ENCUMBRANCE, options: { name: myi18n("Settings.UseEncumbrance.Name"), hint: myi18n("Settings.UseEncumbrance.Hint"), scope: "client", config: true, type: Boolean, default: true } }), e.push({ namespace: t4, key: USE_CONTAINER, options: { name: myi18n("Settings.UseContainer.Name"), hint: myi18n("Settings.UseContainer.Hint"), scope: "client", config: true, type: Boolean, default: true } }), e.push({ namespace: t4, key: USE_ADDITIONAL_INFO, options: { name: myi18n("Settings.AdditionalItemInfo.Name"), hint: myi18n("Settings.AdditionalItemInfo.Hint"), scope: "client", config: true, type: Boolean, default: true } }), e.push({ namespace: t4, key: SHOW_AVERAGE_DAMAGE, options: { name: myi18n("Settings.ShowAverageDamage.Name"), hint: myi18n("Settings.ShowAverageDamage.Hint"), scope: "client", config: true, type: Boolean, default: true } }), e.push({ namespace: t4, key: SHOW_BIO_TAB, options: { name: myi18n("Settings.ShowBioTab.Name"), hint: myi18n("Settings.ShowBioTab.Hint"), scope: "client", config: true, type: Boolean, default: true } }), e.push({ namespace: t4, key: ALLOW_BIO_EDIT, options: { name: myi18n("Settings.AllowBioEdit.Name"), hint: myi18n("Settings.AllowBioEdit.Hint"), scope: "client", config: true, type: Boolean, default: false } }), e.push({ namespace: t4, key: SPLITSCREEN_ENABLED, options: { name: myi18n("Settings.Splitscreen.Name"), hint: myi18n("Settings.Splitscreen.Hint"), scope: "client", config: true, type: Boolean, default: false } }), e;
}
const mobileCompanionGameSettings = new MobileCompanionGameSettings();
var Filters = ((t4) => (t4.Abilities = "abilities", t4.Biography = "biography", t4.Character = "character", t4.Inventory = "object", t4.Features = "features", t4.Spell = "spell", t4.Traits = "traits", t4.CharacterSelect = "characterSelect", t4))(Filters || {});
function handleUpdate(t4, e, n) {
  let o2 = get_store_value(e);
  t4 === o2.id && (o2 = game.actors.find((t5) => t5.id === o2.id), e.set(o2), n());
}
function handleActorUpdate(t4, e, n) {
  let o2 = get_store_value(e);
  o2.id === t4.id && setTimeout(() => {
    o2 = t4, e.set(o2), n();
  }, 100);
}
const actorStore$1 = writable({}), activeFilterStore$1 = writable(Filters.Character);
let currentFilter$1 = Filters.Character;
function initLeft(t4) {
  actorStore$1.set(t4), activeFilterStore$1.subscribe((t5) => {
    currentFilter$1 = t5;
  });
}
const onHandleUpdate$1 = async (t4) => {
  handleUpdate(t4.parent?.id, actorStore$1, () => switchFilter$1(get_store_value(activeFilterStore$1)));
}, onHandleActorUpdate$1 = async (t4) => {
  handleActorUpdate(t4, actorStore$1, () => switchFilter$1(get_store_value(activeFilterStore$1)));
}, handleEffectChange$1 = async (t4) => {
  await onHandleActorUpdate$1(t4.parent);
};
function handleOnMount$1() {
  Hooks.on("createItem", onHandleUpdate$1), Hooks.on("deleteItem", onHandleUpdate$1), Hooks.on("updateItem", onHandleUpdate$1), Hooks.on("updateActor", onHandleActorUpdate$1), Hooks.on("deleteActiveEffect", handleEffectChange$1), Hooks.on("createActiveEffect", handleEffectChange$1), Hooks.on("updateActiveEffect", handleEffectChange$1), switchFilter$1(get_store_value(activeFilterStore$1));
}
function handleOffMount$1() {
  Hooks.off("createItem", onHandleUpdate$1), Hooks.off("deleteItem", onHandleUpdate$1), Hooks.off("updateItem", onHandleUpdate$1), Hooks.off("updateActor", onHandleActorUpdate$1), Hooks.off("deleteActiveEffect", handleEffectChange$1), Hooks.off("createActiveEffect", handleEffectChange$1), Hooks.off("updateActiveEffect", handleEffectChange$1);
}
function switchFilter$1(t4) {
  activeFilterStore$1.set(t4);
}
function getCurrentFilterLeft() {
  return currentFilter$1;
}
function isFull() {
  return false;
}
const actorStore = writable({}), activeFilterStore = writable(Filters.Character);
let currentFilter = Filters.Character;
function initRight(t4) {
  actorStore.set(t4), activeFilterStore.subscribe((t5) => {
    currentFilter = t5;
  });
}
const onHandleUpdate = async (t4) => {
  handleUpdate(t4.parent?.id, actorStore, () => switchFilter(get_store_value(activeFilterStore)));
}, onHandleActorUpdate = async (t4) => {
  handleActorUpdate(t4, actorStore, () => switchFilter(get_store_value(activeFilterStore)));
}, handleEffectChange = async (t4) => {
  await onHandleActorUpdate(t4.parent);
};
function handleOnMount() {
  Hooks.on("createItem", onHandleUpdate), Hooks.on("deleteItem", onHandleUpdate), Hooks.on("updateItem", onHandleUpdate), Hooks.on("updateActor", onHandleActorUpdate), Hooks.on("deleteActiveEffect", handleEffectChange), Hooks.on("createActiveEffect", handleEffectChange), Hooks.on("updateActiveEffect", handleEffectChange), switchFilter(get_store_value(activeFilterStore));
}
function handleOffMount() {
  Hooks.off("createItem", onHandleUpdate), Hooks.off("deleteItem", onHandleUpdate), Hooks.off("updateItem", onHandleUpdate), Hooks.off("updateActor", onHandleActorUpdate), Hooks.off("deleteActiveEffect", handleEffectChange), Hooks.off("createActiveEffect", handleEffectChange), Hooks.off("updateActiveEffect", handleEffectChange);
}
function switchFilter(t4) {
  activeFilterStore.set(t4);
}
function getCurrentFilterRight() {
  return currentFilter;
}
function getHeaderButtons(t4, e, n) {
  const o2 = createButtons(e, n), i = [];
  return i.push(o2.characterButton), i.push(o2.abilitiesButton), i.push(o2.inventoryButton), i.push(o2.featuresButton), t4 && i.push(o2.spellButton), i.push(o2.traitButton), game.settings.get(getFullModuleId(), SHOW_BIO_TAB) && i.push(o2.bioButton), i;
}
function createButtons(t4, e) {
  return { characterButton: { id: [Filters.Character, Filters.CharacterSelect], iconClass: "fas fa-user", buttonClass: "dnd-button", label: "Character", onClick: () => t4(e() === Filters.Character ? Filters.CharacterSelect : Filters.Character) }, abilitiesButton: { id: [Filters.Abilities], iconClass: "fas fa-graduation-cap", buttonClass: "dnd-button", label: "Abilities", onClick: () => t4(Filters.Abilities) }, inventoryButton: { id: [Filters.Inventory], iconClass: "fas fa-box-open", buttonClass: "dnd-button", label: "Inventory", onClick: () => t4(Filters.Inventory) }, featuresButton: { id: [Filters.Features], iconClass: "fas fa-list", buttonClass: "dnd-button", label: "Features", onClick: () => t4(Filters.Features) }, spellButton: { id: [Filters.Spell], iconClass: "fas fa-wand-sparkles", buttonClass: "dnd-button", label: "Spells", onClick: () => t4(Filters.Spell) }, traitButton: { id: [Filters.Traits], iconClass: "fas fa-flag", buttonClass: "dnd-button", label: "Traits", onClick: () => t4(Filters.Traits) }, bioButton: { id: [Filters.Biography], iconClass: "fas fa-feather", buttonClass: "dnd-button", label: "Biography", onClick: () => t4(Filters.Biography) } };
}
const menuButtons = { buttonClass: "dnd-button", iconClass: "" };
function create_else_block$e(t4) {
  let e, n;
  return { c() {
    e = element("i"), attr(e, "class", n = null_to_empty(t4[1]) + " svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1b8xxc1");
  }, m(t5, n2) {
    insert(t5, e, n2);
  }, p(t5, o2) {
    2 & o2 && n !== (n = null_to_empty(t5[1]) + " svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1b8xxc1") && attr(e, "class", n);
  }, d(t5) {
    t5 && detach(e);
  } };
}
function create_if_block$1l(t4) {
  let e, n;
  return { c() {
    e = element("dnd5e-icon"), src_url_equal(e.src, n = t4[1]) || set_custom_element_data(e, "src", n);
  }, m(t5, n2) {
    insert(t5, e, n2);
  }, p(t5, o2) {
    2 & o2 && !src_url_equal(e.src, n = t5[1]) && set_custom_element_data(e, "src", n);
  }, d(t5) {
    t5 && detach(e);
  } };
}
function create_fragment$26(t4) {
  let e, n, o2, i, a, r2;
  let s2 = function(t5) {
    return t5[2] ? create_if_block$1l : create_else_block$e;
  }(t4), c = s2(t4);
  const l = t4[4].default, u = create_slot(l, t4, t4[3], null);
  return { c() {
    e = element("h3"), c.c(), n = space(), o2 = element("span"), i = text(t4[0]), a = space(), u && u.c(), attr(o2, "class", "roboto-upper"), attr(e, "class", "icon svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1b8xxc1");
  }, m(t5, s3) {
    insert(t5, e, s3), c.m(e, null), append(e, n), append(e, o2), append(o2, i), append(e, a), u && u.m(e, null), r2 = true;
  }, p(t5, [e2]) {
    c.p(t5, e2), (!r2 || 1 & e2) && set_data(i, t5[0]), u && u.p && (!r2 || 8 & e2) && update_slot_base(u, l, t5, t5[3], r2 ? get_slot_changes(l, t5[3], e2, null) : get_all_dirty_from_scope(t5[3]), null);
  }, i(t5) {
    r2 || (transition_in(u, t5), r2 = true);
  }, o(t5) {
    transition_out(u, t5), r2 = false;
  }, d(t5) {
    t5 && detach(e), c.d(), u && u.d(t5);
  } };
}
function instance$25(t4, e, n) {
  let { $$slots: o2 = {}, $$scope: i } = e, { title: a } = e, { icon: r2 } = e;
  const s2 = r2.endsWith(".svg");
  return t4.$$set = (t5) => {
    "title" in t5 && n(0, a = t5.title), "icon" in t5 && n(1, r2 = t5.icon), "$$scope" in t5 && n(3, i = t5.$$scope);
  }, [a, r2, s2, i, o2];
}
class TraitHeader extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$25, create_fragment$26, safe_not_equal, { title: 0, icon: 1 });
  }
}
function get_each_context$t(t4, e, n) {
  const o2 = t4.slice();
  return o2[2] = e[n][0], o2[3] = e[n][1], o2;
}
function create_if_block_1$E(t4) {
  let e, n, o2, i, a, r2, s2, c, l, u, p2, d = t4[1].senses[t4[2]] + "", m = t4[3] + "", f = t4[0].units + "";
  return { c() {
    e = element("li"), n = element("span"), o2 = text(d), i = space(), a = element("span"), a.textContent = "|", r2 = space(), s2 = element("span"), c = text(m), l = space(), u = text(f), p2 = space(), attr(n, "class", "label"), attr(a, "class", "separator"), attr(s2, "class", "value"), attr(e, "class", "mc-trait-pill");
  }, m(t5, d2) {
    insert(t5, e, d2), append(e, n), append(n, o2), append(e, i), append(e, a), append(e, r2), append(e, s2), append(s2, c), append(s2, l), append(s2, u), append(e, p2);
  }, p(t5, e2) {
    1 & e2 && d !== (d = t5[1].senses[t5[2]] + "") && set_data(o2, d), 1 & e2 && m !== (m = t5[3] + "") && set_data(c, m), 1 & e2 && f !== (f = t5[0].units + "") && set_data(u, f);
  }, d(t5) {
    t5 && detach(e);
  } };
}
function create_if_block$1k(t4) {
  let e, n, o2 = t4[3] + "";
  return { c() {
    e = element("li"), n = text(o2), attr(e, "class", "mc-trait-pill");
  }, m(t5, o3) {
    insert(t5, e, o3), append(e, n);
  }, p(t5, e2) {
    1 & e2 && o2 !== (o2 = t5[3] + "") && set_data(n, o2);
  }, d(t5) {
    t5 && detach(e);
  } };
}
function create_each_block$t(t4) {
  let e;
  function n(t5, e2) {
    return "special" === t5[2] && t5[3] ? create_if_block$1k : "units" !== t5[2] && t5[3] && 0 !== t5[3] ? create_if_block_1$E : void 0;
  }
  let o2 = n(t4), i = o2 && o2(t4);
  return { c() {
    i && i.c(), e = empty();
  }, m(t5, n2) {
    i && i.m(t5, n2), insert(t5, e, n2);
  }, p(t5, a) {
    o2 === (o2 = n(t5)) && i ? i.p(t5, a) : (i && i.d(1), i = o2 && o2(t5), i && (i.c(), i.m(e.parentNode, e)));
  }, d(t5) {
    t5 && detach(e), i && i.d(t5);
  } };
}
function create_fragment$25(t4) {
  let e, n, o2, i;
  e = new TraitHeader({ props: { title: i18n("DND5E.Senses"), icon: "fas fa-eye" } });
  let a = ensure_array_like(Object.entries(t4[0])), r2 = [];
  for (let e2 = 0; e2 < a.length; e2 += 1) r2[e2] = create_each_block$t(get_each_context$t(t4, a, e2));
  return { c() {
    create_component(e.$$.fragment), n = space(), o2 = element("ul");
    for (let t5 = 0; t5 < r2.length; t5 += 1) r2[t5].c();
    attr(o2, "class", "mc-trait-pills");
  }, m(t5, a2) {
    mount_component(e, t5, a2), insert(t5, n, a2), insert(t5, o2, a2);
    for (let t6 = 0; t6 < r2.length; t6 += 1) r2[t6] && r2[t6].m(o2, null);
    i = true;
  }, p(t5, [e2]) {
    if (3 & e2) {
      let n2;
      for (a = ensure_array_like(Object.entries(t5[0])), n2 = 0; n2 < a.length; n2 += 1) {
        const i2 = get_each_context$t(t5, a, n2);
        r2[n2] ? r2[n2].p(i2, e2) : (r2[n2] = create_each_block$t(i2), r2[n2].c(), r2[n2].m(o2, null));
      }
      for (; n2 < r2.length; n2 += 1) r2[n2].d(1);
      r2.length = a.length;
    }
  }, i(t5) {
    i || (transition_in(e.$$.fragment, t5), i = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), i = false;
  }, d(t5) {
    t5 && (detach(n), detach(o2)), destroy_component(e, t5), destroy_each(r2, t5);
  } };
}
function instance$24(t4, e, n) {
  const o2 = CONFIG.DND5E;
  let { senses: i } = e;
  return t4.$$set = (t5) => {
    "senses" in t5 && n(0, i = t5.senses);
  }, [i, o2];
}
class Senses extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$24, create_fragment$25, safe_not_equal, { senses: 0 });
  }
}
function create_if_block$1j(t4) {
  let e, n;
  return { c() {
    e = element("i"), attr(e, "class", n = null_to_empty(t4[0]) + " svelte-mobile-companion-dnd5e-81nkluj30u9vsd-ch0zz6");
  }, m(t5, n2) {
    insert(t5, e, n2);
  }, p(t5, o2) {
    1 & o2 && n !== (n = null_to_empty(t5[0]) + " svelte-mobile-companion-dnd5e-81nkluj30u9vsd-ch0zz6") && attr(e, "class", n);
  }, d(t5) {
    t5 && detach(e);
  } };
}
function create_fragment$24(t4) {
  let e, n = t4[0] && create_if_block$1j(t4);
  return { c() {
    n && n.c(), e = empty();
  }, m(t5, o2) {
    n && n.m(t5, o2), insert(t5, e, o2);
  }, p(t5, [o2]) {
    t5[0] ? n ? n.p(t5, o2) : (n = create_if_block$1j(t5), n.c(), n.m(e.parentNode, e)) : n && (n.d(1), n = null);
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e), n && n.d(t5);
  } };
}
function instance$23(t4, e, n) {
  let { iconClass: o2 } = e;
  return t4.$$set = (t5) => {
    "iconClass" in t5 && n(0, o2 = t5.iconClass);
  }, [o2];
}
class BypassIcon extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$23, create_fragment$24, safe_not_equal, { iconClass: 0 });
  }
}
function get_each_context$s(t4, e, n) {
  const o2 = t4.slice();
  return o2[13] = e[n], o2;
}
function create_if_block_1$D(t4) {
  let e, n, o2, i, a = t4[4] && create_if_block_4$7(), r2 = t4[5] && create_if_block_3$b(), s2 = t4[6] && create_if_block_2$j();
  return { c() {
    a && a.c(), e = space(), r2 && r2.c(), n = space(), s2 && s2.c(), o2 = empty();
  }, m(t5, c) {
    a && a.m(t5, c), insert(t5, e, c), r2 && r2.m(t5, c), insert(t5, n, c), s2 && s2.m(t5, c), insert(t5, o2, c), i = true;
  }, p: noop$3, i(t5) {
    i || (transition_in(a), transition_in(r2), transition_in(s2), i = true);
  }, o(t5) {
    transition_out(a), transition_out(r2), transition_out(s2), i = false;
  }, d(t5) {
    t5 && (detach(e), detach(n), detach(o2)), a && a.d(t5), r2 && r2.d(t5), s2 && s2.d(t5);
  } };
}
function create_if_block_4$7(t4) {
  let e, n;
  return e = new BypassIcon({ props: { iconClass: "mgc" } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_if_block_3$b(t4) {
  let e, n;
  return e = new BypassIcon({ props: { iconClass: "sil" } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_if_block_2$j(t4) {
  let e, n;
  return e = new BypassIcon({ props: { iconClass: "ada" } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_each_block$s(t4) {
  let e, n, o2, i, a, r2 = t4[7]() && t4[8](t4[13]), s2 = t4[13] + "", c = r2 && create_if_block_1$D(t4);
  return { c() {
    e = element("li"), c && c.c(), n = space(), o2 = text(s2), attr(e, "class", i = "mc-trait-pill " + t4[3]);
  }, m(t5, i2) {
    insert(t5, e, i2), c && c.m(e, null), append(e, n), append(e, o2), a = true;
  }, p(t5, l) {
    1 & l && (r2 = t5[7]() && t5[8](t5[13])), r2 ? c ? (c.p(t5, l), 1 & l && transition_in(c, 1)) : (c = create_if_block_1$D(t5), c.c(), transition_in(c, 1), c.m(e, n)) : c && (group_outros(), transition_out(c, 1, 1, () => {
      c = null;
    }), check_outros()), (!a || 1 & l) && s2 !== (s2 = t5[13] + "") && set_data(o2, s2), (!a || 8 & l && i !== (i = "mc-trait-pill " + t5[3])) && attr(e, "class", i);
  }, i(t5) {
    a || (transition_in(c), a = true);
  }, o(t5) {
    transition_out(c), a = false;
  }, d(t5) {
    t5 && detach(e), c && c.d();
  } };
}
function create_if_block$1i(t4) {
  let e, n, o2, i = t4[0].custom + "";
  return { c() {
    e = element("li"), n = text(i), attr(e, "class", o2 = "mc-trait-pill " + t4[3]);
  }, m(t5, o3) {
    insert(t5, e, o3), append(e, n);
  }, p(t5, a) {
    1 & a && i !== (i = t5[0].custom + "") && set_data(n, i), 8 & a && o2 !== (o2 = "mc-trait-pill " + t5[3]) && attr(e, "class", o2);
  }, d(t5) {
    t5 && detach(e);
  } };
}
function create_fragment$23(t4) {
  let e, n, o2, i, a;
  e = new TraitHeader({ props: { title: t4[1], icon: t4[2] } });
  let r2 = ensure_array_like(t4[0].value), s2 = [];
  for (let e2 = 0; e2 < r2.length; e2 += 1) s2[e2] = create_each_block$s(get_each_context$s(t4, r2, e2));
  const c = (t5) => transition_out(s2[t5], 1, 1, () => {
    s2[t5] = null;
  });
  let l = t4[0].custom && create_if_block$1i(t4);
  return { c() {
    create_component(e.$$.fragment), n = space(), o2 = element("ul");
    for (let t5 = 0; t5 < s2.length; t5 += 1) s2[t5].c();
    i = space(), l && l.c(), attr(o2, "class", "mc-trait-pills");
  }, m(t5, r3) {
    mount_component(e, t5, r3), insert(t5, n, r3), insert(t5, o2, r3);
    for (let t6 = 0; t6 < s2.length; t6 += 1) s2[t6] && s2[t6].m(o2, null);
    append(o2, i), l && l.m(o2, null), a = true;
  }, p(t5, [n2]) {
    const a2 = {};
    if (2 & n2 && (a2.title = t5[1]), 4 & n2 && (a2.icon = t5[2]), e.$set(a2), 505 & n2) {
      let e2;
      for (r2 = ensure_array_like(t5[0].value), e2 = 0; e2 < r2.length; e2 += 1) {
        const a3 = get_each_context$s(t5, r2, e2);
        s2[e2] ? (s2[e2].p(a3, n2), transition_in(s2[e2], 1)) : (s2[e2] = create_each_block$s(a3), s2[e2].c(), transition_in(s2[e2], 1), s2[e2].m(o2, i));
      }
      for (group_outros(), e2 = r2.length; e2 < s2.length; e2 += 1) c(e2);
      check_outros();
    }
    t5[0].custom ? l ? l.p(t5, n2) : (l = create_if_block$1i(t5), l.c(), l.m(o2, null)) : l && (l.d(1), l = null);
  }, i(t5) {
    if (!a) {
      transition_in(e.$$.fragment, t5);
      for (let t6 = 0; t6 < r2.length; t6 += 1) transition_in(s2[t6]);
      a = true;
    }
  }, o(t5) {
    transition_out(e.$$.fragment, t5), s2 = s2.filter(Boolean);
    for (let t6 = 0; t6 < s2.length; t6 += 1) transition_out(s2[t6]);
    a = false;
  }, d(t5) {
    t5 && (detach(n), detach(o2)), destroy_component(e, t5), destroy_each(s2, t5), l && l.d();
  } };
}
function instance$22(t4, e, n) {
  var o2, i, a;
  let { trait: r2 } = e, { title: s2 } = e, { icon: c } = e, { color: l = "" } = e;
  const u = null === (o2 = r2.bypasses) || void 0 === o2 ? void 0 : o2.has("mgc"), p2 = null === (i = r2.bypasses) || void 0 === i ? void 0 : i.has("sil"), d = null === (a = r2.bypasses) || void 0 === a ? void 0 : a.has("ada"), m = ["bludgeoning", "piercing", "slashing"];
  return t4.$$set = (t5) => {
    "trait" in t5 && n(0, r2 = t5.trait), "title" in t5 && n(1, s2 = t5.title), "icon" in t5 && n(2, c = t5.icon), "color" in t5 && n(3, l = t5.color);
  }, [r2, s2, c, l, u, p2, d, function() {
    return u || p2 || d;
  }, function(t5) {
    return m.includes(t5);
  }];
}
class TraitWithByPassComponent extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$22, create_fragment$23, safe_not_equal, { trait: 0, title: 1, icon: 2, color: 3 });
  }
}
function get_each_context$r(t4, e, n) {
  const o2 = t4.slice();
  return o2[4] = e[n], o2;
}
function create_each_block$r(t4) {
  let e, n, o2, i = t4[4] + "";
  return { c() {
    e = element("li"), n = text(i), attr(e, "class", o2 = "mc-trait-pill " + t4[3]);
  }, m(t5, o3) {
    insert(t5, e, o3), append(e, n);
  }, p(t5, a) {
    1 & a && i !== (i = t5[4] + "") && set_data(n, i), 8 & a && o2 !== (o2 = "mc-trait-pill " + t5[3]) && attr(e, "class", o2);
  }, d(t5) {
    t5 && detach(e);
  } };
}
function create_if_block$1h(t4) {
  let e, n, o2, i = t4[0].custom + "";
  return { c() {
    e = element("li"), n = text(i), attr(e, "class", o2 = "mc-trait-pill " + t4[3]);
  }, m(t5, o3) {
    insert(t5, e, o3), append(e, n);
  }, p(t5, a) {
    1 & a && i !== (i = t5[0].custom + "") && set_data(n, i), 8 & a && o2 !== (o2 = "mc-trait-pill " + t5[3]) && attr(e, "class", o2);
  }, d(t5) {
    t5 && detach(e);
  } };
}
function create_fragment$22(t4) {
  let e, n, o2, i, a;
  e = new TraitHeader({ props: { title: t4[1], icon: t4[2] } });
  let r2 = ensure_array_like(t4[0].value), s2 = [];
  for (let e2 = 0; e2 < r2.length; e2 += 1) s2[e2] = create_each_block$r(get_each_context$r(t4, r2, e2));
  let c = t4[0].custom && create_if_block$1h(t4);
  return { c() {
    create_component(e.$$.fragment), n = space(), o2 = element("ul");
    for (let t5 = 0; t5 < s2.length; t5 += 1) s2[t5].c();
    i = space(), c && c.c(), attr(o2, "class", "mc-trait-pills");
  }, m(t5, r3) {
    mount_component(e, t5, r3), insert(t5, n, r3), insert(t5, o2, r3);
    for (let t6 = 0; t6 < s2.length; t6 += 1) s2[t6] && s2[t6].m(o2, null);
    append(o2, i), c && c.m(o2, null), a = true;
  }, p(t5, [n2]) {
    const a2 = {};
    if (2 & n2 && (a2.title = t5[1]), 4 & n2 && (a2.icon = t5[2]), e.$set(a2), 9 & n2) {
      let e2;
      for (r2 = ensure_array_like(t5[0].value), e2 = 0; e2 < r2.length; e2 += 1) {
        const a3 = get_each_context$r(t5, r2, e2);
        s2[e2] ? s2[e2].p(a3, n2) : (s2[e2] = create_each_block$r(a3), s2[e2].c(), s2[e2].m(o2, i));
      }
      for (; e2 < s2.length; e2 += 1) s2[e2].d(1);
      s2.length = r2.length;
    }
    t5[0].custom ? c ? c.p(t5, n2) : (c = create_if_block$1h(t5), c.c(), c.m(o2, null)) : c && (c.d(1), c = null);
  }, i(t5) {
    a || (transition_in(e.$$.fragment, t5), a = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), a = false;
  }, d(t5) {
    t5 && (detach(n), detach(o2)), destroy_component(e, t5), destroy_each(s2, t5), c && c.d();
  } };
}
function instance$21(t4, e, n) {
  let { trait: o2 } = e, { title: i } = e, { icon: a } = e, { color: r2 } = e;
  return t4.$$set = (t5) => {
    "trait" in t5 && n(0, o2 = t5.trait), "title" in t5 && n(1, i = t5.title), "icon" in t5 && n(2, a = t5.icon), "color" in t5 && n(3, r2 = t5.color);
  }, [o2, i, a, r2];
}
class Trait extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$21, create_fragment$22, safe_not_equal, { trait: 0, title: 1, icon: 2, color: 3 });
  }
}
function get_each_context$q(t4, e, n) {
  const o2 = t4.slice();
  return o2[3] = e[n][0], o2[4] = e[n][1], o2;
}
function create_each_block$q(t4) {
  let e, n, o2, i, a, r2 = t4[3] + "", s2 = t4[4] + "";
  return { c() {
    e = element("li"), n = text(r2), o2 = space(), i = text(s2), a = space(), attr(e, "class", "mc-trait-pill red");
  }, m(t5, r3) {
    insert(t5, e, r3), append(e, n), append(e, o2), append(e, i), append(e, a);
  }, p(t5, e2) {
    1 & e2 && r2 !== (r2 = t5[3] + "") && set_data(n, r2), 1 & e2 && s2 !== (s2 = t5[4] + "") && set_data(i, s2);
  }, d(t5) {
    t5 && detach(e);
  } };
}
function create_fragment$21(t4) {
  let e, n, o2, i;
  e = new TraitHeader({ props: { title: t4[1], icon: t4[2] } });
  let a = ensure_array_like(Object.entries(t4[0].amount)), r2 = [];
  for (let e2 = 0; e2 < a.length; e2 += 1) r2[e2] = create_each_block$q(get_each_context$q(t4, a, e2));
  return { c() {
    create_component(e.$$.fragment), n = space(), o2 = element("ul");
    for (let t5 = 0; t5 < r2.length; t5 += 1) r2[t5].c();
    attr(o2, "class", "mc-trait-pills");
  }, m(t5, a2) {
    mount_component(e, t5, a2), insert(t5, n, a2), insert(t5, o2, a2);
    for (let t6 = 0; t6 < r2.length; t6 += 1) r2[t6] && r2[t6].m(o2, null);
    i = true;
  }, p(t5, [n2]) {
    const i2 = {};
    if (2 & n2 && (i2.title = t5[1]), 4 & n2 && (i2.icon = t5[2]), e.$set(i2), 1 & n2) {
      let e2;
      for (a = ensure_array_like(Object.entries(t5[0].amount)), e2 = 0; e2 < a.length; e2 += 1) {
        const i3 = get_each_context$q(t5, a, e2);
        r2[e2] ? r2[e2].p(i3, n2) : (r2[e2] = create_each_block$q(i3), r2[e2].c(), r2[e2].m(o2, null));
      }
      for (; e2 < r2.length; e2 += 1) r2[e2].d(1);
      r2.length = a.length;
    }
  }, i(t5) {
    i || (transition_in(e.$$.fragment, t5), i = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), i = false;
  }, d(t5) {
    t5 && (detach(n), detach(o2)), destroy_component(e, t5), destroy_each(r2, t5);
  } };
}
function instance$20(t4, e, n) {
  let { trait: o2 } = e, { title: i } = e, { icon: a } = e;
  return t4.$$set = (t5) => {
    "trait" in t5 && n(0, o2 = t5.trait), "title" in t5 && n(1, i = t5.title), "icon" in t5 && n(2, a = t5.icon);
  }, [o2, i, a];
}
class TraitDamageModification extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$20, create_fragment$21, safe_not_equal, { trait: 0, title: 1, icon: 2 });
  }
}
function create_fragment$20(t4) {
  let e, n;
  return e = new Trait({ props: { trait: t4[0], title: i18n("DND5E.Armor"), icon: "/systems/dnd5e/icons/svg/checked-shield.svg" } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p: noop$3, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function instance$1$(t4, e, n) {
  let { trait: o2 } = e;
  const i = o2.value.map((t5) => {
    var e2;
    return null !== (e2 = CONFIG.DND5E.armorProficiencies[t5]) && void 0 !== e2 ? e2 : t5;
  }), a = Object.assign(Object.assign({}, o2), { value: i });
  return t4.$$set = (t5) => {
    "trait" in t5 && n(1, o2 = t5.trait);
  }, [a, o2];
}
class ArmorProficiencies extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1$, create_fragment$20, safe_not_equal, { trait: 1 });
  }
}
function get_each_context$p(t4, e, n) {
  const o2 = t4.slice();
  return o2[5] = e[n], o2;
}
function create_if_block_1$C(t4) {
  let e;
  return { c() {
    e = element("i"), attr(e, "class", "mastery svelte-mobile-companion-dnd5e-81nkluj30u9vsd-hhaal"), attr(e, "data-tooltip", "Weapon Mastery"), attr(e, "aria-label", "Weapon Mastery");
  }, m(t5, n) {
    insert(t5, e, n);
  }, d(t5) {
    t5 && detach(e);
  } };
}
function create_each_block$p(t4) {
  let e, n, o2, i = t4[2](t4[5]), a = t4[5] + "", r2 = i && create_if_block_1$C();
  return { c() {
    e = element("li"), r2 && r2.c(), n = space(), o2 = text(a), attr(e, "class", "mc-trait-pill");
  }, m(t5, i2) {
    insert(t5, e, i2), r2 && r2.m(e, null), append(e, n), append(e, o2);
  }, p: noop$3, d(t5) {
    t5 && detach(e), r2 && r2.d();
  } };
}
function create_if_block$1g(t4) {
  let e, n, o2 = t4[0].custom + "";
  return { c() {
    e = element("li"), n = text(o2), attr(e, "class", "mc-trait-pill");
  }, m(t5, o3) {
    insert(t5, e, o3), append(e, n);
  }, p(t5, e2) {
    1 & e2 && o2 !== (o2 = t5[0].custom + "") && set_data(n, o2);
  }, d(t5) {
    t5 && detach(e);
  } };
}
function create_fragment$1$(t4) {
  let e, n, o2, i, a;
  e = new TraitHeader({ props: { title: i18n("TYPES.Item.weaponPl"), icon: "/systems/dnd5e/icons/svg/trait-weapon-proficiencies.svg" } });
  let r2 = ensure_array_like(t4[1].value), s2 = [];
  for (let e2 = 0; e2 < r2.length; e2 += 1) s2[e2] = create_each_block$p(get_each_context$p(t4, r2, e2));
  let c = t4[1].custom && create_if_block$1g(t4);
  return { c() {
    create_component(e.$$.fragment), n = space(), o2 = element("ul");
    for (let t5 = 0; t5 < s2.length; t5 += 1) s2[t5].c();
    i = space(), c && c.c(), attr(o2, "class", "mc-trait-pills");
  }, m(t5, r3) {
    mount_component(e, t5, r3), insert(t5, n, r3), insert(t5, o2, r3);
    for (let t6 = 0; t6 < s2.length; t6 += 1) s2[t6] && s2[t6].m(o2, null);
    append(o2, i), c && c.m(o2, null), a = true;
  }, p(t5, [e2]) {
    if (6 & e2) {
      let n2;
      for (r2 = ensure_array_like(t5[1].value), n2 = 0; n2 < r2.length; n2 += 1) {
        const a2 = get_each_context$p(t5, r2, n2);
        s2[n2] ? s2[n2].p(a2, e2) : (s2[n2] = create_each_block$p(a2), s2[n2].c(), s2[n2].m(o2, i));
      }
      for (; n2 < s2.length; n2 += 1) s2[n2].d(1);
      s2.length = r2.length;
    }
    t5[1].custom && c.p(t5, e2);
  }, i(t5) {
    a || (transition_in(e.$$.fragment, t5), a = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), a = false;
  }, d(t5) {
    t5 && (detach(n), detach(o2)), destroy_component(e, t5), destroy_each(s2, t5), c && c.d();
  } };
}
function instance$1_(t4, e, n) {
  let { trait: o2 } = e;
  const i = o2.mastery.value.map((t5) => {
    var e2, n2;
    return null !== (n2 = null !== (e2 = CONFIG.DND5E.weaponProficiencies[t5]) && void 0 !== e2 ? e2 : CONFIG.DND5E.weaponTypes[t5]) && void 0 !== n2 ? n2 : t5;
  }), a = o2.value.map((t5) => {
    var e2, n2;
    return null !== (n2 = null !== (e2 = CONFIG.DND5E.weaponProficiencies[t5]) && void 0 !== e2 ? e2 : CONFIG.DND5E.weaponTypes[t5]) && void 0 !== n2 ? n2 : t5;
  }), r2 = Object.assign(Object.assign({}, o2), { mastery: Object.assign(Object.assign({}, o2.mastery), { value: i }), value: a });
  return t4.$$set = (t5) => {
    "trait" in t5 && n(0, o2 = t5.trait);
  }, [o2, r2, function(t5) {
    var e2, n2;
    return null === (n2 = null === (e2 = r2.mastery) || void 0 === e2 ? void 0 : e2.value) || void 0 === n2 ? void 0 : n2.has(t5);
  }];
}
class WeaponProficiencies extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1_, create_fragment$1$, safe_not_equal, { trait: 0 });
  }
}
function get_each_context$o(t4, e, n) {
  const o2 = t4.slice();
  return o2[3] = e[n][0], o2[4] = e[n][1], o2;
}
function create_if_block$1f(t4) {
  let e, n, o2, i, a, r2, s2, c, l, u, p2, d = t4[1](t4[3]) + "", m = t4[4] + "", f = t4[0].units + "";
  return { c() {
    e = element("li"), n = element("span"), o2 = text(d), i = space(), a = element("span"), a.textContent = "|", r2 = space(), s2 = element("span"), c = text(m), l = space(), u = text(f), p2 = space(), attr(n, "class", "label"), attr(a, "class", "separator"), attr(s2, "class", "value"), attr(e, "class", "mc-trait-pill");
  }, m(t5, d2) {
    insert(t5, e, d2), append(e, n), append(n, o2), append(e, i), append(e, a), append(e, r2), append(e, s2), append(s2, c), append(s2, l), append(s2, u), append(e, p2);
  }, p(t5, e2) {
    1 & e2 && d !== (d = t5[1](t5[3]) + "") && set_data(o2, d), 1 & e2 && m !== (m = t5[4] + "") && set_data(c, m), 1 & e2 && f !== (f = t5[0].units + "") && set_data(u, f);
  }, d(t5) {
    t5 && detach(e);
  } };
}
function create_each_block$o(t4) {
  let e, n = "units" !== t4[3] && "hover" !== t4[3] && t4[4] > 0 && create_if_block$1f(t4);
  return { c() {
    n && n.c(), e = empty();
  }, m(t5, o2) {
    n && n.m(t5, o2), insert(t5, e, o2);
  }, p(t5, o2) {
    "units" !== t5[3] && "hover" !== t5[3] && t5[4] > 0 ? n ? n.p(t5, o2) : (n = create_if_block$1f(t5), n.c(), n.m(e.parentNode, e)) : n && (n.d(1), n = null);
  }, d(t5) {
    t5 && detach(e), n && n.d(t5);
  } };
}
function create_fragment$1_(t4) {
  let e, n, o2, i;
  e = new TraitHeader({ props: { title: i18n("DND5E.Movement"), icon: "fas fa-person-running" } });
  let a = ensure_array_like(Object.entries(t4[0])), r2 = [];
  for (let e2 = 0; e2 < a.length; e2 += 1) r2[e2] = create_each_block$o(get_each_context$o(t4, a, e2));
  return { c() {
    create_component(e.$$.fragment), n = space(), o2 = element("ul");
    for (let t5 = 0; t5 < r2.length; t5 += 1) r2[t5].c();
    attr(o2, "class", "mc-trait-pills");
  }, m(t5, a2) {
    mount_component(e, t5, a2), insert(t5, n, a2), insert(t5, o2, a2);
    for (let t6 = 0; t6 < r2.length; t6 += 1) r2[t6] && r2[t6].m(o2, null);
    i = true;
  }, p(t5, [e2]) {
    if (3 & e2) {
      let n2;
      for (a = ensure_array_like(Object.entries(t5[0])), n2 = 0; n2 < a.length; n2 += 1) {
        const i2 = get_each_context$o(t5, a, n2);
        r2[n2] ? r2[n2].p(i2, e2) : (r2[n2] = create_each_block$o(i2), r2[n2].c(), r2[n2].m(o2, null));
      }
      for (; n2 < r2.length; n2 += 1) r2[n2].d(1);
      r2.length = a.length;
    }
  }, i(t5) {
    i || (transition_in(e.$$.fragment, t5), i = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), i = false;
  }, d(t5) {
    t5 && (detach(n), detach(o2)), destroy_component(e, t5), destroy_each(r2, t5);
  } };
}
function instance$1Z(t4, e, n) {
  const o2 = CONFIG.DND5E;
  let { movement: i } = e;
  return t4.$$set = (t5) => {
    "movement" in t5 && n(0, i = t5.movement);
  }, [i, function(t5) {
    return "fly" === t5 && i.hover ? o2.movementTypes[t5] + " (" + i18n("DND5E.MovementHover") + ")" : o2.movementTypes[t5];
  }];
}
class Movement extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1Z, create_fragment$1_, safe_not_equal, { movement: 0 });
  }
}
function create_if_block_9(t4) {
  let e, n, o2;
  return n = new Movement({ props: { movement: t4[0] } }), { c() {
    e = element("div"), create_component(n.$$.fragment);
  }, m(t5, i) {
    insert(t5, e, i), mount_component(n, e, null), o2 = true;
  }, p(t5, e2) {
    const o3 = {};
    1 & e2 && (o3.movement = t5[0]), n.$set(o3);
  }, i(t5) {
    o2 || (transition_in(n.$$.fragment, t5), o2 = true);
  }, o(t5) {
    transition_out(n.$$.fragment, t5), o2 = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(n);
  } };
}
function create_if_block_8$1(t4) {
  let e, n, o2;
  return n = new Senses({ props: { senses: t4[1] } }), { c() {
    e = element("div"), create_component(n.$$.fragment);
  }, m(t5, i) {
    insert(t5, e, i), mount_component(n, e, null), o2 = true;
  }, p(t5, e2) {
    const o3 = {};
    2 & e2 && (o3.senses = t5[1]), n.$set(o3);
  }, i(t5) {
    o2 || (transition_in(n.$$.fragment, t5), o2 = true);
  }, o(t5) {
    transition_out(n.$$.fragment, t5), o2 = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(n);
  } };
}
function create_if_block_7$2(t4) {
  let e, n, o2;
  return n = new TraitWithByPassComponent({ props: { trait: t4[2].dr, title: i18n("DND5E.Resistances"), icon: "fas fa-shield-halved", color: "green" } }), { c() {
    e = element("div"), create_component(n.$$.fragment);
  }, m(t5, i) {
    insert(t5, e, i), mount_component(n, e, null), o2 = true;
  }, p(t5, e2) {
    const o3 = {};
    4 & e2 && (o3.trait = t5[2].dr), n.$set(o3);
  }, i(t5) {
    o2 || (transition_in(n.$$.fragment, t5), o2 = true);
  }, o(t5) {
    transition_out(n.$$.fragment, t5), o2 = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(n);
  } };
}
function create_if_block_6$3(t4) {
  let e, n, o2;
  return n = new TraitWithByPassComponent({ props: { trait: t4[2].di, title: i18n("DND5E.Immunities"), icon: "fas fa-shield", color: "green" } }), { c() {
    e = element("div"), create_component(n.$$.fragment);
  }, m(t5, i) {
    insert(t5, e, i), mount_component(n, e, null), o2 = true;
  }, p(t5, e2) {
    const o3 = {};
    4 & e2 && (o3.trait = t5[2].di), n.$set(o3);
  }, i(t5) {
    o2 || (transition_in(n.$$.fragment, t5), o2 = true);
  }, o(t5) {
    transition_out(n.$$.fragment, t5), o2 = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(n);
  } };
}
function create_if_block_5$4(t4) {
  let e, n, o2;
  return n = new Trait({ props: { trait: t4[2].ci, title: i18n("DND5E.ConImm"), icon: "/systems/dnd5e/icons/svg/rosa-shield.svg", color: "green" } }), { c() {
    e = element("div"), create_component(n.$$.fragment);
  }, m(t5, i) {
    insert(t5, e, i), mount_component(n, e, null), o2 = true;
  }, p(t5, e2) {
    const o3 = {};
    4 & e2 && (o3.trait = t5[2].ci), n.$set(o3);
  }, i(t5) {
    o2 || (transition_in(n.$$.fragment, t5), o2 = true);
  }, o(t5) {
    transition_out(n.$$.fragment, t5), o2 = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(n);
  } };
}
function create_if_block_4$6(t4) {
  let e, n, o2;
  return n = new TraitWithByPassComponent({ props: { trait: t4[2].dv, title: i18n("DND5E.Vulnerabilities"), icon: "fas fa-heart-crack", color: "red" } }), { c() {
    e = element("div"), create_component(n.$$.fragment);
  }, m(t5, i) {
    insert(t5, e, i), mount_component(n, e, null), o2 = true;
  }, p(t5, e2) {
    const o3 = {};
    4 & e2 && (o3.trait = t5[2].dv), n.$set(o3);
  }, i(t5) {
    o2 || (transition_in(n.$$.fragment, t5), o2 = true);
  }, o(t5) {
    transition_out(n.$$.fragment, t5), o2 = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(n);
  } };
}
function create_if_block_3$a(t4) {
  let e, n, o2;
  return n = new TraitDamageModification({ props: { trait: t4[2].dm, title: i18n("DND5E.DamMod"), icon: "fas fa-heart-circle-plus" } }), { c() {
    e = element("div"), create_component(n.$$.fragment);
  }, m(t5, i) {
    insert(t5, e, i), mount_component(n, e, null), o2 = true;
  }, p(t5, e2) {
    const o3 = {};
    4 & e2 && (o3.trait = t5[2].dm), n.$set(o3);
  }, i(t5) {
    o2 || (transition_in(n.$$.fragment, t5), o2 = true);
  }, o(t5) {
    transition_out(n.$$.fragment, t5), o2 = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(n);
  } };
}
function create_if_block_2$i(t4) {
  let e, n, o2;
  return n = new ArmorProficiencies({ props: { trait: t4[2].armorProf } }), { c() {
    e = element("div"), create_component(n.$$.fragment);
  }, m(t5, i) {
    insert(t5, e, i), mount_component(n, e, null), o2 = true;
  }, p(t5, e2) {
    const o3 = {};
    4 & e2 && (o3.trait = t5[2].armorProf), n.$set(o3);
  }, i(t5) {
    o2 || (transition_in(n.$$.fragment, t5), o2 = true);
  }, o(t5) {
    transition_out(n.$$.fragment, t5), o2 = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(n);
  } };
}
function create_if_block_1$B(t4) {
  let e, n, o2;
  return n = new WeaponProficiencies({ props: { trait: t4[2].weaponProf } }), { c() {
    e = element("div"), create_component(n.$$.fragment);
  }, m(t5, i) {
    insert(t5, e, i), mount_component(n, e, null), o2 = true;
  }, p(t5, e2) {
    const o3 = {};
    4 & e2 && (o3.trait = t5[2].weaponProf), n.$set(o3);
  }, i(t5) {
    o2 || (transition_in(n.$$.fragment, t5), o2 = true);
  }, o(t5) {
    transition_out(n.$$.fragment, t5), o2 = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(n);
  } };
}
function create_if_block$1e(t4) {
  let e, n, o2;
  return n = new Trait({ props: { trait: t4[2].languages, title: i18n("DND5E.Languages"), icon: "fas fa-flag" } }), { c() {
    e = element("div"), create_component(n.$$.fragment);
  }, m(t5, i) {
    insert(t5, e, i), mount_component(n, e, null), o2 = true;
  }, p(t5, e2) {
    const o3 = {};
    4 & e2 && (o3.trait = t5[2].languages), n.$set(o3);
  }, i(t5) {
    o2 || (transition_in(n.$$.fragment, t5), o2 = true);
  }, o(t5) {
    transition_out(n.$$.fragment, t5), o2 = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(n);
  } };
}
function create_fragment$1Z(t4) {
  let e, n, o2, i, a, r2, s2, c, l, u, p2, d, m = t4[0] && create_if_block_9(t4), f = t4[1] && create_if_block_8$1(t4), _ = t4[2].dr && create_if_block_7$2(t4), h = t4[2].di && create_if_block_6$3(t4), g2 = t4[2].ci && create_if_block_5$4(t4), $2 = t4[2].dv && create_if_block_4$6(t4), b = t4[2].dm && create_if_block_3$a(t4), y = t4[2].armorProf && create_if_block_2$i(t4), v = t4[2].weaponProf && create_if_block_1$B(t4), k = t4[2].languages && create_if_block$1e(t4);
  return { c() {
    e = element("section"), n = element("section"), m && m.c(), o2 = space(), f && f.c(), i = space(), _ && _.c(), a = space(), h && h.c(), r2 = space(), g2 && g2.c(), s2 = space(), $2 && $2.c(), c = space(), b && b.c(), l = space(), y && y.c(), u = space(), v && v.c(), p2 = space(), k && k.c(), attr(n, "class", "traits content-scroll-list svelte-mobile-companion-dnd5e-81nkluj30u9vsd-17qyddn"), attr(e, "class", "category-content");
  }, m(t5, w2) {
    insert(t5, e, w2), append(e, n), m && m.m(n, null), append(n, o2), f && f.m(n, null), append(n, i), _ && _.m(n, null), append(n, a), h && h.m(n, null), append(n, r2), g2 && g2.m(n, null), append(n, s2), $2 && $2.m(n, null), append(n, c), b && b.m(n, null), append(n, l), y && y.m(n, null), append(n, u), v && v.m(n, null), append(n, p2), k && k.m(n, null), d = true;
  }, p(t5, [e2]) {
    t5[0] ? m ? (m.p(t5, e2), 1 & e2 && transition_in(m, 1)) : (m = create_if_block_9(t5), m.c(), transition_in(m, 1), m.m(n, o2)) : m && (group_outros(), transition_out(m, 1, 1, () => {
      m = null;
    }), check_outros()), t5[1] ? f ? (f.p(t5, e2), 2 & e2 && transition_in(f, 1)) : (f = create_if_block_8$1(t5), f.c(), transition_in(f, 1), f.m(n, i)) : f && (group_outros(), transition_out(f, 1, 1, () => {
      f = null;
    }), check_outros()), t5[2].dr ? _ ? (_.p(t5, e2), 4 & e2 && transition_in(_, 1)) : (_ = create_if_block_7$2(t5), _.c(), transition_in(_, 1), _.m(n, a)) : _ && (group_outros(), transition_out(_, 1, 1, () => {
      _ = null;
    }), check_outros()), t5[2].di ? h ? (h.p(t5, e2), 4 & e2 && transition_in(h, 1)) : (h = create_if_block_6$3(t5), h.c(), transition_in(h, 1), h.m(n, r2)) : h && (group_outros(), transition_out(h, 1, 1, () => {
      h = null;
    }), check_outros()), t5[2].ci ? g2 ? (g2.p(t5, e2), 4 & e2 && transition_in(g2, 1)) : (g2 = create_if_block_5$4(t5), g2.c(), transition_in(g2, 1), g2.m(n, s2)) : g2 && (group_outros(), transition_out(g2, 1, 1, () => {
      g2 = null;
    }), check_outros()), t5[2].dv ? $2 ? ($2.p(t5, e2), 4 & e2 && transition_in($2, 1)) : ($2 = create_if_block_4$6(t5), $2.c(), transition_in($2, 1), $2.m(n, c)) : $2 && (group_outros(), transition_out($2, 1, 1, () => {
      $2 = null;
    }), check_outros()), t5[2].dm ? b ? (b.p(t5, e2), 4 & e2 && transition_in(b, 1)) : (b = create_if_block_3$a(t5), b.c(), transition_in(b, 1), b.m(n, l)) : b && (group_outros(), transition_out(b, 1, 1, () => {
      b = null;
    }), check_outros()), t5[2].armorProf ? y ? (y.p(t5, e2), 4 & e2 && transition_in(y, 1)) : (y = create_if_block_2$i(t5), y.c(), transition_in(y, 1), y.m(n, u)) : y && (group_outros(), transition_out(y, 1, 1, () => {
      y = null;
    }), check_outros()), t5[2].weaponProf ? v ? (v.p(t5, e2), 4 & e2 && transition_in(v, 1)) : (v = create_if_block_1$B(t5), v.c(), transition_in(v, 1), v.m(n, p2)) : v && (group_outros(), transition_out(v, 1, 1, () => {
      v = null;
    }), check_outros()), t5[2].languages ? k ? (k.p(t5, e2), 4 & e2 && transition_in(k, 1)) : (k = create_if_block$1e(t5), k.c(), transition_in(k, 1), k.m(n, null)) : k && (group_outros(), transition_out(k, 1, 1, () => {
      k = null;
    }), check_outros());
  }, i(t5) {
    d || (transition_in(m), transition_in(f), transition_in(_), transition_in(h), transition_in(g2), transition_in($2), transition_in(b), transition_in(y), transition_in(v), transition_in(k), d = true);
  }, o(t5) {
    transition_out(m), transition_out(f), transition_out(_), transition_out(h), transition_out(g2), transition_out($2), transition_out(b), transition_out(y), transition_out(v), transition_out(k), d = false;
  }, d(t5) {
    t5 && detach(e), m && m.d(), f && f.d(), _ && _.d(), h && h.d(), g2 && g2.d(), $2 && $2.d(), b && b.d(), y && y.d(), v && v.d(), k && k.d();
  } };
}
function instance$1Y(t4, e, n) {
  let o2, i, a, { actor: r2 } = e;
  const s2 = r2.system;
  return t4.$$set = (t5) => {
    "actor" in t5 && n(3, r2 = t5.actor);
  }, n(2, o2 = s2.traits), n(1, i = s2.attributes.senses), n(0, a = s2.attributes.movement), [a, i, o2, r2];
}
class Traits extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1Y, create_fragment$1Z, safe_not_equal, { actor: 3 });
  }
}
function create_if_block$1d(t4) {
  let e, n, o2, i, a = t4[0].max + "";
  return { c() {
    e = element("span"), e.textContent = "/", n = space(), o2 = element("span"), i = text(a), attr(e, "class", "separator svelte-mobile-companion-dnd5e-81nkluj30u9vsd-zdhd3q"), attr(o2, "class", "max svelte-mobile-companion-dnd5e-81nkluj30u9vsd-zdhd3q");
  }, m(t5, a2) {
    insert(t5, e, a2), insert(t5, n, a2), insert(t5, o2, a2), append(o2, i);
  }, p(t5, e2) {
    1 & e2 && a !== (a = t5[0].max + "") && set_data(i, a);
  }, d(t5) {
    t5 && (detach(e), detach(n), detach(o2));
  } };
}
function create_fragment$1Y(t4) {
  let e, n, o2, i, a, r2, s2, c, l, u, p2, d, m, f, _, h, g2 = t4[0].value + "", $2 = t4[0].max && create_if_block$1d(t4);
  return { c() {
    e = element("div"), n = element("div"), o2 = element("div"), i = element("i"), a = space(), r2 = element("span"), s2 = text(g2), c = space(), $2 && $2.c(), l = space(), u = element("i"), p2 = space(), d = element("i"), m = space(), f = element("i"), _ = space(), h = element("i"), attr(i, "class", "fas fa-weight-hanging svelte-mobile-companion-dnd5e-81nkluj30u9vsd-zdhd3q"), attr(r2, "class", "value svelte-mobile-companion-dnd5e-81nkluj30u9vsd-zdhd3q"), attr(o2, "class", "label svelte-mobile-companion-dnd5e-81nkluj30u9vsd-zdhd3q"), attr(u, "class", "breakpoint encumbrance-low arrow-up svelte-mobile-companion-dnd5e-81nkluj30u9vsd-zdhd3q"), attr(d, "class", "breakpoint encumbrance-low arrow-down svelte-mobile-companion-dnd5e-81nkluj30u9vsd-zdhd3q"), attr(f, "class", "breakpoint encumbrance-high arrow-up svelte-mobile-companion-dnd5e-81nkluj30u9vsd-zdhd3q"), attr(h, "class", "breakpoint encumbrance-high arrow-down svelte-mobile-companion-dnd5e-81nkluj30u9vsd-zdhd3q"), attr(n, "class", "meter progress svelte-mobile-companion-dnd5e-81nkluj30u9vsd-zdhd3q"), set_style(n, "--bar-percentage", t4[0].pct + "%"), set_style(n, "--encumbrance-low", t4[0].stops.encumbered + "%"), set_style(n, "--encumbrance-high", t4[0].stops.heavilyEncumbered + "%"), attr(e, "class", "encumbrance svelte-mobile-companion-dnd5e-81nkluj30u9vsd-zdhd3q");
  }, m(t5, g3) {
    insert(t5, e, g3), append(e, n), append(n, o2), append(o2, i), append(o2, a), append(o2, r2), append(r2, s2), append(o2, c), $2 && $2.m(o2, null), append(n, l), append(n, u), append(n, p2), append(n, d), append(n, m), append(n, f), append(n, _), append(n, h);
  }, p(t5, [e2]) {
    1 & e2 && g2 !== (g2 = t5[0].value + "") && set_data(s2, g2), t5[0].max ? $2 ? $2.p(t5, e2) : ($2 = create_if_block$1d(t5), $2.c(), $2.m(o2, null)) : $2 && ($2.d(1), $2 = null), 1 & e2 && set_style(n, "--bar-percentage", t5[0].pct + "%"), 1 & e2 && set_style(n, "--encumbrance-low", t5[0].stops.encumbered + "%"), 1 & e2 && set_style(n, "--encumbrance-high", t5[0].stops.heavilyEncumbered + "%");
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e), $2 && $2.d();
  } };
}
function encumbranceFromContainer(t4) {
  const e = t4.system;
  return { value: e.contentsWeight, max: e.capacity.value, pct: Math.min(e.contentsWeight / e.capacity.value * 100, 100), encumbered: e.contentsWeight > e.capacity.value, stops: { encumbered: 0, heavilyEncumbered: 0 }, mod: 0, thresholds: { encumbered: 0, heavilyEncumbered: 0, maximum: 0 } };
}
function instance$1X(t4, e, n) {
  let o2, i, { actor: a } = e, { selectedContainer: r2 } = e;
  return t4.$$set = (t5) => {
    "actor" in t5 && n(1, a = t5.actor), "selectedContainer" in t5 && n(2, r2 = t5.selectedContainer);
  }, t4.$$.update = () => {
    if (2 & t4.$$.dirty && n(3, o2 = a.system), 8 & t4.$$.dirty && n(0, i = o2.attributes.encumbrance), 14 & t4.$$.dirty) {
      const t5 = a.itemTypes.container.find(({ id: t6 }) => t6 === r2);
      n(0, i = t5 ? encumbranceFromContainer(t5) : o2.attributes.encumbrance);
    }
  }, [i, a, r2, o2];
}
class Encumbrance extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1X, create_fragment$1Y, safe_not_equal, { actor: 1, selectedContainer: 2 });
  }
}
function create_fragment$1X(t4) {
  let e, n, o2, i, a;
  const r2 = t4[5].default, s2 = create_slot(r2, t4, t4[4], null);
  return { c() {
    e = element("button"), s2 && s2.c(), attr(e, "class", n = null_to_empty(`mobile-companion-button ${t4[2]}`) + " svelte-mobile-companion-dnd5e-81nkluj30u9vsd-14hjf38"), attr(e, "type", t4[0]), e.disabled = t4[1];
  }, m(n2, r3) {
    insert(n2, e, r3), s2 && s2.m(e, null), o2 = true, i || (a = listen(e, "click", t4[3]), i = true);
  }, p(t5, [i2]) {
    s2 && s2.p && (!o2 || 16 & i2) && update_slot_base(s2, r2, t5, t5[4], o2 ? get_slot_changes(r2, t5[4], i2, null) : get_all_dirty_from_scope(t5[4]), null), (!o2 || 4 & i2 && n !== (n = null_to_empty(`mobile-companion-button ${t5[2]}`) + " svelte-mobile-companion-dnd5e-81nkluj30u9vsd-14hjf38")) && attr(e, "class", n), (!o2 || 1 & i2) && attr(e, "type", t5[0]), (!o2 || 2 & i2) && (e.disabled = t5[1]);
  }, i(t5) {
    o2 || (transition_in(s2, t5), o2 = true);
  }, o(t5) {
    transition_out(s2, t5), o2 = false;
  }, d(t5) {
    t5 && detach(e), s2 && s2.d(t5), i = false, a();
  } };
}
function instance$1W(t4, e, n) {
  let { $$slots: o2 = {}, $$scope: i } = e, { type: a = "button" } = e, { disabled: r2 = false } = e, { customClass: s2 = "" } = e;
  const c = createEventDispatcher();
  return t4.$$set = (t5) => {
    "type" in t5 && n(0, a = t5.type), "disabled" in t5 && n(1, r2 = t5.disabled), "customClass" in t5 && n(2, s2 = t5.customClass), "$$scope" in t5 && n(4, i = t5.$$scope);
  }, [a, r2, s2, function(t5) {
    c("click", t5);
  }, i, o2];
}
class MCButton extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1W, create_fragment$1X, safe_not_equal, { type: 0, disabled: 1, customClass: 2 });
  }
}
function create_fragment$1W(t4) {
  let e, n, o2;
  return { c() {
    e = element("input"), attr(e, "class", t4[3]), attr(e, "min", t4[4]), attr(e, "max", t4[5]), attr(e, "id", t4[1]), attr(e, "name", t4[2]), attr(e, "inputmode", "text"), attr(e, "pattern", "[0-9+\\-]*");
  }, m(i, a) {
    insert(i, e, a), set_input_value(e, t4[0]), n || (o2 = [listen(e, "change", t4[6]), listen(e, "input", restrictInput), listen(e, "input", t4[7])], n = true);
  }, p(t5, [n2]) {
    8 & n2 && attr(e, "class", t5[3]), 16 & n2 && attr(e, "min", t5[4]), 32 & n2 && attr(e, "max", t5[5]), 2 & n2 && attr(e, "id", t5[1]), 4 & n2 && attr(e, "name", t5[2]), 1 & n2 && e.value !== t5[0] && set_input_value(e, t5[0]);
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e), n = false, run_all(o2);
  } };
}
function restrictInput(t4) {
  const e = t4.target;
  e.value = e.value.replace(/[^0-9+\-]/g, "");
}
function instance$1V($$self, $$props, $$invalidate) {
  let { value = 0 } = $$props, { id = "" } = $$props, { name = "" } = $$props, { styleClass = "" } = $$props, { min } = $$props, { max } = $$props, previousValue = value;
  const dispatch = createEventDispatcher();
  function handleInputChange(event) {
    const target = event.target;
    let newValue = target.value;
    try {
      /^[+\-]/.test(newValue) && (newValue = `${previousValue}${newValue}`);
      let result = Math.floor(eval(newValue));
      void 0 !== max && (result = Math.min(result, max)), void 0 !== min && (result = Math.max(result, min)), previousValue = result, $$invalidate(0, value = result), dispatch("change", { value: result, name });
    } catch (t4) {
    }
  }
  function input_input_handler() {
    value = this.value, $$invalidate(0, value);
  }
  return $$self.$$set = (t4) => {
    "value" in t4 && $$invalidate(0, value = t4.value), "id" in t4 && $$invalidate(1, id = t4.id), "name" in t4 && $$invalidate(2, name = t4.name), "styleClass" in t4 && $$invalidate(3, styleClass = t4.styleClass), "min" in t4 && $$invalidate(4, min = t4.min), "max" in t4 && $$invalidate(5, max = t4.max);
  }, $$self.$$.update = () => {
    1 & $$self.$$.dirty && $$invalidate(0, value);
  }, [value, id, name, styleClass, min, max, handleInputChange, input_input_handler];
}
class EvaluatingInput extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1V, create_fragment$1W, safe_not_equal, { value: 0, id: 1, name: 2, styleClass: 3, min: 4, max: 5 });
  }
}
function enable() {
  const t4 = document.body, e = t4.requestFullscreen || t4.webkitRequestFullscreen || t4.mozRequestFullScreen || t4.msRequestFullscreen;
  if (e) e.call(t4);
  else if (void 0 !== window.ActiveXObject) {
    const t5 = new ActiveXObject("WScript.Shell");
    null !== t5 && t5.SendKeys("{F11}");
  }
}
function disable() {
  const t4 = document, e = t4.exitFullscreen || t4.webkitExitFullscreen || t4.mozCancelFullScreen || t4.msExitFullscreen;
  if (e) e.call(document);
  else if (void 0 !== window.ActiveXObject) {
    const t5 = new ActiveXObject("WScript.Shell");
    null !== t5 && t5.SendKeys("{F11}");
  }
}
function toggleFullscreen() {
  const t4 = document;
  t4.fullscreenElement || t4.webkitFullscreenElement || t4.mozFullScreenElement || t4.msFullscreenElement ? disable() : enable();
}
function get_each_context$n(t4, e, n) {
  const o2 = t4.slice();
  return o2[10] = e[n], o2;
}
function create_each_block$n(t4) {
  let e, n, o2, i, a, r2, s2, c;
  function l() {
    return t4[9](t4[10]);
  }
  return { c() {
    e = element("button"), n = element("i"), i = space(), attr(n, "class", o2 = null_to_empty(t4[10].iconClass) + " svelte-mobile-companion-dnd5e-81nkluj30u9vsd-v7dqul"), attr(n, "aria-hidden", "true"), toggle_class(n, "active", t4[10].id.includes(t4[2])), attr(e, "class", a = "icon-button " + t4[10].buttonClass + " svelte-mobile-companion-dnd5e-81nkluj30u9vsd-v7dqul"), attr(e, "aria-label", r2 = t4[10].label ? t4[10].label : null), toggle_class(e, "active", t4[10].id.includes(t4[2]));
  }, m(t5, o3) {
    insert(t5, e, o3), append(e, n), append(e, i), s2 || (c = listen(e, "click", prevent_default(l)), s2 = true);
  }, p(i2, s3) {
    t4 = i2, 1 & s3 && o2 !== (o2 = null_to_empty(t4[10].iconClass) + " svelte-mobile-companion-dnd5e-81nkluj30u9vsd-v7dqul") && attr(n, "class", o2), 5 & s3 && toggle_class(n, "active", t4[10].id.includes(t4[2])), 1 & s3 && a !== (a = "icon-button " + t4[10].buttonClass + " svelte-mobile-companion-dnd5e-81nkluj30u9vsd-v7dqul") && attr(e, "class", a), 1 & s3 && r2 !== (r2 = t4[10].label ? t4[10].label : null) && attr(e, "aria-label", r2), 5 & s3 && toggle_class(e, "active", t4[10].id.includes(t4[2]));
  }, d(t5) {
    t5 && detach(e), s2 = false, c();
  } };
}
function create_if_block$1c(t4) {
  let e, n, o2, i, a, r2, s2, c, l, u = t4[4] && create_if_block_1$A(t4);
  return { c() {
    e = element("div"), n = element("button"), o2 = element("i"), r2 = space(), u && u.c(), s2 = empty(), attr(o2, "class", i = "fa-solid fa-bars " + t4[1]?.iconClass + " svelte-mobile-companion-dnd5e-81nkluj30u9vsd-v7dqul"), attr(o2, "aria-hidden", "true"), attr(n, "class", a = "icon-button " + t4[1]?.buttonClass + " svelte-mobile-companion-dnd5e-81nkluj30u9vsd-v7dqul"), attr(n, "aria-label", "Menu"), attr(e, "class", "main-buttons svelte-mobile-companion-dnd5e-81nkluj30u9vsd-v7dqul");
  }, m(i2, a2) {
    insert(i2, e, a2), append(e, n), append(n, o2), insert(i2, r2, a2), u && u.m(i2, a2), insert(i2, s2, a2), c || (l = listen(n, "click", t4[7]), c = true);
  }, p(t5, e2) {
    2 & e2 && i !== (i = "fa-solid fa-bars " + t5[1]?.iconClass + " svelte-mobile-companion-dnd5e-81nkluj30u9vsd-v7dqul") && attr(o2, "class", i), 2 & e2 && a !== (a = "icon-button " + t5[1]?.buttonClass + " svelte-mobile-companion-dnd5e-81nkluj30u9vsd-v7dqul") && attr(n, "class", a), t5[4] ? u ? (u.p(t5, e2), 16 & e2 && transition_in(u, 1)) : (u = create_if_block_1$A(t5), u.c(), transition_in(u, 1), u.m(s2.parentNode, s2)) : u && (group_outros(), transition_out(u, 1, 1, () => {
      u = null;
    }), check_outros());
  }, d(t5) {
    t5 && (detach(e), detach(r2), detach(s2)), u && u.d(t5), c = false, l();
  } };
}
function create_if_block_1$A(t4) {
  let e, n, o2, i, a, r2, s2, c, l, u;
  return { c() {
    e = element("div"), n = element("div"), n.innerHTML = '<i class="fas fa-maximize"></i>Fullscreen', o2 = space(), i = element("div"), i.innerHTML = '<i class="fas fa-gears"></i>Settings', a = space(), r2 = element("div"), r2.innerHTML = '<i class="fas fa-sign-out-alt"></i>Logout', attr(n, "class", "menu-button svelte-mobile-companion-dnd5e-81nkluj30u9vsd-v7dqul"), attr(n, "aria-hidden", "true"), attr(i, "class", "menu-button svelte-mobile-companion-dnd5e-81nkluj30u9vsd-v7dqul"), attr(i, "aria-hidden", "true"), attr(r2, "class", "menu-button svelte-mobile-companion-dnd5e-81nkluj30u9vsd-v7dqul"), attr(r2, "aria-hidden", "true"), attr(e, "class", "context-menu svelte-mobile-companion-dnd5e-81nkluj30u9vsd-v7dqul"), set_style(e, "top", t4[5].top + "px"), set_style(e, "left", t4[5].left + "px");
  }, m(s3, p2) {
    insert(s3, e, p2), append(e, n), append(e, o2), append(e, i), append(e, a), append(e, r2), c = true, l || (u = [listen(n, "click", toggleFullscreen), listen(i, "click", t4[8]), listen(r2, "click", handleLogout)], l = true);
  }, p(t5, n2) {
    (!c || 32 & n2) && set_style(e, "top", t5[5].top + "px"), (!c || 32 & n2) && set_style(e, "left", t5[5].left + "px");
  }, i(t5) {
    c || (t5 && add_render_callback(() => {
      c && (s2 || (s2 = create_bidirectional_transition(e, slide, {}, true)), s2.run(1));
    }), c = true);
  }, o(t5) {
    t5 && (s2 || (s2 = create_bidirectional_transition(e, slide, {}, false)), s2.run(0)), c = false;
  }, d(t5) {
    t5 && detach(e), t5 && s2 && s2.end(), l = false, run_all(u);
  } };
}
function create_fragment$1V(t4) {
  let e, n, o2, i, a, r2, s2, c = ensure_array_like(t4[0]), l = [];
  for (let e2 = 0; e2 < c.length; e2 += 1) l[e2] = create_each_block$n(get_each_context$n(t4, c, e2));
  let u = t4[1] && create_if_block$1c(t4);
  return { c() {
    e = space(), n = element("header"), o2 = element("div");
    for (let t5 = 0; t5 < l.length; t5 += 1) l[t5].c();
    i = space(), u && u.c(), attr(o2, "class", "custom-buttons svelte-mobile-companion-dnd5e-81nkluj30u9vsd-v7dqul"), attr(n, "class", "header svelte-mobile-companion-dnd5e-81nkluj30u9vsd-v7dqul"), attr(n, "style", a = t4[3].join(" "));
  }, m(a2, c2) {
    insert(a2, e, c2), insert(a2, n, c2), append(n, o2);
    for (let t5 = 0; t5 < l.length; t5 += 1) l[t5] && l[t5].m(o2, null);
    append(n, i), u && u.m(n, null), r2 || (s2 = listen(document.body, "click", t4[6]), r2 = true);
  }, p(t5, [e2]) {
    if (5 & e2) {
      let n2;
      for (c = ensure_array_like(t5[0]), n2 = 0; n2 < c.length; n2 += 1) {
        const i2 = get_each_context$n(t5, c, n2);
        l[n2] ? l[n2].p(i2, e2) : (l[n2] = create_each_block$n(i2), l[n2].c(), l[n2].m(o2, null));
      }
      for (; n2 < l.length; n2 += 1) l[n2].d(1);
      l.length = c.length;
    }
    t5[1] ? u ? u.p(t5, e2) : (u = create_if_block$1c(t5), u.c(), u.m(n, null)) : u && (u.d(1), u = null), 8 & e2 && a !== (a = t5[3].join(" ")) && attr(n, "style", a);
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && (detach(e), detach(n)), destroy_each(l, t5), u && u.d(), r2 = false, s2();
  } };
}
function handleLogout() {
  ui.menu.items.logout.onClick();
}
function handleButtonClick(t4) {
  t4.onClick();
}
function instance$1U(t4, e, n) {
  let { customButtons: o2 = [] } = e, { menuButtons: i } = e, { activeFilter: a } = e, { headerStyle: r2 = [] } = e, s2 = false, c = { top: 0, left: 0 };
  return t4.$$set = (t5) => {
    "customButtons" in t5 && n(0, o2 = t5.customButtons), "menuButtons" in t5 && n(1, i = t5.menuButtons), "activeFilter" in t5 && n(2, a = t5.activeFilter), "headerStyle" in t5 && n(3, r2 = t5.headerStyle);
  }, [o2, i, a, r2, s2, c, function() {
    s2 && n(4, s2 = false);
  }, function(t5) {
    if (t5.stopPropagation(), n(4, s2 = !s2), s2) {
      const e2 = t5.target.getBoundingClientRect(), o3 = -15, i2 = -100;
      n(5, c = { top: e2.bottom + window.scrollY + o3, left: e2.left + window.scrollX + i2 });
    }
  }, function(t5) {
    t5.stopPropagation(), game.settings.sheet && game.settings.sheet.close(), n(4, s2 = false), game.settings.sheet.render(true, { focus: true });
  }, (t5) => handleButtonClick(t5)];
}
class Header extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1U, create_fragment$1V, safe_not_equal, { customButtons: 0, menuButtons: 1, activeFilter: 2, headerStyle: 3 });
  }
}
function create_else_block$d(t4) {
  let e;
  return { c() {
    e = element("p"), e.textContent = "This is a Patreon Feature.", attr(e, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1e7pih");
  }, m(t5, n) {
    insert(t5, e, n);
  }, p: noop$3, d(t5) {
    t5 && detach(e);
  } };
}
function create_if_block$1b(t4) {
  let e, n, o2, i;
  return { c() {
    e = element("p"), n = element("b"), o2 = text(t4[0]), i = text(" is a Patreon Feature."), attr(e, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1e7pih");
  }, m(t5, a) {
    insert(t5, e, a), append(e, n), append(n, o2), append(e, i);
  }, p(t5, e2) {
    1 & e2 && set_data(o2, t5[0]);
  }, d(t5) {
    t5 && detach(e);
  } };
}
function create_fragment$1U(t4) {
  let e, n, o2, i, a, r2, s2;
  function c(t5, e2) {
    return t5[0] ? create_if_block$1b : create_else_block$d;
  }
  let l = c(t4), u = l(t4);
  return { c() {
    e = element("div"), n = element("h1"), n.textContent = "Patreon Feature", o2 = space(), u.c(), i = space(), a = element("p"), a.innerHTML = 'You can download it as a <span class="pledge-type svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1e7pih">Copper Coin Collector</span> at <a href="https://www.patreon.com/SyriousWorkshop/membership" target="_blank">Syrious&#39; Workshop</a>', r2 = space(), s2 = element("p"), s2.textContent = "Your contribution will help immensely further developing this module.", attr(n, "class", "title svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1e7pih"), attr(a, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1e7pih"), attr(s2, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1e7pih"), attr(e, "class", "information svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1e7pih");
  }, m(t5, c2) {
    insert(t5, e, c2), append(e, n), append(e, o2), u.m(e, null), append(e, i), append(e, a), append(e, r2), append(e, s2);
  }, p(t5, [n2]) {
    l === (l = c(t5)) && u ? u.p(t5, n2) : (u.d(1), u = l(t5), u && (u.c(), u.m(e, i)));
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e), u.d();
  } };
}
function instance$1T(t4, e, n) {
  let { subject: o2 } = e;
  return t4.$$set = (t5) => {
    "subject" in t5 && n(0, o2 = t5.subject);
  }, [o2];
}
class Patreon extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1T, create_fragment$1U, safe_not_equal, { subject: 0 });
  }
}
function create_fragment$1T(t4) {
  let e;
  return { c() {
    e = element("div"), e.innerHTML = '<div class="text-box svelte-mobile-companion-dnd5e-81nkluj30u9vsd-17yd3t9"><p class="svelte-mobile-companion-dnd5e-81nkluj30u9vsd-17yd3t9"><b>Available in pro version.</b></p> <p class="svelte-mobile-companion-dnd5e-81nkluj30u9vsd-17yd3t9">Please visit <a href="https://www.patreon.com/SyriousWorkshop" target="_blank">Syrious&#39;\n            Workshop</a></p></div>', attr(e, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-17yd3t9"), toggle_class(e, "overlay", t4[0]);
  }, m(t5, n) {
    insert(t5, e, n);
  }, p(t5, [n]) {
    1 & n && toggle_class(e, "overlay", t5[0]);
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e);
  } };
}
function instance$1S(t4, e, n) {
  let { useOverlay: o2 = true } = e;
  return t4.$$set = (t5) => {
    "useOverlay" in t5 && n(0, o2 = t5.useOverlay);
  }, [o2];
}
class ProOverlay extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1S, create_fragment$1T, safe_not_equal, { useOverlay: 0 });
  }
}
function create_else_block$c(t4) {
  let e, n, o2, i, a, r2;
  function s2(t5, e2) {
    return t5[0] <= 0 && t5[3] ? create_if_block_1$z : create_else_block_1$1;
  }
  let c = s2(t4), l = c(t4);
  return { c() {
    l.c(), e = space(), n = element("input"), o2 = space(), i = element("button"), i.innerHTML = '<i class="fas fa-plus"></i>', attr(n, "class", "input svelte-mobile-companion-dnd5e-81nkluj30u9vsd-7x0de1"), attr(n, "type", "text"), n.value = t4[0], attr(n, "placeholder", "0"), attr(n, "inputmode", "numeric"), attr(n, "pattern", "[0-9+=\\-]*"), set_style(n, "font-family", t4[1]), attr(n, "min", "0"), attr(i, "class", "adjustment-button svelte-mobile-companion-dnd5e-81nkluj30u9vsd-7x0de1");
  }, m(s3, c2) {
    l.m(s3, c2), insert(s3, e, c2), insert(s3, n, c2), insert(s3, o2, c2), insert(s3, i, c2), a || (r2 = [listen(n, "input", t4[6]), listen(i, "click", t4[4])], a = true);
  }, p(t5, o3) {
    c === (c = s2(t5)) && l ? l.p(t5, o3) : (l.d(1), l = c(t5), l && (l.c(), l.m(e.parentNode, e))), 1 & o3 && n.value !== t5[0] && (n.value = t5[0]), 2 & o3 && set_style(n, "font-family", t5[1]);
  }, d(t5) {
    t5 && (detach(e), detach(n), detach(o2), detach(i)), l.d(t5), a = false, run_all(r2);
  } };
}
function create_if_block$1a(t4) {
  let e, n;
  return { c() {
    e = element("div"), n = text(t4[0]), attr(e, "class", "input");
  }, m(t5, o2) {
    insert(t5, e, o2), append(e, n);
  }, p(t5, e2) {
    1 & e2 && set_data(n, t5[0]);
  }, d(t5) {
    t5 && detach(e);
  } };
}
function create_else_block_1$1(t4) {
  let e, n, o2;
  return { c() {
    e = element("button"), e.innerHTML = '<i class="fas fa-minus"></i>', attr(e, "class", "adjustment-button svelte-mobile-companion-dnd5e-81nkluj30u9vsd-7x0de1");
  }, m(i, a) {
    insert(i, e, a), n || (o2 = listen(e, "click", t4[5]), n = true);
  }, p: noop$3, d(t5) {
    t5 && detach(e), n = false, o2();
  } };
}
function create_if_block_1$z(t4) {
  let e, n, o2;
  return { c() {
    e = element("button"), e.innerHTML = '<i class="fas fa-trash"></i>', attr(e, "class", "adjustment-button svelte-mobile-companion-dnd5e-81nkluj30u9vsd-7x0de1");
  }, m(i, a) {
    insert(i, e, a), n || (o2 = listen(e, "click", t4[7]), n = true);
  }, p: noop$3, d(t5) {
    t5 && detach(e), n = false, o2();
  } };
}
function create_fragment$1S(t4) {
  let e;
  function n(t5, e2) {
    return t5[2] ? create_if_block$1a : create_else_block$c;
  }
  let o2 = n(t4), i = o2(t4);
  return { c() {
    e = element("div"), i.c(), attr(e, "class", "item-quantity svelte-mobile-companion-dnd5e-81nkluj30u9vsd-7x0de1");
  }, m(t5, n2) {
    insert(t5, e, n2), i.m(e, null);
  }, p(t5, [a]) {
    o2 === (o2 = n(t5)) && i ? i.p(t5, a) : (i.d(1), i = o2(t5), i && (i.c(), i.m(e, null)));
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e), i.d();
  } };
}
function instance$1R(t4, e, n) {
  let { quantity: o2 = 0 } = e, { fontFamily: i = "monospace" } = e, { readOnly: a = false } = e, { removeWhenZero: r2 = false } = e;
  const s2 = createEventDispatcher();
  return t4.$$set = (t5) => {
    "quantity" in t5 && n(0, o2 = t5.quantity), "fontFamily" in t5 && n(1, i = t5.fontFamily), "readOnly" in t5 && n(2, a = t5.readOnly), "removeWhenZero" in t5 && n(3, r2 = t5.removeWhenZero);
  }, [o2, i, a, r2, function() {
    n(0, o2++, o2), s2("onQtyChange", { newValue: o2 });
  }, function() {
    o2 > 0 && (n(0, o2--, o2), s2("onQtyChange", { newValue: o2 }));
  }, function(t5) {
    n(0, o2 = parseInt(t5.target.value || "0")), s2("onQtyChange", { newValue: o2 });
  }, function() {
    s2("remove");
  }];
}
class Quantity extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1R, create_fragment$1S, safe_not_equal, { quantity: 0, fontFamily: 1, readOnly: 2, removeWhenZero: 3 });
  }
}
function portal(t4, e = "body") {
  let n;
  async function o2(o3) {
    if ("string" == typeof (e = o3)) {
      if (n = document.querySelector(e), null === n && (await tick(), n = document.querySelector(e)), null === n) throw new Error(`No element found matching css selector: "${e}"`);
    } else {
      if (!(e instanceof HTMLElement)) throw new TypeError(`Unknown portal target type: ${null === e ? "null" : typeof e}. Allowed types: string (CSS selector) or HTMLElement.`);
      n = e;
    }
    n.appendChild(t4), t4.hidden = false;
  }
  return o2(e), { update: o2, destroy: function() {
    t4.parentNode && t4.parentNode.removeChild(t4);
  } };
}
function create_fragment$1R(t4) {
  let e, n, o2, i, a, r2, s2;
  const c = t4[2].default, l = create_slot(c, t4, t4[1], null);
  return { c() {
    e = element("div"), n = element("div"), o2 = element("span"), o2.innerHTML = '<i class="fas fa-xmark"></i>', i = space(), l && l.c(), attr(o2, "class", "close-button svelte-mobile-companion-dnd5e-81nkluj30u9vsd-6ani4j"), attr(o2, "aria-hidden", "true"), attr(n, "class", "modal svelte-mobile-companion-dnd5e-81nkluj30u9vsd-6ani4j"), attr(e, "id", "mobile-companion-modal"), attr(e, "class", "backdrop svelte-mobile-companion-dnd5e-81nkluj30u9vsd-6ani4j");
  }, m(c2, u) {
    insert(c2, e, u), append(e, n), append(n, o2), append(n, i), l && l.m(n, null), a = true, r2 || (s2 = [listen(o2, "click", t4[0]), action_destroyer(portal.call(null, e, "body"))], r2 = true);
  }, p(t5, [e2]) {
    l && l.p && (!a || 2 & e2) && update_slot_base(l, c, t5, t5[1], a ? get_slot_changes(c, t5[1], e2, null) : get_all_dirty_from_scope(t5[1]), null);
  }, i(t5) {
    a || (transition_in(l, t5), a = true);
  }, o(t5) {
    transition_out(l, t5), a = false;
  }, d(t5) {
    t5 && detach(e), l && l.d(t5), r2 = false, run_all(s2);
  } };
}
function instance$1Q(t4, e, n) {
  let { $$slots: o2 = {}, $$scope: i } = e;
  const a = createEventDispatcher();
  return t4.$$set = (t5) => {
    "$$scope" in t5 && n(1, i = t5.$$scope);
  }, [function() {
    a("close");
  }, i, o2];
}
class GenericModal extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1Q, create_fragment$1R, safe_not_equal, {});
  }
}
function create_if_block_1$y(t4) {
  let e, n;
  return { c() {
    e = element("h2"), n = text(t4[0]), attr(e, "class", "title svelte-mobile-companion-dnd5e-81nkluj30u9vsd-19nja5j");
  }, m(t5, o2) {
    insert(t5, e, o2), append(e, n);
  }, p(t5, e2) {
    1 & e2 && set_data(n, t5[0]);
  }, d(t5) {
    t5 && detach(e);
  } };
}
function create_if_block$19(t4) {
  let e, n, o2;
  return { c() {
    e = element("div"), n = text("Current: "), o2 = text(t4[1]), attr(e, "class", "current-value svelte-mobile-companion-dnd5e-81nkluj30u9vsd-19nja5j");
  }, m(t5, i) {
    insert(t5, e, i), append(e, n), append(e, o2);
  }, p(t5, e2) {
    2 & e2 && set_data(o2, t5[1]);
  }, d(t5) {
    t5 && detach(e);
  } };
}
function create_default_slot$h(t4) {
  let e, n, o2, i, a, r2, s2, c, l, u, p2, d, m, f, _, h, g2, $2, b, y, v, k, w2, S2, T, x2, E, O, A2, C, D, M = t4[0] && create_if_block_1$y(t4), j = (t4[1] || 0 === t4[1]) && create_if_block$19(t4);
  function I(e2) {
    t4[10](e2);
  }
  let N = { styleClass: "global-number-input-with-button-value" };
  return void 0 !== t4[2] && (N.value = t4[2]), m = new EvaluatingInput({ props: N }), binding_callbacks.push(() => bind(m, "value", I)), { c() {
    e = element("div"), n = element("header"), M && M.c(), o2 = space(), j && j.c(), i = space(), a = element("div"), r2 = element("div"), s2 = element("button"), s2.innerHTML = '<i class="fa-solid fa-minus svelte-mobile-companion-dnd5e-81nkluj30u9vsd-19nja5j"></i>', c = space(), l = element("button"), l.innerHTML = '<i class="fa-solid fa-minus svelte-mobile-companion-dnd5e-81nkluj30u9vsd-19nja5j"></i> <i class="fa-solid fa-minus svelte-mobile-companion-dnd5e-81nkluj30u9vsd-19nja5j"></i>', u = space(), p2 = element("button"), p2.innerHTML = '<i class="fa-solid fa-minus svelte-mobile-companion-dnd5e-81nkluj30u9vsd-19nja5j"></i> <i class="fa-solid fa-minus svelte-mobile-companion-dnd5e-81nkluj30u9vsd-19nja5j"></i> <i class="fa-solid fa-minus svelte-mobile-companion-dnd5e-81nkluj30u9vsd-19nja5j"></i>', d = space(), create_component(m.$$.fragment), _ = space(), h = element("div"), g2 = element("button"), g2.innerHTML = '<i class="fa-solid fa-plus svelte-mobile-companion-dnd5e-81nkluj30u9vsd-19nja5j"></i>', $2 = space(), b = element("button"), b.innerHTML = '<i class="fa-solid fa-plus svelte-mobile-companion-dnd5e-81nkluj30u9vsd-19nja5j"></i> <i class="fa-solid fa-plus svelte-mobile-companion-dnd5e-81nkluj30u9vsd-19nja5j"></i>', y = space(), v = element("button"), v.innerHTML = '<i class="fa-solid fa-plus svelte-mobile-companion-dnd5e-81nkluj30u9vsd-19nja5j"></i> <i class="fa-solid fa-plus svelte-mobile-companion-dnd5e-81nkluj30u9vsd-19nja5j"></i> <i class="fa-solid fa-plus svelte-mobile-companion-dnd5e-81nkluj30u9vsd-19nja5j"></i>', k = space(), w2 = element("div"), S2 = element("button"), S2.textContent = `${myi18n("Input.Change")}`, T = space(), x2 = element("p"), x2.textContent = "- OR -", E = space(), O = element("button"), O.textContent = `${myi18n("Input.Set")}`, attr(n, "class", "number-input-header svelte-mobile-companion-dnd5e-81nkluj30u9vsd-19nja5j"), attr(s2, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-19nja5j"), attr(l, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-19nja5j"), attr(p2, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-19nja5j"), attr(r2, "class", "vertical svelte-mobile-companion-dnd5e-81nkluj30u9vsd-19nja5j"), attr(g2, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-19nja5j"), attr(b, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-19nja5j"), attr(v, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-19nja5j"), attr(h, "class", "vertical svelte-mobile-companion-dnd5e-81nkluj30u9vsd-19nja5j"), attr(a, "class", "input-group svelte-mobile-companion-dnd5e-81nkluj30u9vsd-19nja5j"), attr(S2, "class", " svelte-mobile-companion-dnd5e-81nkluj30u9vsd-19nja5j"), attr(x2, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-19nja5j"), attr(O, "class", " svelte-mobile-companion-dnd5e-81nkluj30u9vsd-19nja5j"), attr(w2, "class", "change-or-set svelte-mobile-companion-dnd5e-81nkluj30u9vsd-19nja5j"), attr(e, "class", "modal-content svelte-mobile-companion-dnd5e-81nkluj30u9vsd-19nja5j");
  }, m(f2, I2) {
    insert(f2, e, I2), append(e, n), M && M.m(n, null), append(n, o2), j && j.m(n, null), append(e, i), append(e, a), append(a, r2), append(r2, s2), append(r2, c), append(r2, l), append(r2, u), append(r2, p2), append(a, d), mount_component(m, a, null), append(a, _), append(a, h), append(h, g2), append(h, $2), append(h, b), append(h, y), append(h, v), append(e, k), append(e, w2), append(w2, S2), append(w2, T), append(w2, x2), append(w2, E), append(w2, O), A2 = true, C || (D = [listen(s2, "click", t4[7]), listen(l, "click", t4[8]), listen(p2, "click", t4[9]), listen(g2, "click", t4[11]), listen(b, "click", t4[12]), listen(v, "click", t4[13]), listen(S2, "click", t4[14]), listen(O, "click", t4[15])], C = true);
  }, p(t5, e2) {
    t5[0] ? M ? M.p(t5, e2) : (M = create_if_block_1$y(t5), M.c(), M.m(n, o2)) : M && (M.d(1), M = null), t5[1] || 0 === t5[1] ? j ? j.p(t5, e2) : (j = create_if_block$19(t5), j.c(), j.m(n, null)) : j && (j.d(1), j = null);
    const i2 = {};
    !f && 4 & e2 && (f = true, i2.value = t5[2], add_flush_callback(() => f = false)), m.$set(i2);
  }, i(t5) {
    A2 || (transition_in(m.$$.fragment, t5), A2 = true);
  }, o(t5) {
    transition_out(m.$$.fragment, t5), A2 = false;
  }, d(t5) {
    t5 && detach(e), M && M.d(), j && j.d(), destroy_component(m), C = false, run_all(D);
  } };
}
function create_fragment$1Q(t4) {
  let e, n;
  return e = new GenericModal({ props: { $$slots: { default: [create_default_slot$h] }, $$scope: { ctx: t4 } } }), e.$on("close", t4[6]), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, [n2]) {
    const o2 = {};
    131079 & n2 && (o2.$$scope = { dirty: n2, ctx: t5 }), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function instance$1P(t4, e, n) {
  let { title: o2 } = e, { currentValue: i } = e;
  const a = createEventDispatcher();
  let r2 = 0;
  function s2(t5 = 1) {
    n(2, r2 += t5);
  }
  function c(t5 = 1) {
    n(2, r2 -= t5);
  }
  function l(t5) {
    a("action", { action: t5, value: r2 });
  }
  return t4.$$set = (t5) => {
    "title" in t5 && n(0, o2 = t5.title), "currentValue" in t5 && n(1, i = t5.currentValue);
  }, [o2, i, r2, s2, c, l, function() {
    a("close");
  }, () => c(), () => c(10), () => c(100), function(t5) {
    r2 = t5, n(2, r2);
  }, () => s2(), () => s2(10), () => s2(100), () => l("add"), () => l("set")];
}
class NumberInputWithButtons extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1P, create_fragment$1Q, safe_not_equal, { title: 0, currentValue: 1 });
  }
}
function hideActorSheetPopup(t4) {
  t4.element.style ? t4.element.style.display = "none" : $(t4).hide(), setTimeout(async () => {
    await t4.close();
  }, 1e3);
}
function handleReadOnlyActor(t4) {
  hideActorSheetPopup(t4), readOnlyActor.set(t4.actor);
}
const readOnlyActor = writable(void 0);
function isReadOnlyActor(t4) {
  return get_store_value(readOnlyActor)?.id === t4.id;
}
readOnlyActor.subscribe((t4) => {
  t4 && (actorStore.set(t4), switchFilter(Filters.Character));
});
class FoundryGateway {
  static updateActor(t4, e) {
    isReadOnlyActor(t4) || t4.update(e);
  }
  static updateActivity(t4, e) {
    isReadOnlyActor(t4.actor) || t4.update(e);
  }
  static updateFeature(t4, e) {
    isReadOnlyActor(t4.actor) || t4.update(e);
  }
  static updateItem(t4, e) {
    isReadOnlyActor(t4.actor) || t4.update(e);
  }
}
const faCircleChevronRight = { prefix: "fas", iconName: "circle-chevron-right", icon: [512, 512, ["chevron-circle-right"], "f138", "M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zM241 377c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l87-87-87-87c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0L345 239c9.4 9.4 9.4 24.6 0 33.9L241 377z"] }, faFilter = { prefix: "fas", iconName: "filter", icon: [512, 512, [], "f0b0", "M3.9 54.9C10.5 40.9 24.5 32 40 32l432 0c15.5 0 29.5 8.9 36.1 22.9s4.6 30.5-5.2 42.5L320 320.9 320 448c0 12.1-6.8 23.2-17.7 28.6s-23.8 4.3-33.5-3l-64-48c-8.1-6-12.8-15.5-12.8-25.6l0-79.1L9 97.3C-.7 85.4-2.8 68.8 3.9 54.9z"] }, faMoneyBillTransfer = { prefix: "fas", iconName: "money-bill-transfer", icon: [640, 512, [], "e528", "M535 41c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l64 64c4.5 4.5 7 10.6 7 17s-2.5 12.5-7 17l-64 64c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l23-23L384 112c-13.3 0-24-10.7-24-24s10.7-24 24-24l174.1 0L535 41zM105 377l-23 23L256 400c13.3 0 24 10.7 24 24s-10.7 24-24 24L81.9 448l23 23c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0L7 441c-4.5-4.5-7-10.6-7-17s2.5-12.5 7-17l64-64c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9zM96 64l241.9 0c-3.7 7.2-5.9 15.3-5.9 24c0 28.7 23.3 52 52 52l117.4 0c-4 17 .6 35.5 13.8 48.8c20.3 20.3 53.2 20.3 73.5 0L608 169.5 608 384c0 35.3-28.7 64-64 64l-241.9 0c3.7-7.2 5.9-15.3 5.9-24c0-28.7-23.3-52-52-52l-117.4 0c4-17-.6-35.5-13.8-48.8c-20.3-20.3-53.2-20.3-73.5 0L32 342.5 32 128c0-35.3 28.7-64 64-64zm64 64l-64 0 0 64c35.3 0 64-28.7 64-64zM544 320c-35.3 0-64 28.7-64 64l64 0 0-64zM320 352a96 96 0 1 0 0-192 96 96 0 1 0 0 192z"] }, faXmark = { prefix: "fas", iconName: "xmark", icon: [384, 512, [128473, 10005, 10006, 10060, 215, "close", "multiply", "remove", "times"], "f00d", "M342.6 150.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L192 210.7 86.6 105.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L146.7 256 41.4 361.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L192 301.3 297.4 406.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L237.3 256 342.6 150.6z"] }, faCheck = { prefix: "fas", iconName: "check", icon: [448, 512, [10003, 10004], "f00c", "M438.6 105.4c12.5 12.5 12.5 32.8 0 45.3l-256 256c-12.5 12.5-32.8 12.5-45.3 0l-128-128c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0L160 338.7 393.4 105.4c12.5-12.5 32.8-12.5 45.3 0z"] }, faCircleXmark = { prefix: "fas", iconName: "circle-xmark", icon: [512, 512, [61532, "times-circle", "xmark-circle"], "f057", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM175 175c9.4-9.4 24.6-9.4 33.9 0l47 47 47-47c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-47 47 47 47c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-47-47-47 47c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l47-47-47-47c-9.4-9.4-9.4-24.6 0-33.9z"] }, faXmarkCircle = faCircleXmark;
function classList(t4) {
  const { beat: e, fade: n, beatFade: o2, bounce: i, shake: a, flash: r2, spin: s2, spinPulse: c, spinReverse: l, pulse: u, fixedWidth: p2, inverse: d, border: m, listItem: f, flip: _, size: h, rotation: g2, pull: $2 } = t4, b = { "fa-beat": e, "fa-fade": n, "fa-beat-fade": o2, "fa-bounce": i, "fa-shake": a, "fa-flash": r2, "fa-spin": s2, "fa-spin-reverse": l, "fa-spin-pulse": c, "fa-pulse": u, "fa-fw": p2, "fa-inverse": d, "fa-border": m, "fa-li": f, "fa-flip": true === _, "fa-flip-horizontal": "horizontal" === _ || "both" === _, "fa-flip-vertical": "vertical" === _ || "both" === _, [`fa-${h}`]: null != h, [`fa-rotate-${g2}`]: null != g2 && 0 !== g2, [`fa-pull-${$2}`]: null != $2, "fa-swap-opacity": t4.swapOpacity };
  return Object.keys(b).map((t5) => b[t5] ? t5 : null).filter((t5) => t5);
}
function _isNumerical(t4) {
  return (t4 -= 0) == t4;
}
function camelize(t4) {
  return _isNumerical(t4) ? t4 : (t4 = t4.replace(/[\-_\s]+(.)?/g, function(t5, e) {
    return e ? e.toUpperCase() : "";
  })).substr(0, 1).toLowerCase() + t4.substr(1);
}
function styleToString(t4) {
  return "string" == typeof t4 ? t4 : Object.keys(t4).reduce((e, n) => e + n.split(/(?=[A-Z])/).join("-").toLowerCase() + ":" + t4[n] + ";", "");
}
function convert(t4, e, n = {}) {
  if ("string" == typeof e) return e;
  const o2 = (e.children || []).map((e2) => convert(t4, e2)), i = Object.keys(e.attributes || {}).reduce((t5, n2) => {
    const o3 = e.attributes[n2];
    return "style" === n2 ? t5.attrs.style = styleToString(o3) : 0 === n2.indexOf("aria-") || 0 === n2.indexOf("data-") ? t5.attrs[n2.toLowerCase()] = o3 : t5.attrs[camelize(n2)] = o3, t5;
  }, { attrs: {} });
  return t4(e.tag, { ...i.attrs }, o2);
}
function _defineProperty(t4, e, n) {
  return (e = _toPropertyKey(e)) in t4 ? Object.defineProperty(t4, e, { value: n, enumerable: true, configurable: true, writable: true }) : t4[e] = n, t4;
}
function ownKeys(t4, e) {
  var n = Object.keys(t4);
  if (Object.getOwnPropertySymbols) {
    var o2 = Object.getOwnPropertySymbols(t4);
    e && (o2 = o2.filter(function(e2) {
      return Object.getOwnPropertyDescriptor(t4, e2).enumerable;
    })), n.push.apply(n, o2);
  }
  return n;
}
function _objectSpread2(t4) {
  for (var e = 1; e < arguments.length; e++) {
    var n = null != arguments[e] ? arguments[e] : {};
    e % 2 ? ownKeys(Object(n), true).forEach(function(e2) {
      _defineProperty(t4, e2, n[e2]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(t4, Object.getOwnPropertyDescriptors(n)) : ownKeys(Object(n)).forEach(function(e2) {
      Object.defineProperty(t4, e2, Object.getOwnPropertyDescriptor(n, e2));
    });
  }
  return t4;
}
function _toPrimitive(t4, e) {
  if ("object" != typeof t4 || !t4) return t4;
  var n = t4[Symbol.toPrimitive];
  if (void 0 !== n) {
    var o2 = n.call(t4, e || "default");
    if ("object" != typeof o2) return o2;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return ("string" === e ? String : Number)(t4);
}
function _toPropertyKey(t4) {
  var e = _toPrimitive(t4, "string");
  return "symbol" == typeof e ? e : e + "";
}
const noop = () => {
};
let _WINDOW = {}, _DOCUMENT = {}, _MUTATION_OBSERVER = null, _PERFORMANCE = { mark: noop, measure: noop };
try {
  "undefined" != typeof window && (_WINDOW = window), "undefined" != typeof document && (_DOCUMENT = document), "undefined" != typeof MutationObserver && (_MUTATION_OBSERVER = MutationObserver), "undefined" != typeof performance && (_PERFORMANCE = performance);
} catch (t4) {
}
const { userAgent = "" } = _WINDOW.navigator || {}, WINDOW = _WINDOW, DOCUMENT = _DOCUMENT, MUTATION_OBSERVER = _MUTATION_OBSERVER, PERFORMANCE = _PERFORMANCE;
WINDOW.document;
const IS_DOM = !!DOCUMENT.documentElement && !!DOCUMENT.head && "function" == typeof DOCUMENT.addEventListener && "function" == typeof DOCUMENT.createElement, IS_IE = ~userAgent.indexOf("MSIE") || ~userAgent.indexOf("Trident/");
var p = /fa(s|r|l|t|d|dr|dl|dt|b|k|kd|ss|sr|sl|st|sds|sdr|sdl|sdt)?[\-\ ]/, g = /Font ?Awesome ?([56 ]*)(Solid|Regular|Light|Thin|Duotone|Brands|Free|Pro|Sharp Duotone|Sharp|Kit)?.*/i, S = { classic: { fa: "solid", fas: "solid", "fa-solid": "solid", far: "regular", "fa-regular": "regular", fal: "light", "fa-light": "light", fat: "thin", "fa-thin": "thin", fab: "brands", "fa-brands": "brands" }, duotone: { fa: "solid", fad: "solid", "fa-solid": "solid", "fa-duotone": "solid", fadr: "regular", "fa-regular": "regular", fadl: "light", "fa-light": "light", fadt: "thin", "fa-thin": "thin" }, sharp: { fa: "solid", fass: "solid", "fa-solid": "solid", fasr: "regular", "fa-regular": "regular", fasl: "light", "fa-light": "light", fast: "thin", "fa-thin": "thin" }, "sharp-duotone": { fa: "solid", fasds: "solid", "fa-solid": "solid", fasdr: "regular", "fa-regular": "regular", fasdl: "light", "fa-light": "light", fasdt: "thin", "fa-thin": "thin" } }, A = { GROUP: "duotone-group", SWAP_OPACITY: "swap-opacity", PRIMARY: "primary", SECONDARY: "secondary" }, P = ["fa-classic", "fa-duotone", "fa-sharp", "fa-sharp-duotone"], s = "classic", t = "duotone", r = "sharp", o = "sharp-duotone", L = [s, t, r, o], G = { classic: { 900: "fas", 400: "far", normal: "far", 300: "fal", 100: "fat" }, duotone: { 900: "fad", 400: "fadr", 300: "fadl", 100: "fadt" }, sharp: { 900: "fass", 400: "fasr", 300: "fasl", 100: "fast" }, "sharp-duotone": { 900: "fasds", 400: "fasdr", 300: "fasdl", 100: "fasdt" } }, lt = { "Font Awesome 6 Free": { 900: "fas", 400: "far" }, "Font Awesome 6 Pro": { 900: "fas", 400: "far", normal: "far", 300: "fal", 100: "fat" }, "Font Awesome 6 Brands": { 400: "fab", normal: "fab" }, "Font Awesome 6 Duotone": { 900: "fad", 400: "fadr", normal: "fadr", 300: "fadl", 100: "fadt" }, "Font Awesome 6 Sharp": { 900: "fass", 400: "fasr", normal: "fasr", 300: "fasl", 100: "fast" }, "Font Awesome 6 Sharp Duotone": { 900: "fasds", 400: "fasdr", normal: "fasdr", 300: "fasdl", 100: "fasdt" } }, pt = /* @__PURE__ */ new Map([["classic", { defaultShortPrefixId: "fas", defaultStyleId: "solid", styleIds: ["solid", "regular", "light", "thin", "brands"], futureStyleIds: [], defaultFontWeight: 900 }], ["sharp", { defaultShortPrefixId: "fass", defaultStyleId: "solid", styleIds: ["solid", "regular", "light", "thin"], futureStyleIds: [], defaultFontWeight: 900 }], ["duotone", { defaultShortPrefixId: "fad", defaultStyleId: "solid", styleIds: ["solid", "regular", "light", "thin"], futureStyleIds: [], defaultFontWeight: 900 }], ["sharp-duotone", { defaultShortPrefixId: "fasds", defaultStyleId: "solid", styleIds: ["solid", "regular", "light", "thin"], futureStyleIds: [], defaultFontWeight: 900 }]]), xt = { classic: { solid: "fas", regular: "far", light: "fal", thin: "fat", brands: "fab" }, duotone: { solid: "fad", regular: "fadr", light: "fadl", thin: "fadt" }, sharp: { solid: "fass", regular: "fasr", light: "fasl", thin: "fast" }, "sharp-duotone": { solid: "fasds", regular: "fasdr", light: "fasdl", thin: "fasdt" } }, Ft = ["fak", "fa-kit", "fakd", "fa-kit-duotone"], St = { kit: { fak: "kit", "fa-kit": "kit" }, "kit-duotone": { fakd: "kit-duotone", "fa-kit-duotone": "kit-duotone" } }, At = ["kit"], Ct = { kit: { "fa-kit": "fak" }, "kit-duotone": { "fa-kit-duotone": "fakd" } }, Lt = ["fak", "fakd"], Wt = { kit: { fak: "fa-kit" }, "kit-duotone": { fakd: "fa-kit-duotone" } }, Et = { kit: { kit: "fak" }, "kit-duotone": { "kit-duotone": "fakd" } }, t$1 = { GROUP: "duotone-group", SWAP_OPACITY: "swap-opacity", PRIMARY: "primary", SECONDARY: "secondary" }, r$1 = ["fa-classic", "fa-duotone", "fa-sharp", "fa-sharp-duotone"], bt$1 = ["fak", "fa-kit", "fakd", "fa-kit-duotone"], Yt = { "Font Awesome Kit": { 400: "fak", normal: "fak" }, "Font Awesome Kit Duotone": { 400: "fakd", normal: "fakd" } }, po = { classic: { "fa-brands": "fab", "fa-duotone": "fad", "fa-light": "fal", "fa-regular": "far", "fa-solid": "fas", "fa-thin": "fat" }, duotone: { "fa-regular": "fadr", "fa-light": "fadl", "fa-thin": "fadt" }, sharp: { "fa-solid": "fass", "fa-regular": "fasr", "fa-light": "fasl", "fa-thin": "fast" }, "sharp-duotone": { "fa-solid": "fasds", "fa-regular": "fasdr", "fa-light": "fasdl", "fa-thin": "fasdt" } }, I$1 = { classic: ["fas", "far", "fal", "fat", "fad"], duotone: ["fadr", "fadl", "fadt"], sharp: ["fass", "fasr", "fasl", "fast"], "sharp-duotone": ["fasds", "fasdr", "fasdl", "fasdt"] }, co = { classic: { fab: "fa-brands", fad: "fa-duotone", fal: "fa-light", far: "fa-regular", fas: "fa-solid", fat: "fa-thin" }, duotone: { fadr: "fa-regular", fadl: "fa-light", fadt: "fa-thin" }, sharp: { fass: "fa-solid", fasr: "fa-regular", fasl: "fa-light", fast: "fa-thin" }, "sharp-duotone": { fasds: "fa-solid", fasdr: "fa-regular", fasdl: "fa-light", fasdt: "fa-thin" } }, x = ["fa-solid", "fa-regular", "fa-light", "fa-thin", "fa-duotone", "fa-brands"], xo = ["fa", "fas", "far", "fal", "fat", "fad", "fadr", "fadl", "fadt", "fab", "fass", "fasr", "fasl", "fast", "fasds", "fasdr", "fasdl", "fasdt", ...r$1, ...x], m$1 = ["solid", "regular", "light", "thin", "duotone", "brands"], c$1 = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10], F$1 = c$1.concat([11, 12, 13, 14, 15, 16, 17, 18, 19, 20]), Fo = [...Object.keys(I$1), ...m$1, "2xs", "xs", "sm", "lg", "xl", "2xl", "beat", "border", "fade", "beat-fade", "bounce", "flip-both", "flip-horizontal", "flip-vertical", "flip", "fw", "inverse", "layers-counter", "layers-text", "layers", "li", "pull-left", "pull-right", "pulse", "rotate-180", "rotate-270", "rotate-90", "rotate-by", "shake", "spin-pulse", "spin-reverse", "spin", "stack-1x", "stack-2x", "stack", "ul", t$1.GROUP, t$1.SWAP_OPACITY, t$1.PRIMARY, t$1.SECONDARY].concat(c$1.map((t4) => "".concat(t4, "x"))).concat(F$1.map((t4) => "w-".concat(t4))), ko = { "Font Awesome 5 Free": { 900: "fas", 400: "far" }, "Font Awesome 5 Pro": { 900: "fas", 400: "far", normal: "far", 300: "fal" }, "Font Awesome 5 Brands": { 400: "fab", normal: "fab" }, "Font Awesome 5 Duotone": { 900: "fad" } };
const NAMESPACE_IDENTIFIER = "___FONT_AWESOME___", UNITS_IN_GRID = 16, DEFAULT_CSS_PREFIX = "fa", DEFAULT_REPLACEMENT_CLASS = "svg-inline--fa", DATA_FA_I2SVG = "data-fa-i2svg", DATA_FA_PSEUDO_ELEMENT = "data-fa-pseudo-element", DATA_FA_PSEUDO_ELEMENT_PENDING = "data-fa-pseudo-element-pending", DATA_PREFIX = "data-prefix", DATA_ICON = "data-icon", HTML_CLASS_I2SVG_BASE_CLASS = "fontawesome-i2svg", MUTATION_APPROACH_ASYNC = "async", TAGNAMES_TO_SKIP_FOR_PSEUDOELEMENTS = ["HTML", "HEAD", "STYLE", "SCRIPT"], PRODUCTION$1 = (() => {
  try {
    return "production" === process.env.NODE_ENV;
  } catch (t4) {
    return false;
  }
})();
function familyProxy(t4) {
  return new Proxy(t4, { get: (t5, e) => e in t5 ? t5[e] : t5[s] });
}
const _PREFIX_TO_STYLE = _objectSpread2({}, S);
_PREFIX_TO_STYLE[s] = _objectSpread2(_objectSpread2(_objectSpread2(_objectSpread2({}, { "fa-duotone": "duotone" }), S[s]), St.kit), St["kit-duotone"]);
const PREFIX_TO_STYLE = familyProxy(_PREFIX_TO_STYLE), _STYLE_TO_PREFIX = _objectSpread2({}, xt);
_STYLE_TO_PREFIX[s] = _objectSpread2(_objectSpread2(_objectSpread2(_objectSpread2({}, { duotone: "fad" }), _STYLE_TO_PREFIX[s]), Et.kit), Et["kit-duotone"]);
const STYLE_TO_PREFIX = familyProxy(_STYLE_TO_PREFIX), _PREFIX_TO_LONG_STYLE = _objectSpread2({}, co);
_PREFIX_TO_LONG_STYLE[s] = _objectSpread2(_objectSpread2({}, _PREFIX_TO_LONG_STYLE[s]), Wt.kit);
const PREFIX_TO_LONG_STYLE = familyProxy(_PREFIX_TO_LONG_STYLE), _LONG_STYLE_TO_PREFIX = _objectSpread2({}, po);
_LONG_STYLE_TO_PREFIX[s] = _objectSpread2(_objectSpread2({}, _LONG_STYLE_TO_PREFIX[s]), Ct.kit), familyProxy(_LONG_STYLE_TO_PREFIX);
const ICON_SELECTION_SYNTAX_PATTERN = p, LAYERS_TEXT_CLASSNAME = "fa-layers-text", FONT_FAMILY_PATTERN = g, _FONT_WEIGHT_TO_PREFIX = _objectSpread2({}, G);
familyProxy(_FONT_WEIGHT_TO_PREFIX);
const ATTRIBUTES_WATCHED_FOR_MUTATION = ["class", "data-prefix", "data-icon", "data-fa-transform", "data-fa-mask"], DUOTONE_CLASSES = A, RESERVED_CLASSES = [...At, ...Fo], initial = WINDOW.FontAwesomeConfig || {};
function getAttrConfig(t4) {
  var e = DOCUMENT.querySelector("script[" + t4 + "]");
  if (e) return e.getAttribute(t4);
}
function coerce(t4) {
  return "" === t4 || "false" !== t4 && ("true" === t4 || t4);
}
if (DOCUMENT && "function" == typeof DOCUMENT.querySelector) {
  const t4 = [["data-family-prefix", "familyPrefix"], ["data-css-prefix", "cssPrefix"], ["data-family-default", "familyDefault"], ["data-style-default", "styleDefault"], ["data-replacement-class", "replacementClass"], ["data-auto-replace-svg", "autoReplaceSvg"], ["data-auto-add-css", "autoAddCss"], ["data-auto-a11y", "autoA11y"], ["data-search-pseudo-elements", "searchPseudoElements"], ["data-observe-mutations", "observeMutations"], ["data-mutate-approach", "mutateApproach"], ["data-keep-original-source", "keepOriginalSource"], ["data-measure-performance", "measurePerformance"], ["data-show-missing-icons", "showMissingIcons"]];
  t4.forEach((t5) => {
    let [e, n] = t5;
    const o2 = coerce(getAttrConfig(e));
    null != o2 && (initial[n] = o2);
  });
}
const _default = { styleDefault: "solid", familyDefault: s, cssPrefix: DEFAULT_CSS_PREFIX, replacementClass: DEFAULT_REPLACEMENT_CLASS, autoReplaceSvg: true, autoAddCss: true, autoA11y: true, searchPseudoElements: false, observeMutations: true, mutateApproach: "async", keepOriginalSource: true, measurePerformance: false, showMissingIcons: true };
initial.familyPrefix && (initial.cssPrefix = initial.familyPrefix);
const _config = _objectSpread2(_objectSpread2({}, _default), initial);
_config.autoReplaceSvg || (_config.observeMutations = false);
const config = {};
Object.keys(_default).forEach((t4) => {
  Object.defineProperty(config, t4, { enumerable: true, set: function(e) {
    _config[t4] = e, _onChangeCb.forEach((t5) => t5(config));
  }, get: function() {
    return _config[t4];
  } });
}), Object.defineProperty(config, "familyPrefix", { enumerable: true, set: function(t4) {
  _config.cssPrefix = t4, _onChangeCb.forEach((t5) => t5(config));
}, get: function() {
  return _config.cssPrefix;
} }), WINDOW.FontAwesomeConfig = config;
const _onChangeCb = [];
function onChange(t4) {
  return _onChangeCb.push(t4), () => {
    _onChangeCb.splice(_onChangeCb.indexOf(t4), 1);
  };
}
const d$2 = UNITS_IN_GRID, meaninglessTransform = { size: 16, x: 0, y: 0, rotate: 0, flipX: false, flipY: false };
function insertCss(t4) {
  if (!t4 || !IS_DOM) return;
  const e = DOCUMENT.createElement("style");
  e.setAttribute("type", "text/css"), e.innerHTML = t4;
  const n = DOCUMENT.head.childNodes;
  let o2 = null;
  for (let t5 = n.length - 1; t5 > -1; t5--) {
    const e2 = n[t5], i = (e2.tagName || "").toUpperCase();
    ["STYLE", "LINK"].indexOf(i) > -1 && (o2 = e2);
  }
  return DOCUMENT.head.insertBefore(e, o2), t4;
}
const idPool = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
function nextUniqueId() {
  let t4 = 12, e = "";
  for (; t4-- > 0; ) e += idPool[62 * Math.random() | 0];
  return e;
}
function toArray(t4) {
  const e = [];
  for (let n = (t4 || []).length >>> 0; n--; ) e[n] = t4[n];
  return e;
}
function classArray(t4) {
  return t4.classList ? toArray(t4.classList) : (t4.getAttribute("class") || "").split(" ").filter((t5) => t5);
}
function htmlEscape(t4) {
  return "".concat(t4).replace(/&/g, "&amp;").replace(/"/g, "&quot;").replace(/'/g, "&#39;").replace(/</g, "&lt;").replace(/>/g, "&gt;");
}
function joinAttributes(t4) {
  return Object.keys(t4 || {}).reduce((e, n) => e + "".concat(n, '="').concat(htmlEscape(t4[n]), '" '), "").trim();
}
function joinStyles(t4) {
  return Object.keys(t4 || {}).reduce((e, n) => e + "".concat(n, ": ").concat(t4[n].trim(), ";"), "");
}
function transformIsMeaningful(t4) {
  return t4.size !== meaninglessTransform.size || t4.x !== meaninglessTransform.x || t4.y !== meaninglessTransform.y || t4.rotate !== meaninglessTransform.rotate || t4.flipX || t4.flipY;
}
function transformForSvg(t4) {
  let { transform: e, containerWidth: n, iconWidth: o2 } = t4;
  const i = { transform: "translate(".concat(n / 2, " 256)") }, a = "translate(".concat(32 * e.x, ", ").concat(32 * e.y, ") "), r2 = "scale(".concat(e.size / 16 * (e.flipX ? -1 : 1), ", ").concat(e.size / 16 * (e.flipY ? -1 : 1), ") "), s2 = "rotate(".concat(e.rotate, " 0 0)");
  return { outer: i, inner: { transform: "".concat(a, " ").concat(r2, " ").concat(s2) }, path: { transform: "translate(".concat(o2 / 2 * -1, " -256)") } };
}
function transformForCss(t4) {
  let { transform: e, width: n = UNITS_IN_GRID, height: o2 = UNITS_IN_GRID, startCentered: i = false } = t4, a = "";
  return a += i && IS_IE ? "translate(".concat(e.x / d$2 - n / 2, "em, ").concat(e.y / d$2 - o2 / 2, "em) ") : i ? "translate(calc(-50% + ".concat(e.x / d$2, "em), calc(-50% + ").concat(e.y / d$2, "em)) ") : "translate(".concat(e.x / d$2, "em, ").concat(e.y / d$2, "em) "), a += "scale(".concat(e.size / d$2 * (e.flipX ? -1 : 1), ", ").concat(e.size / d$2 * (e.flipY ? -1 : 1), ") "), a += "rotate(".concat(e.rotate, "deg) "), a;
}
var baseStyles = ':root, :host {\n  --fa-font-solid: normal 900 1em/1 "Font Awesome 6 Free";\n  --fa-font-regular: normal 400 1em/1 "Font Awesome 6 Free";\n  --fa-font-light: normal 300 1em/1 "Font Awesome 6 Pro";\n  --fa-font-thin: normal 100 1em/1 "Font Awesome 6 Pro";\n  --fa-font-duotone: normal 900 1em/1 "Font Awesome 6 Duotone";\n  --fa-font-duotone-regular: normal 400 1em/1 "Font Awesome 6 Duotone";\n  --fa-font-duotone-light: normal 300 1em/1 "Font Awesome 6 Duotone";\n  --fa-font-duotone-thin: normal 100 1em/1 "Font Awesome 6 Duotone";\n  --fa-font-brands: normal 400 1em/1 "Font Awesome 6 Brands";\n  --fa-font-sharp-solid: normal 900 1em/1 "Font Awesome 6 Sharp";\n  --fa-font-sharp-regular: normal 400 1em/1 "Font Awesome 6 Sharp";\n  --fa-font-sharp-light: normal 300 1em/1 "Font Awesome 6 Sharp";\n  --fa-font-sharp-thin: normal 100 1em/1 "Font Awesome 6 Sharp";\n  --fa-font-sharp-duotone-solid: normal 900 1em/1 "Font Awesome 6 Sharp Duotone";\n  --fa-font-sharp-duotone-regular: normal 400 1em/1 "Font Awesome 6 Sharp Duotone";\n  --fa-font-sharp-duotone-light: normal 300 1em/1 "Font Awesome 6 Sharp Duotone";\n  --fa-font-sharp-duotone-thin: normal 100 1em/1 "Font Awesome 6 Sharp Duotone";\n}\n\nsvg:not(:root).svg-inline--fa, svg:not(:host).svg-inline--fa {\n  overflow: visible;\n  box-sizing: content-box;\n}\n\n.svg-inline--fa {\n  display: var(--fa-display, inline-block);\n  height: 1em;\n  overflow: visible;\n  vertical-align: -0.125em;\n}\n.svg-inline--fa.fa-2xs {\n  vertical-align: 0.1em;\n}\n.svg-inline--fa.fa-xs {\n  vertical-align: 0em;\n}\n.svg-inline--fa.fa-sm {\n  vertical-align: -0.0714285705em;\n}\n.svg-inline--fa.fa-lg {\n  vertical-align: -0.2em;\n}\n.svg-inline--fa.fa-xl {\n  vertical-align: -0.25em;\n}\n.svg-inline--fa.fa-2xl {\n  vertical-align: -0.3125em;\n}\n.svg-inline--fa.fa-pull-left {\n  margin-right: var(--fa-pull-margin, 0.3em);\n  width: auto;\n}\n.svg-inline--fa.fa-pull-right {\n  margin-left: var(--fa-pull-margin, 0.3em);\n  width: auto;\n}\n.svg-inline--fa.fa-li {\n  width: var(--fa-li-width, 2em);\n  top: 0.25em;\n}\n.svg-inline--fa.fa-fw {\n  width: var(--fa-fw-width, 1.25em);\n}\n\n.fa-layers svg.svg-inline--fa {\n  bottom: 0;\n  left: 0;\n  margin: auto;\n  position: absolute;\n  right: 0;\n  top: 0;\n}\n\n.fa-layers-counter, .fa-layers-text {\n  display: inline-block;\n  position: absolute;\n  text-align: center;\n}\n\n.fa-layers {\n  display: inline-block;\n  height: 1em;\n  position: relative;\n  text-align: center;\n  vertical-align: -0.125em;\n  width: 1em;\n}\n.fa-layers svg.svg-inline--fa {\n  transform-origin: center center;\n}\n\n.fa-layers-text {\n  left: 50%;\n  top: 50%;\n  transform: translate(-50%, -50%);\n  transform-origin: center center;\n}\n\n.fa-layers-counter {\n  background-color: var(--fa-counter-background-color, #ff253a);\n  border-radius: var(--fa-counter-border-radius, 1em);\n  box-sizing: border-box;\n  color: var(--fa-inverse, #fff);\n  line-height: var(--fa-counter-line-height, 1);\n  max-width: var(--fa-counter-max-width, 5em);\n  min-width: var(--fa-counter-min-width, 1.5em);\n  overflow: hidden;\n  padding: var(--fa-counter-padding, 0.25em 0.5em);\n  right: var(--fa-right, 0);\n  text-overflow: ellipsis;\n  top: var(--fa-top, 0);\n  transform: scale(var(--fa-counter-scale, 0.25));\n  transform-origin: top right;\n}\n\n.fa-layers-bottom-right {\n  bottom: var(--fa-bottom, 0);\n  right: var(--fa-right, 0);\n  top: auto;\n  transform: scale(var(--fa-layers-scale, 0.25));\n  transform-origin: bottom right;\n}\n\n.fa-layers-bottom-left {\n  bottom: var(--fa-bottom, 0);\n  left: var(--fa-left, 0);\n  right: auto;\n  top: auto;\n  transform: scale(var(--fa-layers-scale, 0.25));\n  transform-origin: bottom left;\n}\n\n.fa-layers-top-right {\n  top: var(--fa-top, 0);\n  right: var(--fa-right, 0);\n  transform: scale(var(--fa-layers-scale, 0.25));\n  transform-origin: top right;\n}\n\n.fa-layers-top-left {\n  left: var(--fa-left, 0);\n  right: auto;\n  top: var(--fa-top, 0);\n  transform: scale(var(--fa-layers-scale, 0.25));\n  transform-origin: top left;\n}\n\n.fa-1x {\n  font-size: 1em;\n}\n\n.fa-2x {\n  font-size: 2em;\n}\n\n.fa-3x {\n  font-size: 3em;\n}\n\n.fa-4x {\n  font-size: 4em;\n}\n\n.fa-5x {\n  font-size: 5em;\n}\n\n.fa-6x {\n  font-size: 6em;\n}\n\n.fa-7x {\n  font-size: 7em;\n}\n\n.fa-8x {\n  font-size: 8em;\n}\n\n.fa-9x {\n  font-size: 9em;\n}\n\n.fa-10x {\n  font-size: 10em;\n}\n\n.fa-2xs {\n  font-size: 0.625em;\n  line-height: 0.1em;\n  vertical-align: 0.225em;\n}\n\n.fa-xs {\n  font-size: 0.75em;\n  line-height: 0.0833333337em;\n  vertical-align: 0.125em;\n}\n\n.fa-sm {\n  font-size: 0.875em;\n  line-height: 0.0714285718em;\n  vertical-align: 0.0535714295em;\n}\n\n.fa-lg {\n  font-size: 1.25em;\n  line-height: 0.05em;\n  vertical-align: -0.075em;\n}\n\n.fa-xl {\n  font-size: 1.5em;\n  line-height: 0.0416666682em;\n  vertical-align: -0.125em;\n}\n\n.fa-2xl {\n  font-size: 2em;\n  line-height: 0.03125em;\n  vertical-align: -0.1875em;\n}\n\n.fa-fw {\n  text-align: center;\n  width: 1.25em;\n}\n\n.fa-ul {\n  list-style-type: none;\n  margin-left: var(--fa-li-margin, 2.5em);\n  padding-left: 0;\n}\n.fa-ul > li {\n  position: relative;\n}\n\n.fa-li {\n  left: calc(-1 * var(--fa-li-width, 2em));\n  position: absolute;\n  text-align: center;\n  width: var(--fa-li-width, 2em);\n  line-height: inherit;\n}\n\n.fa-border {\n  border-color: var(--fa-border-color, #eee);\n  border-radius: var(--fa-border-radius, 0.1em);\n  border-style: var(--fa-border-style, solid);\n  border-width: var(--fa-border-width, 0.08em);\n  padding: var(--fa-border-padding, 0.2em 0.25em 0.15em);\n}\n\n.fa-pull-left {\n  float: left;\n  margin-right: var(--fa-pull-margin, 0.3em);\n}\n\n.fa-pull-right {\n  float: right;\n  margin-left: var(--fa-pull-margin, 0.3em);\n}\n\n.fa-beat {\n  animation-name: fa-beat;\n  animation-delay: var(--fa-animation-delay, 0s);\n  animation-direction: var(--fa-animation-direction, normal);\n  animation-duration: var(--fa-animation-duration, 1s);\n  animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n  animation-timing-function: var(--fa-animation-timing, ease-in-out);\n}\n\n.fa-bounce {\n  animation-name: fa-bounce;\n  animation-delay: var(--fa-animation-delay, 0s);\n  animation-direction: var(--fa-animation-direction, normal);\n  animation-duration: var(--fa-animation-duration, 1s);\n  animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n  animation-timing-function: var(--fa-animation-timing, cubic-bezier(0.28, 0.84, 0.42, 1));\n}\n\n.fa-fade {\n  animation-name: fa-fade;\n  animation-delay: var(--fa-animation-delay, 0s);\n  animation-direction: var(--fa-animation-direction, normal);\n  animation-duration: var(--fa-animation-duration, 1s);\n  animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n  animation-timing-function: var(--fa-animation-timing, cubic-bezier(0.4, 0, 0.6, 1));\n}\n\n.fa-beat-fade {\n  animation-name: fa-beat-fade;\n  animation-delay: var(--fa-animation-delay, 0s);\n  animation-direction: var(--fa-animation-direction, normal);\n  animation-duration: var(--fa-animation-duration, 1s);\n  animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n  animation-timing-function: var(--fa-animation-timing, cubic-bezier(0.4, 0, 0.6, 1));\n}\n\n.fa-flip {\n  animation-name: fa-flip;\n  animation-delay: var(--fa-animation-delay, 0s);\n  animation-direction: var(--fa-animation-direction, normal);\n  animation-duration: var(--fa-animation-duration, 1s);\n  animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n  animation-timing-function: var(--fa-animation-timing, ease-in-out);\n}\n\n.fa-shake {\n  animation-name: fa-shake;\n  animation-delay: var(--fa-animation-delay, 0s);\n  animation-direction: var(--fa-animation-direction, normal);\n  animation-duration: var(--fa-animation-duration, 1s);\n  animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n  animation-timing-function: var(--fa-animation-timing, linear);\n}\n\n.fa-spin {\n  animation-name: fa-spin;\n  animation-delay: var(--fa-animation-delay, 0s);\n  animation-direction: var(--fa-animation-direction, normal);\n  animation-duration: var(--fa-animation-duration, 2s);\n  animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n  animation-timing-function: var(--fa-animation-timing, linear);\n}\n\n.fa-spin-reverse {\n  --fa-animation-direction: reverse;\n}\n\n.fa-pulse,\n.fa-spin-pulse {\n  animation-name: fa-spin;\n  animation-direction: var(--fa-animation-direction, normal);\n  animation-duration: var(--fa-animation-duration, 1s);\n  animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n  animation-timing-function: var(--fa-animation-timing, steps(8));\n}\n\n@media (prefers-reduced-motion: reduce) {\n  .fa-beat,\n.fa-bounce,\n.fa-fade,\n.fa-beat-fade,\n.fa-flip,\n.fa-pulse,\n.fa-shake,\n.fa-spin,\n.fa-spin-pulse {\n    animation-delay: -1ms;\n    animation-duration: 1ms;\n    animation-iteration-count: 1;\n    transition-delay: 0s;\n    transition-duration: 0s;\n  }\n}\n@keyframes fa-beat {\n  0%, 90% {\n    transform: scale(1);\n  }\n  45% {\n    transform: scale(var(--fa-beat-scale, 1.25));\n  }\n}\n@keyframes fa-bounce {\n  0% {\n    transform: scale(1, 1) translateY(0);\n  }\n  10% {\n    transform: scale(var(--fa-bounce-start-scale-x, 1.1), var(--fa-bounce-start-scale-y, 0.9)) translateY(0);\n  }\n  30% {\n    transform: scale(var(--fa-bounce-jump-scale-x, 0.9), var(--fa-bounce-jump-scale-y, 1.1)) translateY(var(--fa-bounce-height, -0.5em));\n  }\n  50% {\n    transform: scale(var(--fa-bounce-land-scale-x, 1.05), var(--fa-bounce-land-scale-y, 0.95)) translateY(0);\n  }\n  57% {\n    transform: scale(1, 1) translateY(var(--fa-bounce-rebound, -0.125em));\n  }\n  64% {\n    transform: scale(1, 1) translateY(0);\n  }\n  100% {\n    transform: scale(1, 1) translateY(0);\n  }\n}\n@keyframes fa-fade {\n  50% {\n    opacity: var(--fa-fade-opacity, 0.4);\n  }\n}\n@keyframes fa-beat-fade {\n  0%, 100% {\n    opacity: var(--fa-beat-fade-opacity, 0.4);\n    transform: scale(1);\n  }\n  50% {\n    opacity: 1;\n    transform: scale(var(--fa-beat-fade-scale, 1.125));\n  }\n}\n@keyframes fa-flip {\n  50% {\n    transform: rotate3d(var(--fa-flip-x, 0), var(--fa-flip-y, 1), var(--fa-flip-z, 0), var(--fa-flip-angle, -180deg));\n  }\n}\n@keyframes fa-shake {\n  0% {\n    transform: rotate(-15deg);\n  }\n  4% {\n    transform: rotate(15deg);\n  }\n  8%, 24% {\n    transform: rotate(-18deg);\n  }\n  12%, 28% {\n    transform: rotate(18deg);\n  }\n  16% {\n    transform: rotate(-22deg);\n  }\n  20% {\n    transform: rotate(22deg);\n  }\n  32% {\n    transform: rotate(-12deg);\n  }\n  36% {\n    transform: rotate(12deg);\n  }\n  40%, 100% {\n    transform: rotate(0deg);\n  }\n}\n@keyframes fa-spin {\n  0% {\n    transform: rotate(0deg);\n  }\n  100% {\n    transform: rotate(360deg);\n  }\n}\n.fa-rotate-90 {\n  transform: rotate(90deg);\n}\n\n.fa-rotate-180 {\n  transform: rotate(180deg);\n}\n\n.fa-rotate-270 {\n  transform: rotate(270deg);\n}\n\n.fa-flip-horizontal {\n  transform: scale(-1, 1);\n}\n\n.fa-flip-vertical {\n  transform: scale(1, -1);\n}\n\n.fa-flip-both,\n.fa-flip-horizontal.fa-flip-vertical {\n  transform: scale(-1, -1);\n}\n\n.fa-rotate-by {\n  transform: rotate(var(--fa-rotate-angle, 0));\n}\n\n.fa-stack {\n  display: inline-block;\n  vertical-align: middle;\n  height: 2em;\n  position: relative;\n  width: 2.5em;\n}\n\n.fa-stack-1x,\n.fa-stack-2x {\n  bottom: 0;\n  left: 0;\n  margin: auto;\n  position: absolute;\n  right: 0;\n  top: 0;\n  z-index: var(--fa-stack-z-index, auto);\n}\n\n.svg-inline--fa.fa-stack-1x {\n  height: 1em;\n  width: 1.25em;\n}\n.svg-inline--fa.fa-stack-2x {\n  height: 2em;\n  width: 2.5em;\n}\n\n.fa-inverse {\n  color: var(--fa-inverse, #fff);\n}\n\n.sr-only,\n.fa-sr-only {\n  position: absolute;\n  width: 1px;\n  height: 1px;\n  padding: 0;\n  margin: -1px;\n  overflow: hidden;\n  clip: rect(0, 0, 0, 0);\n  white-space: nowrap;\n  border-width: 0;\n}\n\n.sr-only-focusable:not(:focus),\n.fa-sr-only-focusable:not(:focus) {\n  position: absolute;\n  width: 1px;\n  height: 1px;\n  padding: 0;\n  margin: -1px;\n  overflow: hidden;\n  clip: rect(0, 0, 0, 0);\n  white-space: nowrap;\n  border-width: 0;\n}\n\n.svg-inline--fa .fa-primary {\n  fill: var(--fa-primary-color, currentColor);\n  opacity: var(--fa-primary-opacity, 1);\n}\n\n.svg-inline--fa .fa-secondary {\n  fill: var(--fa-secondary-color, currentColor);\n  opacity: var(--fa-secondary-opacity, 0.4);\n}\n\n.svg-inline--fa.fa-swap-opacity .fa-primary {\n  opacity: var(--fa-secondary-opacity, 0.4);\n}\n\n.svg-inline--fa.fa-swap-opacity .fa-secondary {\n  opacity: var(--fa-primary-opacity, 1);\n}\n\n.svg-inline--fa mask .fa-primary,\n.svg-inline--fa mask .fa-secondary {\n  fill: black;\n}';
function css() {
  const t4 = DEFAULT_CSS_PREFIX, e = DEFAULT_REPLACEMENT_CLASS, n = config.cssPrefix, o2 = config.replacementClass;
  let i = baseStyles;
  if (n !== t4 || o2 !== e) {
    const a = new RegExp("\\.".concat(t4, "\\-"), "g"), r2 = new RegExp("\\--".concat(t4, "\\-"), "g"), s2 = new RegExp("\\.".concat(e), "g");
    i = i.replace(a, ".".concat(n, "-")).replace(r2, "--".concat(n, "-")).replace(s2, ".".concat(o2));
  }
  return i;
}
let _cssInserted = false;
function ensureCss() {
  config.autoAddCss && !_cssInserted && (insertCss(css()), _cssInserted = true);
}
var InjectCSS = { mixout: () => ({ dom: { css, insertCss: ensureCss } }), hooks: () => ({ beforeDOMElementCreation() {
  ensureCss();
}, beforeI2svg() {
  ensureCss();
} }) };
const w = WINDOW || {};
w[NAMESPACE_IDENTIFIER] || (w[NAMESPACE_IDENTIFIER] = {}), w[NAMESPACE_IDENTIFIER].styles || (w[NAMESPACE_IDENTIFIER].styles = {}), w[NAMESPACE_IDENTIFIER].hooks || (w[NAMESPACE_IDENTIFIER].hooks = {}), w[NAMESPACE_IDENTIFIER].shims || (w[NAMESPACE_IDENTIFIER].shims = []);
var namespace = w[NAMESPACE_IDENTIFIER];
const functions = [], listener = function() {
  DOCUMENT.removeEventListener("DOMContentLoaded", listener), loaded = 1, functions.map((t4) => t4());
};
let loaded = false;
function domready(t4) {
  IS_DOM && (loaded ? setTimeout(t4, 0) : functions.push(t4));
}
function toHtml(t4) {
  const { tag: e, attributes: n = {}, children: o2 = [] } = t4;
  return "string" == typeof t4 ? htmlEscape(t4) : "<".concat(e, " ").concat(joinAttributes(n), ">").concat(o2.map(toHtml).join(""), "</").concat(e, ">");
}
function iconFromMapping(t4, e, n) {
  if (t4 && t4[e] && t4[e][n]) return { prefix: e, iconName: n, icon: t4[e][n] };
}
IS_DOM && (loaded = (DOCUMENT.documentElement.doScroll ? /^loaded|^c/ : /^loaded|^i|^c/).test(DOCUMENT.readyState), loaded || DOCUMENT.addEventListener("DOMContentLoaded", listener));
var reduce = function(t4, e, n, o2) {
  var i, a, r2, s2 = Object.keys(t4), c = s2.length, l = e;
  for (void 0 === n ? (i = 1, r2 = t4[s2[0]]) : (i = 0, r2 = n); i < c; i++) r2 = l(r2, t4[a = s2[i]], a, t4);
  return r2;
};
function ucs2decode(t4) {
  const e = [];
  let n = 0;
  const o2 = t4.length;
  for (; n < o2; ) {
    const i = t4.charCodeAt(n++);
    if (i >= 55296 && i <= 56319 && n < o2) {
      const o3 = t4.charCodeAt(n++);
      56320 == (64512 & o3) ? e.push(((1023 & i) << 10) + (1023 & o3) + 65536) : (e.push(i), n--);
    } else e.push(i);
  }
  return e;
}
function toHex(t4) {
  const e = ucs2decode(t4);
  return 1 === e.length ? e[0].toString(16) : null;
}
function codePointAt(t4, e) {
  const n = t4.length;
  let o2, i = t4.charCodeAt(e);
  return i >= 55296 && i <= 56319 && n > e + 1 && (o2 = t4.charCodeAt(e + 1), o2 >= 56320 && o2 <= 57343) ? 1024 * (i - 55296) + o2 - 56320 + 65536 : i;
}
function normalizeIcons(t4) {
  return Object.keys(t4).reduce((e, n) => {
    const o2 = t4[n];
    return !!o2.icon ? e[o2.iconName] = o2.icon : e[n] = o2, e;
  }, {});
}
function defineIcons(t4, e) {
  let n = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {};
  const { skipHooks: o2 = false } = n, i = normalizeIcons(e);
  "function" != typeof namespace.hooks.addPack || o2 ? namespace.styles[t4] = _objectSpread2(_objectSpread2({}, namespace.styles[t4] || {}), i) : namespace.hooks.addPack(t4, normalizeIcons(e)), "fas" === t4 && defineIcons("fa", e);
}
const { styles, shims } = namespace, FAMILY_NAMES = Object.keys(PREFIX_TO_LONG_STYLE), PREFIXES_FOR_FAMILY = FAMILY_NAMES.reduce((t4, e) => (t4[e] = Object.keys(PREFIX_TO_LONG_STYLE[e]), t4), {});
let _defaultUsablePrefix = null, _byUnicode = {}, _byLigature = {}, _byOldName = {}, _byOldUnicode = {}, _byAlias = {};
function isReserved(t4) {
  return ~RESERVED_CLASSES.indexOf(t4);
}
function getIconName(t4, e) {
  const n = e.split("-"), o2 = n[0], i = n.slice(1).join("-");
  return o2 !== t4 || "" === i || isReserved(i) ? null : i;
}
const build = () => {
  const t4 = (t5) => reduce(styles, (e2, n2, o2) => (e2[o2] = reduce(n2, t5, {}), e2), {});
  _byUnicode = t4((t5, e2, n2) => {
    if (e2[3] && (t5[e2[3]] = n2), e2[2]) {
      e2[2].filter((t6) => "number" == typeof t6).forEach((e3) => {
        t5[e3.toString(16)] = n2;
      });
    }
    return t5;
  }), _byLigature = t4((t5, e2, n2) => {
    if (t5[n2] = n2, e2[2]) {
      e2[2].filter((t6) => "string" == typeof t6).forEach((e3) => {
        t5[e3] = n2;
      });
    }
    return t5;
  }), _byAlias = t4((t5, e2, n2) => {
    const o2 = e2[2];
    return t5[n2] = n2, o2.forEach((e3) => {
      t5[e3] = n2;
    }), t5;
  });
  const e = "far" in styles || config.autoFetchSvg, n = reduce(shims, (t5, n2) => {
    const o2 = n2[0];
    let i = n2[1];
    const a = n2[2];
    return "far" !== i || e || (i = "fas"), "string" == typeof o2 && (t5.names[o2] = { prefix: i, iconName: a }), "number" == typeof o2 && (t5.unicodes[o2.toString(16)] = { prefix: i, iconName: a }), t5;
  }, { names: {}, unicodes: {} });
  _byOldName = n.names, _byOldUnicode = n.unicodes, _defaultUsablePrefix = getCanonicalPrefix(config.styleDefault, { family: config.familyDefault });
};
function byUnicode(t4, e) {
  return (_byUnicode[t4] || {})[e];
}
function byLigature(t4, e) {
  return (_byLigature[t4] || {})[e];
}
function byAlias(t4, e) {
  return (_byAlias[t4] || {})[e];
}
function byOldName(t4) {
  return _byOldName[t4] || { prefix: null, iconName: null };
}
function byOldUnicode(t4) {
  const e = _byOldUnicode[t4], n = byUnicode("fas", t4);
  return e || (n ? { prefix: "fas", iconName: n } : null) || { prefix: null, iconName: null };
}
function getDefaultUsablePrefix() {
  return _defaultUsablePrefix;
}
onChange((t4) => {
  _defaultUsablePrefix = getCanonicalPrefix(t4.styleDefault, { family: config.familyDefault });
}), build();
const emptyCanonicalIcon = () => ({ prefix: null, iconName: null, rest: [] });
function getFamilyId(t4) {
  let e = s;
  const n = FAMILY_NAMES.reduce((t5, e2) => (t5[e2] = "".concat(config.cssPrefix, "-").concat(e2), t5), {});
  return L.forEach((o2) => {
    (t4.includes(n[o2]) || t4.some((t5) => PREFIXES_FOR_FAMILY[o2].includes(t5))) && (e = o2);
  }), e;
}
function getCanonicalPrefix(e) {
  let n = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {};
  const { family: o2 = s } = n, i = PREFIX_TO_STYLE[o2][e];
  if (o2 === t && !e) return "fad";
  const a = STYLE_TO_PREFIX[o2][e] || STYLE_TO_PREFIX[o2][i], r2 = e in namespace.styles ? e : null;
  return a || r2 || null;
}
function moveNonFaClassesToRest(t4) {
  let e = [], n = null;
  return t4.forEach((t5) => {
    const o2 = getIconName(config.cssPrefix, t5);
    o2 ? n = o2 : t5 && e.push(t5);
  }), { iconName: n, rest: e };
}
function sortedUniqueValues(t4) {
  return t4.sort().filter((t5, e, n) => n.indexOf(t5) === e);
}
function getCanonicalIcon(t4) {
  let e = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {};
  const { skipLookups: n = false } = e;
  let o2 = null;
  const i = xo.concat(bt$1), a = sortedUniqueValues(t4.filter((t5) => i.includes(t5))), r2 = sortedUniqueValues(t4.filter((t5) => !xo.includes(t5))), s2 = a.filter((t5) => (o2 = t5, !P.includes(t5))), [c = null] = s2, l = getFamilyId(a), u = _objectSpread2(_objectSpread2({}, moveNonFaClassesToRest(r2)), {}, { prefix: getCanonicalPrefix(c, { family: l }) });
  return _objectSpread2(_objectSpread2(_objectSpread2({}, u), getDefaultCanonicalPrefix({ values: t4, family: l, styles, config, canonical: u, givenPrefix: o2 })), applyShimAndAlias(n, o2, u));
}
function applyShimAndAlias(t4, e, n) {
  let { prefix: o2, iconName: i } = n;
  if (t4 || !o2 || !i) return { prefix: o2, iconName: i };
  const a = "fa" === e ? byOldName(i) : {}, r2 = byAlias(o2, i);
  return i = a.iconName || r2 || i, o2 = a.prefix || o2, "far" !== o2 || styles.far || !styles.fas || config.autoFetchSvg || (o2 = "fas"), { prefix: o2, iconName: i };
}
const newCanonicalFamilies = L.filter((e) => e !== s || e !== t), newCanonicalStyles = Object.keys(co).filter((t4) => t4 !== s).map((t4) => Object.keys(co[t4])).flat();
function getDefaultCanonicalPrefix(e) {
  const { values: n, family: o2, canonical: i, givenPrefix: a = "", styles: r2 = {}, config: s2 = {} } = e, c = o2 === t, l = n.includes("fa-duotone") || n.includes("fad"), u = "duotone" === s2.familyDefault, p2 = "fad" === i.prefix || "fa-duotone" === i.prefix;
  if (!c && (l || u || p2) && (i.prefix = "fad"), (n.includes("fa-brands") || n.includes("fab")) && (i.prefix = "fab"), !i.prefix && newCanonicalFamilies.includes(o2)) {
    if (Object.keys(r2).find((t4) => newCanonicalStyles.includes(t4)) || s2.autoFetchSvg) {
      const t4 = pt.get(o2).defaultShortPrefixId;
      i.prefix = t4, i.iconName = byAlias(i.prefix, i.iconName) || i.iconName;
    }
  }
  return "fa" !== i.prefix && "fa" !== a || (i.prefix = getDefaultUsablePrefix() || "fas"), i;
}
class Library {
  constructor() {
    this.definitions = {};
  }
  add() {
    for (var t4 = arguments.length, e = new Array(t4), n = 0; n < t4; n++) e[n] = arguments[n];
    const o2 = e.reduce(this._pullDefinitions, {});
    Object.keys(o2).forEach((t5) => {
      this.definitions[t5] = _objectSpread2(_objectSpread2({}, this.definitions[t5] || {}), o2[t5]), defineIcons(t5, o2[t5]);
      const e2 = PREFIX_TO_LONG_STYLE[s][t5];
      e2 && defineIcons(e2, o2[t5]), build();
    });
  }
  reset() {
    this.definitions = {};
  }
  _pullDefinitions(t4, e) {
    const n = e.prefix && e.iconName && e.icon ? { 0: e } : e;
    return Object.keys(n).map((e2) => {
      const { prefix: o2, iconName: i, icon: a } = n[e2], r2 = a[2];
      t4[o2] || (t4[o2] = {}), r2.length > 0 && r2.forEach((e3) => {
        "string" == typeof e3 && (t4[o2][e3] = a);
      }), t4[o2][i] = a;
    }), t4;
  }
}
let _plugins = [], _hooks = {};
const providers = {}, defaultProviderKeys = Object.keys(providers);
function registerPlugins(t4, e) {
  let { mixoutsTo: n } = e;
  return _plugins = t4, _hooks = {}, Object.keys(providers).forEach((t5) => {
    -1 === defaultProviderKeys.indexOf(t5) && delete providers[t5];
  }), _plugins.forEach((t5) => {
    const e2 = t5.mixout ? t5.mixout() : {};
    if (Object.keys(e2).forEach((t6) => {
      "function" == typeof e2[t6] && (n[t6] = e2[t6]), "object" == typeof e2[t6] && Object.keys(e2[t6]).forEach((o2) => {
        n[t6] || (n[t6] = {}), n[t6][o2] = e2[t6][o2];
      });
    }), t5.hooks) {
      const e3 = t5.hooks();
      Object.keys(e3).forEach((t6) => {
        _hooks[t6] || (_hooks[t6] = []), _hooks[t6].push(e3[t6]);
      });
    }
    t5.provides && t5.provides(providers);
  }), n;
}
function chainHooks(t4, e) {
  for (var n = arguments.length, o2 = new Array(n > 2 ? n - 2 : 0), i = 2; i < n; i++) o2[i - 2] = arguments[i];
  return (_hooks[t4] || []).forEach((t5) => {
    e = t5.apply(null, [e, ...o2]);
  }), e;
}
function callHooks(t4) {
  for (var e = arguments.length, n = new Array(e > 1 ? e - 1 : 0), o2 = 1; o2 < e; o2++) n[o2 - 1] = arguments[o2];
  (_hooks[t4] || []).forEach((t5) => {
    t5.apply(null, n);
  });
}
function callProvided() {
  const t4 = arguments[0], e = Array.prototype.slice.call(arguments, 1);
  return providers[t4] ? providers[t4].apply(null, e) : void 0;
}
function findIconDefinition(t4) {
  "fa" === t4.prefix && (t4.prefix = "fas");
  let { iconName: e } = t4;
  const n = t4.prefix || getDefaultUsablePrefix();
  if (e) return e = byAlias(n, e) || e, iconFromMapping(library.definitions, n, e) || iconFromMapping(namespace.styles, n, e);
}
const library = new Library(), noAuto = () => {
  config.autoReplaceSvg = false, config.observeMutations = false, callHooks("noAuto");
}, dom = { i2svg: function() {
  let t4 = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : {};
  return IS_DOM ? (callHooks("beforeI2svg", t4), callProvided("pseudoElements2svg", t4), callProvided("i2svg", t4)) : Promise.reject(new Error("Operation requires a DOM of some kind."));
}, watch: function() {
  let t4 = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : {};
  const { autoReplaceSvgRoot: e } = t4;
  false === config.autoReplaceSvg && (config.autoReplaceSvg = true), config.observeMutations = true, domready(() => {
    autoReplace({ autoReplaceSvgRoot: e }), callHooks("watch", t4);
  });
} }, parse = { icon: (t4) => {
  if (null === t4) return null;
  if ("object" == typeof t4 && t4.prefix && t4.iconName) return { prefix: t4.prefix, iconName: byAlias(t4.prefix, t4.iconName) || t4.iconName };
  if (Array.isArray(t4) && 2 === t4.length) {
    const e = 0 === t4[1].indexOf("fa-") ? t4[1].slice(3) : t4[1], n = getCanonicalPrefix(t4[0]);
    return { prefix: n, iconName: byAlias(n, e) || e };
  }
  if ("string" == typeof t4 && (t4.indexOf("".concat(config.cssPrefix, "-")) > -1 || t4.match(ICON_SELECTION_SYNTAX_PATTERN))) {
    const e = getCanonicalIcon(t4.split(" "), { skipLookups: true });
    return { prefix: e.prefix || getDefaultUsablePrefix(), iconName: byAlias(e.prefix, e.iconName) || e.iconName };
  }
  if ("string" == typeof t4) {
    const e = getDefaultUsablePrefix();
    return { prefix: e, iconName: byAlias(e, t4) || t4 };
  }
} }, api = { noAuto, config, dom, parse, library, findIconDefinition, toHtml }, autoReplace = function() {
  let t4 = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : {};
  const { autoReplaceSvgRoot: e = DOCUMENT } = t4;
  (Object.keys(namespace.styles).length > 0 || config.autoFetchSvg) && IS_DOM && config.autoReplaceSvg && api.dom.i2svg({ node: e });
};
function domVariants(t4, e) {
  return Object.defineProperty(t4, "abstract", { get: e }), Object.defineProperty(t4, "html", { get: function() {
    return t4.abstract.map((t5) => toHtml(t5));
  } }), Object.defineProperty(t4, "node", { get: function() {
    if (!IS_DOM) return;
    const e2 = DOCUMENT.createElement("div");
    return e2.innerHTML = t4.html, e2.children;
  } }), t4;
}
function asIcon(t4) {
  let { children: e, main: n, mask: o2, attributes: i, styles: a, transform: r2 } = t4;
  if (transformIsMeaningful(r2) && n.found && !o2.found) {
    const { width: t5, height: e2 } = n, o3 = { x: t5 / e2 / 2, y: 0.5 };
    i.style = joinStyles(_objectSpread2(_objectSpread2({}, a), {}, { "transform-origin": "".concat(o3.x + r2.x / 16, "em ").concat(o3.y + r2.y / 16, "em") }));
  }
  return [{ tag: "svg", attributes: i, children: e }];
}
function asSymbol(t4) {
  let { prefix: e, iconName: n, children: o2, attributes: i, symbol: a } = t4;
  const r2 = true === a ? "".concat(e, "-").concat(config.cssPrefix, "-").concat(n) : a;
  return [{ tag: "svg", attributes: { style: "display: none;" }, children: [{ tag: "symbol", attributes: _objectSpread2(_objectSpread2({}, i), {}, { id: r2 }), children: o2 }] }];
}
function makeInlineSvgAbstract(t4) {
  const { icons: { main: e, mask: n }, prefix: o2, iconName: i, transform: a, symbol: r2, title: s2, maskId: c, titleId: l, extra: u, watchable: p2 = false } = t4, { width: d, height: m } = n.found ? n : e, f = Lt.includes(o2), _ = [config.replacementClass, i ? "".concat(config.cssPrefix, "-").concat(i) : ""].filter((t5) => -1 === u.classes.indexOf(t5)).filter((t5) => "" !== t5 || !!t5).concat(u.classes).join(" ");
  let h = { children: [], attributes: _objectSpread2(_objectSpread2({}, u.attributes), {}, { "data-prefix": o2, "data-icon": i, class: _, role: u.attributes.role || "img", xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 ".concat(d, " ").concat(m) }) };
  const g2 = f && !~u.classes.indexOf("fa-fw") ? { width: "".concat(d / m * 16 * 0.0625, "em") } : {};
  p2 && (h.attributes[DATA_FA_I2SVG] = ""), s2 && (h.children.push({ tag: "title", attributes: { id: h.attributes["aria-labelledby"] || "title-".concat(l || nextUniqueId()) }, children: [s2] }), delete h.attributes.title);
  const $2 = _objectSpread2(_objectSpread2({}, h), {}, { prefix: o2, iconName: i, main: e, mask: n, maskId: c, transform: a, symbol: r2, styles: _objectSpread2(_objectSpread2({}, g2), u.styles) }), { children: b, attributes: y } = n.found && e.found ? callProvided("generateAbstractMask", $2) || { children: [], attributes: {} } : callProvided("generateAbstractIcon", $2) || { children: [], attributes: {} };
  return $2.children = b, $2.attributes = y, r2 ? asSymbol($2) : asIcon($2);
}
function makeLayersTextAbstract(t4) {
  const { content: e, width: n, height: o2, transform: i, title: a, extra: r2, watchable: s2 = false } = t4, c = _objectSpread2(_objectSpread2(_objectSpread2({}, r2.attributes), a ? { title: a } : {}), {}, { class: r2.classes.join(" ") });
  s2 && (c[DATA_FA_I2SVG] = "");
  const l = _objectSpread2({}, r2.styles);
  transformIsMeaningful(i) && (l.transform = transformForCss({ transform: i, startCentered: true, width: n, height: o2 }), l["-webkit-transform"] = l.transform);
  const u = joinStyles(l);
  u.length > 0 && (c.style = u);
  const p2 = [];
  return p2.push({ tag: "span", attributes: c, children: [e] }), a && p2.push({ tag: "span", attributes: { class: "sr-only" }, children: [a] }), p2;
}
function makeLayersCounterAbstract(t4) {
  const { content: e, title: n, extra: o2 } = t4, i = _objectSpread2(_objectSpread2(_objectSpread2({}, o2.attributes), n ? { title: n } : {}), {}, { class: o2.classes.join(" ") }), a = joinStyles(o2.styles);
  a.length > 0 && (i.style = a);
  const r2 = [];
  return r2.push({ tag: "span", attributes: i, children: [e] }), n && r2.push({ tag: "span", attributes: { class: "sr-only" }, children: [n] }), r2;
}
const { styles: styles$1 } = namespace;
function asFoundIcon(t4) {
  const e = t4[0], n = t4[1], [o2] = t4.slice(4);
  let i = null;
  return i = Array.isArray(o2) ? { tag: "g", attributes: { class: "".concat(config.cssPrefix, "-").concat(DUOTONE_CLASSES.GROUP) }, children: [{ tag: "path", attributes: { class: "".concat(config.cssPrefix, "-").concat(DUOTONE_CLASSES.SECONDARY), fill: "currentColor", d: o2[0] } }, { tag: "path", attributes: { class: "".concat(config.cssPrefix, "-").concat(DUOTONE_CLASSES.PRIMARY), fill: "currentColor", d: o2[1] } }] } : { tag: "path", attributes: { fill: "currentColor", d: o2 } }, { found: true, width: e, height: n, icon: i };
}
const missingIconResolutionMixin = { found: false, width: 512, height: 512 };
function maybeNotifyMissing(t4, e) {
  PRODUCTION$1 || config.showMissingIcons || !t4 || console.error('Icon with name "'.concat(t4, '" and prefix "').concat(e, '" is missing.'));
}
function findIcon(t4, e) {
  let n = e;
  return "fa" === e && null !== config.styleDefault && (e = getDefaultUsablePrefix()), new Promise((o2, i) => {
    if ("fa" === n) {
      const n2 = byOldName(t4) || {};
      t4 = n2.iconName || t4, e = n2.prefix || e;
    }
    if (t4 && e && styles$1[e] && styles$1[e][t4]) {
      return o2(asFoundIcon(styles$1[e][t4]));
    }
    maybeNotifyMissing(t4, e), o2(_objectSpread2(_objectSpread2({}, missingIconResolutionMixin), {}, { icon: config.showMissingIcons && t4 && callProvided("missingIconAbstract") || {} }));
  });
}
const noop$1 = () => {
}, p$2 = config.measurePerformance && PERFORMANCE && PERFORMANCE.mark && PERFORMANCE.measure ? PERFORMANCE : { mark: noop$1, measure: noop$1 }, preamble = 'FA "6.7.1"', begin = (t4) => (p$2.mark("".concat(preamble, " ").concat(t4, " begins")), () => end(t4)), end = (t4) => {
  p$2.mark("".concat(preamble, " ").concat(t4, " ends")), p$2.measure("".concat(preamble, " ").concat(t4), "".concat(preamble, " ").concat(t4, " begins"), "".concat(preamble, " ").concat(t4, " ends"));
};
var perf = { begin, end };
const noop$2 = () => {
};
function isWatched(t4) {
  return "string" == typeof (t4.getAttribute ? t4.getAttribute(DATA_FA_I2SVG) : null);
}
function hasPrefixAndIcon(t4) {
  const e = t4.getAttribute ? t4.getAttribute(DATA_PREFIX) : null, n = t4.getAttribute ? t4.getAttribute(DATA_ICON) : null;
  return e && n;
}
function hasBeenReplaced(t4) {
  return t4 && t4.classList && t4.classList.contains && t4.classList.contains(config.replacementClass);
}
function getMutator() {
  if (true === config.autoReplaceSvg) return mutators.replace;
  return mutators[config.autoReplaceSvg] || mutators.replace;
}
function createElementNS(t4) {
  return DOCUMENT.createElementNS("http://www.w3.org/2000/svg", t4);
}
function createElement(t4) {
  return DOCUMENT.createElement(t4);
}
function convertSVG(t4) {
  let e = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {};
  const { ceFn: n = "svg" === t4.tag ? createElementNS : createElement } = e;
  if ("string" == typeof t4) return DOCUMENT.createTextNode(t4);
  const o2 = n(t4.tag);
  Object.keys(t4.attributes || []).forEach(function(e2) {
    o2.setAttribute(e2, t4.attributes[e2]);
  });
  return (t4.children || []).forEach(function(t5) {
    o2.appendChild(convertSVG(t5, { ceFn: n }));
  }), o2;
}
function nodeAsComment(t4) {
  let e = " ".concat(t4.outerHTML, " ");
  return e = "".concat(e, "Font Awesome fontawesome.com "), e;
}
const mutators = { replace: function(t4) {
  const e = t4[0];
  if (e.parentNode) if (t4[1].forEach((t5) => {
    e.parentNode.insertBefore(convertSVG(t5), e);
  }), null === e.getAttribute(DATA_FA_I2SVG) && config.keepOriginalSource) {
    let t5 = DOCUMENT.createComment(nodeAsComment(e));
    e.parentNode.replaceChild(t5, e);
  } else e.remove();
}, nest: function(t4) {
  const e = t4[0], n = t4[1];
  if (~classArray(e).indexOf(config.replacementClass)) return mutators.replace(t4);
  const o2 = new RegExp("".concat(config.cssPrefix, "-.*"));
  if (delete n[0].attributes.id, n[0].attributes.class) {
    const t5 = n[0].attributes.class.split(" ").reduce((t6, e2) => (e2 === config.replacementClass || e2.match(o2) ? t6.toSvg.push(e2) : t6.toNode.push(e2), t6), { toNode: [], toSvg: [] });
    n[0].attributes.class = t5.toSvg.join(" "), 0 === t5.toNode.length ? e.removeAttribute("class") : e.setAttribute("class", t5.toNode.join(" "));
  }
  const i = n.map((t5) => toHtml(t5)).join("\n");
  e.setAttribute(DATA_FA_I2SVG, ""), e.innerHTML = i;
} };
function performOperationSync(t4) {
  t4();
}
function perform(t4, e) {
  const n = "function" == typeof e ? e : noop$2;
  if (0 === t4.length) n();
  else {
    let e2 = performOperationSync;
    config.mutateApproach === MUTATION_APPROACH_ASYNC && (e2 = WINDOW.requestAnimationFrame || performOperationSync), e2(() => {
      const e3 = getMutator(), o2 = perf.begin("mutate");
      t4.map(e3), o2(), n();
    });
  }
}
let disabled = false;
function disableObservation() {
  disabled = true;
}
function enableObservation() {
  disabled = false;
}
let mo$1 = null;
function observe(t4) {
  if (!MUTATION_OBSERVER) return;
  if (!config.observeMutations) return;
  const { treeCallback: e = noop$2, nodeCallback: n = noop$2, pseudoElementsCallback: o2 = noop$2, observeMutationsRoot: i = DOCUMENT } = t4;
  mo$1 = new MUTATION_OBSERVER((t5) => {
    if (disabled) return;
    const i2 = getDefaultUsablePrefix();
    toArray(t5).forEach((t6) => {
      if ("childList" === t6.type && t6.addedNodes.length > 0 && !isWatched(t6.addedNodes[0]) && (config.searchPseudoElements && o2(t6.target), e(t6.target)), "attributes" === t6.type && t6.target.parentNode && config.searchPseudoElements && o2(t6.target.parentNode), "attributes" === t6.type && isWatched(t6.target) && ~ATTRIBUTES_WATCHED_FOR_MUTATION.indexOf(t6.attributeName)) if ("class" === t6.attributeName && hasPrefixAndIcon(t6.target)) {
        const { prefix: e2, iconName: n2 } = getCanonicalIcon(classArray(t6.target));
        t6.target.setAttribute(DATA_PREFIX, e2 || i2), n2 && t6.target.setAttribute(DATA_ICON, n2);
      } else hasBeenReplaced(t6.target) && n(t6.target);
    });
  }), IS_DOM && mo$1.observe(i, { childList: true, attributes: true, characterData: true, subtree: true });
}
function disconnect() {
  mo$1 && mo$1.disconnect();
}
function styleParser(t4) {
  const e = t4.getAttribute("style");
  let n = [];
  return e && (n = e.split(";").reduce((t5, e2) => {
    const n2 = e2.split(":"), o2 = n2[0], i = n2.slice(1);
    return o2 && i.length > 0 && (t5[o2] = i.join(":").trim()), t5;
  }, {})), n;
}
function classParser(t4) {
  const e = t4.getAttribute("data-prefix"), n = t4.getAttribute("data-icon"), o2 = void 0 !== t4.innerText ? t4.innerText.trim() : "";
  let i = getCanonicalIcon(classArray(t4));
  return i.prefix || (i.prefix = getDefaultUsablePrefix()), e && n && (i.prefix = e, i.iconName = n), i.iconName && i.prefix || (i.prefix && o2.length > 0 && (i.iconName = byLigature(i.prefix, t4.innerText) || byUnicode(i.prefix, toHex(t4.innerText))), !i.iconName && config.autoFetchSvg && t4.firstChild && t4.firstChild.nodeType === Node.TEXT_NODE && (i.iconName = t4.firstChild.data)), i;
}
function attributesParser(t4) {
  const e = toArray(t4.attributes).reduce((t5, e2) => ("class" !== t5.name && "style" !== t5.name && (t5[e2.name] = e2.value), t5), {}), n = t4.getAttribute("title"), o2 = t4.getAttribute("data-fa-title-id");
  return config.autoA11y && (n ? e["aria-labelledby"] = "".concat(config.replacementClass, "-title-").concat(o2 || nextUniqueId()) : (e["aria-hidden"] = "true", e.focusable = "false")), e;
}
function blankMeta() {
  return { iconName: null, title: null, titleId: null, prefix: null, transform: meaninglessTransform, symbol: false, mask: { iconName: null, prefix: null, rest: [] }, maskId: null, extra: { classes: [], styles: {}, attributes: {} } };
}
function parseMeta(t4) {
  let e = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : { styleParser: true };
  const { iconName: n, prefix: o2, rest: i } = classParser(t4), a = attributesParser(t4), r2 = chainHooks("parseNodeAttributes", {}, t4);
  let s2 = e.styleParser ? styleParser(t4) : [];
  return _objectSpread2({ iconName: n, title: t4.getAttribute("title"), titleId: t4.getAttribute("data-fa-title-id"), prefix: o2, transform: meaninglessTransform, mask: { iconName: null, prefix: null, rest: [] }, maskId: null, symbol: false, extra: { classes: i, styles: s2, attributes: a } }, r2);
}
const { styles: styles$2 } = namespace;
function generateMutation(t4) {
  const e = "nest" === config.autoReplaceSvg ? parseMeta(t4, { styleParser: false }) : parseMeta(t4);
  return ~e.extra.classes.indexOf(LAYERS_TEXT_CLASSNAME) ? callProvided("generateLayersText", t4, e) : callProvided("generateSvgReplacementMutation", t4, e);
}
function getKnownPrefixes() {
  return [...Ft, ...xo];
}
function onTree(t4) {
  let e = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : null;
  if (!IS_DOM) return Promise.resolve();
  const n = DOCUMENT.documentElement.classList, o2 = (t5) => n.add("".concat(HTML_CLASS_I2SVG_BASE_CLASS, "-").concat(t5)), i = (t5) => n.remove("".concat(HTML_CLASS_I2SVG_BASE_CLASS, "-").concat(t5)), a = config.autoFetchSvg ? getKnownPrefixes() : P.concat(Object.keys(styles$2));
  a.includes("fa") || a.push("fa");
  const r2 = [".".concat(LAYERS_TEXT_CLASSNAME, ":not([").concat(DATA_FA_I2SVG, "])")].concat(a.map((t5) => ".".concat(t5, ":not([").concat(DATA_FA_I2SVG, "])"))).join(", ");
  if (0 === r2.length) return Promise.resolve();
  let s2 = [];
  try {
    s2 = toArray(t4.querySelectorAll(r2));
  } catch (t5) {
  }
  if (!(s2.length > 0)) return Promise.resolve();
  o2("pending"), i("complete");
  const c = perf.begin("onTree"), l = s2.reduce((t5, e2) => {
    try {
      const n2 = generateMutation(e2);
      n2 && t5.push(n2);
    } catch (t6) {
      PRODUCTION$1 || "MissingIcon" === t6.name && console.error(t6);
    }
    return t5;
  }, []);
  return new Promise((t5, n2) => {
    Promise.all(l).then((n3) => {
      perform(n3, () => {
        o2("active"), o2("complete"), i("pending"), "function" == typeof e && e(), c(), t5();
      });
    }).catch((t6) => {
      c(), n2(t6);
    });
  });
}
function onNode(t4) {
  let e = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : null;
  generateMutation(t4).then((t5) => {
    t5 && perform([t5], e);
  });
}
function resolveIcons(t4) {
  return function(e) {
    let n = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {};
    const o2 = (e || {}).icon ? e : findIconDefinition(e || {});
    let { mask: i } = n;
    return i && (i = (i || {}).icon ? i : findIconDefinition(i || {})), t4(o2, _objectSpread2(_objectSpread2({}, n), {}, { mask: i }));
  };
}
const render = function(t4) {
  let e = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {};
  const { transform: n = meaninglessTransform, symbol: o2 = false, mask: i = null, maskId: a = null, title: r2 = null, titleId: s2 = null, classes: c = [], attributes: l = {}, styles: u = {} } = e;
  if (!t4) return;
  const { prefix: p2, iconName: d, icon: m } = t4;
  return domVariants(_objectSpread2({ type: "icon" }, t4), () => (callHooks("beforeDOMElementCreation", { iconDefinition: t4, params: e }), config.autoA11y && (r2 ? l["aria-labelledby"] = "".concat(config.replacementClass, "-title-").concat(s2 || nextUniqueId()) : (l["aria-hidden"] = "true", l.focusable = "false")), makeInlineSvgAbstract({ icons: { main: asFoundIcon(m), mask: i ? asFoundIcon(i.icon) : { found: false, width: null, height: null, icon: {} } }, prefix: p2, iconName: d, transform: _objectSpread2(_objectSpread2({}, meaninglessTransform), n), symbol: o2, title: r2, maskId: a, titleId: s2, extra: { attributes: l, styles: u, classes: c } })));
};
var ReplaceElements = { mixout: () => ({ icon: resolveIcons(render) }), hooks: () => ({ mutationObserverCallbacks: (t4) => (t4.treeCallback = onTree, t4.nodeCallback = onNode, t4) }), provides(t4) {
  t4.i2svg = function(t5) {
    const { node: e = DOCUMENT, callback: n = () => {
    } } = t5;
    return onTree(e, n);
  }, t4.generateSvgReplacementMutation = function(t5, e) {
    const { iconName: n, title: o2, titleId: i, prefix: a, transform: r2, symbol: s2, mask: c, maskId: l, extra: u } = e;
    return new Promise((e2, p2) => {
      Promise.all([findIcon(n, a), c.iconName ? findIcon(c.iconName, c.prefix) : Promise.resolve({ found: false, width: 512, height: 512, icon: {} })]).then((c2) => {
        let [p3, d] = c2;
        e2([t5, makeInlineSvgAbstract({ icons: { main: p3, mask: d }, prefix: a, iconName: n, transform: r2, symbol: s2, maskId: l, title: o2, titleId: i, extra: u, watchable: true })]);
      }).catch(p2);
    });
  }, t4.generateAbstractIcon = function(t5) {
    let { children: e, attributes: n, main: o2, transform: i, styles: a } = t5;
    const r2 = joinStyles(a);
    let s2;
    return r2.length > 0 && (n.style = r2), transformIsMeaningful(i) && (s2 = callProvided("generateAbstractTransformGrouping", { main: o2, transform: i, containerWidth: o2.width, iconWidth: o2.width })), e.push(s2 || o2.icon), { children: e, attributes: n };
  };
} }, Layers = { mixout: () => ({ layer(t4) {
  let e = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {};
  const { classes: n = [] } = e;
  return domVariants({ type: "layer" }, () => {
    callHooks("beforeDOMElementCreation", { assembler: t4, params: e });
    let o2 = [];
    return t4((t5) => {
      Array.isArray(t5) ? t5.map((t6) => {
        o2 = o2.concat(t6.abstract);
      }) : o2 = o2.concat(t5.abstract);
    }), [{ tag: "span", attributes: { class: ["".concat(config.cssPrefix, "-layers"), ...n].join(" ") }, children: o2 }];
  });
} }) }, LayersCounter = { mixout: () => ({ counter(t4) {
  let e = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {};
  const { title: n = null, classes: o2 = [], attributes: i = {}, styles: a = {} } = e;
  return domVariants({ type: "counter", content: t4 }, () => (callHooks("beforeDOMElementCreation", { content: t4, params: e }), makeLayersCounterAbstract({ content: t4.toString(), title: n, extra: { attributes: i, styles: a, classes: ["".concat(config.cssPrefix, "-layers-counter"), ...o2] } })));
} }) }, LayersText = { mixout: () => ({ text(t4) {
  let e = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {};
  const { transform: n = meaninglessTransform, title: o2 = null, classes: i = [], attributes: a = {}, styles: r2 = {} } = e;
  return domVariants({ type: "text", content: t4 }, () => (callHooks("beforeDOMElementCreation", { content: t4, params: e }), makeLayersTextAbstract({ content: t4, transform: _objectSpread2(_objectSpread2({}, meaninglessTransform), n), title: o2, extra: { attributes: a, styles: r2, classes: ["".concat(config.cssPrefix, "-layers-text"), ...i] } })));
} }), provides(t4) {
  t4.generateLayersText = function(t5, e) {
    const { title: n, transform: o2, extra: i } = e;
    let a = null, r2 = null;
    if (IS_IE) {
      const e2 = parseInt(getComputedStyle(t5).fontSize, 10), n2 = t5.getBoundingClientRect();
      a = n2.width / e2, r2 = n2.height / e2;
    }
    return config.autoA11y && !n && (i.attributes["aria-hidden"] = "true"), Promise.resolve([t5, makeLayersTextAbstract({ content: t5.innerHTML, width: a, height: r2, transform: o2, title: n, extra: i, watchable: true })]);
  };
} };
const CLEAN_CONTENT_PATTERN = new RegExp('"', "ug"), SECONDARY_UNICODE_RANGE = [1105920, 1112319], _FONT_FAMILY_WEIGHT_TO_PREFIX = _objectSpread2(_objectSpread2(_objectSpread2(_objectSpread2({}, { FontAwesome: { normal: "fas", 400: "fas" } }), lt), ko), Yt), FONT_FAMILY_WEIGHT_TO_PREFIX = Object.keys(_FONT_FAMILY_WEIGHT_TO_PREFIX).reduce((t4, e) => (t4[e.toLowerCase()] = _FONT_FAMILY_WEIGHT_TO_PREFIX[e], t4), {}), FONT_FAMILY_WEIGHT_FALLBACK = Object.keys(FONT_FAMILY_WEIGHT_TO_PREFIX).reduce((t4, e) => {
  const n = FONT_FAMILY_WEIGHT_TO_PREFIX[e];
  return t4[e] = n[900] || [...Object.entries(n)][0][1], t4;
}, {});
function hexValueFromContent(t4) {
  const e = t4.replace(CLEAN_CONTENT_PATTERN, ""), n = codePointAt(e, 0), o2 = n >= SECONDARY_UNICODE_RANGE[0] && n <= SECONDARY_UNICODE_RANGE[1], i = 2 === e.length && e[0] === e[1];
  return { value: toHex(i ? e[0] : e), isSecondary: o2 || i };
}
function getPrefix(t4, e) {
  const n = t4.replace(/^['"]|['"]$/g, "").toLowerCase(), o2 = parseInt(e), i = isNaN(o2) ? "normal" : o2;
  return (FONT_FAMILY_WEIGHT_TO_PREFIX[n] || {})[i] || FONT_FAMILY_WEIGHT_FALLBACK[n];
}
function replaceForPosition(t4, e) {
  const n = "".concat(DATA_FA_PSEUDO_ELEMENT_PENDING).concat(e.replace(":", "-"));
  return new Promise((o2, i) => {
    if (null !== t4.getAttribute(n)) return o2();
    const a = toArray(t4.children).filter((t5) => t5.getAttribute(DATA_FA_PSEUDO_ELEMENT) === e)[0], r2 = WINDOW.getComputedStyle(t4, e), s2 = r2.getPropertyValue("font-family"), c = s2.match(FONT_FAMILY_PATTERN), l = r2.getPropertyValue("font-weight"), u = r2.getPropertyValue("content");
    if (a && !c) return t4.removeChild(a), o2();
    if (c && "none" !== u && "" !== u) {
      const u2 = r2.getPropertyValue("content");
      let p2 = getPrefix(s2, l);
      const { value: d, isSecondary: m } = hexValueFromContent(u2), f = c[0].startsWith("FontAwesome");
      let _ = byUnicode(p2, d), h = _;
      if (f) {
        const t5 = byOldUnicode(d);
        t5.iconName && t5.prefix && (_ = t5.iconName, p2 = t5.prefix);
      }
      if (!_ || m || a && a.getAttribute(DATA_PREFIX) === p2 && a.getAttribute(DATA_ICON) === h) o2();
      else {
        t4.setAttribute(n, h), a && t4.removeChild(a);
        const r3 = blankMeta(), { extra: s3 } = r3;
        s3.attributes[DATA_FA_PSEUDO_ELEMENT] = e, findIcon(_, p2).then((i2) => {
          const a2 = makeInlineSvgAbstract(_objectSpread2(_objectSpread2({}, r3), {}, { icons: { main: i2, mask: emptyCanonicalIcon() }, prefix: p2, iconName: h, extra: s3, watchable: true })), c2 = DOCUMENT.createElementNS("http://www.w3.org/2000/svg", "svg");
          "::before" === e ? t4.insertBefore(c2, t4.firstChild) : t4.appendChild(c2), c2.outerHTML = a2.map((t5) => toHtml(t5)).join("\n"), t4.removeAttribute(n), o2();
        }).catch(i);
      }
    } else o2();
  });
}
function replace(t4) {
  return Promise.all([replaceForPosition(t4, "::before"), replaceForPosition(t4, "::after")]);
}
function processable(t4) {
  return !(t4.parentNode === document.head || ~TAGNAMES_TO_SKIP_FOR_PSEUDOELEMENTS.indexOf(t4.tagName.toUpperCase()) || t4.getAttribute(DATA_FA_PSEUDO_ELEMENT) || t4.parentNode && "svg" === t4.parentNode.tagName);
}
function searchPseudoElements(t4) {
  if (IS_DOM) return new Promise((e, n) => {
    const o2 = toArray(t4.querySelectorAll("*")).filter(processable).map(replace), i = perf.begin("searchPseudoElements");
    disableObservation(), Promise.all(o2).then(() => {
      i(), enableObservation(), e();
    }).catch(() => {
      i(), enableObservation(), n();
    });
  });
}
var PseudoElements = { hooks: () => ({ mutationObserverCallbacks: (t4) => (t4.pseudoElementsCallback = searchPseudoElements, t4) }), provides(t4) {
  t4.pseudoElements2svg = function(t5) {
    const { node: e = DOCUMENT } = t5;
    config.searchPseudoElements && searchPseudoElements(e);
  };
} };
let _unwatched = false;
var MutationObserver$1 = { mixout: () => ({ dom: { unwatch() {
  disableObservation(), _unwatched = true;
} } }), hooks: () => ({ bootstrap() {
  observe(chainHooks("mutationObserverCallbacks", {}));
}, noAuto() {
  disconnect();
}, watch(t4) {
  const { observeMutationsRoot: e } = t4;
  _unwatched ? enableObservation() : observe(chainHooks("mutationObserverCallbacks", { observeMutationsRoot: e }));
} }) };
const parseTransformString = (t4) => t4.toLowerCase().split(" ").reduce((t5, e) => {
  const n = e.toLowerCase().split("-"), o2 = n[0];
  let i = n.slice(1).join("-");
  if (o2 && "h" === i) return t5.flipX = true, t5;
  if (o2 && "v" === i) return t5.flipY = true, t5;
  if (i = parseFloat(i), isNaN(i)) return t5;
  switch (o2) {
    case "grow":
      t5.size = t5.size + i;
      break;
    case "shrink":
      t5.size = t5.size - i;
      break;
    case "left":
      t5.x = t5.x - i;
      break;
    case "right":
      t5.x = t5.x + i;
      break;
    case "up":
      t5.y = t5.y - i;
      break;
    case "down":
      t5.y = t5.y + i;
      break;
    case "rotate":
      t5.rotate = t5.rotate + i;
  }
  return t5;
}, { size: 16, x: 0, y: 0, flipX: false, flipY: false, rotate: 0 });
var PowerTransforms = { mixout: () => ({ parse: { transform: (t4) => parseTransformString(t4) } }), hooks: () => ({ parseNodeAttributes(t4, e) {
  const n = e.getAttribute("data-fa-transform");
  return n && (t4.transform = parseTransformString(n)), t4;
} }), provides(t4) {
  t4.generateAbstractTransformGrouping = function(t5) {
    let { main: e, transform: n, containerWidth: o2, iconWidth: i } = t5;
    const a = { transform: "translate(".concat(o2 / 2, " 256)") }, r2 = "translate(".concat(32 * n.x, ", ").concat(32 * n.y, ") "), s2 = "scale(".concat(n.size / 16 * (n.flipX ? -1 : 1), ", ").concat(n.size / 16 * (n.flipY ? -1 : 1), ") "), c = "rotate(".concat(n.rotate, " 0 0)"), l = { outer: a, inner: { transform: "".concat(r2, " ").concat(s2, " ").concat(c) }, path: { transform: "translate(".concat(i / 2 * -1, " -256)") } };
    return { tag: "g", attributes: _objectSpread2({}, l.outer), children: [{ tag: "g", attributes: _objectSpread2({}, l.inner), children: [{ tag: e.icon.tag, children: e.icon.children, attributes: _objectSpread2(_objectSpread2({}, e.icon.attributes), l.path) }] }] };
  };
} };
const ALL_SPACE = { x: 0, y: 0, width: "100%", height: "100%" };
function fillBlack(t4) {
  let e = !(arguments.length > 1 && void 0 !== arguments[1]) || arguments[1];
  return t4.attributes && (t4.attributes.fill || e) && (t4.attributes.fill = "black"), t4;
}
function deGroup(t4) {
  return "g" === t4.tag ? t4.children : [t4];
}
var Masks = { hooks: () => ({ parseNodeAttributes(t4, e) {
  const n = e.getAttribute("data-fa-mask"), o2 = n ? getCanonicalIcon(n.split(" ").map((t5) => t5.trim())) : emptyCanonicalIcon();
  return o2.prefix || (o2.prefix = getDefaultUsablePrefix()), t4.mask = o2, t4.maskId = e.getAttribute("data-fa-mask-id"), t4;
} }), provides(t4) {
  t4.generateAbstractMask = function(t5) {
    let { children: e, attributes: n, main: o2, mask: i, maskId: a, transform: r2 } = t5;
    const { width: s2, icon: c } = o2, { width: l, icon: u } = i, p2 = transformForSvg({ transform: r2, containerWidth: l, iconWidth: s2 }), d = { tag: "rect", attributes: _objectSpread2(_objectSpread2({}, ALL_SPACE), {}, { fill: "white" }) }, m = c.children ? { children: c.children.map(fillBlack) } : {}, f = { tag: "g", attributes: _objectSpread2({}, p2.inner), children: [fillBlack(_objectSpread2({ tag: c.tag, attributes: _objectSpread2(_objectSpread2({}, c.attributes), p2.path) }, m))] }, _ = { tag: "g", attributes: _objectSpread2({}, p2.outer), children: [f] }, h = "mask-".concat(a || nextUniqueId()), g2 = "clip-".concat(a || nextUniqueId()), $2 = { tag: "mask", attributes: _objectSpread2(_objectSpread2({}, ALL_SPACE), {}, { id: h, maskUnits: "userSpaceOnUse", maskContentUnits: "userSpaceOnUse" }), children: [d, _] }, b = { tag: "defs", children: [{ tag: "clipPath", attributes: { id: g2 }, children: deGroup(u) }, $2] };
    return e.push(b, { tag: "rect", attributes: _objectSpread2({ fill: "currentColor", "clip-path": "url(#".concat(g2, ")"), mask: "url(#".concat(h, ")") }, ALL_SPACE) }), { children: e, attributes: n };
  };
} }, MissingIconIndicator = { provides(t4) {
  let e = false;
  WINDOW.matchMedia && (e = WINDOW.matchMedia("(prefers-reduced-motion: reduce)").matches), t4.missingIconAbstract = function() {
    const t5 = [], n = { fill: "currentColor" }, o2 = { attributeType: "XML", repeatCount: "indefinite", dur: "2s" };
    t5.push({ tag: "path", attributes: _objectSpread2(_objectSpread2({}, n), {}, { d: "M156.5,447.7l-12.6,29.5c-18.7-9.5-35.9-21.2-51.5-34.9l22.7-22.7C127.6,430.5,141.5,440,156.5,447.7z M40.6,272H8.5 c1.4,21.2,5.4,41.7,11.7,61.1L50,321.2C45.1,305.5,41.8,289,40.6,272z M40.6,240c1.4-18.8,5.2-37,11.1-54.1l-29.5-12.6 C14.7,194.3,10,216.7,8.5,240H40.6z M64.3,156.5c7.8-14.9,17.2-28.8,28.1-41.5L69.7,92.3c-13.7,15.6-25.5,32.8-34.9,51.5 L64.3,156.5z M397,419.6c-13.9,12-29.4,22.3-46.1,30.4l11.9,29.8c20.7-9.9,39.8-22.6,56.9-37.6L397,419.6z M115,92.4 c13.9-12,29.4-22.3,46.1-30.4l-11.9-29.8c-20.7,9.9-39.8,22.6-56.8,37.6L115,92.4z M447.7,355.5c-7.8,14.9-17.2,28.8-28.1,41.5 l22.7,22.7c13.7-15.6,25.5-32.9,34.9-51.5L447.7,355.5z M471.4,272c-1.4,18.8-5.2,37-11.1,54.1l29.5,12.6 c7.5-21.1,12.2-43.5,13.6-66.8H471.4z M321.2,462c-15.7,5-32.2,8.2-49.2,9.4v32.1c21.2-1.4,41.7-5.4,61.1-11.7L321.2,462z M240,471.4c-18.8-1.4-37-5.2-54.1-11.1l-12.6,29.5c21.1,7.5,43.5,12.2,66.8,13.6V471.4z M462,190.8c5,15.7,8.2,32.2,9.4,49.2h32.1 c-1.4-21.2-5.4-41.7-11.7-61.1L462,190.8z M92.4,397c-12-13.9-22.3-29.4-30.4-46.1l-29.8,11.9c9.9,20.7,22.6,39.8,37.6,56.9 L92.4,397z M272,40.6c18.8,1.4,36.9,5.2,54.1,11.1l12.6-29.5C317.7,14.7,295.3,10,272,8.5V40.6z M190.8,50 c15.7-5,32.2-8.2,49.2-9.4V8.5c-21.2,1.4-41.7,5.4-61.1,11.7L190.8,50z M442.3,92.3L419.6,115c12,13.9,22.3,29.4,30.5,46.1 l29.8-11.9C470,128.5,457.3,109.4,442.3,92.3z M397,92.4l22.7-22.7c-15.6-13.7-32.8-25.5-51.5-34.9l-12.6,29.5 C370.4,72.1,384.4,81.5,397,92.4z" }) });
    const i = _objectSpread2(_objectSpread2({}, o2), {}, { attributeName: "opacity" }), a = { tag: "circle", attributes: _objectSpread2(_objectSpread2({}, n), {}, { cx: "256", cy: "364", r: "28" }), children: [] };
    return e || a.children.push({ tag: "animate", attributes: _objectSpread2(_objectSpread2({}, o2), {}, { attributeName: "r", values: "28;14;28;28;14;28;" }) }, { tag: "animate", attributes: _objectSpread2(_objectSpread2({}, i), {}, { values: "1;0;1;1;0;1;" }) }), t5.push(a), t5.push({ tag: "path", attributes: _objectSpread2(_objectSpread2({}, n), {}, { opacity: "1", d: "M263.7,312h-16c-6.6,0-12-5.4-12-12c0-71,77.4-63.9,77.4-107.8c0-20-17.8-40.2-57.4-40.2c-29.1,0-44.3,9.6-59.2,28.7 c-3.9,5-11.1,6-16.2,2.4l-13.1-9.2c-5.6-3.9-6.9-11.8-2.6-17.2c21.2-27.2,46.4-44.7,91.2-44.7c52.3,0,97.4,29.8,97.4,80.2 c0,67.6-77.4,63.5-77.4,107.8C275.7,306.6,270.3,312,263.7,312z" }), children: e ? [] : [{ tag: "animate", attributes: _objectSpread2(_objectSpread2({}, i), {}, { values: "1;0;0;0;0;1;" }) }] }), e || t5.push({ tag: "path", attributes: _objectSpread2(_objectSpread2({}, n), {}, { opacity: "0", d: "M232.5,134.5l7,168c0.3,6.4,5.6,11.5,12,11.5h9c6.4,0,11.7-5.1,12-11.5l7-168c0.3-6.8-5.2-12.5-12-12.5h-23 C237.7,122,232.2,127.7,232.5,134.5z" }), children: [{ tag: "animate", attributes: _objectSpread2(_objectSpread2({}, i), {}, { values: "0;0;1;1;0;0;" }) }] }), { tag: "g", attributes: { class: "missing" }, children: t5 };
  };
} }, SvgSymbols = { hooks: () => ({ parseNodeAttributes(t4, e) {
  const n = e.getAttribute("data-fa-symbol"), o2 = null !== n && ("" === n || n);
  return t4.symbol = o2, t4;
} }) }, plugins = [InjectCSS, ReplaceElements, Layers, LayersCounter, LayersText, PseudoElements, MutationObserver$1, PowerTransforms, Masks, MissingIconIndicator, SvgSymbols];
registerPlugins(plugins, { mixoutsTo: api }), api.noAuto, api.config, api.library, api.dom;
const parse$1 = api.parse;
api.findIconDefinition, api.toHtml;
const icon = api.icon;
api.layer, api.text, api.counter;
let PRODUCTION = false;
try {
  PRODUCTION = "production" === process.env.NODE_ENV;
} catch (t4) {
}
function log(...t4) {
  !PRODUCTION && console && "function" == typeof console.error && console.error(...t4);
}
function normalizeIconArgs(t4) {
  return t4 && "object" == typeof t4 && t4.prefix && t4.iconName && t4.icon ? t4 : parse$1.icon ? parse$1.icon(t4) : null === t4 ? null : t4 && "object" == typeof t4 && t4.prefix && t4.iconName ? t4 : Array.isArray(t4) && 2 === t4.length ? { prefix: t4[0], iconName: t4[1] } : "string" == typeof t4 ? { prefix: "fas", iconName: t4 } : void 0;
}
function objectWithKey(t4, e) {
  return Array.isArray(e) && e.length > 0 || !Array.isArray(e) && e ? { [t4]: e } : {};
}
function create_fragment$1P(t4) {
  let e, n = [t4[2]], o2 = {};
  for (let t5 = 0; t5 < n.length; t5 += 1) o2 = assign(o2, n[t5]);
  return { c() {
    e = svg_element("svg"), set_svg_attributes(e, o2);
  }, m(n2, o3) {
    insert(n2, e, o3), e.innerHTML = t4[1], t4[7](e);
  }, p: noop$3, i: noop$3, o: noop$3, d(n2) {
    n2 && detach(e), t4[7](null);
  } };
}
function instance$1O(t4, e, n) {
  let { tag: o2 } = e, { props: i } = e, { children: a } = e, { style: r2 = null } = e, { ref: s2 = null } = e;
  if ("svg" !== o2) throw new Error('SvgElement requires a tag of "svg"');
  function c(t5) {
    return t5?.reduce((t6, e2) => t6 + (e2.tag ? function({ tag: t7, props: e3, children: n2 }) {
      const o3 = Object.keys(e3).map((t8) => `${t8}="${e3[t8]}"`).join(" ");
      return `<${t7} ${o3}>${c(n2)}</${t7}>`;
    }(e2) : e2), "") || "";
  }
  const l = c(a), u = i?.style ? `${i.style}${r2 || ""}` : r2, p2 = { ...i, style: u };
  return t4.$$set = (t5) => {
    "tag" in t5 && n(3, o2 = t5.tag), "props" in t5 && n(4, i = t5.props), "children" in t5 && n(5, a = t5.children), "style" in t5 && n(6, r2 = t5.style), "ref" in t5 && n(0, s2 = t5.ref);
  }, [s2, l, p2, o2, i, a, r2, function(t5) {
    binding_callbacks[t5 ? "unshift" : "push"](() => {
      s2 = t5, n(0, s2);
    });
  }];
}
class SvgElement extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1O, create_fragment$1P, safe_not_equal, { tag: 3, props: 4, children: 5, style: 6, ref: 0 });
  }
}
function create_if_block$18(t4) {
  let e, n, o2;
  const i = [t4[2], { style: t4[1] }];
  function a(e2) {
    t4[28](e2);
  }
  let r2 = {};
  for (let t5 = 0; t5 < i.length; t5 += 1) r2 = assign(r2, i[t5]);
  return void 0 !== t4[0] && (r2.ref = t4[0]), e = new SvgElement({ props: r2 }), binding_callbacks.push(() => bind(e, "ref", a)), { c() {
    create_component(e.$$.fragment);
  }, m(t5, n2) {
    mount_component(e, t5, n2), o2 = true;
  }, p(t5, o3) {
    const a2 = 6 & o3[0] ? get_spread_update(i, [4 & o3[0] && get_spread_object(t5[2]), 2 & o3[0] && { style: t5[1] }]) : {};
    !n && 1 & o3[0] && (n = true, a2.ref = t5[0], add_flush_callback(() => n = false)), e.$set(a2);
  }, i(t5) {
    o2 || (transition_in(e.$$.fragment, t5), o2 = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), o2 = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_fragment$1O(t4) {
  let e, n, o2 = t4[2] && create_if_block$18(t4);
  return { c() {
    o2 && o2.c(), e = empty();
  }, m(t5, i) {
    o2 && o2.m(t5, i), insert(t5, e, i), n = true;
  }, p(t5, n2) {
    t5[2] ? o2 ? (o2.p(t5, n2), 4 & n2[0] && transition_in(o2, 1)) : (o2 = create_if_block$18(t5), o2.c(), transition_in(o2, 1), o2.m(e.parentNode, e)) : o2 && (group_outros(), transition_out(o2, 1, 1, () => {
      o2 = null;
    }), check_outros());
  }, i(t5) {
    n || (transition_in(o2), n = true);
  }, o(t5) {
    transition_out(o2), n = false;
  }, d(t5) {
    t5 && detach(e), o2 && o2.d(t5);
  } };
}
function instance$1N(t4, e, n) {
  const o2 = ["border", "mask", "maskId", "fixedWidth", "inverse", "flip", "icon", "listItem", "pull", "pulse", "rotation", "size", "spin", "spinPulse", "spinReverse", "beat", "fade", "beatFade", "bounce", "shake", "symbol", "title", "titleId", "transform", "swapOpacity", "ref", "style"];
  let i = compute_rest_props(e, o2), { border: a = false } = e, { mask: r2 = null } = e, { maskId: s2 = null } = e, { fixedWidth: c = false } = e, { inverse: l = false } = e, { flip: u = false } = e, { icon: p2 = null } = e, { listItem: d = false } = e, { pull: m = null } = e, { pulse: f = false } = e, { rotation: _ = null } = e, { size: h = null } = e, { spin: g2 = false } = e, { spinPulse: $2 = false } = e, { spinReverse: b = false } = e, { beat: y = false } = e, { fade: v = false } = e, { beatFade: k = false } = e, { bounce: w2 = false } = e, { shake: S2 = false } = e, { symbol: T = false } = e, { title: x2 = "" } = e, { titleId: E = null } = e, { transform: O = null } = e, { swapOpacity: A2 = false } = e, { ref: C = null } = e, { style: D = null } = e;
  const M = normalizeIconArgs(p2), j = objectWithKey("classes", [...classList(e), ...(e.class || "").split(" ")]), I = objectWithKey("transform", "string" == typeof O ? parse$1.transform(O) : O), N = objectWithKey("mask", normalizeIconArgs(r2)), P2 = icon(M, { ...j, ...I, ...N, symbol: T, title: x2, titleId: E, maskId: s2 });
  let F = null;
  if (P2) {
    const { abstract: t5 } = P2;
    F = convert((t6, e2, n2) => ({ tag: t6, props: e2, children: n2 }), t5[0], i);
  } else log("Could not find icon", M);
  return t4.$$set = (t5) => {
    n(35, e = assign(assign({}, e), exclude_internal_props(t5))), n(34, i = compute_rest_props(e, o2)), "border" in t5 && n(3, a = t5.border), "mask" in t5 && n(4, r2 = t5.mask), "maskId" in t5 && n(5, s2 = t5.maskId), "fixedWidth" in t5 && n(6, c = t5.fixedWidth), "inverse" in t5 && n(7, l = t5.inverse), "flip" in t5 && n(8, u = t5.flip), "icon" in t5 && n(9, p2 = t5.icon), "listItem" in t5 && n(10, d = t5.listItem), "pull" in t5 && n(11, m = t5.pull), "pulse" in t5 && n(12, f = t5.pulse), "rotation" in t5 && n(13, _ = t5.rotation), "size" in t5 && n(14, h = t5.size), "spin" in t5 && n(15, g2 = t5.spin), "spinPulse" in t5 && n(16, $2 = t5.spinPulse), "spinReverse" in t5 && n(17, b = t5.spinReverse), "beat" in t5 && n(18, y = t5.beat), "fade" in t5 && n(19, v = t5.fade), "beatFade" in t5 && n(20, k = t5.beatFade), "bounce" in t5 && n(21, w2 = t5.bounce), "shake" in t5 && n(22, S2 = t5.shake), "symbol" in t5 && n(23, T = t5.symbol), "title" in t5 && n(24, x2 = t5.title), "titleId" in t5 && n(25, E = t5.titleId), "transform" in t5 && n(26, O = t5.transform), "swapOpacity" in t5 && n(27, A2 = t5.swapOpacity), "ref" in t5 && n(0, C = t5.ref), "style" in t5 && n(1, D = t5.style);
  }, e = exclude_internal_props(e), [C, D, F, a, r2, s2, c, l, u, p2, d, m, f, _, h, g2, $2, b, y, v, k, w2, S2, T, x2, E, O, A2, function(t5) {
    C = t5, n(0, C);
  }];
}
class FontAwesomeIcon extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1N, create_fragment$1O, safe_not_equal, { border: 3, mask: 4, maskId: 5, fixedWidth: 6, inverse: 7, flip: 8, icon: 9, listItem: 10, pull: 11, pulse: 12, rotation: 13, size: 14, spin: 15, spinPulse: 16, spinReverse: 17, beat: 18, fade: 19, beatFade: 20, bounce: 21, shake: 22, symbol: 23, title: 24, titleId: 25, transform: 26, swapOpacity: 27, ref: 0, style: 1 }, null, [-1, -1]);
  }
}
const conversionToCp = { pp: 1e3, gp: 100, ep: 50, sp: 10, cp: 1 };
function getConversionAmounts(t4, e) {
  let n, o2;
  return conversionToCp[t4] < conversionToCp[e] ? (n = conversionToCp[e] / conversionToCp[t4], o2 = 1) : (n = 1, o2 = conversionToCp[t4] / conversionToCp[e]), { fromAmount: n, resultAmount: o2 };
}
function create_if_block$17(t4) {
  let e, n;
  return e = new GenericModal({ props: { $$slots: { default: [create_default_slot$g] }, $$scope: { ctx: t4 } } }), e.$on("close", t4[6]), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    1048590 & n2 && (o2.$$scope = { dirty: n2, ctx: t5 }), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_if_block_1$x(t4) {
  let e, n, o2, i = getConversionAmounts(t4[1], t4[2]).fromAmount + "", a = getConversionAmounts(t4[1], t4[2]).resultAmount + "";
  return { c() {
    e = text(i), n = text("\r\n                        :\r\n                        "), o2 = text(a);
  }, m(t5, i2) {
    insert(t5, e, i2), insert(t5, n, i2), insert(t5, o2, i2);
  }, p(t5, n2) {
    6 & n2 && i !== (i = getConversionAmounts(t5[1], t5[2]).fromAmount + "") && set_data(e, i), 6 & n2 && a !== (a = getConversionAmounts(t5[1], t5[2]).resultAmount + "") && set_data(o2, a);
  }, d(t5) {
    t5 && (detach(e), detach(n), detach(o2));
  } };
}
function create_default_slot$g(t4) {
  let e, n, o2, i, a, r2, s2, c, l, u, p2, d, m, f, _, h, g2, $2, b, y, v, k, w2, S2, T, x2, E, O, A2, C, D, M, j, I, N, P2, F, R, L2, H, z, q, W, U, G2, B, J, V, X, Y, Z, K, Q, tt, et, nt, ot, it, at, rt, st, ct, lt2, ut, pt2, dt, mt, ft, _t, ht, gt, $t, bt, yt = t4[3].pp + "", vt = t4[3].gp + "", kt = t4[3].ep + "", wt = t4[3].sp + "", St2 = t4[3].cp + "", Tt = t4[3].pp + "", xt2 = t4[3].gp + "", Et2 = t4[3].ep + "", Ot = t4[3].sp + "", At2 = t4[3].cp + "", Ct2 = t4[1] && t4[2] && create_if_block_1$x(t4);
  return { c() {
    e = element("h2"), e.textContent = "Exchange", n = space(), o2 = element("section"), i = element("div"), a = element("label"), r2 = element("i"), s2 = space(), c = element("button"), l = text(yt), u = space(), p2 = element("label"), d = element("i"), m = space(), f = element("button"), _ = text(vt), h = space(), g2 = element("label"), $2 = element("i"), b = space(), y = element("button"), v = text(kt), k = space(), w2 = element("label"), S2 = element("i"), T = space(), x2 = element("button"), E = text(wt), O = space(), A2 = element("label"), C = element("i"), D = space(), M = element("button"), j = text(St2), I = space(), N = element("div"), P2 = svg_element("svg"), F = svg_element("path"), L2 = space(), H = element("div"), Ct2 && Ct2.c(), z = space(), q = element("div"), W = element("label"), U = element("i"), G2 = space(), B = element("button"), J = text(Tt), V = space(), X = element("label"), Y = element("i"), Z = space(), K = element("button"), Q = text(xt2), tt = space(), et = element("label"), nt = element("i"), ot = space(), it = element("button"), at = text(Et2), rt = space(), st = element("label"), ct = element("i"), lt2 = space(), ut = element("button"), pt2 = text(Ot), dt = space(), mt = element("label"), ft = element("i"), _t = space(), ht = element("button"), gt = text(At2), attr(e, "class", "roboto-condensed-upper svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1adys82"), attr(r2, "class", "currency pp svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1adys82"), attr(r2, "aria-hidden", "true"), attr(c, "id", "from-pp"), attr(c, "class", "currency-button svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1adys82"), toggle_class(c, "active", "pp" === t4[1]), attr(a, "for", "from-pp"), attr(a, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1adys82"), attr(d, "class", "currency gp svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1adys82"), attr(d, "aria-hidden", "true"), attr(f, "id", "from-gp"), attr(f, "class", "currency-button svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1adys82"), toggle_class(f, "active", "gp" === t4[1]), attr(p2, "for", "from-gp"), attr(p2, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1adys82"), attr($2, "class", "currency ep svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1adys82"), attr($2, "aria-hidden", "true"), attr(y, "id", "from-ep"), attr(y, "class", "currency-button svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1adys82"), toggle_class(y, "active", "ep" === t4[1]), attr(g2, "for", "from-ep"), attr(g2, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1adys82"), attr(S2, "class", "currency sp svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1adys82"), attr(S2, "aria-hidden", "true"), attr(x2, "id", "from-sp"), attr(x2, "class", "currency-button svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1adys82"), toggle_class(x2, "active", "sp" === t4[1]), attr(w2, "for", "from-sp"), attr(w2, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1adys82"), attr(C, "class", "currency cp svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1adys82"), attr(C, "aria-hidden", "true"), attr(M, "id", "from-cp"), attr(M, "class", "currency-button svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1adys82"), toggle_class(M, "active", "cp" === t4[1]), attr(A2, "for", "from-cp"), attr(A2, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1adys82"), attr(i, "class", "currency-row svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1adys82"), attr(F, "d", "M21 12L14 5V9H3.8C3.51997 9 3.37996 9 3.273 9.0545C3.17892 9.10243 3.10243 9.17892 3.0545 9.273C3 9.37996 3 9.51997 3 9.8V14.2C3 14.48 3 14.62 3.0545 14.727C3.10243 14.8211 3.17892 14.8976 3.273 14.9455C3.37996 15 3.51997 15 3.8 15H14V19L21 12Z"), attr(F, "stroke", "currentColor"), attr(F, "stroke-width", R = t4[1] && t4[2] ? 1 : 0.5), attr(F, "stroke-linecap", "square"), attr(F, "stroke-linejoin", "bevel"), attr(P2, "width", "70px"), attr(P2, "height", "70px"), attr(P2, "viewBox", "0 0 24 24"), attr(P2, "xmlns", "http://www.w3.org/2000/svg"), attr(H, "class", "conversion-rate svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1adys82"), attr(N, "class", "large-arrow svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1adys82"), attr(N, "aria-hidden", "true"), toggle_class(N, "active", t4[1] && t4[2]), attr(U, "class", "currency pp right svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1adys82"), attr(U, "aria-hidden", "true"), attr(B, "id", "to-pp"), attr(B, "class", "currency-button svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1adys82"), toggle_class(B, "active", "pp" === t4[2]), attr(W, "for", "to-pp"), attr(W, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1adys82"), attr(Y, "class", "currency gp right svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1adys82"), attr(Y, "aria-hidden", "true"), attr(K, "id", "to-gp"), attr(K, "class", "currency-button svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1adys82"), toggle_class(K, "active", "gp" === t4[2]), attr(X, "for", "to-gp"), attr(X, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1adys82"), attr(nt, "class", "currency ep right svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1adys82"), attr(nt, "aria-hidden", "true"), attr(it, "id", "to-ep"), attr(it, "class", "currency-button svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1adys82"), toggle_class(it, "active", "ep" === t4[2]), attr(et, "for", "to-ep"), attr(et, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1adys82"), attr(ct, "class", "currency sp right svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1adys82"), attr(ct, "aria-hidden", "true"), attr(ut, "id", "to-sp"), attr(ut, "class", "currency-button svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1adys82"), toggle_class(ut, "active", "sp" === t4[2]), attr(st, "for", "to-sp"), attr(st, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1adys82"), attr(ft, "class", "currency cp right svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1adys82"), attr(ft, "aria-hidden", "true"), attr(ht, "id", "to-cp"), attr(ht, "class", "currency-button svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1adys82"), toggle_class(ht, "active", "cp" === t4[2]), attr(mt, "for", "to-cp"), attr(mt, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1adys82"), attr(q, "class", "currency-row svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1adys82"), attr(o2, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1adys82");
  }, m(R2, yt2) {
    insert(R2, e, yt2), insert(R2, n, yt2), insert(R2, o2, yt2), append(o2, i), append(i, a), append(a, r2), append(a, s2), append(a, c), append(c, l), append(i, u), append(i, p2), append(p2, d), append(p2, m), append(p2, f), append(f, _), append(i, h), append(i, g2), append(g2, $2), append(g2, b), append(g2, y), append(y, v), append(i, k), append(i, w2), append(w2, S2), append(w2, T), append(w2, x2), append(x2, E), append(i, O), append(i, A2), append(A2, C), append(A2, D), append(A2, M), append(M, j), append(o2, I), append(o2, N), append(N, P2), append(P2, F), append(N, L2), append(N, H), Ct2 && Ct2.m(H, null), append(o2, z), append(o2, q), append(q, W), append(W, U), append(W, G2), append(W, B), append(B, J), append(q, V), append(q, X), append(X, Y), append(X, Z), append(X, K), append(K, Q), append(q, tt), append(q, et), append(et, nt), append(et, ot), append(et, it), append(it, at), append(q, rt), append(q, st), append(st, ct), append(st, lt2), append(st, ut), append(ut, pt2), append(q, dt), append(q, mt), append(mt, ft), append(mt, _t), append(mt, ht), append(ht, gt), $t || (bt = [listen(c, "click", t4[9]), listen(f, "click", t4[10]), listen(y, "click", t4[11]), listen(x2, "click", t4[12]), listen(M, "click", t4[13]), listen(N, "click", t4[5]), listen(B, "click", t4[14]), listen(K, "click", t4[15]), listen(it, "click", t4[16]), listen(ut, "click", t4[17]), listen(ht, "click", t4[18])], $t = true);
  }, p(t5, e2) {
    8 & e2 && yt !== (yt = t5[3].pp + "") && set_data(l, yt), 2 & e2 && toggle_class(c, "active", "pp" === t5[1]), 8 & e2 && vt !== (vt = t5[3].gp + "") && set_data(_, vt), 2 & e2 && toggle_class(f, "active", "gp" === t5[1]), 8 & e2 && kt !== (kt = t5[3].ep + "") && set_data(v, kt), 2 & e2 && toggle_class(y, "active", "ep" === t5[1]), 8 & e2 && wt !== (wt = t5[3].sp + "") && set_data(E, wt), 2 & e2 && toggle_class(x2, "active", "sp" === t5[1]), 8 & e2 && St2 !== (St2 = t5[3].cp + "") && set_data(j, St2), 2 & e2 && toggle_class(M, "active", "cp" === t5[1]), 6 & e2 && R !== (R = t5[1] && t5[2] ? 1 : 0.5) && attr(F, "stroke-width", R), t5[1] && t5[2] ? Ct2 ? Ct2.p(t5, e2) : (Ct2 = create_if_block_1$x(t5), Ct2.c(), Ct2.m(H, null)) : Ct2 && (Ct2.d(1), Ct2 = null), 6 & e2 && toggle_class(N, "active", t5[1] && t5[2]), 8 & e2 && Tt !== (Tt = t5[3].pp + "") && set_data(J, Tt), 4 & e2 && toggle_class(B, "active", "pp" === t5[2]), 8 & e2 && xt2 !== (xt2 = t5[3].gp + "") && set_data(Q, xt2), 4 & e2 && toggle_class(K, "active", "gp" === t5[2]), 8 & e2 && Et2 !== (Et2 = t5[3].ep + "") && set_data(at, Et2), 4 & e2 && toggle_class(it, "active", "ep" === t5[2]), 8 & e2 && Ot !== (Ot = t5[3].sp + "") && set_data(pt2, Ot), 4 & e2 && toggle_class(ut, "active", "sp" === t5[2]), 8 & e2 && At2 !== (At2 = t5[3].cp + "") && set_data(gt, At2), 4 & e2 && toggle_class(ht, "active", "cp" === t5[2]);
  }, d(t5) {
    t5 && (detach(e), detach(n), detach(o2)), Ct2 && Ct2.d(), $t = false, run_all(bt);
  } };
}
function create_fragment$1N(t4) {
  let e, n, o2, i, a, r2, s2 = t4[0] && create_if_block$17(t4);
  return o2 = new FontAwesomeIcon({ props: { icon: faMoneyBillTransfer, size: "lg" } }), { c() {
    s2 && s2.c(), e = space(), n = element("button"), create_component(o2.$$.fragment), attr(n, "class", "transfer-button svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1adys82");
  }, m(c, l) {
    s2 && s2.m(c, l), insert(c, e, l), insert(c, n, l), mount_component(o2, n, null), i = true, a || (r2 = listen(n, "click", t4[19]), a = true);
  }, p(t5, [n2]) {
    t5[0] ? s2 ? (s2.p(t5, n2), 1 & n2 && transition_in(s2, 1)) : (s2 = create_if_block$17(t5), s2.c(), transition_in(s2, 1), s2.m(e.parentNode, e)) : s2 && (group_outros(), transition_out(s2, 1, 1, () => {
      s2 = null;
    }), check_outros());
  }, i(t5) {
    i || (transition_in(s2), transition_in(o2.$$.fragment, t5), i = true);
  }, o(t5) {
    transition_out(s2), transition_out(o2.$$.fragment, t5), i = false;
  }, d(t5) {
    t5 && (detach(e), detach(n)), s2 && s2.d(t5), destroy_component(o2), a = false, r2();
  } };
}
function instance$1M(t4, e, n) {
  let o2, { currencyOwner: i } = e, { ownerType: a } = e, r2 = false, s2 = null, c = null;
  function l(t5, e2) {
    "from" === t5 ? n(1, s2 = s2 === e2 ? null : e2) : n(2, c = c === e2 ? null : e2);
  }
  return t4.$$set = (t5) => {
    "currencyOwner" in t5 && n(7, i = t5.currencyOwner), "ownerType" in t5 && n(8, a = t5.ownerType);
  }, t4.$$.update = () => {
    128 & t4.$$.dirty && n(3, o2 = i.system.currency);
  }, [r2, s2, c, o2, l, function() {
    if (!s2 || !c || s2 === c) return;
    const { fromAmount: t5, resultAmount: e2 } = getConversionAmounts(s2, c);
    if (t5 <= o2[s2] && e2 > 0) {
      const n2 = { [s2]: o2[s2] - t5, [c]: o2[c] + e2 }, r3 = { system: { currency: Object.assign(Object.assign({}, o2), n2) } };
      "actor" === a ? FoundryGateway.updateActor(i, r3) : FoundryGateway.updateItem(i, r3);
    }
  }, function() {
    n(1, s2 = null), n(2, c = null), n(0, r2 = false);
  }, i, a, () => l("from", "pp"), () => l("from", "gp"), () => l("from", "ep"), () => l("from", "sp"), () => l("from", "cp"), () => l("to", "pp"), () => l("to", "gp"), () => l("to", "ep"), () => l("to", "sp"), () => l("to", "cp"), () => n(0, r2 = true)];
}
class CurrencyExchange extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1M, create_fragment$1N, safe_not_equal, { currencyOwner: 7, ownerType: 8 });
  }
}
function create_if_block$16(t4) {
  let e, n;
  return e = new NumberInputWithButtons({ props: { title: t4[4], currentValue: t4[5] } }), e.$on("close", t4[10]), e.$on("action", function() {
    is_function(t4[6]) && t4[6].apply(this, arguments);
  }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(n2, o2) {
    t4 = n2;
    const i = {};
    16 & o2 && (i.title = t4[4]), 32 & o2 && (i.currentValue = t4[5]), e.$set(i);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_fragment$1M(t4) {
  let e, n, o2, i, a, r2, s2, c, l, u, p2, d, m, f, _, h, g2, $2, b, y, v, k, w2, S2, T, x2, E, O, A2, C, D, M, j, I, N, P2, F, R, L2 = t4[3] && create_if_block$16(t4);
  return N = new CurrencyExchange({ props: { currencyOwner: t4[1], ownerType: t4[0] ? "container" : "actor" } }), { c() {
    L2 && L2.c(), e = space(), n = element("section"), o2 = element("label"), i = element("i"), a = space(), r2 = element("span"), r2.textContent = "Platinum", s2 = space(), c = element("input"), u = space(), p2 = element("label"), d = element("i"), m = space(), f = element("input"), h = space(), g2 = element("label"), $2 = element("i"), b = space(), y = element("input"), k = space(), w2 = element("label"), S2 = element("i"), T = space(), x2 = element("input"), O = space(), A2 = element("label"), C = element("i"), D = space(), M = element("input"), I = space(), create_component(N.$$.fragment), attr(i, "class", "currency pp svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1xepygq"), attr(i, "aria-hidden", "true"), attr(r2, "class", "sr-only"), attr(c, "id", "currency-pp"), attr(c, "name", "system.currency.pp"), attr(c, "class", "currency-input"), c.value = l = t4[2].pp, c.readOnly = true, attr(o2, "for", "currency-pp"), attr(o2, "class", "currency-label svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1xepygq"), attr(d, "class", "currency gp svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1xepygq"), attr(f, "id", "currency-gp"), attr(f, "name", "system.currency.gp"), attr(f, "class", "currency-input"), f.value = _ = t4[2].gp, f.readOnly = true, attr(p2, "aria-label", "Gold"), attr(p2, "for", "currency-gp"), attr(p2, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1xepygq"), attr($2, "class", "currency ep svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1xepygq"), attr(y, "id", "currency-ep"), attr(y, "name", "system.currency.ep"), attr(y, "class", "currency-input"), y.value = v = t4[2].ep, y.readOnly = true, attr(g2, "aria-label", "Electrum"), attr(g2, "for", "currency-ep"), attr(g2, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1xepygq"), attr(S2, "class", "currency sp svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1xepygq"), attr(x2, "id", "currency-sp"), attr(x2, "name", "system.currency.sp"), attr(x2, "class", "currency-input"), x2.value = E = t4[2].sp, x2.readOnly = true, attr(w2, "aria-label", "Silver"), attr(w2, "for", "currency-sp"), attr(w2, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1xepygq"), attr(C, "class", "currency cp svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1xepygq"), attr(M, "id", "currency-cp"), attr(M, "name", "system.currency.cp"), attr(M, "class", "currency-input"), M.value = j = t4[2].cp, M.readOnly = true, attr(A2, "aria-label", "Copper"), attr(A2, "for", "currency-cp"), attr(A2, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1xepygq"), attr(n, "class", "currency-container svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1xepygq");
  }, m(l2, _2) {
    L2 && L2.m(l2, _2), insert(l2, e, _2), insert(l2, n, _2), append(n, o2), append(o2, i), append(o2, a), append(o2, r2), append(o2, s2), append(o2, c), append(n, u), append(n, p2), append(p2, d), append(p2, m), append(p2, f), append(n, h), append(n, g2), append(g2, $2), append(g2, b), append(g2, y), append(n, k), append(n, w2), append(w2, S2), append(w2, T), append(w2, x2), append(n, O), append(n, A2), append(A2, C), append(A2, D), append(A2, M), append(n, I), mount_component(N, n, null), P2 = true, F || (R = [listen(c, "click", t4[11]), listen(f, "click", t4[12]), listen(y, "click", t4[13]), listen(x2, "click", t4[14]), listen(M, "click", t4[15])], F = true);
  }, p(t5, [n2]) {
    t5[3] ? L2 ? (L2.p(t5, n2), 8 & n2 && transition_in(L2, 1)) : (L2 = create_if_block$16(t5), L2.c(), transition_in(L2, 1), L2.m(e.parentNode, e)) : L2 && (group_outros(), transition_out(L2, 1, 1, () => {
      L2 = null;
    }), check_outros()), (!P2 || 4 & n2 && l !== (l = t5[2].pp) && c.value !== l) && (c.value = l), (!P2 || 4 & n2 && _ !== (_ = t5[2].gp) && f.value !== _) && (f.value = _), (!P2 || 4 & n2 && v !== (v = t5[2].ep) && y.value !== v) && (y.value = v), (!P2 || 4 & n2 && E !== (E = t5[2].sp) && x2.value !== E) && (x2.value = E), (!P2 || 4 & n2 && j !== (j = t5[2].cp) && M.value !== j) && (M.value = j);
    const o3 = {};
    2 & n2 && (o3.currencyOwner = t5[1]), 1 & n2 && (o3.ownerType = t5[0] ? "container" : "actor"), N.$set(o3);
  }, i(t5) {
    P2 || (transition_in(L2), transition_in(N.$$.fragment, t5), P2 = true);
  }, o(t5) {
    transition_out(L2), transition_out(N.$$.fragment, t5), P2 = false;
  }, d(t5) {
    t5 && (detach(e), detach(n)), L2 && L2.d(t5), destroy_component(N), F = false, run_all(R);
  } };
}
function instance$1L(t4, e, n) {
  let o2, i, a, { actor: r2 } = e, { selectedContainer: s2 } = e;
  function c(t5, e2) {
    n(2, o2[e2] = t5, o2), function() {
      const t6 = { system: { currency: o2 } };
      i ? FoundryGateway.updateItem(i, t6) : FoundryGateway.updateActor(r2, t6);
    }();
  }
  let l, u, p2 = false, d = "";
  function m(t5) {
    var e2;
    isReadOnlyActor(r2) || (n(3, p2 = true), n(4, d = null === (e2 = CONFIG.DND5E.currencies[t5]) || void 0 === e2 ? void 0 : e2.label), n(5, l = o2[t5]), n(6, u = (e3) => {
      let i2 = e3.detail.value;
      "add" === e3.detail.action && (i2 += o2[t5]), c(i2, t5), n(3, p2 = false);
    }));
  }
  return t4.$$set = (t5) => {
    "actor" in t5 && n(8, r2 = t5.actor), "selectedContainer" in t5 && n(9, s2 = t5.selectedContainer);
  }, t4.$$.update = () => {
    771 & t4.$$.dirty && (n(0, i = r2.itemTypes.container.find(({ id: t5 }) => t5 === s2)), i && "currency" in i.system ? n(1, a = i) : n(1, a = r2), n(2, o2 = a.system.currency));
  }, [i, a, o2, p2, d, l, u, m, r2, s2, () => n(3, p2 = false), () => m("pp"), () => m("gp"), () => m("ep"), () => m("sp"), () => m("cp")];
}
class Currency extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1L, create_fragment$1M, safe_not_equal, { actor: 8, selectedContainer: 9 });
  }
}
function create_if_block$15(t4) {
  let e;
  return { c() {
    e = element("p"), e.innerHTML = "<b></b>";
  }, m(t5, n) {
    insert(t5, e, n);
  }, d(t5) {
    t5 && detach(e);
  } };
}
function create_fragment$1L(t4) {
  let e, n = t4[0].capacity && create_if_block$15();
  return { c() {
    n && n.c(), e = empty();
  }, m(t5, o2) {
    n && n.m(t5, o2), insert(t5, e, o2);
  }, p(t5, [o2]) {
    t5[0].capacity ? n || (n = create_if_block$15(), n.c(), n.m(e.parentNode, e)) : n && (n.d(1), n = null);
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e), n && n.d(t5);
  } };
}
function instance$1K(t4, e, n) {
  let o2, { item: i } = e;
  return t4.$$set = (t5) => {
    "item" in t5 && n(1, i = t5.item);
  }, t4.$$.update = () => {
    2 & t4.$$.dirty && n(0, o2 = i.system);
  }, [o2, i];
}
class ContainerObject extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1K, create_fragment$1L, safe_not_equal, { item: 1 });
  }
}
function create_if_block$14(t4) {
  let e, n, o2, i, a, r2, s2 = t4[1]() + "";
  return { c() {
    e = element("p"), n = element("b"), n.textContent = `${i18n("DND5E.Type")}:`, o2 = space(), i = text(t4[0]), a = space(), r2 = text(s2);
  }, m(t5, s3) {
    insert(t5, e, s3), append(e, n), append(e, o2), append(e, i), append(e, a), append(e, r2);
  }, p: noop$3, d(t5) {
    t5 && detach(e);
  } };
}
function create_fragment$1K(t4) {
  let e, n = t4[0] && create_if_block$14(t4);
  return { c() {
    n && n.c(), e = empty();
  }, m(t5, o2) {
    n && n.m(t5, o2), insert(t5, e, o2);
  }, p(t5, [e2]) {
    t5[0] && n.p(t5, e2);
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e), n && n.d(t5);
  } };
}
function instance$1J(t4, e, n) {
  var o2;
  let { item: i } = e, a = i.system;
  const r2 = null === (o2 = CONFIG.DND5E.consumableTypes[a.type.value]) || void 0 === o2 ? void 0 : o2.label;
  return t4.$$set = (t5) => {
    "item" in t5 && n(2, i = t5.item);
  }, [r2, function() {
    const t5 = a.type.subtype, e2 = a.type.value;
    if (e2 && t5) {
      const n2 = CONFIG.DND5E.consumableTypes[e2], o3 = null == n2 ? void 0 : n2.subtypes[t5];
      if (o3) return " (" + o3 + ")";
    }
    return "";
  }, i];
}
class ConsumableObject extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1J, create_fragment$1K, safe_not_equal, { item: 2 });
  }
}
function create_if_block$13(t4) {
  let e, n, o2, i;
  return { c() {
    e = element("p"), n = element("b"), n.textContent = `${i18n("DND5E.ItemActivation")}:`, o2 = space(), i = text(t4[2]);
  }, m(t5, a) {
    insert(t5, e, a), append(e, n), append(e, o2), append(e, i);
  }, p: noop$3, d(t5) {
    t5 && detach(e);
  } };
}
function create_fragment$1J(t4) {
  let e, n = (t4[0]?.length > 0 || t4[1]?.length > 0) && create_if_block$13(t4);
  return { c() {
    n && n.c(), e = empty();
  }, m(t5, o2) {
    n && n.m(t5, o2), insert(t5, e, o2);
  }, p(t5, [e2]) {
    (t5[0]?.length > 0 || t5[1]?.length > 0) && n.p(t5, e2);
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e), n && n.d(t5);
  } };
}
function instance$1I(t4, e, n) {
  var o2;
  let { activity: i } = e, { activation: a, duration: r2 } = null !== (o2 = i.activationLabels) && void 0 !== o2 ? o2 : {};
  const s2 = [a, r2].filter((t5) => (null == t5 ? void 0 : t5.length) > 0).join(", ");
  return t4.$$set = (t5) => {
    "activity" in t5 && n(3, i = t5.activity);
  }, [a, r2, s2, i];
}
class Activation extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1I, create_fragment$1J, safe_not_equal, { activity: 3 });
  }
}
function create_if_block$12(t4) {
  let e, n, o2, i;
  return { c() {
    e = element("p"), n = element("b"), n.textContent = `${i18n("DND5E.Range")}:`, o2 = space(), i = text(t4[0]);
  }, m(t5, a) {
    insert(t5, e, a), append(e, n), append(e, o2), append(e, i);
  }, p: noop$3, d(t5) {
    t5 && detach(e);
  } };
}
function create_fragment$1I(t4) {
  let e, n = t4[0]?.length > 0 && create_if_block$12(t4);
  return { c() {
    n && n.c(), e = empty();
  }, m(t5, o2) {
    n && n.m(t5, o2), insert(t5, e, o2);
  }, p(t5, [e2]) {
    t5[0]?.length > 0 && n.p(t5, e2);
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e), n && n.d(t5);
  } };
}
function instance$1H(t4, e, n) {
  var o2;
  let { activity: i } = e, { range: a } = null !== (o2 = i.activationLabels) && void 0 !== o2 ? o2 : {};
  return t4.$$set = (t5) => {
    "activity" in t5 && n(1, i = t5.activity);
  }, [a, i];
}
class Range extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1H, create_fragment$1I, safe_not_equal, { activity: 1 });
  }
}
function create_if_block$11(t4) {
  let e, n, o2, i;
  return { c() {
    e = element("p"), n = element("b"), n.textContent = `${i18n("DND5E.Target")}:`, o2 = space(), i = text(t4[0]);
  }, m(t5, a) {
    insert(t5, e, a), append(e, n), append(e, o2), append(e, i);
  }, p: noop$3, d(t5) {
    t5 && detach(e);
  } };
}
function create_fragment$1H(t4) {
  let e, n = t4[0]?.length > 0 && create_if_block$11(t4);
  return { c() {
    n && n.c(), e = empty();
  }, m(t5, o2) {
    n && n.m(t5, o2), insert(t5, e, o2);
  }, p(t5, [e2]) {
    t5[0]?.length > 0 && n.p(t5, e2);
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e), n && n.d(t5);
  } };
}
function instance$1G(t4, e, n) {
  var o2;
  let { activity: i } = e, { target: a } = null !== (o2 = i.activationLabels) && void 0 !== o2 ? o2 : {};
  return t4.$$set = (t5) => {
    "activity" in t5 && n(1, i = t5.activity);
  }, [a, i];
}
class Target extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1G, create_fragment$1H, safe_not_equal, { activity: 1 });
  }
}
function create_if_block$10(t4) {
  let e, n, o2, i;
  return { c() {
    e = element("p"), n = element("b"), n.textContent = `${i18n("DND5E.Damage")}:`, o2 = space(), i = text(t4[0]);
  }, m(t5, a) {
    insert(t5, e, a), append(e, n), append(e, o2), append(e, i);
  }, p(t5, e2) {
    1 & e2 && set_data(i, t5[0]);
  }, d(t5) {
    t5 && detach(e);
  } };
}
function create_fragment$1G(t4) {
  let e, n = t4[0] && create_if_block$10(t4);
  return { c() {
    n && n.c(), e = empty();
  }, m(t5, o2) {
    n && n.m(t5, o2), insert(t5, e, o2);
  }, p(t5, [o2]) {
    t5[0] ? n ? n.p(t5, o2) : (n = create_if_block$10(t5), n.c(), n.m(e.parentNode, e)) : n && (n.d(1), n = null);
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e), n && n.d(t5);
  } };
}
function instance$1F(t4, e, n) {
  var o2;
  let i, { activity: a } = e, r2 = null === (o2 = null == a ? void 0 : a.labels) || void 0 === o2 ? void 0 : o2.damage;
  return r2 && r2.length > 0 && (i = r2.map((t5) => t5.label).join(", ")), t4.$$set = (t5) => {
    "activity" in t5 && n(1, a = t5.activity);
  }, [i, a];
}
class Damage extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1F, create_fragment$1G, safe_not_equal, { activity: 1 });
  }
}
function create_if_block$$(t4) {
  let e, n, o2, i;
  return { c() {
    e = element("p"), n = element("b"), n.textContent = `${i18n("DND5E.ToHit")}:`, o2 = text(" 1d20"), i = text(t4[0]);
  }, m(t5, a) {
    insert(t5, e, a), append(e, n), append(e, o2), append(e, i);
  }, p: noop$3, d(t5) {
    t5 && detach(e);
  } };
}
function create_fragment$1F(t4) {
  let e, n = t4[0] && t4[0]?.length > 0 && create_if_block$$(t4);
  return { c() {
    n && n.c(), e = empty();
  }, m(t5, o2) {
    n && n.m(t5, o2), insert(t5, e, o2);
  }, p(t5, [e2]) {
    t5[0] && t5[0]?.length > 0 && n.p(t5, e2);
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e), n && n.d(t5);
  } };
}
function instance$1E(t4, e, n) {
  var o2;
  let { activity: i } = e, { toHit: a } = null !== (o2 = i.labels) && void 0 !== o2 ? o2 : {};
  return t4.$$set = (t5) => {
    "activity" in t5 && n(1, i = t5.activity);
  }, [a, i];
}
class ToHit extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1E, create_fragment$1F, safe_not_equal, { activity: 1 });
  }
}
function create_if_block$_(t4) {
  let e, n, o2, i;
  return { c() {
    e = element("p"), n = element("b"), n.textContent = `${i18n("DND5E.Recovery")}:`, o2 = space(), i = text(t4[0]);
  }, m(t5, a) {
    insert(t5, e, a), append(e, n), append(e, o2), append(e, i);
  }, p: noop$3, d(t5) {
    t5 && detach(e);
  } };
}
function create_fragment$1E(t4) {
  let e, n = t4[0]?.length > 0 && create_if_block$_(t4);
  return { c() {
    n && n.c(), e = empty();
  }, m(t5, o2) {
    n && n.m(t5, o2), insert(t5, e, o2);
  }, p(t5, [e2]) {
    t5[0]?.length > 0 && n.p(t5, e2);
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e), n && n.d(t5);
  } };
}
function instance$1D(t4, e, n) {
  var o2;
  let { activity: i } = e, { recovery: a } = null !== (o2 = i.labels) && void 0 !== o2 ? o2 : {};
  return t4.$$set = (t5) => {
    "activity" in t5 && n(1, i = t5.activity);
  }, [a, i];
}
class Recovery extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1D, create_fragment$1E, safe_not_equal, { activity: 1 });
  }
}
function create_if_block_3$9(t4) {
  let e, n, o2, i, a = t4[0].labels.recharge + "";
  return { c() {
    e = element("p"), n = element("b"), n.textContent = `${i18n("DND5E.Recharge")}:`, o2 = space(), i = text(a);
  }, m(t5, a2) {
    insert(t5, e, a2), append(e, n), append(e, o2), append(e, i);
  }, p(t5, e2) {
    1 & e2 && a !== (a = t5[0].labels.recharge + "") && set_data(i, a);
  }, d(t5) {
    t5 && detach(e);
  } };
}
function create_if_block$Z(t4) {
  let e, n, o2, i, a, r2, s2, c, l, u, p2 = t4[0].uses.value + "", d = t4[0].uses.max + "";
  const m = [create_if_block_1$w, create_if_block_2$h], f = [];
  function _(t5, e2) {
    return t5[0].uses.value > 0 ? 0 : t5[0].uses.recovery ? 1 : -1;
  }
  return ~(c = _(t4)) && (l = f[c] = m[c](t4)), { c() {
    e = element("p"), n = element("b"), n.textContent = `${i18n("DND5E.Uses")}:`, o2 = space(), i = text(p2), a = text(" / "), r2 = text(d), s2 = space(), l && l.c();
  }, m(t5, l2) {
    insert(t5, e, l2), append(e, n), append(e, o2), append(e, i), append(e, a), append(e, r2), append(e, s2), ~c && f[c].m(e, null), u = true;
  }, p(t5, n2) {
    (!u || 1 & n2) && p2 !== (p2 = t5[0].uses.value + "") && set_data(i, p2), (!u || 1 & n2) && d !== (d = t5[0].uses.max + "") && set_data(r2, d);
    let o3 = c;
    c = _(t5), c === o3 ? ~c && f[c].p(t5, n2) : (l && (group_outros(), transition_out(f[o3], 1, 1, () => {
      f[o3] = null;
    }), check_outros()), ~c ? (l = f[c], l ? l.p(t5, n2) : (l = f[c] = m[c](t5), l.c()), transition_in(l, 1), l.m(e, null)) : l = null);
  }, i(t5) {
    u || (transition_in(l), u = true);
  }, o(t5) {
    transition_out(l), u = false;
  }, d(t5) {
    t5 && detach(e), ~c && f[c].d();
  } };
}
function create_if_block_2$h(t4) {
  let e, n, o2;
  return n = new MCButton({ props: { customClass: "dnd5e-activity-recharge", $$slots: { default: [create_default_slot_1$3] }, $$scope: { ctx: t4 } } }), n.$on("click", t4[2]), { c() {
    e = element("span"), create_component(n.$$.fragment);
  }, m(t5, i) {
    insert(t5, e, i), mount_component(n, e, null), o2 = true;
  }, p(t5, e2) {
    const o3 = {};
    8 & e2 && (o3.$$scope = { dirty: e2, ctx: t5 }), n.$set(o3);
  }, i(t5) {
    o2 || (transition_in(n.$$.fragment, t5), o2 = true);
  }, o(t5) {
    transition_out(n.$$.fragment, t5), o2 = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(n);
  } };
}
function create_if_block_1$w(t4) {
  let e, n, o2;
  return n = new MCButton({ props: { customClass: "dnd5e-activity-use", $$slots: { default: [create_default_slot$f] }, $$scope: { ctx: t4 } } }), n.$on("click", t4[1]), { c() {
    e = element("span"), create_component(n.$$.fragment);
  }, m(t5, i) {
    insert(t5, e, i), mount_component(n, e, null), o2 = true;
  }, p(t5, e2) {
    const o3 = {};
    8 & e2 && (o3.$$scope = { dirty: e2, ctx: t5 }), n.$set(o3);
  }, i(t5) {
    o2 || (transition_in(n.$$.fragment, t5), o2 = true);
  }, o(t5) {
    transition_out(n.$$.fragment, t5), o2 = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(n);
  } };
}
function create_default_slot_1$3(t4) {
  let e, n, o2, i = i18n("DND5E.Recharge") + "";
  return { c() {
    e = element("i"), n = space(), o2 = text(i), attr(e, "class", "fas fa-arrows-rotate");
  }, m(t5, i2) {
    insert(t5, e, i2), insert(t5, n, i2), insert(t5, o2, i2);
  }, p: noop$3, d(t5) {
    t5 && (detach(e), detach(n), detach(o2));
  } };
}
function create_default_slot$f(t4) {
  let e, n, o2, i = i18n("DND5E.Use") + "";
  return { c() {
    e = element("i"), n = space(), o2 = text(i), attr(e, "class", "fas fa-bolt");
  }, m(t5, i2) {
    insert(t5, e, i2), insert(t5, n, i2), insert(t5, o2, i2);
  }, p: noop$3, d(t5) {
    t5 && (detach(e), detach(n), detach(o2));
  } };
}
function create_fragment$1D(t4) {
  let e, n, o2, i = t4[0].labels.recharge && create_if_block_3$9(t4), a = t4[0].uses && t4[0].uses.max && create_if_block$Z(t4);
  return { c() {
    i && i.c(), e = space(), a && a.c(), n = empty();
  }, m(t5, r2) {
    i && i.m(t5, r2), insert(t5, e, r2), a && a.m(t5, r2), insert(t5, n, r2), o2 = true;
  }, p(t5, [o3]) {
    t5[0].labels.recharge ? i ? i.p(t5, o3) : (i = create_if_block_3$9(t5), i.c(), i.m(e.parentNode, e)) : i && (i.d(1), i = null), t5[0].uses && t5[0].uses.max ? a ? (a.p(t5, o3), 1 & o3 && transition_in(a, 1)) : (a = create_if_block$Z(t5), a.c(), transition_in(a, 1), a.m(n.parentNode, n)) : a && (group_outros(), transition_out(a, 1, 1, () => {
      a = null;
    }), check_outros());
  }, i(t5) {
    o2 || (transition_in(a), o2 = true);
  }, o(t5) {
    transition_out(a), o2 = false;
  }, d(t5) {
    t5 && (detach(e), detach(n)), i && i.d(t5), a && a.d(t5);
  } };
}
function instance$1C(t4, e, n) {
  let { activity: o2 } = e;
  return t4.$$set = (t5) => {
    "activity" in t5 && n(0, o2 = t5.activity);
  }, [o2, function() {
    if (o2.uses) {
      const t5 = {};
      t5["uses.spent"] = o2.uses.spent + 1, FoundryGateway.updateActivity(o2, t5);
    }
  }, function() {
    const t5 = { "uses.spent": 0 };
    FoundryGateway.updateActivity(o2, t5);
  }];
}
class Uses extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1C, create_fragment$1D, safe_not_equal, { activity: 0 });
  }
}
function create_if_block$Y(t4) {
  let e, n, o2;
  return { c() {
    e = text("- "), n = element("i"), o2 = text(t4[2]);
  }, m(t5, i) {
    insert(t5, e, i), insert(t5, n, i), append(n, o2);
  }, p(t5, e2) {
    4 & e2 && set_data(o2, t5[2]);
  }, d(t5) {
    t5 && (detach(e), detach(n));
  } };
}
function create_fragment$1C(t4) {
  let e, n, o2, i, a, r2, s2, c, l, u = t4[2] && create_if_block$Y(t4);
  return { c() {
    e = element("div"), n = element("dnd5e-icon"), i = space(), a = element("p"), r2 = text(t4[1]), s2 = space(), u && u.c(), set_custom_element_data(n, "class", "image svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1qnpeuw"), src_url_equal(n.src, o2 = t4[0]) || set_custom_element_data(n, "src", o2), attr(e, "class", "activity svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1qnpeuw"), attr(e, "role", "button"), attr(e, "aria-hidden", "true");
  }, m(o3, p2) {
    insert(o3, e, p2), append(e, n), append(e, i), append(e, a), append(a, r2), append(a, s2), u && u.m(a, null), c || (l = listen(e, "click", stop_propagation(function() {
      is_function(t4[3]) && t4[3].apply(this, arguments);
    })), c = true);
  }, p(e2, [i2]) {
    t4 = e2, 1 & i2 && !src_url_equal(n.src, o2 = t4[0]) && set_custom_element_data(n, "src", o2), 2 & i2 && set_data(r2, t4[1]), t4[2] ? u ? u.p(t4, i2) : (u = create_if_block$Y(t4), u.c(), u.m(a, null)) : u && (u.d(1), u = null);
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e), u && u.d(), c = false, l();
  } };
}
function instance$1B(t4, e, n) {
  let { iconSrc: o2 } = e, { title: i } = e, { activation: a } = e, { onClick: r2 } = e;
  return t4.$$set = (t5) => {
    "iconSrc" in t5 && n(0, o2 = t5.iconSrc), "title" in t5 && n(1, i = t5.title), "activation" in t5 && n(2, a = t5.activation), "onClick" in t5 && n(3, r2 = t5.onClick);
  }, [o2, i, a, r2];
}
class ActivityTitle extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1B, create_fragment$1C, safe_not_equal, { iconSrc: 0, title: 1, activation: 2, onClick: 3 });
  }
}
function create_fragment$1B(t4) {
  let e, n, o2;
  const i = t4[1].default, a = create_slot(i, t4, t4[0], null);
  return { c() {
    e = element("div"), a && a.c(), attr(e, "class", "details svelte-mobile-companion-dnd5e-81nkluj30u9vsd-wvn87t");
  }, m(t5, n2) {
    insert(t5, e, n2), a && a.m(e, null), o2 = true;
  }, p(t5, [e2]) {
    a && a.p && (!o2 || 1 & e2) && update_slot_base(a, i, t5, t5[0], o2 ? get_slot_changes(i, t5[0], e2, null) : get_all_dirty_from_scope(t5[0]), null);
  }, i(t5) {
    o2 || (transition_in(a, t5), t5 && add_render_callback(() => {
      o2 && (n || (n = create_bidirectional_transition(e, slide, { duration: 200, easing: identity, axis: "y" }, true)), n.run(1));
    }), o2 = true);
  }, o(t5) {
    transition_out(a, t5), t5 && (n || (n = create_bidirectional_transition(e, slide, { duration: 200, easing: identity, axis: "y" }, false)), n.run(0)), o2 = false;
  }, d(t5) {
    t5 && detach(e), a && a.d(t5), t5 && n && n.end();
  } };
}
function instance$1A(t4, e, n) {
  let { $$slots: o2 = {}, $$scope: i } = e;
  return t4.$$set = (t5) => {
    "$$scope" in t5 && n(0, i = t5.$$scope);
  }, [i, o2];
}
class ActivityDetails extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1A, create_fragment$1B, safe_not_equal, {});
  }
}
function create_if_block$X(t4) {
  let e, n;
  return e = new ActivityDetails({ props: { $$slots: { default: [create_default_slot$e] }, $$scope: { ctx: t4 } } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    9 & n2 && (o2.$$scope = { dirty: n2, ctx: t5 }), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_default_slot$e(t4) {
  let e, n, o2, i, a, r2, s2, c, l, u, p2, d, m, f;
  return e = new Activation({ props: { activity: t4[0] } }), o2 = new Recovery({ props: { activity: t4[0] } }), a = new Uses({ props: { activity: t4[0] } }), s2 = new Range({ props: { activity: t4[0] } }), l = new Target({ props: { activity: t4[0] } }), p2 = new ToHit({ props: { activity: t4[0] } }), m = new Damage({ props: { activity: t4[0] } }), { c() {
    create_component(e.$$.fragment), n = space(), create_component(o2.$$.fragment), i = space(), create_component(a.$$.fragment), r2 = space(), create_component(s2.$$.fragment), c = space(), create_component(l.$$.fragment), u = space(), create_component(p2.$$.fragment), d = space(), create_component(m.$$.fragment);
  }, m(t5, _) {
    mount_component(e, t5, _), insert(t5, n, _), mount_component(o2, t5, _), insert(t5, i, _), mount_component(a, t5, _), insert(t5, r2, _), mount_component(s2, t5, _), insert(t5, c, _), mount_component(l, t5, _), insert(t5, u, _), mount_component(p2, t5, _), insert(t5, d, _), mount_component(m, t5, _), f = true;
  }, p(t5, n2) {
    const i2 = {};
    1 & n2 && (i2.activity = t5[0]), e.$set(i2);
    const r3 = {};
    1 & n2 && (r3.activity = t5[0]), o2.$set(r3);
    const c2 = {};
    1 & n2 && (c2.activity = t5[0]), a.$set(c2);
    const u2 = {};
    1 & n2 && (u2.activity = t5[0]), s2.$set(u2);
    const d2 = {};
    1 & n2 && (d2.activity = t5[0]), l.$set(d2);
    const f2 = {};
    1 & n2 && (f2.activity = t5[0]), p2.$set(f2);
    const _ = {};
    1 & n2 && (_.activity = t5[0]), m.$set(_);
  }, i(t5) {
    f || (transition_in(e.$$.fragment, t5), transition_in(o2.$$.fragment, t5), transition_in(a.$$.fragment, t5), transition_in(s2.$$.fragment, t5), transition_in(l.$$.fragment, t5), transition_in(p2.$$.fragment, t5), transition_in(m.$$.fragment, t5), f = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), transition_out(o2.$$.fragment, t5), transition_out(a.$$.fragment, t5), transition_out(s2.$$.fragment, t5), transition_out(l.$$.fragment, t5), transition_out(p2.$$.fragment, t5), transition_out(m.$$.fragment, t5), f = false;
  }, d(t5) {
    t5 && (detach(n), detach(i), detach(r2), detach(c), detach(u), detach(d)), destroy_component(e, t5), destroy_component(o2, t5), destroy_component(a, t5), destroy_component(s2, t5), destroy_component(l, t5), destroy_component(p2, t5), destroy_component(m, t5);
  } };
}
function create_fragment$1A(t4) {
  let e, n, o2, i;
  n = new ActivityTitle({ props: { title: i18n("DND5E.ATTACK.Title.one"), activation: t4[0]?.labels?.activation, iconSrc: "systems/dnd5e/icons/svg/activity/attack.svg", onClick: t4[2] } });
  let a = t4[1] && create_if_block$X(t4);
  return { c() {
    e = element("div"), create_component(n.$$.fragment), o2 = space(), a && a.c(), attr(e, "class", "activity-row");
  }, m(t5, r2) {
    insert(t5, e, r2), mount_component(n, e, null), append(e, o2), a && a.m(e, null), i = true;
  }, p(t5, [o3]) {
    const i2 = {};
    1 & o3 && (i2.activation = t5[0]?.labels?.activation), n.$set(i2), t5[1] ? a ? (a.p(t5, o3), 2 & o3 && transition_in(a, 1)) : (a = create_if_block$X(t5), a.c(), transition_in(a, 1), a.m(e, null)) : a && (group_outros(), transition_out(a, 1, 1, () => {
      a = null;
    }), check_outros());
  }, i(t5) {
    i || (transition_in(n.$$.fragment, t5), transition_in(a), i = true);
  }, o(t5) {
    transition_out(n.$$.fragment, t5), transition_out(a), i = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(n), a && a.d();
  } };
}
function instance$1z(t4, e, n) {
  let o2, { activity: i } = e;
  return t4.$$set = (t5) => {
    "activity" in t5 && n(0, i = t5.activity);
  }, [i, o2, function() {
    n(1, o2 = !o2);
  }];
}
class AttackActivity extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1z, create_fragment$1A, safe_not_equal, { activity: 0 });
  }
}
function create_if_block$W(t4) {
  let e, n;
  return e = new ActivityDetails({ props: { $$slots: { default: [create_default_slot$d] }, $$scope: { ctx: t4 } } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    129 & n2 && (o2.$$scope = { dirty: n2, ctx: t5 }), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_if_block_1$v(t4) {
  let e, n, o2, i, a, r2, s2, c = i18n("DND5E.AbbreviationDC") + "", l = t4[0].check.dc.value + "";
  return { c() {
    e = element("p"), n = element("b"), o2 = text(c), i = space(), a = text(l), r2 = space(), s2 = text(t4[2]);
  }, m(t5, c2) {
    insert(t5, e, c2), append(e, n), append(n, o2), append(n, i), append(n, a), append(e, r2), append(e, s2);
  }, p(t5, e2) {
    1 & e2 && l !== (l = t5[0].check.dc.value + "") && set_data(a, l);
  }, d(t5) {
    t5 && detach(e);
  } };
}
function create_default_slot$d(t4) {
  let e, n, o2, i, a, r2, s2, c, l, u, p2, d;
  e = new Activation({ props: { activity: t4[0] } }), o2 = new Recovery({ props: { activity: t4[0] } }), a = new Uses({ props: { activity: t4[0] } }), s2 = new Range({ props: { activity: t4[0] } }), l = new Target({ props: { activity: t4[0] } });
  let m = t4[2].length > 0 && create_if_block_1$v(t4);
  return { c() {
    create_component(e.$$.fragment), n = space(), create_component(o2.$$.fragment), i = space(), create_component(a.$$.fragment), r2 = space(), create_component(s2.$$.fragment), c = space(), create_component(l.$$.fragment), u = space(), m && m.c(), p2 = empty();
  }, m(t5, f) {
    mount_component(e, t5, f), insert(t5, n, f), mount_component(o2, t5, f), insert(t5, i, f), mount_component(a, t5, f), insert(t5, r2, f), mount_component(s2, t5, f), insert(t5, c, f), mount_component(l, t5, f), insert(t5, u, f), m && m.m(t5, f), insert(t5, p2, f), d = true;
  }, p(t5, n2) {
    const i2 = {};
    1 & n2 && (i2.activity = t5[0]), e.$set(i2);
    const r3 = {};
    1 & n2 && (r3.activity = t5[0]), o2.$set(r3);
    const c2 = {};
    1 & n2 && (c2.activity = t5[0]), a.$set(c2);
    const u2 = {};
    1 & n2 && (u2.activity = t5[0]), s2.$set(u2);
    const p3 = {};
    1 & n2 && (p3.activity = t5[0]), l.$set(p3), t5[2].length > 0 && m.p(t5, n2);
  }, i(t5) {
    d || (transition_in(e.$$.fragment, t5), transition_in(o2.$$.fragment, t5), transition_in(a.$$.fragment, t5), transition_in(s2.$$.fragment, t5), transition_in(l.$$.fragment, t5), d = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), transition_out(o2.$$.fragment, t5), transition_out(a.$$.fragment, t5), transition_out(s2.$$.fragment, t5), transition_out(l.$$.fragment, t5), d = false;
  }, d(t5) {
    t5 && (detach(n), detach(i), detach(r2), detach(c), detach(u), detach(p2)), destroy_component(e, t5), destroy_component(o2, t5), destroy_component(a, t5), destroy_component(s2, t5), destroy_component(l, t5), m && m.d(t5);
  } };
}
function create_fragment$1z(t4) {
  let e, n, o2, i;
  n = new ActivityTitle({ props: { title: i18n("DND5E.CHECK.Title"), activation: t4[0]?.labels?.activation, iconSrc: "systems/dnd5e/icons/svg/activity/check.svg", onClick: t4[3] } });
  let a = t4[1] && create_if_block$W(t4);
  return { c() {
    e = element("div"), create_component(n.$$.fragment), o2 = space(), a && a.c(), attr(e, "class", "activity-row");
  }, m(t5, r2) {
    insert(t5, e, r2), mount_component(n, e, null), append(e, o2), a && a.m(e, null), i = true;
  }, p(t5, [o3]) {
    const i2 = {};
    1 & o3 && (i2.activation = t5[0]?.labels?.activation), n.$set(i2), t5[1] ? a ? (a.p(t5, o3), 2 & o3 && transition_in(a, 1)) : (a = create_if_block$W(t5), a.c(), transition_in(a, 1), a.m(e, null)) : a && (group_outros(), transition_out(a, 1, 1, () => {
      a = null;
    }), check_outros());
  }, i(t5) {
    i || (transition_in(n.$$.fragment, t5), transition_in(a), i = true);
  }, o(t5) {
    transition_out(n.$$.fragment, t5), transition_out(a), i = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(n), a && a.d();
  } };
}
function instance$1y(t4, e, n) {
  var o2;
  let { activity: i } = e, a = [];
  (null === (o2 = null == i ? void 0 : i.check) || void 0 === o2 ? void 0 : o2.associated) && (a = Array.from(i.check.associated).map((t5) => i18n(CONFIG.DND5E.skills[t5].label)));
  const r2 = CONFIG.DND5E.abilities[i.check.ability], s2 = r2 ? r2.label + " (" + a.join(", ") + ")" : "";
  let c;
  return t4.$$set = (t5) => {
    "activity" in t5 && n(0, i = t5.activity);
  }, [i, c, s2, function() {
    n(1, c = !c);
  }];
}
class CheckActivity extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1y, create_fragment$1z, safe_not_equal, { activity: 0 });
  }
}
function create_if_block$V(t4) {
  let e, n;
  return e = new ActivityDetails({ props: { $$slots: { default: [create_default_slot$c] }, $$scope: { ctx: t4 } } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    9 & n2 && (o2.$$scope = { dirty: n2, ctx: t5 }), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_default_slot$c(t4) {
  let e, n, o2, i, a, r2, s2, c, l, u, p2, d;
  return e = new Activation({ props: { activity: t4[0] } }), o2 = new Recovery({ props: { activity: t4[0] } }), a = new Uses({ props: { activity: t4[0] } }), s2 = new Range({ props: { activity: t4[0] } }), l = new Target({ props: { activity: t4[0] } }), p2 = new Damage({ props: { activity: t4[0] } }), { c() {
    create_component(e.$$.fragment), n = space(), create_component(o2.$$.fragment), i = space(), create_component(a.$$.fragment), r2 = space(), create_component(s2.$$.fragment), c = space(), create_component(l.$$.fragment), u = space(), create_component(p2.$$.fragment);
  }, m(t5, m) {
    mount_component(e, t5, m), insert(t5, n, m), mount_component(o2, t5, m), insert(t5, i, m), mount_component(a, t5, m), insert(t5, r2, m), mount_component(s2, t5, m), insert(t5, c, m), mount_component(l, t5, m), insert(t5, u, m), mount_component(p2, t5, m), d = true;
  }, p(t5, n2) {
    const i2 = {};
    1 & n2 && (i2.activity = t5[0]), e.$set(i2);
    const r3 = {};
    1 & n2 && (r3.activity = t5[0]), o2.$set(r3);
    const c2 = {};
    1 & n2 && (c2.activity = t5[0]), a.$set(c2);
    const u2 = {};
    1 & n2 && (u2.activity = t5[0]), s2.$set(u2);
    const d2 = {};
    1 & n2 && (d2.activity = t5[0]), l.$set(d2);
    const m = {};
    1 & n2 && (m.activity = t5[0]), p2.$set(m);
  }, i(t5) {
    d || (transition_in(e.$$.fragment, t5), transition_in(o2.$$.fragment, t5), transition_in(a.$$.fragment, t5), transition_in(s2.$$.fragment, t5), transition_in(l.$$.fragment, t5), transition_in(p2.$$.fragment, t5), d = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), transition_out(o2.$$.fragment, t5), transition_out(a.$$.fragment, t5), transition_out(s2.$$.fragment, t5), transition_out(l.$$.fragment, t5), transition_out(p2.$$.fragment, t5), d = false;
  }, d(t5) {
    t5 && (detach(n), detach(i), detach(r2), detach(c), detach(u)), destroy_component(e, t5), destroy_component(o2, t5), destroy_component(a, t5), destroy_component(s2, t5), destroy_component(l, t5), destroy_component(p2, t5);
  } };
}
function create_fragment$1y(t4) {
  let e, n, o2, i;
  n = new ActivityTitle({ props: { title: i18n("DND5E.DAMAGE.Title"), activation: t4[0]?.labels?.activation, iconSrc: "systems/dnd5e/icons/svg/activity/damage.svg", onClick: t4[2] } });
  let a = t4[1] && create_if_block$V(t4);
  return { c() {
    e = element("div"), create_component(n.$$.fragment), o2 = space(), a && a.c(), attr(e, "class", "activity-row");
  }, m(t5, r2) {
    insert(t5, e, r2), mount_component(n, e, null), append(e, o2), a && a.m(e, null), i = true;
  }, p(t5, [o3]) {
    const i2 = {};
    1 & o3 && (i2.activation = t5[0]?.labels?.activation), n.$set(i2), t5[1] ? a ? (a.p(t5, o3), 2 & o3 && transition_in(a, 1)) : (a = create_if_block$V(t5), a.c(), transition_in(a, 1), a.m(e, null)) : a && (group_outros(), transition_out(a, 1, 1, () => {
      a = null;
    }), check_outros());
  }, i(t5) {
    i || (transition_in(n.$$.fragment, t5), transition_in(a), i = true);
  }, o(t5) {
    transition_out(n.$$.fragment, t5), transition_out(a), i = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(n), a && a.d();
  } };
}
function instance$1x(t4, e, n) {
  let o2, { activity: i } = e;
  return t4.$$set = (t5) => {
    "activity" in t5 && n(0, i = t5.activity);
  }, [i, o2, function() {
    n(1, o2 = !o2);
  }];
}
class DamageActivity extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1x, create_fragment$1y, safe_not_equal, { activity: 0 });
  }
}
function create_if_block$U(t4) {
  let e, n;
  return e = new ActivityDetails({ props: { $$slots: { default: [create_default_slot$b] }, $$scope: { ctx: t4 } } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    9 & n2 && (o2.$$scope = { dirty: n2, ctx: t5 }), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_default_slot$b(t4) {
  let e, n, o2, i, a, r2, s2, c, l, u, p2, d;
  return e = new Activation({ props: { activity: t4[0] } }), o2 = new Recovery({ props: { activity: t4[0] } }), a = new Uses({ props: { activity: t4[0] } }), s2 = new Range({ props: { activity: t4[0] } }), l = new Target({ props: { activity: t4[0] } }), p2 = new Range({ props: { activity: t4[0] } }), { c() {
    create_component(e.$$.fragment), n = space(), create_component(o2.$$.fragment), i = space(), create_component(a.$$.fragment), r2 = space(), create_component(s2.$$.fragment), c = space(), create_component(l.$$.fragment), u = space(), create_component(p2.$$.fragment);
  }, m(t5, m) {
    mount_component(e, t5, m), insert(t5, n, m), mount_component(o2, t5, m), insert(t5, i, m), mount_component(a, t5, m), insert(t5, r2, m), mount_component(s2, t5, m), insert(t5, c, m), mount_component(l, t5, m), insert(t5, u, m), mount_component(p2, t5, m), d = true;
  }, p(t5, n2) {
    const i2 = {};
    1 & n2 && (i2.activity = t5[0]), e.$set(i2);
    const r3 = {};
    1 & n2 && (r3.activity = t5[0]), o2.$set(r3);
    const c2 = {};
    1 & n2 && (c2.activity = t5[0]), a.$set(c2);
    const u2 = {};
    1 & n2 && (u2.activity = t5[0]), s2.$set(u2);
    const d2 = {};
    1 & n2 && (d2.activity = t5[0]), l.$set(d2);
    const m = {};
    1 & n2 && (m.activity = t5[0]), p2.$set(m);
  }, i(t5) {
    d || (transition_in(e.$$.fragment, t5), transition_in(o2.$$.fragment, t5), transition_in(a.$$.fragment, t5), transition_in(s2.$$.fragment, t5), transition_in(l.$$.fragment, t5), transition_in(p2.$$.fragment, t5), d = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), transition_out(o2.$$.fragment, t5), transition_out(a.$$.fragment, t5), transition_out(s2.$$.fragment, t5), transition_out(l.$$.fragment, t5), transition_out(p2.$$.fragment, t5), d = false;
  }, d(t5) {
    t5 && (detach(n), detach(i), detach(r2), detach(c), detach(u)), destroy_component(e, t5), destroy_component(o2, t5), destroy_component(a, t5), destroy_component(s2, t5), destroy_component(l, t5), destroy_component(p2, t5);
  } };
}
function create_fragment$1x(t4) {
  let e, n, o2, i;
  n = new ActivityTitle({ props: { title: i18n("DND5E.ENCHANT.Title"), activation: t4[0]?.labels?.activation, iconSrc: "systems/dnd5e/icons/svg/activity/enchant.svg", onClick: t4[2] } });
  let a = t4[1] && create_if_block$U(t4);
  return { c() {
    e = element("div"), create_component(n.$$.fragment), o2 = space(), a && a.c(), attr(e, "class", "activity-row");
  }, m(t5, r2) {
    insert(t5, e, r2), mount_component(n, e, null), append(e, o2), a && a.m(e, null), i = true;
  }, p(t5, [o3]) {
    const i2 = {};
    1 & o3 && (i2.activation = t5[0]?.labels?.activation), n.$set(i2), t5[1] ? a ? (a.p(t5, o3), 2 & o3 && transition_in(a, 1)) : (a = create_if_block$U(t5), a.c(), transition_in(a, 1), a.m(e, null)) : a && (group_outros(), transition_out(a, 1, 1, () => {
      a = null;
    }), check_outros());
  }, i(t5) {
    i || (transition_in(n.$$.fragment, t5), transition_in(a), i = true);
  }, o(t5) {
    transition_out(n.$$.fragment, t5), transition_out(a), i = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(n), a && a.d();
  } };
}
function instance$1w(t4, e, n) {
  let o2, { activity: i } = e;
  return t4.$$set = (t5) => {
    "activity" in t5 && n(0, i = t5.activity);
  }, [i, o2, function() {
    n(1, o2 = !o2);
  }];
}
class EnchantActivity extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1w, create_fragment$1x, safe_not_equal, { activity: 0 });
  }
}
function create_if_block$T(t4) {
  let e, n, o2, i;
  return { c() {
    e = element("p"), n = element("b"), n.textContent = `${i18n("DND5E.Healing")}:`, o2 = space(), i = text(t4[0]);
  }, m(t5, a) {
    insert(t5, e, a), append(e, n), append(e, o2), append(e, i);
  }, p(t5, e2) {
    1 & e2 && set_data(i, t5[0]);
  }, d(t5) {
    t5 && detach(e);
  } };
}
function create_fragment$1w(t4) {
  let e, n = t4[0] && create_if_block$T(t4);
  return { c() {
    n && n.c(), e = empty();
  }, m(t5, o2) {
    n && n.m(t5, o2), insert(t5, e, o2);
  }, p(t5, [o2]) {
    t5[0] ? n ? n.p(t5, o2) : (n = create_if_block$T(t5), n.c(), n.m(e.parentNode, e)) : n && (n.d(1), n = null);
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e), n && n.d(t5);
  } };
}
function instance$1v(t4, e, n) {
  var o2;
  let i, { activity: a } = e, r2 = null === (o2 = null == a ? void 0 : a.labels) || void 0 === o2 ? void 0 : o2.damage;
  return r2 && r2.length > 0 && (i = r2.map((t5) => t5.label).join(", ")), t4.$$set = (t5) => {
    "activity" in t5 && n(1, a = t5.activity);
  }, [i, a];
}
class Healing extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1v, create_fragment$1w, safe_not_equal, { activity: 1 });
  }
}
function create_if_block$S(t4) {
  let e, n;
  return e = new ActivityDetails({ props: { $$slots: { default: [create_default_slot$a] }, $$scope: { ctx: t4 } } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    9 & n2 && (o2.$$scope = { dirty: n2, ctx: t5 }), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_default_slot$a(t4) {
  let e, n, o2, i, a, r2, s2, c, l, u, p2, d, m, f;
  return e = new Activation({ props: { activity: t4[0] } }), o2 = new Recovery({ props: { activity: t4[0] } }), a = new Uses({ props: { activity: t4[0] } }), s2 = new Range({ props: { activity: t4[0] } }), l = new Target({ props: { activity: t4[0] } }), p2 = new ToHit({ props: { activity: t4[0] } }), m = new Healing({ props: { activity: t4[0] } }), { c() {
    create_component(e.$$.fragment), n = space(), create_component(o2.$$.fragment), i = space(), create_component(a.$$.fragment), r2 = space(), create_component(s2.$$.fragment), c = space(), create_component(l.$$.fragment), u = space(), create_component(p2.$$.fragment), d = space(), create_component(m.$$.fragment);
  }, m(t5, _) {
    mount_component(e, t5, _), insert(t5, n, _), mount_component(o2, t5, _), insert(t5, i, _), mount_component(a, t5, _), insert(t5, r2, _), mount_component(s2, t5, _), insert(t5, c, _), mount_component(l, t5, _), insert(t5, u, _), mount_component(p2, t5, _), insert(t5, d, _), mount_component(m, t5, _), f = true;
  }, p(t5, n2) {
    const i2 = {};
    1 & n2 && (i2.activity = t5[0]), e.$set(i2);
    const r3 = {};
    1 & n2 && (r3.activity = t5[0]), o2.$set(r3);
    const c2 = {};
    1 & n2 && (c2.activity = t5[0]), a.$set(c2);
    const u2 = {};
    1 & n2 && (u2.activity = t5[0]), s2.$set(u2);
    const d2 = {};
    1 & n2 && (d2.activity = t5[0]), l.$set(d2);
    const f2 = {};
    1 & n2 && (f2.activity = t5[0]), p2.$set(f2);
    const _ = {};
    1 & n2 && (_.activity = t5[0]), m.$set(_);
  }, i(t5) {
    f || (transition_in(e.$$.fragment, t5), transition_in(o2.$$.fragment, t5), transition_in(a.$$.fragment, t5), transition_in(s2.$$.fragment, t5), transition_in(l.$$.fragment, t5), transition_in(p2.$$.fragment, t5), transition_in(m.$$.fragment, t5), f = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), transition_out(o2.$$.fragment, t5), transition_out(a.$$.fragment, t5), transition_out(s2.$$.fragment, t5), transition_out(l.$$.fragment, t5), transition_out(p2.$$.fragment, t5), transition_out(m.$$.fragment, t5), f = false;
  }, d(t5) {
    t5 && (detach(n), detach(i), detach(r2), detach(c), detach(u), detach(d)), destroy_component(e, t5), destroy_component(o2, t5), destroy_component(a, t5), destroy_component(s2, t5), destroy_component(l, t5), destroy_component(p2, t5), destroy_component(m, t5);
  } };
}
function create_fragment$1v(t4) {
  let e, n, o2, i;
  n = new ActivityTitle({ props: { title: i18n("DND5E.HEAL.Title"), activation: t4[0]?.labels?.activation, iconSrc: "systems/dnd5e/icons/svg/activity/heal.svg", onClick: t4[2] } });
  let a = t4[1] && create_if_block$S(t4);
  return { c() {
    e = element("div"), create_component(n.$$.fragment), o2 = space(), a && a.c(), attr(e, "class", "activity-row");
  }, m(t5, r2) {
    insert(t5, e, r2), mount_component(n, e, null), append(e, o2), a && a.m(e, null), i = true;
  }, p(t5, [o3]) {
    const i2 = {};
    1 & o3 && (i2.activation = t5[0]?.labels?.activation), n.$set(i2), t5[1] ? a ? (a.p(t5, o3), 2 & o3 && transition_in(a, 1)) : (a = create_if_block$S(t5), a.c(), transition_in(a, 1), a.m(e, null)) : a && (group_outros(), transition_out(a, 1, 1, () => {
      a = null;
    }), check_outros());
  }, i(t5) {
    i || (transition_in(n.$$.fragment, t5), transition_in(a), i = true);
  }, o(t5) {
    transition_out(n.$$.fragment, t5), transition_out(a), i = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(n), a && a.d();
  } };
}
function instance$1u(t4, e, n) {
  let o2, { activity: i } = e;
  return t4.$$set = (t5) => {
    "activity" in t5 && n(0, i = t5.activity);
  }, [i, o2, function() {
    n(1, o2 = !o2);
  }];
}
class HealActivity extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1u, create_fragment$1v, safe_not_equal, { activity: 0 });
  }
}
function create_if_block$R(t4) {
  let e, n;
  return e = new ActivityDetails({ props: { $$slots: { default: [create_default_slot$9] }, $$scope: { ctx: t4 } } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    515 & n2 && (o2.$$scope = { dirty: n2, ctx: t5 }), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_if_block_1$u(t4) {
  let e, n, o2, i, a, r2, s2, c, l, u = t4[4]() + "";
  return { c() {
    e = element("p"), n = element("b"), n.textContent = `${i18n("DND5E.SavingThrow")}:`, o2 = space(), i = text(t4[1]), a = space(), r2 = element("p"), s2 = element("b"), s2.textContent = `${i18n("DND5E.SAVE.FIELDS.damage.onSave.label")}:`, c = space(), l = text(u);
  }, m(t5, u2) {
    insert(t5, e, u2), append(e, n), append(e, o2), append(e, i), insert(t5, a, u2), insert(t5, r2, u2), append(r2, s2), append(r2, c), append(r2, l);
  }, p(t5, e2) {
    2 & e2 && set_data(i, t5[1]);
  }, d(t5) {
    t5 && (detach(e), detach(a), detach(r2));
  } };
}
function create_default_slot$9(t4) {
  let e, n, o2, i, a, r2, s2, c, l, u, p2, d, m;
  e = new Activation({ props: { activity: t4[0] } }), o2 = new Recovery({ props: { activity: t4[0] } }), a = new Uses({ props: { activity: t4[0] } }), s2 = new Range({ props: { activity: t4[0] } }), l = new Target({ props: { activity: t4[0] } });
  let f = t4[1] && t4[1].length > 0 && create_if_block_1$u(t4);
  return d = new Damage({ props: { activity: t4[0] } }), { c() {
    create_component(e.$$.fragment), n = space(), create_component(o2.$$.fragment), i = space(), create_component(a.$$.fragment), r2 = space(), create_component(s2.$$.fragment), c = space(), create_component(l.$$.fragment), u = space(), f && f.c(), p2 = space(), create_component(d.$$.fragment);
  }, m(t5, _) {
    mount_component(e, t5, _), insert(t5, n, _), mount_component(o2, t5, _), insert(t5, i, _), mount_component(a, t5, _), insert(t5, r2, _), mount_component(s2, t5, _), insert(t5, c, _), mount_component(l, t5, _), insert(t5, u, _), f && f.m(t5, _), insert(t5, p2, _), mount_component(d, t5, _), m = true;
  }, p(t5, n2) {
    const i2 = {};
    1 & n2 && (i2.activity = t5[0]), e.$set(i2);
    const r3 = {};
    1 & n2 && (r3.activity = t5[0]), o2.$set(r3);
    const c2 = {};
    1 & n2 && (c2.activity = t5[0]), a.$set(c2);
    const u2 = {};
    1 & n2 && (u2.activity = t5[0]), s2.$set(u2);
    const m2 = {};
    1 & n2 && (m2.activity = t5[0]), l.$set(m2), t5[1] && t5[1].length > 0 ? f ? f.p(t5, n2) : (f = create_if_block_1$u(t5), f.c(), f.m(p2.parentNode, p2)) : f && (f.d(1), f = null);
    const _ = {};
    1 & n2 && (_.activity = t5[0]), d.$set(_);
  }, i(t5) {
    m || (transition_in(e.$$.fragment, t5), transition_in(o2.$$.fragment, t5), transition_in(a.$$.fragment, t5), transition_in(s2.$$.fragment, t5), transition_in(l.$$.fragment, t5), transition_in(d.$$.fragment, t5), m = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), transition_out(o2.$$.fragment, t5), transition_out(a.$$.fragment, t5), transition_out(s2.$$.fragment, t5), transition_out(l.$$.fragment, t5), transition_out(d.$$.fragment, t5), m = false;
  }, d(t5) {
    t5 && (detach(n), detach(i), detach(r2), detach(c), detach(u), detach(p2)), destroy_component(e, t5), destroy_component(o2, t5), destroy_component(a, t5), destroy_component(s2, t5), destroy_component(l, t5), f && f.d(t5), destroy_component(d, t5);
  } };
}
function create_fragment$1u(t4) {
  let e, n, o2, i;
  n = new ActivityTitle({ props: { title: i18n("DND5E.SAVE.Title.one"), activation: t4[0]?.labels?.activation, iconSrc: "systems/dnd5e/icons/svg/activity/save.svg", onClick: t4[3] } });
  let a = t4[2] && create_if_block$R(t4);
  return { c() {
    e = element("div"), create_component(n.$$.fragment), o2 = space(), a && a.c(), attr(e, "class", "activity-row");
  }, m(t5, r2) {
    insert(t5, e, r2), mount_component(n, e, null), append(e, o2), a && a.m(e, null), i = true;
  }, p(t5, [o3]) {
    const i2 = {};
    1 & o3 && (i2.activation = t5[0]?.labels?.activation), n.$set(i2), t5[2] ? a ? (a.p(t5, o3), 4 & o3 && transition_in(a, 1)) : (a = create_if_block$R(t5), a.c(), transition_in(a, 1), a.m(e, null)) : a && (group_outros(), transition_out(a, 1, 1, () => {
      a = null;
    }), check_outros());
  }, i(t5) {
    i || (transition_in(n.$$.fragment, t5), transition_in(a), i = true);
  }, o(t5) {
    transition_out(n.$$.fragment, t5), transition_out(a), i = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(n), a && a.d();
  } };
}
function instance$1t(t4, e, n) {
  var o2, i;
  let { activity: a } = e;
  const r2 = null === (i = null === (o2 = null == a ? void 0 : a.save) || void 0 === o2 ? void 0 : o2.dc) || void 0 === i ? void 0 : i.value, s2 = Array.from(a.save.ability).map((t5) => {
    var e2;
    return null === (e2 = CONFIG.DND5E.abilities[t5]) || void 0 === e2 ? void 0 : e2.label;
  });
  let c, l = "-";
  return r2 && s2 && (l = s2.map((t5) => i18nFormat("DND5E.SaveDC", { dc: r2, ability: t5 })).join(" / ")), t4.$$set = (t5) => {
    "activity" in t5 && n(0, a = t5.activity);
  }, [a, l, c, function() {
    n(2, c = !c);
  }, function() {
    var t5;
    if (null === (t5 = a.damage) || void 0 === t5 ? void 0 : t5.onSave) {
      return i18n(`DND5E.SAVE.FIELDS.damage.onSave.${a.damage.onSave.charAt(0).toUpperCase() + a.damage.onSave.slice(1)}`);
    }
  }];
}
class SaveActivity extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1t, create_fragment$1u, safe_not_equal, { activity: 0 });
  }
}
function get_each_context$m(t4, e, n) {
  const o2 = t4.slice();
  return o2[2] = e[n], o2[4] = n, o2;
}
function create_each_block$m(t4, e) {
  let n, o2 = e[1](e[2], e[4]) + "";
  return { key: t4, first: null, c() {
    n = element("p"), this.first = n;
  }, m(t5, e2) {
    insert(t5, n, e2), n.innerHTML = o2;
  }, p(t5, i) {
    e = t5, 1 & i && o2 !== (o2 = e[1](e[2], e[4]) + "") && (n.innerHTML = o2);
  }, d(t5) {
    t5 && detach(n);
  } };
}
function create_fragment$1t(t4) {
  let e, n = [], o2 = /* @__PURE__ */ new Map(), i = ensure_array_like(t4[0].profiles);
  const a = (t5) => t5[4];
  for (let e2 = 0; e2 < i.length; e2 += 1) {
    let r2 = get_each_context$m(t4, i, e2), s2 = a(r2);
    o2.set(s2, n[e2] = create_each_block$m(s2, r2));
  }
  return { c() {
    e = element("div");
    for (let t5 = 0; t5 < n.length; t5 += 1) n[t5].c();
  }, m(t5, o3) {
    insert(t5, e, o3);
    for (let t6 = 0; t6 < n.length; t6 += 1) n[t6] && n[t6].m(e, null);
  }, p(t5, [r2]) {
    3 & r2 && (i = ensure_array_like(t5[0].profiles), n = update_keyed_each(n, r2, a, 1, t5, i, o2, e, destroy_block, create_each_block$m, null, get_each_context$m));
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e);
    for (let t6 = 0; t6 < n.length; t6 += 1) n[t6].d();
  } };
}
function instance$1s(t4, e, n) {
  let { activity: o2 } = e;
  return t4.$$set = (t5) => {
    "activity" in t5 && n(0, o2 = t5.activity);
  }, [o2, function(t5, e2) {
    var n2, o3;
    const i = [], a = `${null !== (n2 = t5.name) && void 0 !== n2 ? n2 : "Profile" + (e2 + 1)}:`;
    i.push(`<b>${a}</b>`), i.push(`${null !== (o3 = t5.count) && void 0 !== o3 ? o3 : 1} x`), i.push(`${i18n("DND5E.SUMMON.FIELDS.profiles.FIELDS.cr.abbr")} ${t5.cr}`);
    const r2 = Array.from(t5.types).map((t6) => CONFIG.DND5E.creatureTypes[t6].label).join(", ");
    return i.push(r2), t5.level.min && i.push(`${i18n("DND5E.SUMMON.FIELDS.profiles.FIELDS.level.min.label")} ${t5.level.min}`), t5.level.max && i.push(`${i18n("DND5E.SUMMON.FIELDS.profiles.FIELDS.level.max.label")} ${t5.level.max}`), i.join(", ");
  }];
}
class SummonCR extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1s, create_fragment$1t, safe_not_equal, { activity: 0 });
  }
}
const CONTEXT = { ACTOR_STORE: "actorStore", ACTIVE_FILTER_STORE: "activeFilterStore", SWITCH_FILTER: "switchFilter", GET_CURRENT_FILTER: "getCurrentFilter", INNER_APP_WIDTH_STORE: "innerAppWidthStore", SIDE: "side", ACTIVE_SPELL_FILTER: "activeSpellFilter", ACTIVE_OBJECT_FILTER: "activeObjectFilter" };
function get_each_context$l(t4, e, n) {
  const o2 = t4.slice();
  return o2[9] = e[n], o2;
}
function create_if_block$Q(t4) {
  let e, n, o2, i, a = ensure_array_like(t4[0]), r2 = [];
  for (let e2 = 0; e2 < a.length; e2 += 1) r2[e2] = create_each_block$l(get_each_context$l(t4, a, e2));
  return { c() {
    e = element("p"), n = element("b"), n.textContent = `${i18n("DND5E.SUMMON.FIELDS.profiles.element.uuid.label")}:`, o2 = space();
    for (let t5 = 0; t5 < r2.length; t5 += 1) r2[t5].c();
    i = empty();
  }, m(t5, a2) {
    insert(t5, e, a2), append(e, n), insert(t5, o2, a2);
    for (let e2 = 0; e2 < r2.length; e2 += 1) r2[e2] && r2[e2].m(t5, a2);
    insert(t5, i, a2);
  }, p(t5, e2) {
    if (3 & e2) {
      let n2;
      for (a = ensure_array_like(t5[0]), n2 = 0; n2 < a.length; n2 += 1) {
        const o3 = get_each_context$l(t5, a, n2);
        r2[n2] ? r2[n2].p(o3, e2) : (r2[n2] = create_each_block$l(o3), r2[n2].c(), r2[n2].m(i.parentNode, i));
      }
      for (; n2 < r2.length; n2 += 1) r2[n2].d(1);
      r2.length = a.length;
    }
  }, d(t5) {
    t5 && (detach(e), detach(o2), detach(i)), destroy_each(r2, t5);
  } };
}
function create_each_block$l(t4) {
  let e, n, o2, i, a = t4[9].name + "";
  function r2() {
    return t4[3](t4[9]);
  }
  return { c() {
    e = element("div"), n = text(a), attr(e, "aria-hidden", "true"), attr(e, "class", "reference svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1tdx9vw");
  }, m(t5, a2) {
    insert(t5, e, a2), append(e, n), o2 || (i = listen(e, "click", r2), o2 = true);
  }, p(e2, o3) {
    t4 = e2, 1 & o3 && a !== (a = t4[9].name + "") && set_data(n, a);
  }, d(t5) {
    t5 && detach(e), o2 = false, i();
  } };
}
function create_fragment$1s(t4) {
  let e, n = t4[0] && create_if_block$Q(t4);
  return { c() {
    n && n.c(), e = empty();
  }, m(t5, o2) {
    n && n.m(t5, o2), insert(t5, e, o2);
  }, p(t5, [o2]) {
    t5[0] ? n ? n.p(t5, o2) : (n = create_if_block$Q(t5), n.c(), n.m(e.parentNode, e)) : n && (n.d(1), n = null);
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e), n && n.d(t5);
  } };
}
function instance$1r(t4, e, n) {
  let o2, i;
  var a = this && this.__awaiter || function(t5, e2, n2, o3) {
    return new (n2 || (n2 = Promise))(function(i2, a2) {
      function r3(t6) {
        try {
          c2(o3.next(t6));
        } catch (t7) {
          a2(t7);
        }
      }
      function s3(t6) {
        try {
          c2(o3.throw(t6));
        } catch (t7) {
          a2(t7);
        }
      }
      function c2(t6) {
        var e3;
        t6.done ? i2(t6.value) : (e3 = t6.value, e3 instanceof n2 ? e3 : new n2(function(t7) {
          t7(e3);
        })).then(r3, s3);
      }
      c2((o3 = o3.apply(t5, e2 || [])).next());
    });
  };
  let { activity: r2 } = e;
  function s2() {
    return a(this, void 0, void 0, function* () {
      const t5 = Promise.all(r2.profiles.filter((t6) => void 0 !== t6.uuid).map((t6) => a(this, void 0, void 0, function* () {
        return function(t7) {
          return a(this, void 0, void 0, function* () {
            return yield fromUuid(t7);
          });
        }(t6.uuid);
      })));
      return yield t5;
    });
  }
  let c = [];
  function l(t5) {
    o2.set(t5), i.set(Filters.Character);
  }
  onMount(() => a(void 0, void 0, void 0, function* () {
    n(0, c = yield s2());
  }));
  return t4.$$set = (t5) => {
    "activity" in t5 && n(2, r2 = t5.activity);
  }, o2 = getContext(CONTEXT.ACTOR_STORE), i = getContext(CONTEXT.ACTIVE_FILTER_STORE), [c, l, r2, (t5) => l(t5)];
}
class SummonNonCR extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1r, create_fragment$1s, safe_not_equal, { activity: 2 });
  }
}
function create_if_block$P(t4) {
  let e, n;
  return e = new ActivityDetails({ props: { $$slots: { default: [create_default_slot$8] }, $$scope: { ctx: t4 } } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    9 & n2 && (o2.$$scope = { dirty: n2, ctx: t5 }), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_else_block$b(t4) {
  let e, n;
  return e = new SummonNonCR({ props: { activity: t4[0] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    1 & n2 && (o2.activity = t5[0]), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_if_block_1$t(t4) {
  let e, n;
  return e = new SummonCR({ props: { activity: t4[0] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    1 & n2 && (o2.activity = t5[0]), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_default_slot$8(t4) {
  let e, n, o2, i, a, r2, s2, c, l, u, p2, d, m, f;
  e = new Activation({ props: { activity: t4[0] } }), o2 = new Recovery({ props: { activity: t4[0] } }), a = new Uses({ props: { activity: t4[0] } }), s2 = new Range({ props: { activity: t4[0] } }), l = new Target({ props: { activity: t4[0] } });
  const _ = [create_if_block_1$t, create_else_block$b], h = [];
  function g2(t5, e2) {
    return "cr" === t5[0].summon.mode ? 0 : 1;
  }
  return p2 = g2(t4), d = h[p2] = _[p2](t4), { c() {
    create_component(e.$$.fragment), n = space(), create_component(o2.$$.fragment), i = space(), create_component(a.$$.fragment), r2 = space(), create_component(s2.$$.fragment), c = space(), create_component(l.$$.fragment), u = space(), d.c(), m = empty();
  }, m(t5, d2) {
    mount_component(e, t5, d2), insert(t5, n, d2), mount_component(o2, t5, d2), insert(t5, i, d2), mount_component(a, t5, d2), insert(t5, r2, d2), mount_component(s2, t5, d2), insert(t5, c, d2), mount_component(l, t5, d2), insert(t5, u, d2), h[p2].m(t5, d2), insert(t5, m, d2), f = true;
  }, p(t5, n2) {
    const i2 = {};
    1 & n2 && (i2.activity = t5[0]), e.$set(i2);
    const r3 = {};
    1 & n2 && (r3.activity = t5[0]), o2.$set(r3);
    const c2 = {};
    1 & n2 && (c2.activity = t5[0]), a.$set(c2);
    const u2 = {};
    1 & n2 && (u2.activity = t5[0]), s2.$set(u2);
    const f2 = {};
    1 & n2 && (f2.activity = t5[0]), l.$set(f2);
    let $2 = p2;
    p2 = g2(t5), p2 === $2 ? h[p2].p(t5, n2) : (group_outros(), transition_out(h[$2], 1, 1, () => {
      h[$2] = null;
    }), check_outros(), d = h[p2], d ? d.p(t5, n2) : (d = h[p2] = _[p2](t5), d.c()), transition_in(d, 1), d.m(m.parentNode, m));
  }, i(t5) {
    f || (transition_in(e.$$.fragment, t5), transition_in(o2.$$.fragment, t5), transition_in(a.$$.fragment, t5), transition_in(s2.$$.fragment, t5), transition_in(l.$$.fragment, t5), transition_in(d), f = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), transition_out(o2.$$.fragment, t5), transition_out(a.$$.fragment, t5), transition_out(s2.$$.fragment, t5), transition_out(l.$$.fragment, t5), transition_out(d), f = false;
  }, d(t5) {
    t5 && (detach(n), detach(i), detach(r2), detach(c), detach(u), detach(m)), destroy_component(e, t5), destroy_component(o2, t5), destroy_component(a, t5), destroy_component(s2, t5), destroy_component(l, t5), h[p2].d(t5);
  } };
}
function create_fragment$1r(t4) {
  let e, n, o2, i;
  n = new ActivityTitle({ props: { title: i18n("DND5E.SUMMON.Title"), activation: t4[0]?.labels?.activation, iconSrc: "systems/dnd5e/icons/svg/activity/summon.svg", onClick: t4[2] } });
  let a = t4[1] && create_if_block$P(t4);
  return { c() {
    e = element("div"), create_component(n.$$.fragment), o2 = space(), a && a.c(), attr(e, "class", "activity-row");
  }, m(t5, r2) {
    insert(t5, e, r2), mount_component(n, e, null), append(e, o2), a && a.m(e, null), i = true;
  }, p(t5, [o3]) {
    const i2 = {};
    1 & o3 && (i2.activation = t5[0]?.labels?.activation), n.$set(i2), t5[1] ? a ? (a.p(t5, o3), 2 & o3 && transition_in(a, 1)) : (a = create_if_block$P(t5), a.c(), transition_in(a, 1), a.m(e, null)) : a && (group_outros(), transition_out(a, 1, 1, () => {
      a = null;
    }), check_outros());
  }, i(t5) {
    i || (transition_in(n.$$.fragment, t5), transition_in(a), i = true);
  }, o(t5) {
    transition_out(n.$$.fragment, t5), transition_out(a), i = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(n), a && a.d();
  } };
}
function instance$1q(t4, e, n) {
  let o2, { activity: i } = e;
  return t4.$$set = (t5) => {
    "activity" in t5 && n(0, i = t5.activity);
  }, [i, o2, function() {
    n(1, o2 = !o2);
  }];
}
class SummonActivity extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1q, create_fragment$1r, safe_not_equal, { activity: 0 });
  }
}
function create_if_block$O(t4) {
  let e, n;
  return e = new ActivityDetails({ props: { $$slots: { default: [create_default_slot$7] }, $$scope: { ctx: t4 } } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    9 & n2 && (o2.$$scope = { dirty: n2, ctx: t5 }), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_if_block_1$s(t4) {
  let e, n, o2, i, a, r2, s2 = t4[0].roll.name + "", c = t4[0].roll.formula + "";
  return { c() {
    e = element("p"), n = element("b"), o2 = text(s2), i = text(":"), a = space(), r2 = text(c);
  }, m(t5, s3) {
    insert(t5, e, s3), append(e, n), append(n, o2), append(n, i), append(e, a), append(e, r2);
  }, p(t5, e2) {
    1 & e2 && s2 !== (s2 = t5[0].roll.name + "") && set_data(o2, s2), 1 & e2 && c !== (c = t5[0].roll.formula + "") && set_data(r2, c);
  }, d(t5) {
    t5 && detach(e);
  } };
}
function create_default_slot$7(t4) {
  let e, n, o2, i, a, r2, s2, c, l, u, p2, d, m, f, _, h;
  e = new Activation({ props: { activity: t4[0] } }), o2 = new Recovery({ props: { activity: t4[0] } }), a = new Uses({ props: { activity: t4[0] } }), s2 = new Range({ props: { activity: t4[0] } }), l = new Target({ props: { activity: t4[0] } }), p2 = new ToHit({ props: { activity: t4[0] } }), m = new Damage({ props: { activity: t4[0] } });
  let g2 = t4[0].roll?.name && create_if_block_1$s(t4);
  return { c() {
    create_component(e.$$.fragment), n = space(), create_component(o2.$$.fragment), i = space(), create_component(a.$$.fragment), r2 = space(), create_component(s2.$$.fragment), c = space(), create_component(l.$$.fragment), u = space(), create_component(p2.$$.fragment), d = space(), create_component(m.$$.fragment), f = space(), g2 && g2.c(), _ = empty();
  }, m(t5, $2) {
    mount_component(e, t5, $2), insert(t5, n, $2), mount_component(o2, t5, $2), insert(t5, i, $2), mount_component(a, t5, $2), insert(t5, r2, $2), mount_component(s2, t5, $2), insert(t5, c, $2), mount_component(l, t5, $2), insert(t5, u, $2), mount_component(p2, t5, $2), insert(t5, d, $2), mount_component(m, t5, $2), insert(t5, f, $2), g2 && g2.m(t5, $2), insert(t5, _, $2), h = true;
  }, p(t5, n2) {
    const i2 = {};
    1 & n2 && (i2.activity = t5[0]), e.$set(i2);
    const r3 = {};
    1 & n2 && (r3.activity = t5[0]), o2.$set(r3);
    const c2 = {};
    1 & n2 && (c2.activity = t5[0]), a.$set(c2);
    const u2 = {};
    1 & n2 && (u2.activity = t5[0]), s2.$set(u2);
    const d2 = {};
    1 & n2 && (d2.activity = t5[0]), l.$set(d2);
    const f2 = {};
    1 & n2 && (f2.activity = t5[0]), p2.$set(f2);
    const h2 = {};
    1 & n2 && (h2.activity = t5[0]), m.$set(h2), t5[0].roll?.name ? g2 ? g2.p(t5, n2) : (g2 = create_if_block_1$s(t5), g2.c(), g2.m(_.parentNode, _)) : g2 && (g2.d(1), g2 = null);
  }, i(t5) {
    h || (transition_in(e.$$.fragment, t5), transition_in(o2.$$.fragment, t5), transition_in(a.$$.fragment, t5), transition_in(s2.$$.fragment, t5), transition_in(l.$$.fragment, t5), transition_in(p2.$$.fragment, t5), transition_in(m.$$.fragment, t5), h = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), transition_out(o2.$$.fragment, t5), transition_out(a.$$.fragment, t5), transition_out(s2.$$.fragment, t5), transition_out(l.$$.fragment, t5), transition_out(p2.$$.fragment, t5), transition_out(m.$$.fragment, t5), h = false;
  }, d(t5) {
    t5 && (detach(n), detach(i), detach(r2), detach(c), detach(u), detach(d), detach(f), detach(_)), destroy_component(e, t5), destroy_component(o2, t5), destroy_component(a, t5), destroy_component(s2, t5), destroy_component(l, t5), destroy_component(p2, t5), destroy_component(m, t5), g2 && g2.d(t5);
  } };
}
function create_fragment$1q(t4) {
  let e, n, o2, i;
  n = new ActivityTitle({ props: { title: i18n("DND5E.UTILITY.Title"), activation: t4[0]?.labels?.activation, iconSrc: "systems/dnd5e/icons/svg/activity/utility.svg", onClick: t4[2] } });
  let a = t4[1] && create_if_block$O(t4);
  return { c() {
    e = element("div"), create_component(n.$$.fragment), o2 = space(), a && a.c(), attr(e, "class", "activity-row");
  }, m(t5, r2) {
    insert(t5, e, r2), mount_component(n, e, null), append(e, o2), a && a.m(e, null), i = true;
  }, p(t5, [o3]) {
    const i2 = {};
    1 & o3 && (i2.activation = t5[0]?.labels?.activation), n.$set(i2), t5[1] ? a ? (a.p(t5, o3), 2 & o3 && transition_in(a, 1)) : (a = create_if_block$O(t5), a.c(), transition_in(a, 1), a.m(e, null)) : a && (group_outros(), transition_out(a, 1, 1, () => {
      a = null;
    }), check_outros());
  }, i(t5) {
    i || (transition_in(n.$$.fragment, t5), transition_in(a), i = true);
  }, o(t5) {
    transition_out(n.$$.fragment, t5), transition_out(a), i = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(n), a && a.d();
  } };
}
function instance$1p(t4, e, n) {
  let o2, { activity: i } = e;
  return t4.$$set = (t5) => {
    "activity" in t5 && n(0, i = t5.activity);
  }, [i, o2, function() {
    n(1, o2 = !o2);
  }];
}
class UtilityActivity extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1p, create_fragment$1q, safe_not_equal, { activity: 0 });
  }
}
function get_each_context$k(t4, e, n) {
  const o2 = t4.slice();
  return o2[9] = e[n], o2;
}
function create_if_block$N(t4) {
  let e, n, o2 = [], i = /* @__PURE__ */ new Map(), a = ensure_array_like(t4[0]);
  const r2 = (t5) => t5[9].id;
  for (let e2 = 0; e2 < a.length; e2 += 1) {
    let n2 = get_each_context$k(t4, a, e2), s2 = r2(n2);
    i.set(s2, o2[e2] = create_each_block$k(s2, n2));
  }
  return { c() {
    for (let t5 = 0; t5 < o2.length; t5 += 1) o2[t5].c();
    e = empty();
  }, m(t5, i2) {
    for (let e2 = 0; e2 < o2.length; e2 += 1) o2[e2] && o2[e2].m(t5, i2);
    insert(t5, e, i2), n = true;
  }, p(t5, n2) {
    511 & n2 && (a = ensure_array_like(t5[0]), group_outros(), o2 = update_keyed_each(o2, n2, r2, 1, t5, a, i, e.parentNode, outro_and_destroy_block, create_each_block$k, e, get_each_context$k), check_outros());
  }, i(t5) {
    if (!n) {
      for (let t6 = 0; t6 < a.length; t6 += 1) transition_in(o2[t6]);
      n = true;
    }
  }, o(t5) {
    for (let t6 = 0; t6 < o2.length; t6 += 1) transition_out(o2[t6]);
    n = false;
  }, d(t5) {
    t5 && detach(e);
    for (let e2 = 0; e2 < o2.length; e2 += 1) o2[e2].d(t5);
  } };
}
function create_if_block_8(t4) {
  let e, n;
  return e = new AttackActivity({ props: { activity: t4[9] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    1 & n2 && (o2.activity = t5[9]), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_if_block_7$1(t4) {
  let e, n;
  return e = new CheckActivity({ props: { activity: t4[9] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    1 & n2 && (o2.activity = t5[9]), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_if_block_6$2(t4) {
  let e, n;
  return e = new DamageActivity({ props: { activity: t4[9] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    1 & n2 && (o2.activity = t5[9]), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_if_block_5$3(t4) {
  let e, n;
  return e = new EnchantActivity({ props: { activity: t4[9] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    1 & n2 && (o2.activity = t5[9]), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_if_block_4$5(t4) {
  let e, n;
  return e = new HealActivity({ props: { activity: t4[9] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    1 & n2 && (o2.activity = t5[9]), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_if_block_3$8(t4) {
  let e, n;
  return e = new SaveActivity({ props: { activity: t4[9] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    1 & n2 && (o2.activity = t5[9]), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_if_block_2$g(t4) {
  let e, n;
  return e = new UtilityActivity({ props: { activity: t4[9] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    1 & n2 && (o2.activity = t5[9]), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_if_block_1$r(t4) {
  let e, n;
  return e = new SummonActivity({ props: { activity: t4[9] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    1 & n2 && (o2.activity = t5[9]), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_each_block$k(t4, e) {
  let n, o2, i, a, r2, s2, c, l, u, p2, d = e[1](e[9]), m = e[2](e[9]), f = e[3](e[9]), _ = e[4](e[9]), h = e[5](e[9]), g2 = e[6](e[9]), $2 = e[7](e[9]), b = e[8](e[9]), y = d && create_if_block_8(e), v = m && create_if_block_7$1(e), k = f && create_if_block_6$2(e), w2 = _ && create_if_block_5$3(e), S2 = h && create_if_block_4$5(e), T = g2 && create_if_block_3$8(e), x2 = $2 && create_if_block_2$g(e), E = b && create_if_block_1$r(e);
  return { key: t4, first: null, c() {
    n = empty(), y && y.c(), o2 = space(), v && v.c(), i = space(), k && k.c(), a = space(), w2 && w2.c(), r2 = space(), S2 && S2.c(), s2 = space(), T && T.c(), c = space(), x2 && x2.c(), l = space(), E && E.c(), u = empty(), this.first = n;
  }, m(t5, e2) {
    insert(t5, n, e2), y && y.m(t5, e2), insert(t5, o2, e2), v && v.m(t5, e2), insert(t5, i, e2), k && k.m(t5, e2), insert(t5, a, e2), w2 && w2.m(t5, e2), insert(t5, r2, e2), S2 && S2.m(t5, e2), insert(t5, s2, e2), T && T.m(t5, e2), insert(t5, c, e2), x2 && x2.m(t5, e2), insert(t5, l, e2), E && E.m(t5, e2), insert(t5, u, e2), p2 = true;
  }, p(t5, n2) {
    e = t5, 1 & n2 && (d = e[1](e[9])), d ? y ? (y.p(e, n2), 1 & n2 && transition_in(y, 1)) : (y = create_if_block_8(e), y.c(), transition_in(y, 1), y.m(o2.parentNode, o2)) : y && (group_outros(), transition_out(y, 1, 1, () => {
      y = null;
    }), check_outros()), 1 & n2 && (m = e[2](e[9])), m ? v ? (v.p(e, n2), 1 & n2 && transition_in(v, 1)) : (v = create_if_block_7$1(e), v.c(), transition_in(v, 1), v.m(i.parentNode, i)) : v && (group_outros(), transition_out(v, 1, 1, () => {
      v = null;
    }), check_outros()), 1 & n2 && (f = e[3](e[9])), f ? k ? (k.p(e, n2), 1 & n2 && transition_in(k, 1)) : (k = create_if_block_6$2(e), k.c(), transition_in(k, 1), k.m(a.parentNode, a)) : k && (group_outros(), transition_out(k, 1, 1, () => {
      k = null;
    }), check_outros()), 1 & n2 && (_ = e[4](e[9])), _ ? w2 ? (w2.p(e, n2), 1 & n2 && transition_in(w2, 1)) : (w2 = create_if_block_5$3(e), w2.c(), transition_in(w2, 1), w2.m(r2.parentNode, r2)) : w2 && (group_outros(), transition_out(w2, 1, 1, () => {
      w2 = null;
    }), check_outros()), 1 & n2 && (h = e[5](e[9])), h ? S2 ? (S2.p(e, n2), 1 & n2 && transition_in(S2, 1)) : (S2 = create_if_block_4$5(e), S2.c(), transition_in(S2, 1), S2.m(s2.parentNode, s2)) : S2 && (group_outros(), transition_out(S2, 1, 1, () => {
      S2 = null;
    }), check_outros()), 1 & n2 && (g2 = e[6](e[9])), g2 ? T ? (T.p(e, n2), 1 & n2 && transition_in(T, 1)) : (T = create_if_block_3$8(e), T.c(), transition_in(T, 1), T.m(c.parentNode, c)) : T && (group_outros(), transition_out(T, 1, 1, () => {
      T = null;
    }), check_outros()), 1 & n2 && ($2 = e[7](e[9])), $2 ? x2 ? (x2.p(e, n2), 1 & n2 && transition_in(x2, 1)) : (x2 = create_if_block_2$g(e), x2.c(), transition_in(x2, 1), x2.m(l.parentNode, l)) : x2 && (group_outros(), transition_out(x2, 1, 1, () => {
      x2 = null;
    }), check_outros()), 1 & n2 && (b = e[8](e[9])), b ? E ? (E.p(e, n2), 1 & n2 && transition_in(E, 1)) : (E = create_if_block_1$r(e), E.c(), transition_in(E, 1), E.m(u.parentNode, u)) : E && (group_outros(), transition_out(E, 1, 1, () => {
      E = null;
    }), check_outros());
  }, i(t5) {
    p2 || (transition_in(y), transition_in(v), transition_in(k), transition_in(w2), transition_in(S2), transition_in(T), transition_in(x2), transition_in(E), p2 = true);
  }, o(t5) {
    transition_out(y), transition_out(v), transition_out(k), transition_out(w2), transition_out(S2), transition_out(T), transition_out(x2), transition_out(E), p2 = false;
  }, d(t5) {
    t5 && (detach(n), detach(o2), detach(i), detach(a), detach(r2), detach(s2), detach(c), detach(l), detach(u)), y && y.d(t5), v && v.d(t5), k && k.d(t5), w2 && w2.d(t5), S2 && S2.d(t5), T && T.d(t5), x2 && x2.d(t5), E && E.d(t5);
  } };
}
function create_fragment$1p(t4) {
  let e, n, o2, i, a = t4[0] && create_if_block$N(t4);
  return { c() {
    e = element("section"), n = element("b"), n.textContent = `${i18n("DND5E.ACTIVITY.Title.other")}`, o2 = space(), a && a.c();
  }, m(t5, r2) {
    insert(t5, e, r2), append(e, n), append(e, o2), a && a.m(e, null), i = true;
  }, p(t5, [n2]) {
    t5[0] ? a ? (a.p(t5, n2), 1 & n2 && transition_in(a, 1)) : (a = create_if_block$N(t5), a.c(), transition_in(a, 1), a.m(e, null)) : a && (group_outros(), transition_out(a, 1, 1, () => {
      a = null;
    }), check_outros());
  }, i(t5) {
    i || (transition_in(a), i = true);
  }, o(t5) {
    transition_out(a), i = false;
  }, d(t5) {
    t5 && detach(e), a && a.d();
  } };
}
function instance$1o(t4, e, n) {
  let { activities: o2 } = e;
  return t4.$$set = (t5) => {
    "activities" in t5 && n(0, o2 = t5.activities);
  }, [o2, (t5) => "attack" === t5.type, (t5) => "check" === t5.type, (t5) => "damage" === t5.type, (t5) => "enchant" === t5.type, (t5) => "heal" === t5.type, (t5) => "save" === t5.type, (t5) => "utility" === t5.type, (t5) => "summon" === t5.type];
}
class Activities extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1o, create_fragment$1p, safe_not_equal, { activities: 0 });
  }
}
function create_if_block$M(t4) {
  let e;
  return { c() {
    e = element("p");
  }, m(n, o2) {
    insert(n, e, o2), e.innerHTML = t4[0];
  }, p(t5, n) {
    1 & n && (e.innerHTML = t5[0]);
  }, d(t5) {
    t5 && detach(e);
  } };
}
function create_fragment$1o(t4) {
  let e, n = t4[0] && create_if_block$M(t4);
  return { c() {
    n && n.c(), e = empty();
  }, m(t5, o2) {
    n && n.m(t5, o2), insert(t5, e, o2);
  }, p(t5, [o2]) {
    t5[0] ? n ? n.p(t5, o2) : (n = create_if_block$M(t5), n.c(), n.m(e.parentNode, e)) : n && (n.d(1), n = null);
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e), n && n.d(t5);
  } };
}
function instance$1n(t4, e, n) {
  let { htmlText: o2 } = e, { replaceOptions: i = [] } = e;
  i.push({ find: /\[\[\/[^\]]+]]\./g, replace: "" });
  let a = "loading...";
  return enrichText(o2, i).then((t5) => {
    n(0, a = t5);
  }), t4.$$set = (t5) => {
    "htmlText" in t5 && n(1, o2 = t5.htmlText), "replaceOptions" in t5 && n(2, i = t5.replaceOptions);
  }, [a, o2, i];
}
class Description extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1n, create_fragment$1o, safe_not_equal, { htmlText: 1, replaceOptions: 2 });
  }
}
function create_fragment$1n(t4) {
  let e, n;
  return e = new Description({ props: { htmlText: t4[0]() } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p: noop$3, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function instance$1m(t4, e, n) {
  let o2, { itemData: i } = e;
  return t4.$$set = (t5) => {
    "itemData" in t5 && n(1, i = t5.itemData);
  }, [function() {
    return o2 = i.identified, o2 ? i.description.value : i.unidentified.description ? i.unidentified.description : i18n("DND5E.Unidentified.Notice");
  }, i];
}
class ItemDescription extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1m, create_fragment$1n, safe_not_equal, { itemData: 1 });
  }
}
function get_each_context$j(t4, e, n) {
  const o2 = t4.slice();
  return o2[8] = e[n], o2;
}
function create_if_block$L(t4) {
  let e, n, o2, i, a, r2, s2, c, l, u = [], p2 = /* @__PURE__ */ new Map(), d = ensure_array_like(t4[2]);
  const m = (t5) => t5[8].id;
  for (let e2 = 0; e2 < d.length; e2 += 1) {
    let n2 = get_each_context$j(t4, d, e2), o3 = m(n2);
    p2.set(o3, u[e2] = create_each_block$j(o3, n2));
  }
  return { c() {
    e = element("div"), n = element("div"), o2 = element("span"), i = text("Transfer to\r\n            "), a = element("select");
    for (let t5 = 0; t5 < u.length; t5 += 1) u[t5].c();
    r2 = space(), s2 = element("button"), s2.innerHTML = '<i class="fa-solid fa-right-left"></i>', attr(a, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-jnqbyu"), void 0 === t4[1] && add_render_callback(() => t4[5].call(a)), attr(s2, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-jnqbyu"), attr(n, "class", "transfer svelte-mobile-companion-dnd5e-81nkluj30u9vsd-jnqbyu"), attr(e, "class", "transfer-container svelte-mobile-companion-dnd5e-81nkluj30u9vsd-jnqbyu");
  }, m(p3, d2) {
    insert(p3, e, d2), append(e, n), append(n, o2), append(o2, i), append(o2, a);
    for (let t5 = 0; t5 < u.length; t5 += 1) u[t5] && u[t5].m(a, null);
    select_option(a, t4[1], true), append(n, r2), append(n, s2), c || (l = [listen(a, "change", t4[5]), listen(s2, "click", t4[3])], c = true);
  }, p(t5, e2) {
    4 & e2 && (d = ensure_array_like(t5[2]), u = update_keyed_each(u, e2, m, 1, t5, d, p2, a, destroy_block, create_each_block$j, null, get_each_context$j)), 6 & e2 && select_option(a, t5[1]);
  }, d(t5) {
    t5 && detach(e);
    for (let t6 = 0; t6 < u.length; t6 += 1) u[t6].d();
    c = false, run_all(l);
  } };
}
function create_each_block$j(t4, e) {
  let n, o2, i, a = e[8].name + "";
  return { key: t4, first: null, c() {
    n = element("option"), o2 = text(a), n.__value = i = e[8], set_input_value(n, n.__value), this.first = n;
  }, m(t5, e2) {
    insert(t5, n, e2), append(n, o2);
  }, p(t5, r2) {
    e = t5, 4 & r2 && a !== (a = e[8].name + "") && set_data(o2, a), 4 & r2 && i !== (i = e[8]) && (n.__value = i, set_input_value(n, n.__value));
  }, d(t5) {
    t5 && detach(n);
  } };
}
function create_fragment$1m(t4) {
  let e, n = "container" !== t4[0].type && create_if_block$L(t4);
  return { c() {
    n && n.c(), e = empty();
  }, m(t5, o2) {
    n && n.m(t5, o2), insert(t5, e, o2);
  }, p(t5, [o2]) {
    "container" !== t5[0].type ? n ? n.p(t5, o2) : (n = create_if_block$L(t5), n.c(), n.m(e.parentNode, e)) : n && (n.d(1), n = null);
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e), n && n.d(t5);
  } };
}
function instance$1l(t4, e, n) {
  let o2, { actor: i } = e, { item: a } = e;
  const r2 = { id: i.id, name: i.name, isActor: true };
  let s2 = a.container ? { id: a.container.id, name: a.container.name, isActor: false } : r2, c = i.itemTypes.container.filter((t5) => t5.id !== (null == s2 ? void 0 : s2.id)).map((t5) => ({ id: t5.id, name: t5.name, isActor: false }));
  return a.container && (c = [r2, ...c]), t4.$$set = (t5) => {
    "actor" in t5 && n(4, i = t5.actor), "item" in t5 && n(0, a = t5.item);
  }, [a, o2, c, function() {
    const t5 = { system: { container: o2.isActor ? null : o2.id } };
    FoundryGateway.updateItem(a, t5);
  }, i, function() {
    o2 = select_value(this), n(1, o2), n(2, c);
  }];
}
class ItemTransfer extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1l, create_fragment$1m, safe_not_equal, { actor: 4, item: 0 });
  }
}
function create_if_block$K(t4) {
  let e, n, o2, i;
  return { c() {
    e = element("p"), n = element("b"), n.textContent = `${i18n("DND5E.Properties")}:`, o2 = space(), i = text(t4[0]);
  }, m(t5, a) {
    insert(t5, e, a), append(e, n), append(e, o2), append(e, i);
  }, p: noop$3, d(t5) {
    t5 && detach(e);
  } };
}
function create_fragment$1l(t4) {
  let e, n = t4[0] && create_if_block$K(t4);
  return { c() {
    n && n.c(), e = empty();
  }, m(t5, o2) {
    n && n.m(t5, o2), insert(t5, e, o2);
  }, p(t5, [e2]) {
    t5[0] && n.p(t5, e2);
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e), n && n.d(t5);
  } };
}
function instance$1k(t4, e, n) {
  let { item: o2 } = e;
  const i = o2.labels.properties.map((t5) => t5.label).join(", ");
  return t4.$$set = (t5) => {
    "item" in t5 && n(1, o2 = t5.item);
  }, [i, o2];
}
class ObjectProperties extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1k, create_fragment$1l, safe_not_equal, { item: 1 });
  }
}
function create_if_block$J(t4) {
  let e, n, o2, i, a, r2, s2 = t4[0].value + "", c = t4[0].denomination + "";
  return { c() {
    e = element("p"), n = element("b"), n.textContent = `${i18n("DND5E.Price")}`, o2 = text(": "), i = text(s2), a = space(), r2 = text(c);
  }, m(t5, s3) {
    insert(t5, e, s3), append(e, n), append(e, o2), append(e, i), append(e, a), append(e, r2);
  }, p(t5, e2) {
    1 & e2 && s2 !== (s2 = t5[0].value + "") && set_data(i, s2), 1 & e2 && c !== (c = t5[0].denomination + "") && set_data(r2, c);
  }, d(t5) {
    t5 && detach(e);
  } };
}
function create_fragment$1k(t4) {
  let e, n = t4[0].value && create_if_block$J(t4);
  return { c() {
    n && n.c(), e = empty();
  }, m(t5, o2) {
    n && n.m(t5, o2), insert(t5, e, o2);
  }, p(t5, [o2]) {
    t5[0].value ? n ? n.p(t5, o2) : (n = create_if_block$J(t5), n.c(), n.m(e.parentNode, e)) : n && (n.d(1), n = null);
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e), n && n.d(t5);
  } };
}
function instance$1j(t4, e, n) {
  let { price: o2 } = e;
  return t4.$$set = (t5) => {
    "price" in t5 && n(0, o2 = t5.price);
  }, [o2];
}
class Price extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1j, create_fragment$1k, safe_not_equal, { price: 0 });
  }
}
function create_if_block$I(t4) {
  let e, n, o2, i, a, r2, s2 = t4[0].value + "", c = t4[0].units + "";
  return { c() {
    e = element("p"), n = element("b"), n.textContent = `${i18n("DND5E.Weight")}`, o2 = text(": "), i = text(s2), a = space(), r2 = text(c);
  }, m(t5, s3) {
    insert(t5, e, s3), append(e, n), append(e, o2), append(e, i), append(e, a), append(e, r2);
  }, p(t5, e2) {
    1 & e2 && s2 !== (s2 = t5[0].value + "") && set_data(i, s2), 1 & e2 && c !== (c = t5[0].units + "") && set_data(r2, c);
  }, d(t5) {
    t5 && detach(e);
  } };
}
function create_fragment$1j(t4) {
  let e, n = t4[0] && create_if_block$I(t4);
  return { c() {
    n && n.c(), e = empty();
  }, m(t5, o2) {
    n && n.m(t5, o2), insert(t5, e, o2);
  }, p(t5, [o2]) {
    t5[0] ? n ? n.p(t5, o2) : (n = create_if_block$I(t5), n.c(), n.m(e.parentNode, e)) : n && (n.d(1), n = null);
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e), n && n.d(t5);
  } };
}
function instance$1i(t4, e, n) {
  let { weight: o2 } = e;
  return t4.$$set = (t5) => {
    "weight" in t5 && n(0, o2 = t5.weight);
  }, [o2];
}
class Weight extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1i, create_fragment$1j, safe_not_equal, { weight: 0 });
  }
}
const get_details_slot_changes = (t4) => ({}), get_details_slot_context = (t4) => ({}), get_right_content_slot_changes = (t4) => ({}), get_right_content_slot_context = (t4) => ({}), get_below_name_content_slot_changes_1 = (t4) => ({}), get_below_name_content_slot_context_1 = (t4) => ({}), get_below_name_content_slot_changes = (t4) => ({}), get_below_name_content_slot_context = (t4) => ({});
function create_if_block_3$7(t4) {
  let e, n;
  return { c() {
    e = element("img"), attr(e, "class", "item-image svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1jiiryp"), src_url_equal(e.src, n = t4[1]) || attr(e, "src", n), attr(e, "alt", t4[0]), attr(e, "draggable", "false"), attr(e, "style", t4[2]);
  }, m(t5, n2) {
    insert(t5, e, n2);
  }, p(t5, o2) {
    2 & o2 && !src_url_equal(e.src, n = t5[1]) && attr(e, "src", n), 1 & o2 && attr(e, "alt", t5[0]), 4 & o2 && attr(e, "style", t5[2]);
  }, d(t5) {
    t5 && detach(e);
  } };
}
function create_if_block_2$f(t4) {
  let e, n;
  const o2 = t4[10]["below-name-content"], i = create_slot(o2, t4, t4[9], get_below_name_content_slot_context);
  return { c() {
    e = element("div"), i && i.c(), attr(e, "class", "contentBelowName svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1jiiryp");
  }, m(t5, o3) {
    insert(t5, e, o3), i && i.m(e, null), n = true;
  }, p(t5, e2) {
    i && i.p && (!n || 512 & e2) && update_slot_base(i, o2, t5, t5[9], n ? get_slot_changes(o2, t5[9], e2, get_below_name_content_slot_changes) : get_all_dirty_from_scope(t5[9]), get_below_name_content_slot_context);
  }, i(t5) {
    n || (transition_in(i, t5), n = true);
  }, o(t5) {
    transition_out(i, t5), n = false;
  }, d(t5) {
    t5 && detach(e), i && i.d(t5);
  } };
}
function create_if_block_1$q(t4) {
  let e, n;
  const o2 = t4[10]["below-name-content"], i = create_slot(o2, t4, t4[9], get_below_name_content_slot_context_1);
  return { c() {
    e = element("div"), i && i.c(), attr(e, "class", "middle-content");
  }, m(t5, o3) {
    insert(t5, e, o3), i && i.m(e, null), n = true;
  }, p(t5, e2) {
    i && i.p && (!n || 512 & e2) && update_slot_base(i, o2, t5, t5[9], n ? get_slot_changes(o2, t5[9], e2, get_below_name_content_slot_changes_1) : get_all_dirty_from_scope(t5[9]), get_below_name_content_slot_context_1);
  }, i(t5) {
    n || (transition_in(i, t5), n = true);
  }, o(t5) {
    transition_out(i, t5), n = false;
  }, d(t5) {
    t5 && detach(e), i && i.d(t5);
  } };
}
function create_if_block$H(t4) {
  let e, n, o2;
  const i = t4[10].details, a = create_slot(i, t4, t4[9], get_details_slot_context);
  return { c() {
    e = element("div"), a && a.c(), attr(e, "class", "details svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1jiiryp");
  }, m(t5, n2) {
    insert(t5, e, n2), a && a.m(e, null), o2 = true;
  }, p(t5, e2) {
    a && a.p && (!o2 || 512 & e2) && update_slot_base(a, i, t5, t5[9], o2 ? get_slot_changes(i, t5[9], e2, get_details_slot_changes) : get_all_dirty_from_scope(t5[9]), get_details_slot_context);
  }, i(t5) {
    o2 || (transition_in(a, t5), t5 && add_render_callback(() => {
      o2 && (n || (n = create_bidirectional_transition(e, slide, { duration: 200, easing: identity, axis: "y" }, true)), n.run(1));
    }), o2 = true);
  }, o(t5) {
    transition_out(a, t5), t5 && (n || (n = create_bidirectional_transition(e, slide, { duration: 200, easing: identity, axis: "y" }, false)), n.run(0)), o2 = false;
  }, d(t5) {
    t5 && detach(e), a && a.d(t5), t5 && n && n.end();
  } };
}
function create_fragment$1i(t4) {
  let e, n, o2, i, a, r2, s2, c, l, u, p2, d, m, f, _, h = t4[1] && create_if_block_3$7(t4), g2 = !t4[5] && create_if_block_2$f(t4), $2 = t4[5] && create_if_block_1$q(t4);
  const b = t4[10]["right-content"], y = create_slot(b, t4, t4[9], get_right_content_slot_context);
  let v = t4[3] && t4[4] && create_if_block$H(t4);
  return { c() {
    e = element("li"), n = element("div"), o2 = element("div"), i = element("div"), h && h.c(), a = space(), r2 = element("div"), s2 = text(t4[0]), c = space(), g2 && g2.c(), l = space(), $2 && $2.c(), u = space(), y && y.c(), p2 = space(), v && v.c(), attr(r2, "class", "name svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1jiiryp"), attr(r2, "aria-hidden", "true"), attr(i, "class", "name-img svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1jiiryp"), attr(o2, "class", "left-side-content svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1jiiryp"), attr(n, "class", "item svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1jiiryp"), attr(e, "class", d = null_to_empty(t4[5] ? "large-screen" : "small-screen") + " svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1jiiryp");
  }, m(d2, b2) {
    insert(d2, e, b2), append(e, n), append(n, o2), append(o2, i), h && h.m(i, null), append(i, a), append(i, r2), append(r2, s2), append(o2, c), g2 && g2.m(o2, null), append(n, l), $2 && $2.m(n, null), append(n, u), y && y.m(n, null), append(e, p2), v && v.m(e, null), m = true, f || (_ = listen(r2, "click", t4[7]), f = true);
  }, p(t5, [r3]) {
    t5[1] ? h ? h.p(t5, r3) : (h = create_if_block_3$7(t5), h.c(), h.m(i, a)) : h && (h.d(1), h = null), (!m || 1 & r3) && set_data(s2, t5[0]), t5[5] ? g2 && (group_outros(), transition_out(g2, 1, 1, () => {
      g2 = null;
    }), check_outros()) : g2 ? (g2.p(t5, r3), 32 & r3 && transition_in(g2, 1)) : (g2 = create_if_block_2$f(t5), g2.c(), transition_in(g2, 1), g2.m(o2, null)), t5[5] ? $2 ? ($2.p(t5, r3), 32 & r3 && transition_in($2, 1)) : ($2 = create_if_block_1$q(t5), $2.c(), transition_in($2, 1), $2.m(n, u)) : $2 && (group_outros(), transition_out($2, 1, 1, () => {
      $2 = null;
    }), check_outros()), y && y.p && (!m || 512 & r3) && update_slot_base(y, b, t5, t5[9], m ? get_slot_changes(b, t5[9], r3, get_right_content_slot_changes) : get_all_dirty_from_scope(t5[9]), get_right_content_slot_context), t5[3] && t5[4] ? v ? (v.p(t5, r3), 24 & r3 && transition_in(v, 1)) : (v = create_if_block$H(t5), v.c(), transition_in(v, 1), v.m(e, null)) : v && (group_outros(), transition_out(v, 1, 1, () => {
      v = null;
    }), check_outros()), (!m || 32 & r3 && d !== (d = null_to_empty(t5[5] ? "large-screen" : "small-screen") + " svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1jiiryp")) && attr(e, "class", d);
  }, i(t5) {
    m || (transition_in(g2), transition_in($2), transition_in(y, t5), transition_in(v), m = true);
  }, o(t5) {
    transition_out(g2), transition_out($2), transition_out(y, t5), transition_out(v), m = false;
  }, d(t5) {
    t5 && detach(e), h && h.d(), g2 && g2.d(), $2 && $2.d(), y && y.d(t5), v && v.d(), f = false, _();
  } };
}
function instance$1h(t4, e, n) {
  let o2, i, { $$slots: a = {}, $$scope: r2 } = e, { name: s2 } = e, { imageSrc: c } = e, { imageStyle: l } = e, { hasDetails: u = true } = e, p2 = false;
  const d = getContext(CONTEXT.INNER_APP_WIDTH_STORE);
  return component_subscribe(t4, d, (t5) => n(8, i = t5)), t4.$$set = (t5) => {
    "name" in t5 && n(0, s2 = t5.name), "imageSrc" in t5 && n(1, c = t5.imageSrc), "imageStyle" in t5 && n(2, l = t5.imageStyle), "hasDetails" in t5 && n(3, u = t5.hasDetails), "$$scope" in t5 && n(9, r2 = t5.$$scope);
  }, t4.$$.update = () => {
    256 & t4.$$.dirty && n(5, o2 = i.isLargeScreen);
  }, [s2, c, l, u, p2, o2, d, function() {
    n(4, p2 = !p2);
  }, i, r2, a];
}
class ToggleableListEntry extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1h, create_fragment$1i, safe_not_equal, { name: 0, imageSrc: 1, imageStyle: 2, hasDetails: 3 });
  }
}
async function evaluateTotal(t4, e) {
  let n;
  return n = e ? new Roll(t4, e) : new Roll(t4), await n.evaluate(), n.total;
}
function calculateAverage(formula) {
  if (!formula || "" === formula.trim()) return 0;
  const diceMatches = formula.match(/(\d+)d(\d+)/g);
  if (diceMatches && diceMatches.length > 1) {
    let t4 = 0;
    for (const e2 of diceMatches) {
      const [n, o2] = e2.split("d").map(Number);
      t4 += n * (o2 + 1) / 2;
    }
    const e = formula.replace(/(\d+)d(\d+)/g, "").match(/[+-]?\d+(\.\d+)?/g);
    if (e) for (const n of e) t4 += Number(n);
    return t4;
  }
  let transformedFormula = formula.replace(/(\d+)d(\d+)/g, (t4, e, n) => `${e} * (${n} + 1) / 2`);
  if (transformedFormula = transformedFormula.replace(/[^\d+\-*/().]/g, " "), transformedFormula = transformedFormula.replace(/\s+/g, "").replace(/([+\-*/])[+\-*/]+/g, "$1").replace(/^[+*/]+/, "").replace(/[+\-*/]+$/, ""), !transformedFormula || "" === transformedFormula.trim()) return 0;
  try {
    return eval(transformedFormula);
  } catch (t4) {
    return console.error(t4), console.error(`Failed to calculate average for formula: ${formula}`), 0;
  }
}
function getDamageString(t4, e) {
  if (e) {
    return `${t4.formula} (${calculateAverage(t4.formula)})`.replaceAll("*", "×");
  }
  return `${t4.formula}`;
}
function create_if_block_2$e(t4) {
  let e;
  return { c() {
    e = element("span"), e.textContent = `${t4[5]}`, attr(e, "class", "text");
  }, m(t5, n) {
    insert(t5, e, n);
  }, p: noop$3, d(t5) {
    t5 && detach(e);
  } };
}
function create_if_block_1$p(t4) {
  let e, n, o2, i;
  return { c() {
    e = element("span"), e.textContent = "|", n = space(), o2 = element("div"), i = text(t4[0]), attr(e, "class", "separator"), attr(o2, "class", "text");
  }, m(t5, a) {
    insert(t5, e, a), insert(t5, n, a), insert(t5, o2, a), append(o2, i);
  }, p(t5, e2) {
    1 & e2 && set_data(i, t5[0]);
  }, d(t5) {
    t5 && (detach(e), detach(n), detach(o2));
  } };
}
function create_if_block$G(t4) {
  let e, n, o2, i, a, r2, s2;
  return { c() {
    e = element("span"), e.textContent = "|", n = space(), o2 = element("span"), i = text(t4[2]), a = space(), r2 = element("img"), attr(e, "class", "separator"), src_url_equal(r2.src, s2 = t4[1]) || attr(r2, "src", s2), attr(r2, "alt", t4[3]?.damageType), attr(o2, "class", "text damage");
  }, m(t5, s3) {
    insert(t5, e, s3), insert(t5, n, s3), insert(t5, o2, s3), append(o2, i), append(o2, a), append(o2, r2);
  }, p(t5, e2) {
    4 & e2 && set_data(i, t5[2]), 2 & e2 && !src_url_equal(r2.src, s2 = t5[1]) && attr(r2, "src", s2);
  }, d(t5) {
    t5 && (detach(e), detach(n), detach(o2));
  } };
}
function create_fragment$1h(t4) {
  let e, n, o2, i = t4[5] && create_if_block_2$e(t4), a = t4[0] && create_if_block_1$p(t4), r2 = t4[2] && create_if_block$G(t4);
  return { c() {
    e = element("div"), i && i.c(), n = space(), a && a.c(), o2 = space(), r2 && r2.c(), attr(e, "class", "global-quickInfo");
  }, m(t5, s2) {
    insert(t5, e, s2), i && i.m(e, null), append(e, n), a && a.m(e, null), append(e, o2), r2 && r2.m(e, null);
  }, p(t5, [n2]) {
    t5[5] && i.p(t5, n2), t5[0] ? a ? a.p(t5, n2) : (a = create_if_block_1$p(t5), a.c(), a.m(e, o2)) : a && (a.d(1), a = null), t5[2] ? r2 ? r2.p(t5, n2) : (r2 = create_if_block$G(t5), r2.c(), r2.m(e, null)) : r2 && (r2.d(1), r2 = null);
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e), i && i.d(), a && a.d(), r2 && r2.d();
  } };
}
function instance$1g(t4, e, n) {
  let o2;
  var i, a;
  let { item: r2 } = e;
  const s2 = r2.labels.damages.find((t5) => true === t5.base), c = mobileCompanionGameSettings.getWritableStore(SHOW_AVERAGE_DAMAGE);
  component_subscribe(t4, c, (t5) => n(8, o2 = t5));
  let l, u, p2 = null === (i = r2.labels.toHit) || void 0 === i ? void 0 : i.replaceAll("+ - ", "-");
  p2 && (p2 += " to hit");
  let d = r2.labels.activation;
  return t4.$$set = (t5) => {
    "item" in t5 && n(6, r2 = t5.item);
  }, t4.$$.update = () => {
    384 & t4.$$.dirty && s2 && (n(1, l = null === n(7, a = CONFIG.DND5E.damageTypes[s2.damageType]) || void 0 === a ? void 0 : a.icon), n(2, u = getDamageString(s2, o2)));
  }, [p2, l, u, s2, c, d, r2, a, o2];
}
class ItemQuickInfo extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1g, create_fragment$1h, safe_not_equal, { item: 6 });
  }
}
const FLAG_KEY = "favorites";
function getFavoritesFlags(t4) {
  const e = getFullModuleId();
  return t4.getFlag(e, FLAG_KEY) || [];
}
function addFavoriteFlag(t4, e) {
  const n = getFullModuleId(), o2 = getFavoritesFlags(t4);
  t4.setFlag(n, FLAG_KEY, [...o2, e]);
}
function removeFavoriteFlag(t4, e) {
  const n = getFullModuleId(), o2 = getFavoritesFlags(t4);
  t4.setFlag(n, FLAG_KEY, o2.filter((t5) => t5.id !== e));
}
function hasFavoriteFlag(t4, e) {
  return getFavoritesFlags(t4).some((t5) => t5.id === e);
}
function create_else_block$a(t4) {
  let e;
  return { c() {
    e = element("i"), attr(e, "class", "far fa-star");
  }, m(t5, n) {
    insert(t5, e, n);
  }, d(t5) {
    t5 && detach(e);
  } };
}
function create_if_block$F(t4) {
  let e;
  return { c() {
    e = element("i"), attr(e, "class", "fas fa-star");
  }, m(t5, n) {
    insert(t5, e, n);
  }, d(t5) {
    t5 && detach(e);
  } };
}
function create_fragment$1g(t4) {
  let e, n, o2, i, a, r2;
  function s2(t5, e2) {
    return t5[0] ? create_if_block$F : create_else_block$a;
  }
  let c = s2(t4), l = c(t4);
  return { c() {
    e = element("p"), n = element("b"), n.textContent = "Toggle Favorite:", o2 = space(), i = element("button"), l.c(), attr(i, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1syn5cb");
  }, m(s3, c2) {
    insert(s3, e, c2), append(e, n), append(e, o2), append(e, i), l.m(i, null), a || (r2 = listen(i, "click", t4[1]), a = true);
  }, p(t5, [e2]) {
    c !== (c = s2(t5)) && (l.d(1), l = c(t5), l && (l.c(), l.m(i, null)));
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e), l.d(), a = false, r2();
  } };
}
function instance$1f(t4, e, n) {
  let o2, i, { actor: a } = e, { item: r2 } = e, { type: s2 = "item" } = e;
  const c = void 0 !== a.system.hasFavorite;
  return t4.$$set = (t5) => {
    "actor" in t5 && n(2, a = t5.actor), "item" in t5 && n(3, r2 = t5.item), "type" in t5 && n(4, s2 = t5.type);
  }, t4.$$.update = () => {
    12 & t4.$$.dirty && n(5, o2 = r2.getRelativeUUID(a)), 36 & t4.$$.dirty && n(0, i = c ? a.system.hasFavorite(o2) : hasFavoriteFlag(a, o2));
  }, [i, function() {
    if (c) if (i) a.system.removeFavorite(o2);
    else {
      const t5 = { type: s2, id: o2, sort: -1 };
      a.system.addFavorite(t5);
    }
    else if (i) removeFavoriteFlag(a, o2);
    else {
      addFavoriteFlag(a, { type: s2, id: o2, sort: -1 });
    }
  }, a, r2, s2, o2];
}
class ToggleFavorite extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1f, create_fragment$1g, safe_not_equal, { actor: 2, item: 3, type: 4 });
  }
}
function create_else_block$9(t4) {
  let e, n, o2;
  return { c() {
    e = element("button"), e.innerHTML = '<i class="fas fa-sun"></i>', attr(e, "class", "item-control svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1yzx7tn"), toggle_class(e, "active", t4[1] === t4[0].Equipped_Attuned);
  }, m(i, a) {
    insert(i, e, a), n || (o2 = listen(e, "click", stop_propagation(t4[3])), n = true);
  }, p(t5, n2) {
    3 & n2 && toggle_class(e, "active", t5[1] === t5[0].Equipped_Attuned);
  }, d(t5) {
    t5 && detach(e), n = false, o2();
  } };
}
function create_if_block$E(t4) {
  let e, n, o2;
  return { c() {
    e = element("button"), e.innerHTML = '<i class="fas fa-shield-halved"></i>', attr(e, "class", "item-control svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1yzx7tn"), toggle_class(e, "active", t4[1] === t4[0].Equipped_NoAttunementRequired);
  }, m(i, a) {
    insert(i, e, a), n || (o2 = listen(e, "click", stop_propagation(t4[4])), n = true);
  }, p(t5, n2) {
    3 & n2 && toggle_class(e, "active", t5[1] === t5[0].Equipped_NoAttunementRequired);
  }, d(t5) {
    t5 && detach(e), n = false, o2();
  } };
}
function create_fragment$1f(t4) {
  let e;
  function n(t5, e2) {
    return t5[1] === t5[0].Unequipped || t5[1] === t5[0].Equipped_NoAttunementRequired ? create_if_block$E : create_else_block$9;
  }
  let o2 = n(t4), i = o2(t4);
  return { c() {
    i.c(), e = empty();
  }, m(t5, n2) {
    i.m(t5, n2), insert(t5, e, n2);
  }, p(t5, [a]) {
    o2 === (o2 = n(t5)) && i ? i.p(t5, a) : (i.d(1), i = o2(t5), i && (i.c(), i.m(e.parentNode, e)));
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e), i.d(t5);
  } };
}
function instance$1e(t4, e, n) {
  let o2, i, a, r2, { itemData: s2 } = e;
  const c = getContext(CONTEXT.ACTOR_STORE);
  var l;
  component_subscribe(t4, c, (t5) => n(8, r2 = t5)), function(t5) {
    t5[t5.Unequipped = 0] = "Unequipped", t5[t5.Equipped_NoAttunementRequired = 1] = "Equipped_NoAttunementRequired", t5[t5.Equipped_NotAttuned = 2] = "Equipped_NotAttuned", t5[t5.Equipped_Attuned = 3] = "Equipped_Attuned";
  }(l || (l = {}));
  const u = "required" === s2.attunement;
  return t4.$$set = (t5) => {
    "itemData" in t5 && n(5, s2 = t5.itemData);
  }, t4.$$.update = () => {
    32 & t4.$$.dirty && n(7, o2 = s2.attuned), 32 & t4.$$.dirty && n(6, i = s2.equipped), 192 & t4.$$.dirty && n(1, a = function(t5, e2) {
      return e2 ? u ? t5 ? l.Equipped_Attuned : l.Equipped_NotAttuned : l.Equipped_NoAttunementRequired : l.Unequipped;
    }(null != o2 && o2, i));
  }, [l, a, c, function() {
    if (!isReadOnlyActor(r2)) if (o2) {
      n(7, o2 = false);
      const t5 = { "system.attuned": o2, "system.equipped": false };
      FoundryGateway.updateItem(s2.parent, t5);
    } else {
      n(7, o2 = true);
      const t5 = { "system.attuned": o2, "system.equipped": true };
      FoundryGateway.updateItem(s2.parent, t5);
    }
  }, function() {
    if (isReadOnlyActor(r2)) return;
    n(6, i = !i);
    const t5 = { "system.equipped": i };
    FoundryGateway.updateItem(s2.parent, t5);
  }, s2, i, o2];
}
class EquippedAttuned extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1e, create_fragment$1f, safe_not_equal, { itemData: 5 });
  }
}
function create_default_slot_2$2(t4) {
  let e, n;
  return e = new FontAwesomeIcon({ props: { icon: faCheck, size: "2x", style: "color: green" } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p: noop$3, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_default_slot_1$2(t4) {
  let e, n;
  return e = new FontAwesomeIcon({ props: { icon: faXmark, size: "2x", style: "color: gray" } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p: noop$3, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_default_slot$6(t4) {
  let e, n, o2, i, a, r2, s2, c, l, u, p2, d, m, f, _ = t4[0].name + "";
  return p2 = new MCButton({ props: { $$slots: { default: [create_default_slot_2$2] }, $$scope: { ctx: t4 } } }), p2.$on("click", t4[2]), m = new MCButton({ props: { $$slots: { default: [create_default_slot_1$2] }, $$scope: { ctx: t4 } } }), m.$on("click", t4[1]), { c() {
    e = element("main"), n = element("h2"), n.textContent = "Delete Item?", o2 = space(), i = element("p"), a = text("Do you want to delete "), r2 = element("span"), s2 = text(_), c = text("?"), l = space(), u = element("section"), create_component(p2.$$.fragment), d = space(), create_component(m.$$.fragment), attr(n, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-8st4dp"), toggle_class(n, "v12", game.version.startsWith("12")), attr(r2, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-8st4dp"), attr(i, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-8st4dp"), toggle_class(i, "v12", game.version.startsWith("12")), attr(u, "class", "button-group svelte-mobile-companion-dnd5e-81nkluj30u9vsd-8st4dp"), attr(e, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-8st4dp");
  }, m(t5, _2) {
    insert(t5, e, _2), append(e, n), append(e, o2), append(e, i), append(i, a), append(i, r2), append(r2, s2), append(i, c), append(e, l), append(e, u), mount_component(p2, u, null), append(u, d), mount_component(m, u, null), f = true;
  }, p(t5, e2) {
    f || toggle_class(n, "v12", game.version.startsWith("12")), (!f || 1 & e2) && _ !== (_ = t5[0].name + "") && set_data(s2, _), f || toggle_class(i, "v12", game.version.startsWith("12"));
    const o3 = {};
    16 & e2 && (o3.$$scope = { dirty: e2, ctx: t5 }), p2.$set(o3);
    const a2 = {};
    16 & e2 && (a2.$$scope = { dirty: e2, ctx: t5 }), m.$set(a2);
  }, i(t5) {
    f || (transition_in(p2.$$.fragment, t5), transition_in(m.$$.fragment, t5), f = true);
  }, o(t5) {
    transition_out(p2.$$.fragment, t5), transition_out(m.$$.fragment, t5), f = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(p2), destroy_component(m);
  } };
}
function create_fragment$1e(t4) {
  let e, n;
  return e = new GenericModal({ props: { $$slots: { default: [create_default_slot$6] }, $$scope: { ctx: t4 } } }), e.$on("close", t4[1]), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, [n2]) {
    const o2 = {};
    17 & n2 && (o2.$$scope = { dirty: n2, ctx: t5 }), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function instance$1d(t4, e, n) {
  let { item: o2 } = e;
  const i = createEventDispatcher();
  return t4.$$set = (t5) => {
    "item" in t5 && n(0, o2 = t5.item);
  }, [o2, function() {
    i("close");
  }, () => o2.delete()];
}
class DeleteDialog extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1d, create_fragment$1e, safe_not_equal, { item: 0 });
  }
}
function create_if_block_6$1(t4) {
  let e, n;
  return e = new DeleteDialog({ props: { item: t4[1] } }), e.$on("close", t4[16]), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    2 & n2 && (o2.item = t5[1]), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_if_block_5$2(t4) {
  let e, n;
  return e = new ItemQuickInfo({ props: { item: t4[1] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    2 & n2 && (o2.item = t5[1]), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_below_name_content_slot$4(t4) {
  let e, n, o2 = t4[5] && create_if_block_5$2(t4);
  return { c() {
    e = element("div"), o2 && o2.c(), attr(e, "class", "quickinfo svelte-mobile-companion-dnd5e-81nkluj30u9vsd-10y6lek"), attr(e, "slot", "below-name-content");
  }, m(t5, i) {
    insert(t5, e, i), o2 && o2.m(e, null), n = true;
  }, p(t5, n2) {
    t5[5] ? o2 ? (o2.p(t5, n2), 32 & n2 && transition_in(o2, 1)) : (o2 = create_if_block_5$2(t5), o2.c(), transition_in(o2, 1), o2.m(e, null)) : o2 && (group_outros(), transition_out(o2, 1, 1, () => {
      o2 = null;
    }), check_outros());
  }, i(t5) {
    n || (transition_in(o2), n = true);
  }, o(t5) {
    transition_out(o2), n = false;
  }, d(t5) {
    t5 && detach(e), o2 && o2.d();
  } };
}
function create_right_content_slot$4(t4) {
  let e, n, o2, i, a, r2;
  return o2 = new EquippedAttuned({ props: { itemData: t4[2] } }), a = new Quantity({ props: { quantity: t4[2].quantity, readOnly: isReadOnlyActor(t4[0]), removeWhenZero: true, fontFamily: "var(--dnd5e-font-roboto)" } }), a.$on("onQtyChange", t4[10]), a.$on("remove", t4[17]), { c() {
    e = element("div"), n = element("div"), create_component(o2.$$.fragment), i = space(), create_component(a.$$.fragment), attr(n, "class", "equipped-attuned"), attr(e, "class", "rightControls svelte-mobile-companion-dnd5e-81nkluj30u9vsd-10y6lek"), attr(e, "slot", "right-content");
  }, m(t5, s2) {
    insert(t5, e, s2), append(e, n), mount_component(o2, n, null), append(e, i), mount_component(a, e, null), r2 = true;
  }, p(t5, e2) {
    const n2 = {};
    4 & e2 && (n2.itemData = t5[2]), o2.$set(n2);
    const i2 = {};
    4 & e2 && (i2.quantity = t5[2].quantity), 1 & e2 && (i2.readOnly = isReadOnlyActor(t5[0])), a.$set(i2);
  }, i(t5) {
    r2 || (transition_in(o2.$$.fragment, t5), transition_in(a.$$.fragment, t5), r2 = true);
  }, o(t5) {
    transition_out(o2.$$.fragment, t5), transition_out(a.$$.fragment, t5), r2 = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(o2), destroy_component(a);
  } };
}
function create_if_block_4$4(t4) {
  let e, n;
  return e = new ObjectProperties({ props: { item: t4[1] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    2 & n2 && (o2.item = t5[1]), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_if_block_3$6(t4) {
  let e, n;
  return e = new Price({ props: { price: t4[2].price } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    4 & n2 && (o2.price = t5[2].price), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_if_block_2$d(t4) {
  let e, n;
  return e = new Weight({ props: { weight: t4[2].weight } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    4 & n2 && (o2.weight = t5[2].weight), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_if_block_1$o(t4) {
  let e, n;
  return e = new ItemDescription({ props: { itemData: t4[2] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    4 & n2 && (o2.itemData = t5[2]), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_if_block$D(t4) {
  let e, n;
  return e = new ItemTransfer({ props: { actor: t4[0], item: t4[1] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    1 & n2 && (o2.actor = t5[0]), 2 & n2 && (o2.item = t5[1]), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_details_slot$5(t4) {
  let e, n, o2, i, a, r2, s2, c, l, u, p2, d = isFull();
  n = new ToggleFavorite({ props: { actor: t4[0], item: t4[1] } }), i = new Activities({ props: { activities: t4[7] } });
  let m = t4[2].properties?.size > 0 && create_if_block_4$4(t4);
  const f = t4[15].default, _ = create_slot(f, t4, t4[18], null);
  let h = t4[2].price && create_if_block_3$6(t4), g2 = t4[2].weight && create_if_block_2$d(t4), $2 = (t4[2].description || t4[2].price || t4[2].weight) && create_if_block_1$o(t4), b = d && create_if_block$D(t4);
  return { c() {
    e = element("div"), create_component(n.$$.fragment), o2 = space(), create_component(i.$$.fragment), a = space(), m && m.c(), r2 = space(), _ && _.c(), s2 = space(), h && h.c(), c = space(), g2 && g2.c(), l = space(), $2 && $2.c(), u = space(), b && b.c(), attr(e, "slot", "details");
  }, m(t5, d2) {
    insert(t5, e, d2), mount_component(n, e, null), append(e, o2), mount_component(i, e, null), append(e, a), m && m.m(e, null), append(e, r2), _ && _.m(e, null), append(e, s2), h && h.m(e, null), append(e, c), g2 && g2.m(e, null), append(e, l), $2 && $2.m(e, null), append(e, u), b && b.m(e, null), p2 = true;
  }, p(t5, o3) {
    const a2 = {};
    1 & o3 && (a2.actor = t5[0]), 2 & o3 && (a2.item = t5[1]), n.$set(a2);
    const s3 = {};
    128 & o3 && (s3.activities = t5[7]), i.$set(s3), t5[2].properties?.size > 0 ? m ? (m.p(t5, o3), 4 & o3 && transition_in(m, 1)) : (m = create_if_block_4$4(t5), m.c(), transition_in(m, 1), m.m(e, r2)) : m && (group_outros(), transition_out(m, 1, 1, () => {
      m = null;
    }), check_outros()), _ && _.p && (!p2 || 262144 & o3) && update_slot_base(_, f, t5, t5[18], p2 ? get_slot_changes(f, t5[18], o3, null) : get_all_dirty_from_scope(t5[18]), null), t5[2].price ? h ? (h.p(t5, o3), 4 & o3 && transition_in(h, 1)) : (h = create_if_block_3$6(t5), h.c(), transition_in(h, 1), h.m(e, c)) : h && (group_outros(), transition_out(h, 1, 1, () => {
      h = null;
    }), check_outros()), t5[2].weight ? g2 ? (g2.p(t5, o3), 4 & o3 && transition_in(g2, 1)) : (g2 = create_if_block_2$d(t5), g2.c(), transition_in(g2, 1), g2.m(e, l)) : g2 && (group_outros(), transition_out(g2, 1, 1, () => {
      g2 = null;
    }), check_outros()), t5[2].description || t5[2].price || t5[2].weight ? $2 ? ($2.p(t5, o3), 4 & o3 && transition_in($2, 1)) : ($2 = create_if_block_1$o(t5), $2.c(), transition_in($2, 1), $2.m(e, u)) : $2 && (group_outros(), transition_out($2, 1, 1, () => {
      $2 = null;
    }), check_outros()), 64 & o3 && (d = isFull()), d ? b ? (b.p(t5, o3), 64 & o3 && transition_in(b, 1)) : (b = create_if_block$D(t5), b.c(), transition_in(b, 1), b.m(e, null)) : b && (group_outros(), transition_out(b, 1, 1, () => {
      b = null;
    }), check_outros());
  }, i(t5) {
    p2 || (transition_in(n.$$.fragment, t5), transition_in(i.$$.fragment, t5), transition_in(m), transition_in(_, t5), transition_in(h), transition_in(g2), transition_in($2), transition_in(b), p2 = true);
  }, o(t5) {
    transition_out(n.$$.fragment, t5), transition_out(i.$$.fragment, t5), transition_out(m), transition_out(_, t5), transition_out(h), transition_out(g2), transition_out($2), transition_out(b), p2 = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(n), destroy_component(i), m && m.d(), _ && _.d(t5), h && h.d(), g2 && g2.d(), $2 && $2.d(), b && b.d();
  } };
}
function create_fragment$1d(t4) {
  let e, n, o2, i = t4[4] && create_if_block_6$1(t4);
  return n = new ToggleableListEntry({ props: { name: t4[3] ?? "", imageSrc: t4[1].img, $$slots: { details: [create_details_slot$5], "right-content": [create_right_content_slot$4], "below-name-content": [create_below_name_content_slot$4] }, $$scope: { ctx: t4 } } }), { c() {
    i && i.c(), e = space(), create_component(n.$$.fragment);
  }, m(t5, a) {
    i && i.m(t5, a), insert(t5, e, a), mount_component(n, t5, a), o2 = true;
  }, p(t5, [o3]) {
    t5[4] ? i ? (i.p(t5, o3), 16 & o3 && transition_in(i, 1)) : (i = create_if_block_6$1(t5), i.c(), transition_in(i, 1), i.m(e.parentNode, e)) : i && (group_outros(), transition_out(i, 1, 1, () => {
      i = null;
    }), check_outros());
    const a = {};
    8 & o3 && (a.name = t5[3] ?? ""), 2 & o3 && (a.imageSrc = t5[1].img), 262391 & o3 && (a.$$scope = { dirty: o3, ctx: t5 }), n.$set(a);
  }, i(t5) {
    o2 || (transition_in(i), transition_in(n.$$.fragment, t5), o2 = true);
  }, o(t5) {
    transition_out(i), transition_out(n.$$.fragment, t5), o2 = false;
  }, d(t5) {
    t5 && detach(e), i && i.d(t5), destroy_component(n, t5);
  } };
}
function instance$1c(t4, e, n) {
  let o2, i, a, r2, s2, { $$slots: c = {}, $$scope: l } = e;
  var u;
  let p2, d, { actor: m } = e, { item: f } = e, _ = f.system;
  const h = mobileCompanionGameSettings.getWritableStore(USE_CONTAINER);
  component_subscribe(t4, h, (t5) => n(14, s2 = t5));
  const g2 = mobileCompanionGameSettings.getWritableStore(USE_ADDITIONAL_INFO);
  component_subscribe(t4, g2, (t5) => n(13, r2 = t5));
  let $2 = false;
  return t4.$$set = (t5) => {
    "actor" in t5 && n(0, m = t5.actor), "item" in t5 && n(1, f = t5.item), "$$scope" in t5 && n(18, l = t5.$$scope);
  }, t4.$$.update = () => {
    4102 & t4.$$.dirty && (n(2, _ = f.system), n(12, d = _.identified), n(3, p2 = d ? f.name : _.unidentified.name)), 2052 & t4.$$.dirty && n(7, o2 = null === n(11, u = _.activities) || void 0 === u ? void 0 : u.contents), 16384 & t4.$$.dirty && n(6, i = s2), 8192 & t4.$$.dirty && n(5, a = r2);
  }, [m, f, _, p2, $2, a, i, o2, h, g2, function(t5) {
    const e2 = { system: { quantity: t5.detail.newValue } };
    FoundryGateway.updateItem(f, e2);
  }, u, d, r2, s2, c, () => n(4, $2 = false), () => n(4, $2 = true), l];
}
let Object$1 = class extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1c, create_fragment$1d, safe_not_equal, { actor: 0, item: 1 });
  }
};
function create_catch_block$1(t4) {
  return { c: noop$3, m: noop$3, p: noop$3, d: noop$3 };
}
function create_then_block$1(t4) {
  let e, n, o2 = "shield" === t4[0].type.value ? "+" : "", i = t4[4] + "";
  return { c() {
    e = text(o2), n = text(i);
  }, m(t5, o3) {
    insert(t5, e, o3), insert(t5, n, o3);
  }, p(t5, n2) {
    1 & n2 && o2 !== (o2 = "shield" === t5[0].type.value ? "+" : "") && set_data(e, o2);
  }, d(t5) {
    t5 && (detach(e), detach(n));
  } };
}
function create_pending_block$1(t4) {
  return { c: noop$3, m: noop$3, p: noop$3, d: noop$3 };
}
function create_if_block_1$n(t4) {
  let e, n, o2, i, a, r2, s2, c = t4[0].armor.value + "", l = Math.min(t4[1].abilities.dex.mod, t4[0].armor.dex) + "", u = i18n("DND5E.AbilityDex") + "";
  return { c() {
    e = text("("), n = text(c), o2 = text(" + "), i = text(l), a = space(), r2 = text(u), s2 = text(")");
  }, m(t5, c2) {
    insert(t5, e, c2), insert(t5, n, c2), insert(t5, o2, c2), insert(t5, i, c2), insert(t5, a, c2), insert(t5, r2, c2), insert(t5, s2, c2);
  }, p(t5, e2) {
    1 & e2 && c !== (c = t5[0].armor.value + "") && set_data(n, c), 3 & e2 && l !== (l = Math.min(t5[1].abilities.dex.mod, t5[0].armor.dex) + "") && set_data(i, l);
  }, d(t5) {
    t5 && (detach(e), detach(n), detach(o2), detach(i), detach(a), detach(r2), detach(s2));
  } };
}
function create_if_block$C(t4) {
  let e, n, o2, i, a = t4[0].strength + "";
  return { c() {
    e = element("p"), n = element("b"), n.textContent = `${i18n("DND5E.ItemRequiredStr")}:`, o2 = space(), i = text(a);
  }, m(t5, a2) {
    insert(t5, e, a2), append(e, n), append(e, o2), append(e, i);
  }, p(t5, e2) {
    1 & e2 && a !== (a = t5[0].strength + "") && set_data(i, a);
  }, d(t5) {
    t5 && detach(e);
  } };
}
function create_fragment$1c(t4) {
  let e, n, o2, i, a, r2, s2 = { ctx: t4, current: null, token: null, hasCatch: false, pending: create_pending_block$1, then: create_then_block$1, catch: create_catch_block$1, value: 4 };
  handle_promise(t4[2], s2);
  let c = t4[0].armor.dex && create_if_block_1$n(t4), l = t4[0].strength && create_if_block$C(t4);
  return { c() {
    e = element("p"), n = element("b"), n.textContent = `${i18n("DND5E.ArmorClass")}:`, o2 = space(), s2.block.c(), i = space(), c && c.c(), a = space(), l && l.c(), r2 = empty();
  }, m(t5, u) {
    insert(t5, e, u), append(e, n), append(e, o2), s2.block.m(e, s2.anchor = null), s2.mount = () => e, s2.anchor = i, append(e, i), c && c.m(e, null), insert(t5, a, u), l && l.m(t5, u), insert(t5, r2, u);
  }, p(n2, [o3]) {
    update_await_block_branch(s2, t4 = n2, o3), t4[0].armor.dex ? c ? c.p(t4, o3) : (c = create_if_block_1$n(t4), c.c(), c.m(e, null)) : c && (c.d(1), c = null), t4[0].strength ? l ? l.p(t4, o3) : (l = create_if_block$C(t4), l.c(), l.m(r2.parentNode, r2)) : l && (l.d(1), l = null);
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && (detach(e), detach(a), detach(r2)), s2.block.d(), s2.token = null, s2 = null, c && c.d(), l && l.d(t5);
  } };
}
function instance$1b(t4, e, n) {
  let { item: o2 } = e, { rollData: i } = e;
  let a = evaluateTotal(o2.armor.value + ` + min(${o2.armor.dex ? o2.armor.dex : 0},@abilities.dex.mod)`, i);
  return t4.$$set = (t5) => {
    "item" in t5 && n(0, o2 = t5.item), "rollData" in t5 && n(1, i = t5.rollData);
  }, [o2, i, a];
}
class ArmorClass extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1b, create_fragment$1c, safe_not_equal, { item: 0, rollData: 1 });
  }
}
function create_if_block_1$m(t4) {
  let e, n, o2, i;
  return { c() {
    e = element("p"), n = element("b"), n.textContent = `${i18n("DND5E.Type")}:`, o2 = space(), i = text(t4[2]);
  }, m(t5, a) {
    insert(t5, e, a), append(e, n), append(e, o2), append(e, i);
  }, p: noop$3, d(t5) {
    t5 && detach(e);
  } };
}
function create_if_block$B(t4) {
  let e, n;
  return e = new ArmorClass({ props: { item: t4[1], rollData: t4[0] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    1 & n2 && (o2.rollData = t5[0]), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_fragment$1b(t4) {
  let e, n, o2, i = t4[2] && create_if_block_1$m(t4), a = t4[1].armor?.value && create_if_block$B(t4);
  return { c() {
    i && i.c(), e = space(), a && a.c(), n = empty();
  }, m(t5, r2) {
    i && i.m(t5, r2), insert(t5, e, r2), a && a.m(t5, r2), insert(t5, n, r2), o2 = true;
  }, p(t5, [e2]) {
    t5[2] && i.p(t5, e2), t5[1].armor?.value && a.p(t5, e2);
  }, i(t5) {
    o2 || (transition_in(a), o2 = true);
  }, o(t5) {
    transition_out(a), o2 = false;
  }, d(t5) {
    t5 && (detach(e), detach(n)), i && i.d(t5), a && a.d(t5);
  } };
}
function instance$1a(t4, e, n) {
  let { item: o2 } = e, { rollData: i } = e, a = o2.system;
  const r2 = CONFIG.DND5E.equipmentTypes[a.type.value];
  return t4.$$set = (t5) => {
    "item" in t5 && n(3, o2 = t5.item), "rollData" in t5 && n(0, i = t5.rollData);
  }, [i, a, r2, o2];
}
class EquipmentObject extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1a, create_fragment$1b, safe_not_equal, { item: 3, rollData: 0 });
  }
}
function create_if_block$A(t4) {
  let e, n, o2, i;
  return { c() {
    e = element("p"), n = element("b"), n.textContent = `${i18n("DND5E.Type")}:`, o2 = space(), i = text(t4[0]);
  }, m(t5, a) {
    insert(t5, e, a), append(e, n), append(e, o2), append(e, i);
  }, p: noop$3, d(t5) {
    t5 && detach(e);
  } };
}
function create_fragment$1a(t4) {
  let e, n = t4[0] && create_if_block$A(t4);
  return { c() {
    n && n.c(), e = empty();
  }, m(t5, o2) {
    n && n.m(t5, o2), insert(t5, e, o2);
  }, p(t5, [e2]) {
    t5[0] && n.p(t5, e2);
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e), n && n.d(t5);
  } };
}
function instance$19(t4, e, n) {
  var o2;
  let { item: i } = e;
  const a = i.system, r2 = null === (o2 = CONFIG.DND5E.lootTypes[a.type.value]) || void 0 === o2 ? void 0 : o2.label;
  return t4.$$set = (t5) => {
    "item" in t5 && n(1, i = t5.item);
  }, [r2, i];
}
class LootObject extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$19, create_fragment$1a, safe_not_equal, { item: 1 });
  }
}
function create_if_block$z(t4) {
  let e, n, o2, i;
  return { c() {
    e = element("p"), n = element("b"), n.textContent = `${i18n("DND5E.Ability")}:`, o2 = space(), i = text(t4[0]);
  }, m(t5, a) {
    insert(t5, e, a), append(e, n), append(e, o2), append(e, i);
  }, p: noop$3, d(t5) {
    t5 && detach(e);
  } };
}
function create_fragment$19(t4) {
  let e, n = t4[0] && create_if_block$z(t4);
  return { c() {
    n && n.c(), e = empty();
  }, m(t5, o2) {
    n && n.m(t5, o2), insert(t5, e, o2);
  }, p(t5, [e2]) {
    t5[0] && n.p(t5, e2);
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e), n && n.d(t5);
  } };
}
function instance$18(t4, e, n) {
  var o2;
  let { item: i } = e, a = i.system, r2 = null === (o2 = CONFIG.DND5E.abilities[a.ability]) || void 0 === o2 ? void 0 : o2.label;
  return t4.$$set = (t5) => {
    "item" in t5 && n(1, i = t5.item);
  }, [r2, i];
}
class ToolObject extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$18, create_fragment$19, safe_not_equal, { item: 1 });
  }
}
function create_if_block$y(t4) {
  let e, n, o2, i;
  return { c() {
    e = element("p"), n = element("b"), n.textContent = `${i18n("DND5E.ItemWeaponType")}:`, o2 = space(), i = text(t4[0]);
  }, m(t5, a) {
    insert(t5, e, a), append(e, n), append(e, o2), append(e, i);
  }, p: noop$3, d(t5) {
    t5 && detach(e);
  } };
}
function create_fragment$18(t4) {
  let e, n = t4[0] && create_if_block$y(t4);
  return { c() {
    n && n.c(), e = empty();
  }, m(t5, o2) {
    n && n.m(t5, o2), insert(t5, e, o2);
  }, p(t5, [e2]) {
    t5[0] && n.p(t5, e2);
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e), n && n.d(t5);
  } };
}
function instance$17(t4, e, n) {
  let { item: o2 } = e, i = o2.system;
  const a = CONFIG.DND5E.weaponTypes[i.type.value];
  return t4.$$set = (t5) => {
    "item" in t5 && n(1, o2 = t5.item);
  }, [a, o2];
}
class WeaponObject extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$17, create_fragment$18, safe_not_equal, { item: 1 });
  }
}
function create_fragment$17(t4) {
  let e, n, o2, i, a;
  const r2 = t4[2].default, s2 = create_slot(r2, t4, t4[1], null);
  return { c() {
    e = element("div"), n = element("h3"), o2 = text(t4[0]), i = space(), s2 && s2.c(), attr(n, "class", "item-name svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1sxeqxo"), attr(e, "class", "items-header svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1sxeqxo");
  }, m(t5, r3) {
    insert(t5, e, r3), append(e, n), append(n, o2), append(e, i), s2 && s2.m(e, null), a = true;
  }, p(t5, [e2]) {
    (!a || 1 & e2) && set_data(o2, t5[0]), s2 && s2.p && (!a || 2 & e2) && update_slot_base(s2, r2, t5, t5[1], a ? get_slot_changes(r2, t5[1], e2, null) : get_all_dirty_from_scope(t5[1]), null);
  }, i(t5) {
    a || (transition_in(s2, t5), a = true);
  }, o(t5) {
    transition_out(s2, t5), a = false;
  }, d(t5) {
    t5 && detach(e), s2 && s2.d(t5);
  } };
}
function instance$16(t4, e, n) {
  let { $$slots: o2 = {}, $$scope: i } = e, { title: a } = e;
  return t4.$$set = (t5) => {
    "title" in t5 && n(0, a = t5.title), "$$scope" in t5 && n(1, i = t5.$$scope);
  }, [a, i, o2];
}
class SectionListHeader extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$16, create_fragment$17, safe_not_equal, { title: 0 });
  }
}
function create_fragment$16(t4) {
  let e, n, o2, i;
  return { c() {
    e = element("div"), n = element("input"), attr(n, "type", "text"), attr(n, "placeholder", t4[0]), attr(n, "class", "search-input svelte-mobile-companion-dnd5e-81nkluj30u9vsd-vhhux5"), attr(e, "class", "search-container svelte-mobile-companion-dnd5e-81nkluj30u9vsd-vhhux5");
  }, m(a, r2) {
    insert(a, e, r2), append(e, n), o2 || (i = listen(n, "input", t4[1]), o2 = true);
  }, p(t5, [e2]) {
    1 & e2 && attr(n, "placeholder", t5[0]);
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e), o2 = false, i();
  } };
}
function instance$15(t4, e, n) {
  let { placeholder: o2 = "Search..." } = e;
  const i = createEventDispatcher();
  return t4.$$set = (t5) => {
    "placeholder" in t5 && n(0, o2 = t5.placeholder);
  }, [o2, function(t5) {
    const e2 = t5.target;
    i("search", e2.value);
  }];
}
class SearchBar extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$15, create_fragment$16, safe_not_equal, { placeholder: 0 });
  }
}
function get_each_context$i(t4, e, n) {
  const o2 = t4.slice();
  return o2[6] = e[n], o2;
}
function create_default_slot$5(t4) {
  let e, n, o2 = t4[6].label + "";
  return { c() {
    e = text(o2), n = space();
  }, m(t5, o3) {
    insert(t5, e, o3), insert(t5, n, o3);
  }, p(t5, n2) {
    1 & n2 && o2 !== (o2 = t5[6].label + "") && set_data(e, o2);
  }, d(t5) {
    t5 && (detach(e), detach(n));
  } };
}
function create_each_block$i(t4) {
  let e, n;
  return e = new MCButton({ props: { customClass: "global-filter-option " + (t4[2](t4[6]) ? "enabled" : ""), $$slots: { default: [create_default_slot$5] }, $$scope: { ctx: t4 } } }), e.$on("click", function() {
    return t4[5](t4[6]);
  }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(n2, o2) {
    t4 = n2;
    const i = {};
    5 & o2 && (i.customClass = "global-filter-option " + (t4[2](t4[6]) ? "enabled" : "")), 513 & o2 && (i.$$scope = { dirty: o2, ctx: t4 }), e.$set(i);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_fragment$15(t4) {
  let e, n, o2 = ensure_array_like(t4[0]), i = [];
  for (let e2 = 0; e2 < o2.length; e2 += 1) i[e2] = create_each_block$i(get_each_context$i(t4, o2, e2));
  const a = (t5) => transition_out(i[t5], 1, 1, () => {
    i[t5] = null;
  });
  return { c() {
    for (let t5 = 0; t5 < i.length; t5 += 1) i[t5].c();
    e = empty();
  }, m(t5, o3) {
    for (let e2 = 0; e2 < i.length; e2 += 1) i[e2] && i[e2].m(t5, o3);
    insert(t5, e, o3), n = true;
  }, p(t5, [n2]) {
    if (13 & n2) {
      let r2;
      for (o2 = ensure_array_like(t5[0]), r2 = 0; r2 < o2.length; r2 += 1) {
        const a2 = get_each_context$i(t5, o2, r2);
        i[r2] ? (i[r2].p(a2, n2), transition_in(i[r2], 1)) : (i[r2] = create_each_block$i(a2), i[r2].c(), transition_in(i[r2], 1), i[r2].m(e.parentNode, e));
      }
      for (group_outros(), r2 = o2.length; r2 < i.length; r2 += 1) a(r2);
      check_outros();
    }
  }, i(t5) {
    if (!n) {
      for (let t6 = 0; t6 < o2.length; t6 += 1) transition_in(i[t6]);
      n = true;
    }
  }, o(t5) {
    i = i.filter(Boolean);
    for (let t6 = 0; t6 < i.length; t6 += 1) transition_out(i[t6]);
    n = false;
  }, d(t5) {
    t5 && detach(e), destroy_each(i, t5);
  } };
}
function instance$14(t4, e, n) {
  let o2, i, a = noop$3, r2 = () => (a(), a = subscribe(c, (t5) => n(4, i = t5)), c);
  t4.$$.on_destroy.push(() => a());
  let { filterOptions: s2 } = e, { activeFilterStore: c } = e;
  function l(t5) {
    o2(t5) ? c.update((e2) => e2.filter((e3) => e3.label !== t5.label)) : c.update((e2) => [...e2, t5]);
  }
  r2();
  return t4.$$set = (t5) => {
    "filterOptions" in t5 && n(0, s2 = t5.filterOptions), "activeFilterStore" in t5 && r2(n(1, c = t5.activeFilterStore));
  }, t4.$$.update = () => {
    16 & t4.$$.dirty && n(2, o2 = (t5) => i.some((e2) => e2.label === t5.label));
  }, [s2, c, o2, l, i, (t5) => l(t5)];
}
class FilterComponent extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$14, create_fragment$15, safe_not_equal, { filterOptions: 0, activeFilterStore: 1 });
  }
}
function create_fragment$14(t4) {
  let e, n, o2, i, a, r2, s2, c;
  o2 = new FontAwesomeIcon({ props: { icon: faCircleChevronRight, size: "xl", style: "color: var(--dnd5e-color-gold)" } });
  const l = t4[2].default, u = create_slot(l, t4, t4[1], null);
  return { c() {
    e = element("div"), n = element("span"), create_component(o2.$$.fragment), i = space(), u && u.c(), attr(n, "class", "close-button svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1jnx3y7"), attr(n, "aria-hidden", "true"), attr(e, "class", "sidebar svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1jnx3y7");
  }, m(a2, l2) {
    insert(a2, e, l2), append(e, n), mount_component(o2, n, null), append(e, i), u && u.m(e, null), r2 = true, s2 || (c = listen(n, "click", t4[0]), s2 = true);
  }, p(t5, [e2]) {
    u && u.p && (!r2 || 2 & e2) && update_slot_base(u, l, t5, t5[1], r2 ? get_slot_changes(l, t5[1], e2, null) : get_all_dirty_from_scope(t5[1]), null);
  }, i(t5) {
    r2 || (transition_in(o2.$$.fragment, t5), transition_in(u, t5), add_render_callback(() => {
      r2 && (a || (a = create_bidirectional_transition(e, slide, { duration: 100, axis: "x" }, true)), a.run(1));
    }), r2 = true);
  }, o(t5) {
    transition_out(o2.$$.fragment, t5), transition_out(u, t5), a || (a = create_bidirectional_transition(e, slide, { duration: 100, axis: "x" }, false)), a.run(0), r2 = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(o2), u && u.d(t5), t5 && a && a.end(), s2 = false, c();
  } };
}
function instance$13(t4, e, n) {
  let { $$slots: o2 = {}, $$scope: i } = e;
  const a = createEventDispatcher();
  return t4.$$set = (t5) => {
    "$$scope" in t5 && n(1, i = t5.$$scope);
  }, [function() {
    a("close");
  }, i, o2];
}
class SlideInSidebar extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$13, create_fragment$14, safe_not_equal, {});
  }
}
function create_fragment$13(t4) {
  let e, n, o2, i, a, r2, s2, c, l;
  i = new FontAwesomeIcon({ props: { icon: faXmarkCircle, size: "xl", style: "color: var(--dnd5e-color-gold)" } });
  const u = t4[5].default, p2 = create_slot(u, t4, t4[4], null);
  return { c() {
    e = element("div"), n = element("div"), o2 = element("span"), create_component(i.$$.fragment), a = space(), p2 && p2.c(), attr(o2, "class", "close-button svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1ohf4lg"), attr(o2, "aria-hidden", "true"), attr(n, "class", "context-menu svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1ohf4lg"), set_style(n, "--menu-x", t4[0] + "px"), set_style(n, "--menu-y", t4[1] + "px"), attr(e, "class", "context-menu-wrapper svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1ohf4lg"), attr(e, "aria-hidden", "true");
  }, m(r3, u2) {
    insert(r3, e, u2), append(e, n), append(n, o2), mount_component(i, o2, null), append(n, a), p2 && p2.m(n, null), s2 = true, c || (l = [listen(o2, "click", t4[2]), listen(e, "click", t4[3])], c = true);
  }, p(t5, [e2]) {
    p2 && p2.p && (!s2 || 16 & e2) && update_slot_base(p2, u, t5, t5[4], s2 ? get_slot_changes(u, t5[4], e2, null) : get_all_dirty_from_scope(t5[4]), null), (!s2 || 1 & e2) && set_style(n, "--menu-x", t5[0] + "px"), (!s2 || 2 & e2) && set_style(n, "--menu-y", t5[1] + "px");
  }, i(t5) {
    s2 || (transition_in(i.$$.fragment, t5), transition_in(p2, t5), add_render_callback(() => {
      s2 && (r2 || (r2 = create_bidirectional_transition(n, scale, { duration: 200, start: 0.1 }, true)), r2.run(1));
    }), s2 = true);
  }, o(t5) {
    transition_out(i.$$.fragment, t5), transition_out(p2, t5), r2 || (r2 = create_bidirectional_transition(n, scale, { duration: 200, start: 0.1 }, false)), r2.run(0), s2 = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(i), p2 && p2.d(t5), t5 && r2 && r2.end(), c = false, run_all(l);
  } };
}
function instance$12(t4, e, n) {
  let { $$slots: o2 = {}, $$scope: i } = e;
  const a = createEventDispatcher();
  let { x: r2 = 0 } = e, { y: s2 = 0 } = e;
  function c() {
    a("close");
  }
  return t4.$$set = (t5) => {
    "x" in t5 && n(0, r2 = t5.x), "y" in t5 && n(1, s2 = t5.y), "$$scope" in t5 && n(4, i = t5.$$scope);
  }, [r2, s2, c, function(t5) {
    t5.target === t5.currentTarget && c();
  }, i, o2];
}
class StyledContextMenu extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$12, create_fragment$13, safe_not_equal, { x: 0, y: 1 });
  }
}
function create_if_block_1$l(t4) {
  let e, n, o2, i;
  const a = [create_if_block_2$c, create_else_block_1], r2 = [];
  function s2(t5, e2) {
    return t5[6].isLargeScreen ? 0 : 1;
  }
  return e = s2(t4), n = r2[e] = a[e](t4), { c() {
    n.c(), o2 = empty();
  }, m(t5, n2) {
    r2[e].m(t5, n2), insert(t5, o2, n2), i = true;
  }, p(t5, i2) {
    let c = e;
    e = s2(t5), e === c ? r2[e].p(t5, i2) : (group_outros(), transition_out(r2[c], 1, 1, () => {
      r2[c] = null;
    }), check_outros(), n = r2[e], n ? n.p(t5, i2) : (n = r2[e] = a[e](t5), n.c()), transition_in(n, 1), n.m(o2.parentNode, o2));
  }, i(t5) {
    i || (transition_in(n), i = true);
  }, o(t5) {
    transition_out(n), i = false;
  }, d(t5) {
    t5 && detach(o2), r2[e].d(t5);
  } };
}
function create_else_block_1(t4) {
  let e, n;
  return e = new SlideInSidebar({ props: { $$slots: { default: [create_default_slot_2$1] }, $$scope: { ctx: t4 } } }), e.$on("close", t4[12]), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    65542 & n2 && (o2.$$scope = { dirty: n2, ctx: t5 }), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_if_block_2$c(t4) {
  let e, n;
  return e = new StyledContextMenu({ props: { x: t4[9]().x, y: t4[9]().y, $$slots: { default: [create_default_slot_1$1] }, $$scope: { ctx: t4 } } }), e.$on("close", t4[11]), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    65542 & n2 && (o2.$$scope = { dirty: n2, ctx: t5 }), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_default_slot_2$1(t4) {
  let e, n;
  return e = new FilterComponent({ props: { filterOptions: t4[1], activeFilterStore: t4[2] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    2 & n2 && (o2.filterOptions = t5[1]), 4 & n2 && (o2.activeFilterStore = t5[2]), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_default_slot_1$1(t4) {
  let e, n;
  return e = new FilterComponent({ props: { filterOptions: t4[1], activeFilterStore: t4[2] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    2 & n2 && (o2.filterOptions = t5[1]), 4 & n2 && (o2.activeFilterStore = t5[2]), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_else_block$8(t4) {
  let e, n;
  return e = new FontAwesomeIcon({ props: { icon: faFilter, size: "lg" } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_if_block$x(t4) {
  let e, n;
  return e = new FontAwesomeIcon({ props: { icon: faFilter, size: "lg", style: "color: red" } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_default_slot$4(t4) {
  let e, n, o2, i;
  const a = [create_if_block$x, create_else_block$8], r2 = [];
  function s2(t5, e2) {
    return t5[5] ? 0 : 1;
  }
  return e = s2(t4), n = r2[e] = a[e](t4), { c() {
    n.c(), o2 = empty();
  }, m(t5, n2) {
    r2[e].m(t5, n2), insert(t5, o2, n2), i = true;
  }, p(t5, i2) {
    let c = e;
    e = s2(t5), e !== c && (group_outros(), transition_out(r2[c], 1, 1, () => {
      r2[c] = null;
    }), check_outros(), n = r2[e], n || (n = r2[e] = a[e](t5), n.c()), transition_in(n, 1), n.m(o2.parentNode, o2));
  }, i(t5) {
    i || (transition_in(n), i = true);
  }, o(t5) {
    transition_out(n), i = false;
  }, d(t5) {
    t5 && detach(o2), r2[e].d(t5);
  } };
}
function create_fragment$12(t4) {
  let e, n, o2, i, a, r2, s2, c = t4[3] && create_if_block_1$l(t4);
  return o2 = new SearchBar({ props: { placeholder: t4[0] } }), o2.$on("search", t4[8]), r2 = new MCButton({ props: { $$slots: { default: [create_default_slot$4] }, $$scope: { ctx: t4 } } }), r2.$on("click", t4[13]), { c() {
    c && c.c(), e = space(), n = element("div"), create_component(o2.$$.fragment), i = space(), a = element("div"), create_component(r2.$$.fragment), attr(n, "class", "bar svelte-mobile-companion-dnd5e-81nkluj30u9vsd-146regc");
  }, m(l, u) {
    c && c.m(l, u), insert(l, e, u), insert(l, n, u), mount_component(o2, n, null), append(n, i), append(n, a), mount_component(r2, a, null), t4[14](a), s2 = true;
  }, p(t5, [n2]) {
    t5[3] ? c ? (c.p(t5, n2), 8 & n2 && transition_in(c, 1)) : (c = create_if_block_1$l(t5), c.c(), transition_in(c, 1), c.m(e.parentNode, e)) : c && (group_outros(), transition_out(c, 1, 1, () => {
      c = null;
    }), check_outros());
    const i2 = {};
    1 & n2 && (i2.placeholder = t5[0]), o2.$set(i2);
    const a2 = {};
    65568 & n2 && (a2.$$scope = { dirty: n2, ctx: t5 }), r2.$set(a2);
  }, i(t5) {
    s2 || (transition_in(c), transition_in(o2.$$.fragment, t5), transition_in(r2.$$.fragment, t5), s2 = true);
  }, o(t5) {
    transition_out(c), transition_out(o2.$$.fragment, t5), transition_out(r2.$$.fragment, t5), s2 = false;
  }, d(i2) {
    i2 && (detach(e), detach(n)), c && c.d(i2), destroy_component(o2), destroy_component(r2), t4[14](null);
  } };
}
function instance$11(t4, e, n) {
  let o2, i, a, r2 = noop$3, s2 = () => (r2(), r2 = subscribe(u, (t5) => n(10, i = t5)), u);
  t4.$$.on_destroy.push(() => r2());
  let { placeholder: c = "Search..." } = e, { filterOptions: l } = e, { filterStore: u } = e;
  s2();
  const p2 = createEventDispatcher(), d = getContext(CONTEXT.INNER_APP_WIDTH_STORE);
  component_subscribe(t4, d, (t5) => n(6, a = t5));
  let m, f = false;
  return t4.$$set = (t5) => {
    "placeholder" in t5 && n(0, c = t5.placeholder), "filterOptions" in t5 && n(1, l = t5.filterOptions), "filterStore" in t5 && s2(n(2, u = t5.filterStore));
  }, t4.$$.update = () => {
    1024 & t4.$$.dirty && n(5, o2 = i.length > 0);
  }, [c, l, u, f, m, o2, a, d, function(t5) {
    p2("search", t5.detail);
  }, function() {
    if (!m) return { x: 0, y: 0 };
    const t5 = m.getBoundingClientRect();
    return { x: t5.right, y: t5.bottom };
  }, i, () => n(3, f = false), () => n(3, f = false), () => n(3, f = !f), function(t5) {
    binding_callbacks[t5 ? "unshift" : "push"](() => {
      m = t5, n(4, m);
    });
  }];
}
class FilterAndSearch extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$11, create_fragment$12, safe_not_equal, { placeholder: 0, filterOptions: 1, filterStore: 2 });
  }
}
const magicalString = () => foundry.utils.isNewerVersion(game.system.version, "4.4.4") ? i18n("DND5E.ITEM.Property.Magical") : i18n("DND5E.Item.Property.Magical");
function create_fragment$11(t4) {
  let e, n;
  return e = new FilterAndSearch({ props: { placeholder: "Search item...", filterStore: t4[0], filterOptions: t4[2] } }), e.$on("search", t4[1]), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p: noop$3, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function hasActivationOfType(t4, e) {
  return !!t4.system.activities && t4.system.activities.contents.some((t5) => t5.activation.type === e);
}
function instance$10(t4) {
  const e = getContext(CONTEXT.ACTIVE_OBJECT_FILTER), n = createEventDispatcher();
  return [e, function(t5) {
    n("search", t5.detail);
  }, [{ label: i18n("DND5E.Action"), filterFct: (t5) => hasActivationOfType(t5, "action") }, { label: i18n("DND5E.BonusAction"), filterFct: (t5) => hasActivationOfType(t5, "bonus") }, { label: i18n("DND5E.Reaction"), filterFct: (t5) => hasActivationOfType(t5, "reaction") }, { label: i18n("DND5E.Unidentified.Title"), filterFct: (t5) => false === foundry.utils.getProperty(t5, "system.identified") }, { label: i18n("DND5E.Attuned"), filterFct: (t5) => true === foundry.utils.getProperty(t5, "system.attuned") }, { label: i18n("DND5E.AttunementRequired"), filterFct: (t5) => "required" === foundry.utils.getProperty(t5, "system.attunement") }, { label: i18n("DND5E.Equipped"), filterFct: (t5) => true === foundry.utils.getProperty(t5, "system.equipped") }, { label: magicalString(), filterFct: (t5) => foundry.utils.getProperty(t5, "system.properties").has("mgc") }, { label: i18n("Zero Amount"), filterFct: (t5) => 0 === foundry.utils.getProperty(t5, "system.quantity") }]];
}
class ObjectFilterAndSearch extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$10, create_fragment$11, safe_not_equal, {});
  }
}
function get_each_context$h(t4, e, n) {
  const o2 = t4.slice();
  return o2[15] = e[n], o2;
}
function get_each_context_1$7(t4, e, n) {
  const o2 = t4.slice();
  return o2[18] = e[n], o2;
}
function get_each_context_2$3(t4, e, n) {
  const o2 = t4.slice();
  return o2[21] = e[n], o2;
}
function get_each_context_3$2(t4, e, n) {
  const o2 = t4.slice();
  return o2[24] = e[n], o2;
}
function get_each_context_4(t4, e, n) {
  const o2 = t4.slice();
  return o2[27] = e[n], o2;
}
function get_each_context_5(t4, e, n) {
  const o2 = t4.slice();
  return o2[30] = e[n], o2;
}
function create_if_block_5$1(t4) {
  let e, n, o2, i, a, r2 = [], s2 = /* @__PURE__ */ new Map();
  n = new SectionListHeader({ props: { title: i18n("TYPES.Item.weaponPl") } });
  let c = ensure_array_like(t4[6]);
  const l = (t5) => t5[30].id;
  for (let e2 = 0; e2 < c.length; e2 += 1) {
    let n2 = get_each_context_5(t4, c, e2), o3 = l(n2);
    s2.set(o3, r2[e2] = create_each_block_5(o3, n2));
  }
  return { c() {
    e = element("section"), create_component(n.$$.fragment), o2 = space(), i = element("ol");
    for (let t5 = 0; t5 < r2.length; t5 += 1) r2[t5].c();
    attr(i, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-mfxl5s");
  }, m(t5, s3) {
    insert(t5, e, s3), mount_component(n, e, null), append(e, o2), append(e, i);
    for (let t6 = 0; t6 < r2.length; t6 += 1) r2[t6] && r2[t6].m(i, null);
    a = true;
  }, p(t5, e2) {
    65 & e2[0] && (c = ensure_array_like(t5[6]), group_outros(), r2 = update_keyed_each(r2, e2, l, 1, t5, c, s2, i, outro_and_destroy_block, create_each_block_5, null, get_each_context_5), check_outros());
  }, i(t5) {
    if (!a) {
      transition_in(n.$$.fragment, t5);
      for (let t6 = 0; t6 < c.length; t6 += 1) transition_in(r2[t6]);
      a = true;
    }
  }, o(t5) {
    transition_out(n.$$.fragment, t5);
    for (let t6 = 0; t6 < r2.length; t6 += 1) transition_out(r2[t6]);
    a = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(n);
    for (let t6 = 0; t6 < r2.length; t6 += 1) r2[t6].d();
  } };
}
function create_default_slot_5(t4) {
  let e, n, o2;
  return e = new WeaponObject({ props: { item: t4[30] } }), { c() {
    create_component(e.$$.fragment), n = space();
  }, m(t5, i) {
    mount_component(e, t5, i), insert(t5, n, i), o2 = true;
  }, p(t5, n2) {
    const o3 = {};
    64 & n2[0] && (o3.item = t5[30]), e.$set(o3);
  }, i(t5) {
    o2 || (transition_in(e.$$.fragment, t5), o2 = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), o2 = false;
  }, d(t5) {
    t5 && detach(n), destroy_component(e, t5);
  } };
}
function create_each_block_5(t4, e) {
  let n, o2, i;
  return o2 = new Object$1({ props: { actor: e[0], item: e[30], $$slots: { default: [create_default_slot_5] }, $$scope: { ctx: e } } }), { key: t4, first: null, c() {
    n = empty(), create_component(o2.$$.fragment), this.first = n;
  }, m(t5, e2) {
    insert(t5, n, e2), mount_component(o2, t5, e2), i = true;
  }, p(t5, n2) {
    e = t5;
    const i2 = {};
    1 & n2[0] && (i2.actor = e[0]), 64 & n2[0] && (i2.item = e[30]), 64 & n2[0] | 4 & n2[1] && (i2.$$scope = { dirty: n2, ctx: e }), o2.$set(i2);
  }, i(t5) {
    i || (transition_in(o2.$$.fragment, t5), i = true);
  }, o(t5) {
    transition_out(o2.$$.fragment, t5), i = false;
  }, d(t5) {
    t5 && detach(n), destroy_component(o2, t5);
  } };
}
function create_if_block_4$3(t4) {
  let e, n, o2, i, a, r2 = [], s2 = /* @__PURE__ */ new Map();
  n = new SectionListHeader({ props: { title: i18n("TYPES.Item.equipmentPl") } });
  let c = ensure_array_like(t4[3]);
  const l = (t5) => t5[27].id;
  for (let e2 = 0; e2 < c.length; e2 += 1) {
    let n2 = get_each_context_4(t4, c, e2), o3 = l(n2);
    s2.set(o3, r2[e2] = create_each_block_4(o3, n2));
  }
  return { c() {
    e = element("section"), create_component(n.$$.fragment), o2 = space(), i = element("ol");
    for (let t5 = 0; t5 < r2.length; t5 += 1) r2[t5].c();
    attr(i, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-mfxl5s");
  }, m(t5, s3) {
    insert(t5, e, s3), mount_component(n, e, null), append(e, o2), append(e, i);
    for (let t6 = 0; t6 < r2.length; t6 += 1) r2[t6] && r2[t6].m(i, null);
    a = true;
  }, p(t5, e2) {
    9 & e2[0] && (c = ensure_array_like(t5[3]), group_outros(), r2 = update_keyed_each(r2, e2, l, 1, t5, c, s2, i, outro_and_destroy_block, create_each_block_4, null, get_each_context_4), check_outros());
  }, i(t5) {
    if (!a) {
      transition_in(n.$$.fragment, t5);
      for (let t6 = 0; t6 < c.length; t6 += 1) transition_in(r2[t6]);
      a = true;
    }
  }, o(t5) {
    transition_out(n.$$.fragment, t5);
    for (let t6 = 0; t6 < r2.length; t6 += 1) transition_out(r2[t6]);
    a = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(n);
    for (let t6 = 0; t6 < r2.length; t6 += 1) r2[t6].d();
  } };
}
function create_default_slot_4(t4) {
  let e, n, o2;
  return e = new EquipmentObject({ props: { item: t4[27], rollData: t4[0].getRollData(t4[27]) } }), { c() {
    create_component(e.$$.fragment), n = space();
  }, m(t5, i) {
    mount_component(e, t5, i), insert(t5, n, i), o2 = true;
  }, p(t5, n2) {
    const o3 = {};
    8 & n2[0] && (o3.item = t5[27]), 9 & n2[0] && (o3.rollData = t5[0].getRollData(t5[27])), e.$set(o3);
  }, i(t5) {
    o2 || (transition_in(e.$$.fragment, t5), o2 = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), o2 = false;
  }, d(t5) {
    t5 && detach(n), destroy_component(e, t5);
  } };
}
function create_each_block_4(t4, e) {
  let n, o2, i;
  return o2 = new Object$1({ props: { actor: e[0], item: e[27], $$slots: { default: [create_default_slot_4] }, $$scope: { ctx: e } } }), { key: t4, first: null, c() {
    n = empty(), create_component(o2.$$.fragment), this.first = n;
  }, m(t5, e2) {
    insert(t5, n, e2), mount_component(o2, t5, e2), i = true;
  }, p(t5, n2) {
    e = t5;
    const i2 = {};
    1 & n2[0] && (i2.actor = e[0]), 8 & n2[0] && (i2.item = e[27]), 9 & n2[0] | 4 & n2[1] && (i2.$$scope = { dirty: n2, ctx: e }), o2.$set(i2);
  }, i(t5) {
    i || (transition_in(o2.$$.fragment, t5), i = true);
  }, o(t5) {
    transition_out(o2.$$.fragment, t5), i = false;
  }, d(t5) {
    t5 && detach(n), destroy_component(o2, t5);
  } };
}
function create_if_block_3$5(t4) {
  let e, n, o2, i, a, r2 = [], s2 = /* @__PURE__ */ new Map();
  n = new SectionListHeader({ props: { title: i18n("TYPES.Item.consumablePl") } });
  let c = ensure_array_like(t4[2]);
  const l = (t5) => t5[24].id;
  for (let e2 = 0; e2 < c.length; e2 += 1) {
    let n2 = get_each_context_3$2(t4, c, e2), o3 = l(n2);
    s2.set(o3, r2[e2] = create_each_block_3$2(o3, n2));
  }
  return { c() {
    e = element("section"), create_component(n.$$.fragment), o2 = space(), i = element("ol");
    for (let t5 = 0; t5 < r2.length; t5 += 1) r2[t5].c();
    attr(i, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-mfxl5s");
  }, m(t5, s3) {
    insert(t5, e, s3), mount_component(n, e, null), append(e, o2), append(e, i);
    for (let t6 = 0; t6 < r2.length; t6 += 1) r2[t6] && r2[t6].m(i, null);
    a = true;
  }, p(t5, e2) {
    5 & e2[0] && (c = ensure_array_like(t5[2]), group_outros(), r2 = update_keyed_each(r2, e2, l, 1, t5, c, s2, i, outro_and_destroy_block, create_each_block_3$2, null, get_each_context_3$2), check_outros());
  }, i(t5) {
    if (!a) {
      transition_in(n.$$.fragment, t5);
      for (let t6 = 0; t6 < c.length; t6 += 1) transition_in(r2[t6]);
      a = true;
    }
  }, o(t5) {
    transition_out(n.$$.fragment, t5);
    for (let t6 = 0; t6 < r2.length; t6 += 1) transition_out(r2[t6]);
    a = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(n);
    for (let t6 = 0; t6 < r2.length; t6 += 1) r2[t6].d();
  } };
}
function create_default_slot_3(t4) {
  let e, n, o2;
  return e = new ConsumableObject({ props: { item: t4[24] } }), { c() {
    create_component(e.$$.fragment), n = space();
  }, m(t5, i) {
    mount_component(e, t5, i), insert(t5, n, i), o2 = true;
  }, p(t5, n2) {
    const o3 = {};
    4 & n2[0] && (o3.item = t5[24]), e.$set(o3);
  }, i(t5) {
    o2 || (transition_in(e.$$.fragment, t5), o2 = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), o2 = false;
  }, d(t5) {
    t5 && detach(n), destroy_component(e, t5);
  } };
}
function create_each_block_3$2(t4, e) {
  let n, o2, i;
  return o2 = new Object$1({ props: { actor: e[0], item: e[24], $$slots: { default: [create_default_slot_3] }, $$scope: { ctx: e } } }), { key: t4, first: null, c() {
    n = empty(), create_component(o2.$$.fragment), this.first = n;
  }, m(t5, e2) {
    insert(t5, n, e2), mount_component(o2, t5, e2), i = true;
  }, p(t5, n2) {
    e = t5;
    const i2 = {};
    1 & n2[0] && (i2.actor = e[0]), 4 & n2[0] && (i2.item = e[24]), 4 & n2[0] | 4 & n2[1] && (i2.$$scope = { dirty: n2, ctx: e }), o2.$set(i2);
  }, i(t5) {
    i || (transition_in(o2.$$.fragment, t5), i = true);
  }, o(t5) {
    transition_out(o2.$$.fragment, t5), i = false;
  }, d(t5) {
    t5 && detach(n), destroy_component(o2, t5);
  } };
}
function create_if_block_2$b(t4) {
  let e, n, o2, i, a, r2 = [], s2 = /* @__PURE__ */ new Map();
  n = new SectionListHeader({ props: { title: i18n("TYPES.Item.toolPl") } });
  let c = ensure_array_like(t4[5]);
  const l = (t5) => t5[21].id;
  for (let e2 = 0; e2 < c.length; e2 += 1) {
    let n2 = get_each_context_2$3(t4, c, e2), o3 = l(n2);
    s2.set(o3, r2[e2] = create_each_block_2$3(o3, n2));
  }
  return { c() {
    e = element("section"), create_component(n.$$.fragment), o2 = space(), i = element("ol");
    for (let t5 = 0; t5 < r2.length; t5 += 1) r2[t5].c();
    attr(i, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-mfxl5s");
  }, m(t5, s3) {
    insert(t5, e, s3), mount_component(n, e, null), append(e, o2), append(e, i);
    for (let t6 = 0; t6 < r2.length; t6 += 1) r2[t6] && r2[t6].m(i, null);
    a = true;
  }, p(t5, e2) {
    33 & e2[0] && (c = ensure_array_like(t5[5]), group_outros(), r2 = update_keyed_each(r2, e2, l, 1, t5, c, s2, i, outro_and_destroy_block, create_each_block_2$3, null, get_each_context_2$3), check_outros());
  }, i(t5) {
    if (!a) {
      transition_in(n.$$.fragment, t5);
      for (let t6 = 0; t6 < c.length; t6 += 1) transition_in(r2[t6]);
      a = true;
    }
  }, o(t5) {
    transition_out(n.$$.fragment, t5);
    for (let t6 = 0; t6 < r2.length; t6 += 1) transition_out(r2[t6]);
    a = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(n);
    for (let t6 = 0; t6 < r2.length; t6 += 1) r2[t6].d();
  } };
}
function create_default_slot_2(t4) {
  let e, n, o2;
  return e = new ToolObject({ props: { item: t4[21] } }), { c() {
    create_component(e.$$.fragment), n = space();
  }, m(t5, i) {
    mount_component(e, t5, i), insert(t5, n, i), o2 = true;
  }, p(t5, n2) {
    const o3 = {};
    32 & n2[0] && (o3.item = t5[21]), e.$set(o3);
  }, i(t5) {
    o2 || (transition_in(e.$$.fragment, t5), o2 = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), o2 = false;
  }, d(t5) {
    t5 && detach(n), destroy_component(e, t5);
  } };
}
function create_each_block_2$3(t4, e) {
  let n, o2, i;
  return o2 = new Object$1({ props: { actor: e[0], item: e[21], $$slots: { default: [create_default_slot_2] }, $$scope: { ctx: e } } }), { key: t4, first: null, c() {
    n = empty(), create_component(o2.$$.fragment), this.first = n;
  }, m(t5, e2) {
    insert(t5, n, e2), mount_component(o2, t5, e2), i = true;
  }, p(t5, n2) {
    e = t5;
    const i2 = {};
    1 & n2[0] && (i2.actor = e[0]), 32 & n2[0] && (i2.item = e[21]), 32 & n2[0] | 4 & n2[1] && (i2.$$scope = { dirty: n2, ctx: e }), o2.$set(i2);
  }, i(t5) {
    i || (transition_in(o2.$$.fragment, t5), i = true);
  }, o(t5) {
    transition_out(o2.$$.fragment, t5), i = false;
  }, d(t5) {
    t5 && detach(n), destroy_component(o2, t5);
  } };
}
function create_if_block_1$k(t4) {
  let e, n, o2, i, a, r2 = [], s2 = /* @__PURE__ */ new Map();
  n = new SectionListHeader({ props: { title: i18n("TYPES.Item.lootPl") } });
  let c = ensure_array_like(t4[4]);
  const l = (t5) => t5[18].id;
  for (let e2 = 0; e2 < c.length; e2 += 1) {
    let n2 = get_each_context_1$7(t4, c, e2), o3 = l(n2);
    s2.set(o3, r2[e2] = create_each_block_1$7(o3, n2));
  }
  return { c() {
    e = element("section"), create_component(n.$$.fragment), o2 = space(), i = element("ol");
    for (let t5 = 0; t5 < r2.length; t5 += 1) r2[t5].c();
    attr(i, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-mfxl5s");
  }, m(t5, s3) {
    insert(t5, e, s3), mount_component(n, e, null), append(e, o2), append(e, i);
    for (let t6 = 0; t6 < r2.length; t6 += 1) r2[t6] && r2[t6].m(i, null);
    a = true;
  }, p(t5, e2) {
    17 & e2[0] && (c = ensure_array_like(t5[4]), group_outros(), r2 = update_keyed_each(r2, e2, l, 1, t5, c, s2, i, outro_and_destroy_block, create_each_block_1$7, null, get_each_context_1$7), check_outros());
  }, i(t5) {
    if (!a) {
      transition_in(n.$$.fragment, t5);
      for (let t6 = 0; t6 < c.length; t6 += 1) transition_in(r2[t6]);
      a = true;
    }
  }, o(t5) {
    transition_out(n.$$.fragment, t5);
    for (let t6 = 0; t6 < r2.length; t6 += 1) transition_out(r2[t6]);
    a = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(n);
    for (let t6 = 0; t6 < r2.length; t6 += 1) r2[t6].d();
  } };
}
function create_default_slot_1(t4) {
  let e, n, o2;
  return e = new LootObject({ props: { item: t4[18] } }), { c() {
    create_component(e.$$.fragment), n = space();
  }, m(t5, i) {
    mount_component(e, t5, i), insert(t5, n, i), o2 = true;
  }, p(t5, n2) {
    const o3 = {};
    16 & n2[0] && (o3.item = t5[18]), e.$set(o3);
  }, i(t5) {
    o2 || (transition_in(e.$$.fragment, t5), o2 = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), o2 = false;
  }, d(t5) {
    t5 && detach(n), destroy_component(e, t5);
  } };
}
function create_each_block_1$7(t4, e) {
  let n, o2, i;
  return o2 = new Object$1({ props: { actor: e[0], item: e[18], $$slots: { default: [create_default_slot_1] }, $$scope: { ctx: e } } }), { key: t4, first: null, c() {
    n = empty(), create_component(o2.$$.fragment), this.first = n;
  }, m(t5, e2) {
    insert(t5, n, e2), mount_component(o2, t5, e2), i = true;
  }, p(t5, n2) {
    e = t5;
    const i2 = {};
    1 & n2[0] && (i2.actor = e[0]), 16 & n2[0] && (i2.item = e[18]), 16 & n2[0] | 4 & n2[1] && (i2.$$scope = { dirty: n2, ctx: e }), o2.$set(i2);
  }, i(t5) {
    i || (transition_in(o2.$$.fragment, t5), i = true);
  }, o(t5) {
    transition_out(o2.$$.fragment, t5), i = false;
  }, d(t5) {
    t5 && detach(n), destroy_component(o2, t5);
  } };
}
function create_if_block$w(t4) {
  let e, n, o2, i, a, r2 = [], s2 = /* @__PURE__ */ new Map();
  n = new SectionListHeader({ props: { title: i18n("TYPES.Item.containerPl") } });
  let c = ensure_array_like(t4[1]);
  const l = (t5) => t5[15].id;
  for (let e2 = 0; e2 < c.length; e2 += 1) {
    let n2 = get_each_context$h(t4, c, e2), o3 = l(n2);
    s2.set(o3, r2[e2] = create_each_block$h(o3, n2));
  }
  return { c() {
    e = element("section"), create_component(n.$$.fragment), o2 = space(), i = element("ol");
    for (let t5 = 0; t5 < r2.length; t5 += 1) r2[t5].c();
    attr(i, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-mfxl5s");
  }, m(t5, s3) {
    insert(t5, e, s3), mount_component(n, e, null), append(e, o2), append(e, i);
    for (let t6 = 0; t6 < r2.length; t6 += 1) r2[t6] && r2[t6].m(i, null);
    a = true;
  }, p(t5, e2) {
    3 & e2[0] && (c = ensure_array_like(t5[1]), group_outros(), r2 = update_keyed_each(r2, e2, l, 1, t5, c, s2, i, outro_and_destroy_block, create_each_block$h, null, get_each_context$h), check_outros());
  }, i(t5) {
    if (!a) {
      transition_in(n.$$.fragment, t5);
      for (let t6 = 0; t6 < c.length; t6 += 1) transition_in(r2[t6]);
      a = true;
    }
  }, o(t5) {
    transition_out(n.$$.fragment, t5);
    for (let t6 = 0; t6 < r2.length; t6 += 1) transition_out(r2[t6]);
    a = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(n);
    for (let t6 = 0; t6 < r2.length; t6 += 1) r2[t6].d();
  } };
}
function create_default_slot$3(t4) {
  let e, n, o2;
  return e = new ContainerObject({ props: { item: t4[15] } }), { c() {
    create_component(e.$$.fragment), n = space();
  }, m(t5, i) {
    mount_component(e, t5, i), insert(t5, n, i), o2 = true;
  }, p(t5, n2) {
    const o3 = {};
    2 & n2[0] && (o3.item = t5[15]), e.$set(o3);
  }, i(t5) {
    o2 || (transition_in(e.$$.fragment, t5), o2 = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), o2 = false;
  }, d(t5) {
    t5 && detach(n), destroy_component(e, t5);
  } };
}
function create_each_block$h(t4, e) {
  let n, o2, i;
  return o2 = new Object$1({ props: { actor: e[0], item: e[15], $$slots: { default: [create_default_slot$3] }, $$scope: { ctx: e } } }), { key: t4, first: null, c() {
    n = empty(), create_component(o2.$$.fragment), this.first = n;
  }, m(t5, e2) {
    insert(t5, n, e2), mount_component(o2, t5, e2), i = true;
  }, p(t5, n2) {
    e = t5;
    const i2 = {};
    1 & n2[0] && (i2.actor = e[0]), 2 & n2[0] && (i2.item = e[15]), 2 & n2[0] | 4 & n2[1] && (i2.$$scope = { dirty: n2, ctx: e }), o2.$set(i2);
  }, i(t5) {
    i || (transition_in(o2.$$.fragment, t5), i = true);
  }, o(t5) {
    transition_out(o2.$$.fragment, t5), i = false;
  }, d(t5) {
    t5 && detach(n), destroy_component(o2, t5);
  } };
}
function create_fragment$10(t4) {
  let e, n, o2, i, a, r2, s2, c, l;
  e = new ObjectFilterAndSearch({}), e.$on("search", t4[8]);
  let u = t4[6].length > 0 && create_if_block_5$1(t4), p2 = t4[3].length > 0 && create_if_block_4$3(t4), d = t4[2].length > 0 && create_if_block_3$5(t4), m = t4[5].length > 0 && create_if_block_2$b(t4), f = t4[4].length > 0 && create_if_block_1$k(t4), _ = t4[1].length > 0 && create_if_block$w(t4);
  return { c() {
    create_component(e.$$.fragment), n = space(), o2 = element("section"), u && u.c(), i = space(), p2 && p2.c(), a = space(), d && d.c(), r2 = space(), m && m.c(), s2 = space(), f && f.c(), c = space(), _ && _.c(), attr(o2, "class", "content-scroll-list");
  }, m(t5, h) {
    mount_component(e, t5, h), insert(t5, n, h), insert(t5, o2, h), u && u.m(o2, null), append(o2, i), p2 && p2.m(o2, null), append(o2, a), d && d.m(o2, null), append(o2, r2), m && m.m(o2, null), append(o2, s2), f && f.m(o2, null), append(o2, c), _ && _.m(o2, null), l = true;
  }, p(t5, e2) {
    t5[6].length > 0 ? u ? (u.p(t5, e2), 64 & e2[0] && transition_in(u, 1)) : (u = create_if_block_5$1(t5), u.c(), transition_in(u, 1), u.m(o2, i)) : u && (group_outros(), transition_out(u, 1, 1, () => {
      u = null;
    }), check_outros()), t5[3].length > 0 ? p2 ? (p2.p(t5, e2), 8 & e2[0] && transition_in(p2, 1)) : (p2 = create_if_block_4$3(t5), p2.c(), transition_in(p2, 1), p2.m(o2, a)) : p2 && (group_outros(), transition_out(p2, 1, 1, () => {
      p2 = null;
    }), check_outros()), t5[2].length > 0 ? d ? (d.p(t5, e2), 4 & e2[0] && transition_in(d, 1)) : (d = create_if_block_3$5(t5), d.c(), transition_in(d, 1), d.m(o2, r2)) : d && (group_outros(), transition_out(d, 1, 1, () => {
      d = null;
    }), check_outros()), t5[5].length > 0 ? m ? (m.p(t5, e2), 32 & e2[0] && transition_in(m, 1)) : (m = create_if_block_2$b(t5), m.c(), transition_in(m, 1), m.m(o2, s2)) : m && (group_outros(), transition_out(m, 1, 1, () => {
      m = null;
    }), check_outros()), t5[4].length > 0 ? f ? (f.p(t5, e2), 16 & e2[0] && transition_in(f, 1)) : (f = create_if_block_1$k(t5), f.c(), transition_in(f, 1), f.m(o2, c)) : f && (group_outros(), transition_out(f, 1, 1, () => {
      f = null;
    }), check_outros()), t5[1].length > 0 ? _ ? (_.p(t5, e2), 2 & e2[0] && transition_in(_, 1)) : (_ = create_if_block$w(t5), _.c(), transition_in(_, 1), _.m(o2, null)) : _ && (group_outros(), transition_out(_, 1, 1, () => {
      _ = null;
    }), check_outros());
  }, i(t5) {
    l || (transition_in(e.$$.fragment, t5), transition_in(u), transition_in(p2), transition_in(d), transition_in(m), transition_in(f), transition_in(_), l = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), transition_out(u), transition_out(p2), transition_out(d), transition_out(m), transition_out(f), transition_out(_), l = false;
  }, d(t5) {
    t5 && (detach(n), detach(o2)), destroy_component(e, t5), u && u.d(), p2 && p2.d(), d && d.d(), m && m.d(), f && f.d(), _ && _.d();
  } };
}
function instance$$(t4, e, n) {
  let o2, i, a, r2, s2, { actor: c } = e, { selectedContainer: l } = e;
  const u = getContext(CONTEXT.ACTIVE_OBJECT_FILTER);
  let p2, d, m, f, _, h;
  return component_subscribe(t4, u, (t5) => n(14, s2 = t5)), t4.$$set = (t5) => {
    "actor" in t5 && n(0, c = t5.actor), "selectedContainer" in t5 && n(9, l = t5.selectedContainer);
  }, t4.$$.update = () => {
    23552 & t4.$$.dirty[0] && n(13, i = (t5, e2) => e2 ? t5.filter((t6) => {
      const n2 = t6.system;
      return o2 && t6.name.toLowerCase().includes(o2) && r2(t6, s2) && n2.container === e2;
    }) : t5.filter((t6) => {
      const e3 = t6.system, n2 = t6.name.toLowerCase().includes(o2), i2 = a(e3);
      return n2 && r2(t6, s2) && !i2;
    })), 12801 & t4.$$.dirty[0] && (n(1, p2 = i(c.itemTypes.container, l).sort((t5, e2) => t5.name.localeCompare(e2.name))), n(2, d = i(c.itemTypes.consumable, l).sort((t5, e2) => t5.name.localeCompare(e2.name))), n(3, m = i(c.itemTypes.equipment, l).sort((t5, e2) => t5.name.localeCompare(e2.name))), n(4, f = i(c.itemTypes.loot, l).sort((t5, e2) => t5.name.localeCompare(e2.name))), n(5, _ = i(c.itemTypes.tool, l).sort((t5, e2) => t5.name.localeCompare(e2.name))), n(6, h = i(c.itemTypes.weapon, l).sort((t5, e2) => t5.name.localeCompare(e2.name))));
  }, n(12, o2 = ""), n(10, r2 = (t5, e2) => 0 === e2.length || e2.every((e3) => e3.filterFct(t5))), n(11, a = (t5) => null !== fromUuidSync(t5.container)), [c, p2, d, m, f, _, h, u, function(t5) {
    n(12, o2 = t5.detail);
  }, l, r2, a, o2, i, s2];
}
class Objects extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$$, create_fragment$10, safe_not_equal, { actor: 0, selectedContainer: 9 }, null, [-1, -1]);
  }
}
function get_each_context$g(t4, e, n) {
  const o2 = t4.slice();
  return o2[6] = e[n], o2;
}
function create_if_block$v(t4) {
  let e;
  return { c() {
    e = element("div"), e.innerHTML = "<p>Pro version</p>", attr(e, "class", "overlay svelte-mobile-companion-dnd5e-81nkluj30u9vsd-gxy0fw");
  }, m(t5, n) {
    insert(t5, e, n);
  }, d(t5) {
    t5 && detach(e);
  } };
}
function create_each_block$g(t4, e) {
  let n, o2, i, a, r2, s2, c, l, u = create_if_block$v();
  function p2() {
    return e[4](e[6]);
  }
  return { key: t4, first: null, c() {
    n = element("button"), o2 = element("img"), r2 = space(), u && u.c(), s2 = space(), src_url_equal(o2.src, i = e[6].img) || attr(o2, "src", i), attr(o2, "alt", a = e[6].name), attr(o2, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-gxy0fw"), attr(n, "class", "image-container svelte-mobile-companion-dnd5e-81nkluj30u9vsd-gxy0fw"), toggle_class(n, "active", e[0] === e[6].id), this.first = n;
  }, m(t5, e2) {
    insert(t5, n, e2), append(n, o2), append(n, r2), u && u.m(n, null), append(n, s2), c || (l = listen(n, "click", p2), c = true);
  }, p(t5, r3) {
    e = t5, 2 & r3 && !src_url_equal(o2.src, i = e[6].img) && attr(o2, "src", i), 2 & r3 && a !== (a = e[6].name) && attr(o2, "alt", a), 3 & r3 && toggle_class(n, "active", e[0] === e[6].id);
  }, d(t5) {
    t5 && detach(n), u && u.d(), c = false, l();
  } };
}
function create_fragment$$(t4) {
  let e, n = [], o2 = /* @__PURE__ */ new Map(), i = ensure_array_like(t4[1]);
  const a = (t5) => t5[6].id;
  for (let e2 = 0; e2 < i.length; e2 += 1) {
    let r2 = get_each_context$g(t4, i, e2), s2 = a(r2);
    o2.set(s2, n[e2] = create_each_block$g(s2, r2));
  }
  return { c() {
    e = element("section");
    for (let t5 = 0; t5 < n.length; t5 += 1) n[t5].c();
    attr(e, "class", "containers svelte-mobile-companion-dnd5e-81nkluj30u9vsd-gxy0fw");
  }, m(t5, o3) {
    insert(t5, e, o3);
    for (let t6 = 0; t6 < n.length; t6 += 1) n[t6] && n[t6].m(e, null);
  }, p(t5, [r2]) {
    7 & r2 && (i = ensure_array_like(t5[1]), n = update_keyed_each(n, r2, a, 1, t5, i, o2, e, destroy_block, create_each_block$g, null, get_each_context$g));
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e);
    for (let t6 = 0; t6 < n.length; t6 += 1) n[t6].d();
  } };
}
function instance$_(t4, e, n) {
  let o2, { actor: i } = e;
  function a(t5) {
  }
  createEventDispatcher();
  return t4.$$set = (t5) => {
    "actor" in t5 && n(3, i = t5.actor);
  }, t4.$$.update = () => {
    8 & t4.$$.dirty && n(1, o2 = i.itemTypes.container);
  }, [void 0, o2, a, i, (t5) => {
    t5.id;
  }];
}
class Container extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$_, create_fragment$$, safe_not_equal, { actor: 3 });
  }
}
function create_if_block$u(t4) {
  let e, n, o2, i, a, r2, s2, c, l, u, p2 = t4[0].value + "", d = t4[0].max + "";
  return { c() {
    e = element("div"), n = element("i"), o2 = space(), i = element("span"), a = text(p2), r2 = space(), s2 = element("span"), s2.textContent = "/", c = space(), l = element("span"), u = text(d), attr(n, "class", "fas fa-sun"), attr(n, "data-tooltip", "DND5E.Attunement"), attr(n, "aria-label", "Attunement"), attr(i, "class", "value"), attr(s2, "class", "separator"), attr(l, "class", "max"), attr(e, "class", "attunement svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1374oks"), attr(e, "aria-hidden", "true");
  }, m(t5, p3) {
    insert(t5, e, p3), append(e, n), append(e, o2), append(e, i), append(i, a), append(e, r2), append(e, s2), append(e, c), append(e, l), append(l, u);
  }, p(t5, e2) {
    1 & e2 && p2 !== (p2 = t5[0].value + "") && set_data(a, p2), 1 & e2 && d !== (d = t5[0].max + "") && set_data(u, d);
  }, d(t5) {
    t5 && detach(e);
  } };
}
function create_fragment$_(t4) {
  let e, n = t4[0]?.value && t4[0]?.max && create_if_block$u(t4);
  return { c() {
    n && n.c(), e = empty();
  }, m(t5, o2) {
    n && n.m(t5, o2), insert(t5, e, o2);
  }, p(t5, [o2]) {
    t5[0]?.value && t5[0]?.max ? n ? n.p(t5, o2) : (n = create_if_block$u(t5), n.c(), n.m(e.parentNode, e)) : n && (n.d(1), n = null);
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e), n && n.d(t5);
  } };
}
function instance$Z(t4, e, n) {
  let { attunement: o2 } = e;
  return t4.$$set = (t5) => {
    "attunement" in t5 && n(0, o2 = t5.attunement);
  }, [o2];
}
class Attunement extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$Z, create_fragment$_, safe_not_equal, { attunement: 0 });
  }
}
function create_if_block_2$a(t4) {
  let e, n;
  return e = new Container({ props: { actor: t4[0] } }), e.$on("onContainerChange", t4[9]), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    1 & n2 && (o2.actor = t5[0]), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_if_block_1$j(t4) {
  let e, n;
  return e = new Currency({ props: { actor: t4[0], selectedContainer: t4[1] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    1 & n2 && (o2.actor = t5[0]), 2 & n2 && (o2.selectedContainer = t5[1]), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_if_block$t(t4) {
  let e, n;
  return e = new Encumbrance({ props: { actor: t4[0], selectedContainer: t4[1] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    1 & n2 && (o2.actor = t5[0]), 2 & n2 && (o2.selectedContainer = t5[1]), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_fragment$Z(t4) {
  let e, n, o2, i, a, r2, s2, c, l, u = t4[3] && create_if_block_2$a(t4);
  i = new Attunement({ props: { attunement: t4[2] } });
  let p2 = t4[5] && create_if_block_1$j(t4), d = t4[4] && create_if_block$t(t4);
  return c = new Objects({ props: { actor: t4[0], selectedContainer: t4[1] } }), { c() {
    e = element("section"), n = element("div"), u && u.c(), o2 = space(), create_component(i.$$.fragment), a = space(), p2 && p2.c(), r2 = space(), d && d.c(), s2 = space(), create_component(c.$$.fragment), attr(n, "class", "container-attunement svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1x6qbia"), attr(e, "class", "category-content");
  }, m(t5, m) {
    insert(t5, e, m), append(e, n), u && u.m(n, null), append(n, o2), mount_component(i, n, null), append(e, a), p2 && p2.m(e, null), append(e, r2), d && d.m(e, null), append(e, s2), mount_component(c, e, null), l = true;
  }, p(t5, [a2]) {
    t5[3] ? u ? (u.p(t5, a2), 8 & a2 && transition_in(u, 1)) : (u = create_if_block_2$a(t5), u.c(), transition_in(u, 1), u.m(n, o2)) : u && (group_outros(), transition_out(u, 1, 1, () => {
      u = null;
    }), check_outros());
    const l2 = {};
    4 & a2 && (l2.attunement = t5[2]), i.$set(l2), t5[5] ? p2 ? (p2.p(t5, a2), 32 & a2 && transition_in(p2, 1)) : (p2 = create_if_block_1$j(t5), p2.c(), transition_in(p2, 1), p2.m(e, r2)) : p2 && (group_outros(), transition_out(p2, 1, 1, () => {
      p2 = null;
    }), check_outros()), t5[4] ? d ? (d.p(t5, a2), 16 & a2 && transition_in(d, 1)) : (d = create_if_block$t(t5), d.c(), transition_in(d, 1), d.m(e, s2)) : d && (group_outros(), transition_out(d, 1, 1, () => {
      d = null;
    }), check_outros());
    const m = {};
    1 & a2 && (m.actor = t5[0]), 2 & a2 && (m.selectedContainer = t5[1]), c.$set(m);
  }, i(t5) {
    l || (transition_in(u), transition_in(i.$$.fragment, t5), transition_in(p2), transition_in(d), transition_in(c.$$.fragment, t5), l = true);
  }, o(t5) {
    transition_out(u), transition_out(i.$$.fragment, t5), transition_out(p2), transition_out(d), transition_out(c.$$.fragment, t5), l = false;
  }, d(t5) {
    t5 && detach(e), u && u.d(), destroy_component(i), p2 && p2.d(), d && d.d(), destroy_component(c);
  } };
}
function instance$Y(t4, e, n) {
  let o2, i, a, r2, s2, c, l, { actor: u } = e;
  const p2 = mobileCompanionGameSettings.getWritableStore(USE_CURRENCY);
  component_subscribe(t4, p2, (t5) => n(12, l = t5));
  const d = mobileCompanionGameSettings.getWritableStore(USE_ENCUMBRANCE);
  component_subscribe(t4, d, (t5) => n(11, c = t5));
  const m = mobileCompanionGameSettings.getWritableStore(USE_CONTAINER);
  let f;
  return component_subscribe(t4, m, (t5) => n(10, s2 = t5)), t4.$$set = (t5) => {
    "actor" in t5 && n(0, u = t5.actor);
  }, t4.$$.update = () => {
    4096 & t4.$$.dirty && n(5, o2 = l), 2048 & t4.$$.dirty && n(4, i = c), 1024 & t4.$$.dirty && n(3, a = s2), 1 & t4.$$.dirty && n(2, r2 = u.system.attributes.attunement);
  }, [u, f, r2, a, i, o2, p2, d, m, function(t5) {
    n(1, f = t5.detail);
  }, s2, c, l];
}
class Inventory extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$Y, create_fragment$Z, safe_not_equal, { actor: 0 });
  }
}
function create_if_block$s(t4) {
  let e, n;
  return { c() {
    e = element("img"), attr(e, "class", "item-image svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1iw5xbu"), src_url_equal(e.src, n = t4[2]) || attr(e, "src", n), attr(e, "alt", t4[1]), attr(e, "draggable", "false");
  }, m(t5, n2) {
    insert(t5, e, n2);
  }, p: noop$3, d(t5) {
    t5 && detach(e);
  } };
}
function create_fragment$Y(t4) {
  let e, n, o2, i, a, r2, s2, c, l, u, p2, d, m, f, _, h = getAttributes(t4[0]).ac.value + "", g2 = getAttributes(t4[0]).hp.max + "", $2 = t4[2] && create_if_block$s(t4);
  return { c() {
    e = element("li"), n = element("div"), o2 = element("div"), $2 && $2.c(), i = space(), a = element("div"), a.textContent = `${t4[1]}`, r2 = space(), s2 = element("div"), c = text("AC: "), l = text(h), u = space(), p2 = element("span"), p2.textContent = "|", d = text("\r\n            HP: "), m = text(g2), attr(a, "class", "name svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1iw5xbu"), attr(o2, "class", "name-img svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1iw5xbu"), attr(p2, "class", "separator svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1iw5xbu"), attr(s2, "class", "right-content svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1iw5xbu"), attr(n, "class", "item svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1iw5xbu"), attr(e, "aria-hidden", "true"), attr(e, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1iw5xbu");
  }, m(h2, g3) {
    insert(h2, e, g3), append(e, n), append(n, o2), $2 && $2.m(o2, null), append(o2, i), append(o2, a), append(n, r2), append(n, s2), append(s2, c), append(s2, l), append(s2, u), append(s2, p2), append(s2, d), append(s2, m), f || (_ = listen(e, "click", t4[3]), f = true);
  }, p(t5, [e2]) {
    t5[2] && $2.p(t5, e2), 1 & e2 && h !== (h = getAttributes(t5[0]).ac.value + "") && set_data(l, h), 1 & e2 && g2 !== (g2 = getAttributes(t5[0]).hp.max + "") && set_data(m, g2);
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e), $2 && $2.d(), f = false, _();
  } };
}
function getAttributes(t4) {
  return t4.system.attributes;
}
function instance$X(t4, e, n) {
  let o2, i, { actor: a } = e;
  const r2 = a.name, s2 = a.img;
  return t4.$$set = (t5) => {
    "actor" in t5 && n(0, a = t5.actor);
  }, o2 = getContext(CONTEXT.ACTOR_STORE), i = getContext(CONTEXT.ACTIVE_FILTER_STORE), [a, r2, s2, function() {
    saveLastActorId(a.id), o2.set(a), i.set(Filters.Character);
  }];
}
class CharacterListEntry extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$X, create_fragment$Y, safe_not_equal, { actor: 0 });
  }
}
function get_each_context$f(t4, e, n) {
  const o2 = t4.slice();
  return o2[2] = e[n], o2;
}
function create_each_block$f(t4, e) {
  let n, o2, i;
  return o2 = new CharacterListEntry({ props: { actor: e[2] } }), { key: t4, first: null, c() {
    n = empty(), create_component(o2.$$.fragment), this.first = n;
  }, m(t5, e2) {
    insert(t5, n, e2), mount_component(o2, t5, e2), i = true;
  }, p(t5, n2) {
    e = t5;
    const i2 = {};
    1 & n2 && (i2.actor = e[2]), o2.$set(i2);
  }, i(t5) {
    i || (transition_in(o2.$$.fragment, t5), i = true);
  }, o(t5) {
    transition_out(o2.$$.fragment, t5), i = false;
  }, d(t5) {
    t5 && detach(n), destroy_component(o2, t5);
  } };
}
function create_fragment$X(t4) {
  let e, n, o2 = [], i = /* @__PURE__ */ new Map(), a = ensure_array_like(t4[0]);
  const r2 = (t5) => t5[2].id;
  for (let e2 = 0; e2 < a.length; e2 += 1) {
    let n2 = get_each_context$f(t4, a, e2), s2 = r2(n2);
    i.set(s2, o2[e2] = create_each_block$f(s2, n2));
  }
  return { c() {
    for (let t5 = 0; t5 < o2.length; t5 += 1) o2[t5].c();
    e = empty();
  }, m(t5, i2) {
    for (let e2 = 0; e2 < o2.length; e2 += 1) o2[e2] && o2[e2].m(t5, i2);
    insert(t5, e, i2), n = true;
  }, p(t5, [n2]) {
    1 & n2 && (a = ensure_array_like(t5[0]), group_outros(), o2 = update_keyed_each(o2, n2, r2, 1, t5, a, i, e.parentNode, outro_and_destroy_block, create_each_block$f, e, get_each_context$f), check_outros());
  }, i(t5) {
    if (!n) {
      for (let t6 = 0; t6 < a.length; t6 += 1) transition_in(o2[t6]);
      n = true;
    }
  }, o(t5) {
    for (let t6 = 0; t6 < o2.length; t6 += 1) transition_out(o2[t6]);
    n = false;
  }, d(t5) {
    t5 && detach(e);
    for (let e2 = 0; e2 < o2.length; e2 += 1) o2[e2].d(t5);
  } };
}
function getAllButMain(t4) {
  const e = game.user.character, n = t4.ownership[game.user.id] >= 2;
  if (e) {
    const e2 = game.user.character.id === t4.id;
    return n && !e2;
  }
  return n;
}
function instance$W(t4, e, n) {
  let o2, i;
  return t4.$$.update = () => {
    2 & t4.$$.dirty && n(0, i = o2.filter((t5) => getAllButMain(t5)).sort((t5, e2) => t5.name.localeCompare(e2.name)));
  }, n(1, o2 = game.actors.contents), [i, o2];
}
class CharacterList extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$W, create_fragment$X, safe_not_equal, {});
  }
}
function create_if_block_1$i(t4) {
  let e, n, o2, i, a;
  return n = new SectionListHeader({ props: { title: myi18n("MainCharacterHeader") } }), i = new CharacterListEntry({ props: { actor: t4[0] } }), { c() {
    e = element("section"), create_component(n.$$.fragment), o2 = space(), create_component(i.$$.fragment);
  }, m(t5, r2) {
    insert(t5, e, r2), mount_component(n, e, null), append(e, o2), mount_component(i, e, null), a = true;
  }, p: noop$3, i(t5) {
    a || (transition_in(n.$$.fragment, t5), transition_in(i.$$.fragment, t5), a = true);
  }, o(t5) {
    transition_out(n.$$.fragment, t5), transition_out(i.$$.fragment, t5), a = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(n), destroy_component(i);
  } };
}
function create_else_block$7(t4) {
  let e, n;
  return e = new Patreon({ props: { subject: "Multiple character" } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_if_block$r(t4) {
  let e, n;
  return e = new CharacterList({}), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_fragment$W(t4) {
  let e, n, o2, i, a, r2, s2, c = t4[0] && create_if_block_1$i(t4);
  o2 = new SectionListHeader({ props: { title: myi18n("CharacterSelectHeader") } });
  const l = [create_if_block$r, create_else_block$7], u = [];
  return a = 1, r2 = u[1] = l[1](t4), { c() {
    c && c.c(), e = space(), n = element("section"), create_component(o2.$$.fragment), i = space(), r2.c();
  }, m(t5, a2) {
    c && c.m(t5, a2), insert(t5, e, a2), insert(t5, n, a2), mount_component(o2, n, null), append(n, i), u[1].m(n, null), s2 = true;
  }, p(t5, [e2]) {
    t5[0] && c.p(t5, e2);
  }, i(t5) {
    s2 || (transition_in(c), transition_in(o2.$$.fragment, t5), transition_in(r2), s2 = true);
  }, o(t5) {
    transition_out(c), transition_out(o2.$$.fragment, t5), transition_out(r2), s2 = false;
  }, d(t5) {
    t5 && (detach(e), detach(n)), c && c.d(t5), destroy_component(o2), u[1].d();
  } };
}
function instance$V(t4) {
  return [game.user.character];
}
class CharacterSelect extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$V, create_fragment$W, safe_not_equal, {});
  }
}
function create_fragment$V(t4) {
  let e, n;
  return e = new Description({ props: { htmlText: t4[0], replaceOptions: t4[1] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, [n2]) {
    const o2 = {};
    1 & n2 && (o2.htmlText = t5[0]), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function instance$U(t4, e, n) {
  let { description: o2 } = e;
  return t4.$$set = (t5) => {
    "description" in t5 && n(0, o2 = t5.description);
  }, [o2, [{ find: /\[\[\/damage (.*?) type=(.*?)]]/g, replace: "$1 $2" }, { find: /\[\[\/damage (.*?)]]/g, replace: "$1" }, { find: /\[\[\/r (.*?)]]/g, replace: "$1" }, { find: /&amp;Reference\[condition=(.*?)]/g, replace: "<i>$1</i>" }]];
}
class SpellDescription extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$U, create_fragment$V, safe_not_equal, { description: 0 });
  }
}
function create_if_block$q(t4) {
  let e;
  return { c() {
    e = element("div"), e.innerHTML = '<dnd5e-icon src="systems/dnd5e/icons/svg/items/spell.svg"></dnd5e-icon>', attr(e, "class", "tag ritual svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1ue2ie");
  }, m(t5, n) {
    insert(t5, e, n);
  }, d(t5) {
    t5 && detach(e);
  } };
}
function create_fragment$U(t4) {
  let e, n = t4[0] && create_if_block$q();
  return { c() {
    n && n.c(), e = empty();
  }, m(t5, o2) {
    n && n.m(t5, o2), insert(t5, e, o2);
  }, p(t5, [o2]) {
    t5[0] ? n || (n = create_if_block$q(), n.c(), n.m(e.parentNode, e)) : n && (n.d(1), n = null);
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e), n && n.d(t5);
  } };
}
function instance$T(t4, e, n) {
  let o2, i, { spell: a } = e;
  return t4.$$set = (t5) => {
    "spell" in t5 && n(1, a = t5.spell);
  }, t4.$$.update = () => {
    2 & t4.$$.dirty && n(2, o2 = a.system), 4 & t4.$$.dirty && o2.properties.has("ritual"), 4 & t4.$$.dirty && n(0, i = o2.properties.has("ritual"));
  }, [i, a, o2];
}
class RitualTag extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$T, create_fragment$U, safe_not_equal, { spell: 1 });
  }
}
function create_if_block$p(t4) {
  let e, n, o2;
  return { c() {
    e = element("div"), e.innerHTML = '<dnd5e-icon src="systems/dnd5e/icons/svg/statuses/concentrating.svg"></dnd5e-icon>', attr(e, "class", "tag concentrating svelte-mobile-companion-dnd5e-81nkluj30u9vsd-oqu8m2"), attr(e, "aria-hidden", "true"), toggle_class(e, "active", t4[0]);
  }, m(i, a) {
    insert(i, e, a), n || (o2 = listen(e, "click", stop_propagation(prevent_default(t4[2]))), n = true);
  }, p(t5, n2) {
    1 & n2 && toggle_class(e, "active", t5[0]);
  }, d(t5) {
    t5 && detach(e), n = false, o2();
  } };
}
function create_fragment$T(t4) {
  let e, n = t4[1] && create_if_block$p(t4);
  return { c() {
    n && n.c(), e = empty();
  }, m(t5, o2) {
    n && n.m(t5, o2), insert(t5, e, o2);
  }, p(t5, [o2]) {
    t5[1] ? n ? n.p(t5, o2) : (n = create_if_block$p(t5), n.c(), n.m(e.parentNode, e)) : n && (n.d(1), n = null);
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e), n && n.d(t5);
  } };
}
function instance$S(t4, e, n) {
  let o2, i, a, { spell: r2 } = e, { actor: s2 } = e;
  return t4.$$set = (t5) => {
    "spell" in t5 && n(3, r2 = t5.spell), "actor" in t5 && n(4, s2 = t5.actor);
  }, t4.$$.update = () => {
    8 & t4.$$.dirty && n(5, o2 = r2.system), 32 & t4.$$.dirty && n(1, i = o2.properties.has("concentration")), 16 & t4.$$.dirty && n(0, a = s2.statuses.has("concentrating"));
  }, [a, i, function() {
    if (a) s2.endConcentration();
    else {
      const t5 = o2.activities.contents.find((t6) => t6.duration.concentration);
      t5 ? s2.beginConcentrating(t5) : s2.beginConcentrating(r2);
    }
  }, r2, s2, o2];
}
class ConcentrationTag extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$S, create_fragment$T, safe_not_equal, { spell: 3, actor: 4 });
  }
}
var PreparationState = ((t4) => (t4[t4.unprepared = 0] = "unprepared", t4[t4.prepared = 1] = "prepared", t4[t4.always = 2] = "always", t4))(PreparationState || {});
function getSpellPreparation(t4) {
  return foundry.utils.isNewerVersion(game.system.version, "5.1") ? { preparationState: t4.prepared, preparationMethod: t4.method } : { preparationState: getV12PreparationState(t4), preparationMethod: t4.preparation?.mode };
}
function getV12PreparationState(t4) {
  return "prepared" !== t4.preparation?.mode ? 2 : t4.preparation?.prepared ? 1 : 0;
}
function create_fragment$S(t4) {
  let e, n, o2, i, a;
  return { c() {
    e = element("div"), n = element("i"), attr(n, "class", o2 = t4[0] ? "fa-solid fa-certificate" : "fa-solid fa-sun"), attr(e, "class", "tag prepared svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1xh4vex"), attr(e, "aria-hidden", "true"), toggle_class(e, "active", t4[1]);
  }, m(o3, r2) {
    insert(o3, e, r2), append(e, n), i || (a = listen(e, "click", stop_propagation(prevent_default(t4[2]))), i = true);
  }, p(t5, [i2]) {
    1 & i2 && o2 !== (o2 = t5[0] ? "fa-solid fa-certificate" : "fa-solid fa-sun") && attr(n, "class", o2), 2 & i2 && toggle_class(e, "active", t5[1]);
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e), i = false, a();
  } };
}
function instance$R(t4, e, n) {
  let o2, i, a, r2, { spell: s2 } = e;
  return t4.$$set = (t5) => {
    "spell" in t5 && n(3, s2 = t5.spell);
  }, t4.$$.update = () => {
    8 & t4.$$.dirty && n(5, o2 = s2.system), 32 & t4.$$.dirty && n(4, i = getSpellPreparation(o2).preparationState), 16 & t4.$$.dirty && n(0, a = i === PreparationState.always), 17 & t4.$$.dirty && n(1, r2 = i === PreparationState.prepared || a);
  }, [a, r2, function() {
    if (a) return;
    const t5 = { system: { preparation: { prepared: !r2 } } };
    FoundryGateway.updateItem(s2, t5);
  }, s2, i, o2];
}
class PreparedTag extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$R, create_fragment$S, safe_not_equal, { spell: 3 });
  }
}
function create_fragment$R(t4) {
  let e, n, o2, i, a, r2, s2;
  return n = new RitualTag({ props: { spell: t4[1] } }), i = new ConcentrationTag({ props: { actor: t4[0], spell: t4[1] } }), r2 = new PreparedTag({ props: { spell: t4[1] } }), { c() {
    e = element("div"), create_component(n.$$.fragment), o2 = space(), create_component(i.$$.fragment), a = space(), create_component(r2.$$.fragment), attr(e, "class", "tags svelte-mobile-companion-dnd5e-81nkluj30u9vsd-iyzwc8");
  }, m(t5, c) {
    insert(t5, e, c), mount_component(n, e, null), append(e, o2), mount_component(i, e, null), append(e, a), mount_component(r2, e, null), s2 = true;
  }, p(t5, [e2]) {
    const o3 = {};
    2 & e2 && (o3.spell = t5[1]), n.$set(o3);
    const a2 = {};
    1 & e2 && (a2.actor = t5[0]), 2 & e2 && (a2.spell = t5[1]), i.$set(a2);
    const s3 = {};
    2 & e2 && (s3.spell = t5[1]), r2.$set(s3);
  }, i(t5) {
    s2 || (transition_in(n.$$.fragment, t5), transition_in(i.$$.fragment, t5), transition_in(r2.$$.fragment, t5), s2 = true);
  }, o(t5) {
    transition_out(n.$$.fragment, t5), transition_out(i.$$.fragment, t5), transition_out(r2.$$.fragment, t5), s2 = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(n), destroy_component(i), destroy_component(r2);
  } };
}
function instance$Q(t4, e, n) {
  let { actor: o2 } = e, { spell: i } = e;
  return t4.$$set = (t5) => {
    "actor" in t5 && n(0, o2 = t5.actor), "spell" in t5 && n(1, i = t5.spell);
  }, [o2, i];
}
class SpellTags extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$Q, create_fragment$R, safe_not_equal, { actor: 0, spell: 1 });
  }
}
function get_each_context$e(t4, e, n) {
  const o2 = t4.slice();
  return o2[11] = e[n], o2;
}
function create_if_block_4$2(t4) {
  let e;
  return { c() {
    e = element("span"), e.textContent = `${t4[1]}`, attr(e, "class", "text");
  }, m(t5, n) {
    insert(t5, e, n);
  }, p: noop$3, d(t5) {
    t5 && detach(e);
  } };
}
function create_if_block_3$4(t4) {
  let e, n, o2;
  return { c() {
    e = element("span"), e.textContent = "|", n = space(), o2 = element("span"), o2.textContent = `${t4[2].ability} ${t4[2].dc.value}`, attr(e, "class", "separator"), attr(o2, "class", "text save");
  }, m(t5, i) {
    insert(t5, e, i), insert(t5, n, i), insert(t5, o2, i);
  }, p: noop$3, d(t5) {
    t5 && (detach(e), detach(n), detach(o2));
  } };
}
function create_if_block_2$9(t4) {
  let e, n, o2;
  return { c() {
    e = element("span"), e.textContent = "|", n = space(), o2 = element("div"), o2.textContent = `${t4[3]}`, attr(e, "class", "separator"), attr(o2, "class", "text");
  }, m(t5, i) {
    insert(t5, e, i), insert(t5, n, i), insert(t5, o2, i);
  }, p: noop$3, d(t5) {
    t5 && (detach(e), detach(n), detach(o2));
  } };
}
function create_if_block$o(t4) {
  let e, n = ensure_array_like(t4[0]), o2 = [];
  for (let e2 = 0; e2 < n.length; e2 += 1) o2[e2] = create_each_block$e(get_each_context$e(t4, n, e2));
  return { c() {
    for (let t5 = 0; t5 < o2.length; t5 += 1) o2[t5].c();
    e = empty();
  }, m(t5, n2) {
    for (let e2 = 0; e2 < o2.length; e2 += 1) o2[e2] && o2[e2].m(t5, n2);
    insert(t5, e, n2);
  }, p(t5, i) {
    if (1 & i) {
      let a;
      for (n = ensure_array_like(t5[0]), a = 0; a < n.length; a += 1) {
        const r2 = get_each_context$e(t5, n, a);
        o2[a] ? o2[a].p(r2, i) : (o2[a] = create_each_block$e(r2), o2[a].c(), o2[a].m(e.parentNode, e));
      }
      for (; a < o2.length; a += 1) o2[a].d(1);
      o2.length = n.length;
    }
  }, d(t5) {
    t5 && detach(e), destroy_each(o2, t5);
  } };
}
function create_if_block_1$h(t4) {
  let e, n, o2;
  return { c() {
    e = element("img"), src_url_equal(e.src, n = t4[11].damageType) || attr(e, "src", n), attr(e, "alt", o2 = t4[11]?.damageType);
  }, m(t5, n2) {
    insert(t5, e, n2);
  }, p(t5, i) {
    1 & i && !src_url_equal(e.src, n = t5[11].damageType) && attr(e, "src", n), 1 & i && o2 !== (o2 = t5[11]?.damageType) && attr(e, "alt", o2);
  }, d(t5) {
    t5 && detach(e);
  } };
}
function create_each_block$e(t4) {
  let e, n, o2, i, a, r2, s2 = t4[11].avgDamage + "", c = t4[11].damageType && create_if_block_1$h(t4);
  return { c() {
    e = element("span"), e.textContent = "|", n = space(), o2 = element("span"), i = text(s2), a = space(), c && c.c(), r2 = space(), attr(e, "class", "separator"), attr(o2, "class", "text damage");
  }, m(t5, s3) {
    insert(t5, e, s3), insert(t5, n, s3), insert(t5, o2, s3), append(o2, i), append(o2, a), c && c.m(o2, null), append(o2, r2);
  }, p(t5, e2) {
    1 & e2 && s2 !== (s2 = t5[11].avgDamage + "") && set_data(i, s2), t5[11].damageType ? c ? c.p(t5, e2) : (c = create_if_block_1$h(t5), c.c(), c.m(o2, r2)) : c && (c.d(1), c = null);
  }, d(t5) {
    t5 && (detach(e), detach(n), detach(o2)), c && c.d();
  } };
}
function create_fragment$Q(t4) {
  let e, n, o2, i, a = t4[1] && create_if_block_4$2(t4), r2 = t4[2].ability && create_if_block_3$4(t4), s2 = t4[3] && create_if_block_2$9(t4), c = t4[0] && create_if_block$o(t4);
  return { c() {
    e = element("div"), a && a.c(), n = space(), r2 && r2.c(), o2 = space(), s2 && s2.c(), i = space(), c && c.c(), attr(e, "class", "global-quickInfo");
  }, m(t5, l) {
    insert(t5, e, l), a && a.m(e, null), append(e, n), r2 && r2.m(e, null), append(e, o2), s2 && s2.m(e, null), append(e, i), c && c.m(e, null);
  }, p(t5, [n2]) {
    t5[1] && a.p(t5, n2), t5[2].ability && r2.p(t5, n2), t5[3] && s2.p(t5, n2), t5[0] ? c ? c.p(t5, n2) : (c = create_if_block$o(t5), c.c(), c.m(e, null)) : c && (c.d(1), c = null);
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e), a && a.d(), r2 && r2.d(), s2 && s2.d(), c && c.d();
  } };
}
function instance$P(t4, e, n) {
  let o2, i, { spell: a } = e;
  const r2 = a.system;
  let s2 = a.labels.activation;
  const c = function() {
    var t5, e2, n2, o3;
    const i2 = Object.assign({}, null === (e2 = null === (t5 = r2.activities) || void 0 === t5 ? void 0 : t5.getByType("save")[0]) || void 0 === e2 ? void 0 : e2.save);
    return i2.ability = (null === (n2 = i2.ability) || void 0 === n2 ? void 0 : n2.size) ? 1 === i2.ability.size ? null === (o3 = CONFIG.DND5E.abilities[i2.ability.first()]) || void 0 === o3 ? void 0 : o3.abbreviation : i18n("DND5E.AbbreviationDC") : null, i2;
  }();
  const l = function() {
    const t5 = a.labels.toHit;
    if (t5) return t5 + " to hit";
    return null;
  }();
  const u = mobileCompanionGameSettings.getWritableStore(SHOW_AVERAGE_DAMAGE);
  return component_subscribe(t4, u, (t5) => n(6, i = t5)), t4.$$set = (t5) => {
    "spell" in t5 && n(5, a = t5.spell);
  }, t4.$$.update = () => {
    64 & t4.$$.dirty && n(0, o2 = function(t5) {
      function e2(t6) {
        const e3 = CONFIG.DND5E.damageTypes[t6.damageType];
        if (e3) return e3.icon;
        const n2 = CONFIG.DND5E.healingTypes[t6.damageType];
        return n2 ? n2.icon : void 0;
      }
      return a.labels.damages.map((n2) => ({ damageType: e2(n2), avgDamage: getDamageString(n2, t5) }));
    }(i));
  }, [o2, s2, c, l, u, a, i];
}
class SpellQuickInfo extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$P, create_fragment$Q, safe_not_equal, { spell: 5 });
  }
}
function create_if_block_1$g(t4) {
  let e;
  return { c() {
    e = element("li"), e.textContent = "Ritual", attr(e, "class", "property svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1d4m683");
  }, m(t5, n) {
    insert(t5, e, n);
  }, d(t5) {
    t5 && detach(e);
  } };
}
function create_if_block$n(t4) {
  let e;
  return { c() {
    e = element("li"), e.textContent = "Concentration", attr(e, "class", "property svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1d4m683");
  }, m(t5, n) {
    insert(t5, e, n);
  }, d(t5) {
    t5 && detach(e);
  } };
}
function create_fragment$P(t4) {
  let e, n, o2 = t4[0] && create_if_block_1$g(), i = t4[1] && create_if_block$n();
  return { c() {
    e = element("ul"), o2 && o2.c(), n = space(), i && i.c(), attr(e, "class", "properties svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1d4m683");
  }, m(t5, a) {
    insert(t5, e, a), o2 && o2.m(e, null), append(e, n), i && i.m(e, null);
  }, p(t5, [a]) {
    t5[0] ? o2 || (o2 = create_if_block_1$g(), o2.c(), o2.m(e, n)) : o2 && (o2.d(1), o2 = null), t5[1] ? i || (i = create_if_block$n(), i.c(), i.m(e, null)) : i && (i.d(1), i = null);
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e), o2 && o2.d(), i && i.d();
  } };
}
function instance$O(t4, e, n) {
  let { isRitual: o2 = false } = e, { isConcentration: i = false } = e;
  return t4.$$set = (t5) => {
    "isRitual" in t5 && n(0, o2 = t5.isRitual), "isConcentration" in t5 && n(1, i = t5.isConcentration);
  }, [o2, i];
}
class SpellBadges extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$O, create_fragment$P, safe_not_equal, { isRitual: 0, isConcentration: 1 });
  }
}
function get_each_context$d(t4, e, n) {
  const o2 = t4.slice();
  return o2[1] = e[n], o2[3] = n, o2;
}
function create_if_block_1$f(t4) {
  let e, n, o2, i, a = t4[0].labels.materials + "";
  return { c() {
    e = element("p"), n = element("b"), n.textContent = `${i18n("DND5E.Materials")}:`, o2 = space(), i = text(a);
  }, m(t5, a2) {
    insert(t5, e, a2), append(e, n), append(e, o2), append(e, i);
  }, p(t5, e2) {
    1 & e2 && a !== (a = t5[0].labels.materials + "") && set_data(i, a);
  }, d(t5) {
    t5 && detach(e);
  } };
}
function create_if_block$m(t4) {
  let e, n = [], o2 = /* @__PURE__ */ new Map(), i = ensure_array_like(t4[0].labels.derivedDamage);
  const a = (t5) => t5[3];
  for (let e2 = 0; e2 < i.length; e2 += 1) {
    let r2 = get_each_context$d(t4, i, e2), s2 = a(r2);
    o2.set(s2, n[e2] = create_each_block$d(s2, r2));
  }
  return { c() {
    for (let t5 = 0; t5 < n.length; t5 += 1) n[t5].c();
    e = empty();
  }, m(t5, o3) {
    for (let e2 = 0; e2 < n.length; e2 += 1) n[e2] && n[e2].m(t5, o3);
    insert(t5, e, o3);
  }, p(t5, r2) {
    1 & r2 && (i = ensure_array_like(t5[0].labels.derivedDamage), n = update_keyed_each(n, r2, a, 1, t5, i, o2, e.parentNode, destroy_block, create_each_block$d, e, get_each_context$d));
  }, d(t5) {
    t5 && detach(e);
    for (let e2 = 0; e2 < n.length; e2 += 1) n[e2].d(t5);
  } };
}
function create_each_block$d(t4, e) {
  let n, o2, i, a, r2 = e[1].label + "";
  return { key: t4, first: null, c() {
    n = element("p"), o2 = element("b"), o2.textContent = `${i18n("DND5E.Damage")}:`, i = space(), a = text(r2), this.first = n;
  }, m(t5, e2) {
    insert(t5, n, e2), append(n, o2), append(n, i), append(n, a);
  }, p(t5, n2) {
    e = t5, 1 & n2 && r2 !== (r2 = e[1].label + "") && set_data(a, r2);
  }, d(t5) {
    t5 && detach(n);
  } };
}
function create_fragment$O(t4) {
  let e, n, o2, i, a, r2, s2, c, l, u, p2, d, m, f, _, h, g2, $2, b, y, v, k, w2, S2, T, x2, E, O, A2, C, D, M, j = t4[0].labels.activation + "", I = t4[0].labels.range + "", N = t4[0].labels.target + "", P2 = t4[0].labels.components.vsm + "", F = t4[0].labels.duration + "", R = t4[0].labels.school + "", L2 = t4[0].labels.materials && create_if_block_1$f(t4), H = t4[0].labels.derivedDamage && create_if_block$m(t4);
  return { c() {
    e = element("div"), n = element("p"), o2 = element("b"), o2.textContent = `${i18n("DND5E.SpellCastTime")}:`, i = space(), a = text(j), r2 = space(), s2 = element("p"), c = element("b"), c.textContent = `${i18n("DND5E.Range")}:`, l = space(), u = text(I), p2 = space(), d = element("p"), m = element("b"), m.textContent = `${i18n("DND5E.Target")}:`, f = space(), _ = text(N), h = space(), g2 = element("p"), $2 = element("b"), $2.textContent = `${i18n("DND5E.Components")}:`, b = space(), y = text(P2), v = space(), L2 && L2.c(), k = space(), w2 = element("p"), S2 = element("b"), S2.textContent = `${i18n("DND5E.Duration")}:`, T = space(), x2 = text(F), E = space(), H && H.c(), O = space(), A2 = element("p"), C = element("b"), C.textContent = `${i18n("DND5E.School")}:`, D = space(), M = text(R);
  }, m(t5, j2) {
    insert(t5, e, j2), append(e, n), append(n, o2), append(n, i), append(n, a), append(e, r2), append(e, s2), append(s2, c), append(s2, l), append(s2, u), append(e, p2), append(e, d), append(d, m), append(d, f), append(d, _), append(e, h), append(e, g2), append(g2, $2), append(g2, b), append(g2, y), append(e, v), L2 && L2.m(e, null), append(e, k), append(e, w2), append(w2, S2), append(w2, T), append(w2, x2), append(e, E), H && H.m(e, null), append(e, O), append(e, A2), append(A2, C), append(A2, D), append(A2, M);
  }, p(t5, [n2]) {
    1 & n2 && j !== (j = t5[0].labels.activation + "") && set_data(a, j), 1 & n2 && I !== (I = t5[0].labels.range + "") && set_data(u, I), 1 & n2 && N !== (N = t5[0].labels.target + "") && set_data(_, N), 1 & n2 && P2 !== (P2 = t5[0].labels.components.vsm + "") && set_data(y, P2), t5[0].labels.materials ? L2 ? L2.p(t5, n2) : (L2 = create_if_block_1$f(t5), L2.c(), L2.m(e, k)) : L2 && (L2.d(1), L2 = null), 1 & n2 && F !== (F = t5[0].labels.duration + "") && set_data(x2, F), t5[0].labels.derivedDamage ? H ? H.p(t5, n2) : (H = create_if_block$m(t5), H.c(), H.m(e, O)) : H && (H.d(1), H = null), 1 & n2 && R !== (R = t5[0].labels.school + "") && set_data(M, R);
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e), L2 && L2.d(), H && H.d();
  } };
}
function instance$N(t4, e, n) {
  let { spell: o2 } = e;
  return t4.$$set = (t5) => {
    "spell" in t5 && n(0, o2 = t5.spell);
  }, [o2];
}
class SpellProperties extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$N, create_fragment$O, safe_not_equal, { spell: 0 });
  }
}
function applyEffectToActor(t4, e) {
  const n = e.effects.find((e2) => e2.origin === t4.uuid);
  if (n) {
    const e2 = { ...t4.constructor.getInitialDuration(), disabled: false };
    n.update(e2);
  } else {
    const n2 = { ...t4.toObject(), disabled: false, transfer: false, origin: t4.uuid };
    ActiveEffect.implementation.create(n2, { parent: e });
  }
}
function create_fragment$N(t4) {
  let e, n, o2, i;
  return { c() {
    e = element("span"), n = element("i"), attr(n, "class", o2 = null_to_empty(t4[0]) + " svelte-mobile-companion-dnd5e-81nkluj30u9vsd-j2jqgm"), attr(e, "class", "dice-burst svelte-mobile-companion-dnd5e-81nkluj30u9vsd-j2jqgm"), attr(e, "aria-hidden", "true"), attr(e, "style", i = "position: " + t4[6] + "; z-index: " + t4[9] + "; " + (null !== t4[7] ? `left:${t4[7]}px; transform: translate(-50%, -50%);` : "left:50%; transform: translate(-50%, -50%);") + " " + (null !== t4[8] ? `top:${t4[8]}px;` : "top:50%;") + " --duration: " + t4[1] + "ms; --start-scale: " + t4[2] + "; --end-scale: " + t4[3] + "; --start-rot: " + t4[4] + "deg; --end-rot: " + t4[5] + "deg;"), toggle_class(e, "active", t4[10]);
  }, m(t5, o3) {
    insert(t5, e, o3), append(e, n);
  }, p(t5, [a]) {
    1 & a && o2 !== (o2 = null_to_empty(t5[0]) + " svelte-mobile-companion-dnd5e-81nkluj30u9vsd-j2jqgm") && attr(n, "class", o2), 1022 & a && i !== (i = "position: " + t5[6] + "; z-index: " + t5[9] + "; " + (null !== t5[7] ? `left:${t5[7]}px; transform: translate(-50%, -50%);` : "left:50%; transform: translate(-50%, -50%);") + " " + (null !== t5[8] ? `top:${t5[8]}px;` : "top:50%;") + " --duration: " + t5[1] + "ms; --start-scale: " + t5[2] + "; --end-scale: " + t5[3] + "; --start-rot: " + t5[4] + "deg; --end-rot: " + t5[5] + "deg;") && attr(e, "style", i), 1024 & a && toggle_class(e, "active", t5[10]);
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e);
  } };
}
function instance$M(t4, e, n) {
  let { iconClass: o2 = "fa-solid fa-dice-d20 fa-2xl" } = e, { duration: i = 1e3 } = e, { startScale: a = 1 } = e, { endScale: r2 = 20 } = e, { startRotation: s2 = 0 } = e, { endRotation: c = 180 } = e, { position: l = "fixed" } = e, { x: u = null } = e, { y: p2 = null } = e, { zIndex: d = 1e3 } = e, m = false;
  const f = createEventDispatcher();
  return t4.$$set = (t5) => {
    "iconClass" in t5 && n(0, o2 = t5.iconClass), "duration" in t5 && n(1, i = t5.duration), "startScale" in t5 && n(2, a = t5.startScale), "endScale" in t5 && n(3, r2 = t5.endScale), "startRotation" in t5 && n(4, s2 = t5.startRotation), "endRotation" in t5 && n(5, c = t5.endRotation), "position" in t5 && n(6, l = t5.position), "x" in t5 && n(7, u = t5.x), "y" in t5 && n(8, p2 = t5.y), "zIndex" in t5 && n(9, d = t5.zIndex);
  }, [o2, i, a, r2, s2, c, l, u, p2, d, m, function() {
    if (m) return;
    n(10, m = true), f("start");
    const t5 = setTimeout(() => {
      n(10, m = false), f("end"), clearTimeout(t5);
    }, i);
  }];
}
class DiceBurst extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$M, create_fragment$N, safe_not_equal, { iconClass: 0, duration: 1, startScale: 2, endScale: 3, startRotation: 4, endRotation: 5, position: 6, x: 7, y: 8, zIndex: 9, trigger: 11 });
  }
  get trigger() {
    return this.$$.ctx[11];
  }
}
function get_each_context$c(t4, e, n) {
  const o2 = t4.slice();
  return o2[8] = e[n], o2;
}
function create_each_block$c(t4, e) {
  let n, o2, i, a, r2, s2, c, l, u = e[8].name + "";
  function p2() {
    return e[6](e[8]);
  }
  return { key: t4, first: null, c() {
    n = element("div"), o2 = element("button"), i = text("Apply "), a = text(u), s2 = space(), o2.disabled = r2 = e[4](e[8]), attr(o2, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-bljcxs"), attr(n, "class", "button-wrapper svelte-mobile-companion-dnd5e-81nkluj30u9vsd-bljcxs"), this.first = n;
  }, m(t5, e2) {
    insert(t5, n, e2), append(n, o2), append(o2, i), append(o2, a), append(n, s2), c || (l = listen(o2, "click", prevent_default(p2)), c = true);
  }, p(t5, n2) {
    e = t5, 1 & n2 && u !== (u = e[8].name + "") && set_data(a, u), 1 & n2 && r2 !== (r2 = e[4](e[8])) && (o2.disabled = r2);
  }, d(t5) {
    t5 && detach(n), c = false, l();
  } };
}
function create_fragment$M(t4) {
  let e, n, o2, i, a = [], r2 = /* @__PURE__ */ new Map();
  e = new DiceBurst({ props: { duration: 1e3 } }), t4[5](e);
  let s2 = ensure_array_like(t4[0]);
  const c = (t5) => t5[8].id;
  for (let e2 = 0; e2 < s2.length; e2 += 1) {
    let n2 = get_each_context$c(t4, s2, e2), o3 = c(n2);
    r2.set(o3, a[e2] = create_each_block$c(o3, n2));
  }
  return { c() {
    create_component(e.$$.fragment), n = space();
    for (let t5 = 0; t5 < a.length; t5 += 1) a[t5].c();
    o2 = empty();
  }, m(t5, r3) {
    mount_component(e, t5, r3), insert(t5, n, r3);
    for (let e2 = 0; e2 < a.length; e2 += 1) a[e2] && a[e2].m(t5, r3);
    insert(t5, o2, r3), i = true;
  }, p(t5, [n2]) {
    e.$set({}), 25 & n2 && (s2 = ensure_array_like(t5[0]), a = update_keyed_each(a, n2, c, 1, t5, s2, r2, o2.parentNode, destroy_block, create_each_block$c, o2, get_each_context$c));
  }, i(t5) {
    i || (transition_in(e.$$.fragment, t5), i = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), i = false;
  }, d(i2) {
    i2 && (detach(n), detach(o2)), t4[5](null), destroy_component(e, i2);
    for (let t5 = 0; t5 < a.length; t5 += 1) a[t5].d(i2);
  } };
}
function instance$L(t4, e, n) {
  let o2, { effects: i } = e;
  const a = getContext(CONTEXT.ACTOR_STORE);
  let r2;
  function s2(t5) {
    applyEffectToActor(t5, o2), r2.trigger();
  }
  component_subscribe(t4, a, (t5) => n(7, o2 = t5));
  return t4.$$set = (t5) => {
    "effects" in t5 && n(0, i = t5.effects);
  }, [i, r2, a, s2, function(t5) {
    return o2.effects.contents.some((e2) => e2.origin === t5.uuid);
  }, function(t5) {
    binding_callbacks[t5 ? "unshift" : "push"](() => {
      r2 = t5, n(1, r2);
    });
  }, (t5) => s2(t5)];
}
class Effects extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$L, create_fragment$M, safe_not_equal, { effects: 0 });
  }
}
function create_if_block_2$8(t4) {
  let e, n;
  return e = new SpellQuickInfo({ props: { spell: t4[1] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    2 & n2 && (o2.spell = t5[1]), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_below_name_content_slot$3(t4) {
  let e, n, o2 = t4[2] && t4[4] && create_if_block_2$8(t4);
  return { c() {
    e = element("div"), o2 && o2.c(), attr(e, "class", "quickinfo svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1pu0qga"), attr(e, "slot", "below-name-content");
  }, m(t5, i) {
    insert(t5, e, i), o2 && o2.m(e, null), n = true;
  }, p(t5, n2) {
    t5[2] && t5[4] ? o2 ? (o2.p(t5, n2), 20 & n2 && transition_in(o2, 1)) : (o2 = create_if_block_2$8(t5), o2.c(), transition_in(o2, 1), o2.m(e, null)) : o2 && (group_outros(), transition_out(o2, 1, 1, () => {
      o2 = null;
    }), check_outros());
  }, i(t5) {
    n || (transition_in(o2), n = true);
  }, o(t5) {
    transition_out(o2), n = false;
  }, d(t5) {
    t5 && detach(e), o2 && o2.d();
  } };
}
function create_if_block_1$e(t4) {
  let e, n;
  return e = new SpellTags({ props: { actor: t4[0], spell: t4[1] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    1 & n2 && (o2.actor = t5[0]), 2 & n2 && (o2.spell = t5[1]), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_right_content_slot$3(t4) {
  let e, n, o2 = t4[2] && create_if_block_1$e(t4);
  return { c() {
    e = element("div"), o2 && o2.c(), attr(e, "class", "spellTags svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1pu0qga"), attr(e, "slot", "right-content");
  }, m(t5, i) {
    insert(t5, e, i), o2 && o2.m(e, null), n = true;
  }, p(t5, n2) {
    t5[2] ? o2 ? (o2.p(t5, n2), 4 & n2 && transition_in(o2, 1)) : (o2 = create_if_block_1$e(t5), o2.c(), transition_in(o2, 1), o2.m(e, null)) : o2 && (group_outros(), transition_out(o2, 1, 1, () => {
      o2 = null;
    }), check_outros());
  }, i(t5) {
    n || (transition_in(o2), n = true);
  }, o(t5) {
    transition_out(o2), n = false;
  }, d(t5) {
    t5 && detach(e), o2 && o2.d();
  } };
}
function create_if_block$l(t4) {
  let e, n, o2, i, a, r2, s2, c, l, u;
  return e = new SpellBadges({ props: { isConcentration: t4[6], isRitual: t4[7] } }), o2 = new Effects({ props: { effects: t4[5] } }), a = new ToggleFavorite({ props: { actor: t4[0], item: t4[1] } }), s2 = new Activities({ props: { activities: t4[3].activities.contents } }), l = new SpellProperties({ props: { spell: t4[1] } }), { c() {
    create_component(e.$$.fragment), n = space(), create_component(o2.$$.fragment), i = space(), create_component(a.$$.fragment), r2 = space(), create_component(s2.$$.fragment), c = space(), create_component(l.$$.fragment);
  }, m(t5, p2) {
    mount_component(e, t5, p2), insert(t5, n, p2), mount_component(o2, t5, p2), insert(t5, i, p2), mount_component(a, t5, p2), insert(t5, r2, p2), mount_component(s2, t5, p2), insert(t5, c, p2), mount_component(l, t5, p2), u = true;
  }, p(t5, n2) {
    const i2 = {};
    64 & n2 && (i2.isConcentration = t5[6]), 128 & n2 && (i2.isRitual = t5[7]), e.$set(i2);
    const r3 = {};
    32 & n2 && (r3.effects = t5[5]), o2.$set(r3);
    const c2 = {};
    1 & n2 && (c2.actor = t5[0]), 2 & n2 && (c2.item = t5[1]), a.$set(c2);
    const u2 = {};
    8 & n2 && (u2.activities = t5[3].activities.contents), s2.$set(u2);
    const p2 = {};
    2 & n2 && (p2.spell = t5[1]), l.$set(p2);
  }, i(t5) {
    u || (transition_in(e.$$.fragment, t5), transition_in(o2.$$.fragment, t5), transition_in(a.$$.fragment, t5), transition_in(s2.$$.fragment, t5), transition_in(l.$$.fragment, t5), u = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), transition_out(o2.$$.fragment, t5), transition_out(a.$$.fragment, t5), transition_out(s2.$$.fragment, t5), transition_out(l.$$.fragment, t5), u = false;
  }, d(t5) {
    t5 && (detach(n), detach(i), detach(r2), detach(c)), destroy_component(e, t5), destroy_component(o2, t5), destroy_component(a, t5), destroy_component(s2, t5), destroy_component(l, t5);
  } };
}
function create_details_slot$4(t4) {
  let e, n, o2, i, a, r2, s2 = t4[2] && create_if_block$l(t4);
  return i = new SpellDescription({ props: { description: t4[8] } }), { c() {
    e = element("div"), n = element("div"), s2 && s2.c(), o2 = space(), create_component(i.$$.fragment), attr(e, "slot", "details");
  }, m(t5, a2) {
    insert(t5, e, a2), append(e, n), s2 && s2.m(n, null), append(n, o2), mount_component(i, n, null), r2 = true;
  }, p(t5, e2) {
    t5[2] ? s2 ? (s2.p(t5, e2), 4 & e2 && transition_in(s2, 1)) : (s2 = create_if_block$l(t5), s2.c(), transition_in(s2, 1), s2.m(n, o2)) : s2 && (group_outros(), transition_out(s2, 1, 1, () => {
      s2 = null;
    }), check_outros());
  }, i(t5) {
    r2 || (transition_in(s2), transition_in(i.$$.fragment, t5), t5 && add_render_callback(() => {
      r2 && (a || (a = create_bidirectional_transition(n, slide, { duration: 200, easing: identity, axis: "y" }, true)), a.run(1));
    }), r2 = true);
  }, o(t5) {
    transition_out(s2), transition_out(i.$$.fragment, t5), t5 && (a || (a = create_bidirectional_transition(n, slide, { duration: 200, easing: identity, axis: "y" }, false)), a.run(0)), r2 = false;
  }, d(t5) {
    t5 && detach(e), s2 && s2.d(), destroy_component(i), t5 && a && a.end();
  } };
}
function create_fragment$L(t4) {
  let e, n;
  return e = new ToggleableListEntry({ props: { name: t4[1].name, imageSrc: t4[1].img, $$slots: { details: [create_details_slot$4], "right-content": [create_right_content_slot$3], "below-name-content": [create_below_name_content_slot$3] }, $$scope: { ctx: t4 } } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, [n2]) {
    const o2 = {};
    2 & n2 && (o2.name = t5[1].name), 2 & n2 && (o2.imageSrc = t5[1].img), 2303 & n2 && (o2.$$scope = { dirty: n2, ctx: t5 }), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function instance$K(t4, e, n) {
  let o2, i, a, r2;
  var s2;
  let c, { actor: l } = e, { spell: u } = e, { sichtbar: p2 = false } = e;
  const d = mobileCompanionGameSettings.getWritableStore(USE_ADDITIONAL_INFO).subscribe((t5) => {
    n(4, c = t5);
  });
  onDestroy(() => {
    d();
  });
  const m = p2 ? u.system.description.value : `<div class="text-box">
  <p><b>Available in pro version. </b></p>
  <p>Please visit <a href="https://www.patreon.com/SyriousWorkshop" target="_blank">Syrious' Workshop</a></p>
</div>`;
  return t4.$$set = (t5) => {
    "actor" in t5 && n(0, l = t5.actor), "spell" in t5 && n(1, u = t5.spell), "sichtbar" in t5 && n(2, p2 = t5.sichtbar);
  }, t4.$$.update = () => {
    2 & t4.$$.dirty && n(3, o2 = u.system), 8 & t4.$$.dirty && n(7, i = o2.properties.has("ritual")), 8 & t4.$$.dirty && n(6, a = o2.properties.has("concentration")), 514 & t4.$$.dirty && n(5, r2 = null === n(9, s2 = u.effects) || void 0 === s2 ? void 0 : s2.contents);
  }, [l, u, p2, o2, c, r2, a, i, m, s2];
}
class Spell extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$K, create_fragment$L, safe_not_equal, { actor: 0, spell: 1, sichtbar: 2 });
  }
}
function get_each_context$b(t4, e, n) {
  const o2 = t4.slice();
  return o2[8] = e[n], o2;
}
function get_each_context_1$6(t4, e, n) {
  const o2 = t4.slice();
  return o2[8] = e[n], o2;
}
function create_each_block_1$6(t4) {
  let e, n, o2;
  return { c() {
    e = element("button"), e.innerHTML = '<dnd5e-icon src="systems/dnd5e/icons/svg/spell-slot.svg"></dnd5e-icon>', attr(e, "type", "button"), attr(e, "class", "pip filled svelte-mobile-companion-dnd5e-81nkluj30u9vsd-xo4a3c");
  }, m(i, a) {
    insert(i, e, a), n || (o2 = listen(e, "click", t4[3]), n = true);
  }, p: noop$3, d(t5) {
    t5 && detach(e), n = false, o2();
  } };
}
function create_each_block$b(t4) {
  let e, n, o2;
  return { c() {
    e = element("button"), e.innerHTML = '<dnd5e-icon src="systems/dnd5e/icons/svg/spell-slot.svg"></dnd5e-icon> ', attr(e, "type", "button"), attr(e, "class", "pip svelte-mobile-companion-dnd5e-81nkluj30u9vsd-xo4a3c");
  }, m(i, a) {
    insert(i, e, a), n || (o2 = listen(e, "click", t4[2]), n = true);
  }, p: noop$3, d(t5) {
    t5 && detach(e), n = false, o2();
  } };
}
function create_fragment$K(t4) {
  let e, n, o2 = ensure_array_like(t4[1]), i = [];
  for (let e2 = 0; e2 < o2.length; e2 += 1) i[e2] = create_each_block_1$6(get_each_context_1$6(t4, o2, e2));
  let a = ensure_array_like(t4[0]), r2 = [];
  for (let e2 = 0; e2 < a.length; e2 += 1) r2[e2] = create_each_block$b(get_each_context$b(t4, a, e2));
  return { c() {
    e = element("div");
    for (let t5 = 0; t5 < i.length; t5 += 1) i[t5].c();
    n = space();
    for (let t5 = 0; t5 < r2.length; t5 += 1) r2[t5].c();
    attr(e, "class", "pips svelte-mobile-companion-dnd5e-81nkluj30u9vsd-xo4a3c");
  }, m(t5, o3) {
    insert(t5, e, o3);
    for (let t6 = 0; t6 < i.length; t6 += 1) i[t6] && i[t6].m(e, null);
    append(e, n);
    for (let t6 = 0; t6 < r2.length; t6 += 1) r2[t6] && r2[t6].m(e, null);
  }, p(t5, [s2]) {
    if (10 & s2) {
      let a2;
      for (o2 = ensure_array_like(t5[1]), a2 = 0; a2 < o2.length; a2 += 1) {
        const r3 = get_each_context_1$6(t5, o2, a2);
        i[a2] ? i[a2].p(r3, s2) : (i[a2] = create_each_block_1$6(r3), i[a2].c(), i[a2].m(e, n));
      }
      for (; a2 < i.length; a2 += 1) i[a2].d(1);
      i.length = o2.length;
    }
    if (5 & s2) {
      let n2;
      for (a = ensure_array_like(t5[0]), n2 = 0; n2 < a.length; n2 += 1) {
        const o3 = get_each_context$b(t5, a, n2);
        r2[n2] ? r2[n2].p(o3, s2) : (r2[n2] = create_each_block$b(o3), r2[n2].c(), r2[n2].m(e, null));
      }
      for (; n2 < r2.length; n2 += 1) r2[n2].d(1);
      r2.length = a.length;
    }
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e), destroy_each(i, t5), destroy_each(r2, t5);
  } };
}
function instance$J(t4, e, n) {
  let o2, i, { actor: a } = e, { spell: r2 } = e, { spellLevel: s2 } = e;
  function c(t5) {
    const e2 = { system: { spells: { [s2]: { value: t5 } } } };
    FoundryGateway.updateActor(a, e2);
  }
  return t4.$$set = (t5) => {
    "actor" in t5 && n(5, a = t5.actor), "spell" in t5 && n(4, r2 = t5.spell), "spellLevel" in t5 && n(6, s2 = t5.spellLevel);
  }, t4.$$.update = () => {
    16 & t4.$$.dirty && n(1, o2 = (null == r2 ? void 0 : r2.max) > 0 ? Array(r2.value).fill(0) : []), 16 & t4.$$.dirty && n(0, i = (null == r2 ? void 0 : r2.max) > 0 ? Array(Math.max(0, r2.max - r2.value)).fill(0) : []);
  }, [i, o2, function() {
    if (r2) {
      c(r2.value + 1);
    }
  }, function() {
    if (r2) {
      const t5 = Math.max(0, r2.value - 1);
      n(4, r2.value = t5, r2), c(t5);
    }
  }, r2, a, s2];
}
class SpellSlots extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$J, create_fragment$K, safe_not_equal, { actor: 5, spell: 4, spellLevel: 6 });
  }
}
function get_each_context$a(t4, e, n) {
  const o2 = t4.slice();
  return o2[7] = e[n], o2;
}
function create_if_block$k(t4) {
  let e, n, o2 = [], i = /* @__PURE__ */ new Map(), a = ensure_array_like(t4[0]);
  const r2 = (t5) => t5[7].id;
  for (let e2 = 0; e2 < a.length; e2 += 1) {
    let n2 = get_each_context$a(t4, a, e2), s2 = r2(n2);
    i.set(s2, o2[e2] = create_each_block$a(s2, n2));
  }
  return { c() {
    for (let t5 = 0; t5 < o2.length; t5 += 1) o2[t5].c();
    e = empty();
  }, m(t5, i2) {
    for (let e2 = 0; e2 < o2.length; e2 += 1) o2[e2] && o2[e2].m(t5, i2);
    insert(t5, e, i2), n = true;
  }, p(t5, n2) {
    7 & n2 && (a = ensure_array_like(t5[0]), group_outros(), o2 = update_keyed_each(o2, n2, r2, 1, t5, a, i, e.parentNode, outro_and_destroy_block, create_each_block$a, e, get_each_context$a), check_outros());
  }, i(t5) {
    if (!n) {
      for (let t6 = 0; t6 < a.length; t6 += 1) transition_in(o2[t6]);
      n = true;
    }
  }, o(t5) {
    for (let t6 = 0; t6 < o2.length; t6 += 1) transition_out(o2[t6]);
    n = false;
  }, d(t5) {
    t5 && detach(e);
    for (let e2 = 0; e2 < o2.length; e2 += 1) o2[e2].d(t5);
  } };
}
function create_each_block$a(t4, e) {
  let n, o2, i;
  return o2 = new Spell({ props: { actor: e[1], spell: e[7], sichtbar: e[2] } }), { key: t4, first: null, c() {
    n = empty(), create_component(o2.$$.fragment), this.first = n;
  }, m(t5, e2) {
    insert(t5, n, e2), mount_component(o2, t5, e2), i = true;
  }, p(t5, n2) {
    e = t5;
    const i2 = {};
    2 & n2 && (i2.actor = e[1]), 1 & n2 && (i2.spell = e[7]), 4 & n2 && (i2.sichtbar = e[2]), o2.$set(i2);
  }, i(t5) {
    i || (transition_in(o2.$$.fragment, t5), i = true);
  }, o(t5) {
    transition_out(o2.$$.fragment, t5), i = false;
  }, d(t5) {
    t5 && detach(n), destroy_component(o2, t5);
  } };
}
function create_fragment$J(t4) {
  let e, n, o2, i, a, r2;
  n = new SectionListHeader({ props: { title: t4[3] } }), i = new SpellSlots({ props: { actor: t4[1], spell: t4[4], spellLevel: t4[5] } });
  let s2 = t4[0] && create_if_block$k(t4);
  return { c() {
    e = element("section"), create_component(n.$$.fragment), o2 = space(), create_component(i.$$.fragment), a = space(), s2 && s2.c(), attr(e, "class", "spell-card svelte-mobile-companion-dnd5e-81nkluj30u9vsd-zeocwk");
  }, m(t5, c) {
    insert(t5, e, c), mount_component(n, e, null), append(e, o2), mount_component(i, e, null), append(e, a), s2 && s2.m(e, null), r2 = true;
  }, p(t5, [o3]) {
    const a2 = {};
    8 & o3 && (a2.title = t5[3]), n.$set(a2);
    const r3 = {};
    2 & o3 && (r3.actor = t5[1]), 16 & o3 && (r3.spell = t5[4]), i.$set(r3), t5[0] ? s2 ? (s2.p(t5, o3), 1 & o3 && transition_in(s2, 1)) : (s2 = create_if_block$k(t5), s2.c(), transition_in(s2, 1), s2.m(e, null)) : s2 && (group_outros(), transition_out(s2, 1, 1, () => {
      s2 = null;
    }), check_outros());
  }, i(t5) {
    r2 || (transition_in(n.$$.fragment, t5), transition_in(i.$$.fragment, t5), transition_in(s2), r2 = true);
  }, o(t5) {
    transition_out(n.$$.fragment, t5), transition_out(i.$$.fragment, t5), transition_out(s2), r2 = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(n), destroy_component(i), s2 && s2.d();
  } };
}
function instance$I(t4, e, n) {
  let o2, { spells: i = [] } = e, { actor: a } = e, { level: r2 } = e, { sichtbar: s2 = false } = e, { label: c } = e, l = `spell${r2}`;
  return t4.$$set = (t5) => {
    "spells" in t5 && n(0, i = t5.spells), "actor" in t5 && n(1, a = t5.actor), "level" in t5 && n(6, r2 = t5.level), "sichtbar" in t5 && n(2, s2 = t5.sichtbar), "label" in t5 && n(3, c = t5.label);
  }, t4.$$.update = () => {
    2 & t4.$$.dirty && n(4, o2 = a.system.spells[l]);
  }, [i, a, s2, c, o2, l, r2];
}
class SpellLevelCard extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$I, create_fragment$J, safe_not_equal, { spells: 0, actor: 1, level: 6, sichtbar: 2, label: 3 });
  }
}
function create_if_block$j(t4) {
  let e, n;
  return { c() {
    e = element("p"), n = text(t4[1]), attr(e, "class", "subtitle svelte-mobile-companion-dnd5e-81nkluj30u9vsd-11u3ofl");
  }, m(t5, o2) {
    insert(t5, e, o2), append(e, n);
  }, p(t5, e2) {
    2 & e2 && set_data(n, t5[1]);
  }, d(t5) {
    t5 && detach(e);
  } };
}
function create_fragment$I(t4) {
  let e, n, o2, i, a, r2, s2, c, l, u = t4[1] && create_if_block$j(t4);
  return { c() {
    e = element("filigree-box"), n = element("h3"), o2 = text(t4[0]), i = space(), u && u.c(), a = space(), r2 = element("div"), s2 = text(t4[2]), attr(n, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-11u3ofl"), attr(r2, "class", "content svelte-mobile-companion-dnd5e-81nkluj30u9vsd-11u3ofl"), set_custom_element_data(e, "class", "info-box svelte-mobile-companion-dnd5e-81nkluj30u9vsd-11u3ofl"), set_custom_element_data(e, "aria-hidden", "true"), toggle_class(e, "highlight", t4[3]);
  }, m(p2, d) {
    insert(p2, e, d), append(e, n), append(n, o2), append(e, i), u && u.m(e, null), append(e, a), append(e, r2), append(r2, s2), c || (l = listen(e, "click", t4[4]), c = true);
  }, p(t5, [n2]) {
    1 & n2 && set_data(o2, t5[0]), t5[1] ? u ? u.p(t5, n2) : (u = create_if_block$j(t5), u.c(), u.m(e, a)) : u && (u.d(1), u = null), 4 & n2 && set_data(s2, t5[2]), 8 & n2 && toggle_class(e, "highlight", t5[3]);
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e), u && u.d(), c = false, l();
  } };
}
function instance$H(t4, e, n) {
  let { title: o2 } = e, { subtitle: i } = e, { content: a } = e, { highlight: r2 = false } = e;
  const s2 = createEventDispatcher();
  return t4.$$set = (t5) => {
    "title" in t5 && n(0, o2 = t5.title), "subtitle" in t5 && n(1, i = t5.subtitle), "content" in t5 && n(2, a = t5.content), "highlight" in t5 && n(3, r2 = t5.highlight);
  }, [o2, i, a, r2, function() {
    s2("click");
  }];
}
class InfoBox extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$H, create_fragment$I, safe_not_equal, { title: 0, subtitle: 1, content: 2, highlight: 3 });
  }
}
function get_each_context$9(t4, e, n) {
  const o2 = t4.slice();
  return o2[11] = e[n], o2;
}
function create_each_block$9(t4) {
  let e, n;
  return e = new InfoBox({ props: { title: "Spell DC", subtitle: t4[4].length > 1 ? t4[11].spellcastingClass : void 0, content: t4[11].dc } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    16 & n2 && (o2.subtitle = t5[4].length > 1 ? t5[11].spellcastingClass : void 0), 16 & n2 && (o2.content = t5[11].dc), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_else_block$6(t4) {
  let e, n;
  return e = new InfoBox({ props: { title: "Prepared", content: t4[0], highlight: t4[2] } }), e.$on("click", t4[7]), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    1 & n2 && (o2.content = t5[0]), 4 & n2 && (o2.highlight = t5[2]), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_if_block_1$d(t4) {
  let e, n;
  return e = new InfoBox({ props: { title: "Prepared", content: t4[0] + ` (${t4[1]})`, highlight: t4[2] } }), e.$on("click", t4[7]), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    3 & n2 && (o2.content = t5[0] + ` (${t5[1]})`), 4 & n2 && (o2.highlight = t5[2]), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_if_block$i(t4) {
  let e, n, o2, i, a, r2, s2, c;
  return { c() {
    e = element("div"), n = element("p"), o2 = text(t4[5]), a = space(), r2 = element("button"), r2.innerHTML = '<dnd5e-icon src="systems/dnd5e/icons/svg/break-concentration.svg" class="svelte-mobile-companion-dnd5e-81nkluj30u9vsd-ll3h2f"></dnd5e-icon>', attr(n, "class", i = "info-text animated-strike " + (t4[6] ? "active" : "") + " svelte-mobile-companion-dnd5e-81nkluj30u9vsd-ll3h2f"), attr(r2, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-ll3h2f"), attr(e, "class", "header-element svelte-mobile-companion-dnd5e-81nkluj30u9vsd-ll3h2f");
  }, m(i2, l) {
    insert(i2, e, l), append(e, n), append(n, o2), append(e, a), append(e, r2), s2 || (c = listen(r2, "click", t4[8]), s2 = true);
  }, p(t5, e2) {
    32 & e2 && set_data(o2, t5[5]), 64 & e2 && i !== (i = "info-text animated-strike " + (t5[6] ? "active" : "") + " svelte-mobile-companion-dnd5e-81nkluj30u9vsd-ll3h2f") && attr(n, "class", i);
  }, d(t5) {
    t5 && detach(e), s2 = false, c();
  } };
}
function create_fragment$H(t4) {
  let e, n, o2, i, a, r2, s2, c = ensure_array_like(t4[4]), l = [];
  for (let e2 = 0; e2 < c.length; e2 += 1) l[e2] = create_each_block$9(get_each_context$9(t4, c, e2));
  const u = (t5) => transition_out(l[t5], 1, 1, () => {
    l[t5] = null;
  }), p2 = [create_if_block_1$d, create_else_block$6], d = [];
  function m(t5, e2) {
    return t5[1] !== t5[0] ? 0 : 1;
  }
  o2 = m(t4), i = d[o2] = p2[o2](t4);
  let f = t4[3] && create_if_block$i(t4);
  return { c() {
    e = element("section");
    for (let t5 = 0; t5 < l.length; t5 += 1) l[t5].c();
    n = space(), i.c(), a = space(), f && f.c(), r2 = empty(), attr(e, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-ll3h2f");
  }, m(t5, i2) {
    insert(t5, e, i2);
    for (let t6 = 0; t6 < l.length; t6 += 1) l[t6] && l[t6].m(e, null);
    append(e, n), d[o2].m(e, null), insert(t5, a, i2), f && f.m(t5, i2), insert(t5, r2, i2), s2 = true;
  }, p(t5, [a2]) {
    if (16 & a2) {
      let o3;
      for (c = ensure_array_like(t5[4]), o3 = 0; o3 < c.length; o3 += 1) {
        const i2 = get_each_context$9(t5, c, o3);
        l[o3] ? (l[o3].p(i2, a2), transition_in(l[o3], 1)) : (l[o3] = create_each_block$9(i2), l[o3].c(), transition_in(l[o3], 1), l[o3].m(e, n));
      }
      for (group_outros(), o3 = c.length; o3 < l.length; o3 += 1) u(o3);
      check_outros();
    }
    let s3 = o2;
    o2 = m(t5), o2 === s3 ? d[o2].p(t5, a2) : (group_outros(), transition_out(d[s3], 1, 1, () => {
      d[s3] = null;
    }), check_outros(), i = d[o2], i ? i.p(t5, a2) : (i = d[o2] = p2[o2](t5), i.c()), transition_in(i, 1), i.m(e, null)), t5[3] ? f ? f.p(t5, a2) : (f = create_if_block$i(t5), f.c(), f.m(r2.parentNode, r2)) : f && (f.d(1), f = null);
  }, i(t5) {
    if (!s2) {
      for (let t6 = 0; t6 < c.length; t6 += 1) transition_in(l[t6]);
      transition_in(i), s2 = true;
    }
  }, o(t5) {
    l = l.filter(Boolean);
    for (let t6 = 0; t6 < l.length; t6 += 1) transition_out(l[t6]);
    transition_out(i), s2 = false;
  }, d(t5) {
    t5 && (detach(e), detach(a), detach(r2)), destroy_each(l, t5), d[o2].d(), f && f.d(t5);
  } };
}
function instance$G(t4, e, n) {
  let o2, { actor: i } = e, { preparedSpells: a } = e, { readiedSpells: r2 } = e, { filterActive: s2 = false } = e;
  const c = createEventDispatcher();
  let l, u;
  let p2 = false;
  return t4.$$set = (t5) => {
    "actor" in t5 && n(9, i = t5.actor), "preparedSpells" in t5 && n(0, a = t5.preparedSpells), "readiedSpells" in t5 && n(1, r2 = t5.readiedSpells), "filterActive" in t5 && n(2, s2 = t5.filterActive);
  }, t4.$$.update = () => {
    520 & t4.$$.dirty && (n(3, l = i.statuses.has("concentrating")), l && n(5, u = i.appliedEffects.filter((t5) => t5.name.startsWith("Concentrating:")).map((t5) => t5.name))), 528 & t4.$$.dirty && i.spellcastingClasses && Object.values(i.spellcastingClasses).map((t5) => {
      if (t5.spellcasting) {
        const e2 = { spellcastingClass: t5.name, dc: t5.spellcasting.save };
        o2.push(e2);
      }
    });
  }, n(4, o2 = []), [a, r2, s2, l, o2, u, p2, function() {
    c("toggleSpells");
  }, function() {
    n(6, p2 = true), setTimeout(() => {
      i.endConcentration(), n(6, p2 = false);
    }, 800);
  }, i];
}
class SpellsHeader extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$G, create_fragment$H, safe_not_equal, { actor: 9, preparedSpells: 0, readiedSpells: 1, filterActive: 2 });
  }
}
function get_each_context$8(t4, e, n) {
  const o2 = t4.slice();
  return o2[4] = e[n], o2;
}
function create_if_block$h(t4) {
  let e, n, o2 = [], i = /* @__PURE__ */ new Map(), a = ensure_array_like(t4[0]);
  const r2 = (t5) => t5[4].id;
  for (let e2 = 0; e2 < a.length; e2 += 1) {
    let n2 = get_each_context$8(t4, a, e2), s2 = r2(n2);
    i.set(s2, o2[e2] = create_each_block$8(s2, n2));
  }
  return { c() {
    for (let t5 = 0; t5 < o2.length; t5 += 1) o2[t5].c();
    e = empty();
  }, m(t5, i2) {
    for (let e2 = 0; e2 < o2.length; e2 += 1) o2[e2] && o2[e2].m(t5, i2);
    insert(t5, e, i2), n = true;
  }, p(t5, n2) {
    3 & n2 && (a = ensure_array_like(t5[0]), group_outros(), o2 = update_keyed_each(o2, n2, r2, 1, t5, a, i, e.parentNode, outro_and_destroy_block, create_each_block$8, e, get_each_context$8), check_outros());
  }, i(t5) {
    if (!n) {
      for (let t6 = 0; t6 < a.length; t6 += 1) transition_in(o2[t6]);
      n = true;
    }
  }, o(t5) {
    for (let t6 = 0; t6 < o2.length; t6 += 1) transition_out(o2[t6]);
    n = false;
  }, d(t5) {
    t5 && detach(e);
    for (let e2 = 0; e2 < o2.length; e2 += 1) o2[e2].d(t5);
  } };
}
function create_each_block$8(t4, e) {
  let n, o2, i;
  return o2 = new Spell({ props: { actor: e[1], spell: e[4], sichtbar: isFull() } }), { key: t4, first: null, c() {
    n = empty(), create_component(o2.$$.fragment), this.first = n;
  }, m(t5, e2) {
    insert(t5, n, e2), mount_component(o2, t5, e2), i = true;
  }, p(t5, n2) {
    e = t5;
    const i2 = {};
    2 & n2 && (i2.actor = e[1]), 1 & n2 && (i2.spell = e[4]), o2.$set(i2);
  }, i(t5) {
    i || (transition_in(o2.$$.fragment, t5), i = true);
  }, o(t5) {
    transition_out(o2.$$.fragment, t5), i = false;
  }, d(t5) {
    t5 && detach(n), destroy_component(o2, t5);
  } };
}
function create_fragment$G(t4) {
  let e, n, o2, i, a, r2;
  n = new SectionListHeader({ props: { title: t4[2] } }), i = new SpellSlots({ props: { actor: t4[1], spell: t4[3], spellLevel } });
  let s2 = t4[0] && create_if_block$h(t4);
  return { c() {
    e = element("section"), create_component(n.$$.fragment), o2 = space(), create_component(i.$$.fragment), a = space(), s2 && s2.c(), attr(e, "class", "spell-card svelte-mobile-companion-dnd5e-81nkluj30u9vsd-zeocwk");
  }, m(t5, c) {
    insert(t5, e, c), mount_component(n, e, null), append(e, o2), mount_component(i, e, null), append(e, a), s2 && s2.m(e, null), r2 = true;
  }, p(t5, [o3]) {
    const a2 = {};
    4 & o3 && (a2.title = t5[2]), n.$set(a2);
    const r3 = {};
    2 & o3 && (r3.actor = t5[1]), 8 & o3 && (r3.spell = t5[3]), i.$set(r3), t5[0] ? s2 ? (s2.p(t5, o3), 1 & o3 && transition_in(s2, 1)) : (s2 = create_if_block$h(t5), s2.c(), transition_in(s2, 1), s2.m(e, null)) : s2 && (group_outros(), transition_out(s2, 1, 1, () => {
      s2 = null;
    }), check_outros());
  }, i(t5) {
    r2 || (transition_in(n.$$.fragment, t5), transition_in(i.$$.fragment, t5), transition_in(s2), r2 = true);
  }, o(t5) {
    transition_out(n.$$.fragment, t5), transition_out(i.$$.fragment, t5), transition_out(s2), r2 = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(n), destroy_component(i), s2 && s2.d();
  } };
}
let spellLevel = "pact";
function instance$F(t4, e, n) {
  let o2, i, { spells: a = [] } = e, { actor: r2 } = e;
  return t4.$$set = (t5) => {
    "spells" in t5 && n(0, a = t5.spells), "actor" in t5 && n(1, r2 = t5.actor);
  }, t4.$$.update = () => {
    2 & t4.$$.dirty && n(3, o2 = r2.system.spells[spellLevel]), 2 & t4.$$.dirty && n(2, i = r2.system.spells[spellLevel].label + " — " + i18n("DND5E.SpellLevel" + r2.system.spells[spellLevel].level));
  }, [a, r2, i, o2];
}
class SpellLevelCardForWarlocks extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$F, create_fragment$G, safe_not_equal, { spells: 0, actor: 1 });
  }
}
function create_fragment$F(t4) {
  let e, n;
  return e = new FilterAndSearch({ props: { placeholder: "Search spells...", filterStore: t4[0], filterOptions: t4[2] } }), e.$on("search", t4[1]), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p: noop$3, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function instance$E(t4) {
  const e = getContext(CONTEXT.ACTIVE_SPELL_FILTER), n = createEventDispatcher();
  return [e, function(t5) {
    n("search", t5.detail);
  }, [{ label: i18n("DND5E.Action"), filterFct: (t5) => "action" === foundry.utils.getProperty(t5, "system.activation.type") }, { label: i18n("DND5E.BonusAction"), filterFct: (t5) => "bonus" === foundry.utils.getProperty(t5, "system.activation.type") }, { label: i18n("DND5E.Reaction"), filterFct: (t5) => "reaction" === foundry.utils.getProperty(t5, "system.activation.type") }, { label: i18n("DND5E.Concentration"), filterFct: (t5) => foundry.utils.getProperty(t5, "system.properties").has("concentration") }, { label: i18n("DND5E.Ritual"), filterFct: (t5) => foundry.utils.getProperty(t5, "system.properties").has("ritual") }, { label: i18n("DND5E.SchoolAbj"), filterFct: (t5) => "abj" === foundry.utils.getProperty(t5, "system.school") }, { label: i18n("DND5E.SchoolCon"), filterFct: (t5) => "con" === foundry.utils.getProperty(t5, "system.school") }, { label: i18n("DND5E.SchoolDiv"), filterFct: (t5) => "div" === foundry.utils.getProperty(t5, "system.school") }, { label: i18n("DND5E.SchoolEnc"), filterFct: (t5) => "enc" === foundry.utils.getProperty(t5, "system.school") }, { label: i18n("DND5E.SchoolEvo"), filterFct: (t5) => "evo" === foundry.utils.getProperty(t5, "system.school") }, { label: i18n("DND5E.SchoolIll"), filterFct: (t5) => "ill" === foundry.utils.getProperty(t5, "system.school") }, { label: i18n("DND5E.SchoolNec"), filterFct: (t5) => "nec" === foundry.utils.getProperty(t5, "system.school") }, { label: i18n("DND5E.SchoolTrs"), filterFct: (t5) => "trs" === foundry.utils.getProperty(t5, "system.school") }]];
}
class SpellFilterAndSearch extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$E, create_fragment$F, safe_not_equal, {});
  }
}
function get_each_context$7(t4, e, n) {
  const o2 = t4.slice();
  return o2[17] = e[n], o2;
}
function get_each_context_1$5(t4, e, n) {
  const o2 = t4.slice();
  return o2[17] = e[n], o2;
}
function create_if_block_2$7(t4) {
  let e, n, o2 = ensure_array_like(t4[5]), i = [];
  for (let e2 = 0; e2 < o2.length; e2 += 1) i[e2] = create_each_block_1$5(get_each_context_1$5(t4, o2, e2));
  const a = (t5) => transition_out(i[t5], 1, 1, () => {
    i[t5] = null;
  });
  return { c() {
    for (let t5 = 0; t5 < i.length; t5 += 1) i[t5].c();
    e = empty();
  }, m(t5, o3) {
    for (let e2 = 0; e2 < i.length; e2 += 1) i[e2] && i[e2].m(t5, o3);
    insert(t5, e, o3), n = true;
  }, p(t5, n2) {
    if (35 & n2) {
      let r2;
      for (o2 = ensure_array_like(t5[5]), r2 = 0; r2 < o2.length; r2 += 1) {
        const a2 = get_each_context_1$5(t5, o2, r2);
        i[r2] ? (i[r2].p(a2, n2), transition_in(i[r2], 1)) : (i[r2] = create_each_block_1$5(a2), i[r2].c(), transition_in(i[r2], 1), i[r2].m(e.parentNode, e));
      }
      for (group_outros(), r2 = o2.length; r2 < i.length; r2 += 1) a(r2);
      check_outros();
    }
  }, i(t5) {
    if (!n) {
      for (let t6 = 0; t6 < o2.length; t6 += 1) transition_in(i[t6]);
      n = true;
    }
  }, o(t5) {
    i = i.filter(Boolean);
    for (let t6 = 0; t6 < i.length; t6 += 1) transition_out(i[t6]);
    n = false;
  }, d(t5) {
    t5 && detach(e), destroy_each(i, t5);
  } };
}
function create_each_block_1$5(t4) {
  let e, n;
  return e = new SpellLevelCard({ props: { spells: t4[1][t4[17].level], actor: t4[0], level: t4[17].level, sichtbar: true, label: t4[17].label } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    34 & n2 && (o2.spells = t5[1][t5[17].level]), 1 & n2 && (o2.actor = t5[0]), 32 & n2 && (o2.level = t5[17].level), 32 & n2 && (o2.label = t5[17].label), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_if_block_1$c(t4) {
  let e, n, o2, i, a = ensure_array_like(t4[6]), r2 = [];
  for (let e2 = 0; e2 < a.length; e2 += 1) r2[e2] = create_each_block$7(get_each_context$7(t4, a, e2));
  const s2 = (t5) => transition_out(r2[t5], 1, 1, () => {
    r2[t5] = null;
  });
  return o2 = new ProOverlay({}), { c() {
    e = element("div");
    for (let t5 = 0; t5 < r2.length; t5 += 1) r2[t5].c();
    n = space(), create_component(o2.$$.fragment), set_style(e, "position", "relative");
  }, m(t5, a2) {
    insert(t5, e, a2);
    for (let t6 = 0; t6 < r2.length; t6 += 1) r2[t6] && r2[t6].m(e, null);
    append(e, n), mount_component(o2, e, null), i = true;
  }, p(t5, o3) {
    if (67 & o3) {
      let i2;
      for (a = ensure_array_like(t5[6]), i2 = 0; i2 < a.length; i2 += 1) {
        const s3 = get_each_context$7(t5, a, i2);
        r2[i2] ? (r2[i2].p(s3, o3), transition_in(r2[i2], 1)) : (r2[i2] = create_each_block$7(s3), r2[i2].c(), transition_in(r2[i2], 1), r2[i2].m(e, n));
      }
      for (group_outros(), i2 = a.length; i2 < r2.length; i2 += 1) s2(i2);
      check_outros();
    }
  }, i(t5) {
    if (!i) {
      for (let t6 = 0; t6 < a.length; t6 += 1) transition_in(r2[t6]);
      transition_in(o2.$$.fragment, t5), i = true;
    }
  }, o(t5) {
    r2 = r2.filter(Boolean);
    for (let t6 = 0; t6 < r2.length; t6 += 1) transition_out(r2[t6]);
    transition_out(o2.$$.fragment, t5), i = false;
  }, d(t5) {
    t5 && detach(e), destroy_each(r2, t5), destroy_component(o2);
  } };
}
function create_each_block$7(t4) {
  let e, n;
  return e = new SpellLevelCard({ props: { spells: t4[1][t4[17].level], actor: t4[0], level: t4[17].level, label: t4[17].label } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    66 & n2 && (o2.spells = t5[1][t5[17].level]), 1 & n2 && (o2.actor = t5[0]), 64 & n2 && (o2.level = t5[17].level), 64 & n2 && (o2.label = t5[17].label), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_if_block$g(t4) {
  let e, n;
  return e = new SpellLevelCardForWarlocks({ props: { actor: t4[0], spells: t4[4] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    1 & n2 && (o2.actor = t5[0]), 16 & n2 && (o2.spells = t5[4]), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_fragment$E(t4) {
  let e, n, o2, i, a, r2, s2, c, l;
  n = new SpellsHeader({ props: { actor: t4[0], preparedSpells: t4[7].length, readiedSpells: t4[3].length, filterActive: t4[2] } }), n.$on("toggleSpells", t4[10]), i = new SpellFilterAndSearch({}), i.$on("search", t4[9]);
  let u = t4[5].length > 0 && create_if_block_2$7(t4), p2 = t4[6].length > 0 && create_if_block_1$c(t4), d = t4[4]?.length > 0 && create_if_block$g(t4);
  return { c() {
    e = element("section"), create_component(n.$$.fragment), o2 = space(), create_component(i.$$.fragment), a = space(), r2 = element("ol"), u && u.c(), s2 = space(), p2 && p2.c(), c = space(), d && d.c(), attr(r2, "class", "content-scroll-list svelte-mobile-companion-dnd5e-81nkluj30u9vsd-mfxl5s"), attr(e, "class", "category-content");
  }, m(t5, m) {
    insert(t5, e, m), mount_component(n, e, null), append(e, o2), mount_component(i, e, null), append(e, a), append(e, r2), u && u.m(r2, null), append(r2, s2), p2 && p2.m(r2, null), append(r2, c), d && d.m(r2, null), l = true;
  }, p(t5, [e2]) {
    const o3 = {};
    1 & e2 && (o3.actor = t5[0]), 128 & e2 && (o3.preparedSpells = t5[7].length), 8 & e2 && (o3.readiedSpells = t5[3].length), 4 & e2 && (o3.filterActive = t5[2]), n.$set(o3), t5[5].length > 0 ? u ? (u.p(t5, e2), 32 & e2 && transition_in(u, 1)) : (u = create_if_block_2$7(t5), u.c(), transition_in(u, 1), u.m(r2, s2)) : u && (group_outros(), transition_out(u, 1, 1, () => {
      u = null;
    }), check_outros()), t5[6].length > 0 ? p2 ? (p2.p(t5, e2), 64 & e2 && transition_in(p2, 1)) : (p2 = create_if_block_1$c(t5), p2.c(), transition_in(p2, 1), p2.m(r2, c)) : p2 && (group_outros(), transition_out(p2, 1, 1, () => {
      p2 = null;
    }), check_outros()), t5[4]?.length > 0 ? d ? (d.p(t5, e2), 16 & e2 && transition_in(d, 1)) : (d = create_if_block$g(t5), d.c(), transition_in(d, 1), d.m(r2, null)) : d && (group_outros(), transition_out(d, 1, 1, () => {
      d = null;
    }), check_outros());
  }, i(t5) {
    l || (transition_in(n.$$.fragment, t5), transition_in(i.$$.fragment, t5), transition_in(u), transition_in(p2), transition_in(d), l = true);
  }, o(t5) {
    transition_out(n.$$.fragment, t5), transition_out(i.$$.fragment, t5), transition_out(u), transition_out(p2), transition_out(d), l = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(n), destroy_component(i), u && u.d(), p2 && p2.d(), d && d.d();
  } };
}
function instance$D(t4, e, n) {
  let o2, i, a, r2, s2, c, l, { actor: u } = e;
  const p2 = getContext(CONTEXT.ACTIVE_SPELL_FILTER);
  let d, m, f;
  function _(t5) {
    return "pact" === getSpellPreparation(t5).preparationMethod;
  }
  component_subscribe(t4, p2, (t5) => n(15, l = t5)), null === sessionStorage.getItem("filterActive") ? (f = false, sessionStorage.setItem("filterActive", "false")) : f = "true" === sessionStorage.getItem("filterActive");
  let h = [], g2 = [];
  return t4.$$set = (t5) => {
    "actor" in t5 && n(0, u = t5.actor);
  }, t4.$$.update = () => {
    if (1 & t4.$$.dirty && n(13, o2 = u.collections.items.filter((t5) => "spell" === t5.type)), 61440 & t4.$$.dirty && n(11, i = o2.filter((t5) => t5.name.toLowerCase().includes(c) && a(t5, l))), 8192 & t4.$$.dirty && n(3, r2 = o2.filter((t5) => getSpellPreparation(t5.system).preparationState !== PreparationState.unprepared)), 8 & t4.$$.dirty && n(7, s2 = r2.filter((t5) => {
      const e2 = getSpellPreparation(t5.system);
      return ("spell" === e2.preparationMethod || "prepared" === e2.preparationMethod) && e2.preparationState === PreparationState.prepared;
    })), 2060 & t4.$$.dirty) {
      n(1, d = (f ? r2 : i).reduce((t5, e2) => {
        const n2 = e2.system;
        let o3 = n2.level;
        return 0 !== o3 && _(n2) || (t5[o3] || (t5[o3] = []), t5[o3].push(e2)), t5;
      }, {})), n(4, m = i.filter((t5) => {
        const e2 = t5.system;
        return _(e2) && e2.level > 0;
      }));
    }
    if (2 & t4.$$.dirty) for (const t5 in d) d[t5].sort((t6, e2) => t6.name.localeCompare(e2.name));
    if (3 & t4.$$.dirty) {
      const t5 = [], e2 = [];
      Object.entries(d).forEach(([n2, o3]) => {
        const i2 = Number.parseInt(n2), a2 = 0 === i2 ? i18n("DND5E.SpellCantrip") : Object.entries(u.system.spells).filter(([t6, e3]) => e3.level === i2).map(([t6, e3]) => e3.label)[0];
        i2 < 2 ? t5.push({ level: i2, label: a2 }) : e2.push({ level: i2, label: a2 });
      }), n(5, h = t5), n(6, g2 = e2);
    }
  }, n(12, c = ""), n(14, a = (t5, e2) => 0 === e2.length || e2.every((e3) => e3.filterFct(t5))), [u, d, f, r2, m, h, g2, s2, p2, function(t5) {
    n(12, c = t5.detail);
  }, function() {
    n(5, h.length = 0, h), n(6, g2.length = 0, g2), n(2, f = !f), sessionStorage.setItem("filterActive", f.toString());
  }, i, c, o2, a, l];
}
class Spells extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$D, create_fragment$E, safe_not_equal, { actor: 0 });
  }
}
function create_default_slot$2(t4) {
  let e, n, o2;
  return { c() {
    e = element("div"), e.textContent = "Uses", n = space(), o2 = element("div"), o2.textContent = "Recovery", attr(e, "class", "item-uses svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1jbdyv2"), attr(o2, "class", "item-recovery svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1jbdyv2");
  }, m(t5, i) {
    insert(t5, e, i), insert(t5, n, i), insert(t5, o2, i);
  }, p: noop$3, d(t5) {
    t5 && (detach(e), detach(n), detach(o2));
  } };
}
function create_fragment$D(t4) {
  let e, n;
  return e = new SectionListHeader({ props: { title: t4[0], $$slots: { default: [create_default_slot$2] }, $$scope: { ctx: t4 } } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, [n2]) {
    const o2 = {};
    1 & n2 && (o2.title = t5[0]), 2 & n2 && (o2.$$scope = { dirty: n2, ctx: t5 }), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function instance$C(t4, e, n) {
  let { title: o2 } = e;
  return t4.$$set = (t5) => {
    "title" in t5 && n(0, o2 = t5.title);
  }, [o2];
}
class FeaturesSectionHeader extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$C, create_fragment$D, safe_not_equal, { title: 0 });
  }
}
function create_if_block_1$b(t4) {
  let e, n, o2;
  return { c() {
    e = element("button"), e.innerHTML = '<i class="fas fa-minus"></i>', attr(e, "class", "adjustment-button svelte-mobile-companion-dnd5e-81nkluj30u9vsd-tn0ke6");
  }, m(i, a) {
    insert(i, e, a), n || (o2 = listen(e, "click", t4[4]), n = true);
  }, p: noop$3, d(t5) {
    t5 && detach(e), n = false, o2();
  } };
}
function create_if_block$f(t4) {
  let e, n, o2;
  return { c() {
    e = element("button"), e.innerHTML = '<i class="fas fa-plus"></i>', attr(e, "class", "adjustment-button svelte-mobile-companion-dnd5e-81nkluj30u9vsd-tn0ke6");
  }, m(i, a) {
    insert(i, e, a), n || (o2 = listen(e, "click", t4[3]), n = true);
  }, p: noop$3, d(t5) {
    t5 && detach(e), n = false, o2();
  } };
}
function create_fragment$C(t4) {
  let e, n, o2, i, a, r2, s2, c, l, u, p2, d = !t4[5] && create_if_block_1$b(t4), m = !t4[5] && create_if_block$f(t4);
  return { c() {
    e = element("div"), d && d.c(), n = space(), o2 = element("div"), i = element("span"), a = text(t4[0]), r2 = space(), s2 = element("span"), s2.textContent = "/", c = space(), l = element("span"), u = text(t4[1]), p2 = space(), m && m.c(), attr(i, "class", "current svelte-mobile-companion-dnd5e-81nkluj30u9vsd-tn0ke6"), attr(s2, "class", "separator svelte-mobile-companion-dnd5e-81nkluj30u9vsd-tn0ke6"), attr(l, "class", "max svelte-mobile-companion-dnd5e-81nkluj30u9vsd-tn0ke6"), attr(o2, "class", "uses svelte-mobile-companion-dnd5e-81nkluj30u9vsd-tn0ke6"), attr(e, "class", "item-quantity svelte-mobile-companion-dnd5e-81nkluj30u9vsd-tn0ke6");
  }, m(t5, f) {
    insert(t5, e, f), d && d.m(e, null), append(e, n), append(e, o2), append(o2, i), append(i, a), append(o2, r2), append(o2, s2), append(o2, c), append(o2, l), append(l, u), append(e, p2), m && m.m(e, null);
  }, p(t5, [e2]) {
    t5[5] || d.p(t5, e2), 1 & e2 && set_data(a, t5[0]), 2 & e2 && set_data(u, t5[1]), t5[5] || m.p(t5, e2);
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e), d && d.d(), m && m.d();
  } };
}
function instance$B(t4, e, n) {
  let o2, { current: i = 0 } = e, { max: a = 0 } = e;
  const r2 = getContext(CONTEXT.ACTOR_STORE);
  component_subscribe(t4, r2, (t5) => n(6, o2 = t5));
  const s2 = createEventDispatcher();
  const c = isReadOnlyActor(o2);
  return t4.$$set = (t5) => {
    "current" in t5 && n(0, i = t5.current), "max" in t5 && n(1, a = t5.max);
  }, [i, a, r2, function() {
    i >= a || (n(0, i++, i), s2("onQtyChange", i));
  }, function() {
    i > 0 && (n(0, i--, i), s2("onQtyChange", i));
  }, c];
}
class FeatureUses extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$B, create_fragment$C, safe_not_equal, { current: 0, max: 1 });
  }
}
function create_below_name_content_slot$2(t4) {
  let e;
  return { c() {
    e = element("div"), e.innerHTML = "", attr(e, "slot", "below-name-content");
  }, m(t5, n) {
    insert(t5, e, n);
  }, p: noop$3, d(t5) {
    t5 && detach(e);
  } };
}
function create_if_block_3$3(t4) {
  let e, n;
  return e = new FeatureUses({ props: { max: t4[2].max, current: t4[2].value } }), e.$on("onQtyChange", t4[7]), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    4 & n2 && (o2.max = t5[2].max), 4 & n2 && (o2.current = t5[2].value), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_else_block$5(t4) {
  let e, n;
  return { c() {
    e = element("div"), n = element("span"), n.textContent = `${t4[6]()}`, attr(n, "class", "condensed"), attr(e, "class", "item-recovery svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1mdcygz");
  }, m(t5, o2) {
    insert(t5, e, o2), append(e, n);
  }, p: noop$3, d(t5) {
    t5 && detach(e);
  } };
}
function create_if_block_2$6(t4) {
  let e, n, o2, i = (t4[0].system.uses?.recovery?.[0]?.formula ?? "") + "";
  return { c() {
    e = element("div"), n = element("i"), o2 = text(i), attr(n, "class", "fas fa-bolt"), attr(e, "class", "item-recovery svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1mdcygz");
  }, m(t5, i2) {
    insert(t5, e, i2), append(e, n), append(e, o2);
  }, p(t5, e2) {
    1 & e2 && i !== (i = (t5[0].system.uses?.recovery?.[0]?.formula ?? "") + "") && set_data(o2, i);
  }, d(t5) {
    t5 && detach(e);
  } };
}
function create_right_content_slot$2(t4) {
  let e, n, o2, i = t4[2]?.max && create_if_block_3$3(t4);
  let a = function(t5) {
    return "recharge" === t5[5] ? create_if_block_2$6 : create_else_block$5;
  }(t4), r2 = a(t4);
  return { c() {
    e = element("div"), i && i.c(), n = space(), r2.c(), attr(e, "class", "uses-and-recovery svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1mdcygz"), attr(e, "slot", "right-content");
  }, m(t5, a2) {
    insert(t5, e, a2), i && i.m(e, null), append(e, n), r2.m(e, null), o2 = true;
  }, p(t5, o3) {
    t5[2]?.max ? i ? (i.p(t5, o3), 4 & o3 && transition_in(i, 1)) : (i = create_if_block_3$3(t5), i.c(), transition_in(i, 1), i.m(e, n)) : i && (group_outros(), transition_out(i, 1, 1, () => {
      i = null;
    }), check_outros()), r2.p(t5, o3);
  }, i(t5) {
    o2 || (transition_in(i), o2 = true);
  }, o(t5) {
    transition_out(i), o2 = false;
  }, d(t5) {
    t5 && detach(e), i && i.d(), r2.d();
  } };
}
function create_if_block_1$a(t4) {
  let e, n;
  return e = new Activities({ props: { activities: t4[0].system.activities.contents } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    1 & n2 && (o2.activities = t5[0].system.activities.contents), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_if_block$e(t4) {
  let e, n, o2, i, a, r2, s2 = t4[4][t4[0].system.uses?.recovery[0]?.type] + "", c = t4[0].system.uses?.recovery?.[0]?.formula + "";
  return { c() {
    e = element("b"), e.textContent = "Recovery:", n = space(), o2 = text(s2), i = text("\r\n            on "), a = text(c), r2 = text("+");
  }, m(t5, s3) {
    insert(t5, e, s3), insert(t5, n, s3), insert(t5, o2, s3), insert(t5, i, s3), insert(t5, a, s3), insert(t5, r2, s3);
  }, p(t5, e2) {
    1 & e2 && s2 !== (s2 = t5[4][t5[0].system.uses?.recovery[0]?.type] + "") && set_data(o2, s2), 1 & e2 && c !== (c = t5[0].system.uses?.recovery?.[0]?.formula + "") && set_data(a, c);
  }, d(t5) {
    t5 && (detach(e), detach(n), detach(o2), detach(i), detach(a), detach(r2));
  } };
}
function create_details_slot$3(t4) {
  let e, n, o2, i, a, r2, s2;
  n = new ToggleFavorite({ props: { actor: t4[1], item: t4[0] } });
  let c = t4[0].system.activities?.size > 0 && create_if_block_1$a(t4), l = "recharge" === t4[5] && create_if_block$e(t4);
  return r2 = new Description({ props: { htmlText: t4[3] } }), { c() {
    e = element("div"), create_component(n.$$.fragment), o2 = space(), c && c.c(), i = space(), l && l.c(), a = space(), create_component(r2.$$.fragment), attr(e, "slot", "details");
  }, m(t5, u) {
    insert(t5, e, u), mount_component(n, e, null), append(e, o2), c && c.m(e, null), append(e, i), l && l.m(e, null), append(e, a), mount_component(r2, e, null), s2 = true;
  }, p(t5, o3) {
    const a2 = {};
    2 & o3 && (a2.actor = t5[1]), 1 & o3 && (a2.item = t5[0]), n.$set(a2), t5[0].system.activities?.size > 0 ? c ? (c.p(t5, o3), 1 & o3 && transition_in(c, 1)) : (c = create_if_block_1$a(t5), c.c(), transition_in(c, 1), c.m(e, i)) : c && (group_outros(), transition_out(c, 1, 1, () => {
      c = null;
    }), check_outros()), "recharge" === t5[5] && l.p(t5, o3);
  }, i(t5) {
    s2 || (transition_in(n.$$.fragment, t5), transition_in(c), transition_in(r2.$$.fragment, t5), s2 = true);
  }, o(t5) {
    transition_out(n.$$.fragment, t5), transition_out(c), transition_out(r2.$$.fragment, t5), s2 = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(n), c && c.d(), l && l.d(), destroy_component(r2);
  } };
}
function create_fragment$B(t4) {
  let e, n;
  return e = new ToggleableListEntry({ props: { name: t4[0].name, imageSrc: t4[0].img, $$slots: { details: [create_details_slot$3], "right-content": [create_right_content_slot$2], "below-name-content": [create_below_name_content_slot$2] }, $$scope: { ctx: t4 } } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, [n2]) {
    const o2 = {};
    1 & n2 && (o2.name = t5[0].name), 1 & n2 && (o2.imageSrc = t5[0].img), 263 & n2 && (o2.$$scope = { dirty: n2, ctx: t5 }), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function instance$A(t4, e, n) {
  let o2, { feature: i } = e, { actor: a } = e;
  const r2 = i.system.description.value, s2 = { recoverAll: game.i18n.localize("DND5E.USES.Recovery.Type.RecoverAll"), loseAll: game.i18n.localize("DND5E.USES.Recovery.Type.LoseAll"), formula: game.i18n.localize("DND5E.USES.Recovery.Type.Formula") };
  let c = l();
  function l() {
    var t5, e2, n2;
    const o3 = null === (t5 = i.system.uses) || void 0 === t5 ? void 0 : t5.recovery;
    let a2 = "-";
    if ((null == o3 ? void 0 : o3.length) > 0) a2 = o3[0].period;
    else if ((null === (e2 = i.system.activities) || void 0 === e2 ? void 0 : e2.size) > 0) {
      const t6 = i.system.activities.contents[0].uses, e3 = null === (n2 = null == t6 ? void 0 : t6.recovery[0]) || void 0 === n2 ? void 0 : n2.period;
      e3 && (a2 = e3);
    }
    return a2;
  }
  return t4.$$set = (t5) => {
    "feature" in t5 && n(0, i = t5.feature), "actor" in t5 && n(1, a = t5.actor);
  }, t4.$$.update = () => {
    1 & t4.$$.dirty && n(2, o2 = i.system.uses);
  }, [i, a, o2, r2, s2, c, l, function(t5) {
    var e2;
    const n2 = t5.detail, o3 = { system: { uses: { spent: (null === (e2 = i.system.uses) || void 0 === e2 ? void 0 : e2.max) - n2 } } };
    FoundryGateway.updateFeature(i, o3);
  }];
}
class Feature extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$A, create_fragment$B, safe_not_equal, { feature: 0, actor: 1 });
  }
}
function get_each_context$6(t4, e, n) {
  const o2 = t4.slice();
  return o2[3] = e[n], o2;
}
function create_each_block$6(t4) {
  let e, n;
  return e = new Feature({ props: { feature: t4[3], actor: t4[2] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    2 & n2 && (o2.feature = t5[3]), 4 & n2 && (o2.actor = t5[2]), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_fragment$A(t4) {
  let e, n, o2, i, a;
  n = new FeaturesSectionHeader({ props: { title: t4[0] } });
  let r2 = ensure_array_like(t4[1]), s2 = [];
  for (let e2 = 0; e2 < r2.length; e2 += 1) s2[e2] = create_each_block$6(get_each_context$6(t4, r2, e2));
  const c = (t5) => transition_out(s2[t5], 1, 1, () => {
    s2[t5] = null;
  });
  return { c() {
    e = element("section"), create_component(n.$$.fragment), o2 = space(), i = element("ol");
    for (let t5 = 0; t5 < s2.length; t5 += 1) s2[t5].c();
    attr(i, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1q25mcs");
  }, m(t5, r3) {
    insert(t5, e, r3), mount_component(n, e, null), append(e, o2), append(e, i);
    for (let t6 = 0; t6 < s2.length; t6 += 1) s2[t6] && s2[t6].m(i, null);
    a = true;
  }, p(t5, [e2]) {
    const o3 = {};
    if (1 & e2 && (o3.title = t5[0]), n.$set(o3), 6 & e2) {
      let n2;
      for (r2 = ensure_array_like(t5[1]), n2 = 0; n2 < r2.length; n2 += 1) {
        const o4 = get_each_context$6(t5, r2, n2);
        s2[n2] ? (s2[n2].p(o4, e2), transition_in(s2[n2], 1)) : (s2[n2] = create_each_block$6(o4), s2[n2].c(), transition_in(s2[n2], 1), s2[n2].m(i, null));
      }
      for (group_outros(), n2 = r2.length; n2 < s2.length; n2 += 1) c(n2);
      check_outros();
    }
  }, i(t5) {
    if (!a) {
      transition_in(n.$$.fragment, t5);
      for (let t6 = 0; t6 < r2.length; t6 += 1) transition_in(s2[t6]);
      a = true;
    }
  }, o(t5) {
    transition_out(n.$$.fragment, t5), s2 = s2.filter(Boolean);
    for (let t6 = 0; t6 < s2.length; t6 += 1) transition_out(s2[t6]);
    a = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(n), destroy_each(s2, t5);
  } };
}
function instance$z(t4, e, n) {
  let { title: o2 } = e, { features: i } = e, { actor: a } = e;
  return t4.$$set = (t5) => {
    "title" in t5 && n(0, o2 = t5.title), "features" in t5 && n(1, i = t5.features), "actor" in t5 && n(2, a = t5.actor);
  }, [o2, i, a];
}
class FeaturesSection extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$z, create_fragment$A, safe_not_equal, { title: 0, features: 1, actor: 2 });
  }
}
function get_each_context$5(t4, e, n) {
  const o2 = t4.slice();
  return o2[8] = e[n][0], o2[9] = e[n][1], o2;
}
function get_each_context_1$4(t4, e, n) {
  const o2 = t4.slice();
  return o2[8] = e[n][0], o2[9] = e[n][1], o2;
}
function get_each_context_2$2(t4, e, n) {
  const o2 = t4.slice();
  return o2[8] = e[n][0], o2[9] = e[n][1], o2;
}
function get_each_context_3$1(t4, e, n) {
  const o2 = t4.slice();
  return o2[8] = e[n][0], o2[9] = e[n][1], o2;
}
function create_each_block_3$1(t4) {
  let e, n;
  return e = new FeaturesSection({ props: { features: t4[9], title: t4[8], actor: t4[0] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    16 & n2 && (o2.features = t5[9]), 16 & n2 && (o2.title = t5[8]), 1 & n2 && (o2.actor = t5[0]), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_each_block_2$2(t4) {
  let e, n;
  return e = new FeaturesSection({ props: { features: t4[9], title: t4[8], actor: t4[0] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    8 & n2 && (o2.features = t5[9]), 8 & n2 && (o2.title = t5[8]), 1 & n2 && (o2.actor = t5[0]), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_each_block_1$4(t4) {
  let e, n;
  return e = new FeaturesSection({ props: { features: t4[9], title: t4[8], actor: t4[0] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    4 & n2 && (o2.features = t5[9]), 4 & n2 && (o2.title = t5[8]), 1 & n2 && (o2.actor = t5[0]), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_each_block$5(t4) {
  let e, n;
  return e = new FeaturesSection({ props: { features: t4[9], title: t4[8], actor: t4[0] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    2 & n2 && (o2.features = t5[9]), 2 & n2 && (o2.title = t5[8]), 1 & n2 && (o2.actor = t5[0]), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_fragment$z(t4) {
  let e, n, o2, i, a, r2, s2, c;
  n = new SearchBar({ props: { placeholder: "Search features..." } }), n.$on("search", t4[5]);
  let l = ensure_array_like([...t4[4].entries()]), u = [];
  for (let e2 = 0; e2 < l.length; e2 += 1) u[e2] = create_each_block_3$1(get_each_context_3$1(t4, l, e2));
  const p2 = (t5) => transition_out(u[t5], 1, 1, () => {
    u[t5] = null;
  });
  let d = ensure_array_like([...t4[3].entries()]), m = [];
  for (let e2 = 0; e2 < d.length; e2 += 1) m[e2] = create_each_block_2$2(get_each_context_2$2(t4, d, e2));
  const f = (t5) => transition_out(m[t5], 1, 1, () => {
    m[t5] = null;
  });
  let _ = ensure_array_like([...t4[2].entries()]), h = [];
  for (let e2 = 0; e2 < _.length; e2 += 1) h[e2] = create_each_block_1$4(get_each_context_1$4(t4, _, e2));
  const g2 = (t5) => transition_out(h[t5], 1, 1, () => {
    h[t5] = null;
  });
  let $2 = ensure_array_like([...t4[1].entries()]), b = [];
  for (let e2 = 0; e2 < $2.length; e2 += 1) b[e2] = create_each_block$5(get_each_context$5(t4, $2, e2));
  const y = (t5) => transition_out(b[t5], 1, 1, () => {
    b[t5] = null;
  });
  return { c() {
    e = element("section"), create_component(n.$$.fragment), o2 = space(), i = element("section");
    for (let t5 = 0; t5 < u.length; t5 += 1) u[t5].c();
    a = space();
    for (let t5 = 0; t5 < m.length; t5 += 1) m[t5].c();
    r2 = space();
    for (let t5 = 0; t5 < h.length; t5 += 1) h[t5].c();
    s2 = space();
    for (let t5 = 0; t5 < b.length; t5 += 1) b[t5].c();
    attr(i, "class", "content-scroll-list"), attr(e, "class", "category-content");
  }, m(t5, l2) {
    insert(t5, e, l2), mount_component(n, e, null), append(e, o2), append(e, i);
    for (let t6 = 0; t6 < u.length; t6 += 1) u[t6] && u[t6].m(i, null);
    append(i, a);
    for (let t6 = 0; t6 < m.length; t6 += 1) m[t6] && m[t6].m(i, null);
    append(i, r2);
    for (let t6 = 0; t6 < h.length; t6 += 1) h[t6] && h[t6].m(i, null);
    append(i, s2);
    for (let t6 = 0; t6 < b.length; t6 += 1) b[t6] && b[t6].m(i, null);
    c = true;
  }, p(t5, [e2]) {
    if (17 & e2) {
      let n2;
      for (l = ensure_array_like([...t5[4].entries()]), n2 = 0; n2 < l.length; n2 += 1) {
        const o3 = get_each_context_3$1(t5, l, n2);
        u[n2] ? (u[n2].p(o3, e2), transition_in(u[n2], 1)) : (u[n2] = create_each_block_3$1(o3), u[n2].c(), transition_in(u[n2], 1), u[n2].m(i, a));
      }
      for (group_outros(), n2 = l.length; n2 < u.length; n2 += 1) p2(n2);
      check_outros();
    }
    if (9 & e2) {
      let n2;
      for (d = ensure_array_like([...t5[3].entries()]), n2 = 0; n2 < d.length; n2 += 1) {
        const o3 = get_each_context_2$2(t5, d, n2);
        m[n2] ? (m[n2].p(o3, e2), transition_in(m[n2], 1)) : (m[n2] = create_each_block_2$2(o3), m[n2].c(), transition_in(m[n2], 1), m[n2].m(i, r2));
      }
      for (group_outros(), n2 = d.length; n2 < m.length; n2 += 1) f(n2);
      check_outros();
    }
    if (5 & e2) {
      let n2;
      for (_ = ensure_array_like([...t5[2].entries()]), n2 = 0; n2 < _.length; n2 += 1) {
        const o3 = get_each_context_1$4(t5, _, n2);
        h[n2] ? (h[n2].p(o3, e2), transition_in(h[n2], 1)) : (h[n2] = create_each_block_1$4(o3), h[n2].c(), transition_in(h[n2], 1), h[n2].m(i, s2));
      }
      for (group_outros(), n2 = _.length; n2 < h.length; n2 += 1) g2(n2);
      check_outros();
    }
    if (3 & e2) {
      let n2;
      for ($2 = ensure_array_like([...t5[1].entries()]), n2 = 0; n2 < $2.length; n2 += 1) {
        const o3 = get_each_context$5(t5, $2, n2);
        b[n2] ? (b[n2].p(o3, e2), transition_in(b[n2], 1)) : (b[n2] = create_each_block$5(o3), b[n2].c(), transition_in(b[n2], 1), b[n2].m(i, null));
      }
      for (group_outros(), n2 = $2.length; n2 < b.length; n2 += 1) y(n2);
      check_outros();
    }
  }, i(t5) {
    if (!c) {
      transition_in(n.$$.fragment, t5);
      for (let t6 = 0; t6 < l.length; t6 += 1) transition_in(u[t6]);
      for (let t6 = 0; t6 < d.length; t6 += 1) transition_in(m[t6]);
      for (let t6 = 0; t6 < _.length; t6 += 1) transition_in(h[t6]);
      for (let t6 = 0; t6 < $2.length; t6 += 1) transition_in(b[t6]);
      c = true;
    }
  }, o(t5) {
    transition_out(n.$$.fragment, t5), u = u.filter(Boolean);
    for (let t6 = 0; t6 < u.length; t6 += 1) transition_out(u[t6]);
    m = m.filter(Boolean);
    for (let t6 = 0; t6 < m.length; t6 += 1) transition_out(m[t6]);
    h = h.filter(Boolean);
    for (let t6 = 0; t6 < h.length; t6 += 1) transition_out(h[t6]);
    b = b.filter(Boolean);
    for (let t6 = 0; t6 < b.length; t6 += 1) transition_out(b[t6]);
    c = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(n), destroy_each(u, t5), destroy_each(m, t5), destroy_each(h, t5), destroy_each(b, t5);
  } };
}
function pushToFeaturesMap(t4, e, n) {
  var o2;
  return t4.has(e) ? null === (o2 = t4.get(e)) || void 0 === o2 || o2.push(n) : t4.set(e, [n]), t4;
}
function sortFeatures(t4) {
  return t4.forEach((t5, e) => {
    t5.sort((t6, e2) => t6.name.localeCompare(e2.name));
  }), t4;
}
function instance$y(t4, e, n) {
  let o2, i, a, r2, s2, { actor: c } = e;
  return t4.$$set = (t5) => {
    "actor" in t5 && n(0, c = t5.actor);
  }, t4.$$.update = () => {
    95 & t4.$$.dirty && (o2.clear(), i.clear(), a.clear(), r2.clear(), Object.keys(CONFIG.DND5E.featureTypes).forEach((t5) => {
      const e2 = t5;
      let n2 = c.itemTypes[e2];
      n2 && n2.forEach((t6) => {
        if (!t6.name.toLowerCase().includes(s2)) return;
        const e3 = function(t7) {
          var e4, n3, o3, i2, a2;
          const [r3] = null !== (n3 = null === (e4 = t7.getFlag("dnd5e", "advancementOrigin")) || void 0 === e4 ? void 0 : e4.split(".")) && void 0 !== n3 ? n3 : [], s3 = c.items.get(r3);
          let l = s3 ? s3.type : t7.type, u = s3 ? s3.name : t7.name;
          switch (l) {
            case "race":
              return { type: "race", label: null === (o3 = CONFIG.DND5E.featureTypes.race) || void 0 === o3 ? void 0 : o3.label };
            case "background":
              return { type: "background", label: null === (i2 = CONFIG.DND5E.featureTypes.background) || void 0 === i2 ? void 0 : i2.label };
            case "class":
              return { type: "class", label: i18nFormat("DND5E.FeaturesClass", { class: u }) };
            case "subclass":
              return (null === (a2 = null == s3 ? void 0 : s3.class) || void 0 === a2 ? void 0 : a2.name) ? { type: "class", label: i18nFormat("DND5E.FeaturesClass", { class: s3.class.name }) } : { type: "other", label: i18nFormat("DND5E.FeaturesClass", { class: "Other" }) };
            default:
              return { type: "other", label: i18nFormat("DND5E.FeaturesClass", { class: "Other" }) };
          }
        }(t6);
        switch (e3.type) {
          case "race":
            pushToFeaturesMap(i, e3.label, t6);
            break;
          case "background":
            pushToFeaturesMap(a, e3.label, t6);
            break;
          case "class":
            pushToFeaturesMap(o2, e3.label, t6);
            break;
          case "other":
            pushToFeaturesMap(r2, e3.label, t6);
        }
      });
    }), n(4, o2 = sortFeatures(o2)), n(3, i = sortFeatures(i)), n(2, a = sortFeatures(a)), n(1, r2 = sortFeatures(r2)));
  }, n(4, o2 = /* @__PURE__ */ new Map()), n(3, i = /* @__PURE__ */ new Map()), n(2, a = /* @__PURE__ */ new Map()), n(1, r2 = /* @__PURE__ */ new Map()), n(6, s2 = ""), [c, r2, a, i, o2, function(t5) {
    n(6, s2 = t5.detail);
  }, s2];
}
class Features extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$y, create_fragment$z, safe_not_equal, { actor: 0 });
  }
}
function create_if_block_2$5(t4) {
  let e;
  return { c() {
    e = text("+");
  }, m(t5, n) {
    insert(t5, e, n);
  }, d(t5) {
    t5 && detach(e);
  } };
}
function create_if_block$d(t4) {
  let e, n, o2, i, a, r2 = t4[0].save.value + "", s2 = t4[0].mod > 0 && create_if_block_1$9();
  return { c() {
    e = element("span"), n = element("i"), o2 = space(), i = element("span"), s2 && s2.c(), a = text(r2), attr(n, "class", "fas fa-shield svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1kw4awe"), attr(i, "class", "value svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1kw4awe"), attr(e, "class", "save svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1kw4awe");
  }, m(t5, r3) {
    insert(t5, e, r3), append(e, n), append(e, o2), append(e, i), s2 && s2.m(i, null), append(i, a);
  }, p(t5, e2) {
    t5[0].mod > 0 ? s2 || (s2 = create_if_block_1$9(), s2.c(), s2.m(i, a)) : s2 && (s2.d(1), s2 = null), 1 & e2 && r2 !== (r2 = t5[0].save.value + "") && set_data(a, r2);
  }, d(t5) {
    t5 && detach(e), s2 && s2.d();
  } };
}
function create_if_block_1$9(t4) {
  let e;
  return { c() {
    e = text("+");
  }, m(t5, n) {
    insert(t5, e, n);
  }, d(t5) {
    t5 && detach(e);
  } };
}
function create_fragment$y(t4) {
  let e, n, o2, i, a, r2, s2, c, l, u, p2, d, m, f, _ = t4[0].value + "", h = t4[0].mod + "", g2 = t4[0].name + "", $2 = t4[0].mod > 0 && create_if_block_2$5(), b = t4[0].mod !== t4[0].save.value && create_if_block$d(t4);
  return { c() {
    e = element("section"), n = element("div"), o2 = element("div"), i = element("div"), a = text(_), r2 = space(), s2 = element("div"), $2 && $2.c(), c = text(h), l = space(), u = element("span"), p2 = text(g2), d = space(), b && b.c(), attr(i, "class", "score svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1kw4awe"), attr(s2, "class", "mod svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1kw4awe"), attr(u, "class", "label svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1kw4awe"), attr(o2, "class", "ability-score svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1kw4awe"), attr(n, "class", "ability-score svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1kw4awe"), attr(e, "aria-hidden", "true"), attr(e, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1kw4awe"), toggle_class(e, "highlightAbility", t4[1]);
  }, m(_2, h2) {
    insert(_2, e, h2), append(e, n), append(n, o2), append(o2, i), append(i, a), append(o2, r2), append(o2, s2), $2 && $2.m(s2, null), append(s2, c), append(o2, l), append(o2, u), append(u, p2), append(n, d), b && b.m(n, null), m || (f = listen(e, "click", t4[2]), m = true);
  }, p(t5, [o3]) {
    1 & o3 && _ !== (_ = t5[0].value + "") && set_data(a, _), t5[0].mod > 0 ? $2 || ($2 = create_if_block_2$5(), $2.c(), $2.m(s2, c)) : $2 && ($2.d(1), $2 = null), 1 & o3 && h !== (h = t5[0].mod + "") && set_data(c, h), 1 & o3 && g2 !== (g2 = t5[0].name + "") && set_data(p2, g2), t5[0].mod !== t5[0].save.value ? b ? b.p(t5, o3) : (b = create_if_block$d(t5), b.c(), b.m(n, null)) : b && (b.d(1), b = null), 2 & o3 && toggle_class(e, "highlightAbility", t5[1]);
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e), $2 && $2.d(), b && b.d(), m = false, f();
  } };
}
function instance$x(t4, e, n) {
  let o2, { ability: i } = e, { isHighlight: a } = e;
  const r2 = createEventDispatcher();
  return t4.$$set = (t5) => {
    "ability" in t5 && n(0, i = t5.ability), "isHighlight" in t5 && n(3, a = t5.isHighlight);
  }, t4.$$.update = () => {
    8 & t4.$$.dirty && n(1, o2 = a);
  }, [i, o2, function() {
    r2("selectAbility", i);
  }, a];
}
class Ability extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$x, create_fragment$y, safe_not_equal, { ability: 0, isHighlight: 3 });
  }
}
function create_else_block$4(t4) {
  let e, n, o2 = t4[0].total + "";
  return { c() {
    e = element("div"), n = text(o2), attr(e, "class", "bonus svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1349zf3");
  }, m(t5, o3) {
    insert(t5, e, o3), append(e, n);
  }, p(t5, e2) {
    1 & e2 && o2 !== (o2 = t5[0].total + "") && set_data(n, o2);
  }, d(t5) {
    t5 && detach(e);
  } };
}
function create_if_block$c(t4) {
  let e, n, o2, i = t4[0].total + "";
  return { c() {
    e = element("div"), n = text("+"), o2 = text(i), attr(e, "class", "bonus svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1349zf3");
  }, m(t5, i2) {
    insert(t5, e, i2), append(e, n), append(e, o2);
  }, p(t5, e2) {
    1 & e2 && i !== (i = t5[0].total + "") && set_data(o2, i);
  }, d(t5) {
    t5 && detach(e);
  } };
}
function create_fragment$x(t4) {
  let e, n, o2, i, a, r2, s2, c, l, u = (t4[0].passive ?? "") + "";
  function p2(t5, e2) {
    return t5[0].total > 0 ? create_if_block$c : create_else_block$4;
  }
  let d = p2(t4), m = d(t4);
  return { c() {
    e = element("li"), n = element("div"), o2 = space(), i = element("span"), a = text(t4[2]), r2 = space(), m.c(), s2 = space(), c = element("div"), l = text(u), attr(n, "class", null_to_empty("proficiency " + t4[3]()) + " svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1349zf3"), attr(i, "class", "name rollable skill-name svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1349zf3"), attr(c, "class", "passive svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1349zf3"), attr(e, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1349zf3"), toggle_class(e, "isHighlight", t4[1]);
  }, m(t5, u2) {
    insert(t5, e, u2), append(e, n), append(e, o2), append(e, i), append(i, a), append(e, r2), m.m(e, null), append(e, s2), append(e, c), append(c, l);
  }, p(t5, [n2]) {
    4 & n2 && set_data(a, t5[2]), d === (d = p2(t5)) && m ? m.p(t5, n2) : (m.d(1), m = d(t5), m && (m.c(), m.m(e, s2))), 1 & n2 && u !== (u = (t5[0].passive ?? "") + "") && set_data(l, u), 2 & n2 && toggle_class(e, "isHighlight", t5[1]);
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e), m.d();
  } };
}
function instance$w(t4, e, n) {
  var o2 = this && this.__awaiter || function(t5, e2, n2, o3) {
    return new (n2 || (n2 = Promise))(function(i2, a2) {
      function r3(t6) {
        try {
          c(o3.next(t6));
        } catch (t7) {
          a2(t7);
        }
      }
      function s2(t6) {
        try {
          c(o3.throw(t6));
        } catch (t7) {
          a2(t7);
        }
      }
      function c(t6) {
        var e3;
        t6.done ? i2(t6.value) : (e3 = t6.value, e3 instanceof n2 ? e3 : new n2(function(t7) {
          t7(e3);
        })).then(r3, s2);
      }
      c((o3 = o3.apply(t5, e2 || [])).next());
    });
  };
  let i, { skill: a } = e, { isHighlight: r2 } = e;
  return t4.$$set = (t5) => {
    "skill" in t5 && n(0, a = t5.skill), "isHighlight" in t5 && n(1, r2 = t5.isHighlight);
  }, t4.$$.update = () => {
    1 & t4.$$.dirty && (CONFIG.DND5E.skills[a.name] ? n(2, i = CONFIG.DND5E.skills[a.name].label) : function() {
      o2(this, void 0, void 0, function* () {
        if (CONFIG.DND5E.tools[a.name]) {
          const t5 = CONFIG.DND5E.tools[a.name].id;
          fromUuid(t5).then((t6) => n(2, i = t6.name));
        } else switch (a.name) {
          case "land":
            n(2, i = i18n("DND5E.VehicleTypeLand"));
            break;
          case "water":
            n(2, i = i18n("DND5E.VehicleTypeWater"));
            break;
          case "space":
            n(2, i = i18n("DND5E.VehicleTypeSpace"));
            break;
          case "air":
            n(2, i = i18n("DND5E.VehicleTypeAir"));
            break;
          case "art":
            n(2, i = i18n("DND5E.ToolArtisans"));
            break;
          case "game":
            n(2, i = i18n("DND5E.ToolGamingSet"));
            break;
          case "music":
            n(2, i = i18n("DND5E.ToolMusicalInstrument"));
            break;
          case "vehicle":
            n(2, i = i18n("DND5E.ToolVehicle"));
        }
      });
    }());
  }, [a, r2, i, function() {
    switch (a.value) {
      case 0.5:
        return "half";
      case 1:
        return "full";
      case 2:
        return "expert";
      default:
        return "";
    }
  }];
}
class Skill extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$w, create_fragment$x, safe_not_equal, { skill: 0, isHighlight: 1 });
  }
}
function get_each_context$4(t4, e, n) {
  const o2 = t4.slice();
  return o2[7] = e[n], o2;
}
function get_each_context_1$3(t4, e, n) {
  const o2 = t4.slice();
  return o2[10] = e[n], o2;
}
function get_each_context_2$1(t4, e, n) {
  const o2 = t4.slice();
  return o2[7] = e[n], o2;
}
function get_each_context_3(t4, e, n) {
  const o2 = t4.slice();
  return o2[10] = e[n], o2;
}
function create_each_block_3(t4) {
  let e, n;
  return e = new Skill({ props: { skill: t4[10], isHighlight: t4[2](t4[10]) } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    1 & n2 && (o2.skill = t5[10]), 1 & n2 && (o2.isHighlight = t5[2](t5[10])), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_each_block_2$1(t4) {
  let e, n, o2, i = ensure_array_like(t4[7]), a = [];
  for (let e2 = 0; e2 < i.length; e2 += 1) a[e2] = create_each_block_3(get_each_context_3(t4, i, e2));
  const r2 = (t5) => transition_out(a[t5], 1, 1, () => {
    a[t5] = null;
  });
  return { c() {
    e = element("ul");
    for (let t5 = 0; t5 < a.length; t5 += 1) a[t5].c();
    n = space(), attr(e, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-kmua2z");
  }, m(t5, i2) {
    insert(t5, e, i2);
    for (let t6 = 0; t6 < a.length; t6 += 1) a[t6] && a[t6].m(e, null);
    append(e, n), o2 = true;
  }, p(t5, o3) {
    if (5 & o3) {
      let s2;
      for (i = ensure_array_like(t5[7]), s2 = 0; s2 < i.length; s2 += 1) {
        const r3 = get_each_context_3(t5, i, s2);
        a[s2] ? (a[s2].p(r3, o3), transition_in(a[s2], 1)) : (a[s2] = create_each_block_3(r3), a[s2].c(), transition_in(a[s2], 1), a[s2].m(e, n));
      }
      for (group_outros(), s2 = i.length; s2 < a.length; s2 += 1) r2(s2);
      check_outros();
    }
  }, i(t5) {
    if (!o2) {
      for (let t6 = 0; t6 < i.length; t6 += 1) transition_in(a[t6]);
      o2 = true;
    }
  }, o(t5) {
    a = a.filter(Boolean);
    for (let t6 = 0; t6 < a.length; t6 += 1) transition_out(a[t6]);
    o2 = false;
  }, d(t5) {
    t5 && detach(e), destroy_each(a, t5);
  } };
}
function create_each_block_1$3(t4) {
  let e, n;
  return e = new Skill({ props: { skill: t4[10], isHighlight: t4[2](t4[10]) } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    2 & n2 && (o2.skill = t5[10]), 2 & n2 && (o2.isHighlight = t5[2](t5[10])), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_each_block$4(t4) {
  let e, n, o2, i = ensure_array_like(t4[7]), a = [];
  for (let e2 = 0; e2 < i.length; e2 += 1) a[e2] = create_each_block_1$3(get_each_context_1$3(t4, i, e2));
  const r2 = (t5) => transition_out(a[t5], 1, 1, () => {
    a[t5] = null;
  });
  return { c() {
    e = element("ul");
    for (let t5 = 0; t5 < a.length; t5 += 1) a[t5].c();
    n = space(), attr(e, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-kmua2z");
  }, m(t5, i2) {
    insert(t5, e, i2);
    for (let t6 = 0; t6 < a.length; t6 += 1) a[t6] && a[t6].m(e, null);
    append(e, n), o2 = true;
  }, p(t5, o3) {
    if (6 & o3) {
      let s2;
      for (i = ensure_array_like(t5[7]), s2 = 0; s2 < i.length; s2 += 1) {
        const r3 = get_each_context_1$3(t5, i, s2);
        a[s2] ? (a[s2].p(r3, o3), transition_in(a[s2], 1)) : (a[s2] = create_each_block_1$3(r3), a[s2].c(), transition_in(a[s2], 1), a[s2].m(e, n));
      }
      for (group_outros(), s2 = i.length; s2 < a.length; s2 += 1) r2(s2);
      check_outros();
    }
  }, i(t5) {
    if (!o2) {
      for (let t6 = 0; t6 < i.length; t6 += 1) transition_in(a[t6]);
      o2 = true;
    }
  }, o(t5) {
    a = a.filter(Boolean);
    for (let t6 = 0; t6 < a.length; t6 += 1) transition_out(a[t6]);
    o2 = false;
  }, d(t5) {
    t5 && detach(e), destroy_each(a, t5);
  } };
}
function create_fragment$w(t4) {
  let e, n, o2, i, a, r2, s2, c, l, u, p2, d = ensure_array_like(t4[0]), m = [];
  for (let e2 = 0; e2 < d.length; e2 += 1) m[e2] = create_each_block_2$1(get_each_context_2$1(t4, d, e2));
  const f = (t5) => transition_out(m[t5], 1, 1, () => {
    m[t5] = null;
  });
  let _ = ensure_array_like(t4[1]), h = [];
  for (let e2 = 0; e2 < _.length; e2 += 1) h[e2] = create_each_block$4(get_each_context$4(t4, _, e2));
  const g2 = (t5) => transition_out(h[t5], 1, 1, () => {
    h[t5] = null;
  });
  return { c() {
    e = element("filigree-box"), n = element("span"), o2 = element("h3"), o2.textContent = `${i18n("DND5E.Skills")}`, i = space(), a = element("div");
    for (let t5 = 0; t5 < m.length; t5 += 1) m[t5].c();
    r2 = space(), s2 = element("span"), c = element("h3"), c.textContent = `${i18n("TYPES.Item.toolPl")}`, l = space(), u = element("div");
    for (let t5 = 0; t5 < h.length; t5 += 1) h[t5].c();
    attr(o2, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-kmua2z"), attr(n, "class", "roboto-upper"), attr(a, "class", "skills svelte-mobile-companion-dnd5e-81nkluj30u9vsd-kmua2z"), attr(c, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-kmua2z"), attr(s2, "class", "roboto-upper"), attr(u, "class", "skills svelte-mobile-companion-dnd5e-81nkluj30u9vsd-kmua2z"), set_custom_element_data(e, "class", "skill-container svelte-mobile-companion-dnd5e-81nkluj30u9vsd-kmua2z");
  }, m(t5, d2) {
    insert(t5, e, d2), append(e, n), append(n, o2), append(e, i), append(e, a);
    for (let t6 = 0; t6 < m.length; t6 += 1) m[t6] && m[t6].m(a, null);
    append(e, r2), append(e, s2), append(s2, c), append(e, l), append(e, u);
    for (let t6 = 0; t6 < h.length; t6 += 1) h[t6] && h[t6].m(u, null);
    p2 = true;
  }, p(t5, [e2]) {
    if (5 & e2) {
      let n2;
      for (d = ensure_array_like(t5[0]), n2 = 0; n2 < d.length; n2 += 1) {
        const o3 = get_each_context_2$1(t5, d, n2);
        m[n2] ? (m[n2].p(o3, e2), transition_in(m[n2], 1)) : (m[n2] = create_each_block_2$1(o3), m[n2].c(), transition_in(m[n2], 1), m[n2].m(a, null));
      }
      for (group_outros(), n2 = d.length; n2 < m.length; n2 += 1) f(n2);
      check_outros();
    }
    if (6 & e2) {
      let n2;
      for (_ = ensure_array_like(t5[1]), n2 = 0; n2 < _.length; n2 += 1) {
        const o3 = get_each_context$4(t5, _, n2);
        h[n2] ? (h[n2].p(o3, e2), transition_in(h[n2], 1)) : (h[n2] = create_each_block$4(o3), h[n2].c(), transition_in(h[n2], 1), h[n2].m(u, null));
      }
      for (group_outros(), n2 = _.length; n2 < h.length; n2 += 1) g2(n2);
      check_outros();
    }
  }, i(t5) {
    if (!p2) {
      for (let t6 = 0; t6 < d.length; t6 += 1) transition_in(m[t6]);
      for (let t6 = 0; t6 < _.length; t6 += 1) transition_in(h[t6]);
      p2 = true;
    }
  }, o(t5) {
    m = m.filter(Boolean);
    for (let t6 = 0; t6 < m.length; t6 += 1) transition_out(m[t6]);
    h = h.filter(Boolean);
    for (let t6 = 0; t6 < h.length; t6 += 1) transition_out(h[t6]);
    p2 = false;
  }, d(t5) {
    t5 && detach(e), destroy_each(m, t5), destroy_each(h, t5);
  } };
}
function instance$v(t4, e, n) {
  let { characterData: o2 } = e, { highlightedSkillAttributes: i } = e, a = [], r2 = [];
  return t4.$$set = (t5) => {
    "characterData" in t5 && n(3, o2 = t5.characterData), "highlightedSkillAttributes" in t5 && n(4, i = t5.highlightedSkillAttributes);
  }, t4.$$.update = () => {
    16 & t4.$$.dirty && i && (function() {
      n(0, a = []);
      const t5 = Object.keys(o2.skills).map((t6) => {
        const e2 = o2.skills[t6];
        return e2.name = t6, e2;
      });
      a.push(t5.slice(0, 9)), a.push(t5.slice(9, 18));
    }(), function() {
      n(1, r2 = []);
      const t5 = Object.keys(o2.tools).map((t6) => {
        const e3 = o2.tools[t6];
        return e3.name = t6, e3;
      }), e2 = Math.ceil(t5.length / 2);
      r2.push(t5.slice(0, e2)), r2.push(t5.slice(e2, t5.length));
    }());
  }, [a, r2, function(t5) {
    return 0 === i.length || i.includes(t5.ability);
  }, o2, i];
}
class Skills extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$v, create_fragment$w, safe_not_equal, { characterData: 3, highlightedSkillAttributes: 4 });
  }
}
function get_each_context$3(t4, e, n) {
  const o2 = t4.slice();
  return o2[10] = e[n], o2;
}
function get_each_context_1$2(t4, e, n) {
  const o2 = t4.slice();
  return o2[13] = e[n], o2;
}
function create_each_block_1$2(t4) {
  let e, n;
  return e = new Ability({ props: { ability: t4[13], isHighlight: t4[1].includes(t4[13].name) } }), e.$on("selectAbility", t4[4]), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    1 & n2 && (o2.ability = t5[13]), 3 & n2 && (o2.isHighlight = t5[1].includes(t5[13].name)), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_each_block$3(t4) {
  let e, n, o2, i = ensure_array_like(t4[10]), a = [];
  for (let e2 = 0; e2 < i.length; e2 += 1) a[e2] = create_each_block_1$2(get_each_context_1$2(t4, i, e2));
  const r2 = (t5) => transition_out(a[t5], 1, 1, () => {
    a[t5] = null;
  });
  return { c() {
    e = element("div");
    for (let t5 = 0; t5 < a.length; t5 += 1) a[t5].c();
    n = space(), attr(e, "class", "ability-score-container-row svelte-mobile-companion-dnd5e-81nkluj30u9vsd-10t0y9b");
  }, m(t5, i2) {
    insert(t5, e, i2);
    for (let t6 = 0; t6 < a.length; t6 += 1) a[t6] && a[t6].m(e, null);
    append(e, n), o2 = true;
  }, p(t5, o3) {
    if (19 & o3) {
      let s2;
      for (i = ensure_array_like(t5[10]), s2 = 0; s2 < i.length; s2 += 1) {
        const r3 = get_each_context_1$2(t5, i, s2);
        a[s2] ? (a[s2].p(r3, o3), transition_in(a[s2], 1)) : (a[s2] = create_each_block_1$2(r3), a[s2].c(), transition_in(a[s2], 1), a[s2].m(e, n));
      }
      for (group_outros(), s2 = i.length; s2 < a.length; s2 += 1) r2(s2);
      check_outros();
    }
  }, i(t5) {
    if (!o2) {
      for (let t6 = 0; t6 < i.length; t6 += 1) transition_in(a[t6]);
      o2 = true;
    }
  }, o(t5) {
    a = a.filter(Boolean);
    for (let t6 = 0; t6 < a.length; t6 += 1) transition_out(a[t6]);
    o2 = false;
  }, d(t5) {
    t5 && detach(e), destroy_each(a, t5);
  } };
}
function create_fragment$v(t4) {
  let e, n, o2, i, a, r2, s2 = ensure_array_like(t4[0]), c = [];
  for (let e2 = 0; e2 < s2.length; e2 += 1) c[e2] = create_each_block$3(get_each_context$3(t4, s2, e2));
  const l = (t5) => transition_out(c[t5], 1, 1, () => {
    c[t5] = null;
  });
  return a = new Skills({ props: { characterData: t4[2], highlightedSkillAttributes: t4[1] } }), { c() {
    e = element("section"), n = element("div");
    for (let t5 = 0; t5 < c.length; t5 += 1) c[t5].c();
    o2 = space(), i = element("section"), create_component(a.$$.fragment), attr(n, "class", "ability-score-container svelte-mobile-companion-dnd5e-81nkluj30u9vsd-10t0y9b"), attr(i, "class", "content-scroll-list"), attr(e, "class", "category-content");
  }, m(t5, s3) {
    insert(t5, e, s3), append(e, n);
    for (let t6 = 0; t6 < c.length; t6 += 1) c[t6] && c[t6].m(n, null);
    append(e, o2), append(e, i), mount_component(a, i, null), r2 = true;
  }, p(t5, [e2]) {
    if (19 & e2) {
      let o4;
      for (s2 = ensure_array_like(t5[0]), o4 = 0; o4 < s2.length; o4 += 1) {
        const i2 = get_each_context$3(t5, s2, o4);
        c[o4] ? (c[o4].p(i2, e2), transition_in(c[o4], 1)) : (c[o4] = create_each_block$3(i2), c[o4].c(), transition_in(c[o4], 1), c[o4].m(n, null));
      }
      for (group_outros(), o4 = s2.length; o4 < c.length; o4 += 1) l(o4);
      check_outros();
    }
    const o3 = {};
    2 & e2 && (o3.highlightedSkillAttributes = t5[1]), a.$set(o3);
  }, i(t5) {
    if (!r2) {
      for (let t6 = 0; t6 < s2.length; t6 += 1) transition_in(c[t6]);
      transition_in(a.$$.fragment, t5), r2 = true;
    }
  }, o(t5) {
    c = c.filter(Boolean);
    for (let t6 = 0; t6 < c.length; t6 += 1) transition_out(c[t6]);
    transition_out(a.$$.fragment, t5), r2 = false;
  }, d(t5) {
    t5 && detach(e), destroy_each(c, t5), destroy_component(a);
  } };
}
function instance$u(t4, e, n) {
  let o2, { actor: i } = e, a = i.system;
  const r2 = getContext(CONTEXT.INNER_APP_WIDTH_STORE);
  component_subscribe(t4, r2, (t5) => n(6, o2 = t5));
  const s2 = Object.keys(a.abilities).map((t5) => {
    const e2 = a.abilities[t5];
    return e2.name = t5, e2;
  });
  let c = [];
  function l() {
    const t5 = o2.width;
    let e2;
    e2 = t5 >= 600 ? 6 : t5 >= 300 ? 3 : 2, n(0, c = []);
    for (let t6 = 0; t6 < s2.length; t6 += e2) c.push(s2.slice(t6, t6 + e2));
  }
  let u = [];
  const p2 = r2.subscribe((t5) => {
    l();
  });
  return onMount(() => (l(), () => {
    p2();
  })), t4.$$set = (t5) => {
    "actor" in t5 && n(5, i = t5.actor);
  }, [c, u, a, r2, function(t5) {
    if (!t5.detail) return;
    const e2 = t5.detail.name;
    u.includes(e2) ? n(1, u = u.filter((t6) => t6 !== e2)) : n(1, u = [...u, e2]);
  }, i];
}
class Abilities extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$u, create_fragment$v, safe_not_equal, { actor: 5 });
  }
}
function create_if_block_1$8(t4) {
  let e, n, o2;
  return n = new NumberInputWithButtons({ props: { title: myi18n("ModifyHp"), currentValue: t4[0].attributes.hp.value } }), n.$on("action", t4[6]), n.$on("close", t4[5]), { c() {
    e = element("div"), create_component(n.$$.fragment);
  }, m(t5, i) {
    insert(t5, e, i), mount_component(n, e, null), o2 = true;
  }, p(t5, e2) {
    const o3 = {};
    1 & e2 && (o3.currentValue = t5[0].attributes.hp.value), n.$set(o3);
  }, i(t5) {
    o2 || (transition_in(n.$$.fragment, t5), o2 = true);
  }, o(t5) {
    transition_out(n.$$.fragment, t5), o2 = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(n);
  } };
}
function create_if_block$b(t4) {
  let e, n, o2;
  return n = new NumberInputWithButtons({ props: { title: myi18n("ModifyTempHp"), currentValue: t4[0].attributes.hp.temp } }), n.$on("action", t4[7]), n.$on("close", t4[5]), { c() {
    e = element("div"), create_component(n.$$.fragment);
  }, m(t5, i) {
    insert(t5, e, i), mount_component(n, e, null), o2 = true;
  }, p(t5, e2) {
    const o3 = {};
    1 & e2 && (o3.currentValue = t5[0].attributes.hp.temp), n.$set(o3);
  }, i(t5) {
    o2 || (transition_in(n.$$.fragment, t5), o2 = true);
  }, o(t5) {
    transition_out(n.$$.fragment, t5), o2 = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(n);
  } };
}
function create_fragment$u(t4) {
  let e, n, o2, i, a, r2, s2, c, l, u, p2, d, m, f, _, h, g2, $2, b, y, v, k, w2, S2 = t4[0].attributes.hp.value + "", T = t4[0].attributes.hp.effectiveMax + "", x2 = (t4[0].attributes.hp.temp && 0 !== t4[0].attributes.hp.temp ? t4[0].attributes.hp.temp : "TMP") + "", E = t4[1] && create_if_block_1$8(t4), O = t4[2] && create_if_block$b(t4);
  return { c() {
    e = element("div"), n = element("div"), o2 = element("span"), o2.textContent = `${i18n("DND5E.HitPoints")}`, i = space(), a = element("div"), r2 = element("div"), s2 = element("div"), c = element("span"), l = text(S2), u = space(), p2 = element("span"), p2.textContent = "/", d = space(), m = element("span"), f = text(T), _ = space(), h = element("div"), g2 = text(x2), $2 = space(), E && E.c(), b = space(), O && O.c(), y = empty(), attr(n, "class", "label roboto-condensed-upper svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1px261h"), attr(c, "class", "value svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1px261h"), attr(p2, "class", "separator svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1px261h"), attr(m, "class", "max svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1px261h"), attr(s2, "class", "label svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1px261h"), attr(r2, "class", "progress svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1px261h"), set_style(r2, "--bar-percentage", t4[0].attributes.hp.pct + "%"), attr(r2, "aria-hidden", "true"), attr(h, "class", "tmp svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1px261h"), attr(h, "aria-hidden", "true"), toggle_class(h, "value", t4[0].attributes.hp.temp), attr(a, "class", "meter svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1px261h"), attr(e, "class", "meter-group svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1px261h");
  }, m(S3, T2) {
    insert(S3, e, T2), append(e, n), append(n, o2), append(e, i), append(e, a), append(a, r2), append(r2, s2), append(s2, c), append(c, l), append(s2, u), append(s2, p2), append(s2, d), append(s2, m), append(m, f), append(a, _), append(a, h), append(h, g2), insert(S3, $2, T2), E && E.m(S3, T2), insert(S3, b, T2), O && O.m(S3, T2), insert(S3, y, T2), v = true, k || (w2 = [listen(r2, "click", stop_propagation(t4[8])), listen(h, "click", stop_propagation(t4[9]))], k = true);
  }, p(t5, [e2]) {
    (!v || 1 & e2) && S2 !== (S2 = t5[0].attributes.hp.value + "") && set_data(l, S2), (!v || 1 & e2) && T !== (T = t5[0].attributes.hp.effectiveMax + "") && set_data(f, T), (!v || 1 & e2) && set_style(r2, "--bar-percentage", t5[0].attributes.hp.pct + "%"), (!v || 1 & e2) && x2 !== (x2 = (t5[0].attributes.hp.temp && 0 !== t5[0].attributes.hp.temp ? t5[0].attributes.hp.temp : "TMP") + "") && set_data(g2, x2), (!v || 1 & e2) && toggle_class(h, "value", t5[0].attributes.hp.temp), t5[1] ? E ? (E.p(t5, e2), 2 & e2 && transition_in(E, 1)) : (E = create_if_block_1$8(t5), E.c(), transition_in(E, 1), E.m(b.parentNode, b)) : E && (group_outros(), transition_out(E, 1, 1, () => {
      E = null;
    }), check_outros()), t5[2] ? O ? (O.p(t5, e2), 4 & e2 && transition_in(O, 1)) : (O = create_if_block$b(t5), O.c(), transition_in(O, 1), O.m(y.parentNode, y)) : O && (group_outros(), transition_out(O, 1, 1, () => {
      O = null;
    }), check_outros());
  }, i(t5) {
    v || (transition_in(E), transition_in(O), v = true);
  }, o(t5) {
    transition_out(E), transition_out(O), v = false;
  }, d(t5) {
    t5 && (detach(e), detach($2), detach(b), detach(y)), E && E.d(t5), O && O.d(t5), k = false, run_all(w2);
  } };
}
function instance$t(t4, e, n) {
  let o2, { actorData: i } = e;
  const a = getContext(CONTEXT.ACTOR_STORE);
  component_subscribe(t4, a, (t5) => n(10, o2 = t5));
  let r2 = false, s2 = false;
  function c(t5) {
    isReadOnlyActor(o2) || ("hp" === t5 ? n(1, r2 = true) : n(2, s2 = true));
  }
  function l() {
    n(1, r2 = false), n(2, s2 = false);
  }
  return t4.$$set = (t5) => {
    "actorData" in t5 && n(0, i = t5.actorData);
  }, [i, r2, s2, a, c, l, function(t5) {
    const e2 = t5.detail.action, n2 = t5.detail.value;
    let o3 = i.attributes.hp.value;
    "add" === e2 ? o3 += n2 : o3 = n2;
    const a2 = {};
    a2["system.attributes.hp.value"] = o3, FoundryGateway.updateActor(i.parent, a2), l();
  }, function(t5) {
    var e2;
    const n2 = t5.detail.action, o3 = t5.detail.value;
    let a2 = null !== (e2 = i.attributes.hp.temp) && void 0 !== e2 ? e2 : 0;
    "add" === n2 ? a2 += o3 : a2 = o3;
    const r3 = {};
    r3["system.attributes.hp.temp"] = a2, FoundryGateway.updateActor(i.parent, r3), l();
  }, () => c("hp"), () => c("temp")];
}
class CharacterHitPoints extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$t, create_fragment$u, safe_not_equal, { actorData: 0 });
  }
}
function create_fragment$t(t4) {
  let e, n, o2, i, a, r2, s2, c, l, u, p2, d, m, f = t4[0].attributes.hd.value + "", _ = t4[0].attributes.hd.max + "";
  return { c() {
    e = element("div"), n = element("div"), o2 = element("span"), o2.textContent = `${i18n("DND5E.HitDice")}`, i = space(), a = element("div"), r2 = element("div"), s2 = element("span"), c = text(f), l = space(), u = element("span"), u.textContent = "/", p2 = space(), d = element("span"), m = text(_), attr(n, "class", "label roboto-condensed-upper svelte-mobile-companion-dnd5e-81nkluj30u9vsd-11cb1zg"), attr(s2, "class", "value"), attr(u, "class", "separator"), attr(d, "class", "max"), attr(r2, "class", "label svelte-mobile-companion-dnd5e-81nkluj30u9vsd-11cb1zg"), attr(a, "class", "progress svelte-mobile-companion-dnd5e-81nkluj30u9vsd-11cb1zg"), set_style(a, "--bar-percentage", t4[0].attributes.hd.pct + "%"), attr(e, "class", "meter-group svelte-mobile-companion-dnd5e-81nkluj30u9vsd-11cb1zg");
  }, m(t5, f2) {
    insert(t5, e, f2), append(e, n), append(n, o2), append(e, i), append(e, a), append(a, r2), append(r2, s2), append(s2, c), append(r2, l), append(r2, u), append(r2, p2), append(r2, d), append(d, m);
  }, p(t5, [e2]) {
    1 & e2 && f !== (f = t5[0].attributes.hd.value + "") && set_data(c, f), 1 & e2 && _ !== (_ = t5[0].attributes.hd.max + "") && set_data(m, _), 1 & e2 && set_style(a, "--bar-percentage", t5[0].attributes.hd.pct + "%");
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e);
  } };
}
function instance$s(t4, e, n) {
  let { actorData: o2 } = e;
  return t4.$$set = (t5) => {
    "actorData" in t5 && n(0, o2 = t5.actorData);
  }, [o2];
}
class CharacterHitDice extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$s, create_fragment$t, safe_not_equal, { actorData: 0 });
  }
}
function get_each_context$2(t4, e, n) {
  const o2 = t4.slice();
  return o2[8] = e[n], o2;
}
function get_each_context_1$1(t4, e, n) {
  const o2 = t4.slice();
  return o2[8] = e[n], o2;
}
function create_each_block_1$1(t4, e) {
  let n, o2, i;
  function a() {
    return e[6](e[8]);
  }
  return { key: t4, first: null, c() {
    n = element("button"), attr(n, "type", "button"), attr(n, "class", "pip svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1bs1rx5"), toggle_class(n, "filled", e[8] <= e[2]), toggle_class(n, "death", 6 === e[2] && 6 === e[8]), this.first = n;
  }, m(t5, e2) {
    insert(t5, n, e2), o2 || (i = listen(n, "click", a), o2 = true);
  }, p(t5, o3) {
    e = t5, 5 & o3 && toggle_class(n, "filled", e[8] <= e[2]), 5 & o3 && toggle_class(n, "death", 6 === e[2] && 6 === e[8]);
  }, d(t5) {
    t5 && detach(n), o2 = false, i();
  } };
}
function create_each_block$2(t4, e) {
  let n, o2, i;
  function a() {
    return e[7](e[8]);
  }
  return { key: t4, first: null, c() {
    n = element("button"), attr(n, "type", "button"), attr(n, "class", "pip svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1bs1rx5"), toggle_class(n, "filled", e[8] <= e[2]), toggle_class(n, "death", 6 === e[2] && 6 === e[8]), this.first = n;
  }, m(t5, e2) {
    insert(t5, n, e2), o2 || (i = listen(n, "click", a), o2 = true);
  }, p(t5, o3) {
    e = t5, 6 & o3 && toggle_class(n, "filled", e[8] <= e[2]), 6 & o3 && toggle_class(n, "death", 6 === e[2] && 6 === e[8]);
  }, d(t5) {
    t5 && detach(n), o2 = false, i();
  } };
}
function create_fragment$s(t4) {
  let e, n, o2, i, a, r2, s2, c = [], l = /* @__PURE__ */ new Map(), u = [], p2 = /* @__PURE__ */ new Map(), d = ensure_array_like(t4[0]);
  const m = (t5) => t5[8];
  for (let e2 = 0; e2 < d.length; e2 += 1) {
    let n2 = get_each_context_1$1(t4, d, e2), o3 = m(n2);
    l.set(o3, c[e2] = create_each_block_1$1(o3, n2));
  }
  let f = ensure_array_like(t4[1]);
  const _ = (t5) => t5[8];
  for (let e2 = 0; e2 < f.length; e2 += 1) {
    let n2 = get_each_context$2(t4, f, e2), o3 = _(n2);
    p2.set(o3, u[e2] = create_each_block$2(o3, n2));
  }
  return { c() {
    e = element("div"), n = element("div"), n.textContent = `${i18n("DND5E.Exhaustion")}`, o2 = space(), i = element("div"), a = element("div");
    for (let t5 = 0; t5 < c.length; t5 += 1) c[t5].c();
    r2 = space(), s2 = element("div");
    for (let t5 = 0; t5 < u.length; t5 += 1) u[t5].c();
    attr(n, "class", "label roboto-condensed-upper svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1bs1rx5"), attr(a, "class", "pips-row svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1bs1rx5"), attr(s2, "class", "pips-row svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1bs1rx5"), attr(i, "class", "pips svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1bs1rx5"), attr(e, "class", "exhaustion svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1bs1rx5");
  }, m(t5, l2) {
    insert(t5, e, l2), append(e, n), append(e, o2), append(e, i), append(i, a);
    for (let t6 = 0; t6 < c.length; t6 += 1) c[t6] && c[t6].m(a, null);
    append(i, r2), append(i, s2);
    for (let t6 = 0; t6 < u.length; t6 += 1) u[t6] && u[t6].m(s2, null);
  }, p(t5, [e2]) {
    13 & e2 && (d = ensure_array_like(t5[0]), c = update_keyed_each(c, e2, m, 1, t5, d, l, a, destroy_block, create_each_block_1$1, null, get_each_context_1$1)), 14 & e2 && (f = ensure_array_like(t5[1]), u = update_keyed_each(u, e2, _, 1, t5, f, p2, s2, destroy_block, create_each_block$2, null, get_each_context$2));
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e);
    for (let t6 = 0; t6 < c.length; t6 += 1) c[t6].d();
    for (let t6 = 0; t6 < u.length; t6 += 1) u[t6].d();
  } };
}
function instance$r(t4, e, n) {
  let o2, { actor: i } = e, a = [], r2 = [], s2 = 0;
  function c(t5) {
    const e2 = {};
    let n2 = t5;
    t5 === s2 && (n2 = t5 - 1), e2["system.attributes.exhaustion"] = n2, FoundryGateway.updateActor(i, e2);
  }
  return t4.$$set = (t5) => {
    "actor" in t5 && n(4, i = t5.actor);
  }, t4.$$.update = () => {
    16 & t4.$$.dirty && n(5, o2 = i.system), 32 & t4.$$.dirty && (n(0, a = Array.from({ length: 3 }, (t5, e2) => e2 + 1)), n(1, r2 = Array.from({ length: 3 }, (t5, e2) => e2 + 3 + 1)), n(2, s2 = o2.attributes.exhaustion));
  }, [a, r2, s2, c, i, o2, (t5) => c(t5), (t5) => c(t5)];
}
class CharacterExhaustion extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$r, create_fragment$s, safe_not_equal, { actor: 4 });
  }
}
function create_fragment$r(t4) {
  let e, n, o2, i, a, r2, s2, c, l, u, p2, d, m, f, _, h, g2, $2 = t4[0].attributes.movement.walk + "";
  return { c() {
    e = element("div"), n = element("div"), o2 = element("div"), i = element("span"), i.textContent = `${t4[1]()}`, a = space(), r2 = element("div"), r2.textContent = `${i18n("DND5E.Initiative")}`, s2 = space(), c = element("div"), l = element("div"), u = text($2), p2 = space(), d = element("div"), d.textContent = `${i18n("DND5E.MovementWalk")}`, m = space(), f = element("div"), _ = element("div"), _.textContent = `${t4[2]()}`, h = space(), g2 = element("div"), g2.textContent = `${i18n("DND5E.Proficiency")}`, attr(o2, "class", "value svelte-mobile-companion-dnd5e-81nkluj30u9vsd-38ky5n"), attr(r2, "class", "label roboto-condensed-upper svelte-mobile-companion-dnd5e-81nkluj30u9vsd-38ky5n"), attr(n, "class", "lozenge svelte-mobile-companion-dnd5e-81nkluj30u9vsd-38ky5n"), attr(l, "class", "value svelte-mobile-companion-dnd5e-81nkluj30u9vsd-38ky5n"), attr(d, "class", "label roboto-condensed-upper svelte-mobile-companion-dnd5e-81nkluj30u9vsd-38ky5n"), attr(c, "class", "lozenge svelte-mobile-companion-dnd5e-81nkluj30u9vsd-38ky5n"), attr(_, "class", "value svelte-mobile-companion-dnd5e-81nkluj30u9vsd-38ky5n"), attr(g2, "class", "label roboto-condensed-upper svelte-mobile-companion-dnd5e-81nkluj30u9vsd-38ky5n"), attr(f, "class", "lozenge svelte-mobile-companion-dnd5e-81nkluj30u9vsd-38ky5n"), attr(e, "class", "lozenges svelte-mobile-companion-dnd5e-81nkluj30u9vsd-38ky5n");
  }, m(t5, $3) {
    insert(t5, e, $3), append(e, n), append(n, o2), append(o2, i), append(n, a), append(n, r2), append(e, s2), append(e, c), append(c, l), append(l, u), append(c, p2), append(c, d), append(e, m), append(e, f), append(f, _), append(f, h), append(f, g2);
  }, p(t5, [e2]) {
    1 & e2 && $2 !== ($2 = t5[0].attributes.movement.walk + "") && set_data(u, $2);
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e);
  } };
}
function instance$q(t4, e, n) {
  let o2, { actor: i } = e;
  return t4.$$set = (t5) => {
    "actor" in t5 && n(3, i = t5.actor);
  }, t4.$$.update = () => {
    8 & t4.$$.dirty && n(0, o2 = i.system);
  }, [o2, function() {
    const t5 = o2.attributes.init.total;
    return t5 > 0 ? "+" + t5 : t5;
  }, function() {
    const t5 = o2.attributes.prof;
    return t5 > 0 ? "+" + t5 : "-" + t5;
  }, i];
}
class CharacterStatsLozenges extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$q, create_fragment$r, safe_not_equal, { actor: 3 });
  }
}
function create_fragment$q(t4) {
  let e, n, o2, i, a = t4[0].attributes.ac.value + "";
  return { c() {
    e = element("div"), n = element("div"), o2 = element("div"), i = text(a), attr(n, "class", "ac-badge svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1x2jjr3"), attr(e, "class", "top svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1x2jjr3");
  }, m(t5, a2) {
    insert(t5, e, a2), append(e, n), append(n, o2), append(o2, i);
  }, p(t5, [e2]) {
    1 & e2 && a !== (a = t5[0].attributes.ac.value + "") && set_data(i, a);
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e);
  } };
}
function instance$p(t4, e, n) {
  let o2, { actor: i } = e;
  return t4.$$set = (t5) => {
    "actor" in t5 && n(1, i = t5.actor);
  }, t4.$$.update = () => {
    2 & t4.$$.dirty && n(0, o2 = i.system);
  }, [o2, i];
}
class CharacterAcBadge extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$p, create_fragment$q, safe_not_equal, { actor: 1 });
  }
}
function getActorImageOrDefault(t4) {
  return new Promise((e) => {
    const n = new Image();
    n.onload = () => e(t4), n.onerror = () => e("icons/svg/mystery-man.svg"), n.src = t4;
  });
}
function create_if_block_1$7(t4) {
  let e, n;
  return { c() {
    e = element("img"), src_url_equal(e.src, n = t4[2]) || attr(e, "src", n), attr(e, "alt", t4[0]), attr(e, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-kjds6x");
  }, m(t5, n2) {
    insert(t5, e, n2);
  }, p(t5, o2) {
    4 & o2 && !src_url_equal(e.src, n = t5[2]) && attr(e, "src", n), 1 & o2 && attr(e, "alt", t5[0]);
  }, d(t5) {
    t5 && detach(e);
  } };
}
function create_if_block$a(t4) {
  let e, n, o2, i, a, r2, s2, c;
  return { c() {
    e = element("div"), n = element("div"), o2 = element("img"), src_url_equal(o2.src, i = t4[2]) || attr(o2, "src", i), attr(o2, "alt", t4[0]), attr(o2, "class", "modal-image svelte-mobile-companion-dnd5e-81nkluj30u9vsd-kjds6x"), attr(n, "class", "modal-content svelte-mobile-companion-dnd5e-81nkluj30u9vsd-kjds6x"), attr(e, "class", "modal-bg svelte-mobile-companion-dnd5e-81nkluj30u9vsd-kjds6x"), attr(e, "aria-hidden", "true");
  }, m(i2, a2) {
    insert(i2, e, a2), append(e, n), append(n, o2), r2 = true, s2 || (c = listen(e, "click", t4[3]), s2 = true);
  }, p(t5, e2) {
    (!r2 || 4 & e2 && !src_url_equal(o2.src, i = t5[2])) && attr(o2, "src", i), (!r2 || 1 & e2) && attr(o2, "alt", t5[0]);
  }, i(t5) {
    r2 || (t5 && add_render_callback(() => {
      r2 && (a || (a = create_bidirectional_transition(e, fade, { duration: 100, easing: identity }, true)), a.run(1));
    }), r2 = true);
  }, o(t5) {
    t5 && (a || (a = create_bidirectional_transition(e, fade, { duration: 100, easing: identity }, false)), a.run(0)), r2 = false;
  }, d(t5) {
    t5 && detach(e), t5 && a && a.end(), s2 = false, c();
  } };
}
function create_fragment$p(t4) {
  let e, n, o2, i, a, r2 = t4[2] && create_if_block_1$7(t4), s2 = t4[1] && create_if_block$a(t4);
  return { c() {
    e = element("div"), r2 && r2.c(), n = space(), s2 && s2.c(), o2 = empty(), attr(e, "class", "portrait svelte-mobile-companion-dnd5e-81nkluj30u9vsd-kjds6x"), attr(e, "aria-hidden", "true");
  }, m(c, l) {
    insert(c, e, l), r2 && r2.m(e, null), insert(c, n, l), s2 && s2.m(c, l), insert(c, o2, l), i || (a = listen(e, "click", t4[3]), i = true);
  }, p(t5, [n2]) {
    t5[2] ? r2 ? r2.p(t5, n2) : (r2 = create_if_block_1$7(t5), r2.c(), r2.m(e, null)) : r2 && (r2.d(1), r2 = null), t5[1] ? s2 ? (s2.p(t5, n2), 2 & n2 && transition_in(s2, 1)) : (s2 = create_if_block$a(t5), s2.c(), transition_in(s2, 1), s2.m(o2.parentNode, o2)) : s2 && (group_outros(), transition_out(s2, 1, 1, () => {
      s2 = null;
    }), check_outros());
  }, i(t5) {
    transition_in(s2);
  }, o(t5) {
    transition_out(s2);
  }, d(t5) {
    t5 && (detach(e), detach(n), detach(o2)), r2 && r2.d(), s2 && s2.d(t5), i = false, a();
  } };
}
function instance$o(t4, e, n) {
  let o2, { img: i } = e, { name: a } = e, r2 = false;
  return getActorImageOrDefault(i).then((t5) => n(2, o2 = t5)), t4.$$set = (t5) => {
    "img" in t5 && n(4, i = t5.img), "name" in t5 && n(0, a = t5.name);
  }, [a, r2, o2, function() {
    n(1, r2 = !r2);
  }, i];
}
class CharacterPortrait extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$o, create_fragment$p, safe_not_equal, { img: 4, name: 0 });
  }
}
function create_fragment$o(t4) {
  let e, n, o2, i, a, r2, s2, c, l, u, p2, d, m, f, _;
  return o2 = new CharacterAcBadge({ props: { actor: t4[0] } }), a = new CharacterPortrait({ props: { img: t4[0].img, name: t4[0].name } }), s2 = new CharacterStatsLozenges({ props: { actor: t4[0] } }), u = new CharacterHitPoints({ props: { actorData: t4[1] } }), d = new CharacterHitDice({ props: { actorData: t4[1] } }), f = new CharacterExhaustion({ props: { actor: t4[0] } }), { c() {
    e = element("div"), n = element("div"), create_component(o2.$$.fragment), i = space(), create_component(a.$$.fragment), r2 = space(), create_component(s2.$$.fragment), c = space(), l = element("div"), create_component(u.$$.fragment), p2 = space(), create_component(d.$$.fragment), m = space(), create_component(f.$$.fragment), attr(n, "class", "ac-lozenges svelte-mobile-companion-dnd5e-81nkluj30u9vsd-3t2zs1"), attr(l, "class", "hp-hd"), attr(e, "class", "stats svelte-mobile-companion-dnd5e-81nkluj30u9vsd-3t2zs1");
  }, m(t5, h) {
    insert(t5, e, h), append(e, n), mount_component(o2, n, null), append(n, i), mount_component(a, n, null), append(n, r2), mount_component(s2, n, null), append(e, c), append(e, l), mount_component(u, l, null), append(l, p2), mount_component(d, l, null), append(e, m), mount_component(f, e, null), _ = true;
  }, p(t5, [e2]) {
    const n2 = {};
    1 & e2 && (n2.actor = t5[0]), o2.$set(n2);
    const i2 = {};
    1 & e2 && (i2.img = t5[0].img), 1 & e2 && (i2.name = t5[0].name), a.$set(i2);
    const r3 = {};
    1 & e2 && (r3.actor = t5[0]), s2.$set(r3);
    const c2 = {};
    2 & e2 && (c2.actorData = t5[1]), u.$set(c2);
    const l2 = {};
    2 & e2 && (l2.actorData = t5[1]), d.$set(l2);
    const p3 = {};
    1 & e2 && (p3.actor = t5[0]), f.$set(p3);
  }, i(t5) {
    _ || (transition_in(o2.$$.fragment, t5), transition_in(a.$$.fragment, t5), transition_in(s2.$$.fragment, t5), transition_in(u.$$.fragment, t5), transition_in(d.$$.fragment, t5), transition_in(f.$$.fragment, t5), _ = true);
  }, o(t5) {
    transition_out(o2.$$.fragment, t5), transition_out(a.$$.fragment, t5), transition_out(s2.$$.fragment, t5), transition_out(u.$$.fragment, t5), transition_out(d.$$.fragment, t5), transition_out(f.$$.fragment, t5), _ = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(o2), destroy_component(a), destroy_component(s2), destroy_component(u), destroy_component(d), destroy_component(f);
  } };
}
function instance$n(t4, e, n) {
  let o2, { actor: i } = e;
  return t4.$$set = (t5) => {
    "actor" in t5 && n(0, i = t5.actor);
  }, t4.$$.update = () => {
    1 & t4.$$.dirty && n(1, o2 = i.system);
  }, [i, o2];
}
class CharacterStatsAndPortrait extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$n, create_fragment$o, safe_not_equal, { actor: 0 });
  }
}
function create_fragment$n(t4) {
  let e, n, o2, i, a, r2, s2, c, l, u, p2, d, m, f, _, h, g2, $2, b, y, v, k, w2, S2, T;
  return { c() {
    e = element("div"), n = element("div"), n.textContent = `${i18n("DND5E.DeathSave")}`, o2 = space(), i = element("div"), a = element("div"), r2 = element("span"), r2.innerHTML = '<i class="fas fa-check"></i>', s2 = space(), c = element("div"), l = element("button"), u = space(), p2 = element("button"), d = space(), m = element("button"), f = space(), _ = element("div"), h = element("span"), h.innerHTML = '<i class="fa-solid fa-skull"></i>', g2 = space(), $2 = element("div"), b = element("button"), y = space(), v = element("button"), k = space(), w2 = element("button"), attr(n, "class", "label roboto-condensed-upper svelte-mobile-companion-dnd5e-81nkluj30u9vsd-82el5p"), attr(r2, "class", "icon svelte-mobile-companion-dnd5e-81nkluj30u9vsd-82el5p"), attr(l, "type", "button"), attr(l, "class", "pip svelte-mobile-companion-dnd5e-81nkluj30u9vsd-82el5p"), toggle_class(l, "filled", t4[1] >= 1), attr(p2, "type", "button"), attr(p2, "class", "pip svelte-mobile-companion-dnd5e-81nkluj30u9vsd-82el5p"), toggle_class(p2, "filled", t4[1] >= 2), attr(m, "type", "button"), attr(m, "class", "pip svelte-mobile-companion-dnd5e-81nkluj30u9vsd-82el5p"), toggle_class(m, "filled", t4[1] >= 3), attr(c, "class", "pips svelte-mobile-companion-dnd5e-81nkluj30u9vsd-82el5p"), attr(a, "class", "box svelte-mobile-companion-dnd5e-81nkluj30u9vsd-82el5p"), attr(h, "class", "icon fail svelte-mobile-companion-dnd5e-81nkluj30u9vsd-82el5p"), attr(b, "type", "button"), attr(b, "class", "pip failure svelte-mobile-companion-dnd5e-81nkluj30u9vsd-82el5p"), toggle_class(b, "filled", t4[0] >= 1), attr(v, "type", "button"), attr(v, "class", "pip failure svelte-mobile-companion-dnd5e-81nkluj30u9vsd-82el5p"), toggle_class(v, "filled", t4[0] >= 2), attr(w2, "type", "button"), attr(w2, "class", "pip failure svelte-mobile-companion-dnd5e-81nkluj30u9vsd-82el5p"), toggle_class(w2, "filled", t4[0] >= 3), attr($2, "class", "pips svelte-mobile-companion-dnd5e-81nkluj30u9vsd-82el5p"), attr(_, "class", "box svelte-mobile-companion-dnd5e-81nkluj30u9vsd-82el5p"), attr(i, "class", "death-saves svelte-mobile-companion-dnd5e-81nkluj30u9vsd-82el5p"), attr(e, "class", "death-tray  svelte-mobile-companion-dnd5e-81nkluj30u9vsd-82el5p");
  }, m(x2, E) {
    insert(x2, e, E), append(e, n), append(e, o2), append(e, i), append(i, a), append(a, r2), append(a, s2), append(a, c), append(c, l), append(c, u), append(c, p2), append(c, d), append(c, m), append(i, f), append(i, _), append(_, h), append(_, g2), append(_, $2), append($2, b), append($2, y), append($2, v), append($2, k), append($2, w2), S2 || (T = [listen(l, "click", t4[6]), listen(p2, "click", t4[7]), listen(m, "click", t4[8]), listen(b, "click", t4[9]), listen(v, "click", t4[10]), listen(w2, "click", t4[11])], S2 = true);
  }, p(t5, [e2]) {
    2 & e2 && toggle_class(l, "filled", t5[1] >= 1), 2 & e2 && toggle_class(p2, "filled", t5[1] >= 2), 2 & e2 && toggle_class(m, "filled", t5[1] >= 3), 1 & e2 && toggle_class(b, "filled", t5[0] >= 1), 1 & e2 && toggle_class(v, "filled", t5[0] >= 2), 1 & e2 && toggle_class(w2, "filled", t5[0] >= 3);
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e), S2 = false, run_all(T);
  } };
}
function instance$m(t4, e, n) {
  let o2, i, a, { actor: r2 } = e;
  function s2(t5, e2) {
    const n2 = {};
    n2[`system.attributes.death.${e2}`] = t5, FoundryGateway.updateActor(r2, n2);
  }
  function c(t5) {
    s2(t5 === i ? t5 - 1 : t5, "success");
  }
  function l(t5) {
    s2(t5 === a ? t5 - 1 : t5, "failure");
  }
  return t4.$$set = (t5) => {
    "actor" in t5 && n(4, r2 = t5.actor);
  }, t4.$$.update = () => {
    16 & t4.$$.dirty && n(5, o2 = r2.system), 32 & t4.$$.dirty && n(1, i = o2.attributes.death.success), 32 & t4.$$.dirty && n(0, a = o2.attributes.death.failure);
  }, [a, i, c, l, r2, o2, () => c(1), () => c(2), () => c(3), () => l(1), () => l(2), () => l(3)];
}
class CharacterDeath extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$m, create_fragment$n, safe_not_equal, { actor: 4 });
  }
}
function create_fragment$m(t4) {
  let e, n, o2, i, a;
  return n = new CharacterStatsAndPortrait({ props: { actor: t4[0] } }), i = new CharacterDeath({ props: { actor: t4[0] } }), { c() {
    e = element("div"), create_component(n.$$.fragment), o2 = space(), create_component(i.$$.fragment), attr(e, "class", "character svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1owdn6a");
  }, m(t5, r2) {
    insert(t5, e, r2), mount_component(n, e, null), append(e, o2), mount_component(i, e, null), a = true;
  }, p(t5, [e2]) {
    const o3 = {};
    1 & e2 && (o3.actor = t5[0]), n.$set(o3);
    const a2 = {};
    1 & e2 && (a2.actor = t5[0]), i.$set(a2);
  }, i(t5) {
    a || (transition_in(n.$$.fragment, t5), transition_in(i.$$.fragment, t5), a = true);
  }, o(t5) {
    transition_out(n.$$.fragment, t5), transition_out(i.$$.fragment, t5), a = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(n), destroy_component(i);
  } };
}
function instance$l(t4, e, n) {
  let { actor: o2 } = e;
  return t4.$$set = (t5) => {
    "actor" in t5 && n(0, o2 = t5.actor);
  }, [o2];
}
class Character extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$l, create_fragment$m, safe_not_equal, { actor: 0 });
  }
}
function create_fragment$l(t4) {
  let e, n, o2, i, a, r2 = t4[0].name + "";
  return { c() {
    e = element("div"), n = element("div"), o2 = text(r2), i = space(), a = element("div"), a.textContent = `${t4[1]}`, attr(n, "class", "character-name svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1vinbqw"), attr(a, "class", "class roboto-upper svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1vinbqw"), attr(e, "class", "name-container svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1vinbqw");
  }, m(t5, r3) {
    insert(t5, e, r3), append(e, n), append(n, o2), append(e, i), append(e, a);
  }, p(t5, [e2]) {
    1 & e2 && r2 !== (r2 = t5[0].name + "") && set_data(o2, r2);
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e);
  } };
}
function instance$k(t4, e, n) {
  let { actor: o2 } = e;
  const i = Object.keys(o2.classes).map((t5) => ({ name: o2.classes[t5].name, level: o2.classes[t5].system.levels }));
  i.sort((t5, e2) => e2.level - t5.level);
  const a = i.map((t5) => t5.name + " " + t5.level).join(" / ");
  return t4.$$set = (t5) => {
    "actor" in t5 && n(0, o2 = t5.actor);
  }, [o2, a];
}
class CharacterNameAndClass extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$k, create_fragment$l, safe_not_equal, { actor: 0 });
  }
}
function create_fragment$k(t4) {
  let e, n, o2, i, a, r2, s2, c = t4[0].details.level + "";
  return { c() {
    e = element("div"), n = element("div"), o2 = text(c), i = space(), a = element("button"), attr(a, "type", "button"), attr(a, "class", "inspiration svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1f7h0as"), toggle_class(a, "active", t4[0].attributes.inspiration), attr(n, "class", "level-badge svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1f7h0as"), attr(e, "class", "badge-container svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1f7h0as");
  }, m(c2, l) {
    insert(c2, e, l), append(e, n), append(n, o2), append(n, i), append(n, a), r2 || (s2 = listen(a, "click", t4[1]), r2 = true);
  }, p(t5, [e2]) {
    1 & e2 && c !== (c = t5[0].details.level + "") && set_data(o2, c), 1 & e2 && toggle_class(a, "active", t5[0].attributes.inspiration);
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e), r2 = false, s2();
  } };
}
function instance$j(t4, e, n) {
  let o2, { actor: i } = e;
  return t4.$$set = (t5) => {
    "actor" in t5 && n(2, i = t5.actor);
  }, t4.$$.update = () => {
    4 & t4.$$.dirty && n(0, o2 = i.system);
  }, [o2, function() {
    const t5 = {};
    t5["system.attributes.inspiration"] = !o2.attributes.inspiration, FoundryGateway.updateActor(i, t5);
  }, i];
}
class LevelAndInspiration extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$j, create_fragment$k, safe_not_equal, { actor: 2 });
  }
}
function create_if_block_1$6(t4) {
  let e, n, o2, i, a, r2, s2, c, l, u, p2 = t4[2].details.xp.value + "", d = t4[2].details.xp.max + "";
  return { c() {
    e = element("div"), n = element("span"), o2 = text(p2), i = space(), a = element("span"), a.textContent = "/", r2 = space(), s2 = element("span"), c = text(d), l = space(), u = element("div"), attr(n, "class", "value"), attr(a, "class", "separator"), attr(s2, "class", "max"), attr(e, "class", "xp-label roboto-upper svelte-mobile-companion-dnd5e-81nkluj30u9vsd-hjirms"), attr(u, "class", "xp-bar svelte-mobile-companion-dnd5e-81nkluj30u9vsd-hjirms"), set_style(u, "--bar-percentage", t4[4] + "%");
  }, m(t5, p3) {
    insert(t5, e, p3), append(e, n), append(n, o2), append(e, i), append(e, a), append(e, r2), append(e, s2), append(s2, c), insert(t5, l, p3), insert(t5, u, p3);
  }, p(t5, e2) {
    4 & e2 && p2 !== (p2 = t5[2].details.xp.value + "") && set_data(o2, p2), 4 & e2 && d !== (d = t5[2].details.xp.max + "") && set_data(c, d), 16 & e2 && set_style(u, "--bar-percentage", t5[4] + "%");
  }, d(t5) {
    t5 && (detach(e), detach(l), detach(u));
  } };
}
function create_if_block$9(t4) {
  let e, n, o2;
  return { c() {
    e = element("div"), n = text("CR "), o2 = text(t4[0]), attr(e, "class", "cr-label roboto-upper svelte-mobile-companion-dnd5e-81nkluj30u9vsd-hjirms");
  }, m(t5, i) {
    insert(t5, e, i), append(e, n), append(e, o2);
  }, p(t5, e2) {
    1 & e2 && set_data(o2, t5[0]);
  }, d(t5) {
    t5 && detach(e);
  } };
}
function create_fragment$j(t4) {
  let e, n, o2 = t4[3] && create_if_block_1$6(t4), i = t4[1] && create_if_block$9(t4);
  return { c() {
    e = element("div"), o2 && o2.c(), n = space(), i && i.c(), attr(e, "class", "xp-container");
  }, m(t5, a) {
    insert(t5, e, a), o2 && o2.m(e, null), append(e, n), i && i.m(e, null);
  }, p(t5, [a]) {
    t5[3] ? o2 ? o2.p(t5, a) : (o2 = create_if_block_1$6(t5), o2.c(), o2.m(e, n)) : o2 && (o2.d(1), o2 = null), t5[1] ? i ? i.p(t5, a) : (i = create_if_block$9(t5), i.c(), i.m(e, null)) : i && (i.d(1), i = null);
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e), o2 && o2.d(), i && i.d();
  } };
}
function instance$i(t4, e, n) {
  let o2, i, a, r2, s2, { actor: c } = e;
  return t4.$$set = (t5) => {
    "actor" in t5 && n(5, c = t5.actor);
  }, t4.$$.update = () => {
    32 & t4.$$.dirty && n(2, o2 = c.system), 4 & t4.$$.dirty && n(4, i = o2.details.xp.value / o2.details.xp.max * 100), 39 & t4.$$.dirty && (n(3, s2 = "character" === c.type), n(1, r2 = "npc" === c.type), r2 && (n(0, a = o2.details.cr), a ? 0.125 === a ? n(0, a = "¹⁄₈") : 0.25 === a ? n(0, a = "¹⁄₄") : 0.5 === a && n(0, a = "¹⁄₂") : n(0, a = "-")));
  }, [a, r2, o2, s2, i, c];
}
class XPLabel extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$i, create_fragment$j, safe_not_equal, { actor: 5 });
  }
}
function create_fragment$i(t4) {
  let e, n, o2, i, a, r2;
  return { c() {
    e = element("div"), n = element("button"), n.innerHTML = '<i class="fas fa-utensils svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1th0vfz"></i>', o2 = space(), i = element("button"), i.innerHTML = '<i class="fas fa-campground svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1th0vfz"></i>', attr(n, "type", "button"), attr(n, "class", "short-rest gold-button svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1th0vfz"), attr(i, "type", "button"), attr(i, "class", "long-rest gold-button svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1th0vfz"), attr(e, "class", "sheet-header-buttons svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1th0vfz");
  }, m(s2, c) {
    insert(s2, e, c), append(e, n), append(e, o2), append(e, i), a || (r2 = [listen(n, "click", t4[0]), listen(i, "click", t4[1])], a = true);
  }, p: noop$3, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e), a = false, run_all(r2);
  } };
}
function instance$h(t4, e, n) {
  let { actor: o2 } = e;
  return t4.$$set = (t5) => {
    "actor" in t5 && n(2, o2 = t5.actor);
  }, [function() {
    o2.shortRest({ dialog: true });
  }, function() {
    o2.longRest({ dialog: true });
  }, o2];
}
class RestButtons extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$h, create_fragment$i, safe_not_equal, { actor: 2 });
  }
}
function create_if_block$8(t4) {
  let e, n;
  return e = new XPLabel({ props: { actor: t4[0] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    1 & n2 && (o2.actor = t5[0]), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_fragment$h(t4) {
  let e, n, o2, i, a, r2, s2;
  o2 = new RestButtons({ props: { actor: t4[0] } }), a = new LevelAndInspiration({ props: { actor: t4[0] } });
  let c = "noxp" !== t4[1] && create_if_block$8(t4);
  return { c() {
    e = element("div"), n = element("div"), create_component(o2.$$.fragment), i = space(), create_component(a.$$.fragment), r2 = space(), c && c.c(), attr(n, "class", "right-buttons svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1mzrtvq"), attr(e, "class", "right-header svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1mzrtvq");
  }, m(t5, l) {
    insert(t5, e, l), append(e, n), mount_component(o2, n, null), append(n, i), mount_component(a, n, null), append(e, r2), c && c.m(e, null), s2 = true;
  }, p(t5, [e2]) {
    const n2 = {};
    1 & e2 && (n2.actor = t5[0]), o2.$set(n2);
    const i2 = {};
    1 & e2 && (i2.actor = t5[0]), a.$set(i2), "noxp" !== t5[1] && c.p(t5, e2);
  }, i(t5) {
    s2 || (transition_in(o2.$$.fragment, t5), transition_in(a.$$.fragment, t5), transition_in(c), s2 = true);
  }, o(t5) {
    transition_out(o2.$$.fragment, t5), transition_out(a.$$.fragment, t5), transition_out(c), s2 = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(o2), destroy_component(a), c && c.d();
  } };
}
function instance$g(t4, e, n) {
  let { actor: o2 } = e;
  const i = game.settings.get("dnd5e", "levelingMode");
  return t4.$$set = (t5) => {
    "actor" in t5 && n(0, o2 = t5.actor);
  }, [o2, i];
}
class LevelAndRests extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$g, create_fragment$h, safe_not_equal, { actor: 0 });
  }
}
function create_fragment$g(t4) {
  let e, n, o2, i, a;
  return n = new CharacterNameAndClass({ props: { actor: t4[0] } }), i = new LevelAndRests({ props: { actor: t4[0] } }), { c() {
    e = element("header"), create_component(n.$$.fragment), o2 = space(), create_component(i.$$.fragment), attr(e, "class", "sheet-header svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1gumnt8");
  }, m(t5, r2) {
    insert(t5, e, r2), mount_component(n, e, null), append(e, o2), mount_component(i, e, null), a = true;
  }, p(t5, [e2]) {
    const o3 = {};
    1 & e2 && (o3.actor = t5[0]), n.$set(o3);
    const a2 = {};
    1 & e2 && (a2.actor = t5[0]), i.$set(a2);
  }, i(t5) {
    a || (transition_in(n.$$.fragment, t5), transition_in(i.$$.fragment, t5), a = true);
  }, o(t5) {
    transition_out(n.$$.fragment, t5), transition_out(i.$$.fragment, t5), a = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(n), destroy_component(i);
  } };
}
function instance$f(t4, e, n) {
  let { actor: o2 } = e;
  return t4.$$set = (t5) => {
    "actor" in t5 && n(0, o2 = t5.actor);
  }, [o2];
}
class CharacterHeader extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$f, create_fragment$g, safe_not_equal, { actor: 0 });
  }
}
function create_if_block_2$4(t4) {
  let e, n;
  return e = new SpellQuickInfo({ props: { spell: t4[1] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    2 & n2 && (o2.spell = t5[1]), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_below_name_content_slot$1(t4) {
  let e, n, o2 = t4[4] && create_if_block_2$4(t4);
  return { c() {
    e = element("div"), o2 && o2.c(), attr(e, "class", "quickinfo"), attr(e, "slot", "below-name-content");
  }, m(t5, i) {
    insert(t5, e, i), o2 && o2.m(e, null), n = true;
  }, p(t5, n2) {
    t5[4] ? o2 ? (o2.p(t5, n2), 16 & n2 && transition_in(o2, 1)) : (o2 = create_if_block_2$4(t5), o2.c(), transition_in(o2, 1), o2.m(e, null)) : o2 && (group_outros(), transition_out(o2, 1, 1, () => {
      o2 = null;
    }), check_outros());
  }, i(t5) {
    n || (transition_in(o2), n = true);
  }, o(t5) {
    transition_out(o2), n = false;
  }, d(t5) {
    t5 && detach(e), o2 && o2.d();
  } };
}
function create_if_block_1$5(t4) {
  let e, n, o2, i;
  return e = new RitualTag({ props: { spell: t4[1] } }), o2 = new ConcentrationTag({ props: { spell: t4[1], actor: t4[0] } }), { c() {
    create_component(e.$$.fragment), n = space(), create_component(o2.$$.fragment);
  }, m(t5, a) {
    mount_component(e, t5, a), insert(t5, n, a), mount_component(o2, t5, a), i = true;
  }, p(t5, n2) {
    const i2 = {};
    2 & n2 && (i2.spell = t5[1]), e.$set(i2);
    const a = {};
    2 & n2 && (a.spell = t5[1]), 1 & n2 && (a.actor = t5[0]), o2.$set(a);
  }, i(t5) {
    i || (transition_in(e.$$.fragment, t5), transition_in(o2.$$.fragment, t5), i = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), transition_out(o2.$$.fragment, t5), i = false;
  }, d(t5) {
    t5 && detach(n), destroy_component(e, t5), destroy_component(o2, t5);
  } };
}
function create_right_content_slot$1(t4) {
  let e, n, o2 = t4[4] && create_if_block_1$5(t4);
  return { c() {
    e = element("div"), o2 && o2.c(), attr(e, "class", "spellTags"), attr(e, "slot", "right-content");
  }, m(t5, i) {
    insert(t5, e, i), o2 && o2.m(e, null), n = true;
  }, p(t5, n2) {
    t5[4] ? o2 ? (o2.p(t5, n2), 16 & n2 && transition_in(o2, 1)) : (o2 = create_if_block_1$5(t5), o2.c(), transition_in(o2, 1), o2.m(e, null)) : o2 && (group_outros(), transition_out(o2, 1, 1, () => {
      o2 = null;
    }), check_outros());
  }, i(t5) {
    n || (transition_in(o2), n = true);
  }, o(t5) {
    transition_out(o2), n = false;
  }, d(t5) {
    t5 && detach(e), o2 && o2.d();
  } };
}
function create_else_block$3(t4) {
  let e, n;
  return e = new Patreon({ props: { subject: "Higher level spell information" } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p: noop$3, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_if_block$7(t4) {
  let e, n, o2, i, a, r2, s2, c, l, u, p2, d, m, f;
  return n = new SpellBadges({ props: { isConcentration: t4[5], isRitual: t4[6] } }), i = new Effects({ props: { effects: t4[3] } }), r2 = new ToggleFavorite({ props: { actor: t4[0], item: t4[1] } }), c = new Activities({ props: { activities: t4[2].activities.contents } }), u = new SpellProperties({ props: { spell: t4[1] } }), d = new SpellDescription({ props: { description: t4[1].system.description.value } }), { c() {
    e = element("div"), create_component(n.$$.fragment), o2 = space(), create_component(i.$$.fragment), a = space(), create_component(r2.$$.fragment), s2 = space(), create_component(c.$$.fragment), l = space(), create_component(u.$$.fragment), p2 = space(), create_component(d.$$.fragment);
  }, m(t5, m2) {
    insert(t5, e, m2), mount_component(n, e, null), append(e, o2), mount_component(i, e, null), append(e, a), mount_component(r2, e, null), append(e, s2), mount_component(c, e, null), append(e, l), mount_component(u, e, null), append(e, p2), mount_component(d, e, null), f = true;
  }, p(t5, e2) {
    const o3 = {};
    32 & e2 && (o3.isConcentration = t5[5]), 64 & e2 && (o3.isRitual = t5[6]), n.$set(o3);
    const a2 = {};
    8 & e2 && (a2.effects = t5[3]), i.$set(a2);
    const s3 = {};
    1 & e2 && (s3.actor = t5[0]), 2 & e2 && (s3.item = t5[1]), r2.$set(s3);
    const l2 = {};
    4 & e2 && (l2.activities = t5[2].activities.contents), c.$set(l2);
    const p3 = {};
    2 & e2 && (p3.spell = t5[1]), u.$set(p3);
    const m2 = {};
    2 & e2 && (m2.description = t5[1].system.description.value), d.$set(m2);
  }, i(t5) {
    f || (transition_in(n.$$.fragment, t5), transition_in(i.$$.fragment, t5), transition_in(r2.$$.fragment, t5), transition_in(c.$$.fragment, t5), transition_in(u.$$.fragment, t5), transition_in(d.$$.fragment, t5), t5 && add_render_callback(() => {
      f && (m || (m = create_bidirectional_transition(e, slide, { duration: 200, easing: identity, axis: "y" }, true)), m.run(1));
    }), f = true);
  }, o(t5) {
    transition_out(n.$$.fragment, t5), transition_out(i.$$.fragment, t5), transition_out(r2.$$.fragment, t5), transition_out(c.$$.fragment, t5), transition_out(u.$$.fragment, t5), transition_out(d.$$.fragment, t5), t5 && (m || (m = create_bidirectional_transition(e, slide, { duration: 200, easing: identity, axis: "y" }, false)), m.run(0)), f = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(n), destroy_component(i), destroy_component(r2), destroy_component(c), destroy_component(u), destroy_component(d), t5 && m && m.end();
  } };
}
function create_details_slot$2(t4) {
  let e, n, o2, i;
  const a = [create_if_block$7, create_else_block$3], r2 = [];
  function s2(t5, e2) {
    return t5[4] ? 0 : 1;
  }
  return n = s2(t4), o2 = r2[n] = a[n](t4), { c() {
    e = element("div"), o2.c(), attr(e, "slot", "details");
  }, m(t5, o3) {
    insert(t5, e, o3), r2[n].m(e, null), i = true;
  }, p(t5, i2) {
    let c = n;
    n = s2(t5), n === c ? r2[n].p(t5, i2) : (group_outros(), transition_out(r2[c], 1, 1, () => {
      r2[c] = null;
    }), check_outros(), o2 = r2[n], o2 ? o2.p(t5, i2) : (o2 = r2[n] = a[n](t5), o2.c()), transition_in(o2, 1), o2.m(e, null));
  }, i(t5) {
    i || (transition_in(o2), i = true);
  }, o(t5) {
    transition_out(o2), i = false;
  }, d(t5) {
    t5 && detach(e), r2[n].d();
  } };
}
function create_key_block(t4) {
  let e, n;
  return e = new ToggleableListEntry({ props: { name: t4[1].name, imageSrc: t4[1].img, $$slots: { details: [create_details_slot$2], "right-content": [create_right_content_slot$1], "below-name-content": [create_below_name_content_slot$1] }, $$scope: { ctx: t4 } } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    2 & n2 && (o2.name = t5[1].name), 2 & n2 && (o2.imageSrc = t5[1].img), 383 & n2 && (o2.$$scope = { dirty: n2, ctx: t5 }), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_fragment$f(t4) {
  let e, n, o2 = t4[1].id, i = create_key_block(t4);
  return { c() {
    i.c(), e = empty();
  }, m(t5, o3) {
    i.m(t5, o3), insert(t5, e, o3), n = true;
  }, p(t5, [n2]) {
    2 & n2 && safe_not_equal(o2, o2 = t5[1].id) ? (group_outros(), transition_out(i, 1, 1, noop$3), check_outros(), i = create_key_block(t5), i.c(), transition_in(i, 1), i.m(e.parentNode, e)) : i.p(t5, n2);
  }, i(t5) {
    n || (transition_in(i), n = true);
  }, o(t5) {
    transition_out(i), n = false;
  }, d(t5) {
    t5 && detach(e), i.d(t5);
  } };
}
function instance$e(t4, e, n) {
  let o2, i, a, r2, s2;
  var c;
  let { actor: l } = e, { spell: u } = e;
  return t4.$$set = (t5) => {
    "actor" in t5 && n(0, l = t5.actor), "spell" in t5 && n(1, u = t5.spell);
  }, t4.$$.update = () => {
    2 & t4.$$.dirty && n(2, o2 = u.system), 4 & t4.$$.dirty && n(6, i = o2.properties.has("ritual")), 4 & t4.$$.dirty && n(5, a = o2.properties.has("concentration")), 4 & t4.$$.dirty && n(4, r2 = o2.level <= 2), 130 & t4.$$.dirty && n(3, s2 = null === n(7, c = u.effects) || void 0 === c ? void 0 : c.contents);
  }, [l, u, o2, s2, r2, a, i, c];
}
class FavoriteSpell extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$e, create_fragment$f, safe_not_equal, { actor: 0, spell: 1 });
  }
}
function create_below_name_content_slot(t4) {
  let e, n, o2;
  return n = new ItemQuickInfo({ props: { item: t4[1] } }), { c() {
    e = element("div"), create_component(n.$$.fragment), attr(e, "class", "quickinfo svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1vnz0hi"), attr(e, "slot", "below-name-content");
  }, m(t5, i) {
    insert(t5, e, i), mount_component(n, e, null), o2 = true;
  }, p(t5, e2) {
    const o3 = {};
    2 & e2 && (o3.item = t5[1]), n.$set(o3);
  }, i(t5) {
    o2 || (transition_in(n.$$.fragment, t5), o2 = true);
  }, o(t5) {
    transition_out(n.$$.fragment, t5), o2 = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(n);
  } };
}
function create_right_content_slot(t4) {
  let e, n, o2;
  return n = new EquippedAttuned({ props: { itemData: t4[2] } }), { c() {
    e = element("div"), create_component(n.$$.fragment), attr(e, "class", "rightControls svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1vnz0hi"), attr(e, "slot", "right-content");
  }, m(t5, i) {
    insert(t5, e, i), mount_component(n, e, null), o2 = true;
  }, p(t5, e2) {
    const o3 = {};
    4 & e2 && (o3.itemData = t5[2]), n.$set(o3);
  }, i(t5) {
    o2 || (transition_in(n.$$.fragment, t5), o2 = true);
  }, o(t5) {
    transition_out(n.$$.fragment, t5), o2 = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(n);
  } };
}
function create_if_block_3$2(t4) {
  let e, n;
  return e = new ObjectProperties({ props: { item: t4[1] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    2 & n2 && (o2.item = t5[1]), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_if_block_2$3(t4) {
  let e, n;
  return e = new Price({ props: { price: t4[2].price } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    4 & n2 && (o2.price = t5[2].price), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_if_block_1$4(t4) {
  let e, n;
  return e = new Weight({ props: { weight: t4[2].weight } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    4 & n2 && (o2.weight = t5[2].weight), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_if_block$6(t4) {
  let e, n;
  return e = new ItemDescription({ props: { itemData: t4[2] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    4 & n2 && (o2.itemData = t5[2]), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_details_slot$1(t4) {
  let e, n, o2, i, a, r2, s2, c, l, u;
  n = new ToggleFavorite({ props: { actor: t4[0], item: t4[1] } }), i = new Activities({ props: { activities: t4[4] } });
  let p2 = t4[2].properties?.size > 0 && create_if_block_3$2(t4);
  const d = t4[7].default, m = create_slot(d, t4, t4[8], null);
  let f = t4[2].price && create_if_block_2$3(t4), _ = t4[2].weight && create_if_block_1$4(t4), h = (t4[2].description || t4[2].price || t4[2].weight) && create_if_block$6(t4);
  return { c() {
    e = element("div"), create_component(n.$$.fragment), o2 = space(), create_component(i.$$.fragment), a = space(), p2 && p2.c(), r2 = space(), m && m.c(), s2 = space(), f && f.c(), c = space(), _ && _.c(), l = space(), h && h.c(), attr(e, "slot", "details");
  }, m(t5, d2) {
    insert(t5, e, d2), mount_component(n, e, null), append(e, o2), mount_component(i, e, null), append(e, a), p2 && p2.m(e, null), append(e, r2), m && m.m(e, null), append(e, s2), f && f.m(e, null), append(e, c), _ && _.m(e, null), append(e, l), h && h.m(e, null), u = true;
  }, p(t5, o3) {
    const a2 = {};
    1 & o3 && (a2.actor = t5[0]), 2 & o3 && (a2.item = t5[1]), n.$set(a2);
    const s3 = {};
    16 & o3 && (s3.activities = t5[4]), i.$set(s3), t5[2].properties?.size > 0 ? p2 ? (p2.p(t5, o3), 4 & o3 && transition_in(p2, 1)) : (p2 = create_if_block_3$2(t5), p2.c(), transition_in(p2, 1), p2.m(e, r2)) : p2 && (group_outros(), transition_out(p2, 1, 1, () => {
      p2 = null;
    }), check_outros()), m && m.p && (!u || 256 & o3) && update_slot_base(m, d, t5, t5[8], u ? get_slot_changes(d, t5[8], o3, null) : get_all_dirty_from_scope(t5[8]), null), t5[2].price ? f ? (f.p(t5, o3), 4 & o3 && transition_in(f, 1)) : (f = create_if_block_2$3(t5), f.c(), transition_in(f, 1), f.m(e, c)) : f && (group_outros(), transition_out(f, 1, 1, () => {
      f = null;
    }), check_outros()), t5[2].weight ? _ ? (_.p(t5, o3), 4 & o3 && transition_in(_, 1)) : (_ = create_if_block_1$4(t5), _.c(), transition_in(_, 1), _.m(e, l)) : _ && (group_outros(), transition_out(_, 1, 1, () => {
      _ = null;
    }), check_outros()), t5[2].description || t5[2].price || t5[2].weight ? h ? (h.p(t5, o3), 4 & o3 && transition_in(h, 1)) : (h = create_if_block$6(t5), h.c(), transition_in(h, 1), h.m(e, null)) : h && (group_outros(), transition_out(h, 1, 1, () => {
      h = null;
    }), check_outros());
  }, i(t5) {
    u || (transition_in(n.$$.fragment, t5), transition_in(i.$$.fragment, t5), transition_in(p2), transition_in(m, t5), transition_in(f), transition_in(_), transition_in(h), u = true);
  }, o(t5) {
    transition_out(n.$$.fragment, t5), transition_out(i.$$.fragment, t5), transition_out(p2), transition_out(m, t5), transition_out(f), transition_out(_), transition_out(h), u = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(n), destroy_component(i), p2 && p2.d(), m && m.d(t5), f && f.d(), _ && _.d(), h && h.d();
  } };
}
function create_fragment$e(t4) {
  let e, n;
  return e = new ToggleableListEntry({ props: { name: t4[3] ?? "", imageSrc: t4[1].img, $$slots: { details: [create_details_slot$1], "right-content": [create_right_content_slot], "below-name-content": [create_below_name_content_slot] }, $$scope: { ctx: t4 } } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, [n2]) {
    const o2 = {};
    8 & n2 && (o2.name = t5[3] ?? ""), 2 & n2 && (o2.imageSrc = t5[1].img), 279 & n2 && (o2.$$scope = { dirty: n2, ctx: t5 }), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function instance$d(t4, e, n) {
  let o2, i, { $$slots: a = {}, $$scope: r2 } = e;
  var s2;
  let c, l, { actor: u } = e, { item: p2 } = e;
  return t4.$$set = (t5) => {
    "actor" in t5 && n(0, u = t5.actor), "item" in t5 && n(1, p2 = t5.item), "$$scope" in t5 && n(8, r2 = t5.$$scope);
  }, t4.$$.update = () => {
    2 & t4.$$.dirty && n(2, i = p2.system), 36 & t4.$$.dirty && n(4, o2 = null === n(5, s2 = i.activities) || void 0 === s2 ? void 0 : s2.contents), 70 & t4.$$.dirty && (n(6, l = i.identified), n(3, c = l ? p2.name : i.unidentified.name));
  }, [u, p2, i, c, o2, s2, l, a, r2];
}
class FavoriteItem extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$d, create_fragment$e, safe_not_equal, { actor: 0, item: 1 });
  }
}
function create_fragment$d(t4) {
  let e, n;
  return e = new Feature({ props: { feature: t4[0], actor: t4[1] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, [n2]) {
    const o2 = {};
    1 & n2 && (o2.feature = t5[0]), 2 & n2 && (o2.actor = t5[1]), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function instance$c(t4, e, n) {
  let { feature: o2 } = e, { actor: i } = e;
  return t4.$$set = (t5) => {
    "feature" in t5 && n(0, o2 = t5.feature), "actor" in t5 && n(1, i = t5.actor);
  }, [o2, i];
}
class FavoriteFeat extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$c, create_fragment$d, safe_not_equal, { feature: 0, actor: 1 });
  }
}
function get_each_context$1(t4, e, n) {
  const o2 = t4.slice();
  return o2[5] = e[n], o2;
}
function get_each_context_1(t4, e, n) {
  const o2 = t4.slice();
  return o2[8] = e[n], o2;
}
function get_each_context_2(t4, e, n) {
  const o2 = t4.slice();
  return o2[11] = e[n], o2;
}
function create_if_block_4$1(t4) {
  let e, n, o2, i;
  return e = new SectionListHeader({ props: { title: "Favorites" } }), o2 = new Patreon({ props: { subject: "Favorites" } }), { c() {
    create_component(e.$$.fragment), n = space(), create_component(o2.$$.fragment);
  }, m(t5, a) {
    mount_component(e, t5, a), insert(t5, n, a), mount_component(o2, t5, a), i = true;
  }, p: noop$3, i(t5) {
    i || (transition_in(e.$$.fragment, t5), transition_in(o2.$$.fragment, t5), i = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), transition_out(o2.$$.fragment, t5), i = false;
  }, d(t5) {
    t5 && detach(n), destroy_component(e, t5), destroy_component(o2, t5);
  } };
}
function create_if_block$5(t4) {
  let e, n, o2, i, a = t4[2]?.length > 0 && create_if_block_3$1(t4), r2 = t4[1]?.length > 0 && create_if_block_2$2(t4), s2 = t4[3]?.length > 0 && create_if_block_1$3(t4);
  return { c() {
    e = element("section"), a && a.c(), n = space(), r2 && r2.c(), o2 = space(), s2 && s2.c();
  }, m(t5, c) {
    insert(t5, e, c), a && a.m(e, null), append(e, n), r2 && r2.m(e, null), append(e, o2), s2 && s2.m(e, null), i = true;
  }, p(t5, i2) {
    t5[2]?.length > 0 ? a ? (a.p(t5, i2), 4 & i2 && transition_in(a, 1)) : (a = create_if_block_3$1(t5), a.c(), transition_in(a, 1), a.m(e, n)) : a && (group_outros(), transition_out(a, 1, 1, () => {
      a = null;
    }), check_outros()), t5[1]?.length > 0 ? r2 ? (r2.p(t5, i2), 2 & i2 && transition_in(r2, 1)) : (r2 = create_if_block_2$2(t5), r2.c(), transition_in(r2, 1), r2.m(e, o2)) : r2 && (group_outros(), transition_out(r2, 1, 1, () => {
      r2 = null;
    }), check_outros()), t5[3]?.length > 0 ? s2 ? (s2.p(t5, i2), 8 & i2 && transition_in(s2, 1)) : (s2 = create_if_block_1$3(t5), s2.c(), transition_in(s2, 1), s2.m(e, null)) : s2 && (group_outros(), transition_out(s2, 1, 1, () => {
      s2 = null;
    }), check_outros());
  }, i(t5) {
    i || (transition_in(a), transition_in(r2), transition_in(s2), i = true);
  }, o(t5) {
    transition_out(a), transition_out(r2), transition_out(s2), i = false;
  }, d(t5) {
    t5 && detach(e), a && a.d(), r2 && r2.d(), s2 && s2.d();
  } };
}
function create_if_block_3$1(t4) {
  let e, n, o2, i;
  e = new SectionListHeader({ props: { title: "Favorite Spells" } });
  let a = ensure_array_like(t4[2]), r2 = [];
  for (let e2 = 0; e2 < a.length; e2 += 1) r2[e2] = create_each_block_2(get_each_context_2(t4, a, e2));
  const s2 = (t5) => transition_out(r2[t5], 1, 1, () => {
    r2[t5] = null;
  });
  return { c() {
    create_component(e.$$.fragment), n = space();
    for (let t5 = 0; t5 < r2.length; t5 += 1) r2[t5].c();
    o2 = empty();
  }, m(t5, a2) {
    mount_component(e, t5, a2), insert(t5, n, a2);
    for (let e2 = 0; e2 < r2.length; e2 += 1) r2[e2] && r2[e2].m(t5, a2);
    insert(t5, o2, a2), i = true;
  }, p(t5, e2) {
    if (5 & e2) {
      let n2;
      for (a = ensure_array_like(t5[2]), n2 = 0; n2 < a.length; n2 += 1) {
        const i2 = get_each_context_2(t5, a, n2);
        r2[n2] ? (r2[n2].p(i2, e2), transition_in(r2[n2], 1)) : (r2[n2] = create_each_block_2(i2), r2[n2].c(), transition_in(r2[n2], 1), r2[n2].m(o2.parentNode, o2));
      }
      for (group_outros(), n2 = a.length; n2 < r2.length; n2 += 1) s2(n2);
      check_outros();
    }
  }, i(t5) {
    if (!i) {
      transition_in(e.$$.fragment, t5);
      for (let t6 = 0; t6 < a.length; t6 += 1) transition_in(r2[t6]);
      i = true;
    }
  }, o(t5) {
    transition_out(e.$$.fragment, t5), r2 = r2.filter(Boolean);
    for (let t6 = 0; t6 < r2.length; t6 += 1) transition_out(r2[t6]);
    i = false;
  }, d(t5) {
    t5 && (detach(n), detach(o2)), destroy_component(e, t5), destroy_each(r2, t5);
  } };
}
function create_each_block_2(t4) {
  let e, n;
  return e = new FavoriteSpell({ props: { actor: t4[0], spell: t4[11] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    1 & n2 && (o2.actor = t5[0]), 4 & n2 && (o2.spell = t5[11]), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_if_block_2$2(t4) {
  let e, n, o2, i;
  e = new SectionListHeader({ props: { title: "Favorite Objects" } });
  let a = ensure_array_like(t4[1]), r2 = [];
  for (let e2 = 0; e2 < a.length; e2 += 1) r2[e2] = create_each_block_1(get_each_context_1(t4, a, e2));
  const s2 = (t5) => transition_out(r2[t5], 1, 1, () => {
    r2[t5] = null;
  });
  return { c() {
    create_component(e.$$.fragment), n = space();
    for (let t5 = 0; t5 < r2.length; t5 += 1) r2[t5].c();
    o2 = empty();
  }, m(t5, a2) {
    mount_component(e, t5, a2), insert(t5, n, a2);
    for (let e2 = 0; e2 < r2.length; e2 += 1) r2[e2] && r2[e2].m(t5, a2);
    insert(t5, o2, a2), i = true;
  }, p(t5, e2) {
    if (3 & e2) {
      let n2;
      for (a = ensure_array_like(t5[1]), n2 = 0; n2 < a.length; n2 += 1) {
        const i2 = get_each_context_1(t5, a, n2);
        r2[n2] ? (r2[n2].p(i2, e2), transition_in(r2[n2], 1)) : (r2[n2] = create_each_block_1(i2), r2[n2].c(), transition_in(r2[n2], 1), r2[n2].m(o2.parentNode, o2));
      }
      for (group_outros(), n2 = a.length; n2 < r2.length; n2 += 1) s2(n2);
      check_outros();
    }
  }, i(t5) {
    if (!i) {
      transition_in(e.$$.fragment, t5);
      for (let t6 = 0; t6 < a.length; t6 += 1) transition_in(r2[t6]);
      i = true;
    }
  }, o(t5) {
    transition_out(e.$$.fragment, t5), r2 = r2.filter(Boolean);
    for (let t6 = 0; t6 < r2.length; t6 += 1) transition_out(r2[t6]);
    i = false;
  }, d(t5) {
    t5 && (detach(n), detach(o2)), destroy_component(e, t5), destroy_each(r2, t5);
  } };
}
function create_each_block_1(t4) {
  let e, n;
  return e = new FavoriteItem({ props: { actor: t4[0], item: t4[8] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    1 & n2 && (o2.actor = t5[0]), 2 & n2 && (o2.item = t5[8]), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_if_block_1$3(t4) {
  let e, n, o2, i;
  e = new SectionListHeader({ props: { title: "Favorite Features" } });
  let a = ensure_array_like(t4[3]), r2 = [];
  for (let e2 = 0; e2 < a.length; e2 += 1) r2[e2] = create_each_block$1(get_each_context$1(t4, a, e2));
  const s2 = (t5) => transition_out(r2[t5], 1, 1, () => {
    r2[t5] = null;
  });
  return { c() {
    create_component(e.$$.fragment), n = space();
    for (let t5 = 0; t5 < r2.length; t5 += 1) r2[t5].c();
    o2 = empty();
  }, m(t5, a2) {
    mount_component(e, t5, a2), insert(t5, n, a2);
    for (let e2 = 0; e2 < r2.length; e2 += 1) r2[e2] && r2[e2].m(t5, a2);
    insert(t5, o2, a2), i = true;
  }, p(t5, e2) {
    if (9 & e2) {
      let n2;
      for (a = ensure_array_like(t5[3]), n2 = 0; n2 < a.length; n2 += 1) {
        const i2 = get_each_context$1(t5, a, n2);
        r2[n2] ? (r2[n2].p(i2, e2), transition_in(r2[n2], 1)) : (r2[n2] = create_each_block$1(i2), r2[n2].c(), transition_in(r2[n2], 1), r2[n2].m(o2.parentNode, o2));
      }
      for (group_outros(), n2 = a.length; n2 < r2.length; n2 += 1) s2(n2);
      check_outros();
    }
  }, i(t5) {
    if (!i) {
      transition_in(e.$$.fragment, t5);
      for (let t6 = 0; t6 < a.length; t6 += 1) transition_in(r2[t6]);
      i = true;
    }
  }, o(t5) {
    transition_out(e.$$.fragment, t5), r2 = r2.filter(Boolean);
    for (let t6 = 0; t6 < r2.length; t6 += 1) transition_out(r2[t6]);
    i = false;
  }, d(t5) {
    t5 && (detach(n), detach(o2)), destroy_component(e, t5), destroy_each(r2, t5);
  } };
}
function create_each_block$1(t4) {
  let e, n;
  return e = new FavoriteFeat({ props: { actor: t4[0], feature: t4[5] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    1 & n2 && (o2.actor = t5[0]), 8 & n2 && (o2.feature = t5[5]), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_fragment$c(t4) {
  let e, n, o2, i, a;
  const r2 = [create_if_block$5, create_if_block_4$1], s2 = [];
  function c(t5, n2) {
    return null == e && (e = !!isFull()), e ? 0 : t5[2]?.length > 0 || t5[1]?.length > 0 || t5[3]?.length > 0 ? 1 : -1;
  }
  return ~(n = c(t4)) && (o2 = s2[n] = r2[n](t4)), { c() {
    o2 && o2.c(), i = empty();
  }, m(t5, e2) {
    ~n && s2[n].m(t5, e2), insert(t5, i, e2), a = true;
  }, p(t5, [e2]) {
    let a2 = n;
    n = c(t5), n === a2 ? ~n && s2[n].p(t5, e2) : (o2 && (group_outros(), transition_out(s2[a2], 1, 1, () => {
      s2[a2] = null;
    }), check_outros()), ~n ? (o2 = s2[n], o2 ? o2.p(t5, e2) : (o2 = s2[n] = r2[n](t5), o2.c()), transition_in(o2, 1), o2.m(i.parentNode, i)) : o2 = null);
  }, i(t5) {
    a || (transition_in(o2), a = true);
  }, o(t5) {
    transition_out(o2), a = false;
  }, d(t5) {
    t5 && detach(i), ~n && s2[n].d(t5);
  } };
}
function isFeat(t4) {
  return "feat" === t4.type || "background" === t4.type || "race" === t4.type || "class" === t4.type || "subclass" === t4.type;
}
function isObject(t4) {
  return "base" === t4.type || "weapon" === t4.type || "equipment" === t4.type || "consumable" === t4.type || "tool" === t4.type || "loot" === t4.type || "container" === t4.type;
}
function instance$b(t4, e, n) {
  let { actor: o2 } = e, i = [], a = [], r2 = [];
  return t4.$$set = (t5) => {
    "actor" in t5 && n(0, o2 = t5.actor);
  }, t4.$$.update = () => {
    if (1 & t4.$$.dirty) {
      let t5 = [], e2 = [], s2 = [];
      const c = o2.system.favorites || getFavoritesFlags(o2);
      null == c || c.filter((t6) => "item" === t6.type).sort((t6, e3) => t6.sort.valueOf() - e3.sort.valueOf()).map((t6) => function(t7) {
        const e3 = t7.substring(t7.lastIndexOf(".") + 1);
        return o2.items.get(e3);
      }(t6.id)).filter((t6) => void 0 !== t6).forEach((n2) => {
        "spell" === n2.type ? e2.push(n2) : isFeat(n2) ? s2.push(n2) : isObject(n2) && t5.push(n2);
      }), n(1, i = t5.sort((t6, e3) => t6.name.localeCompare(e3.name))), n(2, a = e2.sort((t6, e3) => t6.name.localeCompare(e3.name))), n(3, r2 = s2.sort((t6, e3) => t6.name.localeCompare(e3.name)));
    }
  }, [o2, i, a, r2];
}
class Favorites extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$b, create_fragment$c, safe_not_equal, { actor: 0 });
  }
}
function get_each_context(t4, e, n) {
  const o2 = t4.slice();
  return o2[7] = e[n], o2;
}
function create_if_block$4(t4) {
  let e, n, o2, i, a = [], r2 = /* @__PURE__ */ new Map();
  n = new SectionListHeader({ props: { title: i18n("DND5E.Conditions") } });
  let s2 = ensure_array_like(t4[0]);
  const c = (t5) => t5[7].id;
  for (let e2 = 0; e2 < s2.length; e2 += 1) {
    let n2 = get_each_context(t4, s2, e2), o3 = c(n2);
    r2.set(o3, a[e2] = create_each_block(o3, n2));
  }
  return { c() {
    e = element("section"), create_component(n.$$.fragment), o2 = space();
    for (let t5 = 0; t5 < a.length; t5 += 1) a[t5].c();
  }, m(t5, r3) {
    insert(t5, e, r3), mount_component(n, e, null), append(e, o2);
    for (let t6 = 0; t6 < a.length; t6 += 1) a[t6] && a[t6].m(e, null);
    i = true;
  }, p(t5, n2) {
    5 & n2 && (s2 = ensure_array_like(t5[0]), group_outros(), a = update_keyed_each(a, n2, c, 1, t5, s2, r2, e, outro_and_destroy_block, create_each_block, null, get_each_context), check_outros());
  }, i(t5) {
    if (!i) {
      transition_in(n.$$.fragment, t5);
      for (let t6 = 0; t6 < s2.length; t6 += 1) transition_in(a[t6]);
      i = true;
    }
  }, o(t5) {
    transition_out(n.$$.fragment, t5);
    for (let t6 = 0; t6 < a.length; t6 += 1) transition_out(a[t6]);
    i = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(n);
    for (let t6 = 0; t6 < a.length; t6 += 1) a[t6].d();
  } };
}
function create_if_block_2$1(t4) {
  let e, n, o2, i;
  function a() {
    return t4[5](t4[7]);
  }
  return { c() {
    e = element("div"), n = element("button"), n.textContent = "Remove Effect", attr(n, "class", "remove-effect svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1n8x3c0"), attr(e, "class", "button-wrapper svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1n8x3c0");
  }, m(t5, r2) {
    insert(t5, e, r2), append(e, n), o2 || (i = listen(n, "click", a), o2 = true);
  }, p(e2, n2) {
    t4 = e2;
  }, d(t5) {
    t5 && detach(e), o2 = false, i();
  } };
}
function create_catch_block(t4) {
  return { c: noop$3, m: noop$3, p: noop$3, d: noop$3 };
}
function create_then_block(t4) {
  let e;
  function n(t5, e2) {
    return t5[10] ? create_if_block_1$2 : create_else_block$2;
  }
  let o2 = n(t4), i = o2(t4);
  return { c() {
    i.c(), e = empty();
  }, m(t5, n2) {
    i.m(t5, n2), insert(t5, e, n2);
  }, p(t5, a) {
    o2 === (o2 = n(t5)) && i ? i.p(t5, a) : (i.d(1), i = o2(t5), i && (i.c(), i.m(e.parentNode, e)));
  }, d(t5) {
    t5 && detach(e), i.d(t5);
  } };
}
function create_else_block$2(t4) {
  let e;
  return { c() {
    e = element("p"), e.textContent = "No description available.";
  }, m(t5, n) {
    insert(t5, e, n);
  }, p: noop$3, d(t5) {
    t5 && detach(e);
  } };
}
function create_if_block_1$2(t4) {
  let e, n, o2 = t4[10] + "";
  return { c() {
    e = new HtmlTag(false), n = empty(), e.a = n;
  }, m(t5, i) {
    e.m(o2, t5, i), insert(t5, n, i);
  }, p(t5, n2) {
    1 & n2 && o2 !== (o2 = t5[10] + "") && e.p(o2);
  }, d(t5) {
    t5 && (detach(n), e.d());
  } };
}
function create_pending_block(t4) {
  return { c: noop$3, m: noop$3, p: noop$3, d: noop$3 };
}
function create_details_slot(t4) {
  let e, n, o2, i, a = !t4[7].id.startsWith("dnd5e"), r2 = a && create_if_block_2$1(t4), s2 = { ctx: t4, current: null, token: null, hasCatch: false, pending: create_pending_block, then: create_then_block, catch: create_catch_block, value: 10 };
  return handle_promise(o2 = t4[2](t4[7]), s2), { c() {
    e = element("div"), r2 && r2.c(), n = space(), s2.block.c(), i = space(), attr(e, "slot", "details");
  }, m(t5, o3) {
    insert(t5, e, o3), r2 && r2.m(e, null), append(e, n), s2.block.m(e, s2.anchor = null), s2.mount = () => e, s2.anchor = i, append(e, i);
  }, p(i2, c) {
    t4 = i2, 1 & c && (a = !t4[7].id.startsWith("dnd5e")), a ? r2 ? r2.p(t4, c) : (r2 = create_if_block_2$1(t4), r2.c(), r2.m(e, n)) : r2 && (r2.d(1), r2 = null), s2.ctx = t4, 1 & c && o2 !== (o2 = t4[2](t4[7])) && handle_promise(o2, s2) || update_await_block_branch(s2, t4, c);
  }, d(t5) {
    t5 && detach(e), r2 && r2.d(), s2.block.d(), s2.token = null, s2 = null;
  } };
}
function create_each_block(t4, e) {
  let n, o2, i;
  return o2 = new ToggleableListEntry({ props: { name: e[7].name, imageSrc: e[7].img, imageStyle: "background-color: rebeccapurple;", $$slots: { details: [create_details_slot] }, $$scope: { ctx: e } } }), { key: t4, first: null, c() {
    n = empty(), create_component(o2.$$.fragment), this.first = n;
  }, m(t5, e2) {
    insert(t5, n, e2), mount_component(o2, t5, e2), i = true;
  }, p(t5, n2) {
    e = t5;
    const i2 = {};
    1 & n2 && (i2.name = e[7].name), 1 & n2 && (i2.imageSrc = e[7].img), 2049 & n2 && (i2.$$scope = { dirty: n2, ctx: e }), o2.$set(i2);
  }, i(t5) {
    i || (transition_in(o2.$$.fragment, t5), i = true);
  }, o(t5) {
    transition_out(o2.$$.fragment, t5), i = false;
  }, d(t5) {
    t5 && detach(n), destroy_component(o2, t5);
  } };
}
function create_fragment$b(t4) {
  let e, n, o2 = t4[0]?.length > 0 && create_if_block$4(t4);
  return { c() {
    o2 && o2.c(), e = empty();
  }, m(t5, i) {
    o2 && o2.m(t5, i), insert(t5, e, i), n = true;
  }, p(t5, [n2]) {
    t5[0]?.length > 0 ? o2 ? (o2.p(t5, n2), 1 & n2 && transition_in(o2, 1)) : (o2 = create_if_block$4(t5), o2.c(), transition_in(o2, 1), o2.m(e.parentNode, e)) : o2 && (group_outros(), transition_out(o2, 1, 1, () => {
      o2 = null;
    }), check_outros());
  }, i(t5) {
    n || (transition_in(o2), n = true);
  }, o(t5) {
    transition_out(o2), n = false;
  }, d(t5) {
    t5 && detach(e), o2 && o2.d(t5);
  } };
}
function removeEffect(t4) {
  t4.delete();
}
function instance$a(t4, e, n) {
  let o2, i, a, r2, s2 = noop$3;
  t4.$$.on_destroy.push(() => s2());
  var c = this && this.__awaiter || function(t5, e2, n2, o3) {
    return new (n2 || (n2 = Promise))(function(i2, a2) {
      function r3(t6) {
        try {
          c2(o3.next(t6));
        } catch (t7) {
          a2(t7);
        }
      }
      function s3(t6) {
        try {
          c2(o3.throw(t6));
        } catch (t7) {
          a2(t7);
        }
      }
      function c2(t6) {
        var e3;
        t6.done ? i2(t6.value) : (e3 = t6.value, e3 instanceof n2 ? e3 : new n2(function(t7) {
          t7(e3);
        })).then(r3, s3);
      }
      c2((o3 = o3.apply(t5, e2 || [])).next());
    });
  };
  return t4.$$.update = () => {
    16 & t4.$$.dirty && n(3, i = r2), 8 & t4.$$.dirty && n(0, a = i.effects.contents.filter((t5) => !t5.disabled).sort((t5, e2) => t5.name.localeCompare(e2.name)));
  }, n(1, o2 = getContext(CONTEXT.ACTOR_STORE)), s2(), s2 = subscribe(o2, (t5) => n(4, r2 = t5)), [a, o2, function(t5) {
    return c(this, void 0, void 0, function* () {
      var e2, n2;
      if ((null === (e2 = t5.description) || void 0 === e2 ? void 0 : e2.length) > 0) {
        if (t5.description.startsWith("@Embed")) {
          const e3 = t5.description.replace(/@Embed\[(.+?)inline]/, "$1").trim(), o3 = yield fromUuid(e3);
          if (null === (n2 = null == o3 ? void 0 : o3.text) || void 0 === n2 ? void 0 : n2.content) return yield enrichText(o3.text.content);
        }
        return new Promise((e3) => e3(t5.description));
      }
    });
  }, i, r2, (t5) => removeEffect(t5)];
}
class Conditions extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$a, create_fragment$b, safe_not_equal, {});
  }
}
function create_fragment$a(t4) {
  let e, n, o2, i, a, r2, s2, c, l, u;
  return o2 = new CharacterHeader({ props: { actor: t4[0] } }), a = new Character({ props: { actor: t4[0] } }), s2 = new Conditions({}), l = new Favorites({ props: { actor: t4[0] } }), { c() {
    e = element("section"), n = element("section"), create_component(o2.$$.fragment), i = space(), create_component(a.$$.fragment), r2 = space(), create_component(s2.$$.fragment), c = space(), create_component(l.$$.fragment), attr(n, "class", "content-scroll-list svelte-mobile-companion-dnd5e-81nkluj30u9vsd-19pbveh"), attr(e, "class", "category-content svelte-mobile-companion-dnd5e-81nkluj30u9vsd-19pbveh");
  }, m(t5, p2) {
    insert(t5, e, p2), append(e, n), mount_component(o2, n, null), append(n, i), mount_component(a, n, null), append(n, r2), mount_component(s2, n, null), append(n, c), mount_component(l, n, null), u = true;
  }, p(t5, [e2]) {
    const n2 = {};
    1 & e2 && (n2.actor = t5[0]), o2.$set(n2);
    const i2 = {};
    1 & e2 && (i2.actor = t5[0]), a.$set(i2);
    const r3 = {};
    1 & e2 && (r3.actor = t5[0]), l.$set(r3);
  }, i(t5) {
    u || (transition_in(o2.$$.fragment, t5), transition_in(a.$$.fragment, t5), transition_in(s2.$$.fragment, t5), transition_in(l.$$.fragment, t5), u = true);
  }, o(t5) {
    transition_out(o2.$$.fragment, t5), transition_out(a.$$.fragment, t5), transition_out(s2.$$.fragment, t5), transition_out(l.$$.fragment, t5), u = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(o2), destroy_component(a), destroy_component(s2), destroy_component(l);
  } };
}
function instance$9(t4, e, n) {
  let { actor: o2 } = e;
  return t4.$$set = (t5) => {
    "actor" in t5 && n(0, o2 = t5.actor);
  }, [o2];
}
class Character_1 extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$9, create_fragment$a, safe_not_equal, { actor: 0 });
  }
}
function create_fragment$9(t4) {
  let e, n, o2, i, a, r2, s2 = (t4[1] || "-") + "";
  return { c() {
    e = element("div"), n = element("span"), o2 = text(t4[0]), i = space(), a = element("span"), r2 = text(s2), attr(n, "class", "label svelte-mobile-companion-dnd5e-81nkluj30u9vsd-j4gaz1"), attr(a, "class", "value svelte-mobile-companion-dnd5e-81nkluj30u9vsd-j4gaz1"), attr(e, "class", "label-container svelte-mobile-companion-dnd5e-81nkluj30u9vsd-j4gaz1");
  }, m(t5, s3) {
    insert(t5, e, s3), append(e, n), append(n, o2), append(e, i), append(e, a), append(a, r2);
  }, p(t5, [e2]) {
    1 & e2 && set_data(o2, t5[0]), 2 & e2 && s2 !== (s2 = (t5[1] || "-") + "") && set_data(r2, s2);
  }, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e);
  } };
}
function instance$8(t4, e, n) {
  let { label: o2 } = e, { value: i = "" } = e;
  return t4.$$set = (t5) => {
    "label" in t5 && n(0, o2 = t5.label), "value" in t5 && n(1, i = t5.value);
  }, [o2, i];
}
class BioProperty extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$8, create_fragment$9, safe_not_equal, { label: 0, value: 1 });
  }
}
class FoundryStyles {
  static #ze = void 0;
  static #qe = /* @__PURE__ */ new Map();
  static #$e = false;
  static #We() {
    this.#$e = true;
    const t4 = Array.from(document.styleSheets).filter((t5) => null !== t5.href);
    let e;
    const n = globalThis.foundry.utils.getRoute("/css/style.css");
    for (const o2 of t4) {
      let t5;
      try {
        t5 = new URL(o2.href);
      } catch (t6) {
        continue;
      }
      if ("string" == typeof t5.pathname && t5.pathname === n) {
        this.#ze = e = o2;
        break;
      }
    }
    if (e) for (const t5 of e.cssRules) {
      if (!(t5 instanceof CSSStyleRule)) continue;
      const e2 = {};
      for (const n2 of t5.style.cssText.split(";")) {
        const t6 = n2.split(":");
        t6.length < 2 || (e2[t6[0].trim()] = t6[1].trim());
      }
      this.#qe.set(t5.selectorText, e2);
    }
  }
  static getProperties(t4) {
    if (this.#$e || this.#We(), this.#qe.has(t4)) return this.#qe.get(t4);
    for (const e of this.#qe.keys()) if (e.includes(t4)) return this.#qe.get(e);
  }
  static getProperty(t4, e) {
    if (this.#$e || this.#We(), this.#qe.has(t4)) {
      const n = this.#qe.get(t4);
      return isObject$1(n) && e in n ? n[e] : void 0;
    }
    for (const n of this.#qe.keys()) if (n.includes(t4)) {
      const t5 = this.#qe.get(n);
      if (isObject$1(t5) && e in t5) return t5[e];
    }
  }
}
class FVTTConfigure {
  static #$e = false;
  static initialize() {
    if (this.#$e) return;
    const t4 = new TJSStyleManager({ docKey: "#__tjs-root-styles", version: 1.1 });
    this.#$e = true, t4.setProperties({ "--tjs-checkerboard-background-dark": "rgb(205, 205, 205)", "--tjs-checkerboard-background-10": `url('data:image/svg+xml;utf8,<svg preserveAspectRatio="none"  viewBox="0 0 10 10" xmlns="http://www.w3.org/2000/svg"><rect x="0" y="0" width="5" height="5" fill="transparent" /><rect x="5" y="5" width="5" height="5" fill="transparent" /><rect x="5" y="0" width="5" height="5" fill="white" /><rect x="0" y="5" width="5" height="5" fill="white" /></svg>') 0 0 / 10px 10px, var(--tjs-checkerboard-background-dark, rgb(205, 205, 205))` }, false), t4.setProperties({ "--tjs-action-ripple-background": "rgba(0, 0, 0, 0.35)" }, false), t4.setProperties({ "--tjs-icon-button-background-hover": "rgba(0, 0, 0, 0.10)", "--tjs-icon-button-background-selected": "rgba(0, 0, 0, 0.20)" }, false);
    {
      const e = FoundryStyles.getProperties('input[type="text"], input[type="number"]');
      isObject$1(e) && t4.setProperties({ "--tjs-input-background": "background" in e ? e.background : "rgba(0, 0, 0, 0.05)", "--tjs-input-border": "border" in e ? e.border : "1px solid var(--color-border-light-tertiary)", "--tjs-input-border-radius": "border-radius" in e ? e["border-radius"] : "3px", "--tjs-input-height": "height" in e ? e.height : "var(--form-field-height)", "--tjs-input-min-width": "min-width" in e ? e["min-width"] : "20px", "--tjs-input-padding": "padding" in e ? e.padding : "1px 3px", "--tjs-input-width": "width" in e ? e.width : "calc(100% - 2px)", "--_tjs-default-input-height": "height" in e ? e.height : "var(--form-field-height)", "--tjs-input-border-color": "var(--color-border-light-tertiary)" }, false);
    }
    {
      const e = FoundryStyles.getProperties('input[type="range"]::-webkit-slider-runnable-track'), n = FoundryStyles.getProperties('input[type="range"]:focus::-webkit-slider-runnable-track'), o2 = FoundryStyles.getProperties('input[type="range"]::-webkit-slider-thumb'), i = FoundryStyles.getProperties('input[type="range"]:focus::-webkit-slider-thumb');
      isObject$1(e) && t4.setProperties({ "--tjs-input-range-slider-track-box-shadow": "box-shadow" in e ? e["box-shadow"] : "1px 1px 1px #000000, 0px 0px 1px #0d0d0d" }, false), isObject$1(n) && t4.setProperties({ "--tjs-input-range-slider-track-box-shadow-focus": "box-shadow" in n ? n["box-shadow"] : "1px 1px 1px #000000, 0px 0px 1px #0d0d0d" }, false), isObject$1(o2) && t4.setProperties({ "--tjs-input-range-slider-thumb-box-shadow": "box-shadow" in o2 ? o2["box-shadow"] : "0 0 5px var(--color-shadow-primary)" }, false), isObject$1(i) && t4.setProperties({ "--tjs-input-range-slider-thumb-box-shadow-focus": "box-shadow" in i ? i["box-shadow"] : "0 0 5px var(--color-shadow-primary)" }, false);
    }
    t4.setProperties({ "--tjs-default-popup-background": "var(--color-text-dark-header, #23221d)", "--tjs-default-popup-border": "1px solid var(--color-border-dark, #000)", "--tjs-default-popup-box-shadow": "0 0 2px var(--color-shadow-dark, #000)", "--tjs-default-popup-primary-color": "var(--color-text-light-primary, #b5b3a4)", "--tjs-default-popup-highlight-color": "var(--color-text-light-highlight, #f0f0e0)", "--tjs-default-popover-border": "1px solid var(--color-border-dark, #000)", "--tjs-default-popover-box-shadow": "0 0 10px var(--color-shadow-dark, #000)" }, false), Hooks.on("PopOut:loading", (e, n) => {
      e instanceof SvelteApp && n.document.addEventListener("DOMContentLoaded", () => t4.clone(n.document));
    });
  }
}
FVTTConfigure.initialize();
class Hashing {
  static #Ue = /^[0-9A-F]{8}-[0-9A-F]{4}-4[0-9A-F]{3}-[89AB][0-9A-F]{3}-[0-9A-F]{12}$/i;
  constructor() {
    throw new Error("Hashing constructor: This is a static class and should not be constructed.");
  }
  static hashCode(t4, e = 0) {
    if ("string" != typeof t4) return 0;
    let n = 3735928559 ^ e, o2 = 1103547991 ^ e;
    for (let e2, i = 0; i < t4.length; i++) e2 = t4.charCodeAt(i), n = Math.imul(n ^ e2, 2654435761), o2 = Math.imul(o2 ^ e2, 1597334677);
    return n = Math.imul(n ^ n >>> 16, 2246822507) ^ Math.imul(o2 ^ o2 >>> 13, 3266489909), o2 = Math.imul(o2 ^ o2 >>> 16, 2246822507) ^ Math.imul(n ^ n >>> 13, 3266489909), 4294967296 * (2097151 & o2) + (n >>> 0);
  }
  static isUuidv4(t4) {
    return "string" == typeof t4 && this.#Ue.test(t4);
  }
  static uuidv4() {
    return ("10000000-1000-4000-8000" + -1e11).replace(/[018]/g, (t4) => (t4 ^ (globalThis.crypto ?? globalThis.msCrypto).getRandomValues(new Uint8Array(1))[0] & 15 >> t4 / 4).toString(16));
  }
}
class DynReducerUtils {
  static arrayEquals(t4, e) {
    if (t4 === e) return true;
    if (null === t4 || null === e) return false;
    if (t4.length !== e.length) return false;
    for (let n = t4.length; --n >= 0; ) if (t4[n] !== e[n]) return false;
    return true;
  }
  static hashString(t4, e = 0) {
    if (null == t4) return 0;
    let n = 3735928559 ^ e, o2 = 1103547991 ^ e;
    for (let e2, i = 0; i < t4.length; i++) e2 = t4.charCodeAt(i), n = Math.imul(n ^ e2, 2654435761), o2 = Math.imul(o2 ^ e2, 1597334677);
    return n = Math.imul(n ^ n >>> 16, 2246822507) ^ Math.imul(o2 ^ o2 >>> 13, 3266489909), o2 = Math.imul(o2 ^ o2 >>> 16, 2246822507) ^ Math.imul(n ^ n >>> 13, 3266489909), 4294967296 * (2097151 & o2) + (n >>> 0);
  }
  static hashUnknown(t4) {
    if (null == t4) return 0;
    let e = 0;
    switch (typeof t4) {
      case "boolean":
        e = t4 ? 1 : 0;
        break;
      case "bigint":
        e = Number(BigInt.asIntN(64, t4));
        break;
      case "function":
        e = this.hashString(t4.name);
        break;
      case "number":
        e = Number.isFinite(t4) ? t4 : 0;
        break;
      case "object":
        break;
      case "string":
        e = this.hashString(t4);
        break;
      case "symbol":
        e = this.hashString(Symbol.keyFor(t4));
    }
    return e;
  }
  static hasPrototype(t4, e) {
    if ("function" != typeof t4) return false;
    if (t4 === e) return true;
    for (let n = Object.getPrototypeOf(t4); n; n = Object.getPrototypeOf(n)) if (n === e) return true;
    return false;
  }
  static isIterable(t4) {
    return null != t4 && "object" == typeof t4 && "function" == typeof t4[Symbol.iterator];
  }
}
class AdapterDerived {
  #Ge;
  #Be;
  #Je;
  #Ve = /* @__PURE__ */ new Map();
  #Xe = false;
  constructor(t4, e, n) {
    this.#Ge = t4, this.#Je = e, this.#Be = n, Object.freeze(this);
  }
  create(t4) {
    if (this.#Xe || null === this.#Ge) throw Error("AdapterDerived.create error: this instance has been destroyed.");
    let e, n, o2 = {};
    const i = this.#Be;
    if ("string" == typeof t4) e = t4, n = i;
    else if ("function" == typeof t4 && DynReducerUtils.hasPrototype(t4, i)) n = t4;
    else {
      if ("object" != typeof t4 || null === t4) throw new TypeError("AdapterDerived.create error: 'options' does not conform to allowed parameters.");
      ({ name: e, ctor: n = i, ...o2 } = t4);
    }
    if (!DynReducerUtils.hasPrototype(n, i)) throw new TypeError(`AdapterDerived.create error: 'ctor' is not a '${i?.name}'.`);
    if (e = e ?? n?.name, "string" != typeof e) throw new TypeError("AdapterDerived.create error: 'name' is not a string.");
    const a = new n(this.#Ge, this.#Je, o2);
    if (this.#Ve.set(e, a), this.#Ye(a)) {
      const { filters: t5, sort: e2, ...n2 } = o2;
      a.initialize(n2);
    }
    return a;
  }
  clear() {
    if (!this.#Xe) {
      for (const t4 of this.#Ve.values()) t4.destroy();
      this.#Ve.clear();
    }
  }
  delete(t4) {
    if (this.#Xe) throw Error("AdapterDerived.delete error: this instance has been destroyed.");
    const e = this.#Ve.get(t4);
    return e && e.destroy(), this.#Ve.delete(t4);
  }
  destroy() {
    this.#Xe || (this.clear(), this.#Ge = null, this.#Je = null, this.#Xe = true);
  }
  get(t4) {
    if (this.#Xe) throw Error("AdapterDerived.get error: this instance has been destroyed.");
    return this.#Ve.get(t4);
  }
  #Ye(t4) {
    return "function" == typeof t4?.initialize;
  }
  update(t4 = false) {
    if (!this.#Xe) for (const e of this.#Ve.values()) e.index.update(t4);
  }
}
class AdapterFilters {
  #Ze;
  #Ke;
  #jt = /* @__PURE__ */ new Map();
  constructor(t4, e) {
    this.#Ke = t4, this.#Ze = e, Object.freeze(this);
  }
  get length() {
    return this.#Ze.filters.length;
  }
  *[Symbol.iterator]() {
    if (0 !== this.#Ze.filters.length) for (const t4 of this.#Ze.filters) yield { ...t4 };
  }
  add(...t4) {
    let e = 0;
    for (const n of t4) {
      const t5 = typeof n;
      if ("function" !== t5 && ("object" !== t5 || null === n)) throw new TypeError("AdapterFilters error: 'filter' is not a function or object.");
      let o2, i;
      if ("function" === t5) o2 = { id: void 0, filter: n, weight: 1 }, i = n.subscribe;
      else {
        if ("object" !== t5) throw new TypeError("AdapterFilters error: 'filter' is not defined.");
        if (!("filter" in n)) throw new TypeError("AdapterFilters error: 'filter' attribute is not a function.");
        if ("function" != typeof n.filter) throw new TypeError("AdapterFilters error: 'filter' attribute is not a function.");
        if (void 0 !== n.weight && ("number" != typeof n.weight || n.weight < 0 || n.weight > 1)) throw new TypeError("AdapterFilters error: 'weight' attribute is not a number between '0 - 1' inclusive.");
        o2 = { id: void 0 !== n.id ? n.id : void 0, filter: n.filter, weight: n.weight || 1 }, i = n.filter.subscribe ?? n.subscribe;
      }
      const a = this.#Ze.filters.findIndex((t6) => o2.weight < t6.weight);
      if (a >= 0 ? this.#Ze.filters.splice(a, 0, o2) : this.#Ze.filters.push(o2), "function" == typeof i) {
        const t6 = i(this.#Ke);
        if ("function" != typeof t6) throw new TypeError("AdapterFilters error: Filter has subscribe function, but no unsubscribe function is returned.");
        if (this.#jt.has(o2.filter)) throw new Error("AdapterFilters error: Filter added already has an unsubscribe function registered.");
        this.#jt.set(o2.filter, t6), e++;
      }
    }
    e < t4.length && this.#Ke(true);
  }
  clear() {
    this.#Ze.filters.length = 0;
    for (const t4 of this.#jt.values()) t4();
    this.#jt.clear(), this.#Ke();
  }
  remove(...t4) {
    const e = this.#Ze.filters.length;
    if (0 !== e) {
      for (const e2 of t4) {
        const t5 = "function" == typeof e2 ? e2 : null !== e2 && "object" == typeof e2 ? e2.filter : void 0;
        if (t5) {
          for (let e3 = this.#Ze.filters.length; --e3 >= 0; ) if (this.#Ze.filters[e3].filter === t5) {
            let n;
            this.#Ze.filters.splice(e3, 1), "function" == typeof (n = this.#jt.get(t5)) && (n(), this.#jt.delete(t5));
          }
        }
      }
      e !== this.#Ze.filters.length && this.#Ke(true);
    }
  }
  removeBy(t4) {
    const e = this.#Ze.filters.length;
    if (0 !== e) {
      if ("function" != typeof t4) throw new TypeError("AdapterFilters error: 'callback' is not a function.");
      this.#Ze.filters = this.#Ze.filters.filter((e2) => {
        const n = t4.call(t4, { ...e2 });
        if (n) {
          let t5;
          "function" == typeof (t5 = this.#jt.get(e2.filter)) && (t5(), this.#jt.delete(e2.filter));
        }
        return !n;
      }), e !== this.#Ze.filters.length && this.#Ke(true);
    }
  }
  removeById(...t4) {
    const e = this.#Ze.filters.length;
    0 !== e && (this.#Ze.filters = this.#Ze.filters.filter((e2) => {
      let n = 0;
      for (const o2 of t4) n |= e2.id === o2 ? 1 : 0;
      if (n) {
        let t5;
        "function" == typeof (t5 = this.#jt.get(e2.filter)) && (t5(), this.#jt.delete(e2.filter));
      }
      return !n;
    }), e !== this.#Ze.filters.length && this.#Ke(true));
  }
}
class AdapterIndexer {
  derivedAdapter;
  filtersData;
  hostData;
  hostUpdate;
  indexData;
  sortData;
  sortFn;
  destroyed = false;
  constructor(t4, e, n) {
    this.hostData = t4, this.hostUpdate = e, this.indexData = { index: null, hash: null, reversed: false, parent: n };
  }
  get active() {
    return this.filtersData.filters.length > 0 || null !== this.sortData.compareFn || true === this.indexData.parent?.active;
  }
  get length() {
    return this.indexData.index ? this.indexData.index.length : 0;
  }
  calcHashUpdate(t4, e, n = false) {
    const o2 = "boolean" == typeof n && n;
    let i = null;
    const a = this.indexData.index;
    if (a) for (let t5 = a.length; --t5 >= 0; ) i ^= DynReducerUtils.hashUnknown(a[t5]) + 2654435769 + (i << 6) + (i >> 2);
    this.indexData.hash = i, !o2 && e === i && DynReducerUtils.arrayEquals(t4, a) || this.hostUpdate();
  }
  destroy() {
    this.destroyed || (this.hostData = null, this.indexData.index = null, this.indexData.hash = null, this.indexData.reversed = false, this.indexData.parent = null, this.destroyed = true);
  }
  initAdapters(t4, e, n) {
    this.filtersData = t4, this.sortData = e, this.derivedAdapter = n, this.sortFn = this.createSortFn();
  }
}
class AdapterSort {
  #Qe;
  #Ke;
  #tn;
  constructor(t4, e) {
    this.#Ke = t4, this.#Qe = e, Object.freeze(this);
  }
  clear() {
    const t4 = this.#Qe.compareFn;
    this.#Qe.compareFn = null, "function" == typeof this.#tn && (this.#tn(), this.#tn = void 0), "function" == typeof t4 && this.#Ke(true);
  }
  set(t4) {
    let e, n;
    switch ("function" == typeof this.#tn && (this.#tn(), this.#tn = void 0), typeof t4) {
      case "function":
        e = t4, n = t4.subscribe;
        break;
      case "object":
        if (null === t4) break;
        if ("function" != typeof t4.compare) throw new TypeError("AdapterSort error: 'compare' attribute is not a function.");
        e = t4.compare, n = t4.compare.subscribe ?? t4.subscribe;
    }
    if ("function" != typeof e) {
      const t5 = this.#Qe.compareFn;
      return this.#Qe.compareFn = null, void ("function" == typeof t5 && this.#Ke());
    }
    if (this.#Qe.compareFn = e, "function" == typeof n) {
      if (this.#tn = n(this.#Ke), "function" != typeof this.#tn) throw new Error("AdapterSort error: sort has 'subscribe' function, but no 'unsubscribe' function is returned.");
    } else this.#Ke(true);
  }
}
class IndexerAPI {
  #en;
  active;
  length;
  update;
  constructor(t4) {
    this.#en = t4.indexData, this.update = t4.update.bind(t4), Object.defineProperties(this, { active: { get: () => t4.active }, length: { get: () => t4.length } }), Object.freeze(this);
  }
  get hash() {
    return this.#en.hash;
  }
  *[Symbol.iterator]() {
    const t4 = this.#en;
    if (!t4.index) return;
    const e = t4.reversed, n = t4.index.length;
    if (e) for (let e2 = n; --e2 >= 0; ) yield t4.index[e2];
    else for (let e2 = 0; e2 < n; e2++) yield t4.index[e2];
  }
}
class MapIndexer extends AdapterIndexer {
  createSortFn() {
    return (t4, e) => {
      const n = this.hostData?.[0], o2 = n?.get(t4), i = n?.get(e);
      return o2 && i ? this.sortData.compareFn(o2, i) : 0;
    };
  }
  reduceImpl() {
    const t4 = [], e = this.hostData?.[0];
    if (!e) return t4;
    const n = this.filtersData.filters;
    let o2 = true;
    const i = this.indexData.parent;
    if (DynReducerUtils.isIterable(i) && i.active) for (const a of i) {
      const i2 = e.get(a);
      if (o2 = true, void 0 !== i2) {
        for (let t5 = 0, e2 = n.length; t5 < e2; t5++) if (!n[t5].filter(i2)) {
          o2 = false;
          break;
        }
        o2 && t4.push(a);
      }
    }
    else for (const i2 of e.keys()) {
      o2 = true;
      const a = e.get(i2);
      if (void 0 !== a) {
        for (let t5 = 0, e2 = n.length; t5 < e2; t5++) if (!n[t5].filter(a)) {
          o2 = false;
          break;
        }
        o2 && t4.push(i2);
      }
    }
    return t4;
  }
  update(t4 = false) {
    if (this.destroyed) return;
    const e = this.indexData.index, n = this.indexData.hash, o2 = this.hostData?.[0], i = this.indexData.parent;
    (0 === this.filtersData.filters.length && !this.sortData.compareFn || this.indexData.index && o2?.size !== this.indexData.index.length) && (this.indexData.index = null), this.filtersData.filters.length > 0 && (this.indexData.index = this.reduceImpl()), !this.indexData.index && i?.active && (this.indexData.index = [...i]), this.sortData.compareFn && o2 instanceof Map && (this.indexData.index || (this.indexData.index = [...o2.keys()]), this.indexData.index.sort(this.sortFn)), this.calcHashUpdate(e, n, t4), this.derivedAdapter?.update(t4);
  }
}
class DerivedMapAPI {
  clear;
  create;
  delete;
  destroy;
  get;
  constructor(t4) {
    this.clear = t4.clear.bind(t4), this.create = t4.create.bind(t4), this.delete = t4.delete.bind(t4), this.destroy = t4.destroy.bind(t4), this.get = t4.get.bind(t4), Object.freeze(this);
  }
}
class DynMapReducerDerived {
  #nn;
  #Ve;
  #on;
  #in;
  #Ze = { filters: [] };
  #an;
  #rn;
  #sn;
  #Qe = { compareFn: null };
  #C = [];
  #Xe = false;
  constructor(t4, e, n) {
    this.#nn = t4, this.#an = new MapIndexer(this.#nn, this.#D.bind(this), e), this.#rn = new IndexerAPI(this.#an), this.#in = new AdapterFilters(this.#rn.update, this.#Ze), this.#sn = new AdapterSort(this.#rn.update, this.#Qe), this.#Ve = new AdapterDerived(this.#nn, this.#rn, DynMapReducerDerived), this.#on = new DerivedMapAPI(this.#Ve), this.#an.initAdapters(this.#Ze, this.#Qe, this.#Ve);
    const { filters: o2, sort: i } = n;
    if (void 0 !== o2) {
      if (!DynReducerUtils.isIterable(o2)) throw new TypeError("DerivedMapReducer error (DataDerivedOptions): 'filters' attribute is not iterable.");
      this.filters.add(...o2);
    }
    if (void 0 !== i) {
      if ("function" != typeof i && ("object" != typeof i || null === i)) throw new TypeError("DerivedMapReducer error (DataDerivedOptions): 'sort' attribute is not a function or object.");
      this.sort.set(i);
    }
  }
  get derived() {
    return this.#on;
  }
  get filters() {
    return this.#in;
  }
  get index() {
    return this.#rn;
  }
  get destroyed() {
    return this.#Xe;
  }
  get length() {
    const t4 = this.#nn?.[0];
    return this.#an.active ? this.index.length : t4 ? t4.size : 0;
  }
  get reversed() {
    return this.#an.indexData.reversed;
  }
  get sort() {
    return this.#sn;
  }
  set reversed(t4) {
    if ("boolean" != typeof t4) throw new TypeError("DerivedMapReducer.reversed error: 'reversed' is not a boolean.");
    this.#an.indexData.reversed = t4, this.index.update(true);
  }
  destroy() {
    this.#Xe = true, this.#nn = [null], this.#an.update(true), this.#C.length = 0, this.#Ve.destroy(), this.#an.destroy(), this.#in.clear(), this.#sn.clear();
  }
  initialize(t4) {
  }
  *[Symbol.iterator]() {
    const t4 = this.#nn?.[0] ?? null;
    if (!this.#Xe && null !== t4 && 0 !== t4?.size) if (this.#an.active) for (const e of this.index) yield t4.get(e);
    else if (this.reversed) {
      const e = [...t4.values()];
      for (let t5 = e.length; --t5 >= 0; ) yield e[t5];
    } else for (const e of t4.values()) yield e;
  }
  subscribe(t4) {
    return -1 === this.#C.findIndex((e) => e === t4) && (this.#C.push(t4), t4(this)), () => {
      const e = this.#C.findIndex((e2) => e2 === t4);
      -1 !== e && this.#C.splice(e, 1);
    };
  }
  #D() {
    for (let t4 = 0; t4 < this.#C.length; t4++) this.#C[t4](this);
  }
}
class DynMapReducer {
  #nn = [null];
  #Ve;
  #on;
  #in;
  #Ze = { filters: [] };
  #an;
  #rn;
  #sn;
  #Qe = { compareFn: null };
  #C = [];
  #Xe = false;
  constructor(t4) {
    let e, n, o2;
    if (null === t4) throw new TypeError("DynMapReducer error: 'data' is not an object or Map.");
    if (void 0 !== t4 && "object" != typeof t4 && !(t4 instanceof Map)) throw new TypeError("DynMapReducer error: 'data' is not an object or Map.");
    if (void 0 !== t4 && t4 instanceof Map) e = t4;
    else if (void 0 !== t4 && ("data" in t4 || "filters" in t4 || "sort" in t4)) {
      if (void 0 !== t4.data && !(t4.data instanceof Map)) throw new TypeError("DynMapReducer error (DataDynMap): 'data' attribute is not a Map.");
      if (t4.data instanceof Map && (e = t4.data), void 0 !== t4.filters) {
        if (!DynReducerUtils.isIterable(t4.filters)) throw new TypeError("DynMapReducer error (DataDynMap): 'filters' attribute is not iterable.");
        n = t4.filters;
      }
      if (void 0 !== t4.sort) if ("function" == typeof t4.sort) o2 = t4.sort;
      else {
        if ("object" != typeof t4.sort || null === t4.sort) throw new TypeError("DynMapReducer error (DataDynMap): 'sort' attribute is not a function or object.");
        o2 = t4.sort;
      }
    }
    e && (this.#nn[0] = e), this.#an = new MapIndexer(this.#nn, this.#D.bind(this)), this.#rn = new IndexerAPI(this.#an), this.#in = new AdapterFilters(this.#rn.update, this.#Ze), this.#sn = new AdapterSort(this.#rn.update, this.#Qe), this.#Ve = new AdapterDerived(this.#nn, this.#rn, DynMapReducerDerived), this.#on = new DerivedMapAPI(this.#Ve), this.#an.initAdapters(this.#Ze, this.#Qe, this.#Ve), n && this.filters.add(...n), o2 && this.sort.set(o2);
  }
  get data() {
    return this.#nn[0];
  }
  get derived() {
    return this.#on;
  }
  get filters() {
    return this.#in;
  }
  get index() {
    return this.#rn;
  }
  get destroyed() {
    return this.#Xe;
  }
  get length() {
    const t4 = this.#nn[0];
    return this.#an.active ? this.#rn.length : t4 ? t4.size : 0;
  }
  get reversed() {
    return this.#an.indexData.reversed;
  }
  get sort() {
    return this.#sn;
  }
  set reversed(t4) {
    if ("boolean" != typeof t4) throw new TypeError("DynMapReducer.reversed error: 'reversed' is not a boolean.");
    this.#an.indexData.reversed = t4, this.index.update(true);
  }
  destroy() {
    this.#Xe || (this.#Xe = true, this.#Ve.destroy(), this.#nn = [null], this.index.update(true), this.#C.length = 0, this.#in.clear(), this.#sn.clear(), this.#an.destroy());
  }
  initialize(t4) {
  }
  setData(t4, e = false) {
    if (null !== t4 && !(t4 instanceof Map)) throw new TypeError("DynMapReducer.setData error: 'data' is not iterable.");
    if ("boolean" != typeof e) throw new TypeError("DynMapReducer.setData error: 'replace' is not a boolean.");
    const n = this.#nn[0];
    if (n instanceof Map && !e) if (t4 instanceof Map && n instanceof Map) {
      const e2 = new Set(n.keys());
      for (const o2 of t4.keys()) n.set(o2, t4.get(o2)), e2.has(o2) && e2.delete(o2);
      for (const t5 of e2) n.delete(t5);
    } else null === t4 && (this.#nn[0] = null);
    else this.#nn[0] = t4 instanceof Map ? t4 : null;
    this.#an.indexData.index = null, this.index.update(true);
  }
  subscribe(t4) {
    return -1 === this.#C.findIndex((e) => e === t4) && (this.#C.push(t4), t4(this)), () => {
      const e = this.#C.findIndex((e2) => e2 === t4);
      -1 !== e && this.#C.splice(e, 1);
    };
  }
  #D() {
    for (let t4 = 0; t4 < this.#C.length; t4++) this.#C[t4](this);
  }
  *[Symbol.iterator]() {
    const t4 = this.#nn[0];
    if (!this.#Xe && null !== t4 && 0 !== t4?.size) if (this.#an.active) for (const e of this.index) yield t4.get(e);
    else if (this.reversed) {
      const e = [...t4.values()];
      for (let t5 = e.length; --t5 >= 0; ) yield e[t5];
    } else for (const e of t4.values()) yield e;
  }
}
function isDocument(t4) {
  return null != t4 && t4 instanceof foundry.abstract.Document;
}
class EmbeddedStoreManager {
  static #cn = /(?<action>create|delete|update)(?<sep>\.?)(?<name>\w+)/;
  #ln = /* @__PURE__ */ new Map();
  #un;
  #pn = /* @__PURE__ */ new Map();
  #dn = /* @__PURE__ */ new Set();
  constructor(t4) {
    this.#un = t4, this.handleDocChange(), Object.seal(this);
  }
  create(t4, e) {
    const n = t4?.documentName;
    if ("string" != typeof n) throw new TypeError("EmbeddedStoreManager.create error: 'FoundryDoc' does not have a valid 'documentName' property.");
    const o2 = this.#un[0];
    let i = null;
    if (o2) try {
      i = o2.getEmbeddedCollection(n);
    } catch (t5) {
      console.warn(`EmbeddedStoreManager.create error: No valid embedded collection for: ${n}`);
    }
    let a, r2 = this.#ln.get(n);
    r2 || (r2 = { collection: i, stores: /* @__PURE__ */ new Map() }, this.#ln.set(n, r2));
    let s2, c = {};
    if ("string" == typeof e ? (a = e, s2 = DynMapReducer) : "function" == typeof e && hasPrototype(e, DynMapReducer) ? s2 = e : isObject$1(e) ? { name: a, ctor: s2 = DynMapReducer, ...c } = e : (a = n, s2 = DynMapReducer), !hasPrototype(s2, DynMapReducer)) throw new TypeError("EmbeddedStoreManager.create error: 'ctor' is not a 'DynMapReducer'.");
    if (a = a ?? s2?.name, "string" != typeof a) throw new TypeError("EmbeddedStoreManager.create error: 'name' is not a string.");
    if (r2.stores.has(a)) return r2.stores.get(a);
    {
      const t5 = new s2(i ? { data: i, ...c } : { ...c });
      return r2.stores.set(a, t5), "function" == typeof t5?.initialize && t5.initialize(c), t5;
    }
  }
  destroy(t4, e) {
    let n = 0;
    if (void 0 === t4) {
      for (const t5 of this.#ln.values()) {
        t5.collection = null;
        for (const e2 of t5.stores.values()) e2.destroy(), n++;
      }
      this.#ln.clear();
    } else {
      const o2 = t4?.documentName;
      if ("string" != typeof o2) throw new TypeError("EmbeddedStoreManager.delete error: 'FoundryDoc' does not have a valid 'documentName' property.");
      if (void 0 === e) {
        const t5 = this.#ln.get(o2);
        if (t5) {
          t5.collection = null;
          for (const e2 of t5.stores.values()) e2.destroy(), n++;
        }
        this.#ln.delete(o2);
      } else if ("string" === e) {
        const t5 = this.#ln.get(o2);
        if (t5) {
          const o3 = t5.stores.get(e);
          o3 && (o3.destroy(), n++);
        }
      }
    }
    return n > 0;
  }
  get(t4, e) {
    const n = t4?.documentName;
    if ("string" != typeof n) throw new TypeError("EmbeddedStoreManager.get error: 'FoundryDoc' does not have a valid 'documentName' property.");
    const o2 = this.#ln.get(n);
    if (o2) return o2.stores.get(e ?? n);
  }
  handleDocChange() {
    const t4 = this.#un[0];
    if (isDocument(t4)) {
      const e = new Set(this.#ln.keys()), n = Object.entries(t4.constructor?.metadata?.embedded ?? []);
      this.#pn.clear(), this.#dn.clear();
      for (const [o2, i] of n) {
        e.delete(o2), this.#dn.add(`create${o2}`), this.#dn.add(`delete${o2}`), this.#dn.add(`update${o2}`), this.#dn.add(`create.${i}`), this.#dn.add(`delete.${i}`), this.#dn.add(`update.${i}`), this.#dn.add(`create${i}`), this.#dn.add(`delete${i}`), this.#dn.add(`update${i}`), this.#pn.set(o2, o2), this.#pn.set(i, o2);
        let n2 = null;
        try {
          n2 = t4.getEmbeddedCollection(o2);
        } catch (t5) {
          console.warn(`EmbeddedStoreManager.handleDocUpdate error: No valid embedded collection for: ${o2}`);
        }
        const a = this.#ln.get(o2);
        if (a) {
          a.collection = n2;
          for (const t5 of a.stores.values()) t5.setData(a.collection, true);
        }
      }
      for (const t5 of e) {
        const e2 = this.#ln.get(t5);
        if (e2) {
          e2.collection = null;
          for (const t6 of e2.stores.values()) t6.setData(null, true);
        }
      }
    } else {
      this.#pn.clear(), this.#dn.clear();
      for (const t5 of this.#ln.values()) {
        t5.collection = null;
        for (const e of t5.stores.values()) e.setData(null, true);
      }
    }
  }
  handleUpdate(t4) {
    if (!this.#dn.has(t4)) return;
    const e = EmbeddedStoreManager.#cn.exec(t4);
    if (e && e.groups) {
      const t5 = e.groups.name, n = this.#pn.get(t5), o2 = this.#ln.get(n);
      if (o2) for (const t6 of o2.stores.values()) t6.index.update(true);
    }
  }
}
class TJSDocument {
  #mn;
  #un = [void 0];
  #fn;
  #_n;
  #hn;
  #Wt = {};
  #C = [];
  #gn;
  constructor(t4, e = {}) {
    this.#hn = `tjs-document-${Hashing.uuidv4()}`, this.#mn = { close: this.#$n.bind(this), render: this.#D.bind(this) }, isPlainObject(t4) ? this.setOptions(t4) : (this.setOptions(e), this.set(t4));
  }
  get embedded() {
    return this.#_n || (this.#fn = new EmbeddedStoreManager(this.#un), this.#_n = { create: (t4, e) => this.#fn.create(t4, e), destroy: (t4, e) => this.#fn.destroy(t4, e), get: (t4, e) => this.#fn.get(t4, e) }), this.#_n;
  }
  get updateOptions() {
    return this.#gn ?? { action: "unknown", data: [] };
  }
  get uuidv4() {
    return this.#hn;
  }
  #bn() {
    const t4 = this.#un[0];
    isDocument(t4) && isObject$1(t4?.apps) && !t4.apps[this.#hn] && (t4.apps[this.#hn] = this.#mn);
  }
  #yn() {
    const t4 = this.#un[0];
    isDocument(t4) && delete t4?.apps?.[this.#hn];
  }
  async #$n() {
    const t4 = this.#un[0];
    isDocument(t4) && !t4?.collection?.has(t4.id) && (this.#vn(void 0), "function" == typeof this.#Wt.preDelete && await this.#Wt.preDelete(t4), this.#D(false, { action: "delete" }), "function" == typeof this.#Wt.delete && await this.#Wt.delete(t4), await tick(), this.#gn = void 0);
  }
  destroy() {
    this.#fn && (this.#fn.destroy(), this.#fn = void 0, this.#_n = void 0), this.#vn(void 0), this.#Wt.delete = void 0, this.#Wt.preDelete = void 0, this.#C.length = 0;
  }
  get() {
    return this.#un[0];
  }
  static getUUIDFromDataTransfer(t4, { compendium: e = true, world: n = true, types: o2 } = {}) {
    if (!isObject$1(t4)) return;
    if (Array.isArray(o2) && !o2.includes(t4.type)) return;
    let i;
    if ("string" == typeof t4.uuid) {
      (t4.uuid.startsWith("Compendium") && e || n) && (i = t4.uuid);
    }
    return i;
  }
  set(t4, e = {}) {
    if (null != t4 && !isDocument(t4)) throw new TypeError("TJSDocument set error: 'document' is not a valid Document or undefined / null.");
    if (!isObject$1(e)) throw new TypeError("TJSDocument set error: 'options' is not an object.");
    this.#vn(t4) && (isDocument(t4) && this.#C.length && this.#bn(), this.#D(false, { ...e, action: "tjs-set-" + (null == t4 ? "undefined" : "new") }));
  }
  #vn(t4) {
    const e = t4 !== this.#un[0];
    return e && this.#yn(), this.#un[0] = null == t4 ? void 0 : t4, e && this.#fn && this.#fn.handleDocChange(), e;
  }
  async setFromDataTransfer(t4, e) {
    return this.setFromUUID(TJSDocument.getUUIDFromDataTransfer(t4, e));
  }
  async setFromUUID(t4, e) {
    if ("string" != typeof t4 || 0 === t4.length) return false;
    try {
      const n = await globalThis.fromUuid(t4);
      if (n) return this.set(n, e), true;
    } catch (t5) {
    }
    return false;
  }
  setOptions(t4) {
    if (!isObject$1(t4)) throw new TypeError("TJSDocument error: 'options' is not a plain object.");
    if (void 0 !== t4.delete && null !== t4.delete && "function" != typeof t4.delete) throw new TypeError("TJSDocument error: 'delete' attribute in options is not a function or null.");
    if (void 0 !== t4.preDelete && null !== t4.preDelete && "function" != typeof t4.preDelete) throw new TypeError("TJSDocument error: 'preDelete' attribute in options is not a function or null.");
    void 0 !== t4.delete && (this.#Wt.delete = t4.delete ?? void 0), void 0 !== t4.preDelete && (this.#Wt.preDelete = t4.preDelete ?? void 0);
  }
  subscribe(t4) {
    let e = false;
    if (-1 === this.#C.findIndex((e2) => e2 === t4) && (this.#C.push(t4), e = true), e) {
      1 === this.#C.length && this.#bn();
      const e2 = { action: "tjs-subscribe", data: [] };
      t4(this.#un[0], e2);
    }
    return () => {
      const e2 = this.#C.findIndex((e3) => e3 === t4);
      -1 !== e2 && this.#C.splice(e2, 1), 0 === this.#C.length && this.#yn();
    };
  }
  #D(t4, e = {}) {
    const n = { action: e.action ?? e.renderContext ?? "tjs-unknown", data: e.data ?? e.renderData ?? [] };
    Array.isArray(n.data) || (n.data = [n.data]), this.#gn = n;
    const o2 = this.#C, i = this.#un[0];
    for (let t5 = 0; t5 < o2.length; t5++) o2[t5](i, n);
    this.#fn && this.#fn.handleUpdate(n.action);
  }
}
function create_fragment$8(t4) {
  let e, n, o2;
  return { c() {
    e = element("button"), e.textContent = `${localize("EDITOR." + (t4[2] ? "Hide" : "Reveal"))}`, attr(e, "type", "button"), attr(e, "class", "reveal svelte-mobile-companion-dnd5e-81nkluj30u9vsd-1e62bm0");
  }, m(i, a) {
    insert(i, e, a), n || (o2 = listen(e, "click", t4[3]), n = true);
  }, p: noop$3, i: noop$3, o: noop$3, d(t5) {
    t5 && detach(e), n = false, o2();
  } };
}
function instance$7(t4, e, n) {
  let { onUpdateRevealButtons: o2 } = e, { sectionEl: i } = e;
  const a = i.classList.contains("revealed");
  return t4.$$set = (t5) => {
    "onUpdateRevealButtons" in t5 && n(0, o2 = t5.onUpdateRevealButtons), "sectionEl" in t5 && n(1, i = t5.sectionEl);
  }, [o2, i, a, () => o2(!a, i.id)];
}
class RevealSecretButton extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$7, create_fragment$8, safe_not_equal, { onUpdateRevealButtons: 0, sectionEl: 1 });
  }
}
function processHTML({ html: t4, process: e, selector: n, containerElement: o2 = "div", firstMatchOnly: i = false, namespaceURI: a }) {
  if ("string" != typeof t4) throw new TypeError("processHTML error: 'html' is not a string.");
  if ("function" != typeof e) throw new TypeError("processHTML error: 'process' is not a function.");
  if ("string" != typeof n) throw new TypeError("processHTML error: 'selector' is not a string.");
  if ("string" != typeof o2) throw new TypeError("processHTML error: 'containerElement' is not a string.");
  if ("boolean" != typeof i) throw new TypeError("processHTML error: 'firstMatchOnly' is not a boolean.");
  if (void 0 !== a && "string" != typeof a) throw new TypeError("processHTML error: 'namespaceURI' is not a string.");
  const r2 = a ? `${a}|${n}` : n, s2 = document.createElement(o2);
  if (s2.innerHTML = t4, i) {
    const t5 = s2.querySelector(r2);
    t5 && e(t5);
  } else {
    const t5 = s2.querySelectorAll(r2);
    if (t5) for (const n2 of t5) e(n2);
  }
  return s2.innerHTML;
}
function createMountRevealSecretButtons(t4, e) {
  function n(n2, o2) {
    const i = t4.get();
    if (i && "string" == typeof e?.fieldName) {
      const t5 = safeAccess(i, e?.fieldName);
      if ("string" == typeof t5) {
        const a = processHTML({ html: t5, process: (t6) => t6.classList[n2 ? "add" : "remove"]("revealed"), selector: `section.secret[id=${o2}]`, firstMatchOnly: true });
        i.update({ [e?.fieldName]: a });
      }
    }
  }
  return (o2) => {
    const i = [];
    function a() {
      for (const t5 of i) t5.$destroy();
      i.length = 0;
    }
    return { update({ mountRevealButtons: r2 }) {
      r2 && t4.get() && "string" == typeof e?.fieldName ? nextAnimationFrame().then(() => {
        a();
        const t5 = o2.querySelectorAll("section.secret[id]");
        for (const e2 of t5) i.push(new RevealSecretButton({ target: e2, anchor: e2.firstChild, props: { onUpdateRevealButtons: n, sectionEl: e2 } }));
      }) : a();
    }, destroy() {
      a();
    } };
  };
}
class PMImpl {
  static setInitialSelection(t4, e) {
    const n = t4.state.tr, o2 = n.doc, i = e.initialSelection, a = "all" === i || "end" === i || "start" === i ? i : "start", r2 = globalThis.ProseMirror.TextSelection.atStart(o2).from, s2 = globalThis.ProseMirror.TextSelection.atEnd(o2).to;
    let c;
    switch (a) {
      case "all": {
        const t5 = clamp(0, r2, s2), e2 = clamp(o2.content.size, r2, s2);
        c = n.setSelection(globalThis.ProseMirror.TextSelection.create(o2, t5, e2));
        break;
      }
      case "end": {
        const t5 = clamp(o2.content.size, r2, s2), e2 = clamp(o2.content.size, r2, s2);
        c = n.setSelection(globalThis.ProseMirror.TextSelection.create(o2, t5, e2));
        break;
      }
      case "start": {
        const t5 = clamp(0, r2, s2), e2 = clamp(0, r2, s2);
        c = n.setSelection(globalThis.ProseMirror.TextSelection.create(o2, t5, e2));
        break;
      }
    }
    c && (c.scrollIntoView(), t4.dispatch(c));
  }
}
const ProseMirrorKeyMaps = globalThis.ProseMirror ? globalThis.ProseMirror.ProseMirrorKeyMaps : class {
};
class TJSKeyMaps extends ProseMirrorKeyMaps {
  #kn;
  constructor(t4, e) {
    super(t4, e), "function" == typeof e.onQuit && (this.#kn = e.onQuit);
  }
  buildMapping() {
    const t4 = super.buildMapping();
    return this.#kn && (t4.Escape && (t4["Mod-p"] = t4.Escape), t4.Escape = () => this.#kn()), t4;
  }
}
const Plugin = globalThis.ProseMirror ? globalThis.ProseMirror.Plugin : class {
}, PluginKey = globalThis.ProseMirror ? globalThis.ProseMirror.PluginKey : class {
};
class TJSPasteUUID {
  static #wn = /(\.).*([a-zA-Z0-9]{16})/;
  static build() {
    const t4 = new this();
    return new Plugin({ key: new PluginKey("tjsPasteRawUUID"), props: { transformPastedText: (e) => t4.#Sn(e) } });
  }
  #Sn(t4) {
    if ("string" == typeof t4) try {
      if (TJSPasteUUID.#wn.test(t4)) {
        const e = globalThis.fromUuidSync(t4);
        e && (t4 = `@UUID[${t4}]{${"string" == typeof e.name ? e.name : "Unknown"}}`);
      }
    } catch (t5) {
    }
    return t4;
  }
}
function create_if_block_1$1(t4) {
  let e, n, o2;
  return { c() {
    e = element("a"), e.innerHTML = '<i class="fas fa-edit"></i>', attr(e, "class", "editor-edit svelte-mobile-companion-dnd5e-81nkluj30u9vsd-yxbnoz"), attr(e, "role", "button"), attr(e, "tabindex", "-1");
  }, m(i, a) {
    insert(i, e, a), n || (o2 = listen(e, "click", t4[19]), n = true);
  }, p: noop$3, d(t5) {
    t5 && detach(e), n = false, o2();
  } };
}
function create_else_block$1(t4) {
  let e;
  return { c() {
    e = element("div"), attr(e, "class", "editor-enriched svelte-mobile-companion-dnd5e-81nkluj30u9vsd-yxbnoz");
  }, m(n, o2) {
    insert(n, e, o2), e.innerHTML = t4[1];
  }, p(t5, n) {
    2 & n && (e.innerHTML = t5[1]);
  }, d(t5) {
    t5 && detach(e);
  } };
}
function create_if_block$3(t4) {
  let e;
  return { c() {
    e = element("div"), attr(e, "class", "editor-content svelte-mobile-companion-dnd5e-81nkluj30u9vsd-yxbnoz");
  }, m(n, o2) {
    insert(n, e, o2), t4[20](e);
  }, p: noop$3, d(n) {
    n && detach(e), t4[20](null);
  } };
}
function create_fragment$7(t4) {
  let e, n, o2, i, a, r2, s2, c = t4[6] && create_if_block_1$1(t4);
  function l(t5, e2) {
    return t5[4] ? create_if_block$3 : create_else_block$1;
  }
  let u = l(t4), p2 = u(t4);
  return { c() {
    e = element("div"), c && c.c(), n = space(), p2.c(), attr(e, "class", o2 = "editor prosemirror tjs-editor " + (Array.isArray(t4[0]?.classes) ? t4[0].classes.join(" ") : "") + " svelte-mobile-companion-dnd5e-81nkluj30u9vsd-yxbnoz"), attr(e, "role", "textbox"), attr(e, "tabindex", "0"), toggle_class(e, "click-to-edit", t4[2]), toggle_class(e, "editor-active", t4[4]);
  }, m(o3, l2) {
    insert(o3, e, l2), c && c.m(e, null), append(e, n), p2.m(e, null), t4[21](e), r2 || (s2 = [action_destroyer(i = applyStyles.call(null, e, t4[0]?.styles)), action_destroyer(a = t4[10].call(null, e, { mountRevealButtons: !t4[4] && t4[3], enrichedContent: t4[1] })), listen(e, "click", t4[12]), listen(e, "keydown", t4[13]), listen(e, "keyup", t4[14])], r2 = true);
  }, p(t5, [r3]) {
    t5[6] ? c ? c.p(t5, r3) : (c = create_if_block_1$1(t5), c.c(), c.m(e, n)) : c && (c.d(1), c = null), u === (u = l(t5)) && p2 ? p2.p(t5, r3) : (p2.d(1), p2 = u(t5), p2 && (p2.c(), p2.m(e, null))), 1 & r3 && o2 !== (o2 = "editor prosemirror tjs-editor " + (Array.isArray(t5[0]?.classes) ? t5[0].classes.join(" ") : "") + " svelte-mobile-companion-dnd5e-81nkluj30u9vsd-yxbnoz") && attr(e, "class", o2), i && is_function(i.update) && 1 & r3 && i.update.call(null, t5[0]?.styles), a && is_function(a.update) && 26 & r3 && a.update.call(null, { mountRevealButtons: !t5[4] && t5[3], enrichedContent: t5[1] }), 5 & r3 && toggle_class(e, "click-to-edit", t5[2]), 17 & r3 && toggle_class(e, "editor-active", t5[4]);
  }, i: noop$3, o: noop$3, d(n2) {
    n2 && detach(e), c && c.d(), p2.d(), t4[21](null), r2 = false, run_all(s2);
  } };
}
function instance$6(t4, e, n) {
  let o2, i, { content: a = "" } = e, { enrichedContent: r2 = "" } = e, { options: s2 = {} } = e;
  const c = getContext("#external")?.application, l = c?.reactive?.storeUIState?.activeWindow ?? writable(globalThis);
  component_subscribe(t4, l, (t5) => n(18, i = t5));
  const u = createEventDispatcher(), p2 = new TJSDocument({ delete: function(t5) {
    isObject$1(s2) && n(0, s2.document = void 0, s2);
    w2(), u("editor:document:deleted", { document: t5 }), n(15, a = ""), n(1, r2 = "");
  } });
  component_subscribe(t4, p2, (t5) => n(17, o2 = t5));
  const d = createMountRevealSecretButtons(p2, s2);
  let m, f, _, h, g2, $2, b = i, y = true, v = false, k = false;
  function w2(t5 = true) {
    _ && (_.destroy(), _ = void 0, setTimeout(() => {
      n(4, v = false);
    }, 0), k && (k = false, setTimeout(() => {
      CrossWindow.isHTMLElement(g2) && g2?.isConnected && g2.focus();
    }, 100)), t5 && u("editor:cancel"));
  }
  async function S2() {
    const t5 = "boolean" != typeof s2?.button || s2.button, e2 = { ...s2, plugins: { ...ProseMirror.defaultPlugins, menu: ProseMirror.ProseMirrorMenu.build(ProseMirror.defaultSchema, { compact: "boolean" == typeof s2?.menuCompact && s2.menuCompact, destroyOnSave: t5, onSave: () => T({ remove: t5 }) }), keyMaps: TJSKeyMaps.build(ProseMirror.defaultSchema, { onSave: () => T({ remove: t5 }), onQuit: () => w2() }), tjsPasteRawUUID: TJSPasteUUID.build(), ...isObject$1(s2?.plugins) ? s2.plugins : {} } };
    n(4, v = true), await tick(), _ = await ProseMirrorEditor.create(f, a, e2);
    const o3 = g2.querySelector(".editor-container");
    o3 && (o3.style = "margin: var(--tjs-editor-container-margin, 0)"), _.view.focus(), PMImpl.setInitialSelection(_.view, s2), u("editor:start");
  }
  function T({ remove: t5 = true } = {}) {
    if (_) {
      if (_.isDirty()) {
        let t6 = ProseMirror.dom.serializeString(_.view.state.doc);
        o2 && "string" == typeof s2?.fieldName ? o2.update({ [s2.fieldName]: t6 }) : n(15, a = t6), u("editor:save", { content: t6 });
      }
      t5 && w2(false);
    }
  }
  onDestroy(() => {
    v ? T({ remove: "boolean" != typeof s2?.button || s2.button }) : w2();
  }), onMount(() => {
    !y || h || m || S2();
  });
  return t4.$$set = (t5) => {
    "content" in t5 && n(15, a = t5.content), "enrichedContent" in t5 && n(1, r2 = t5.enrichedContent), "options" in t5 && n(0, s2 = t5.options);
  }, t4.$$.update = () => {
    if (327696 & t4.$$.dirty && b !== i && (v && T(), n(16, b = i)), 131081 & t4.$$.dirty && (n(3, y = "boolean" == typeof s2?.editable ? s2.editable : game.user.isGM || ((o2 ?? s2.document)?.isOwner ?? false)), y || w2()), 25 & t4.$$.dirty && n(2, m = !v && y && "boolean" == typeof s2?.clickToEdit && s2.clickToEdit), 29 & t4.$$.dirty && n(6, h = !v && y && ("boolean" != typeof s2?.button || s2.button) && !m), 1 & t4.$$.dirty && ($2 = "string" == typeof s2?.keyCode ? s2.keyCode : "Enter"), 131073 & t4.$$.dirty) if (void 0 !== s2?.document) {
      if (!(s2.document instanceof globalThis.foundry.abstract.Document)) throw new TypeError("TJSProseMirror error: 'options.document' is not a Foundry document.");
      if ("string" != typeof s2?.fieldName) throw new TypeError("TJSProseMirror error: 'options.document' is defined, but 'options.fieldName' is not a string.");
      s2.document !== o2 && (n(1, r2 = ""), n(15, a = ""), w2(), p2.set(s2.document));
    } else o2 && (n(1, r2 = ""), n(15, a = ""), w2(), p2.set(void 0));
    163841 & t4.$$.dirty && (n(15, a = void 0 !== o2 && "string" == typeof s2?.fieldName ? globalThis.foundry.utils.getProperty(o2, s2.fieldName) : "string" == typeof a ? a : ""), async function(t5, e2) {
      if ("string" == typeof t5) if (e2) {
        const e3 = o2?.isOwner ?? false, i2 = o2 ?? void 0, a2 = isObject$1(s2?.enrichOptions) ? { secrets: globalThis.game.user.isGM || e3, relativeTo: i2, ...s2.enrichOptions, async: true } : { async: true, relativeTo: i2, secrets: globalThis.game.user.isGM || e3 };
        n(1, r2 = await TextEditor.enrichHTML(t5, a2));
      } else n(1, r2 = t5);
      else n(1, r2 = "");
      u("editor:enrichedContent", { enrichedContent: r2 });
    }(a, "boolean" != typeof s2?.enrichContent || s2.enrichContent));
  }, [s2, r2, m, y, v, f, h, g2, l, p2, d, S2, function() {
    !v && m && S2();
  }, function(t5) {
    v ? ("Escape" === t5.code || "KeyS" === t5.code && (t5.ctrlKey || t5.metaKey)) && (t5.preventDefault(), t5.stopPropagation()) : t5.code === $2 && (t5.preventDefault(), t5.stopPropagation());
  }, function(t5) {
    t5.code === $2 && (v || (k = true, S2()), t5.preventDefault(), t5.stopPropagation());
  }, a, b, o2, i, () => S2(), function(t5) {
    binding_callbacks[t5 ? "unshift" : "push"](() => {
      f = t5, n(5, f);
    });
  }, function(t5) {
    binding_callbacks[t5 ? "unshift" : "push"](() => {
      g2 = t5, n(7, g2);
    });
  }];
}
class TJSProseMirror extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$6, create_fragment$7, safe_not_equal, { content: 15, enrichedContent: 1, options: 0 });
  }
}
function create_fragment$6(t4) {
  let e, n, o2, i, a, r2, s2, c, l, u, p2, d, m, f, _, h, g2, $2, b, y, v, k, w2, S2, T, x2, E, O, A2, C, D, M, j, I, N, P2, F, R, L2, H, z, q, W, U, G2, B, J, V, X, Y;
  function Z(e2) {
    t4[25](e2);
  }
  s2 = new BioProperty({ props: { label: i18n("DND5E.Eyes"), value: t4[6] } }), l = new BioProperty({ props: { label: i18n("DND5E.Hair"), value: t4[3] } }), p2 = new BioProperty({ props: { label: i18n("DND5E.Skin"), value: t4[2] } }), f = new BioProperty({ props: { label: i18n("DND5E.Height"), value: t4[5] } }), h = new BioProperty({ props: { label: i18n("DND5E.Weight"), value: t4[0] } }), $2 = new BioProperty({ props: { label: i18n("DND5E.Age"), value: t4[1] } }), v = new BioProperty({ props: { label: i18n("DND5E.Appearance"), value: t4[9] } }), O = new BioProperty({ props: { label: i18n("DND5E.Alignment"), value: t4[13] } }), D = new BioProperty({ props: { label: i18n("DND5E.Gender"), value: t4[7] } }), I = new BioProperty({ props: { label: i18n("DND5E.Faith"), value: t4[4] } }), F = new BioProperty({ props: { label: i18n("DND5E.Ideals"), value: t4[12] } }), L2 = new BioProperty({ props: { label: i18n("DND5E.Bonds"), value: t4[11] } }), z = new BioProperty({ props: { label: i18n("DND5E.Flaws"), value: t4[10] } }), W = new BioProperty({ props: { label: i18n("DND5E.PersonalityTraits"), value: t4[8] } });
  let K = { options: t4[18] };
  return void 0 !== t4[14] && (K.content = t4[14]), V = new TJSProseMirror({ props: K }), binding_callbacks.push(() => bind(V, "content", Z)), V.$on("editor:cancel", t4[26]), V.$on("editor:save", t4[19]), { c() {
    e = element("div"), n = element("section"), o2 = element("h2"), o2.textContent = `${myi18n("PhysicalTraits")}`, i = space(), a = element("div"), r2 = element("div"), create_component(s2.$$.fragment), c = space(), create_component(l.$$.fragment), u = space(), create_component(p2.$$.fragment), d = space(), m = element("div"), create_component(f.$$.fragment), _ = space(), create_component(h.$$.fragment), g2 = space(), create_component($2.$$.fragment), b = space(), y = element("div"), create_component(v.$$.fragment), k = space(), w2 = element("section"), S2 = element("h2"), S2.textContent = `${myi18n("Identity")}`, T = space(), x2 = element("div"), E = element("div"), create_component(O.$$.fragment), A2 = space(), C = element("div"), create_component(D.$$.fragment), M = space(), j = element("div"), create_component(I.$$.fragment), N = space(), P2 = element("div"), create_component(F.$$.fragment), R = space(), create_component(L2.$$.fragment), H = space(), create_component(z.$$.fragment), q = space(), create_component(W.$$.fragment), U = space(), G2 = element("section"), B = element("h2"), B.textContent = `${i18n("DND5E.Biography")}`, J = space(), create_component(V.$$.fragment), attr(o2, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-sxigvt"), attr(r2, "class", "properties-group svelte-mobile-companion-dnd5e-81nkluj30u9vsd-sxigvt"), attr(m, "class", "properties-group svelte-mobile-companion-dnd5e-81nkluj30u9vsd-sxigvt"), attr(a, "class", "properties-grid svelte-mobile-companion-dnd5e-81nkluj30u9vsd-sxigvt"), attr(y, "class", "full-width svelte-mobile-companion-dnd5e-81nkluj30u9vsd-sxigvt"), attr(n, "class", "details-section svelte-mobile-companion-dnd5e-81nkluj30u9vsd-sxigvt"), attr(S2, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-sxigvt"), attr(E, "class", "properties-group svelte-mobile-companion-dnd5e-81nkluj30u9vsd-sxigvt"), attr(C, "class", "properties-group svelte-mobile-companion-dnd5e-81nkluj30u9vsd-sxigvt"), attr(j, "class", "properties-group svelte-mobile-companion-dnd5e-81nkluj30u9vsd-sxigvt"), attr(x2, "class", "properties-grid svelte-mobile-companion-dnd5e-81nkluj30u9vsd-sxigvt"), attr(P2, "class", "full-width svelte-mobile-companion-dnd5e-81nkluj30u9vsd-sxigvt"), attr(w2, "class", "details-section svelte-mobile-companion-dnd5e-81nkluj30u9vsd-sxigvt"), attr(B, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-sxigvt"), attr(G2, "class", "details-section biography svelte-mobile-companion-dnd5e-81nkluj30u9vsd-sxigvt"), attr(e, "class", "character-details svelte-mobile-companion-dnd5e-81nkluj30u9vsd-sxigvt"), toggle_class(e, "mobile", t4[15].mobile), toggle_class(e, "tablet", t4[15].tablet), toggle_class(e, "desktop", t4[15].desktop);
  }, m(t5, X2) {
    insert(t5, e, X2), append(e, n), append(n, o2), append(n, i), append(n, a), append(a, r2), mount_component(s2, r2, null), append(r2, c), mount_component(l, r2, null), append(r2, u), mount_component(p2, r2, null), append(a, d), append(a, m), mount_component(f, m, null), append(m, _), mount_component(h, m, null), append(m, g2), mount_component($2, m, null), append(n, b), append(n, y), mount_component(v, y, null), append(e, k), append(e, w2), append(w2, S2), append(w2, T), append(w2, x2), append(x2, E), mount_component(O, E, null), append(x2, A2), append(x2, C), mount_component(D, C, null), append(x2, M), append(x2, j), mount_component(I, j, null), append(w2, N), append(w2, P2), mount_component(F, P2, null), append(P2, R), mount_component(L2, P2, null), append(P2, H), mount_component(z, P2, null), append(P2, q), mount_component(W, P2, null), append(e, U), append(e, G2), append(G2, B), append(G2, J), mount_component(V, G2, null), Y = true;
  }, p(t5, [n2]) {
    const o3 = {};
    64 & n2 && (o3.value = t5[6]), s2.$set(o3);
    const i2 = {};
    8 & n2 && (i2.value = t5[3]), l.$set(i2);
    const a2 = {};
    4 & n2 && (a2.value = t5[2]), p2.$set(a2);
    const r3 = {};
    32 & n2 && (r3.value = t5[5]), f.$set(r3);
    const c2 = {};
    1 & n2 && (c2.value = t5[0]), h.$set(c2);
    const u2 = {};
    2 & n2 && (u2.value = t5[1]), $2.$set(u2);
    const d2 = {};
    512 & n2 && (d2.value = t5[9]), v.$set(d2);
    const m2 = {};
    8192 & n2 && (m2.value = t5[13]), O.$set(m2);
    const _2 = {};
    128 & n2 && (_2.value = t5[7]), D.$set(_2);
    const g3 = {};
    16 & n2 && (g3.value = t5[4]), I.$set(g3);
    const b2 = {};
    4096 & n2 && (b2.value = t5[12]), F.$set(b2);
    const y2 = {};
    2048 & n2 && (y2.value = t5[11]), L2.$set(y2);
    const k2 = {};
    1024 & n2 && (k2.value = t5[10]), z.$set(k2);
    const w3 = {};
    256 & n2 && (w3.value = t5[8]), W.$set(w3);
    const S3 = {};
    !X && 16384 & n2 && (X = true, S3.content = t5[14], add_flush_callback(() => X = false)), V.$set(S3), (!Y || 32768 & n2) && toggle_class(e, "mobile", t5[15].mobile), (!Y || 32768 & n2) && toggle_class(e, "tablet", t5[15].tablet), (!Y || 32768 & n2) && toggle_class(e, "desktop", t5[15].desktop);
  }, i(t5) {
    Y || (transition_in(s2.$$.fragment, t5), transition_in(l.$$.fragment, t5), transition_in(p2.$$.fragment, t5), transition_in(f.$$.fragment, t5), transition_in(h.$$.fragment, t5), transition_in($2.$$.fragment, t5), transition_in(v.$$.fragment, t5), transition_in(O.$$.fragment, t5), transition_in(D.$$.fragment, t5), transition_in(I.$$.fragment, t5), transition_in(F.$$.fragment, t5), transition_in(L2.$$.fragment, t5), transition_in(z.$$.fragment, t5), transition_in(W.$$.fragment, t5), transition_in(V.$$.fragment, t5), Y = true);
  }, o(t5) {
    transition_out(s2.$$.fragment, t5), transition_out(l.$$.fragment, t5), transition_out(p2.$$.fragment, t5), transition_out(f.$$.fragment, t5), transition_out(h.$$.fragment, t5), transition_out($2.$$.fragment, t5), transition_out(v.$$.fragment, t5), transition_out(O.$$.fragment, t5), transition_out(D.$$.fragment, t5), transition_out(I.$$.fragment, t5), transition_out(F.$$.fragment, t5), transition_out(L2.$$.fragment, t5), transition_out(z.$$.fragment, t5), transition_out(W.$$.fragment, t5), transition_out(V.$$.fragment, t5), Y = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(s2), destroy_component(l), destroy_component(p2), destroy_component(f), destroy_component(h), destroy_component($2), destroy_component(v), destroy_component(O), destroy_component(D), destroy_component(I), destroy_component(F), destroy_component(L2), destroy_component(z), destroy_component(W), destroy_component(V);
  } };
}
function instance$5(t4, e, n) {
  let o2, i, a, r2, s2, c, l, u, p2, d, m, f, _, h, g2, $2, b, y, v, k;
  var w2;
  const S2 = getContext(CONTEXT.ACTOR_STORE);
  component_subscribe(t4, S2, (t5) => n(23, v = t5));
  const T = getContext(CONTEXT.INNER_APP_WIDTH_STORE);
  component_subscribe(t4, T, (t5) => n(24, k = t5));
  const x2 = { button: true, clickToEdit: false, editable: game.settings.get(getFullModuleId(), ALLOW_BIO_EDIT) && !isReadOnlyActor(v) };
  return t4.$$.update = () => {
    16777216 & t4.$$.dirty && n(22, o2 = k), 4194304 & t4.$$.dirty && n(15, i = { mobile: o2 <= 600, tablet: o2 > 600 && o2 <= 1024, desktop: o2 > 1024 }), 8388608 & t4.$$.dirty && n(21, a = v.system.details), 3145728 & t4.$$.dirty && n(14, r2 = null === n(20, w2 = a.biography) || void 0 === w2 ? void 0 : w2.value), 2097152 & t4.$$.dirty && n(13, s2 = a.alignment), 2097152 & t4.$$.dirty && n(12, c = a.ideal), 2097152 & t4.$$.dirty && n(11, l = a.bond), 2097152 & t4.$$.dirty && n(10, u = a.flaw), 2097152 & t4.$$.dirty && n(9, p2 = a.appearance), 2097152 & t4.$$.dirty && n(8, d = a.trait), 2097152 & t4.$$.dirty && n(7, m = a.gender), 2097152 & t4.$$.dirty && n(6, f = a.eyes), 2097152 & t4.$$.dirty && n(5, _ = a.height), 2097152 & t4.$$.dirty && n(4, h = a.faith), 2097152 & t4.$$.dirty && n(3, g2 = a.hair), 2097152 & t4.$$.dirty && n(2, $2 = a.skin), 2097152 & t4.$$.dirty && n(1, b = a.age), 2097152 & t4.$$.dirty && n(0, y = a.weight);
  }, [y, b, $2, g2, h, _, f, m, d, p2, u, l, c, s2, r2, i, S2, T, x2, function(t5) {
    const e2 = t5.detail.content, n2 = {};
    n2["system.details.biography.value"] = e2, FoundryGateway.updateActor(v, n2);
  }, w2, a, o2, v, k, function(t5) {
    r2 = t5, n(14, r2), n(21, a), n(20, w2), n(23, v);
  }, () => console.log("editor:cancel")];
}
class Biography extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$5, create_fragment$6, safe_not_equal, {});
  }
}
function create_fragment$5(t4) {
  let e, n, o2, i;
  return o2 = new Biography({}), { c() {
    e = element("section"), n = element("section"), create_component(o2.$$.fragment), attr(n, "class", "content-scroll-list"), attr(e, "class", "category-content");
  }, m(t5, a) {
    insert(t5, e, a), append(e, n), mount_component(o2, n, null), i = true;
  }, p: noop$3, i(t5) {
    i || (transition_in(o2.$$.fragment, t5), i = true);
  }, o(t5) {
    transition_out(o2.$$.fragment, t5), i = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(o2);
  } };
}
class Biography_1 extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, null, create_fragment$5, safe_not_equal, {});
  }
}
function create_if_block_7(t4) {
  let e, n;
  return e = new CharacterSelect({}), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p: noop$3, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_if_block_6(t4) {
  let e, n;
  return e = new Biography_1({}), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p: noop$3, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_if_block_5(t4) {
  let e, n;
  return e = new Traits({ props: { actor: t4[1] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    2 & n2 && (o2.actor = t5[1]), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_if_block_4(t4) {
  let e, n;
  return e = new Spells({ props: { actor: t4[1] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    2 & n2 && (o2.actor = t5[1]), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_if_block_3(t4) {
  let e, n;
  return e = new Features({ props: { actor: t4[1] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    2 & n2 && (o2.actor = t5[1]), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_if_block_2(t4) {
  let e, n;
  return e = new Inventory({ props: { actor: t4[1] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    2 & n2 && (o2.actor = t5[1]), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_if_block_1(t4) {
  let e, n;
  return e = new Abilities({ props: { actor: t4[1] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    2 & n2 && (o2.actor = t5[1]), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_if_block$2(t4) {
  let e, n;
  return e = new Character_1({ props: { actor: t4[1] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, p(t5, n2) {
    const o2 = {};
    2 & n2 && (o2.actor = t5[1]), e.$set(o2);
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_fragment$4(t4) {
  let e, n, o2, i, a, r2, s2;
  n = new Header({ props: { customButtons: t4[4], activeFilter: t4[3], menuButtons: "right" === t4[7] ? menuButtons : void 0, headerStyle: t4[2] } });
  const c = [create_if_block$2, create_if_block_1, create_if_block_2, create_if_block_3, create_if_block_4, create_if_block_5, create_if_block_6, create_if_block_7], l = [];
  function u(t5, e2) {
    return t5[3] === Filters.Character ? 0 : t5[3] === Filters.Abilities ? 1 : t5[3] === Filters.Inventory ? 2 : t5[3] === Filters.Features ? 3 : t5[3] === Filters.Spell ? 4 : t5[3] === Filters.Traits ? 5 : t5[3] === Filters.Biography ? 6 : t5[3] === Filters.CharacterSelect ? 7 : -1;
  }
  return ~(i = u(t4)) && (a = l[i] = c[i](t4)), { c() {
    e = element("div"), create_component(n.$$.fragment), o2 = space(), a && a.c(), attr(e, "class", "pd-8 dnd5e-container svelte-mobile-companion-dnd5e-81nkluj30u9vsd-12riche"), attr(e, "style", r2 = `width: ${t4[0]}vw;`);
  }, m(t5, a2) {
    insert(t5, e, a2), mount_component(n, e, null), append(e, o2), ~i && l[i].m(e, null), s2 = true;
  }, p(t5, [o3]) {
    const p2 = {};
    16 & o3 && (p2.customButtons = t5[4]), 8 & o3 && (p2.activeFilter = t5[3]), 4 & o3 && (p2.headerStyle = t5[2]), n.$set(p2);
    let d = i;
    i = u(t5), i === d ? ~i && l[i].p(t5, o3) : (a && (group_outros(), transition_out(l[d], 1, 1, () => {
      l[d] = null;
    }), check_outros()), ~i ? (a = l[i], a ? a.p(t5, o3) : (a = l[i] = c[i](t5), a.c()), transition_in(a, 1), a.m(e, null)) : a = null), (!s2 || 1 & o3 && r2 !== (r2 = `width: ${t5[0]}vw;`)) && attr(e, "style", r2);
  }, i(t5) {
    s2 || (transition_in(n.$$.fragment, t5), transition_in(a), s2 = true);
  }, o(t5) {
    transition_out(n.$$.fragment, t5), transition_out(a), s2 = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(n), ~i && l[i].d();
  } };
}
function instance$4(t4, e, n) {
  let o2, i, a, r2, s2, c, l, u, p2, d = noop$3, m = noop$3;
  t4.$$.on_destroy.push(() => d()), t4.$$.on_destroy.push(() => m());
  let { mainWidth: f } = e;
  const _ = getContext(CONTEXT.SWITCH_FILTER), h = getContext(CONTEXT.GET_CURRENT_FILTER), g2 = getContext(CONTEXT.SIDE);
  return t4.$$set = (t5) => {
    "mainWidth" in t5 && n(0, f = t5.mainWidth);
  }, t4.$$.update = () => {
    512 & t4.$$.dirty && n(1, a = u), 2 & t4.$$.dirty && n(8, s2 = a.collections.items.some((t5) => "spell" === t5.type)), 256 & t4.$$.dirty && n(4, r2 = getHeaderButtons(s2, _, h)), 1024 & t4.$$.dirty && n(3, c = p2), 512 & t4.$$.dirty && n(2, l = isReadOnlyActor(u) ? ["background-color: #660066;"] : []);
  }, n(6, o2 = getContext(CONTEXT.ACTOR_STORE)), d(), d = subscribe(o2, (t5) => n(9, u = t5)), n(5, i = getContext(CONTEXT.ACTIVE_FILTER_STORE)), m(), m = subscribe(i, (t5) => n(10, p2 = t5)), [f, a, l, c, r2, i, o2, g2, s2, u, p2];
}
class App extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$4, create_fragment$4, safe_not_equal, { mainWidth: 0 });
  }
}
function create_else_block(t4) {
  let e, n, o2;
  return n = new Patreon({ props: { subject: "Splitscreen" } }), { c() {
    e = element("div"), create_component(n.$$.fragment), attr(e, "class", "patron svelte-mobile-companion-dnd5e-81nkluj30u9vsd-or3rxj");
  }, m(t5, i) {
    insert(t5, e, i), mount_component(n, e, null), o2 = true;
  }, i(t5) {
    o2 || (transition_in(n.$$.fragment, t5), o2 = true);
  }, o(t5) {
    transition_out(n.$$.fragment, t5), o2 = false;
  }, d(t5) {
    t5 && detach(e), destroy_component(n);
  } };
}
function create_if_block$1(t4) {
  let e, n;
  return e = new App({ props: { mainWidth: 50 } }), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_fragment$3(t4) {
  let e, n, o2, i;
  const a = [create_if_block$1, create_else_block], r2 = [];
  return n = 1, o2 = r2[1] = a[1](t4), { c() {
    e = element("section"), o2.c(), attr(e, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-or3rxj");
  }, m(n2, o3) {
    insert(n2, e, o3), r2[1].m(e, null), t4[1](e), i = true;
  }, p: noop$3, i(t5) {
    i || (transition_in(o2), i = true);
  }, o(t5) {
    transition_out(o2), i = false;
  }, d(n2) {
    n2 && detach(e), r2[1].d(), t4[1](null);
  } };
}
function instance$3(t4, e, n) {
  const o2 = writable({ width: 0, isLargeScreen: false });
  let i, a;
  setContext(CONTEXT.ACTOR_STORE, actorStore$1), setContext(CONTEXT.ACTIVE_FILTER_STORE, activeFilterStore$1), setContext(CONTEXT.SWITCH_FILTER, switchFilter$1), setContext(CONTEXT.GET_CURRENT_FILTER, getCurrentFilterLeft), setContext(CONTEXT.INNER_APP_WIDTH_STORE, o2), setContext(CONTEXT.SIDE, "left"), setContext(CONTEXT.ACTIVE_SPELL_FILTER, writable([])), setContext(CONTEXT.ACTIVE_OBJECT_FILTER, writable([]));
  const r2 = new ResizeObserver((t5) => {
    a = t5[0].contentRect.width, o2.set({ width: a, isLargeScreen: a >= 600 });
  });
  return onMount(() => {
    handleOnMount$1(), a = i.offsetWidth, o2.set({ width: a, isLargeScreen: a >= 600 }), r2.observe(i);
  }), onDestroy(() => {
    handleOffMount$1(), r2.disconnect();
  }), [i, function(t5) {
    binding_callbacks[t5 ? "unshift" : "push"](() => {
      i = t5, n(0, i);
    });
  }];
}
class LeftScreen extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$3, create_fragment$3, safe_not_equal, {});
  }
}
function create_fragment$2(t4) {
  let e, n, o2;
  return n = new App({ props: { mainWidth: t4[2] } }), { c() {
    e = element("section"), create_component(n.$$.fragment);
  }, m(i, a) {
    insert(i, e, a), mount_component(n, e, null), t4[6](e), o2 = true;
  }, p(t5, [e2]) {
    const o3 = {};
    4 & e2 && (o3.mainWidth = t5[2]), n.$set(o3);
  }, i(t5) {
    o2 || (transition_in(n.$$.fragment, t5), o2 = true);
  }, o(t5) {
    transition_out(n.$$.fragment, t5), o2 = false;
  }, d(o3) {
    o3 && detach(e), destroy_component(n), t4[6](null);
  } };
}
function instance$2(t4, e, n) {
  let o2, i, a, r2, s2 = noop$3, c = noop$3;
  t4.$$.on_destroy.push(() => s2()), t4.$$.on_destroy.push(() => c());
  const l = writable({ width: 0, isLargeScreen: false });
  let u, p2;
  setContext(CONTEXT.ACTOR_STORE, actorStore), setContext(CONTEXT.ACTIVE_FILTER_STORE, activeFilterStore), setContext(CONTEXT.SWITCH_FILTER, switchFilter), setContext(CONTEXT.GET_CURRENT_FILTER, getCurrentFilterRight), setContext(CONTEXT.INNER_APP_WIDTH_STORE, l), setContext(CONTEXT.SIDE, "right"), setContext(CONTEXT.ACTIVE_SPELL_FILTER, writable([])), setContext(CONTEXT.ACTIVE_OBJECT_FILTER, writable([]));
  const d = new ResizeObserver((t5) => {
    p2 = t5[0].contentRect.width, l.set({ width: p2, isLargeScreen: p2 >= 600 });
  });
  onMount(() => {
    handleOnMount(), p2 = u.offsetWidth, l.set({ width: p2, isLargeScreen: p2 >= 600 }), d.observe(u);
  }), onDestroy(() => {
    handleOffMount(), d.disconnect();
  });
  let m = 100;
  return t4.$$.update = () => {
    49 & t4.$$.dirty && n(2, m = r2 ? 50 : i ? a : 100);
  }, n(3, o2 = mobileCompanionGameSettings.getWritableStore(SPLITSCREEN_ENABLED)), c(), c = subscribe(o2, (t5) => n(5, r2 = t5)), n(0, i = mobileCompanionGameSettings.getWritableStore(MAIN_WIDTH)), s2(), s2 = subscribe(i, (t5) => n(4, a = t5)), [i, u, m, o2, a, r2, function(t5) {
    binding_callbacks[t5 ? "unshift" : "push"](() => {
      u = t5, n(1, u);
    });
  }];
}
class RightScreen extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$2, create_fragment$2, safe_not_equal, {});
  }
}
function create_if_block(t4) {
  let e, n;
  return e = new LeftScreen({}), { c() {
    create_component(e.$$.fragment);
  }, m(t5, o2) {
    mount_component(e, t5, o2), n = true;
  }, i(t5) {
    n || (transition_in(e.$$.fragment, t5), n = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), n = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function create_default_slot$1(t4) {
  let e, n, o2, i, a, r2 = t4[3] && create_if_block();
  return o2 = new RightScreen({}), { c() {
    e = element("main"), r2 && r2.c(), n = space(), create_component(o2.$$.fragment), attr(e, "style", i = `background-image: url(${t4[2]})`), attr(e, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-101n127");
  }, m(t5, i2) {
    insert(t5, e, i2), r2 && r2.m(e, null), append(e, n), mount_component(o2, e, null), a = true;
  }, p(t5, o3) {
    t5[3] ? r2 ? 8 & o3 && transition_in(r2, 1) : (r2 = create_if_block(), r2.c(), transition_in(r2, 1), r2.m(e, n)) : r2 && (group_outros(), transition_out(r2, 1, 1, () => {
      r2 = null;
    }), check_outros()), (!a || 4 & o3 && i !== (i = `background-image: url(${t5[2]})`)) && attr(e, "style", i);
  }, i(t5) {
    a || (transition_in(r2), transition_in(o2.$$.fragment, t5), a = true);
  }, o(t5) {
    transition_out(r2), transition_out(o2.$$.fragment, t5), a = false;
  }, d(t5) {
    t5 && detach(e), r2 && r2.d(), destroy_component(o2);
  } };
}
function create_fragment$1(t4) {
  let e, n, o2;
  function i(e2) {
    t4[8](e2);
  }
  let a = { $$slots: { default: [create_default_slot$1] }, $$scope: { ctx: t4 } };
  return void 0 !== t4[0] && (a.elementRoot = t4[0]), e = new ApplicationShell({ props: a }), binding_callbacks.push(() => bind(e, "elementRoot", i)), { c() {
    create_component(e.$$.fragment);
  }, m(t5, n2) {
    mount_component(e, t5, n2), o2 = true;
  }, p(t5, [o3]) {
    const i2 = {};
    524 & o3 && (i2.$$scope = { dirty: o3, ctx: t5 }), !n && 1 & o3 && (n = true, i2.elementRoot = t5[0], add_flush_callback(() => n = false)), e.$set(i2);
  }, i(t5) {
    o2 || (transition_in(e.$$.fragment, t5), o2 = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), o2 = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function instance$1(t4, e, n) {
  let o2, i, a, r2, s2 = noop$3;
  t4.$$.on_destroy.push(() => s2());
  let { elementRoot: c } = e, { props: l } = e, { moduleName: u } = e;
  setContext(foundryContextId, u), initLeft(l), initRight(l);
  const p2 = mobileCompanionGameSettings.getWritableStore(BACKGROUND_IMG);
  return component_subscribe(t4, p2, (t5) => n(7, a = t5)), t4.$$set = (t5) => {
    "elementRoot" in t5 && n(0, c = t5.elementRoot), "props" in t5 && n(5, l = t5.props), "moduleName" in t5 && n(6, u = t5.moduleName);
  }, t4.$$.update = () => {
    128 & t4.$$.dirty && n(2, o2 = void 0);
  }, n(1, i = mobileCompanionGameSettings.getWritableStore(SPLITSCREEN_ENABLED)), s2(), s2 = subscribe(i, (t5) => n(3, r2 = t5)), [c, i, o2, r2, p2, l, u, a, function(t5) {
    c = t5, n(0, c);
  }];
}
let AppShell$1 = class extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance$1, create_fragment$1, safe_not_equal, { elementRoot: 0, props: 5, moduleName: 6 });
  }
  get elementRoot() {
    return this.$$.ctx[0];
  }
  set elementRoot(t4) {
    this.$$set({ elementRoot: t4 }), flush();
  }
  get props() {
    return this.$$.ctx[5];
  }
  set props(t4) {
    this.$$set({ props: t4 }), flush();
  }
  get moduleName() {
    return this.$$.ctx[6];
  }
  set moduleName(t4) {
    this.$$set({ moduleName: t4 }), flush();
  }
};
class AppShell extends SvelteApp {
  constructor(t4) {
    super(), this.options.svelte.props = t4;
  }
  static get defaultOptions() {
    return foundry.utils.mergeObject(super.defaultOptions, { title: "Mobile Companion Dnd5e", id: getBaseModuleId(), classes: [getBaseModuleId()], width: window.innerWidth, height: window.innerHeight, alwaysOnTop: true, resizable: false, svelte: { class: AppShell$1, target: document.body, props: {} } });
  }
}
function create_default_slot(t4) {
  let e, n, o2, i, a, r2, s2;
  return { c() {
    e = element("div"), n = element("h2"), n.textContent = "An error occurred", o2 = space(), i = element("strong"), i.textContent = "Mobile-Companion encountered an error:", a = space(), r2 = element("p"), s2 = text(t4[1]), attr(n, "class", "svelte-mobile-companion-dnd5e-81nkluj30u9vsd-5mhrnj"), attr(e, "class", "container svelte-mobile-companion-dnd5e-81nkluj30u9vsd-5mhrnj");
  }, m(t5, c) {
    insert(t5, e, c), append(e, n), append(e, o2), append(e, i), append(e, a), append(e, r2), append(r2, s2);
  }, p(t5, e2) {
    2 & e2 && set_data(s2, t5[1]);
  }, d(t5) {
    t5 && detach(e);
  } };
}
function create_fragment(t4) {
  let e, n, o2;
  function i(e2) {
    t4[2](e2);
  }
  let a = { $$slots: { default: [create_default_slot] }, $$scope: { ctx: t4 } };
  return void 0 !== t4[0] && (a.elementRoot = t4[0]), e = new ApplicationShell({ props: a }), binding_callbacks.push(() => bind(e, "elementRoot", i)), { c() {
    create_component(e.$$.fragment);
  }, m(t5, n2) {
    mount_component(e, t5, n2), o2 = true;
  }, p(t5, [o3]) {
    const i2 = {};
    10 & o3 && (i2.$$scope = { dirty: o3, ctx: t5 }), !n && 1 & o3 && (n = true, i2.elementRoot = t5[0], add_flush_callback(() => n = false)), e.$set(i2);
  }, i(t5) {
    o2 || (transition_in(e.$$.fragment, t5), o2 = true);
  }, o(t5) {
    transition_out(e.$$.fragment, t5), o2 = false;
  }, d(t5) {
    destroy_component(e, t5);
  } };
}
function instance(t4, e, n) {
  let { elementRoot: o2 } = e, { error: i } = e;
  return t4.$$set = (t5) => {
    "elementRoot" in t5 && n(0, o2 = t5.elementRoot), "error" in t5 && n(1, i = t5.error);
  }, [o2, i, function(t5) {
    o2 = t5, n(0, o2);
  }];
}
let ErrorShell$1 = class extends SvelteComponent {
  constructor(t4) {
    super(), init(this, t4, instance, create_fragment, safe_not_equal, { elementRoot: 0, error: 1 });
  }
  get elementRoot() {
    return this.$$.ctx[0];
  }
  set elementRoot(t4) {
    this.$$set({ elementRoot: t4 }), flush();
  }
  get error() {
    return this.$$.ctx[1];
  }
  set error(t4) {
    this.$$set({ error: t4 }), flush();
  }
};
class ErrorShell extends SvelteApp {
  constructor(t4) {
    super(), this.options.svelte.props.error = t4;
  }
  static get defaultOptions() {
    return foundry.utils.mergeObject(super.defaultOptions, { title: "Error", id: getBaseModuleId(), classes: ["error-shell"], width: "400px", height: "300px", zIndex: 99999, resizable: false, svelte: { class: ErrorShell$1, target: document.body, props: {} } });
  }
}
async function setupPerformanceSettings() {
  await game.settings.set("core", "noCanvas", true), await game.settings.set("core", "pixelRatioResolutionScaling", false), await game.settings.set("core", "visionAnimation", false), await game.settings.set("core", "mipmap", false), await game.settings.set("core", "performanceMode", CONST.CANVAS_PERFORMANCE_MODES.LOW), await game.settings.set("core", "maxFPS", 10);
}
function loadSheet() {
  try {
    activateSheet((t4) => new AppShell({ props: t4, moduleName: "mobile-companion-dnd5e" }));
  } catch (t4) {
    console.error(t4), new ErrorShell(t4.message).render(true);
  }
}
Hooks.once("init", async () => {
}), Hooks.once("setup", async () => {
  setSubModuleId("dnd5e"), mobileCompanionGameSettings.init(), isMobileCompanion() && await setupPerformanceSettings();
}), Hooks.once("ready", () => {
  onReady(loadSheet);
}), Hooks.on("renderItemSheet", (t4) => {
  onRenderItemSheet(t4);
}), Hooks.on("renderSettingsConfig", async (t4, e, n) => {
  renderSettingsConfig(e);
}), Hooks.on("renderActorSheet", (t4, e) => {
  isMobileCompanion() && handleReadOnlyActor(t4);
}), Hooks.on("renderActorSheetV2", (t4, e) => {
  isMobileCompanion() && handleReadOnlyActor(t4);
});
