import fs from"node:fs";import path from"node:path";import*as packages from"./packages/_module.mjs";globalThis.packages=packages;import lockfile from"proper-lockfile";import{createLogger,LogEntry}from"./logging.mjs";import configurePaths from"./paths.mjs";import ServerSettings from"./core/config.mjs";import License from"./core/license.mjs";import Updater from"./core/update.mjs";import*as database from"./database/database.mjs";import Files from"./files/files.mjs";import GameServer from"./core/game.mjs";import{World}from"./packages/_module.mjs";import Express from"./server/express.mjs";import UPnP from"./server/upnp.mjs";import{vtt}from"../common/constants.mjs";import{resetDemo}from"./components/demo.mjs";import{ReleaseData}from"../common/config.mjs";import{fromUuid}from"./core/utils.mjs";export default async function initialize({args:e=[],root:s,messages:o=[],debug:t=!1}={}){global.vtt="FoundryVTT",global.release=new ReleaseData(JSON.parse(fs.readFileSync(`${s}/package.json`,"utf8")).release),global.config={},global.startupMessages=o,global.fatalError=null,global.fromUuid=fromUuid;try{global.paths=configurePaths({root:s,messages:o,debug:t})}catch(e){process.stdout.write(e.stack),process.exit(1)}const r=global.paths,a=parseArgs(e),n=global.logger=createLogger(r,o,a);n.info(`Foundry Virtual Tabletop - Version ${global.release.generation} Build ${global.release.build}`),n.info(`User Data Directory - "${global.paths.user}"`),"adminKey"in a&&global.logger.warn("You are using the old --adminKey parameter which has been renamed to --adminPassword"),global.game=new GameServer;let i={};try{i=global.config=await initializeCriticalFunctions(a,r,n)}catch(e){e.message=`A fatal error occurred while trying to start the Foundry Virtual Tabletop server: ${e.message}`,(n||console).error(e),await new Promise((()=>setTimeout((()=>process.exit(1)),100)))}i.updater=new Updater(r);const{app:l,express:c,license:p,options:u,upnp:m}=i;global.db=i.db,global.getDocumentClass=db.getDocumentClass,global.express=i.express,global.options=i.options,p.needsSignature||await launchDefaultWorld(u);try{await c.listen()}catch(e){e.message=`Unable to start Express server: ${e.message}`,(n||console).error(e),await new Promise((()=>setTimeout((()=>process.exit(1)),100)))}return process.on("uncaughtException",(e=>n.error(e))),handleRestart(n),process.once("exit",(()=>handleShutdown({exit:!1,logger:n,express:c,upnp:m}))),process.once("SIGINT",process.exit.bind(null,0)),process.once("SIGTERM",process.exit.bind(null,0)),process.once("SIGHUP",process.exit.bind(null,0)),l&&l.initialize(c.address),i}async function initializeCriticalFunctions(e,s,o){testPermissions(),createUserDataStructure(),await acquireLockFile(),await clearUnnecessaryFiles();const t=ServerSettings.load();t.initialize(e);const r=new License(t.service);r.verify();const a=new Files(t);if(a.availableStorageNames.includes("s3"))try{await a.storages.s3.identifyEndpoint()}catch(e){o.error(`Failed to determine S3 endpoint: ${e.message}`),delete a.storages.s3}const n=t.upnp?new UPnP({port:t.port,ttl:t.upnpLeaseDuration}).createMapping():null;let i=null;if(t.isElectron){const{default:e}=await import("./interface/electron.mjs");i=new e(t)}const l=new Express(t,s,o);return await Promise.all([]),{adminPassword:t.adminPassword,app:i,db:database,express:l,files:a,license:r,logger:o,options:t,service:t.service,sockets:l.io.sockets.sockets,upnp:n,release:release,vtt:vtt}}function testPermissions(){const e=global.paths;try{const s=fs.existsSync(e.user)?e.user:path.dirname(e.user),o=path.join(s,".permission-test.txt");fs.writeFileSync(o,"test"),fs.unlinkSync(o)}catch(s){throw s.message=`You do not have permission to create content in ${e.user}: ${s.message}`,s}}function createUserDataStructure(){const e=global.paths,s=["user","data","config","logs"];for(let o of s)fs.mkdirSync(e[o],{recursive:!0});if(!fs.existsSync(e.options)){const s={dataPath:e.user},o=fs.existsSync(e.envOptions)?JSON.parse(fs.readFileSync(e.envOptions)):{},t=["compressStatic","fullscreen","hostname","language","localHostname","port","protocol","proxyPort","proxySSL","routePrefix","updateChannel","upnp","upnpLeaseDuration"];for(const e of t)s[e]=o[e];new ServerSettings(s).save()}const o=["systems","modules","worlds"],t={systems:"This directory contains systems which define game frameworks for use in Foundry VTT. Each system has its own uniquely named subdirectory containing a system.json manifest file.",modules:"This directory contains add-on modules which add or extend core VTT functionality. Each module has its own uniquely named subdirectory containing a module.json manifest file.",worlds:"This directory contains worlds which define the game and campaign settings in Foundry VTT. Each world has its own uniquely named subdirectory containing a world.json manifest file."};for(let s of o){let o=path.join(e.data,s);fs.mkdirSync(o,{recursive:!0}),fs.writeFileSync(path.join(o,"README.txt"),t[s])}}async function acquireLockFile(){const e=global.paths;if(await lockfile.check(e.options))throw new Error(`${vtt} cannot start in this directory which is already locked by another process.`);return lockfile.lock(e.options,{stale:1e4})}async function clearUnnecessaryFiles(){const e=global.paths,s=path.join(e.root,"certs");try{await fs.promises.rm(s,{force:!0,recursive:!0})}catch(e){}}function parseArgs(e){const s={},o=/^--/;for(let t of e){if(!o.test(t))continue;t=t.replace(o,"");const e=t.split("=");s[e[0]]=!(e.length>1)||e[1]}return"adminKey"in s&&(s.adminPassword=s.adminKey),s}async function launchDefaultWorld(e){if(e.demo?.sourceZip)try{return resetDemo()}catch(s){logger.warn(s),e.demo=null}if(e.world){const s=World.get(e.world,{strict:!1});if(!s?.canAutoLaunch)return logger.warn(`The requested World "${e.world}" is not available to auto-launch.`),void(e.world=null);try{await s.setup()}catch(o){logger.error(`The requested World "${e.world}" could not be auto-launched as it encountered an error.`),logger.error(o),e.world=null,await s.deactivate(null,{asAdmin:!0})}}}function handleRestart(e){process.env.restart&&(e.info("Server restarted after update"),delete process.env.restart)}function handleShutdown({exit:e=!0,logger:s,upnp:o,express:t}={}){s.info("Shutting down Foundry Virtual Tabletop server"),o&&o.removeMapping(),t&&t.server.close(),s.info("Shut-down success. Goodbye!"),e&&process.exit()}