import fs from"fs";import os from"os";import path from"path";import{spawn}from"child_process";import url from"url";import License from"./license.mjs";import Files from"../files/files.mjs";import{SOFTWARE_UPDATE_CHANNELS,TIMEOUTS}from"../../common/constants.mjs";import{fetchJsonWithTimeout}from"../../common/utils/http.mjs";import{ReleaseData}from"../../common/config.mjs";import FileDownloader from"../files/downloader.mjs";export default class Updater{constructor(e){this.appDir=e.root,this.updateDir=path.join(e.root,"_update"),this.platform=this._getPlatform(),this.target=null,this.availability={hasUpdate:!1,couldReachWebsite:!1,slowResponse:!1,version:null,channel:null,willDisableModules:!1},this._throttlePct=null,this._updateCheckTime=0}_getPlatform(){let e=os.platform();return"win32"===e?"win":"darwin"===e?"mac":"linux"}get file(){if(!this.target?.download)throw new Error("No target download URL has yet been identified!");const e=url.parse(this.target.download).pathname;return e?path.parse(e).base:null}get localDest(){return`${this.updateDir}/${this.file}`}async check({updateChannel:e="stable",forceUpdate:t}={}){if(t=["true",!0].includes(t),this.target=null,this.availability.version=null,this.availability.channel=null,this.availability.couldReachWebsite=!0,!((e={alpha:"prototype",beta:"testing",release:"stable"}[e]||e)in SOFTWARE_UPDATE_CHANNELS))throw new Error(`${e} is not a valid software update channel to check.`);e!==config.options.updateChannel&&(config.options.updateSource({updateChannel:e}),config.options.save());const s=await this.#e(),a=!0===config.options.telemetry,i=Date.now();let o;try{o=await this.#t(e,a?s:null)}catch(e){return 403!==e.code&&(logger.warn("The Foundry Virtual Tabletop website could not be reached to check for core software updates"),this.availability.couldReachWebsite=!1),null}finally{this.availability.slowResponse=Date.now()-i>2e3}if(globalThis.game.saveNews(o.news,o.featured_content),globalThis.release.updateSource({maxGeneration:o.max_generation,maxStableGeneration:o.max_stable_generation}),!1===o.valid_key)throw config.license.expire(),new Error("SETUP.UpdateLicenseInvalid");if(config.options.noupdate)throw new Error("SETUP.UpdateNoUpdateMode");if("error"===o.status){const e=new Error(o.message);if(e.messageCode=o.message_code,!("latest_release"in o))throw e}const n=new ReleaseData(o.latest_release);this.availability.hasUpdate=n.isNewer(config.release);const r=t||this.availability.hasUpdate;return r&&(logger.info(`Core software ${n.channel} update ${n.version} is available!`),this.target=n,this.availability.version=n.version,this.availability.channel=n.channel),this.availability.willDisableModules=r&&n.isGenerationalChange(config.release),this.target}async#t(e,t){return fetchJsonWithTimeout(License.SOFTWARE_UPDATE_URL,{headers:{"Content-Type":"application/json",Authorization:config.license.authorizationHeader},method:"POST",body:JSON.stringify({diagnostics:t,updateChannel:e,license:config.license.data,versions:{foundry:config.release.version,node:process.versions.node,electron:process.versions.electron}})},{timeoutMs:TIMEOUTS.PACKAGE_REPOSITORY})}update(){if(config.options.noupdate)throw new Error("You are not allowed to update this instance of Foundry Virtual Tabletop because it was launched in --noupdate mode.");return new Promise((async(e,t)=>{try{await this.download({onFetched:()=>e({})});await this.install()&&this.restart()}catch(e){this.progress({step:CONST.SETUP_PACKAGE_PROGRESS.STEPS.ERROR,message:e.message,pct:100}),t(e)}}))}async download({onFetched:e}={}){if(!this.target)throw new Error("No update target has been identified");try{fs.accessSync(paths.root,fs.constants.W_OK),await fs.promises.rm(this.updateDir,{force:!0,recursive:!0}),await fs.promises.mkdir(this.updateDir)}catch(e){throw console.error(e),new Error("You do not have permission to write files in your Foundry Virtual Tabletop installation \n      location. You may need to run the application as an Administrator to perform an update.")}const t=this.target.download=await this._getDownloadURL(this.target),s=CONST.SETUP_PACKAGE_PROGRESS.STEPS,a=new FileDownloader(t,this.localDest);return a.on("error",(e=>this.progress({step:s.ERROR,message:e.message,pct:100}))),a.on("progress",(e=>{this.progress({step:s.DOWNLOAD,message:"SETUP.UpdateDownloadingS",log:"Downloading software update",pct:Math.min(e,99)})})),e&&a.on("fetched",e),await a.download(),this.progress({step:s.DOWNLOAD,message:"SETUP.UpdateDownloadingC",log:"Update download complete",pct:100}),this.localDest}async _getDownloadURL(e){return(await fetchJsonWithTimeout(License.SOFTWARE_DOWNLOAD_URL,{headers:{"Content-Type":"application/json",Authorization:config.license.authorizationHeader},method:"POST",body:JSON.stringify({generation:e.generation,build:e.build,license:config.license.data})})).download}async install(){const e=CONST.SETUP_PACKAGE_PROGRESS.STEPS;if(!fs.existsSync(this.localDest))return this.progress({step:e.ERROR,message:"SETUP.UpdateNoArchive",log:"No archive",pct:100}),!1;const t=config.options.debug,s=t?path.join(this.appDir,"_testInstall"):this.appDir;t&&await fs.promises.rm(s,{force:!0,recursive:!0});const a=await Files.extractArchive(this.localDest,this.updateDir,{onProgress:(t,s,a,i)=>{this.progress({step:e.EXTRACT,message:"SETUP.UpdateExtractingS",log:"Extracting downloaded update files",pct:Math.min(i,99)})}});this.progress({step:e.EXTRACT,message:"SETUP.UpdateExtractingC",log:"Update extraction complete",pct:100}),fs.unlinkSync(this.localDest),this.progress({step:e.CLEANUP,message:"SETUP.UpdateCleaningS",log:"Cleaning existing folder content",pct:25});const i=t?[]:["dist","public","templates"];for(let[t,a]of i.entries()){await fs.promises.rm(path.join(s,a),{force:!0,recursive:!0});const o=Math.min(Math.round(t+2/i.length+1),99);this.progress({pct:o,step:e.CLEANUP,message:"SETUP.UpdateCleaningS",log:"Cleaning existing folder content"})}this.progress({step:e.CLEANUP,message:"SETUP.UpdateCleaningC",log:"Folder cleaning complete",pct:100});let o=0;return await Files.copyDirectory(this.updateDir,s,{onProgress:()=>{o++;let t=Math.clamped(Math.round(o/a*100),0,99);this.progress({step:e.INSTALL,message:"SETUP.UpdateInstallingS",log:"Installing update files",pct:t})},onError:async(e,t,s)=>{if("EBUSY"!==s.code)throw s;await Files.areFilesIdentical(e,t)||logger.error(`Attempting to overwrite file '${t}' failed as the file is in use by the process. It will be skipped, but this may cause instability in the application.`)},ignore:["package.json"]}),await fs.promises.copyFile(path.join(this.updateDir,"package.json"),path.join(s,"package.json")),this.progress({step:e.INSTALL,message:"SETUP.UpdateInstallingC",log:"Update installation complete",pct:100}),await fs.promises.rm(this.updateDir,{recursive:!0}),t&&await fs.promises.rm(s,{recursive:!0}),!0}async restart(e={}){const{options:t}=config;if(!t.isElectron)return setTimeout(process.exit,50),void this.progress({step:CONST.SETUP_PACKAGE_PROGRESS.STEPS.COMPLETE,message:"SETUP.UpdateCompleteManual",log:"Update Complete",pct:100});let s=process.argv[0],a=process.argv.slice(1)||[];e.restart=1,setTimeout((()=>{spawn(s,a,{detached:!0,cwd:this.appDir,stdio:"inherit",env:e}).unref(),process.exit()}),50),this.progress({step:CONST.SETUP_PACKAGE_PROGRESS.STEPS.COMPLETE,message:"SETUP.UpdateCompleteAuto",log:"Update Complete",pct:100})}progress({step:e,message:t,log:s,pct:a=0}={}){if(a===this._throttlePct)return;this._throttlePct=100===a?null:a;const{logger:i,express:o}=global.config;s??=t,i.info(a?`${s} - ${a}%`:s),o.io.emit("progress",{action:CONST.SETUP_PACKAGE_PROGRESS.ACTIONS.UPDATE_CORE,type:"core",name:"FoundryVTT",step:e,message:t,pct:a})}async checkCoreUpdateAvailability(){const{config:e,packages:t}=global,s=Date.now();if(s-this._updateCheckTime<864e5)return this.availability;this._updateCheckTime=s;try{await this.check({updateChannel:e.options.updateChannel})}catch{}return Object.values(t.PACKAGE_TYPE_MAPPING).forEach((e=>e.reevaluateAvailabilities())),this.availability}async#e(){const e={timestamp:Date.now()};e.os={platform:os.platform(),version:this.#s(),node:process.versions.node,electron:process.versions.electron},e.foundry={generation:config.release.generation,build:config.release.build,channel:config.options.updateChannel,hosting:config.service.key?config.service.id:null};for(const t of Object.values(packages.PACKAGE_TYPE_MAPPING)){const s=e[t.collection]={},a=t.getPackages();for(const e of a.values())e.manifest&&(s[e.id]={version:e.version})}e.playtime={total:0,max:0};for(const t of packages.World.packages.values())e.playtime.total+=t.playtime,t.playtime>e.playtime.max&&(e.playtime.max=t.playtime),t.system?.id in e.systems&&(e.systems[t.system.id].playtime||=0,e.systems[t.system.id].playtime+=t.playtime);const t=path.join(paths.logs,"diagnostics.json");return Files.writeFileSyncSafe(t,JSON.stringify(e,null,2)),e}#s(){try{const e=fs.readFileSync("/etc/os-release","utf-8").match(/^PRETTY_NAME="(.*)"$/m);return e?e[1]:os.release()}catch(e){return os.release()}}}