import fs from"fs";import path from"path";import yauzl from"yauzl";import LocalFileStorage from"./local.mjs";import S3FileStorage from"./s3.mjs";import{HTML_FILE_EXTENSIONS,MEDIA_MIME_TYPES,UPLOADABLE_FILE_EXTENSIONS}from"../../common/constants.mjs";import{getProperty,mergeObject,parseS3URL,formatFileSize}from"../../common/utils/helpers.mjs";import crypto from"crypto";import checkDiskSpace from"check-disk-space";export default class Files{constructor(e){this.storages={data:new LocalFileStorage("data",paths.data),public:new LocalFileStorage("public",paths.public),s3:S3FileStorage.fromConfig("s3",e.awsConfig)},this.configuration=this._loadConfig()}static STORAGE_CONFIGURATION_FILENAME="storage.json";_loadConfig(){const e=path.join(paths.config,Files.STORAGE_CONFIGURATION_FILENAME);return fs.existsSync(e)?JSON.parse(fs.readFileSync(e,"utf8")):{}}get availableStorageNames(){return Object.entries(this.storages).reduce(((e,t)=>(t[1]&&e.push(t[0]),e)),[])}getClientConfig(e){const t=this.availableStorageNames.filter((t=>{if(!e||e.hasRole("ASSISTANT"))return!0;const{configuration:s}=this.storages[t];return!0!==s[""]?.private})),s=this.storages.s3;return{storages:t,s3:s?{endpoint:s.endpoint,buckets:s.buckets}:null}}static async copyDirectory(e,t,{onProgress:s=null,onError:r=null,ignore:a=[],_root:i=!0}={}){i&&(a=a.map((t=>path.join(e,t)))),await fs.promises.mkdir(t,{recursive:!0});const o=fs.readdirSync(e);for(let i of o){let o=path.join(e,i),n=path.join(t,i);if(!a.includes(o))if(fs.lstatSync(o).isDirectory())await this.copyDirectory(o,n,{onProgress:s,onError:r,ignore:a,_root:!1});else{try{await fs.promises.copyFile(o,n)}catch(e){if(!(r instanceof Function))throw e;r(o,n,e)}s instanceof Function&&s(o,n)}}}static async getDirectorySize(e){if(!fs.existsSync(e))return;let t=0;const s=async e=>{const r=[];for(const a of await fs.promises.readdir(e,{withFileTypes:!0})){const i=path.join(e,a.name);a.isDirectory()?r.push(s(i)):r.push(fs.promises.stat(i).then((e=>t+=e.size)))}await Promise.all(r)};return await s(e),t}static getDirectorySizeSync(e){if(!fs.existsSync(e))return;const t=(e,s)=>{for(const r of fs.readdirSync(e,{withFileTypes:!0})){const a=path.join(e,r.name);r.isDirectory()?s=t(a,s):s+=fs.statSync(a).size}return s};return t(e,0)}static async processArchive(e,t,s=null){const r=process;return new Promise(((a,i)=>{r.noAsar=!0,yauzl.open(e,{lazyEntries:!0},((e,o)=>{e&&i(e);const n=o.entryCount;let c=0;o.on("entry",(async e=>{c++;let r=Math.round(100*c/n);await t(o,e,c,n,i),s&&await s(e.fileName,c,n,r),o.readEntry()})).once("error",i).once("close",(()=>{r.noAsar=!1,a(n)})),o.readEntry()}))}))}static async extractArchive(e,t,{onProgress:s=null,removeRoot:r}={}){return this.processArchive(e,(async(e,s,a,i,o)=>{let n=s.fileName;r&&(n=n.replace(r,"")),""===n||n.endsWith("/")||await this._extractEntry(e,t,s,n,o)}),s)}static async summarizeArchive(e,{manifestPath:t=null}={}){const s={contents:[],manifest:null};return await this.processArchive(e,(async(e,r,a,i,o)=>{let n=r.fileName;s.contents.push(n),n===t&&(s.manifest=await this._readEntry(e,r,o))})),s}static _readEntry(e,t,s){return new Promise((r=>{e.openReadStream(t,((e,t)=>{e&&s(e);let a="";t.on("data",(e=>a+=e.toString())),t.on("end",(()=>r(a)))}))}))}static _extractEntry(e,t,s,r,a){let i=path.join(t,r);return fs.mkdirSync(path.dirname(i),{recursive:!0}),new Promise((t=>{const r=fs.createWriteStream(i).on("finish",t).on("error",a);e.openReadStream(s,((e,t)=>{e&&a(e),t.pipe(r)}))}))}static resolveClientPaths(e,t){return t.map((t=>{const s=path.join(t.root,t.directory),r=path.join(s,e),a=fs.existsSync(r);return this.isPathContained(r,s)?{exists:a,clientPath:LocalFileStorage.toClientPath(r,t.root)}:{exists:!1,clientPath:null}}))}static standardizePath(e){return path.normalize(e).split(path.sep).join(path.posix.sep)}static isPathContained(e,t){const s=path.relative(t,e);return!(s&&(s.startsWith("..")||path.isAbsolute(s)))}static writeFileSyncSafe(e,t,s={}){const r=`${e}~`,a=fs.openSync(r,"w");fs.writeFileSync(a,t,s),fs.fsyncSync(a),fs.closeSync(a),fs.renameSync(r,e);const i=fs.openSync(e,"r+");return fs.fsyncSync(i),fs.closeSync(i),i}static copyLargeFile(e,t,{encoding:s="utf8",mode:r=420}={}){return new Promise(((a,i)=>{const o=fs.createReadStream(e,{encoding:s}),n=fs.createWriteStream(t,{encoding:s,mode:r});o.on("error",i),n.on("error",i),n.on("finish",a),o.pipe(n)}))}static getFileHash(e){return new Promise(((t,s)=>{const r=crypto.createHash("sha256"),a=fs.createReadStream(e);a.on("error",s),a.on("end",(()=>t(r.digest("hex")))),a.on("data",(e=>r.update(e)))}))}static async areFilesIdentical(e,t){const[s,r]=await Promise.all([fs.promises.stat(e),fs.promises.stat(t)]);if(s.size!==r.size)return!1;const[a,i]=await Promise.all([this.getFileHash(e),this.getFileHash(t)]);return a===i}static async getAvailableDiskSpace(e){const{free:t}=await checkDiskSpace(e);return t}static loadTemplate(e){const t=e.startsWith("templates")?paths.root:paths.data;if(e=path.join(t,e),!this.isPathContained(e,t))throw new Error("You are not allowed to load template files outside of the application or user data locations");if(!HTML_FILE_EXTENSIONS.includes(path.extname(e).slice(1)))throw new Error(`You are only allowed to load template files with an extension in [${HTML_FILE_EXTENSIONS}]`);try{return{html:fs.readFileSync(e,{encoding:"utf8"}),success:!0}}catch(e){return{html:"",success:!1,error:e.message}}}static parseWildcardPath(e){let t="data";const s={wildcard:!0};if(/\.s3\.[^/]+\//.test(e)){t="s3";const{bucket:r,keyPrefix:a}=parseS3URL(e);r&&(s.bucket=r,e=a)}else e.startsWith("icons/")&&(t="public");return{source:t,pattern:e,browseOptions:s}}static async upload(e,t,s={}){if(!t)throw new Error("No file was uploaded");if(!["data","s3"].includes(e))throw new Error("You may not upload to this location");const r=path.extname(t.name).slice(1).toLowerCase(),a=UPLOADABLE_FILE_EXTENSIONS[r];if(s.contentType=a,!a)throw new Error("You are attempting to upload a file with a disallowed file extension.");const i=MEDIA_MIME_TYPES.includes(a),o=["module.json","system.json","world.json","template.json"].includes(t.name.toLowerCase());s.overwrite=i&&!o;return config.files.storages[e].upload(t,s)}static socketListeners(e){e.on("manageFiles",((t,s,r)=>{this._onManageFiles(e,t,s,r)})),e.on("template",((e,t)=>{try{t(this.loadTemplate(e))}catch(e){t({error:e.message})}}))}static _onManageFiles(e,t,s,r){const a=!game.active&&!config.adminPassword||e.session.admin;if(!(e.user?e.user.hasPermission("FILES_BROWSE"):a))return r({error:"You do not have permission to browse the host file system!"});s.isAdmin=a||game.active&&e.user.hasRole("ASSISTANT");const i="user"===t.storage?"data":t.storage,o=config.files.storages[i];if(!o)return r({error:`The requested file storage ${t.storage} does not exist!`});switch(t.action){case"browseFiles":this._handleGetFiles(o,t,s,r);break;case"createDirectory":this._handleCreateDirectory(o,t,s,r);break;case"configurePath":this._handleConfigurePath(o,t,s,r)}}static _handleCreateDirectory(e,t,s,r){e.createDirectory(t.target,s).then((e=>r(e))).catch((e=>r({error:e.message})))}static _handleGetFiles(e,t,s,r){const a=mergeObject(s,{target:t.target});e.getFiles(a).then((e=>r(e))).catch((e=>r({error:e.message})))}static _handleConfigurePath(e,t,s,r){let a=e.configuration;s.bucket&&(a=a[s.bucket]=a[s.bucket]||{});const i=t.target,o=getProperty(a,i)||{};mergeObject(o,{private:s.private,gridSize:s.gridSize}),o.private||o.gridSize?a[i]=o:delete a[i];const n=path.join(paths.config,Files.STORAGE_CONFIGURATION_FILENAME);fs.writeFileSync(n,JSON.stringify(config.files.configuration)),r(o)}}