'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var core = require('@pixi/core');
var display = require('@pixi/display');

const _Application = class {
  constructor(options) {
    this.stage = new display.Container();
    options = Object.assign({
      forceCanvas: false
    }, options);
    this.renderer = core.autoDetectRenderer(options);
    _Application._plugins.forEach((plugin) => {
      plugin.init.call(this, options);
    });
  }
  render() {
    this.renderer.render(this.stage);
  }
  get view() {
    return this.renderer.view;
  }
  get screen() {
    return this.renderer.screen;
  }
  destroy(removeView, stageOptions) {
    const plugins = _Application._plugins.slice(0);
    plugins.reverse();
    plugins.forEach((plugin) => {
      plugin.destroy.call(this);
    });
    this.stage.destroy(stageOptions);
    this.stage = null;
    this.renderer.destroy(removeView);
    this.renderer = null;
  }
};
let Application = _Application;
Application._plugins = [];
core.extensions.handleByList(core.ExtensionType.Application, Application._plugins);

exports.Application = Application;
//# sourceMappingURL=Application.js.map
