'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

require('./AssetExtension.js');
var Assets = require('./Assets.js');
require('./cache/index.js');
require('./detections/index.js');
require('./loader/index.js');
require('./resolver/index.js');
require('./utils/index.js');
var Cache = require('./cache/Cache.js');
var cacheTextureArray = require('./cache/parsers/cacheTextureArray.js');
var detectAvif = require('./detections/parsers/detectAvif.js');
var detectWebp = require('./detections/parsers/detectWebp.js');
var detectDefaults = require('./detections/parsers/detectDefaults.js');
var LoaderParser = require('./loader/parsers/LoaderParser.js');
var loadJson = require('./loader/parsers/loadJson.js');
var loadTxt = require('./loader/parsers/loadTxt.js');
var loadWebFont = require('./loader/parsers/loadWebFont.js');
var loadSVG = require('./loader/parsers/textures/loadSVG.js');
var loadTextures = require('./loader/parsers/textures/loadTextures.js');
var createTexture = require('./loader/parsers/textures/utils/createTexture.js');
var resolveTextureUrl = require('./resolver/parsers/resolveTextureUrl.js');
var checkDataUrl = require('./utils/checkDataUrl.js');
var checkExtension = require('./utils/checkExtension.js');
var convertToList = require('./utils/convertToList.js');
var copySearchParams = require('./utils/copySearchParams.js');
var createStringVariations = require('./utils/createStringVariations.js');
var isSingleItem = require('./utils/isSingleItem.js');



exports.Assets = Assets.Assets;
exports.AssetsClass = Assets.AssetsClass;
exports.Cache = Cache.Cache;
exports.cacheTextureArray = cacheTextureArray.cacheTextureArray;
exports.detectAvif = detectAvif.detectAvif;
exports.detectWebp = detectWebp.detectWebp;
exports.detectDefaults = detectDefaults.detectDefaults;
exports.LoaderParserPriority = LoaderParser.LoaderParserPriority;
exports.loadJson = loadJson.loadJson;
exports.loadTxt = loadTxt.loadTxt;
exports.getFontFamilyName = loadWebFont.getFontFamilyName;
exports.loadWebFont = loadWebFont.loadWebFont;
exports.loadSVG = loadSVG.loadSVG;
exports.loadImageBitmap = loadTextures.loadImageBitmap;
exports.loadTextures = loadTextures.loadTextures;
exports.createTexture = createTexture.createTexture;
exports.resolveTextureUrl = resolveTextureUrl.resolveTextureUrl;
exports.checkDataUrl = checkDataUrl.checkDataUrl;
exports.checkExtension = checkExtension.checkExtension;
exports.convertToList = convertToList.convertToList;
exports.copySearchParams = copySearchParams.copySearchParams;
exports.createStringVariations = createStringVariations.createStringVariations;
exports.isSingleItem = isSingleItem.isSingleItem;
//# sourceMappingURL=index.js.map
