'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var core = require('@pixi/core');

class BlobResource extends core.BufferResource {
  constructor(source, options = { width: 1, height: 1, autoLoad: true }) {
    let origin;
    let data;
    if (typeof source === "string") {
      origin = source;
      data = new Uint8Array();
    } else {
      origin = null;
      data = source;
    }
    super(data, options);
    this.origin = origin;
    this.buffer = data ? new core.ViewableBuffer(data) : null;
    this._load = null;
    this.loaded = false;
    if (this.origin !== null && options.autoLoad !== false) {
      this.load();
    }
    if (this.origin === null && this.buffer) {
      this._load = Promise.resolve(this);
      this.loaded = true;
      this.onBlobLoaded(this.buffer.rawBinaryData);
    }
  }
  onBlobLoaded(_data) {
  }
  load() {
    if (this._load) {
      return this._load;
    }
    this._load = fetch(this.origin).then((response) => response.blob()).then((blob) => blob.arrayBuffer()).then((arrayBuffer) => {
      this.data = new Uint32Array(arrayBuffer);
      this.buffer = new core.ViewableBuffer(arrayBuffer);
      this.loaded = true;
      this.onBlobLoaded(arrayBuffer);
      this.update();
      return this;
    });
    return this._load;
  }
}

exports.BlobResource = BlobResource;
//# sourceMappingURL=BlobResource.js.map
