'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var color = require('@pixi/color');
var extensions = require('@pixi/extensions');

class BackgroundSystem {
  constructor() {
    this.clearBeforeRender = true;
    this._backgroundColor = new color.Color(0);
    this.alpha = 1;
  }
  init(options) {
    this.clearBeforeRender = options.clearBeforeRender;
    const { backgroundColor, background, backgroundAlpha } = options;
    const color = background ?? backgroundColor;
    if (color !== void 0) {
      this.color = color;
    }
    this.alpha = backgroundAlpha;
  }
  get color() {
    return this._backgroundColor.value;
  }
  set color(value) {
    this._backgroundColor.setValue(value);
  }
  get alpha() {
    return this._backgroundColor.alpha;
  }
  set alpha(value) {
    this._backgroundColor.setAlpha(value);
  }
  get backgroundColor() {
    return this._backgroundColor;
  }
  destroy() {
  }
}
BackgroundSystem.defaultOptions = {
  backgroundAlpha: 1,
  backgroundColor: 0,
  clearBeforeRender: true
};
BackgroundSystem.extension = {
  type: [
    extensions.ExtensionType.RendererSystem,
    extensions.ExtensionType.CanvasRendererSystem
  ],
  name: "background"
};
extensions.extensions.add(BackgroundSystem);

exports.BackgroundSystem = BackgroundSystem;
//# sourceMappingURL=BackgroundSystem.js.map
