import { TYPES } from '@pixi/constants';
import { Buffer } from '../geometry/Buffer.mjs';
import { Geometry } from '../geometry/Geometry.mjs';

class BatchGeometry extends Geometry {
  constructor(_static = false) {
    super();
    this._buffer = new Buffer(null, _static, false);
    this._indexBuffer = new Buffer(null, _static, true);
    this.addAttribute("aVertexPosition", this._buffer, 2, false, TYPES.FLOAT).addAttribute("aTextureCoord", this._buffer, 2, false, TYPES.FLOAT).addAttribute("aColor", this._buffer, 4, true, TYPES.UNSIGNED_BYTE).addAttribute("aTextureId", this._buffer, 1, true, TYPES.FLOAT).addIndex(this._indexBuffer);
  }
}

export { BatchGeometry };
//# sourceMappingURL=BatchGeometry.mjs.map
