'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var constants = require('@pixi/constants');
var math = require('@pixi/math');

class FilterState {
  constructor() {
    this.renderTexture = null;
    this.target = null;
    this.legacy = false;
    this.resolution = 1;
    this.multisample = constants.MSAA_QUALITY.NONE;
    this.sourceFrame = new math.Rectangle();
    this.destinationFrame = new math.Rectangle();
    this.bindingSourceFrame = new math.Rectangle();
    this.bindingDestinationFrame = new math.Rectangle();
    this.filters = [];
    this.transform = null;
  }
  clear() {
    this.target = null;
    this.filters = null;
    this.renderTexture = null;
  }
}

exports.FilterState = FilterState;
//# sourceMappingURL=FilterState.js.map
