'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var constants = require('@pixi/constants');
var utils = require('@pixi/utils');
var defaultProgram$1 = require('./defaultProgram.js');
var defaultProgram = require('./defaultProgram2.js');
require('./utils/index.js');
var setPrecision = require('./utils/setPrecision.js');
var getMaxFragmentPrecision = require('./utils/getMaxFragmentPrecision.js');

let UID = 0;
const nameCache = {};
const _Program = class {
  constructor(vertexSrc, fragmentSrc, name = "pixi-shader", extra = {}) {
    this.extra = {};
    this.id = UID++;
    this.vertexSrc = vertexSrc || _Program.defaultVertexSrc;
    this.fragmentSrc = fragmentSrc || _Program.defaultFragmentSrc;
    this.vertexSrc = this.vertexSrc.trim();
    this.fragmentSrc = this.fragmentSrc.trim();
    this.extra = extra;
    if (this.vertexSrc.substring(0, 8) !== "#version") {
      name = name.replace(/\s+/g, "-");
      if (nameCache[name]) {
        nameCache[name]++;
        name += `-${nameCache[name]}`;
      } else {
        nameCache[name] = 1;
      }
      this.vertexSrc = `#define SHADER_NAME ${name}
${this.vertexSrc}`;
      this.fragmentSrc = `#define SHADER_NAME ${name}
${this.fragmentSrc}`;
      this.vertexSrc = setPrecision.setPrecision(this.vertexSrc, _Program.defaultVertexPrecision, constants.PRECISION.HIGH);
      this.fragmentSrc = setPrecision.setPrecision(this.fragmentSrc, _Program.defaultFragmentPrecision, getMaxFragmentPrecision.getMaxFragmentPrecision());
    }
    this.glPrograms = {};
    this.syncUniforms = null;
  }
  static get defaultVertexSrc() {
    return defaultProgram["default"];
  }
  static get defaultFragmentSrc() {
    return defaultProgram$1["default"];
  }
  static from(vertexSrc, fragmentSrc, name) {
    const key = vertexSrc + fragmentSrc;
    let program = utils.ProgramCache[key];
    if (!program) {
      utils.ProgramCache[key] = program = new _Program(vertexSrc, fragmentSrc, name);
    }
    return program;
  }
};
let Program = _Program;
Program.defaultVertexPrecision = constants.PRECISION.HIGH;
Program.defaultFragmentPrecision = utils.isMobile.apple.device ? constants.PRECISION.HIGH : constants.PRECISION.MEDIUM;

exports.Program = Program;
//# sourceMappingURL=Program.js.map
