'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var constants = require('@pixi/constants');
var getTestContext = require('./getTestContext.js');

let maxFragmentPrecision;
function getMaxFragmentPrecision() {
  if (!maxFragmentPrecision) {
    maxFragmentPrecision = constants.PRECISION.MEDIUM;
    const gl = getTestContext.getTestContext();
    if (gl) {
      if (gl.getShaderPrecisionFormat) {
        const shaderFragment = gl.getShaderPrecisionFormat(gl.FRAGMENT_SHADER, gl.HIGH_FLOAT);
        maxFragmentPrecision = shaderFragment.precision ? constants.PRECISION.HIGH : constants.PRECISION.MEDIUM;
      }
    }
  }
  return maxFragmentPrecision;
}

exports.getMaxFragmentPrecision = getMaxFragmentPrecision;
//# sourceMappingURL=getMaxFragmentPrecision.js.map
