'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var BaseImageResource = require('./BaseImageResource.js');

class CanvasResource extends BaseImageResource.BaseImageResource {
  constructor(source) {
    super(source);
  }
  static test(source) {
    const { OffscreenCanvas } = globalThis;
    if (OffscreenCanvas && source instanceof OffscreenCanvas) {
      return true;
    }
    return globalThis.HTMLCanvasElement && source instanceof HTMLCanvasElement;
  }
}

exports.CanvasResource = CanvasResource;
//# sourceMappingURL=CanvasResource.js.map
