import { Ticker, UPDATE_PRIORITY } from '@pixi/core';

class EventsTickerClass {
  constructor() {
    this.interactionFrequency = 10;
    this._deltaTime = 0;
    this._didMove = false;
    this.tickerAdded = false;
    this._pauseUpdate = true;
  }
  init(events) {
    this.removeTickerListener();
    this.events = events;
    this.interactionFrequency = 10;
    this._deltaTime = 0;
    this._didMove = false;
    this.tickerAdded = false;
    this._pauseUpdate = true;
  }
  get pauseUpdate() {
    return this._pauseUpdate;
  }
  set pauseUpdate(paused) {
    this._pauseUpdate = paused;
  }
  addTickerListener() {
    if (this.tickerAdded || !this.domElement) {
      return;
    }
    Ticker.system.add(this.tickerUpdate, this, UPDATE_PRIORITY.INTERACTION);
    this.tickerAdded = true;
  }
  removeTickerListener() {
    if (!this.tickerAdded) {
      return;
    }
    Ticker.system.remove(this.tickerUpdate, this);
    this.tickerAdded = false;
  }
  pointerMoved() {
    this._didMove = true;
  }
  update() {
    if (!this.domElement || this._pauseUpdate) {
      return;
    }
    if (this._didMove) {
      this._didMove = false;
      return;
    }
    const rootPointerEvent = this.events["rootPointerEvent"];
    if (this.events.supportsTouchEvents && rootPointerEvent.pointerType === "touch") {
      return;
    }
    globalThis.document.dispatchEvent(new PointerEvent("pointermove", {
      clientX: rootPointerEvent.clientX,
      clientY: rootPointerEvent.clientY
    }));
  }
  tickerUpdate(deltaTime) {
    this._deltaTime += deltaTime;
    if (this._deltaTime < this.interactionFrequency) {
      return;
    }
    this._deltaTime = 0;
    this.update();
  }
}
const EventsTicker = new EventsTickerClass();

export { EventsTicker };
//# sourceMappingURL=EventTicker.mjs.map
