import { FederatedMouseEvent } from './FederatedMouseEvent.mjs';

class FederatedPointerEvent extends FederatedMouseEvent {
  constructor() {
    super(...arguments);
    this.width = 0;
    this.height = 0;
    this.isPrimary = false;
  }
  getCoalescedEvents() {
    if (this.type === "pointermove" || this.type === "mousemove" || this.type === "touchmove") {
      return [this];
    }
    return [];
  }
  getPredictedEvents() {
    throw new Error("getPredictedEvents is not supported!");
  }
}

export { FederatedPointerEvent };
//# sourceMappingURL=FederatedPointerEvent.mjs.map
