'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var core = require('@pixi/core');
var noise = require('./noise.js');

class NoiseFilter extends core.Filter {
  constructor(noise$1 = 0.5, seed = Math.random()) {
    super(core.defaultFilterVertex, noise["default"], {
      uNoise: 0,
      uSeed: 0
    });
    this.noise = noise$1;
    this.seed = seed;
  }
  get noise() {
    return this.uniforms.uNoise;
  }
  set noise(value) {
    this.uniforms.uNoise = value;
  }
  get seed() {
    return this.uniforms.uSeed;
  }
  set seed(value) {
    this.uniforms.uSeed = value;
  }
}

exports.NoiseFilter = NoiseFilter;
//# sourceMappingURL=NoiseFilter.js.map
