import { WRAP_MODES } from '@pixi/core';
import { Mesh, MeshMaterial } from '@pixi/mesh';
import { RopeGeometry } from './geometry/RopeGeometry.mjs';

class SimpleRope extends Mesh {
  constructor(texture, points, textureScale = 0) {
    const ropeGeometry = new RopeGeometry(texture.height, points, textureScale);
    const meshMaterial = new MeshMaterial(texture);
    if (textureScale > 0) {
      texture.baseTexture.wrapMode = WRAP_MODES.REPEAT;
    }
    super(ropeGeometry, meshMaterial);
    this.autoUpdate = true;
  }
  _render(renderer) {
    const geometry = this.geometry;
    if (this.autoUpdate || geometry._width !== this.shader.texture.height) {
      geometry._width = this.shader.texture.height;
      geometry.update();
    }
    super._render(renderer);
  }
}

export { SimpleRope };
//# sourceMappingURL=SimpleRope.mjs.map
