import DatabaseBackend from"../../../common/abstract/backend.mjs";import{expandObject,parseUuid,setProperty}from"../../../common/utils/helpers.mjs";import{handleEvent}from"../../server/sockets.mjs";import{EmbeddedCollectionField}from"../../../common/data/fields.mjs";import{fromUuid,tagModelStats}from"../../core/utils.mjs";export default class ServerDatabaseBackend extends DatabaseBackend{socketListeners(e){e.on("modifyDocument",handleEvent.bind(e,"modifyDocument",this.modifyDocument.bind(this)))}async modifyDocument(e,t){const a=global.db,o=this[t.action];if(!(o instanceof Function))throw new Error(`Invalid Document modification action ${t.action} requested`);let r,i=a[t.type];if(!i)throw new Error(`Invalid Document type ${t.type} provided for database modification operation`);if(t.pack){const e=a.packs.get(t.pack);if("Folder"===t.type)i=e.folderClass;else if(!t.parentUuid){if(t.type!==e.packData.type)throw new Error(`${t.type} Documents cannot be created in a compendium that only allows for ${e.packData.type} Documents.`);i=e}e.connected||await e.connect()}return r=t.pack?a.packs.get(t.pack).db:t.parentUuid?parseUuid(t.parentUuid)?.collection.db:i.db,r.semaphore.add(o.bind(this),i,t,e)}async _getParent(e){return e.parentUuid?fromUuid(e.parentUuid,{invalid:!0}):null}async _getDocuments(e,{query:t,options:a,parent:o}={},r){if(o)return this._getEmbeddedDocuments(e,o,{query:t,options:a},r);if(a.index){const o=a.indexFields||["name","img","thumb","type"],r=["password","passwordSalt"];for(const t of o)if(r.includes(t)||e.schema.get(t)instanceof EmbeddedCollectionField)throw new Error(`You are not allowed to request the "${t}" field as a compendium index.`);const i=o.reduce(((e,t)=>(setProperty(e,t,1),e)),{});return e.sublevel.find(t,{project:i})}return e.find(t,{safe:!0})}async _getEmbeddedDocuments(e,t,{query:a,options:o},r){o.broadcast=!1;const i=t.getEmbeddedCollection(e.documentName);return Array.from(i.values())}async _createDocuments(e,{data:t,options:a,parent:o,parentUuid:r,pack:i},n){if(a.temporary)throw new Error("It is no longer supported to create temporary documents via a server-side creation request.");const d=e.documentName,s=e.collectionName,c=o?o.getSublevel(s):e.sublevel,l=o?.getEmbeddedCollection(s);l&&(e=l.documentClass);const m=[];a.modifiedTime=Date.now();const p=c.db.batch(),{restoreDelta:u}=a;for(let d of t){if(a.keepId&&d._id||(d._id=await c.createNewId()),l?.has(d._id))throw new Error(`The _id [${d._id}] already exists within the parent collection: ${o.documentName} [${o.id}] ${s}`);d=expandObject(d);const t=[r,s,d._id].filterJoin(".");await e.sanitizeUserInput(d,{user:n,uuid:t,type:d.type});const f=e.fromSource(d,{parent:o,pack:i});if(await f.loadRelatedDocuments(),n&&!f.canUserModify(n,"create",d))throw new Error(this._logError(n,"create",f,{parent:o,pack:i}));await f._preCreate(d,a,n),f.validate({fields:!0,joint:!0,strict:!0}),o&&l.set(f.id,f,{restoreDelta:u}),f.batchWrite(p,{restoreDelta:u}),m.push((async()=>(await f._onCreate(d,a,n),f)))}o&&(tagModelStats(o,{user:n,modifiedTime:a.modifiedTime}),o.batchWrite(p,{writeEmbedded:!1,childModified:!0})),await p.write();const f=await Promise.all(m.map((e=>e())));return this._logOperation("Created",d,f,{level:"info",parent:o,pack:i}),f}async _updateDocuments(e,{updates:t,options:a,parent:o,parentUuid:r,pack:i},n){const d=e.documentName,s=e.collectionName,c=o?o.getSublevel(s):e.sublevel,l=o?.getEmbeddedCollection(s),m=[];a.modifiedTime=Date.now();const p=new Map,u=[];for(let e of t){if(!("_id"in e))throw new Error(`You cannot update a ${d} without providing an _id`);p.set(e._id,expandObject(e)),u.push(e._id)}const f=o?u.map((e=>l.get(e,{invalid:!0}))):await e.getMany(Array.from(u));await Promise.all(f.map(((e,t)=>{if(!e)throw new Error(`${d} "${u[t]}" does not exist!`);return e.loadRelatedDocuments()})));const h=c.db.batch(),{restoreDelta:w}=a;for(let t of f){const d=p.get(t.id),c=[r,s,d._id].filterJoin(".");if(await e.sanitizeUserInput(d,{user:n,uuid:c,type:d.type??t.type}),n&&!t.canUserModify(n,"update",d))throw new Error(this._logError(n,"update",t,{parent:o,pack:i}));let u=!1;for(const[o,r]of Object.entries(e.hierarchy))if(o in d){u=!0;for(const e of t.getEmbeddedCollection(o))await e.loadRelatedDocuments();!1===a.recursive&&r.batchDeleteBranch?.(t,h,{restoreDelta:w})}const f=t.updateSource(d,a);f._id=t.id,await t._preUpdate(f,a,n),o&&l.set(t.id,t,{restoreDelta:w}),t.batchWrite(h,{writeEmbedded:u,restoreDelta:w}),m.push((async()=>(await t._onUpdate(f,a,n),f)))}o?(tagModelStats(o,{user:n,modifiedTime:a.modifiedTime}),o.batchWrite(h,{writeEmbedded:!1,childModified:!0})):e.isCached&&game.documentCache.addAll(f),await h.write();const b=await Promise.all(m.map((e=>e())));return global.options.debug&&this._logOperation("Updated",d,f,{level:"debug",parent:o,pack:i}),b}async _deleteDocuments(e,{ids:t,options:a,parent:o,pack:r},i){const n=e.documentName;if(!o&&a.deleteAll&&!i.isGM)throw new Error(this._logError(i,"delete",`all ${n} Documents`,{pack:r}));const d=e.collectionName,s=o?o.getSublevel(d):e.sublevel,c=o?.getEmbeddedCollection(d),l=[];let m;m=o?a.deleteAll?c.contents.concat(Array.from(c.invalidDocumentIds).map((e=>c.getInvalid(e)))):t.map((e=>c.get(e,{strict:!0,invalid:!0}))):a.deleteAll?await e.find():await e.getMany(t);const p=s.db.batch();for(let e of m)if(e.invalid&&i.isGM)e.batchDelete(p),l.push((()=>e.id));else{if(await e.loadRelatedDocuments(),i&&!e.canUserModify(i,"delete"))throw new Error(this._logError(i,"delete",e,{parent:o,pack:r}));await e._preDelete(a,i),o&&c.delete(e.id),e.batchDelete(p,{user:i}),l.push((async()=>(await e._onDelete(a,i),e.id)))}o?(tagModelStats(o,{user:i}),o.batchWrite(p,{writeEmbedded:!1,childModified:!0})):e.isCached&&m.forEach((e=>game.documentCache.delete(e))),await p.write();const u=await Promise.all(l.map((e=>e())));return this._logOperation("Deleted",n,m,{level:"info",parent:o,pack:r}),u}getFlagScopes(){}getCompendiumScopes(){return Array.from(global.db.packs.keys())}_getLogger(){return globalThis.logger}}