import fs from"fs";import path from"path";import NeDB from"nedb";import Files from"../../files/files.mjs";import LevelDatabase from"./level-database.mjs";import{DOCUMENT_OWNERSHIP_LEVELS}from"../../../common/constants.mjs";import{deepClone,isEmpty,parseUuid,setProperty}from"../../../common/utils/helpers.mjs";import*as fields from"../../../common/data/fields.mjs";import{tagModelStats}from"../../core/utils.mjs";export default function ServerDocumentMixin(e){return class extends e{constructor(e={},t={}){super(e,t);const{db:s,sublevelName:i,sublevel:a}=this._configureDB();Object.defineProperties(this,{db:{value:s,writable:!1},sublevelName:{value:i,writable:!1},sublevel:{value:a,writable:!1}})}static name="ServerDocumentMixin";static isCached=!1;closestDeltaAncestor(){return this.parent?this.parent.constructor.isDelta?this.parent:this.parent.closestDeltaAncestor():null}_initialize(e={}){super._initialize(e),Object.defineProperty(this,"dbKey",{value:this._getDBKey(),writable:!1,configurable:!0})}static get db(){if(!this._db)throw new Error(`The ${this.collectionName} database is not yet connected!`);return this._db}static _db;static _connectionFailed=!1;static sublevel;db;sublevelName;sublevel;getSublevel(e){const t=LevelDatabase.formatKey(this.sublevelName,e);return this.db.sublevels[t]}static _getSublevelNames(){const e=[],t=(s,i)=>{e.push(s);for(const[e,a]of Object.entries(i.hierarchy))t(LevelDatabase.formatKey(s,e),a.model)};return t(this.metadata.collection,this),e}static async connect({strict:e=!0}={}){if(this._connectionFailed)return;if("open"===this._db?.status)return this._db;const t=this.filename+".db",s=this._getSublevelNames(),i=fs.existsSync(path.join(this.filename,"CURRENT"));try{this._db=await LevelDatabase.connect(this.collectionName,this.filename,{sublevels:s})}catch(t){if(logger.error(t.message),e)throw t;if(this._connectionFailed=!0,this.packData){const{packageName:e,packageType:s}=this.packData;packages?.warnings?.add(e,{type:s,message:t.message})}return}return this.sublevel=this._db.sublevels[this.metadata.collection],fs.existsSync(t)&&(i||await this._migrateNEDBToLevelDB(t),global.config.options.deleteNEDB&&(global.logger.info(`${vtt} | Deleting migrated NEDB file "${t}"`),fs.rmSync(t))),await this.deleteOrphanDocuments(),this._db}static get connected(){return LevelDatabase.databases.has(this.collectionName)}static async disconnect(){"open"===this._db?.status&&await this.db.close(),this._db=void 0}static get filename(){const e=global.game.world;if(!e)throw new Error(`You cannot access the ${this.collectionName} database before the game is ready!`);return Files.standardizePath(path.join(e.path,"data",this.collectionName))}static async _migrateNEDBToLevelDB(e){global.logger.info(`${vtt} | Performing one-time migration of table "${this.collectionName}" from NEDB to LevelDB`);const t=await new Promise(((t,s)=>{const i=new NeDB(e);i.loadDatabase((e=>e?s(e):t(i)))})),s=await new Promise(((e,s)=>{t.find({},((t,i)=>t?s(t):e(i)))})),i=this._db.batch();for(const e of s)this.batchWrite(e,i,{writeEmbedded:!0,generateIds:!0});await i.write(),global.logger.info(`${vtt} | Completed migration of table "${this.collectionName} to LevelDB "${this.filename}"`)}static async deleteOrphanDocuments(){if(isEmpty(this.hierarchy))return;const e=new Set(await this.sublevel.keys().all()),t=this._db.batch();let s=0;const i=async(e,a,o)=>{for(const[n,r]of Object.entries(e.hierarchy)){const e=r.model,l=LevelDatabase.formatKey(a,n),d=this._db.sublevels[l],c=await d.keys().all();for(const i of c){const a=i.substring(0,i.lastIndexOf("."));if(!o.has(a)){s++;const o=await d.get(i);await e.expandEmbedded(o,{idPrefix:a,sublevelName:l,ldb:this._db}),e.batchDelete(o,t,{idPrefix:a,sublevelName:l})}}await i(e,l,new Set(c))}};await i(this,this.metadata.collection,e),await t.write(),s&&global.logger.warn(`${vtt} | Deleted ${s} orphaned embedded documents from the ${this.collectionName} database`)}_getDBKey(){if(!this.id)return null;const e=[this.id];let t=this.parent;for(;t;)e.unshift(t.id),t=t.parent;return LevelDatabase.formatKey(...e)}_configureDB(){let e,t=this;const s=[];do{s.unshift(t.isEmbedded?t.parentCollection:t.constructor.metadata.collection),e=t.constructor._db,t=t.parent}while(t);const i=LevelDatabase.formatKey(...s);return{db:e,sublevelName:i,sublevel:e.sublevels[i]}}static async dump({sort:e}={}){return this.sublevel.find(void 0,{sort:e,map:async e=>(await this.expandEmbedded(e),e)})}static async get(e,t={},s){const i=await this.sublevel.get(e);if(void 0!==i)return await this.expandEmbedded(i),this.fromSource(i,t);if(!0===t.strict)throw new Error(`The ${this.name} ${e} does not exist in ${this.collectionName}`)}static async getMany(e,t={}){const s=await this.sublevel.getMany(e);return Promise.all(s.map((async e=>{if(e)return await this.expandEmbedded(e),this.fromSource(e,t)})))}static async expandEmbedded(e,{idPrefix:t,sublevelName:s,ldb:i}={}){i=i??this.db,s=s??this.metadata.collection;const a=t?LevelDatabase.formatKey(t,e._id):e._id;for(const[t,o]of Object.entries(this.hierarchy))e[t]=await o.expandEmbedded(e,a,s,i);return e}static async find(e,t={}){return this.sublevel.find(e,{map:async e=>(await this.expandEmbedded(e),this.fromSource(e,t))})}static batchWrite(e,t,{writeEmbedded:s=!0,generateIds:i=!1,idPrefix:a,dbKey:o,sublevelName:n}={}){n=n??this.metadata.collection;const r=o??(a?LevelDatabase.formatKey(a,e._id):e._id);for(const[a,o]of Object.entries(this.hierarchy))e[a]=o.batchWrite(e,t,r,n,{writeEmbedded:s,generateIds:i});const l=t.db.sublevels[n].prefixKey(r);t.put(l,e)}static batchDelete(e,t,{idPrefix:s,dbKey:i,sublevelName:a}={}){a=a??this.metadata.collection;const o=i??(s?LevelDatabase.formatKey(s,e._id):e._id);for(const s of Object.values(this.hierarchy))s.batchDelete(e,t,o,a);const n=t.db.sublevels[a];t.del(n.prefixKey(o))}async loadRelatedDocuments(){}async save(){if(this.invalid)throw new Error("You may not save a Document which has an invalid DataModel.");if(!this.id)throw new Error("You may not save a Document which does not have an id.");const e=this.db.batch();return this.batchWrite(e),await e.write(),this}batchWrite(e,{writeEmbedded:t=!0,generateIds:s=!1,writeAncestorDeltas:i=!1,childModified:a=!1,propagateStats:o}={}){if(a?o=deepClone(this._source._stats):o&&this.updateSource({_stats:o}),a||i)if(this.closestDeltaAncestor()){const e=this.parent.getEmbeddedCollection(this.parentCollection);e.manages?.(this.id)?i=!1:(i=!0,e.set(this.id,this))}else i=!1;this.parent&&(o||i)&&this.parent.batchWrite(e,{writeEmbedded:t,generateIds:s,writeAncestorDeltas:i,propagateStats:o});const n=this.toObject(),{dbKey:r,sublevelName:l}=this;this.constructor.batchWrite(n,e,{dbKey:r,sublevelName:l,generateIds:s,writeEmbedded:t||i})}batchDelete(e){const t=this.toObject();this.constructor.batchDelete(t,e,{dbKey:this.dbKey,sublevelName:this.sublevelName})}static async sanitizeUserInput(e,{documentId:t,fieldPath:s=[],user:i,type:a,uuid:o}={}){const n=this.sanitizedFields;if("string"==typeof a&&a.includes(".")){const[e,...t]=a.split("."),s=t.join("."),i=game.world.modules.get(e),o=i?.documentTypes?.[this.documentName]?.[s];if(o){for(const e of o.htmlFields||[]){setProperty(n,`system.${e}`,new fields.HTMLField)}for(const[e,t]of Object.entries(o.filePathFields||{})){setProperty(n,`system.${e}`,new fields.FilePathField({categories:t}))}}}if(o){const e=parseUuid(o);t=e.documentId,e.embedded&&(s=e.embedded)}return this._sanitizeFields(n,e,{assetPath:this.extractedAssetPath,documentId:t||e._id,fieldPath:s,user:i})}static async _sanitizeFields(e,t,{fieldPath:s,...i}={}){if(!t)return t;for(const[a,o]of Object.entries(t)){const n=e[a];if(!n)continue;const r=s.concat([a]);if(n instanceof fields.DataField)t[a]=n.sanitize(o,{fieldPath:r,...i});else if(n instanceof Array){const e=n[0];await Promise.all(o.map(((t,s)=>{const a=t._id??s;return this._sanitizeFields(e,t,{fieldPath:r.concat([a]),...i})})))}else n instanceof Object&&await this._sanitizeFields(n,o,{fieldPath:r,...i})}return t}static get sanitizedFields(){if(!this._sanitizedFields){this._sanitizedFields=this.schema.apply((function(){if(this.sanitize)return this}),{},{filter:!0,initializeArrays:!0});for(const e of this.getSystemFields("htmlFields")||[]){const t=`system.${e}`;setProperty(this._sanitizedFields,t,new fields.HTMLField)}for(const[e,t]of Object.entries(this.getSystemFields("filePathFields")||{})){const s=`system.${e}`;setProperty(this._sanitizedFields,s,new fields.FilePathField({categories:t}))}}return this._sanitizedFields}static _sanitizedFields;static getSystemFields(e){return game.template[this.documentName]?.[e]}static get extractedAssetPath(){const e=this.package??game.world;return path.join(e.path,"assets",this.metadata.collection)}_deleteExtractedAssets(){const e=this.constructor.extractedAssetPath;if(!fs.existsSync(e))return;const t=this.parent?[this.parent.id,this.collectionName,this.id].join("-"):this.id;for(const s of fs.readdirSync(e))if(s.startsWith(t)){const t=path.join(e,s);fs.unlinkSync(t),logger.info(`${vtt} | Deleted extracted base64 asset: ${t}`)}}static async migrateSystem(){if(!this.hasTypeData)throw new Error(`Document ${this.documentName} does not have type data`);globalThis.logger.info(`${vtt} | Migrating ${this.documentName} documents to the latest game system data model`);const e=await this.find(),t=this.db.batch();for(const s of e)try{s.updateSource({system:s.migrateSystemData()});for(const[e,t]of Object.entries(this.metadata.embedded)){if(global.db[e].hasTypeData)for(const e of s[t])e.updateSource({system:e.migrateSystemData()})}s.batchWrite(t,{writeEmbedded:!0})}catch(e){globalThis.logger.error(e)}await t.write(),globalThis.logger.info(`Successfully migrated ${e.length} ${this.documentName} documents to the latest system data model.`)}async _preCreate(e,t,s){await super._preCreate(e,t,s);for(const e of Object.keys(this.constructor.hierarchy))for(let s of this.getEmbeddedCollection(e)??[])s&&(s.id&&!1!==t.keepEmbeddedIds||s.updateSource({_id:await this.sublevel.createNewId()}));this.ownership&&s&&!(s.id in this.ownership)&&this.updateSource({[`ownership.${s.id}`]:DOCUMENT_OWNERSHIP_LEVELS.OWNER}),tagModelStats(this,{user:s,modifiedTime:t.modifiedTime})}async _preUpdate(e,t,s){await super._preUpdate(e,t,s),tagModelStats(this,{changes:e,user:s,modifiedTime:t.modifiedTime})}async _onDelete(e,t){await super._onDelete(e,t),this._deleteExtractedAssets()}}}