import{COMPENDIUM_DOCUMENT_TYPES,COMPATIBILITY_MODES}from"../../common/constants.mjs";import LevelDatabase from"./backend/level-database.mjs";import ServerDatabaseBackend from"./backend/server-backend.mjs";import ServerCompendiumMixin from"./backend/server-compendium.mjs";import Actor from"./documents/actor.mjs";import Cards from"./documents/cards.mjs";import Combat from"./documents/combat.mjs";import Combatant from"./documents/combatant.mjs";import FogExploration from"./documents/fog.mjs";import Folder from"./documents/folder.mjs";import Item from"./documents/item.mjs";import JournalEntry from"./documents/journal.mjs";import JournalEntryPage from"./documents/journal-page.mjs";import Playlist from"./documents/playlist.mjs";import Scene from"./documents/scene.mjs";import Setting from"./documents/setting.mjs";import Token from"./documents/token.mjs";import ActorDelta from"./documents/actor-delta.mjs";import Note from"./documents/note.mjs";import User from"./documents/user.mjs";import{ActiveEffect,Adventure,AmbientLight,AmbientSound,Card,ChatMessage,Drawing,Macro,MeasuredTemplate,PlaylistSound,RollTable,TableResult,Tile,Wall}from"./documents/others.mjs";import"./fields-extensions.mjs";export const DatabaseBackend=new ServerDatabaseBackend;export const documents=[Actor,Cards,ChatMessage,Combat,Drawing,FogExploration,Folder,Item,JournalEntry,Macro,Playlist,RollTable,Scene,Setting,User];export async function connect({onProgress:e}={}){for(const t of documents)await t.connect(),void 0!==global.gc&&global.gc(),e instanceof Function&&e(t)}export async function disconnect(){const e=[];for(let t of LevelDatabase.databases.values())e.push(t.close());await Promise.all(e),packs.clear()}export const packs=new Map;export function defineCompendium(e){_validateCompendiumMetadata(e);const t=global.db[e.type],o=ServerCompendiumMixin(t,e);return db.packs.set(o.collectionName,o),o}function _validateCompendiumMetadata(e={}){if(!("name"in e))throw new Error("Compendium packs must define a canonical name");if(!("path"in e))throw new Error("Compendium packs must specify their relative file path.");if(!("type"in e))throw new Error("Compendium packs must specify the document type they contain.");if(!("absPath"in e))throw new Error("An absolute file path must be provided when a new Compendium is defined.");if(!COMPENDIUM_DOCUMENT_TYPES.includes(e.type))throw new Error(`Compendium ${e.label} is configured for an invalid Document type ${e.type}`);return!0}globalThis.CONFIG={compatibility:{mode:COMPATIBILITY_MODES.WARNING,includePatterns:[],excludePatterns:[]},DatabaseBackend:DatabaseBackend,Actor:{documentClass:Actor},Adventure:{documentClass:foundry.documents.BaseAdventure},Cards:{documentClass:Cards},ChatMessage:{documentClass:ChatMessage},Combat:{documentClass:Combat},FogExploration:{documentClass:FogExploration},Folder:{documentClass:Folder},Item:{documentClass:Item},JournalEntry:{documentClass:JournalEntry},JournalEntryPage:{documentClass:JournalEntryPage},Macro:{documentClass:Macro},Playlist:{documentClass:Playlist},RollTable:{documentClass:RollTable},Scene:{documentClass:Scene},Setting:{documentClass:Setting},User:{documentClass:User},ActiveEffect:{documentClass:ActiveEffect},Card:{documentClass:Card},TableResult:{documentClass:TableResult},PlaylistSound:{documentClass:PlaylistSound},AmbientLight:{documentClass:AmbientLight},AmbientSound:{documentClass:AmbientSound},Combatant:{documentClass:Combatant},Drawing:{documentClass:Drawing},MeasuredTemplate:{documentClass:MeasuredTemplate},Note:{documentClass:Note},Tile:{documentClass:Tile},Token:{documentClass:Token},Wall:{documentClass:Wall},ActorDelta:{documentClass:ActorDelta}};export{Actor,ActiveEffect,Adventure,AmbientLight,AmbientSound,Card,Cards,ChatMessage,Combat,Combatant,Drawing,FogExploration,Folder,Item,JournalEntry,JournalEntryPage,MeasuredTemplate,Note,Playlist,PlaylistSound,Scene,Setting,Macro,RollTable,TableResult,Tile,Token,ActorDelta,User,Wall};