import*as fs from"fs";import*as path from"path";import archiver from"archiver";import Files from"../files/files.mjs";import DataModel from"../../common/abstract/data.mjs";import*as fields from"../../common/data/fields.mjs";import{PackageCompatibility}from"../../common/packages/module.mjs";import BasePackage,{PackageRelationships}from"../../common/packages/base-package.mjs";import ProgressEmitter from"../components/progress-emitter.mjs";import{formatFileSize}from"../../common/utils/helpers.mjs";export default class PackageBackups{static BACKUP_TYPES=["module","system","world","snapshot"];async createBackups(e,{level:t=6,onProgress:a}={}){const s=[];for(const{packageId:i,type:r,note:n,snapshotId:o}of e)s.push(await this.createBackup(i,r,{level:t,note:n,snapshotId:o,onProgress:a}));return s}createBackup(e,t,{level:a=6,note:s="",onProgress:i,snapshotId:r}={}){const{logger:n,packages:o}=global,{ACTIONS:c,STEPS:l}=CONST.SETUP_PACKAGE_PROGRESS,p=o.PACKAGE_TYPE_MAPPING[t].get(e);if(!p)throw new Error(`Cannot create a backup of ${t} '${e}' because it is not installed.`);const{backups:g,install:d}=this.#e(e,t);return fs.mkdirSync(g,{recursive:!0}),n.info(`Writing backup for ${t} '${e}'.`),new Promise((async(o,S)=>{const u=new Date,P=`${t}.${e}.${u.toDateInputString()}.${u.valueOf()}`,f=path.join(g,`${P}.bak`),h=path.join(g,`${P}.json`),k=fs.createWriteStream(f),m=archiver("zip",{zlib:{level:a}}),E=await Files.getDirectorySize(d),b=new ProgressEmitter(c.CREATE_BACKUP,l.ARCHIVE,E,{packageId:e,type:t,id:P,title:p.title,message:"SETUP.BACKUPS.BackingUp"},{onProgress:i});let A;m.on("warning",(e=>n.warn(e))),m.on("error",(e=>{A=e,b.error(e),S(e)})),m.on("progress",(({fs:e})=>b.emit(e.processedBytes))),k.on("close",(()=>{if(A)return void(fs.existsSync(f)&&fs.unlinkSync(f));const a=m.pointer(),i=`Wrote backup for ${t} '${e}' to '${f}'. Wrote ${a} bytes.`,n=this.#t(p,h,{id:P,size:a,note:s,snapshotId:r,originalSize:E,createdAt:u.valueOf()});b.complete({log:i,context:{backupData:n}}),o(n)})),m.pipe(k),m.directory(d,!1),m.finalize()}))}async restoreBackups(e,{onProgress:t}={}){for(const a of e)await this.restoreBackup(a,{onProgress:t})}async restoreBackup(e,{onProgress:t}={}){const{paths:a}=global,{id:s,packageId:i,type:r}=e,{ACTIONS:n}=CONST.SETUP_PACKAGE_PROGRESS,o=path.join(a.backups,"tmp",s);fs.mkdirSync(o,{recursive:!0});const c=new ProgressEmitter(n.RESTORE_BACKUP,null,1);try{const a=await this.#a(e,o,{onProgress:t});await this.#s(e,o,a,{onProgress:t}),this.#i(i,r),c.complete({context:{backupData:e}})}catch(e){c.error(e)}finally{fs.rmSync(o,{recursive:!0,maxRetries:10})}}async deleteBackups(e){const{ACTIONS:t,STEPS:a}=CONST.SETUP_PACKAGE_PROGRESS,s=new ProgressEmitter(t.DELETE_BACKUP,a.DELETE,e.length,{message:"SETUP.BACKUPS.DeletingBackup"});try{let t=0;for(const a of e)await this.deleteBackup(a),s.emit(++t);s.complete()}catch(e){s.error(e)}}async deleteBackup({id:e,packageId:t,type:a}){const{logger:s}=global,{backups:i}=this.#e(t,a);await fs.promises.unlink(path.join(i,`${e}.json`)),await fs.promises.unlink(path.join(i,`${e}.bak`)),s.info(`Deleted backup ${e}`)}listBackups(){const{paths:e,logger:t}=global,a=Object.keys(packages.PACKAGE_TYPE_MAPPING).reduce(((a,s)=>{a[s]={};const i=packages.PACKAGE_TYPE_MAPPING[s],r=path.join(e.backups,i.collection);if(!fs.existsSync(r))return a;for(const e of fs.readdirSync(r,{withFileTypes:!0})){if(!e.isDirectory())continue;const i=e.name;try{BasePackage.validateId(i)}catch(e){t.warn(`Invalid backup directory '${i}' found when listing backups: ${e.message}`);continue}a[s][i]=this.getBackups(i,s)}return a}),{});return a.snapshots=this.getSnapshots(),a}getBackups(e,t){const{logger:a}=global,{backups:s}=this.#e(e,t);if(!fs.existsSync(s))return[];const i=[];for(const e of fs.readdirSync(s))if(".json"===path.extname(e))try{const t=JSON.parse(fs.readFileSync(path.join(s,e),{encoding:"utf8"}));i.push(new BackupData(t))}catch(t){a.warn(`Found JSON file '${path.join(s,e)}' that was not a valid backup manifest: ${t.message}`)}return i.sort(((e,t)=>t.createdAt-e.createdAt)),i}async#a(e,t,{onProgress:a,emitCompletion:s}={}){const{logger:i}=global,{ACTIONS:r,STEPS:n}=CONST.SETUP_PACKAGE_PROGRESS,{id:o,packageId:c,type:l,title:p}=e,{backups:g}=this.#e(c,l),d=path.join(g,`${o}.bak`);if(!fs.existsSync(d))throw new Error(`Backup for ${l} package '${c}' with ID '${o}' did not exist.`);let S,u;return i.info(`Extracting backup '${o}' for ${l} package '${c}'.`),await Files.extractArchive(d,t,{onProgress:(e,t,s)=>{S=s,u||(u=new ProgressEmitter(r.RESTORE_BACKUP,n.EXTRACT,s,{packageId:c,type:l,id:o,title:p,message:"SETUP.BACKUPS.Extracting"},{onProgress:a})),u.emit(t)}}),s&&u.complete(),S}async#s(e,t,a,{onProgress:s,emitCompletion:i}={}){const{logger:r}=global,{ACTIONS:n,STEPS:o}=CONST.SETUP_PACKAGE_PROGRESS,{id:c,packageId:l,type:p,title:g}=e,{install:d}=this.#e(l,p);r.info(`Deleting existing installation at '${d}'.`),fs.rmSync(d,{force:!0,recursive:!0,maxRetries:10});let S=0;const u=new ProgressEmitter(n.RESTORE_BACKUP,o.INSTALL,a,{packageId:l,type:p,id:c,title:g,message:"SETUP.BACKUPS.Copying"},{onProgress:s});r.info(`Copying backup files '${t}' -> '${d}'`),await Files.copyDirectory(t,d,{onProgress:()=>u.emit(++S)}),i&&u.complete()}#t(e,t,a={}){const s=new BackupData({...e.toObject(),...a,packageId:e.id,type:e.constructor.type});return fs.writeFileSync(t,JSON.stringify(s.toObject(),null,2),{encoding:"utf8"}),s}async createSnapshot({level:e=6,note:t="",onProgress:a}={}){const{logger:s,packages:i,paths:r}=global,{ACTIONS:n,STEPS:o}=CONST.SETUP_PACKAGE_PROGRESS,c=new Date,l=`snapshot.${c.toDateInputString()}.${c.valueOf()}`,p=path.join(r.backups,"snapshots"),g=path.join(p,`${l}.json`),d=new ProgressEmitter(n.CREATE_SNAPSHOT,null,1,{id:l,type:"snapshot"}),S=[];let u=0,P=0;fs.mkdirSync(p,{recursive:!0}),s.info(`Taking snapshot '${l}'.`);try{for(const[t,r]of Object.entries(i.PACKAGE_TYPE_MAPPING)){s.info(`Snapshotting ${t}s.`);const i=o[`SNAPSHOT_${t.toUpperCase()}S`],c=new ProgressEmitter(n.CREATE_SNAPSHOT,i,r.packages.size,{id:l,type:"snapshot",message:`SETUP.BACKUPS.Snapshotting.${t}`},{onProgress:a});c.emit(0);let p=0;for(const s of r.packages){const i=await this.createBackup(s.id,t,{level:e,onProgress:a,snapshotId:l});c.emit(++p),u+=i.size,P+=i.originalSize,S.push(i)}}}catch(e){throw d.error(e),await this.deleteBackups(S),e}const f=`Wrote ${formatFileSize(u,{decimalPlaces:0})} snapshot '${l}'.`,h=this.#r(g,{id:l,note:t,originalSize:P,createdAt:c.valueOf(),size:u,backups:S.map((e=>e.id))});return d.complete({log:f,context:{snapshotData:h}}),h}async checkCreateSnapshotDiskSpace(){const{packages:e,paths:t}=global;let a=0;for(const t of Object.values(e.PACKAGE_TYPE_MAPPING))a+=await Files.getDirectorySize(t.baseDir);return{required:a,available:await Files.getAvailableDiskSpace(t.backups)}}async restoreSnapshot(e,{onProgress:t}={}){const{paths:a,packages:s}=global,{id:i}=e,r=new ProgressEmitter(CONST.SETUP_PACKAGE_PROGRESS.ACTIONS.RESTORE_SNAPSHOT,null,1),n=path.join(a.backups,"tmp.extract",i),o=path.join(a.backups,"tmp.original",i);fs.mkdirSync(n,{recursive:!0}),fs.mkdirSync(o,{recursive:!0});try{const a=await this.#n(e,n,{onProgress:t});await this.#o(i,a,o,{onProgress:t})}finally{fs.rmSync(n,{recursive:!0,maxRetries:10}),fs.rmSync(o,{recursive:!0,maxRetries:10})}for(const e of Object.values(s.PACKAGE_TYPE_MAPPING))e.resetPackages();r.complete()}async checkRestoreSnapshotDiskSpace({originalSize:e}){const{paths:t}=global;return{required:e,available:await Files.getAvailableDiskSpace(t.backups)}}async#n({backups:e,id:t},a,{onProgress:s}={}){e instanceof Set||(e=new Set(e));const{ACTIONS:i,STEPS:r}=CONST.SETUP_PACKAGE_PROGRESS,n=[],o=new ProgressEmitter(i.RESTORE_SNAPSHOT,r.EXTRACT,e.size,{id:t,type:"snapshot",message:"SETUP.BACKUPS.ExtractingPl"});o.emit(0);for(const t of e)try{const e=this.#c(t);if(!e)throw new Error("Failed to read backup manifest.");const i=path.join(a,t);fs.mkdirSync(i,{recursive:!0});const r=await this.#a(e,i,{onProgress:s,emitCompletion:!0});n.push({backupData:e,totalFiles:r,extractDir:i}),o.emit(n.length)}catch(e){throw e.message=`Failed to restore backup ID '${t}': ${e.message}`,logger.error(e),o.error(e),e}return n}async#o(e,t,a,{onProgress:s}={}){let i;const r=[],{ACTIONS:n,STEPS:o}=CONST.SETUP_PACKAGE_PROGRESS,c=new ProgressEmitter(n.RESTORE_SNAPSHOT,o.INSTALL,t.length,{id:e,type:"snapshot",message:"SETUP.BACKUPS.CopyingPl"});c.emit(0);for(const{backupData:e,totalFiles:n,extractDir:o}of t)try{const{packageId:t,type:i}=e,{install:l}=this.#e(t,i);if(fs.existsSync(l)){const e=path.join(a,i,t);fs.mkdirSync(path.dirname(e),{recursive:!0}),fs.renameSync(l,e)}await this.#s(e,o,n,{onProgress:s,emitCompletion:!0}),r.push(e),c.emit(r.length)}catch(t){t.message=`Failed to restore backup ID '${e.id}': ${t.message}`,logger.error(t),c.error(t),i=t;break}if(i){for(const e of r){const{packageId:t,type:s}=e,i=path.join(a,s,t);if(!fs.existsSync(i))continue;const{install:r}=this.#e(t,s);fs.rmSync(r,{force:!0,recursive:!0,maxRetries:10}),fs.renameSync(i,r)}throw i}}async deleteSnapshots(e,{onProgress:t}={}){const{ACTIONS:a,STEPS:s}=CONST.SETUP_PACKAGE_PROGRESS,i=new ProgressEmitter(a.DELETE_SNAPSHOT,s.DELETE,e.length,{type:"snapshot",message:"SETUP.BACKUPS.DeletingSnapshot"},{onProgress:t});let r=0;for(const a of e)await this.deleteSnapshot(a,{onProgress:t}),i.emit(++r);i.complete()}async deleteSnapshot({id:e,backups:t,generation:a,build:s},{onProgress:i}={}){t instanceof Set||(t=new Set(t));const{paths:r,logger:n}=global,{ACTIONS:o,STEPS:c}=CONST.SETUP_PACKAGE_PROGRESS,l=path.join(r.backups,"snapshots");fs.unlinkSync(path.join(l,`${e}.json`));const p=new ProgressEmitter(o.DELETE_BACKUP,c.DELETE,t.size,{id:e,type:"snapshot",message:"SETUP.BACKUPS.DeletingBackup"},{onProgress:i});let g=0;for(const e of t){const t=this.#c(e);if(!t)throw new Error("Failed to read backup manifest.");await this.deleteBackup(t),p.emit(++g)}p.complete(),n.info(`Deleted snapshot ${e}`)}getSnapshots(){const{logger:e,paths:t}=global,a=path.join(t.backups,"snapshots");if(!fs.existsSync(a))return{};const s=[];for(const t of fs.readdirSync(a))if(".json"===path.extname(t))try{const e=JSON.parse(fs.readFileSync(path.join(a,t),{encoding:"utf8"})),i=new SnapshotData(e);s.push(i)}catch(s){e.warn(`Found JSON file '${path.join(a,t)}' that was not a valid snapshot manifest: ${s.message}`)}return s.sort(((e,t)=>t.createdAt-e.createdAt)),Object.fromEntries(s.map((e=>[e.id,e])))}#r(e,t={}){const{config:a}=global,{generation:s,build:i}=a.release,r=new SnapshotData({type:"snapshot",generation:s,build:i,...t});return fs.writeFileSync(e,JSON.stringify(r.toObject(),null,2),{encoding:"utf8"}),r}#c(e){const[t,a]=e.split(".");if(!t||!a)return;const{backups:s}=this.#e(a,t),i=JSON.parse(fs.readFileSync(path.join(s,`${e}.json`),{encoding:"utf8"}));return new BackupData(i)}#e(e,t){const{packages:a,paths:s}=global,i=a.PACKAGE_TYPE_MAPPING[t];return{install:path.join(i.baseDir,e),backups:path.join(s.backups,i.collection,e)}}#i(e,t){const{packages:a}=global,s=a.PACKAGE_TYPE_MAPPING[t];"system"===t&&a.World.resetPackages();const i=path.join(s.baseDir,e,s.manifestFile),r=s.fromManifestPath(i);s.packages.set(e,r);for(const e of Object.values(a.PACKAGE_TYPE_MAPPING))e.reevaluateAvailabilities()}}class BaseBackupData extends DataModel{static defineSchema(){return{type:new fields.StringField({required:!0,blank:!1,choices:PackageBackups.BACKUP_TYPES}),createdAt:new fields.NumberField({required:!0,integer:!0,positive:!0}),size:new fields.NumberField({required:!0,integer:!0,positive:!0}),originalSize:new fields.NumberField({required:!0,integer:!0,positive:!0}),note:new fields.StringField({required:!0})}}}class BackupData extends BaseBackupData{static defineSchema(){return Object.assign({},super.defineSchema(),{id:new fields.StringField({required:!0,blank:!1,validate:BackupData.validateBackupId}),packageId:new fields.StringField({required:!0,blank:!1,validate:BasePackage.validateId}),snapshotId:new fields.StringField({required:!0,blank:!1,nullable:!0,validate:SnapshotData.validateSnapshotId}),title:new fields.StringField({required:!0,blank:!1}),description:new fields.StringField({required:!0}),version:new fields.StringField({required:!0,blank:!1,initial:"0"}),compatibility:new PackageCompatibility,relationships:new PackageRelationships,system:new fields.StringField({required:!0,blank:!1,nullable:!0})})}static validateBackupId(e){const{packages:t}=global,[,a,s]=e.match(/([a-z]+)\.([A-Z\d-_]+)\.\d{4}-\d\d-\d\d\.\d+/i)??[];if(!(a in t.PACKAGE_TYPE_MAPPING)||!s)throw new Error("Malformed backup identifier.");BasePackage.validateId(s)}}class SnapshotData extends BaseBackupData{static defineSchema(){return Object.assign({},super.defineSchema(),{id:new fields.StringField({required:!0,blank:!1,validate:SnapshotData.validateSnapshotId}),generation:new fields.NumberField({required:!0,nullable:!1,integer:!0,min:1}),build:new fields.NumberField({required:!0,nullable:!1,integer:!0}),backups:new fields.SetField(new fields.StringField({required:!0,blank:!1,validate:BackupData.validateBackupId}))})}static validateSnapshotId(e){if(!/snapshot\.\d{4}-\d\d-\d\d\.\d+/.test(e))throw new Error("Malformed snapshot identifier.")}}