'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var core = require('@pixi/core');
var checkDataUrl = require('../../utils/checkDataUrl.js');
var checkExtension = require('../../utils/checkExtension.js');
var LoaderParser = require('./LoaderParser.js');

const validJSONExtension = ".json";
const validJSONMIME = "application/json";
const loadJson = {
  extension: {
    type: core.ExtensionType.LoadParser,
    priority: LoaderParser.LoaderParserPriority.Low
  },
  name: "loadJson",
  test(url) {
    return checkDataUrl.checkDataUrl(url, validJSONMIME) || checkExtension.checkExtension(url, validJSONExtension);
  },
  async load(url) {
    const response = await core.settings.ADAPTER.fetch(url);
    const json = await response.json();
    return json;
  }
};
core.extensions.add(loadJson);

exports.loadJson = loadJson;
//# sourceMappingURL=loadJson.js.map
