'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var core = require('@pixi/core');
var checkDataUrl = require('../../utils/checkDataUrl.js');
var checkExtension = require('../../utils/checkExtension.js');
var LoaderParser = require('./LoaderParser.js');

const validTXTExtension = ".txt";
const validTXTMIME = "text/plain";
const loadTxt = {
  name: "loadTxt",
  extension: {
    type: core.ExtensionType.LoadParser,
    priority: LoaderParser.LoaderParserPriority.Low
  },
  test(url) {
    return checkDataUrl.checkDataUrl(url, validTXTMIME) || checkExtension.checkExtension(url, validTXTExtension);
  },
  async load(url) {
    const response = await core.settings.ADAPTER.fetch(url);
    const txt = await response.text();
    return txt;
  }
};
core.extensions.add(loadTxt);

exports.loadTxt = loadTxt;
//# sourceMappingURL=loadTxt.js.map
