'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var core = require('@pixi/core');
var checkDataUrl = require('../../../utils/checkDataUrl.js');
var checkExtension = require('../../../utils/checkExtension.js');
var LoaderParser = require('../LoaderParser.js');
var loadTextures = require('./loadTextures.js');
var createTexture = require('./utils/createTexture.js');

const validSVGExtension = ".svg";
const validSVGMIME = "image/svg+xml";
const loadSVG = {
  extension: {
    type: core.ExtensionType.LoadParser,
    priority: LoaderParser.LoaderParserPriority.High
  },
  name: "loadSVG",
  test(url) {
    return checkDataUrl.checkDataUrl(url, validSVGMIME) || checkExtension.checkExtension(url, validSVGExtension);
  },
  async testParse(data) {
    return core.SVGResource.test(data);
  },
  async parse(asset, data, loader) {
    const src = new core.SVGResource(asset, data?.data?.resourceOptions);
    await src.load();
    const base = new core.BaseTexture(src, {
      resolution: core.utils.getResolutionOfUrl(asset),
      ...data?.data
    });
    base.resource.src = asset;
    const texture = createTexture.createTexture(base, loader, asset);
    return texture;
  },
  async load(url, _options) {
    const response = await core.settings.ADAPTER.fetch(url);
    return response.text();
  },
  unload: loadTextures.loadTextures.unload
};
core.extensions.add(loadSVG);

exports.loadSVG = loadSVG;
//# sourceMappingURL=loadSVG.js.map
