import { ExtensionType, settings, extensions } from '@pixi/core';
import '../../loader/index.mjs';
import { loadTextures } from '../../loader/parsers/textures/loadTextures.mjs';

const resolveTextureUrl = {
  extension: ExtensionType.ResolveParser,
  test: loadTextures.test,
  parse: (value) => ({
    resolution: parseFloat(settings.RETINA_PREFIX.exec(value)?.[1] ?? "1"),
    format: value.split(".").pop(),
    src: value
  })
};
extensions.add(resolveTextureUrl);

export { resolveTextureUrl };
//# sourceMappingURL=resolveTextureUrl.mjs.map
