import { ExtensionType, settings, extensions as extensions$1 } from '@pixi/core';

let storedGl;
let extensions;
function getCompressedTextureExtensions() {
  extensions = {
    s3tc: storedGl.getExtension("WEBGL_compressed_texture_s3tc"),
    s3tc_sRGB: storedGl.getExtension("WEBGL_compressed_texture_s3tc_srgb"),
    etc: storedGl.getExtension("WEBGL_compressed_texture_etc"),
    etc1: storedGl.getExtension("WEBGL_compressed_texture_etc1"),
    pvrtc: storedGl.getExtension("WEBGL_compressed_texture_pvrtc") || storedGl.getExtension("WEBKIT_WEBGL_compressed_texture_pvrtc"),
    atc: storedGl.getExtension("WEBGL_compressed_texture_atc"),
    astc: storedGl.getExtension("WEBGL_compressed_texture_astc")
  };
}
const detectCompressedTextures = {
  extension: {
    type: ExtensionType.DetectionParser,
    priority: 2
  },
  test: async () => {
    const canvas = settings.ADAPTER.createCanvas();
    const gl = canvas.getContext("webgl");
    if (!gl) {
      console.warn("WebGL not available for compressed textures.");
      return false;
    }
    storedGl = gl;
    return true;
  },
  add: async (formats) => {
    if (!extensions)
      getCompressedTextureExtensions();
    const textureFormats = [];
    for (const extensionName in extensions) {
      const extension = extensions[extensionName];
      if (!extension) {
        continue;
      }
      textureFormats.push(extensionName);
    }
    return [...textureFormats, ...formats];
  },
  remove: async (formats) => {
    if (!extensions)
      getCompressedTextureExtensions();
    return formats.filter((f) => !(f in extensions));
  }
};
extensions$1.add(detectCompressedTextures);

export { detectCompressedTextures };
//# sourceMappingURL=detectCompressedTextures.mjs.map
