'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var constants = require('@pixi/constants');
var Buffer = require('../geometry/Buffer.js');
var Geometry = require('../geometry/Geometry.js');

class BatchGeometry extends Geometry.Geometry {
  constructor(_static = false) {
    super();
    this._buffer = new Buffer.Buffer(null, _static, false);
    this._indexBuffer = new Buffer.Buffer(null, _static, true);
    this.addAttribute("aVertexPosition", this._buffer, 2, false, constants.TYPES.FLOAT).addAttribute("aTextureCoord", this._buffer, 2, false, constants.TYPES.FLOAT).addAttribute("aColor", this._buffer, 4, true, constants.TYPES.UNSIGNED_BYTE).addAttribute("aTextureId", this._buffer, 1, true, constants.TYPES.FLOAT).addIndex(this._indexBuffer);
  }
}

exports.BatchGeometry = BatchGeometry;
//# sourceMappingURL=BatchGeometry.js.map
