'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var settings = require('@pixi/settings');

function maxRecommendedTextures(max) {
  let allowMax = true;
  const navigator = settings.settings.ADAPTER.getNavigator();
  if (settings.isMobile.tablet || settings.isMobile.phone) {
    if (settings.isMobile.apple.device) {
      const match = navigator.userAgent.match(/OS (\d+)_(\d+)?/);
      if (match) {
        const majorVersion = parseInt(match[1], 10);
        if (majorVersion < 11) {
          allowMax = false;
        }
      }
    }
    if (settings.isMobile.android.device) {
      const match = navigator.userAgent.match(/Android\s([0-9.]*)/);
      if (match) {
        const majorVersion = parseInt(match[1], 10);
        if (majorVersion < 7) {
          allowMax = false;
        }
      }
    }
  }
  return allowMax ? max : 4;
}

exports.maxRecommendedTextures = maxRecommendedTextures;
//# sourceMappingURL=maxRecommendedTextures.js.map
