'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var constants = require('@pixi/constants');
var Program = require('../shader/Program.js');
var Shader = require('../shader/Shader.js');
var State = require('../state/State.js');
var defaultFilter$1 = require('./defaultFilter.js');
var defaultFilter = require('./defaultFilter2.js');

const _Filter = class extends Shader.Shader {
  constructor(vertexSrc, fragmentSrc, uniforms) {
    const program = Program.Program.from(vertexSrc || _Filter.defaultVertexSrc, fragmentSrc || _Filter.defaultFragmentSrc);
    super(program, uniforms);
    this.padding = 0;
    this.resolution = _Filter.defaultResolution;
    this.multisample = _Filter.defaultMultisample;
    this.enabled = true;
    this.autoFit = true;
    this.state = new State.State();
  }
  apply(filterManager, input, output, clearMode, _currentState) {
    filterManager.applyFilter(this, input, output, clearMode);
  }
  get blendMode() {
    return this.state.blendMode;
  }
  set blendMode(value) {
    this.state.blendMode = value;
  }
  get resolution() {
    return this._resolution;
  }
  set resolution(value) {
    this._resolution = value;
  }
  static get defaultVertexSrc() {
    return defaultFilter["default"];
  }
  static get defaultFragmentSrc() {
    return defaultFilter$1["default"];
  }
};
let Filter = _Filter;
Filter.defaultResolution = 1;
Filter.defaultMultisample = constants.MSAA_QUALITY.NONE;

exports.Filter = Filter;
//# sourceMappingURL=Filter.js.map
