'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var math = require('@pixi/math');
var TextureMatrix = require('../../textures/TextureMatrix.js');
var Filter = require('../Filter.js');
var spriteMaskFilter$1 = require('./spriteMaskFilter2.js');
var spriteMaskFilter = require('./spriteMaskFilter3.js');

class SpriteMaskFilter extends Filter.Filter {
  constructor(vertexSrc, fragmentSrc, uniforms) {
    let sprite = null;
    if (typeof vertexSrc !== "string" && fragmentSrc === void 0 && uniforms === void 0) {
      sprite = vertexSrc;
      vertexSrc = void 0;
      fragmentSrc = void 0;
      uniforms = void 0;
    }
    super(vertexSrc || spriteMaskFilter["default"], fragmentSrc || spriteMaskFilter$1["default"], uniforms);
    this.maskSprite = sprite;
    this.maskMatrix = new math.Matrix();
  }
  get maskSprite() {
    return this._maskSprite;
  }
  set maskSprite(value) {
    this._maskSprite = value;
    if (this._maskSprite) {
      this._maskSprite.renderable = false;
    }
  }
  apply(filterManager, input, output, clearMode) {
    const maskSprite = this._maskSprite;
    const tex = maskSprite._texture;
    if (!tex.valid) {
      return;
    }
    if (!tex.uvMatrix) {
      tex.uvMatrix = new TextureMatrix.TextureMatrix(tex, 0);
    }
    tex.uvMatrix.update();
    this.uniforms.npmAlpha = tex.baseTexture.alphaMode ? 0 : 1;
    this.uniforms.mask = tex;
    this.uniforms.otherMatrix = filterManager.calculateSpriteMatrix(this.maskMatrix, maskSprite).prepend(tex.uvMatrix.mapCoord);
    this.uniforms.alpha = maskSprite.worldAlpha;
    this.uniforms.maskClamp = tex.uvMatrix.uClampFrame;
    filterManager.applyFilter(this, input, output, clearMode);
  }
}

exports.SpriteMaskFilter = SpriteMaskFilter;
//# sourceMappingURL=SpriteMaskFilter.js.map
