import { Filter, defaultFilterVertex } from '@pixi/core';
import fragment from './noise.mjs';

class NoiseFilter extends Filter {
  constructor(noise = 0.5, seed = Math.random()) {
    super(defaultFilterVertex, fragment, {
      uNoise: 0,
      uSeed: 0
    });
    this.noise = noise;
    this.seed = seed;
  }
  get noise() {
    return this.uniforms.uNoise;
  }
  set noise(value) {
    this.uniforms.uNoise = value;
  }
  get seed() {
    return this.uniforms.uSeed;
  }
  set seed(value) {
    this.uniforms.uSeed = value;
  }
}

export { NoiseFilter };
//# sourceMappingURL=NoiseFilter.mjs.map
