import { Texture } from '@pixi/core';
import { Mesh, MeshGeometry, MeshMaterial } from '@pixi/mesh';

class SimpleMesh extends Mesh {
  constructor(texture = Texture.EMPTY, vertices, uvs, indices, drawMode) {
    const geometry = new MeshGeometry(vertices, uvs, indices);
    geometry.getBuffer("aVertexPosition").static = false;
    const meshMaterial = new MeshMaterial(texture);
    super(geometry, meshMaterial, null, drawMode);
    this.autoUpdate = true;
  }
  get vertices() {
    return this.geometry.getBuffer("aVertexPosition").data;
  }
  set vertices(value) {
    this.geometry.getBuffer("aVertexPosition").data = value;
  }
  _render(renderer) {
    if (this.autoUpdate) {
      this.geometry.getBuffer("aVertexPosition").update();
    }
    super._render(renderer);
  }
}

export { SimpleMesh };
//# sourceMappingURL=SimpleMesh.mjs.map
