'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var core = require('@pixi/core');
var mesh = require('@pixi/mesh');
var PlaneGeometry = require('./geometry/PlaneGeometry.js');

class SimplePlane extends mesh.Mesh {
  constructor(texture, verticesX, verticesY) {
    const planeGeometry = new PlaneGeometry.PlaneGeometry(texture.width, texture.height, verticesX, verticesY);
    const meshMaterial = new mesh.MeshMaterial(core.Texture.WHITE);
    super(planeGeometry, meshMaterial);
    this.texture = texture;
    this.autoResize = true;
  }
  textureUpdated() {
    this._textureID = this.shader.texture._updateID;
    const geometry = this.geometry;
    const { width, height } = this.shader.texture;
    if (this.autoResize && (geometry.width !== width || geometry.height !== height)) {
      geometry.width = this.shader.texture.width;
      geometry.height = this.shader.texture.height;
      geometry.build();
    }
  }
  set texture(value) {
    if (this.shader.texture === value) {
      return;
    }
    this.shader.texture = value;
    this._textureID = -1;
    if (value.baseTexture.valid) {
      this.textureUpdated();
    } else {
      value.once("update", this.textureUpdated, this);
    }
  }
  get texture() {
    return this.shader.texture;
  }
  _render(renderer) {
    if (this._textureID !== this.shader.texture._updateID) {
      this.textureUpdated();
    }
    super._render(renderer);
  }
  destroy(options) {
    this.shader.texture.off("update", this.textureUpdated, this);
    super.destroy(options);
  }
}

exports.SimplePlane = SimplePlane;
//# sourceMappingURL=SimplePlane.js.map
