'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

class CountLimiter {
  constructor(maxItemsPerFrame) {
    this.maxItemsPerFrame = maxItemsPerFrame;
    this.itemsLeft = 0;
  }
  beginFrame() {
    this.itemsLeft = this.maxItemsPerFrame;
  }
  allowedToUpload() {
    return this.itemsLeft-- > 0;
  }
}

exports.CountLimiter = CountLimiter;
//# sourceMappingURL=CountLimiter.js.map
