import{isNewerVersion}from"../../common/utils/helpers.mjs";import{PACKAGE_AVAILABILITY_CODES}from"../../common/constants.mjs";import{World,System,Module,PACKAGE_TYPE_MAPPING}from"./_module.mjs";import path from"path";import PreviewCompatibility from"./preview-compatibility.mjs";import{ReleaseData}from"../../common/config.mjs";export async function getPackages({type:e="system"}={}){const t=PACKAGE_TYPE_MAPPING[e];if(!t)throw new Error(`Invalid package type ${e} requested`);const{packages:r,owned:a}=await t.getRepositoryPackages();return{packages:Array.from(r.values()).map((e=>e.vend())),owned:a}}export async function getPackageFromRemoteManifest({type:e="module",manifest:t=""}={}){const r=PACKAGE_TYPE_MAPPING[e];return await r.fromRemoteManifest(t)}export async function checkPackage({type:e,id:t,manifest:r}={}){const a=PACKAGE_TYPE_MAPPING[e];if(!a)throw new Error(`Invalid package type ${e} requested`);const o=a.get(t,{strict:!1});if(!r){if(!o.manifest)throw new Error(`The ${e} ${t} has no manifest URL provided`);r=o.manifest}const s=await a.check(r,o),n=s.remote;let i;if(o&&(i=await a.fromRepository(t),!i||n&&!isNewerVersion(i.version,n.version)||(s.trackChange=o.suggestTrackChange(i))),s.trackChange&&s.error&&404===s.errorCode&&delete s.error,s.trackChange||!n)return s;if(s.isUpgrade||s.isDowngrade)return s;if(o&&!o.protected){o.sidegrade(n,i)&&(s.hasSidegraded=!0)}return s}export async function installPackage({type:e,id:t,manifest:r}){const{logger:a,express:o}=config,s=PACKAGE_TYPE_MAPPING[e];if(!s)throw new Error(`Invalid package type ${e} requested`);if(!r)throw new Error("A manifest URL must be provided");const n=await checkPackage({type:e,id:t,manifest:r}),i=n.remote;if(!i){let t=[`Unable to load valid ${e} manifest data from "${r}"`,n.error].filterJoin("\n");throw new Error(t)}if(t=i.id,n.isDowngrade)throw new Error(`You are currently using a more recent version of ${e} ${i.title} and may not downgrade to an older version`);const c=i.availability,p=PACKAGE_AVAILABILITY_CODES;if(c===p.REQUIRES_CORE_DOWNGRADE)throw new Error(`${e} ${t} version ${i.version} requires an older version of the Foundry Virtual Tabletop software: ${i.compatibility.maximum} or older`);if([p.REQUIRES_CORE_UPGRADE_STABLE,p.REQUIRES_CORE_UPGRADE_UNSTABLE].includes(c))throw new Error(`${e} ${t} version ${i.version} requires a more modern version of the Foundry Virtual Tabletop software: ${i.compatibility.minimum} or newer`);let l,E=i.download;if(i.protected){if(l=await s.getProtectedDownloadURL({type:e,id:t,version:i.version}),"error"===l.status)throw new Error(l.message);E=l.download}if(!E)throw new Error(`The ${i.title} ${e} does not provide a download URL that can be installed`);const P={};!1==!n.compatibility?P.warning=`${i.title} version ${i.version} may not be compatible with Foundry VTT versions newer than ${i.compatibility.verified}`:null===n.compatibility&&(P.warning=`${i.title} version ${i.version} does not specify compatibility and may not work with Foundry VTT version ${config.release.version}`);const g=(s,n,i={})=>{let c;const p=CONST.SETUP_PACKAGE_PROGRESS.STEPS;switch(s){case p.DOWNLOAD:c="Downloading Package";break;case p.INSTALL:c="Installing package";break;case p.CLEANUP:c="Cleaning Up Artifacts";break;case p.COMPLETE:c="Installation Complete";break;case p.VEND:c="Vending Package";break;case p.ERROR:c=i.error}a.info(`${c} - ${n}%`);const l=`SETUP.PackageProgress${s.titleCase()}`;o.io.emit("progress",{action:CONST.SETUP_PACKAGE_PROGRESS.ACTIONS.INSTALL_PKG,type:e,id:t,manifest:r,pct:n,step:s,message:l,...i})};return new Promise((async(e,o)=>{const n=CONST.SETUP_PACKAGE_PROGRESS.STEPS;try{const a=await s.install(t,r,E,l,{onFetched:()=>e(P),onProgress:g,onError:(e,t)=>{if(e===n.DOWNLOAD)return o(t);const r={error:t.message,stack:t.stack};g(n.ERROR,100,r)}});if(!a)return g(n.ERROR,100,{error:"PACKAGE.InstallFailed",packageWarnings:{[t]:packages.warnings.toJSON()[t]}});const i={pkg:a.vend()};g(n.VEND,100,i)}catch(e){g(n.ERROR,100,{error:e.message}),a.error(e),o(e)}}))}export async function resetPackages(){return Module.resetPackages(),System.resetPackages(),World.resetPackages(),{message:"Reset package cache for all package types"}}export async function uninstallPackage({type:e,id:t}){const r=PACKAGE_TYPE_MAPPING[e];if(!r)throw new Error(`Invalid package type ${e} requested`);const a=r.uninstall(t);return a.uninstalled=!0,a}export async function lockPackage({type:e,id:t,shouldLock:r}){const a=PACKAGE_TYPE_MAPPING[e];if(!a)throw new Error(`Invalid package type ${e} requested`);return a.get(t,{strict:!1}).lock(r),{message:`Locked package ${t}`}}export async function handlePreviewCompatibility({release:e}){const t=new PreviewCompatibility(new ReleaseData(e));return await t.evaluate(),t.vend()}export function handleCreateBackups({backups:e}){const{packages:t,express:r}=global,{ACTIONS:a,STEPS:o}=CONST.SETUP_PACKAGE_PROGRESS;return t.backups.createBackups(e).catch((e=>{r.io.emit("progress",{action:a.CREATE_BACKUP,step:o.ERROR,error:e.message,stack:e.stack})})),{}}export function handleCreateSnapshot({note:e}){const{packages:t,express:r}=global,{ACTIONS:a,STEPS:o}=CONST.SETUP_PACKAGE_PROGRESS;return t.backups.createSnapshot({note:e}).catch((e=>{r.io.emit("progress",{action:a.CREATE_SNAPSHOT,steps:o.ERROR,error:e.message,stack:e.stack})})),{}}export function handleDeleteBackups({backups:e}){const{packages:t,express:r}=global,{ACTIONS:a,STEPS:o}=CONST.SETUP_PACKAGE_PROGRESS;return t.backups.deleteBackups(e).catch((e=>{r.io.emit("progress",{action:a.DELETE_BACKUP,step:o.ERROR,error:e.message,stack:e.stack})})),{}}export function handleDeleteSnapshots({snapshots:e}){const{packages:t,express:r}=global,{ACTIONS:a,STEPS:o}=CONST.SETUP_PACKAGE_PROGRESS;return t.backups.deleteSnapshots(e).catch((e=>{r.io.emit("progress",{action:a.DELETE_SNAPSHOT,step:o.ERROR,error:e.message,stack:e.stack})})),{}}export function handleRestoreBackups({backups:e}){const{packages:t,express:r}=global,{ACTIONS:a,STEPS:o}=CONST.SETUP_PACKAGE_PROGRESS;return t.backups.restoreBackups(e).catch((e=>{r.io.emit("progress",{action:a.RESTORE_BACKUP,steps:o.ERROR,error:e.message,stack:e.stack})})),{}}export function handleRestoreSnapshot({snapshotData:e}){const{packages:t,express:r}=global,{ACTIONS:a,STEPS:o}=CONST.SETUP_PACKAGE_PROGRESS;return t.backups.restoreSnapshot(e).catch((e=>{r.io.emit("progress",{action:a.RESTORE_SNAPSHOT,steps:o.ERROR,error:e.message,stack:e.stack})})),{}}