'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var core = require('@pixi/core');
require('../utils/index.js');
var convertToList = require('../utils/convertToList.js');

class CacheClass {
  constructor() {
    this._parsers = [];
    this._cache = /* @__PURE__ */ new Map();
    this._cacheMap = /* @__PURE__ */ new Map();
  }
  reset() {
    this._cacheMap.clear();
    this._cache.clear();
  }
  has(key) {
    return this._cache.has(key);
  }
  get(key) {
    const result = this._cache.get(key);
    if (!result) {
      console.warn(`[Assets] Asset id ${key} was not found in the Cache`);
    }
    return result;
  }
  set(key, value) {
    const keys = convertToList.convertToList(key);
    let cacheableAssets;
    for (let i = 0; i < this.parsers.length; i++) {
      const parser = this.parsers[i];
      if (parser.test(value)) {
        cacheableAssets = parser.getCacheableAssets(keys, value);
        break;
      }
    }
    if (!cacheableAssets) {
      cacheableAssets = {};
      keys.forEach((key2) => {
        cacheableAssets[key2] = value;
      });
    }
    const cacheKeys = Object.keys(cacheableAssets);
    const cachedAssets = {
      cacheKeys,
      keys
    };
    keys.forEach((key2) => {
      this._cacheMap.set(key2, cachedAssets);
    });
    cacheKeys.forEach((key2) => {
      if (this._cache.has(key2) && this._cache.get(key2) !== value) {
        console.warn("[Cache] already has key:", key2);
      }
      this._cache.set(key2, cacheableAssets[key2]);
    });
    if (value instanceof core.Texture) {
      const texture = value;
      keys.forEach((key2) => {
        if (texture.baseTexture !== core.Texture.EMPTY.baseTexture) {
          core.BaseTexture.addToCache(texture.baseTexture, key2);
        }
        core.Texture.addToCache(texture, key2);
      });
    }
  }
  remove(key) {
    this._cacheMap.get(key);
    if (!this._cacheMap.has(key)) {
      console.warn(`[Assets] Asset id ${key} was not found in the Cache`);
      return;
    }
    const cacheMap = this._cacheMap.get(key);
    const cacheKeys = cacheMap.cacheKeys;
    cacheKeys.forEach((key2) => {
      this._cache.delete(key2);
    });
    cacheMap.keys.forEach((key2) => {
      this._cacheMap.delete(key2);
    });
  }
  get parsers() {
    return this._parsers;
  }
}
const Cache = new CacheClass();

exports.Cache = Cache;
//# sourceMappingURL=Cache.js.map
