'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var core = require('@pixi/core');

const cacheTextureArray = {
  extension: core.ExtensionType.CacheParser,
  test: (asset) => Array.isArray(asset) && asset.every((t) => t instanceof core.Texture),
  getCacheableAssets: (keys, asset) => {
    const out = {};
    keys.forEach((key) => {
      asset.forEach((item, i) => {
        out[key + (i === 0 ? "" : i + 1)] = item;
      });
    });
    return out;
  }
};
core.extensions.add(cacheTextureArray);

exports.cacheTextureArray = cacheTextureArray;
//# sourceMappingURL=cacheTextureArray.js.map
