import { ExtensionType, settings, extensions } from '@pixi/core';
import { checkDataUrl } from '../../utils/checkDataUrl.mjs';
import { checkExtension } from '../../utils/checkExtension.mjs';
import { LoaderParserPriority } from './LoaderParser.mjs';

const validJSONExtension = ".json";
const validJSONMIME = "application/json";
const loadJson = {
  extension: {
    type: ExtensionType.LoadParser,
    priority: LoaderParserPriority.Low
  },
  name: "loadJson",
  test(url) {
    return checkDataUrl(url, validJSONMIME) || checkExtension(url, validJSONExtension);
  },
  async load(url) {
    const response = await settings.ADAPTER.fetch(url);
    const json = await response.json();
    return json;
  }
};
extensions.add(loadJson);

export { loadJson };
//# sourceMappingURL=loadJson.mjs.map
