'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var assets = require('@pixi/assets');
var core = require('@pixi/core');
require('../parsers/index.js');
var parseKTX = require('../parsers/parseKTX.js');

const loadKTX = {
  extension: {
    type: core.ExtensionType.LoadParser,
    priority: assets.LoaderParserPriority.High
  },
  name: "loadKTX",
  test(url) {
    return assets.checkExtension(url, ".ktx");
  },
  async load(url, asset, loader) {
    const response = await core.settings.ADAPTER.fetch(url);
    const arrayBuffer = await response.arrayBuffer();
    const { compressed, uncompressed, kvData } = parseKTX.parseKTX(url, arrayBuffer);
    const resources = compressed ?? uncompressed;
    const options = {
      mipmap: core.MIPMAP_MODES.OFF,
      alphaMode: core.ALPHA_MODES.NO_PREMULTIPLIED_ALPHA,
      resolution: core.utils.getResolutionOfUrl(url),
      ...asset.data
    };
    const textures = resources.map((resource) => {
      if (resources === uncompressed) {
        Object.assign(options, {
          type: resource.type,
          format: resource.format
        });
      }
      const base = new core.BaseTexture(resource, options);
      base.ktxKeyValueData = kvData;
      return assets.createTexture(base, loader, url);
    });
    return textures.length === 1 ? textures[0] : textures;
  },
  unload(texture) {
    if (Array.isArray(texture)) {
      texture.forEach((t) => t.destroy(true));
    } else {
      texture.destroy(true);
    }
  }
};
core.extensions.add(loadKTX);

exports.loadKTX = loadKTX;
//# sourceMappingURL=loadKTX.js.map
