'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var core = require('@pixi/core');

const resolveCompressedTextureUrl = {
  extension: core.ExtensionType.ResolveParser,
  test: (value) => {
    const temp = value.split("?")[0];
    const extension = temp.split(".").pop();
    return ["basis", "ktx", "dds"].includes(extension);
  },
  parse: (value) => {
    const temp = value.split("?")[0];
    const extension = temp.split(".").pop();
    if (extension === "ktx") {
      const extensions2 = [
        ".s3tc.ktx",
        ".s3tc_sRGB.ktx",
        ".etc.ktx",
        ".etc1.ktx",
        ".pvrt.ktx",
        ".atc.ktx",
        ".astc.ktx"
      ];
      if (extensions2.some((ext) => value.endsWith(ext))) {
        return {
          resolution: parseFloat(core.settings.RETINA_PREFIX.exec(value)?.[1] ?? "1"),
          format: extensions2.find((ext) => value.endsWith(ext)),
          src: value
        };
      }
    }
    return {
      resolution: parseFloat(core.settings.RETINA_PREFIX.exec(value)?.[1] ?? "1"),
      format: value.split(".").pop(),
      src: value
    };
  }
};
core.extensions.add(resolveCompressedTextureUrl);

exports.resolveCompressedTextureUrl = resolveCompressedTextureUrl;
//# sourceMappingURL=resolveCompressedTextureUrl.js.map
