'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

require('./settings.js');
var color = require('@pixi/color');
var constants = require('@pixi/constants');
var extensions = require('@pixi/extensions');
var math = require('@pixi/math');
var runner = require('@pixi/runner');
var settings = require('@pixi/settings');
var ticker = require('@pixi/ticker');
var utils$1 = require('@pixi/utils');
var autoDetectRenderer = require('./autoDetectRenderer.js');
var BackgroundSystem = require('./background/BackgroundSystem.js');
var BatchDrawCall = require('./batch/BatchDrawCall.js');
var BatchGeometry = require('./batch/BatchGeometry.js');
var BatchRenderer = require('./batch/BatchRenderer.js');
var BatchShaderGenerator = require('./batch/BatchShaderGenerator.js');
var BatchSystem = require('./batch/BatchSystem.js');
var BatchTextureArray = require('./batch/BatchTextureArray.js');
var ObjectRenderer = require('./batch/ObjectRenderer.js');
var ContextSystem = require('./context/ContextSystem.js');
var Filter = require('./filters/Filter.js');
var FilterState = require('./filters/FilterState.js');
var FilterSystem = require('./filters/FilterSystem.js');
require('./filters/IFilterTarget.js');
var SpriteMaskFilter = require('./filters/spriteMask/SpriteMaskFilter.js');
var index = require('./fragments/index.js');
var Framebuffer = require('./framebuffer/Framebuffer.js');
var FramebufferSystem = require('./framebuffer/FramebufferSystem.js');
var GLFramebuffer = require('./framebuffer/GLFramebuffer.js');
var MultisampleSystem = require('./framebuffer/MultisampleSystem.js');
var Attribute = require('./geometry/Attribute.js');
var Buffer = require('./geometry/Buffer.js');
var BufferSystem = require('./geometry/BufferSystem.js');
var Geometry = require('./geometry/Geometry.js');
var GeometrySystem = require('./geometry/GeometrySystem.js');
var ViewableBuffer = require('./geometry/ViewableBuffer.js');
require('./IRenderer.js');
var MaskData = require('./mask/MaskData.js');
var MaskSystem = require('./mask/MaskSystem.js');
var ScissorSystem = require('./mask/ScissorSystem.js');
var StencilSystem = require('./mask/StencilSystem.js');
var PluginSystem = require('./plugin/PluginSystem.js');
var ProjectionSystem = require('./projection/ProjectionSystem.js');
var ObjectRendererSystem = require('./render/ObjectRendererSystem.js');
var Renderer = require('./Renderer.js');
var BaseRenderTexture = require('./renderTexture/BaseRenderTexture.js');
var GenerateTextureSystem = require('./renderTexture/GenerateTextureSystem.js');
var RenderTexture = require('./renderTexture/RenderTexture.js');
var RenderTexturePool = require('./renderTexture/RenderTexturePool.js');
var RenderTextureSystem = require('./renderTexture/RenderTextureSystem.js');
var GLProgram = require('./shader/GLProgram.js');
var Program = require('./shader/Program.js');
var Shader = require('./shader/Shader.js');
var ShaderSystem = require('./shader/ShaderSystem.js');
var UniformGroup = require('./shader/UniformGroup.js');
var checkMaxIfStatementsInShader = require('./shader/utils/checkMaxIfStatementsInShader.js');
var generateProgram = require('./shader/utils/generateProgram.js');
var generateUniformBufferSync = require('./shader/utils/generateUniformBufferSync.js');
var getTestContext = require('./shader/utils/getTestContext.js');
var uniformParsers = require('./shader/utils/uniformParsers.js');
var unsafeEvalSupported = require('./shader/utils/unsafeEvalSupported.js');
var StartupSystem = require('./startup/StartupSystem.js');
var State = require('./state/State.js');
var StateSystem = require('./state/StateSystem.js');
require('./system/ISystem.js');
require('./systems.js');
var BaseTexture = require('./textures/BaseTexture.js');
var GLTexture = require('./textures/GLTexture.js');
require('./textures/resources/index.js');
var Texture = require('./textures/Texture.js');
var TextureGCSystem = require('./textures/TextureGCSystem.js');
var TextureMatrix = require('./textures/TextureMatrix.js');
var TextureSystem = require('./textures/TextureSystem.js');
var TextureUvs = require('./textures/TextureUvs.js');
var TransformFeedback = require('./transformFeedback/TransformFeedback.js');
var TransformFeedbackSystem = require('./transformFeedback/TransformFeedbackSystem.js');
var Quad = require('./utils/Quad.js');
var QuadUv = require('./utils/QuadUv.js');
var ViewSystem = require('./view/ViewSystem.js');
var SystemManager = require('./system/SystemManager.js');
var BaseImageResource = require('./textures/resources/BaseImageResource.js');
var Resource = require('./textures/resources/Resource.js');
var AbstractMultiResource = require('./textures/resources/AbstractMultiResource.js');
var ArrayResource = require('./textures/resources/ArrayResource.js');
var autoDetectResource = require('./textures/resources/autoDetectResource.js');
var BufferResource = require('./textures/resources/BufferResource.js');
var CanvasResource = require('./textures/resources/CanvasResource.js');
var CubeResource = require('./textures/resources/CubeResource.js');
var ImageBitmapResource = require('./textures/resources/ImageBitmapResource.js');
var ImageResource = require('./textures/resources/ImageResource.js');
var SVGResource = require('./textures/resources/SVGResource.js');
var VideoResource = require('./textures/resources/VideoResource.js');

function _interopNamespace(e) {
	if (e && e.__esModule) return e;
	var n = Object.create(null);
	if (e) {
		Object.keys(e).forEach(function (k) {
			if (k !== 'default') {
				var d = Object.getOwnPropertyDescriptor(e, k);
				Object.defineProperty(n, k, d.get ? d : {
					enumerable: true,
					get: function () { return e[k]; }
				});
			}
		});
	}
	n["default"] = e;
	return n;
}

var utils__namespace = /*#__PURE__*/_interopNamespace(utils$1);

const VERSION = "7.2.4";

exports.utils = utils__namespace;
exports.autoDetectRenderer = autoDetectRenderer.autoDetectRenderer;
exports.BackgroundSystem = BackgroundSystem.BackgroundSystem;
exports.BatchDrawCall = BatchDrawCall.BatchDrawCall;
exports.BatchGeometry = BatchGeometry.BatchGeometry;
exports.BatchRenderer = BatchRenderer.BatchRenderer;
exports.BatchShaderGenerator = BatchShaderGenerator.BatchShaderGenerator;
exports.BatchSystem = BatchSystem.BatchSystem;
exports.BatchTextureArray = BatchTextureArray.BatchTextureArray;
exports.ObjectRenderer = ObjectRenderer.ObjectRenderer;
exports.ContextSystem = ContextSystem.ContextSystem;
exports.Filter = Filter.Filter;
exports.FilterState = FilterState.FilterState;
exports.FilterSystem = FilterSystem.FilterSystem;
exports.SpriteMaskFilter = SpriteMaskFilter.SpriteMaskFilter;
exports.defaultFilterVertex = index.defaultFilterVertex;
exports.defaultVertex = index.defaultVertex;
exports.Framebuffer = Framebuffer.Framebuffer;
exports.FramebufferSystem = FramebufferSystem.FramebufferSystem;
exports.GLFramebuffer = GLFramebuffer.GLFramebuffer;
exports.MultisampleSystem = MultisampleSystem.MultisampleSystem;
exports.Attribute = Attribute.Attribute;
exports.Buffer = Buffer.Buffer;
exports.BufferSystem = BufferSystem.BufferSystem;
exports.Geometry = Geometry.Geometry;
exports.GeometrySystem = GeometrySystem.GeometrySystem;
exports.ViewableBuffer = ViewableBuffer.ViewableBuffer;
exports.MaskData = MaskData.MaskData;
exports.MaskSystem = MaskSystem.MaskSystem;
exports.ScissorSystem = ScissorSystem.ScissorSystem;
exports.StencilSystem = StencilSystem.StencilSystem;
exports.PluginSystem = PluginSystem.PluginSystem;
exports.ProjectionSystem = ProjectionSystem.ProjectionSystem;
exports.ObjectRendererSystem = ObjectRendererSystem.ObjectRendererSystem;
exports.Renderer = Renderer.Renderer;
exports.BaseRenderTexture = BaseRenderTexture.BaseRenderTexture;
exports.GenerateTextureSystem = GenerateTextureSystem.GenerateTextureSystem;
exports.RenderTexture = RenderTexture.RenderTexture;
exports.RenderTexturePool = RenderTexturePool.RenderTexturePool;
exports.RenderTextureSystem = RenderTextureSystem.RenderTextureSystem;
exports.GLProgram = GLProgram.GLProgram;
exports.IGLUniformData = GLProgram.IGLUniformData;
exports.Program = Program.Program;
exports.Shader = Shader.Shader;
exports.ShaderSystem = ShaderSystem.ShaderSystem;
exports.UniformGroup = UniformGroup.UniformGroup;
exports.checkMaxIfStatementsInShader = checkMaxIfStatementsInShader.checkMaxIfStatementsInShader;
exports.generateProgram = generateProgram.generateProgram;
exports.createUBOElements = generateUniformBufferSync.createUBOElements;
exports.generateUniformBufferSync = generateUniformBufferSync.generateUniformBufferSync;
exports.getUBOData = generateUniformBufferSync.getUBOData;
exports.getTestContext = getTestContext.getTestContext;
exports.uniformParsers = uniformParsers.uniformParsers;
exports.unsafeEvalSupported = unsafeEvalSupported.unsafeEvalSupported;
exports.StartupSystem = StartupSystem.StartupSystem;
exports.State = State.State;
exports.StateSystem = StateSystem.StateSystem;
exports.BaseTexture = BaseTexture.BaseTexture;
exports.GLTexture = GLTexture.GLTexture;
exports.Texture = Texture.Texture;
exports.TextureGCSystem = TextureGCSystem.TextureGCSystem;
exports.TextureMatrix = TextureMatrix.TextureMatrix;
exports.TextureSystem = TextureSystem.TextureSystem;
exports.TextureUvs = TextureUvs.TextureUvs;
exports.TransformFeedback = TransformFeedback.TransformFeedback;
exports.TransformFeedbackSystem = TransformFeedbackSystem.TransformFeedbackSystem;
exports.Quad = Quad.Quad;
exports.QuadUv = QuadUv.QuadUv;
exports.ViewSystem = ViewSystem.ViewSystem;
exports.SystemManager = SystemManager.SystemManager;
exports.BaseImageResource = BaseImageResource.BaseImageResource;
exports.Resource = Resource.Resource;
exports.AbstractMultiResource = AbstractMultiResource.AbstractMultiResource;
exports.ArrayResource = ArrayResource.ArrayResource;
exports.INSTALLED = autoDetectResource.INSTALLED;
exports.autoDetectResource = autoDetectResource.autoDetectResource;
exports.BufferResource = BufferResource.BufferResource;
exports.CanvasResource = CanvasResource.CanvasResource;
exports.CubeResource = CubeResource.CubeResource;
exports.ImageBitmapResource = ImageBitmapResource.ImageBitmapResource;
exports.ImageResource = ImageResource.ImageResource;
exports.SVGResource = SVGResource.SVGResource;
exports.VideoResource = VideoResource.VideoResource;
exports.VERSION = VERSION;
Object.keys(color).forEach(function (k) {
	if (k !== 'default' && !exports.hasOwnProperty(k)) Object.defineProperty(exports, k, {
		enumerable: true,
		get: function () { return color[k]; }
	});
});
Object.keys(constants).forEach(function (k) {
	if (k !== 'default' && !exports.hasOwnProperty(k)) Object.defineProperty(exports, k, {
		enumerable: true,
		get: function () { return constants[k]; }
	});
});
Object.keys(extensions).forEach(function (k) {
	if (k !== 'default' && !exports.hasOwnProperty(k)) Object.defineProperty(exports, k, {
		enumerable: true,
		get: function () { return extensions[k]; }
	});
});
Object.keys(math).forEach(function (k) {
	if (k !== 'default' && !exports.hasOwnProperty(k)) Object.defineProperty(exports, k, {
		enumerable: true,
		get: function () { return math[k]; }
	});
});
Object.keys(runner).forEach(function (k) {
	if (k !== 'default' && !exports.hasOwnProperty(k)) Object.defineProperty(exports, k, {
		enumerable: true,
		get: function () { return runner[k]; }
	});
});
Object.keys(settings).forEach(function (k) {
	if (k !== 'default' && !exports.hasOwnProperty(k)) Object.defineProperty(exports, k, {
		enumerable: true,
		get: function () { return settings[k]; }
	});
});
Object.keys(ticker).forEach(function (k) {
	if (k !== 'default' && !exports.hasOwnProperty(k)) Object.defineProperty(exports, k, {
		enumerable: true,
		get: function () { return ticker[k]; }
	});
});
//# sourceMappingURL=index.js.map
