'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var color = require('@pixi/color');
var constants = require('@pixi/constants');
var Framebuffer = require('../framebuffer/Framebuffer.js');
var BaseTexture = require('../textures/BaseTexture.js');

class BaseRenderTexture extends BaseTexture.BaseTexture {
  constructor(options = {}) {
    if (typeof options === "number") {
      const width = arguments[0];
      const height = arguments[1];
      const scaleMode = arguments[2];
      const resolution = arguments[3];
      options = { width, height, scaleMode, resolution };
    }
    options.width = options.width || 100;
    options.height = options.height || 100;
    options.multisample ?? (options.multisample = constants.MSAA_QUALITY.NONE);
    super(null, options);
    this.mipmap = constants.MIPMAP_MODES.OFF;
    this.valid = true;
    this._clear = new color.Color([0, 0, 0, 0]);
    this.framebuffer = new Framebuffer.Framebuffer(this.realWidth, this.realHeight).addColorTexture(0, this);
    this.framebuffer.multisample = options.multisample;
    this.maskStack = [];
    this.filterStack = [{}];
  }
  set clearColor(value) {
    this._clear.setValue(value);
  }
  get clearColor() {
    return this._clear.value;
  }
  get clear() {
    return this._clear;
  }
  resize(desiredWidth, desiredHeight) {
    this.framebuffer.resize(desiredWidth * this.resolution, desiredHeight * this.resolution);
    this.setRealSize(this.framebuffer.width, this.framebuffer.height);
  }
  dispose() {
    this.framebuffer.dispose();
    super.dispose();
  }
  destroy() {
    super.destroy();
    this.framebuffer.destroyDepthTexture();
    this.framebuffer = null;
  }
}

exports.BaseRenderTexture = BaseRenderTexture;
//# sourceMappingURL=BaseRenderTexture.js.map
