'use strict';

var constants = require('@pixi/constants');
var settings = require('@pixi/settings');
var utils = require('@pixi/utils');
var BatchRenderer = require('./batch/BatchRenderer.js');
var Filter = require('./filters/Filter.js');
var Program = require('./shader/Program.js');
require('./systems.js');
var BaseTexture = require('./textures/BaseTexture.js');
var ContextSystem = require('./context/ContextSystem.js');
var BackgroundSystem = require('./background/BackgroundSystem.js');
var ViewSystem = require('./view/ViewSystem.js');
var StartupSystem = require('./startup/StartupSystem.js');
var TextureGCSystem = require('./textures/TextureGCSystem.js');

settings.settings.PREFER_ENV = constants.ENV.WEBGL2;
settings.settings.STRICT_TEXTURE_CACHE = false;
settings.settings.RENDER_OPTIONS = {
  ...ContextSystem.ContextSystem.defaultOptions,
  ...BackgroundSystem.BackgroundSystem.defaultOptions,
  ...ViewSystem.ViewSystem.defaultOptions,
  ...StartupSystem.StartupSystem.defaultOptions
};
Object.defineProperties(settings.settings, {
  WRAP_MODE: {
    get() {
      return BaseTexture.BaseTexture.defaultOptions.wrapMode;
    },
    set(value) {
      utils.deprecation("7.1.0", "settings.WRAP_MODE is deprecated, use BaseTexture.defaultOptions.wrapMode");
      BaseTexture.BaseTexture.defaultOptions.wrapMode = value;
    }
  },
  SCALE_MODE: {
    get() {
      return BaseTexture.BaseTexture.defaultOptions.scaleMode;
    },
    set(value) {
      utils.deprecation("7.1.0", "settings.SCALE_MODE is deprecated, use BaseTexture.defaultOptions.scaleMode");
      BaseTexture.BaseTexture.defaultOptions.scaleMode = value;
    }
  },
  MIPMAP_TEXTURES: {
    get() {
      return BaseTexture.BaseTexture.defaultOptions.mipmap;
    },
    set(value) {
      utils.deprecation("7.1.0", "settings.MIPMAP_TEXTURES is deprecated, use BaseTexture.defaultOptions.mipmap");
      BaseTexture.BaseTexture.defaultOptions.mipmap = value;
    }
  },
  ANISOTROPIC_LEVEL: {
    get() {
      return BaseTexture.BaseTexture.defaultOptions.anisotropicLevel;
    },
    set(value) {
      utils.deprecation("7.1.0", "settings.ANISOTROPIC_LEVEL is deprecated, use BaseTexture.defaultOptions.anisotropicLevel");
      BaseTexture.BaseTexture.defaultOptions.anisotropicLevel = value;
    }
  },
  FILTER_RESOLUTION: {
    get() {
      utils.deprecation("7.1.0", "settings.FILTER_RESOLUTION is deprecated, use Filter.defaultResolution");
      return Filter.Filter.defaultResolution;
    },
    set(value) {
      Filter.Filter.defaultResolution = value;
    }
  },
  FILTER_MULTISAMPLE: {
    get() {
      utils.deprecation("7.1.0", "settings.FILTER_MULTISAMPLE is deprecated, use Filter.defaultMultisample");
      return Filter.Filter.defaultMultisample;
    },
    set(value) {
      Filter.Filter.defaultMultisample = value;
    }
  },
  SPRITE_MAX_TEXTURES: {
    get() {
      return BatchRenderer.BatchRenderer.defaultMaxTextures;
    },
    set(value) {
      utils.deprecation("7.1.0", "settings.SPRITE_MAX_TEXTURES is deprecated, use BatchRenderer.defaultMaxTextures");
      BatchRenderer.BatchRenderer.defaultMaxTextures = value;
    }
  },
  SPRITE_BATCH_SIZE: {
    get() {
      return BatchRenderer.BatchRenderer.defaultBatchSize;
    },
    set(value) {
      utils.deprecation("7.1.0", "settings.SPRITE_BATCH_SIZE is deprecated, use BatchRenderer.defaultBatchSize");
      BatchRenderer.BatchRenderer.defaultBatchSize = value;
    }
  },
  CAN_UPLOAD_SAME_BUFFER: {
    get() {
      return BatchRenderer.BatchRenderer.canUploadSameBuffer;
    },
    set(value) {
      utils.deprecation("7.1.0", "settings.CAN_UPLOAD_SAME_BUFFER is deprecated, use BatchRenderer.canUploadSameBuffer");
      BatchRenderer.BatchRenderer.canUploadSameBuffer = value;
    }
  },
  GC_MODE: {
    get() {
      return TextureGCSystem.TextureGCSystem.defaultMode;
    },
    set(value) {
      utils.deprecation("7.1.0", "settings.GC_MODE is deprecated, use TextureGCSystem.defaultMode");
      TextureGCSystem.TextureGCSystem.defaultMode = value;
    }
  },
  GC_MAX_IDLE: {
    get() {
      return TextureGCSystem.TextureGCSystem.defaultMaxIdle;
    },
    set(value) {
      utils.deprecation("7.1.0", "settings.GC_MAX_IDLE is deprecated, use TextureGCSystem.defaultMaxIdle");
      TextureGCSystem.TextureGCSystem.defaultMaxIdle = value;
    }
  },
  GC_MAX_CHECK_COUNT: {
    get() {
      return TextureGCSystem.TextureGCSystem.defaultCheckCountMax;
    },
    set(value) {
      utils.deprecation("7.1.0", "settings.GC_MAX_CHECK_COUNT is deprecated, use TextureGCSystem.defaultCheckCountMax");
      TextureGCSystem.TextureGCSystem.defaultCheckCountMax = value;
    }
  },
  PRECISION_VERTEX: {
    get() {
      return Program.Program.defaultVertexPrecision;
    },
    set(value) {
      utils.deprecation("7.1.0", "settings.PRECISION_VERTEX is deprecated, use Program.defaultVertexPrecision");
      Program.Program.defaultVertexPrecision = value;
    }
  },
  PRECISION_FRAGMENT: {
    get() {
      return Program.Program.defaultFragmentPrecision;
    },
    set(value) {
      utils.deprecation("7.1.0", "settings.PRECISION_FRAGMENT is deprecated, use Program.defaultFragmentPrecision");
      Program.Program.defaultFragmentPrecision = value;
    }
  }
});
//# sourceMappingURL=settings.js.map
