'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var runner = require('@pixi/runner');
var Program = require('./Program.js');
var UniformGroup = require('./UniformGroup.js');

class Shader {
  constructor(program, uniforms) {
    this.uniformBindCount = 0;
    this.program = program;
    if (uniforms) {
      if (uniforms instanceof UniformGroup.UniformGroup) {
        this.uniformGroup = uniforms;
      } else {
        this.uniformGroup = new UniformGroup.UniformGroup(uniforms);
      }
    } else {
      this.uniformGroup = new UniformGroup.UniformGroup({});
    }
    this.disposeRunner = new runner.Runner("disposeShader");
  }
  checkUniformExists(name, group) {
    if (group.uniforms[name]) {
      return true;
    }
    for (const i in group.uniforms) {
      const uniform = group.uniforms[i];
      if (uniform.group) {
        if (this.checkUniformExists(name, uniform)) {
          return true;
        }
      }
    }
    return false;
  }
  destroy() {
    this.uniformGroup = null;
    this.disposeRunner.emit(this);
    this.disposeRunner.destroy();
  }
  get uniforms() {
    return this.uniformGroup.uniforms;
  }
  static from(vertexSrc, fragmentSrc, uniforms) {
    const program = Program.Program.from(vertexSrc, fragmentSrc);
    return new Shader(program, uniforms);
  }
}

exports.Shader = Shader;
//# sourceMappingURL=Shader.js.map
