import { ExtensionType, extensions } from '@pixi/extensions';

class StartupSystem {
  constructor(renderer) {
    this.renderer = renderer;
  }
  run(options) {
    const { renderer } = this;
    renderer.runners.init.emit(renderer.options);
    if (options.hello) {
      console.log(`PixiJS ${"7.2.4"} - ${renderer.rendererLogId} - https://pixijs.com`);
    }
    renderer.resize(renderer.screen.width, renderer.screen.height);
  }
  destroy() {
  }
}
StartupSystem.defaultOptions = {
  hello: false
};
StartupSystem.extension = {
  type: [
    ExtensionType.RendererSystem,
    ExtensionType.CanvasRendererSystem
  ],
  name: "startup"
};
extensions.add(StartupSystem);

export { StartupSystem };
//# sourceMappingURL=StartupSystem.mjs.map
