'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var ArrayResource = require('./ArrayResource.js');
var autoDetectResource = require('./autoDetectResource.js');
var BufferResource = require('./BufferResource.js');
var CanvasResource = require('./CanvasResource.js');
var CubeResource = require('./CubeResource.js');
var ImageBitmapResource = require('./ImageBitmapResource.js');
var ImageResource = require('./ImageResource.js');
var SVGResource = require('./SVGResource.js');
var VideoResource = require('./VideoResource.js');
var BaseImageResource = require('./BaseImageResource.js');
var Resource = require('./Resource.js');
var AbstractMultiResource = require('./AbstractMultiResource.js');

autoDetectResource.INSTALLED.push(ImageBitmapResource.ImageBitmapResource, ImageResource.ImageResource, CanvasResource.CanvasResource, VideoResource.VideoResource, SVGResource.SVGResource, BufferResource.BufferResource, CubeResource.CubeResource, ArrayResource.ArrayResource);

exports.ArrayResource = ArrayResource.ArrayResource;
exports.INSTALLED = autoDetectResource.INSTALLED;
exports.autoDetectResource = autoDetectResource.autoDetectResource;
exports.BufferResource = BufferResource.BufferResource;
exports.CanvasResource = CanvasResource.CanvasResource;
exports.CubeResource = CubeResource.CubeResource;
exports.ImageBitmapResource = ImageBitmapResource.ImageBitmapResource;
exports.ImageResource = ImageResource.ImageResource;
exports.SVGResource = SVGResource.SVGResource;
exports.VideoResource = VideoResource.VideoResource;
exports.BaseImageResource = BaseImageResource.BaseImageResource;
exports.Resource = Resource.Resource;
exports.AbstractMultiResource = AbstractMultiResource.AbstractMultiResource;
//# sourceMappingURL=index.js.map
