'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var core = require('@pixi/core');
var buildCircle = require('./buildCircle.js');
var buildPoly = require('./buildPoly.js');
var buildRectangle = require('./buildRectangle.js');
var buildRoundedRectangle = require('./buildRoundedRectangle.js');
var ArcUtils = require('./ArcUtils.js');
var BatchPart = require('./BatchPart.js');
var BezierUtils = require('./BezierUtils.js');
var buildLine = require('./buildLine.js');
var QuadraticUtils = require('./QuadraticUtils.js');

const FILL_COMMANDS = {
  [core.SHAPES.POLY]: buildPoly.buildPoly,
  [core.SHAPES.CIRC]: buildCircle.buildCircle,
  [core.SHAPES.ELIP]: buildCircle.buildCircle,
  [core.SHAPES.RECT]: buildRectangle.buildRectangle,
  [core.SHAPES.RREC]: buildRoundedRectangle.buildRoundedRectangle
};
const BATCH_POOL = [];
const DRAW_CALL_POOL = [];

exports.buildCircle = buildCircle.buildCircle;
exports.buildPoly = buildPoly.buildPoly;
exports.buildRectangle = buildRectangle.buildRectangle;
exports.buildRoundedRectangle = buildRoundedRectangle.buildRoundedRectangle;
exports.ArcUtils = ArcUtils.ArcUtils;
exports.BatchPart = BatchPart.BatchPart;
exports.BezierUtils = BezierUtils.BezierUtils;
exports.buildLine = buildLine.buildLine;
exports.QuadraticUtils = QuadraticUtils.QuadraticUtils;
exports.BATCH_POOL = BATCH_POOL;
exports.DRAW_CALL_POOL = DRAW_CALL_POOL;
exports.FILL_COMMANDS = FILL_COMMANDS;
//# sourceMappingURL=index.js.map
